/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceManager<T extends CanonicalResource> {
    private boolean enforceUniqueId;
    private List<T> list = new ArrayList<T>();
    private Map<String, T> map = new HashMap<String, T>();

    public CanonicalResourceManager(boolean enforceUniqueId) {
        this.enforceUniqueId = enforceUniqueId;
    }

    public void copy(CanonicalResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void see(T r) {
        if (!((Resource)r).hasId()) {
            ((Resource)r).setId(UUID.randomUUID().toString());
        }
        if (this.enforceUniqueId && this.map.containsKey(((Resource)r).getId())) {
            this.drop(((Resource)r).getId());
        }
        this.list.add(r);
        this.map.put(((Resource)r).getId(), r);
        if (((CanonicalResource)r).hasUrl()) {
            if (((CanonicalResource)r).hasVersion()) {
                this.map.put(((CanonicalResource)r).getUrl() + "|" + ((CanonicalResource)r).getVersion(), r);
            }
            this.updateList(((CanonicalResource)r).getUrl(), ((CanonicalResource)r).getVersion());
        }
    }

    private void updateList(String url, String version) {
        ArrayList<CanonicalResource> rl = new ArrayList<CanonicalResource>();
        for (Object t : this.list) {
            if (!url.equals(((CanonicalResource)t).getUrl()) || rl.contains(t)) continue;
            rl.add((CanonicalResource)t);
        }
        if (rl.size() > 0) {
            Collections.sort(rl, new MetadataResourceVersionComparator());
            this.map.put(url, (CanonicalResource)rl.get(rl.size() - 1));
            if (version != null) {
                String lv;
                CanonicalResource latest = null;
                for (CanonicalResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)version)) continue;
                    latest = t;
                }
                if (latest != null && (lv = VersionUtilities.getMajMin((String)latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, (CanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public T get(String url) {
        return (T)((CanonicalResource)this.map.get(url));
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public T get(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return (T)((CanonicalResource)this.map.get(system + "|" + version));
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return (T)((CanonicalResource)this.map.get(system + "|" + mm));
        }
        return null;
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return this.map.containsKey(system + "|" + mm);
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public void drop(String id) {
        CanonicalResource res = null;
        do {
            res = null;
            for (CanonicalResource t : this.list) {
                if (!t.getId().equals(id)) continue;
                res = t;
            }
            if (res == null) continue;
            this.list.remove(res);
            this.map.remove(id);
            this.map.remove(res.getUrl());
            if (res.hasVersion()) {
                this.map.remove(res.getUrl() + "|" + res.getVersion());
                String mm = VersionUtilities.getMajMin((String)res.getVersion());
                if (mm != null) {
                    this.map.remove(res.getUrl() + "|" + mm);
                }
            }
            this.updateList(res.getUrl(), res.getVersion());
        } while (res != null);
    }

    public void listAll(List<T> result) {
        result.addAll(this.list);
    }

    public void listAllM(List<CanonicalResource> result) {
        result.addAll(this.list);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        ArrayList<CanonicalResource> res = new ArrayList<CanonicalResource>();
        for (CanonicalResource t : this.list) {
            if (res.contains(t)) continue;
            res.add(t);
        }
        return res;
    }

    public List<T> getSortedList() {
        ArrayList<CanonicalResource> res = new ArrayList<CanonicalResource>();
        for (CanonicalResource t : this.list) {
            if (res.contains(t)) continue;
            res.add(t);
        }
        Collections.sort(res, new CanonicalListSorter());
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public class MetadataResourceVersionComparator<T extends CanonicalResource>
    implements Comparator<T> {
        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((CanonicalResource)arg1).getVersion();
            String v2 = ((CanonicalResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(CanonicalResourceManager.this.list.indexOf(arg1), CanonicalResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }

    public class CanonicalListSorter
    implements Comparator<CanonicalResource> {
        @Override
        public int compare(CanonicalResource arg0, CanonicalResource arg1) {
            String u0 = arg0.getUrl();
            String u1 = arg1.getUrl();
            return u0.compareTo(u1);
        }
    }
}

