/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructuralMatch;
import org.hl7.fhir.r5.comparison.ValueSetComparer;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.DefinitionNavigator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ProfileComparer
extends CanonicalResourceComparer {
    private ProfileUtilities utilsLeft;
    private ProfileUtilities utilsRight;

    public ProfileComparer(ComparisonSession session, ProfileUtilities utilsLeft, ProfileUtilities utilsRight) {
        super(session);
        this.utilsLeft = utilsLeft;
        this.utilsRight = utilsRight;
    }

    @Override
    protected String fhirType() {
        return "StructureDefinition";
    }

    public ProfileComparison compare(StructureDefinition left, StructureDefinition right) throws DefinitionException, FHIRFormatError, IOException {
        this.check(left, "left");
        this.check(right, "right");
        ProfileComparison res = new ProfileComparison(left, right);
        this.session.identify(res);
        StructureDefinition sd = new StructureDefinition();
        res.setUnion(sd);
        this.session.identify(sd);
        sd.setName("Union" + left.getName() + "And" + right.getName());
        sd.setTitle("Union of " + left.getTitle() + " And " + right.getTitle());
        sd.setStatus(left.getStatus());
        sd.setDate(new Date());
        StructureDefinition sd1 = new StructureDefinition();
        res.setIntersection(sd1);
        this.session.identify(sd1);
        sd1.setName("Intersection" + left.getName() + "And" + right.getName());
        sd1.setTitle("Intersection of " + left.getTitle() + " And " + right.getTitle());
        sd1.setStatus(left.getStatus());
        sd1.setDate(new Date());
        this.compareMetadata(left, right, res.getMetadata(), res);
        this.comparePrimitives("fhirVersion", left.getFhirVersionElement(), right.getFhirVersionElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res);
        this.comparePrimitives("kind", left.getKindElement(), right.getKindElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res);
        this.comparePrimitives("abstract", left.getAbstractElement(), right.getAbstractElement(), res.getMetadata(), ValidationMessage.IssueSeverity.WARNING, res);
        this.comparePrimitives("type", left.getTypeElement(), right.getTypeElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        this.comparePrimitives("baseDefinition", left.getBaseDefinitionElement(), right.getBaseDefinitionElement(), res.getMetadata(), ValidationMessage.IssueSeverity.ERROR, res);
        if (left.getType().equals(right.getType())) {
            DefinitionNavigator ln = new DefinitionNavigator(this.session.getContextLeft(), left);
            DefinitionNavigator rn = new DefinitionNavigator(this.session.getContextRight(), right);
            StructuralMatch<ElementDefinition> sm = new StructuralMatch<ElementDefinition>(ln.current(), rn.current());
            this.compareElements(res, sm, ln.path(), null, ln, rn);
            res.combined = sm;
        }
        return res;
    }

    private void check(StructureDefinition sd, String name) {
        if (sd == null) {
            throw new DefinitionException("No StructureDefinition provided (" + name + ": " + sd.getName() + ")");
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            throw new DefinitionException("StructureDefinition is not for an profile - can't be compared (" + name + ": " + sd.getName() + ")");
        }
        if (sd.getSnapshot().getElement().isEmpty()) {
            throw new DefinitionException("StructureDefinition snapshot is empty (" + name + ": " + sd.getName() + ")");
        }
    }

    private void compareElements(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, String sliceName, DefinitionNavigator left, DefinitionNavigator right) throws DefinitionException, FHIRFormatError, IOException {
        assert (path != null);
        assert (left != null);
        assert (right != null);
        assert (left.path().equals(right.path()));
        if (this.session.isDebug()) {
            System.out.println("Compare elements at " + path);
        }
        ElementDefinition subset = new ElementDefinition();
        subset.setPath(left.path());
        if (sliceName != null) {
            subset.setSliceName(sliceName);
        }
        subset.getRepresentation().addAll(left.current().getRepresentation());
        subset.setDefaultValue(left.current().getDefaultValue());
        subset.setMeaningWhenMissing(left.current().getMeaningWhenMissing());
        subset.setIsModifier(left.current().getIsModifier());
        subset.setIsSummary(left.current().getIsSummary());
        subset.setLabel(this.mergeText(comp, res, path, "label", left.current().getLabel(), right.current().getLabel(), false));
        subset.setShort(this.mergeText(comp, res, path, "short", left.current().getShort(), right.current().getShort(), false));
        subset.setDefinition(this.mergeText(comp, res, path, "definition", left.current().getDefinition(), right.current().getDefinition(), false));
        subset.setComment(this.mergeText(comp, res, path, "comments", left.current().getComment(), right.current().getComment(), false));
        subset.setRequirements(this.mergeText(comp, res, path, "requirements", left.current().getRequirements(), right.current().getRequirements(), false));
        subset.getCode().addAll(this.mergeCodings(left.current().getCode(), right.current().getCode()));
        subset.getAlias().addAll(this.mergeStrings(left.current().getAlias(), right.current().getAlias()));
        subset.getMapping().addAll(this.mergeMappings(left.current().getMapping(), right.current().getMapping()));
        subset.setExample(left.current().hasExample() ? left.current().getExample() : right.current().getExample());
        if (left.current().getMustSupport() != right.current().getMustSupport()) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, "Elements differ in definition for mustSupport:\r\n  \"" + left.current().getMustSupport() + "\"\r\n  \"" + right.current().getMustSupport() + "\"", path, comp.getMessages(), res.getMessages());
        }
        subset.setMustSupport(left.current().getMustSupport() || right.current().getMustSupport());
        ElementDefinition superset = subset.copy();
        superset.setMin(this.unionMin(left.current().getMin(), right.current().getMin()));
        superset.setMax(this.unionMax(left.current().getMax(), right.current().getMax()));
        subset.setMin(this.intersectMin(left.current().getMin(), right.current().getMin()));
        subset.setMax(this.intersectMax(left.current().getMax(), right.current().getMax()));
        this.rule(comp, res, subset.getMax().equals("*") || Integer.parseInt(subset.getMax()) >= subset.getMin(), path, "Cardinality Mismatch: " + this.card(left) + "/" + this.card(right));
        superset.getType().addAll(this.unionTypes(comp, res, path, left.current().getType(), right.current().getType()));
        subset.getType().addAll(this.intersectTypes(comp, res, subset, path, left.current().getType(), right.current().getType()));
        this.rule(comp, res, !subset.getType().isEmpty() || !left.current().hasType() && !right.current().hasType(), path, "Type Mismatch:\r\n  " + this.typeCode(left) + "\r\n  " + this.typeCode(right));
        superset.setMaxLengthElement(this.unionMaxLength(left.current().getMaxLength(), right.current().getMaxLength()));
        subset.setMaxLengthElement(this.intersectMaxLength(left.current().getMaxLength(), right.current().getMaxLength()));
        if (left.current().hasBinding() || right.current().hasBinding()) {
            this.compareBindings(comp, res, subset, superset, path, left.current(), right.current());
        }
        superset.getConstraint().addAll(this.intersectConstraints(path, left.current().getConstraint(), right.current().getConstraint()));
        subset.getConstraint().addAll(this.unionConstraints(comp, res, path, left.current().getConstraint(), right.current().getConstraint()));
        ((StructureDefinition)comp.getIntersection()).getSnapshot().getElement().add(subset);
        ((StructureDefinition)comp.getUnion()).getSnapshot().getElement().add(superset);
        this.compareChildren(comp, res, path, left, right);
    }

    private void compareChildren(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, DefinitionNavigator left, DefinitionNavigator right) throws DefinitionException, IOException, FHIRFormatError {
        List<DefinitionNavigator> lc = left.children();
        List<DefinitionNavigator> rc = right.children();
        if (lc.isEmpty() && !rc.isEmpty() && right.current().getType().size() == 1 && left.hasTypeChildren(right.current().getType().get(0))) {
            lc = left.childrenFromType(right.current().getType().get(0));
        }
        if (rc.isEmpty() && !lc.isEmpty() && left.current().getType().size() == 1 && right.hasTypeChildren(left.current().getType().get(0))) {
            rc = right.childrenFromType(left.current().getType().get(0));
        }
        ArrayList<DefinitionNavigator> matchR = new ArrayList<DefinitionNavigator>();
        for (DefinitionNavigator l : lc) {
            DefinitionNavigator r = this.findInList(rc, l);
            if (r == null) {
                ((StructureDefinition)comp.getUnion()).getSnapshot().getElement().add(l.current().copy());
                res.getChildren().add(new StructuralMatch<ElementDefinition>(l.current(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed this element", path)));
                continue;
            }
            matchR.add(r);
            StructuralMatch<ElementDefinition> sm = new StructuralMatch<ElementDefinition>(l.current(), r.current());
            res.getChildren().add(sm);
            this.compareElements(comp, sm, l.path(), null, l, r);
        }
        for (DefinitionNavigator r : rc) {
            if (matchR.contains(r)) continue;
            ((StructureDefinition)comp.getUnion()).getSnapshot().getElement().add(r.current().copy());
            res.getChildren().add(new StructuralMatch<ElementDefinition>(this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added this element", path), r.current()));
        }
    }

    private DefinitionNavigator findInList(List<DefinitionNavigator> rc, DefinitionNavigator l) {
        for (DefinitionNavigator t : rc) {
            if (!this.tail(t.current().getPath()).equals(this.tail(l.current().getPath()))) continue;
            return t;
        }
        return null;
    }

    private void ruleEqual(ProfileComparison comp, StructuralMatch<ElementDefinition> res, DataType vLeft, DataType vRight, String name, String path) throws IOException {
        if (vLeft != null || vRight != null) {
            if (vLeft == null) {
                this.vm(ValidationMessage.IssueSeverity.ERROR, "Added " + name, path, comp.getMessages(), res.getMessages());
            } else if (vRight == null) {
                this.vm(ValidationMessage.IssueSeverity.ERROR, "Removed " + name, path, comp.getMessages(), res.getMessages());
            } else if (!Base.compareDeep(vLeft, vRight, false)) {
                this.vm(ValidationMessage.IssueSeverity.ERROR, name + " must be the same (" + this.toString(vLeft, true) + "/" + this.toString(vRight, false) + ")", path, comp.getMessages(), res.getMessages());
            }
        }
    }

    private String toString(DataType val, boolean left) throws IOException {
        if (val instanceof PrimitiveType) {
            return "\"" + ((PrimitiveType)val).getValueAsString() + "\"";
        }
        IParser jp = left ? this.session.getContextLeft().newJsonParser() : this.session.getContextRight().newJsonParser();
        return jp.composeString(val, "value");
    }

    private String stripLinks(String s) {
        while (s.contains("](")) {
            int i = s.indexOf("](");
            int j = s.substring(i).indexOf(")");
            if (j == -1) {
                return s;
            }
            s = s.substring(0, i + 1) + s.substring(i + j + 1);
        }
        return s;
    }

    private boolean rule(ProfileComparison comp, StructuralMatch<ElementDefinition> res, boolean test, String path, String message) {
        if (!test) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, message, path, comp.getMessages(), res.getMessages());
        }
        return test;
    }

    private String mergeText(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, String name, String left, String right, boolean isError) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if ((left = this.stripLinks(left)).equalsIgnoreCase(right = this.stripLinks(right))) {
            return left;
        }
        if (path != null) {
            this.vm(isError ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING, "Elements differ in " + name + ":\r\n  \"" + left + "\"\r\n  \"" + right + "\"", path, comp.getMessages(), res.getMessages());
        }
        return "left: " + left + "; right: " + right;
    }

    private List<Coding> mergeCodings(List<Coding> left, List<Coding> right) {
        ArrayList<Coding> result = new ArrayList<Coding>();
        result.addAll(left);
        for (Coding c : right) {
            boolean found = false;
            for (Coding ct : left) {
                if (!Utilities.equals((String)c.getSystem(), (String)ct.getSystem()) || !Utilities.equals((String)c.getCode(), (String)ct.getCode())) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private List<StringType> mergeStrings(List<StringType> left, List<StringType> right) {
        ArrayList<StringType> result = new ArrayList<StringType>();
        result.addAll(left);
        for (StringType c : right) {
            boolean found = false;
            for (StringType ct : left) {
                if (!Utilities.equals((String)((String)c.getValue()), (String)((String)ct.getValue()))) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private List<ElementDefinition.ElementDefinitionMappingComponent> mergeMappings(List<ElementDefinition.ElementDefinitionMappingComponent> left, List<ElementDefinition.ElementDefinitionMappingComponent> right) {
        ArrayList<ElementDefinition.ElementDefinitionMappingComponent> result = new ArrayList<ElementDefinition.ElementDefinitionMappingComponent>();
        result.addAll(left);
        for (ElementDefinition.ElementDefinitionMappingComponent c : right) {
            boolean found = false;
            for (ElementDefinition.ElementDefinitionMappingComponent ct : left) {
                if (!Utilities.equals((String)c.getIdentity(), (String)ct.getIdentity()) || !Utilities.equals((String)c.getLanguage(), (String)ct.getLanguage()) || !Utilities.equals((String)c.getMap(), (String)ct.getMap())) continue;
                found = true;
            }
            if (found) continue;
            result.add(c);
        }
        return result;
    }

    private int intersectMin(int left, int right) {
        if (left > right) {
            return left;
        }
        return right;
    }

    private int unionMin(int left, int right) {
        if (left > right) {
            return right;
        }
        return left;
    }

    private String intersectMax(String left, String right) {
        int r;
        int l = "*".equals(left) ? Integer.MAX_VALUE : Integer.parseInt(left);
        int n = r = "*".equals(right) ? Integer.MAX_VALUE : Integer.parseInt(right);
        if (l < r) {
            return left;
        }
        return right;
    }

    private String unionMax(String left, String right) {
        int r;
        int l = "*".equals(left) ? Integer.MAX_VALUE : Integer.parseInt(left);
        int n = r = "*".equals(right) ? Integer.MAX_VALUE : Integer.parseInt(right);
        if (l < r) {
            return right;
        }
        return left;
    }

    private IntegerType intersectMaxLength(int left, int right) {
        if (left == 0) {
            left = Integer.MAX_VALUE;
        }
        if (right == 0) {
            right = Integer.MAX_VALUE;
        }
        if (left < right) {
            return left == Integer.MAX_VALUE ? null : new IntegerType(left);
        }
        return right == Integer.MAX_VALUE ? null : new IntegerType(right);
    }

    private IntegerType unionMaxLength(int left, int right) {
        if (left == 0) {
            left = Integer.MAX_VALUE;
        }
        if (right == 0) {
            right = Integer.MAX_VALUE;
        }
        if (left < right) {
            return right == Integer.MAX_VALUE ? null : new IntegerType(right);
        }
        return left == Integer.MAX_VALUE ? null : new IntegerType(left);
    }

    private String card(DefinitionNavigator defn) {
        return Integer.toString(defn.current().getMin()) + ".." + defn.current().getMax();
    }

    private Collection<? extends ElementDefinition.TypeRefComponent> unionTypes(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, List<ElementDefinition.TypeRefComponent> left, List<ElementDefinition.TypeRefComponent> right) throws DefinitionException, IOException, FHIRFormatError {
        ArrayList<ElementDefinition.TypeRefComponent> result = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent l : left) {
            this.checkAddTypeUnion(comp, res, path, result, l, this.session.getContextLeft());
        }
        for (ElementDefinition.TypeRefComponent r : right) {
            this.checkAddTypeUnion(comp, res, path, result, r, this.session.getContextRight());
        }
        return result;
    }

    private void checkAddTypeUnion(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, List<ElementDefinition.TypeRefComponent> results, ElementDefinition.TypeRefComponent nw, IWorkerContext ctxt) throws DefinitionException, IOException, FHIRFormatError {
        boolean pfound = false;
        boolean tfound = false;
        if ((nw = nw.copy()).hasAggregation()) {
            throw new DefinitionException("Aggregation not supported: " + path);
        }
        for (ElementDefinition.TypeRefComponent ex : results) {
            ProfileComparison compP;
            StructureDefinition sdnw;
            StructureDefinition sdex;
            if (!Utilities.equals((String)ex.getWorkingCode(), (String)nw.getWorkingCode())) continue;
            if (!ex.hasProfile() && !nw.hasProfile()) {
                pfound = true;
            } else if (!ex.hasProfile()) {
                pfound = true;
            } else if (!nw.hasProfile()) {
                pfound = true;
                ex.setProfile(null);
            } else {
                sdex = ((IWorkerContext)ex.getUserData("ctxt")).fetchResource(StructureDefinition.class, (String)ex.getProfile().get(0).getValue());
                sdnw = ctxt.fetchResource(StructureDefinition.class, (String)nw.getProfile().get(0).getValue());
                if (sdex != null && sdnw != null) {
                    if (sdex.getUrl().equals(sdnw.getUrl())) {
                        pfound = true;
                    } else if (this.derivesFrom(sdex, sdnw, (IWorkerContext)ex.getUserData("ctxt"))) {
                        ex.setProfile(nw.getProfile());
                        pfound = true;
                    } else if (this.derivesFrom(sdnw, sdex, ctxt)) {
                        pfound = true;
                    } else if (sdnw.getSnapshot().getElement().get(0).getPath().equals(sdex.getSnapshot().getElement().get(0).getPath()) && (compP = (ProfileComparison)this.session.compare(sdex, sdnw)) != null && compP.getUnion() != null) {
                        pfound = true;
                        ex.addProfile("#" + compP.getId());
                    }
                }
            }
            if (!ex.hasTargetProfile() && !nw.hasTargetProfile()) {
                tfound = true;
                continue;
            }
            if (!ex.hasTargetProfile()) {
                tfound = true;
                continue;
            }
            if (!nw.hasTargetProfile()) {
                tfound = true;
                ex.setTargetProfile(null);
                continue;
            }
            sdex = ((IWorkerContext)ex.getUserData("ctxt")).fetchResource(StructureDefinition.class, (String)ex.getTargetProfile().get(0).getValue());
            sdnw = ctxt.fetchResource(StructureDefinition.class, (String)nw.getTargetProfile().get(0).getValue());
            if (sdex == null || sdnw == null) continue;
            if (this.matches(sdex, sdnw)) {
                tfound = true;
                continue;
            }
            if (this.derivesFrom(sdex, sdnw, (IWorkerContext)ex.getUserData("ctxt"))) {
                ex.setTargetProfile(nw.getTargetProfile());
                tfound = true;
                continue;
            }
            if (this.derivesFrom(sdnw, sdex, ctxt)) {
                tfound = true;
                continue;
            }
            if (!sdnw.getSnapshot().getElement().get(0).getPath().equals(sdex.getSnapshot().getElement().get(0).getPath()) || (compP = (ProfileComparison)this.session.compare(sdex, sdnw)).getUnion() == null) continue;
            tfound = true;
            ex.addTargetProfile("#" + compP.getId());
        }
        if (!tfound || !pfound) {
            nw.setUserData("ctxt", ctxt);
            results.add(nw);
        }
    }

    private boolean matches(StructureDefinition s1, StructureDefinition s2) {
        if (!s1.getUrl().equals(s2.getUrl())) {
            return false;
        }
        if (s1.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && s2.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            return true;
        }
        if (s1.hasVersion()) {
            return s1.getVersion().equals(s2.getVersion());
        }
        return !s2.hasVersion();
    }

    private boolean derivesFrom(StructureDefinition left, StructureDefinition right, IWorkerContext ctxt) {
        StructureDefinition sd = left;
        while (sd != null) {
            if (right.getUrl().equals(sd.getBaseDefinition())) {
                return true;
            }
            sd = sd.hasBaseDefinition() ? ctxt.fetchResource(StructureDefinition.class, sd.getBaseDefinition()) : null;
        }
        return false;
    }

    private Collection<? extends ElementDefinition.TypeRefComponent> intersectTypes(ProfileComparison comp, StructuralMatch<ElementDefinition> res, ElementDefinition ed, String path, List<ElementDefinition.TypeRefComponent> left, List<ElementDefinition.TypeRefComponent> right) throws DefinitionException, IOException, FHIRFormatError {
        ArrayList<ElementDefinition.TypeRefComponent> result = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent l : left) {
            if (l.hasAggregation()) {
                throw new DefinitionException("Aggregation not supported: " + path);
            }
            boolean pfound = false;
            boolean tfound = false;
            ElementDefinition.TypeRefComponent c = l.copy();
            for (ElementDefinition.TypeRefComponent r : right) {
                ProfileComparison compP;
                StructureDefinition sdr;
                StructureDefinition sdl;
                if (r.hasAggregation()) {
                    throw new DefinitionException("Aggregation not supported: " + path);
                }
                if (!l.hasProfile() && !r.hasProfile()) {
                    pfound = true;
                } else if (!r.hasProfile()) {
                    pfound = true;
                } else if (!l.hasProfile()) {
                    pfound = true;
                    c.setProfile(r.getProfile());
                } else {
                    sdl = this.resolveProfile(comp, res, path, (String)l.getProfile().get(0).getValue(), ((StructureDefinition)comp.getLeft()).getName(), this.session.getContextLeft());
                    sdr = this.resolveProfile(comp, res, path, (String)r.getProfile().get(0).getValue(), ((StructureDefinition)comp.getRight()).getName(), this.session.getContextRight());
                    if (sdl != null && sdr != null) {
                        if (sdl == sdr) {
                            pfound = true;
                        } else if (this.derivesFrom(sdl, sdr, this.session.getContextLeft())) {
                            pfound = true;
                        } else if (this.derivesFrom(sdr, sdl, this.session.getContextRight())) {
                            c.setProfile(r.getProfile());
                            pfound = true;
                        } else if (sdl.getType().equals(sdr.getType()) && (compP = (ProfileComparison)this.session.compare(sdl, sdr)) != null && compP.getIntersection() != null) {
                            pfound = true;
                            c.addProfile("#" + compP.getId());
                        }
                    }
                }
                if (!l.hasTargetProfile() && !r.hasTargetProfile()) {
                    tfound = true;
                    continue;
                }
                if (!r.hasTargetProfile()) {
                    tfound = true;
                    continue;
                }
                if (!l.hasTargetProfile()) {
                    tfound = true;
                    c.setTargetProfile(r.getTargetProfile());
                    continue;
                }
                sdl = this.resolveProfile(comp, res, path, (String)l.getTargetProfile().get(0).getValue(), ((StructureDefinition)comp.getLeft()).getName(), this.session.getContextLeft());
                sdr = this.resolveProfile(comp, res, path, (String)r.getTargetProfile().get(0).getValue(), ((StructureDefinition)comp.getRight()).getName(), this.session.getContextRight());
                if (sdl == null || sdr == null) continue;
                if (this.matches(sdl, sdr)) {
                    tfound = true;
                    continue;
                }
                if (this.derivesFrom(sdl, sdr, this.session.getContextLeft())) {
                    tfound = true;
                    continue;
                }
                if (this.derivesFrom(sdr, sdl, this.session.getContextRight())) {
                    c.setTargetProfile(r.getTargetProfile());
                    tfound = true;
                    continue;
                }
                if (!sdl.getType().equals(sdr.getType()) || (compP = (ProfileComparison)this.session.compare(sdl, sdr)) == null || compP.getIntersection() == null) continue;
                tfound = true;
                c.addTargetProfile("#" + compP.getId());
            }
            if (!pfound || !tfound) continue;
            result.add(c);
        }
        return result;
    }

    private String typeCode(DefinitionNavigator defn) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : defn.current().getType()) {
            b.append(t.getWorkingCode() + (t.hasProfile() ? "(" + t.getProfile() + ")" : "") + (t.hasTargetProfile() ? "(" + t.getTargetProfile() + ")" : ""));
        }
        return b.toString();
    }

    private boolean compareBindings(ProfileComparison comp, StructuralMatch<ElementDefinition> res, ElementDefinition subset, ElementDefinition superset, String path, ElementDefinition lDef, ElementDefinition rDef) throws FHIRFormatError, DefinitionException, IOException {
        ElementDefinition.ElementDefinitionBindingComponent right;
        assert (lDef.hasBinding() || rDef.hasBinding());
        if (!lDef.hasBinding()) {
            subset.setBinding(rDef.getBinding());
            superset.setBinding(rDef.getBinding().copy());
            superset.getBinding().setStrength(Enumerations.BindingStrength.EXAMPLE);
            return true;
        }
        if (!rDef.hasBinding()) {
            subset.setBinding(lDef.getBinding());
            superset.setBinding(lDef.getBinding().copy());
            superset.getBinding().setStrength(Enumerations.BindingStrength.EXAMPLE);
            return true;
        }
        ElementDefinition.ElementDefinitionBindingComponent left = lDef.getBinding();
        if (Base.compareDeep(left, right = rDef.getBinding(), false)) {
            subset.setBinding(left);
            superset.setBinding(right);
        }
        if (this.isPreferredOrExample(left) && this.isPreferredOrExample(right)) {
            if (right.getStrength() == Enumerations.BindingStrength.PREFERRED && left.getStrength() == Enumerations.BindingStrength.EXAMPLE && !Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
                this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Example/preferred bindings differ at " + path + " using binding from " + ((StructureDefinition)comp.getRight()).getName(), path, comp.getMessages(), res.getMessages());
                subset.setBinding(right);
                superset.setBinding(this.unionBindings(comp, res, path, left, right));
            } else {
                if (!(right.getStrength() == Enumerations.BindingStrength.EXAMPLE && left.getStrength() == Enumerations.BindingStrength.EXAMPLE || Base.compareDeep(left.getValueSet(), right.getValueSet(), false))) {
                    this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Example/preferred bindings differ at " + path + " using binding from " + ((StructureDefinition)comp.getLeft()).getName(), path, comp.getMessages(), res.getMessages());
                }
                subset.setBinding(left);
                superset.setBinding(this.unionBindings(comp, res, path, left, right));
            }
            return true;
        }
        if (this.isPreferredOrExample(left)) {
            subset.setBinding(right);
            superset.setBinding(this.unionBindings(comp, res, path, left, right));
            return true;
        }
        if (this.isPreferredOrExample(right)) {
            subset.setBinding(left);
            superset.setBinding(this.unionBindings(comp, res, path, left, right));
            return true;
        }
        ElementDefinition.ElementDefinitionBindingComponent subBinding = new ElementDefinition.ElementDefinitionBindingComponent();
        subset.setBinding(subBinding);
        ElementDefinition.ElementDefinitionBindingComponent superBinding = new ElementDefinition.ElementDefinitionBindingComponent();
        superset.setBinding(superBinding);
        subBinding.setDescription(this.mergeText(comp, res, path, "description", left.getDescription(), right.getDescription(), false));
        superBinding.setDescription(this.mergeText(comp, res, path, "description", left.getDescription(), right.getDescription(), false));
        if (left.getStrength() == Enumerations.BindingStrength.REQUIRED || right.getStrength() == Enumerations.BindingStrength.REQUIRED) {
            subBinding.setStrength(Enumerations.BindingStrength.REQUIRED);
        } else {
            subBinding.setStrength(Enumerations.BindingStrength.EXTENSIBLE);
        }
        if (left.getStrength() == Enumerations.BindingStrength.EXTENSIBLE || right.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
            superBinding.setStrength(Enumerations.BindingStrength.EXTENSIBLE);
        } else {
            superBinding.setStrength(Enumerations.BindingStrength.REQUIRED);
        }
        if (Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
            subBinding.setValueSet(left.getValueSet());
            superBinding.setValueSet(left.getValueSet());
            return true;
        }
        if (!left.hasValueSet()) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, "No left Value set at " + path, path, comp.getMessages(), res.getMessages());
            return true;
        }
        if (!right.hasValueSet()) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, "No right Value set at " + path, path, comp.getMessages(), res.getMessages());
            return true;
        }
        ValueSet lvs = this.resolveVS((StructureDefinition)comp.getLeft(), left.getValueSet(), this.session.getContextLeft());
        ValueSet rvs = this.resolveVS((StructureDefinition)comp.getRight(), right.getValueSet(), this.session.getContextRight());
        if (lvs == null) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, "Unable to resolve left value set " + left.getValueSet().toString() + " at " + path, path, comp.getMessages(), res.getMessages());
            return true;
        }
        if (rvs == null) {
            this.vm(ValidationMessage.IssueSeverity.ERROR, "Unable to resolve right value set " + right.getValueSet().toString() + " at " + path, path, comp.getMessages(), res.getMessages());
            return true;
        }
        if (this.sameValueSets(lvs, rvs)) {
            subBinding.setValueSet(lvs.getUrl());
            superBinding.setValueSet(lvs.getUrl());
        } else {
            ValueSetComparer.ValueSetComparison compP = (ValueSetComparer.ValueSetComparison)this.session.compare(lvs, rvs);
            if (compP != null) {
                subBinding.setValueSet(((ValueSet)compP.getIntersection()).getUrl());
                superBinding.setValueSet(((ValueSet)compP.getUnion()).getUrl());
            }
        }
        return false;
    }

    private boolean sameValueSets(ValueSet lvs, ValueSet rvs) {
        if (!lvs.getUrl().equals(rvs.getUrl())) {
            return false;
        }
        if (this.isCore(lvs) && this.isCore(rvs)) {
            return true;
        }
        if (lvs.hasVersion()) {
            if (!lvs.getVersion().equals(rvs.getVersion())) {
                return false;
            }
            if (!rvs.hasVersion()) {
                return false;
            }
        }
        return true;
    }

    private boolean isCore(ValueSet vs) {
        return vs.getUrl().startsWith("http://hl7.org/fhir/ValueSet");
    }

    private List<ElementDefinition.ElementDefinitionConstraintComponent> intersectConstraints(String path, List<ElementDefinition.ElementDefinitionConstraintComponent> left, List<ElementDefinition.ElementDefinitionConstraintComponent> right) {
        ArrayList<ElementDefinition.ElementDefinitionConstraintComponent> result = new ArrayList<ElementDefinition.ElementDefinitionConstraintComponent>();
        for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
            boolean found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (!found) continue;
            result.add(l);
        }
        return result;
    }

    private List<ElementDefinition.ElementDefinitionConstraintComponent> unionConstraints(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, List<ElementDefinition.ElementDefinitionConstraintComponent> left, List<ElementDefinition.ElementDefinitionConstraintComponent> right) {
        boolean found;
        ArrayList<ElementDefinition.ElementDefinitionConstraintComponent> result = new ArrayList<ElementDefinition.ElementDefinitionConstraintComponent>();
        for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
            found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (!found && !Utilities.existsInList((String)l.getExpression(), (String[])new String[]{"hasValue() or (children().count() > id.count())", "extension.exists() != value.exists()"})) {
                this.vm(ValidationMessage.IssueSeverity.INFORMATION, "StructureDefinition " + ((StructureDefinition)comp.getLeft()).getName() + " has a constraint that is removed in " + ((StructureDefinition)comp.getRight()).getName() + " and it is uncertain whether they are compatible (" + l.getExpression() + ")", path, comp.getMessages(), res.getMessages());
            }
            result.add(l);
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent r : right) {
            found = false;
            for (ElementDefinition.ElementDefinitionConstraintComponent l : left) {
                if (!Utilities.equals((String)r.getId(), (String)l.getId()) && (!Utilities.equals((String)r.getXpath(), (String)l.getXpath()) || r.getSeverity() != l.getSeverity())) continue;
                found = true;
            }
            if (found || Utilities.existsInList((String)r.getExpression(), (String[])new String[]{"hasValue() or (children().count() > id.count())", "extension.exists() != value.exists()"})) continue;
            this.vm(ValidationMessage.IssueSeverity.INFORMATION, "StructureDefinition " + ((StructureDefinition)comp.getRight()).getName() + " has added constraint that is not found in " + ((StructureDefinition)comp.getLeft()).getName() + " and it is uncertain whether they are compatible (" + r.getExpression() + ")", path, comp.getMessages(), res.getMessages());
        }
        return result;
    }

    private StructureDefinition resolveProfile(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, String url, String name, IWorkerContext ctxt) {
        StructureDefinition sd = ctxt.fetchResource(StructureDefinition.class, url);
        if (sd == null) {
            ValidationMessage validationMessage = this.vmI(ValidationMessage.IssueSeverity.WARNING, "Unable to resolve profile " + url + " in profile " + name, path);
        }
        return sd;
    }

    private boolean isPreferredOrExample(ElementDefinition.ElementDefinitionBindingComponent binding) {
        return binding.getStrength() == Enumerations.BindingStrength.EXAMPLE || binding.getStrength() == Enumerations.BindingStrength.PREFERRED;
    }

    private ElementDefinition.ElementDefinitionBindingComponent unionBindings(ProfileComparison comp, StructuralMatch<ElementDefinition> res, String path, ElementDefinition.ElementDefinitionBindingComponent left, ElementDefinition.ElementDefinitionBindingComponent right) throws FHIRFormatError, DefinitionException, IOException {
        ElementDefinition.ElementDefinitionBindingComponent union = new ElementDefinition.ElementDefinitionBindingComponent();
        if (left.getStrength().compareTo(right.getStrength()) < 0) {
            union.setStrength(left.getStrength());
        } else {
            union.setStrength(right.getStrength());
        }
        union.setDescription(this.mergeText(comp, res, path, "binding.description", left.getDescription(), right.getDescription(), false));
        if (Base.compareDeep(left.getValueSet(), right.getValueSet(), false)) {
            union.setValueSet(left.getValueSet());
        } else {
            ValueSet lvs = this.resolveVS((StructureDefinition)comp.getLeft(), left.getValueSet(), this.session.getContextLeft());
            ValueSet rvs = this.resolveVS((StructureDefinition)comp.getRight(), right.getValueSet(), this.session.getContextRight());
            if (lvs != null && rvs != null) {
                ValueSetComparer.ValueSetComparison compP = (ValueSetComparer.ValueSetComparison)this.session.compare(lvs, rvs);
                if (compP != null) {
                    union.setValueSet(((ValueSet)compP.getUnion()).getUrl());
                }
            } else if (lvs != null) {
                union.setValueSet(lvs.getUrl());
            } else if (rvs != null) {
                union.setValueSet(rvs.getUrl());
            }
        }
        return union;
    }

    private ValueSet resolveVS(StructureDefinition ctxtLeft, String vsRef, IWorkerContext ctxt) {
        if (vsRef == null) {
            return null;
        }
        return ctxt.fetchResource(ValueSet.class, vsRef);
    }

    public XhtmlNode renderStructure(ProfileComparison comp, String id, String prefix, String corePath) throws FHIRException, IOException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(Utilities.path((String[])new String[]{"[tmp]", "compare"}), false, true);
        gen.setTranslator(this.session.getContextRight().translator());
        HierarchicalTableGenerator.TableModel model = gen.initComparisonTable(corePath, id);
        this.genElementComp(null, gen, model.getRows(), comp.combined, corePath, prefix, null, true);
        return gen.generate(model, prefix, 0, null);
    }

    private void genElementComp(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, StructuralMatch<ElementDefinition> combined, String corePath, String prefix, HierarchicalTableGenerator.Row slicingRow, boolean root) throws IOException {
        String leftColor;
        HierarchicalTableGenerator.Row originalRow = slicingRow;
        HierarchicalTableGenerator.Row typesRow = null;
        List<StructuralMatch<ElementDefinition>> children = combined.getChildren();
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        rows.add(row);
        String path = combined.either().getPath();
        row.setAnchor(path);
        row.setColor(this.utilsRight.getRowColor(combined.either(), false));
        if (this.eitherHasSlicing(combined)) {
            row.setLineColor(1);
        } else if (this.eitherHasSliceName(combined)) {
            row.setLineColor(2);
        } else {
            row.setLineColor(0);
        }
        boolean ext = false;
        if (this.tail(path).equals("extension")) {
            if (this.elementIsComplex(combined)) {
                row.setIcon("icon_extension_complex.png", "Complex Extension");
            } else {
                row.setIcon("icon_extension_simple.png", "Simple Extension");
            }
            ext = true;
        } else if (this.tail(path).equals("modifierExtension")) {
            if (this.elementIsComplex(combined)) {
                row.setIcon("icon_modifier_extension_complex.png", "Complex Extension");
            } else {
                row.setIcon("icon_modifier_extension_simple.png", "Simple Extension");
            }
        } else if (this.hasChoice(combined)) {
            if (this.allAreReference(combined)) {
                row.setIcon("icon_reference.png", "Reference to another Resource");
            } else {
                row.setIcon("icon_choice.gif", "Choice of Types");
                typesRow = row;
            }
        } else if (combined.either().hasContentReference()) {
            row.setIcon("icon_reuse.png", "Reference to another Element");
        } else if (this.isPrimitive(combined)) {
            row.setIcon("icon_primitive.png", "Primitive Data Type");
        } else if (this.hasTarget(combined)) {
            row.setIcon("icon_reference.png", "Reference to another Resource");
        } else if (this.isDataType(combined)) {
            row.setIcon("icon_datatype.gif", "Data Type");
        } else {
            row.setIcon("icon_resource.png", "Resource");
        }
        String ref = defPath == null ? null : defPath + combined.either().getId();
        String sName = this.tail(path);
        String sn = this.getSliceName(combined);
        if (sn != null) {
            sName = sName + ":" + sn;
        }
        ProfileUtilities.UnusedTracker used = new ProfileUtilities.UnusedTracker();
        String string = !combined.hasLeft() ? "#ffffb3" : (leftColor = combined.hasErrors() ? "#f0b3ff" : null);
        String rightColor = !combined.hasRight() ? "#ffffb3" : (combined.hasErrors() ? "#f0b3ff" : null);
        HierarchicalTableGenerator.Cell nc = combined.hasLeft() ? this.utilsRight.genElementNameCell(gen, combined.getLeft(), "??", true, corePath, prefix, root, false, false, null, typesRow, row, false, ext, used, ref, sName) : this.utilsRight.genElementNameCell(gen, combined.getRight(), "??", true, corePath, prefix, root, false, false, null, typesRow, row, false, ext, used, ref, sName);
        if (combined.hasLeft()) {
            this.frame(this.utilsRight.genElementCells(gen, combined.getLeft(), "??", true, corePath, prefix, root, false, false, null, typesRow, row, false, ext, used, ref, sName, nc), leftColor);
        } else {
            this.frame(this.spacers(row, 4, gen), leftColor);
        }
        if (combined.hasRight()) {
            this.frame(this.utilsRight.genElementCells(gen, combined.getRight(), "??", true, corePath, prefix, root, false, false, null, typesRow, row, false, ext, used, ref, sName, nc), rightColor);
        } else {
            this.frame(this.spacers(row, 4, gen), rightColor);
        }
        row.getCells().add(this.cellForMessages(gen, combined.getMessages()));
        for (StructuralMatch<ElementDefinition> child : children) {
            this.genElementComp(defPath, gen, row.getSubRows(), child, corePath, prefix, originalRow, false);
        }
    }

    private void frame(List<HierarchicalTableGenerator.Cell> cells, String color) {
        for (HierarchicalTableGenerator.Cell cell : cells) {
            if (color == null) continue;
            cell.setStyle("background-color: " + color);
        }
        cells.get(0).setStyle("border-left: 1px grey solid" + (color == null ? "" : "; background-color: " + color));
        cells.get(cells.size() - 1).setStyle("border-right: 1px grey solid" + (color == null ? "" : "; background-color: " + color));
    }

    private List<HierarchicalTableGenerator.Cell> spacers(HierarchicalTableGenerator.Row row, int count, HierarchicalTableGenerator gen) {
        ArrayList<HierarchicalTableGenerator.Cell> res = new ArrayList<HierarchicalTableGenerator.Cell>();
        for (int i = 0; i < count; ++i) {
            HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
            res.add(c);
            row.getCells().add(c);
        }
        return res;
    }

    private String getSliceName(StructuralMatch<ElementDefinition> combined) {
        return null;
    }

    private boolean isDataType(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean hasTarget(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean isPrimitive(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean allAreReference(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean hasChoice(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean elementIsComplex(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean eitherHasSliceName(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private boolean eitherHasSlicing(StructuralMatch<ElementDefinition> combined) {
        return false;
    }

    private String tail(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    public class ProfileComparison
    extends CanonicalResourceComparer.CanonicalResourceComparison<StructureDefinition> {
        private StructuralMatch<ElementDefinition> combined;

        public ProfileComparison(StructureDefinition left, StructureDefinition right) {
            super((CanonicalResourceComparer)ProfileComparer.this, (CanonicalResource)left, (CanonicalResource)right);
            this.combined = new StructuralMatch();
        }

        public StructuralMatch<ElementDefinition> getCombined() {
            return this.combined;
        }

        @Override
        protected String abbreviation() {
            return "sd";
        }

        @Override
        protected String summary() {
            return "Profile: " + ((StructureDefinition)this.left).present() + " vs " + ((StructureDefinition)this.right).present();
        }

        @Override
        protected String fhirType() {
            return "StructureDefinition";
        }

        @Override
        protected void countMessages(ResourceComparer.MessageCounts cnts) {
            super.countMessages(cnts);
            this.combined.countMessages(cnts);
        }
    }
}

