/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceManager<T extends CanonicalResource> {
    private boolean enforceUniqueId;
    private List<CachedCanonicalResource<T>> list = new ArrayList<CachedCanonicalResource<T>>();
    private Map<String, CachedCanonicalResource<T>> map = new HashMap<String, CachedCanonicalResource<T>>();

    public CanonicalResourceManager(boolean enforceUniqueId) {
        this.enforceUniqueId = enforceUniqueId;
    }

    public void copy(CanonicalResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void register(CanonicalResourceProxy r, IWorkerContext.PackageVersion packgeInfo) {
        if (!r.hasId()) {
            throw new FHIRException("An id is required for a deferred load resource");
        }
        CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
        this.see(cr);
    }

    public void see(T r, IWorkerContext.PackageVersion packgeInfo) {
        if (!((Resource)r).hasId()) {
            ((Resource)r).setId(UUID.randomUUID().toString());
        }
        CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
        this.see(cr);
    }

    public void see(CachedCanonicalResource<T> cr) {
        if (this.enforceUniqueId && this.map.containsKey(cr.getId())) {
            this.drop(cr.getId());
        }
        if (cr.getPackageInfo() != null && cr.getPackageInfo().getId().startsWith("hl7.terminology")) {
            ArrayList<CachedCanonicalResource<T>> toDrop = new ArrayList<CachedCanonicalResource<T>>();
            for (CachedCanonicalResource<T> cachedCanonicalResource : this.list) {
                if (cachedCanonicalResource.getUrl() == null || !cachedCanonicalResource.getUrl().equals(cr.getUrl()) || !this.isBasePackage(cachedCanonicalResource.getPackageInfo())) continue;
                toDrop.add(cachedCanonicalResource);
            }
            for (CachedCanonicalResource<Object> cachedCanonicalResource : toDrop) {
                this.drop(cachedCanonicalResource.getId());
            }
        }
        this.list.add(cr);
        this.map.put(cr.getId(), cr);
        if (cr.getUrl() != null) {
            if (cr.hasVersion()) {
                this.map.put(cr.getUrl() + "|" + cr.getVersion(), cr);
            }
            this.updateList(cr.getUrl(), cr.getVersion());
        }
    }

    private boolean isBasePackage(IWorkerContext.PackageVersion packageInfo) {
        return packageInfo == null ? false : VersionUtilities.isCorePackage((String)packageInfo.getId());
    }

    private void updateList(String url, String version) {
        ArrayList<CachedCanonicalResource<T>> rl = new ArrayList<CachedCanonicalResource<T>>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (!url.equals(t.getUrl()) || rl.contains(t)) continue;
            rl.add(t);
        }
        if (rl.size() > 0) {
            Collections.sort(rl, new MetadataResourceVersionComparator());
            this.map.put(url, (CachedCanonicalResource)rl.get(rl.size() - 1));
            if (version != null) {
                String lv;
                CachedCanonicalResource latest = null;
                for (CachedCanonicalResource cachedCanonicalResource : rl) {
                    if (!VersionUtilities.versionsCompatible((String)cachedCanonicalResource.getVersion(), (String)version)) continue;
                    latest = cachedCanonicalResource;
                }
                if (latest != null && (lv = VersionUtilities.getMajMin((String)latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, (CachedCanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public T get(String url) {
        return this.map.containsKey(url) ? (T)this.map.get(url).getResource() : null;
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public T get(String system, String version) {
        if (version == null) {
            return this.get(system);
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getResource();
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null && this.map.containsKey(system + "|" + mm)) {
            return this.map.get(system + "|" + mm).getResource();
        }
        return null;
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return this.map.containsKey(system + "|" + mm);
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public void drop(String id) {
        CachedCanonicalResource<T> res = null;
        do {
            res = null;
            for (CachedCanonicalResource<T> t : this.list) {
                if (!t.getId().equals(id)) continue;
                res = t;
            }
            if (res == null) continue;
            this.list.remove(res);
            this.map.remove(id);
            this.map.remove(res.getUrl());
            if (res.hasVersion()) {
                this.map.remove(res.getUrl() + "|" + res.getVersion());
                String mm = VersionUtilities.getMajMin((String)res.getVersion());
                if (mm != null) {
                    this.map.remove(res.getUrl() + "|" + mm);
                }
            }
            this.updateList(res.getUrl(), res.getVersion());
        } while (res != null);
    }

    public void listAll(List<T> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add(t.getResource());
        }
    }

    public void listAllM(List<CanonicalResource> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add((CanonicalResource)t.getResource());
        }
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        ArrayList<T> res = new ArrayList<T>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (res.contains(t.getResource())) continue;
            res.add(t.getResource());
        }
        return res;
    }

    public List<T> getSortedList() {
        List<T> res = this.getList();
        Collections.sort(res, new CanonicalListSorter());
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public class MetadataResourceVersionComparator<T1 extends CachedCanonicalResource<T>>
    implements Comparator<T1> {
        @Override
        public int compare(T1 arg1, T1 arg2) {
            String v1 = ((CachedCanonicalResource)arg1).getVersion();
            String v2 = ((CachedCanonicalResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(CanonicalResourceManager.this.list.indexOf(arg1), CanonicalResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }

    private static class CachedCanonicalResource<T1 extends CanonicalResource> {
        private T1 resource;
        private CanonicalResourceProxy proxy;
        private IWorkerContext.PackageVersion packageInfo;
        final /* synthetic */ CanonicalResourceManager this$0;

        public CachedCanonicalResource(T1 resource, IWorkerContext.PackageVersion packageInfo) {
            this.this$0 = var1_1;
            this.resource = resource;
            this.packageInfo = packageInfo;
        }

        public CachedCanonicalResource(CanonicalResourceManager canonicalResourceManager, CanonicalResourceProxy proxy, IWorkerContext.PackageVersion packageInfo) {
            this.this$0 = canonicalResourceManager;
            this.proxy = proxy;
            this.packageInfo = packageInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T1 getResource() {
            if (this.resource == null) {
                CanonicalResource res = this.proxy.getResource();
                CachedCanonicalResource cachedCanonicalResource = this;
                synchronized (cachedCanonicalResource) {
                    this.resource = res;
                }
                this.proxy = null;
            }
            return this.resource;
        }

        public IWorkerContext.PackageVersion getPackageInfo() {
            return this.packageInfo;
        }

        public String getUrl() {
            return this.resource != null ? ((CanonicalResource)this.resource).getUrl() : this.proxy.getUrl();
        }

        public String getId() {
            return this.resource != null ? ((Resource)this.resource).getId() : this.proxy.getId();
        }

        public String getVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).getVersion() : this.proxy.getVersion();
        }

        public boolean hasVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).hasVersion() : this.proxy.getVersion() != null;
        }

        public String toString() {
            return this.resource != null ? ((CanonicalResource)this.resource).fhirType() + "/" + ((Resource)this.resource).getId() + ": " + ((CanonicalResource)this.resource).getUrl() + "|" + ((CanonicalResource)this.resource).getVersion() : this.proxy.toString();
        }
    }

    public class CanonicalListSorter
    implements Comparator<CanonicalResource> {
        @Override
        public int compare(CanonicalResource arg0, CanonicalResource arg1) {
            String u0 = arg0.getUrl();
            String u1 = arg1.getUrl();
            return u0.compareTo(u1);
        }
    }

    public static abstract class CanonicalResourceProxy {
        private String type;
        private String id;
        private String url;
        private String version;
        private CanonicalResource resource;

        public CanonicalResourceProxy(String type, String id, String url, String version) {
            this.type = type;
            this.id = id;
            this.url = url;
            this.version = version;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasId() {
            return this.id != null;
        }

        public boolean hasUrl() {
            return this.url != null;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public CanonicalResource getResource() throws FHIRException {
            if (this.resource == null) {
                this.resource = this.loadResource();
                if (this.resource instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)this.resource);
                }
            }
            return this.resource;
        }

        public void setResource(CanonicalResource resource) {
            this.resource = resource;
        }

        public abstract CanonicalResource loadResource() throws FHIRException;

        public String toString() {
            return this.type + "/" + this.id + ": " + this.url + "|" + this.version;
        }
    }
}

