/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EvidenceFocus", profile="http://hl7.org/fhir/StructureDefinition/EvidenceFocus")
public class EvidenceFocus
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this EvidenceFocus, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this EvidenceFocus when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique to the EvidenceFocus Resource", formalDefinition="A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of this summary", formalDefinition="The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name", formalDefinition="A natural language name identifying the evidence focus. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="useContext", type={UsageContext.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Use context", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence focus instances.")
    protected List<UsageContext> useContext;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date created", formalDefinition="The date  (and optionally time) when the evidence focus was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence focus changes.")
    protected DateTimeType date;
    @Child(name="note", type={Annotation.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Used for general notes and annotations not coded elsewhere.")
    protected List<Annotation> note;
    @Child(name="copyright", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright", formalDefinition="A copyright statement relating to the evidence focus and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence focus.")
    protected MarkdownType copyright;
    @Child(name="citeAs", type={Citation.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Citation for this EvidenceFocus resource", formalDefinition="Citation for this EvidenceFocus resource.")
    protected Reference citeAs;
    @Child(name="characteristic", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Characteristic", formalDefinition="Characteristic.")
    protected List<EvidenceFocusCharacteristicComponent> characteristic;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation", formalDefinition="Additional documentation.")
    protected List<RelatedArtifact> relatedArtifact;
    private static final long serialVersionUID = 1053034569L;
    @SearchParamDefinition(name="context-quantity", path="(EvidenceFocus.useContext.value as Quantity) | (EvidenceFocus.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the evidence focus", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="EvidenceFocus.useContext", description="A use context type and quantity- or range-based value assigned to the evidence focus", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="EvidenceFocus.useContext", description="A use context type and value assigned to the evidence focus", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="EvidenceFocus.useContext.code", description="A type of use context assigned to the evidence focus", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(EvidenceFocus.useContext.value as CodeableConcept)", description="A use context assigned to the evidence focus", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="EvidenceFocus.date", description="The evidence focus publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="EvidenceFocus.identifier", description="External identifier for the evidence focus", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="EvidenceFocus.name", description="Computationally friendly name of the evidence focus", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="status", path="EvidenceFocus.status", description="The current status of the evidence focus", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="EvidenceFocus.url", description="The uri that identifies the evidence focus", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="EvidenceFocus.version", description="The business version of the evidence focus", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public EvidenceFocus() {
    }

    public EvidenceFocus(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public EvidenceFocus setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public EvidenceFocus setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public EvidenceFocus setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public EvidenceFocus addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public EvidenceFocus setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public EvidenceFocus setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public EvidenceFocus setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public EvidenceFocus setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public EvidenceFocus setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public EvidenceFocus setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public EvidenceFocus setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public EvidenceFocus addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public EvidenceFocus setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public EvidenceFocus setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public EvidenceFocus setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public EvidenceFocus addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public EvidenceFocus setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public EvidenceFocus setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Reference getCiteAs() {
        if (this.citeAs == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceFocus.citeAs");
            }
            if (Configuration.doAutoCreate()) {
                this.citeAs = new Reference();
            }
        }
        return this.citeAs;
    }

    public boolean hasCiteAs() {
        return this.citeAs != null && !this.citeAs.isEmpty();
    }

    public EvidenceFocus setCiteAs(Reference value) {
        this.citeAs = value;
        return this;
    }

    public List<EvidenceFocusCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceFocusCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public EvidenceFocus setCharacteristic(List<EvidenceFocusCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (EvidenceFocusCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceFocusCharacteristicComponent addCharacteristic() {
        EvidenceFocusCharacteristicComponent t = new EvidenceFocusCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceFocusCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public EvidenceFocus addCharacteristic(EvidenceFocusCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceFocusCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public EvidenceFocusCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public EvidenceFocus setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public EvidenceFocus addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    @Override
    public int getTitleMax() {
        return 0;
    }

    @Override
    public StringType getTitleElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"title\"");
    }

    @Override
    public boolean hasTitleElement() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public EvidenceFocus setTitleElement(StringType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"title\"");
    }

    @Override
    public String getTitle() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"title\"");
    }

    @Override
    public EvidenceFocus setTitle(String value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"title\"");
    }

    @Override
    public int getExperimentalMax() {
        return 0;
    }

    @Override
    public BooleanType getExperimentalElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean hasExperimentalElement() {
        return false;
    }

    @Override
    public boolean hasExperimental() {
        return false;
    }

    @Override
    public EvidenceFocus setExperimentalElement(BooleanType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean getExperimental() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"experimental\"");
    }

    @Override
    public EvidenceFocus setExperimental(boolean value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"experimental\"");
    }

    @Override
    public int getPublisherMax() {
        return 0;
    }

    @Override
    public StringType getPublisherElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"publisher\"");
    }

    @Override
    public boolean hasPublisherElement() {
        return false;
    }

    @Override
    public boolean hasPublisher() {
        return false;
    }

    @Override
    public EvidenceFocus setPublisherElement(StringType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"publisher\"");
    }

    @Override
    public String getPublisher() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"publisher\"");
    }

    @Override
    public EvidenceFocus setPublisher(String value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"publisher\"");
    }

    @Override
    public int getContactMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getContact() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public EvidenceFocus setContact(List<ContactDetail> theContact) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"contact\"");
    }

    @Override
    public boolean hasContact() {
        return false;
    }

    @Override
    public ContactDetail addContact() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"contact\"");
    }

    @Override
    public EvidenceFocus addContact(ContactDetail t) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"contact\"");
    }

    @Override
    public ContactDetail getContactFirstRep() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"contact\"");
    }

    @Override
    public int getDescriptionMax() {
        return 0;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"description\"");
    }

    @Override
    public boolean hasDescriptionElement() {
        return false;
    }

    @Override
    public boolean hasDescription() {
        return false;
    }

    @Override
    public EvidenceFocus setDescriptionElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"description\"");
    }

    @Override
    public String getDescription() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"description\"");
    }

    @Override
    public EvidenceFocus setDescription(String value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"description\"");
    }

    @Override
    public int getJurisdictionMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public EvidenceFocus setJurisdiction(List<CodeableConcept> theJurisdiction) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public boolean hasJurisdiction() {
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public EvidenceFocus addJurisdiction(CodeableConcept t) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public EvidenceFocus setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"purpose\"");
    }

    @Override
    public EvidenceFocus setPurpose(String value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"purpose\"");
    }

    @Override
    public int getApprovalDateMax() {
        return 0;
    }

    @Override
    public DateType getApprovalDateElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"approvalDate\"");
    }

    @Override
    public boolean hasApprovalDateElement() {
        return false;
    }

    @Override
    public boolean hasApprovalDate() {
        return false;
    }

    @Override
    public EvidenceFocus setApprovalDateElement(DateType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Date getApprovalDate() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"approvalDate\"");
    }

    @Override
    public EvidenceFocus setApprovalDate(Date value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"approvalDate\"");
    }

    @Override
    public int getLastReviewDateMax() {
        return 0;
    }

    @Override
    public DateType getLastReviewDateElement() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return false;
    }

    @Override
    public boolean hasLastReviewDate() {
        return false;
    }

    @Override
    public EvidenceFocus setLastReviewDateElement(DateType value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Date getLastReviewDate() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public EvidenceFocus setLastReviewDate(Date value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public EvidenceFocus setEffectivePeriod(Period value) {
        throw new Error("The resource type \"EvidenceFocus\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this EvidenceFocus when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the evidence focus. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence focus instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence focus was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence focus changes.", 0, 1, this.date));
        children.add(new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the evidence focus and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence focus.", 0, 1, this.copyright));
        children.add(new Property("citeAs", "Reference(Citation)", "Citation for this EvidenceFocus resource.", 0, 1, this.citeAs));
        children.add(new Property("characteristic", "", "Characteristic.", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Additional documentation.", 0, Integer.MAX_VALUE, this.relatedArtifact));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this EvidenceFocus when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the evidence focus. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence focus instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence focus was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence focus changes.", 0, 1, this.date);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the evidence focus and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence focus.", 0, 1, this.copyright);
            }
            case -1360156695: {
                return new Property("citeAs", "Reference(Citation)", "Citation for this EvidenceFocus resource.", 0, 1, this.citeAs);
            }
            case 366313883: {
                return new Property("characteristic", "", "Characteristic.", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Additional documentation.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.copyright;
                }
                return baseArray;
            }
            case -1360156695: {
                Base[] baseArray;
                if (this.citeAs == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.citeAs;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1360156695: {
                this.citeAs = TypeConvertor.castToReference(value);
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((EvidenceFocusCharacteristicComponent)((Object)value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("citeAs")) {
            this.citeAs = TypeConvertor.castToReference(value);
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((EvidenceFocusCharacteristicComponent)((Object)value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1360156695: {
                return this.getCiteAs();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -1360156695: {
                return new String[]{"Reference"};
            }
            case 366313883: {
                return new String[0];
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.status");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.date");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.copyright");
        }
        if (name.equals("citeAs")) {
            this.citeAs = new Reference();
            return this.citeAs;
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EvidenceFocus";
    }

    @Override
    public EvidenceFocus copy() {
        EvidenceFocus dst = new EvidenceFocus();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EvidenceFocus dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        Reference reference = dst.citeAs = this.citeAs == null ? null : this.citeAs.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<EvidenceFocusCharacteristicComponent>();
            for (EvidenceFocusCharacteristicComponent evidenceFocusCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(evidenceFocusCharacteristicComponent.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
    }

    protected EvidenceFocus typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceFocus)) {
            return false;
        }
        EvidenceFocus o = (EvidenceFocus)other_;
        return EvidenceFocus.compareDeep(this.url, o.url, true) && EvidenceFocus.compareDeep(this.identifier, o.identifier, true) && EvidenceFocus.compareDeep(this.version, o.version, true) && EvidenceFocus.compareDeep(this.name, o.name, true) && EvidenceFocus.compareDeep(this.status, o.status, true) && EvidenceFocus.compareDeep(this.useContext, o.useContext, true) && EvidenceFocus.compareDeep(this.date, o.date, true) && EvidenceFocus.compareDeep(this.note, o.note, true) && EvidenceFocus.compareDeep(this.copyright, o.copyright, true) && EvidenceFocus.compareDeep(this.citeAs, o.citeAs, true) && EvidenceFocus.compareDeep(this.characteristic, o.characteristic, true) && EvidenceFocus.compareDeep(this.relatedArtifact, o.relatedArtifact, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceFocus)) {
            return false;
        }
        EvidenceFocus o = (EvidenceFocus)other_;
        return EvidenceFocus.compareValues(this.url, o.url, true) && EvidenceFocus.compareValues(this.version, o.version, true) && EvidenceFocus.compareValues(this.name, o.name, true) && EvidenceFocus.compareValues(this.status, o.status, true) && EvidenceFocus.compareValues(this.date, o.date, true) && EvidenceFocus.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.status, this.useContext, this.date, this.note, this.copyright, this.citeAs, this.characteristic, this.relatedArtifact});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EvidenceFocus;
    }

    @Block
    public static class EvidenceFocusCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Characteristic code", formalDefinition="Characteristic code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evfocus-characteristic-code")
        protected CodeableConcept code;
        @Child(name="value", type={Reference.class, CodeableConcept.class, BooleanType.class, Quantity.class, Range.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Characteristic value", formalDefinition="Characteristic value.")
        protected DataType value;
        @Child(name="exclude", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is used to express not the characteristic", formalDefinition="Is used to express not the characteristic.")
        protected BooleanType exclude;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Timeframe for the characteristic", formalDefinition="Timeframe for the characteristic.")
        protected Period period;
        private static final long serialVersionUID = 279867823L;

        public EvidenceFocusCharacteristicComponent() {
        }

        public EvidenceFocusCharacteristicComponent(CodeableConcept code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceFocusCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public EvidenceFocusCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EvidenceFocusCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof Reference || value instanceof CodeableConcept || value instanceof BooleanType || value instanceof Quantity || value instanceof Range)) {
                throw new Error("Not the right type for EvidenceFocus.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceFocusCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public EvidenceFocusCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public EvidenceFocusCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceFocusCharacteristicComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EvidenceFocusCharacteristicComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Characteristic code.", 0, 1, this.code));
            children.add(new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value));
            children.add(new Property("exclude", "boolean", "Is used to express not the characteristic.", 0, 1, this.exclude));
            children.add(new Property("period", "Period", "Timeframe for the characteristic.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Characteristic code.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Any)", "Characteristic value.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Characteristic value.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Characteristic value.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Characteristic value.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Characteristic value.", 0, 1, this.value);
                }
                case -1321148966: {
                    return new Property("exclude", "boolean", "Is used to express not the characteristic.", 0, 1, this.exclude);
                }
                case -991726143: {
                    return new Property("period", "Period", "Timeframe for the characteristic.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.exclude;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1321148966: {
                    this.exclude = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("exclude")) {
                this.exclude = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Reference", "CodeableConcept", "boolean", "Quantity", "Range"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("exclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceFocus.characteristic.exclude");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceFocusCharacteristicComponent copy() {
            EvidenceFocusCharacteristicComponent dst = new EvidenceFocusCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceFocusCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceFocusCharacteristicComponent)) {
                return false;
            }
            EvidenceFocusCharacteristicComponent o = (EvidenceFocusCharacteristicComponent)other_;
            return EvidenceFocusCharacteristicComponent.compareDeep(this.code, o.code, true) && EvidenceFocusCharacteristicComponent.compareDeep(this.value, o.value, true) && EvidenceFocusCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && EvidenceFocusCharacteristicComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceFocusCharacteristicComponent)) {
                return false;
            }
            EvidenceFocusCharacteristicComponent o = (EvidenceFocusCharacteristicComponent)other_;
            return EvidenceFocusCharacteristicComponent.compareValues(this.exclude, o.exclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value, this.exclude, this.period});
        }

        @Override
        public String fhirType() {
            return "EvidenceFocus.characteristic";
        }
    }
}

