/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationKnowledge", profile="http://hl7.org/fhir/StructureDefinition/MedicationKnowledge")
public class MedicationKnowledge
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this medication", formalDefinition="Business identifier for this medication.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies this medication", formalDefinition="A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-status")
    protected Enumeration<MedicationKnowledgeStatusCodes> status;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.")
    protected Reference manufacturer;
    @Child(name="doseForm", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    protected CodeableConcept doseForm;
    @Child(name="amount", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of drug in package", formalDefinition="Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).")
    protected Quantity amount;
    @Child(name="synonym", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional names for a medication", formalDefinition="Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.")
    protected List<StringType> synonym;
    @Child(name="relatedMedicationKnowledge", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated or related medication information", formalDefinition="Associated or related knowledge about a medication.")
    protected List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> relatedMedicationKnowledge;
    @Child(name="associatedMedication", type={Medication.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A medication resource that is associated with this medication", formalDefinition="Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).")
    protected List<Reference> associatedMedication;
    @Child(name="productType", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Category of the medication or product", formalDefinition="Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).")
    protected List<CodeableConcept> productType;
    @Child(name="monograph", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
    protected List<MedicationKnowledgeMonographComponent> monograph;
    @Child(name="ingredient", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
    protected List<MedicationKnowledgeIngredientComponent> ingredient;
    @Child(name="device", type={Device.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A device associated with the medication (for example, a drug coated catheter or a drug impregnated dressing)", formalDefinition="A device associated with the medication (for example, a drug coated catheter or a drug impregnated dressing).")
    protected List<Reference> device;
    @Child(name="preparationInstruction", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The instructions for preparing the medication", formalDefinition="The instructions for preparing the medication.")
    protected MarkdownType preparationInstruction;
    @Child(name="intendedRoute", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The intended or approved route of administration", formalDefinition="The intended or approved route of administration.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected List<CodeableConcept> intendedRoute;
    @Child(name="cost", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The pricing of the medication", formalDefinition="The price of the medication.")
    protected List<MedicationKnowledgeCostComponent> cost;
    @Child(name="monitoringProgram", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Program under which a medication is reviewed", formalDefinition="The program under which the medication is reviewed.")
    protected List<MedicationKnowledgeMonitoringProgramComponent> monitoringProgram;
    @Child(name="administrationGuideline", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Guidelines or protocols for administration of the medication", formalDefinition="Guidelines or protocols that are applicable for the administration of the medication.")
    protected List<MedicationKnowledgeAdministrationGuidelineComponent> administrationGuideline;
    @Child(name="medicineClassification", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Categorization of the medication within a formulary or classification system", formalDefinition="Categorization of the medication within a formulary or classification system.")
    protected List<MedicationKnowledgeMedicineClassificationComponent> medicineClassification;
    @Child(name="packaging", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationKnowledgePackagingComponent packaging;
    @Child(name="drugCharacteristic", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specifies descriptive properties of the medicine", formalDefinition="Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.")
    protected List<MedicationKnowledgeDrugCharacteristicComponent> drugCharacteristic;
    @Child(name="clinicalUseIssue", type={ClinicalUseIssue.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential clinical issue with or between medication(s)", formalDefinition="Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).")
    protected List<Reference> clinicalUseIssue;
    @Child(name="regulatory", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Regulatory information about a medication", formalDefinition="Regulatory information about a medication.")
    protected List<MedicationKnowledgeRegulatoryComponent> regulatory;
    @Child(name="kineticCharacteristic", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The time course of drug absorption, distribution, metabolism and excretion of a medication from the body", formalDefinition="The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.")
    protected List<MedicationKnowledgeKineticCharacteristicComponent> kineticCharacteristic;
    private static final long serialVersionUID = -489255977L;
    @SearchParamDefinition(name="classification-type", path="MedicationKnowledge.medicineClassification.type", description="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", type="token")
    public static final String SP_CLASSIFICATION_TYPE = "classification-type";
    public static final TokenClientParam CLASSIFICATION_TYPE = new TokenClientParam("classification-type");
    @SearchParamDefinition(name="classification", path="MedicationKnowledge.medicineClassification.classification", description="Specific category assigned to the medication", type="token")
    public static final String SP_CLASSIFICATION = "classification";
    public static final TokenClientParam CLASSIFICATION = new TokenClientParam("classification");
    @SearchParamDefinition(name="code", path="MedicationKnowledge.code", description="Code that identifies this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="doseform", path="MedicationKnowledge.doseForm", description="powder | tablets | capsule +", type="token")
    public static final String SP_DOSEFORM = "doseform";
    public static final TokenClientParam DOSEFORM = new TokenClientParam("doseform");
    @SearchParamDefinition(name="identifier", path="MedicationKnowledge.identifier", description="Business identifier for this medication", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient-code", path="MedicationKnowledge.ingredient.item.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="ingredient", path="MedicationKnowledge.ingredient.item.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("MedicationKnowledge:ingredient").toLocked();
    @SearchParamDefinition(name="manufacturer", path="MedicationKnowledge.manufacturer", description="Manufacturer of the item", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("MedicationKnowledge:manufacturer").toLocked();
    @SearchParamDefinition(name="monitoring-program-name", path="MedicationKnowledge.monitoringProgram.name", description="Name of the reviewing program", type="token")
    public static final String SP_MONITORING_PROGRAM_NAME = "monitoring-program-name";
    public static final TokenClientParam MONITORING_PROGRAM_NAME = new TokenClientParam("monitoring-program-name");
    @SearchParamDefinition(name="monitoring-program-type", path="MedicationKnowledge.monitoringProgram.type", description="Type of program under which the medication is monitored", type="token")
    public static final String SP_MONITORING_PROGRAM_TYPE = "monitoring-program-type";
    public static final TokenClientParam MONITORING_PROGRAM_TYPE = new TokenClientParam("monitoring-program-type");
    @SearchParamDefinition(name="monograph-type", path="MedicationKnowledge.monograph.type", description="The category of medication document", type="token")
    public static final String SP_MONOGRAPH_TYPE = "monograph-type";
    public static final TokenClientParam MONOGRAPH_TYPE = new TokenClientParam("monograph-type");
    @SearchParamDefinition(name="monograph", path="MedicationKnowledge.monograph.source", description="Associated documentation about the medication", type="reference", target={DocumentReference.class})
    public static final String SP_MONOGRAPH = "monograph";
    public static final ReferenceClientParam MONOGRAPH = new ReferenceClientParam("monograph");
    public static final Include INCLUDE_MONOGRAPH = new Include("MedicationKnowledge:monograph").toLocked();
    @SearchParamDefinition(name="product-type", path="MedicationKnowledge.productType", description="Category of the medication or product", type="token")
    public static final String SP_PRODUCT_TYPE = "product-type";
    public static final TokenClientParam PRODUCT_TYPE = new TokenClientParam("product-type");
    @SearchParamDefinition(name="source-cost", path="MedicationKnowledge.cost.source", description="The source or owner for the price information", type="token")
    public static final String SP_SOURCE_COST = "source-cost";
    public static final TokenClientParam SOURCE_COST = new TokenClientParam("source-cost");
    @SearchParamDefinition(name="status", path="MedicationKnowledge.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationKnowledge setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationKnowledge addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public MedicationKnowledge setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationKnowledgeStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationKnowledge setStatusElement(Enumeration<MedicationKnowledgeStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationKnowledgeStatusCodes getStatus() {
        return this.status == null ? null : (MedicationKnowledgeStatusCodes)((Object)this.status.getValue());
    }

    public MedicationKnowledge setStatus(MedicationKnowledgeStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public MedicationKnowledge setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public CodeableConcept getDoseForm() {
        if (this.doseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.doseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.doseForm = new CodeableConcept();
            }
        }
        return this.doseForm;
    }

    public boolean hasDoseForm() {
        return this.doseForm != null && !this.doseForm.isEmpty();
    }

    public MedicationKnowledge setDoseForm(CodeableConcept value) {
        this.doseForm = value;
        return this;
    }

    public Quantity getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Quantity();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public MedicationKnowledge setAmount(Quantity value) {
        this.amount = value;
        return this;
    }

    public List<StringType> getSynonym() {
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        return this.synonym;
    }

    public MedicationKnowledge setSynonym(List<StringType> theSynonym) {
        this.synonym = theSynonym;
        return this;
    }

    public boolean hasSynonym() {
        if (this.synonym == null) {
            return false;
        }
        for (StringType item : this.synonym) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSynonymElement() {
        StringType t = new StringType();
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return t;
    }

    public MedicationKnowledge addSynonym(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return this;
    }

    public boolean hasSynonym(String value) {
        if (this.synonym == null) {
            return false;
        }
        for (StringType v : this.synonym) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> getRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        return this.relatedMedicationKnowledge;
    }

    public MedicationKnowledge setRelatedMedicationKnowledge(List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> theRelatedMedicationKnowledge) {
        this.relatedMedicationKnowledge = theRelatedMedicationKnowledge;
        return this;
    }

    public boolean hasRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            return false;
        }
        for (MedicationKnowledgeRelatedMedicationKnowledgeComponent item : this.relatedMedicationKnowledge) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent addRelatedMedicationKnowledge() {
        MedicationKnowledgeRelatedMedicationKnowledgeComponent t = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return t;
    }

    public MedicationKnowledge addRelatedMedicationKnowledge(MedicationKnowledgeRelatedMedicationKnowledgeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return this;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent getRelatedMedicationKnowledgeFirstRep() {
        if (this.getRelatedMedicationKnowledge().isEmpty()) {
            this.addRelatedMedicationKnowledge();
        }
        return this.getRelatedMedicationKnowledge().get(0);
    }

    public List<Reference> getAssociatedMedication() {
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        return this.associatedMedication;
    }

    public MedicationKnowledge setAssociatedMedication(List<Reference> theAssociatedMedication) {
        this.associatedMedication = theAssociatedMedication;
        return this;
    }

    public boolean hasAssociatedMedication() {
        if (this.associatedMedication == null) {
            return false;
        }
        for (Reference item : this.associatedMedication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAssociatedMedication() {
        Reference t = new Reference();
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return t;
    }

    public MedicationKnowledge addAssociatedMedication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return this;
    }

    public Reference getAssociatedMedicationFirstRep() {
        if (this.getAssociatedMedication().isEmpty()) {
            this.addAssociatedMedication();
        }
        return this.getAssociatedMedication().get(0);
    }

    public List<CodeableConcept> getProductType() {
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        return this.productType;
    }

    public MedicationKnowledge setProductType(List<CodeableConcept> theProductType) {
        this.productType = theProductType;
        return this;
    }

    public boolean hasProductType() {
        if (this.productType == null) {
            return false;
        }
        for (CodeableConcept item : this.productType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductType() {
        CodeableConcept t = new CodeableConcept();
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return t;
    }

    public MedicationKnowledge addProductType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return this;
    }

    public CodeableConcept getProductTypeFirstRep() {
        if (this.getProductType().isEmpty()) {
            this.addProductType();
        }
        return this.getProductType().get(0);
    }

    public List<MedicationKnowledgeMonographComponent> getMonograph() {
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        return this.monograph;
    }

    public MedicationKnowledge setMonograph(List<MedicationKnowledgeMonographComponent> theMonograph) {
        this.monograph = theMonograph;
        return this;
    }

    public boolean hasMonograph() {
        if (this.monograph == null) {
            return false;
        }
        for (MedicationKnowledgeMonographComponent item : this.monograph) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonographComponent addMonograph() {
        MedicationKnowledgeMonographComponent t = new MedicationKnowledgeMonographComponent();
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return t;
    }

    public MedicationKnowledge addMonograph(MedicationKnowledgeMonographComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return this;
    }

    public MedicationKnowledgeMonographComponent getMonographFirstRep() {
        if (this.getMonograph().isEmpty()) {
            this.addMonograph();
        }
        return this.getMonograph().get(0);
    }

    public List<MedicationKnowledgeIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        return this.ingredient;
    }

    public MedicationKnowledge setIngredient(List<MedicationKnowledgeIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (MedicationKnowledgeIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeIngredientComponent addIngredient() {
        MedicationKnowledgeIngredientComponent t = new MedicationKnowledgeIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicationKnowledge addIngredient(MedicationKnowledgeIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public MedicationKnowledgeIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public MedicationKnowledge setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationKnowledge addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public MarkdownType getPreparationInstructionElement() {
        if (this.preparationInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.preparationInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.preparationInstruction = new MarkdownType();
            }
        }
        return this.preparationInstruction;
    }

    public boolean hasPreparationInstructionElement() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public boolean hasPreparationInstruction() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public MedicationKnowledge setPreparationInstructionElement(MarkdownType value) {
        this.preparationInstruction = value;
        return this;
    }

    public String getPreparationInstruction() {
        return this.preparationInstruction == null ? null : (String)this.preparationInstruction.getValue();
    }

    public MedicationKnowledge setPreparationInstruction(String value) {
        if (value == null) {
            this.preparationInstruction = null;
        } else {
            if (this.preparationInstruction == null) {
                this.preparationInstruction = new MarkdownType();
            }
            this.preparationInstruction.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getIntendedRoute() {
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        return this.intendedRoute;
    }

    public MedicationKnowledge setIntendedRoute(List<CodeableConcept> theIntendedRoute) {
        this.intendedRoute = theIntendedRoute;
        return this;
    }

    public boolean hasIntendedRoute() {
        if (this.intendedRoute == null) {
            return false;
        }
        for (CodeableConcept item : this.intendedRoute) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIntendedRoute() {
        CodeableConcept t = new CodeableConcept();
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return t;
    }

    public MedicationKnowledge addIntendedRoute(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return this;
    }

    public CodeableConcept getIntendedRouteFirstRep() {
        if (this.getIntendedRoute().isEmpty()) {
            this.addIntendedRoute();
        }
        return this.getIntendedRoute().get(0);
    }

    public List<MedicationKnowledgeCostComponent> getCost() {
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        return this.cost;
    }

    public MedicationKnowledge setCost(List<MedicationKnowledgeCostComponent> theCost) {
        this.cost = theCost;
        return this;
    }

    public boolean hasCost() {
        if (this.cost == null) {
            return false;
        }
        for (MedicationKnowledgeCostComponent item : this.cost) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeCostComponent addCost() {
        MedicationKnowledgeCostComponent t = new MedicationKnowledgeCostComponent();
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return t;
    }

    public MedicationKnowledge addCost(MedicationKnowledgeCostComponent t) {
        if (t == null) {
            return this;
        }
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return this;
    }

    public MedicationKnowledgeCostComponent getCostFirstRep() {
        if (this.getCost().isEmpty()) {
            this.addCost();
        }
        return this.getCost().get(0);
    }

    public List<MedicationKnowledgeMonitoringProgramComponent> getMonitoringProgram() {
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        return this.monitoringProgram;
    }

    public MedicationKnowledge setMonitoringProgram(List<MedicationKnowledgeMonitoringProgramComponent> theMonitoringProgram) {
        this.monitoringProgram = theMonitoringProgram;
        return this;
    }

    public boolean hasMonitoringProgram() {
        if (this.monitoringProgram == null) {
            return false;
        }
        for (MedicationKnowledgeMonitoringProgramComponent item : this.monitoringProgram) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonitoringProgramComponent addMonitoringProgram() {
        MedicationKnowledgeMonitoringProgramComponent t = new MedicationKnowledgeMonitoringProgramComponent();
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return t;
    }

    public MedicationKnowledge addMonitoringProgram(MedicationKnowledgeMonitoringProgramComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return this;
    }

    public MedicationKnowledgeMonitoringProgramComponent getMonitoringProgramFirstRep() {
        if (this.getMonitoringProgram().isEmpty()) {
            this.addMonitoringProgram();
        }
        return this.getMonitoringProgram().get(0);
    }

    public List<MedicationKnowledgeAdministrationGuidelineComponent> getAdministrationGuideline() {
        if (this.administrationGuideline == null) {
            this.administrationGuideline = new ArrayList<MedicationKnowledgeAdministrationGuidelineComponent>();
        }
        return this.administrationGuideline;
    }

    public MedicationKnowledge setAdministrationGuideline(List<MedicationKnowledgeAdministrationGuidelineComponent> theAdministrationGuideline) {
        this.administrationGuideline = theAdministrationGuideline;
        return this;
    }

    public boolean hasAdministrationGuideline() {
        if (this.administrationGuideline == null) {
            return false;
        }
        for (MedicationKnowledgeAdministrationGuidelineComponent item : this.administrationGuideline) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeAdministrationGuidelineComponent addAdministrationGuideline() {
        MedicationKnowledgeAdministrationGuidelineComponent t = new MedicationKnowledgeAdministrationGuidelineComponent();
        if (this.administrationGuideline == null) {
            this.administrationGuideline = new ArrayList<MedicationKnowledgeAdministrationGuidelineComponent>();
        }
        this.administrationGuideline.add(t);
        return t;
    }

    public MedicationKnowledge addAdministrationGuideline(MedicationKnowledgeAdministrationGuidelineComponent t) {
        if (t == null) {
            return this;
        }
        if (this.administrationGuideline == null) {
            this.administrationGuideline = new ArrayList<MedicationKnowledgeAdministrationGuidelineComponent>();
        }
        this.administrationGuideline.add(t);
        return this;
    }

    public MedicationKnowledgeAdministrationGuidelineComponent getAdministrationGuidelineFirstRep() {
        if (this.getAdministrationGuideline().isEmpty()) {
            this.addAdministrationGuideline();
        }
        return this.getAdministrationGuideline().get(0);
    }

    public List<MedicationKnowledgeMedicineClassificationComponent> getMedicineClassification() {
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        return this.medicineClassification;
    }

    public MedicationKnowledge setMedicineClassification(List<MedicationKnowledgeMedicineClassificationComponent> theMedicineClassification) {
        this.medicineClassification = theMedicineClassification;
        return this;
    }

    public boolean hasMedicineClassification() {
        if (this.medicineClassification == null) {
            return false;
        }
        for (MedicationKnowledgeMedicineClassificationComponent item : this.medicineClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMedicineClassificationComponent addMedicineClassification() {
        MedicationKnowledgeMedicineClassificationComponent t = new MedicationKnowledgeMedicineClassificationComponent();
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return t;
    }

    public MedicationKnowledge addMedicineClassification(MedicationKnowledgeMedicineClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return this;
    }

    public MedicationKnowledgeMedicineClassificationComponent getMedicineClassificationFirstRep() {
        if (this.getMedicineClassification().isEmpty()) {
            this.addMedicineClassification();
        }
        return this.getMedicineClassification().get(0);
    }

    public MedicationKnowledgePackagingComponent getPackaging() {
        if (this.packaging == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.packaging");
            }
            if (Configuration.doAutoCreate()) {
                this.packaging = new MedicationKnowledgePackagingComponent();
            }
        }
        return this.packaging;
    }

    public boolean hasPackaging() {
        return this.packaging != null && !this.packaging.isEmpty();
    }

    public MedicationKnowledge setPackaging(MedicationKnowledgePackagingComponent value) {
        this.packaging = value;
        return this;
    }

    public List<MedicationKnowledgeDrugCharacteristicComponent> getDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        return this.drugCharacteristic;
    }

    public MedicationKnowledge setDrugCharacteristic(List<MedicationKnowledgeDrugCharacteristicComponent> theDrugCharacteristic) {
        this.drugCharacteristic = theDrugCharacteristic;
        return this;
    }

    public boolean hasDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            return false;
        }
        for (MedicationKnowledgeDrugCharacteristicComponent item : this.drugCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeDrugCharacteristicComponent addDrugCharacteristic() {
        MedicationKnowledgeDrugCharacteristicComponent t = new MedicationKnowledgeDrugCharacteristicComponent();
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return t;
    }

    public MedicationKnowledge addDrugCharacteristic(MedicationKnowledgeDrugCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return this;
    }

    public MedicationKnowledgeDrugCharacteristicComponent getDrugCharacteristicFirstRep() {
        if (this.getDrugCharacteristic().isEmpty()) {
            this.addDrugCharacteristic();
        }
        return this.getDrugCharacteristic().get(0);
    }

    public List<Reference> getClinicalUseIssue() {
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        return this.clinicalUseIssue;
    }

    public MedicationKnowledge setClinicalUseIssue(List<Reference> theClinicalUseIssue) {
        this.clinicalUseIssue = theClinicalUseIssue;
        return this;
    }

    public boolean hasClinicalUseIssue() {
        if (this.clinicalUseIssue == null) {
            return false;
        }
        for (Reference item : this.clinicalUseIssue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addClinicalUseIssue() {
        Reference t = new Reference();
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        this.clinicalUseIssue.add(t);
        return t;
    }

    public MedicationKnowledge addClinicalUseIssue(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        this.clinicalUseIssue.add(t);
        return this;
    }

    public Reference getClinicalUseIssueFirstRep() {
        if (this.getClinicalUseIssue().isEmpty()) {
            this.addClinicalUseIssue();
        }
        return this.getClinicalUseIssue().get(0);
    }

    public List<MedicationKnowledgeRegulatoryComponent> getRegulatory() {
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        return this.regulatory;
    }

    public MedicationKnowledge setRegulatory(List<MedicationKnowledgeRegulatoryComponent> theRegulatory) {
        this.regulatory = theRegulatory;
        return this;
    }

    public boolean hasRegulatory() {
        if (this.regulatory == null) {
            return false;
        }
        for (MedicationKnowledgeRegulatoryComponent item : this.regulatory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRegulatoryComponent addRegulatory() {
        MedicationKnowledgeRegulatoryComponent t = new MedicationKnowledgeRegulatoryComponent();
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return t;
    }

    public MedicationKnowledge addRegulatory(MedicationKnowledgeRegulatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return this;
    }

    public MedicationKnowledgeRegulatoryComponent getRegulatoryFirstRep() {
        if (this.getRegulatory().isEmpty()) {
            this.addRegulatory();
        }
        return this.getRegulatory().get(0);
    }

    public List<MedicationKnowledgeKineticCharacteristicComponent> getKineticCharacteristic() {
        if (this.kineticCharacteristic == null) {
            this.kineticCharacteristic = new ArrayList<MedicationKnowledgeKineticCharacteristicComponent>();
        }
        return this.kineticCharacteristic;
    }

    public MedicationKnowledge setKineticCharacteristic(List<MedicationKnowledgeKineticCharacteristicComponent> theKineticCharacteristic) {
        this.kineticCharacteristic = theKineticCharacteristic;
        return this;
    }

    public boolean hasKineticCharacteristic() {
        if (this.kineticCharacteristic == null) {
            return false;
        }
        for (MedicationKnowledgeKineticCharacteristicComponent item : this.kineticCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeKineticCharacteristicComponent addKineticCharacteristic() {
        MedicationKnowledgeKineticCharacteristicComponent t = new MedicationKnowledgeKineticCharacteristicComponent();
        if (this.kineticCharacteristic == null) {
            this.kineticCharacteristic = new ArrayList<MedicationKnowledgeKineticCharacteristicComponent>();
        }
        this.kineticCharacteristic.add(t);
        return t;
    }

    public MedicationKnowledge addKineticCharacteristic(MedicationKnowledgeKineticCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.kineticCharacteristic == null) {
            this.kineticCharacteristic = new ArrayList<MedicationKnowledgeKineticCharacteristicComponent>();
        }
        this.kineticCharacteristic.add(t);
        return this;
    }

    public MedicationKnowledgeKineticCharacteristicComponent getKineticCharacteristicFirstRep() {
        if (this.getKineticCharacteristic().isEmpty()) {
            this.addKineticCharacteristic();
        }
        return this.getKineticCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer));
        children.add(new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm));
        children.add(new Property("amount", "Quantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount));
        children.add(new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym));
        children.add(new Property("relatedMedicationKnowledge", "", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge));
        children.add(new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, Integer.MAX_VALUE, this.associatedMedication));
        children.add(new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType));
        children.add(new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph));
        children.add(new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("device", "Reference(Device)", "A device associated with the medication (for example, a drug coated catheter or a drug impregnated dressing).", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction));
        children.add(new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute));
        children.add(new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost));
        children.add(new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram));
        children.add(new Property("administrationGuideline", "", "Guidelines or protocols that are applicable for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuideline));
        children.add(new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification));
        children.add(new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging));
        children.add(new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic));
        children.add(new Property("clinicalUseIssue", "Reference(ClinicalUseIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.clinicalUseIssue));
        children.add(new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory));
        children.add(new Property("kineticCharacteristic", "", "The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.", 0, Integer.MAX_VALUE, this.kineticCharacteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.  The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer);
            }
            case 1303858817: {
                return new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm);
            }
            case -1413853096: {
                return new Property("amount", "Quantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).", 0, 1, this.amount);
            }
            case -1742128133: {
                return new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym);
            }
            case 723067972: {
                return new Property("relatedMedicationKnowledge", "", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge);
            }
            case 1312779381: {
                return new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, Integer.MAX_VALUE, this.associatedMedication);
            }
            case -1491615543: {
                return new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType);
            }
            case -1442980789: {
                return new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -1335157162: {
                return new Property("device", "Reference(Device)", "A device associated with the medication (for example, a drug coated catheter or a drug impregnated dressing).", 0, Integer.MAX_VALUE, this.device);
            }
            case 1025456503: {
                return new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction);
            }
            case -767798050: {
                return new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute);
            }
            case 3059661: {
                return new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost);
            }
            case 569848092: {
                return new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram);
            }
            case -815253966: {
                return new Property("administrationGuideline", "", "Guidelines or protocols that are applicable for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuideline);
            }
            case 1791551680: {
                return new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification);
            }
            case 1802065795: {
                return new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging);
            }
            case -844126885: {
                return new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic);
            }
            case 251885509: {
                return new Property("clinicalUseIssue", "Reference(ClinicalUseIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.clinicalUseIssue);
            }
            case -27327848: {
                return new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory);
            }
            case -573129004: {
                return new Property("kineticCharacteristic", "", "The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.", 0, Integer.MAX_VALUE, this.kineticCharacteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 1303858817: {
                Base[] baseArray;
                if (this.doseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.doseForm;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.amount;
                }
                return baseArray;
            }
            case -1742128133: {
                return this.synonym == null ? new Base[]{} : this.synonym.toArray(new Base[this.synonym.size()]);
            }
            case 723067972: {
                return this.relatedMedicationKnowledge == null ? new Base[]{} : this.relatedMedicationKnowledge.toArray(new Base[this.relatedMedicationKnowledge.size()]);
            }
            case 1312779381: {
                return this.associatedMedication == null ? new Base[]{} : this.associatedMedication.toArray(new Base[this.associatedMedication.size()]);
            }
            case -1491615543: {
                return this.productType == null ? new Base[]{} : this.productType.toArray(new Base[this.productType.size()]);
            }
            case -1442980789: {
                return this.monograph == null ? new Base[]{} : this.monograph.toArray(new Base[this.monograph.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case 1025456503: {
                Base[] baseArray;
                if (this.preparationInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.preparationInstruction;
                }
                return baseArray;
            }
            case -767798050: {
                return this.intendedRoute == null ? new Base[]{} : this.intendedRoute.toArray(new Base[this.intendedRoute.size()]);
            }
            case 3059661: {
                return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
            }
            case 569848092: {
                return this.monitoringProgram == null ? new Base[]{} : this.monitoringProgram.toArray(new Base[this.monitoringProgram.size()]);
            }
            case -815253966: {
                return this.administrationGuideline == null ? new Base[]{} : this.administrationGuideline.toArray(new Base[this.administrationGuideline.size()]);
            }
            case 1791551680: {
                return this.medicineClassification == null ? new Base[]{} : this.medicineClassification.toArray(new Base[this.medicineClassification.size()]);
            }
            case 1802065795: {
                Base[] baseArray;
                if (this.packaging == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.packaging;
                }
                return baseArray;
            }
            case -844126885: {
                return this.drugCharacteristic == null ? new Base[]{} : this.drugCharacteristic.toArray(new Base[this.drugCharacteristic.size()]);
            }
            case 251885509: {
                return this.clinicalUseIssue == null ? new Base[]{} : this.clinicalUseIssue.toArray(new Base[this.clinicalUseIssue.size()]);
            }
            case -27327848: {
                return this.regulatory == null ? new Base[]{} : this.regulatory.toArray(new Base[this.regulatory.size()]);
            }
            case -573129004: {
                return this.kineticCharacteristic == null ? new Base[]{} : this.kineticCharacteristic.toArray(new Base[this.kineticCharacteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToReference(value);
                return value;
            }
            case 1303858817: {
                this.doseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1413853096: {
                this.amount = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -1742128133: {
                this.getSynonym().add(TypeConvertor.castToString(value));
                return value;
            }
            case 723067972: {
                this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
                return value;
            }
            case 1312779381: {
                this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1491615543: {
                this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1442980789: {
                this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1025456503: {
                this.preparationInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -767798050: {
                this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059661: {
                this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
                return value;
            }
            case 569848092: {
                this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
                return value;
            }
            case -815253966: {
                this.getAdministrationGuideline().add((MedicationKnowledgeAdministrationGuidelineComponent)((Object)value));
                return value;
            }
            case 1791551680: {
                this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
                return value;
            }
            case 1802065795: {
                this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
                return value;
            }
            case -844126885: {
                this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
                return value;
            }
            case 251885509: {
                this.getClinicalUseIssue().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -27327848: {
                this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
                return value;
            }
            case -573129004: {
                this.getKineticCharacteristic().add((MedicationKnowledgeKineticCharacteristicComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = TypeConvertor.castToReference(value);
        } else if (name.equals("doseForm")) {
            this.doseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("amount")) {
            this.amount = TypeConvertor.castToQuantity(value);
        } else if (name.equals("synonym")) {
            this.getSynonym().add(TypeConvertor.castToString(value));
        } else if (name.equals("relatedMedicationKnowledge")) {
            this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
        } else if (name.equals("associatedMedication")) {
            this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
        } else if (name.equals("productType")) {
            this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_MONOGRAPH)) {
            this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
        } else if (name.equals("device")) {
            this.getDevice().add(TypeConvertor.castToReference(value));
        } else if (name.equals("preparationInstruction")) {
            this.preparationInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("intendedRoute")) {
            this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("cost")) {
            this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
        } else if (name.equals("monitoringProgram")) {
            this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
        } else if (name.equals("administrationGuideline")) {
            this.getAdministrationGuideline().add((MedicationKnowledgeAdministrationGuidelineComponent)((Object)value));
        } else if (name.equals("medicineClassification")) {
            this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
        } else if (name.equals("packaging")) {
            this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
        } else if (name.equals("drugCharacteristic")) {
            this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
        } else if (name.equals("clinicalUseIssue")) {
            this.getClinicalUseIssue().add(TypeConvertor.castToReference(value));
        } else if (name.equals("regulatory")) {
            this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
        } else if (name.equals("kineticCharacteristic")) {
            this.getKineticCharacteristic().add((MedicationKnowledgeKineticCharacteristicComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 1303858817: {
                return this.getDoseForm();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case -1742128133: {
                return this.addSynonymElement();
            }
            case 723067972: {
                return this.addRelatedMedicationKnowledge();
            }
            case 1312779381: {
                return this.addAssociatedMedication();
            }
            case -1491615543: {
                return this.addProductType();
            }
            case -1442980789: {
                return this.addMonograph();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case 1025456503: {
                return this.getPreparationInstructionElement();
            }
            case -767798050: {
                return this.addIntendedRoute();
            }
            case 3059661: {
                return this.addCost();
            }
            case 569848092: {
                return this.addMonitoringProgram();
            }
            case -815253966: {
                return this.addAdministrationGuideline();
            }
            case 1791551680: {
                return this.addMedicineClassification();
            }
            case 1802065795: {
                return this.getPackaging();
            }
            case -844126885: {
                return this.addDrugCharacteristic();
            }
            case 251885509: {
                return this.addClinicalUseIssue();
            }
            case -27327848: {
                return this.addRegulatory();
            }
            case -573129004: {
                return this.addKineticCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 1303858817: {
                return new String[]{"CodeableConcept"};
            }
            case -1413853096: {
                return new String[]{"Quantity"};
            }
            case -1742128133: {
                return new String[]{"string"};
            }
            case 723067972: {
                return new String[0];
            }
            case 1312779381: {
                return new String[]{"Reference"};
            }
            case -1491615543: {
                return new String[]{"CodeableConcept"};
            }
            case -1442980789: {
                return new String[0];
            }
            case -206409263: {
                return new String[0];
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 1025456503: {
                return new String[]{"markdown"};
            }
            case -767798050: {
                return new String[]{"CodeableConcept"};
            }
            case 3059661: {
                return new String[0];
            }
            case 569848092: {
                return new String[0];
            }
            case -815253966: {
                return new String[0];
            }
            case 1791551680: {
                return new String[0];
            }
            case 1802065795: {
                return new String[0];
            }
            case -844126885: {
                return new String[0];
            }
            case 251885509: {
                return new String[]{"Reference"};
            }
            case -27327848: {
                return new String[0];
            }
            case -573129004: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.status");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("doseForm")) {
            this.doseForm = new CodeableConcept();
            return this.doseForm;
        }
        if (name.equals("amount")) {
            this.amount = new Quantity();
            return this.amount;
        }
        if (name.equals("synonym")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.synonym");
        }
        if (name.equals("relatedMedicationKnowledge")) {
            return this.addRelatedMedicationKnowledge();
        }
        if (name.equals("associatedMedication")) {
            return this.addAssociatedMedication();
        }
        if (name.equals("productType")) {
            return this.addProductType();
        }
        if (name.equals(SP_MONOGRAPH)) {
            return this.addMonograph();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("device")) {
            return this.addDevice();
        }
        if (name.equals("preparationInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.preparationInstruction");
        }
        if (name.equals("intendedRoute")) {
            return this.addIntendedRoute();
        }
        if (name.equals("cost")) {
            return this.addCost();
        }
        if (name.equals("monitoringProgram")) {
            return this.addMonitoringProgram();
        }
        if (name.equals("administrationGuideline")) {
            return this.addAdministrationGuideline();
        }
        if (name.equals("medicineClassification")) {
            return this.addMedicineClassification();
        }
        if (name.equals("packaging")) {
            this.packaging = new MedicationKnowledgePackagingComponent();
            return this.packaging;
        }
        if (name.equals("drugCharacteristic")) {
            return this.addDrugCharacteristic();
        }
        if (name.equals("clinicalUseIssue")) {
            return this.addClinicalUseIssue();
        }
        if (name.equals("regulatory")) {
            return this.addRegulatory();
        }
        if (name.equals("kineticCharacteristic")) {
            return this.addKineticCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationKnowledge";
    }

    @Override
    public MedicationKnowledge copy() {
        MedicationKnowledge dst = new MedicationKnowledge();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationKnowledge dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.doseForm = this.doseForm == null ? null : this.doseForm.copy();
        Quantity quantity = dst.amount = this.amount == null ? null : this.amount.copy();
        if (this.synonym != null) {
            dst.synonym = new ArrayList<StringType>();
            for (StringType stringType : this.synonym) {
                dst.synonym.add(stringType.copy());
            }
        }
        if (this.relatedMedicationKnowledge != null) {
            dst.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
            for (MedicationKnowledgeRelatedMedicationKnowledgeComponent medicationKnowledgeRelatedMedicationKnowledgeComponent : this.relatedMedicationKnowledge) {
                dst.relatedMedicationKnowledge.add(medicationKnowledgeRelatedMedicationKnowledgeComponent.copy());
            }
        }
        if (this.associatedMedication != null) {
            dst.associatedMedication = new ArrayList<Reference>();
            for (Reference reference : this.associatedMedication) {
                dst.associatedMedication.add(reference.copy());
            }
        }
        if (this.productType != null) {
            dst.productType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.productType) {
                dst.productType.add(codeableConcept.copy());
            }
        }
        if (this.monograph != null) {
            dst.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
            for (MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : this.monograph) {
                dst.monograph.add(medicationKnowledgeMonographComponent.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
            for (MedicationKnowledgeIngredientComponent medicationKnowledgeIngredientComponent : this.ingredient) {
                dst.ingredient.add(medicationKnowledgeIngredientComponent.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference : this.device) {
                dst.device.add(reference.copy());
            }
        }
        MarkdownType markdownType = dst.preparationInstruction = this.preparationInstruction == null ? null : this.preparationInstruction.copy();
        if (this.intendedRoute != null) {
            dst.intendedRoute = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.intendedRoute) {
                dst.intendedRoute.add(codeableConcept.copy());
            }
        }
        if (this.cost != null) {
            dst.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            for (MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : this.cost) {
                dst.cost.add(medicationKnowledgeCostComponent.copy());
            }
        }
        if (this.monitoringProgram != null) {
            dst.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
            for (MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : this.monitoringProgram) {
                dst.monitoringProgram.add(medicationKnowledgeMonitoringProgramComponent.copy());
            }
        }
        if (this.administrationGuideline != null) {
            dst.administrationGuideline = new ArrayList<MedicationKnowledgeAdministrationGuidelineComponent>();
            for (MedicationKnowledgeAdministrationGuidelineComponent medicationKnowledgeAdministrationGuidelineComponent : this.administrationGuideline) {
                dst.administrationGuideline.add(medicationKnowledgeAdministrationGuidelineComponent.copy());
            }
        }
        if (this.medicineClassification != null) {
            dst.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
            for (MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : this.medicineClassification) {
                dst.medicineClassification.add(medicationKnowledgeMedicineClassificationComponent.copy());
            }
        }
        MedicationKnowledgePackagingComponent medicationKnowledgePackagingComponent = dst.packaging = this.packaging == null ? null : this.packaging.copy();
        if (this.drugCharacteristic != null) {
            dst.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
            for (MedicationKnowledgeDrugCharacteristicComponent medicationKnowledgeDrugCharacteristicComponent : this.drugCharacteristic) {
                dst.drugCharacteristic.add(medicationKnowledgeDrugCharacteristicComponent.copy());
            }
        }
        if (this.clinicalUseIssue != null) {
            dst.clinicalUseIssue = new ArrayList<Reference>();
            for (Reference reference : this.clinicalUseIssue) {
                dst.clinicalUseIssue.add(reference.copy());
            }
        }
        if (this.regulatory != null) {
            dst.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
            for (MedicationKnowledgeRegulatoryComponent medicationKnowledgeRegulatoryComponent : this.regulatory) {
                dst.regulatory.add(medicationKnowledgeRegulatoryComponent.copy());
            }
        }
        if (this.kineticCharacteristic != null) {
            dst.kineticCharacteristic = new ArrayList<MedicationKnowledgeKineticCharacteristicComponent>();
            for (MedicationKnowledgeKineticCharacteristicComponent medicationKnowledgeKineticCharacteristicComponent : this.kineticCharacteristic) {
                dst.kineticCharacteristic.add(medicationKnowledgeKineticCharacteristicComponent.copy());
            }
        }
    }

    protected MedicationKnowledge typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareDeep(this.identifier, o.identifier, true) && MedicationKnowledge.compareDeep(this.code, o.code, true) && MedicationKnowledge.compareDeep(this.status, o.status, true) && MedicationKnowledge.compareDeep(this.manufacturer, o.manufacturer, true) && MedicationKnowledge.compareDeep(this.doseForm, o.doseForm, true) && MedicationKnowledge.compareDeep(this.amount, o.amount, true) && MedicationKnowledge.compareDeep(this.synonym, o.synonym, true) && MedicationKnowledge.compareDeep(this.relatedMedicationKnowledge, o.relatedMedicationKnowledge, true) && MedicationKnowledge.compareDeep(this.associatedMedication, o.associatedMedication, true) && MedicationKnowledge.compareDeep(this.productType, o.productType, true) && MedicationKnowledge.compareDeep(this.monograph, o.monograph, true) && MedicationKnowledge.compareDeep(this.ingredient, o.ingredient, true) && MedicationKnowledge.compareDeep(this.device, o.device, true) && MedicationKnowledge.compareDeep(this.preparationInstruction, o.preparationInstruction, true) && MedicationKnowledge.compareDeep(this.intendedRoute, o.intendedRoute, true) && MedicationKnowledge.compareDeep(this.cost, o.cost, true) && MedicationKnowledge.compareDeep(this.monitoringProgram, o.monitoringProgram, true) && MedicationKnowledge.compareDeep(this.administrationGuideline, o.administrationGuideline, true) && MedicationKnowledge.compareDeep(this.medicineClassification, o.medicineClassification, true) && MedicationKnowledge.compareDeep(this.packaging, o.packaging, true) && MedicationKnowledge.compareDeep(this.drugCharacteristic, o.drugCharacteristic, true) && MedicationKnowledge.compareDeep(this.clinicalUseIssue, o.clinicalUseIssue, true) && MedicationKnowledge.compareDeep(this.regulatory, o.regulatory, true) && MedicationKnowledge.compareDeep(this.kineticCharacteristic, o.kineticCharacteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareValues(this.status, o.status, true) && MedicationKnowledge.compareValues(this.synonym, o.synonym, true) && MedicationKnowledge.compareValues(this.preparationInstruction, o.preparationInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.status, this.manufacturer, this.doseForm, this.amount, this.synonym, this.relatedMedicationKnowledge, this.associatedMedication, this.productType, this.monograph, this.ingredient, this.device, this.preparationInstruction, this.intendedRoute, this.cost, this.monitoringProgram, this.administrationGuideline, this.medicineClassification, this.packaging, this.drugCharacteristic, this.clinicalUseIssue, this.regulatory, this.kineticCharacteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationKnowledge;
    }

    @Block
    public static class MedicationKnowledgeKineticCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of kinetics", formalDefinition="Code specifying the type of kinetics (e.g. area under the curve, half life period, lethal dose 50.).")
        protected CodeableConcept type;
        @Child(name="value", type={Quantity.class, Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the characteristic", formalDefinition="Description of the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeKineticCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeKineticCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeKineticCharacteristicComponent setValue(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof Duration)) {
                throw new Error("Not the right type for MedicationKnowledge.kineticCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Code specifying the type of kinetics (e.g. area under the curve, half life period, lethal dose 50.).", 0, 1, this.type));
            children.add(new Property("value[x]", "Quantity|Duration", "Description of the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code specifying the type of kinetics (e.g. area under the curve, half life period, lethal dose 50.).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|Duration", "Description of the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|Duration", "Description of the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Description of the characteristic.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "Description of the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeKineticCharacteristicComponent copy() {
            MedicationKnowledgeKineticCharacteristicComponent dst = new MedicationKnowledgeKineticCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeKineticCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeKineticCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeKineticCharacteristicComponent o = (MedicationKnowledgeKineticCharacteristicComponent)other_;
            return MedicationKnowledgeKineticCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeKineticCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeKineticCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeKineticCharacteristicComponent o = (MedicationKnowledgeKineticCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.kineticCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryMaxDispenseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed", formalDefinition="The maximum number of units of the medication that can be dispensed.")
        protected Quantity quantity;
        @Child(name="period", type={Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The period that applies to the maximum number of units", formalDefinition="The period that applies to the maximum number of units.")
        protected Duration period;
        private static final long serialVersionUID = -441724185L;

        public MedicationKnowledgeRegulatoryMaxDispenseComponent() {
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent(Quantity quantity) {
            this.setQuantity(quantity);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Duration();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setPeriod(Duration value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity));
            children.add(new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity);
                }
                case -991726143: {
                    return new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -991726143: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("period")) {
                this.period = new Duration();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryMaxDispenseComponent copy() {
            MedicationKnowledgeRegulatoryMaxDispenseComponent dst = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryMaxDispenseComponent dst) {
            super.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.quantity, o.quantity, true) && MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.period});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.maxDispense";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatorySubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the type of substitution allowed", formalDefinition="Specifies the type of substitution allowed.")
        protected CodeableConcept type;
        @Child(name="allowed", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if regulation allows for changes in the medication when dispensing", formalDefinition="Specifies if regulation allows for changes in the medication when dispensing.")
        protected BooleanType allowed;
        private static final long serialVersionUID = 396354861L;

        public MedicationKnowledgeRegulatorySubstitutionComponent() {
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent(CodeableConcept type, boolean allowed) {
            this.setType(type);
            this.setAllowed(allowed);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public BooleanType getAllowedElement() {
            if (this.allowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.allowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.allowed = new BooleanType();
                }
            }
            return this.allowed;
        }

        public boolean hasAllowedElement() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowedElement(BooleanType value) {
            this.allowed = value;
            return this;
        }

        public boolean getAllowed() {
            return this.allowed == null || this.allowed.isEmpty() ? false : (Boolean)this.allowed.getValue();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowed(boolean value) {
            if (this.allowed == null) {
                this.allowed = new BooleanType();
            }
            this.allowed.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type));
            children.add(new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type);
                }
                case -911343192: {
                    return new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("allowed")) {
                this.allowed = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -911343192: {
                    return this.getAllowedElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.regulatory.substitution.allowed");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatorySubstitutionComponent copy() {
            MedicationKnowledgeRegulatorySubstitutionComponent dst = new MedicationKnowledgeRegulatorySubstitutionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatorySubstitutionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.allowed, o.allowed, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareValues(this.allowed, o.allowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.allowed});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.substitution";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regulatoryAuthority", type={Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the authority of the regulation", formalDefinition="The authority that is specifying the regulations.")
        protected Reference regulatoryAuthority;
        @Child(name="substitution", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective", formalDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective.")
        protected List<MedicationKnowledgeRegulatorySubstitutionComponent> substitution;
        @Child(name="schedule", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the schedule of a medication in jurisdiction", formalDefinition="Specifies the schedule of a medication in jurisdiction.")
        protected List<CodeableConcept> schedule;
        @Child(name="maxDispense", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed in a period", formalDefinition="The maximum number of units of the medication that can be dispensed in a period.")
        protected MedicationKnowledgeRegulatoryMaxDispenseComponent maxDispense;
        private static final long serialVersionUID = -2005823416L;

        public MedicationKnowledgeRegulatoryComponent() {
        }

        public MedicationKnowledgeRegulatoryComponent(Reference regulatoryAuthority) {
            this.setRegulatoryAuthority(regulatoryAuthority);
        }

        public Reference getRegulatoryAuthority() {
            if (this.regulatoryAuthority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.regulatoryAuthority");
                }
                if (Configuration.doAutoCreate()) {
                    this.regulatoryAuthority = new Reference();
                }
            }
            return this.regulatoryAuthority;
        }

        public boolean hasRegulatoryAuthority() {
            return this.regulatoryAuthority != null && !this.regulatoryAuthority.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setRegulatoryAuthority(Reference value) {
            this.regulatoryAuthority = value;
            return this;
        }

        public List<MedicationKnowledgeRegulatorySubstitutionComponent> getSubstitution() {
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            return this.substitution;
        }

        public MedicationKnowledgeRegulatoryComponent setSubstitution(List<MedicationKnowledgeRegulatorySubstitutionComponent> theSubstitution) {
            this.substitution = theSubstitution;
            return this;
        }

        public boolean hasSubstitution() {
            if (this.substitution == null) {
                return false;
            }
            for (MedicationKnowledgeRegulatorySubstitutionComponent item : this.substitution) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent addSubstitution() {
            MedicationKnowledgeRegulatorySubstitutionComponent t = new MedicationKnowledgeRegulatorySubstitutionComponent();
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSubstitution(MedicationKnowledgeRegulatorySubstitutionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return this;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent getSubstitutionFirstRep() {
            if (this.getSubstitution().isEmpty()) {
                this.addSubstitution();
            }
            return this.getSubstitution().get(0);
        }

        public List<CodeableConcept> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            return this.schedule;
        }

        public MedicationKnowledgeRegulatoryComponent setSchedule(List<CodeableConcept> theSchedule) {
            this.schedule = theSchedule;
            return this;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (CodeableConcept item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSchedule() {
            CodeableConcept t = new CodeableConcept();
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            this.schedule.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSchedule(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            this.schedule.add(t);
            return this;
        }

        public CodeableConcept getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent getMaxDispense() {
            if (this.maxDispense == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.maxDispense");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                }
            }
            return this.maxDispense;
        }

        public boolean hasMaxDispense() {
            return this.maxDispense != null && !this.maxDispense.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setMaxDispense(MedicationKnowledgeRegulatoryMaxDispenseComponent value) {
            this.maxDispense = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority));
            children.add(new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution));
            children.add(new Property("schedule", "CodeableConcept", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule));
            children.add(new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 711233419: {
                    return new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority);
                }
                case 826147581: {
                    return new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution);
                }
                case -697920873: {
                    return new Property("schedule", "CodeableConcept", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule);
                }
                case -1977784607: {
                    return new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    Base[] baseArray;
                    if (this.regulatoryAuthority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regulatoryAuthority;
                    }
                    return baseArray;
                }
                case 826147581: {
                    return this.substitution == null ? new Base[]{} : this.substitution.toArray(new Base[this.substitution.size()]);
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1977784607: {
                    Base[] baseArray;
                    if (this.maxDispense == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.maxDispense;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    this.regulatoryAuthority = TypeConvertor.castToReference(value);
                    return value;
                }
                case 826147581: {
                    this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
                    return value;
                }
                case -697920873: {
                    this.getSchedule().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1977784607: {
                    this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = TypeConvertor.castToReference(value);
            } else if (name.equals("substitution")) {
                this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
            } else if (name.equals("schedule")) {
                this.getSchedule().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("maxDispense")) {
                this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return this.getRegulatoryAuthority();
                }
                case 826147581: {
                    return this.addSubstitution();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1977784607: {
                    return this.getMaxDispense();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return new String[]{"Reference"};
                }
                case 826147581: {
                    return new String[0];
                }
                case -697920873: {
                    return new String[]{"CodeableConcept"};
                }
                case -1977784607: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = new Reference();
                return this.regulatoryAuthority;
            }
            if (name.equals("substitution")) {
                return this.addSubstitution();
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("maxDispense")) {
                this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                return this.maxDispense;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryComponent copy() {
            MedicationKnowledgeRegulatoryComponent dst = new MedicationKnowledgeRegulatoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.regulatoryAuthority = this.regulatoryAuthority == null ? null : this.regulatoryAuthority.copy();
            if (this.substitution != null) {
                dst.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
                for (MedicationKnowledgeRegulatorySubstitutionComponent medicationKnowledgeRegulatorySubstitutionComponent : this.substitution) {
                    dst.substitution.add(medicationKnowledgeRegulatorySubstitutionComponent.copy());
                }
            }
            if (this.schedule != null) {
                dst.schedule = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.schedule) {
                    dst.schedule.add(codeableConcept.copy());
                }
            }
            dst.maxDispense = this.maxDispense == null ? null : this.maxDispense.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return MedicationKnowledgeRegulatoryComponent.compareDeep(this.regulatoryAuthority, o.regulatoryAuthority, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.substitution, o.substitution, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.schedule, o.schedule, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.maxDispense, o.maxDispense, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regulatoryAuthority, this.substitution, this.schedule, this.maxDispense});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory";
        }
    }

    @Block
    public static class MedicationKnowledgeDrugCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of characteristic of medication", formalDefinition="A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-characteristic")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, StringType.class, Quantity.class, Base64BinaryType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the characteristic", formalDefinition="Description of the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDrugCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof Quantity || value instanceof Base64BinaryType || value instanceof Attachment)) {
                throw new Error("Not the right type for MedicationKnowledge.drugCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Description of the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "string", "Quantity", "base64Binary", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDrugCharacteristicComponent copy() {
            MedicationKnowledgeDrugCharacteristicComponent dst = new MedicationKnowledgeDrugCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeDrugCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.drugCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgePackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A code that defines the specific type of packaging that the medication can be found in", formalDefinition="A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-package-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of product units the package would contain if fully loaded", formalDefinition="The number of product units the package would contain if fully loaded.")
        protected Quantity quantity;
        @Child(name="device", type={Device.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The device used to administer the medication (e.g. scoop, applicator, syringe)", formalDefinition="The device used to administer the medication (e.g. scoop, applicator, syringe).")
        protected Reference device;
        @Child(name="material", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        protected CodeableConcept material;
        @Child(name="packaging", type={MedicationKnowledgePackagingComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Allows packages within packages", formalDefinition="Allows packages within packages (e.g. blister packages within a box or vials of medications within a box).")
        protected List<MedicationKnowledgePackagingComponent> packaging;
        private static final long serialVersionUID = 574843440L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Reference getDevice() {
            if (this.device == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.device");
                }
                if (Configuration.doAutoCreate()) {
                    this.device = new Reference();
                }
            }
            return this.device;
        }

        public boolean hasDevice() {
            return this.device != null && !this.device.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setDevice(Reference value) {
            this.device = value;
            return this;
        }

        public CodeableConcept getMaterial() {
            if (this.material == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.material");
                }
                if (Configuration.doAutoCreate()) {
                    this.material = new CodeableConcept();
                }
            }
            return this.material;
        }

        public boolean hasMaterial() {
            return this.material != null && !this.material.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setMaterial(CodeableConcept value) {
            this.material = value;
            return this;
        }

        public List<MedicationKnowledgePackagingComponent> getPackaging() {
            if (this.packaging == null) {
                this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
            }
            return this.packaging;
        }

        public MedicationKnowledgePackagingComponent setPackaging(List<MedicationKnowledgePackagingComponent> thePackaging) {
            this.packaging = thePackaging;
            return this;
        }

        public boolean hasPackaging() {
            if (this.packaging == null) {
                return false;
            }
            for (MedicationKnowledgePackagingComponent item : this.packaging) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgePackagingComponent addPackaging() {
            MedicationKnowledgePackagingComponent t = new MedicationKnowledgePackagingComponent();
            if (this.packaging == null) {
                this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
            }
            this.packaging.add(t);
            return t;
        }

        public MedicationKnowledgePackagingComponent addPackaging(MedicationKnowledgePackagingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.packaging == null) {
                this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
            }
            this.packaging.add(t);
            return this;
        }

        public MedicationKnowledgePackagingComponent getPackagingFirstRep() {
            if (this.getPackaging().isEmpty()) {
                this.addPackaging();
            }
            return this.getPackaging().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity));
            children.add(new Property("device", "Reference(Device)", "The device used to administer the medication (e.g. scoop, applicator, syringe).", 0, 1, this.device));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, 1, this.material));
            children.add(new Property("packaging", "@MedicationKnowledge.packaging", "Allows packages within packages (e.g. blister packages within a box or vials of medications within a box).", 0, Integer.MAX_VALUE, this.packaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity);
                }
                case -1335157162: {
                    return new Property("device", "Reference(Device)", "The device used to administer the medication (e.g. scoop, applicator, syringe).", 0, 1, this.device);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, 1, this.material);
                }
                case 1802065795: {
                    return new Property("packaging", "@MedicationKnowledge.packaging", "Allows packages within packages (e.g. blister packages within a box or vials of medications within a box).", 0, Integer.MAX_VALUE, this.packaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1335157162: {
                    Base[] baseArray;
                    if (this.device == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.device;
                    }
                    return baseArray;
                }
                case 299066663: {
                    Base[] baseArray;
                    if (this.material == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.material;
                    }
                    return baseArray;
                }
                case 1802065795: {
                    return this.packaging == null ? new Base[]{} : this.packaging.toArray(new Base[this.packaging.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1335157162: {
                    this.device = TypeConvertor.castToReference(value);
                    return value;
                }
                case 299066663: {
                    this.material = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1802065795: {
                    this.getPackaging().add((MedicationKnowledgePackagingComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("device")) {
                this.device = TypeConvertor.castToReference(value);
            } else if (name.equals("material")) {
                this.material = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("packaging")) {
                this.getPackaging().add((MedicationKnowledgePackagingComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1335157162: {
                    return this.getDevice();
                }
                case 299066663: {
                    return this.getMaterial();
                }
                case 1802065795: {
                    return this.addPackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case 1802065795: {
                    return new String[]{"@MedicationKnowledge.packaging"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("device")) {
                this.device = new Reference();
                return this.device;
            }
            if (name.equals("material")) {
                this.material = new CodeableConcept();
                return this.material;
            }
            if (name.equals("packaging")) {
                return this.addPackaging();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgePackagingComponent copy() {
            MedicationKnowledgePackagingComponent dst = new MedicationKnowledgePackagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgePackagingComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.device = this.device == null ? null : this.device.copy();
            CodeableConcept codeableConcept = dst.material = this.material == null ? null : this.material.copy();
            if (this.packaging != null) {
                dst.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
                for (MedicationKnowledgePackagingComponent i : this.packaging) {
                    dst.packaging.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return MedicationKnowledgePackagingComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgePackagingComponent.compareDeep(this.quantity, o.quantity, true) && MedicationKnowledgePackagingComponent.compareDeep(this.device, o.device, true) && MedicationKnowledgePackagingComponent.compareDeep(this.material, o.material, true) && MedicationKnowledgePackagingComponent.compareDeep(this.packaging, o.packaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.quantity, this.device, this.material, this.packaging});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.packaging";
        }
    }

    @Block
    public static class MedicationKnowledgeMedicineClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", formalDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).")
        protected CodeableConcept type;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific category assigned to the medication", formalDefinition="Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).")
        protected List<CodeableConcept> classification;
        private static final long serialVersionUID = 1562996046L;

        public MedicationKnowledgeMedicineClassificationComponent() {
        }

        public MedicationKnowledgeMedicineClassificationComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMedicineClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMedicineClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            return this.classification;
        }

        public MedicationKnowledgeMedicineClassificationComponent setClassification(List<CodeableConcept> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CodeableConcept item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassification() {
            CodeableConcept t = new CodeableConcept();
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return t;
        }

        public MedicationKnowledgeMedicineClassificationComponent addClassification(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return this;
        }

        public CodeableConcept getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type));
            children.add(new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type);
                }
                case 382350310: {
                    return new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 382350310: {
                    return this.addClassification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                return this.addClassification();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMedicineClassificationComponent copy() {
            MedicationKnowledgeMedicineClassificationComponent dst = new MedicationKnowledgeMedicineClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMedicineClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classification != null) {
                dst.classification = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classification) {
                    dst.classification.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.classification, o.classification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classification});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.medicineClassification";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Categorization of specific characteristic that is relevant to the administration guideline", formalDefinition="The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific characteristic", formalDefinition="The specific characteristic (e.g. height, weight, gender, etc.).")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent() {
        }

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent setValue(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationKnowledge.administrationGuideline.patientCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent copy() {
            MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent dst = new MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent o = (MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent o = (MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuideline.patientCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelineDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of dosage for a medication", formalDefinition="The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).")
        protected CodeableConcept type;
        @Child(name="dosage", type={Dosage.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<Dosage> dosage;
        private static final long serialVersionUID = 1578257961L;

        public MedicationKnowledgeAdministrationGuidelineDosageComponent() {
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent(CodeableConcept type, Dosage dosage) {
            this.setType(type);
            this.addDosage(dosage);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeAdministrationGuidelineDosageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Dosage> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent setDosage(List<Dosage> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (Dosage item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Dosage addDosage() {
            Dosage t = new Dosage();
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent addDosage(Dosage t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return this;
        }

        public Dosage getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type));
            children.add(new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type);
                }
                case -1326018889: {
                    return new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1326018889: {
                    this.getDosage().add(TypeConvertor.castToDosage(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dosage")) {
                this.getDosage().add(TypeConvertor.castToDosage(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1326018889: {
                    return this.addDosage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326018889: {
                    return new String[]{"Dosage"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelineDosageComponent copy() {
            MedicationKnowledgeAdministrationGuidelineDosageComponent dst = new MedicationKnowledgeAdministrationGuidelineDosageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelineDosageComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.dosage != null) {
                dst.dosage = new ArrayList<Dosage>();
                for (Dosage i : this.dosage) {
                    dst.dosage.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelineDosageComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelineDosageComponent o = (MedicationKnowledgeAdministrationGuidelineDosageComponent)other_;
            return MedicationKnowledgeAdministrationGuidelineDosageComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeAdministrationGuidelineDosageComponent.compareDeep(this.dosage, o.dosage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelineDosageComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelineDosageComponent o = (MedicationKnowledgeAdministrationGuidelineDosageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.dosage});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuideline.dosage";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelineComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="dosage", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<MedicationKnowledgeAdministrationGuidelineDosageComponent> dosage;
        @Child(name="indication", type={CodeableReference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indication for use that apply to the specific administration guidelines", formalDefinition="Indication or reason for use of the medication that applies to the specific administration guidelines.")
        protected CodeableReference indication;
        @Child(name="patientCharacteristic", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristics of the patient that are relevant to the administration guidelines", formalDefinition="Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).")
        protected List<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent> patientCharacteristic;
        private static final long serialVersionUID = 1786736896L;

        public List<MedicationKnowledgeAdministrationGuidelineDosageComponent> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelineDosageComponent>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeAdministrationGuidelineComponent setDosage(List<MedicationKnowledgeAdministrationGuidelineDosageComponent> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (MedicationKnowledgeAdministrationGuidelineDosageComponent item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent addDosage() {
            MedicationKnowledgeAdministrationGuidelineDosageComponent t = new MedicationKnowledgeAdministrationGuidelineDosageComponent();
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelineDosageComponent>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelineComponent addDosage(MedicationKnowledgeAdministrationGuidelineDosageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelineDosageComponent>();
            }
            this.dosage.add(t);
            return this;
        }

        public MedicationKnowledgeAdministrationGuidelineDosageComponent getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        public CodeableReference getIndication() {
            if (this.indication == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeAdministrationGuidelineComponent.indication");
                }
                if (Configuration.doAutoCreate()) {
                    this.indication = new CodeableReference();
                }
            }
            return this.indication;
        }

        public boolean hasIndication() {
            return this.indication != null && !this.indication.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelineComponent setIndication(CodeableReference value) {
            this.indication = value;
            return this;
        }

        public List<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent> getPatientCharacteristic() {
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent>();
            }
            return this.patientCharacteristic;
        }

        public MedicationKnowledgeAdministrationGuidelineComponent setPatientCharacteristic(List<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent> thePatientCharacteristic) {
            this.patientCharacteristic = thePatientCharacteristic;
            return this;
        }

        public boolean hasPatientCharacteristic() {
            if (this.patientCharacteristic == null) {
                return false;
            }
            for (MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent item : this.patientCharacteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent addPatientCharacteristic() {
            MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent t = new MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent();
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent>();
            }
            this.patientCharacteristic.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelineComponent addPatientCharacteristic(MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent>();
            }
            this.patientCharacteristic.add(t);
            return this;
        }

        public MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent getPatientCharacteristicFirstRep() {
            if (this.getPatientCharacteristic().isEmpty()) {
                this.addPatientCharacteristic();
            }
            return this.getPatientCharacteristic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
            children.add(new Property("indication", "CodeableReference(ClinicalUseIssue)", "Indication or reason for use of the medication that applies to the specific administration guidelines.", 0, 1, this.indication));
            children.add(new Property("patientCharacteristic", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1326018889: {
                    return new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
                case -597168804: {
                    return new Property("indication", "CodeableReference(ClinicalUseIssue)", "Indication or reason for use of the medication that applies to the specific administration guidelines.", 0, 1, this.indication);
                }
                case 1770130432: {
                    return new Property("patientCharacteristic", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
                case -597168804: {
                    Base[] baseArray;
                    if (this.indication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.indication;
                    }
                    return baseArray;
                }
                case 1770130432: {
                    return this.patientCharacteristic == null ? new Base[]{} : this.patientCharacteristic.toArray(new Base[this.patientCharacteristic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    this.getDosage().add((MedicationKnowledgeAdministrationGuidelineDosageComponent)value);
                    return value;
                }
                case -597168804: {
                    this.indication = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 1770130432: {
                    this.getPatientCharacteristic().add((MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("dosage")) {
                this.getDosage().add((MedicationKnowledgeAdministrationGuidelineDosageComponent)value);
            } else if (name.equals("indication")) {
                this.indication = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("patientCharacteristic")) {
                this.getPatientCharacteristic().add((MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.addDosage();
                }
                case -597168804: {
                    return this.getIndication();
                }
                case 1770130432: {
                    return this.addPatientCharacteristic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return new String[0];
                }
                case -597168804: {
                    return new String[]{"CodeableReference"};
                }
                case 1770130432: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            if (name.equals("indication")) {
                this.indication = new CodeableReference();
                return this.indication;
            }
            if (name.equals("patientCharacteristic")) {
                return this.addPatientCharacteristic();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelineComponent copy() {
            MedicationKnowledgeAdministrationGuidelineComponent dst = new MedicationKnowledgeAdministrationGuidelineComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeAdministrationGuidelineComponent dst) {
            super.copyValues(dst);
            if (this.dosage != null) {
                dst.dosage = new ArrayList<MedicationKnowledgeAdministrationGuidelineDosageComponent>();
                for (MedicationKnowledgeAdministrationGuidelineDosageComponent medicationKnowledgeAdministrationGuidelineDosageComponent : this.dosage) {
                    dst.dosage.add(medicationKnowledgeAdministrationGuidelineDosageComponent.copy());
                }
            }
            CodeableReference codeableReference = dst.indication = this.indication == null ? null : this.indication.copy();
            if (this.patientCharacteristic != null) {
                dst.patientCharacteristic = new ArrayList<MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent>();
                for (MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent medicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent : this.patientCharacteristic) {
                    dst.patientCharacteristic.add(medicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelineComponent o = (MedicationKnowledgeAdministrationGuidelineComponent)other_;
            return MedicationKnowledgeAdministrationGuidelineComponent.compareDeep(this.dosage, o.dosage, true) && MedicationKnowledgeAdministrationGuidelineComponent.compareDeep(this.indication, o.indication, true) && MedicationKnowledgeAdministrationGuidelineComponent.compareDeep(this.patientCharacteristic, o.patientCharacteristic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelineComponent o = (MedicationKnowledgeAdministrationGuidelineComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.dosage, this.indication, this.patientCharacteristic});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuideline";
        }
    }

    @Block
    public static class MedicationKnowledgeMonitoringProgramComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of program under which the medication is monitored", formalDefinition="Type of program under which the medication is monitored.")
        protected CodeableConcept type;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the reviewing program", formalDefinition="Name of the reviewing program.")
        protected StringType name;
        private static final long serialVersionUID = -280346281L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MedicationKnowledgeMonitoringProgramComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type));
            children.add(new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.monitoringProgram.name");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonitoringProgramComponent copy() {
            MedicationKnowledgeMonitoringProgramComponent dst = new MedicationKnowledgeMonitoringProgramComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonitoringProgramComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monitoringProgram";
        }
    }

    @Block
    public static class MedicationKnowledgeCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of the cost information", formalDefinition="The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.")
        protected CodeableConcept type;
        @Child(name="source", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source or owner for the price information", formalDefinition="The source or owner that assigns the price to the medication.")
        protected StringType source;
        @Child(name="cost", type={Money.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The price of the medication", formalDefinition="The price of the medication.")
        protected Money cost;
        private static final long serialVersionUID = 244671378L;

        public MedicationKnowledgeCostComponent() {
        }

        public MedicationKnowledgeCostComponent(CodeableConcept type, Money cost) {
            this.setType(type);
            this.setCost(cost);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeCostComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public MedicationKnowledgeCostComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new StringType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public Money getCost() {
            if (this.cost == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.cost");
                }
                if (Configuration.doAutoCreate()) {
                    this.cost = new Money();
                }
            }
            return this.cost;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public MedicationKnowledgeCostComponent setCost(Money value) {
            this.cost = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type));
            children.add(new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source));
            children.add(new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source);
                }
                case 3059661: {
                    return new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToString(value);
                    return value;
                }
                case 3059661: {
                    this.cost = TypeConvertor.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToString(value);
            } else if (name.equals("cost")) {
                this.cost = TypeConvertor.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 3059661: {
                    return this.getCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 3059661: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.cost.source");
            }
            if (name.equals("cost")) {
                this.cost = new Money();
                return this.cost;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeCostComponent copy() {
            MedicationKnowledgeCostComponent dst = new MedicationKnowledgeCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeCostComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeCostComponent.compareDeep(this.source, o.source, true) && MedicationKnowledgeCostComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareValues(this.source, o.source, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source, this.cost});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.cost";
        }
    }

    @Block
    public static class MedicationKnowledgeIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Medication(s) or MedicinalProductIngredient(s) contained in the medication", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication.")
        protected CodeableReference item;
        @Child(name="isActive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Active ingredient indicator", formalDefinition="Indication of whether this ingredient affects the therapeutic action of the drug.")
        protected BooleanType isActive;
        @Child(name="strength", type={Ratio.class, CodeableConcept.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-ingredientstrength")
        protected DataType strength;
        private static final long serialVersionUID = -979760018L;

        public MedicationKnowledgeIngredientComponent() {
        }

        public MedicationKnowledgeIngredientComponent(CodeableReference item) {
            this.setItem(item);
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public BooleanType getIsActiveElement() {
            if (this.isActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.isActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.isActive = new BooleanType();
                }
            }
            return this.isActive;
        }

        public boolean hasIsActiveElement() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public boolean hasIsActive() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setIsActiveElement(BooleanType value) {
            this.isActive = value;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive == null || this.isActive.isEmpty() ? false : (Boolean)this.isActive.getValue();
        }

        public MedicationKnowledgeIngredientComponent setIsActive(boolean value) {
            if (this.isActive == null) {
                this.isActive = new BooleanType();
            }
            this.isActive.setValue((Object)value);
            return this;
        }

        public DataType getStrength() {
            return this.strength;
        }

        public Ratio getStrengthRatio() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Ratio();
            }
            if (!(this.strength instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Ratio)this.strength;
        }

        public boolean hasStrengthRatio() {
            return this != null && this.strength instanceof Ratio;
        }

        public CodeableConcept getStrengthCodeableConcept() throws FHIRException {
            if (this.strength == null) {
                this.strength = new CodeableConcept();
            }
            if (!(this.strength instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.strength;
        }

        public boolean hasStrengthCodeableConcept() {
            return this != null && this.strength instanceof CodeableConcept;
        }

        public Quantity getStrengthQuantity() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Quantity();
            }
            if (!(this.strength instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Quantity)this.strength;
        }

        public boolean hasStrengthQuantity() {
            return this != null && this.strength instanceof Quantity;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setStrength(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationKnowledge.ingredient.strength[x]: " + value.fhirType());
            }
            this.strength = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(Ingredient)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item));
            children.add(new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive));
            children.add(new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(Ingredient)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case -748916528: {
                    return new Property("isActive", "boolean", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.isActive);
                }
                case 127377567: {
                    return new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case 1791316033: {
                    return new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case 2141786186: {
                    return new Property("strength[x]", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case -1455903456: {
                    return new Property("strength[x]", "CodeableConcept", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case -1793570836: {
                    return new Property("strength[x]", "Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -748916528: {
                    Base[] baseArray;
                    if (this.isActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isActive;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strength;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -748916528: {
                    this.isActive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("isActive")) {
                this.isActive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("strength[x]")) {
                this.strength = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case -748916528: {
                    return this.getIsActiveElement();
                }
                case 127377567: {
                    return this.getStrength();
                }
                case 1791316033: {
                    return this.getStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case -748916528: {
                    return new String[]{"boolean"};
                }
                case 1791316033: {
                    return new String[]{"Ratio", "CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("isActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.ingredient.isActive");
            }
            if (name.equals("strengthRatio")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthCodeableConcept")) {
                this.strength = new CodeableConcept();
                return this.strength;
            }
            if (name.equals("strengthQuantity")) {
                this.strength = new Quantity();
                return this.strength;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIngredientComponent copy() {
            MedicationKnowledgeIngredientComponent dst = new MedicationKnowledgeIngredientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIngredientComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.isActive = this.isActive == null ? null : this.isActive.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareDeep(this.item, o.item, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.isActive, o.isActive, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareValues(this.isActive, o.isActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.isActive, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.ingredient";
        }
    }

    @Block
    public static class MedicationKnowledgeMonographComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of medication document", formalDefinition="The category of documentation about the medication. (e.g. professional monograph, patient education monograph).")
        protected CodeableConcept type;
        @Child(name="source", type={DocumentReference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
        protected Reference source;
        private static final long serialVersionUID = -197893751L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Reference();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setSource(Reference value) {
            this.source = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type));
            children.add(new Property("source", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                this.source = new Reference();
                return this.source;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonographComponent copy() {
            MedicationKnowledgeMonographComponent dst = new MedicationKnowledgeMonographComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonographComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return MedicationKnowledgeMonographComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonographComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monograph";
        }
    }

    @Block
    public static class MedicationKnowledgeRelatedMedicationKnowledgeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of medicationKnowledge", formalDefinition="The category of the associated medication knowledge reference.")
        protected CodeableConcept type;
        @Child(name="reference", type={MedicationKnowledge.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the associated medication knowledge", formalDefinition="Associated documentation about the associated medication knowledge.")
        protected List<Reference> reference;
        private static final long serialVersionUID = 1687147899L;

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent() {
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent(CodeableConcept type, Reference reference) {
            this.setType(type);
            this.addReference(reference);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRelatedMedicationKnowledgeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getReference() {
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            return this.reference;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setReference(List<Reference> theReference) {
            this.reference = theReference;
            return this;
        }

        public boolean hasReference() {
            if (this.reference == null) {
                return false;
            }
            for (Reference item : this.reference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReference() {
            Reference t = new Reference();
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return t;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent addReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return this;
        }

        public Reference getReferenceFirstRep() {
            if (this.getReference().isEmpty()) {
                this.addReference();
            }
            return this.getReference().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type));
            children.add(new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type);
                }
                case -925155509: {
                    return new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -925155509: {
                    return this.reference == null ? new Base[]{} : this.reference.toArray(new Base[this.reference.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.getReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.getReference().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -925155509: {
                    return this.addReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reference")) {
                return this.addReference();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRelatedMedicationKnowledgeComponent copy() {
            MedicationKnowledgeRelatedMedicationKnowledgeComponent dst = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRelatedMedicationKnowledgeComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.reference != null) {
                dst.reference = new ArrayList<Reference>();
                for (Reference i : this.reference) {
                    dst.reference.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.reference});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.relatedMedicationKnowledge";
        }
    }

    public static class MedicationKnowledgeStatusCodesEnumFactory
    implements EnumFactory<MedicationKnowledgeStatusCodes> {
        @Override
        public MedicationKnowledgeStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationKnowledgeStatusCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationKnowledgeStatusCodes code) {
            if (code == MedicationKnowledgeStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == MedicationKnowledgeStatusCodes.INACTIVE) {
                return "inactive";
            }
            if (code == MedicationKnowledgeStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationKnowledgeStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationKnowledgeStatusCodes {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static MedicationKnowledgeStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
                case INACTIVE: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
                case ENTEREDINERROR: {
                    return "http://terminology.hl7.org/CodeSystem/medicationknowledge-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is available for use.";
                }
                case INACTIVE: {
                    return "The medication is not available for use.";
                }
                case ENTEREDINERROR: {
                    return "The medication was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

