/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="RiskAssessment", profile="http://hl7.org/fhir/StructureDefinition/RiskAssessment")
public class RiskAssessment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for the assessment", formalDefinition="Business identifier assigned to the risk assessment.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Request fulfilled by this assessment", formalDefinition="A reference to the request that is fulfilled by this risk assessment.")
    protected Reference basedOn;
    @Child(name="parent", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Part of this occurrence", formalDefinition="A reference to a resource that this risk assessment is part of, such as a Procedure.")
    protected Reference parent;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the RiskAssessment, using the same statuses as an Observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    protected Enumeration<Enumerations.ObservationStatus> status;
    @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Evaluation mechanism", formalDefinition="The algorithm, process or mechanism used to evaluate the risk.")
    protected CodeableConcept method;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of assessment", formalDefinition="The type of the risk assessment performed.")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what does assessment apply to?", formalDefinition="The patient or group the risk assessment applies to.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where was assessment performed?", formalDefinition="The encounter where the assessment was performed.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When was assessment made?", formalDefinition="The date (and possibly time) the risk assessment was performed.")
    protected DataType occurrence;
    @Child(name="condition", type={Condition.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Condition assessed", formalDefinition="For assessments or prognosis specific to a particular condition, indicates the condition being assessed.")
    protected Reference condition;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Device.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who did assessment?", formalDefinition="The provider or software application that performed the assessment.")
    protected Reference performer;
    @Child(name="reason", type={CodeableReference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the assessment was necessary?", formalDefinition="The reason the risk assessment was performed.")
    protected List<CodeableReference> reason;
    @Child(name="basis", type={Reference.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used in assessment", formalDefinition="Indicates the source data considered as part of the assessment (for example, FamilyHistory, Observations, Procedures, Conditions, etc.).")
    protected List<Reference> basis;
    @Child(name="prediction", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Outcome predicted", formalDefinition="Describes the expected outcome for the subject.")
    protected List<RiskAssessmentPredictionComponent> prediction;
    @Child(name="mitigation", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How to reduce risk", formalDefinition="A description of the steps that might be taken to reduce the identified risk(s).")
    protected StringType mitigation;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the risk assessment", formalDefinition="Additional comments about the risk assessment.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1076114228L;
    @SearchParamDefinition(name="condition", path="RiskAssessment.condition", description="Condition assessed", type="reference", target={Condition.class})
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("RiskAssessment:condition").toLocked();
    @SearchParamDefinition(name="method", path="RiskAssessment.method", description="Evaluation mechanism", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");
    @SearchParamDefinition(name="performer", path="RiskAssessment.performer", description="Who did assessment?", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("RiskAssessment:performer").toLocked();
    @SearchParamDefinition(name="probability", path="RiskAssessment.prediction.probability", description="Likelihood of specified outcome", type="number")
    public static final String SP_PROBABILITY = "probability";
    public static final NumberClientParam PROBABILITY = new NumberClientParam("probability");
    @SearchParamDefinition(name="risk", path="RiskAssessment.prediction.qualitativeRisk", description="Likelihood of specified outcome as a qualitative value", type="token")
    public static final String SP_RISK = "risk";
    public static final TokenClientParam RISK = new TokenClientParam("risk");
    @SearchParamDefinition(name="subject", path="RiskAssessment.subject", description="Who/what does assessment apply to?", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("RiskAssessment:subject").toLocked();
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.context.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("RiskAssessment:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RiskAssessment:patient").toLocked();

    public RiskAssessment() {
    }

    public RiskAssessment(Enumerations.ObservationStatus status, Reference subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RiskAssessment setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RiskAssessment addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getBasedOn() {
        if (this.basedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.basedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.basedOn = new Reference();
            }
        }
        return this.basedOn;
    }

    public boolean hasBasedOn() {
        return this.basedOn != null && !this.basedOn.isEmpty();
    }

    public RiskAssessment setBasedOn(Reference value) {
        this.basedOn = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public RiskAssessment setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public Enumeration<Enumerations.ObservationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public RiskAssessment setStatusElement(Enumeration<Enumerations.ObservationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ObservationStatus getStatus() {
        return this.status == null ? null : (Enumerations.ObservationStatus)((Object)this.status.getValue());
    }

    public RiskAssessment setStatus(Enumerations.ObservationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public RiskAssessment setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public RiskAssessment setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public RiskAssessment setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public RiskAssessment setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public RiskAssessment setOccurrence(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for RiskAssessment.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Reference getCondition() {
        if (this.condition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.condition");
            }
            if (Configuration.doAutoCreate()) {
                this.condition = new Reference();
            }
        }
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && !this.condition.isEmpty();
    }

    public RiskAssessment setCondition(Reference value) {
        this.condition = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public RiskAssessment setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public RiskAssessment setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public RiskAssessment addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        return this.basis;
    }

    public RiskAssessment setBasis(List<Reference> theBasis) {
        this.basis = theBasis;
        return this;
    }

    public boolean hasBasis() {
        if (this.basis == null) {
            return false;
        }
        for (Reference item : this.basis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasis() {
        Reference t = new Reference();
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return t;
    }

    public RiskAssessment addBasis(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        this.basis.add(t);
        return this;
    }

    public Reference getBasisFirstRep() {
        if (this.getBasis().isEmpty()) {
            this.addBasis();
        }
        return this.getBasis().get(0);
    }

    public List<RiskAssessmentPredictionComponent> getPrediction() {
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        return this.prediction;
    }

    public RiskAssessment setPrediction(List<RiskAssessmentPredictionComponent> thePrediction) {
        this.prediction = thePrediction;
        return this;
    }

    public boolean hasPrediction() {
        if (this.prediction == null) {
            return false;
        }
        for (RiskAssessmentPredictionComponent item : this.prediction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RiskAssessmentPredictionComponent addPrediction() {
        RiskAssessmentPredictionComponent t = new RiskAssessmentPredictionComponent();
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return t;
    }

    public RiskAssessment addPrediction(RiskAssessmentPredictionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
        }
        this.prediction.add(t);
        return this;
    }

    public RiskAssessmentPredictionComponent getPredictionFirstRep() {
        if (this.getPrediction().isEmpty()) {
            this.addPrediction();
        }
        return this.getPrediction().get(0);
    }

    public StringType getMitigationElement() {
        if (this.mitigation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RiskAssessment.mitigation");
            }
            if (Configuration.doAutoCreate()) {
                this.mitigation = new StringType();
            }
        }
        return this.mitigation;
    }

    public boolean hasMitigationElement() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public boolean hasMitigation() {
        return this.mitigation != null && !this.mitigation.isEmpty();
    }

    public RiskAssessment setMitigationElement(StringType value) {
        this.mitigation = value;
        return this;
    }

    public String getMitigation() {
        return this.mitigation == null ? null : (String)this.mitigation.getValue();
    }

    public RiskAssessment setMitigation(String value) {
        if (Utilities.noString((String)value)) {
            this.mitigation = null;
        } else {
            if (this.mitigation == null) {
                this.mitigation = new StringType();
            }
            this.mitigation.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public RiskAssessment setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public RiskAssessment addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the risk assessment.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(Any)", "A reference to the request that is fulfilled by this risk assessment.", 0, 1, this.basedOn));
        children.add(new Property("parent", "Reference(Any)", "A reference to a resource that this risk assessment is part of, such as a Procedure.", 0, 1, this.parent));
        children.add(new Property("status", "code", "The status of the RiskAssessment, using the same statuses as an Observation.", 0, 1, this.status));
        children.add(new Property(SP_METHOD, "CodeableConcept", "The algorithm, process or mechanism used to evaluate the risk.", 0, 1, this.method));
        children.add(new Property("code", "CodeableConcept", "The type of the risk assessment performed.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group the risk assessment applies to.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter where the assessment was performed.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence));
        children.add(new Property(SP_CONDITION, "Reference(Condition)", "For assessments or prognosis specific to a particular condition, indicates the condition being assessed.", 0, 1, this.condition));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Device)", "The provider or software application that performed the assessment.", 0, 1, this.performer));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "The reason the risk assessment was performed.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("basis", "Reference(Any)", "Indicates the source data considered as part of the assessment (for example, FamilyHistory, Observations, Procedures, Conditions, etc.).", 0, Integer.MAX_VALUE, this.basis));
        children.add(new Property("prediction", "", "Describes the expected outcome for the subject.", 0, Integer.MAX_VALUE, this.prediction));
        children.add(new Property("mitigation", "string", "A description of the steps that might be taken to reduce the identified risk(s).", 0, 1, this.mitigation));
        children.add(new Property("note", "Annotation", "Additional comments about the risk assessment.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the risk assessment.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "A reference to the request that is fulfilled by this risk assessment.", 0, 1, this.basedOn);
            }
            case -995424086: {
                return new Property("parent", "Reference(Any)", "A reference to a resource that this risk assessment is part of, such as a Procedure.", 0, 1, this.parent);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the RiskAssessment, using the same statuses as an Observation.", 0, 1, this.status);
            }
            case -1077554975: {
                return new Property(SP_METHOD, "CodeableConcept", "The algorithm, process or mechanism used to evaluate the risk.", 0, 1, this.method);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The type of the risk assessment performed.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group the risk assessment applies to.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter where the assessment was performed.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The date (and possibly time) the risk assessment was performed.", 0, 1, this.occurrence);
            }
            case -861311717: {
                return new Property(SP_CONDITION, "Reference(Condition)", "For assessments or prognosis specific to a particular condition, indicates the condition being assessed.", 0, 1, this.condition);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Device)", "The provider or software application that performed the assessment.", 0, 1, this.performer);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "The reason the risk assessment was performed.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 93508670: {
                return new Property("basis", "Reference(Any)", "Indicates the source data considered as part of the assessment (for example, FamilyHistory, Observations, Procedures, Conditions, etc.).", 0, Integer.MAX_VALUE, this.basis);
            }
            case 1161234575: {
                return new Property("prediction", "", "Describes the expected outcome for the subject.", 0, Integer.MAX_VALUE, this.prediction);
            }
            case 1293793087: {
                return new Property("mitigation", "string", "A description of the steps that might be taken to reduce the identified risk(s).", 0, 1, this.mitigation);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional comments about the risk assessment.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                Base[] baseArray;
                if (this.basedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.basedOn;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.parent;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.method;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.occurrence;
                }
                return baseArray;
            }
            case -861311717: {
                Base[] baseArray;
                if (this.condition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.condition;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.performer;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 93508670: {
                return this.basis == null ? new Base[]{} : this.basis.toArray(new Base[this.basis.size()]);
            }
            case 1161234575: {
                return this.prediction == null ? new Base[]{} : this.prediction.toArray(new Base[this.prediction.size()]);
            }
            case 1293793087: {
                Base[] baseArray;
                if (this.mitigation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.mitigation;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.basedOn = TypeConvertor.castToReference(value);
                return value;
            }
            case -995424086: {
                this.parent = TypeConvertor.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.ObservationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1077554975: {
                this.method = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -861311717: {
                this.condition = TypeConvertor.castToReference(value);
                return value;
            }
            case 481140686: {
                this.performer = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 93508670: {
                this.getBasis().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1161234575: {
                this.getPrediction().add((RiskAssessmentPredictionComponent)((Object)value));
                return value;
            }
            case 1293793087: {
                this.mitigation = TypeConvertor.castToString(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.basedOn = TypeConvertor.castToReference(value);
        } else if (name.equals("parent")) {
            this.parent = TypeConvertor.castToReference(value);
        } else if (name.equals("status")) {
            value = new Enumerations.ObservationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_METHOD)) {
            this.method = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals(SP_CONDITION)) {
            this.condition = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("basis")) {
            this.getBasis().add(TypeConvertor.castToReference(value));
        } else if (name.equals("prediction")) {
            this.getPrediction().add((RiskAssessmentPredictionComponent)((Object)value));
        } else if (name.equals("mitigation")) {
            this.mitigation = TypeConvertor.castToString(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.getBasedOn();
            }
            case -995424086: {
                return this.getParent();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -861311717: {
                return this.getCondition();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -934964668: {
                return this.addReason();
            }
            case 93508670: {
                return this.addBasis();
            }
            case 1161234575: {
                return this.addPrediction();
            }
            case 1293793087: {
                return this.getMitigationElement();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -861311717: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 93508670: {
                return new String[]{"Reference"};
            }
            case 1161234575: {
                return new String[0];
            }
            case 1293793087: {
                return new String[]{"string"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            this.basedOn = new Reference();
            return this.basedOn;
        }
        if (name.equals("parent")) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.status");
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals(SP_CONDITION)) {
            this.condition = new Reference();
            return this.condition;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("basis")) {
            return this.addBasis();
        }
        if (name.equals("prediction")) {
            return this.addPrediction();
        }
        if (name.equals("mitigation")) {
            throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.mitigation");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RiskAssessment";
    }

    @Override
    public RiskAssessment copy() {
        RiskAssessment dst = new RiskAssessment();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RiskAssessment dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.basedOn = this.basedOn == null ? null : this.basedOn.copy();
        dst.parent = this.parent == null ? null : this.parent.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.condition = this.condition == null ? null : this.condition.copy();
        Reference reference = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.basis != null) {
            dst.basis = new ArrayList<Reference>();
            for (Reference reference2 : this.basis) {
                dst.basis.add(reference2.copy());
            }
        }
        if (this.prediction != null) {
            dst.prediction = new ArrayList<RiskAssessmentPredictionComponent>();
            for (RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : this.prediction) {
                dst.prediction.add(riskAssessmentPredictionComponent.copy());
            }
        }
        StringType stringType = dst.mitigation = this.mitigation == null ? null : this.mitigation.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected RiskAssessment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other_;
        return RiskAssessment.compareDeep(this.identifier, o.identifier, true) && RiskAssessment.compareDeep(this.basedOn, o.basedOn, true) && RiskAssessment.compareDeep(this.parent, o.parent, true) && RiskAssessment.compareDeep(this.status, o.status, true) && RiskAssessment.compareDeep(this.method, o.method, true) && RiskAssessment.compareDeep(this.code, o.code, true) && RiskAssessment.compareDeep(this.subject, o.subject, true) && RiskAssessment.compareDeep(this.encounter, o.encounter, true) && RiskAssessment.compareDeep(this.occurrence, o.occurrence, true) && RiskAssessment.compareDeep(this.condition, o.condition, true) && RiskAssessment.compareDeep(this.performer, o.performer, true) && RiskAssessment.compareDeep(this.reason, o.reason, true) && RiskAssessment.compareDeep(this.basis, o.basis, true) && RiskAssessment.compareDeep(this.prediction, o.prediction, true) && RiskAssessment.compareDeep(this.mitigation, o.mitigation, true) && RiskAssessment.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RiskAssessment)) {
            return false;
        }
        RiskAssessment o = (RiskAssessment)other_;
        return RiskAssessment.compareValues(this.status, o.status, true) && RiskAssessment.compareValues(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.parent, this.status, this.method, this.code, this.subject, this.encounter, this.occurrence, this.condition, this.performer, this.reason, this.basis, this.prediction, this.mitigation, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RiskAssessment;
    }

    @Block
    public static class RiskAssessmentPredictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outcome", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Possible outcome for the subject", formalDefinition="One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).")
        protected CodeableConcept outcome;
        @Child(name="probability", type={DecimalType.class, Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Likelihood of specified outcome", formalDefinition="Indicates how likely the outcome is (in the specified timeframe).")
        protected DataType probability;
        @Child(name="qualitativeRisk", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Likelihood of specified outcome as a qualitative value", formalDefinition="Indicates how likely the outcome is (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, or high).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/risk-probability")
        protected CodeableConcept qualitativeRisk;
        @Child(name="relativeRisk", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relative likelihood", formalDefinition="Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).")
        protected DecimalType relativeRisk;
        @Child(name="when", type={Period.class, Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Timeframe or age range", formalDefinition="Indicates the period of time or age range of the subject to which the specified probability applies.")
        protected DataType when;
        @Child(name="rationale", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of prediction", formalDefinition="Additional information explaining the basis for the prediction.")
        protected StringType rationale;
        private static final long serialVersionUID = -1559504257L;

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public RiskAssessmentPredictionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public DataType getProbability() {
            return this.probability;
        }

        public DecimalType getProbabilityDecimalType() throws FHIRException {
            if (this.probability == null) {
                this.probability = new DecimalType();
            }
            if (!(this.probability instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.probability;
        }

        public boolean hasProbabilityDecimalType() {
            return this != null && this.probability instanceof DecimalType;
        }

        public Range getProbabilityRange() throws FHIRException {
            if (this.probability == null) {
                this.probability = new Range();
            }
            if (!(this.probability instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.probability.getClass().getName() + " was encountered");
            }
            return (Range)this.probability;
        }

        public boolean hasProbabilityRange() {
            return this != null && this.probability instanceof Range;
        }

        public boolean hasProbability() {
            return this.probability != null && !this.probability.isEmpty();
        }

        public RiskAssessmentPredictionComponent setProbability(DataType value) {
            if (value != null && !(value instanceof DecimalType) && !(value instanceof Range)) {
                throw new Error("Not the right type for RiskAssessment.prediction.probability[x]: " + value.fhirType());
            }
            this.probability = value;
            return this;
        }

        public CodeableConcept getQualitativeRisk() {
            if (this.qualitativeRisk == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.qualitativeRisk");
                }
                if (Configuration.doAutoCreate()) {
                    this.qualitativeRisk = new CodeableConcept();
                }
            }
            return this.qualitativeRisk;
        }

        public boolean hasQualitativeRisk() {
            return this.qualitativeRisk != null && !this.qualitativeRisk.isEmpty();
        }

        public RiskAssessmentPredictionComponent setQualitativeRisk(CodeableConcept value) {
            this.qualitativeRisk = value;
            return this;
        }

        public DecimalType getRelativeRiskElement() {
            if (this.relativeRisk == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.relativeRisk");
                }
                if (Configuration.doAutoCreate()) {
                    this.relativeRisk = new DecimalType();
                }
            }
            return this.relativeRisk;
        }

        public boolean hasRelativeRiskElement() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public boolean hasRelativeRisk() {
            return this.relativeRisk != null && !this.relativeRisk.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRelativeRiskElement(DecimalType value) {
            this.relativeRisk = value;
            return this;
        }

        public BigDecimal getRelativeRisk() {
            return this.relativeRisk == null ? null : (BigDecimal)this.relativeRisk.getValue();
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(BigDecimal value) {
            if (value == null) {
                this.relativeRisk = null;
            } else {
                if (this.relativeRisk == null) {
                    this.relativeRisk = new DecimalType();
                }
                this.relativeRisk.setValue(value);
            }
            return this;
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(long value) {
            this.relativeRisk = new DecimalType();
            this.relativeRisk.setValue(value);
            return this;
        }

        public RiskAssessmentPredictionComponent setRelativeRisk(double value) {
            this.relativeRisk = new DecimalType();
            this.relativeRisk.setValue(value);
            return this;
        }

        public DataType getWhen() {
            return this.when;
        }

        public Period getWhenPeriod() throws FHIRException {
            if (this.when == null) {
                this.when = new Period();
            }
            if (!(this.when instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Period)this.when;
        }

        public boolean hasWhenPeriod() {
            return this != null && this.when instanceof Period;
        }

        public Range getWhenRange() throws FHIRException {
            if (this.when == null) {
                this.when = new Range();
            }
            if (!(this.when instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Range)this.when;
        }

        public boolean hasWhenRange() {
            return this != null && this.when instanceof Range;
        }

        public boolean hasWhen() {
            return this.when != null && !this.when.isEmpty();
        }

        public RiskAssessmentPredictionComponent setWhen(DataType value) {
            if (value != null && !(value instanceof Period) && !(value instanceof Range)) {
                throw new Error("Not the right type for RiskAssessment.prediction.when[x]: " + value.fhirType());
            }
            this.when = value;
            return this;
        }

        public StringType getRationaleElement() {
            if (this.rationale == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RiskAssessmentPredictionComponent.rationale");
                }
                if (Configuration.doAutoCreate()) {
                    this.rationale = new StringType();
                }
            }
            return this.rationale;
        }

        public boolean hasRationaleElement() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public boolean hasRationale() {
            return this.rationale != null && !this.rationale.isEmpty();
        }

        public RiskAssessmentPredictionComponent setRationaleElement(StringType value) {
            this.rationale = value;
            return this;
        }

        public String getRationale() {
            return this.rationale == null ? null : (String)this.rationale.getValue();
        }

        public RiskAssessmentPredictionComponent setRationale(String value) {
            if (Utilities.noString((String)value)) {
                this.rationale = null;
            } else {
                if (this.rationale == null) {
                    this.rationale = new StringType();
                }
                this.rationale.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outcome", "CodeableConcept", "One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).", 0, 1, this.outcome));
            children.add(new Property("probability[x]", "decimal|Range", "Indicates how likely the outcome is (in the specified timeframe).", 0, 1, this.probability));
            children.add(new Property("qualitativeRisk", "CodeableConcept", "Indicates how likely the outcome is (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, or high).", 0, 1, this.qualitativeRisk));
            children.add(new Property("relativeRisk", "decimal", "Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).", 0, 1, this.relativeRisk));
            children.add(new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when));
            children.add(new Property("rationale", "string", "Additional information explaining the basis for the prediction.", 0, 1, this.rationale));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1106507950: {
                    return new Property("outcome", "CodeableConcept", "One of the potential outcomes for the patient (e.g. remission, death,  a particular condition).", 0, 1, this.outcome);
                }
                case 1430185003: {
                    return new Property("probability[x]", "decimal|Range", "Indicates how likely the outcome is (in the specified timeframe).", 0, 1, this.probability);
                }
                case -1290561483: {
                    return new Property("probability[x]", "decimal|Range", "Indicates how likely the outcome is (in the specified timeframe).", 0, 1, this.probability);
                }
                case 888495452: {
                    return new Property("probability[x]", "decimal", "Indicates how likely the outcome is (in the specified timeframe).", 0, 1, this.probability);
                }
                case 9275912: {
                    return new Property("probability[x]", "Range", "Indicates how likely the outcome is (in the specified timeframe).", 0, 1, this.probability);
                }
                case 123308730: {
                    return new Property("qualitativeRisk", "CodeableConcept", "Indicates how likely the outcome is (in the specified timeframe), expressed as a qualitative value (e.g. low, medium, or high).", 0, 1, this.qualitativeRisk);
                }
                case -70741061: {
                    return new Property("relativeRisk", "decimal", "Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.).", 0, 1, this.relativeRisk);
                }
                case 1312831238: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 3648314: {
                    return new Property("when[x]", "Period|Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 251476379: {
                    return new Property("when[x]", "Period", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case -1098542557: {
                    return new Property("when[x]", "Range", "Indicates the period of time or age range of the subject to which the specified probability applies.", 0, 1, this.when);
                }
                case 345689335: {
                    return new Property("rationale", "string", "Additional information explaining the basis for the prediction.", 0, 1, this.rationale);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.outcome;
                    }
                    return baseArray;
                }
                case -1290561483: {
                    Base[] baseArray;
                    if (this.probability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.probability;
                    }
                    return baseArray;
                }
                case 123308730: {
                    Base[] baseArray;
                    if (this.qualitativeRisk == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.qualitativeRisk;
                    }
                    return baseArray;
                }
                case -70741061: {
                    Base[] baseArray;
                    if (this.relativeRisk == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.relativeRisk;
                    }
                    return baseArray;
                }
                case 3648314: {
                    Base[] baseArray;
                    if (this.when == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.when;
                    }
                    return baseArray;
                }
                case 345689335: {
                    Base[] baseArray;
                    if (this.rationale == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.rationale;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    this.outcome = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1290561483: {
                    this.probability = TypeConvertor.castToType(value);
                    return value;
                }
                case 123308730: {
                    this.qualitativeRisk = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -70741061: {
                    this.relativeRisk = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 3648314: {
                    this.when = TypeConvertor.castToType(value);
                    return value;
                }
                case 345689335: {
                    this.rationale = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("probability[x]")) {
                this.probability = TypeConvertor.castToType(value);
            } else if (name.equals("qualitativeRisk")) {
                this.qualitativeRisk = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("relativeRisk")) {
                this.relativeRisk = TypeConvertor.castToDecimal(value);
            } else if (name.equals("when[x]")) {
                this.when = TypeConvertor.castToType(value);
            } else if (name.equals("rationale")) {
                this.rationale = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    return this.getOutcome();
                }
                case 1430185003: {
                    return this.getProbability();
                }
                case -1290561483: {
                    return this.getProbability();
                }
                case 123308730: {
                    return this.getQualitativeRisk();
                }
                case -70741061: {
                    return this.getRelativeRiskElement();
                }
                case 1312831238: {
                    return this.getWhen();
                }
                case 3648314: {
                    return this.getWhen();
                }
                case 345689335: {
                    return this.getRationaleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1106507950: {
                    return new String[]{"CodeableConcept"};
                }
                case -1290561483: {
                    return new String[]{"decimal", "Range"};
                }
                case 123308730: {
                    return new String[]{"CodeableConcept"};
                }
                case -70741061: {
                    return new String[]{"decimal"};
                }
                case 3648314: {
                    return new String[]{"Period", "Range"};
                }
                case 345689335: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("probabilityDecimal")) {
                this.probability = new DecimalType();
                return this.probability;
            }
            if (name.equals("probabilityRange")) {
                this.probability = new Range();
                return this.probability;
            }
            if (name.equals("qualitativeRisk")) {
                this.qualitativeRisk = new CodeableConcept();
                return this.qualitativeRisk;
            }
            if (name.equals("relativeRisk")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.prediction.relativeRisk");
            }
            if (name.equals("whenPeriod")) {
                this.when = new Period();
                return this.when;
            }
            if (name.equals("whenRange")) {
                this.when = new Range();
                return this.when;
            }
            if (name.equals("rationale")) {
                throw new FHIRException("Cannot call addChild on a primitive type RiskAssessment.prediction.rationale");
            }
            return super.addChild(name);
        }

        @Override
        public RiskAssessmentPredictionComponent copy() {
            RiskAssessmentPredictionComponent dst = new RiskAssessmentPredictionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RiskAssessmentPredictionComponent dst) {
            super.copyValues(dst);
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.probability = this.probability == null ? null : this.probability.copy();
            dst.qualitativeRisk = this.qualitativeRisk == null ? null : this.qualitativeRisk.copy();
            dst.relativeRisk = this.relativeRisk == null ? null : this.relativeRisk.copy();
            dst.when = this.when == null ? null : this.when.copy();
            dst.rationale = this.rationale == null ? null : this.rationale.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other_;
            return RiskAssessmentPredictionComponent.compareDeep(this.outcome, o.outcome, true) && RiskAssessmentPredictionComponent.compareDeep(this.probability, o.probability, true) && RiskAssessmentPredictionComponent.compareDeep(this.qualitativeRisk, o.qualitativeRisk, true) && RiskAssessmentPredictionComponent.compareDeep(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareDeep(this.when, o.when, true) && RiskAssessmentPredictionComponent.compareDeep(this.rationale, o.rationale, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RiskAssessmentPredictionComponent)) {
                return false;
            }
            RiskAssessmentPredictionComponent o = (RiskAssessmentPredictionComponent)other_;
            return RiskAssessmentPredictionComponent.compareValues(this.relativeRisk, o.relativeRisk, true) && RiskAssessmentPredictionComponent.compareValues(this.rationale, o.rationale, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.outcome, this.probability, this.qualitativeRisk, this.relativeRisk, this.when, this.rationale});
        }

        @Override
        public String fhirType() {
            return "RiskAssessment.prediction";
        }
    }
}

