/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceAmount;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstancePolymer", profile="http://hl7.org/fhir/StructureDefinition/SubstancePolymer")
public class SubstancePolymer
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected Identifier identifier;
    @Child(name="class", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected CodeableConcept class_;
    @Child(name="geometry", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected CodeableConcept geometry;
    @Child(name="copolymerConnectivity", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<CodeableConcept> copolymerConnectivity;
    @Child(name="modification", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo. This is intended to connect to a repeating full modification structure, also used by Protein and Nucleic Acid . String is just a placeholder", formalDefinition="Todo. This is intended to connect to a repeating full modification structure, also used by Protein and Nucleic Acid . String is just a placeholder.")
    protected StringType modification;
    @Child(name="monomerSet", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstancePolymerMonomerSetComponent> monomerSet;
    @Child(name="repeat", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected List<SubstancePolymerRepeatComponent> repeat;
    private static final long serialVersionUID = 11937102L;

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstancePolymer.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SubstancePolymer setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstancePolymer.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new CodeableConcept();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public SubstancePolymer setClass_(CodeableConcept value) {
        this.class_ = value;
        return this;
    }

    public CodeableConcept getGeometry() {
        if (this.geometry == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstancePolymer.geometry");
            }
            if (Configuration.doAutoCreate()) {
                this.geometry = new CodeableConcept();
            }
        }
        return this.geometry;
    }

    public boolean hasGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public SubstancePolymer setGeometry(CodeableConcept value) {
        this.geometry = value;
        return this;
    }

    public List<CodeableConcept> getCopolymerConnectivity() {
        if (this.copolymerConnectivity == null) {
            this.copolymerConnectivity = new ArrayList<CodeableConcept>();
        }
        return this.copolymerConnectivity;
    }

    public SubstancePolymer setCopolymerConnectivity(List<CodeableConcept> theCopolymerConnectivity) {
        this.copolymerConnectivity = theCopolymerConnectivity;
        return this;
    }

    public boolean hasCopolymerConnectivity() {
        if (this.copolymerConnectivity == null) {
            return false;
        }
        for (CodeableConcept item : this.copolymerConnectivity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCopolymerConnectivity() {
        CodeableConcept t = new CodeableConcept();
        if (this.copolymerConnectivity == null) {
            this.copolymerConnectivity = new ArrayList<CodeableConcept>();
        }
        this.copolymerConnectivity.add(t);
        return t;
    }

    public SubstancePolymer addCopolymerConnectivity(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.copolymerConnectivity == null) {
            this.copolymerConnectivity = new ArrayList<CodeableConcept>();
        }
        this.copolymerConnectivity.add(t);
        return this;
    }

    public CodeableConcept getCopolymerConnectivityFirstRep() {
        if (this.getCopolymerConnectivity().isEmpty()) {
            this.addCopolymerConnectivity();
        }
        return this.getCopolymerConnectivity().get(0);
    }

    public StringType getModificationElement() {
        if (this.modification == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstancePolymer.modification");
            }
            if (Configuration.doAutoCreate()) {
                this.modification = new StringType();
            }
        }
        return this.modification;
    }

    public boolean hasModificationElement() {
        return this.modification != null && !this.modification.isEmpty();
    }

    public boolean hasModification() {
        return this.modification != null && !this.modification.isEmpty();
    }

    public SubstancePolymer setModificationElement(StringType value) {
        this.modification = value;
        return this;
    }

    public String getModification() {
        return this.modification == null ? null : (String)this.modification.getValue();
    }

    public SubstancePolymer setModification(String value) {
        if (Utilities.noString((String)value)) {
            this.modification = null;
        } else {
            if (this.modification == null) {
                this.modification = new StringType();
            }
            this.modification.setValue(value);
        }
        return this;
    }

    public List<SubstancePolymerMonomerSetComponent> getMonomerSet() {
        if (this.monomerSet == null) {
            this.monomerSet = new ArrayList<SubstancePolymerMonomerSetComponent>();
        }
        return this.monomerSet;
    }

    public SubstancePolymer setMonomerSet(List<SubstancePolymerMonomerSetComponent> theMonomerSet) {
        this.monomerSet = theMonomerSet;
        return this;
    }

    public boolean hasMonomerSet() {
        if (this.monomerSet == null) {
            return false;
        }
        for (SubstancePolymerMonomerSetComponent item : this.monomerSet) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstancePolymerMonomerSetComponent addMonomerSet() {
        SubstancePolymerMonomerSetComponent t = new SubstancePolymerMonomerSetComponent();
        if (this.monomerSet == null) {
            this.monomerSet = new ArrayList<SubstancePolymerMonomerSetComponent>();
        }
        this.monomerSet.add(t);
        return t;
    }

    public SubstancePolymer addMonomerSet(SubstancePolymerMonomerSetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monomerSet == null) {
            this.monomerSet = new ArrayList<SubstancePolymerMonomerSetComponent>();
        }
        this.monomerSet.add(t);
        return this;
    }

    public SubstancePolymerMonomerSetComponent getMonomerSetFirstRep() {
        if (this.getMonomerSet().isEmpty()) {
            this.addMonomerSet();
        }
        return this.getMonomerSet().get(0);
    }

    public List<SubstancePolymerRepeatComponent> getRepeat() {
        if (this.repeat == null) {
            this.repeat = new ArrayList<SubstancePolymerRepeatComponent>();
        }
        return this.repeat;
    }

    public SubstancePolymer setRepeat(List<SubstancePolymerRepeatComponent> theRepeat) {
        this.repeat = theRepeat;
        return this;
    }

    public boolean hasRepeat() {
        if (this.repeat == null) {
            return false;
        }
        for (SubstancePolymerRepeatComponent item : this.repeat) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstancePolymerRepeatComponent addRepeat() {
        SubstancePolymerRepeatComponent t = new SubstancePolymerRepeatComponent();
        if (this.repeat == null) {
            this.repeat = new ArrayList<SubstancePolymerRepeatComponent>();
        }
        this.repeat.add(t);
        return t;
    }

    public SubstancePolymer addRepeat(SubstancePolymerRepeatComponent t) {
        if (t == null) {
            return this;
        }
        if (this.repeat == null) {
            this.repeat = new ArrayList<SubstancePolymerRepeatComponent>();
        }
        this.repeat.add(t);
        return this;
    }

    public SubstancePolymerRepeatComponent getRepeatFirstRep() {
        if (this.getRepeat().isEmpty()) {
            this.addRepeat();
        }
        return this.getRepeat().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Todo.", 0, 1, this.identifier));
        children.add(new Property("class", "CodeableConcept", "Todo.", 0, 1, this.class_));
        children.add(new Property("geometry", "CodeableConcept", "Todo.", 0, 1, this.geometry));
        children.add(new Property("copolymerConnectivity", "CodeableConcept", "Todo.", 0, Integer.MAX_VALUE, this.copolymerConnectivity));
        children.add(new Property("modification", "string", "Todo. This is intended to connect to a repeating full modification structure, also used by Protein and Nucleic Acid . String is just a placeholder.", 0, 1, this.modification));
        children.add(new Property("monomerSet", "", "Todo.", 0, Integer.MAX_VALUE, this.monomerSet));
        children.add(new Property("repeat", "", "Todo.", 0, Integer.MAX_VALUE, this.repeat));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Todo.", 0, 1, this.identifier);
            }
            case 94742904: {
                return new Property("class", "CodeableConcept", "Todo.", 0, 1, this.class_);
            }
            case 1846020210: {
                return new Property("geometry", "CodeableConcept", "Todo.", 0, 1, this.geometry);
            }
            case 997107577: {
                return new Property("copolymerConnectivity", "CodeableConcept", "Todo.", 0, Integer.MAX_VALUE, this.copolymerConnectivity);
            }
            case -684600932: {
                return new Property("modification", "string", "Todo. This is intended to connect to a repeating full modification structure, also used by Protein and Nucleic Acid . String is just a placeholder.", 0, 1, this.modification);
            }
            case -1622483765: {
                return new Property("monomerSet", "", "Todo.", 0, Integer.MAX_VALUE, this.monomerSet);
            }
            case -934531685: {
                return new Property("repeat", "", "Todo.", 0, Integer.MAX_VALUE, this.repeat);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.class_;
                }
                return baseArray;
            }
            case 1846020210: {
                Base[] baseArray;
                if (this.geometry == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.geometry;
                }
                return baseArray;
            }
            case 997107577: {
                return this.copolymerConnectivity == null ? new Base[]{} : this.copolymerConnectivity.toArray(new Base[this.copolymerConnectivity.size()]);
            }
            case -684600932: {
                Base[] baseArray;
                if (this.modification == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.modification;
                }
                return baseArray;
            }
            case -1622483765: {
                return this.monomerSet == null ? new Base[]{} : this.monomerSet.toArray(new Base[this.monomerSet.size()]);
            }
            case -934531685: {
                return this.repeat == null ? new Base[]{} : this.repeat.toArray(new Base[this.repeat.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 94742904: {
                this.class_ = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1846020210: {
                this.geometry = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 997107577: {
                this.getCopolymerConnectivity().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -684600932: {
                this.modification = TypeConvertor.castToString(value);
                return value;
            }
            case -1622483765: {
                this.getMonomerSet().add((SubstancePolymerMonomerSetComponent)value);
                return value;
            }
            case -934531685: {
                this.getRepeat().add((SubstancePolymerRepeatComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("class")) {
            this.class_ = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("geometry")) {
            this.geometry = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("copolymerConnectivity")) {
            this.getCopolymerConnectivity().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("modification")) {
            this.modification = TypeConvertor.castToString(value);
        } else if (name.equals("monomerSet")) {
            this.getMonomerSet().add((SubstancePolymerMonomerSetComponent)value);
        } else if (name.equals("repeat")) {
            this.getRepeat().add((SubstancePolymerRepeatComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 94742904: {
                return this.getClass_();
            }
            case 1846020210: {
                return this.getGeometry();
            }
            case 997107577: {
                return this.addCopolymerConnectivity();
            }
            case -684600932: {
                return this.getModificationElement();
            }
            case -1622483765: {
                return this.addMonomerSet();
            }
            case -934531685: {
                return this.addRepeat();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case 1846020210: {
                return new String[]{"CodeableConcept"};
            }
            case 997107577: {
                return new String[]{"CodeableConcept"};
            }
            case -684600932: {
                return new String[]{"string"};
            }
            case -1622483765: {
                return new String[0];
            }
            case -934531685: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("class")) {
            this.class_ = new CodeableConcept();
            return this.class_;
        }
        if (name.equals("geometry")) {
            this.geometry = new CodeableConcept();
            return this.geometry;
        }
        if (name.equals("copolymerConnectivity")) {
            return this.addCopolymerConnectivity();
        }
        if (name.equals("modification")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.modification");
        }
        if (name.equals("monomerSet")) {
            return this.addMonomerSet();
        }
        if (name.equals("repeat")) {
            return this.addRepeat();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstancePolymer";
    }

    @Override
    public SubstancePolymer copy() {
        SubstancePolymer dst = new SubstancePolymer();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstancePolymer dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.class_ = this.class_ == null ? null : this.class_.copy();
        CodeableConcept codeableConcept = dst.geometry = this.geometry == null ? null : this.geometry.copy();
        if (this.copolymerConnectivity != null) {
            dst.copolymerConnectivity = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.copolymerConnectivity) {
                dst.copolymerConnectivity.add(codeableConcept2.copy());
            }
        }
        StringType stringType = dst.modification = this.modification == null ? null : this.modification.copy();
        if (this.monomerSet != null) {
            dst.monomerSet = new ArrayList<SubstancePolymerMonomerSetComponent>();
            for (SubstancePolymerMonomerSetComponent substancePolymerMonomerSetComponent : this.monomerSet) {
                dst.monomerSet.add(substancePolymerMonomerSetComponent.copy());
            }
        }
        if (this.repeat != null) {
            dst.repeat = new ArrayList<SubstancePolymerRepeatComponent>();
            for (SubstancePolymerRepeatComponent substancePolymerRepeatComponent : this.repeat) {
                dst.repeat.add(substancePolymerRepeatComponent.copy());
            }
        }
    }

    protected SubstancePolymer typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstancePolymer)) {
            return false;
        }
        SubstancePolymer o = (SubstancePolymer)other_;
        return SubstancePolymer.compareDeep(this.identifier, o.identifier, true) && SubstancePolymer.compareDeep(this.class_, o.class_, true) && SubstancePolymer.compareDeep(this.geometry, o.geometry, true) && SubstancePolymer.compareDeep(this.copolymerConnectivity, o.copolymerConnectivity, true) && SubstancePolymer.compareDeep(this.modification, o.modification, true) && SubstancePolymer.compareDeep(this.monomerSet, o.monomerSet, true) && SubstancePolymer.compareDeep(this.repeat, o.repeat, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstancePolymer)) {
            return false;
        }
        SubstancePolymer o = (SubstancePolymer)other_;
        return SubstancePolymer.compareValues(this.modification, o.modification, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.class_, this.geometry, this.copolymerConnectivity, this.modification, this.monomerSet, this.repeat});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstancePolymer;
    }

    @Block
    public static class SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept type;
        @Child(name="representation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected StringType representation;
        @Child(name="format", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept format;
        @Child(name="attachment", type={Attachment.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected Attachment attachment;
        private static final long serialVersionUID = -1385695515L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRepresentationElement() {
            if (this.representation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.representation");
                }
                if (Configuration.doAutoCreate()) {
                    this.representation = new StringType();
                }
            }
            return this.representation;
        }

        public boolean hasRepresentationElement() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public boolean hasRepresentation() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent setRepresentationElement(StringType value) {
            this.representation = value;
            return this;
        }

        public String getRepresentation() {
            return this.representation == null ? null : (String)this.representation.getValue();
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent setRepresentation(String value) {
            if (Utilities.noString((String)value)) {
                this.representation = null;
            } else {
                if (this.representation == null) {
                    this.representation = new StringType();
                }
                this.representation.setValue(value);
            }
            return this;
        }

        public CodeableConcept getFormat() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new CodeableConcept();
                }
            }
            return this.format;
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent setFormat(CodeableConcept value) {
            this.format = value;
            return this;
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type));
            children.add(new Property("representation", "string", "Todo.", 0, 1, this.representation));
            children.add(new Property("format", "CodeableConcept", "Todo.", 0, 1, this.format));
            children.add(new Property("attachment", "Attachment", "Todo.", 0, 1, this.attachment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Todo.", 0, 1, this.type);
                }
                case -671065907: {
                    return new Property("representation", "string", "Todo.", 0, 1, this.representation);
                }
                case -1268779017: {
                    return new Property("format", "CodeableConcept", "Todo.", 0, 1, this.format);
                }
                case -1963501277: {
                    return new Property("attachment", "Attachment", "Todo.", 0, 1, this.attachment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -671065907: {
                    Base[] baseArray;
                    if (this.representation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.representation;
                    }
                    return baseArray;
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.format;
                    }
                    return baseArray;
                }
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.attachment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -671065907: {
                    this.representation = TypeConvertor.castToString(value);
                    return value;
                }
                case -1268779017: {
                    this.format = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1963501277: {
                    this.attachment = TypeConvertor.castToAttachment(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("representation")) {
                this.representation = TypeConvertor.castToString(value);
            } else if (name.equals("format")) {
                this.format = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("attachment")) {
                this.attachment = TypeConvertor.castToAttachment(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -671065907: {
                    return this.getRepresentationElement();
                }
                case -1268779017: {
                    return this.getFormat();
                }
                case -1963501277: {
                    return this.getAttachment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -671065907: {
                    return new String[]{"string"};
                }
                case -1268779017: {
                    return new String[]{"CodeableConcept"};
                }
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("representation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.repeat.repeatUnit.structuralRepresentation.representation");
            }
            if (name.equals("format")) {
                this.format = new CodeableConcept();
                return this.format;
            }
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent copy() {
            SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent dst = new SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.representation = this.representation == null ? null : this.representation.copy();
            dst.format = this.format == null ? null : this.format.copy();
            dst.attachment = this.attachment == null ? null : this.attachment.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent o = (SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)other_;
            return SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.compareDeep(this.type, o.type, true) && SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.compareDeep(this.representation, o.representation, true) && SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.compareDeep(this.format, o.format, true) && SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.compareDeep(this.attachment, o.attachment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent o = (SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)other_;
            return SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent.compareValues(this.representation, o.representation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.representation, this.format, this.attachment});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.repeat.repeatUnit.structuralRepresentation";
        }
    }

    @Block
    public static class SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="degree", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept degree;
        @Child(name="amount", type={SubstanceAmount.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected SubstanceAmount amount;
        private static final long serialVersionUID = -1487452773L;

        public CodeableConcept getDegree() {
            if (this.degree == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent.degree");
                }
                if (Configuration.doAutoCreate()) {
                    this.degree = new CodeableConcept();
                }
            }
            return this.degree;
        }

        public boolean hasDegree() {
            return this.degree != null && !this.degree.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent setDegree(CodeableConcept value) {
            this.degree = value;
            return this;
        }

        public SubstanceAmount getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SubstanceAmount();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent setAmount(SubstanceAmount value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("degree", "CodeableConcept", "Todo.", 0, 1, this.degree));
            children.add(new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1335595316: {
                    return new Property("degree", "CodeableConcept", "Todo.", 0, 1, this.degree);
                }
                case -1413853096: {
                    return new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1335595316: {
                    Base[] baseArray;
                    if (this.degree == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.degree;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1335595316: {
                    this.degree = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToSubstanceAmount(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("degree")) {
                this.degree = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToSubstanceAmount(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335595316: {
                    return this.getDegree();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335595316: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"SubstanceAmount"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("degree")) {
                this.degree = new CodeableConcept();
                return this.degree;
            }
            if (name.equals("amount")) {
                this.amount = new SubstanceAmount();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent copy() {
            SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent dst = new SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent dst) {
            super.copyValues(dst);
            dst.degree = this.degree == null ? null : this.degree.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent o = (SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)other_;
            return SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent.compareDeep(this.degree, o.degree, true) && SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent o = (SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.degree, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.repeat.repeatUnit.degreeOfPolymerisation";
        }
    }

    @Block
    public static class SubstancePolymerRepeatRepeatUnitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="unit", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected StringType unit;
        @Child(name="orientation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept orientation;
        @Child(name="amount", type={SubstanceAmount.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected SubstanceAmount amount;
        @Child(name="degreeOfPolymerisation", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent> degreeOfPolymerisation;
        @Child(name="structuralRepresentation", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent> structuralRepresentation;
        private static final long serialVersionUID = -1739084500L;

        public StringType getUnitElement() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new StringType();
                }
            }
            return this.unit;
        }

        public boolean hasUnitElement() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitComponent setUnitElement(StringType value) {
            this.unit = value;
            return this;
        }

        public String getUnit() {
            return this.unit == null ? null : (String)this.unit.getValue();
        }

        public SubstancePolymerRepeatRepeatUnitComponent setUnit(String value) {
            if (Utilities.noString((String)value)) {
                this.unit = null;
            } else {
                if (this.unit == null) {
                    this.unit = new StringType();
                }
                this.unit.setValue(value);
            }
            return this;
        }

        public CodeableConcept getOrientation() {
            if (this.orientation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitComponent.orientation");
                }
                if (Configuration.doAutoCreate()) {
                    this.orientation = new CodeableConcept();
                }
            }
            return this.orientation;
        }

        public boolean hasOrientation() {
            return this.orientation != null && !this.orientation.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitComponent setOrientation(CodeableConcept value) {
            this.orientation = value;
            return this;
        }

        public SubstanceAmount getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatRepeatUnitComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SubstanceAmount();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstancePolymerRepeatRepeatUnitComponent setAmount(SubstanceAmount value) {
            this.amount = value;
            return this;
        }

        public List<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent> getDegreeOfPolymerisation() {
            if (this.degreeOfPolymerisation == null) {
                this.degreeOfPolymerisation = new ArrayList<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent>();
            }
            return this.degreeOfPolymerisation;
        }

        public SubstancePolymerRepeatRepeatUnitComponent setDegreeOfPolymerisation(List<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent> theDegreeOfPolymerisation) {
            this.degreeOfPolymerisation = theDegreeOfPolymerisation;
            return this;
        }

        public boolean hasDegreeOfPolymerisation() {
            if (this.degreeOfPolymerisation == null) {
                return false;
            }
            for (SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent item : this.degreeOfPolymerisation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent addDegreeOfPolymerisation() {
            SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent t = new SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent();
            if (this.degreeOfPolymerisation == null) {
                this.degreeOfPolymerisation = new ArrayList<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent>();
            }
            this.degreeOfPolymerisation.add(t);
            return t;
        }

        public SubstancePolymerRepeatRepeatUnitComponent addDegreeOfPolymerisation(SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.degreeOfPolymerisation == null) {
                this.degreeOfPolymerisation = new ArrayList<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent>();
            }
            this.degreeOfPolymerisation.add(t);
            return this;
        }

        public SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent getDegreeOfPolymerisationFirstRep() {
            if (this.getDegreeOfPolymerisation().isEmpty()) {
                this.addDegreeOfPolymerisation();
            }
            return this.getDegreeOfPolymerisation().get(0);
        }

        public List<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent> getStructuralRepresentation() {
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent>();
            }
            return this.structuralRepresentation;
        }

        public SubstancePolymerRepeatRepeatUnitComponent setStructuralRepresentation(List<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent> theStructuralRepresentation) {
            this.structuralRepresentation = theStructuralRepresentation;
            return this;
        }

        public boolean hasStructuralRepresentation() {
            if (this.structuralRepresentation == null) {
                return false;
            }
            for (SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent item : this.structuralRepresentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent addStructuralRepresentation() {
            SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent t = new SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent();
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent>();
            }
            this.structuralRepresentation.add(t);
            return t;
        }

        public SubstancePolymerRepeatRepeatUnitComponent addStructuralRepresentation(SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent>();
            }
            this.structuralRepresentation.add(t);
            return this;
        }

        public SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent getStructuralRepresentationFirstRep() {
            if (this.getStructuralRepresentation().isEmpty()) {
                this.addStructuralRepresentation();
            }
            return this.getStructuralRepresentation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("unit", "string", "Todo.", 0, 1, this.unit));
            children.add(new Property("orientation", "CodeableConcept", "Todo.", 0, 1, this.orientation));
            children.add(new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount));
            children.add(new Property("degreeOfPolymerisation", "", "Todo.", 0, Integer.MAX_VALUE, this.degreeOfPolymerisation));
            children.add(new Property("structuralRepresentation", "", "Todo.", 0, Integer.MAX_VALUE, this.structuralRepresentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3594628: {
                    return new Property("unit", "string", "Todo.", 0, 1, this.unit);
                }
                case -1439500848: {
                    return new Property("orientation", "CodeableConcept", "Todo.", 0, 1, this.orientation);
                }
                case -1413853096: {
                    return new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount);
                }
                case -159251872: {
                    return new Property("degreeOfPolymerisation", "", "Todo.", 0, Integer.MAX_VALUE, this.degreeOfPolymerisation);
                }
                case 14311178: {
                    return new Property("structuralRepresentation", "", "Todo.", 0, Integer.MAX_VALUE, this.structuralRepresentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.unit;
                    }
                    return baseArray;
                }
                case -1439500848: {
                    Base[] baseArray;
                    if (this.orientation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.orientation;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case -159251872: {
                    return this.degreeOfPolymerisation == null ? new Base[]{} : this.degreeOfPolymerisation.toArray(new Base[this.degreeOfPolymerisation.size()]);
                }
                case 14311178: {
                    return this.structuralRepresentation == null ? new Base[]{} : this.structuralRepresentation.toArray(new Base[this.structuralRepresentation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3594628: {
                    this.unit = TypeConvertor.castToString(value);
                    return value;
                }
                case -1439500848: {
                    this.orientation = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToSubstanceAmount(value);
                    return value;
                }
                case -159251872: {
                    this.getDegreeOfPolymerisation().add((SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)value);
                    return value;
                }
                case 14311178: {
                    this.getStructuralRepresentation().add((SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("unit")) {
                this.unit = TypeConvertor.castToString(value);
            } else if (name.equals("orientation")) {
                this.orientation = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToSubstanceAmount(value);
            } else if (name.equals("degreeOfPolymerisation")) {
                this.getDegreeOfPolymerisation().add((SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent)value);
            } else if (name.equals("structuralRepresentation")) {
                this.getStructuralRepresentation().add((SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3594628: {
                    return this.getUnitElement();
                }
                case -1439500848: {
                    return this.getOrientation();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -159251872: {
                    return this.addDegreeOfPolymerisation();
                }
                case 14311178: {
                    return this.addStructuralRepresentation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3594628: {
                    return new String[]{"string"};
                }
                case -1439500848: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"SubstanceAmount"};
                }
                case -159251872: {
                    return new String[0];
                }
                case 14311178: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("unit")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.repeat.repeatUnit.unit");
            }
            if (name.equals("orientation")) {
                this.orientation = new CodeableConcept();
                return this.orientation;
            }
            if (name.equals("amount")) {
                this.amount = new SubstanceAmount();
                return this.amount;
            }
            if (name.equals("degreeOfPolymerisation")) {
                return this.addDegreeOfPolymerisation();
            }
            if (name.equals("structuralRepresentation")) {
                return this.addStructuralRepresentation();
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerRepeatRepeatUnitComponent copy() {
            SubstancePolymerRepeatRepeatUnitComponent dst = new SubstancePolymerRepeatRepeatUnitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerRepeatRepeatUnitComponent dst) {
            super.copyValues(dst);
            dst.unit = this.unit == null ? null : this.unit.copy();
            dst.orientation = this.orientation == null ? null : this.orientation.copy();
            SubstanceAmount substanceAmount = dst.amount = this.amount == null ? null : this.amount.copy();
            if (this.degreeOfPolymerisation != null) {
                dst.degreeOfPolymerisation = new ArrayList<SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent>();
                for (SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent substancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent : this.degreeOfPolymerisation) {
                    dst.degreeOfPolymerisation.add(substancePolymerRepeatRepeatUnitDegreeOfPolymerisationComponent.copy());
                }
            }
            if (this.structuralRepresentation != null) {
                dst.structuralRepresentation = new ArrayList<SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent>();
                for (SubstancePolymerRepeatRepeatUnitStructuralRepresentationComponent substancePolymerRepeatRepeatUnitStructuralRepresentationComponent : this.structuralRepresentation) {
                    dst.structuralRepresentation.add(substancePolymerRepeatRepeatUnitStructuralRepresentationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitComponent o = (SubstancePolymerRepeatRepeatUnitComponent)other_;
            return SubstancePolymerRepeatRepeatUnitComponent.compareDeep(this.unit, o.unit, true) && SubstancePolymerRepeatRepeatUnitComponent.compareDeep(this.orientation, o.orientation, true) && SubstancePolymerRepeatRepeatUnitComponent.compareDeep(this.amount, o.amount, true) && SubstancePolymerRepeatRepeatUnitComponent.compareDeep(this.degreeOfPolymerisation, o.degreeOfPolymerisation, true) && SubstancePolymerRepeatRepeatUnitComponent.compareDeep(this.structuralRepresentation, o.structuralRepresentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatRepeatUnitComponent)) {
                return false;
            }
            SubstancePolymerRepeatRepeatUnitComponent o = (SubstancePolymerRepeatRepeatUnitComponent)other_;
            return SubstancePolymerRepeatRepeatUnitComponent.compareValues(this.unit, o.unit, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.unit, this.orientation, this.amount, this.degreeOfPolymerisation, this.structuralRepresentation});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.repeat.repeatUnit";
        }
    }

    @Block
    public static class SubstancePolymerRepeatComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="numberOfUnits", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected IntegerType numberOfUnits;
        @Child(name="averageMolecularFormula", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected StringType averageMolecularFormula;
        @Child(name="repeatUnitAmountType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept repeatUnitAmountType;
        @Child(name="repeatUnit", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<SubstancePolymerRepeatRepeatUnitComponent> repeatUnit;
        private static final long serialVersionUID = -988147059L;

        public IntegerType getNumberOfUnitsElement() {
            if (this.numberOfUnits == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatComponent.numberOfUnits");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfUnits = new IntegerType();
                }
            }
            return this.numberOfUnits;
        }

        public boolean hasNumberOfUnitsElement() {
            return this.numberOfUnits != null && !this.numberOfUnits.isEmpty();
        }

        public boolean hasNumberOfUnits() {
            return this.numberOfUnits != null && !this.numberOfUnits.isEmpty();
        }

        public SubstancePolymerRepeatComponent setNumberOfUnitsElement(IntegerType value) {
            this.numberOfUnits = value;
            return this;
        }

        public int getNumberOfUnits() {
            return this.numberOfUnits == null || this.numberOfUnits.isEmpty() ? 0 : (Integer)this.numberOfUnits.getValue();
        }

        public SubstancePolymerRepeatComponent setNumberOfUnits(int value) {
            if (this.numberOfUnits == null) {
                this.numberOfUnits = new IntegerType();
            }
            this.numberOfUnits.setValue((Object)value);
            return this;
        }

        public StringType getAverageMolecularFormulaElement() {
            if (this.averageMolecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatComponent.averageMolecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.averageMolecularFormula = new StringType();
                }
            }
            return this.averageMolecularFormula;
        }

        public boolean hasAverageMolecularFormulaElement() {
            return this.averageMolecularFormula != null && !this.averageMolecularFormula.isEmpty();
        }

        public boolean hasAverageMolecularFormula() {
            return this.averageMolecularFormula != null && !this.averageMolecularFormula.isEmpty();
        }

        public SubstancePolymerRepeatComponent setAverageMolecularFormulaElement(StringType value) {
            this.averageMolecularFormula = value;
            return this;
        }

        public String getAverageMolecularFormula() {
            return this.averageMolecularFormula == null ? null : (String)this.averageMolecularFormula.getValue();
        }

        public SubstancePolymerRepeatComponent setAverageMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.averageMolecularFormula = null;
            } else {
                if (this.averageMolecularFormula == null) {
                    this.averageMolecularFormula = new StringType();
                }
                this.averageMolecularFormula.setValue(value);
            }
            return this;
        }

        public CodeableConcept getRepeatUnitAmountType() {
            if (this.repeatUnitAmountType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerRepeatComponent.repeatUnitAmountType");
                }
                if (Configuration.doAutoCreate()) {
                    this.repeatUnitAmountType = new CodeableConcept();
                }
            }
            return this.repeatUnitAmountType;
        }

        public boolean hasRepeatUnitAmountType() {
            return this.repeatUnitAmountType != null && !this.repeatUnitAmountType.isEmpty();
        }

        public SubstancePolymerRepeatComponent setRepeatUnitAmountType(CodeableConcept value) {
            this.repeatUnitAmountType = value;
            return this;
        }

        public List<SubstancePolymerRepeatRepeatUnitComponent> getRepeatUnit() {
            if (this.repeatUnit == null) {
                this.repeatUnit = new ArrayList<SubstancePolymerRepeatRepeatUnitComponent>();
            }
            return this.repeatUnit;
        }

        public SubstancePolymerRepeatComponent setRepeatUnit(List<SubstancePolymerRepeatRepeatUnitComponent> theRepeatUnit) {
            this.repeatUnit = theRepeatUnit;
            return this;
        }

        public boolean hasRepeatUnit() {
            if (this.repeatUnit == null) {
                return false;
            }
            for (SubstancePolymerRepeatRepeatUnitComponent item : this.repeatUnit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstancePolymerRepeatRepeatUnitComponent addRepeatUnit() {
            SubstancePolymerRepeatRepeatUnitComponent t = new SubstancePolymerRepeatRepeatUnitComponent();
            if (this.repeatUnit == null) {
                this.repeatUnit = new ArrayList<SubstancePolymerRepeatRepeatUnitComponent>();
            }
            this.repeatUnit.add(t);
            return t;
        }

        public SubstancePolymerRepeatComponent addRepeatUnit(SubstancePolymerRepeatRepeatUnitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.repeatUnit == null) {
                this.repeatUnit = new ArrayList<SubstancePolymerRepeatRepeatUnitComponent>();
            }
            this.repeatUnit.add(t);
            return this;
        }

        public SubstancePolymerRepeatRepeatUnitComponent getRepeatUnitFirstRep() {
            if (this.getRepeatUnit().isEmpty()) {
                this.addRepeatUnit();
            }
            return this.getRepeatUnit().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("numberOfUnits", "integer", "Todo.", 0, 1, this.numberOfUnits));
            children.add(new Property("averageMolecularFormula", "string", "Todo.", 0, 1, this.averageMolecularFormula));
            children.add(new Property("repeatUnitAmountType", "CodeableConcept", "Todo.", 0, 1, this.repeatUnitAmountType));
            children.add(new Property("repeatUnit", "", "Todo.", 0, Integer.MAX_VALUE, this.repeatUnit));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1321430961: {
                    return new Property("numberOfUnits", "integer", "Todo.", 0, 1, this.numberOfUnits);
                }
                case 111461715: {
                    return new Property("averageMolecularFormula", "string", "Todo.", 0, 1, this.averageMolecularFormula);
                }
                case -1994025263: {
                    return new Property("repeatUnitAmountType", "CodeableConcept", "Todo.", 0, 1, this.repeatUnitAmountType);
                }
                case 1159607743: {
                    return new Property("repeatUnit", "", "Todo.", 0, Integer.MAX_VALUE, this.repeatUnit);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1321430961: {
                    Base[] baseArray;
                    if (this.numberOfUnits == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.numberOfUnits;
                    }
                    return baseArray;
                }
                case 111461715: {
                    Base[] baseArray;
                    if (this.averageMolecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.averageMolecularFormula;
                    }
                    return baseArray;
                }
                case -1994025263: {
                    Base[] baseArray;
                    if (this.repeatUnitAmountType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.repeatUnitAmountType;
                    }
                    return baseArray;
                }
                case 1159607743: {
                    return this.repeatUnit == null ? new Base[]{} : this.repeatUnit.toArray(new Base[this.repeatUnit.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1321430961: {
                    this.numberOfUnits = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 111461715: {
                    this.averageMolecularFormula = TypeConvertor.castToString(value);
                    return value;
                }
                case -1994025263: {
                    this.repeatUnitAmountType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1159607743: {
                    this.getRepeatUnit().add((SubstancePolymerRepeatRepeatUnitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("numberOfUnits")) {
                this.numberOfUnits = TypeConvertor.castToInteger(value);
            } else if (name.equals("averageMolecularFormula")) {
                this.averageMolecularFormula = TypeConvertor.castToString(value);
            } else if (name.equals("repeatUnitAmountType")) {
                this.repeatUnitAmountType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("repeatUnit")) {
                this.getRepeatUnit().add((SubstancePolymerRepeatRepeatUnitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1321430961: {
                    return this.getNumberOfUnitsElement();
                }
                case 111461715: {
                    return this.getAverageMolecularFormulaElement();
                }
                case -1994025263: {
                    return this.getRepeatUnitAmountType();
                }
                case 1159607743: {
                    return this.addRepeatUnit();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1321430961: {
                    return new String[]{"integer"};
                }
                case 111461715: {
                    return new String[]{"string"};
                }
                case -1994025263: {
                    return new String[]{"CodeableConcept"};
                }
                case 1159607743: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("numberOfUnits")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.repeat.numberOfUnits");
            }
            if (name.equals("averageMolecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.repeat.averageMolecularFormula");
            }
            if (name.equals("repeatUnitAmountType")) {
                this.repeatUnitAmountType = new CodeableConcept();
                return this.repeatUnitAmountType;
            }
            if (name.equals("repeatUnit")) {
                return this.addRepeatUnit();
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerRepeatComponent copy() {
            SubstancePolymerRepeatComponent dst = new SubstancePolymerRepeatComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerRepeatComponent dst) {
            super.copyValues(dst);
            dst.numberOfUnits = this.numberOfUnits == null ? null : this.numberOfUnits.copy();
            dst.averageMolecularFormula = this.averageMolecularFormula == null ? null : this.averageMolecularFormula.copy();
            CodeableConcept codeableConcept = dst.repeatUnitAmountType = this.repeatUnitAmountType == null ? null : this.repeatUnitAmountType.copy();
            if (this.repeatUnit != null) {
                dst.repeatUnit = new ArrayList<SubstancePolymerRepeatRepeatUnitComponent>();
                for (SubstancePolymerRepeatRepeatUnitComponent i : this.repeatUnit) {
                    dst.repeatUnit.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatComponent)) {
                return false;
            }
            SubstancePolymerRepeatComponent o = (SubstancePolymerRepeatComponent)other_;
            return SubstancePolymerRepeatComponent.compareDeep(this.numberOfUnits, o.numberOfUnits, true) && SubstancePolymerRepeatComponent.compareDeep(this.averageMolecularFormula, o.averageMolecularFormula, true) && SubstancePolymerRepeatComponent.compareDeep(this.repeatUnitAmountType, o.repeatUnitAmountType, true) && SubstancePolymerRepeatComponent.compareDeep(this.repeatUnit, o.repeatUnit, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerRepeatComponent)) {
                return false;
            }
            SubstancePolymerRepeatComponent o = (SubstancePolymerRepeatComponent)other_;
            return SubstancePolymerRepeatComponent.compareValues(this.numberOfUnits, o.numberOfUnits, true) && SubstancePolymerRepeatComponent.compareValues(this.averageMolecularFormula, o.averageMolecularFormula, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.numberOfUnits, this.averageMolecularFormula, this.repeatUnitAmountType, this.repeatUnit});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.repeat";
        }
    }

    @Block
    public static class SubstancePolymerMonomerSetStartingMaterialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept code;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept category;
        @Child(name="isDefining", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected BooleanType isDefining;
        @Child(name="amount", type={SubstanceAmount.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected SubstanceAmount amount;
        private static final long serialVersionUID = -254439457L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerMonomerSetStartingMaterialComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerMonomerSetStartingMaterialComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public BooleanType getIsDefiningElement() {
            if (this.isDefining == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerMonomerSetStartingMaterialComponent.isDefining");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDefining = new BooleanType();
                }
            }
            return this.isDefining;
        }

        public boolean hasIsDefiningElement() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public boolean hasIsDefining() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent setIsDefiningElement(BooleanType value) {
            this.isDefining = value;
            return this;
        }

        public boolean getIsDefining() {
            return this.isDefining == null || this.isDefining.isEmpty() ? false : (Boolean)this.isDefining.getValue();
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent setIsDefining(boolean value) {
            if (this.isDefining == null) {
                this.isDefining = new BooleanType();
            }
            this.isDefining.setValue((Object)value);
            return this;
        }

        public SubstanceAmount getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerMonomerSetStartingMaterialComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SubstanceAmount();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent setAmount(SubstanceAmount value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Todo.", 0, 1, this.code));
            children.add(new Property("category", "CodeableConcept", "Todo.", 0, 1, this.category));
            children.add(new Property("isDefining", "boolean", "Todo.", 0, 1, this.isDefining));
            children.add(new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Todo.", 0, 1, this.code);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Todo.", 0, 1, this.category);
                }
                case -141812990: {
                    return new Property("isDefining", "boolean", "Todo.", 0, 1, this.isDefining);
                }
                case -1413853096: {
                    return new Property("amount", "SubstanceAmount", "Todo.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.category;
                    }
                    return baseArray;
                }
                case -141812990: {
                    Base[] baseArray;
                    if (this.isDefining == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.isDefining;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -141812990: {
                    this.isDefining = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToSubstanceAmount(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("isDefining")) {
                this.isDefining = TypeConvertor.castToBoolean(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToSubstanceAmount(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case -141812990: {
                    return this.getIsDefiningElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -141812990: {
                    return new String[]{"boolean"};
                }
                case -1413853096: {
                    return new String[]{"SubstanceAmount"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("isDefining")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstancePolymer.monomerSet.startingMaterial.isDefining");
            }
            if (name.equals("amount")) {
                this.amount = new SubstanceAmount();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerMonomerSetStartingMaterialComponent copy() {
            SubstancePolymerMonomerSetStartingMaterialComponent dst = new SubstancePolymerMonomerSetStartingMaterialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerMonomerSetStartingMaterialComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.isDefining = this.isDefining == null ? null : this.isDefining.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerMonomerSetStartingMaterialComponent)) {
                return false;
            }
            SubstancePolymerMonomerSetStartingMaterialComponent o = (SubstancePolymerMonomerSetStartingMaterialComponent)other_;
            return SubstancePolymerMonomerSetStartingMaterialComponent.compareDeep(this.code, o.code, true) && SubstancePolymerMonomerSetStartingMaterialComponent.compareDeep(this.category, o.category, true) && SubstancePolymerMonomerSetStartingMaterialComponent.compareDeep(this.isDefining, o.isDefining, true) && SubstancePolymerMonomerSetStartingMaterialComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerMonomerSetStartingMaterialComponent)) {
                return false;
            }
            SubstancePolymerMonomerSetStartingMaterialComponent o = (SubstancePolymerMonomerSetStartingMaterialComponent)other_;
            return SubstancePolymerMonomerSetStartingMaterialComponent.compareValues(this.isDefining, o.isDefining, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.category, this.isDefining, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.monomerSet.startingMaterial";
        }
    }

    @Block
    public static class SubstancePolymerMonomerSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="ratioType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected CodeableConcept ratioType;
        @Child(name="startingMaterial", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Todo", formalDefinition="Todo.")
        protected List<SubstancePolymerMonomerSetStartingMaterialComponent> startingMaterial;
        private static final long serialVersionUID = -933825014L;

        public CodeableConcept getRatioType() {
            if (this.ratioType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstancePolymerMonomerSetComponent.ratioType");
                }
                if (Configuration.doAutoCreate()) {
                    this.ratioType = new CodeableConcept();
                }
            }
            return this.ratioType;
        }

        public boolean hasRatioType() {
            return this.ratioType != null && !this.ratioType.isEmpty();
        }

        public SubstancePolymerMonomerSetComponent setRatioType(CodeableConcept value) {
            this.ratioType = value;
            return this;
        }

        public List<SubstancePolymerMonomerSetStartingMaterialComponent> getStartingMaterial() {
            if (this.startingMaterial == null) {
                this.startingMaterial = new ArrayList<SubstancePolymerMonomerSetStartingMaterialComponent>();
            }
            return this.startingMaterial;
        }

        public SubstancePolymerMonomerSetComponent setStartingMaterial(List<SubstancePolymerMonomerSetStartingMaterialComponent> theStartingMaterial) {
            this.startingMaterial = theStartingMaterial;
            return this;
        }

        public boolean hasStartingMaterial() {
            if (this.startingMaterial == null) {
                return false;
            }
            for (SubstancePolymerMonomerSetStartingMaterialComponent item : this.startingMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent addStartingMaterial() {
            SubstancePolymerMonomerSetStartingMaterialComponent t = new SubstancePolymerMonomerSetStartingMaterialComponent();
            if (this.startingMaterial == null) {
                this.startingMaterial = new ArrayList<SubstancePolymerMonomerSetStartingMaterialComponent>();
            }
            this.startingMaterial.add(t);
            return t;
        }

        public SubstancePolymerMonomerSetComponent addStartingMaterial(SubstancePolymerMonomerSetStartingMaterialComponent t) {
            if (t == null) {
                return this;
            }
            if (this.startingMaterial == null) {
                this.startingMaterial = new ArrayList<SubstancePolymerMonomerSetStartingMaterialComponent>();
            }
            this.startingMaterial.add(t);
            return this;
        }

        public SubstancePolymerMonomerSetStartingMaterialComponent getStartingMaterialFirstRep() {
            if (this.getStartingMaterial().isEmpty()) {
                this.addStartingMaterial();
            }
            return this.getStartingMaterial().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("ratioType", "CodeableConcept", "Todo.", 0, 1, this.ratioType));
            children.add(new Property("startingMaterial", "", "Todo.", 0, Integer.MAX_VALUE, this.startingMaterial));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 344937957: {
                    return new Property("ratioType", "CodeableConcept", "Todo.", 0, 1, this.ratioType);
                }
                case 442919303: {
                    return new Property("startingMaterial", "", "Todo.", 0, Integer.MAX_VALUE, this.startingMaterial);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 344937957: {
                    Base[] baseArray;
                    if (this.ratioType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.ratioType;
                    }
                    return baseArray;
                }
                case 442919303: {
                    return this.startingMaterial == null ? new Base[]{} : this.startingMaterial.toArray(new Base[this.startingMaterial.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 344937957: {
                    this.ratioType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 442919303: {
                    this.getStartingMaterial().add((SubstancePolymerMonomerSetStartingMaterialComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("ratioType")) {
                this.ratioType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("startingMaterial")) {
                this.getStartingMaterial().add((SubstancePolymerMonomerSetStartingMaterialComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 344937957: {
                    return this.getRatioType();
                }
                case 442919303: {
                    return this.addStartingMaterial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 344937957: {
                    return new String[]{"CodeableConcept"};
                }
                case 442919303: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ratioType")) {
                this.ratioType = new CodeableConcept();
                return this.ratioType;
            }
            if (name.equals("startingMaterial")) {
                return this.addStartingMaterial();
            }
            return super.addChild(name);
        }

        @Override
        public SubstancePolymerMonomerSetComponent copy() {
            SubstancePolymerMonomerSetComponent dst = new SubstancePolymerMonomerSetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstancePolymerMonomerSetComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.ratioType = this.ratioType == null ? null : this.ratioType.copy();
            if (this.startingMaterial != null) {
                dst.startingMaterial = new ArrayList<SubstancePolymerMonomerSetStartingMaterialComponent>();
                for (SubstancePolymerMonomerSetStartingMaterialComponent i : this.startingMaterial) {
                    dst.startingMaterial.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerMonomerSetComponent)) {
                return false;
            }
            SubstancePolymerMonomerSetComponent o = (SubstancePolymerMonomerSetComponent)other_;
            return SubstancePolymerMonomerSetComponent.compareDeep(this.ratioType, o.ratioType, true) && SubstancePolymerMonomerSetComponent.compareDeep(this.startingMaterial, o.startingMaterial, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstancePolymerMonomerSetComponent)) {
                return false;
            }
            SubstancePolymerMonomerSetComponent o = (SubstancePolymerMonomerSetComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.ratioType, this.startingMaterial});
        }

        @Override
        public String fhirType() {
            return "SubstancePolymer.monomerSet";
        }
    }
}

