/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.r5.model.IntegerType;

@DatatypeDef(name="unsignedInt", profileOf=IntegerType.class)
public class UnsignedIntType
extends IntegerType {
    private static final long serialVersionUID = -7991875974606711355L;

    public UnsignedIntType() {
    }

    public UnsignedIntType(int theInteger) {
        this.setValue((Object)theInteger);
    }

    public UnsignedIntType(String theIntegerAsString) {
        this.setValueAsString(theIntegerAsString);
    }

    public UnsignedIntType(Long theValue) {
        if (theValue < 0L || theValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(theValue + " cannot be cast to int without changing its value.");
        }
        if (theValue != null) {
            this.setValue((Object)((int)theValue.longValue()));
        }
    }

    @Override
    public UnsignedIntType copy() {
        UnsignedIntType ret = new UnsignedIntType((Integer)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "unsignedInt";
    }
}

