/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class OperationDefinitionRenderer
extends TerminologyRenderer {
    public OperationDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    public OperationDefinitionRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws IOException, FHIRException, EOperationOutcome {
        return this.render(x, (OperationDefinition)dr);
    }

    public boolean render(XhtmlNode x, OperationDefinition opd) throws IOException, FHIRException, EOperationOutcome {
        x.h2().addText(opd.getName());
        x.para().addText(Utilities.capitalize((String)opd.getKind().toString()) + ": " + opd.getName());
        x.para().tx("The official URL for this operation definition is: ");
        x.pre().tx(opd.getUrl());
        this.addMarkdown(x, opd.getDescription());
        if (opd.getSystem()) {
            x.para().tx("URL: [base]/$" + opd.getCode());
        }
        for (CodeType c : opd.getResource()) {
            if (opd.getType()) {
                x.para().tx("URL: [base]/" + (String)c.getValue() + "/$" + opd.getCode());
            }
            if (!opd.getInstance()) continue;
            x.para().tx("URL: [base]/" + (String)c.getValue() + "/[id]/$" + opd.getCode());
        }
        x.para().tx("Parameters");
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx("Use");
        tr.td().b().tx("Name");
        tr.td().b().tx("Cardinality");
        tr.td().b().tx("Type");
        tr.td().b().tx("Binding");
        tr.td().b().tx("Documentation");
        for (OperationDefinition.OperationDefinitionParameterComponent p : opd.getParameter()) {
            this.genOpParam(tbl, "", p);
        }
        this.addMarkdown(x, opd.getComment());
        return true;
    }

    public void describe(XhtmlNode x, OperationDefinition opd) {
        x.tx(this.display(opd));
    }

    public String display(OperationDefinition opd) {
        return opd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((OperationDefinition)r).present();
    }

    private void genOpParam(XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p) throws EOperationOutcome, FHIRException, IOException {
        StructureDefinition sd;
        XhtmlNode tr = tbl.tr();
        tr.td().addText(p.getUse().toString());
        tr.td().addText(path + p.getName());
        tr.td().addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        XhtmlNode td = tr.td();
        StructureDefinition structureDefinition = sd = p.getType() != null ? this.context.getWorker().fetchTypeDefinition(p.getType().toCode()) : null;
        if (sd == null) {
            td.tx(p.hasType() ? p.getType().toCode() : "");
        } else if (sd.getAbstract() && p.hasExtension("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
            boolean first = true;
            for (Extension ex : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                String s = ex.getValue().primitiveValue();
                StructureDefinition sdt = this.context.getWorker().fetchTypeDefinition(s);
                if (sdt == null) {
                    td.tx(p.hasType() ? p.getType().toCode() : "");
                    continue;
                }
                td.ah(sdt.getUserString("path")).tx(s);
            }
        } else {
            td.ah(sd.getUserString("path")).tx(p.hasType() ? p.getType().toCode() : "");
        }
        if (p.hasSearchType()) {
            td.br();
            td.tx("(");
            td.ah(this.context.getSpecificationLink() == null ? "search.html#" + p.getSearchType().toCode() : Utilities.pathURL((String[])new String[]{this.context.getSpecificationLink(), "search.html#" + p.getSearchType().toCode()})).tx(p.getSearchType().toCode());
            td.tx(")");
        }
        td = tr.td();
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            this.AddVsRef(p.getBinding().getValueSet(), td);
            td.tx(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.td(), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(tbl, path + p.getName() + ".", pp);
            }
        }
    }
}

