/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.ElementWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class ResourceRenderer
extends DataRenderer {
    protected Resolver.ResourceContext rcontext;
    protected XVerExtensionManager xverManager;
    protected boolean forResource;

    public ResourceRenderer(RenderingContext context) {
        super(context);
    }

    public ResourceRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context);
        this.rcontext = rcontext;
    }

    public XhtmlNode build(Resource dr) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        this.render(x, dr);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DomainResource r) throws IOException, FHIRException, EOperationOutcome {
        boolean hasExtensions;
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean ofr = this.forResource;
        try {
            this.forResource = true;
            hasExtensions = this.render(x, r);
        }
        finally {
            this.forResource = ofr;
        }
        ResourceRenderer.inject(r, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public XhtmlNode render(BaseWrappers.ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        assert (r.getContext() == this.context);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = this.render(x, r);
        if (r.hasNarrative()) {
            r.injectNarrative(x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        }
        return x;
    }

    public abstract boolean render(XhtmlNode var1, Resource var2) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome;

    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        ProfileDrivenRenderer pr = new ProfileDrivenRenderer(this.context);
        return pr.render(x, r);
    }

    public void describe(XhtmlNode x, Resource r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public void describe(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public abstract String display(Resource var1) throws UnsupportedEncodingException, IOException;

    public abstract String display(BaseWrappers.ResourceWrapper var1) throws UnsupportedEncodingException, IOException;

    public static void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (r.hasLanguage()) {
            x.setAttribute("lang", r.getLanguage());
            x.setAttribute("xml:lang", r.getLanguage());
        }
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.clear();
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public void renderReference(Resource res, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        this.renderReference((BaseWrappers.ResourceWrapper)rw, x, r);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        this.renderReference(rw, x, r, true);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        if (r == null) {
            x.tx("null!");
            return;
        }
        XhtmlNode c = null;
        Resolver.ResourceWithReference tr = null;
        if (r.hasReferenceElement() && allowLinks) {
            tr = this.resolveReference(rw, r.getReference());
            c = !r.getReference().startsWith("#") ? (tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(r.getReference())) : x.ah(r.getReference());
        } else {
            c = x.span(null, null);
        }
        if (r.hasDisplayElement()) {
            c.addText(r.getDisplay());
            if (tr != null && tr.getResource() != null) {
                c.tx(". Generated Summary: ");
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"));
            }
        } else if (tr != null && tr.getResource() != null) {
            if (tr.getReference().startsWith("#")) {
                c.tx("See above (" + tr.getResource().fhirType() + "/" + tr.getResource().getId() + ")");
            } else {
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"));
            }
        } else {
            c.addText(r.getReference());
        }
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, BaseWrappers.BaseWrapper r) throws UnsupportedEncodingException, IOException {
        String v;
        XhtmlNode c = x;
        Resolver.ResourceWithReference tr = null;
        if (r.has("reference")) {
            v = r.get("reference").primitiveValue();
            tr = this.resolveReference(rw, v);
            if (!v.startsWith("#")) {
                c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(v);
            }
        } else {
            v = "";
        }
        if (r.has("display")) {
            c.addText(r.get("display").primitiveValue());
            if (tr != null && tr.getResource() != null) {
                c.tx(". Generated Summary: ");
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, v.startsWith("#"));
            }
        } else if (tr != null && tr.getResource() != null) {
            new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), v.startsWith("#"), v.startsWith("#"));
        } else {
            c.addText(v);
        }
    }

    protected Resolver.ResourceWithReference resolveReference(BaseWrappers.ResourceWrapper res, String url) {
        Object ae;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#") && res != null) {
            for (BaseWrappers.ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new Resolver.ResourceWithReference(null, r);
            }
            return null;
        }
        if (this.rcontext != null) {
            Bundle.BundleEntryComponent bundleResource = this.rcontext.resolve(url);
            if (bundleResource != null) {
                String bundleUrl = "#" + bundleResource.getResource().getResourceType().name() + "_" + bundleResource.getResource().getId();
                return new Resolver.ResourceWithReference(bundleUrl, new DirectWrappers.ResourceWrapperDirect(this.context, bundleResource.getResource()));
            }
            Element bundleElement = this.rcontext.resolveElement(url);
            if (bundleElement != null) {
                String bundleUrl = null;
                Element br = bundleElement.getNamedChild("resource");
                bundleUrl = br.getChildValue("id") != null ? "#" + br.fhirType() + "_" + br.getChildValue("id") : "#" + this.fullUrlToAnchor(bundleElement.getChildValue("fullUrl"));
                return new Resolver.ResourceWithReference(bundleUrl, new ElementWrappers.ResourceWrapperMetaElement(this.context, br));
            }
        }
        if ((ae = this.getContext().getWorker().fetchResource(null, url)) != null) {
            return new Resolver.ResourceWithReference(url, new DirectWrappers.ResourceWrapperDirect(this.context, (Resource)ae));
        }
        if (this.context.getResolver() != null) {
            return this.context.getResolver().resolve(this.context, url);
        }
        return null;
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    protected void generateCopyright(XhtmlNode x, CanonicalResource cs) {
        XhtmlNode p = x.para();
        p.b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Copyright Statement:", this.context.getLang()));
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public String displayReference(Resource res, Reference r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    public Base parseType(String string, String type) {
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.ResourceWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.BaseWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected boolean valued(BaseWrappers.PropertyWrapper pw) {
        return pw != null && pw.hasValues();
    }

    protected BaseWrappers.ResourceWrapper fetchResource(BaseWrappers.BaseWrapper subject) throws UnsupportedEncodingException, FHIRException, IOException {
        if (this.context.getResolver() == null) {
            return null;
        }
        BaseWrappers.PropertyWrapper ref = subject.getChildByName("reference");
        if (ref == null || !ref.hasValues()) {
            return null;
        }
        String url = ref.value().getBase().primitiveValue();
        Resolver.ResourceWithReference rr = this.context.getResolver().resolve(this.context, url);
        return rr == null ? null : rr.getResource();
    }

    protected String describeStatus(Enumerations.PublicationStatus status, boolean experimental) {
        switch (status) {
            case ACTIVE: {
                return experimental ? "Experimental" : "Active";
            }
            case DRAFT: {
                return "draft";
            }
            case RETIRED: {
                return "retired";
            }
        }
        return "Unknown";
    }

    protected void renderCommitteeLink(XhtmlNode x, CanonicalResource cr) {
        String code = ToolingExtensions.readStringExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://terminology.hl7.org/CodeSystem/hl7-work-group");
        if (cs == null || !cs.hasUserData("path")) {
            x.tx(code);
        } else {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
            if (cd == null) {
                x.tx(code);
            } else {
                x.ah(cs.getUserString("path") + "#" + cs.getId() + "-" + cd.getCode()).tx(cd.getDisplay());
            }
        }
    }
}

