/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.w3c.dom.Document;

public interface IResourceValidator {
    public CheckDisplayOption getCheckDisplay();

    public void setCheckDisplay(CheckDisplayOption var1);

    public IdStatus getResourceIdRule();

    public void setResourceIdRule(IdStatus var1);

    public BestPracticeWarningLevel getBestPracticeWarningLevel();

    public IResourceValidator setBestPracticeWarningLevel(BestPracticeWarningLevel var1);

    public IValidatorResourceFetcher getFetcher();

    public IResourceValidator setFetcher(IValidatorResourceFetcher var1);

    public IValidationProfileUsageTracker getTracker();

    public IResourceValidator setTracker(IValidationProfileUsageTracker var1);

    public boolean isNoBindingMsgSuppressed();

    public IResourceValidator setNoBindingMsgSuppressed(boolean var1);

    public boolean isNoInvariantChecks();

    public IResourceValidator setNoInvariantChecks(boolean var1);

    public boolean isNoTerminologyChecks();

    public IResourceValidator setNoTerminologyChecks(boolean var1);

    public boolean isNoExtensibleWarnings();

    public IResourceValidator setNoExtensibleWarnings(boolean var1);

    public boolean isErrorForUnknownProfiles();

    public void setErrorForUnknownProfiles(boolean var1);

    public boolean isShowMessagesFromReferences();

    public void setShowMessagesFromReferences(boolean var1);

    public boolean isAssumeValidRestReferences();

    public void setAssumeValidRestReferences(boolean var1);

    public boolean isAllowExamples();

    public void setAllowExamples(boolean var1);

    public boolean isCrumbTrails();

    public void setCrumbTrails(boolean var1);

    public List<BundleValidationRule> getBundleValidationRules();

    public void validate(Object var1, List<ValidationMessage> var2, Element var3) throws FHIRException;

    public void validate(Object var1, List<ValidationMessage> var2, Element var3, String var4) throws FHIRException;

    public void validate(Object var1, List<ValidationMessage> var2, Element var3, List<StructureDefinition> var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, InputStream var3, Manager.FhirFormat var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, InputStream var3, Manager.FhirFormat var4, String var5) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, InputStream var3, Manager.FhirFormat var4, List<StructureDefinition> var5) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Resource var3) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Resource var3, String var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Resource var3, List<StructureDefinition> var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, org.w3c.dom.Element var3) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, org.w3c.dom.Element var3, String var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, org.w3c.dom.Element var3, List<StructureDefinition> var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Document var3) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Document var3, String var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, Document var3, List<StructureDefinition> var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, JsonObject var3) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, JsonObject var3, String var4) throws FHIRException;

    public Element validate(Object var1, List<ValidationMessage> var2, JsonObject var3, List<StructureDefinition> var4) throws FHIRException;

    public static enum IdStatus {
        OPTIONAL,
        REQUIRED,
        PROHIBITED;

    }

    public static enum CheckDisplayOption {
        Ignore,
        Check,
        CheckCaseAndSpace,
        CheckCase,
        CheckSpace;

    }

    public static enum BestPracticeWarningLevel {
        Ignore,
        Hint,
        Warning,
        Error;

    }

    public static interface IValidatorResourceFetcher {
        public Element fetch(Object var1, String var2) throws FHIRFormatError, DefinitionException, FHIRException, IOException;

        public ReferenceValidationPolicy validationPolicy(Object var1, String var2, String var3);

        public boolean resolveURL(Object var1, String var2, String var3) throws IOException, FHIRException;

        public byte[] fetchRaw(String var1) throws MalformedURLException, IOException;

        public void setLocale(Locale var1);
    }

    public static interface IValidationProfileUsageTracker {
        public void recordProfileUsage(StructureDefinition var1, Object var2, Element var3);
    }

    public static enum ReferenceValidationPolicy {
        IGNORE,
        CHECK_TYPE_IF_EXISTS,
        CHECK_EXISTS,
        CHECK_EXISTS_AND_TYPE,
        CHECK_VALID;


        public boolean checkExists() {
            return this == CHECK_EXISTS_AND_TYPE || this == CHECK_EXISTS || this == CHECK_VALID || this == CHECK_TYPE_IF_EXISTS;
        }

        public boolean checkType() {
            return this == CHECK_TYPE_IF_EXISTS || this == CHECK_EXISTS_AND_TYPE || this == CHECK_VALID;
        }

        public boolean checkValid() {
            return this == CHECK_VALID;
        }
    }

    public static class BundleValidationRule {
        private String rule;
        private String profile;
        private boolean checked;

        public BundleValidationRule(String rule, String profile) {
            this.rule = rule;
            this.profile = profile;
        }

        public String getRule() {
            return this.rule;
        }

        public String getProfile() {
            return this.profile;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }
    }
}

