/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonParserBase;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUseStatement;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.OrderedDistribution;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.ProdCharacteristic;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.Statistic;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class JsonParser
extends JsonParserBase {
    public JsonParser() {
    }

    public JsonParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    public JsonParser(boolean allowUnknownContent, boolean allowComments) {
        this.setAllowUnknownContent(allowUnknownContent);
        this.setAllowComments(allowComments);
    }

    protected void parseBaseProperties(JsonObject json, Base res) throws IOException, FHIRFormatError {
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        if (s != null) {
            res.setValue(e.fromCode(s));
        }
        return res;
    }

    protected DateType parseDate(String v) throws IOException, FHIRFormatError {
        DateType res = new DateType(v);
        return res;
    }

    protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(v);
        return res;
    }

    protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
        CodeType res = new CodeType(v);
        return res;
    }

    protected StringType parseString(String v) throws IOException, FHIRFormatError {
        StringType res = new StringType(v);
        return res;
    }

    protected IntegerType parseInteger(Long v) throws IOException, FHIRFormatError {
        IntegerType res = new IntegerType(v);
        return res;
    }

    protected Integer64Type parseInteger64(Long v) throws IOException, FHIRFormatError {
        Integer64Type res = new Integer64Type(v);
        return res;
    }

    protected OidType parseOid(String v) throws IOException, FHIRFormatError {
        OidType res = new OidType(v);
        return res;
    }

    protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
        CanonicalType res = new CanonicalType(v);
        return res;
    }

    protected UriType parseUri(String v) throws IOException, FHIRFormatError {
        UriType res = new UriType(v);
        return res;
    }

    protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
        UuidType res = new UuidType(v);
        return res;
    }

    protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
        UrlType res = new UrlType(v);
        return res;
    }

    protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
        InstantType res = new InstantType(v);
        return res;
    }

    protected BooleanType parseBoolean(Boolean v) throws IOException, FHIRFormatError {
        BooleanType res = new BooleanType(v);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(v);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(v);
        return res;
    }

    protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(v);
        return res;
    }

    protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
        TimeType res = new TimeType(v);
        return res;
    }

    protected IdType parseId(String v) throws IOException, FHIRFormatError {
        IdType res = new IdType(v);
        return res;
    }

    protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(v);
        return res;
    }

    protected DecimalType parseDecimal(BigDecimal v) throws IOException, FHIRFormatError {
        DecimalType res = new DecimalType(v);
        if (v instanceof JsonTrackingParser.PresentedBigDecimal) {
            res.setRepresentation(((JsonTrackingParser.PresentedBigDecimal)v).getPresentation());
        }
        return res;
    }

    protected void parseBackboneElementProperties(JsonObject json, BackboneElement res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("modifierExtension")) {
            JsonArray array = json.getAsJsonArray("modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseBackboneTypeProperties(JsonObject json, BackboneType res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("modifierExtension")) {
            JsonArray array = json.getAsJsonArray("modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseDataTypeProperties(JsonObject json, DataType res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
    }

    @Override
    protected void parseElementProperties(JsonObject json, Element res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("id")) {
            res.setIdElement(this.parseString(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("extension")) {
            JsonArray array = json.getAsJsonArray("extension");
            for (int i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
        Address res = new Address();
        this.parseAddressProperties(json, res);
        return res;
    }

    protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("line")) {
            array = json.getAsJsonArray("line");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLine().add(new StringType());
                    continue;
                }
                res.getLine().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_line")) {
            array = json.getAsJsonArray("_line");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLine().size()) {
                    res.getLine().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
            }
        }
        if (json.has("city")) {
            res.setCityElement(this.parseString(json.get("city").getAsString()));
        }
        if (json.has("_city")) {
            this.parseElementProperties(this.getJObject(json, "_city"), res.getCityElement());
        }
        if (json.has("district")) {
            res.setDistrictElement(this.parseString(json.get("district").getAsString()));
        }
        if (json.has("_district")) {
            this.parseElementProperties(this.getJObject(json, "_district"), res.getDistrictElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseString(json.get("state").getAsString()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(this.getJObject(json, "_state"), res.getStateElement());
        }
        if (json.has("postalCode")) {
            res.setPostalCodeElement(this.parseString(json.get("postalCode").getAsString()));
        }
        if (json.has("_postalCode")) {
            this.parseElementProperties(this.getJObject(json, "_postalCode"), res.getPostalCodeElement());
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(this.getJObject(json, "_country"), res.getCountryElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
        Age res = new Age();
        this.parseAgeProperties(json, res);
        return res;
    }

    protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseAnnotationProperties(json, res);
        return res;
    }

    protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        DataType author = this.parseType("author", json);
        if (author != null) {
            res.setAuthor(author);
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseAttachmentProperties(json, res);
        return res;
    }

    protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(this.getJObject(json, "_contentType"), res.getContentTypeElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseInteger64(json.get("size").getAsLong()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(this.getJObject(json, "_size"), res.getSizeElement());
        }
        if (json.has("hash")) {
            res.setHashElement(this.parseBase64Binary(json.get("hash").getAsString()));
        }
        if (json.has("_hash")) {
            this.parseElementProperties(this.getJObject(json, "_hash"), res.getHashElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("creation")) {
            res.setCreationElement(this.parseDateTime(json.get("creation").getAsString()));
        }
        if (json.has("_creation")) {
            this.parseElementProperties(this.getJObject(json, "_creation"), res.getCreationElement());
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(this.getJObject(json, "_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(this.getJObject(json, "_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(this.getJObject(json, "_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(this.getJObject(json, "_duration"), res.getDurationElement());
        }
        if (json.has("pages")) {
            res.setPagesElement(this.parsePositiveInt(json.get("pages").getAsString()));
        }
        if (json.has("_pages")) {
            this.parseElementProperties(this.getJObject(json, "_pages"), res.getPagesElement());
        }
    }

    protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseCodeableConceptProperties(json, res);
        return res;
    }

    protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("coding")) {
            JsonArray array = json.getAsJsonArray("coding");
            for (int i = 0; i < array.size(); ++i) {
                res.getCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected CodeableReference parseCodeableReference(JsonObject json) throws IOException, FHIRFormatError {
        CodeableReference res = new CodeableReference();
        this.parseCodeableReferenceProperties(json, res);
        return res;
    }

    protected void parseCodeableReferenceProperties(JsonObject json, CodeableReference res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("concept")) {
            res.setConcept(this.parseCodeableConcept(this.getJObject(json, "concept")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseCodingProperties(json, res);
        return res;
    }

    protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(json.get("userSelected").getAsBoolean()));
        }
        if (json.has("_userSelected")) {
            this.parseElementProperties(this.getJObject(json, "_userSelected"), res.getUserSelectedElement());
        }
    }

    protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseContactDetailProperties(json, res);
        return res;
    }

    protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseContactPointProperties(json, res);
        return res;
    }

    protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(this.getJObject(json, "_rank"), res.getRankElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseContributorProperties(json, res);
        return res;
    }

    protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (int i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
        Count res = new Count();
        this.parseCountProperties(json, res);
        return res;
    }

    protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseDataRequirementProperties(json, res);
        return res;
    }

    protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
        int i;
        DataType subject;
        int i2;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getProfile().get(i2));
            }
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("mustSupport")) {
            JsonArray array2 = json.getAsJsonArray("mustSupport");
            for (i = 0; i < array2.size(); ++i) {
                if (array2.get(i).isJsonNull()) {
                    res.getMustSupport().add(new StringType());
                    continue;
                }
                res.getMustSupport().add(this.parseString(array2.get(i).getAsString()));
            }
        }
        if (json.has("_mustSupport")) {
            JsonArray array3 = json.getAsJsonArray("_mustSupport");
            for (i = 0; i < array3.size(); ++i) {
                if (i == res.getMustSupport().size()) {
                    res.getMustSupport().add(this.parseString(null));
                }
                if (!(array3.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array3.get(i).getAsJsonObject(), res.getMustSupport().get(i));
            }
        }
        if (json.has("codeFilter")) {
            JsonArray array4 = json.getAsJsonArray("codeFilter");
            for (i = 0; i < array4.size(); ++i) {
                res.getCodeFilter().add(this.parseDataRequirementCodeFilterComponent(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateFilter")) {
            JsonArray array5 = json.getAsJsonArray("dateFilter");
            for (i = 0; i < array5.size(); ++i) {
                res.getDateFilter().add(this.parseDataRequirementDateFilterComponent(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("limit")) {
            res.setLimitElement(this.parsePositiveInt(json.get("limit").getAsString()));
        }
        if (json.has("_limit")) {
            this.parseElementProperties(this.getJObject(json, "_limit"), res.getLimitElement());
        }
        if (json.has("sort")) {
            JsonArray array6 = json.getAsJsonArray("sort");
            for (i = 0; i < array6.size(); ++i) {
                res.getSort().add(this.parseDataRequirementSortComponent(array6.get(i).getAsJsonObject()));
            }
        }
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseDataRequirementCodeFilterComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("searchParam")) {
            res.setSearchParamElement(this.parseString(json.get("searchParam").getAsString()));
        }
        if (json.has("_searchParam")) {
            this.parseElementProperties(this.getJObject(json, "_searchParam"), res.getSearchParamElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("code")) {
            JsonArray array = json.getAsJsonArray("code");
            for (int i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseDataRequirementDateFilterComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("searchParam")) {
            res.setSearchParamElement(this.parseString(json.get("searchParam").getAsString()));
        }
        if (json.has("_searchParam")) {
            this.parseElementProperties(this.getJObject(json, "_searchParam"), res.getSearchParamElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(JsonObject json) throws IOException, FHIRFormatError {
        DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
        this.parseDataRequirementSortComponentProperties(json, res);
        return res;
    }

    protected void parseDataRequirementSortComponentProperties(JsonObject json, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("direction")) {
            res.setDirectionElement(this.parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
        }
        if (json.has("_direction")) {
            this.parseElementProperties(this.getJObject(json, "_direction"), res.getDirectionElement());
        }
    }

    protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseDistanceProperties(json, res);
        return res;
    }

    protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseDosageProperties(json, res);
        return res;
    }

    protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
        DataType asNeeded;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parseInteger(json.get("sequence").getAsLong()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("additionalInstruction")) {
            JsonArray array = json.getAsJsonArray("additionalInstruction");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditionalInstruction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(json.get("patientInstruction").getAsString()));
        }
        if (json.has("_patientInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(this.getJObject(json, "timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(this.getJObject(json, "site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(this.getJObject(json, "route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(this.getJObject(json, "method")));
        }
        if (json.has("doseAndRate")) {
            JsonArray array = json.getAsJsonArray("doseAndRate");
            for (int i = 0; i < array.size(); ++i) {
                res.getDoseAndRate().add(this.parseDosageDoseAndRateComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(this.getJObject(json, "maxDosePerPeriod")));
        }
        if (json.has("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseQuantity(this.getJObject(json, "maxDosePerAdministration")));
        }
        if (json.has("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseQuantity(this.getJObject(json, "maxDosePerLifetime")));
        }
    }

    protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
        this.parseDosageDoseAndRateComponentProperties(json, res);
        return res;
    }

    protected void parseDosageDoseAndRateComponentProperties(JsonObject json, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
        DataType rate;
        DataType dose;
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
    }

    protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseDurationProperties(json, res);
        return res;
    }

    protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
        this.parseQuantityProperties(json, res);
    }

    protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementDefinitionProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType maxValue;
        DataType minValue;
        DataType pattern;
        DataType fixed;
        DataType defaultValue;
        int i2;
        JsonArray array2;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("representation")) {
            array2 = json.getAsJsonArray("representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getRepresentation().add(new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory(), ElementDefinition.PropertyRepresentation.NULL));
                    continue;
                }
                res.getRepresentation().add(this.parseEnumeration(array2.get(i2).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            }
        }
        if (json.has("_representation")) {
            array2 = json.getAsJsonArray("_representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getRepresentation().size()) {
                    res.getRepresentation().add(this.parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getRepresentation().get(i2));
            }
        }
        if (json.has("sliceName")) {
            res.setSliceNameElement(this.parseString(json.get("sliceName").getAsString()));
        }
        if (json.has("_sliceName")) {
            this.parseElementProperties(this.getJObject(json, "_sliceName"), res.getSliceNameElement());
        }
        if (json.has("sliceIsConstraining")) {
            res.setSliceIsConstrainingElement(this.parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
        }
        if (json.has("_sliceIsConstraining")) {
            this.parseElementProperties(this.getJObject(json, "_sliceIsConstraining"), res.getSliceIsConstrainingElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("code")) {
            array2 = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("slicing")) {
            res.setSlicing(this.parseElementDefinitionSlicingComponent(this.getJObject(json, "slicing")));
        }
        if (json.has("short")) {
            res.setShortElement(this.parseString(json.get("short").getAsString()));
        }
        if (json.has("_short")) {
            this.parseElementProperties(this.getJObject(json, "_short"), res.getShortElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(this.getJObject(json, "_requirements"), res.getRequirementsElement());
        }
        if (json.has("alias")) {
            array2 = json.getAsJsonArray("alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getAlias().add(new StringType());
                    continue;
                }
                res.getAlias().add(this.parseString(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array2 = json.getAsJsonArray("_alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getAlias().get(i2));
            }
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseElementDefinitionBaseComponent(this.getJObject(json, "base")));
        }
        if (json.has("contentReference")) {
            res.setContentReferenceElement(this.parseUri(json.get("contentReference").getAsString()));
        }
        if (json.has("_contentReference")) {
            this.parseElementProperties(this.getJObject(json, "_contentReference"), res.getContentReferenceElement());
        }
        if (json.has("type")) {
            array2 = json.getAsJsonArray("type");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((defaultValue = this.parseType("defaultValue", json)) != null) {
            res.setDefaultValue(defaultValue);
        }
        if (json.has("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(json.get("meaningWhenMissing").getAsString()));
        }
        if (json.has("_meaningWhenMissing")) {
            this.parseElementProperties(this.getJObject(json, "_meaningWhenMissing"), res.getMeaningWhenMissingElement());
        }
        if (json.has("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(json.get("orderMeaning").getAsString()));
        }
        if (json.has("_orderMeaning")) {
            this.parseElementProperties(this.getJObject(json, "_orderMeaning"), res.getOrderMeaningElement());
        }
        if ((fixed = this.parseType("fixed", json)) != null) {
            res.setFixed(fixed);
        }
        if ((pattern = this.parseType("pattern", json)) != null) {
            res.setPattern(pattern);
        }
        if (json.has("example")) {
            JsonArray array3 = json.getAsJsonArray("example");
            for (int i3 = 0; i3 < array3.size(); ++i3) {
                res.getExample().add(this.parseElementDefinitionExampleComponent(array3.get(i3).getAsJsonObject()));
            }
        }
        if ((minValue = this.parseType("minValue", json)) != null) {
            res.setMinValue(minValue);
        }
        if ((maxValue = this.parseType("maxValue", json)) != null) {
            res.setMaxValue(maxValue);
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(this.getJObject(json, "_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getCondition().add(new IdType());
                    continue;
                }
                res.getCondition().add(this.parseId(array.get(i).getAsString()));
            }
        }
        if (json.has("_condition")) {
            array = json.getAsJsonArray("_condition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCondition().size()) {
                    res.getCondition().add(this.parseId(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
            }
        }
        if (json.has("constraint")) {
            array = json.getAsJsonArray("constraint");
            for (i = 0; i < array.size(); ++i) {
                res.getConstraint().add(this.parseElementDefinitionConstraintComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(json.get("mustSupport").getAsBoolean()));
        }
        if (json.has("_mustSupport")) {
            this.parseElementProperties(this.getJObject(json, "_mustSupport"), res.getMustSupportElement());
        }
        if (json.has("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(json.get("isModifier").getAsBoolean()));
        }
        if (json.has("_isModifier")) {
            this.parseElementProperties(this.getJObject(json, "_isModifier"), res.getIsModifierElement());
        }
        if (json.has("isModifierReason")) {
            res.setIsModifierReasonElement(this.parseString(json.get("isModifierReason").getAsString()));
        }
        if (json.has("_isModifierReason")) {
            this.parseElementProperties(this.getJObject(json, "_isModifierReason"), res.getIsModifierReasonElement());
        }
        if (json.has("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(json.get("isSummary").getAsBoolean()));
        }
        if (json.has("_isSummary")) {
            this.parseElementProperties(this.getJObject(json, "_isSummary"), res.getIsSummaryElement());
        }
        if (json.has("binding")) {
            res.setBinding(this.parseElementDefinitionBindingComponent(this.getJObject(json, "binding")));
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseElementDefinitionMappingComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementDefinitionSlicingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("discriminator")) {
            JsonArray array = json.getAsJsonArray("discriminator");
            for (int i = 0; i < array.size(); ++i) {
                res.getDiscriminator().add(this.parseElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("ordered")) {
            res.setOrderedElement(this.parseBoolean(json.get("ordered").getAsBoolean()));
        }
        if (json.has("_ordered")) {
            this.parseElementProperties(this.getJObject(json, "_ordered"), res.getOrderedElement());
        }
        if (json.has("rules")) {
            res.setRulesElement(this.parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        }
        if (json.has("_rules")) {
            this.parseElementProperties(this.getJObject(json, "_rules"), res.getRulesElement());
        }
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementDefinitionSlicingDiscriminatorComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementDefinitionBaseComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseUnsignedInt(json.get("min").getAsString()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementDefinitionTypeRefComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseUri(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("targetProfile")) {
            array = json.getAsJsonArray("targetProfile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getTargetProfile().add(new CanonicalType());
                    continue;
                }
                res.getTargetProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_targetProfile")) {
            array = json.getAsJsonArray("_targetProfile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTargetProfile().size()) {
                    res.getTargetProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTargetProfile().get(i));
            }
        }
        if (json.has("aggregation")) {
            array = json.getAsJsonArray("aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAggregation().add(new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory(), ElementDefinition.AggregationMode.NULL));
                    continue;
                }
                res.getAggregation().add(this.parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            }
        }
        if (json.has("_aggregation")) {
            array = json.getAsJsonArray("_aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAggregation().size()) {
                    res.getAggregation().add(this.parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(this.getJObject(json, "_versioning"), res.getVersioningElement());
        }
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementDefinitionExampleComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementDefinitionConstraintComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseId(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(this.getJObject(json, "_key"), res.getKeyElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(this.getJObject(json, "_requirements"), res.getRequirementsElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("human")) {
            res.setHumanElement(this.parseString(json.get("human").getAsString()));
        }
        if (json.has("_human")) {
            this.parseElementProperties(this.getJObject(json, "_human"), res.getHumanElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(this.getJObject(json, "_xpath"), res.getXpathElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseCanonical(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementDefinitionBindingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(this.getJObject(json, "_strength"), res.getStrengthElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementDefinitionMappingComponentProperties(json, res);
        return res;
    }

    protected void parseElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(this.getJObject(json, "_identity"), res.getIdentityElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("map")) {
            res.setMapElement(this.parseString(json.get("map").getAsString()));
        }
        if (json.has("_map")) {
            this.parseElementProperties(this.getJObject(json, "_map"), res.getMapElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
    }

    protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
        Expression res = new Expression();
        this.parseExpressionProperties(json, res);
        return res;
    }

    protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseId(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
    }

    protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseExtensionProperties(json, res);
        return res;
    }

    protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseDataTypeProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseHumanNameProperties(json, res);
        return res;
    }

    protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("family")) {
            res.setFamilyElement(this.parseString(json.get("family").getAsString()));
        }
        if (json.has("_family")) {
            this.parseElementProperties(this.getJObject(json, "_family"), res.getFamilyElement());
        }
        if (json.has("given")) {
            array = json.getAsJsonArray("given");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getGiven().add(new StringType());
                    continue;
                }
                res.getGiven().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_given")) {
            array = json.getAsJsonArray("_given");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getGiven().size()) {
                    res.getGiven().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
            }
        }
        if (json.has("prefix")) {
            array = json.getAsJsonArray("prefix");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPrefix().add(new StringType());
                    continue;
                }
                res.getPrefix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_prefix")) {
            array = json.getAsJsonArray("_prefix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPrefix().size()) {
                    res.getPrefix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
            }
        }
        if (json.has("suffix")) {
            array = json.getAsJsonArray("suffix");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSuffix().add(new StringType());
                    continue;
                }
                res.getSuffix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_suffix")) {
            array = json.getAsJsonArray("_suffix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSuffix().size()) {
                    res.getSuffix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseIdentifierProperties(json, res);
        return res;
    }

    protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("assigner")) {
            res.setAssigner(this.parseReference(this.getJObject(json, "assigner")));
        }
    }

    protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
        MarketingStatus res = new MarketingStatus();
        this.parseMarketingStatusProperties(json, res);
        return res;
    }

    protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
        this.parseBackboneTypeProperties(json, res);
        if (json.has("country")) {
            res.setCountry(this.parseCodeableConcept(this.getJObject(json, "country")));
        }
        if (json.has("jurisdiction")) {
            res.setJurisdiction(this.parseCodeableConcept(this.getJObject(json, "jurisdiction")));
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("dateRange")) {
            res.setDateRange(this.parsePeriod(this.getJObject(json, "dateRange")));
        }
        if (json.has("restoreDate")) {
            res.setRestoreDateElement(this.parseDateTime(json.get("restoreDate").getAsString()));
        }
        if (json.has("_restoreDate")) {
            this.parseElementProperties(this.getJObject(json, "_restoreDate"), res.getRestoreDateElement());
        }
    }

    protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseMetaProperties(json, res);
        return res;
    }

    protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDataTypeProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseId(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(this.getJObject(json, "_versionId"), res.getVersionIdElement());
        }
        if (json.has("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(json.get("lastUpdated").getAsString()));
        }
        if (json.has("_lastUpdated")) {
            this.parseElementProperties(this.getJObject(json, "_lastUpdated"), res.getLastUpdatedElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProfile().add(new CanonicalType());
                    continue;
                }
                res.getProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("security")) {
            array = json.getAsJsonArray("security");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurity().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
        Money res = new Money();
        this.parseMoneyProperties(json, res);
        return res;
    }

    protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("currency")) {
            res.setCurrencyElement(this.parseCode(json.get("currency").getAsString()));
        }
        if (json.has("_currency")) {
            this.parseElementProperties(this.getJObject(json, "_currency"), res.getCurrencyElement());
        }
    }

    protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseNarrativeProperties(json, res);
        return res;
    }

    protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("div")) {
            res.setDiv(this.parseXhtml(json.get("div").getAsString()));
        }
    }

    protected OrderedDistribution parseOrderedDistribution(JsonObject json) throws IOException, FHIRFormatError {
        OrderedDistribution res = new OrderedDistribution();
        this.parseOrderedDistributionProperties(json, res);
        return res;
    }

    protected void parseOrderedDistributionProperties(JsonObject json, OrderedDistribution res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("numberOfIntervals")) {
            res.setNumberOfIntervalsElement(this.parseInteger(json.get("numberOfIntervals").getAsLong()));
        }
        if (json.has("_numberOfIntervals")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfIntervals"), res.getNumberOfIntervalsElement());
        }
        if (json.has("bottomOfFirstInterval")) {
            res.setBottomOfFirstInterval(this.parseQuantity(this.getJObject(json, "bottomOfFirstInterval")));
        }
        if (json.has("interval")) {
            array = json.getAsJsonArray("interval");
            for (i = 0; i < array.size(); ++i) {
                res.getInterval().add(this.parseOrderedDistributionIntervalComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topOfInterval")) {
            res.setTopOfInterval(this.parseQuantity(this.getJObject(json, "topOfInterval")));
        }
    }

    protected OrderedDistribution.OrderedDistributionIntervalComponent parseOrderedDistributionIntervalComponent(JsonObject json) throws IOException, FHIRFormatError {
        OrderedDistribution.OrderedDistributionIntervalComponent res = new OrderedDistribution.OrderedDistributionIntervalComponent();
        this.parseOrderedDistributionIntervalComponentProperties(json, res);
        return res;
    }

    protected void parseOrderedDistributionIntervalComponentProperties(JsonObject json, OrderedDistribution.OrderedDistributionIntervalComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("rankOrder")) {
            res.setRankOrderElement(this.parseInteger(json.get("rankOrder").getAsLong()));
        }
        if (json.has("_rankOrder")) {
            this.parseElementProperties(this.getJObject(json, "_rankOrder"), res.getRankOrderElement());
        }
        if (json.has("intervalStatistic")) {
            JsonArray array = json.getAsJsonArray("intervalStatistic");
            for (int i = 0; i < array.size(); ++i) {
                res.getIntervalStatistic().add(this.parseStatistic(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseParameterDefinitionProperties(json, res);
        return res;
    }

    protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
    }

    protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
        Period res = new Period();
        this.parsePeriodProperties(json, res);
        return res;
    }

    protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseDateTime(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseDateTime(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
    }

    protected Population parsePopulation(JsonObject json) throws IOException, FHIRFormatError {
        Population res = new Population();
        this.parsePopulationProperties(json, res);
        return res;
    }

    protected void parsePopulationProperties(JsonObject json, Population res) throws IOException, FHIRFormatError {
        this.parseBackboneTypeProperties(json, res);
        DataType age = this.parseType("age", json);
        if (age != null) {
            res.setAge(age);
        }
        if (json.has("gender")) {
            res.setGender(this.parseCodeableConcept(this.getJObject(json, "gender")));
        }
        if (json.has("race")) {
            res.setRace(this.parseCodeableConcept(this.getJObject(json, "race")));
        }
        if (json.has("physiologicalCondition")) {
            res.setPhysiologicalCondition(this.parseCodeableConcept(this.getJObject(json, "physiologicalCondition")));
        }
    }

    protected ProdCharacteristic parseProdCharacteristic(JsonObject json) throws IOException, FHIRFormatError {
        ProdCharacteristic res = new ProdCharacteristic();
        this.parseProdCharacteristicProperties(json, res);
        return res;
    }

    protected void parseProdCharacteristicProperties(JsonObject json, ProdCharacteristic res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("height")) {
            res.setHeight(this.parseQuantity(this.getJObject(json, "height")));
        }
        if (json.has("width")) {
            res.setWidth(this.parseQuantity(this.getJObject(json, "width")));
        }
        if (json.has("depth")) {
            res.setDepth(this.parseQuantity(this.getJObject(json, "depth")));
        }
        if (json.has("weight")) {
            res.setWeight(this.parseQuantity(this.getJObject(json, "weight")));
        }
        if (json.has("nominalVolume")) {
            res.setNominalVolume(this.parseQuantity(this.getJObject(json, "nominalVolume")));
        }
        if (json.has("externalDiameter")) {
            res.setExternalDiameter(this.parseQuantity(this.getJObject(json, "externalDiameter")));
        }
        if (json.has("shape")) {
            res.setShapeElement(this.parseString(json.get("shape").getAsString()));
        }
        if (json.has("_shape")) {
            this.parseElementProperties(this.getJObject(json, "_shape"), res.getShapeElement());
        }
        if (json.has("color")) {
            array = json.getAsJsonArray("color");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getColor().add(new StringType());
                    continue;
                }
                res.getColor().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_color")) {
            array = json.getAsJsonArray("_color");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getColor().size()) {
                    res.getColor().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getColor().get(i));
            }
        }
        if (json.has("imprint")) {
            array = json.getAsJsonArray("imprint");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImprint().add(new StringType());
                    continue;
                }
                res.getImprint().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_imprint")) {
            array = json.getAsJsonArray("_imprint");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImprint().size()) {
                    res.getImprint().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImprint().get(i));
            }
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("scoring")) {
            res.setScoring(this.parseCodeableConcept(this.getJObject(json, "scoring")));
        }
    }

    protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
        ProductShelfLife res = new ProductShelfLife();
        this.parseProductShelfLifeProperties(json, res);
        return res;
    }

    protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
        DataType period;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((period = this.parseType("period", json)) != null) {
            res.setPeriod(period);
        }
        if (json.has("specialPrecautionsForStorage")) {
            JsonArray array = json.getAsJsonArray("specialPrecautionsForStorage");
            for (int i = 0; i < array.size(); ++i) {
                res.getSpecialPrecautionsForStorage().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseQuantityProperties(json, res);
        return res;
    }

    protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(this.getJObject(json, "_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(this.getJObject(json, "_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
    }

    protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
        Range res = new Range();
        this.parseRangeProperties(json, res);
        return res;
    }

    protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseQuantity(this.getJObject(json, "low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseQuantity(this.getJObject(json, "high")));
        }
    }

    protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseRatioProperties(json, res);
        return res;
    }

    protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("numerator")) {
            res.setNumerator(this.parseQuantity(this.getJObject(json, "numerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(this.getJObject(json, "denominator")));
        }
    }

    protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseReferenceProperties(json, res);
        return res;
    }

    protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseUri(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
    }

    protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseRelatedArtifactProperties(json, res);
        return res;
    }

    protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(this.getJObject(json, "_label"), res.getLabelElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("citation")) {
            res.setCitationElement(this.parseMarkdown(json.get("citation").getAsString()));
        }
        if (json.has("_citation")) {
            this.parseElementProperties(this.getJObject(json, "_citation"), res.getCitationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(this.getJObject(json, "document")));
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCanonical(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(this.getJObject(json, "_resource"), res.getResourceElement());
        }
    }

    protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseSampledDataProperties(json, res);
        return res;
    }

    protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseQuantity(this.getJObject(json, "origin")));
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(this.getJObject(json, "_period"), res.getPeriodElement());
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
        }
        if (json.has("_lowerLimit")) {
            this.parseElementProperties(this.getJObject(json, "_lowerLimit"), res.getLowerLimitElement());
        }
        if (json.has("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(json.get("upperLimit").getAsBigDecimal()));
        }
        if (json.has("_upperLimit")) {
            this.parseElementProperties(this.getJObject(json, "_upperLimit"), res.getUpperLimitElement());
        }
        if (json.has("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(json.get("dimensions").getAsString()));
        }
        if (json.has("_dimensions")) {
            this.parseElementProperties(this.getJObject(json, "_dimensions"), res.getDimensionsElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseString(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseSignatureProperties(json, res);
        return res;
    }

    protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseInstant(json.get("when").getAsString()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(this.getJObject(json, "_when"), res.getWhenElement());
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(this.getJObject(json, "who")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(this.getJObject(json, "onBehalfOf")));
        }
        if (json.has("targetFormat")) {
            res.setTargetFormatElement(this.parseCode(json.get("targetFormat").getAsString()));
        }
        if (json.has("_targetFormat")) {
            this.parseElementProperties(this.getJObject(json, "_targetFormat"), res.getTargetFormatElement());
        }
        if (json.has("sigFormat")) {
            res.setSigFormatElement(this.parseCode(json.get("sigFormat").getAsString()));
        }
        if (json.has("_sigFormat")) {
            this.parseElementProperties(this.getJObject(json, "_sigFormat"), res.getSigFormatElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected Statistic parseStatistic(JsonObject json) throws IOException, FHIRFormatError {
        Statistic res = new Statistic();
        this.parseStatisticProperties(json, res);
        return res;
    }

    protected void parseStatisticProperties(JsonObject json, Statistic res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("statisticType")) {
            res.setStatisticType(this.parseCodeableConcept(this.getJObject(json, "statisticType")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("numberOfEvents")) {
            res.setNumberOfEventsElement(this.parseInteger(json.get("numberOfEvents").getAsLong()));
        }
        if (json.has("_numberOfEvents")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfEvents"), res.getNumberOfEventsElement());
        }
        if (json.has("sampleSize")) {
            res.setSampleSize(this.parseStatisticSampleSizeComponent(this.getJObject(json, "sampleSize")));
        }
        if (json.has("attributeEstimate")) {
            array = json.getAsJsonArray("attributeEstimate");
            for (i = 0; i < array.size(); ++i) {
                res.getAttributeEstimate().add(this.parseStatisticAttributeEstimateComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modelCharacteristic")) {
            array = json.getAsJsonArray("modelCharacteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getModelCharacteristic().add(this.parseStatisticModelCharacteristicComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Statistic.StatisticSampleSizeComponent parseStatisticSampleSizeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Statistic.StatisticSampleSizeComponent res = new Statistic.StatisticSampleSizeComponent();
        this.parseStatisticSampleSizeComponentProperties(json, res);
        return res;
    }

    protected void parseStatisticSampleSizeComponentProperties(JsonObject json, Statistic.StatisticSampleSizeComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("numberOfStudies")) {
            res.setNumberOfStudiesElement(this.parseInteger(json.get("numberOfStudies").getAsLong()));
        }
        if (json.has("_numberOfStudies")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfStudies"), res.getNumberOfStudiesElement());
        }
        if (json.has("numberOfParticipants")) {
            res.setNumberOfParticipantsElement(this.parseInteger(json.get("numberOfParticipants").getAsLong()));
        }
        if (json.has("_numberOfParticipants")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfParticipants"), res.getNumberOfParticipantsElement());
        }
        if (json.has("knownDataCount")) {
            res.setKnownDataCountElement(this.parseInteger(json.get("knownDataCount").getAsLong()));
        }
        if (json.has("_knownDataCount")) {
            this.parseElementProperties(this.getJObject(json, "_knownDataCount"), res.getKnownDataCountElement());
        }
    }

    protected Statistic.StatisticAttributeEstimateComponent parseStatisticAttributeEstimateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Statistic.StatisticAttributeEstimateComponent res = new Statistic.StatisticAttributeEstimateComponent();
        this.parseStatisticAttributeEstimateComponentProperties(json, res);
        return res;
    }

    protected void parseStatisticAttributeEstimateComponentProperties(JsonObject json, Statistic.StatisticAttributeEstimateComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("level")) {
            res.setLevelElement(this.parseDecimal(json.get("level").getAsBigDecimal()));
        }
        if (json.has("_level")) {
            this.parseElementProperties(this.getJObject(json, "_level"), res.getLevelElement());
        }
        if (json.has("range")) {
            res.setRange(this.parseRange(this.getJObject(json, "range")));
        }
        if (json.has("attributeEstimate")) {
            array = json.getAsJsonArray("attributeEstimate");
            for (i = 0; i < array.size(); ++i) {
                res.getAttributeEstimate().add(this.parseStatisticAttributeEstimateAttributeEstimateComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Statistic.StatisticAttributeEstimateAttributeEstimateComponent parseStatisticAttributeEstimateAttributeEstimateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Statistic.StatisticAttributeEstimateAttributeEstimateComponent res = new Statistic.StatisticAttributeEstimateAttributeEstimateComponent();
        this.parseStatisticAttributeEstimateAttributeEstimateComponentProperties(json, res);
        return res;
    }

    protected void parseStatisticAttributeEstimateAttributeEstimateComponentProperties(JsonObject json, Statistic.StatisticAttributeEstimateAttributeEstimateComponent res) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("level")) {
            res.setLevelElement(this.parseDecimal(json.get("level").getAsBigDecimal()));
        }
        if (json.has("_level")) {
            this.parseElementProperties(this.getJObject(json, "_level"), res.getLevelElement());
        }
        if (json.has("range")) {
            res.setRange(this.parseRange(this.getJObject(json, "range")));
        }
    }

    protected Statistic.StatisticModelCharacteristicComponent parseStatisticModelCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        Statistic.StatisticModelCharacteristicComponent res = new Statistic.StatisticModelCharacteristicComponent();
        this.parseStatisticModelCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseStatisticModelCharacteristicComponentProperties(JsonObject json, Statistic.StatisticModelCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("variable")) {
            JsonArray array = json.getAsJsonArray("variable");
            for (int i = 0; i < array.size(); ++i) {
                res.getVariable().add(this.parseStatisticModelCharacteristicVariableComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Statistic.StatisticModelCharacteristicVariableComponent parseStatisticModelCharacteristicVariableComponent(JsonObject json) throws IOException, FHIRFormatError {
        Statistic.StatisticModelCharacteristicVariableComponent res = new Statistic.StatisticModelCharacteristicVariableComponent();
        this.parseStatisticModelCharacteristicVariableComponentProperties(json, res);
        return res;
    }

    protected void parseStatisticModelCharacteristicVariableComponentProperties(JsonObject json, Statistic.StatisticModelCharacteristicVariableComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        if (json.has("variableDefinition")) {
            res.setVariableDefinition(this.parseReference(this.getJObject(json, "variableDefinition")));
        }
        if (json.has("handling")) {
            res.setHandlingElement(this.parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        }
        if (json.has("_handling")) {
            this.parseElementProperties(this.getJObject(json, "_handling"), res.getHandlingElement());
        }
        if (json.has("valueCategory")) {
            array = json.getAsJsonArray("valueCategory");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueQuantity")) {
            array = json.getAsJsonArray("valueQuantity");
            for (i = 0; i < array.size(); ++i) {
                res.getValueQuantity().add(this.parseQuantity(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueRange")) {
            array = json.getAsJsonArray("valueRange");
            for (i = 0; i < array.size(); ++i) {
                res.getValueRange().add(this.parseRange(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseTimingProperties(json, res);
        return res;
    }

    protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneTypeProperties(json, res);
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getEvent().add(new DateTimeType());
                    continue;
                }
                res.getEvent().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_event")) {
            array = json.getAsJsonArray("_event");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getEvent().size()) {
                    res.getEvent().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
            }
        }
        if (json.has("repeat")) {
            res.setRepeat(this.parseTimingRepeatComponent(this.getJObject(json, "repeat")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected Timing.TimingRepeatComponent parseTimingRepeatComponent(JsonObject json) throws IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseTimingRepeatComponentProperties(json, res);
        return res;
    }

    protected void parseTimingRepeatComponentProperties(JsonObject json, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseElementProperties(json, res);
        DataType bounds = this.parseType("bounds", json);
        if (bounds != null) {
            res.setBounds(bounds);
        }
        if (json.has("count")) {
            res.setCountElement(this.parsePositiveInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
        if (json.has("countMax")) {
            res.setCountMaxElement(this.parsePositiveInt(json.get("countMax").getAsString()));
        }
        if (json.has("_countMax")) {
            this.parseElementProperties(this.getJObject(json, "_countMax"), res.getCountMaxElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(this.getJObject(json, "_duration"), res.getDurationElement());
        }
        if (json.has("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(json.get("durationMax").getAsBigDecimal()));
        }
        if (json.has("_durationMax")) {
            this.parseElementProperties(this.getJObject(json, "_durationMax"), res.getDurationMaxElement());
        }
        if (json.has("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_durationUnit")) {
            this.parseElementProperties(this.getJObject(json, "_durationUnit"), res.getDurationUnitElement());
        }
        if (json.has("frequency")) {
            res.setFrequencyElement(this.parsePositiveInt(json.get("frequency").getAsString()));
        }
        if (json.has("_frequency")) {
            this.parseElementProperties(this.getJObject(json, "_frequency"), res.getFrequencyElement());
        }
        if (json.has("frequencyMax")) {
            res.setFrequencyMaxElement(this.parsePositiveInt(json.get("frequencyMax").getAsString()));
        }
        if (json.has("_frequencyMax")) {
            this.parseElementProperties(this.getJObject(json, "_frequencyMax"), res.getFrequencyMaxElement());
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(this.getJObject(json, "_period"), res.getPeriodElement());
        }
        if (json.has("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(json.get("periodMax").getAsBigDecimal()));
        }
        if (json.has("_periodMax")) {
            this.parseElementProperties(this.getJObject(json, "_periodMax"), res.getPeriodMaxElement());
        }
        if (json.has("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_periodUnit")) {
            this.parseElementProperties(this.getJObject(json, "_periodUnit"), res.getPeriodUnitElement());
        }
        if (json.has("dayOfWeek")) {
            array = json.getAsJsonArray("dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDayOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
                    continue;
                }
                res.getDayOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_dayOfWeek")) {
            array = json.getAsJsonArray("_dayOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDayOfWeek().size()) {
                    res.getDayOfWeek().add(this.parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
            }
        }
        if (json.has("timeOfDay")) {
            array = json.getAsJsonArray("timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getTimeOfDay().add(new TimeType());
                    continue;
                }
                res.getTimeOfDay().add(this.parseTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_timeOfDay")) {
            array = json.getAsJsonArray("_timeOfDay");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTimeOfDay().size()) {
                    res.getTimeOfDay().add(this.parseTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
            }
        }
        if (json.has("when")) {
            array = json.getAsJsonArray("when");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getWhen().add(new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory(), Timing.EventTiming.NULL));
                    continue;
                }
                res.getWhen().add(this.parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
            }
        }
        if (json.has("_when")) {
            array = json.getAsJsonArray("_when");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getWhen().size()) {
                    res.getWhen().add(this.parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
            }
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(json.get("offset").getAsString()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(this.getJObject(json, "_offset"), res.getOffsetElement());
        }
    }

    protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseTriggerDefinitionProperties(json, res);
        return res;
    }

    protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
        DataType timing;
        this.parseDataTypeProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("data")) {
            JsonArray array = json.getAsJsonArray("data");
            for (int i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            res.setCondition(this.parseExpression(this.getJObject(json, "condition")));
        }
    }

    protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseUsageContextProperties(json, res);
        return res;
    }

    protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseDataTypeProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected void parseCanonicalResourceProperties(JsonObject json, CanonicalResource res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
    }

    protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("contained")) {
            array = json.getAsJsonArray("contained");
            for (i = 0; i < array.size(); ++i) {
                res.getContained().add(this.parseResource(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("extension")) {
            array = json.getAsJsonArray("extension");
            for (i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modifierExtension")) {
            array = json.getAsJsonArray("modifierExtension");
            for (i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseMetadataResourceProperties(JsonObject json, MetadataResource res) throws IOException, FHIRFormatError {
        this.parseCanonicalResourceProperties(json, res);
    }

    protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
        this.parseBaseProperties(json, res);
        if (json.has("id")) {
            res.setIdElement(this.parseId(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(this.getJObject(json, "_id"), res.getIdElement());
        }
        if (json.has("meta")) {
            res.setMeta(this.parseMeta(this.getJObject(json, "meta")));
        }
        if (json.has("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(json.get("implicitRules").getAsString()));
        }
        if (json.has("_implicitRules")) {
            this.parseElementProperties(this.getJObject(json, "_implicitRules"), res.getImplicitRulesElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
    }

    protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
        Account res = new Account();
        this.parseAccountProperties(json, res);
        return res;
    }

    protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("servicePeriod")) {
            res.setServicePeriod(this.parsePeriod(this.getJObject(json, "servicePeriod")));
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseAccountCoverageComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("guarantor")) {
            array = json.getAsJsonArray("guarantor");
            for (i = 0; i < array.size(); ++i) {
                res.getGuarantor().add(this.parseAccountGuarantorComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(this.getJObject(json, "partOf")));
        }
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseAccountCoverageComponentProperties(json, res);
        return res;
    }

    protected void parseAccountCoverageComponentProperties(JsonObject json, Account.CoverageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parsePositiveInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json) throws IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseAccountGuarantorComponentProperties(json, res);
        return res;
    }

    protected void parseAccountGuarantorComponentProperties(JsonObject json, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
        if (json.has("onHold")) {
            res.setOnHoldElement(this.parseBoolean(json.get("onHold").getAsBoolean()));
        }
        if (json.has("_onHold")) {
            this.parseElementProperties(this.getJObject(json, "_onHold"), res.getOnHoldElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseActivityDefinitionProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType product;
        DataType timing;
        int i2;
        DataType subject;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i3 = 0; i3 < array.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getContact().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = json.getAsJsonArray("useContext");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getUseContext().add(this.parseUsageContext(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = json.getAsJsonArray("jurisdiction");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(this.getJObject(json, "_usage"), res.getUsageElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            JsonArray array = json.getAsJsonArray("topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("author")) {
            JsonArray array = json.getAsJsonArray("author");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthor().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("editor")) {
            JsonArray array = json.getAsJsonArray("editor");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEditor().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = json.getAsJsonArray("reviewer");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReviewer().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = json.getAsJsonArray("endorser");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getEndorser().add(this.parseContactDetail(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = json.getAsJsonArray("relatedArtifact");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("library")) {
            JsonArray array = json.getAsJsonArray("library");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getLibrary().add(new CanonicalType());
                    continue;
                }
                res.getLibrary().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_library")) {
            JsonArray array = json.getAsJsonArray("_library");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getLibrary().size()) {
                    res.getLibrary().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getLibrary().get(i2));
            }
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.RequestResourceType.NULL, new ActivityDefinition.RequestResourceTypeEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("participant")) {
            JsonArray array = json.getAsJsonArray("participant");
            for (int i4 = 0; i4 < array.size(); ++i4) {
                res.getParticipant().add(this.parseActivityDefinitionParticipantComponent(array.get(i4).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("dosage")) {
            JsonArray array = json.getAsJsonArray("dosage");
            for (i = 0; i < array.size(); ++i) {
                res.getDosage().add(this.parseDosage(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            JsonArray array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimenRequirement")) {
            JsonArray array = json.getAsJsonArray("specimenRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimenRequirement().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("observationRequirement")) {
            JsonArray array = json.getAsJsonArray("observationRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getObservationRequirement().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("observationResultRequirement")) {
            JsonArray array = json.getAsJsonArray("observationResultRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getObservationResultRequirement().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("transform")) {
            res.setTransformElement(this.parseCanonical(json.get("transform").getAsString()));
        }
        if (json.has("_transform")) {
            this.parseElementProperties(this.getJObject(json, "_transform"), res.getTransformElement());
        }
        if (json.has("dynamicValue")) {
            JsonArray array = json.getAsJsonArray("dynamicValue");
            for (i = 0; i < array.size(); ++i) {
                res.getDynamicValue().add(this.parseActivityDefinitionDynamicValueComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseActivityDefinitionParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(JsonObject json) throws IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseActivityDefinitionDynamicValueComponentProperties(json, res);
        return res;
    }

    protected void parseActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("expression")) {
            res.setExpression(this.parseExpression(this.getJObject(json, "expression")));
        }
    }

    protected AdministrableProductDefinition parseAdministrableProductDefinition(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition res = new AdministrableProductDefinition();
        this.parseAdministrableProductDefinitionProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionProperties(JsonObject json, AdministrableProductDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("administrableDoseForm")) {
            res.setAdministrableDoseForm(this.parseCodeableConcept(this.getJObject(json, "administrableDoseForm")));
        }
        if (json.has("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(this.getJObject(json, "unitOfPresentation")));
        }
        if (json.has("producedFrom")) {
            array = json.getAsJsonArray("producedFrom");
            for (i = 0; i < array.size(); ++i) {
                res.getProducedFrom().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("device")) {
            array = json.getAsJsonArray("device");
            for (i = 0; i < array.size(); ++i) {
                res.getDevice().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseAdministrableProductDefinitionPropertyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("routeOfAdministration")) {
            array = json.getAsJsonArray("routeOfAdministration");
            for (i = 0; i < array.size(); ++i) {
                res.getRouteOfAdministration().add(this.parseAdministrableProductDefinitionRouteOfAdministrationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent parseAdministrableProductDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent();
        this.parseAdministrableProductDefinitionPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionPropertyComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("firstDose")) {
            res.setFirstDose(this.parseQuantity(this.getJObject(json, "firstDose")));
        }
        if (json.has("maxSingleDose")) {
            res.setMaxSingleDose(this.parseQuantity(this.getJObject(json, "maxSingleDose")));
        }
        if (json.has("maxDosePerDay")) {
            res.setMaxDosePerDay(this.parseQuantity(this.getJObject(json, "maxDosePerDay")));
        }
        if (json.has("maxDosePerTreatmentPeriod")) {
            res.setMaxDosePerTreatmentPeriod(this.parseRatio(this.getJObject(json, "maxDosePerTreatmentPeriod")));
        }
        if (json.has("maxTreatmentPeriod")) {
            res.setMaxTreatmentPeriod(this.parseDuration(this.getJObject(json, "maxTreatmentPeriod")));
        }
        if (json.has("targetSpecies")) {
            JsonArray array = json.getAsJsonArray("targetSpecies");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetSpecies().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("withdrawalPeriod")) {
            JsonArray array = json.getAsJsonArray("withdrawalPeriod");
            for (int i = 0; i < array.size(); ++i) {
                res.getWithdrawalPeriod().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
        this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, res);
        return res;
    }

    protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("tissue")) {
            res.setTissue(this.parseCodeableConcept(this.getJObject(json, "tissue")));
        }
        if (json.has("value")) {
            res.setValue(this.parseQuantity(this.getJObject(json, "value")));
        }
        if (json.has("supportingInformation")) {
            res.setSupportingInformationElement(this.parseString(json.get("supportingInformation").getAsString()));
        }
        if (json.has("_supportingInformation")) {
            this.parseElementProperties(this.getJObject(json, "_supportingInformation"), res.getSupportingInformationElement());
        }
    }

    protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseAdverseEventProperties(json, res);
        return res;
    }

    protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("actuality")) {
            res.setActualityElement(this.parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
        }
        if (json.has("_actuality")) {
            this.parseElementProperties(this.getJObject(json, "_actuality"), res.getActualityElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("detected")) {
            res.setDetectedElement(this.parseDateTime(json.get("detected").getAsString()));
        }
        if (json.has("_detected")) {
            this.parseElementProperties(this.getJObject(json, "_detected"), res.getDetectedElement());
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("resultingCondition")) {
            JsonArray array2 = json.getAsJsonArray("resultingCondition");
            for (i = 0; i < array2.size(); ++i) {
                res.getResultingCondition().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(this.getJObject(json, "seriousness")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(this.getJObject(json, "outcome")));
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(this.getJObject(json, "recorder")));
        }
        if (json.has("participant")) {
            JsonArray array3 = json.getAsJsonArray("participant");
            for (i = 0; i < array3.size(); ++i) {
                res.getParticipant().add(this.parseAdverseEventParticipantComponent(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("suspectEntity")) {
            JsonArray array4 = json.getAsJsonArray("suspectEntity");
            for (i = 0; i < array4.size(); ++i) {
                res.getSuspectEntity().add(this.parseAdverseEventSuspectEntityComponent(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributingFactor")) {
            JsonArray array5 = json.getAsJsonArray("contributingFactor");
            for (i = 0; i < array5.size(); ++i) {
                res.getContributingFactor().add(this.parseAdverseEventContributingFactorComponent(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("preventiveAction")) {
            JsonArray array6 = json.getAsJsonArray("preventiveAction");
            for (i = 0; i < array6.size(); ++i) {
                res.getPreventiveAction().add(this.parseAdverseEventPreventiveActionComponent(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("mitigatingAction")) {
            JsonArray array7 = json.getAsJsonArray("mitigatingAction");
            for (i = 0; i < array7.size(); ++i) {
                res.getMitigatingAction().add(this.parseAdverseEventMitigatingActionComponent(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array8 = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array8.size(); ++i) {
                res.getSupportingInfo().add(this.parseAdverseEventSupportingInfoComponent(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("study")) {
            JsonArray array9 = json.getAsJsonArray("study");
            for (i = 0; i < array9.size(); ++i) {
                res.getStudy().add(this.parseReference(array9.get(i).getAsJsonObject()));
            }
        }
    }

    protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
        this.parseAdverseEventParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventParticipantComponentProperties(JsonObject json, AdverseEvent.AdverseEventParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseAdverseEventSuspectEntityComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType instance = this.parseType("instance", json);
        if (instance != null) {
            res.setInstance(instance);
        }
        if (json.has("causality")) {
            res.setCausality(this.parseAdverseEventSuspectEntityCausalityComponent(this.getJObject(json, "causality")));
        }
    }

    protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
        this.parseAdverseEventSuspectEntityCausalityComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("assessmentMethod")) {
            res.setAssessmentMethod(this.parseCodeableConcept(this.getJObject(json, "assessmentMethod")));
        }
        if (json.has("entityRelatedness")) {
            res.setEntityRelatedness(this.parseCodeableConcept(this.getJObject(json, "entityRelatedness")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected AdverseEvent.AdverseEventContributingFactorComponent parseAdverseEventContributingFactorComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventContributingFactorComponent res = new AdverseEvent.AdverseEventContributingFactorComponent();
        this.parseAdverseEventContributingFactorComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventContributingFactorComponentProperties(JsonObject json, AdverseEvent.AdverseEventContributingFactorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventPreventiveActionComponent parseAdverseEventPreventiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventPreventiveActionComponent res = new AdverseEvent.AdverseEventPreventiveActionComponent();
        this.parseAdverseEventPreventiveActionComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventPreventiveActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventPreventiveActionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventMitigatingActionComponent parseAdverseEventMitigatingActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventMitigatingActionComponent res = new AdverseEvent.AdverseEventMitigatingActionComponent();
        this.parseAdverseEventMitigatingActionComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventMitigatingActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventMitigatingActionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
        this.parseAdverseEventSupportingInfoComponentProperties(json, res);
        return res;
    }

    protected void parseAdverseEventSupportingInfoComponentProperties(JsonObject json, AdverseEvent.AdverseEventSupportingInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseAllergyIntoleranceProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
        int i;
        DataType onset;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(this.getJObject(json, "clinicalStatus")));
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(this.getJObject(json, "verificationStatus")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getCategory().add(new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), AllergyIntolerance.AllergyIntoleranceCategory.NULL));
                    continue;
                }
                res.getCategory().add(this.parseEnumeration(array.get(i2).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
            }
        }
        if (json.has("_category")) {
            array = json.getAsJsonArray("_category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getCategory().size()) {
                    res.getCategory().add(this.parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getCategory().get(i2));
            }
        }
        if (json.has("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        }
        if (json.has("_criticality")) {
            this.parseElementProperties(this.getJObject(json, "_criticality"), res.getCriticalityElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(this.getJObject(json, "recorder")));
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(this.getJObject(json, "asserter")));
        }
        if (json.has("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(json.get("lastOccurrence").getAsString()));
        }
        if (json.has("_lastOccurrence")) {
            this.parseElementProperties(this.getJObject(json, "_lastOccurrence"), res.getLastOccurrenceElement());
        }
        if (json.has("note")) {
            JsonArray array2 = json.getAsJsonArray("note");
            for (i = 0; i < array2.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reaction")) {
            JsonArray array3 = json.getAsJsonArray("reaction");
            for (i = 0; i < array3.size(); ++i) {
                res.getReaction().add(this.parseAllergyIntoleranceReactionComponent(array3.get(i).getAsJsonObject()));
            }
        }
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseAllergyIntoleranceReactionComponentProperties(json, res);
        return res;
    }

    protected void parseAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(this.getJObject(json, "substance")));
        }
        if (json.has("manifestation")) {
            array = json.getAsJsonArray("manifestation");
            for (i = 0; i < array.size(); ++i) {
                res.getManifestation().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(this.getJObject(json, "_onset"), res.getOnsetElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(this.getJObject(json, "exposureRoute")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseAppointmentProperties(json, res);
        return res;
    }

    protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("cancelationReason")) {
            res.setCancelationReason(this.parseCodeableConcept(this.getJObject(json, "cancelationReason")));
        }
        if (json.has("serviceCategory")) {
            array = json.getAsJsonArray("serviceCategory");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(this.getJObject(json, "appointmentType")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
        if (json.has("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(json.get("minutesDuration").getAsString()));
        }
        if (json.has("_minutesDuration")) {
            this.parseElementProperties(this.getJObject(json, "_minutesDuration"), res.getMinutesDurationElement());
        }
        if (json.has("slot")) {
            array = json.getAsJsonArray("slot");
            for (i = 0; i < array.size(); ++i) {
                res.getSlot().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(json.get("patientInstruction").getAsString()));
        }
        if (json.has("_patientInstruction")) {
            this.parseElementProperties(this.getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAppointmentParticipantComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requestedPeriod")) {
            array = json.getAsJsonArray("requestedPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getRequestedPeriod().add(this.parsePeriod(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseAppointmentParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseAppointmentParticipantComponentProperties(JsonObject json, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(this.getJObject(json, "_required"), res.getRequiredElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseAppointmentResponseProperties(json, res);
        return res;
    }

    protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(this.getJObject(json, "appointment")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(this.getJObject(json, "_end"), res.getEndElement());
        }
        if (json.has("participantType")) {
            array = json.getAsJsonArray("participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
        if (json.has("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(json.get("participantStatus").getAsString(), Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
        }
        if (json.has("_participantStatus")) {
            this.parseElementProperties(this.getJObject(json, "_participantStatus"), res.getParticipantStatusElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
    }

    protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseAuditEventProperties(json, res);
        return res;
    }

    protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(this.getJObject(json, "type")));
        }
        if (json.has("subtype")) {
            array = json.getAsJsonArray("subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(this.getJObject(json, "_action"), res.getActionElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AuditEvent.AuditEventSeverity.NULL, new AuditEvent.AuditEventSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(this.getJObject(json, "_recorded"), res.getRecordedElement());
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(this.getJObject(json, "outcome")));
        }
        if (json.has("purposeOfEvent")) {
            array = json.getAsJsonArray("purposeOfEvent");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseAuditEventAgentComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("source")) {
            res.setSource(this.parseAuditEventSourceComponent(this.getJObject(json, "source")));
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseAuditEventEntityComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseAuditEventAgentComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventAgentComponentProperties(JsonObject json, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("role")) {
            array = json.getAsJsonArray("role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(this.getJObject(json, "who")));
        }
        if (json.has("altId")) {
            res.setAltIdElement(this.parseString(json.get("altId").getAsString()));
        }
        if (json.has("_altId")) {
            this.parseElementProperties(this.getJObject(json, "_altId"), res.getAltIdElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("requestor")) {
            res.setRequestorElement(this.parseBoolean(json.get("requestor").getAsBoolean()));
        }
        if (json.has("_requestor")) {
            this.parseElementProperties(this.getJObject(json, "_requestor"), res.getRequestorElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPolicy().add(new UriType());
                    continue;
                }
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("media")) {
            res.setMedia(this.parseCoding(this.getJObject(json, "media")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseAuditEventAgentNetworkComponent(this.getJObject(json, "network")));
        }
        if (json.has("purposeOfUse")) {
            array = json.getAsJsonArray("purposeOfUse");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfUse().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAgentNetworkComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseAuditEventAgentNetworkComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("address")) {
            res.setAddressElement(this.parseString(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(this.getJObject(json, "_address"), res.getAddressElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseAuditEventSourceComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventSourceComponentProperties(JsonObject json, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("site")) {
            res.setSiteElement(this.parseString(json.get("site").getAsString()));
        }
        if (json.has("_site")) {
            this.parseElementProperties(this.getJObject(json, "_site"), res.getSiteElement());
        }
        if (json.has("observer")) {
            res.setObserver(this.parseReference(this.getJObject(json, "observer")));
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseAuditEventEntityComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventEntityComponentProperties(JsonObject json, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("what")) {
            res.setWhat(this.parseReference(this.getJObject(json, "what")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(this.getJObject(json, "type")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCoding(this.getJObject(json, "role")));
        }
        if (json.has("lifecycle")) {
            res.setLifecycle(this.parseCoding(this.getJObject(json, "lifecycle")));
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("query")) {
            res.setQueryElement(this.parseBase64Binary(json.get("query").getAsString()));
        }
        if (json.has("_query")) {
            this.parseElementProperties(this.getJObject(json, "_query"), res.getQueryElement());
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseAuditEventEntityDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseAuditEventEntityDetailComponentProperties(json, res);
        return res;
    }

    protected void parseAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseBasicProperties(json, res);
        return res;
    }

    protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDate(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseBinaryProperties(json, res);
        return res;
    }

    protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
        this.parseResourceProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(this.getJObject(json, "_contentType"), res.getContentTypeElement());
        }
        if (json.has("securityContext")) {
            res.setSecurityContext(this.parseReference(this.getJObject(json, "securityContext")));
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(this.getJObject(json, "_data"), res.getDataElement());
        }
    }

    protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
        this.parseBiologicallyDerivedProductProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("productCategory")) {
            res.setProductCategoryElement(this.parseEnumeration(json.get("productCategory").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
        }
        if (json.has("_productCategory")) {
            this.parseElementProperties(this.getJObject(json, "_productCategory"), res.getProductCategoryElement());
        }
        if (json.has("productCode")) {
            res.setProductCode(this.parseCodeableConcept(this.getJObject(json, "productCode")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("request")) {
            array = json.getAsJsonArray("request");
            for (i = 0; i < array.size(); ++i) {
                res.getRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseInteger(json.get("quantity").getAsLong()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(this.getJObject(json, "_quantity"), res.getQuantityElement());
        }
        if (json.has("parent")) {
            array = json.getAsJsonArray("parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("collection")) {
            res.setCollection(this.parseBiologicallyDerivedProductCollectionComponent(this.getJObject(json, "collection")));
        }
        if (json.has("processing")) {
            array = json.getAsJsonArray("processing");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessing().add(this.parseBiologicallyDerivedProductProcessingComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("manipulation")) {
            res.setManipulation(this.parseBiologicallyDerivedProductManipulationComponent(this.getJObject(json, "manipulation")));
        }
        if (json.has("storage")) {
            array = json.getAsJsonArray("storage");
            for (i = 0; i < array.size(); ++i) {
                res.getStorage().add(this.parseBiologicallyDerivedProductStorageComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        this.parseBiologicallyDerivedProductCollectionComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
        DataType collected;
        this.parseBackboneElementProperties(json, res);
        if (json.has("collector")) {
            res.setCollector(this.parseReference(this.getJObject(json, "collector")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(this.getJObject(json, "source")));
        }
        if ((collected = this.parseType("collected", json)) != null) {
            res.setCollected(collected);
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductProcessingComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
        this.parseBiologicallyDerivedProductProcessingComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductProcessingComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws IOException, FHIRFormatError {
        DataType time;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("procedure")) {
            res.setProcedure(this.parseCodeableConcept(this.getJObject(json, "procedure")));
        }
        if (json.has("additive")) {
            res.setAdditive(this.parseReference(this.getJObject(json, "additive")));
        }
        if ((time = this.parseType("time", json)) != null) {
            res.setTime(time);
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductManipulationComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
        this.parseBiologicallyDerivedProductManipulationComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductManipulationComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws IOException, FHIRFormatError {
        DataType time;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if ((time = this.parseType("time", json)) != null) {
            res.setTime(time);
        }
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductStorageComponent(JsonObject json) throws IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
        this.parseBiologicallyDerivedProductStorageComponentProperties(json, res);
        return res;
    }

    protected void parseBiologicallyDerivedProductStorageComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("temperature")) {
            res.setTemperatureElement(this.parseDecimal(json.get("temperature").getAsBigDecimal()));
        }
        if (json.has("_temperature")) {
            this.parseElementProperties(this.getJObject(json, "_temperature"), res.getTemperatureElement());
        }
        if (json.has("scale")) {
            res.setScaleElement(this.parseEnumeration(json.get("scale").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
        }
        if (json.has("_scale")) {
            this.parseElementProperties(this.getJObject(json, "_scale"), res.getScaleElement());
        }
        if (json.has("duration")) {
            res.setDuration(this.parsePeriod(this.getJObject(json, "duration")));
        }
    }

    protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
        BodyStructure res = new BodyStructure();
        this.parseBodyStructureProperties(json, res);
        return res;
    }

    protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(this.getJObject(json, "_active"), res.getActiveElement());
        }
        if (json.has("morphology")) {
            res.setMorphology(this.parseCodeableConcept(this.getJObject(json, "morphology")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseCodeableConcept(this.getJObject(json, "location")));
        }
        if (json.has("locationQualifier")) {
            array = json.getAsJsonArray("locationQualifier");
            for (i = 0; i < array.size(); ++i) {
                res.getLocationQualifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
    }

    protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseBundleProperties(json, res);
        return res;
    }

    protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseInstant(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(this.getJObject(json, "_timestamp"), res.getTimestampElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseUnsignedInt(json.get("total").getAsString()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(this.getJObject(json, "_total"), res.getTotalElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleLinkComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseBundleEntryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("signature")) {
            res.setSignature(this.parseSignature(this.getJObject(json, "signature")));
        }
    }

    protected Bundle.BundleLinkComponent parseBundleLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBundleLinkComponentProperties(json, res);
        return res;
    }

    protected void parseBundleLinkComponentProperties(JsonObject json, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relation")) {
            res.setRelationElement(this.parseString(json.get("relation").getAsString()));
        }
        if (json.has("_relation")) {
            this.parseElementProperties(this.getJObject(json, "_relation"), res.getRelationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Bundle.BundleEntryComponent parseBundleEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBundleEntryComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryComponentProperties(JsonObject json, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("link")) {
            JsonArray array = json.getAsJsonArray("link");
            for (int i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleLinkComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fullUrl")) {
            res.setFullUrlElement(this.parseUri(json.get("fullUrl").getAsString()));
        }
        if (json.has("_fullUrl")) {
            this.parseElementProperties(this.getJObject(json, "_fullUrl"), res.getFullUrlElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(this.getJObject(json, "resource")));
        }
        if (json.has("search")) {
            res.setSearch(this.parseBundleEntrySearchComponent(this.getJObject(json, "search")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseBundleEntryRequestComponent(this.getJObject(json, "request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseBundleEntryResponseComponent(this.getJObject(json, "response")));
        }
    }

    protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBundleEntrySearchComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntrySearchComponentProperties(JsonObject json, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("score")) {
            res.setScoreElement(this.parseDecimal(json.get("score").getAsBigDecimal()));
        }
        if (json.has("_score")) {
            this.parseElementProperties(this.getJObject(json, "_score"), res.getScoreElement());
        }
    }

    protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBundleEntryRequestComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryRequestComponentProperties(JsonObject json, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("method")) {
            res.setMethodElement(this.parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(this.getJObject(json, "_method"), res.getMethodElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(json.get("ifNoneMatch").getAsString()));
        }
        if (json.has("_ifNoneMatch")) {
            this.parseElementProperties(this.getJObject(json, "_ifNoneMatch"), res.getIfNoneMatchElement());
        }
        if (json.has("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(json.get("ifModifiedSince").getAsString()));
        }
        if (json.has("_ifModifiedSince")) {
            this.parseElementProperties(this.getJObject(json, "_ifModifiedSince"), res.getIfModifiedSinceElement());
        }
        if (json.has("ifMatch")) {
            res.setIfMatchElement(this.parseString(json.get("ifMatch").getAsString()));
        }
        if (json.has("_ifMatch")) {
            this.parseElementProperties(this.getJObject(json, "_ifMatch"), res.getIfMatchElement());
        }
        if (json.has("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(json.get("ifNoneExist").getAsString()));
        }
        if (json.has("_ifNoneExist")) {
            this.parseElementProperties(this.getJObject(json, "_ifNoneExist"), res.getIfNoneExistElement());
        }
    }

    protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBundleEntryResponseComponentProperties(json, res);
        return res;
    }

    protected void parseBundleEntryResponseComponentProperties(JsonObject json, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseString(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseUri(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(this.getJObject(json, "_location"), res.getLocationElement());
        }
        if (json.has("etag")) {
            res.setEtagElement(this.parseString(json.get("etag").getAsString()));
        }
        if (json.has("_etag")) {
            this.parseElementProperties(this.getJObject(json, "_etag"), res.getEtagElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(this.getJObject(json, "_lastModified"), res.getLastModifiedElement());
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseResource(this.getJObject(json, "outcome")));
        }
    }

    protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseCapabilityStatementProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("instantiates")) {
            array = json.getAsJsonArray("instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiates().add(new CanonicalType());
                    continue;
                }
                res.getInstantiates().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiates")) {
            array = json.getAsJsonArray("_instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiates().size()) {
                    res.getInstantiates().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
            }
        }
        if (json.has("imports")) {
            array = json.getAsJsonArray("imports");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImports().add(new CanonicalType());
                    continue;
                }
                res.getImports().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_imports")) {
            array = json.getAsJsonArray("_imports");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImports().size()) {
                    res.getImports().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
            }
        }
        if (json.has("software")) {
            res.setSoftware(this.parseCapabilityStatementSoftwareComponent(this.getJObject(json, "software")));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseCapabilityStatementImplementationComponent(this.getJObject(json, "implementation")));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(this.getJObject(json, "_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("format")) {
            array = json.getAsJsonArray("format");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getFormat().add(new CodeType());
                    continue;
                }
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            array = json.getAsJsonArray("_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
            }
        }
        if (json.has("patchFormat")) {
            array = json.getAsJsonArray("patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPatchFormat().add(new CodeType());
                    continue;
                }
                res.getPatchFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_patchFormat")) {
            array = json.getAsJsonArray("_patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPatchFormat().size()) {
                    res.getPatchFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
            }
        }
        if (json.has("implementationGuide")) {
            array = json.getAsJsonArray("implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImplementationGuide().add(new CanonicalType());
                    continue;
                }
                res.getImplementationGuide().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_implementationGuide")) {
            array = json.getAsJsonArray("_implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImplementationGuide().size()) {
                    res.getImplementationGuide().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
            }
        }
        if (json.has("rest")) {
            array = json.getAsJsonArray("rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseCapabilityStatementRestComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("messaging")) {
            array = json.getAsJsonArray("messaging");
            for (i = 0; i < array.size(); ++i) {
                res.getMessaging().add(this.parseCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("document")) {
            array = json.getAsJsonArray("document");
            for (i = 0; i < array.size(); ++i) {
                res.getDocument().add(this.parseCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseCapabilityStatementSoftwareComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(this.getJObject(json, "_releaseDate"), res.getReleaseDateElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseCapabilityStatementImplementationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseCapabilityStatementRestComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Enumerations.RestfulCapabilityMode.NULL, new Enumerations.RestfulCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("security")) {
            res.setSecurity(this.parseCapabilityStatementRestSecurityComponent(this.getJObject(json, "security")));
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getCompartment().add(new CanonicalType());
                    continue;
                }
                res.getCompartment().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = json.getAsJsonArray("_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseCapabilityStatementRestSecurityComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("cors")) {
            res.setCorsElement(this.parseBoolean(json.get("cors").getAsBoolean()));
        }
        if (json.has("_cors")) {
            this.parseElementProperties(this.getJObject(json, "_cors"), res.getCorsElement());
        }
        if (json.has("service")) {
            JsonArray array = json.getAsJsonArray("service");
            for (int i = 0; i < array.size(); ++i) {
                res.getService().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseCapabilityStatementRestResourceComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("supportedProfile")) {
            array = json.getAsJsonArray("supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSupportedProfile().add(new CanonicalType());
                    continue;
                }
                res.getSupportedProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_supportedProfile")) {
            array = json.getAsJsonArray("_supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSupportedProfile().size()) {
                    res.getSupportedProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(this.getJObject(json, "_versioning"), res.getVersioningElement());
        }
        if (json.has("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(json.get("readHistory").getAsBoolean()));
        }
        if (json.has("_readHistory")) {
            this.parseElementProperties(this.getJObject(json, "_readHistory"), res.getReadHistoryElement());
        }
        if (json.has("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(json.get("updateCreate").getAsBoolean()));
        }
        if (json.has("_updateCreate")) {
            this.parseElementProperties(this.getJObject(json, "_updateCreate"), res.getUpdateCreateElement());
        }
        if (json.has("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(json.get("conditionalCreate").getAsBoolean()));
        }
        if (json.has("_conditionalCreate")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalCreate"), res.getConditionalCreateElement());
        }
        if (json.has("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        }
        if (json.has("_conditionalRead")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalRead"), res.getConditionalReadElement());
        }
        if (json.has("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
        }
        if (json.has("_conditionalUpdate")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalUpdate"), res.getConditionalUpdateElement());
        }
        if (json.has("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        }
        if (json.has("_conditionalDelete")) {
            this.parseElementProperties(this.getJObject(json, "_conditionalDelete"), res.getConditionalDeleteElement());
        }
        if (json.has("referencePolicy")) {
            array = json.getAsJsonArray("referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getReferencePolicy().add(new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory(), CapabilityStatement.ReferenceHandlingPolicy.NULL));
                    continue;
                }
                res.getReferencePolicy().add(this.parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
            }
        }
        if (json.has("_referencePolicy")) {
            array = json.getAsJsonArray("_referencePolicy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReferencePolicy().size()) {
                    res.getReferencePolicy().add(this.parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
            }
        }
        if (json.has("searchInclude")) {
            array = json.getAsJsonArray("searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSearchInclude().add(new StringType());
                    continue;
                }
                res.getSearchInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchInclude")) {
            array = json.getAsJsonArray("_searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchInclude().size()) {
                    res.getSearchInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
            }
        }
        if (json.has("searchRevInclude")) {
            array = json.getAsJsonArray("searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSearchRevInclude().add(new StringType());
                    continue;
                }
                res.getSearchRevInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchRevInclude")) {
            array = json.getAsJsonArray("_searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchRevInclude().size()) {
                    res.getSearchRevInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseCapabilityStatementResourceInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseCapabilityStatementRestResourceSearchParamComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        this.parseCapabilityStatementRestResourceOperationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseCapabilityStatementSystemInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseCapabilityStatementMessagingComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(json.get("reliableCache").getAsString()));
        }
        if (json.has("_reliableCache")) {
            this.parseElementProperties(this.getJObject(json, "_reliableCache"), res.getReliableCacheElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("supportedMessage")) {
            array = json.getAsJsonArray("supportedMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportedMessage().add(this.parseCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseCapabilityStatementMessagingEndpointComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseCoding(this.getJObject(json, "protocol")));
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUrl(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(this.getJObject(json, "_address"), res.getAddressElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseCapabilityStatementMessagingSupportedMessageComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseCapabilityStatementDocumentComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
    }

    protected CapabilityStatement2 parseCapabilityStatement2(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2 res = new CapabilityStatement2();
        this.parseCapabilityStatement2Properties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2Properties(JsonObject json, CapabilityStatement2 res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("instantiates")) {
            array = json.getAsJsonArray("instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiates().add(new CanonicalType());
                    continue;
                }
                res.getInstantiates().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiates")) {
            array = json.getAsJsonArray("_instantiates");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiates().size()) {
                    res.getInstantiates().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
            }
        }
        if (json.has("imports")) {
            array = json.getAsJsonArray("imports");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImports().add(new CanonicalType());
                    continue;
                }
                res.getImports().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_imports")) {
            array = json.getAsJsonArray("_imports");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImports().size()) {
                    res.getImports().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
            }
        }
        if (json.has("software")) {
            res.setSoftware(this.parseCapabilityStatement2SoftwareComponent(this.getJObject(json, "software")));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseCapabilityStatement2ImplementationComponent(this.getJObject(json, "implementation")));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(this.getJObject(json, "_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("format")) {
            array = json.getAsJsonArray("format");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getFormat().add(new CodeType());
                    continue;
                }
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            array = json.getAsJsonArray("_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
            }
        }
        if (json.has("patchFormat")) {
            array = json.getAsJsonArray("patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPatchFormat().add(new CodeType());
                    continue;
                }
                res.getPatchFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_patchFormat")) {
            array = json.getAsJsonArray("_patchFormat");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPatchFormat().size()) {
                    res.getPatchFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
            }
        }
        if (json.has("implementationGuide")) {
            array = json.getAsJsonArray("implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImplementationGuide().add(new CanonicalType());
                    continue;
                }
                res.getImplementationGuide().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_implementationGuide")) {
            array = json.getAsJsonArray("_implementationGuide");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImplementationGuide().size()) {
                    res.getImplementationGuide().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
            }
        }
        if (json.has("rest")) {
            array = json.getAsJsonArray("rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseCapabilityStatement2RestComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CapabilityStatement2.CapabilityStatement2SoftwareComponent parseCapabilityStatement2SoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2SoftwareComponent res = new CapabilityStatement2.CapabilityStatement2SoftwareComponent();
        this.parseCapabilityStatement2SoftwareComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2SoftwareComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2SoftwareComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(this.getJObject(json, "_releaseDate"), res.getReleaseDateElement());
        }
    }

    protected CapabilityStatement2.CapabilityStatement2ImplementationComponent parseCapabilityStatement2ImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2ImplementationComponent res = new CapabilityStatement2.CapabilityStatement2ImplementationComponent();
        this.parseCapabilityStatement2ImplementationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2ImplementationComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2ImplementationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUrl(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
    }

    protected CapabilityStatement2.CapabilityStatement2RestComponent parseCapabilityStatement2RestComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2RestComponent res = new CapabilityStatement2.CapabilityStatement2RestComponent();
        this.parseCapabilityStatement2RestComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2RestComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Enumerations.RestfulCapabilityMode.NULL, new Enumerations.RestfulCapabilityModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCapabilityStatement2RestResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatement2SystemInteractionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatement2RestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatement2RestResourceOperationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getCompartment().add(new CanonicalType());
                    continue;
                }
                res.getCompartment().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = json.getAsJsonArray("_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
            }
        }
    }

    protected CapabilityStatement2.CapabilityStatement2RestResourceComponent parseCapabilityStatement2RestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2RestResourceComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceComponent();
        this.parseCapabilityStatement2RestResourceComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2RestResourceComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("supportedProfile")) {
            array = json.getAsJsonArray("supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSupportedProfile().add(new CanonicalType());
                    continue;
                }
                res.getSupportedProfile().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_supportedProfile")) {
            array = json.getAsJsonArray("_supportedProfile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSupportedProfile().size()) {
                    res.getSupportedProfile().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseCapabilityStatement2ResourceInteractionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseCapabilityStatement2RestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseCapabilityStatement2RestResourceOperationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CapabilityStatement2.ResourceInteractionComponent parseCapabilityStatement2ResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.ResourceInteractionComponent res = new CapabilityStatement2.ResourceInteractionComponent();
        this.parseCapabilityStatement2ResourceInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2ResourceInteractionComponentProperties(JsonObject json, CapabilityStatement2.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement2.TypeRestfulInteraction.NULL, new CapabilityStatement2.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent parseCapabilityStatement2RestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent();
        this.parseCapabilityStatement2RestResourceSearchParamComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2RestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent parseCapabilityStatement2RestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent();
        this.parseCapabilityStatement2RestResourceOperationComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2RestResourceOperationComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseCanonical(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CapabilityStatement2.SystemInteractionComponent parseCapabilityStatement2SystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CapabilityStatement2.SystemInteractionComponent res = new CapabilityStatement2.SystemInteractionComponent();
        this.parseCapabilityStatement2SystemInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseCapabilityStatement2SystemInteractionComponentProperties(JsonObject json, CapabilityStatement2.SystemInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CapabilityStatement2.SystemRestfulInteraction.NULL, new CapabilityStatement2.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseCarePlanProperties(json, res);
        return res;
    }

    protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = json.getAsJsonArray("instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = json.getAsJsonArray("_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = json.getAsJsonArray("instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = json.getAsJsonArray("_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i = 0; i < array.size(); ++i) {
                res.getReplaces().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            array = json.getAsJsonArray("activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseCarePlanActivityComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseCarePlanActivityComponentProperties(json, res);
        return res;
    }

    protected void parseCarePlanActivityComponentProperties(JsonObject json, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("outcome")) {
            array = json.getAsJsonArray("outcome");
            for (i = 0; i < array.size(); ++i) {
                res.getOutcome().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("progress")) {
            array = json.getAsJsonArray("progress");
            for (i = 0; i < array.size(); ++i) {
                res.getProgress().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("detail")) {
            res.setDetail(this.parseCarePlanActivityDetailComponent(this.getJObject(json, "detail")));
        }
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanActivityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseCarePlanActivityDetailComponentProperties(json, res);
        return res;
    }

    protected void parseCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
        DataType product;
        DataType reported;
        DataType scheduled;
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(this.getJObject(json, "_kind"), res.getKindElement());
        }
        if (json.has("instantiatesCanonical")) {
            array = json.getAsJsonArray("instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = json.getAsJsonArray("_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = json.getAsJsonArray("instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = json.getAsJsonArray("_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("location")) {
            res.setLocation(this.parseCodeableReference(this.getJObject(json, "location")));
        }
        if ((reported = this.parseType("reported", json)) != null) {
            res.setReported(reported);
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getPerformer().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("dailyAmount")) {
            res.setDailyAmount(this.parseQuantity(this.getJObject(json, "dailyAmount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseCareTeamProperties(json, res);
        return res;
    }

    protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCareTeamParticipantComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("managingOrganization")) {
            array = json.getAsJsonArray("managingOrganization");
            for (i = 0; i < array.size(); ++i) {
                res.getManagingOrganization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseCareTeamParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseCareTeamParticipantComponentProperties(JsonObject json, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
        DataType coverage;
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(this.getJObject(json, "member")));
        }
        if (json.has("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(this.getJObject(json, "onBehalfOf")));
        }
        if ((coverage = this.parseType("coverage", json)) != null) {
            res.setCoverage(coverage);
        }
    }

    protected CatalogEntry parseCatalogEntry(JsonObject json) throws IOException, FHIRFormatError {
        CatalogEntry res = new CatalogEntry();
        this.parseCatalogEntryProperties(json, res);
        return res;
    }

    protected void parseCatalogEntryProperties(JsonObject json, CatalogEntry res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CatalogEntry.CatalogEntryType.NULL, new CatalogEntry.CatalogEntryTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CatalogEntry.CatalogEntryStatus.NULL, new CatalogEntry.CatalogEntryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("orderable")) {
            res.setOrderableElement(this.parseBoolean(json.get("orderable").getAsBoolean()));
        }
        if (json.has("_orderable")) {
            this.parseElementProperties(this.getJObject(json, "_orderable"), res.getOrderableElement());
        }
        if (json.has("referencedItem")) {
            res.setReferencedItem(this.parseReference(this.getJObject(json, "referencedItem")));
        }
        if (json.has("relatedEntry")) {
            array = json.getAsJsonArray("relatedEntry");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedEntry().add(this.parseCatalogEntryRelatedEntryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("updatedBy")) {
            res.setUpdatedBy(this.parseReference(this.getJObject(json, "updatedBy")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("estimatedDuration")) {
            res.setEstimatedDuration(this.parseDuration(this.getJObject(json, "estimatedDuration")));
        }
        if (json.has("billingCode")) {
            array = json.getAsJsonArray("billingCode");
            for (i = 0; i < array.size(); ++i) {
                res.getBillingCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("billingSummary")) {
            res.setBillingSummaryElement(this.parseString(json.get("billingSummary").getAsString()));
        }
        if (json.has("_billingSummary")) {
            this.parseElementProperties(this.getJObject(json, "_billingSummary"), res.getBillingSummaryElement());
        }
        if (json.has("scheduleSummary")) {
            res.setScheduleSummaryElement(this.parseString(json.get("scheduleSummary").getAsString()));
        }
        if (json.has("_scheduleSummary")) {
            this.parseElementProperties(this.getJObject(json, "_scheduleSummary"), res.getScheduleSummaryElement());
        }
        if (json.has("limitationSummary")) {
            res.setLimitationSummaryElement(this.parseString(json.get("limitationSummary").getAsString()));
        }
        if (json.has("_limitationSummary")) {
            this.parseElementProperties(this.getJObject(json, "_limitationSummary"), res.getLimitationSummaryElement());
        }
        if (json.has("regulatorySummary")) {
            res.setRegulatorySummaryElement(this.parseString(json.get("regulatorySummary").getAsString()));
        }
        if (json.has("_regulatorySummary")) {
            this.parseElementProperties(this.getJObject(json, "_regulatorySummary"), res.getRegulatorySummaryElement());
        }
    }

    protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryRelatedEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
        CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
        this.parseCatalogEntryRelatedEntryComponentProperties(json, res);
        return res;
    }

    protected void parseCatalogEntryRelatedEntryComponentProperties(JsonObject json, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(this.getJObject(json, "_relationship"), res.getRelationshipElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(this.getJObject(json, "target")));
        }
    }

    protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseChargeItemProperties(json, res);
        return res;
    }

    protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
        int i;
        DataType product;
        int i2;
        DataType occurrence;
        int i3;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i3 = 0; i3 < array.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("definitionUri")) {
            array = json.getAsJsonArray("definitionUri");
            for (i3 = 0; i3 < array.size(); ++i3) {
                if (array.get(i3).isJsonNull()) {
                    res.getDefinitionUri().add(new UriType());
                    continue;
                }
                res.getDefinitionUri().add(this.parseUri(array.get(i3).getAsString()));
            }
        }
        if (json.has("_definitionUri")) {
            array = json.getAsJsonArray("_definitionUri");
            for (i3 = 0; i3 < array.size(); ++i3) {
                if (i3 == res.getDefinitionUri().size()) {
                    res.getDefinitionUri().add(this.parseUri(null));
                }
                if (!(array.get(i3) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i3).getAsJsonObject(), res.getDefinitionUri().get(i3));
            }
        }
        if (json.has("definitionCanonical")) {
            array = json.getAsJsonArray("definitionCanonical");
            for (i3 = 0; i3 < array.size(); ++i3) {
                if (array.get(i3).isJsonNull()) {
                    res.getDefinitionCanonical().add(new CanonicalType());
                    continue;
                }
                res.getDefinitionCanonical().add(this.parseCanonical(array.get(i3).getAsString()));
            }
        }
        if (json.has("_definitionCanonical")) {
            array = json.getAsJsonArray("_definitionCanonical");
            for (i3 = 0; i3 < array.size(); ++i3) {
                if (i3 == res.getDefinitionCanonical().size()) {
                    res.getDefinitionCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i3) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i3).getAsJsonObject(), res.getDefinitionCanonical().get(i3));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i3 = 0; i3 < array.size(); ++i3) {
                res.getPartOf().add(this.parseReference(array.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(this.getJObject(json, "context")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getPerformer().add(this.parseChargeItemPerformerComponent(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(this.getJObject(json, "performingOrganization")));
        }
        if (json.has("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(this.getJObject(json, "requestingOrganization")));
        }
        if (json.has("costCenter")) {
            res.setCostCenter(this.parseReference(this.getJObject(json, "costCenter")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("bodysite")) {
            JsonArray array3 = json.getAsJsonArray("bodysite");
            for (i2 = 0; i2 < array3.size(); ++i2) {
                res.getBodysite().add(this.parseCodeableConcept(array3.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("factorOverride")) {
            res.setFactorOverrideElement(this.parseDecimal(json.get("factorOverride").getAsBigDecimal()));
        }
        if (json.has("_factorOverride")) {
            this.parseElementProperties(this.getJObject(json, "_factorOverride"), res.getFactorOverrideElement());
        }
        if (json.has("priceOverride")) {
            res.setPriceOverride(this.parseMoney(this.getJObject(json, "priceOverride")));
        }
        if (json.has("overrideReason")) {
            res.setOverrideReasonElement(this.parseString(json.get("overrideReason").getAsString()));
        }
        if (json.has("_overrideReason")) {
            this.parseElementProperties(this.getJObject(json, "_overrideReason"), res.getOverrideReasonElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(json.get("enteredDate").getAsString()));
        }
        if (json.has("_enteredDate")) {
            this.parseElementProperties(this.getJObject(json, "_enteredDate"), res.getEnteredDateElement());
        }
        if (json.has("reason")) {
            JsonArray array4 = json.getAsJsonArray("reason");
            for (i2 = 0; i2 < array4.size(); ++i2) {
                res.getReason().add(this.parseCodeableConcept(array4.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("service")) {
            JsonArray array5 = json.getAsJsonArray("service");
            for (i2 = 0; i2 < array5.size(); ++i2) {
                res.getService().add(this.parseReference(array5.get(i2).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("account")) {
            JsonArray array6 = json.getAsJsonArray("account");
            for (i = 0; i < array6.size(); ++i) {
                res.getAccount().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array7 = json.getAsJsonArray("note");
            for (i = 0; i < array7.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            JsonArray array8 = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array8.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
    }

    protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
        this.parseChargeItemPerformerComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemPerformerComponentProperties(JsonObject json, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition res = new ChargeItemDefinition();
        this.parseChargeItemDefinitionProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("derivedFromUri")) {
            array = json.getAsJsonArray("derivedFromUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDerivedFromUri().add(new UriType());
                    continue;
                }
                res.getDerivedFromUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_derivedFromUri")) {
            array = json.getAsJsonArray("_derivedFromUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDerivedFromUri().size()) {
                    res.getDerivedFromUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDerivedFromUri().get(i));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPartOf().add(new CanonicalType());
                    continue;
                }
                res.getPartOf().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_partOf")) {
            array = json.getAsJsonArray("_partOf");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPartOf().size()) {
                    res.getPartOf().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPartOf().get(i));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getReplaces().add(new CanonicalType());
                    continue;
                }
                res.getReplaces().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_replaces")) {
            array = json.getAsJsonArray("_replaces");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getReplaces().size()) {
                    res.getReplaces().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
            }
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("applicability")) {
            array = json.getAsJsonArray("applicability");
            for (i = 0; i < array.size(); ++i) {
                res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("propertyGroup")) {
            array = json.getAsJsonArray("propertyGroup");
            for (i = 0; i < array.size(); ++i) {
                res.getPropertyGroup().add(this.parseChargeItemDefinitionPropertyGroupComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        this.parseChargeItemDefinitionApplicabilityComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseString(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        this.parseChargeItemDefinitionPropertyGroupComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("applicability")) {
            array = json.getAsJsonArray("applicability");
            for (i = 0; i < array.size(); ++i) {
                res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priceComponent")) {
            array = json.getAsJsonArray("priceComponent");
            for (i = 0; i < array.size(); ++i) {
                res.getPriceComponent().add(this.parseChargeItemDefinitionPropertyGroupPriceComponentComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionPropertyGroupPriceComponentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
        this.parseChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(json, res);
        return res;
    }

    protected void parseChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.InvoicePriceComponentType.NULL, new Enumerations.InvoicePriceComponentTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected Citation parseCitation(JsonObject json) throws IOException, FHIRFormatError {
        Citation res = new Citation();
        this.parseCitationProperties(json, res);
        return res;
    }

    protected void parseCitationProperties(JsonObject json, Citation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedIdentifier")) {
            array = json.getAsJsonArray("relatedIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("summary")) {
            array = json.getAsJsonArray("summary");
            for (i = 0; i < array.size(); ++i) {
                res.getSummary().add(this.parseCitationSummaryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateCited")) {
            res.setDateCitedElement(this.parseDateTime(json.get("dateCited").getAsString()));
        }
        if (json.has("_dateCited")) {
            this.parseElementProperties(this.getJObject(json, "_dateCited"), res.getDateCitedElement());
        }
        if (json.has("variantCitation")) {
            res.setVariantCitation(this.parseCitationVariantCitationComponent(this.getJObject(json, "variantCitation")));
        }
        if (json.has("publishingModel")) {
            res.setPublishingModel(this.parseCodeableConcept(this.getJObject(json, "publishingModel")));
        }
        if (json.has("journal")) {
            res.setJournal(this.parseCitationJournalComponent(this.getJObject(json, "journal")));
        }
        if (json.has("publicationInfo")) {
            res.setPublicationInfo(this.parseCitationPublicationInfoComponent(this.getJObject(json, "publicationInfo")));
        }
        if (json.has("articleTitle")) {
            res.setArticleTitleElement(this.parseMarkdown(json.get("articleTitle").getAsString()));
        }
        if (json.has("_articleTitle")) {
            this.parseElementProperties(this.getJObject(json, "_articleTitle"), res.getArticleTitleElement());
        }
        if (json.has("alternativeTitle")) {
            array = json.getAsJsonArray("alternativeTitle");
            for (i = 0; i < array.size(); ++i) {
                res.getAlternativeTitle().add(this.parseCitationAlternativeTitleComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("pagination")) {
            res.setPagination(this.parseCitationPaginationComponent(this.getJObject(json, "pagination")));
        }
        if (json.has("articleUrl")) {
            array = json.getAsJsonArray("articleUrl");
            for (i = 0; i < array.size(); ++i) {
                res.getArticleUrl().add(this.parseCitationArticleUrlComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseMarkdown(json.get("abstract").getAsString()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(this.getJObject(json, "_abstract"), res.getAbstractElement());
        }
        if (json.has("abstractCopyright")) {
            res.setAbstractCopyrightElement(this.parseMarkdown(json.get("abstractCopyright").getAsString()));
        }
        if (json.has("_abstractCopyright")) {
            this.parseElementProperties(this.getJObject(json, "_abstractCopyright"), res.getAbstractCopyrightElement());
        }
        if (json.has("alternativeAbstract")) {
            array = json.getAsJsonArray("alternativeAbstract");
            for (i = 0; i < array.size(); ++i) {
                res.getAlternativeAbstract().add(this.parseCitationAlternativeAbstractComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributorship")) {
            res.setContributorship(this.parseCitationContributorshipComponent(this.getJObject(json, "contributorship")));
        }
        if (json.has("articleLanguage")) {
            res.setArticleLanguage(this.parseCodeableConcept(this.getJObject(json, "articleLanguage")));
        }
        if (json.has("alternativeForm")) {
            array = json.getAsJsonArray("alternativeForm");
            for (i = 0; i < array.size(); ++i) {
                res.getAlternativeForm().add(this.parseCitationAlternativeFormComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("classifier")) {
            array = json.getAsJsonArray("classifier");
            for (i = 0; i < array.size(); ++i) {
                res.getClassifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("keywordList")) {
            array = json.getAsJsonArray("keywordList");
            for (i = 0; i < array.size(); ++i) {
                res.getKeywordList().add(this.parseCitationKeywordListComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("medlinePubMed")) {
            res.setMedlinePubMed(this.parseCitationMedlinePubMedComponent(this.getJObject(json, "medlinePubMed")));
        }
    }

    protected Citation.CitationSummaryComponent parseCitationSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationSummaryComponent res = new Citation.CitationSummaryComponent();
        this.parseCitationSummaryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationSummaryComponentProperties(JsonObject json, Citation.CitationSummaryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("style")) {
            res.setStyle(this.parseCodeableConcept(this.getJObject(json, "style")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseMarkdown(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Citation.CitationVariantCitationComponent parseCitationVariantCitationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationVariantCitationComponent res = new Citation.CitationVariantCitationComponent();
        this.parseCitationVariantCitationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationVariantCitationComponentProperties(JsonObject json, Citation.CitationVariantCitationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("baseCitation")) {
            res.setBaseCitation(this.parseReference(this.getJObject(json, "baseCitation")));
        }
    }

    protected Citation.CitationJournalComponent parseCitationJournalComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationJournalComponent res = new Citation.CitationJournalComponent();
        this.parseCitationJournalComponentProperties(json, res);
        return res;
    }

    protected void parseCitationJournalComponentProperties(JsonObject json, Citation.CitationJournalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(this.getJObject(json, "_country"), res.getCountryElement());
        }
        if (json.has("journalIssue")) {
            res.setJournalIssue(this.parseCitationJournalJournalIssueComponent(this.getJObject(json, "journalIssue")));
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
    }

    protected Citation.CitationJournalJournalIssueComponent parseCitationJournalJournalIssueComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationJournalJournalIssueComponent res = new Citation.CitationJournalJournalIssueComponent();
        this.parseCitationJournalJournalIssueComponentProperties(json, res);
        return res;
    }

    protected void parseCitationJournalJournalIssueComponentProperties(JsonObject json, Citation.CitationJournalJournalIssueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("citedMedium")) {
            res.setCitedMedium(this.parseCodeableConcept(this.getJObject(json, "citedMedium")));
        }
        if (json.has("volume")) {
            res.setVolumeElement(this.parseString(json.get("volume").getAsString()));
        }
        if (json.has("_volume")) {
            this.parseElementProperties(this.getJObject(json, "_volume"), res.getVolumeElement());
        }
        if (json.has("issue")) {
            res.setIssueElement(this.parseString(json.get("issue").getAsString()));
        }
        if (json.has("_issue")) {
            this.parseElementProperties(this.getJObject(json, "_issue"), res.getIssueElement());
        }
        if (json.has("publicationDate")) {
            res.setPublicationDate(this.parseCitationJournalJournalIssuePublicationDateComponent(this.getJObject(json, "publicationDate")));
        }
    }

    protected Citation.CitationJournalJournalIssuePublicationDateComponent parseCitationJournalJournalIssuePublicationDateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationJournalJournalIssuePublicationDateComponent res = new Citation.CitationJournalJournalIssuePublicationDateComponent();
        this.parseCitationJournalJournalIssuePublicationDateComponentProperties(json, res);
        return res;
    }

    protected void parseCitationJournalJournalIssuePublicationDateComponentProperties(JsonObject json, Citation.CitationJournalJournalIssuePublicationDateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("year")) {
            res.setYearElement(this.parseString(json.get("year").getAsString()));
        }
        if (json.has("_year")) {
            this.parseElementProperties(this.getJObject(json, "_year"), res.getYearElement());
        }
        if (json.has("month")) {
            res.setMonthElement(this.parseString(json.get("month").getAsString()));
        }
        if (json.has("_month")) {
            this.parseElementProperties(this.getJObject(json, "_month"), res.getMonthElement());
        }
        if (json.has("day")) {
            res.setDayElement(this.parseString(json.get("day").getAsString()));
        }
        if (json.has("_day")) {
            this.parseElementProperties(this.getJObject(json, "_day"), res.getDayElement());
        }
        if (json.has("season")) {
            res.setSeasonElement(this.parseString(json.get("season").getAsString()));
        }
        if (json.has("_season")) {
            this.parseElementProperties(this.getJObject(json, "_season"), res.getSeasonElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Citation.CitationPublicationInfoComponent parseCitationPublicationInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationPublicationInfoComponent res = new Citation.CitationPublicationInfoComponent();
        this.parseCitationPublicationInfoComponentProperties(json, res);
        return res;
    }

    protected void parseCitationPublicationInfoComponentProperties(JsonObject json, Citation.CitationPublicationInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("publishedIn")) {
            res.setPublishedIn(this.parseCitationPublicationInfoPublishedInComponent(this.getJObject(json, "publishedIn")));
        }
        if (json.has("entryDate")) {
            res.setEntryDateElement(this.parseDateTime(json.get("entryDate").getAsString()));
        }
        if (json.has("_entryDate")) {
            this.parseElementProperties(this.getJObject(json, "_entryDate"), res.getEntryDateElement());
        }
        if (json.has("revisionDate")) {
            res.setRevisionDateElement(this.parseDateTime(json.get("revisionDate").getAsString()));
        }
        if (json.has("_revisionDate")) {
            this.parseElementProperties(this.getJObject(json, "_revisionDate"), res.getRevisionDateElement());
        }
        if (json.has("pageCount")) {
            res.setPageCountElement(this.parseString(json.get("pageCount").getAsString()));
        }
        if (json.has("_pageCount")) {
            this.parseElementProperties(this.getJObject(json, "_pageCount"), res.getPageCountElement());
        }
    }

    protected Citation.CitationPublicationInfoPublishedInComponent parseCitationPublicationInfoPublishedInComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationPublicationInfoPublishedInComponent res = new Citation.CitationPublicationInfoPublishedInComponent();
        this.parseCitationPublicationInfoPublishedInComponentProperties(json, res);
        return res;
    }

    protected void parseCitationPublicationInfoPublishedInComponentProperties(JsonObject json, Citation.CitationPublicationInfoPublishedInComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("publisher")) {
            res.setPublisher(this.parseReference(this.getJObject(json, "publisher")));
        }
        if (json.has("publisherLocation")) {
            res.setPublisherLocationElement(this.parseString(json.get("publisherLocation").getAsString()));
        }
        if (json.has("_publisherLocation")) {
            this.parseElementProperties(this.getJObject(json, "_publisherLocation"), res.getPublisherLocationElement());
        }
        if (json.has("startDate")) {
            res.setStartDateElement(this.parseDate(json.get("startDate").getAsString()));
        }
        if (json.has("_startDate")) {
            this.parseElementProperties(this.getJObject(json, "_startDate"), res.getStartDateElement());
        }
    }

    protected Citation.CitationAlternativeTitleComponent parseCitationAlternativeTitleComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeTitleComponent res = new Citation.CitationAlternativeTitleComponent();
        this.parseCitationAlternativeTitleComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeTitleComponentProperties(JsonObject json, Citation.CitationAlternativeTitleComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseMarkdown(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
    }

    protected Citation.CitationPaginationComponent parseCitationPaginationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationPaginationComponent res = new Citation.CitationPaginationComponent();
        this.parseCitationPaginationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationPaginationComponentProperties(JsonObject json, Citation.CitationPaginationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("pageString")) {
            res.setPageStringElement(this.parseString(json.get("pageString").getAsString()));
        }
        if (json.has("_pageString")) {
            this.parseElementProperties(this.getJObject(json, "_pageString"), res.getPageStringElement());
        }
        if (json.has("firstPage")) {
            res.setFirstPageElement(this.parseString(json.get("firstPage").getAsString()));
        }
        if (json.has("_firstPage")) {
            this.parseElementProperties(this.getJObject(json, "_firstPage"), res.getFirstPageElement());
        }
        if (json.has("lastPage")) {
            res.setLastPageElement(this.parseString(json.get("lastPage").getAsString()));
        }
        if (json.has("_lastPage")) {
            this.parseElementProperties(this.getJObject(json, "_lastPage"), res.getLastPageElement());
        }
    }

    protected Citation.CitationArticleUrlComponent parseCitationArticleUrlComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationArticleUrlComponent res = new Citation.CitationArticleUrlComponent();
        this.parseCitationArticleUrlComponentProperties(json, res);
        return res;
    }

    protected void parseCitationArticleUrlComponentProperties(JsonObject json, Citation.CitationArticleUrlComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Citation.CitationAlternativeAbstractComponent parseCitationAlternativeAbstractComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeAbstractComponent res = new Citation.CitationAlternativeAbstractComponent();
        this.parseCitationAlternativeAbstractComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeAbstractComponentProperties(JsonObject json, Citation.CitationAlternativeAbstractComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseMarkdown(json.get("abstract").getAsString()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(this.getJObject(json, "_abstract"), res.getAbstractElement());
        }
        if (json.has("abstractCopyright")) {
            res.setAbstractCopyrightElement(this.parseMarkdown(json.get("abstractCopyright").getAsString()));
        }
        if (json.has("_abstractCopyright")) {
            this.parseElementProperties(this.getJObject(json, "_abstractCopyright"), res.getAbstractCopyrightElement());
        }
    }

    protected Citation.CitationContributorshipComponent parseCitationContributorshipComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationContributorshipComponent res = new Citation.CitationContributorshipComponent();
        this.parseCitationContributorshipComponentProperties(json, res);
        return res;
    }

    protected void parseCitationContributorshipComponentProperties(JsonObject json, Citation.CitationContributorshipComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("complete")) {
            res.setCompleteElement(this.parseBoolean(json.get("complete").getAsBoolean()));
        }
        if (json.has("_complete")) {
            this.parseElementProperties(this.getJObject(json, "_complete"), res.getCompleteElement());
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseCitationContributorshipEntryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("summary")) {
            array = json.getAsJsonArray("summary");
            for (i = 0; i < array.size(); ++i) {
                res.getSummary().add(this.parseCitationContributorshipSummaryComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Citation.CitationContributorshipEntryComponent parseCitationContributorshipEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationContributorshipEntryComponent res = new Citation.CitationContributorshipEntryComponent();
        this.parseCitationContributorshipEntryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationContributorshipEntryComponentProperties(JsonObject json, Citation.CitationContributorshipEntryComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setName(this.parseHumanName(this.getJObject(json, "name")));
        }
        if (json.has("initials")) {
            res.setInitialsElement(this.parseString(json.get("initials").getAsString()));
        }
        if (json.has("_initials")) {
            this.parseElementProperties(this.getJObject(json, "_initials"), res.getInitialsElement());
        }
        if (json.has("collectiveName")) {
            res.setCollectiveNameElement(this.parseString(json.get("collectiveName").getAsString()));
        }
        if (json.has("_collectiveName")) {
            this.parseElementProperties(this.getJObject(json, "_collectiveName"), res.getCollectiveNameElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("affiliationInfo")) {
            array = json.getAsJsonArray("affiliationInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getAffiliationInfo().add(this.parseCitationContributorshipEntryAffiliationInfoComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contribution")) {
            array = json.getAsJsonArray("contribution");
            for (i = 0; i < array.size(); ++i) {
                res.getContribution().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notAnAuthor")) {
            res.setNotAnAuthorElement(this.parseBoolean(json.get("notAnAuthor").getAsBoolean()));
        }
        if (json.has("_notAnAuthor")) {
            this.parseElementProperties(this.getJObject(json, "_notAnAuthor"), res.getNotAnAuthorElement());
        }
        if (json.has("correspondingAuthor")) {
            res.setCorrespondingAuthorElement(this.parseBoolean(json.get("correspondingAuthor").getAsBoolean()));
        }
        if (json.has("_correspondingAuthor")) {
            this.parseElementProperties(this.getJObject(json, "_correspondingAuthor"), res.getCorrespondingAuthorElement());
        }
        if (json.has("listOrder")) {
            res.setListOrderElement(this.parsePositiveInt(json.get("listOrder").getAsString()));
        }
        if (json.has("_listOrder")) {
            this.parseElementProperties(this.getJObject(json, "_listOrder"), res.getListOrderElement());
        }
    }

    protected Citation.CitationContributorshipEntryAffiliationInfoComponent parseCitationContributorshipEntryAffiliationInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationContributorshipEntryAffiliationInfoComponent res = new Citation.CitationContributorshipEntryAffiliationInfoComponent();
        this.parseCitationContributorshipEntryAffiliationInfoComponentProperties(json, res);
        return res;
    }

    protected void parseCitationContributorshipEntryAffiliationInfoComponentProperties(JsonObject json, Citation.CitationContributorshipEntryAffiliationInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("affiliation")) {
            res.setAffiliationElement(this.parseString(json.get("affiliation").getAsString()));
        }
        if (json.has("_affiliation")) {
            this.parseElementProperties(this.getJObject(json, "_affiliation"), res.getAffiliationElement());
        }
        if (json.has("role")) {
            res.setRoleElement(this.parseString(json.get("role").getAsString()));
        }
        if (json.has("_role")) {
            this.parseElementProperties(this.getJObject(json, "_role"), res.getRoleElement());
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Citation.CitationContributorshipSummaryComponent parseCitationContributorshipSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationContributorshipSummaryComponent res = new Citation.CitationContributorshipSummaryComponent();
        this.parseCitationContributorshipSummaryComponentProperties(json, res);
        return res;
    }

    protected void parseCitationContributorshipSummaryComponentProperties(JsonObject json, Citation.CitationContributorshipSummaryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("style")) {
            res.setStyle(this.parseCodeableConcept(this.getJObject(json, "style")));
        }
        if (json.has("source")) {
            res.setSource(this.parseCodeableConcept(this.getJObject(json, "source")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseMarkdown(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected Citation.CitationAlternativeFormComponent parseCitationAlternativeFormComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormComponent res = new Citation.CitationAlternativeFormComponent();
        this.parseCitationAlternativeFormComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormComponentProperties(JsonObject json, Citation.CitationAlternativeFormComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("publishingModel")) {
            res.setPublishingModel(this.parseCodeableConcept(this.getJObject(json, "publishingModel")));
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
        if (json.has("journalIssue")) {
            res.setJournalIssue(this.parseCitationAlternativeFormJournalIssueComponent(this.getJObject(json, "journalIssue")));
        }
        if (json.has("pagination")) {
            res.setPagination(this.parseCitationAlternativeFormPaginationComponent(this.getJObject(json, "pagination")));
        }
        if (json.has("publicationInfo")) {
            res.setPublicationInfo(this.parseCitationAlternativeFormPublicationInfoComponent(this.getJObject(json, "publicationInfo")));
        }
    }

    protected Citation.CitationAlternativeFormJournalIssueComponent parseCitationAlternativeFormJournalIssueComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormJournalIssueComponent res = new Citation.CitationAlternativeFormJournalIssueComponent();
        this.parseCitationAlternativeFormJournalIssueComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormJournalIssueComponentProperties(JsonObject json, Citation.CitationAlternativeFormJournalIssueComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("citedMedium")) {
            res.setCitedMedium(this.parseCodeableConcept(this.getJObject(json, "citedMedium")));
        }
        if (json.has("volume")) {
            res.setVolumeElement(this.parseString(json.get("volume").getAsString()));
        }
        if (json.has("_volume")) {
            this.parseElementProperties(this.getJObject(json, "_volume"), res.getVolumeElement());
        }
        if (json.has("issue")) {
            res.setIssueElement(this.parseString(json.get("issue").getAsString()));
        }
        if (json.has("_issue")) {
            this.parseElementProperties(this.getJObject(json, "_issue"), res.getIssueElement());
        }
        if (json.has("publicationDate")) {
            res.setPublicationDate(this.parseCitationAlternativeFormJournalIssuePublicationDateComponent(this.getJObject(json, "publicationDate")));
        }
    }

    protected Citation.CitationAlternativeFormJournalIssuePublicationDateComponent parseCitationAlternativeFormJournalIssuePublicationDateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormJournalIssuePublicationDateComponent res = new Citation.CitationAlternativeFormJournalIssuePublicationDateComponent();
        this.parseCitationAlternativeFormJournalIssuePublicationDateComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormJournalIssuePublicationDateComponentProperties(JsonObject json, Citation.CitationAlternativeFormJournalIssuePublicationDateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("year")) {
            res.setYearElement(this.parseString(json.get("year").getAsString()));
        }
        if (json.has("_year")) {
            this.parseElementProperties(this.getJObject(json, "_year"), res.getYearElement());
        }
        if (json.has("month")) {
            res.setMonthElement(this.parseString(json.get("month").getAsString()));
        }
        if (json.has("_month")) {
            this.parseElementProperties(this.getJObject(json, "_month"), res.getMonthElement());
        }
        if (json.has("day")) {
            res.setDayElement(this.parseString(json.get("day").getAsString()));
        }
        if (json.has("_day")) {
            this.parseElementProperties(this.getJObject(json, "_day"), res.getDayElement());
        }
        if (json.has("season")) {
            res.setSeasonElement(this.parseString(json.get("season").getAsString()));
        }
        if (json.has("_season")) {
            this.parseElementProperties(this.getJObject(json, "_season"), res.getSeasonElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Citation.CitationAlternativeFormPaginationComponent parseCitationAlternativeFormPaginationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormPaginationComponent res = new Citation.CitationAlternativeFormPaginationComponent();
        this.parseCitationAlternativeFormPaginationComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormPaginationComponentProperties(JsonObject json, Citation.CitationAlternativeFormPaginationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("pageString")) {
            res.setPageStringElement(this.parseString(json.get("pageString").getAsString()));
        }
        if (json.has("_pageString")) {
            this.parseElementProperties(this.getJObject(json, "_pageString"), res.getPageStringElement());
        }
        if (json.has("firstPage")) {
            res.setFirstPageElement(this.parseString(json.get("firstPage").getAsString()));
        }
        if (json.has("_firstPage")) {
            this.parseElementProperties(this.getJObject(json, "_firstPage"), res.getFirstPageElement());
        }
        if (json.has("lastPage")) {
            res.setLastPageElement(this.parseString(json.get("lastPage").getAsString()));
        }
        if (json.has("_lastPage")) {
            this.parseElementProperties(this.getJObject(json, "_lastPage"), res.getLastPageElement());
        }
    }

    protected Citation.CitationAlternativeFormPublicationInfoComponent parseCitationAlternativeFormPublicationInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormPublicationInfoComponent res = new Citation.CitationAlternativeFormPublicationInfoComponent();
        this.parseCitationAlternativeFormPublicationInfoComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormPublicationInfoComponentProperties(JsonObject json, Citation.CitationAlternativeFormPublicationInfoComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("publishedIn")) {
            res.setPublishedIn(this.parseCitationAlternativeFormPublicationInfoPublishedInComponent(this.getJObject(json, "publishedIn")));
        }
        if (json.has("entryDate")) {
            res.setEntryDateElement(this.parseDateTime(json.get("entryDate").getAsString()));
        }
        if (json.has("_entryDate")) {
            this.parseElementProperties(this.getJObject(json, "_entryDate"), res.getEntryDateElement());
        }
        if (json.has("revisionDate")) {
            res.setRevisionDateElement(this.parseDateTime(json.get("revisionDate").getAsString()));
        }
        if (json.has("_revisionDate")) {
            this.parseElementProperties(this.getJObject(json, "_revisionDate"), res.getRevisionDateElement());
        }
        if (json.has("pageCount")) {
            res.setPageCountElement(this.parseString(json.get("pageCount").getAsString()));
        }
        if (json.has("_pageCount")) {
            this.parseElementProperties(this.getJObject(json, "_pageCount"), res.getPageCountElement());
        }
    }

    protected Citation.CitationAlternativeFormPublicationInfoPublishedInComponent parseCitationAlternativeFormPublicationInfoPublishedInComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationAlternativeFormPublicationInfoPublishedInComponent res = new Citation.CitationAlternativeFormPublicationInfoPublishedInComponent();
        this.parseCitationAlternativeFormPublicationInfoPublishedInComponentProperties(json, res);
        return res;
    }

    protected void parseCitationAlternativeFormPublicationInfoPublishedInComponentProperties(JsonObject json, Citation.CitationAlternativeFormPublicationInfoPublishedInComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("publisher")) {
            res.setPublisher(this.parseReference(this.getJObject(json, "publisher")));
        }
        if (json.has("publisherLocation")) {
            res.setPublisherLocationElement(this.parseString(json.get("publisherLocation").getAsString()));
        }
        if (json.has("_publisherLocation")) {
            this.parseElementProperties(this.getJObject(json, "_publisherLocation"), res.getPublisherLocationElement());
        }
        if (json.has("startDate")) {
            res.setStartDateElement(this.parseDate(json.get("startDate").getAsString()));
        }
        if (json.has("_startDate")) {
            this.parseElementProperties(this.getJObject(json, "_startDate"), res.getStartDateElement());
        }
    }

    protected Citation.CitationKeywordListComponent parseCitationKeywordListComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationKeywordListComponent res = new Citation.CitationKeywordListComponent();
        this.parseCitationKeywordListComponentProperties(json, res);
        return res;
    }

    protected void parseCitationKeywordListComponentProperties(JsonObject json, Citation.CitationKeywordListComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("owner")) {
            res.setOwnerElement(this.parseString(json.get("owner").getAsString()));
        }
        if (json.has("_owner")) {
            this.parseElementProperties(this.getJObject(json, "_owner"), res.getOwnerElement());
        }
        if (json.has("keyword")) {
            JsonArray array = json.getAsJsonArray("keyword");
            for (int i = 0; i < array.size(); ++i) {
                res.getKeyword().add(this.parseCitationKeywordListKeywordComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Citation.CitationKeywordListKeywordComponent parseCitationKeywordListKeywordComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationKeywordListKeywordComponent res = new Citation.CitationKeywordListKeywordComponent();
        this.parseCitationKeywordListKeywordComponentProperties(json, res);
        return res;
    }

    protected void parseCitationKeywordListKeywordComponentProperties(JsonObject json, Citation.CitationKeywordListKeywordComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("majorTopic")) {
            res.setMajorTopicElement(this.parseBoolean(json.get("majorTopic").getAsBoolean()));
        }
        if (json.has("_majorTopic")) {
            this.parseElementProperties(this.getJObject(json, "_majorTopic"), res.getMajorTopicElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected Citation.CitationMedlinePubMedComponent parseCitationMedlinePubMedComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationMedlinePubMedComponent res = new Citation.CitationMedlinePubMedComponent();
        this.parseCitationMedlinePubMedComponentProperties(json, res);
        return res;
    }

    protected void parseCitationMedlinePubMedComponentProperties(JsonObject json, Citation.CitationMedlinePubMedComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("medlineState")) {
            res.setMedlineState(this.parseCodeableConcept(this.getJObject(json, "medlineState")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseCodeableConcept(this.getJObject(json, "owner")));
        }
        if (json.has("pmid")) {
            res.setPmidElement(this.parsePositiveInt(json.get("pmid").getAsString()));
        }
        if (json.has("_pmid")) {
            this.parseElementProperties(this.getJObject(json, "_pmid"), res.getPmidElement());
        }
        if (json.has("pmidVersion")) {
            res.setPmidVersionElement(this.parsePositiveInt(json.get("pmidVersion").getAsString()));
        }
        if (json.has("_pmidVersion")) {
            this.parseElementProperties(this.getJObject(json, "_pmidVersion"), res.getPmidVersionElement());
        }
        if (json.has("dateCreated")) {
            res.setDateCreatedElement(this.parseDate(json.get("dateCreated").getAsString()));
        }
        if (json.has("_dateCreated")) {
            this.parseElementProperties(this.getJObject(json, "_dateCreated"), res.getDateCreatedElement());
        }
        if (json.has("dateCompleted")) {
            res.setDateCompletedElement(this.parseDate(json.get("dateCompleted").getAsString()));
        }
        if (json.has("_dateCompleted")) {
            this.parseElementProperties(this.getJObject(json, "_dateCompleted"), res.getDateCompletedElement());
        }
        if (json.has("dateRevised")) {
            res.setDateRevisedElement(this.parseDate(json.get("dateRevised").getAsString()));
        }
        if (json.has("_dateRevised")) {
            this.parseElementProperties(this.getJObject(json, "_dateRevised"), res.getDateRevisedElement());
        }
        if (json.has("pubMedPubDate")) {
            array = json.getAsJsonArray("pubMedPubDate");
            for (i = 0; i < array.size(); ++i) {
                res.getPubMedPubDate().add(this.parseCitationMedlinePubMedPubMedPubDateComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("publicationState")) {
            res.setPublicationState(this.parseCodeableConcept(this.getJObject(json, "publicationState")));
        }
        if (json.has("relatedArticle")) {
            array = json.getAsJsonArray("relatedArticle");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArticle().add(this.parseCitationMedlinePubMedRelatedArticleComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Citation.CitationMedlinePubMedPubMedPubDateComponent parseCitationMedlinePubMedPubMedPubDateComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationMedlinePubMedPubMedPubDateComponent res = new Citation.CitationMedlinePubMedPubMedPubDateComponent();
        this.parseCitationMedlinePubMedPubMedPubDateComponentProperties(json, res);
        return res;
    }

    protected void parseCitationMedlinePubMedPubMedPubDateComponentProperties(JsonObject json, Citation.CitationMedlinePubMedPubMedPubDateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("publicationState")) {
            res.setPublicationState(this.parseCodeableConcept(this.getJObject(json, "publicationState")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
    }

    protected Citation.CitationMedlinePubMedRelatedArticleComponent parseCitationMedlinePubMedRelatedArticleComponent(JsonObject json) throws IOException, FHIRFormatError {
        Citation.CitationMedlinePubMedRelatedArticleComponent res = new Citation.CitationMedlinePubMedRelatedArticleComponent();
        this.parseCitationMedlinePubMedRelatedArticleComponentProperties(json, res);
        return res;
    }

    protected void parseCitationMedlinePubMedRelatedArticleComponentProperties(JsonObject json, Citation.CitationMedlinePubMedRelatedArticleComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("citationReference")) {
            res.setCitationReference(this.parseReference(this.getJObject(json, "citationReference")));
        }
        if (json.has("citationMarkdown")) {
            res.setCitationMarkdownElement(this.parseMarkdown(json.get("citationMarkdown").getAsString()));
        }
        if (json.has("_citationMarkdown")) {
            this.parseElementProperties(this.getJObject(json, "_citationMarkdown"), res.getCitationMarkdownElement());
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseClaimProperties(json, res);
        return res;
    }

    protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(this.getJObject(json, "billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(this.getJObject(json, "prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(this.getJObject(json, "originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(this.getJObject(json, "payee")));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(this.getJObject(json, "referral")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseClaimCareTeamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseClaimSupportingInformationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseClaimProcedureComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimInsuranceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(this.getJObject(json, "accident")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimItemComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(this.getJObject(json, "total")));
        }
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseClaimRelatedClaimComponentProperties(json, res);
        return res;
    }

    protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(this.getJObject(json, "reference")));
        }
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseClaimPayeeComponentProperties(json, res);
        return res;
    }

    protected void parseClaimPayeeComponentProperties(JsonObject json, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseClaimCareTeamComponentProperties(json, res);
        return res;
    }

    protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(this.getJObject(json, "_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("qualification")) {
            res.setQualification(this.parseCodeableConcept(this.getJObject(json, "qualification")));
        }
    }

    protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
        this.parseClaimSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseClaimSupportingInformationComponentProperties(JsonObject json, Claim.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        DataType value;
        DataType timing;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseClaimDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
        DataType diagnosis;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(this.getJObject(json, "onAdmission")));
        }
        if (json.has("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(this.getJObject(json, "packageCode")));
        }
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseClaimProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseClaimProcedureComponentProperties(JsonObject json, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
        DataType procedure;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        if (json.has("udi")) {
            JsonArray array = json.getAsJsonArray("udi");
            for (int i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseClaimInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseClaimAccidentComponentProperties(json, res);
        return res;
    }

    protected void parseClaimAccidentComponentProperties(JsonObject json, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
        DataType location;
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected Claim.ItemComponent parseClaimItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseClaimItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimItemComponentProperties(JsonObject json, Claim.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("careTeamSequence")) {
            array2 = json.getAsJsonArray("careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getCareTeamSequence().add(new PositiveIntType());
                    continue;
                }
                res.getCareTeamSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamSequence")) {
            array2 = json.getAsJsonArray("_careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamSequence().size()) {
                    res.getCareTeamSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getCareTeamSequence().get(i2));
            }
        }
        if (json.has("diagnosisSequence")) {
            array2 = json.getAsJsonArray("diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDiagnosisSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDiagnosisSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisSequence")) {
            array2 = json.getAsJsonArray("_diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisSequence().size()) {
                    res.getDiagnosisSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDiagnosisSequence().get(i2));
            }
        }
        if (json.has("procedureSequence")) {
            array2 = json.getAsJsonArray("procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getProcedureSequence().add(new PositiveIntType());
                    continue;
                }
                res.getProcedureSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureSequence")) {
            array2 = json.getAsJsonArray("_procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureSequence().size()) {
                    res.getProcedureSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getProcedureSequence().get(i2));
            }
        }
        if (json.has("informationSequence")) {
            array2 = json.getAsJsonArray("informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInformationSequence().add(new PositiveIntType());
                    continue;
                }
                res.getInformationSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationSequence")) {
            array2 = json.getAsJsonArray("_informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationSequence().size()) {
                    res.getInformationSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInformationSequence().get(i2));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            array = json.getAsJsonArray("encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseClaimDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimDetailComponentProperties(JsonObject json, Claim.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseClaimSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseClaimResponseProperties(json, res);
        return res;
    }

    protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("requestor")) {
            res.setRequestor(this.parseReference(this.getJObject(json, "requestor")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(this.getJObject(json, "preAuthPeriod")));
        }
        if (json.has("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(this.getJObject(json, "payeeType")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimResponseItemComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("total")) {
            array = json.getAsJsonArray("total");
            for (i = 0; i < array.size(); ++i) {
                res.getTotal().add(this.parseClaimResponseTotalComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(this.getJObject(json, "payment")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("formCode")) {
            res.setFormCode(this.parseCodeableConcept(this.getJObject(json, "formCode")));
        }
        if (json.has("form")) {
            res.setForm(this.parseAttachment(this.getJObject(json, "form")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseClaimResponseNoteComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("communicationRequest")) {
            array = json.getAsJsonArray("communicationRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunicationRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseClaimResponseErrorComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseClaimResponseItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(json.get("itemSequence").getAsString()));
        }
        if (json.has("_itemSequence")) {
            this.parseElementProperties(this.getJObject(json, "_itemSequence"), res.getItemSequenceElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseClaimResponseAdjudicationComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseClaimResponseItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(json.get("detailSequence").getAsString()));
        }
        if (json.has("_detailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseClaimResponseSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(json.get("subDetailSequence").getAsString()));
        }
        if (json.has("_subDetailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseClaimResponseAddedItemComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            array2 = json.getAsJsonArray("itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getItemSequence().add(new PositiveIntType());
                    continue;
                }
                res.getItemSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_itemSequence")) {
            array2 = json.getAsJsonArray("_itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getItemSequence().size()) {
                    res.getItemSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getItemSequence().get(i2));
            }
        }
        if (json.has("detailSequence")) {
            array2 = json.getAsJsonArray("detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_detailSequence")) {
            array2 = json.getAsJsonArray("_detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDetailSequence().size()) {
                    res.getDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDetailSequence().get(i2));
            }
        }
        if (json.has("subdetailSequence")) {
            array2 = json.getAsJsonArray("subdetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getSubdetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSubdetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_subdetailSequence")) {
            array2 = json.getAsJsonArray("_subdetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getSubdetailSequence().size()) {
                    res.getSubdetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getSubdetailSequence().get(i2));
            }
        }
        if (json.has("provider")) {
            array2 = json.getAsJsonArray("provider");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProvider().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseAddedItemDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
        this.parseClaimResponseAddedItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseAddedItemSubDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
        this.parseClaimResponseAddedItemSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
        this.parseClaimResponseTotalComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseClaimResponsePaymentComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(this.getJObject(json, "adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(this.getJObject(json, "adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseClaimResponseNoteComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseClaimResponseInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseClaimResponseErrorComponentProperties(json, res);
        return res;
    }

    protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(json.get("itemSequence").getAsString()));
        }
        if (json.has("_itemSequence")) {
            this.parseElementProperties(this.getJObject(json, "_itemSequence"), res.getItemSequenceElement());
        }
        if (json.has("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(json.get("detailSequence").getAsString()));
        }
        if (json.has("_detailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
        }
        if (json.has("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(json.get("subDetailSequence").getAsString()));
        }
        if (json.has("_subDetailSequence")) {
            this.parseElementProperties(this.getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseClinicalImpressionProperties(json, res);
        return res;
    }

    protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
        int i;
        DataType effective;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("previous")) {
            res.setPrevious(this.parseReference(this.getJObject(json, "previous")));
        }
        if (json.has("problem")) {
            JsonArray array = json.getAsJsonArray("problem");
            for (i = 0; i < array.size(); ++i) {
                res.getProblem().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("protocol")) {
            JsonArray array = json.getAsJsonArray("protocol");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getProtocol().add(new UriType());
                    continue;
                }
                res.getProtocol().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_protocol")) {
            JsonArray array = json.getAsJsonArray("_protocol");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProtocol().size()) {
                    res.getProtocol().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
            }
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(this.getJObject(json, "_summary"), res.getSummaryElement());
        }
        if (json.has("finding")) {
            JsonArray array = json.getAsJsonArray("finding");
            for (i = 0; i < array.size(); ++i) {
                res.getFinding().add(this.parseClinicalImpressionFindingComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prognosisCodeableConcept")) {
            JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prognosisReference")) {
            JsonArray array = json.getAsJsonArray("prognosisReference");
            for (i = 0; i < array.size(); ++i) {
                res.getPrognosisReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseClinicalImpressionFindingComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableReference(this.getJObject(json, "item")));
        }
        if (json.has("basis")) {
            res.setBasisElement(this.parseString(json.get("basis").getAsString()));
        }
        if (json.has("_basis")) {
            this.parseElementProperties(this.getJObject(json, "_basis"), res.getBasisElement());
        }
    }

    protected ClinicalUseIssue parseClinicalUseIssue(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue res = new ClinicalUseIssue();
        this.parseClinicalUseIssueProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueProperties(JsonObject json, ClinicalUseIssue res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ClinicalUseIssue.ClinicalUseIssueType.NULL, new ClinicalUseIssue.ClinicalUseIssueTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i = 0; i < array.size(); ++i) {
                res.getSubject().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("contraindication")) {
            res.setContraindication(this.parseClinicalUseIssueContraindicationComponent(this.getJObject(json, "contraindication")));
        }
        if (json.has("indication")) {
            res.setIndication(this.parseClinicalUseIssueIndicationComponent(this.getJObject(json, "indication")));
        }
        if (json.has("interaction")) {
            res.setInteraction(this.parseClinicalUseIssueInteractionComponent(this.getJObject(json, "interaction")));
        }
        if (json.has("population")) {
            array = json.getAsJsonArray("population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parsePopulation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("undesirableEffect")) {
            res.setUndesirableEffect(this.parseClinicalUseIssueUndesirableEffectComponent(this.getJObject(json, "undesirableEffect")));
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueContraindicationComponent parseClinicalUseIssueContraindicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationComponent();
        this.parseClinicalUseIssueContraindicationComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueContraindicationComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableConcept(this.getJObject(json, "diseaseSymptomProcedure")));
        }
        if (json.has("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableConcept(this.getJObject(json, "diseaseStatus")));
        }
        if (json.has("comorbidity")) {
            array = json.getAsJsonArray("comorbidity");
            for (i = 0; i < array.size(); ++i) {
                res.getComorbidity().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("otherTherapy")) {
            array = json.getAsJsonArray("otherTherapy");
            for (i = 0; i < array.size(); ++i) {
                res.getOtherTherapy().add(this.parseClinicalUseIssueContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent parseClinicalUseIssueContraindicationOtherTherapyComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent();
        this.parseClinicalUseIssueContraindicationOtherTherapyComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueContraindicationOtherTherapyComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
        DataType medication;
        this.parseBackboneElementProperties(json, res);
        if (json.has("therapyRelationshipType")) {
            res.setTherapyRelationshipType(this.parseCodeableConcept(this.getJObject(json, "therapyRelationshipType")));
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueIndicationComponent parseClinicalUseIssueIndicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueIndicationComponent res = new ClinicalUseIssue.ClinicalUseIssueIndicationComponent();
        this.parseClinicalUseIssueIndicationComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueIndicationComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueIndicationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableConcept(this.getJObject(json, "diseaseSymptomProcedure")));
        }
        if (json.has("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableConcept(this.getJObject(json, "diseaseStatus")));
        }
        if (json.has("comorbidity")) {
            array = json.getAsJsonArray("comorbidity");
            for (i = 0; i < array.size(); ++i) {
                res.getComorbidity().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("intendedEffect")) {
            res.setIntendedEffect(this.parseCodeableConcept(this.getJObject(json, "intendedEffect")));
        }
        if (json.has("duration")) {
            res.setDuration(this.parseQuantity(this.getJObject(json, "duration")));
        }
        if (json.has("undesirableEffect")) {
            array = json.getAsJsonArray("undesirableEffect");
            for (i = 0; i < array.size(); ++i) {
                res.getUndesirableEffect().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("otherTherapy")) {
            array = json.getAsJsonArray("otherTherapy");
            for (i = 0; i < array.size(); ++i) {
                res.getOtherTherapy().add(this.parseClinicalUseIssueContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueInteractionComponent parseClinicalUseIssueInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueInteractionComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionComponent();
        this.parseClinicalUseIssueInteractionComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueInteractionComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueInteractionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("interactant")) {
            JsonArray array = json.getAsJsonArray("interactant");
            for (int i = 0; i < array.size(); ++i) {
                res.getInteractant().add(this.parseClinicalUseIssueInteractionInteractantComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("effect")) {
            res.setEffect(this.parseCodeableConcept(this.getJObject(json, "effect")));
        }
        if (json.has("incidence")) {
            res.setIncidence(this.parseCodeableConcept(this.getJObject(json, "incidence")));
        }
        if (json.has("management")) {
            res.setManagement(this.parseCodeableConcept(this.getJObject(json, "management")));
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent parseClinicalUseIssueInteractionInteractantComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent();
        this.parseClinicalUseIssueInteractionInteractantComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueInteractionInteractantComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
    }

    protected ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent parseClinicalUseIssueUndesirableEffectComponent(JsonObject json) throws IOException, FHIRFormatError {
        ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res = new ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent();
        this.parseClinicalUseIssueUndesirableEffectComponentProperties(json, res);
        return res;
    }

    protected void parseClinicalUseIssueUndesirableEffectComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("symptomConditionEffect")) {
            res.setSymptomConditionEffect(this.parseCodeableConcept(this.getJObject(json, "symptomConditionEffect")));
        }
        if (json.has("classification")) {
            res.setClassification(this.parseCodeableConcept(this.getJObject(json, "classification")));
        }
        if (json.has("frequencyOfOccurrence")) {
            res.setFrequencyOfOccurrence(this.parseCodeableConcept(this.getJObject(json, "frequencyOfOccurrence")));
        }
    }

    protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseCodeSystemProperties(json, res);
        return res;
    }

    protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(json.get("caseSensitive").getAsBoolean()));
        }
        if (json.has("_caseSensitive")) {
            this.parseElementProperties(this.getJObject(json, "_caseSensitive"), res.getCaseSensitiveElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseCanonical(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(this.getJObject(json, "_valueSet"), res.getValueSetElement());
        }
        if (json.has("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        }
        if (json.has("_hierarchyMeaning")) {
            this.parseElementProperties(this.getJObject(json, "_hierarchyMeaning"), res.getHierarchyMeaningElement());
        }
        if (json.has("compositional")) {
            res.setCompositionalElement(this.parseBoolean(json.get("compositional").getAsBoolean()));
        }
        if (json.has("_compositional")) {
            this.parseElementProperties(this.getJObject(json, "_compositional"), res.getCompositionalElement());
        }
        if (json.has("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(json.get("versionNeeded").getAsBoolean()));
        }
        if (json.has("_versionNeeded")) {
            this.parseElementProperties(this.getJObject(json, "_versionNeeded"), res.getVersionNeededElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(this.getJObject(json, "_content"), res.getContentElement());
        }
        if (json.has("supplements")) {
            res.setSupplementsElement(this.parseCanonical(json.get("supplements").getAsString()));
        }
        if (json.has("_supplements")) {
            this.parseElementProperties(this.getJObject(json, "_supplements"), res.getSupplementsElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseUnsignedInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(this.getJObject(json, "_count"), res.getCountElement());
        }
        if (json.has("filter")) {
            array = json.getAsJsonArray("filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseCodeSystemFilterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseCodeSystemFilterComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemFilterComponentProperties(JsonObject json, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("operator")) {
            array = json.getAsJsonArray("operator");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOperator().add(new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory(), Enumerations.FilterOperator.NULL));
                    continue;
                }
                res.getOperator().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
            }
        }
        if (json.has("_operator")) {
            array = json.getAsJsonArray("_operator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOperator().size()) {
                    res.getOperator().add(this.parseEnumeration(null, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
            }
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseCodeSystemPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseCodeSystemConceptDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseString(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(this.getJObject(json, "_definition"), res.getDefinitionElement());
        }
        if (json.has("designation")) {
            array = json.getAsJsonArray("designation");
            for (i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseCodeSystemConceptDefinitionDesignationComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(this.getJObject(json, "_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(this.getJObject(json, "use")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseCodeSystemConceptPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseCommunicationProperties(json, res);
        return res;
    }

    protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = json.getAsJsonArray("instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = json.getAsJsonArray("_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = json.getAsJsonArray("instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = json.getAsJsonArray("_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            array = json.getAsJsonArray("partOf");
            for (i = 0; i < array.size(); ++i) {
                res.getPartOf().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("inResponseTo")) {
            array = json.getAsJsonArray("inResponseTo");
            for (i = 0; i < array.size(); ++i) {
                res.getInResponseTo().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("topic")) {
            res.setTopic(this.parseCodeableConcept(this.getJObject(json, "topic")));
        }
        if (json.has("about")) {
            array = json.getAsJsonArray("about");
            for (i = 0; i < array.size(); ++i) {
                res.getAbout().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("sent")) {
            res.setSentElement(this.parseDateTime(json.get("sent").getAsString()));
        }
        if (json.has("_sent")) {
            this.parseElementProperties(this.getJObject(json, "_sent"), res.getSentElement());
        }
        if (json.has("received")) {
            res.setReceivedElement(this.parseDateTime(json.get("received").getAsString()));
        }
        if (json.has("_received")) {
            this.parseElementProperties(this.getJObject(json, "_received"), res.getReceivedElement());
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(this.getJObject(json, "sender")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationPayloadComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseCommunicationPayloadComponentProperties(json, res);
        return res;
    }

    protected void parseCommunicationPayloadComponentProperties(JsonObject json, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseCommunicationRequestProperties(json, res);
        return res;
    }

    protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("replaces")) {
            array = json.getAsJsonArray("replaces");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReplaces().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(this.getJObject(json, "groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("about")) {
            array = json.getAsJsonArray("about");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAbout().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPayload().add(this.parseCommunicationRequestPayloadComponent(array.get(i2).getAsJsonObject()));
            }
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(this.getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(this.getJObject(json, "requester")));
        }
        if (json.has("recipient")) {
            JsonArray array2 = json.getAsJsonArray("recipient");
            for (i = 0; i < array2.size(); ++i) {
                res.getRecipient().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("informationProvider")) {
            JsonArray array3 = json.getAsJsonArray("informationProvider");
            for (i = 0; i < array3.size(); ++i) {
                res.getInformationProvider().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            JsonArray array4 = json.getAsJsonArray("reason");
            for (i = 0; i < array4.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array5 = json.getAsJsonArray("note");
            for (i = 0; i < array5.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array5.get(i).getAsJsonObject()));
            }
        }
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseCommunicationRequestPayloadComponentProperties(json, res);
        return res;
    }

    protected void parseCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseCompartmentDefinitionProperties(json, res);
        return res;
    }

    protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("search")) {
            res.setSearchElement(this.parseBoolean(json.get("search").getAsBoolean()));
        }
        if (json.has("_search")) {
            this.parseElementProperties(this.getJObject(json, "_search"), res.getSearchElement());
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseCompartmentDefinitionResourceComponentProperties(json, res);
        return res;
    }

    protected void parseCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("param")) {
            array = json.getAsJsonArray("param");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getParam().add(new StringType());
                    continue;
                }
                res.getParam().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_param")) {
            array = json.getAsJsonArray("_param");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParam().size()) {
                    res.getParam().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(this.getJObject(json, "_documentation"), res.getDocumentationElement());
        }
    }

    protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseCompositionProperties(json, res);
        return res;
    }

    protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("confidentiality")) {
            res.setConfidentialityElement(this.parseCode(json.get("confidentiality").getAsString()));
        }
        if (json.has("_confidentiality")) {
            this.parseElementProperties(this.getJObject(json, "_confidentiality"), res.getConfidentialityElement());
        }
        if (json.has("attester")) {
            array = json.getAsJsonArray("attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseCompositionAttesterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseCompositionRelatesToComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCompositionEventComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseCompositionAttesterComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionAttesterComponentProperties(JsonObject json, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected Composition.CompositionRelatesToComponent parseCompositionRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
        this.parseCompositionRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionRelatesToComponentProperties(JsonObject json, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
        DataType target;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
    }

    protected Composition.CompositionEventComponent parseCompositionEventComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseCompositionEventComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionEventComponentProperties(JsonObject json, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseCompositionSectionComponentProperties(json, res);
        return res;
    }

    protected void parseCompositionSectionComponentProperties(JsonObject json, Composition.SectionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("focus")) {
            res.setFocus(this.parseReference(this.getJObject(json, "focus")));
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(this.getJObject(json, "orderedBy")));
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(this.getJObject(json, "emptyReason")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseConceptMapProperties(json, res);
        return res;
    }

    protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
        DataType target;
        DataType source;
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.addIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("group")) {
            JsonArray array2 = json.getAsJsonArray("group");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getGroup().add(this.parseConceptMapGroupComponent(array2.get(i2).getAsJsonObject()));
            }
        }
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseConceptMapGroupComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapGroupComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("sourceVersion")) {
            res.setSourceVersionElement(this.parseString(json.get("sourceVersion").getAsString()));
        }
        if (json.has("_sourceVersion")) {
            this.parseElementProperties(this.getJObject(json, "_sourceVersion"), res.getSourceVersionElement());
        }
        if (json.has("target")) {
            res.setTargetElement(this.parseUri(json.get("target").getAsString()));
        }
        if (json.has("_target")) {
            this.parseElementProperties(this.getJObject(json, "_target"), res.getTargetElement());
        }
        if (json.has("targetVersion")) {
            res.setTargetVersionElement(this.parseString(json.get("targetVersion").getAsString()));
        }
        if (json.has("_targetVersion")) {
            this.parseElementProperties(this.getJObject(json, "_targetVersion"), res.getTargetVersionElement());
        }
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("unmapped")) {
            res.setUnmapped(this.parseConceptMapGroupUnmappedComponent(this.getJObject(json, "unmapped")));
        }
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseConceptMapSourceElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("noMap")) {
            res.setNoMapElement(this.parseBoolean(json.get("noMap").getAsBoolean()));
        }
        if (json.has("_noMap")) {
            this.parseElementProperties(this.getJObject(json, "_noMap"), res.getNoMapElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseConceptMapTargetElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(this.getJObject(json, "_relationship"), res.getRelationshipElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("dependsOn")) {
            array = json.getAsJsonArray("dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("product")) {
            array = json.getAsJsonArray("product");
            for (i = 0; i < array.size(); ++i) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseConceptMapOtherElementComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("property")) {
            res.setPropertyElement(this.parseUri(json.get("property").getAsString()));
        }
        if (json.has("_property")) {
            this.parseElementProperties(this.getJObject(json, "_property"), res.getPropertyElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseCanonical(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(this.getJObject(json, "_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseConceptMapGroupUnmappedComponentProperties(json, res);
        return res;
    }

    protected void parseConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(this.getJObject(json, "_display"), res.getDisplayElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseCanonical(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
    }

    protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseConditionProperties(json, res);
        return res;
    }

    protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType abatement;
        DataType onset;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(this.getJObject(json, "clinicalStatus")));
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(this.getJObject(json, "verificationStatus")));
        }
        if (json.has("category")) {
            array2 = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(this.getJObject(json, "severity")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("bodySite")) {
            array2 = json.getAsJsonArray("bodySite");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBodySite().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if ((abatement = this.parseType("abatement", json)) != null) {
            res.setAbatement(abatement);
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(this.getJObject(json, "_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(this.getJObject(json, "recorder")));
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(this.getJObject(json, "asserter")));
        }
        if (json.has("stage")) {
            array = json.getAsJsonArray("stage");
            for (i = 0; i < array.size(); ++i) {
                res.getStage().add(this.parseConditionStageComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("evidence")) {
            array = json.getAsJsonArray("evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseConditionEvidenceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Condition.ConditionStageComponent parseConditionStageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseConditionStageComponentProperties(json, res);
        return res;
    }

    protected void parseConditionStageComponentProperties(JsonObject json, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("summary")) {
            res.setSummary(this.parseCodeableConcept(this.getJObject(json, "summary")));
        }
        if (json.has("assessment")) {
            JsonArray array = json.getAsJsonArray("assessment");
            for (int i = 0; i < array.size(); ++i) {
                res.getAssessment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
    }

    protected Condition.ConditionEvidenceComponent parseConditionEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseConditionEvidenceComponentProperties(json, res);
        return res;
    }

    protected void parseConditionEvidenceComponentProperties(JsonObject json, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ConditionDefinition parseConditionDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition res = new ConditionDefinition();
        this.parseConditionDefinitionProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionProperties(JsonObject json, ConditionDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(this.getJObject(json, "severity")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("stage")) {
            res.setStage(this.parseCodeableConcept(this.getJObject(json, "stage")));
        }
        if (json.has("hasSeverity")) {
            res.setHasSeverityElement(this.parseBoolean(json.get("hasSeverity").getAsBoolean()));
        }
        if (json.has("_hasSeverity")) {
            this.parseElementProperties(this.getJObject(json, "_hasSeverity"), res.getHasSeverityElement());
        }
        if (json.has("hasBodySite")) {
            res.setHasBodySiteElement(this.parseBoolean(json.get("hasBodySite").getAsBoolean()));
        }
        if (json.has("_hasBodySite")) {
            this.parseElementProperties(this.getJObject(json, "_hasBodySite"), res.getHasBodySiteElement());
        }
        if (json.has("hasStage")) {
            res.setHasStageElement(this.parseBoolean(json.get("hasStage").getAsBoolean()));
        }
        if (json.has("_hasStage")) {
            this.parseElementProperties(this.getJObject(json, "_hasStage"), res.getHasStageElement());
        }
        if (json.has("definition")) {
            array = json.getAsJsonArray("definition");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDefinition().add(new UriType());
                    continue;
                }
                res.getDefinition().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_definition")) {
            array = json.getAsJsonArray("_definition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDefinition().size()) {
                    res.getDefinition().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
            }
        }
        if (json.has("observation")) {
            array = json.getAsJsonArray("observation");
            for (i = 0; i < array.size(); ++i) {
                res.getObservation().add(this.parseConditionDefinitionObservationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("medication")) {
            array = json.getAsJsonArray("medication");
            for (i = 0; i < array.size(); ++i) {
                res.getMedication().add(this.parseConditionDefinitionMedicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("precondition")) {
            array = json.getAsJsonArray("precondition");
            for (i = 0; i < array.size(); ++i) {
                res.getPrecondition().add(this.parseConditionDefinitionPreconditionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("team")) {
            array = json.getAsJsonArray("team");
            for (i = 0; i < array.size(); ++i) {
                res.getTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("questionnaire")) {
            array = json.getAsJsonArray("questionnaire");
            for (i = 0; i < array.size(); ++i) {
                res.getQuestionnaire().add(this.parseConditionDefinitionQuestionnaireComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("plan")) {
            array = json.getAsJsonArray("plan");
            for (i = 0; i < array.size(); ++i) {
                res.getPlan().add(this.parseConditionDefinitionPlanComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionObservationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
        this.parseConditionDefinitionObservationComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionObservationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionObservationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionMedicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
        this.parseConditionDefinitionMedicationComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionMedicationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionPreconditionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
        this.parseConditionDefinitionPreconditionComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionPreconditionComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionQuestionnaireComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
        this.parseConditionDefinitionQuestionnaireComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionQuestionnaireComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseEnumeration(json.get("purpose").getAsString(), ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
        this.parseConditionDefinitionPlanComponentProperties(json, res);
        return res;
    }

    protected void parseConditionDefinitionPlanComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPlanComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseConsentProperties(json, res);
        return res;
    }

    protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("scope")) {
            res.setScope(this.parseCodeableConcept(this.getJObject(json, "scope")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(this.getJObject(json, "_dateTime"), res.getDateTimeElement());
        }
        if (json.has("performer")) {
            array = json.getAsJsonArray("performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("manager")) {
            array = json.getAsJsonArray("manager");
            for (i = 0; i < array.size(); ++i) {
                res.getManager().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("controller")) {
            array = json.getAsJsonArray("controller");
            for (i = 0; i < array.size(); ++i) {
                res.getController().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("sourceAttachment")) {
            array = json.getAsJsonArray("sourceAttachment");
            for (i = 0; i < array.size(); ++i) {
                res.getSourceAttachment().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("sourceReference")) {
            array = json.getAsJsonArray("sourceReference");
            for (i = 0; i < array.size(); ++i) {
                res.getSourceReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseConsentPolicyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("policyRule")) {
            res.setPolicyRule(this.parseCodeableConcept(this.getJObject(json, "policyRule")));
        }
        if (json.has("verification")) {
            array = json.getAsJsonArray("verification");
            for (i = 0; i < array.size(); ++i) {
                res.getVerification().add(this.parseConsentVerificationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("provision")) {
            res.setProvision(this.parseConsentProvisionComponent(this.getJObject(json, "provision")));
        }
    }

    protected Consent.ConsentPolicyComponent parseConsentPolicyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
        this.parseConsentPolicyComponentProperties(json, res);
        return res;
    }

    protected void parseConsentPolicyComponentProperties(JsonObject json, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("authority")) {
            res.setAuthorityElement(this.parseUri(json.get("authority").getAsString()));
        }
        if (json.has("_authority")) {
            this.parseElementProperties(this.getJObject(json, "_authority"), res.getAuthorityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
    }

    protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
        this.parseConsentVerificationComponentProperties(json, res);
        return res;
    }

    protected void parseConsentVerificationComponentProperties(JsonObject json, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("verified")) {
            res.setVerifiedElement(this.parseBoolean(json.get("verified").getAsBoolean()));
        }
        if (json.has("_verified")) {
            this.parseElementProperties(this.getJObject(json, "_verified"), res.getVerifiedElement());
        }
        if (json.has("verificationType")) {
            res.setVerificationType(this.parseCodeableConcept(this.getJObject(json, "verificationType")));
        }
        if (json.has("verifiedBy")) {
            res.setVerifiedBy(this.parseReference(this.getJObject(json, "verifiedBy")));
        }
        if (json.has("verifiedWith")) {
            res.setVerifiedWith(this.parseReference(this.getJObject(json, "verifiedWith")));
        }
        if (json.has("verificationDate")) {
            array = json.getAsJsonArray("verificationDate");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getVerificationDate().add(new DateTimeType());
                    continue;
                }
                res.getVerificationDate().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_verificationDate")) {
            array = json.getAsJsonArray("_verificationDate");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getVerificationDate().size()) {
                    res.getVerificationDate().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getVerificationDate().get(i));
            }
        }
    }

    protected Consent.ProvisionComponent parseConsentProvisionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionComponent res = new Consent.ProvisionComponent();
        this.parseConsentProvisionComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionComponentProperties(JsonObject json, Consent.ProvisionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseConsentProvisionActorComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            array = json.getAsJsonArray("purpose");
            for (i = 0; i < array.size(); ++i) {
                res.getPurpose().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("class")) {
            array = json.getAsJsonArray("class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(this.getJObject(json, "dataPeriod")));
        }
        if (json.has("data")) {
            array = json.getAsJsonArray("data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseConsentProvisionDataComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("provision")) {
            array = json.getAsJsonArray("provision");
            for (i = 0; i < array.size(); ++i) {
                res.getProvision().add(this.parseConsentProvisionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
        this.parseConsentProvisionActorComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionActorComponentProperties(JsonObject json, Consent.ProvisionActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(JsonObject json) throws IOException, FHIRFormatError {
        Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
        this.parseConsentProvisionDataComponentProperties(json, res);
        return res;
    }

    protected void parseConsentProvisionDataComponentProperties(JsonObject json, Consent.ProvisionDataComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("meaning")) {
            res.setMeaningElement(this.parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        }
        if (json.has("_meaning")) {
            this.parseElementProperties(this.getJObject(json, "_meaning"), res.getMeaningElement());
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
    }

    protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseContractProperties(json, res);
        return res;
    }

    protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
        DataType legallyBinding;
        int i;
        DataType topic;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("legalState")) {
            res.setLegalState(this.parseCodeableConcept(this.getJObject(json, "legalState")));
        }
        if (json.has("instantiatesCanonical")) {
            res.setInstantiatesCanonical(this.parseReference(this.getJObject(json, "instantiatesCanonical")));
        }
        if (json.has("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(json.get("instantiatesUri").getAsString()));
        }
        if (json.has("_instantiatesUri")) {
            this.parseElementProperties(this.getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
        }
        if (json.has("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(this.getJObject(json, "contentDerivative")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(this.getJObject(json, "applies")));
        }
        if (json.has("expirationType")) {
            res.setExpirationType(this.parseCodeableConcept(this.getJObject(json, "expirationType")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("authority")) {
            array = json.getAsJsonArray("authority");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthority().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("domain")) {
            array = json.getAsJsonArray("domain");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDomain().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("site")) {
            array = json.getAsJsonArray("site");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSite().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("alias")) {
            array = json.getAsJsonArray("alias");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getAlias().add(new StringType());
                    continue;
                }
                res.getAlias().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array = json.getAsJsonArray("_alias");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getAlias().get(i2));
            }
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("scope")) {
            res.setScope(this.parseCodeableConcept(this.getJObject(json, "scope")));
        }
        if ((topic = this.parseType("topic", json)) != null) {
            res.setTopic(topic);
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            JsonArray array2 = json.getAsJsonArray("subType");
            for (i = 0; i < array2.size(); ++i) {
                res.getSubType().add(this.parseCodeableConcept(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contentDefinition")) {
            res.setContentDefinition(this.parseContractContentDefinitionComponent(this.getJObject(json, "contentDefinition")));
        }
        if (json.has("term")) {
            JsonArray array3 = json.getAsJsonArray("term");
            for (i = 0; i < array3.size(); ++i) {
                res.getTerm().add(this.parseContractTermComponent(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array4 = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array4.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relevantHistory")) {
            JsonArray array5 = json.getAsJsonArray("relevantHistory");
            for (i = 0; i < array5.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("signer")) {
            JsonArray array6 = json.getAsJsonArray("signer");
            for (i = 0; i < array6.size(); ++i) {
                res.getSigner().add(this.parseContractSignatoryComponent(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("friendly")) {
            JsonArray array7 = json.getAsJsonArray("friendly");
            for (i = 0; i < array7.size(); ++i) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("legal")) {
            JsonArray array8 = json.getAsJsonArray("legal");
            for (i = 0; i < array8.size(); ++i) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rule")) {
            JsonArray array9 = json.getAsJsonArray("rule");
            for (i = 0; i < array9.size(); ++i) {
                res.getRule().add(this.parseContractComputableLanguageComponent(array9.get(i).getAsJsonObject()));
            }
        }
        if ((legallyBinding = this.parseType("legallyBinding", json)) != null) {
            res.setLegallyBinding(legallyBinding);
        }
    }

    protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
        this.parseContractContentDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("publisher")) {
            res.setPublisher(this.parseReference(this.getJObject(json, "publisher")));
        }
        if (json.has("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(json.get("publicationDate").getAsString()));
        }
        if (json.has("_publicationDate")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDate"), res.getPublicationDateElement());
        }
        if (json.has("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
        }
        if (json.has("_publicationStatus")) {
            this.parseElementProperties(this.getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
    }

    protected Contract.TermComponent parseContractTermComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseContractTermComponentProperties(json, res);
        return res;
    }

    protected void parseContractTermComponentProperties(JsonObject json, Contract.TermComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType topic;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(this.getJObject(json, "applies")));
        }
        if ((topic = this.parseType("topic", json)) != null) {
            res.setTopic(topic);
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseContractSecurityLabelComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("offer")) {
            res.setOffer(this.parseContractOfferComponent(this.getJObject(json, "offer")));
        }
        if (json.has("asset")) {
            array = json.getAsJsonArray("asset");
            for (i = 0; i < array.size(); ++i) {
                res.getAsset().add(this.parseContractAssetComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseContractActionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseContractTermComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
        this.parseContractSecurityLabelComponentProperties(json, res);
        return res;
    }

    protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            array = json.getAsJsonArray("number");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_number")) {
            array = json.getAsJsonArray("_number");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNumber().size()) {
                    res.getNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
            }
        }
        if (json.has("classification")) {
            res.setClassification(this.parseCoding(this.getJObject(json, "classification")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("control")) {
            array = json.getAsJsonArray("control");
            for (i = 0; i < array.size(); ++i) {
                res.getControl().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.ContractOfferComponent parseContractOfferComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
        this.parseContractOfferComponentProperties(json, res);
        return res;
    }

    protected void parseContractOfferComponentProperties(JsonObject json, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("party")) {
            array = json.getAsJsonArray("party");
            for (i = 0; i < array.size(); ++i) {
                res.getParty().add(this.parseContractPartyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            res.setTopic(this.parseReference(this.getJObject(json, "topic")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("decision")) {
            res.setDecision(this.parseCodeableConcept(this.getJObject(json, "decision")));
        }
        if (json.has("decisionMode")) {
            array = json.getAsJsonArray("decisionMode");
            for (i = 0; i < array.size(); ++i) {
                res.getDecisionMode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("answer")) {
            array = json.getAsJsonArray("answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseContractAnswerComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("linkId")) {
            array = json.getAsJsonArray("linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = json.getAsJsonArray("_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = json.getAsJsonArray("securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = json.getAsJsonArray("_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ContractPartyComponent parseContractPartyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
        this.parseContractPartyComponentProperties(json, res);
        return res;
    }

    protected void parseContractPartyComponentProperties(JsonObject json, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            JsonArray array = json.getAsJsonArray("reference");
            for (int i = 0; i < array.size(); ++i) {
                res.getReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
    }

    protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.AnswerComponent res = new Contract.AnswerComponent();
        this.parseContractAnswerComponentProperties(json, res);
        return res;
    }

    protected void parseContractAnswerComponentProperties(JsonObject json, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
    }

    protected Contract.ContractAssetComponent parseContractAssetComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
        this.parseContractAssetComponentProperties(json, res);
        return res;
    }

    protected void parseContractAssetComponentProperties(JsonObject json, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("scope")) {
            res.setScope(this.parseCodeableConcept(this.getJObject(json, "scope")));
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("typeReference")) {
            array = json.getAsJsonArray("typeReference");
            for (i = 0; i < array.size(); ++i) {
                res.getTypeReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subtype")) {
            array = json.getAsJsonArray("subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(this.getJObject(json, "relationship")));
        }
        if (json.has("context")) {
            array = json.getAsJsonArray("context");
            for (i = 0; i < array.size(); ++i) {
                res.getContext().add(this.parseContractAssetContextComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            res.setConditionElement(this.parseString(json.get("condition").getAsString()));
        }
        if (json.has("_condition")) {
            this.parseElementProperties(this.getJObject(json, "_condition"), res.getConditionElement());
        }
        if (json.has("periodType")) {
            array = json.getAsJsonArray("periodType");
            for (i = 0; i < array.size(); ++i) {
                res.getPeriodType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            array = json.getAsJsonArray("period");
            for (i = 0; i < array.size(); ++i) {
                res.getPeriod().add(this.parsePeriod(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("usePeriod")) {
            array = json.getAsJsonArray("usePeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getUsePeriod().add(this.parsePeriod(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("linkId")) {
            array = json.getAsJsonArray("linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = json.getAsJsonArray("_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
            }
        }
        if (json.has("answer")) {
            array = json.getAsJsonArray("answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseContractAnswerComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = json.getAsJsonArray("securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = json.getAsJsonArray("_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
            }
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i = 0; i < array.size(); ++i) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.AssetContextComponent res = new Contract.AssetContextComponent();
        this.parseContractAssetContextComponentProperties(json, res);
        return res;
    }

    protected void parseContractAssetContextComponentProperties(JsonObject json, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("code")) {
            JsonArray array = json.getAsJsonArray("code");
            for (int i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseContractValuedItemComponentProperties(json, res);
        return res;
    }

    protected void parseContractValuedItemComponentProperties(JsonObject json, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        DataType entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(this.getJObject(json, "_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(this.getJObject(json, "_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("payment")) {
            res.setPaymentElement(this.parseString(json.get("payment").getAsString()));
        }
        if (json.has("_payment")) {
            this.parseElementProperties(this.getJObject(json, "_payment"), res.getPaymentElement());
        }
        if (json.has("paymentDate")) {
            res.setPaymentDateElement(this.parseDateTime(json.get("paymentDate").getAsString()));
        }
        if (json.has("_paymentDate")) {
            this.parseElementProperties(this.getJObject(json, "_paymentDate"), res.getPaymentDateElement());
        }
        if (json.has("responsible")) {
            res.setResponsible(this.parseReference(this.getJObject(json, "responsible")));
        }
        if (json.has("recipient")) {
            res.setRecipient(this.parseReference(this.getJObject(json, "recipient")));
        }
        if (json.has("linkId")) {
            array = json.getAsJsonArray("linkId");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = json.getAsJsonArray("_linkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
            }
        }
        if (json.has("securityLabelNumber")) {
            array = json.getAsJsonArray("securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            array = json.getAsJsonArray("_securityLabelNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ActionComponent parseContractActionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ActionComponent res = new Contract.ActionComponent();
        this.parseContractActionComponentProperties(json, res);
        return res;
    }

    protected void parseContractActionComponentProperties(JsonObject json, Contract.ActionComponent res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(json.get("doNotPerform").getAsBoolean()));
        }
        if (json.has("_doNotPerform")) {
            this.parseElementProperties(this.getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseContractActionSubjectComponent(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("intent")) {
            res.setIntent(this.parseCodeableConcept(this.getJObject(json, "intent")));
        }
        if (json.has("linkId")) {
            array = json.getAsJsonArray("linkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getLinkId().add(new StringType());
                    continue;
                }
                res.getLinkId().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_linkId")) {
            array = json.getAsJsonArray("_linkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getLinkId().size()) {
                    res.getLinkId().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getLinkId().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(this.getJObject(json, "status")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(this.getJObject(json, "context")));
        }
        if (json.has("contextLinkId")) {
            array = json.getAsJsonArray("contextLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getContextLinkId().add(new StringType());
                    continue;
                }
                res.getContextLinkId().add(this.parseString(array.get(i2).getAsString()));
            }
        }
        if (json.has("_contextLinkId")) {
            array = json.getAsJsonArray("_contextLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getContextLinkId().size()) {
                    res.getContextLinkId().add(this.parseString(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getContextLinkId().get(i2));
            }
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("requester")) {
            JsonArray array2 = json.getAsJsonArray("requester");
            for (i = 0; i < array2.size(); ++i) {
                res.getRequester().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requesterLinkId")) {
            JsonArray array3 = json.getAsJsonArray("requesterLinkId");
            for (i = 0; i < array3.size(); ++i) {
                if (array3.get(i).isJsonNull()) {
                    res.getRequesterLinkId().add(new StringType());
                    continue;
                }
                res.getRequesterLinkId().add(this.parseString(array3.get(i).getAsString()));
            }
        }
        if (json.has("_requesterLinkId")) {
            JsonArray array4 = json.getAsJsonArray("_requesterLinkId");
            for (i = 0; i < array4.size(); ++i) {
                if (i == res.getRequesterLinkId().size()) {
                    res.getRequesterLinkId().add(this.parseString(null));
                }
                if (!(array4.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array4.get(i).getAsJsonObject(), res.getRequesterLinkId().get(i));
            }
        }
        if (json.has("performerType")) {
            JsonArray array5 = json.getAsJsonArray("performerType");
            for (i = 0; i < array5.size(); ++i) {
                res.getPerformerType().add(this.parseCodeableConcept(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("performerRole")) {
            res.setPerformerRole(this.parseCodeableConcept(this.getJObject(json, "performerRole")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("performerLinkId")) {
            JsonArray array6 = json.getAsJsonArray("performerLinkId");
            for (i = 0; i < array6.size(); ++i) {
                if (array6.get(i).isJsonNull()) {
                    res.getPerformerLinkId().add(new StringType());
                    continue;
                }
                res.getPerformerLinkId().add(this.parseString(array6.get(i).getAsString()));
            }
        }
        if (json.has("_performerLinkId")) {
            JsonArray array7 = json.getAsJsonArray("_performerLinkId");
            for (i = 0; i < array7.size(); ++i) {
                if (i == res.getPerformerLinkId().size()) {
                    res.getPerformerLinkId().add(this.parseString(null));
                }
                if (!(array7.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array7.get(i).getAsJsonObject(), res.getPerformerLinkId().get(i));
            }
        }
        if (json.has("reason")) {
            JsonArray array8 = json.getAsJsonArray("reason");
            for (i = 0; i < array8.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonLinkId")) {
            JsonArray array9 = json.getAsJsonArray("reasonLinkId");
            for (i = 0; i < array9.size(); ++i) {
                if (array9.get(i).isJsonNull()) {
                    res.getReasonLinkId().add(new StringType());
                    continue;
                }
                res.getReasonLinkId().add(this.parseString(array9.get(i).getAsString()));
            }
        }
        if (json.has("_reasonLinkId")) {
            JsonArray array10 = json.getAsJsonArray("_reasonLinkId");
            for (i = 0; i < array10.size(); ++i) {
                if (i == res.getReasonLinkId().size()) {
                    res.getReasonLinkId().add(this.parseString(null));
                }
                if (!(array10.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array10.get(i).getAsJsonObject(), res.getReasonLinkId().get(i));
            }
        }
        if (json.has("note")) {
            JsonArray array11 = json.getAsJsonArray("note");
            for (i = 0; i < array11.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array11.get(i).getAsJsonObject()));
            }
        }
        if (json.has("securityLabelNumber")) {
            JsonArray array12 = json.getAsJsonArray("securityLabelNumber");
            for (i = 0; i < array12.size(); ++i) {
                if (array12.get(i).isJsonNull()) {
                    res.getSecurityLabelNumber().add(new UnsignedIntType());
                    continue;
                }
                res.getSecurityLabelNumber().add(this.parseUnsignedInt(array12.get(i).getAsString()));
            }
        }
        if (json.has("_securityLabelNumber")) {
            JsonArray array13 = json.getAsJsonArray("_securityLabelNumber");
            for (i = 0; i < array13.size(); ++i) {
                if (i == res.getSecurityLabelNumber().size()) {
                    res.getSecurityLabelNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array13.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array13.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
            }
        }
    }

    protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
        this.parseContractActionSubjectComponentProperties(json, res);
        return res;
    }

    protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            JsonArray array = json.getAsJsonArray("reference");
            for (int i = 0; i < array.size(); ++i) {
                res.getReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseContractSignatoryComponentProperties(json, res);
        return res;
    }

    protected void parseContractSignatoryComponentProperties(JsonObject json, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
        if (json.has("signature")) {
            JsonArray array = json.getAsJsonArray("signature");
            for (int i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseContractFriendlyLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseContractLegalLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseContractComputableLanguageComponentProperties(json, res);
        return res;
    }

    protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
    }

    protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseCoverageProperties(json, res);
        return res;
    }

    protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("policyHolder")) {
            res.setPolicyHolder(this.parseReference(this.getJObject(json, "policyHolder")));
        }
        if (json.has("subscriber")) {
            res.setSubscriber(this.parseReference(this.getJObject(json, "subscriber")));
        }
        if (json.has("subscriberId")) {
            res.setSubscriberId(this.parseIdentifier(this.getJObject(json, "subscriberId")));
        }
        if (json.has("beneficiary")) {
            res.setBeneficiary(this.parseReference(this.getJObject(json, "beneficiary")));
        }
        if (json.has("dependent")) {
            res.setDependentElement(this.parseString(json.get("dependent").getAsString()));
        }
        if (json.has("_dependent")) {
            this.parseElementProperties(this.getJObject(json, "_dependent"), res.getDependentElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("payor")) {
            array = json.getAsJsonArray("payor");
            for (i = 0; i < array.size(); ++i) {
                res.getPayor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("class")) {
            array = json.getAsJsonArray("class");
            for (i = 0; i < array.size(); ++i) {
                res.getClass_().add(this.parseCoverageClassComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("order")) {
            res.setOrderElement(this.parsePositiveInt(json.get("order").getAsString()));
        }
        if (json.has("_order")) {
            this.parseElementProperties(this.getJObject(json, "_order"), res.getOrderElement());
        }
        if (json.has("network")) {
            res.setNetworkElement(this.parseString(json.get("network").getAsString()));
        }
        if (json.has("_network")) {
            this.parseElementProperties(this.getJObject(json, "_network"), res.getNetworkElement());
        }
        if (json.has("costToBeneficiary")) {
            array = json.getAsJsonArray("costToBeneficiary");
            for (i = 0; i < array.size(); ++i) {
                res.getCostToBeneficiary().add(this.parseCoverageCostToBeneficiaryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subrogation")) {
            res.setSubrogationElement(this.parseBoolean(json.get("subrogation").getAsBoolean()));
        }
        if (json.has("_subrogation")) {
            this.parseElementProperties(this.getJObject(json, "_subrogation"), res.getSubrogationElement());
        }
        if (json.has("contract")) {
            array = json.getAsJsonArray("contract");
            for (i = 0; i < array.size(); ++i) {
                res.getContract().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.ClassComponent res = new Coverage.ClassComponent();
        this.parseCoverageClassComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageClassComponentProperties(JsonObject json, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
    }

    protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
        this.parseCoverageCostToBeneficiaryComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageCostToBeneficiaryComponentProperties(JsonObject json, Coverage.CostToBeneficiaryComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exception")) {
            JsonArray array = json.getAsJsonArray("exception");
            for (int i = 0; i < array.size(); ++i) {
                res.getException().add(this.parseCoverageExemptionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Coverage.ExemptionComponent parseCoverageExemptionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
        this.parseCoverageExemptionComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageExemptionComponentProperties(JsonObject json, Coverage.ExemptionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest res = new CoverageEligibilityRequest();
        this.parseCoverageEligibilityRequestProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType serviced;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("purpose")) {
            array = json.getAsJsonArray("purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getPurpose().add(new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL));
                    continue;
                }
                res.getPurpose().add(this.parseEnumeration(array.get(i2).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
            }
        }
        if (json.has("_purpose")) {
            array = json.getAsJsonArray("_purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getPurpose().size()) {
                    res.getPurpose().add(this.parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getPurpose().get(i2));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("supportingInfo")) {
            JsonArray array2 = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array2.size(); ++i) {
                res.getSupportingInfo().add(this.parseCoverageEligibilityRequestSupportingInformationComponent(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("insurance")) {
            JsonArray array3 = json.getAsJsonArray("insurance");
            for (i = 0; i < array3.size(); ++i) {
                res.getInsurance().add(this.parseCoverageEligibilityRequestInsuranceComponent(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("item")) {
            JsonArray array4 = json.getAsJsonArray("item");
            for (i = 0; i < array4.size(); ++i) {
                res.getItem().add(this.parseCoverageEligibilityRequestDetailsComponent(array4.get(i).getAsJsonObject()));
            }
        }
    }

    protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
        this.parseCoverageEligibilityRequestSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestSupportingInformationComponentProperties(JsonObject json, CoverageEligibilityRequest.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("information")) {
            res.setInformation(this.parseReference(this.getJObject(json, "information")));
        }
        if (json.has("appliesToAll")) {
            res.setAppliesToAllElement(this.parseBoolean(json.get("appliesToAll").getAsBoolean()));
        }
        if (json.has("_appliesToAll")) {
            this.parseElementProperties(this.getJObject(json, "_appliesToAll"), res.getAppliesToAllElement());
        }
    }

    protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
        this.parseCoverageEligibilityRequestInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(this.getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
        }
    }

    protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
        this.parseCoverageEligibilityRequestDetailsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("supportingInfoSequence")) {
            array = json.getAsJsonArray("supportingInfoSequence");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getSupportingInfoSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSupportingInfoSequence().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_supportingInfoSequence")) {
            array = json.getAsJsonArray("_supportingInfoSequence");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSupportingInfoSequence().size()) {
                    res.getSupportingInfoSequence().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportingInfoSequence().get(i));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseCoverageEligibilityRequestDiagnosisComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
        this.parseCoverageEligibilityRequestDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType diagnosis = this.parseType("diagnosis", json);
        if (diagnosis != null) {
            res.setDiagnosis(diagnosis);
        }
    }

    protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse res = new CoverageEligibilityResponse();
        this.parseCoverageEligibilityResponseProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
        int i;
        DataType serviced;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("purpose")) {
            array = json.getAsJsonArray("purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getPurpose().add(new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL));
                    continue;
                }
                res.getPurpose().add(this.parseEnumeration(array.get(i2).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
            }
        }
        if (json.has("_purpose")) {
            array = json.getAsJsonArray("_purpose");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getPurpose().size()) {
                    res.getPurpose().add(this.parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getPurpose().get(i2));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("requestor")) {
            res.setRequestor(this.parseReference(this.getJObject(json, "requestor")));
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("insurance")) {
            JsonArray array2 = json.getAsJsonArray("insurance");
            for (i = 0; i < array2.size(); ++i) {
                res.getInsurance().add(this.parseCoverageEligibilityResponseInsuranceComponent(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(json.get("preAuthRef").getAsString()));
        }
        if (json.has("_preAuthRef")) {
            this.parseElementProperties(this.getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
        }
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(this.getJObject(json, "form")));
        }
        if (json.has("error")) {
            JsonArray array3 = json.getAsJsonArray("error");
            for (i = 0; i < array3.size(); ++i) {
                res.getError().add(this.parseCoverageEligibilityResponseErrorsComponent(array3.get(i).getAsJsonObject()));
            }
        }
    }

    protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
        this.parseCoverageEligibilityResponseInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("inforce")) {
            res.setInforceElement(this.parseBoolean(json.get("inforce").getAsBoolean()));
        }
        if (json.has("_inforce")) {
            this.parseElementProperties(this.getJObject(json, "_inforce"), res.getInforceElement());
        }
        if (json.has("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(this.getJObject(json, "benefitPeriod")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseCoverageEligibilityResponseItemsComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
        this.parseCoverageEligibilityResponseItemsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(this.getJObject(json, "_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(this.getJObject(json, "network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if (json.has("benefit")) {
            array = json.getAsJsonArray("benefit");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefit().add(this.parseCoverageEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("authorizationRequired")) {
            res.setAuthorizationRequiredElement(this.parseBoolean(json.get("authorizationRequired").getAsBoolean()));
        }
        if (json.has("_authorizationRequired")) {
            this.parseElementProperties(this.getJObject(json, "_authorizationRequired"), res.getAuthorizationRequiredElement());
        }
        if (json.has("authorizationSupporting")) {
            array = json.getAsJsonArray("authorizationSupporting");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthorizationSupporting().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("authorizationUrl")) {
            res.setAuthorizationUrlElement(this.parseUri(json.get("authorizationUrl").getAsString()));
        }
        if (json.has("_authorizationUrl")) {
            this.parseElementProperties(this.getJObject(json, "_authorizationUrl"), res.getAuthorizationUrlElement());
        }
    }

    protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
        this.parseCoverageEligibilityResponseBenefitComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
        DataType used;
        DataType allowed;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json) throws IOException, FHIRFormatError {
        CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
        this.parseCoverageEligibilityResponseErrorsComponentProperties(json, res);
        return res;
    }

    protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
    }

    protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDetectedIssueProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
        int i;
        DataType identified;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ObservationStatus.NULL, new Enumerations.ObservationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(this.getJObject(json, "_severity"), res.getSeverityElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if ((identified = this.parseType("identified", json)) != null) {
            res.setIdentified(identified);
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
        if (json.has("implicated")) {
            JsonArray array = json.getAsJsonArray("implicated");
            for (i = 0; i < array.size(); ++i) {
                res.getImplicated().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("evidence")) {
            JsonArray array = json.getAsJsonArray("evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseDetectedIssueEvidenceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseString(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(this.getJObject(json, "_detail"), res.getDetailElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
        if (json.has("mitigation")) {
            JsonArray array = json.getAsJsonArray("mitigation");
            for (i = 0; i < array.size(); ++i) {
                res.getMitigation().add(this.parseDetectedIssueMitigationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
        this.parseDetectedIssueEvidenceComponentProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueEvidenceComponentProperties(JsonObject json, DetectedIssue.DetectedIssueEvidenceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseDetectedIssueMitigationComponentProperties(json, res);
        return res;
    }

    protected void parseDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(this.getJObject(json, "action")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDeviceProperties(json, res);
        return res;
    }

    protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("displayName")) {
            res.setDisplayNameElement(this.parseString(json.get("displayName").getAsString()));
        }
        if (json.has("_displayName")) {
            this.parseElementProperties(this.getJObject(json, "_displayName"), res.getDisplayNameElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(this.getJObject(json, "definition")));
        }
        if (json.has("udiCarrier")) {
            array = json.getAsJsonArray("udiCarrier");
            for (i = 0; i < array.size(); ++i) {
                res.getUdiCarrier().add(this.parseDeviceUdiCarrierComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            array = json.getAsJsonArray("statusReason");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("distinctIdentifier")) {
            res.setDistinctIdentifierElement(this.parseString(json.get("distinctIdentifier").getAsString()));
        }
        if (json.has("_distinctIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_distinctIdentifier"), res.getDistinctIdentifierElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturerElement(this.parseString(json.get("manufacturer").getAsString()));
        }
        if (json.has("_manufacturer")) {
            this.parseElementProperties(this.getJObject(json, "_manufacturer"), res.getManufacturerElement());
        }
        if (json.has("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(json.get("manufactureDate").getAsString()));
        }
        if (json.has("_manufactureDate")) {
            this.parseElementProperties(this.getJObject(json, "_manufactureDate"), res.getManufactureDateElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(this.getJObject(json, "_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(this.getJObject(json, "_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("serialNumber")) {
            res.setSerialNumberElement(this.parseString(json.get("serialNumber").getAsString()));
        }
        if (json.has("_serialNumber")) {
            this.parseElementProperties(this.getJObject(json, "_serialNumber"), res.getSerialNumberElement());
        }
        if (json.has("deviceName")) {
            array = json.getAsJsonArray("deviceName");
            for (i = 0; i < array.size(); ++i) {
                res.getDeviceName().add(this.parseDeviceDeviceNameComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modelNumber")) {
            res.setModelNumberElement(this.parseString(json.get("modelNumber").getAsString()));
        }
        if (json.has("_modelNumber")) {
            this.parseElementProperties(this.getJObject(json, "_modelNumber"), res.getModelNumberElement());
        }
        if (json.has("partNumber")) {
            res.setPartNumberElement(this.parseString(json.get("partNumber").getAsString()));
        }
        if (json.has("_partNumber")) {
            this.parseElementProperties(this.getJObject(json, "_partNumber"), res.getPartNumberElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialization")) {
            array = json.getAsJsonArray("specialization");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialization().add(this.parseDeviceSpecializationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            array = json.getAsJsonArray("version");
            for (i = 0; i < array.size(); ++i) {
                res.getVersion().add(this.parseDeviceVersionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseDevicePropertyComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatus(this.parseDeviceOperationalStatusComponent(this.getJObject(json, "operationalStatus")));
        }
        if (json.has("associationStatus")) {
            res.setAssociationStatus(this.parseDeviceAssociationStatusComponent(this.getJObject(json, "associationStatus")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("safety")) {
            array = json.getAsJsonArray("safety");
            for (i = 0; i < array.size(); ++i) {
                res.getSafety().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(this.getJObject(json, "parent")));
        }
    }

    protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
        this.parseDeviceUdiCarrierComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceUdiCarrierComponentProperties(JsonObject json, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
        }
        if (json.has("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(json.get("carrierAIDC").getAsString()));
        }
        if (json.has("_carrierAIDC")) {
            this.parseElementProperties(this.getJObject(json, "_carrierAIDC"), res.getCarrierAIDCElement());
        }
        if (json.has("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(json.get("carrierHRF").getAsString()));
        }
        if (json.has("_carrierHRF")) {
            this.parseElementProperties(this.getJObject(json, "_carrierHRF"), res.getCarrierHRFElement());
        }
        if (json.has("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        }
        if (json.has("_entryType")) {
            this.parseElementProperties(this.getJObject(json, "_entryType"), res.getEntryTypeElement());
        }
    }

    protected Device.DeviceDeviceNameComponent parseDeviceDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
        this.parseDeviceDeviceNameComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDeviceNameComponentProperties(JsonObject json, Device.DeviceDeviceNameComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected Device.DeviceSpecializationComponent parseDeviceSpecializationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
        this.parseDeviceSpecializationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceSpecializationComponentProperties(JsonObject json, Device.DeviceSpecializationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("systemType")) {
            res.setSystemType(this.parseCodeableConcept(this.getJObject(json, "systemType")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
    }

    protected Device.DeviceVersionComponent parseDeviceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
        this.parseDeviceVersionComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceVersionComponentProperties(JsonObject json, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("component")) {
            res.setComponent(this.parseIdentifier(this.getJObject(json, "component")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected Device.DevicePropertyComponent parseDevicePropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
        this.parseDevicePropertyComponentProperties(json, res);
        return res;
    }

    protected void parseDevicePropertyComponentProperties(JsonObject json, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("valueQuantity")) {
            array = json.getAsJsonArray("valueQuantity");
            for (i = 0; i < array.size(); ++i) {
                res.getValueQuantity().add(this.parseQuantity(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueCode")) {
            array = json.getAsJsonArray("valueCode");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Device.DeviceOperationalStatusComponent parseDeviceOperationalStatusComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceOperationalStatusComponent res = new Device.DeviceOperationalStatusComponent();
        this.parseDeviceOperationalStatusComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceOperationalStatusComponentProperties(JsonObject json, Device.DeviceOperationalStatusComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("value")) {
            res.setValue(this.parseCodeableConcept(this.getJObject(json, "value")));
        }
        if (json.has("reason")) {
            JsonArray array = json.getAsJsonArray("reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Device.DeviceAssociationStatusComponent parseDeviceAssociationStatusComponent(JsonObject json) throws IOException, FHIRFormatError {
        Device.DeviceAssociationStatusComponent res = new Device.DeviceAssociationStatusComponent();
        this.parseDeviceAssociationStatusComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceAssociationStatusComponentProperties(JsonObject json, Device.DeviceAssociationStatusComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("value")) {
            res.setValue(this.parseCodeableConcept(this.getJObject(json, "value")));
        }
        if (json.has("reason")) {
            JsonArray array = json.getAsJsonArray("reason");
            for (int i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition res = new DeviceDefinition();
        this.parseDeviceDefinitionProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType manufacturer;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("udiDeviceIdentifier")) {
            array = json.getAsJsonArray("udiDeviceIdentifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionUdiDeviceIdentifierComponent(array.get(i2).getAsJsonObject()));
            }
        }
        if ((manufacturer = this.parseType("manufacturer", json)) != null) {
            res.setManufacturer(manufacturer);
        }
        if (json.has("deviceName")) {
            JsonArray array2 = json.getAsJsonArray("deviceName");
            for (i = 0; i < array2.size(); ++i) {
                res.getDeviceName().add(this.parseDeviceDefinitionDeviceNameComponent(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modelNumber")) {
            res.setModelNumberElement(this.parseString(json.get("modelNumber").getAsString()));
        }
        if (json.has("_modelNumber")) {
            this.parseElementProperties(this.getJObject(json, "_modelNumber"), res.getModelNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("specialization")) {
            JsonArray array3 = json.getAsJsonArray("specialization");
            for (i = 0; i < array3.size(); ++i) {
                res.getSpecialization().add(this.parseDeviceDefinitionSpecializationComponent(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            JsonArray array4 = json.getAsJsonArray("version");
            for (i = 0; i < array4.size(); ++i) {
                if (array4.get(i).isJsonNull()) {
                    res.getVersion().add(new StringType());
                    continue;
                }
                res.getVersion().add(this.parseString(array4.get(i).getAsString()));
            }
        }
        if (json.has("_version")) {
            JsonArray array5 = json.getAsJsonArray("_version");
            for (i = 0; i < array5.size(); ++i) {
                if (i == res.getVersion().size()) {
                    res.getVersion().add(this.parseString(null));
                }
                if (!(array5.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array5.get(i).getAsJsonObject(), res.getVersion().get(i));
            }
        }
        if (json.has("safety")) {
            JsonArray array6 = json.getAsJsonArray("safety");
            for (i = 0; i < array6.size(); ++i) {
                res.getSafety().add(this.parseCodeableConcept(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("shelfLifeStorage")) {
            JsonArray array7 = json.getAsJsonArray("shelfLifeStorage");
            for (i = 0; i < array7.size(); ++i) {
                res.getShelfLifeStorage().add(this.parseProductShelfLife(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("physicalCharacteristics")) {
            res.setPhysicalCharacteristics(this.parseProdCharacteristic(this.getJObject(json, "physicalCharacteristics")));
        }
        if (json.has("languageCode")) {
            JsonArray array8 = json.getAsJsonArray("languageCode");
            for (i = 0; i < array8.size(); ++i) {
                res.getLanguageCode().add(this.parseCodeableConcept(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("capability")) {
            JsonArray array9 = json.getAsJsonArray("capability");
            for (i = 0; i < array9.size(); ++i) {
                res.getCapability().add(this.parseDeviceDefinitionCapabilityComponent(array9.get(i).getAsJsonObject()));
            }
        }
        if (json.has("property")) {
            JsonArray array10 = json.getAsJsonArray("property");
            for (i = 0; i < array10.size(); ++i) {
                res.getProperty().add(this.parseDeviceDefinitionPropertyComponent(array10.get(i).getAsJsonObject()));
            }
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(this.getJObject(json, "owner")));
        }
        if (json.has("contact")) {
            JsonArray array11 = json.getAsJsonArray("contact");
            for (i = 0; i < array11.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array11.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onlineInformation")) {
            res.setOnlineInformationElement(this.parseUri(json.get("onlineInformation").getAsString()));
        }
        if (json.has("_onlineInformation")) {
            this.parseElementProperties(this.getJObject(json, "_onlineInformation"), res.getOnlineInformationElement());
        }
        if (json.has("note")) {
            JsonArray array12 = json.getAsJsonArray("note");
            for (i = 0; i < array12.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array12.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("parentDevice")) {
            res.setParentDevice(this.parseReference(this.getJObject(json, "parentDevice")));
        }
        if (json.has("material")) {
            JsonArray array13 = json.getAsJsonArray("material");
            for (i = 0; i < array13.size(); ++i) {
                res.getMaterial().add(this.parseDeviceDefinitionMaterialComponent(array13.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        this.parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(json.get("deviceIdentifier").getAsString()));
        }
        if (json.has("_deviceIdentifier")) {
            this.parseElementProperties(this.getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
        }
        if (json.has("issuer")) {
            res.setIssuerElement(this.parseUri(json.get("issuer").getAsString()));
        }
        if (json.has("_issuer")) {
            this.parseElementProperties(this.getJObject(json, "_issuer"), res.getIssuerElement());
        }
        if (json.has("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(json.get("jurisdiction").getAsString()));
        }
        if (json.has("_jurisdiction")) {
            this.parseElementProperties(this.getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        this.parseDeviceDefinitionDeviceNameComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionSpecializationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
        this.parseDeviceDefinitionSpecializationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionSpecializationComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("systemType")) {
            res.setSystemTypeElement(this.parseString(json.get("systemType").getAsString()));
        }
        if (json.has("_systemType")) {
            this.parseElementProperties(this.getJObject(json, "_systemType"), res.getSystemTypeElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
    }

    protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionCapabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
        this.parseDeviceDefinitionCapabilityComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionCapabilityComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("description")) {
            JsonArray array = json.getAsJsonArray("description");
            for (int i = 0; i < array.size(); ++i) {
                res.getDescription().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        this.parseDeviceDefinitionPropertyComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("valueQuantity")) {
            array = json.getAsJsonArray("valueQuantity");
            for (i = 0; i < array.size(); ++i) {
                res.getValueQuantity().add(this.parseQuantity(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueCode")) {
            array = json.getAsJsonArray("valueCode");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        this.parseDeviceDefinitionMaterialComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(this.getJObject(json, "substance")));
        }
        if (json.has("alternate")) {
            res.setAlternateElement(this.parseBoolean(json.get("alternate").getAsBoolean()));
        }
        if (json.has("_alternate")) {
            this.parseElementProperties(this.getJObject(json, "_alternate"), res.getAlternateElement());
        }
        if (json.has("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
        }
        if (json.has("_allergenicIndicator")) {
            this.parseElementProperties(this.getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
        }
    }

    protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDeviceMetricProperties(json, res);
        return res;
    }

    protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(this.getJObject(json, "source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(this.getJObject(json, "parent")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        }
        if (json.has("_operationalStatus")) {
            this.parseElementProperties(this.getJObject(json, "_operationalStatus"), res.getOperationalStatusElement());
        }
        if (json.has("color")) {
            res.setColorElement(this.parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(this.getJObject(json, "_color"), res.getColorElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(this.getJObject(json, "_category"), res.getCategoryElement());
        }
        if (json.has("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(this.getJObject(json, "measurementPeriod")));
        }
        if (json.has("calibration")) {
            array = json.getAsJsonArray("calibration");
            for (i = 0; i < array.size(); ++i) {
                res.getCalibration().add(this.parseDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseDeviceMetricCalibrationComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(this.getJObject(json, "_state"), res.getStateElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseInstant(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
    }

    protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseDeviceRequestProperties(json, res);
        return res;
    }

    protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
        int i;
        DataType occurrence;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = json.getAsJsonArray("instantiatesCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = json.getAsJsonArray("_instantiatesCanonical");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getInstantiatesCanonical().get(i2));
            }
        }
        if (json.has("instantiatesUri")) {
            array = json.getAsJsonArray("instantiatesUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (array.get(i2).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = json.getAsJsonArray("_instantiatesUri");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getInstantiatesUri().get(i2));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("priorRequest")) {
            array = json.getAsJsonArray("priorRequest");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getPriorRequest().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(this.getJObject(json, "groupIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("intent")) {
            res.setIntentElement(this.parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        }
        if (json.has("_intent")) {
            this.parseElementProperties(this.getJObject(json, "_intent"), res.getIntentElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(this.getJObject(json, "_priority"), res.getPriorityElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableReference(this.getJObject(json, "code")));
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getParameter().add(this.parseDeviceRequestParameterComponent(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(json.get("authoredOn").getAsString()));
        }
        if (json.has("_authoredOn")) {
            this.parseElementProperties(this.getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(this.getJObject(json, "requester")));
        }
        if (json.has("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(this.getJObject(json, "performerType")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("reason")) {
            JsonArray array2 = json.getAsJsonArray("reason");
            for (i = 0; i < array2.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("insurance")) {
            JsonArray array3 = json.getAsJsonArray("insurance");
            for (i = 0; i < array3.size(); ++i) {
                res.getInsurance().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            JsonArray array4 = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array4.size(); ++i) {
                res.getSupportingInfo().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array5 = json.getAsJsonArray("note");
            for (i = 0; i < array5.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relevantHistory")) {
            JsonArray array6 = json.getAsJsonArray("relevantHistory");
            for (i = 0; i < array6.size(); ++i) {
                res.getRelevantHistory().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
    }

    protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
        this.parseDeviceRequestParameterComponentProperties(json, res);
        return res;
    }

    protected void parseDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDeviceUseStatementProperties(json, res);
        return res;
    }

    protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
        int i;
        DataType timing;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("derivedFrom")) {
            array = json.getAsJsonArray("derivedFrom");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDerivedFrom().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(this.getJObject(json, "context")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(json.get("dateAsserted").getAsString()));
        }
        if (json.has("_dateAsserted")) {
            this.parseElementProperties(this.getJObject(json, "_dateAsserted"), res.getDateAssertedElement());
        }
        if (json.has("usageStatus")) {
            res.setUsageStatus(this.parseCodeableConcept(this.getJObject(json, "usageStatus")));
        }
        if (json.has("usageReason")) {
            JsonArray array2 = json.getAsJsonArray("usageReason");
            for (i = 0; i < array2.size(); ++i) {
                res.getUsageReason().add(this.parseCodeableConcept(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("informationSource")) {
            res.setInformationSource(this.parseReference(this.getJObject(json, "informationSource")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseCodeableReference(this.getJObject(json, "device")));
        }
        if (json.has("reason")) {
            JsonArray array3 = json.getAsJsonArray("reason");
            for (i = 0; i < array3.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableReference(this.getJObject(json, "bodySite")));
        }
        if (json.has("note")) {
            JsonArray array4 = json.getAsJsonArray("note");
            for (i = 0; i < array4.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array4.get(i).getAsJsonObject()));
            }
        }
    }

    protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDiagnosticReportProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
        int i;
        DataType effective;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(this.getJObject(json, "_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (i = 0; i < array2.size(); ++i) {
                res.getPerformer().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("resultsInterpreter")) {
            JsonArray array3 = json.getAsJsonArray("resultsInterpreter");
            for (i = 0; i < array3.size(); ++i) {
                res.getResultsInterpreter().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            JsonArray array4 = json.getAsJsonArray("specimen");
            for (i = 0; i < array4.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("result")) {
            JsonArray array5 = json.getAsJsonArray("result");
            for (i = 0; i < array5.size(); ++i) {
                res.getResult().add(this.parseReference(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("imagingStudy")) {
            JsonArray array6 = json.getAsJsonArray("imagingStudy");
            for (i = 0; i < array6.size(); ++i) {
                res.getImagingStudy().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("media")) {
            JsonArray array7 = json.getAsJsonArray("media");
            for (i = 0; i < array7.size(); ++i) {
                res.getMedia().add(this.parseDiagnosticReportMediaComponent(array7.get(i).getAsJsonObject()));
            }
        }
        if (json.has("conclusion")) {
            res.setConclusionElement(this.parseString(json.get("conclusion").getAsString()));
        }
        if (json.has("_conclusion")) {
            this.parseElementProperties(this.getJObject(json, "_conclusion"), res.getConclusionElement());
        }
        if (json.has("conclusionCode")) {
            JsonArray array8 = json.getAsJsonArray("conclusionCode");
            for (i = 0; i < array8.size(); ++i) {
                res.getConclusionCode().add(this.parseCodeableConcept(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("presentedForm")) {
            JsonArray array9 = json.getAsJsonArray("presentedForm");
            for (i = 0; i < array9.size(); ++i) {
                res.getPresentedForm().add(this.parseAttachment(array9.get(i).getAsJsonObject()));
            }
        }
    }

    protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(JsonObject json) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
        this.parseDiagnosticReportMediaComponentProperties(json, res);
        return res;
    }

    protected void parseDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("link")) {
            res.setLink(this.parseReference(this.getJObject(json, "link")));
        }
    }

    protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDocumentManifestProperties(json, res);
        return res;
    }

    protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(this.getJObject(json, "masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentManifestRelatedComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestRelatedComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseDocumentManifestRelatedComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(this.getJObject(json, "ref")));
        }
    }

    protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDocumentReferenceProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(json.get("docStatus").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        }
        if (json.has("_docStatus")) {
            this.parseElementProperties(this.getJObject(json, "_docStatus"), res.getDocStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            array = json.getAsJsonArray("encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(this.getJObject(json, "facilityType")));
        }
        if (json.has("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(this.getJObject(json, "practiceSetting")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseInstant(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("attester")) {
            array = json.getAsJsonArray("attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseDocumentReferenceAttesterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(this.getJObject(json, "custodian")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentReferenceContentComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(this.getJObject(json, "sourcePatientInfo")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected DocumentReference.DocumentReferenceAttesterComponent parseDocumentReferenceAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceAttesterComponent res = new DocumentReference.DocumentReferenceAttesterComponent();
        this.parseDocumentReferenceAttesterComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceAttesterComponentProperties(JsonObject json, DocumentReference.DocumentReferenceAttesterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), DocumentReference.DocumentAttestationMode.NULL, new DocumentReference.DocumentAttestationModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(this.getJObject(json, "_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseDocumentReferenceRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(this.getJObject(json, "target")));
        }
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(JsonObject json) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseDocumentReferenceContentComponentProperties(json, res);
        return res;
    }

    protected void parseDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("attachment")) {
            res.setAttachment(this.parseAttachment(this.getJObject(json, "attachment")));
        }
        if (json.has("format")) {
            res.setFormat(this.parseCoding(this.getJObject(json, "format")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
    }

    protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseEncounterProperties(json, res);
        return res;
    }

    protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("class")) {
            res.setClass_(this.parseCoding(this.getJObject(json, "class")));
        }
        if (json.has("classHistory")) {
            array = json.getAsJsonArray("classHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getClassHistory().add(this.parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceType")) {
            res.setServiceType(this.parseCodeableConcept(this.getJObject(json, "serviceType")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("subjectStatus")) {
            res.setSubjectStatus(this.parseCodeableConcept(this.getJObject(json, "subjectStatus")));
        }
        if (json.has("episodeOfCare")) {
            array = json.getAsJsonArray("episodeOfCare");
            for (i = 0; i < array.size(); ++i) {
                res.getEpisodeOfCare().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseEncounterParticipantComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointment")) {
            array = json.getAsJsonArray("appointment");
            for (i = 0; i < array.size(); ++i) {
                res.getAppointment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(this.getJObject(json, "length")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("account")) {
            array = json.getAsJsonArray("account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parseEncounterHospitalizationComponent(this.getJObject(json, "hospitalization")));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterLocationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceProvider")) {
            res.setServiceProvider(this.parseReference(this.getJObject(json, "serviceProvider")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(this.getJObject(json, "partOf")));
        }
    }

    protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
        this.parseEncounterStatusHistoryComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
        this.parseEncounterClassHistoryComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("class")) {
            res.setClass_(this.parseCoding(this.getJObject(json, "class")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseEncounterParticipantComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterParticipantComponentProperties(JsonObject json, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("individual")) {
            res.setIndividual(this.parseReference(this.getJObject(json, "individual")));
        }
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseEncounterDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("condition")) {
            res.setCondition(this.parseReference(this.getJObject(json, "condition")));
        }
        if (json.has("use")) {
            res.setUse(this.parseCodeableConcept(this.getJObject(json, "use")));
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(this.getJObject(json, "_rank"), res.getRankElement());
        }
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterHospitalizationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseEncounterHospitalizationComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterHospitalizationComponentProperties(JsonObject json, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(this.getJObject(json, "preAdmissionIdentifier")));
        }
        if (json.has("origin")) {
            res.setOrigin(this.parseReference(this.getJObject(json, "origin")));
        }
        if (json.has("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(this.getJObject(json, "admitSource")));
        }
        if (json.has("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(this.getJObject(json, "reAdmission")));
        }
        if (json.has("dietPreference")) {
            array = json.getAsJsonArray("dietPreference");
            for (i = 0; i < array.size(); ++i) {
                res.getDietPreference().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialCourtesy")) {
            array = json.getAsJsonArray("specialCourtesy");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialArrangement")) {
            array = json.getAsJsonArray("specialArrangement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(this.getJObject(json, "destination")));
        }
        if (json.has("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(this.getJObject(json, "dischargeDisposition")));
        }
    }

    protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseEncounterLocationComponentProperties(json, res);
        return res;
    }

    protected void parseEncounterLocationComponentProperties(JsonObject json, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(this.getJObject(json, "physicalType")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseEndpointProperties(json, res);
        return res;
    }

    protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("connectionType")) {
            res.setConnectionType(this.parseCoding(this.getJObject(json, "connectionType")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(this.getJObject(json, "managingOrganization")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("payloadType")) {
            array = json.getAsJsonArray("payloadType");
            for (i = 0; i < array.size(); ++i) {
                res.getPayloadType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payloadMimeType")) {
            array = json.getAsJsonArray("payloadMimeType");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPayloadMimeType().add(new CodeType());
                    continue;
                }
                res.getPayloadMimeType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_payloadMimeType")) {
            array = json.getAsJsonArray("_payloadMimeType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPayloadMimeType().size()) {
                    res.getPayloadMimeType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
            }
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUrl(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(this.getJObject(json, "_address"), res.getAddressElement());
        }
        if (json.has("header")) {
            array = json.getAsJsonArray("header");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getHeader().add(new StringType());
                    continue;
                }
                res.getHeader().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_header")) {
            array = json.getAsJsonArray("_header");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getHeader().size()) {
                    res.getHeader().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
            }
        }
    }

    protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseEnrollmentRequestProperties(json, res);
        return res;
    }

    protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("candidate")) {
            res.setCandidate(this.parseReference(this.getJObject(json, "candidate")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
    }

    protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseEnrollmentResponseProperties(json, res);
        return res;
    }

    protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(this.getJObject(json, "request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(this.getJObject(json, "organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(this.getJObject(json, "requestProvider")));
        }
    }

    protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseEpisodeOfCareProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(this.getJObject(json, "managingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("referralRequest")) {
            array = json.getAsJsonArray("referralRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careManager")) {
            res.setCareManager(this.parseReference(this.getJObject(json, "careManager")));
        }
        if (json.has("team")) {
            array = json.getAsJsonArray("team");
            for (i = 0; i < array.size(); ++i) {
                res.getTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("account")) {
            array = json.getAsJsonArray("account");
            for (i = 0; i < array.size(); ++i) {
                res.getAccount().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseEpisodeOfCareStatusHistoryComponentProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseEpisodeOfCareDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("condition")) {
            res.setCondition(this.parseReference(this.getJObject(json, "condition")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(this.getJObject(json, "_rank"), res.getRankElement());
        }
    }

    protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
        EventDefinition res = new EventDefinition();
        this.parseEventDefinitionProperties(json, res);
        return res;
    }

    protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
        int i;
        DataType subject;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if ((subject = this.parseType("subject", json)) != null) {
            res.setSubject(subject);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            JsonArray array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            JsonArray array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(this.getJObject(json, "_usage"), res.getUsageElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(this.getJObject(json, "effectivePeriod")));
        }
        if (json.has("topic")) {
            JsonArray array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("author")) {
            JsonArray array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("editor")) {
            JsonArray array = json.getAsJsonArray("editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reviewer")) {
            JsonArray array = json.getAsJsonArray("reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endorser")) {
            JsonArray array = json.getAsJsonArray("endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            JsonArray array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("trigger")) {
            JsonArray array = json.getAsJsonArray("trigger");
            for (i = 0; i < array.size(); ++i) {
                res.getTrigger().add(this.parseTriggerDefinition(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Evidence parseEvidence(JsonObject json) throws IOException, FHIRFormatError {
        Evidence res = new Evidence();
        this.parseEvidenceProperties(json, res);
        return res;
    }

    protected void parseEvidenceProperties(JsonObject json, Evidence res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(json.get("approvalDate").getAsString()));
        }
        if (json.has("_approvalDate")) {
            this.parseElementProperties(this.getJObject(json, "_approvalDate"), res.getApprovalDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(this.getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("editor")) {
            array = json.getAsJsonArray("editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reviewer")) {
            array = json.getAsJsonArray("reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endorser")) {
            array = json.getAsJsonArray("endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("assertion")) {
            res.setAssertionElement(this.parseMarkdown(json.get("assertion").getAsString()));
        }
        if (json.has("_assertion")) {
            this.parseElementProperties(this.getJObject(json, "_assertion"), res.getAssertionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("variableDefinition")) {
            array = json.getAsJsonArray("variableDefinition");
            for (i = 0; i < array.size(); ++i) {
                res.getVariableDefinition().add(this.parseEvidenceVariableDefinitionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("synthesisType")) {
            res.setSynthesisType(this.parseCodeableConcept(this.getJObject(json, "synthesisType")));
        }
        if (json.has("studyType")) {
            res.setStudyType(this.parseCodeableConcept(this.getJObject(json, "studyType")));
        }
        if (json.has("statistic")) {
            array = json.getAsJsonArray("statistic");
            for (i = 0; i < array.size(); ++i) {
                res.getStatistic().add(this.parseStatistic(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("distribution")) {
            array = json.getAsJsonArray("distribution");
            for (i = 0; i < array.size(); ++i) {
                res.getDistribution().add(this.parseOrderedDistribution(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("certainty")) {
            array = json.getAsJsonArray("certainty");
            for (i = 0; i < array.size(); ++i) {
                res.getCertainty().add(this.parseEvidenceCertaintyComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
        this.parseEvidenceVariableDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableDefinitionComponentProperties(JsonObject json, Evidence.EvidenceVariableDefinitionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("variableRole")) {
            res.setVariableRole(this.parseCodeableConcept(this.getJObject(json, "variableRole")));
        }
        if (json.has("observed")) {
            res.setObserved(this.parseReference(this.getJObject(json, "observed")));
        }
        if (json.has("intended")) {
            res.setIntended(this.parseReference(this.getJObject(json, "intended")));
        }
        if (json.has("directnessMatch")) {
            res.setDirectnessMatch(this.parseCodeableConcept(this.getJObject(json, "directnessMatch")));
        }
    }

    protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
        this.parseEvidenceCertaintyComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceCertaintyComponentProperties(JsonObject json, Evidence.EvidenceCertaintyComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rating")) {
            array = json.getAsJsonArray("rating");
            for (i = 0; i < array.size(); ++i) {
                res.getRating().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("certaintySubcomponent")) {
            array = json.getAsJsonArray("certaintySubcomponent");
            for (i = 0; i < array.size(); ++i) {
                res.getCertaintySubcomponent().add(this.parseEvidenceCertaintyCertaintySubcomponentComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Evidence.EvidenceCertaintyCertaintySubcomponentComponent parseEvidenceCertaintyCertaintySubcomponentComponent(JsonObject json) throws IOException, FHIRFormatError {
        Evidence.EvidenceCertaintyCertaintySubcomponentComponent res = new Evidence.EvidenceCertaintyCertaintySubcomponentComponent();
        this.parseEvidenceCertaintyCertaintySubcomponentComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceCertaintyCertaintySubcomponentComponentProperties(JsonObject json, Evidence.EvidenceCertaintyCertaintySubcomponentComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rating")) {
            array = json.getAsJsonArray("rating");
            for (i = 0; i < array.size(); ++i) {
                res.getRating().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceReport parseEvidenceReport(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport res = new EvidenceReport();
        this.parseEvidenceReportProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportProperties(JsonObject json, EvidenceReport res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedIdentifier")) {
            array = json.getAsJsonArray("relatedIdentifier");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("citeAs")) {
            res.setCiteAs(this.parseReference(this.getJObject(json, "citeAs")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseEvidenceReportSubjectComponent(this.getJObject(json, "subject")));
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("editor")) {
            array = json.getAsJsonArray("editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reviewer")) {
            array = json.getAsJsonArray("reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endorser")) {
            array = json.getAsJsonArray("endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseEvidenceReportRelatesToComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseEvidenceReportSectionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceReport.EvidenceReportSubjectComponent parseEvidenceReportSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectComponent res = new EvidenceReport.EvidenceReportSubjectComponent();
        this.parseEvidenceReportSubjectComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSubjectComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseEvidenceReportSubjectCharacteristicComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceReport.EvidenceReportSubjectCharacteristicComponent parseEvidenceReportSubjectCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectCharacteristicComponent res = new EvidenceReport.EvidenceReportSubjectCharacteristicComponent();
        this.parseEvidenceReportSubjectCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSubjectCharacteristicComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(this.getJObject(json, "_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected EvidenceReport.EvidenceReportRelatesToComponent parseEvidenceReportRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportRelatesToComponent res = new EvidenceReport.EvidenceReportRelatesToComponent();
        this.parseEvidenceReportRelatesToComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportRelatesToComponentProperties(JsonObject json, EvidenceReport.EvidenceReportRelatesToComponent res) throws IOException, FHIRFormatError {
        DataType target;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), EvidenceReport.ReportRelationshipType.NULL, new EvidenceReport.ReportRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
    }

    protected EvidenceReport.SectionComponent parseEvidenceReportSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceReport.SectionComponent res = new EvidenceReport.SectionComponent();
        this.parseEvidenceReportSectionComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceReportSectionComponentProperties(JsonObject json, EvidenceReport.SectionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("focus")) {
            res.setFocus(this.parseCodeableConcept(this.getJObject(json, "focus")));
        }
        if (json.has("focusReference")) {
            res.setFocusReference(this.parseReference(this.getJObject(json, "focusReference")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(this.getJObject(json, "text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(this.getJObject(json, "_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(this.getJObject(json, "orderedBy")));
        }
        if (json.has("entryClassifier")) {
            array = json.getAsJsonArray("entryClassifier");
            for (i = 0; i < array.size(); ++i) {
                res.getEntryClassifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("entryReference")) {
            array = json.getAsJsonArray("entryReference");
            for (i = 0; i < array.size(); ++i) {
                res.getEntryReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(this.getJObject(json, "emptyReason")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseEvidenceReportSectionComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceVariable parseEvidenceVariable(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable res = new EvidenceVariable();
        this.parseEvidenceVariableProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableProperties(JsonObject json, EvidenceVariable res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseMetadataResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("shortTitle")) {
            res.setShortTitleElement(this.parseString(json.get("shortTitle").getAsString()));
        }
        if (json.has("_shortTitle")) {
            this.parseElementProperties(this.getJObject(json, "_shortTitle"), res.getShortTitleElement());
        }
        if (json.has("subtitle")) {
            res.setSubtitleElement(this.parseString(json.get("subtitle").getAsString()));
        }
        if (json.has("_subtitle")) {
            this.parseElementProperties(this.getJObject(json, "_subtitle"), res.getSubtitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("editor")) {
            array = json.getAsJsonArray("editor");
            for (i = 0; i < array.size(); ++i) {
                res.getEditor().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reviewer")) {
            array = json.getAsJsonArray("reviewer");
            for (i = 0; i < array.size(); ++i) {
                res.getReviewer().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endorser")) {
            array = json.getAsJsonArray("endorser");
            for (i = 0; i < array.size(); ++i) {
                res.getEndorser().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedArtifact")) {
            array = json.getAsJsonArray("relatedArtifact");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedArtifact().add(this.parseRelatedArtifact(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(this.getJObject(json, "_actual"), res.getActualElement());
        }
        if (json.has("characteristicCombination")) {
            res.setCharacteristicCombinationElement(this.parseEnumeration(json.get("characteristicCombination").getAsString(), EvidenceVariable.CharacteristicCombination.NULL, new EvidenceVariable.CharacteristicCombinationEnumFactory()));
        }
        if (json.has("_characteristicCombination")) {
            this.parseElementProperties(this.getJObject(json, "_characteristicCombination"), res.getCharacteristicCombinationElement());
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseEvidenceVariableCharacteristicComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("handling")) {
            res.setHandlingElement(this.parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        }
        if (json.has("_handling")) {
            this.parseElementProperties(this.getJObject(json, "_handling"), res.getHandlingElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseEvidenceVariableCategoryComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
        this.parseEvidenceVariableCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType definition;
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if ((definition = this.parseType("definition", json)) != null) {
            res.setDefinition(definition);
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(this.getJObject(json, "method")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(this.getJObject(json, "device")));
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(this.getJObject(json, "_exclude"), res.getExcludeElement());
        }
        if (json.has("timeFromStart")) {
            res.setTimeFromStart(this.parseEvidenceVariableCharacteristicTimeFromStartComponent(this.getJObject(json, "timeFromStart")));
        }
        if (json.has("groupMeasure")) {
            res.setGroupMeasureElement(this.parseEnumeration(json.get("groupMeasure").getAsString(), EvidenceVariable.GroupMeasure.NULL, new EvidenceVariable.GroupMeasureEnumFactory()));
        }
        if (json.has("_groupMeasure")) {
            this.parseElementProperties(this.getJObject(json, "_groupMeasure"), res.getGroupMeasureElement());
        }
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent parseEvidenceVariableCharacteristicTimeFromStartComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent res = new EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent();
        this.parseEvidenceVariableCharacteristicTimeFromStartComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCharacteristicTimeFromStartComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("range")) {
            res.setRange(this.parseRange(this.getJObject(json, "range")));
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected EvidenceVariable.EvidenceVariableCategoryComponent parseEvidenceVariableCategoryComponent(JsonObject json) throws IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCategoryComponent res = new EvidenceVariable.EvidenceVariableCategoryComponent();
        this.parseEvidenceVariableCategoryComponentProperties(json, res);
        return res;
    }

    protected void parseEvidenceVariableCategoryComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCategoryComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
    }

    protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario res = new ExampleScenario();
        this.parseExampleScenarioProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("actor")) {
            array = json.getAsJsonArray("actor");
            for (i = 0; i < array.size(); ++i) {
                res.getActor().add(this.parseExampleScenarioActorComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseExampleScenarioInstanceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("process")) {
            array = json.getAsJsonArray("process");
            for (i = 0; i < array.size(); ++i) {
                res.getProcess().add(this.parseExampleScenarioProcessComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("workflow")) {
            array = json.getAsJsonArray("workflow");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getWorkflow().add(new CanonicalType());
                    continue;
                }
                res.getWorkflow().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_workflow")) {
            array = json.getAsJsonArray("_workflow");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getWorkflow().size()) {
                    res.getWorkflow().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getWorkflow().get(i));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
        this.parseExampleScenarioActorComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("actorId")) {
            res.setActorIdElement(this.parseString(json.get("actorId").getAsString()));
        }
        if (json.has("_actorId")) {
            this.parseElementProperties(this.getJObject(json, "_actorId"), res.getActorIdElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
        this.parseExampleScenarioInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("resourceId")) {
            res.setResourceIdElement(this.parseString(json.get("resourceId").getAsString()));
        }
        if (json.has("_resourceId")) {
            this.parseElementProperties(this.getJObject(json, "_resourceId"), res.getResourceIdElement());
        }
        if (json.has("resourceType")) {
            res.setResourceTypeElement(this.parseCode(json.get("resourceType").getAsString()));
        }
        if (json.has("_resourceType")) {
            this.parseElementProperties(this.getJObject(json, "_resourceType"), res.getResourceTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("version")) {
            array = json.getAsJsonArray("version");
            for (i = 0; i < array.size(); ++i) {
                res.getVersion().add(this.parseExampleScenarioInstanceVersionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("containedInstance")) {
            array = json.getAsJsonArray("containedInstance");
            for (i = 0; i < array.size(); ++i) {
                res.getContainedInstance().add(this.parseExampleScenarioInstanceContainedInstanceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        this.parseExampleScenarioInstanceVersionComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseString(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(this.getJObject(json, "_versionId"), res.getVersionIdElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        this.parseExampleScenarioInstanceContainedInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("resourceId")) {
            res.setResourceIdElement(this.parseString(json.get("resourceId").getAsString()));
        }
        if (json.has("_resourceId")) {
            this.parseElementProperties(this.getJObject(json, "_resourceId"), res.getResourceIdElement());
        }
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseString(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(this.getJObject(json, "_versionId"), res.getVersionIdElement());
        }
    }

    protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
        this.parseExampleScenarioProcessComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("preConditions")) {
            res.setPreConditionsElement(this.parseMarkdown(json.get("preConditions").getAsString()));
        }
        if (json.has("_preConditions")) {
            this.parseElementProperties(this.getJObject(json, "_preConditions"), res.getPreConditionsElement());
        }
        if (json.has("postConditions")) {
            res.setPostConditionsElement(this.parseMarkdown(json.get("postConditions").getAsString()));
        }
        if (json.has("_postConditions")) {
            this.parseElementProperties(this.getJObject(json, "_postConditions"), res.getPostConditionsElement());
        }
        if (json.has("step")) {
            JsonArray array = json.getAsJsonArray("step");
            for (int i = 0; i < array.size(); ++i) {
                res.getStep().add(this.parseExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
        this.parseExampleScenarioProcessStepComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("process")) {
            array = json.getAsJsonArray("process");
            for (i = 0; i < array.size(); ++i) {
                res.getProcess().add(this.parseExampleScenarioProcessComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("pause")) {
            res.setPauseElement(this.parseBoolean(json.get("pause").getAsBoolean()));
        }
        if (json.has("_pause")) {
            this.parseElementProperties(this.getJObject(json, "_pause"), res.getPauseElement());
        }
        if (json.has("operation")) {
            res.setOperation(this.parseExampleScenarioProcessStepOperationComponent(this.getJObject(json, "operation")));
        }
        if (json.has("alternative")) {
            array = json.getAsJsonArray("alternative");
            for (i = 0; i < array.size(); ++i) {
                res.getAlternative().add(this.parseExampleScenarioProcessStepAlternativeComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        this.parseExampleScenarioProcessStepOperationComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parseString(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("initiator")) {
            res.setInitiatorElement(this.parseString(json.get("initiator").getAsString()));
        }
        if (json.has("_initiator")) {
            this.parseElementProperties(this.getJObject(json, "_initiator"), res.getInitiatorElement());
        }
        if (json.has("receiver")) {
            res.setReceiverElement(this.parseString(json.get("receiver").getAsString()));
        }
        if (json.has("_receiver")) {
            this.parseElementProperties(this.getJObject(json, "_receiver"), res.getReceiverElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("initiatorActive")) {
            res.setInitiatorActiveElement(this.parseBoolean(json.get("initiatorActive").getAsBoolean()));
        }
        if (json.has("_initiatorActive")) {
            this.parseElementProperties(this.getJObject(json, "_initiatorActive"), res.getInitiatorActiveElement());
        }
        if (json.has("receiverActive")) {
            res.setReceiverActiveElement(this.parseBoolean(json.get("receiverActive").getAsBoolean()));
        }
        if (json.has("_receiverActive")) {
            this.parseElementProperties(this.getJObject(json, "_receiverActive"), res.getReceiverActiveElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseExampleScenarioInstanceContainedInstanceComponent(this.getJObject(json, "request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseExampleScenarioInstanceContainedInstanceComponent(this.getJObject(json, "response")));
        }
    }

    protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        this.parseExampleScenarioProcessStepAlternativeComponentProperties(json, res);
        return res;
    }

    protected void parseExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("step")) {
            JsonArray array = json.getAsJsonArray("step");
            for (int i = 0; i < array.size(); ++i) {
                res.getStep().add(this.parseExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseExplanationOfBenefitProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(this.getJObject(json, "subType")));
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(this.getJObject(json, "billablePeriod")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(this.getJObject(json, "_created"), res.getCreatedElement());
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(this.getJObject(json, "enterer")));
        }
        if (json.has("insurer")) {
            res.setInsurer(this.parseReference(this.getJObject(json, "insurer")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("fundsReserveRequested")) {
            res.setFundsReserveRequested(this.parseCodeableConcept(this.getJObject(json, "fundsReserveRequested")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(this.getJObject(json, "fundsReserve")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(this.getJObject(json, "prescription")));
        }
        if (json.has("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(this.getJObject(json, "originalPrescription")));
        }
        if (json.has("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(this.getJObject(json, "payee")));
        }
        if (json.has("referral")) {
            res.setReferral(this.parseReference(this.getJObject(json, "referral")));
        }
        if (json.has("facility")) {
            res.setFacility(this.parseReference(this.getJObject(json, "facility")));
        }
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(this.getJObject(json, "claimResponse")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(this.getJObject(json, "_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(this.getJObject(json, "_disposition"), res.getDispositionElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("preAuthRefPeriod")) {
            array = json.getAsJsonArray("preAuthRefPeriod");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRefPeriod().add(this.parsePeriod(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careTeam")) {
            array = json.getAsJsonArray("careTeam");
            for (i = 0; i < array.size(); ++i) {
                res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInfo")) {
            array = json.getAsJsonArray("supportingInfo");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInfo().add(this.parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(json.get("precedence").getAsString()));
        }
        if (json.has("_precedence")) {
            this.parseElementProperties(this.getJObject(json, "_precedence"), res.getPrecedenceElement());
        }
        if (json.has("insurance")) {
            array = json.getAsJsonArray("insurance");
            for (i = 0; i < array.size(); ++i) {
                res.getInsurance().add(this.parseExplanationOfBenefitInsuranceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(this.getJObject(json, "accident")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("total")) {
            array = json.getAsJsonArray("total");
            for (i = 0; i < array.size(); ++i) {
                res.getTotal().add(this.parseExplanationOfBenefitTotalComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(this.getJObject(json, "payment")));
        }
        if (json.has("formCode")) {
            res.setFormCode(this.parseCodeableConcept(this.getJObject(json, "formCode")));
        }
        if (json.has("form")) {
            res.setForm(this.parseAttachment(this.getJObject(json, "form")));
        }
        if (json.has("processNote")) {
            array = json.getAsJsonArray("processNote");
            for (i = 0; i < array.size(); ++i) {
                res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(this.getJObject(json, "benefitPeriod")));
        }
        if (json.has("benefitBalance")) {
            array = json.getAsJsonArray("benefitBalance");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseExplanationOfBenefitRelatedClaimComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("claim")) {
            res.setClaim(this.parseReference(this.getJObject(json, "claim")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(this.getJObject(json, "reference")));
        }
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseExplanationOfBenefitPayeeComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(this.getJObject(json, "party")));
        }
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseExplanationOfBenefitCareTeamComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(this.getJObject(json, "provider")));
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseBoolean(json.get("responsible").getAsBoolean()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(this.getJObject(json, "_responsible"), res.getResponsibleElement());
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("qualification")) {
            res.setQualification(this.parseCodeableConcept(this.getJObject(json, "qualification")));
        }
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseExplanationOfBenefitSupportingInformationComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
        DataType value;
        DataType timing;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(this.getJObject(json, "reason")));
        }
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseExplanationOfBenefitDiagnosisComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
        DataType diagnosis;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if ((diagnosis = this.parseType("diagnosis", json)) != null) {
            res.setDiagnosis(diagnosis);
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(this.getJObject(json, "onAdmission")));
        }
        if (json.has("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(this.getJObject(json, "packageCode")));
        }
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseExplanationOfBenefitProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
        DataType procedure;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        if (json.has("udi")) {
            JsonArray array = json.getAsJsonArray("udi");
            for (int i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseExplanationOfBenefitInsuranceComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(this.getJObject(json, "_focal"), res.getFocalElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(this.getJObject(json, "coverage")));
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getPreAuthRef().add(new StringType());
                    continue;
                }
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseExplanationOfBenefitAccidentComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
        DataType location;
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseExplanationOfBenefitItemComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("careTeamSequence")) {
            array2 = json.getAsJsonArray("careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getCareTeamSequence().add(new PositiveIntType());
                    continue;
                }
                res.getCareTeamSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_careTeamSequence")) {
            array2 = json.getAsJsonArray("_careTeamSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getCareTeamSequence().size()) {
                    res.getCareTeamSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getCareTeamSequence().get(i2));
            }
        }
        if (json.has("diagnosisSequence")) {
            array2 = json.getAsJsonArray("diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDiagnosisSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDiagnosisSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisSequence")) {
            array2 = json.getAsJsonArray("_diagnosisSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDiagnosisSequence().size()) {
                    res.getDiagnosisSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDiagnosisSequence().get(i2));
            }
        }
        if (json.has("procedureSequence")) {
            array2 = json.getAsJsonArray("procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getProcedureSequence().add(new PositiveIntType());
                    continue;
                }
                res.getProcedureSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_procedureSequence")) {
            array2 = json.getAsJsonArray("_procedureSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getProcedureSequence().size()) {
                    res.getProcedureSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getProcedureSequence().get(i2));
            }
        }
        if (json.has("informationSequence")) {
            array2 = json.getAsJsonArray("informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInformationSequence().add(new PositiveIntType());
                    continue;
                }
                res.getInformationSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_informationSequence")) {
            array2 = json.getAsJsonArray("_informationSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInformationSequence().size()) {
                    res.getInformationSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInformationSequence().get(i2));
            }
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("encounter")) {
            array = json.getAsJsonArray("encounter");
            for (i = 0; i < array.size(); ++i) {
                res.getEncounter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseExplanationOfBenefitAdjudicationComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(this.getJObject(json, "reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseExplanationOfBenefitDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseExplanationOfBenefitSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(this.getJObject(json, "_sequence"), res.getSequenceElement());
        }
        if (json.has("revenue")) {
            res.setRevenue(this.parseCodeableConcept(this.getJObject(json, "revenue")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseExplanationOfBenefitAddedItemComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType location;
        DataType serviced;
        int i2;
        JsonArray array2;
        this.parseBackboneElementProperties(json, res);
        if (json.has("itemSequence")) {
            array2 = json.getAsJsonArray("itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getItemSequence().add(new PositiveIntType());
                    continue;
                }
                res.getItemSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_itemSequence")) {
            array2 = json.getAsJsonArray("_itemSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getItemSequence().size()) {
                    res.getItemSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getItemSequence().get(i2));
            }
        }
        if (json.has("detailSequence")) {
            array2 = json.getAsJsonArray("detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_detailSequence")) {
            array2 = json.getAsJsonArray("_detailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getDetailSequence().size()) {
                    res.getDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getDetailSequence().get(i2));
            }
        }
        if (json.has("subDetailSequence")) {
            array2 = json.getAsJsonArray("subDetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getSubDetailSequence().add(new PositiveIntType());
                    continue;
                }
                res.getSubDetailSequence().add(this.parsePositiveInt(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_subDetailSequence")) {
            array2 = json.getAsJsonArray("_subDetailSequence");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getSubDetailSequence().size()) {
                    res.getSubDetailSequence().add(this.parsePositiveInt(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getSubDetailSequence().get(i2));
            }
        }
        if (json.has("provider")) {
            array2 = json.getAsJsonArray("provider");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProvider().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array2 = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getModifier().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array2 = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProgramCode().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if ((location = this.parseType("location", json)) != null) {
            res.setLocation(location);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(this.getJObject(json, "bodySite")));
        }
        if (json.has("subSite")) {
            array = json.getAsJsonArray("subSite");
            for (i = 0; i < array.size(); ++i) {
                res.getSubSite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitAddedItemDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
        this.parseExplanationOfBenefitAddedItemDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitAddedItemDetailSubDetailComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        this.parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(this.getJObject(json, "productOrService")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(this.getJObject(json, "quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(this.getJObject(json, "unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(this.getJObject(json, "_factor"), res.getFactorElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(this.getJObject(json, "net")));
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getNoteNumber().add(new PositiveIntType());
                    continue;
                }
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
        this.parseExplanationOfBenefitTotalComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseExplanationOfBenefitPaymentComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if (json.has("adjustment")) {
            res.setAdjustment(this.parseMoney(this.getJObject(json, "adjustment")));
        }
        if (json.has("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(this.getJObject(json, "adjustmentReason")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(this.getJObject(json, "amount")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseExplanationOfBenefitNoteComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(this.getJObject(json, "_text"), res.getTextElement());
        }
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(this.getJObject(json, "language")));
        }
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseExplanationOfBenefitBenefitBalanceComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(this.getJObject(json, "category")));
        }
        if (json.has("excluded")) {
            res.setExcludedElement(this.parseBoolean(json.get("excluded").getAsBoolean()));
        }
        if (json.has("_excluded")) {
            this.parseElementProperties(this.getJObject(json, "_excluded"), res.getExcludedElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCodeableConcept(this.getJObject(json, "network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(this.getJObject(json, "unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCodeableConcept(this.getJObject(json, "term")));
        }
        if (json.has("financial")) {
            JsonArray array = json.getAsJsonArray("financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseExplanationOfBenefitBenefitComponentProperties(json, res);
        return res;
    }

    protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
        DataType used;
        DataType allowed;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(this.getJObject(json, "type")));
        }
        if ((allowed = this.parseType("allowed", json)) != null) {
            res.setAllowed(allowed);
        }
        if ((used = this.parseType("used", json)) != null) {
            res.setUsed(used);
        }
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseFamilyMemberHistoryProperties(json, res);
        return res;
    }

    protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType deceased;
        DataType age;
        DataType born;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array2 = json.getAsJsonArray("instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array2 = json.getAsJsonArray("_instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInstantiatesCanonical().get(i2));
            }
        }
        if (json.has("instantiatesUri")) {
            array2 = json.getAsJsonArray("instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array2 = json.getAsJsonArray("_instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInstantiatesUri().get(i2));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(this.getJObject(json, "dataAbsentReason")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(this.getJObject(json, "relationship")));
        }
        if (json.has("sex")) {
            res.setSex(this.parseCodeableConcept(this.getJObject(json, "sex")));
        }
        if ((born = this.parseType("born", json)) != null) {
            res.setBorn(born);
        }
        if ((age = this.parseType("age", json)) != null) {
            res.setAge(age);
        }
        if (json.has("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(json.get("estimatedAge").getAsBoolean()));
        }
        if (json.has("_estimatedAge")) {
            this.parseElementProperties(this.getJObject(json, "_estimatedAge"), res.getEstimatedAgeElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseFamilyMemberHistoryProcedureComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryConditionComponent(JsonObject json) throws IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseFamilyMemberHistoryConditionComponentProperties(json, res);
        return res;
    }

    protected void parseFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
        DataType onset;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(this.getJObject(json, "outcome")));
        }
        if (json.has("contributedToDeath")) {
            res.setContributedToDeathElement(this.parseBoolean(json.get("contributedToDeath").getAsBoolean()));
        }
        if (json.has("_contributedToDeath")) {
            this.parseElementProperties(this.getJObject(json, "_contributedToDeath"), res.getContributedToDeathElement());
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected FamilyMemberHistory.FamilyMemberHistoryProcedureComponent parseFamilyMemberHistoryProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res = new FamilyMemberHistory.FamilyMemberHistoryProcedureComponent();
        this.parseFamilyMemberHistoryProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseFamilyMemberHistoryProcedureComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res) throws IOException, FHIRFormatError {
        DataType performed;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(this.getJObject(json, "outcome")));
        }
        if (json.has("contributedToDeath")) {
            res.setContributedToDeathElement(this.parseBoolean(json.get("contributedToDeath").getAsBoolean()));
        }
        if (json.has("_contributedToDeath")) {
            this.parseElementProperties(this.getJObject(json, "_contributedToDeath"), res.getContributedToDeathElement());
        }
        if ((performed = this.parseType("performed", json)) != null) {
            res.setPerformed(performed);
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (int i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseFlagProperties(json, res);
        return res;
    }

    protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(this.getJObject(json, "author")));
        }
    }

    protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseGoalProperties(json, res);
        return res;
    }

    protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
        int i;
        DataType start;
        int i2;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("lifecycleStatus")) {
            res.setLifecycleStatusElement(this.parseEnumeration(json.get("lifecycleStatus").getAsString(), Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
        }
        if (json.has("_lifecycleStatus")) {
            this.parseElementProperties(this.getJObject(json, "_lifecycleStatus"), res.getLifecycleStatusElement());
        }
        if (json.has("achievementStatus")) {
            res.setAchievementStatus(this.parseCodeableConcept(this.getJObject(json, "achievementStatus")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("continuous")) {
            res.setContinuousElement(this.parseBoolean(json.get("continuous").getAsBoolean()));
        }
        if (json.has("_continuous")) {
            this.parseElementProperties(this.getJObject(json, "_continuous"), res.getContinuousElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(this.getJObject(json, "priority")));
        }
        if (json.has("description")) {
            res.setDescription(this.parseCodeableConcept(this.getJObject(json, "description")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if ((start = this.parseType("start", json)) != null) {
            res.setStart(start);
        }
        if (json.has("target")) {
            JsonArray array2 = json.getAsJsonArray("target");
            for (i = 0; i < array2.size(); ++i) {
                res.getTarget().add(this.parseGoalTargetComponent(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(this.getJObject(json, "_statusDate"), res.getStatusDateElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReasonElement(this.parseString(json.get("statusReason").getAsString()));
        }
        if (json.has("_statusReason")) {
            this.parseElementProperties(this.getJObject(json, "_statusReason"), res.getStatusReasonElement());
        }
        if (json.has("expressedBy")) {
            res.setExpressedBy(this.parseReference(this.getJObject(json, "expressedBy")));
        }
        if (json.has("addresses")) {
            JsonArray array3 = json.getAsJsonArray("addresses");
            for (i = 0; i < array3.size(); ++i) {
                res.getAddresses().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array4 = json.getAsJsonArray("note");
            for (i = 0; i < array4.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcome")) {
            JsonArray array5 = json.getAsJsonArray("outcome");
            for (i = 0; i < array5.size(); ++i) {
                res.getOutcome().add(this.parseCodeableReference(array5.get(i).getAsJsonObject()));
            }
        }
    }

    protected Goal.GoalTargetComponent parseGoalTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
        Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
        this.parseGoalTargetComponentProperties(json, res);
        return res;
    }

    protected void parseGoalTargetComponentProperties(JsonObject json, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
        DataType due;
        DataType detail;
        this.parseBackboneElementProperties(json, res);
        if (json.has("measure")) {
            res.setMeasure(this.parseCodeableConcept(this.getJObject(json, "measure")));
        }
        if ((detail = this.parseType("detail", json)) != null) {
            res.setDetail(detail);
        }
        if ((due = this.parseType("due", json)) != null) {
            res.setDue(due);
        }
    }

    protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
        GraphDefinition res = new GraphDefinition();
        this.parseGraphDefinitionProperties(json, res);
        return res;
    }

    protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseMarkdown(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(this.getJObject(json, "_purpose"), res.getPurposeElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseCode(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(this.getJObject(json, "_start"), res.getStartElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseGraphDefinitionLinkComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
        this.parseGraphDefinitionLinkComponentProperties(json, res);
        return res;
    }

    protected void parseGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(this.getJObject(json, "_path"), res.getPathElement());
        }
        if (json.has("sliceName")) {
            res.setSliceNameElement(this.parseString(json.get("sliceName").getAsString()));
        }
        if (json.has("_sliceName")) {
            this.parseElementProperties(this.getJObject(json, "_sliceName"), res.getSliceNameElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(this.getJObject(json, "_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(this.getJObject(json, "_max"), res.getMaxElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionLinkTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        this.parseGraphDefinitionLinkTargetComponentProperties(json, res);
        return res;
    }

    protected void parseGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("params")) {
            res.setParamsElement(this.parseString(json.get("params").getAsString()));
        }
        if (json.has("_params")) {
            this.parseElementProperties(this.getJObject(json, "_params"), res.getParamsElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                res.getCompartment().add(this.parseGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseGraphDefinitionLinkComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionLinkTargetCompartmentComponent(JsonObject json) throws IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        this.parseGraphDefinitionLinkTargetCompartmentComponentProperties(json, res);
        return res;
    }

    protected void parseGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(this.getJObject(json, "_use"), res.getUseElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("rule")) {
            res.setRuleElement(this.parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
        }
        if (json.has("_rule")) {
            this.parseElementProperties(this.getJObject(json, "_rule"), res.getRuleElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(this.getJObject(json, "_expression"), res.getExpressionElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
        Group res = new Group();
        this.parseGroupProperties(json, res);
        return res;
    }

    protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(this.getJObject(json, "_active"), res.getActiveElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(this.getJObject(json, "_actual"), res.getActualElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(json.get("quantity").getAsString()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(this.getJObject(json, "_quantity"), res.getQuantityElement());
        }
        if (json.has("managingEntity")) {
            res.setManagingEntity(this.parseReference(this.getJObject(json, "managingEntity")));
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseGroupCharacteristicComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("member")) {
            array = json.getAsJsonArray("member");
            for (i = 0; i < array.size(); ++i) {
                res.getMember().add(this.parseGroupMemberComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Group.GroupCharacteristicComponent parseGroupCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseGroupCharacteristicComponentProperties(json, res);
        return res;
    }

    protected void parseGroupCharacteristicComponentProperties(JsonObject json, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
        DataType value;
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(this.getJObject(json, "_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
    }

    protected Group.GroupMemberComponent parseGroupMemberComponent(JsonObject json) throws IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseGroupMemberComponentProperties(json, res);
        return res;
    }

    protected void parseGroupMemberComponentProperties(JsonObject json, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(this.getJObject(json, "entity")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(this.getJObject(json, "period")));
        }
        if (json.has("inactive")) {
            res.setInactiveElement(this.parseBoolean(json.get("inactive").getAsBoolean()));
        }
        if (json.has("_inactive")) {
            this.parseElementProperties(this.getJObject(json, "_inactive"), res.getInactiveElement());
        }
    }

    protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseGuidanceResponseProperties(json, res);
        return res;
    }

    protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
        int i;
        DataType module;
        this.parseDomainResourceProperties(json, res);
        if (json.has("requestIdentifier")) {
            res.setRequestIdentifier(this.parseIdentifier(this.getJObject(json, "requestIdentifier")));
        }
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if ((module = this.parseType("module", json)) != null) {
            res.setModule(module);
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("occurrenceDateTime")) {
            res.setOccurrenceDateTimeElement(this.parseDateTime(json.get("occurrenceDateTime").getAsString()));
        }
        if (json.has("_occurrenceDateTime")) {
            this.parseElementProperties(this.getJObject(json, "_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(this.getJObject(json, "performer")));
        }
        if (json.has("reason")) {
            JsonArray array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("evaluationMessage")) {
            JsonArray array = json.getAsJsonArray("evaluationMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getEvaluationMessage().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outputParameters")) {
            res.setOutputParameters(this.parseReference(this.getJObject(json, "outputParameters")));
        }
        if (json.has("result")) {
            res.setResult(this.parseReference(this.getJObject(json, "result")));
        }
        if (json.has("dataRequirement")) {
            JsonArray array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseHealthcareServiceProperties(json, res);
        return res;
    }

    protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(this.getJObject(json, "_active"), res.getActiveElement());
        }
        if (json.has("providedBy")) {
            res.setProvidedBy(this.parseReference(this.getJObject(json, "providedBy")));
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
        if (json.has("extraDetails")) {
            res.setExtraDetailsElement(this.parseMarkdown(json.get("extraDetails").getAsString()));
        }
        if (json.has("_extraDetails")) {
            this.parseElementProperties(this.getJObject(json, "_extraDetails"), res.getExtraDetailsElement());
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(this.getJObject(json, "photo")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("coverageArea")) {
            array = json.getAsJsonArray("coverageArea");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverageArea().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceProvisionCode")) {
            array = json.getAsJsonArray("serviceProvisionCode");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("eligibility")) {
            array = json.getAsJsonArray("eligibility");
            for (i = 0; i < array.size(); ++i) {
                res.getEligibility().add(this.parseHealthcareServiceEligibilityComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("program")) {
            array = json.getAsJsonArray("program");
            for (i = 0; i < array.size(); ++i) {
                res.getProgram().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("communication")) {
            array = json.getAsJsonArray("communication");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referralMethod")) {
            array = json.getAsJsonArray("referralMethod");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralMethod().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(json.get("appointmentRequired").getAsBoolean()));
        }
        if (json.has("_appointmentRequired")) {
            this.parseElementProperties(this.getJObject(json, "_appointmentRequired"), res.getAppointmentRequiredElement());
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parseHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parseHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(this.getJObject(json, "_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceEligibilityComponent(JsonObject json) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
        this.parseHealthcareServiceEligibilityComponentProperties(json, res);
        return res;
    }

    protected void parseHealthcareServiceEligibilityComponentProperties(JsonObject json, HealthcareService.HealthcareServiceEligibilityComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseMarkdown(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(this.getJObject(json, "_comment"), res.getCommentElement());
        }
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseHealthcareServiceAvailableTimeComponentProperties(json, res);
        return res;
    }

    protected void parseHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getDaysOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
                    continue;
                }
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(this.getJObject(json, "_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(this.getJObject(json, "_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(this.getJObject(json, "_availableEndTime"), res.getAvailableEndTimeElement());
        }
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceNotAvailableComponent(JsonObject json) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseHealthcareServiceNotAvailableComponentProperties(json, res);
        return res;
    }

    protected void parseHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(this.getJObject(json, "during")));
        }
    }

    protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseImagingStudyProperties(json, res);
        return res;
    }

    protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("modality")) {
            array = json.getAsJsonArray("modality");
            for (i = 0; i < array.size(); ++i) {
                res.getModality().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(this.getJObject(json, "subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(this.getJObject(json, "_started"), res.getStartedElement());
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referrer")) {
            res.setReferrer(this.parseReference(this.getJObject(json, "referrer")));
        }
        if (json.has("interpreter")) {
            array = json.getAsJsonArray("interpreter");
            for (i = 0; i < array.size(); ++i) {
                res.getInterpreter().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(json.get("numberOfSeries").getAsString()));
        }
        if (json.has("_numberOfSeries")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfSeries"), res.getNumberOfSeriesElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseImagingStudyProcedureComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingStudySeriesComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImagingStudy.ImagingStudyProcedureComponent parseImagingStudyProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudyProcedureComponent res = new ImagingStudy.ImagingStudyProcedureComponent();
        this.parseImagingStudyProcedureComponentProperties(json, res);
        return res;
    }

    protected void parseImagingStudyProcedureComponentProperties(JsonObject json, ImagingStudy.ImagingStudyProcedureComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudySeriesComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseImagingStudySeriesComponentProperties(json, res);
        return res;
    }

    protected void parseImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseId(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(this.getJObject(json, "_uid"), res.getUidElement());
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("modality")) {
            res.setModality(this.parseCoding(this.getJObject(json, "modality")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(this.getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(this.getJObject(json, "bodySite")));
        }
        if (json.has("laterality")) {
            res.setLaterality(this.parseCoding(this.getJObject(json, "laterality")));
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(this.getJObject(json, "_started"), res.getStartedElement());
        }
        if (json.has("performer")) {
            array = json.getAsJsonArray("performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseImagingStudySeriesPerformerComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudySeriesPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
        this.parseImagingStudySeriesPerformerComponentProperties(json, res);
        return res;
    }

    protected void parseImagingStudySeriesPerformerComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudySeriesInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseImagingStudySeriesInstanceComponentProperties(json, res);
        return res;
    }

    protected void parseImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseId(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(this.getJObject(json, "_uid"), res.getUidElement());
        }
        if (json.has("sopClass")) {
            res.setSopClass(this.parseCoding(this.getJObject(json, "sopClass")));
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(this.getJObject(json, "_number"), res.getNumberElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
    }

    protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseImmunizationProperties(json, res);
        return res;
    }

    protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataType informationSource;
        DataType occurrence;
        int i2;
        JsonArray array2;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array2 = json.getAsJsonArray("instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array2 = json.getAsJsonArray("_instantiatesCanonical");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInstantiatesCanonical().get(i2));
            }
        }
        if (json.has("instantiatesUri")) {
            array2 = json.getAsJsonArray("instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (array2.get(i2).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array2 = json.getAsJsonArray("_instantiatesUri");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getInstantiatesUri().get(i2));
            }
        }
        if (json.has("basedOn")) {
            array2 = json.getAsJsonArray("basedOn");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getBasedOn().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatusCodes.NULL, new Immunization.ImmunizationStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(this.getJObject(json, "statusReason")));
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(this.getJObject(json, "vaccineCode")));
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(this.getJObject(json, "manufacturer")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(this.getJObject(json, "_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(this.getJObject(json, "_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(this.getJObject(json, "encounter")));
        }
        if ((occurrence = this.parseType("occurrence", json)) != null) {
            res.setOccurrence(occurrence);
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseDateTime(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(this.getJObject(json, "_recorded"), res.getRecordedElement());
        }
        if (json.has("primarySource")) {
            res.setPrimarySourceElement(this.parseBoolean(json.get("primarySource").getAsBoolean()));
        }
        if (json.has("_primarySource")) {
            this.parseElementProperties(this.getJObject(json, "_primarySource"), res.getPrimarySourceElement());
        }
        if ((informationSource = this.parseType("informationSource", json)) != null) {
            res.setInformationSource(informationSource);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(this.getJObject(json, "location")));
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(this.getJObject(json, "site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(this.getJObject(json, "route")));
        }
        if (json.has("doseQuantity")) {
            res.setDoseQuantity(this.parseQuantity(this.getJObject(json, "doseQuantity")));
        }
        if (json.has("performer")) {
            array = json.getAsJsonArray("performer");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseImmunizationPerformerComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("isSubpotent")) {
            res.setIsSubpotentElement(this.parseBoolean(json.get("isSubpotent").getAsBoolean()));
        }
        if (json.has("_isSubpotent")) {
            this.parseElementProperties(this.getJObject(json, "_isSubpotent"), res.getIsSubpotentElement());
        }
        if (json.has("subpotentReason")) {
            array = json.getAsJsonArray("subpotentReason");
            for (i = 0; i < array.size(); ++i) {
                res.getSubpotentReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("education")) {
            array = json.getAsJsonArray("education");
            for (i = 0; i < array.size(); ++i) {
                res.getEducation().add(this.parseImmunizationEducationComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("programEligibility")) {
            array = json.getAsJsonArray("programEligibility");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramEligibility().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fundingSource")) {
            res.setFundingSource(this.parseCodeableConcept(this.getJObject(json, "fundingSource")));
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseImmunizationReactionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("protocolApplied")) {
            array = json.getAsJsonArray("protocolApplied");
            for (i = 0; i < array.size(); ++i) {
                res.getProtocolApplied().add(this.parseImmunizationProtocolAppliedComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Immunization.ImmunizationPerformerComponent parseImmunizationPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
        Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
        this.parseImmunizationPerformerComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationPerformerComponentProperties(JsonObject json, Immunization.ImmunizationPerformerComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("function")) {
            res.setFunction(this.parseCodeableConcept(this.getJObject(json, "function")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(this.getJObject(json, "actor")));
        }
    }

    protected Immunization.ImmunizationEducationComponent parseImmunizationEducationComponent(JsonObject json) throws IOException, FHIRFormatError {
        Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
        this.parseImmunizationEducationComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationEducationComponentProperties(JsonObject json, Immunization.ImmunizationEducationComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("documentType")) {
            res.setDocumentTypeElement(this.parseString(json.get("documentType").getAsString()));
        }
        if (json.has("_documentType")) {
            this.parseElementProperties(this.getJObject(json, "_documentType"), res.getDocumentTypeElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(this.getJObject(json, "_reference"), res.getReferenceElement());
        }
        if (json.has("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(json.get("publicationDate").getAsString()));
        }
        if (json.has("_publicationDate")) {
            this.parseElementProperties(this.getJObject(json, "_publicationDate"), res.getPublicationDateElement());
        }
        if (json.has("presentationDate")) {
            res.setPresentationDateElement(this.parseDateTime(json.get("presentationDate").getAsString()));
        }
        if (json.has("_presentationDate")) {
            this.parseElementProperties(this.getJObject(json, "_presentationDate"), res.getPresentationDateElement());
        }
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseImmunizationReactionComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationReactionComponentProperties(JsonObject json, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("detail")) {
            res.setDetail(this.parseReference(this.getJObject(json, "detail")));
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(this.getJObject(json, "_reported"), res.getReportedElement());
        }
    }

    protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationProtocolAppliedComponent(JsonObject json) throws IOException, FHIRFormatError {
        Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
        this.parseImmunizationProtocolAppliedComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationProtocolAppliedComponentProperties(JsonObject json, Immunization.ImmunizationProtocolAppliedComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(this.getJObject(json, "_series"), res.getSeriesElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(this.getJObject(json, "authority")));
        }
        if (json.has("targetDisease")) {
            JsonArray array = json.getAsJsonArray("targetDisease");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetDisease().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parseString(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(this.getJObject(json, "_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(this.getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
        }
    }

    protected ImmunizationEvaluation parseImmunizationEvaluation(JsonObject json) throws IOException, FHIRFormatError {
        ImmunizationEvaluation res = new ImmunizationEvaluation();
        this.parseImmunizationEvaluationProperties(json, res);
        return res;
    }

    protected void parseImmunizationEvaluationProperties(JsonObject json, ImmunizationEvaluation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(this.getJObject(json, "authority")));
        }
        if (json.has("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(this.getJObject(json, "targetDisease")));
        }
        if (json.has("immunizationEvent")) {
            res.setImmunizationEvent(this.parseReference(this.getJObject(json, "immunizationEvent")));
        }
        if (json.has("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(this.getJObject(json, "doseStatus")));
        }
        if (json.has("doseStatusReason")) {
            array = json.getAsJsonArray("doseStatusReason");
            for (i = 0; i < array.size(); ++i) {
                res.getDoseStatusReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(this.getJObject(json, "_series"), res.getSeriesElement());
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parseString(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(this.getJObject(json, "_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(this.getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
        }
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseImmunizationRecommendationProperties(json, res);
        return res;
    }

    protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instantiatesCanonical")) {
            array = json.getAsJsonArray("instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesCanonical().add(new CanonicalType());
                    continue;
                }
                res.getInstantiatesCanonical().add(this.parseCanonical(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesCanonical")) {
            array = json.getAsJsonArray("_instantiatesCanonical");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesCanonical().size()) {
                    res.getInstantiatesCanonical().add(this.parseCanonical(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
            }
        }
        if (json.has("instantiatesUri")) {
            array = json.getAsJsonArray("instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getInstantiatesUri().add(new UriType());
                    continue;
                }
                res.getInstantiatesUri().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_instantiatesUri")) {
            array = json.getAsJsonArray("_instantiatesUri");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInstantiatesUri().size()) {
                    res.getInstantiatesUri().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(this.getJObject(json, "patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(this.getJObject(json, "authority")));
        }
        if (json.has("recommendation")) {
            array = json.getAsJsonArray("recommendation");
            for (i = 0; i < array.size(); ++i) {
                res.getRecommendation().add(this.parseImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationRecommendationComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseImmunizationRecommendationRecommendationComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("vaccineCode")) {
            array = json.getAsJsonArray("vaccineCode");
            for (i = 0; i < array.size(); ++i) {
                res.getVaccineCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("targetDisease")) {
            array = json.getAsJsonArray("targetDisease");
            for (i = 0; i < array.size(); ++i) {
                res.getTargetDisease().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contraindicatedVaccineCode")) {
            array = json.getAsJsonArray("contraindicatedVaccineCode");
            for (i = 0; i < array.size(); ++i) {
                res.getContraindicatedVaccineCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(this.getJObject(json, "forecastStatus")));
        }
        if (json.has("forecastReason")) {
            array = json.getAsJsonArray("forecastReason");
            for (i = 0; i < array.size(); ++i) {
                res.getForecastReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateCriterion")) {
            array = json.getAsJsonArray("dateCriterion");
            for (i = 0; i < array.size(); ++i) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(this.getJObject(json, "_series"), res.getSeriesElement());
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parseString(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(this.getJObject(json, "_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(this.getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
        }
        if (json.has("supportingImmunization")) {
            array = json.getAsJsonArray("supportingImmunization");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingImmunization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingPatientInformation")) {
            array = json.getAsJsonArray("supportingPatientInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingPatientInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, res);
        return res;
    }

    protected void parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(this.getJObject(json, "code")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseImplementationGuideProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseCanonicalResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(this.getJObject(json, "_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(this.getJObject(json, "_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(this.getJObject(json, "_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(this.getJObject(json, "_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(this.getJObject(json, "_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactDetail(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseUsageContext(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("jurisdiction")) {
            array = json.getAsJsonArray("jurisdiction");
            for (i = 0; i < array.size(); ++i) {
                res.getJurisdiction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(this.getJObject(json, "_copyright"), res.getCopyrightElement());
        }
        if (json.has("packageId")) {
            res.setPackageIdElement(this.parseId(json.get("packageId").getAsString()));
        }
        if (json.has("_packageId")) {
            this.parseElementProperties(this.getJObject(json, "_packageId"), res.getPackageIdElement());
        }
        if (json.has("license")) {
            res.setLicenseElement(this.parseEnumeration(json.get("license").getAsString(), ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
        }
        if (json.has("_license")) {
            this.parseElementProperties(this.getJObject(json, "_license"), res.getLicenseElement());
        }
        if (json.has("fhirVersion")) {
            array = json.getAsJsonArray("fhirVersion");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
                    continue;
                }
                res.getFhirVersion().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
            }
        }
        if (json.has("_fhirVersion")) {
            array = json.getAsJsonArray("_fhirVersion");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFhirVersion().size()) {
                    res.getFhirVersion().add(this.parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
            }
        }
        if (json.has("dependsOn")) {
            array = json.getAsJsonArray("dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseImplementationGuideDependsOnComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("global")) {
            array = json.getAsJsonArray("global");
            for (i = 0; i < array.size(); ++i) {
                res.getGlobal().add(this.parseImplementationGuideGlobalComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseImplementationGuideDefinitionComponent(this.getJObject(json, "definition")));
        }
        if (json.has("manifest")) {
            res.setManifest(this.parseImplementationGuideManifestComponent(this.getJObject(json, "manifest")));
        }
    }

    protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideDependsOnComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        this.parseImplementationGuideDependsOnComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDependsOnComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("uri")) {
            res.setUriElement(this.parseCanonical(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(this.getJObject(json, "_uri"), res.getUriElement());
        }
        if (json.has("packageId")) {
            res.setPackageIdElement(this.parseId(json.get("packageId").getAsString()));
        }
        if (json.has("_packageId")) {
            this.parseElementProperties(this.getJObject(json, "_packageId"), res.getPackageIdElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(this.getJObject(json, "_version"), res.getVersionElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideGlobalComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseImplementationGuideGlobalComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(this.getJObject(json, "_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfileElement(this.parseCanonical(json.get("profile").getAsString()));
        }
        if (json.has("_profile")) {
            this.parseElementProperties(this.getJObject(json, "_profile"), res.getProfileElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
        this.parseImplementationGuideDefinitionComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("grouping")) {
            array = json.getAsJsonArray("grouping");
            for (i = 0; i < array.size(); ++i) {
                res.getGrouping().add(this.parseImplementationGuideDefinitionGroupingComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseImplementationGuideDefinitionResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("page")) {
            res.setPage(this.parseImplementationGuideDefinitionPageComponent(this.getJObject(json, "page")));
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseImplementationGuideDefinitionParameterComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("template")) {
            array = json.getAsJsonArray("template");
            for (i = 0; i < array.size(); ++i) {
                res.getTemplate().add(this.parseImplementationGuideDefinitionTemplateComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideDefinitionGroupingComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        this.parseImplementationGuideDefinitionGroupingComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionGroupingComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        this.parseImplementationGuideDefinitionResourceComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionResourceComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws IOException, FHIRFormatError {
        DataType example;
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if (json.has("fhirVersion")) {
            array = json.getAsJsonArray("fhirVersion");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
                    continue;
                }
                res.getFhirVersion().add(this.parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
            }
        }
        if (json.has("_fhirVersion")) {
            array = json.getAsJsonArray("_fhirVersion");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFhirVersion().size()) {
                    res.getFhirVersion().add(this.parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if ((example = this.parseType("example", json)) != null) {
            res.setExample(example);
        }
        if (json.has("groupingId")) {
            res.setGroupingIdElement(this.parseId(json.get("groupingId").getAsString()));
        }
        if (json.has("_groupingId")) {
            this.parseElementProperties(this.getJObject(json, "_groupingId"), res.getGroupingIdElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideDefinitionPageComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        this.parseImplementationGuideDefinitionPageComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionPageComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType name = this.parseType("name", json);
        if (name != null) {
            res.setName(name);
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("generation")) {
            res.setGenerationElement(this.parseEnumeration(json.get("generation").getAsString(), ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
        }
        if (json.has("_generation")) {
            this.parseElementProperties(this.getJObject(json, "_generation"), res.getGenerationElement());
        }
        if (json.has("page")) {
            JsonArray array = json.getAsJsonArray("page");
            for (int i = 0; i < array.size(); ++i) {
                res.getPage().add(this.parseImplementationGuideDefinitionPageComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideDefinitionParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
        this.parseImplementationGuideDefinitionParameterComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionParameterComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseString(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(this.getJObject(json, "_value"), res.getValueElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideDefinitionTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
        this.parseImplementationGuideDefinitionTemplateComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideDefinitionTemplateComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(this.getJObject(json, "_code"), res.getCodeElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseString(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(this.getJObject(json, "_source"), res.getSourceElement());
        }
        if (json.has("scope")) {
            res.setScopeElement(this.parseString(json.get("scope").getAsString()));
        }
        if (json.has("_scope")) {
            this.parseElementProperties(this.getJObject(json, "_scope"), res.getScopeElement());
        }
    }

    protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideManifestComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
        this.parseImplementationGuideManifestComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideManifestComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideManifestComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("rendering")) {
            res.setRenderingElement(this.parseUrl(json.get("rendering").getAsString()));
        }
        if (json.has("_rendering")) {
            this.parseElementProperties(this.getJObject(json, "_rendering"), res.getRenderingElement());
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseImplementationGuideManifestResourceComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("page")) {
            array = json.getAsJsonArray("page");
            for (i = 0; i < array.size(); ++i) {
                res.getPage().add(this.parseImplementationGuideManifestPageComponent(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getImage().add(new StringType());
                    continue;
                }
                res.getImage().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_image")) {
            array = json.getAsJsonArray("_image");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImage().size()) {
                    res.getImage().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImage().get(i));
            }
        }
        if (json.has("other")) {
            array = json.getAsJsonArray("other");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getOther().add(new StringType());
                    continue;
                }
                res.getOther().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_other")) {
            array = json.getAsJsonArray("_other");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOther().size()) {
                    res.getOther().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOther().get(i));
            }
        }
    }

    protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
        this.parseImplementationGuideManifestResourceComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideManifestResourceComponentProperties(JsonObject json, ImplementationGuide.ManifestResourceComponent res) throws IOException, FHIRFormatError {
        DataType example;
        this.parseBackboneElementProperties(json, res);
        if (json.has("reference")) {
            res.setReference(this.parseReference(this.getJObject(json, "reference")));
        }
        if ((example = this.parseType("example", json)) != null) {
            res.setExample(example);
        }
        if (json.has("relativePath")) {
            res.setRelativePathElement(this.parseUrl(json.get("relativePath").getAsString()));
        }
        if (json.has("_relativePath")) {
            this.parseElementProperties(this.getJObject(json, "_relativePath"), res.getRelativePathElement());
        }
    }

    protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(JsonObject json) throws IOException, FHIRFormatError {
        ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
        this.parseImplementationGuideManifestPageComponentProperties(json, res);
        return res;
    }

    protected void parseImplementationGuideManifestPageComponentProperties(JsonObject json, ImplementationGuide.ManifestPageComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(this.getJObject(json, "_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(this.getJObject(json, "_title"), res.getTitleElement());
        }
        if (json.has("anchor")) {
            array = json.getAsJsonArray("anchor");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i).isJsonNull()) {
                    res.getAnchor().add(new StringType());
                    continue;
                }
                res.getAnchor().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_anchor")) {
            array = json.getAsJsonArray("_anchor");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAnchor().size()) {
                    res.getAnchor().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAnchor().get(i));
            }
        }
    }

    protected Ingredient parseIngredient(JsonObject json) throws IOException, FHIRFormatError {
        Ingredient res = new Ingredient();
        this.parseIngredientProperties(json, res);
        return res;
    }

    protected void parseIngredientProperties(JsonObject json, Ingredient res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(this.getJObject(json, "identifier")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(this.getJObject(json, "role")));
        }
        if (json.has("function")) {
            array = json.getAsJsonArray("function");
            for (i = 0; i < array.size(); ++i) {
                res.getFunction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseMarkdown(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(this.getJObject(json, "_description"), res.getDescriptionElement());
        }
        if (json.has("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
        }
        if (json.has("_allergenicIndicator")) {
            this.parseElementProperties(this.getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
        }
        if (json.has("manufacturer")) {
            array = json.getAsJsonArray("manufacturer");
            for (i = 0; i < array.size(); ++i) {
                res.getManufacturer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("substance")) {
            res.setSubstance(this.parseIngredientSubstanceComponent(this.getJObject(json, "substance")));
        }
        if (json.has("specifiedSubstance")) {
            array = json.getAsJsonArray("specifiedSubstance");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecifiedSubstance().add(this.parseIngredientSpecifiedSubstanceComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Ingredient.IngredientSubstanceComponent parseIngredientSubstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
        this.parseIngredientSubstanceComponentProperties(json, res);
        return res;
    }

    protected void parseIngredientSubstanceComponentProperties(JsonObject json, Ingredient.IngredientSubstanceComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType code = this.parseType("code", json);
        if (code != null) {
            res.setCode(code);
        }
        if (json.has("strength")) {
            JsonArray array = json.getAsJsonArray("strength");
            for (int i = 0; i < array.size(); ++i) {
                res.getStrength().add(this.parseIngredientSubstanceStrengthComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Ingredient.IngredientSubstanceStrengthComponent parseIngredientSubstanceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthComponent();
        this.parseIngredientSubstanceStrengthComponentProperties(json, res);
        return res;
    }

    protected void parseIngredientSubstanceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSubstanceStrengthComponent res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseBackboneElementProperties(json, res);
        if (json.has("presentation")) {
            res.setPresentation(this.parseRatio(this.getJObject(json, "presentation")));
        }
        if (json.has("presentationHighLimit")) {
            res.setPresentationHighLimit(this.parseRatio(this.getJObject(json, "presentationHighLimit")));
        }
        if (json.has("presentationText")) {
            res.setPresentationTextElement(this.parseString(json.get("presentationText").getAsString()));
        }
        if (json.has("_presentationText")) {
            this.parseElementProperties(this.getJObject(json, "_presentationText"), res.getPresentationTextElement());
        }
        if (json.has("concentration")) {
            res.setConcentration(this.parseRatio(this.getJObject(json, "concentration")));
        }
        if (json.has("concentrationHighLimit")) {
            res.setConcentrationHighLimit(this.parseRatio(this.getJObject(json, "concentrationHighLimit")));
        }
        if (json.has("concentrationText")) {
            res.setConcentrationTextElement(this.parseString(json.get("concentrationText").getAsString()));
        }
        if (json.has("_concentrationText")) {
            this.parseElementProperties(this.getJObject(json, "_concentrationText"), res.getConcentrationTextElement());
        }
        if (json.has("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(json.get("measurementPoint").getAsString()));
        }
        if (json.has("_measurementPoint")) {
            this.parseElementProperties(this.getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
        }
        if (json.has("country")) {
            array = json.getAsJsonArray("country");
            for (i = 0; i < array.size(); ++i) {
                res.getCountry().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referenceStrength")) {
            array = json.getAsJsonArray("referenceStrength");
            for (i = 0; i < array.size(); ++i) {
                res.getReferenceStrength().add(this.parseIngredientSubstanceStrengthReferenceStrengthComponent(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent parseIngredientSubstanceStrengthReferenceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent();
        this.parseIngredientSubstanceStrengthReferenceStrengthComponentProperties(json, res);
        return res;
    }

    protected void parseIngredientSubstanceStrengthReferenceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res) throws IOException, FHIRFormatError {
        this.parseBackboneElementProperties(json, res);
        DataType substance = this.parseType("substance", json);
        if (substance != null) {
            res.setSubstance(substance);
        }
        if (json.has("strength")) {
            res.setStrength(this.parseRatio(this.getJObject(json, "strength")));
        }
        if (json.has("strengthHighLimit")) {
            res.setStrengthHighLimit(this.parseRatio(this.getJObject(json, "strengthHighLimit")));
        }
        if (json.has("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(json.get("measurementPoint").getAsString()));
        }
        if (json.has("_measurementPoint")) {
            this.parseElementProperties(this.getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
        }
        if (json.has("country")) {
            JsonArr