/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AdministrableProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/AdministrableProductDefinition")
public class AdministrableProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the pharmaceutical medicinal product", formalDefinition="An identifier for the pharmaceutical medicinal product.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={MedicinalProductDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product that this is a pharmaceutical product of", formalDefinition="The product that this is a pharmaceutical product of.")
    protected List<Reference> subject;
    @Child(name="administrableDoseForm", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The administrable dose form, after necessary reconstitution", formalDefinition="The administrable dose form, after necessary reconstitution.")
    protected CodeableConcept administrableDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="producedFrom", type={ManufacturedItemDefinition.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The manufactured item(s) that this administrable product is produced from. Either a single item, or several that are mixed before administration (e.g. a power item and a solution item). Note that these are not raw ingredients", formalDefinition="The manufactured item(s) that this administrable product is produced from. Either a single item, or several that are mixed before administration (e.g. a power item and a solution item). Note that these are not raw ingredients.")
    protected List<Reference> producedFrom;
    @Child(name="ingredient", type={Ingredient.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients of this administrable pharmaceutical product", formalDefinition="The ingredients of this administrable pharmaceutical product.")
    protected List<Reference> ingredient;
    @Child(name="device", type={DeviceDefinition.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Accompanying device", formalDefinition="Accompanying device.")
    protected List<Reference> device;
    @Child(name="property", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Characteristics e.g. a products onset of action", formalDefinition="Characteristics e.g. a products onset of action.")
    protected List<AdministrableProductDefinitionPropertyComponent> property;
    @Child(name="routeOfAdministration", type={}, order=8, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body", formalDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body.")
    protected List<AdministrableProductDefinitionRouteOfAdministrationComponent> routeOfAdministration;
    private static final long serialVersionUID = -1072766896L;
    @SearchParamDefinition(name="device", path="AdministrableProductDefinition.device", description="Accompanying device", type="reference", target={DeviceDefinition.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("AdministrableProductDefinition:device").toLocked();
    @SearchParamDefinition(name="dose-form", path="AdministrableProductDefinition.administrableDoseForm", description="The administrable dose form, after necessary reconstitution", type="token")
    public static final String SP_DOSE_FORM = "dose-form";
    public static final TokenClientParam DOSE_FORM = new TokenClientParam("dose-form");
    @SearchParamDefinition(name="identifier", path="AdministrableProductDefinition.identifier", description="An identifier for the pharmaceutical medicinal product", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient", path="AdministrableProductDefinition.ingredient", description="The ingredients of this administrable pharmaceutical product", type="reference", target={Ingredient.class})
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("AdministrableProductDefinition:ingredient").toLocked();
    @SearchParamDefinition(name="manufactured-item", path="AdministrableProductDefinition.producedFrom", description="The manufactured item(s) that this administrable product is produced from. Either a single item, or several that are mixed before administration (e.g. a power item and a solution item). Note that these are not raw ingredients", type="reference", target={ManufacturedItemDefinition.class})
    public static final String SP_MANUFACTURED_ITEM = "manufactured-item";
    public static final ReferenceClientParam MANUFACTURED_ITEM = new ReferenceClientParam("manufactured-item");
    public static final Include INCLUDE_MANUFACTURED_ITEM = new Include("AdministrableProductDefinition:manufactured-item").toLocked();
    @SearchParamDefinition(name="route", path="AdministrableProductDefinition.routeOfAdministration.code", description="Coded expression for the route", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="subject", path="AdministrableProductDefinition.subject", description="The product that this is a pharmaceutical product of", type="reference", target={MedicinalProductDefinition.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AdministrableProductDefinition:subject").toLocked();
    @SearchParamDefinition(name="target-species", path="AdministrableProductDefinition.routeOfAdministration.targetSpecies.code", description="Coded expression for the species", type="token")
    public static final String SP_TARGET_SPECIES = "target-species";
    public static final TokenClientParam TARGET_SPECIES = new TokenClientParam("target-species");

    public AdministrableProductDefinition() {
    }

    public AdministrableProductDefinition(AdministrableProductDefinitionRouteOfAdministrationComponent routeOfAdministration) {
        this.addRouteOfAdministration(routeOfAdministration);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AdministrableProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AdministrableProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public AdministrableProductDefinition setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public AdministrableProductDefinition addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public CodeableConcept getAdministrableDoseForm() {
        if (this.administrableDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdministrableProductDefinition.administrableDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.administrableDoseForm = new CodeableConcept();
            }
        }
        return this.administrableDoseForm;
    }

    public boolean hasAdministrableDoseForm() {
        return this.administrableDoseForm != null && !this.administrableDoseForm.isEmpty();
    }

    public AdministrableProductDefinition setAdministrableDoseForm(CodeableConcept value) {
        this.administrableDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AdministrableProductDefinition.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public AdministrableProductDefinition setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getProducedFrom() {
        if (this.producedFrom == null) {
            this.producedFrom = new ArrayList<Reference>();
        }
        return this.producedFrom;
    }

    public AdministrableProductDefinition setProducedFrom(List<Reference> theProducedFrom) {
        this.producedFrom = theProducedFrom;
        return this;
    }

    public boolean hasProducedFrom() {
        if (this.producedFrom == null) {
            return false;
        }
        for (Reference item : this.producedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProducedFrom() {
        Reference t = new Reference();
        if (this.producedFrom == null) {
            this.producedFrom = new ArrayList<Reference>();
        }
        this.producedFrom.add(t);
        return t;
    }

    public AdministrableProductDefinition addProducedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.producedFrom == null) {
            this.producedFrom = new ArrayList<Reference>();
        }
        this.producedFrom.add(t);
        return this;
    }

    public Reference getProducedFromFirstRep() {
        if (this.getProducedFrom().isEmpty()) {
            this.addProducedFrom();
        }
        return this.getProducedFrom().get(0);
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public AdministrableProductDefinition setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public AdministrableProductDefinition addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public AdministrableProductDefinition setDevice(List<Reference> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public AdministrableProductDefinition addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public Reference getDeviceFirstRep() {
        if (this.getDevice().isEmpty()) {
            this.addDevice();
        }
        return this.getDevice().get(0);
    }

    public List<AdministrableProductDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<AdministrableProductDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public AdministrableProductDefinition setProperty(List<AdministrableProductDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (AdministrableProductDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdministrableProductDefinitionPropertyComponent addProperty() {
        AdministrableProductDefinitionPropertyComponent t = new AdministrableProductDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<AdministrableProductDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public AdministrableProductDefinition addProperty(AdministrableProductDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<AdministrableProductDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public AdministrableProductDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public List<AdministrableProductDefinitionRouteOfAdministrationComponent> getRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationComponent>();
        }
        return this.routeOfAdministration;
    }

    public AdministrableProductDefinition setRouteOfAdministration(List<AdministrableProductDefinitionRouteOfAdministrationComponent> theRouteOfAdministration) {
        this.routeOfAdministration = theRouteOfAdministration;
        return this;
    }

    public boolean hasRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            return false;
        }
        for (AdministrableProductDefinitionRouteOfAdministrationComponent item : this.routeOfAdministration) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdministrableProductDefinitionRouteOfAdministrationComponent addRouteOfAdministration() {
        AdministrableProductDefinitionRouteOfAdministrationComponent t = new AdministrableProductDefinitionRouteOfAdministrationComponent();
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationComponent>();
        }
        this.routeOfAdministration.add(t);
        return t;
    }

    public AdministrableProductDefinition addRouteOfAdministration(AdministrableProductDefinitionRouteOfAdministrationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationComponent>();
        }
        this.routeOfAdministration.add(t);
        return this;
    }

    public AdministrableProductDefinitionRouteOfAdministrationComponent getRouteOfAdministrationFirstRep() {
        if (this.getRouteOfAdministration().isEmpty()) {
            this.addRouteOfAdministration();
        }
        return this.getRouteOfAdministration().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pharmaceutical product of.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation));
        children.add(new Property("producedFrom", "Reference(ManufacturedItemDefinition)", "The manufactured item(s) that this administrable product is produced from. Either a single item, or several that are mixed before administration (e.g. a power item and a solution item). Note that these are not raw ingredients.", 0, Integer.MAX_VALUE, this.producedFrom));
        children.add(new Property(SP_INGREDIENT, "Reference(Ingredient)", "The ingredients of this administrable pharmaceutical product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property(SP_DEVICE, "Reference(DeviceDefinition)", "Accompanying device.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("property", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("routeOfAdministration", "", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProductDefinition)", "The product that this is a pharmaceutical product of.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 1446105202: {
                return new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation);
            }
            case 588380494: {
                return new Property("producedFrom", "Reference(ManufacturedItemDefinition)", "The manufactured item(s) that this administrable product is produced from. Either a single item, or several that are mixed before administration (e.g. a power item and a solution item). Note that these are not raw ingredients.", 0, Integer.MAX_VALUE, this.producedFrom);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "Reference(Ingredient)", "The ingredients of this administrable pharmaceutical product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(DeviceDefinition)", "Accompanying device.", 0, Integer.MAX_VALUE, this.device);
            }
            case -993141291: {
                return new Property("property", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.property);
            }
            case 1742084734: {
                return new Property("routeOfAdministration", "", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 1446105202: {
                Base[] baseArray;
                if (this.administrableDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.administrableDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case 588380494: {
                return this.producedFrom == null ? new Base[]{} : this.producedFrom.toArray(new Base[this.producedFrom.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 1742084734: {
                return this.routeOfAdministration == null ? new Base[]{} : this.routeOfAdministration.toArray(new Base[this.routeOfAdministration.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1446105202: {
                this.administrableDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 588380494: {
                this.getProducedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((AdministrableProductDefinitionPropertyComponent)value);
                return value;
            }
            case 1742084734: {
                this.getRouteOfAdministration().add((AdministrableProductDefinitionRouteOfAdministrationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("producedFrom")) {
            this.getProducedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_DEVICE)) {
            this.getDevice().add(TypeConvertor.castToReference(value));
        } else if (name.equals("property")) {
            this.getProperty().add((AdministrableProductDefinitionPropertyComponent)value);
        } else if (name.equals("routeOfAdministration")) {
            this.getRouteOfAdministration().add((AdministrableProductDefinitionRouteOfAdministrationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 1446105202: {
                return this.getAdministrableDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case 588380494: {
                return this.addProducedFrom();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -1335157162: {
                return this.addDevice();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 1742084734: {
                return this.addRouteOfAdministration();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1446105202: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case 588380494: {
                return new String[]{"Reference"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -993141291: {
                return new String[0];
            }
            case 1742084734: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = new CodeableConcept();
            return this.administrableDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("producedFrom")) {
            return this.addProducedFrom();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals(SP_DEVICE)) {
            return this.addDevice();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("routeOfAdministration")) {
            return this.addRouteOfAdministration();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AdministrableProductDefinition";
    }

    @Override
    public AdministrableProductDefinition copy() {
        AdministrableProductDefinition dst = new AdministrableProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AdministrableProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.administrableDoseForm = this.administrableDoseForm == null ? null : this.administrableDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.producedFrom != null) {
            dst.producedFrom = new ArrayList<Reference>();
            for (Reference reference : this.producedFrom) {
                dst.producedFrom.add(reference.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference : this.device) {
                dst.device.add(reference.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<AdministrableProductDefinitionPropertyComponent>();
            for (AdministrableProductDefinitionPropertyComponent administrableProductDefinitionPropertyComponent : this.property) {
                dst.property.add(administrableProductDefinitionPropertyComponent.copy());
            }
        }
        if (this.routeOfAdministration != null) {
            dst.routeOfAdministration = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationComponent>();
            for (AdministrableProductDefinitionRouteOfAdministrationComponent administrableProductDefinitionRouteOfAdministrationComponent : this.routeOfAdministration) {
                dst.routeOfAdministration.add(administrableProductDefinitionRouteOfAdministrationComponent.copy());
            }
        }
    }

    protected AdministrableProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AdministrableProductDefinition)) {
            return false;
        }
        AdministrableProductDefinition o = (AdministrableProductDefinition)other_;
        return AdministrableProductDefinition.compareDeep(this.identifier, o.identifier, true) && AdministrableProductDefinition.compareDeep(this.subject, o.subject, true) && AdministrableProductDefinition.compareDeep(this.administrableDoseForm, o.administrableDoseForm, true) && AdministrableProductDefinition.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && AdministrableProductDefinition.compareDeep(this.producedFrom, o.producedFrom, true) && AdministrableProductDefinition.compareDeep(this.ingredient, o.ingredient, true) && AdministrableProductDefinition.compareDeep(this.device, o.device, true) && AdministrableProductDefinition.compareDeep(this.property, o.property, true) && AdministrableProductDefinition.compareDeep(this.routeOfAdministration, o.routeOfAdministration, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AdministrableProductDefinition)) {
            return false;
        }
        AdministrableProductDefinition o = (AdministrableProductDefinition)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.subject, this.administrableDoseForm, this.unitOfPresentation, this.producedFrom, this.ingredient, this.device, this.property, this.routeOfAdministration});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AdministrableProductDefinition;
    }

    @Block
    public static class AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="tissue", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk", formalDefinition="Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.")
        protected CodeableConcept tissue;
        @Child(name="value", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the time", formalDefinition="A value for the time.")
        protected Quantity value;
        @Child(name="supportingInformation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Extra information about the withdrawal period", formalDefinition="Extra information about the withdrawal period.")
        protected StringType supportingInformation;
        private static final long serialVersionUID = -1113691238L;

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent() {
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(CodeableConcept tissue, Quantity value) {
            this.setTissue(tissue);
            this.setValue(value);
        }

        public CodeableConcept getTissue() {
            if (this.tissue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.tissue");
                }
                if (Configuration.doAutoCreate()) {
                    this.tissue = new CodeableConcept();
                }
            }
            return this.tissue;
        }

        public boolean hasTissue() {
            return this.tissue != null && !this.tissue.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setTissue(CodeableConcept value) {
            this.tissue = value;
            return this;
        }

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public StringType getSupportingInformationElement() {
            if (this.supportingInformation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.supportingInformation");
                }
                if (Configuration.doAutoCreate()) {
                    this.supportingInformation = new StringType();
                }
            }
            return this.supportingInformation;
        }

        public boolean hasSupportingInformationElement() {
            return this.supportingInformation != null && !this.supportingInformation.isEmpty();
        }

        public boolean hasSupportingInformation() {
            return this.supportingInformation != null && !this.supportingInformation.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setSupportingInformationElement(StringType value) {
            this.supportingInformation = value;
            return this;
        }

        public String getSupportingInformation() {
            return this.supportingInformation == null ? null : (String)this.supportingInformation.getValue();
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent setSupportingInformation(String value) {
            if (Utilities.noString((String)value)) {
                this.supportingInformation = null;
            } else {
                if (this.supportingInformation == null) {
                    this.supportingInformation = new StringType();
                }
                this.supportingInformation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("tissue", "CodeableConcept", "Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.", 0, 1, this.tissue));
            children.add(new Property("value", "Quantity", "A value for the time.", 0, 1, this.value));
            children.add(new Property("supportingInformation", "string", "Extra information about the withdrawal period.", 0, 1, this.supportingInformation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -873475867: {
                    return new Property("tissue", "CodeableConcept", "Coded expression for the type of tissue for which the withdrawal period applues, e.g. meat, milk.", 0, 1, this.tissue);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "A value for the time.", 0, 1, this.value);
                }
                case -1248768647: {
                    return new Property("supportingInformation", "string", "Extra information about the withdrawal period.", 0, 1, this.supportingInformation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    Base[] baseArray;
                    if (this.tissue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.tissue;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1248768647: {
                    Base[] baseArray;
                    if (this.supportingInformation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.supportingInformation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    this.tissue = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1248768647: {
                    this.supportingInformation = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("tissue")) {
                this.tissue = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToQuantity(value);
            } else if (name.equals("supportingInformation")) {
                this.supportingInformation = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    return this.getTissue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1248768647: {
                    return this.getSupportingInformationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -873475867: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case -1248768647: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("tissue")) {
                this.tissue = new CodeableConcept();
                return this.tissue;
            }
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("supportingInformation")) {
                throw new FHIRException("Cannot call addChild on a primitive type AdministrableProductDefinition.routeOfAdministration.targetSpecies.withdrawalPeriod.supportingInformation");
            }
            return super.addChild(name);
        }

        @Override
        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent copy() {
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent dst = new AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent dst) {
            super.copyValues(dst);
            dst.tissue = this.tissue == null ? null : this.tissue.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.supportingInformation = this.supportingInformation == null ? null : this.supportingInformation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent o = (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)other_;
            return AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.tissue, o.tissue, true) && AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.value, o.value, true) && AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareDeep(this.supportingInformation, o.supportingInformation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent o = (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)other_;
            return AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent.compareValues(this.supportingInformation, o.supportingInformation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.tissue, this.value, this.supportingInformation});
        }

        @Override
        public String fhirType() {
            return "AdministrableProductDefinition.routeOfAdministration.targetSpecies.withdrawalPeriod";
        }
    }

    @Block
    public static class AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the species", formalDefinition="Coded expression for the species.")
        protected CodeableConcept code;
        @Child(name="withdrawalPeriod", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A species specific time during which consumption of animal product is not appropriate", formalDefinition="A species specific time during which consumption of animal product is not appropriate.")
        protected List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> withdrawalPeriod;
        private static final long serialVersionUID = -560311351L;

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent() {
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> getWithdrawalPeriod() {
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            return this.withdrawalPeriod;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent setWithdrawalPeriod(List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent> theWithdrawalPeriod) {
            this.withdrawalPeriod = theWithdrawalPeriod;
            return this;
        }

        public boolean hasWithdrawalPeriod() {
            if (this.withdrawalPeriod == null) {
                return false;
            }
            for (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent item : this.withdrawalPeriod) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent addWithdrawalPeriod() {
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent t = new AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            this.withdrawalPeriod.add(t);
            return t;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent addWithdrawalPeriod(AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent t) {
            if (t == null) {
                return this;
            }
            if (this.withdrawalPeriod == null) {
                this.withdrawalPeriod = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
            }
            this.withdrawalPeriod.add(t);
            return this;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent getWithdrawalPeriodFirstRep() {
            if (this.getWithdrawalPeriod().isEmpty()) {
                this.addWithdrawalPeriod();
            }
            return this.getWithdrawalPeriod().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Coded expression for the species.", 0, 1, this.code));
            children.add(new Property("withdrawalPeriod", "", "A species specific time during which consumption of animal product is not appropriate.", 0, Integer.MAX_VALUE, this.withdrawalPeriod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded expression for the species.", 0, 1, this.code);
                }
                case -98450730: {
                    return new Property("withdrawalPeriod", "", "A species specific time during which consumption of animal product is not appropriate.", 0, Integer.MAX_VALUE, this.withdrawalPeriod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -98450730: {
                    return this.withdrawalPeriod == null ? new Base[]{} : this.withdrawalPeriod.toArray(new Base[this.withdrawalPeriod.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -98450730: {
                    this.getWithdrawalPeriod().add((AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("withdrawalPeriod")) {
                this.getWithdrawalPeriod().add((AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -98450730: {
                    return this.addWithdrawalPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -98450730: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("withdrawalPeriod")) {
                return this.addWithdrawalPeriod();
            }
            return super.addChild(name);
        }

        @Override
        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent copy() {
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent dst = new AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.withdrawalPeriod != null) {
                dst.withdrawalPeriod = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent>();
                for (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent i : this.withdrawalPeriod) {
                    dst.withdrawalPeriod.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent o = (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)other_;
            return AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent.compareDeep(this.code, o.code, true) && AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent.compareDeep(this.withdrawalPeriod, o.withdrawalPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent o = (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.withdrawalPeriod});
        }

        @Override
        public String fhirType() {
            return "AdministrableProductDefinition.routeOfAdministration.targetSpecies";
        }
    }

    @Block
    public static class AdministrableProductDefinitionRouteOfAdministrationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coded expression for the route", formalDefinition="Coded expression for the route.")
        protected CodeableConcept code;
        @Child(name="firstDose", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement", formalDefinition="The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.")
        protected Quantity firstDose;
        @Child(name="maxSingleDose", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement", formalDefinition="The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.")
        protected Quantity maxSingleDose;
        @Child(name="maxDosePerDay", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Quantity maxDosePerDay;
        @Child(name="maxDosePerTreatmentPeriod", type={Ratio.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Ratio maxDosePerTreatmentPeriod;
        @Child(name="maxTreatmentPeriod", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation", formalDefinition="The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.")
        protected Duration maxTreatmentPeriod;
        @Child(name="targetSpecies", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A species for which this route applies", formalDefinition="A species for which this route applies.")
        protected List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent> targetSpecies;
        private static final long serialVersionUID = 322274730L;

        public AdministrableProductDefinitionRouteOfAdministrationComponent() {
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Quantity getFirstDose() {
            if (this.firstDose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.firstDose");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstDose = new Quantity();
                }
            }
            return this.firstDose;
        }

        public boolean hasFirstDose() {
            return this.firstDose != null && !this.firstDose.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setFirstDose(Quantity value) {
            this.firstDose = value;
            return this;
        }

        public Quantity getMaxSingleDose() {
            if (this.maxSingleDose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.maxSingleDose");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxSingleDose = new Quantity();
                }
            }
            return this.maxSingleDose;
        }

        public boolean hasMaxSingleDose() {
            return this.maxSingleDose != null && !this.maxSingleDose.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setMaxSingleDose(Quantity value) {
            this.maxSingleDose = value;
            return this;
        }

        public Quantity getMaxDosePerDay() {
            if (this.maxDosePerDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.maxDosePerDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerDay = new Quantity();
                }
            }
            return this.maxDosePerDay;
        }

        public boolean hasMaxDosePerDay() {
            return this.maxDosePerDay != null && !this.maxDosePerDay.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setMaxDosePerDay(Quantity value) {
            this.maxDosePerDay = value;
            return this;
        }

        public Ratio getMaxDosePerTreatmentPeriod() {
            if (this.maxDosePerTreatmentPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.maxDosePerTreatmentPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerTreatmentPeriod = new Ratio();
                }
            }
            return this.maxDosePerTreatmentPeriod;
        }

        public boolean hasMaxDosePerTreatmentPeriod() {
            return this.maxDosePerTreatmentPeriod != null && !this.maxDosePerTreatmentPeriod.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setMaxDosePerTreatmentPeriod(Ratio value) {
            this.maxDosePerTreatmentPeriod = value;
            return this;
        }

        public Duration getMaxTreatmentPeriod() {
            if (this.maxTreatmentPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionRouteOfAdministrationComponent.maxTreatmentPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxTreatmentPeriod = new Duration();
                }
            }
            return this.maxTreatmentPeriod;
        }

        public boolean hasMaxTreatmentPeriod() {
            return this.maxTreatmentPeriod != null && !this.maxTreatmentPeriod.isEmpty();
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setMaxTreatmentPeriod(Duration value) {
            this.maxTreatmentPeriod = value;
            return this;
        }

        public List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent> getTargetSpecies() {
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent>();
            }
            return this.targetSpecies;
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent setTargetSpecies(List<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent> theTargetSpecies) {
            this.targetSpecies = theTargetSpecies;
            return this;
        }

        public boolean hasTargetSpecies() {
            if (this.targetSpecies == null) {
                return false;
            }
            for (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent item : this.targetSpecies) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent addTargetSpecies() {
            AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent t = new AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent>();
            }
            this.targetSpecies.add(t);
            return t;
        }

        public AdministrableProductDefinitionRouteOfAdministrationComponent addTargetSpecies(AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.targetSpecies == null) {
                this.targetSpecies = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent>();
            }
            this.targetSpecies.add(t);
            return this;
        }

        public AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent getTargetSpeciesFirstRep() {
            if (this.getTargetSpecies().isEmpty()) {
                this.addTargetSpecies();
            }
            return this.getTargetSpecies().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Coded expression for the route.", 0, 1, this.code));
            children.add(new Property("firstDose", "Quantity", "The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.", 0, 1, this.firstDose));
            children.add(new Property("maxSingleDose", "Quantity", "The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.", 0, 1, this.maxSingleDose));
            children.add(new Property("maxDosePerDay", "Quantity", "The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerDay));
            children.add(new Property("maxDosePerTreatmentPeriod", "Ratio", "The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerTreatmentPeriod));
            children.add(new Property("maxTreatmentPeriod", "Duration", "The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxTreatmentPeriod));
            children.add(new Property("targetSpecies", "", "A species for which this route applies.", 0, Integer.MAX_VALUE, this.targetSpecies));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded expression for the route.", 0, 1, this.code);
                }
                case 132551405: {
                    return new Property("firstDose", "Quantity", "The first dose (dose quantity) administered in humans can be specified, for a product under investigation, using a numerical value and its unit of measurement.", 0, 1, this.firstDose);
                }
                case -259207927: {
                    return new Property("maxSingleDose", "Quantity", "The maximum single dose that can be administered as per the protocol of a clinical trial can be specified using a numerical value and its unit of measurement.", 0, 1, this.maxSingleDose);
                }
                case -2017475520: {
                    return new Property("maxDosePerDay", "Quantity", "The maximum dose per day (maximum dose quantity to be administered in any one 24-h period) that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerDay);
                }
                case -608040195: {
                    return new Property("maxDosePerTreatmentPeriod", "Ratio", "The maximum dose per treatment period that can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxDosePerTreatmentPeriod);
                }
                case 920698453: {
                    return new Property("maxTreatmentPeriod", "Duration", "The maximum treatment period during which an Investigational Medicinal Product can be administered as per the protocol referenced in the clinical trial authorisation.", 0, 1, this.maxTreatmentPeriod);
                }
                case 295481963: {
                    return new Property("targetSpecies", "", "A species for which this route applies.", 0, Integer.MAX_VALUE, this.targetSpecies);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 132551405: {
                    Base[] baseArray;
                    if (this.firstDose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.firstDose;
                    }
                    return baseArray;
                }
                case -259207927: {
                    Base[] baseArray;
                    if (this.maxSingleDose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.maxSingleDose;
                    }
                    return baseArray;
                }
                case -2017475520: {
                    Base[] baseArray;
                    if (this.maxDosePerDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.maxDosePerDay;
                    }
                    return baseArray;
                }
                case -608040195: {
                    Base[] baseArray;
                    if (this.maxDosePerTreatmentPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.maxDosePerTreatmentPeriod;
                    }
                    return baseArray;
                }
                case 920698453: {
                    Base[] baseArray;
                    if (this.maxTreatmentPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.maxTreatmentPeriod;
                    }
                    return baseArray;
                }
                case 295481963: {
                    return this.targetSpecies == null ? new Base[]{} : this.targetSpecies.toArray(new Base[this.targetSpecies.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 132551405: {
                    this.firstDose = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -259207927: {
                    this.maxSingleDose = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -2017475520: {
                    this.maxDosePerDay = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -608040195: {
                    this.maxDosePerTreatmentPeriod = TypeConvertor.castToRatio(value);
                    return value;
                }
                case 920698453: {
                    this.maxTreatmentPeriod = TypeConvertor.castToDuration(value);
                    return value;
                }
                case 295481963: {
                    this.getTargetSpecies().add((AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("firstDose")) {
                this.firstDose = TypeConvertor.castToQuantity(value);
            } else if (name.equals("maxSingleDose")) {
                this.maxSingleDose = TypeConvertor.castToQuantity(value);
            } else if (name.equals("maxDosePerDay")) {
                this.maxDosePerDay = TypeConvertor.castToQuantity(value);
            } else if (name.equals("maxDosePerTreatmentPeriod")) {
                this.maxDosePerTreatmentPeriod = TypeConvertor.castToRatio(value);
            } else if (name.equals("maxTreatmentPeriod")) {
                this.maxTreatmentPeriod = TypeConvertor.castToDuration(value);
            } else if (name.equals("targetSpecies")) {
                this.getTargetSpecies().add((AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 132551405: {
                    return this.getFirstDose();
                }
                case -259207927: {
                    return this.getMaxSingleDose();
                }
                case -2017475520: {
                    return this.getMaxDosePerDay();
                }
                case -608040195: {
                    return this.getMaxDosePerTreatmentPeriod();
                }
                case 920698453: {
                    return this.getMaxTreatmentPeriod();
                }
                case 295481963: {
                    return this.addTargetSpecies();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 132551405: {
                    return new String[]{"Quantity"};
                }
                case -259207927: {
                    return new String[]{"Quantity"};
                }
                case -2017475520: {
                    return new String[]{"Quantity"};
                }
                case -608040195: {
                    return new String[]{"Ratio"};
                }
                case 920698453: {
                    return new String[]{"Duration"};
                }
                case 295481963: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("firstDose")) {
                this.firstDose = new Quantity();
                return this.firstDose;
            }
            if (name.equals("maxSingleDose")) {
                this.maxSingleDose = new Quantity();
                return this.maxSingleDose;
            }
            if (name.equals("maxDosePerDay")) {
                this.maxDosePerDay = new Quantity();
                return this.maxDosePerDay;
            }
            if (name.equals("maxDosePerTreatmentPeriod")) {
                this.maxDosePerTreatmentPeriod = new Ratio();
                return this.maxDosePerTreatmentPeriod;
            }
            if (name.equals("maxTreatmentPeriod")) {
                this.maxTreatmentPeriod = new Duration();
                return this.maxTreatmentPeriod;
            }
            if (name.equals("targetSpecies")) {
                return this.addTargetSpecies();
            }
            return super.addChild(name);
        }

        @Override
        public AdministrableProductDefinitionRouteOfAdministrationComponent copy() {
            AdministrableProductDefinitionRouteOfAdministrationComponent dst = new AdministrableProductDefinitionRouteOfAdministrationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdministrableProductDefinitionRouteOfAdministrationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.firstDose = this.firstDose == null ? null : this.firstDose.copy();
            dst.maxSingleDose = this.maxSingleDose == null ? null : this.maxSingleDose.copy();
            dst.maxDosePerDay = this.maxDosePerDay == null ? null : this.maxDosePerDay.copy();
            dst.maxDosePerTreatmentPeriod = this.maxDosePerTreatmentPeriod == null ? null : this.maxDosePerTreatmentPeriod.copy();
            Duration duration = dst.maxTreatmentPeriod = this.maxTreatmentPeriod == null ? null : this.maxTreatmentPeriod.copy();
            if (this.targetSpecies != null) {
                dst.targetSpecies = new ArrayList<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent>();
                for (AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent i : this.targetSpecies) {
                    dst.targetSpecies.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationComponent o = (AdministrableProductDefinitionRouteOfAdministrationComponent)other_;
            return AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.code, o.code, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.firstDose, o.firstDose, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.maxSingleDose, o.maxSingleDose, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.maxDosePerDay, o.maxDosePerDay, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.maxDosePerTreatmentPeriod, o.maxDosePerTreatmentPeriod, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.maxTreatmentPeriod, o.maxTreatmentPeriod, true) && AdministrableProductDefinitionRouteOfAdministrationComponent.compareDeep(this.targetSpecies, o.targetSpecies, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionRouteOfAdministrationComponent)) {
                return false;
            }
            AdministrableProductDefinitionRouteOfAdministrationComponent o = (AdministrableProductDefinitionRouteOfAdministrationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.firstDose, this.maxSingleDose, this.maxDosePerDay, this.maxDosePerTreatmentPeriod, this.maxTreatmentPeriod, this.targetSpecies});
        }

        @Override
        public String fhirType() {
            return "AdministrableProductDefinition.routeOfAdministration";
        }
    }

    @Block
    public static class AdministrableProductDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        @Child(name="status", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of characteristic e.g. assigned or pending", formalDefinition="The status of characteristic e.g. assigned or pending.")
        protected CodeableConcept status;
        private static final long serialVersionUID = -872048207L;

        public AdministrableProductDefinitionPropertyComponent() {
        }

        public AdministrableProductDefinitionPropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AdministrableProductDefinitionPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AdministrableProductDefinitionPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for AdministrableProductDefinition.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdministrableProductDefinitionPropertyComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public AdministrableProductDefinitionPropertyComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
            children.add(new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("status")) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -892481550: {
                    return this.getStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            return super.addChild(name);
        }

        @Override
        public AdministrableProductDefinitionPropertyComponent copy() {
            AdministrableProductDefinitionPropertyComponent dst = new AdministrableProductDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdministrableProductDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.status = this.status == null ? null : this.status.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionPropertyComponent)) {
                return false;
            }
            AdministrableProductDefinitionPropertyComponent o = (AdministrableProductDefinitionPropertyComponent)other_;
            return AdministrableProductDefinitionPropertyComponent.compareDeep(this.type, o.type, true) && AdministrableProductDefinitionPropertyComponent.compareDeep(this.value, o.value, true) && AdministrableProductDefinitionPropertyComponent.compareDeep(this.status, o.status, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdministrableProductDefinitionPropertyComponent)) {
                return false;
            }
            AdministrableProductDefinitionPropertyComponent o = (AdministrableProductDefinitionPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value, this.status});
        }

        @Override
        public String fhirType() {
            return "AdministrableProductDefinition.property";
        }
    }
}

