/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConditionDefinition", profile="http://hl7.org/fhir/StructureDefinition/ConditionDefinition")
public class ConditionDefinition
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this condition definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the condition definition", formalDefinition="A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the condition definition", formalDefinition="The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this condition definition (computer friendly)", formalDefinition="A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this condition definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the condition definition.")
    protected StringType title;
    @Child(name="subtitle", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the event definition", formalDefinition="An explanatory or alternate title for the event definition giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this condition definition. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the condition definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the condition definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the condition definition", formalDefinition="A free text natural language description of the condition definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for condition definition (if applicable)", formalDefinition="A legal or geographic region in which the condition definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="code", type={CodeableConcept.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected CodeableConcept code;
    @Child(name="severity", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-severity")
    protected CodeableConcept severity;
    @Child(name="bodySite", type={CodeableConcept.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="stage", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-stage")
    protected CodeableConcept stage;
    @Child(name="hasSeverity", type={BooleanType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether Severity is appropriate", formalDefinition="Whether Severity is appropriate to collect for this condition.")
    protected BooleanType hasSeverity;
    @Child(name="hasBodySite", type={BooleanType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether bodySite is appropriate", formalDefinition="Whether bodySite is appropriate to collect for this condition.")
    protected BooleanType hasBodySite;
    @Child(name="hasStage", type={BooleanType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether stage is appropriate", formalDefinition="Whether stage is appropriate to collect for this condition.")
    protected BooleanType hasStage;
    @Child(name="definition", type={UriType.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Formal Definition for the condition", formalDefinition="Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.")
    protected List<UriType> definition;
    @Child(name="observation", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations particularly relevant to this condition", formalDefinition="Observations particularly relevant to this condition.")
    protected List<ConditionDefinitionObservationComponent> observation;
    @Child(name="medication", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Medications particularly relevant for this condition", formalDefinition="Medications particularly relevant for this condition.")
    protected List<ConditionDefinitionMedicationComponent> medication;
    @Child(name="precondition", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observation that suggets this condition", formalDefinition="An observation that suggests that this condition applies.")
    protected List<ConditionDefinitionPreconditionComponent> precondition;
    @Child(name="team", type={CareTeam.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Appropriate team for this condition", formalDefinition="Appropriate team for this condition.")
    protected List<Reference> team;
    @Child(name="questionnaire", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Questionnaire for this condition", formalDefinition="Questionnaire for this condition.")
    protected List<ConditionDefinitionQuestionnaireComponent> questionnaire;
    @Child(name="plan", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan that is appropriate", formalDefinition="Plan that is appropriate.")
    protected List<ConditionDefinitionPlanComponent> plan;
    private static final long serialVersionUID = 1798806914L;
    @SearchParamDefinition(name="context-quantity", path="(ConditionDefinition.useContext.value as Quantity) | (ConditionDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the condition definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ConditionDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the condition definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ConditionDefinition.useContext", description="A use context type and value assigned to the condition definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ConditionDefinition.useContext.code", description="A type of use context assigned to the condition definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ConditionDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the condition definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ConditionDefinition.date", description="The condition definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ConditionDefinition.description", description="The description of the condition definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ConditionDefinition.identifier", description="External identifier for the condition definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ConditionDefinition.jurisdiction", description="Intended jurisdiction for the condition definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ConditionDefinition.name", description="Computationally friendly name of the condition definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ConditionDefinition.publisher", description="Name of the publisher of the condition definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ConditionDefinition.status", description="The current status of the condition definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ConditionDefinition.title", description="The human-friendly name of the condition definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ConditionDefinition.url", description="The uri that identifies the condition definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ConditionDefinition.version", description="The business version of the condition definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ConditionDefinition() {
    }

    public ConditionDefinition(Enumerations.PublicationStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConditionDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConditionDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ConditionDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConditionDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConditionDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConditionDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConditionDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConditionDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConditionDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public ConditionDefinition setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public ConditionDefinition setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConditionDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConditionDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConditionDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConditionDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConditionDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConditionDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConditionDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConditionDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ConditionDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConditionDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConditionDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ConditionDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ConditionDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ConditionDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public ConditionDefinition setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public ConditionDefinition setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getStage() {
        if (this.stage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.stage");
            }
            if (Configuration.doAutoCreate()) {
                this.stage = new CodeableConcept();
            }
        }
        return this.stage;
    }

    public boolean hasStage() {
        return this.stage != null && !this.stage.isEmpty();
    }

    public ConditionDefinition setStage(CodeableConcept value) {
        this.stage = value;
        return this;
    }

    public BooleanType getHasSeverityElement() {
        if (this.hasSeverity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasSeverity");
            }
            if (Configuration.doAutoCreate()) {
                this.hasSeverity = new BooleanType();
            }
        }
        return this.hasSeverity;
    }

    public boolean hasHasSeverityElement() {
        return this.hasSeverity != null && !this.hasSeverity.isEmpty();
    }

    public boolean hasHasSeverity() {
        return this.hasSeverity != null && !this.hasSeverity.isEmpty();
    }

    public ConditionDefinition setHasSeverityElement(BooleanType value) {
        this.hasSeverity = value;
        return this;
    }

    public boolean getHasSeverity() {
        return this.hasSeverity == null || this.hasSeverity.isEmpty() ? false : (Boolean)this.hasSeverity.getValue();
    }

    public ConditionDefinition setHasSeverity(boolean value) {
        if (this.hasSeverity == null) {
            this.hasSeverity = new BooleanType();
        }
        this.hasSeverity.setValue((Object)value);
        return this;
    }

    public BooleanType getHasBodySiteElement() {
        if (this.hasBodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasBodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.hasBodySite = new BooleanType();
            }
        }
        return this.hasBodySite;
    }

    public boolean hasHasBodySiteElement() {
        return this.hasBodySite != null && !this.hasBodySite.isEmpty();
    }

    public boolean hasHasBodySite() {
        return this.hasBodySite != null && !this.hasBodySite.isEmpty();
    }

    public ConditionDefinition setHasBodySiteElement(BooleanType value) {
        this.hasBodySite = value;
        return this;
    }

    public boolean getHasBodySite() {
        return this.hasBodySite == null || this.hasBodySite.isEmpty() ? false : (Boolean)this.hasBodySite.getValue();
    }

    public ConditionDefinition setHasBodySite(boolean value) {
        if (this.hasBodySite == null) {
            this.hasBodySite = new BooleanType();
        }
        this.hasBodySite.setValue((Object)value);
        return this;
    }

    public BooleanType getHasStageElement() {
        if (this.hasStage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasStage");
            }
            if (Configuration.doAutoCreate()) {
                this.hasStage = new BooleanType();
            }
        }
        return this.hasStage;
    }

    public boolean hasHasStageElement() {
        return this.hasStage != null && !this.hasStage.isEmpty();
    }

    public boolean hasHasStage() {
        return this.hasStage != null && !this.hasStage.isEmpty();
    }

    public ConditionDefinition setHasStageElement(BooleanType value) {
        this.hasStage = value;
        return this;
    }

    public boolean getHasStage() {
        return this.hasStage == null || this.hasStage.isEmpty() ? false : (Boolean)this.hasStage.getValue();
    }

    public ConditionDefinition setHasStage(boolean value) {
        if (this.hasStage == null) {
            this.hasStage = new BooleanType();
        }
        this.hasStage.setValue((Object)value);
        return this;
    }

    public List<UriType> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        return this.definition;
    }

    public ConditionDefinition setDefinition(List<UriType> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (UriType item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDefinitionElement() {
        UriType t = new UriType();
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return t;
    }

    public ConditionDefinition addDefinition(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return this;
    }

    public boolean hasDefinition(String value) {
        if (this.definition == null) {
            return false;
        }
        for (UriType v : this.definition) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ConditionDefinitionObservationComponent> getObservation() {
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        return this.observation;
    }

    public ConditionDefinition setObservation(List<ConditionDefinitionObservationComponent> theObservation) {
        this.observation = theObservation;
        return this;
    }

    public boolean hasObservation() {
        if (this.observation == null) {
            return false;
        }
        for (ConditionDefinitionObservationComponent item : this.observation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionObservationComponent addObservation() {
        ConditionDefinitionObservationComponent t = new ConditionDefinitionObservationComponent();
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        this.observation.add(t);
        return t;
    }

    public ConditionDefinition addObservation(ConditionDefinitionObservationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        this.observation.add(t);
        return this;
    }

    public ConditionDefinitionObservationComponent getObservationFirstRep() {
        if (this.getObservation().isEmpty()) {
            this.addObservation();
        }
        return this.getObservation().get(0);
    }

    public List<ConditionDefinitionMedicationComponent> getMedication() {
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        return this.medication;
    }

    public ConditionDefinition setMedication(List<ConditionDefinitionMedicationComponent> theMedication) {
        this.medication = theMedication;
        return this;
    }

    public boolean hasMedication() {
        if (this.medication == null) {
            return false;
        }
        for (ConditionDefinitionMedicationComponent item : this.medication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionMedicationComponent addMedication() {
        ConditionDefinitionMedicationComponent t = new ConditionDefinitionMedicationComponent();
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        this.medication.add(t);
        return t;
    }

    public ConditionDefinition addMedication(ConditionDefinitionMedicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        this.medication.add(t);
        return this;
    }

    public ConditionDefinitionMedicationComponent getMedicationFirstRep() {
        if (this.getMedication().isEmpty()) {
            this.addMedication();
        }
        return this.getMedication().get(0);
    }

    public List<ConditionDefinitionPreconditionComponent> getPrecondition() {
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        return this.precondition;
    }

    public ConditionDefinition setPrecondition(List<ConditionDefinitionPreconditionComponent> thePrecondition) {
        this.precondition = thePrecondition;
        return this;
    }

    public boolean hasPrecondition() {
        if (this.precondition == null) {
            return false;
        }
        for (ConditionDefinitionPreconditionComponent item : this.precondition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionPreconditionComponent addPrecondition() {
        ConditionDefinitionPreconditionComponent t = new ConditionDefinitionPreconditionComponent();
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        this.precondition.add(t);
        return t;
    }

    public ConditionDefinition addPrecondition(ConditionDefinitionPreconditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        this.precondition.add(t);
        return this;
    }

    public ConditionDefinitionPreconditionComponent getPreconditionFirstRep() {
        if (this.getPrecondition().isEmpty()) {
            this.addPrecondition();
        }
        return this.getPrecondition().get(0);
    }

    public List<Reference> getTeam() {
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        return this.team;
    }

    public ConditionDefinition setTeam(List<Reference> theTeam) {
        this.team = theTeam;
        return this;
    }

    public boolean hasTeam() {
        if (this.team == null) {
            return false;
        }
        for (Reference item : this.team) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTeam() {
        Reference t = new Reference();
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return t;
    }

    public ConditionDefinition addTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return this;
    }

    public Reference getTeamFirstRep() {
        if (this.getTeam().isEmpty()) {
            this.addTeam();
        }
        return this.getTeam().get(0);
    }

    public List<ConditionDefinitionQuestionnaireComponent> getQuestionnaire() {
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        return this.questionnaire;
    }

    public ConditionDefinition setQuestionnaire(List<ConditionDefinitionQuestionnaireComponent> theQuestionnaire) {
        this.questionnaire = theQuestionnaire;
        return this;
    }

    public boolean hasQuestionnaire() {
        if (this.questionnaire == null) {
            return false;
        }
        for (ConditionDefinitionQuestionnaireComponent item : this.questionnaire) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionQuestionnaireComponent addQuestionnaire() {
        ConditionDefinitionQuestionnaireComponent t = new ConditionDefinitionQuestionnaireComponent();
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        this.questionnaire.add(t);
        return t;
    }

    public ConditionDefinition addQuestionnaire(ConditionDefinitionQuestionnaireComponent t) {
        if (t == null) {
            return this;
        }
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        this.questionnaire.add(t);
        return this;
    }

    public ConditionDefinitionQuestionnaireComponent getQuestionnaireFirstRep() {
        if (this.getQuestionnaire().isEmpty()) {
            this.addQuestionnaire();
        }
        return this.getQuestionnaire().get(0);
    }

    public List<ConditionDefinitionPlanComponent> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        return this.plan;
    }

    public ConditionDefinition setPlan(List<ConditionDefinitionPlanComponent> thePlan) {
        this.plan = thePlan;
        return this;
    }

    public boolean hasPlan() {
        if (this.plan == null) {
            return false;
        }
        for (ConditionDefinitionPlanComponent item : this.plan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionPlanComponent addPlan() {
        ConditionDefinitionPlanComponent t = new ConditionDefinitionPlanComponent();
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        this.plan.add(t);
        return t;
    }

    public ConditionDefinition addPlan(ConditionDefinitionPlanComponent t) {
        if (t == null) {
            return this;
        }
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        this.plan.add(t);
        return this;
    }

    public ConditionDefinitionPlanComponent getPlanFirstRep() {
        if (this.getPlan().isEmpty()) {
            this.addPlan();
        }
        return this.getPlan().get(0);
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public ConditionDefinition setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public ConditionDefinition setPurpose(String value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public ConditionDefinition setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public ConditionDefinition setCopyright(String value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public int getApprovalDateMax() {
        return 0;
    }

    @Override
    public DateType getApprovalDateElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public boolean hasApprovalDateElement() {
        return false;
    }

    @Override
    public boolean hasApprovalDate() {
        return false;
    }

    @Override
    public ConditionDefinition setApprovalDateElement(DateType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Date getApprovalDate() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public ConditionDefinition setApprovalDate(Date value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public int getLastReviewDateMax() {
        return 0;
    }

    @Override
    public DateType getLastReviewDateElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return false;
    }

    @Override
    public boolean hasLastReviewDate() {
        return false;
    }

    @Override
    public ConditionDefinition setLastReviewDateElement(DateType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Date getLastReviewDate() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public ConditionDefinition setLastReviewDate(Date value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public ConditionDefinition setEffectivePeriod(Period value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the condition definition.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the event definition giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this condition definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the condition definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the condition definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the condition definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the condition definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("code", "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code));
        children.add(new Property("severity", "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity));
        children.add(new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, 1, this.bodySite));
        children.add(new Property("stage", "CodeableConcept", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage));
        children.add(new Property("hasSeverity", "boolean", "Whether Severity is appropriate to collect for this condition.", 0, 1, this.hasSeverity));
        children.add(new Property("hasBodySite", "boolean", "Whether bodySite is appropriate to collect for this condition.", 0, 1, this.hasBodySite));
        children.add(new Property("hasStage", "boolean", "Whether stage is appropriate to collect for this condition.", 0, 1, this.hasStage));
        children.add(new Property("definition", "uri", "Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("observation", "", "Observations particularly relevant to this condition.", 0, Integer.MAX_VALUE, this.observation));
        children.add(new Property("medication", "", "Medications particularly relevant for this condition.", 0, Integer.MAX_VALUE, this.medication));
        children.add(new Property("precondition", "", "An observation that suggests that this condition applies.", 0, Integer.MAX_VALUE, this.precondition));
        children.add(new Property("team", "Reference(CareTeam)", "Appropriate team for this condition.", 0, Integer.MAX_VALUE, this.team));
        children.add(new Property("questionnaire", "", "Questionnaire for this condition.", 0, Integer.MAX_VALUE, this.questionnaire));
        children.add(new Property("plan", "", "Plan that is appropriate.", 0, Integer.MAX_VALUE, this.plan));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the condition definition.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the event definition giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this condition definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the condition definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the condition definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the condition definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the condition definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code);
            }
            case 1478300413: {
                return new Property("severity", "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, 1, this.bodySite);
            }
            case 109757182: {
                return new Property("stage", "CodeableConcept", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage);
            }
            case 57790391: {
                return new Property("hasSeverity", "boolean", "Whether Severity is appropriate to collect for this condition.", 0, 1, this.hasSeverity);
            }
            case 282110147: {
                return new Property("hasBodySite", "boolean", "Whether bodySite is appropriate to collect for this condition.", 0, 1, this.hasBodySite);
            }
            case 129749124: {
                return new Property("hasStage", "boolean", "Whether stage is appropriate to collect for this condition.", 0, 1, this.hasStage);
            }
            case -1014418093: {
                return new Property("definition", "uri", "Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.", 0, Integer.MAX_VALUE, this.definition);
            }
            case 122345516: {
                return new Property("observation", "", "Observations particularly relevant to this condition.", 0, Integer.MAX_VALUE, this.observation);
            }
            case 1998965455: {
                return new Property("medication", "", "Medications particularly relevant for this condition.", 0, Integer.MAX_VALUE, this.medication);
            }
            case -650968616: {
                return new Property("precondition", "", "An observation that suggests that this condition applies.", 0, Integer.MAX_VALUE, this.precondition);
            }
            case 3555933: {
                return new Property("team", "Reference(CareTeam)", "Appropriate team for this condition.", 0, Integer.MAX_VALUE, this.team);
            }
            case -1017049693: {
                return new Property("questionnaire", "", "Questionnaire for this condition.", 0, Integer.MAX_VALUE, this.questionnaire);
            }
            case 3443497: {
                return new Property("plan", "", "Plan that is appropriate.", 0, Integer.MAX_VALUE, this.plan);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.code;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.severity;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.bodySite;
                }
                return baseArray;
            }
            case 109757182: {
                Base[] baseArray;
                if (this.stage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.stage;
                }
                return baseArray;
            }
            case 57790391: {
                Base[] baseArray;
                if (this.hasSeverity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.hasSeverity;
                }
                return baseArray;
            }
            case 282110147: {
                Base[] baseArray;
                if (this.hasBodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.hasBodySite;
                }
                return baseArray;
            }
            case 129749124: {
                Base[] baseArray;
                if (this.hasStage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.hasStage;
                }
                return baseArray;
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case 122345516: {
                return this.observation == null ? new Base[]{} : this.observation.toArray(new Base[this.observation.size()]);
            }
            case 1998965455: {
                return this.medication == null ? new Base[]{} : this.medication.toArray(new Base[this.medication.size()]);
            }
            case -650968616: {
                return this.precondition == null ? new Base[]{} : this.precondition.toArray(new Base[this.precondition.size()]);
            }
            case 3555933: {
                return this.team == null ? new Base[]{} : this.team.toArray(new Base[this.team.size()]);
            }
            case -1017049693: {
                return this.questionnaire == null ? new Base[]{} : this.questionnaire.toArray(new Base[this.questionnaire.size()]);
            }
            case 3443497: {
                return this.plan == null ? new Base[]{} : this.plan.toArray(new Base[this.plan.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1478300413: {
                this.severity = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 109757182: {
                this.stage = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 57790391: {
                this.hasSeverity = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 282110147: {
                this.hasBodySite = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 129749124: {
                this.hasStage = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(TypeConvertor.castToUri(value));
                return value;
            }
            case 122345516: {
                this.getObservation().add((ConditionDefinitionObservationComponent)((Object)value));
                return value;
            }
            case 1998965455: {
                this.getMedication().add((ConditionDefinitionMedicationComponent)((Object)value));
                return value;
            }
            case -650968616: {
                this.getPrecondition().add((ConditionDefinitionPreconditionComponent)((Object)value));
                return value;
            }
            case 3555933: {
                this.getTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1017049693: {
                this.getQuestionnaire().add((ConditionDefinitionQuestionnaireComponent)((Object)value));
                return value;
            }
            case 3443497: {
                this.getPlan().add((ConditionDefinitionPlanComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("severity")) {
            this.severity = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("stage")) {
            this.stage = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("hasSeverity")) {
            this.hasSeverity = TypeConvertor.castToBoolean(value);
        } else if (name.equals("hasBodySite")) {
            this.hasBodySite = TypeConvertor.castToBoolean(value);
        } else if (name.equals("hasStage")) {
            this.hasStage = TypeConvertor.castToBoolean(value);
        } else if (name.equals("definition")) {
            this.getDefinition().add(TypeConvertor.castToUri(value));
        } else if (name.equals("observation")) {
            this.getObservation().add((ConditionDefinitionObservationComponent)((Object)value));
        } else if (name.equals("medication")) {
            this.getMedication().add((ConditionDefinitionMedicationComponent)((Object)value));
        } else if (name.equals("precondition")) {
            this.getPrecondition().add((ConditionDefinitionPreconditionComponent)((Object)value));
        } else if (name.equals("team")) {
            this.getTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("questionnaire")) {
            this.getQuestionnaire().add((ConditionDefinitionQuestionnaireComponent)((Object)value));
        } else if (name.equals("plan")) {
            this.getPlan().add((ConditionDefinitionPlanComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 109757182: {
                return this.getStage();
            }
            case 57790391: {
                return this.getHasSeverityElement();
            }
            case 282110147: {
                return this.getHasBodySiteElement();
            }
            case 129749124: {
                return this.getHasStageElement();
            }
            case -1014418093: {
                return this.addDefinitionElement();
            }
            case 122345516: {
                return this.addObservation();
            }
            case 1998965455: {
                return this.addMedication();
            }
            case -650968616: {
                return this.addPrecondition();
            }
            case 3555933: {
                return this.addTeam();
            }
            case -1017049693: {
                return this.addQuestionnaire();
            }
            case 3443497: {
                return this.addPlan();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 109757182: {
                return new String[]{"CodeableConcept"};
            }
            case 57790391: {
                return new String[]{"boolean"};
            }
            case 282110147: {
                return new String[]{"boolean"};
            }
            case 129749124: {
                return new String[]{"boolean"};
            }
            case -1014418093: {
                return new String[]{"uri"};
            }
            case 122345516: {
                return new String[0];
            }
            case 1998965455: {
                return new String[0];
            }
            case -650968616: {
                return new String[0];
            }
            case 3555933: {
                return new String[]{"Reference"};
            }
            case -1017049693: {
                return new String[0];
            }
            case 3443497: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("severity")) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("stage")) {
            this.stage = new CodeableConcept();
            return this.stage;
        }
        if (name.equals("hasSeverity")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.hasSeverity");
        }
        if (name.equals("hasBodySite")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.hasBodySite");
        }
        if (name.equals("hasStage")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.hasStage");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.definition");
        }
        if (name.equals("observation")) {
            return this.addObservation();
        }
        if (name.equals("medication")) {
            return this.addMedication();
        }
        if (name.equals("precondition")) {
            return this.addPrecondition();
        }
        if (name.equals("team")) {
            return this.addTeam();
        }
        if (name.equals("questionnaire")) {
            return this.addQuestionnaire();
        }
        if (name.equals("plan")) {
            return this.addPlan();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConditionDefinition";
    }

    @Override
    public ConditionDefinition copy() {
        ConditionDefinition dst = new ConditionDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ConditionDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.stage = this.stage == null ? null : this.stage.copy();
        dst.hasSeverity = this.hasSeverity == null ? null : this.hasSeverity.copy();
        dst.hasBodySite = this.hasBodySite == null ? null : this.hasBodySite.copy();
        BooleanType booleanType = dst.hasStage = this.hasStage == null ? null : this.hasStage.copy();
        if (this.definition != null) {
            dst.definition = new ArrayList<UriType>();
            for (UriType uriType2 : this.definition) {
                dst.definition.add(uriType2.copy());
            }
        }
        if (this.observation != null) {
            dst.observation = new ArrayList<ConditionDefinitionObservationComponent>();
            for (ConditionDefinitionObservationComponent conditionDefinitionObservationComponent : this.observation) {
                dst.observation.add(conditionDefinitionObservationComponent.copy());
            }
        }
        if (this.medication != null) {
            dst.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
            for (ConditionDefinitionMedicationComponent conditionDefinitionMedicationComponent : this.medication) {
                dst.medication.add(conditionDefinitionMedicationComponent.copy());
            }
        }
        if (this.precondition != null) {
            dst.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
            for (ConditionDefinitionPreconditionComponent conditionDefinitionPreconditionComponent : this.precondition) {
                dst.precondition.add(conditionDefinitionPreconditionComponent.copy());
            }
        }
        if (this.team != null) {
            dst.team = new ArrayList<Reference>();
            for (Reference reference : this.team) {
                dst.team.add(reference.copy());
            }
        }
        if (this.questionnaire != null) {
            dst.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
            for (ConditionDefinitionQuestionnaireComponent conditionDefinitionQuestionnaireComponent : this.questionnaire) {
                dst.questionnaire.add(conditionDefinitionQuestionnaireComponent.copy());
            }
        }
        if (this.plan != null) {
            dst.plan = new ArrayList<ConditionDefinitionPlanComponent>();
            for (ConditionDefinitionPlanComponent conditionDefinitionPlanComponent : this.plan) {
                dst.plan.add(conditionDefinitionPlanComponent.copy());
            }
        }
    }

    protected ConditionDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConditionDefinition)) {
            return false;
        }
        ConditionDefinition o = (ConditionDefinition)other_;
        return ConditionDefinition.compareDeep(this.url, o.url, true) && ConditionDefinition.compareDeep(this.identifier, o.identifier, true) && ConditionDefinition.compareDeep(this.version, o.version, true) && ConditionDefinition.compareDeep(this.name, o.name, true) && ConditionDefinition.compareDeep(this.title, o.title, true) && ConditionDefinition.compareDeep(this.subtitle, o.subtitle, true) && ConditionDefinition.compareDeep(this.status, o.status, true) && ConditionDefinition.compareDeep(this.experimental, o.experimental, true) && ConditionDefinition.compareDeep(this.date, o.date, true) && ConditionDefinition.compareDeep(this.publisher, o.publisher, true) && ConditionDefinition.compareDeep(this.contact, o.contact, true) && ConditionDefinition.compareDeep(this.description, o.description, true) && ConditionDefinition.compareDeep(this.useContext, o.useContext, true) && ConditionDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && ConditionDefinition.compareDeep(this.code, o.code, true) && ConditionDefinition.compareDeep(this.severity, o.severity, true) && ConditionDefinition.compareDeep(this.bodySite, o.bodySite, true) && ConditionDefinition.compareDeep(this.stage, o.stage, true) && ConditionDefinition.compareDeep(this.hasSeverity, o.hasSeverity, true) && ConditionDefinition.compareDeep(this.hasBodySite, o.hasBodySite, true) && ConditionDefinition.compareDeep(this.hasStage, o.hasStage, true) && ConditionDefinition.compareDeep(this.definition, o.definition, true) && ConditionDefinition.compareDeep(this.observation, o.observation, true) && ConditionDefinition.compareDeep(this.medication, o.medication, true) && ConditionDefinition.compareDeep(this.precondition, o.precondition, true) && ConditionDefinition.compareDeep(this.team, o.team, true) && ConditionDefinition.compareDeep(this.questionnaire, o.questionnaire, true) && ConditionDefinition.compareDeep(this.plan, o.plan, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConditionDefinition)) {
            return false;
        }
        ConditionDefinition o = (ConditionDefinition)other_;
        return ConditionDefinition.compareValues(this.url, o.url, true) && ConditionDefinition.compareValues(this.version, o.version, true) && ConditionDefinition.compareValues(this.name, o.name, true) && ConditionDefinition.compareValues(this.title, o.title, true) && ConditionDefinition.compareValues(this.subtitle, o.subtitle, true) && ConditionDefinition.compareValues(this.status, o.status, true) && ConditionDefinition.compareValues(this.experimental, o.experimental, true) && ConditionDefinition.compareValues(this.date, o.date, true) && ConditionDefinition.compareValues(this.publisher, o.publisher, true) && ConditionDefinition.compareValues(this.description, o.description, true) && ConditionDefinition.compareValues(this.hasSeverity, o.hasSeverity, true) && ConditionDefinition.compareValues(this.hasBodySite, o.hasBodySite, true) && ConditionDefinition.compareValues(this.hasStage, o.hasStage, true) && ConditionDefinition.compareValues(this.definition, o.definition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.code, this.severity, this.bodySite, this.stage, this.hasSeverity, this.hasBodySite, this.hasStage, this.definition, this.observation, this.medication, this.precondition, this.team, this.questionnaire, this.plan});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConditionDefinition;
    }

    @Block
    public static class ConditionDefinitionPlanComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Use for the plan", formalDefinition="Use for the plan.")
        protected CodeableConcept role;
        @Child(name="reference", type={PlanDefinition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual plan", formalDefinition="The actual plan.")
        protected Reference reference;
        private static final long serialVersionUID = -1992921787L;

        public ConditionDefinitionPlanComponent() {
        }

        public ConditionDefinitionPlanComponent(Reference reference) {
            this.setReference(reference);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPlanComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ConditionDefinitionPlanComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPlanComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConditionDefinitionPlanComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Use for the plan.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(PlanDefinition)", "The actual plan.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Use for the plan.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(PlanDefinition)", "The actual plan.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionPlanComponent copy() {
            ConditionDefinitionPlanComponent dst = new ConditionDefinitionPlanComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionPlanComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPlanComponent)) {
                return false;
            }
            ConditionDefinitionPlanComponent o = (ConditionDefinitionPlanComponent)other_;
            return ConditionDefinitionPlanComponent.compareDeep(this.role, o.role, true) && ConditionDefinitionPlanComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPlanComponent)) {
                return false;
            }
            ConditionDefinitionPlanComponent o = (ConditionDefinitionPlanComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.plan";
        }
    }

    @Block
    public static class ConditionDefinitionQuestionnaireComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="preadmit | diff-diagnosis | outcome", formalDefinition="Use of the questionnaire.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-questionnaire-purpose")
        protected Enumeration<ConditionQuestionnairePurpose> purpose;
        @Child(name="reference", type={Questionnaire.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific Questionnaire", formalDefinition="Specific Questionnaire.")
        protected Reference reference;
        private static final long serialVersionUID = -1791379681L;

        public ConditionDefinitionQuestionnaireComponent() {
        }

        public ConditionDefinitionQuestionnaireComponent(ConditionQuestionnairePurpose purpose, Reference reference) {
            this.setPurpose(purpose);
            this.setReference(reference);
        }

        public Enumeration<ConditionQuestionnairePurpose> getPurposeElement() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionQuestionnaireComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new Enumeration<ConditionQuestionnairePurpose>(new ConditionQuestionnairePurposeEnumFactory());
                }
            }
            return this.purpose;
        }

        public boolean hasPurposeElement() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public ConditionDefinitionQuestionnaireComponent setPurposeElement(Enumeration<ConditionQuestionnairePurpose> value) {
            this.purpose = value;
            return this;
        }

        public ConditionQuestionnairePurpose getPurpose() {
            return this.purpose == null ? null : (ConditionQuestionnairePurpose)((Object)this.purpose.getValue());
        }

        public ConditionDefinitionQuestionnaireComponent setPurpose(ConditionQuestionnairePurpose value) {
            if (this.purpose == null) {
                this.purpose = new Enumeration<ConditionQuestionnairePurpose>(new ConditionQuestionnairePurposeEnumFactory());
            }
            this.purpose.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionQuestionnaireComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConditionDefinitionQuestionnaireComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("purpose", "code", "Use of the questionnaire.", 0, 1, this.purpose));
            children.add(new Property("reference", "Reference(Questionnaire)", "Specific Questionnaire.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -220463842: {
                    return new Property("purpose", "code", "Use of the questionnaire.", 0, 1, this.purpose);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Questionnaire)", "Specific Questionnaire.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    Base[] baseArray;
                    if (this.purpose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.purpose;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    value = new ConditionQuestionnairePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.purpose = value;
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                value = new ConditionQuestionnairePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.purpose = value;
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return this.getPurposeElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.questionnaire.purpose");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionQuestionnaireComponent copy() {
            ConditionDefinitionQuestionnaireComponent dst = new ConditionDefinitionQuestionnaireComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionQuestionnaireComponent dst) {
            super.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionQuestionnaireComponent)) {
                return false;
            }
            ConditionDefinitionQuestionnaireComponent o = (ConditionDefinitionQuestionnaireComponent)other_;
            return ConditionDefinitionQuestionnaireComponent.compareDeep(this.purpose, o.purpose, true) && ConditionDefinitionQuestionnaireComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionQuestionnaireComponent)) {
                return false;
            }
            ConditionDefinitionQuestionnaireComponent o = (ConditionDefinitionQuestionnaireComponent)other_;
            return ConditionDefinitionQuestionnaireComponent.compareValues(this.purpose, o.purpose, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.purpose, this.reference});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.questionnaire";
        }
    }

    @Block
    public static class ConditionDefinitionPreconditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="sensitive | specific", formalDefinition="Kind of pre-condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-precondition-type")
        protected Enumeration<ConditionPreconditionType> type;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Observation", formalDefinition="Code for relevant Observation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of Observation", formalDefinition="Value of Observation.")
        protected DataType value;
        private static final long serialVersionUID = -1210333235L;

        public ConditionDefinitionPreconditionComponent() {
        }

        public ConditionDefinitionPreconditionComponent(ConditionPreconditionType type, CodeableConcept code) {
            this.setType(type);
            this.setCode(code);
        }

        public Enumeration<ConditionPreconditionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPreconditionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConditionPreconditionType>(new ConditionPreconditionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setTypeElement(Enumeration<ConditionPreconditionType> value) {
            this.type = value;
            return this;
        }

        public ConditionPreconditionType getType() {
            return this.type == null ? null : (ConditionPreconditionType)((Object)this.type.getValue());
        }

        public ConditionDefinitionPreconditionComponent setType(ConditionPreconditionType value) {
            if (this.type == null) {
                this.type = new Enumeration<ConditionPreconditionType>(new ConditionPreconditionTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPreconditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setValue(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for ConditionDefinition.precondition.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Kind of pre-condition.", 0, 1, this.type));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code));
            children.add(new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Kind of pre-condition.", 0, 1, this.type);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Value of Observation.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Value of Observation.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ConditionPreconditionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConditionPreconditionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConditionDefinition.precondition.type");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionPreconditionComponent copy() {
            ConditionDefinitionPreconditionComponent dst = new ConditionDefinitionPreconditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionPreconditionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPreconditionComponent)) {
                return false;
            }
            ConditionDefinitionPreconditionComponent o = (ConditionDefinitionPreconditionComponent)other_;
            return ConditionDefinitionPreconditionComponent.compareDeep(this.type, o.type, true) && ConditionDefinitionPreconditionComponent.compareDeep(this.code, o.code, true) && ConditionDefinitionPreconditionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPreconditionComponent)) {
                return false;
            }
            ConditionDefinitionPreconditionComponent o = (ConditionDefinitionPreconditionComponent)other_;
            return ConditionDefinitionPreconditionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.precondition";
        }
    }

    @Block
    public static class ConditionDefinitionMedicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category that is relevant", formalDefinition="Category that is relevant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationrequest-category")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Medication", formalDefinition="Code for relevant Medication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1433986479L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionMedicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ConditionDefinitionMedicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionMedicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionMedicationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Medication.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Medication.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionMedicationComponent copy() {
            ConditionDefinitionMedicationComponent dst = new ConditionDefinitionMedicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionMedicationComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionMedicationComponent)) {
                return false;
            }
            ConditionDefinitionMedicationComponent o = (ConditionDefinitionMedicationComponent)other_;
            return ConditionDefinitionMedicationComponent.compareDeep(this.category, o.category, true) && ConditionDefinitionMedicationComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionMedicationComponent)) {
                return false;
            }
            ConditionDefinitionMedicationComponent o = (ConditionDefinitionMedicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.code});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.medication";
        }
    }

    @Block
    public static class ConditionDefinitionObservationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category that is relevant", formalDefinition="Category that is relevant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Observation", formalDefinition="Code for relevant Observation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1433986479L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionObservationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ConditionDefinitionObservationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionObservationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionObservationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionObservationComponent copy() {
            ConditionDefinitionObservationComponent dst = new ConditionDefinitionObservationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionObservationComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionObservationComponent)) {
                return false;
            }
            ConditionDefinitionObservationComponent o = (ConditionDefinitionObservationComponent)other_;
            return ConditionDefinitionObservationComponent.compareDeep(this.category, o.category, true) && ConditionDefinitionObservationComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionObservationComponent)) {
                return false;
            }
            ConditionDefinitionObservationComponent o = (ConditionDefinitionObservationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.code});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.observation";
        }
    }

    public static class ConditionQuestionnairePurposeEnumFactory
    implements EnumFactory<ConditionQuestionnairePurpose> {
        @Override
        public ConditionQuestionnairePurpose fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preadmit".equals(codeString)) {
                return ConditionQuestionnairePurpose.PREADMIT;
            }
            if ("diff-diagnosis".equals(codeString)) {
                return ConditionQuestionnairePurpose.DIFFDIAGNOSIS;
            }
            if ("outcome".equals(codeString)) {
                return ConditionQuestionnairePurpose.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        public Enumeration<ConditionQuestionnairePurpose> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionQuestionnairePurpose>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preadmit".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.PREADMIT);
            }
            if ("diff-diagnosis".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.DIFFDIAGNOSIS);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.OUTCOME);
            }
            throw new FHIRException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionQuestionnairePurpose code) {
            if (code == ConditionQuestionnairePurpose.PREADMIT) {
                return "preadmit";
            }
            if (code == ConditionQuestionnairePurpose.DIFFDIAGNOSIS) {
                return "diff-diagnosis";
            }
            if (code == ConditionQuestionnairePurpose.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionQuestionnairePurpose code) {
            return code.getSystem();
        }
    }

    public static enum ConditionQuestionnairePurpose {
        PREADMIT,
        DIFFDIAGNOSIS,
        OUTCOME,
        NULL;


        public static ConditionQuestionnairePurpose fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preadmit".equals(codeString)) {
                return PREADMIT;
            }
            if ("diff-diagnosis".equals(codeString)) {
                return DIFFDIAGNOSIS;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREADMIT: {
                    return "preadmit";
                }
                case DIFFDIAGNOSIS: {
                    return "diff-diagnosis";
                }
                case OUTCOME: {
                    return "outcome";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREADMIT: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
                case DIFFDIAGNOSIS: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREADMIT: {
                    return "A pre-admit questionnaire.";
                }
                case DIFFDIAGNOSIS: {
                    return "A questionnaire that helps with diferential diagnosis.";
                }
                case OUTCOME: {
                    return "A questionnaire to check on outcomes for the patient.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREADMIT: {
                    return "Pre-admit";
                }
                case DIFFDIAGNOSIS: {
                    return "Diff Diagnosis";
                }
                case OUTCOME: {
                    return "Outcome";
                }
            }
            return "?";
        }
    }

    public static class ConditionPreconditionTypeEnumFactory
    implements EnumFactory<ConditionPreconditionType> {
        @Override
        public ConditionPreconditionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sensitive".equals(codeString)) {
                return ConditionPreconditionType.SENSITIVE;
            }
            if ("specific".equals(codeString)) {
                return ConditionPreconditionType.SPECIFIC;
            }
            throw new IllegalArgumentException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        public Enumeration<ConditionPreconditionType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionPreconditionType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sensitive".equals(codeString)) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.SENSITIVE);
            }
            if ("specific".equals(codeString)) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.SPECIFIC);
            }
            throw new FHIRException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionPreconditionType code) {
            if (code == ConditionPreconditionType.SENSITIVE) {
                return "sensitive";
            }
            if (code == ConditionPreconditionType.SPECIFIC) {
                return "specific";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionPreconditionType code) {
            return code.getSystem();
        }
    }

    public static enum ConditionPreconditionType {
        SENSITIVE,
        SPECIFIC,
        NULL;


        public static ConditionPreconditionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sensitive".equals(codeString)) {
                return SENSITIVE;
            }
            if ("specific".equals(codeString)) {
                return SPECIFIC;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENSITIVE: {
                    return "sensitive";
                }
                case SPECIFIC: {
                    return "specific";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENSITIVE: {
                    return "http://hl7.org/fhir/condition-precondition-type";
                }
                case SPECIFIC: {
                    return "http://hl7.org/fhir/condition-precondition-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENSITIVE: {
                    return "The observation is very sensitive for the condition, but may also indicate other conditions.";
                }
                case SPECIFIC: {
                    return "The observation is very specific for this condition, but not particularly sensitive.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENSITIVE: {
                    return "Sensitive";
                }
                case SPECIFIC: {
                    return "Specific";
                }
            }
            return "?";
        }
    }
}

