/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EvidenceReport", profile="http://hl7.org/fhir/StructureDefinition/EvidenceReport")
public class EvidenceReport
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this EvidenceReport, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this EvidenceReport when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="useContext", type={UsageContext.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence report instances.")
    protected List<UsageContext> useContext;
    @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="May include DOI, PMID, PMCID, etc.", formalDefinition="A formal identifier that is used to identify this EvidenceReport when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="relatedIdentifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="May include trial registry identifiers", formalDefinition="A formal identifier that is used to identify things closely related to this EvidenceReport.")
    protected List<Identifier> relatedIdentifier;
    @Child(name="citeAs", type={Citation.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Citation for this report", formalDefinition="Citation Resource or display of suggested citation for this report.")
    protected Reference citeAs;
    @Child(name="type", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Kind of report", formalDefinition="Specifies the kind of report, such as grouping of classifiers, search results, or human-compiled expression.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-report-type")
    protected CodeableConcept type;
    @Child(name="note", type={Annotation.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes and annotations", formalDefinition="Used for footnotes and annotations.")
    protected List<Annotation> note;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link, description or reference to artifact associated with the report", formalDefinition="Link, description or reference to artifact associated with the report.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="subject", type={}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of the report", formalDefinition="Specifies the subject or focus of the report. Answers \"What is this report about?\".")
    protected EvidenceReportSubjectComponent subject;
    @Child(name="publisher", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the evidence report.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="author", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual, organization, or device primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individiual, organization, or device primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individiual, organization, or device primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individiual, organization, or device responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatesTo", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Relationships to other compositions/documents", formalDefinition="Relationships that this composition has with other compositions or documents that already exist.")
    protected List<EvidenceReportRelatesToComponent> relatesTo;
    @Child(name="section", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Composition is broken into sections", formalDefinition="The root of the sections that make up the composition.")
    protected List<SectionComponent> section;
    private static final long serialVersionUID = 867867967L;
    @SearchParamDefinition(name="context-quantity", path="(EvidenceReport.useContext.value as Quantity) | (EvidenceReport.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the evidence report", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="EvidenceReport.useContext", description="A use context type and quantity- or range-based value assigned to the evidence report", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="EvidenceReport.useContext", description="A use context type and value assigned to the evidence report", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="EvidenceReport.useContext.code", description="A type of use context assigned to the evidence report", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(EvidenceReport.useContext.value as CodeableConcept)", description="A use context assigned to the evidence report", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="identifier", path="EvidenceReport.identifier", description="External identifier for the evidence report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="publisher", path="EvidenceReport.publisher", description="Name of the publisher of the evidence report", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="EvidenceReport.status", description="The current status of the evidence report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="EvidenceReport.url", description="The uri that identifies the evidence report", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public EvidenceReport() {
    }

    public EvidenceReport(Enumerations.PublicationStatus status, EvidenceReportSubjectComponent subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public EvidenceReport setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public EvidenceReport setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public EvidenceReport setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public EvidenceReport setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public EvidenceReport setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public EvidenceReport addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public EvidenceReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public EvidenceReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Identifier> getRelatedIdentifier() {
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        return this.relatedIdentifier;
    }

    public EvidenceReport setRelatedIdentifier(List<Identifier> theRelatedIdentifier) {
        this.relatedIdentifier = theRelatedIdentifier;
        return this;
    }

    public boolean hasRelatedIdentifier() {
        if (this.relatedIdentifier == null) {
            return false;
        }
        for (Identifier item : this.relatedIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addRelatedIdentifier() {
        Identifier t = new Identifier();
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        this.relatedIdentifier.add(t);
        return t;
    }

    public EvidenceReport addRelatedIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        this.relatedIdentifier.add(t);
        return this;
    }

    public Identifier getRelatedIdentifierFirstRep() {
        if (this.getRelatedIdentifier().isEmpty()) {
            this.addRelatedIdentifier();
        }
        return this.getRelatedIdentifier().get(0);
    }

    public Reference getCiteAs() {
        if (this.citeAs == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.citeAs");
            }
            if (Configuration.doAutoCreate()) {
                this.citeAs = new Reference();
            }
        }
        return this.citeAs;
    }

    public boolean hasCiteAs() {
        return this.citeAs != null && !this.citeAs.isEmpty();
    }

    public EvidenceReport setCiteAs(Reference value) {
        this.citeAs = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public EvidenceReport setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public EvidenceReport setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public EvidenceReport addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public EvidenceReport setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public EvidenceReport addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public EvidenceReportSubjectComponent getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new EvidenceReportSubjectComponent();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public EvidenceReport setSubject(EvidenceReportSubjectComponent value) {
        this.subject = value;
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceReport.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public EvidenceReport setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public EvidenceReport setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public EvidenceReport setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public EvidenceReport addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public EvidenceReport setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public EvidenceReport addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public EvidenceReport setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public EvidenceReport addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public EvidenceReport setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public EvidenceReport addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public EvidenceReport setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public EvidenceReport addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<EvidenceReportRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<EvidenceReportRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public EvidenceReport setRelatesTo(List<EvidenceReportRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (EvidenceReportRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceReportRelatesToComponent addRelatesTo() {
        EvidenceReportRelatesToComponent t = new EvidenceReportRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<EvidenceReportRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public EvidenceReport addRelatesTo(EvidenceReportRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<EvidenceReportRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public EvidenceReportRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public List<SectionComponent> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        return this.section;
    }

    public EvidenceReport setSection(List<SectionComponent> theSection) {
        this.section = theSection;
        return this;
    }

    public boolean hasSection() {
        if (this.section == null) {
            return false;
        }
        for (SectionComponent item : this.section) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SectionComponent addSection() {
        SectionComponent t = new SectionComponent();
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return t;
    }

    public EvidenceReport addSection(SectionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return this;
    }

    public SectionComponent getSectionFirstRep() {
        if (this.getSection().isEmpty()) {
            this.addSection();
        }
        return this.getSection().get(0);
    }

    @Override
    public int getVersionMax() {
        return 0;
    }

    @Override
    public StringType getVersionElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"version\"");
    }

    @Override
    public boolean hasVersionElement() {
        return false;
    }

    @Override
    public boolean hasVersion() {
        return false;
    }

    @Override
    public EvidenceReport setVersionElement(StringType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"version\"");
    }

    @Override
    public String getVersion() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"version\"");
    }

    @Override
    public EvidenceReport setVersion(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"version\"");
    }

    @Override
    public int getNameMax() {
        return 0;
    }

    @Override
    public StringType getNameElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"name\"");
    }

    @Override
    public boolean hasNameElement() {
        return false;
    }

    @Override
    public boolean hasName() {
        return false;
    }

    @Override
    public EvidenceReport setNameElement(StringType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"name\"");
    }

    @Override
    public String getName() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"name\"");
    }

    @Override
    public EvidenceReport setName(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"name\"");
    }

    @Override
    public int getTitleMax() {
        return 0;
    }

    @Override
    public StringType getTitleElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"title\"");
    }

    @Override
    public boolean hasTitleElement() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public EvidenceReport setTitleElement(StringType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"title\"");
    }

    @Override
    public String getTitle() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"title\"");
    }

    @Override
    public EvidenceReport setTitle(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"title\"");
    }

    @Override
    public int getExperimentalMax() {
        return 0;
    }

    @Override
    public BooleanType getExperimentalElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean hasExperimentalElement() {
        return false;
    }

    @Override
    public boolean hasExperimental() {
        return false;
    }

    @Override
    public EvidenceReport setExperimentalElement(BooleanType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean getExperimental() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"experimental\"");
    }

    @Override
    public EvidenceReport setExperimental(boolean value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"experimental\"");
    }

    @Override
    public int getDateMax() {
        return 0;
    }

    @Override
    public DateTimeType getDateElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"date\"");
    }

    @Override
    public boolean hasDateElement() {
        return false;
    }

    @Override
    public boolean hasDate() {
        return false;
    }

    @Override
    public EvidenceReport setDateElement(DateTimeType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"date\"");
    }

    @Override
    public Date getDate() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"date\"");
    }

    @Override
    public EvidenceReport setDate(Date value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"date\"");
    }

    @Override
    public int getDescriptionMax() {
        return 0;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"description\"");
    }

    @Override
    public boolean hasDescriptionElement() {
        return false;
    }

    @Override
    public boolean hasDescription() {
        return false;
    }

    @Override
    public EvidenceReport setDescriptionElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"description\"");
    }

    @Override
    public String getDescription() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"description\"");
    }

    @Override
    public EvidenceReport setDescription(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"description\"");
    }

    @Override
    public int getJurisdictionMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public EvidenceReport setJurisdiction(List<CodeableConcept> theJurisdiction) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public boolean hasJurisdiction() {
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public EvidenceReport addJurisdiction(CodeableConcept t) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public EvidenceReport setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"purpose\"");
    }

    @Override
    public EvidenceReport setPurpose(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"purpose\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public EvidenceReport setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"copyright\"");
    }

    @Override
    public EvidenceReport setCopyright(String value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"copyright\"");
    }

    @Override
    public int getApprovalDateMax() {
        return 0;
    }

    @Override
    public DateType getApprovalDateElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"approvalDate\"");
    }

    @Override
    public boolean hasApprovalDateElement() {
        return false;
    }

    @Override
    public boolean hasApprovalDate() {
        return false;
    }

    @Override
    public EvidenceReport setApprovalDateElement(DateType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Date getApprovalDate() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"approvalDate\"");
    }

    @Override
    public EvidenceReport setApprovalDate(Date value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"approvalDate\"");
    }

    @Override
    public int getLastReviewDateMax() {
        return 0;
    }

    @Override
    public DateType getLastReviewDateElement() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return false;
    }

    @Override
    public boolean hasLastReviewDate() {
        return false;
    }

    @Override
    public EvidenceReport setLastReviewDateElement(DateType value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Date getLastReviewDate() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public EvidenceReport setLastReviewDate(Date value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public EvidenceReport setEffectivePeriod(Period value) {
        throw new Error("The resource type \"EvidenceReport\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this EvidenceReport when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence report instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this EvidenceReport when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to this EvidenceReport.", 0, Integer.MAX_VALUE, this.relatedIdentifier));
        children.add(new Property("citeAs", "Reference(Citation)", "Citation Resource or display of suggested citation for this report.", 0, 1, this.citeAs));
        children.add(new Property("type", "CodeableConcept", "Specifies the kind of report, such as grouping of classifiers, search results, or human-compiled expression.", 0, 1, this.type));
        children.add(new Property("note", "Annotation", "Used for footnotes and annotations.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Link, description or reference to artifact associated with the report.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("subject", "", "Specifies the subject or focus of the report. Answers \"What is this report about?\".", 0, 1, this.subject));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the evidence report.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("author", "ContactDetail", "An individiual, organization, or device primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individiual, organization, or device primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individiual, organization, or device primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individiual, organization, or device responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatesTo", "", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property("section", "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this EvidenceReport when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence report instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this EvidenceReport when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1007604940: {
                return new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to this EvidenceReport.", 0, Integer.MAX_VALUE, this.relatedIdentifier);
            }
            case -1360156695: {
                return new Property("citeAs", "Reference(Citation)", "Citation Resource or display of suggested citation for this report.", 0, 1, this.citeAs);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Specifies the kind of report, such as grouping of classifiers, search results, or human-compiled expression.", 0, 1, this.type);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Used for footnotes and annotations.", 0, Integer.MAX_VALUE, this.note);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Link, description or reference to artifact associated with the report.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -1867885268: {
                return new Property("subject", "", "Specifies the subject or focus of the report. Answers \"What is this report about?\".", 0, 1, this.subject);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the evidence report.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual, organization, or device primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individiual, organization, or device primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individiual, organization, or device primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individiual, organization, or device responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case 1970241253: {
                return new Property("section", "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1007604940: {
                return this.relatedIdentifier == null ? new Base[]{} : this.relatedIdentifier.toArray(new Base[this.relatedIdentifier.size()]);
            }
            case -1360156695: {
                Base[] baseArray;
                if (this.citeAs == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.citeAs;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case 1970241253: {
                return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1007604940: {
                this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1360156695: {
                this.citeAs = TypeConvertor.castToReference(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case -1867885268: {
                this.subject = (EvidenceReportSubjectComponent)((Object)value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((EvidenceReportRelatesToComponent)((Object)value));
                return value;
            }
            case 1970241253: {
                this.getSection().add((SectionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("relatedIdentifier")) {
            this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("citeAs")) {
            this.citeAs = TypeConvertor.castToReference(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("subject")) {
            this.subject = (EvidenceReportSubjectComponent)((Object)value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((EvidenceReportRelatesToComponent)((Object)value));
        } else if (name.equals("section")) {
            this.getSection().add((SectionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1007604940: {
                return this.addRelatedIdentifier();
            }
            case -1360156695: {
                return this.getCiteAs();
            }
            case 3575610: {
                return this.getType();
            }
            case 3387378: {
                return this.addNote();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case 1970241253: {
                return this.addSection();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1007604940: {
                return new String[]{"Identifier"};
            }
            case -1360156695: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -1867885268: {
                return new String[0];
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case -7765931: {
                return new String[0];
            }
            case 1970241253: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.url");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.status");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("relatedIdentifier")) {
            return this.addRelatedIdentifier();
        }
        if (name.equals("citeAs")) {
            this.citeAs = new Reference();
            return this.citeAs;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("subject")) {
            this.subject = new EvidenceReportSubjectComponent();
            return this.subject;
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals("section")) {
            return this.addSection();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EvidenceReport";
    }

    @Override
    public EvidenceReport copy() {
        EvidenceReport dst = new EvidenceReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EvidenceReport dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.relatedIdentifier != null) {
            dst.relatedIdentifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.relatedIdentifier) {
                dst.relatedIdentifier.add(identifier.copy());
            }
        }
        dst.citeAs = this.citeAs == null ? null : this.citeAs.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<EvidenceReportRelatesToComponent>();
            for (EvidenceReportRelatesToComponent evidenceReportRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(evidenceReportRelatesToComponent.copy());
            }
        }
        if (this.section != null) {
            dst.section = new ArrayList<SectionComponent>();
            for (SectionComponent sectionComponent : this.section) {
                dst.section.add(sectionComponent.copy());
            }
        }
    }

    protected EvidenceReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceReport)) {
            return false;
        }
        EvidenceReport o = (EvidenceReport)other_;
        return EvidenceReport.compareDeep(this.url, o.url, true) && EvidenceReport.compareDeep(this.status, o.status, true) && EvidenceReport.compareDeep(this.useContext, o.useContext, true) && EvidenceReport.compareDeep(this.identifier, o.identifier, true) && EvidenceReport.compareDeep(this.relatedIdentifier, o.relatedIdentifier, true) && EvidenceReport.compareDeep(this.citeAs, o.citeAs, true) && EvidenceReport.compareDeep(this.type, o.type, true) && EvidenceReport.compareDeep(this.note, o.note, true) && EvidenceReport.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && EvidenceReport.compareDeep(this.subject, o.subject, true) && EvidenceReport.compareDeep(this.publisher, o.publisher, true) && EvidenceReport.compareDeep(this.contact, o.contact, true) && EvidenceReport.compareDeep(this.author, o.author, true) && EvidenceReport.compareDeep(this.editor, o.editor, true) && EvidenceReport.compareDeep(this.reviewer, o.reviewer, true) && EvidenceReport.compareDeep(this.endorser, o.endorser, true) && EvidenceReport.compareDeep(this.relatesTo, o.relatesTo, true) && EvidenceReport.compareDeep(this.section, o.section, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceReport)) {
            return false;
        }
        EvidenceReport o = (EvidenceReport)other_;
        return EvidenceReport.compareValues(this.url, o.url, true) && EvidenceReport.compareValues(this.status, o.status, true) && EvidenceReport.compareValues(this.publisher, o.publisher, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.status, this.useContext, this.identifier, this.relatedIdentifier, this.citeAs, this.type, this.note, this.relatedArtifact, this.subject, this.publisher, this.contact, this.author, this.editor, this.reviewer, this.endorser, this.relatesTo, this.section});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EvidenceReport;
    }

    @Block
    public static class SectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for section (e.g. for ToC)", formalDefinition="The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.")
        protected StringType title;
        @Child(name="focus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of section (recommended)", formalDefinition="A code identifying the kind of content contained within the section. This should be consistent with the section title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-report-section")
        protected CodeableConcept focus;
        @Child(name="focusReference", type={Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of section by Resource", formalDefinition="A definitional Resource identifying the kind of content contained within the section. This should be consistent with the section title.")
        protected Reference focusReference;
        @Child(name="author", type={Person.class, Device.class, Group.class, Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who and/or what authored the section", formalDefinition="Identifies who is responsible for the information in this section, not necessarily who typed it in.")
        protected List<Reference> author;
        @Child(name="text", type={Narrative.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text summary of the section, for human interpretation", formalDefinition="A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is peferred to contain sufficient detail to make it acceptable for a human to just read the narrative.")
        protected Narrative text;
        @Child(name="mode", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="working | snapshot | changes", formalDefinition="How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
        protected Enumeration<Enumerations.ListMode> mode;
        @Child(name="orderedBy", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Order of section entries", formalDefinition="Specifies the order applied to the items in the section entries.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
        protected CodeableConcept orderedBy;
        @Child(name="entryClassifier", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Extensible classifiers", formalDefinition="Specifies any type of classification of the evidence report.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-classifier-code")
        protected List<CodeableConcept> entryClassifier;
        @Child(name="entryReference", type={Reference.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to data that supports this section", formalDefinition="A reference to the actual resource from which the narrative in the section is derived.")
        protected List<Reference> entryReference;
        @Child(name="emptyReason", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the section is empty", formalDefinition="If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        protected CodeableConcept emptyReason;
        @Child(name="section", type={SectionComponent.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Section", formalDefinition="A nested sub-section within this section.")
        protected List<SectionComponent> section;
        private static final long serialVersionUID = -354142458L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public SectionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public SectionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public CodeableConcept getFocus() {
            if (this.focus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.focus");
                }
                if (Configuration.doAutoCreate()) {
                    this.focus = new CodeableConcept();
                }
            }
            return this.focus;
        }

        public boolean hasFocus() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public SectionComponent setFocus(CodeableConcept value) {
            this.focus = value;
            return this;
        }

        public Reference getFocusReference() {
            if (this.focusReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.focusReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.focusReference = new Reference();
                }
            }
            return this.focusReference;
        }

        public boolean hasFocusReference() {
            return this.focusReference != null && !this.focusReference.isEmpty();
        }

        public SectionComponent setFocusReference(Reference value) {
            this.focusReference = value;
            return this;
        }

        public List<Reference> getAuthor() {
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            return this.author;
        }

        public SectionComponent setAuthor(List<Reference> theAuthor) {
            this.author = theAuthor;
            return this;
        }

        public boolean hasAuthor() {
            if (this.author == null) {
                return false;
            }
            for (Reference item : this.author) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAuthor() {
            Reference t = new Reference();
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            this.author.add(t);
            return t;
        }

        public SectionComponent addAuthor(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            this.author.add(t);
            return this;
        }

        public Reference getAuthorFirstRep() {
            if (this.getAuthor().isEmpty()) {
                this.addAuthor();
            }
            return this.getAuthor().get(0);
        }

        public Narrative getText() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new Narrative();
                }
            }
            return this.text;
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public SectionComponent setText(Narrative value) {
            this.text = value;
            return this;
        }

        public Enumeration<Enumerations.ListMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public SectionComponent setModeElement(Enumeration<Enumerations.ListMode> value) {
            this.mode = value;
            return this;
        }

        public Enumerations.ListMode getMode() {
            return this.mode == null ? null : (Enumerations.ListMode)((Object)this.mode.getValue());
        }

        public SectionComponent setMode(Enumerations.ListMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getOrderedBy() {
            if (this.orderedBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.orderedBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.orderedBy = new CodeableConcept();
                }
            }
            return this.orderedBy;
        }

        public boolean hasOrderedBy() {
            return this.orderedBy != null && !this.orderedBy.isEmpty();
        }

        public SectionComponent setOrderedBy(CodeableConcept value) {
            this.orderedBy = value;
            return this;
        }

        public List<CodeableConcept> getEntryClassifier() {
            if (this.entryClassifier == null) {
                this.entryClassifier = new ArrayList<CodeableConcept>();
            }
            return this.entryClassifier;
        }

        public SectionComponent setEntryClassifier(List<CodeableConcept> theEntryClassifier) {
            this.entryClassifier = theEntryClassifier;
            return this;
        }

        public boolean hasEntryClassifier() {
            if (this.entryClassifier == null) {
                return false;
            }
            for (CodeableConcept item : this.entryClassifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addEntryClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.entryClassifier == null) {
                this.entryClassifier = new ArrayList<CodeableConcept>();
            }
            this.entryClassifier.add(t);
            return t;
        }

        public SectionComponent addEntryClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.entryClassifier == null) {
                this.entryClassifier = new ArrayList<CodeableConcept>();
            }
            this.entryClassifier.add(t);
            return this;
        }

        public CodeableConcept getEntryClassifierFirstRep() {
            if (this.getEntryClassifier().isEmpty()) {
                this.addEntryClassifier();
            }
            return this.getEntryClassifier().get(0);
        }

        public List<Reference> getEntryReference() {
            if (this.entryReference == null) {
                this.entryReference = new ArrayList<Reference>();
            }
            return this.entryReference;
        }

        public SectionComponent setEntryReference(List<Reference> theEntryReference) {
            this.entryReference = theEntryReference;
            return this;
        }

        public boolean hasEntryReference() {
            if (this.entryReference == null) {
                return false;
            }
            for (Reference item : this.entryReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEntryReference() {
            Reference t = new Reference();
            if (this.entryReference == null) {
                this.entryReference = new ArrayList<Reference>();
            }
            this.entryReference.add(t);
            return t;
        }

        public SectionComponent addEntryReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.entryReference == null) {
                this.entryReference = new ArrayList<Reference>();
            }
            this.entryReference.add(t);
            return this;
        }

        public Reference getEntryReferenceFirstRep() {
            if (this.getEntryReference().isEmpty()) {
                this.addEntryReference();
            }
            return this.getEntryReference().get(0);
        }

        public CodeableConcept getEmptyReason() {
            if (this.emptyReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.emptyReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.emptyReason = new CodeableConcept();
                }
            }
            return this.emptyReason;
        }

        public boolean hasEmptyReason() {
            return this.emptyReason != null && !this.emptyReason.isEmpty();
        }

        public SectionComponent setEmptyReason(CodeableConcept value) {
            this.emptyReason = value;
            return this;
        }

        public List<SectionComponent> getSection() {
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            return this.section;
        }

        public SectionComponent setSection(List<SectionComponent> theSection) {
            this.section = theSection;
            return this;
        }

        public boolean hasSection() {
            if (this.section == null) {
                return false;
            }
            for (SectionComponent item : this.section) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SectionComponent addSection() {
            SectionComponent t = new SectionComponent();
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return t;
        }

        public SectionComponent addSection(SectionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return this;
        }

        public SectionComponent getSectionFirstRep() {
            if (this.getSection().isEmpty()) {
                this.addSection();
            }
            return this.getSection().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title));
            children.add(new Property("focus", "CodeableConcept", "A code identifying the kind of content contained within the section. This should be consistent with the section title.", 0, 1, this.focus));
            children.add(new Property("focusReference", "Reference(Any)", "A definitional Resource identifying the kind of content contained within the section. This should be consistent with the section title.", 0, 1, this.focusReference));
            children.add(new Property("author", "Reference(Person|Device|Group|Organization)", "Identifies who is responsible for the information in this section, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author));
            children.add(new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is peferred to contain sufficient detail to make it acceptable for a human to just read the narrative.", 0, 1, this.text));
            children.add(new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode));
            children.add(new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy));
            children.add(new Property("entryClassifier", "CodeableConcept", "Specifies any type of classification of the evidence report.", 0, Integer.MAX_VALUE, this.entryClassifier));
            children.add(new Property("entryReference", "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entryReference));
            children.add(new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason));
            children.add(new Property("section", "@EvidenceReport.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title);
                }
                case 97604824: {
                    return new Property("focus", "CodeableConcept", "A code identifying the kind of content contained within the section. This should be consistent with the section title.", 0, 1, this.focus);
                }
                case 1823604051: {
                    return new Property("focusReference", "Reference(Any)", "A definitional Resource identifying the kind of content contained within the section. This should be consistent with the section title.", 0, 1, this.focusReference);
                }
                case -1406328437: {
                    return new Property("author", "Reference(Person|Device|Group|Organization)", "Identifies who is responsible for the information in this section, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author);
                }
                case 3556653: {
                    return new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is peferred to contain sufficient detail to make it acceptable for a human to just read the narrative.", 0, 1, this.text);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode);
                }
                case -391079516: {
                    return new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy);
                }
                case -948201421: {
                    return new Property("entryClassifier", "CodeableConcept", "Specifies any type of classification of the evidence report.", 0, Integer.MAX_VALUE, this.entryClassifier);
                }
                case 438810361: {
                    return new Property("entryReference", "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entryReference);
                }
                case 1140135409: {
                    return new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason);
                }
                case 1970241253: {
                    return new Property("section", "@EvidenceReport.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 97604824: {
                    Base[] baseArray;
                    if (this.focus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focus;
                    }
                    return baseArray;
                }
                case 1823604051: {
                    Base[] baseArray;
                    if (this.focusReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.focusReference;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.text;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.mode;
                    }
                    return baseArray;
                }
                case -391079516: {
                    Base[] baseArray;
                    if (this.orderedBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.orderedBy;
                    }
                    return baseArray;
                }
                case -948201421: {
                    return this.entryClassifier == null ? new Base[]{} : this.entryClassifier.toArray(new Base[this.entryClassifier.size()]);
                }
                case 438810361: {
                    return this.entryReference == null ? new Base[]{} : this.entryReference.toArray(new Base[this.entryReference.size()]);
                }
                case 1140135409: {
                    Base[] baseArray;
                    if (this.emptyReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.emptyReason;
                    }
                    return baseArray;
                }
                case 1970241253: {
                    return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 97604824: {
                    this.focus = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1823604051: {
                    this.focusReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1406328437: {
                    this.getAuthor().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToNarrative(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case -391079516: {
                    this.orderedBy = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -948201421: {
                    this.getEntryClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 438810361: {
                    this.getEntryReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 1140135409: {
                    this.emptyReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1970241253: {
                    this.getSection().add((SectionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("focus")) {
                this.focus = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("focusReference")) {
                this.focusReference = TypeConvertor.castToReference(value);
            } else if (name.equals("author")) {
                this.getAuthor().add(TypeConvertor.castToReference(value));
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToNarrative(value);
            } else if (name.equals("mode")) {
                value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("orderedBy")) {
                this.orderedBy = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("entryClassifier")) {
                this.getEntryClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("entryReference")) {
                this.getEntryReference().add(TypeConvertor.castToReference(value));
            } else if (name.equals("emptyReason")) {
                this.emptyReason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("section")) {
                this.getSection().add((SectionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 97604824: {
                    return this.getFocus();
                }
                case 1823604051: {
                    return this.getFocusReference();
                }
                case -1406328437: {
                    return this.addAuthor();
                }
                case 3556653: {
                    return this.getText();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case -391079516: {
                    return this.getOrderedBy();
                }
                case -948201421: {
                    return this.addEntryClassifier();
                }
                case 438810361: {
                    return this.addEntryReference();
                }
                case 1140135409: {
                    return this.getEmptyReason();
                }
                case 1970241253: {
                    return this.addSection();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 97604824: {
                    return new String[]{"CodeableConcept"};
                }
                case 1823604051: {
                    return new String[]{"Reference"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
                case 3556653: {
                    return new String[]{"Narrative"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case -391079516: {
                    return new String[]{"CodeableConcept"};
                }
                case -948201421: {
                    return new String[]{"CodeableConcept"};
                }
                case 438810361: {
                    return new String[]{"Reference"};
                }
                case 1140135409: {
                    return new String[]{"CodeableConcept"};
                }
                case 1970241253: {
                    return new String[]{"@EvidenceReport.section"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.section.title");
            }
            if (name.equals("focus")) {
                this.focus = new CodeableConcept();
                return this.focus;
            }
            if (name.equals("focusReference")) {
                this.focusReference = new Reference();
                return this.focusReference;
            }
            if (name.equals("author")) {
                return this.addAuthor();
            }
            if (name.equals("text")) {
                this.text = new Narrative();
                return this.text;
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.section.mode");
            }
            if (name.equals("orderedBy")) {
                this.orderedBy = new CodeableConcept();
                return this.orderedBy;
            }
            if (name.equals("entryClassifier")) {
                return this.addEntryClassifier();
            }
            if (name.equals("entryReference")) {
                return this.addEntryReference();
            }
            if (name.equals("emptyReason")) {
                this.emptyReason = new CodeableConcept();
                return this.emptyReason;
            }
            if (name.equals("section")) {
                return this.addSection();
            }
            return super.addChild(name);
        }

        @Override
        public SectionComponent copy() {
            SectionComponent dst = new SectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SectionComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.focus = this.focus == null ? null : this.focus.copy();
            Reference reference = dst.focusReference = this.focusReference == null ? null : this.focusReference.copy();
            if (this.author != null) {
                dst.author = new ArrayList<Reference>();
                for (Reference reference2 : this.author) {
                    dst.author.add(reference2.copy());
                }
            }
            dst.text = this.text == null ? null : this.text.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            CodeableConcept codeableConcept = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
            if (this.entryClassifier != null) {
                dst.entryClassifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.entryClassifier) {
                    dst.entryClassifier.add(codeableConcept2.copy());
                }
            }
            if (this.entryReference != null) {
                dst.entryReference = new ArrayList<Reference>();
                for (Reference reference3 : this.entryReference) {
                    dst.entryReference.add(reference3.copy());
                }
            }
            CodeableConcept codeableConcept3 = dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
            if (this.section != null) {
                dst.section = new ArrayList<SectionComponent>();
                for (SectionComponent sectionComponent : this.section) {
                    dst.section.add(sectionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareDeep(this.title, o.title, true) && SectionComponent.compareDeep(this.focus, o.focus, true) && SectionComponent.compareDeep(this.focusReference, o.focusReference, true) && SectionComponent.compareDeep(this.author, o.author, true) && SectionComponent.compareDeep(this.text, o.text, true) && SectionComponent.compareDeep(this.mode, o.mode, true) && SectionComponent.compareDeep(this.orderedBy, o.orderedBy, true) && SectionComponent.compareDeep(this.entryClassifier, o.entryClassifier, true) && SectionComponent.compareDeep(this.entryReference, o.entryReference, true) && SectionComponent.compareDeep(this.emptyReason, o.emptyReason, true) && SectionComponent.compareDeep(this.section, o.section, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareValues(this.title, o.title, true) && SectionComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.focus, this.focusReference, this.author, this.text, this.mode, this.orderedBy, this.entryClassifier, this.entryReference, this.emptyReason, this.section});
        }

        @Override
        public String fhirType() {
            return "EvidenceReport.section";
        }
    }

    @Block
    public static class EvidenceReportRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="replaces | amends | appends | transforms", formalDefinition="The type of relationship that this composition has with anther composition or document.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-relation-type")
        protected Enumeration<ReportRelationshipType> code;
        @Child(name="target", type={Identifier.class, EvidenceReport.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target composition/document of this relationship.")
        protected DataType target;
        private static final long serialVersionUID = -1091549831L;

        public EvidenceReportRelatesToComponent() {
        }

        public EvidenceReportRelatesToComponent(ReportRelationshipType code, DataType target) {
            this.setCode(code);
            this.setTarget(target);
        }

        public Enumeration<ReportRelationshipType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReportRelatesToComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<ReportRelationshipType>(new ReportRelationshipTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public EvidenceReportRelatesToComponent setCodeElement(Enumeration<ReportRelationshipType> value) {
            this.code = value;
            return this;
        }

        public ReportRelationshipType getCode() {
            return this.code == null ? null : (ReportRelationshipType)((Object)this.code.getValue());
        }

        public EvidenceReportRelatesToComponent setCode(ReportRelationshipType value) {
            if (this.code == null) {
                this.code = new Enumeration<ReportRelationshipType>(new ReportRelationshipTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public DataType getTarget() {
            return this.target;
        }

        public Identifier getTargetIdentifier() throws FHIRException {
            if (this.target == null) {
                this.target = new Identifier();
            }
            if (!(this.target instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Identifier)this.target;
        }

        public boolean hasTargetIdentifier() {
            return this != null && this.target instanceof Identifier;
        }

        public Reference getTargetReference() throws FHIRException {
            if (this.target == null) {
                this.target = new Reference();
            }
            if (!(this.target instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
            }
            return (Reference)this.target;
        }

        public boolean hasTargetReference() {
            return this != null && this.target instanceof Reference;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public EvidenceReportRelatesToComponent setTarget(DataType value) {
            if (value != null && !(value instanceof Identifier) && !(value instanceof Reference)) {
                throw new Error("Not the right type for EvidenceReport.relatesTo.target[x]: " + value.fhirType());
            }
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "The type of relationship that this composition has with anther composition or document.", 0, 1, this.code));
            children.add(new Property("target[x]", "Identifier|Reference(EvidenceReport)", "The target composition/document of this relationship.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "The type of relationship that this composition has with anther composition or document.", 0, 1, this.code);
                }
                case -815579825: {
                    return new Property("target[x]", "Identifier|Reference(EvidenceReport)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case -880905839: {
                    return new Property("target[x]", "Identifier|Reference(EvidenceReport)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case 1690892570: {
                    return new Property("target[x]", "Identifier", "The target composition/document of this relationship.", 0, 1, this.target);
                }
                case 1259806906: {
                    return new Property("target[x]", "Reference(EvidenceReport)", "The target composition/document of this relationship.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new ReportRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new ReportRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("target[x]")) {
                this.target = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -815579825: {
                    return this.getTarget();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -880905839: {
                    return new String[]{"Identifier", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.relatesTo.code");
            }
            if (name.equals("targetIdentifier")) {
                this.target = new Identifier();
                return this.target;
            }
            if (name.equals("targetReference")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceReportRelatesToComponent copy() {
            EvidenceReportRelatesToComponent dst = new EvidenceReportRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceReportRelatesToComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportRelatesToComponent)) {
                return false;
            }
            EvidenceReportRelatesToComponent o = (EvidenceReportRelatesToComponent)other_;
            return EvidenceReportRelatesToComponent.compareDeep(this.code, o.code, true) && EvidenceReportRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportRelatesToComponent)) {
                return false;
            }
            EvidenceReportRelatesToComponent o = (EvidenceReportRelatesToComponent)other_;
            return EvidenceReportRelatesToComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.target});
        }

        @Override
        public String fhirType() {
            return "EvidenceReport.relatesTo";
        }
    }

    @Block
    public static class EvidenceReportSubjectCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristic code", formalDefinition="Characteristic code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/focus-characteristic-code")
        protected CodeableConcept code;
        @Child(name="value", type={Reference.class, CodeableConcept.class, BooleanType.class, Quantity.class, Range.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristic value", formalDefinition="Characteristic value.")
        protected DataType value;
        @Child(name="exclude", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is used to express not the characteristic", formalDefinition="Is used to express not the characteristic.")
        protected BooleanType exclude;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Timeframe for the characteristic", formalDefinition="Timeframe for the characteristic.")
        protected Period period;
        private static final long serialVersionUID = 279867823L;

        public EvidenceReportSubjectCharacteristicComponent() {
        }

        public EvidenceReportSubjectCharacteristicComponent(CodeableConcept code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReportSubjectCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public EvidenceReportSubjectCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EvidenceReportSubjectCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof Reference || value instanceof CodeableConcept || value instanceof BooleanType || value instanceof Quantity || value instanceof Range)) {
                throw new Error("Not the right type for EvidenceReport.subject.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReportSubjectCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public EvidenceReportSubjectCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public EvidenceReportSubjectCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceReportSubjectCharacteristicComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EvidenceReportSubjectCharacteristicComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Characteristic code.", 0, 1, this.code));
            children.add(new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value));
            children.add(new Property("exclude", "boolean", "Is used to express not the characteristic.", 0, 1, this.exclude));
            children.add(new Property("period", "Period", "Timeframe for the characteristic.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Characteristic code.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Reference(Any)|CodeableConcept|boolean|Quantity|Range", "Characteristic value.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Any)", "Characteristic value.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Characteristic value.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Characteristic value.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Characteristic value.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Characteristic value.", 0, 1, this.value);
                }
                case -1321148966: {
                    return new Property("exclude", "boolean", "Is used to express not the characteristic.", 0, 1, this.exclude);
                }
                case -991726143: {
                    return new Property("period", "Period", "Timeframe for the characteristic.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.exclude;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1321148966: {
                    this.exclude = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("exclude")) {
                this.exclude = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Reference", "CodeableConcept", "boolean", "Quantity", "Range"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("exclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceReport.subject.characteristic.exclude");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceReportSubjectCharacteristicComponent copy() {
            EvidenceReportSubjectCharacteristicComponent dst = new EvidenceReportSubjectCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceReportSubjectCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportSubjectCharacteristicComponent)) {
                return false;
            }
            EvidenceReportSubjectCharacteristicComponent o = (EvidenceReportSubjectCharacteristicComponent)other_;
            return EvidenceReportSubjectCharacteristicComponent.compareDeep(this.code, o.code, true) && EvidenceReportSubjectCharacteristicComponent.compareDeep(this.value, o.value, true) && EvidenceReportSubjectCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && EvidenceReportSubjectCharacteristicComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportSubjectCharacteristicComponent)) {
                return false;
            }
            EvidenceReportSubjectCharacteristicComponent o = (EvidenceReportSubjectCharacteristicComponent)other_;
            return EvidenceReportSubjectCharacteristicComponent.compareValues(this.exclude, o.exclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value, this.exclude, this.period});
        }

        @Override
        public String fhirType() {
            return "EvidenceReport.subject.characteristic";
        }
    }

    @Block
    public static class EvidenceReportSubjectComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="characteristic", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristic", formalDefinition="Characteristic.")
        protected List<EvidenceReportSubjectCharacteristicComponent> characteristic;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Used for general notes and annotations not coded elsewhere.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -734040873L;

        public List<EvidenceReportSubjectCharacteristicComponent> getCharacteristic() {
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceReportSubjectCharacteristicComponent>();
            }
            return this.characteristic;
        }

        public EvidenceReportSubjectComponent setCharacteristic(List<EvidenceReportSubjectCharacteristicComponent> theCharacteristic) {
            this.characteristic = theCharacteristic;
            return this;
        }

        public boolean hasCharacteristic() {
            if (this.characteristic == null) {
                return false;
            }
            for (EvidenceReportSubjectCharacteristicComponent item : this.characteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceReportSubjectCharacteristicComponent addCharacteristic() {
            EvidenceReportSubjectCharacteristicComponent t = new EvidenceReportSubjectCharacteristicComponent();
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceReportSubjectCharacteristicComponent>();
            }
            this.characteristic.add(t);
            return t;
        }

        public EvidenceReportSubjectComponent addCharacteristic(EvidenceReportSubjectCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceReportSubjectCharacteristicComponent>();
            }
            this.characteristic.add(t);
            return this;
        }

        public EvidenceReportSubjectCharacteristicComponent getCharacteristicFirstRep() {
            if (this.getCharacteristic().isEmpty()) {
                this.addCharacteristic();
            }
            return this.getCharacteristic().get(0);
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceReportSubjectComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceReportSubjectComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("characteristic", "", "Characteristic.", 0, Integer.MAX_VALUE, this.characteristic));
            children.add(new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 366313883: {
                    return new Property("characteristic", "", "Characteristic.", 0, Integer.MAX_VALUE, this.characteristic);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    this.getCharacteristic().add((EvidenceReportSubjectCharacteristicComponent)value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("characteristic")) {
                this.getCharacteristic().add((EvidenceReportSubjectCharacteristicComponent)value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    return this.addCharacteristic();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    return new String[0];
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("characteristic")) {
                return this.addCharacteristic();
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceReportSubjectComponent copy() {
            EvidenceReportSubjectComponent dst = new EvidenceReportSubjectComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceReportSubjectComponent dst) {
            super.copyValues(dst);
            if (this.characteristic != null) {
                dst.characteristic = new ArrayList<EvidenceReportSubjectCharacteristicComponent>();
                for (EvidenceReportSubjectCharacteristicComponent evidenceReportSubjectCharacteristicComponent : this.characteristic) {
                    dst.characteristic.add(evidenceReportSubjectCharacteristicComponent.copy());
                }
            }
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportSubjectComponent)) {
                return false;
            }
            EvidenceReportSubjectComponent o = (EvidenceReportSubjectComponent)other_;
            return EvidenceReportSubjectComponent.compareDeep(this.characteristic, o.characteristic, true) && EvidenceReportSubjectComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceReportSubjectComponent)) {
                return false;
            }
            EvidenceReportSubjectComponent o = (EvidenceReportSubjectComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.characteristic, this.note});
        }

        @Override
        public String fhirType() {
            return "EvidenceReport.subject";
        }
    }

    public static class ReportRelationshipTypeEnumFactory
    implements EnumFactory<ReportRelationshipType> {
        @Override
        public ReportRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return ReportRelationshipType.REPLACES;
            }
            if ("amends".equals(codeString)) {
                return ReportRelationshipType.AMENDS;
            }
            if ("appends".equals(codeString)) {
                return ReportRelationshipType.APPENDS;
            }
            if ("transforms".equals(codeString)) {
                return ReportRelationshipType.TRANSFORMS;
            }
            throw new IllegalArgumentException("Unknown ReportRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ReportRelationshipType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReportRelationshipType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<ReportRelationshipType>(this, ReportRelationshipType.REPLACES);
            }
            if ("amends".equals(codeString)) {
                return new Enumeration<ReportRelationshipType>(this, ReportRelationshipType.AMENDS);
            }
            if ("appends".equals(codeString)) {
                return new Enumeration<ReportRelationshipType>(this, ReportRelationshipType.APPENDS);
            }
            if ("transforms".equals(codeString)) {
                return new Enumeration<ReportRelationshipType>(this, ReportRelationshipType.TRANSFORMS);
            }
            throw new FHIRException("Unknown ReportRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ReportRelationshipType code) {
            if (code == ReportRelationshipType.REPLACES) {
                return "replaces";
            }
            if (code == ReportRelationshipType.AMENDS) {
                return "amends";
            }
            if (code == ReportRelationshipType.APPENDS) {
                return "appends";
            }
            if (code == ReportRelationshipType.TRANSFORMS) {
                return "transforms";
            }
            return "?";
        }

        @Override
        public String toSystem(ReportRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum ReportRelationshipType {
        REPLACES,
        AMENDS,
        APPENDS,
        TRANSFORMS,
        NULL;


        public static ReportRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("amends".equals(codeString)) {
                return AMENDS;
            }
            if ("appends".equals(codeString)) {
                return APPENDS;
            }
            if ("transforms".equals(codeString)) {
                return TRANSFORMS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReportRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REPLACES: {
                    return "replaces";
                }
                case AMENDS: {
                    return "amends";
                }
                case APPENDS: {
                    return "appends";
                }
                case TRANSFORMS: {
                    return "transforms";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REPLACES: {
                    return "http://hl7.org/fhir/report-relation-type";
                }
                case AMENDS: {
                    return "http://hl7.org/fhir/report-relation-type";
                }
                case APPENDS: {
                    return "http://hl7.org/fhir/report-relation-type";
                }
                case TRANSFORMS: {
                    return "http://hl7.org/fhir/report-relation-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REPLACES: {
                    return "This document replaces or supersedes the target document.";
                }
                case AMENDS: {
                    return "This document notes corrections or changes to replace or supersede parts of the target document.";
                }
                case APPENDS: {
                    return "This document adds additional information to the target document.";
                }
                case TRANSFORMS: {
                    return "This document was generated by transforming the target document (eg format or language conversion).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REPLACES: {
                    return "Replaces";
                }
                case AMENDS: {
                    return "Amends";
                }
                case APPENDS: {
                    return "Appends";
                }
                case TRANSFORMS: {
                    return "Transforms";
                }
            }
            return "?";
        }
    }
}

