/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.utilities.Utilities;

public class ExpressionNode {
    private String uniqueId;
    private Kind kind;
    private String name;
    private Base constant;
    private Function function;
    private List<ExpressionNode> parameters;
    private ExpressionNode inner;
    private ExpressionNode group;
    private Operation operation;
    private boolean proximal;
    private ExpressionNode opNext;
    private SourceLocation start;
    private SourceLocation end;
    private SourceLocation opStart;
    private SourceLocation opEnd;
    private TypeDetails types;
    private TypeDetails opTypes;

    public ExpressionNode(int uniqueId) {
        this.uniqueId = Integer.toString(uniqueId);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        switch (this.kind) {
            case Name: {
                b.append(this.name);
                break;
            }
            case Function: {
                if (this.function == Function.Item) {
                    b.append("[");
                } else {
                    b.append(this.name);
                    b.append("(");
                }
                boolean first = true;
                for (ExpressionNode n : this.parameters) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(n.toString());
                }
                if (this.function == Function.Item) {
                    b.append("]");
                    break;
                }
                b.append(")");
                break;
            }
            case Constant: {
                if (this.constant instanceof StringType) {
                    b.append("'" + Utilities.escapeJson((String)this.constant.primitiveValue()) + "'");
                    break;
                }
                if (this.constant instanceof Quantity) {
                    Quantity q = (Quantity)this.constant;
                    b.append(Utilities.escapeJson((String)q.getValue().toPlainString()));
                    b.append(" '");
                    b.append(Utilities.escapeJson((String)q.getUnit()));
                    b.append("'");
                    break;
                }
                if (this.constant.primitiveValue() != null) {
                    b.append(Utilities.escapeJson((String)this.constant.primitiveValue()));
                    break;
                }
                b.append(Utilities.escapeJson((String)this.constant.toString()));
                break;
            }
            case Group: {
                b.append("(");
                b.append(this.group.toString());
                b.append(")");
            }
        }
        if (this.inner != null) {
            if (Kind.Function != this.inner.getKind() || Function.Item != this.inner.getFunction()) {
                b.append(".");
            }
            b.append(this.inner.toString());
        }
        if (this.operation != null) {
            b.append(" ");
            b.append(this.operation.toCode());
            b.append(" ");
            b.append(this.opNext.toString());
        }
        return b.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Base getConstant() {
        return this.constant;
    }

    public void setConstant(Base constant) {
        this.constant = constant;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
        if (this.parameters == null) {
            this.parameters = new ArrayList<ExpressionNode>();
        }
    }

    public boolean isProximal() {
        return this.proximal;
    }

    public void setProximal(boolean proximal) {
        this.proximal = proximal;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public ExpressionNode getInner() {
        return this.inner;
    }

    public void setInner(ExpressionNode value) {
        this.inner = value;
    }

    public ExpressionNode getOpNext() {
        return this.opNext;
    }

    public void setOpNext(ExpressionNode value) {
        this.opNext = value;
    }

    public List<ExpressionNode> getParameters() {
        return this.parameters;
    }

    public boolean checkName() {
        if (!this.name.startsWith("$")) {
            return true;
        }
        return Utilities.existsInList((String)this.name, (String[])new String[]{"$this", "$total"});
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public ExpressionNode getGroup() {
        return this.group;
    }

    public void setGroup(ExpressionNode group) {
        this.group = group;
    }

    public SourceLocation getStart() {
        return this.start;
    }

    public void setStart(SourceLocation start) {
        this.start = start;
    }

    public SourceLocation getEnd() {
        return this.end;
    }

    public void setEnd(SourceLocation end) {
        this.end = end;
    }

    public SourceLocation getOpStart() {
        return this.opStart;
    }

    public void setOpStart(SourceLocation opStart) {
        this.opStart = opStart;
    }

    public SourceLocation getOpEnd() {
        return this.opEnd;
    }

    public void setOpEnd(SourceLocation opEnd) {
        this.opEnd = opEnd;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int parameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public String Canonical() {
        StringBuilder b = new StringBuilder();
        this.write(b);
        return b.toString();
    }

    public String summary() {
        switch (this.kind) {
            case Name: {
                return this.uniqueId + ": " + this.name;
            }
            case Function: {
                return this.uniqueId + ": " + this.function.toString() + "()";
            }
            case Constant: {
                return this.uniqueId + ": " + this.constant;
            }
            case Group: {
                return this.uniqueId + ": (Group)";
            }
        }
        return "?exp-kind?";
    }

    private void write(StringBuilder b) {
        switch (this.kind) {
            case Name: {
                b.append(this.name);
                break;
            }
            case Constant: {
                b.append(this.constant);
                break;
            }
            case Function: {
                b.append(this.function.toCode());
                b.append('(');
                boolean f = true;
                for (ExpressionNode n : this.parameters) {
                    if (f) {
                        f = false;
                    } else {
                        b.append(", ");
                    }
                    n.write(b);
                }
                b.append(')');
                break;
            }
            case Group: {
                b.append('(');
                this.group.write(b);
                b.append(')');
            }
        }
        if (this.inner != null) {
            b.append('.');
            this.inner.write(b);
        }
        if (this.operation != null) {
            b.append(' ');
            b.append(this.operation.toCode());
            b.append(' ');
            this.opNext.write(b);
        }
    }

    public String check() {
        String msg;
        switch (this.kind) {
            case Name: {
                if (!Utilities.noString((String)this.name)) break;
                return "No Name provided @ " + this.location();
            }
            case Function: {
                if (this.function == null) {
                    return "No Function id provided @ " + this.location();
                }
                for (ExpressionNode n : this.parameters) {
                    String msg2 = n.check();
                    if (msg2 == null) continue;
                    return msg2;
                }
                break;
            }
            case Unary: {
                break;
            }
            case Constant: {
                if (this.constant != null) break;
                return "No Constant provided @ " + this.location();
            }
            case Group: {
                if (this.group == null) {
                    return "No Group provided @ " + this.location();
                }
                msg = this.group.check();
                if (msg == null) break;
                return msg;
            }
        }
        if (this.inner != null && (msg = this.inner.check()) != null) {
            return msg;
        }
        if (this.operation == null) {
            if (this.opNext != null) {
                return "Next provided when it shouldn't be @ " + this.location();
            }
        } else {
            if (this.opNext == null) {
                return "No Next provided @ " + this.location();
            }
            this.opNext.check();
        }
        return null;
    }

    private String location() {
        return Integer.toString(this.start.getLine()) + ", " + Integer.toString(this.start.getColumn());
    }

    public TypeDetails getTypes() {
        return this.types;
    }

    public void setTypes(TypeDetails types) {
        this.types = types;
    }

    public TypeDetails getOpTypes() {
        return this.opTypes;
    }

    public void setOpTypes(TypeDetails opTypes) {
        this.opTypes = opTypes;
    }

    public static enum CollectionStatus {
        SINGLETON,
        ORDERED,
        UNORDERED;

    }

    public static enum Operation {
        Equals,
        Equivalent,
        NotEquals,
        NotEquivalent,
        LessThan,
        Greater,
        LessOrEqual,
        GreaterOrEqual,
        Is,
        As,
        Union,
        Or,
        And,
        Xor,
        Implies,
        Times,
        DivideBy,
        Plus,
        Minus,
        Concatenate,
        Div,
        Mod,
        In,
        Contains,
        MemberOf;


        public static Operation fromCode(String name) {
            if (Utilities.noString((String)name)) {
                return null;
            }
            if (name.equals("=")) {
                return Equals;
            }
            if (name.equals("~")) {
                return Equivalent;
            }
            if (name.equals("!=")) {
                return NotEquals;
            }
            if (name.equals("!~")) {
                return NotEquivalent;
            }
            if (name.equals(">")) {
                return Greater;
            }
            if (name.equals("<")) {
                return LessThan;
            }
            if (name.equals(">=")) {
                return GreaterOrEqual;
            }
            if (name.equals("<=")) {
                return LessOrEqual;
            }
            if (name.equals("|")) {
                return Union;
            }
            if (name.equals("or")) {
                return Or;
            }
            if (name.equals("and")) {
                return And;
            }
            if (name.equals("xor")) {
                return Xor;
            }
            if (name.equals("is")) {
                return Is;
            }
            if (name.equals("as")) {
                return As;
            }
            if (name.equals("*")) {
                return Times;
            }
            if (name.equals("/")) {
                return DivideBy;
            }
            if (name.equals("+")) {
                return Plus;
            }
            if (name.equals("-")) {
                return Minus;
            }
            if (name.equals("&")) {
                return Concatenate;
            }
            if (name.equals("implies")) {
                return Implies;
            }
            if (name.equals("div")) {
                return Div;
            }
            if (name.equals("mod")) {
                return Mod;
            }
            if (name.equals("in")) {
                return In;
            }
            if (name.equals("contains")) {
                return Contains;
            }
            if (name.equals("memberOf")) {
                return MemberOf;
            }
            return null;
        }

        public String toCode() {
            switch (this) {
                case Equals: {
                    return "=";
                }
                case Equivalent: {
                    return "~";
                }
                case NotEquals: {
                    return "!=";
                }
                case NotEquivalent: {
                    return "!~";
                }
                case Greater: {
                    return ">";
                }
                case LessThan: {
                    return "<";
                }
                case GreaterOrEqual: {
                    return ">=";
                }
                case LessOrEqual: {
                    return "<=";
                }
                case Union: {
                    return "|";
                }
                case Or: {
                    return "or";
                }
                case And: {
                    return "and";
                }
                case Xor: {
                    return "xor";
                }
                case Times: {
                    return "*";
                }
                case DivideBy: {
                    return "/";
                }
                case Plus: {
                    return "+";
                }
                case Minus: {
                    return "-";
                }
                case Concatenate: {
                    return "&";
                }
                case Implies: {
                    return "implies";
                }
                case Is: {
                    return "is";
                }
                case As: {
                    return "as";
                }
                case Div: {
                    return "div";
                }
                case Mod: {
                    return "mod";
                }
                case In: {
                    return "in";
                }
                case Contains: {
                    return "contains";
                }
                case MemberOf: {
                    return "memberOf";
                }
            }
            return "?custom?";
        }
    }

    public static enum Function {
        Custom,
        Empty,
        Not,
        Exists,
        SubsetOf,
        SupersetOf,
        IsDistinct,
        Distinct,
        Count,
        Where,
        Select,
        All,
        Repeat,
        Aggregate,
        Item,
        As,
        Is,
        Single,
        First,
        Last,
        Tail,
        Skip,
        Take,
        Union,
        Combine,
        Intersect,
        Exclude,
        Iif,
        Upper,
        Lower,
        ToChars,
        IndexOf,
        Substring,
        StartsWith,
        EndsWith,
        Matches,
        ReplaceMatches,
        Contains,
        Replace,
        Length,
        Children,
        Descendants,
        MemberOf,
        Trace,
        Check,
        Today,
        Now,
        Resolve,
        Extension,
        AllFalse,
        AnyFalse,
        AllTrue,
        AnyTrue,
        HasValue,
        OfType,
        Type,
        ConvertsToBoolean,
        ConvertsToInteger,
        ConvertsToString,
        ConvertsToDecimal,
        ConvertsToQuantity,
        ConvertsToDateTime,
        ConvertsToDate,
        ConvertsToTime,
        ToBoolean,
        ToInteger,
        ToString,
        ToDecimal,
        ToQuantity,
        ToDateTime,
        ToTime,
        ConformsTo,
        Round,
        Sqrt,
        Abs,
        Ceiling,
        Exp,
        Floor,
        Ln,
        Log,
        Power,
        Truncate,
        Encode,
        Decode,
        Escape,
        Unescape,
        Trim,
        Split,
        Join,
        HtmlChecks1,
        HtmlChecks2,
        AliasAs,
        Alias;


        public static Function fromCode(String name) {
            if (name.equals("empty")) {
                return Empty;
            }
            if (name.equals("not")) {
                return Not;
            }
            if (name.equals("exists")) {
                return Exists;
            }
            if (name.equals("subsetOf")) {
                return SubsetOf;
            }
            if (name.equals("supersetOf")) {
                return SupersetOf;
            }
            if (name.equals("isDistinct")) {
                return IsDistinct;
            }
            if (name.equals("distinct")) {
                return Distinct;
            }
            if (name.equals("count")) {
                return Count;
            }
            if (name.equals("where")) {
                return Where;
            }
            if (name.equals("select")) {
                return Select;
            }
            if (name.equals("all")) {
                return All;
            }
            if (name.equals("repeat")) {
                return Repeat;
            }
            if (name.equals("aggregate")) {
                return Aggregate;
            }
            if (name.equals("item")) {
                return Item;
            }
            if (name.equals("as")) {
                return As;
            }
            if (name.equals("is")) {
                return Is;
            }
            if (name.equals("single")) {
                return Single;
            }
            if (name.equals("first")) {
                return First;
            }
            if (name.equals("last")) {
                return Last;
            }
            if (name.equals("tail")) {
                return Tail;
            }
            if (name.equals("skip")) {
                return Skip;
            }
            if (name.equals("take")) {
                return Take;
            }
            if (name.equals("union")) {
                return Union;
            }
            if (name.equals("combine")) {
                return Combine;
            }
            if (name.equals("intersect")) {
                return Intersect;
            }
            if (name.equals("exclude")) {
                return Exclude;
            }
            if (name.equals("iif")) {
                return Iif;
            }
            if (name.equals("lower")) {
                return Lower;
            }
            if (name.equals("upper")) {
                return Upper;
            }
            if (name.equals("toChars")) {
                return ToChars;
            }
            if (name.equals("indexOf")) {
                return IndexOf;
            }
            if (name.equals("substring")) {
                return Substring;
            }
            if (name.equals("startsWith")) {
                return StartsWith;
            }
            if (name.equals("endsWith")) {
                return EndsWith;
            }
            if (name.equals("matches")) {
                return Matches;
            }
            if (name.equals("replaceMatches")) {
                return ReplaceMatches;
            }
            if (name.equals("contains")) {
                return Contains;
            }
            if (name.equals("replace")) {
                return Replace;
            }
            if (name.equals("length")) {
                return Length;
            }
            if (name.equals("children")) {
                return Children;
            }
            if (name.equals("descendants")) {
                return Descendants;
            }
            if (name.equals("memberOf")) {
                return MemberOf;
            }
            if (name.equals("trace")) {
                return Trace;
            }
            if (name.equals("check")) {
                return Check;
            }
            if (name.equals("today")) {
                return Today;
            }
            if (name.equals("now")) {
                return Now;
            }
            if (name.equals("resolve")) {
                return Resolve;
            }
            if (name.equals("extension")) {
                return Extension;
            }
            if (name.equals("allFalse")) {
                return AllFalse;
            }
            if (name.equals("anyFalse")) {
                return AnyFalse;
            }
            if (name.equals("allTrue")) {
                return AllTrue;
            }
            if (name.equals("anyTrue")) {
                return AnyTrue;
            }
            if (name.equals("hasValue")) {
                return HasValue;
            }
            if (name.equals("alias")) {
                return Alias;
            }
            if (name.equals("aliasAs")) {
                return AliasAs;
            }
            if (name.equals("htmlChecks")) {
                return HtmlChecks1;
            }
            if (name.equals("htmlchecks")) {
                return HtmlChecks1;
            }
            if (name.equals("htmlChecks2")) {
                return HtmlChecks2;
            }
            if (name.equals("encode")) {
                return Encode;
            }
            if (name.equals("decode")) {
                return Decode;
            }
            if (name.equals("escape")) {
                return Escape;
            }
            if (name.equals("unescape")) {
                return Unescape;
            }
            if (name.equals("trim")) {
                return Trim;
            }
            if (name.equals("split")) {
                return Split;
            }
            if (name.equals("join")) {
                return Join;
            }
            if (name.equals("ofType")) {
                return OfType;
            }
            if (name.equals("type")) {
                return Type;
            }
            if (name.equals("toInteger")) {
                return ToInteger;
            }
            if (name.equals("toDecimal")) {
                return ToDecimal;
            }
            if (name.equals("toString")) {
                return ToString;
            }
            if (name.equals("toQuantity")) {
                return ToQuantity;
            }
            if (name.equals("toBoolean")) {
                return ToBoolean;
            }
            if (name.equals("toDateTime")) {
                return ToDateTime;
            }
            if (name.equals("toTime")) {
                return ToTime;
            }
            if (name.equals("convertsToInteger")) {
                return ConvertsToInteger;
            }
            if (name.equals("convertsToDecimal")) {
                return ConvertsToDecimal;
            }
            if (name.equals("convertsToString")) {
                return ConvertsToString;
            }
            if (name.equals("convertsToQuantity")) {
                return ConvertsToQuantity;
            }
            if (name.equals("convertsToBoolean")) {
                return ConvertsToBoolean;
            }
            if (name.equals("convertsToDateTime")) {
                return ConvertsToDateTime;
            }
            if (name.equals("convertsToDate")) {
                return ConvertsToDate;
            }
            if (name.equals("convertsToTime")) {
                return ConvertsToTime;
            }
            if (name.equals("conformsTo")) {
                return ConformsTo;
            }
            if (name.equals("round")) {
                return Round;
            }
            if (name.equals("sqrt")) {
                return Sqrt;
            }
            if (name.equals("abs")) {
                return Abs;
            }
            if (name.equals("ceiling")) {
                return Ceiling;
            }
            if (name.equals("exp")) {
                return Exp;
            }
            if (name.equals("floor")) {
                return Floor;
            }
            if (name.equals("ln")) {
                return Ln;
            }
            if (name.equals("log")) {
                return Log;
            }
            if (name.equals("power")) {
                return Power;
            }
            if (name.equals("truncate")) {
                return Truncate;
            }
            return null;
        }

        public String toCode() {
            switch (this) {
                case Empty: {
                    return "empty";
                }
                case Not: {
                    return "not";
                }
                case Exists: {
                    return "exists";
                }
                case SubsetOf: {
                    return "subsetOf";
                }
                case SupersetOf: {
                    return "supersetOf";
                }
                case IsDistinct: {
                    return "isDistinct";
                }
                case Distinct: {
                    return "distinct";
                }
                case Count: {
                    return "count";
                }
                case Where: {
                    return "where";
                }
                case Select: {
                    return "select";
                }
                case All: {
                    return "all";
                }
                case Repeat: {
                    return "repeat";
                }
                case Aggregate: {
                    return "aggregate";
                }
                case Item: {
                    return "item";
                }
                case As: {
                    return "as";
                }
                case Is: {
                    return "is";
                }
                case Single: {
                    return "single";
                }
                case First: {
                    return "first";
                }
                case Last: {
                    return "last";
                }
                case Tail: {
                    return "tail";
                }
                case Skip: {
                    return "skip";
                }
                case Take: {
                    return "take";
                }
                case Union: {
                    return "union";
                }
                case Combine: {
                    return "combine";
                }
                case Intersect: {
                    return "intersect";
                }
                case Exclude: {
                    return "exclude";
                }
                case Iif: {
                    return "iif";
                }
                case ToChars: {
                    return "toChars";
                }
                case Lower: {
                    return "lower";
                }
                case Upper: {
                    return "upper";
                }
                case IndexOf: {
                    return "indexOf";
                }
                case Substring: {
                    return "substring";
                }
                case StartsWith: {
                    return "startsWith";
                }
                case EndsWith: {
                    return "endsWith";
                }
                case Matches: {
                    return "matches";
                }
                case ReplaceMatches: {
                    return "replaceMatches";
                }
                case Contains: {
                    return "contains";
                }
                case Replace: {
                    return "replace";
                }
                case Length: {
                    return "length";
                }
                case Children: {
                    return "children";
                }
                case Descendants: {
                    return "descendants";
                }
                case MemberOf: {
                    return "memberOf";
                }
                case Trace: {
                    return "trace";
                }
                case Check: {
                    return "check";
                }
                case Today: {
                    return "today";
                }
                case Now: {
                    return "now";
                }
                case Resolve: {
                    return "resolve";
                }
                case Extension: {
                    return "extension";
                }
                case AllFalse: {
                    return "allFalse";
                }
                case AnyFalse: {
                    return "anyFalse";
                }
                case AllTrue: {
                    return "allTrue";
                }
                case AnyTrue: {
                    return "anyTrue";
                }
                case HasValue: {
                    return "hasValue";
                }
                case Alias: {
                    return "alias";
                }
                case AliasAs: {
                    return "aliasAs";
                }
                case Encode: {
                    return "encode";
                }
                case Decode: {
                    return "decode";
                }
                case Escape: {
                    return "escape";
                }
                case Unescape: {
                    return "unescape";
                }
                case Trim: {
                    return "trim";
                }
                case Split: {
                    return "split";
                }
                case Join: {
                    return "join";
                }
                case HtmlChecks1: {
                    return "htmlChecks";
                }
                case HtmlChecks2: {
                    return "htmlChecks2";
                }
                case OfType: {
                    return "ofType";
                }
                case Type: {
                    return "type";
                }
                case ToInteger: {
                    return "toInteger";
                }
                case ToDecimal: {
                    return "toDecimal";
                }
                case ToString: {
                    return "toString";
                }
                case ToBoolean: {
                    return "toBoolean";
                }
                case ToQuantity: {
                    return "toQuantity";
                }
                case ToDateTime: {
                    return "toDateTime";
                }
                case ToTime: {
                    return "toTime";
                }
                case ConvertsToInteger: {
                    return "convertsToInteger";
                }
                case ConvertsToDecimal: {
                    return "convertsToDecimal";
                }
                case ConvertsToString: {
                    return "convertsToString";
                }
                case ConvertsToBoolean: {
                    return "convertsToBoolean";
                }
                case ConvertsToQuantity: {
                    return "convertsToQuantity";
                }
                case ConvertsToDateTime: {
                    return "convertsToDateTime";
                }
                case ConvertsToDate: {
                    return "convertsToDate";
                }
                case ConvertsToTime: {
                    return "isTime";
                }
                case ConformsTo: {
                    return "conformsTo";
                }
                case Round: {
                    return "round";
                }
                case Sqrt: {
                    return "sqrt";
                }
                case Abs: {
                    return "abs";
                }
                case Ceiling: {
                    return "ceiling";
                }
                case Exp: {
                    return "exp";
                }
                case Floor: {
                    return "floor";
                }
                case Ln: {
                    return "ln";
                }
                case Log: {
                    return "log";
                }
                case Power: {
                    return "power";
                }
                case Truncate: {
                    return "truncate";
                }
            }
            return "?custom?";
        }
    }

    public static class SourceLocation {
        private int line;
        private int column;

        public SourceLocation(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String toString() {
            return Integer.toString(this.line) + ", " + Integer.toString(this.column);
        }
    }

    public static enum Kind {
        Name,
        Function,
        Constant,
        Group,
        Unary;

    }
}

