/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Immunization", profile="http://hl7.org/fhir/StructureDefinition/Immunization")
public class Immunization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this immunization record.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition for the immunization event", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition for the immunization event", formalDefinition="The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={CarePlan.class, MedicationRequest.class, ImmunizationRecommendation.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Authority that the immunization event is based on", formalDefinition="A plan, order or recommendation fulfilled in whole or in part by this immunization.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="completed | entered-in-error | not-done", formalDefinition="Indicates the current status of the immunization event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-status")
    protected Enumeration<ImmunizationStatusCodes> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Indicates the reason the immunization event was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-status-reason")
    protected CodeableConcept statusReason;
    @Child(name="vaccineCode", type={CodeableConcept.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccine product administered", formalDefinition="Vaccine that was administered or was to be administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
    protected CodeableConcept vaccineCode;
    @Child(name="manufacturer", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine manufacturer", formalDefinition="Name of vaccine manufacturer.")
    protected Reference manufacturer;
    @Child(name="lotNumber", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine lot number", formalDefinition="Lot number of the  vaccine product.")
    protected StringType lotNumber;
    @Child(name="expirationDate", type={DateType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Vaccine expiration date", formalDefinition="Date vaccine batch expires.")
    protected DateType expirationDate;
    @Child(name="patient", type={Patient.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who was immunized", formalDefinition="The patient who either received or did not receive the immunization.")
    protected Reference patient;
    @Child(name="encounter", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter immunization was part of", formalDefinition="The visit or admission or other contact between patient and health care provider the immunization was performed as part of.")
    protected Reference encounter;
    @Child(name="occurrence", type={DateTimeType.class, StringType.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccine administration date", formalDefinition="Date vaccine administered or was to be administered.")
    protected DataType occurrence;
    @Child(name="recorded", type={DateTimeType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the immunization was first captured in the subject's record", formalDefinition="The date the occurrence of the immunization was first captured in the record - potentially significantly after the occurrence of the event.")
    protected DateTimeType recorded;
    @Child(name="primarySource", type={BooleanType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates context the data was recorded in", formalDefinition="Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.")
    protected BooleanType primarySource;
    @Child(name="informationSource", type={CodeableConcept.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the source of a  reported record", formalDefinition="Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-origin")
    protected DataType informationSource;
    @Child(name="location", type={Location.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where immunization occurred", formalDefinition="The service delivery location where the vaccine administration occurred.")
    protected Reference location;
    @Child(name="site", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Body site vaccine  was administered", formalDefinition="Body site where vaccine was administered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-site")
    protected CodeableConcept site;
    @Child(name="route", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How vaccine entered body", formalDefinition="The path by which the vaccine product is taken into the body.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-route")
    protected CodeableConcept route;
    @Child(name="doseQuantity", type={Quantity.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount of vaccine administered", formalDefinition="The quantity of vaccine product that was administered.")
    protected Quantity doseQuantity;
    @Child(name="performer", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who performed event", formalDefinition="Indicates who performed the immunization event.")
    protected List<ImmunizationPerformerComponent> performer;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional immunization notes", formalDefinition="Extra information about the immunization that is not conveyed by the other attributes.")
    protected List<Annotation> note;
    @Child(name="reason", type={CodeableReference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why immunization occurred", formalDefinition="Describes why the immunization occurred in coded or textual form, or Indicates another resource (Condition, Observation or DiagnosticReport) whose existence justifies this immunization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-reason")
    protected List<CodeableReference> reason;
    @Child(name="isSubpotent", type={BooleanType.class}, order=23, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Dose potency", formalDefinition="Indication if a dose is considered to be subpotent. By default, a dose should be considered to be potent.")
    protected BooleanType isSubpotent;
    @Child(name="subpotentReason", type={CodeableConcept.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for being subpotent", formalDefinition="Reason why a dose is considered to be subpotent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-subpotent-reason")
    protected List<CodeableConcept> subpotentReason;
    @Child(name="education", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Educational material presented to patient", formalDefinition="Educational material presented to the patient (or guardian) at the time of vaccine administration.")
    protected List<ImmunizationEducationComponent> education;
    @Child(name="programEligibility", type={CodeableConcept.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient eligibility for a vaccination program", formalDefinition="Indicates a patient's eligibility for a funding program.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-program-eligibility")
    protected List<CodeableConcept> programEligibility;
    @Child(name="fundingSource", type={CodeableConcept.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Funding source for the vaccine", formalDefinition="Indicates the source of the vaccine actually administered. This may be different than the patient eligibility (e.g. the patient may be eligible for a publically purchased vaccine but due to inventory issues, vaccine purchased with private funds was actually administered).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-funding-source")
    protected CodeableConcept fundingSource;
    @Child(name="reaction", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of a reaction that follows immunization", formalDefinition="Categorical data indicating that an adverse event is associated in time to an immunization.")
    protected List<ImmunizationReactionComponent> reaction;
    @Child(name="protocolApplied", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Protocol followed by the provider", formalDefinition="The protocol (set of recommendations) being followed by the provider who administered the dose.")
    protected List<ImmunizationProtocolAppliedComponent> protocolApplied;
    private static final long serialVersionUID = 35822108L;
    @SearchParamDefinition(name="location", path="Immunization.location", description="The service delivery location or facility in which the vaccine was / was to be administered", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Immunization:location").toLocked();
    @SearchParamDefinition(name="lot-number", path="Immunization.lotNumber", description="Vaccine Lot Number", type="string")
    public static final String SP_LOT_NUMBER = "lot-number";
    public static final StringClientParam LOT_NUMBER = new StringClientParam("lot-number");
    @SearchParamDefinition(name="manufacturer", path="Immunization.manufacturer", description="Vaccine Manufacturer", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Immunization:manufacturer").toLocked();
    @SearchParamDefinition(name="performer", path="Immunization.performer.actor", description="The practitioner or organization who played a role in the vaccination", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Immunization:performer").toLocked();
    @SearchParamDefinition(name="reaction-date", path="Immunization.reaction.date", description="When reaction started", type="date")
    public static final String SP_REACTION_DATE = "reaction-date";
    public static final DateClientParam REACTION_DATE = new DateClientParam("reaction-date");
    @SearchParamDefinition(name="reaction", path="Immunization.reaction.detail", description="Additional information on reaction", type="reference", target={Observation.class})
    public static final String SP_REACTION = "reaction";
    public static final ReferenceClientParam REACTION = new ReferenceClientParam("reaction");
    public static final Include INCLUDE_REACTION = new Include("Immunization:reaction").toLocked();
    @SearchParamDefinition(name="reason-code", path="Immunization.reason.concept", description="Reason why the vaccine was administered", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Immunization.reason.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Immunization:reason-reference").toLocked();
    @SearchParamDefinition(name="series", path="Immunization.protocolApplied.series", description="The series being followed by the provider", type="string")
    public static final String SP_SERIES = "series";
    public static final StringClientParam SERIES = new StringClientParam("series");
    @SearchParamDefinition(name="status-reason", path="Immunization.statusReason", description="Reason why the vaccine was not administered", type="token")
    public static final String SP_STATUS_REASON = "status-reason";
    public static final TokenClientParam STATUS_REASON = new TokenClientParam("status-reason");
    @SearchParamDefinition(name="status", path="Immunization.status", description="Immunization event status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="target-disease", path="Immunization.protocolApplied.targetDisease", description="The target disease the dose is being administered against", type="token")
    public static final String SP_TARGET_DISEASE = "target-disease";
    public static final TokenClientParam TARGET_DISEASE = new TokenClientParam("target-disease");
    @SearchParamDefinition(name="vaccine-code", path="Immunization.vaccineCode", description="Vaccine Product Administered", type="token")
    public static final String SP_VACCINE_CODE = "vaccine-code";
    public static final TokenClientParam VACCINE_CODE = new TokenClientParam("vaccine-code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Immunization:patient").toLocked();

    public Immunization() {
    }

    public Immunization(ImmunizationStatusCodes status, CodeableConcept vaccineCode, Reference patient, DataType occurrence) {
        this.setStatus(status);
        this.setVaccineCode(vaccineCode);
        this.setPatient(patient);
        this.setOccurrence(occurrence);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Immunization setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Immunization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public Immunization setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public Immunization addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public Immunization setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public Immunization addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Immunization setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Immunization addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<ImmunizationStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ImmunizationStatusCodes>(new ImmunizationStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Immunization setStatusElement(Enumeration<ImmunizationStatusCodes> value) {
        this.status = value;
        return this;
    }

    public ImmunizationStatusCodes getStatus() {
        return this.status == null ? null : (ImmunizationStatusCodes)((Object)this.status.getValue());
    }

    public Immunization setStatus(ImmunizationStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<ImmunizationStatusCodes>(new ImmunizationStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Immunization setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public CodeableConcept getVaccineCode() {
        if (this.vaccineCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.vaccineCode");
            }
            if (Configuration.doAutoCreate()) {
                this.vaccineCode = new CodeableConcept();
            }
        }
        return this.vaccineCode;
    }

    public boolean hasVaccineCode() {
        return this.vaccineCode != null && !this.vaccineCode.isEmpty();
    }

    public Immunization setVaccineCode(CodeableConcept value) {
        this.vaccineCode = value;
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Immunization setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Immunization setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Immunization setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public DateType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Immunization setExpirationDateElement(DateType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Immunization setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Immunization setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Immunization setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public StringType getOccurrenceStringType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new StringType();
        }
        if (!(this.occurrence instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (StringType)this.occurrence;
    }

    public boolean hasOccurrenceStringType() {
        return this != null && this.occurrence instanceof StringType;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public Immunization setOccurrence(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof StringType)) {
            throw new Error("Not the right type for Immunization.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new DateTimeType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public Immunization setRecordedElement(DateTimeType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public Immunization setRecorded(Date value) {
        if (value == null) {
            this.recorded = null;
        } else {
            if (this.recorded == null) {
                this.recorded = new DateTimeType();
            }
            this.recorded.setValue(value);
        }
        return this;
    }

    public BooleanType getPrimarySourceElement() {
        if (this.primarySource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.primarySource");
            }
            if (Configuration.doAutoCreate()) {
                this.primarySource = new BooleanType();
            }
        }
        return this.primarySource;
    }

    public boolean hasPrimarySourceElement() {
        return this.primarySource != null && !this.primarySource.isEmpty();
    }

    public boolean hasPrimarySource() {
        return this.primarySource != null && !this.primarySource.isEmpty();
    }

    public Immunization setPrimarySourceElement(BooleanType value) {
        this.primarySource = value;
        return this;
    }

    public boolean getPrimarySource() {
        return this.primarySource == null || this.primarySource.isEmpty() ? false : (Boolean)this.primarySource.getValue();
    }

    public Immunization setPrimarySource(boolean value) {
        if (this.primarySource == null) {
            this.primarySource = new BooleanType();
        }
        this.primarySource.setValue((Object)value);
        return this;
    }

    public DataType getInformationSource() {
        return this.informationSource;
    }

    public CodeableConcept getInformationSourceCodeableConcept() throws FHIRException {
        if (this.informationSource == null) {
            this.informationSource = new CodeableConcept();
        }
        if (!(this.informationSource instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.informationSource.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.informationSource;
    }

    public boolean hasInformationSourceCodeableConcept() {
        return this != null && this.informationSource instanceof CodeableConcept;
    }

    public Reference getInformationSourceReference() throws FHIRException {
        if (this.informationSource == null) {
            this.informationSource = new Reference();
        }
        if (!(this.informationSource instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.informationSource.getClass().getName() + " was encountered");
        }
        return (Reference)this.informationSource;
    }

    public boolean hasInformationSourceReference() {
        return this != null && this.informationSource instanceof Reference;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public Immunization setInformationSource(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Immunization.informationSource[x]: " + value.fhirType());
        }
        this.informationSource = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Immunization setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public CodeableConcept getSite() {
        if (this.site == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.site");
            }
            if (Configuration.doAutoCreate()) {
                this.site = new CodeableConcept();
            }
        }
        return this.site;
    }

    public boolean hasSite() {
        return this.site != null && !this.site.isEmpty();
    }

    public Immunization setSite(CodeableConcept value) {
        this.site = value;
        return this;
    }

    public CodeableConcept getRoute() {
        if (this.route == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.route");
            }
            if (Configuration.doAutoCreate()) {
                this.route = new CodeableConcept();
            }
        }
        return this.route;
    }

    public boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    public Immunization setRoute(CodeableConcept value) {
        this.route = value;
        return this;
    }

    public Quantity getDoseQuantity() {
        if (this.doseQuantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.doseQuantity");
            }
            if (Configuration.doAutoCreate()) {
                this.doseQuantity = new Quantity();
            }
        }
        return this.doseQuantity;
    }

    public boolean hasDoseQuantity() {
        return this.doseQuantity != null && !this.doseQuantity.isEmpty();
    }

    public Immunization setDoseQuantity(Quantity value) {
        this.doseQuantity = value;
        return this;
    }

    public List<ImmunizationPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ImmunizationPerformerComponent>();
        }
        return this.performer;
    }

    public Immunization setPerformer(List<ImmunizationPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ImmunizationPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationPerformerComponent addPerformer() {
        ImmunizationPerformerComponent t = new ImmunizationPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ImmunizationPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public Immunization addPerformer(ImmunizationPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ImmunizationPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ImmunizationPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Immunization setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Immunization addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Immunization setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Immunization addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public BooleanType getIsSubpotentElement() {
        if (this.isSubpotent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.isSubpotent");
            }
            if (Configuration.doAutoCreate()) {
                this.isSubpotent = new BooleanType();
            }
        }
        return this.isSubpotent;
    }

    public boolean hasIsSubpotentElement() {
        return this.isSubpotent != null && !this.isSubpotent.isEmpty();
    }

    public boolean hasIsSubpotent() {
        return this.isSubpotent != null && !this.isSubpotent.isEmpty();
    }

    public Immunization setIsSubpotentElement(BooleanType value) {
        this.isSubpotent = value;
        return this;
    }

    public boolean getIsSubpotent() {
        return this.isSubpotent == null || this.isSubpotent.isEmpty() ? false : (Boolean)this.isSubpotent.getValue();
    }

    public Immunization setIsSubpotent(boolean value) {
        if (this.isSubpotent == null) {
            this.isSubpotent = new BooleanType();
        }
        this.isSubpotent.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getSubpotentReason() {
        if (this.subpotentReason == null) {
            this.subpotentReason = new ArrayList<CodeableConcept>();
        }
        return this.subpotentReason;
    }

    public Immunization setSubpotentReason(List<CodeableConcept> theSubpotentReason) {
        this.subpotentReason = theSubpotentReason;
        return this;
    }

    public boolean hasSubpotentReason() {
        if (this.subpotentReason == null) {
            return false;
        }
        for (CodeableConcept item : this.subpotentReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubpotentReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.subpotentReason == null) {
            this.subpotentReason = new ArrayList<CodeableConcept>();
        }
        this.subpotentReason.add(t);
        return t;
    }

    public Immunization addSubpotentReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subpotentReason == null) {
            this.subpotentReason = new ArrayList<CodeableConcept>();
        }
        this.subpotentReason.add(t);
        return this;
    }

    public CodeableConcept getSubpotentReasonFirstRep() {
        if (this.getSubpotentReason().isEmpty()) {
            this.addSubpotentReason();
        }
        return this.getSubpotentReason().get(0);
    }

    public List<ImmunizationEducationComponent> getEducation() {
        if (this.education == null) {
            this.education = new ArrayList<ImmunizationEducationComponent>();
        }
        return this.education;
    }

    public Immunization setEducation(List<ImmunizationEducationComponent> theEducation) {
        this.education = theEducation;
        return this;
    }

    public boolean hasEducation() {
        if (this.education == null) {
            return false;
        }
        for (ImmunizationEducationComponent item : this.education) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationEducationComponent addEducation() {
        ImmunizationEducationComponent t = new ImmunizationEducationComponent();
        if (this.education == null) {
            this.education = new ArrayList<ImmunizationEducationComponent>();
        }
        this.education.add(t);
        return t;
    }

    public Immunization addEducation(ImmunizationEducationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.education == null) {
            this.education = new ArrayList<ImmunizationEducationComponent>();
        }
        this.education.add(t);
        return this;
    }

    public ImmunizationEducationComponent getEducationFirstRep() {
        if (this.getEducation().isEmpty()) {
            this.addEducation();
        }
        return this.getEducation().get(0);
    }

    public List<CodeableConcept> getProgramEligibility() {
        if (this.programEligibility == null) {
            this.programEligibility = new ArrayList<CodeableConcept>();
        }
        return this.programEligibility;
    }

    public Immunization setProgramEligibility(List<CodeableConcept> theProgramEligibility) {
        this.programEligibility = theProgramEligibility;
        return this;
    }

    public boolean hasProgramEligibility() {
        if (this.programEligibility == null) {
            return false;
        }
        for (CodeableConcept item : this.programEligibility) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProgramEligibility() {
        CodeableConcept t = new CodeableConcept();
        if (this.programEligibility == null) {
            this.programEligibility = new ArrayList<CodeableConcept>();
        }
        this.programEligibility.add(t);
        return t;
    }

    public Immunization addProgramEligibility(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.programEligibility == null) {
            this.programEligibility = new ArrayList<CodeableConcept>();
        }
        this.programEligibility.add(t);
        return this;
    }

    public CodeableConcept getProgramEligibilityFirstRep() {
        if (this.getProgramEligibility().isEmpty()) {
            this.addProgramEligibility();
        }
        return this.getProgramEligibility().get(0);
    }

    public CodeableConcept getFundingSource() {
        if (this.fundingSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Immunization.fundingSource");
            }
            if (Configuration.doAutoCreate()) {
                this.fundingSource = new CodeableConcept();
            }
        }
        return this.fundingSource;
    }

    public boolean hasFundingSource() {
        return this.fundingSource != null && !this.fundingSource.isEmpty();
    }

    public Immunization setFundingSource(CodeableConcept value) {
        this.fundingSource = value;
        return this;
    }

    public List<ImmunizationReactionComponent> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        return this.reaction;
    }

    public Immunization setReaction(List<ImmunizationReactionComponent> theReaction) {
        this.reaction = theReaction;
        return this;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (ImmunizationReactionComponent item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationReactionComponent addReaction() {
        ImmunizationReactionComponent t = new ImmunizationReactionComponent();
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        this.reaction.add(t);
        return t;
    }

    public Immunization addReaction(ImmunizationReactionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReactionComponent>();
        }
        this.reaction.add(t);
        return this;
    }

    public ImmunizationReactionComponent getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            this.addReaction();
        }
        return this.getReaction().get(0);
    }

    public List<ImmunizationProtocolAppliedComponent> getProtocolApplied() {
        if (this.protocolApplied == null) {
            this.protocolApplied = new ArrayList<ImmunizationProtocolAppliedComponent>();
        }
        return this.protocolApplied;
    }

    public Immunization setProtocolApplied(List<ImmunizationProtocolAppliedComponent> theProtocolApplied) {
        this.protocolApplied = theProtocolApplied;
        return this;
    }

    public boolean hasProtocolApplied() {
        if (this.protocolApplied == null) {
            return false;
        }
        for (ImmunizationProtocolAppliedComponent item : this.protocolApplied) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationProtocolAppliedComponent addProtocolApplied() {
        ImmunizationProtocolAppliedComponent t = new ImmunizationProtocolAppliedComponent();
        if (this.protocolApplied == null) {
            this.protocolApplied = new ArrayList<ImmunizationProtocolAppliedComponent>();
        }
        this.protocolApplied.add(t);
        return t;
    }

    public Immunization addProtocolApplied(ImmunizationProtocolAppliedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.protocolApplied == null) {
            this.protocolApplied = new ArrayList<ImmunizationProtocolAppliedComponent>();
        }
        this.protocolApplied.add(t);
        return this;
    }

    public ImmunizationProtocolAppliedComponent getProtocolAppliedFirstRep() {
        if (this.getProtocolApplied().isEmpty()) {
            this.addProtocolApplied();
        }
        return this.getProtocolApplied().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this immunization record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition|EventDefinition|EvidenceVariable|Measure|OperationDefinition|PlanDefinition|Questionnaire|SubscriptionTopic)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(CarePlan|MedicationRequest|ImmunizationRecommendation)", "A plan, order or recommendation fulfilled in whole or in part by this immunization.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_STATUS, "code", "Indicates the current status of the immunization event.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Indicates the reason the immunization event was not performed.", 0, 1, this.statusReason));
        children.add(new Property("vaccineCode", "CodeableConcept", "Vaccine that was administered or was to be administered.", 0, 1, this.vaccineCode));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Name of vaccine manufacturer.", 0, 1, this.manufacturer));
        children.add(new Property("lotNumber", "string", "Lot number of the  vaccine product.", 0, 1, this.lotNumber));
        children.add(new Property("expirationDate", SP_DATE, "Date vaccine batch expires.", 0, 1, this.expirationDate));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who either received or did not receive the immunization.", 0, 1, this.patient));
        children.add(new Property("encounter", "Reference(Encounter)", "The visit or admission or other contact between patient and health care provider the immunization was performed as part of.", 0, 1, this.encounter));
        children.add(new Property("occurrence[x]", "dateTime|string", "Date vaccine administered or was to be administered.", 0, 1, this.occurrence));
        children.add(new Property("recorded", "dateTime", "The date the occurrence of the immunization was first captured in the record - potentially significantly after the occurrence of the event.", 0, 1, this.recorded));
        children.add(new Property("primarySource", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.", 0, 1, this.primarySource));
        children.add(new Property("informationSource[x]", "CodeableConcept|Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.", 0, 1, this.informationSource));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The service delivery location where the vaccine administration occurred.", 0, 1, this.location));
        children.add(new Property("site", "CodeableConcept", "Body site where vaccine was administered.", 0, 1, this.site));
        children.add(new Property("route", "CodeableConcept", "The path by which the vaccine product is taken into the body.", 0, 1, this.route));
        children.add(new Property("doseQuantity", "Quantity", "The quantity of vaccine product that was administered.", 0, 1, this.doseQuantity));
        children.add(new Property(SP_PERFORMER, "", "Indicates who performed the immunization event.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("note", "Annotation", "Extra information about the immunization that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "Describes why the immunization occurred in coded or textual form, or Indicates another resource (Condition, Observation or DiagnosticReport) whose existence justifies this immunization.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("isSubpotent", "boolean", "Indication if a dose is considered to be subpotent. By default, a dose should be considered to be potent.", 0, 1, this.isSubpotent));
        children.add(new Property("subpotentReason", "CodeableConcept", "Reason why a dose is considered to be subpotent.", 0, Integer.MAX_VALUE, this.subpotentReason));
        children.add(new Property("education", "", "Educational material presented to the patient (or guardian) at the time of vaccine administration.", 0, Integer.MAX_VALUE, this.education));
        children.add(new Property("programEligibility", "CodeableConcept", "Indicates a patient's eligibility for a funding program.", 0, Integer.MAX_VALUE, this.programEligibility));
        children.add(new Property("fundingSource", "CodeableConcept", "Indicates the source of the vaccine actually administered. This may be different than the patient eligibility (e.g. the patient may be eligible for a publically purchased vaccine but due to inventory issues, vaccine purchased with private funds was actually administered).", 0, 1, this.fundingSource));
        children.add(new Property(SP_REACTION, "", "Categorical data indicating that an adverse event is associated in time to an immunization.", 0, Integer.MAX_VALUE, this.reaction));
        children.add(new Property("protocolApplied", "", "The protocol (set of recommendations) being followed by the provider who administered the dose.", 0, Integer.MAX_VALUE, this.protocolApplied));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this immunization record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition|EventDefinition|EvidenceVariable|Measure|OperationDefinition|PlanDefinition|Questionnaire|SubscriptionTopic)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this Immunization.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|MedicationRequest|ImmunizationRecommendation)", "A plan, order or recommendation fulfilled in whole or in part by this immunization.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current status of the immunization event.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Indicates the reason the immunization event was not performed.", 0, 1, this.statusReason);
            }
            case 664556354: {
                return new Property("vaccineCode", "CodeableConcept", "Vaccine that was administered or was to be administered.", 0, 1, this.vaccineCode);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Name of vaccine manufacturer.", 0, 1, this.manufacturer);
            }
            case 462547450: {
                return new Property("lotNumber", "string", "Lot number of the  vaccine product.", 0, 1, this.lotNumber);
            }
            case -668811523: {
                return new Property("expirationDate", SP_DATE, "Date vaccine batch expires.", 0, 1, this.expirationDate);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who either received or did not receive the immunization.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The visit or admission or other contact between patient and health care provider the immunization was performed as part of.", 0, 1, this.encounter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|string", "Date vaccine administered or was to be administered.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|string", "Date vaccine administered or was to be administered.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "Date vaccine administered or was to be administered.", 0, 1, this.occurrence);
            }
            case 1496896834: {
                return new Property("occurrence[x]", "string", "Date vaccine administered or was to be administered.", 0, 1, this.occurrence);
            }
            case -799233872: {
                return new Property("recorded", "dateTime", "The date the occurrence of the immunization was first captured in the record - potentially significantly after the occurrence of the event.", 0, 1, this.recorded);
            }
            case -528721731: {
                return new Property("primarySource", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.", 0, 1, this.primarySource);
            }
            case -890044743: {
                return new Property("informationSource[x]", "CodeableConcept|Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.", 0, 1, this.informationSource);
            }
            case -2123220889: {
                return new Property("informationSource[x]", "CodeableConcept|Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.", 0, 1, this.informationSource);
            }
            case -1849314246: {
                return new Property("informationSource[x]", "CodeableConcept", "Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.", 0, 1, this.informationSource);
            }
            case -1721324892: {
                return new Property("informationSource[x]", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Typically the source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.", 0, 1, this.informationSource);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The service delivery location where the vaccine administration occurred.", 0, 1, this.location);
            }
            case 3530567: {
                return new Property("site", "CodeableConcept", "Body site where vaccine was administered.", 0, 1, this.site);
            }
            case 108704329: {
                return new Property("route", "CodeableConcept", "The path by which the vaccine product is taken into the body.", 0, 1, this.route);
            }
            case -2083618872: {
                return new Property("doseQuantity", "Quantity", "The quantity of vaccine product that was administered.", 0, 1, this.doseQuantity);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Indicates who performed the immunization event.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the immunization that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport)", "Describes why the immunization occurred in coded or textual form, or Indicates another resource (Condition, Observation or DiagnosticReport) whose existence justifies this immunization.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1618512556: {
                return new Property("isSubpotent", "boolean", "Indication if a dose is considered to be subpotent. By default, a dose should be considered to be potent.", 0, 1, this.isSubpotent);
            }
            case 805168794: {
                return new Property("subpotentReason", "CodeableConcept", "Reason why a dose is considered to be subpotent.", 0, Integer.MAX_VALUE, this.subpotentReason);
            }
            case -290756696: {
                return new Property("education", "", "Educational material presented to the patient (or guardian) at the time of vaccine administration.", 0, Integer.MAX_VALUE, this.education);
            }
            case 1207530089: {
                return new Property("programEligibility", "CodeableConcept", "Indicates a patient's eligibility for a funding program.", 0, Integer.MAX_VALUE, this.programEligibility);
            }
            case 1120150904: {
                return new Property("fundingSource", "CodeableConcept", "Indicates the source of the vaccine actually administered. This may be different than the patient eligibility (e.g. the patient may be eligible for a publically purchased vaccine but due to inventory issues, vaccine purchased with private funds was actually administered).", 0, 1, this.fundingSource);
            }
            case -867509719: {
                return new Property(SP_REACTION, "", "Categorical data indicating that an adverse event is associated in time to an immunization.", 0, Integer.MAX_VALUE, this.reaction);
            }
            case 607985349: {
                return new Property("protocolApplied", "", "The protocol (set of recommendations) being followed by the provider who administered the dose.", 0, Integer.MAX_VALUE, this.protocolApplied);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case 664556354: {
                Base[] baseArray;
                if (this.vaccineCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.vaccineCode;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.lotNumber;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.expirationDate;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.encounter;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.occurrence;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.recorded;
                }
                return baseArray;
            }
            case -528721731: {
                Base[] baseArray;
                if (this.primarySource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.primarySource;
                }
                return baseArray;
            }
            case -2123220889: {
                Base[] baseArray;
                if (this.informationSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.informationSource;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.location;
                }
                return baseArray;
            }
            case 3530567: {
                Base[] baseArray;
                if (this.site == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.site;
                }
                return baseArray;
            }
            case 108704329: {
                Base[] baseArray;
                if (this.route == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.route;
                }
                return baseArray;
            }
            case -2083618872: {
                Base[] baseArray;
                if (this.doseQuantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.doseQuantity;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1618512556: {
                Base[] baseArray;
                if (this.isSubpotent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.isSubpotent;
                }
                return baseArray;
            }
            case 805168794: {
                return this.subpotentReason == null ? new Base[]{} : this.subpotentReason.toArray(new Base[this.subpotentReason.size()]);
            }
            case -290756696: {
                return this.education == null ? new Base[]{} : this.education.toArray(new Base[this.education.size()]);
            }
            case 1207530089: {
                return this.programEligibility == null ? new Base[]{} : this.programEligibility.toArray(new Base[this.programEligibility.size()]);
            }
            case 1120150904: {
                Base[] baseArray;
                if (this.fundingSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.fundingSource;
                }
                return baseArray;
            }
            case -867509719: {
                return this.reaction == null ? new Base[]{} : this.reaction.toArray(new Base[this.reaction.size()]);
            }
            case 607985349: {
                return this.protocolApplied == null ? new Base[]{} : this.protocolApplied.toArray(new Base[this.protocolApplied.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new ImmunizationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 664556354: {
                this.vaccineCode = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToReference(value);
                return value;
            }
            case 462547450: {
                this.lotNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -528721731: {
                this.primarySource = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -2123220889: {
                this.informationSource = TypeConvertor.castToType(value);
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case 3530567: {
                this.site = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 108704329: {
                this.route = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -2083618872: {
                this.doseQuantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ImmunizationPerformerComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1618512556: {
                this.isSubpotent = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 805168794: {
                this.getSubpotentReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -290756696: {
                this.getEducation().add((ImmunizationEducationComponent)((Object)value));
                return value;
            }
            case 1207530089: {
                this.getProgramEligibility().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1120150904: {
                this.fundingSource = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -867509719: {
                this.getReaction().add((ImmunizationReactionComponent)((Object)value));
                return value;
            }
            case 607985349: {
                this.getProtocolApplied().add((ImmunizationProtocolAppliedComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ImmunizationStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("vaccineCode")) {
            this.vaccineCode = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = TypeConvertor.castToReference(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = TypeConvertor.castToString(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = TypeConvertor.castToDate(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals("recorded")) {
            this.recorded = TypeConvertor.castToDateTime(value);
        } else if (name.equals("primarySource")) {
            this.primarySource = TypeConvertor.castToBoolean(value);
        } else if (name.equals("informationSource[x]")) {
            this.informationSource = TypeConvertor.castToType(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("site")) {
            this.site = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("route")) {
            this.route = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("doseQuantity")) {
            this.doseQuantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((ImmunizationPerformerComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("isSubpotent")) {
            this.isSubpotent = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subpotentReason")) {
            this.getSubpotentReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("education")) {
            this.getEducation().add((ImmunizationEducationComponent)((Object)value));
        } else if (name.equals("programEligibility")) {
            this.getProgramEligibility().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("fundingSource")) {
            this.fundingSource = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_REACTION)) {
            this.getReaction().add((ImmunizationReactionComponent)((Object)value));
        } else if (name.equals("protocolApplied")) {
            this.getProtocolApplied().add((ImmunizationProtocolAppliedComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 664556354: {
                return this.getVaccineCode();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 462547450: {
                return this.getLotNumberElement();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -528721731: {
                return this.getPrimarySourceElement();
            }
            case -890044743: {
                return this.getInformationSource();
            }
            case -2123220889: {
                return this.getInformationSource();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 3530567: {
                return this.getSite();
            }
            case 108704329: {
                return this.getRoute();
            }
            case -2083618872: {
                return this.getDoseQuantity();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 3387378: {
                return this.addNote();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1618512556: {
                return this.getIsSubpotentElement();
            }
            case 805168794: {
                return this.addSubpotentReason();
            }
            case -290756696: {
                return this.addEducation();
            }
            case 1207530089: {
                return this.addProgramEligibility();
            }
            case 1120150904: {
                return this.getFundingSource();
            }
            case -867509719: {
                return this.addReaction();
            }
            case 607985349: {
                return this.addProtocolApplied();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 664556354: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 462547450: {
                return new String[]{"string"};
            }
            case -668811523: {
                return new String[]{SP_DATE};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "string"};
            }
            case -799233872: {
                return new String[]{"dateTime"};
            }
            case -528721731: {
                return new String[]{"boolean"};
            }
            case -2123220889: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 3530567: {
                return new String[]{"CodeableConcept"};
            }
            case 108704329: {
                return new String[]{"CodeableConcept"};
            }
            case -2083618872: {
                return new String[]{"Quantity"};
            }
            case 481140686: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1618512556: {
                return new String[]{"boolean"};
            }
            case 805168794: {
                return new String[]{"CodeableConcept"};
            }
            case -290756696: {
                return new String[0];
            }
            case 1207530089: {
                return new String[]{"CodeableConcept"};
            }
            case 1120150904: {
                return new String[]{"CodeableConcept"};
            }
            case -867509719: {
                return new String[0];
            }
            case 607985349: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("vaccineCode")) {
            this.vaccineCode = new CodeableConcept();
            return this.vaccineCode;
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.lotNumber");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.expirationDate");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrenceString")) {
            this.occurrence = new StringType();
            return this.occurrence;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.recorded");
        }
        if (name.equals("primarySource")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.primarySource");
        }
        if (name.equals("informationSourceCodeableConcept")) {
            this.informationSource = new CodeableConcept();
            return this.informationSource;
        }
        if (name.equals("informationSourceReference")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("site")) {
            this.site = new CodeableConcept();
            return this.site;
        }
        if (name.equals("route")) {
            this.route = new CodeableConcept();
            return this.route;
        }
        if (name.equals("doseQuantity")) {
            this.doseQuantity = new Quantity();
            return this.doseQuantity;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("isSubpotent")) {
            throw new FHIRException("Cannot call addChild on a primitive type Immunization.isSubpotent");
        }
        if (name.equals("subpotentReason")) {
            return this.addSubpotentReason();
        }
        if (name.equals("education")) {
            return this.addEducation();
        }
        if (name.equals("programEligibility")) {
            return this.addProgramEligibility();
        }
        if (name.equals("fundingSource")) {
            this.fundingSource = new CodeableConcept();
            return this.fundingSource;
        }
        if (name.equals(SP_REACTION)) {
            return this.addReaction();
        }
        if (name.equals("protocolApplied")) {
            return this.addProtocolApplied();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Immunization";
    }

    @Override
    public Immunization copy() {
        Immunization dst = new Immunization();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Immunization dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.vaccineCode = this.vaccineCode == null ? null : this.vaccineCode.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        dst.primarySource = this.primarySource == null ? null : this.primarySource.copy();
        dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.site = this.site == null ? null : this.site.copy();
        dst.route = this.route == null ? null : this.route.copy();
        Quantity quantity = dst.doseQuantity = this.doseQuantity == null ? null : this.doseQuantity.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ImmunizationPerformerComponent>();
            for (ImmunizationPerformerComponent immunizationPerformerComponent : this.performer) {
                dst.performer.add(immunizationPerformerComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        BooleanType booleanType = dst.isSubpotent = this.isSubpotent == null ? null : this.isSubpotent.copy();
        if (this.subpotentReason != null) {
            dst.subpotentReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.subpotentReason) {
                dst.subpotentReason.add(codeableConcept.copy());
            }
        }
        if (this.education != null) {
            dst.education = new ArrayList<ImmunizationEducationComponent>();
            for (ImmunizationEducationComponent immunizationEducationComponent : this.education) {
                dst.education.add(immunizationEducationComponent.copy());
            }
        }
        if (this.programEligibility != null) {
            dst.programEligibility = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.programEligibility) {
                dst.programEligibility.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.fundingSource = this.fundingSource == null ? null : this.fundingSource.copy();
        if (this.reaction != null) {
            dst.reaction = new ArrayList<ImmunizationReactionComponent>();
            for (ImmunizationReactionComponent immunizationReactionComponent : this.reaction) {
                dst.reaction.add(immunizationReactionComponent.copy());
            }
        }
        if (this.protocolApplied != null) {
            dst.protocolApplied = new ArrayList<ImmunizationProtocolAppliedComponent>();
            for (ImmunizationProtocolAppliedComponent immunizationProtocolAppliedComponent : this.protocolApplied) {
                dst.protocolApplied.add(immunizationProtocolAppliedComponent.copy());
            }
        }
    }

    protected Immunization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Immunization)) {
            return false;
        }
        Immunization o = (Immunization)other_;
        return Immunization.compareDeep(this.identifier, o.identifier, true) && Immunization.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && Immunization.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && Immunization.compareDeep(this.basedOn, o.basedOn, true) && Immunization.compareDeep(this.status, o.status, true) && Immunization.compareDeep(this.statusReason, o.statusReason, true) && Immunization.compareDeep(this.vaccineCode, o.vaccineCode, true) && Immunization.compareDeep(this.manufacturer, o.manufacturer, true) && Immunization.compareDeep(this.lotNumber, o.lotNumber, true) && Immunization.compareDeep(this.expirationDate, o.expirationDate, true) && Immunization.compareDeep(this.patient, o.patient, true) && Immunization.compareDeep(this.encounter, o.encounter, true) && Immunization.compareDeep(this.occurrence, o.occurrence, true) && Immunization.compareDeep(this.recorded, o.recorded, true) && Immunization.compareDeep(this.primarySource, o.primarySource, true) && Immunization.compareDeep(this.informationSource, o.informationSource, true) && Immunization.compareDeep(this.location, o.location, true) && Immunization.compareDeep(this.site, o.site, true) && Immunization.compareDeep(this.route, o.route, true) && Immunization.compareDeep(this.doseQuantity, o.doseQuantity, true) && Immunization.compareDeep(this.performer, o.performer, true) && Immunization.compareDeep(this.note, o.note, true) && Immunization.compareDeep(this.reason, o.reason, true) && Immunization.compareDeep(this.isSubpotent, o.isSubpotent, true) && Immunization.compareDeep(this.subpotentReason, o.subpotentReason, true) && Immunization.compareDeep(this.education, o.education, true) && Immunization.compareDeep(this.programEligibility, o.programEligibility, true) && Immunization.compareDeep(this.fundingSource, o.fundingSource, true) && Immunization.compareDeep(this.reaction, o.reaction, true) && Immunization.compareDeep(this.protocolApplied, o.protocolApplied, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Immunization)) {
            return false;
        }
        Immunization o = (Immunization)other_;
        return Immunization.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && Immunization.compareValues(this.instantiatesUri, o.instantiatesUri, true) && Immunization.compareValues(this.status, o.status, true) && Immunization.compareValues(this.lotNumber, o.lotNumber, true) && Immunization.compareValues(this.expirationDate, o.expirationDate, true) && Immunization.compareValues(this.recorded, o.recorded, true) && Immunization.compareValues(this.primarySource, o.primarySource, true) && Immunization.compareValues(this.isSubpotent, o.isSubpotent, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.status, this.statusReason, this.vaccineCode, this.manufacturer, this.lotNumber, this.expirationDate, this.patient, this.encounter, this.occurrence, this.recorded, this.primarySource, this.informationSource, this.location, this.site, this.route, this.doseQuantity, this.performer, this.note, this.reason, this.isSubpotent, this.subpotentReason, this.education, this.programEligibility, this.fundingSource, this.reaction, this.protocolApplied});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Immunization;
    }

    @Block
    public static class ImmunizationProtocolAppliedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="series", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of vaccine series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
        protected StringType series;
        @Child(name="authority", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is responsible for publishing the recommendations", formalDefinition="Indicates the authority who published the protocol (e.g. ACIP) that is being followed.")
        protected Reference authority;
        @Child(name="targetDisease", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Vaccine preventatable disease being targetted", formalDefinition="The vaccine preventable disease the dose is being administered against.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-target-disease")
        protected List<CodeableConcept> targetDisease;
        @Child(name="doseNumber", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Dose number within series", formalDefinition="Nominal position in a series as intended by the practitioner administering the dose.")
        protected StringType doseNumber;
        @Child(name="seriesDoses", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity as intended by the practitioner administering the dose.")
        protected StringType seriesDoses;
        private static final long serialVersionUID = 660613103L;

        public ImmunizationProtocolAppliedComponent() {
        }

        public ImmunizationProtocolAppliedComponent(String doseNumber) {
            this.setDoseNumber(doseNumber);
        }

        public StringType getSeriesElement() {
            if (this.series == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationProtocolAppliedComponent.series");
                }
                if (Configuration.doAutoCreate()) {
                    this.series = new StringType();
                }
            }
            return this.series;
        }

        public boolean hasSeriesElement() {
            return this.series != null && !this.series.isEmpty();
        }

        public boolean hasSeries() {
            return this.series != null && !this.series.isEmpty();
        }

        public ImmunizationProtocolAppliedComponent setSeriesElement(StringType value) {
            this.series = value;
            return this;
        }

        public String getSeries() {
            return this.series == null ? null : (String)this.series.getValue();
        }

        public ImmunizationProtocolAppliedComponent setSeries(String value) {
            if (Utilities.noString((String)value)) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(value);
            }
            return this;
        }

        public Reference getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationProtocolAppliedComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new Reference();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ImmunizationProtocolAppliedComponent setAuthority(Reference value) {
            this.authority = value;
            return this;
        }

        public List<CodeableConcept> getTargetDisease() {
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            return this.targetDisease;
        }

        public ImmunizationProtocolAppliedComponent setTargetDisease(List<CodeableConcept> theTargetDisease) {
            this.targetDisease = theTargetDisease;
            return this;
        }

        public boolean hasTargetDisease() {
            if (this.targetDisease == null) {
                return false;
            }
            for (CodeableConcept item : this.targetDisease) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTargetDisease() {
            CodeableConcept t = new CodeableConcept();
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return t;
        }

        public ImmunizationProtocolAppliedComponent addTargetDisease(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return this;
        }

        public CodeableConcept getTargetDiseaseFirstRep() {
            if (this.getTargetDisease().isEmpty()) {
                this.addTargetDisease();
            }
            return this.getTargetDisease().get(0);
        }

        public StringType getDoseNumberElement() {
            if (this.doseNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationProtocolAppliedComponent.doseNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseNumber = new StringType();
                }
            }
            return this.doseNumber;
        }

        public boolean hasDoseNumberElement() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public boolean hasDoseNumber() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public ImmunizationProtocolAppliedComponent setDoseNumberElement(StringType value) {
            this.doseNumber = value;
            return this;
        }

        public String getDoseNumber() {
            return this.doseNumber == null ? null : (String)this.doseNumber.getValue();
        }

        public ImmunizationProtocolAppliedComponent setDoseNumber(String value) {
            if (this.doseNumber == null) {
                this.doseNumber = new StringType();
            }
            this.doseNumber.setValue(value);
            return this;
        }

        public StringType getSeriesDosesElement() {
            if (this.seriesDoses == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationProtocolAppliedComponent.seriesDoses");
                }
                if (Configuration.doAutoCreate()) {
                    this.seriesDoses = new StringType();
                }
            }
            return this.seriesDoses;
        }

        public boolean hasSeriesDosesElement() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public boolean hasSeriesDoses() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public ImmunizationProtocolAppliedComponent setSeriesDosesElement(StringType value) {
            this.seriesDoses = value;
            return this;
        }

        public String getSeriesDoses() {
            return this.seriesDoses == null ? null : (String)this.seriesDoses.getValue();
        }

        public ImmunizationProtocolAppliedComponent setSeriesDoses(String value) {
            if (Utilities.noString((String)value)) {
                this.seriesDoses = null;
            } else {
                if (this.seriesDoses == null) {
                    this.seriesDoses = new StringType();
                }
                this.seriesDoses.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Immunization.SP_SERIES, "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series));
            children.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP) that is being followed.", 0, 1, this.authority));
            children.add(new Property("targetDisease", "CodeableConcept", "The vaccine preventable disease the dose is being administered against.", 0, Integer.MAX_VALUE, this.targetDisease));
            children.add(new Property("doseNumber", "string", "Nominal position in a series as intended by the practitioner administering the dose.", 0, 1, this.doseNumber));
            children.add(new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as intended by the practitioner administering the dose.", 0, 1, this.seriesDoses));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -905838985: {
                    return new Property(Immunization.SP_SERIES, "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series);
                }
                case 1475610435: {
                    return new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP) that is being followed.", 0, 1, this.authority);
                }
                case -319593813: {
                    return new Property("targetDisease", "CodeableConcept", "The vaccine preventable disease the dose is being administered against.", 0, Integer.MAX_VALUE, this.targetDisease);
                }
                case -887709242: {
                    return new Property("doseNumber", "string", "Nominal position in a series as intended by the practitioner administering the dose.", 0, 1, this.doseNumber);
                }
                case -1936727105: {
                    return new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as intended by the practitioner administering the dose.", 0, 1, this.seriesDoses);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -905838985: {
                    Base[] baseArray;
                    if (this.series == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.series;
                    }
                    return baseArray;
                }
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.authority;
                    }
                    return baseArray;
                }
                case -319593813: {
                    return this.targetDisease == null ? new Base[]{} : this.targetDisease.toArray(new Base[this.targetDisease.size()]);
                }
                case -887709242: {
                    Base[] baseArray;
                    if (this.doseNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.doseNumber;
                    }
                    return baseArray;
                }
                case -1936727105: {
                    Base[] baseArray;
                    if (this.seriesDoses == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.seriesDoses;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -905838985: {
                    this.series = TypeConvertor.castToString(value);
                    return value;
                }
                case 1475610435: {
                    this.authority = TypeConvertor.castToReference(value);
                    return value;
                }
                case -319593813: {
                    this.getTargetDisease().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -887709242: {
                    this.doseNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case -1936727105: {
                    this.seriesDoses = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Immunization.SP_SERIES)) {
                this.series = TypeConvertor.castToString(value);
            } else if (name.equals("authority")) {
                this.authority = TypeConvertor.castToReference(value);
            } else if (name.equals("targetDisease")) {
                this.getTargetDisease().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("doseNumber")) {
                this.doseNumber = TypeConvertor.castToString(value);
            } else if (name.equals("seriesDoses")) {
                this.seriesDoses = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -905838985: {
                    return this.getSeriesElement();
                }
                case 1475610435: {
                    return this.getAuthority();
                }
                case -319593813: {
                    return this.addTargetDisease();
                }
                case -887709242: {
                    return this.getDoseNumberElement();
                }
                case -1936727105: {
                    return this.getSeriesDosesElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -905838985: {
                    return new String[]{"string"};
                }
                case 1475610435: {
                    return new String[]{"Reference"};
                }
                case -319593813: {
                    return new String[]{"CodeableConcept"};
                }
                case -887709242: {
                    return new String[]{"string"};
                }
                case -1936727105: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Immunization.SP_SERIES)) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.protocolApplied.series");
            }
            if (name.equals("authority")) {
                this.authority = new Reference();
                return this.authority;
            }
            if (name.equals("targetDisease")) {
                return this.addTargetDisease();
            }
            if (name.equals("doseNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.protocolApplied.doseNumber");
            }
            if (name.equals("seriesDoses")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.protocolApplied.seriesDoses");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationProtocolAppliedComponent copy() {
            ImmunizationProtocolAppliedComponent dst = new ImmunizationProtocolAppliedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationProtocolAppliedComponent dst) {
            super.copyValues(dst);
            dst.series = this.series == null ? null : this.series.copy();
            Reference reference = dst.authority = this.authority == null ? null : this.authority.copy();
            if (this.targetDisease != null) {
                dst.targetDisease = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.targetDisease) {
                    dst.targetDisease.add(i.copy());
                }
            }
            dst.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
            dst.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationProtocolAppliedComponent)) {
                return false;
            }
            ImmunizationProtocolAppliedComponent o = (ImmunizationProtocolAppliedComponent)other_;
            return ImmunizationProtocolAppliedComponent.compareDeep(this.series, o.series, true) && ImmunizationProtocolAppliedComponent.compareDeep(this.authority, o.authority, true) && ImmunizationProtocolAppliedComponent.compareDeep(this.targetDisease, o.targetDisease, true) && ImmunizationProtocolAppliedComponent.compareDeep(this.doseNumber, o.doseNumber, true) && ImmunizationProtocolAppliedComponent.compareDeep(this.seriesDoses, o.seriesDoses, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationProtocolAppliedComponent)) {
                return false;
            }
            ImmunizationProtocolAppliedComponent o = (ImmunizationProtocolAppliedComponent)other_;
            return ImmunizationProtocolAppliedComponent.compareValues(this.series, o.series, true) && ImmunizationProtocolAppliedComponent.compareValues(this.doseNumber, o.doseNumber, true) && ImmunizationProtocolAppliedComponent.compareValues(this.seriesDoses, o.seriesDoses, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.series, this.authority, this.targetDisease, this.doseNumber, this.seriesDoses});
        }

        @Override
        public String fhirType() {
            return "Immunization.protocolApplied";
        }
    }

    @Block
    public static class ImmunizationReactionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When reaction started", formalDefinition="Date of reaction to the immunization.")
        protected DateTimeType date;
        @Child(name="detail", type={Observation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information on reaction", formalDefinition="Details of the reaction.")
        protected Reference detail;
        @Child(name="reported", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates self-reported reaction", formalDefinition="Self-reported indicator.")
        protected BooleanType reported;
        private static final long serialVersionUID = -655647546L;

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ImmunizationReactionComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ImmunizationReactionComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getDetail() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new Reference();
                }
            }
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public ImmunizationReactionComponent setDetail(Reference value) {
            this.detail = value;
            return this;
        }

        public BooleanType getReportedElement() {
            if (this.reported == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationReactionComponent.reported");
                }
                if (Configuration.doAutoCreate()) {
                    this.reported = new BooleanType();
                }
            }
            return this.reported;
        }

        public boolean hasReportedElement() {
            return this.reported != null && !this.reported.isEmpty();
        }

        public boolean hasReported() {
            return this.reported != null && !this.reported.isEmpty();
        }

        public ImmunizationReactionComponent setReportedElement(BooleanType value) {
            this.reported = value;
            return this;
        }

        public boolean getReported() {
            return this.reported == null || this.reported.isEmpty() ? false : (Boolean)this.reported.getValue();
        }

        public ImmunizationReactionComponent setReported(boolean value) {
            if (this.reported == null) {
                this.reported = new BooleanType();
            }
            this.reported.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Immunization.SP_DATE, "dateTime", "Date of reaction to the immunization.", 0, 1, this.date));
            children.add(new Property("detail", "Reference(Observation)", "Details of the reaction.", 0, 1, this.detail));
            children.add(new Property("reported", "boolean", "Self-reported indicator.", 0, 1, this.reported));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3076014: {
                    return new Property(Immunization.SP_DATE, "dateTime", "Date of reaction to the immunization.", 0, 1, this.date);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Observation)", "Details of the reaction.", 0, 1, this.detail);
                }
                case -427039533: {
                    return new Property("reported", "boolean", "Self-reported indicator.", 0, 1, this.reported);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.date;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
                case -427039533: {
                    Base[] baseArray;
                    if (this.reported == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reported;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = TypeConvertor.castToReference(value);
                    return value;
                }
                case -427039533: {
                    this.reported = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Immunization.SP_DATE)) {
                this.date = TypeConvertor.castToDateTime(value);
            } else if (name.equals("detail")) {
                this.detail = TypeConvertor.castToReference(value);
            } else if (name.equals("reported")) {
                this.reported = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return this.getDateElement();
                }
                case -1335224239: {
                    return this.getDetail();
                }
                case -427039533: {
                    return this.getReportedElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
                case -427039533: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Immunization.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.reaction.date");
            }
            if (name.equals("detail")) {
                this.detail = new Reference();
                return this.detail;
            }
            if (name.equals("reported")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.reaction.reported");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationReactionComponent copy() {
            ImmunizationReactionComponent dst = new ImmunizationReactionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationReactionComponent dst) {
            super.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.reported = this.reported == null ? null : this.reported.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationReactionComponent)) {
                return false;
            }
            ImmunizationReactionComponent o = (ImmunizationReactionComponent)other_;
            return ImmunizationReactionComponent.compareDeep(this.date, o.date, true) && ImmunizationReactionComponent.compareDeep(this.detail, o.detail, true) && ImmunizationReactionComponent.compareDeep(this.reported, o.reported, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationReactionComponent)) {
                return false;
            }
            ImmunizationReactionComponent o = (ImmunizationReactionComponent)other_;
            return ImmunizationReactionComponent.compareValues(this.date, o.date, true) && ImmunizationReactionComponent.compareValues(this.reported, o.reported, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.date, this.detail, this.reported});
        }

        @Override
        public String fhirType() {
            return "Immunization.reaction";
        }
    }

    @Block
    public static class ImmunizationEducationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="documentType", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Educational material document identifier", formalDefinition="Identifier of the material presented to the patient.")
        protected StringType documentType;
        @Child(name="reference", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Educational material reference pointer", formalDefinition="Reference pointer to the educational material given to the patient if the information was on line.")
        protected UriType reference;
        @Child(name="publicationDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Educational material publication date", formalDefinition="Date the educational material was published.")
        protected DateTimeType publicationDate;
        @Child(name="presentationDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Educational material presentation date", formalDefinition="Date the educational material was given to the patient.")
        protected DateTimeType presentationDate;
        private static final long serialVersionUID = -1277654827L;

        public StringType getDocumentTypeElement() {
            if (this.documentType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationEducationComponent.documentType");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentType = new StringType();
                }
            }
            return this.documentType;
        }

        public boolean hasDocumentTypeElement() {
            return this.documentType != null && !this.documentType.isEmpty();
        }

        public boolean hasDocumentType() {
            return this.documentType != null && !this.documentType.isEmpty();
        }

        public ImmunizationEducationComponent setDocumentTypeElement(StringType value) {
            this.documentType = value;
            return this;
        }

        public String getDocumentType() {
            return this.documentType == null ? null : (String)this.documentType.getValue();
        }

        public ImmunizationEducationComponent setDocumentType(String value) {
            if (Utilities.noString((String)value)) {
                this.documentType = null;
            } else {
                if (this.documentType == null) {
                    this.documentType = new StringType();
                }
                this.documentType.setValue(value);
            }
            return this;
        }

        public UriType getReferenceElement() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationEducationComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new UriType();
                }
            }
            return this.reference;
        }

        public boolean hasReferenceElement() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ImmunizationEducationComponent setReferenceElement(UriType value) {
            this.reference = value;
            return this;
        }

        public String getReference() {
            return this.reference == null ? null : (String)this.reference.getValue();
        }

        public ImmunizationEducationComponent setReference(String value) {
            if (Utilities.noString((String)value)) {
                this.reference = null;
            } else {
                if (this.reference == null) {
                    this.reference = new UriType();
                }
                this.reference.setValue(value);
            }
            return this;
        }

        public DateTimeType getPublicationDateElement() {
            if (this.publicationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationEducationComponent.publicationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDate = new DateTimeType();
                }
            }
            return this.publicationDate;
        }

        public boolean hasPublicationDateElement() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public boolean hasPublicationDate() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public ImmunizationEducationComponent setPublicationDateElement(DateTimeType value) {
            this.publicationDate = value;
            return this;
        }

        public Date getPublicationDate() {
            return this.publicationDate == null ? null : (Date)this.publicationDate.getValue();
        }

        public ImmunizationEducationComponent setPublicationDate(Date value) {
            if (value == null) {
                this.publicationDate = null;
            } else {
                if (this.publicationDate == null) {
                    this.publicationDate = new DateTimeType();
                }
                this.publicationDate.setValue(value);
            }
            return this;
        }

        public DateTimeType getPresentationDateElement() {
            if (this.presentationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationEducationComponent.presentationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentationDate = new DateTimeType();
                }
            }
            return this.presentationDate;
        }

        public boolean hasPresentationDateElement() {
            return this.presentationDate != null && !this.presentationDate.isEmpty();
        }

        public boolean hasPresentationDate() {
            return this.presentationDate != null && !this.presentationDate.isEmpty();
        }

        public ImmunizationEducationComponent setPresentationDateElement(DateTimeType value) {
            this.presentationDate = value;
            return this;
        }

        public Date getPresentationDate() {
            return this.presentationDate == null ? null : (Date)this.presentationDate.getValue();
        }

        public ImmunizationEducationComponent setPresentationDate(Date value) {
            if (value == null) {
                this.presentationDate = null;
            } else {
                if (this.presentationDate == null) {
                    this.presentationDate = new DateTimeType();
                }
                this.presentationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("documentType", "string", "Identifier of the material presented to the patient.", 0, 1, this.documentType));
            children.add(new Property("reference", "uri", "Reference pointer to the educational material given to the patient if the information was on line.", 0, 1, this.reference));
            children.add(new Property("publicationDate", "dateTime", "Date the educational material was published.", 0, 1, this.publicationDate));
            children.add(new Property("presentationDate", "dateTime", "Date the educational material was given to the patient.", 0, 1, this.presentationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1473196299: {
                    return new Property("documentType", "string", "Identifier of the material presented to the patient.", 0, 1, this.documentType);
                }
                case -925155509: {
                    return new Property("reference", "uri", "Reference pointer to the educational material given to the patient if the information was on line.", 0, 1, this.reference);
                }
                case 1470566394: {
                    return new Property("publicationDate", "dateTime", "Date the educational material was published.", 0, 1, this.publicationDate);
                }
                case 1602373096: {
                    return new Property("presentationDate", "dateTime", "Date the educational material was given to the patient.", 0, 1, this.presentationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1473196299: {
                    Base[] baseArray;
                    if (this.documentType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.documentType;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
                case 1470566394: {
                    Base[] baseArray;
                    if (this.publicationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.publicationDate;
                    }
                    return baseArray;
                }
                case 1602373096: {
                    Base[] baseArray;
                    if (this.presentationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.presentationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1473196299: {
                    this.documentType = TypeConvertor.castToString(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1470566394: {
                    this.publicationDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 1602373096: {
                    this.presentationDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("documentType")) {
                this.documentType = TypeConvertor.castToString(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToUri(value);
            } else if (name.equals("publicationDate")) {
                this.publicationDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("presentationDate")) {
                this.presentationDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1473196299: {
                    return this.getDocumentTypeElement();
                }
                case -925155509: {
                    return this.getReferenceElement();
                }
                case 1470566394: {
                    return this.getPublicationDateElement();
                }
                case 1602373096: {
                    return this.getPresentationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1473196299: {
                    return new String[]{"string"};
                }
                case -925155509: {
                    return new String[]{"uri"};
                }
                case 1470566394: {
                    return new String[]{"dateTime"};
                }
                case 1602373096: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("documentType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.education.documentType");
            }
            if (name.equals("reference")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.education.reference");
            }
            if (name.equals("publicationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.education.publicationDate");
            }
            if (name.equals("presentationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Immunization.education.presentationDate");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationEducationComponent copy() {
            ImmunizationEducationComponent dst = new ImmunizationEducationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationEducationComponent dst) {
            super.copyValues(dst);
            dst.documentType = this.documentType == null ? null : this.documentType.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.publicationDate = this.publicationDate == null ? null : this.publicationDate.copy();
            dst.presentationDate = this.presentationDate == null ? null : this.presentationDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationEducationComponent)) {
                return false;
            }
            ImmunizationEducationComponent o = (ImmunizationEducationComponent)other_;
            return ImmunizationEducationComponent.compareDeep(this.documentType, o.documentType, true) && ImmunizationEducationComponent.compareDeep(this.reference, o.reference, true) && ImmunizationEducationComponent.compareDeep(this.publicationDate, o.publicationDate, true) && ImmunizationEducationComponent.compareDeep(this.presentationDate, o.presentationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationEducationComponent)) {
                return false;
            }
            ImmunizationEducationComponent o = (ImmunizationEducationComponent)other_;
            return ImmunizationEducationComponent.compareValues(this.documentType, o.documentType, true) && ImmunizationEducationComponent.compareValues(this.reference, o.reference, true) && ImmunizationEducationComponent.compareValues(this.publicationDate, o.publicationDate, true) && ImmunizationEducationComponent.compareValues(this.presentationDate, o.presentationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.documentType, this.reference, this.publicationDate, this.presentationDate});
        }

        @Override
        public String fhirType() {
            return "Immunization.education";
        }
    }

    @Block
    public static class ImmunizationPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What type of performance was done", formalDefinition="Describes the type of performance (e.g. ordering provider, administering provider, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual or organization who was performing", formalDefinition="The practitioner or organization who performed the action.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public ImmunizationPerformerComponent() {
        }

        public ImmunizationPerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ImmunizationPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ImmunizationPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Describes the type of performance (e.g. ordering provider, administering provider, etc.).", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner or organization who performed the action.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Describes the type of performance (e.g. ordering provider, administering provider, etc.).", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner or organization who performed the action.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationPerformerComponent copy() {
            ImmunizationPerformerComponent dst = new ImmunizationPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationPerformerComponent)) {
                return false;
            }
            ImmunizationPerformerComponent o = (ImmunizationPerformerComponent)other_;
            return ImmunizationPerformerComponent.compareDeep(this.function, o.function, true) && ImmunizationPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationPerformerComponent)) {
                return false;
            }
            ImmunizationPerformerComponent o = (ImmunizationPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "Immunization.performer";
        }
    }

    public static class ImmunizationStatusCodesEnumFactory
    implements EnumFactory<ImmunizationStatusCodes> {
        @Override
        public ImmunizationStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return ImmunizationStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ImmunizationStatusCodes.ENTEREDINERROR;
            }
            if ("not-done".equals(codeString)) {
                return ImmunizationStatusCodes.NOTDONE;
            }
            throw new IllegalArgumentException("Unknown ImmunizationStatusCodes code '" + codeString + "'");
        }

        public Enumeration<ImmunizationStatusCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImmunizationStatusCodes>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ImmunizationStatusCodes>(this, ImmunizationStatusCodes.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ImmunizationStatusCodes>(this, ImmunizationStatusCodes.ENTEREDINERROR);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<ImmunizationStatusCodes>(this, ImmunizationStatusCodes.NOTDONE);
            }
            throw new FHIRException("Unknown ImmunizationStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(ImmunizationStatusCodes code) {
            if (code == ImmunizationStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == ImmunizationStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ImmunizationStatusCodes.NOTDONE) {
                return "not-done";
            }
            return "?";
        }

        @Override
        public String toSystem(ImmunizationStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum ImmunizationStatusCodes {
        COMPLETED,
        ENTEREDINERROR,
        NOTDONE,
        NULL;


        public static ImmunizationStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImmunizationStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NOTDONE: {
                    return "not-done";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/event-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETED: {
                    return "The event has now concluded.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"stopped\" rather than \"entered-in-error\".).";
                }
                case NOTDONE: {
                    return "The event was terminated prior to any activity beyond preparation.  I.e. The 'main' activity has not yet begun.  The boundary between preparatory and the 'main' activity is context-specific.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NOTDONE: {
                    return "Not Done";
                }
            }
            return "?";
        }
    }
}

