/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="NutritionOrder", profile="http://hl7.org/fhir/StructureDefinition/NutritionOrder")
public class NutritionOrder
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers assigned to this order", formalDefinition="Identifiers assigned to this order by the order sender or by the order receiver.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.")
    protected List<UriType> instantiatesUri;
    @Child(name="instantiates", type={UriType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="The URL pointing to a protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.")
    protected List<UriType> instantiates;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="The workflow status of the nutrition order/request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<Enumerations.RequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option", formalDefinition="Indicates the level of authority/intentionality associated with the NutrionOrder and where the request fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<Enumerations.RequestIntent> intent;
    @Child(name="patient", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who requires the diet, formula or nutritional supplement", formalDefinition="The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.")
    protected Reference patient;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The encounter associated with this nutrition order", formalDefinition="An encounter that provides additional information about the healthcare context in which this request is made.")
    protected Reference encounter;
    @Child(name="dateTime", type={DateTimeType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date and time the nutrition order was requested", formalDefinition="The date and time that this nutrition order was requested.")
    protected DateTimeType dateTime;
    @Child(name="orderer", type={Practitioner.class, PractitionerRole.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who ordered the diet, formula or nutritional supplement", formalDefinition="The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.")
    protected Reference orderer;
    @Child(name="allergyIntolerance", type={AllergyIntolerance.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of the patient's food and nutrition-related allergies and intolerances", formalDefinition="A link to a record of allergies or intolerances  which should be included in the nutrition order.")
    protected List<Reference> allergyIntolerance;
    @Child(name="foodPreferenceModifier", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Order-specific modifier about the type of food that should be given", formalDefinition="This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
    protected List<CodeableConcept> foodPreferenceModifier;
    @Child(name="excludeFoodModifier", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Order-specific modifier about the type of food that should not be given", formalDefinition="This modifier is used to convey Order-specific modifier about the type of oral food or oral fluids that should not be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced AllergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/food-type")
    protected List<CodeableConcept> excludeFoodModifier;
    @Child(name="oralDiet", type={}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Oral diet components", formalDefinition="Diet given orally in contrast to enteral (tube) feeding.")
    protected NutritionOrderOralDietComponent oralDiet;
    @Child(name="supplement", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supplement components", formalDefinition="Oral nutritional products given in order to add further nutritional value to the patient's diet.")
    protected List<NutritionOrderSupplementComponent> supplement;
    @Child(name="enteralFormula", type={}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Enteral formula components", formalDefinition="Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.")
    protected NutritionOrderEnteralFormulaComponent enteralFormula;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments", formalDefinition="Comments made about the nutrition order by the requester, performer, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1010528149L;
    @SearchParamDefinition(name="additive", path="NutritionOrder.enteralFormula.additiveType", description="Type of module component to add to the feeding", type="token")
    public static final String SP_ADDITIVE = "additive";
    public static final TokenClientParam ADDITIVE = new TokenClientParam("additive");
    @SearchParamDefinition(name="datetime", path="NutritionOrder.dateTime", description="Return nutrition orders requested on this date", type="date")
    public static final String SP_DATETIME = "datetime";
    public static final DateClientParam DATETIME = new DateClientParam("datetime");
    @SearchParamDefinition(name="formula", path="NutritionOrder.enteralFormula.baseFormulaType", description="Type of enteral or infant formula", type="token")
    public static final String SP_FORMULA = "formula";
    public static final TokenClientParam FORMULA = new TokenClientParam("formula");
    @SearchParamDefinition(name="instantiates-canonical", path="NutritionOrder.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("NutritionOrder:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="NutritionOrder.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="oraldiet", path="NutritionOrder.oralDiet.type", description="Type of diet that can be consumed orally (i.e., take via the mouth).", type="token")
    public static final String SP_ORALDIET = "oraldiet";
    public static final TokenClientParam ORALDIET = new TokenClientParam("oraldiet");
    @SearchParamDefinition(name="provider", path="NutritionOrder.orderer", description="The identity of the provider who placed the nutrition order", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("NutritionOrder:provider").toLocked();
    @SearchParamDefinition(name="status", path="NutritionOrder.status", description="Status of the nutrition order.", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="supplement", path="NutritionOrder.supplement.type", description="Type of supplement product requested", type="token")
    public static final String SP_SUPPLEMENT = "supplement";
    public static final TokenClientParam SUPPLEMENT = new TokenClientParam("supplement");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("NutritionOrder:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("NutritionOrder:patient").toLocked();

    public NutritionOrder() {
    }

    public NutritionOrder(Enumerations.RequestStatus status, Enumerations.RequestIntent intent, Reference patient, Date dateTime) {
        this.setStatus(status);
        this.setIntent(intent);
        this.setPatient(patient);
        this.setDateTime(dateTime);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public NutritionOrder setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public NutritionOrder addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public NutritionOrder setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public NutritionOrder addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public NutritionOrder setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public NutritionOrder addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiates() {
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        return this.instantiates;
    }

    public NutritionOrder setInstantiates(List<UriType> theInstantiates) {
        this.instantiates = theInstantiates;
        return this;
    }

    public boolean hasInstantiates() {
        if (this.instantiates == null) {
            return false;
        }
        for (UriType item : this.instantiates) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesElement() {
        UriType t = new UriType();
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        this.instantiates.add(t);
        return t;
    }

    public NutritionOrder addInstantiates(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<UriType>();
        }
        this.instantiates.add(t);
        return this;
    }

    public boolean hasInstantiates(String value) {
        if (this.instantiates == null) {
            return false;
        }
        for (UriType v : this.instantiates) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NutritionOrder setStatusElement(Enumeration<Enumerations.RequestStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.RequestStatus getStatus() {
        return this.status == null ? null : (Enumerations.RequestStatus)((Object)this.status.getValue());
    }

    public NutritionOrder setStatus(Enumerations.RequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.RequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public NutritionOrder setIntentElement(Enumeration<Enumerations.RequestIntent> value) {
        this.intent = value;
        return this;
    }

    public Enumerations.RequestIntent getIntent() {
        return this.intent == null ? null : (Enumerations.RequestIntent)((Object)this.intent.getValue());
    }

    public NutritionOrder setIntent(Enumerations.RequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public NutritionOrder setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public NutritionOrder setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getDateTimeElement() {
        if (this.dateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.dateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.dateTime = new DateTimeType();
            }
        }
        return this.dateTime;
    }

    public boolean hasDateTimeElement() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public boolean hasDateTime() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public NutritionOrder setDateTimeElement(DateTimeType value) {
        this.dateTime = value;
        return this;
    }

    public Date getDateTime() {
        return this.dateTime == null ? null : (Date)this.dateTime.getValue();
    }

    public NutritionOrder setDateTime(Date value) {
        if (this.dateTime == null) {
            this.dateTime = new DateTimeType();
        }
        this.dateTime.setValue(value);
        return this;
    }

    public Reference getOrderer() {
        if (this.orderer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.orderer = new Reference();
            }
        }
        return this.orderer;
    }

    public boolean hasOrderer() {
        return this.orderer != null && !this.orderer.isEmpty();
    }

    public NutritionOrder setOrderer(Reference value) {
        this.orderer = value;
        return this;
    }

    public List<Reference> getAllergyIntolerance() {
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        return this.allergyIntolerance;
    }

    public NutritionOrder setAllergyIntolerance(List<Reference> theAllergyIntolerance) {
        this.allergyIntolerance = theAllergyIntolerance;
        return this;
    }

    public boolean hasAllergyIntolerance() {
        if (this.allergyIntolerance == null) {
            return false;
        }
        for (Reference item : this.allergyIntolerance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAllergyIntolerance() {
        Reference t = new Reference();
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        this.allergyIntolerance.add(t);
        return t;
    }

    public NutritionOrder addAllergyIntolerance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        this.allergyIntolerance.add(t);
        return this;
    }

    public Reference getAllergyIntoleranceFirstRep() {
        if (this.getAllergyIntolerance().isEmpty()) {
            this.addAllergyIntolerance();
        }
        return this.getAllergyIntolerance().get(0);
    }

    public List<CodeableConcept> getFoodPreferenceModifier() {
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        return this.foodPreferenceModifier;
    }

    public NutritionOrder setFoodPreferenceModifier(List<CodeableConcept> theFoodPreferenceModifier) {
        this.foodPreferenceModifier = theFoodPreferenceModifier;
        return this;
    }

    public boolean hasFoodPreferenceModifier() {
        if (this.foodPreferenceModifier == null) {
            return false;
        }
        for (CodeableConcept item : this.foodPreferenceModifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFoodPreferenceModifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        this.foodPreferenceModifier.add(t);
        return t;
    }

    public NutritionOrder addFoodPreferenceModifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        this.foodPreferenceModifier.add(t);
        return this;
    }

    public CodeableConcept getFoodPreferenceModifierFirstRep() {
        if (this.getFoodPreferenceModifier().isEmpty()) {
            this.addFoodPreferenceModifier();
        }
        return this.getFoodPreferenceModifier().get(0);
    }

    public List<CodeableConcept> getExcludeFoodModifier() {
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        return this.excludeFoodModifier;
    }

    public NutritionOrder setExcludeFoodModifier(List<CodeableConcept> theExcludeFoodModifier) {
        this.excludeFoodModifier = theExcludeFoodModifier;
        return this;
    }

    public boolean hasExcludeFoodModifier() {
        if (this.excludeFoodModifier == null) {
            return false;
        }
        for (CodeableConcept item : this.excludeFoodModifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addExcludeFoodModifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        this.excludeFoodModifier.add(t);
        return t;
    }

    public NutritionOrder addExcludeFoodModifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        this.excludeFoodModifier.add(t);
        return this;
    }

    public CodeableConcept getExcludeFoodModifierFirstRep() {
        if (this.getExcludeFoodModifier().isEmpty()) {
            this.addExcludeFoodModifier();
        }
        return this.getExcludeFoodModifier().get(0);
    }

    public NutritionOrderOralDietComponent getOralDiet() {
        if (this.oralDiet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.oralDiet");
            }
            if (Configuration.doAutoCreate()) {
                this.oralDiet = new NutritionOrderOralDietComponent();
            }
        }
        return this.oralDiet;
    }

    public boolean hasOralDiet() {
        return this.oralDiet != null && !this.oralDiet.isEmpty();
    }

    public NutritionOrder setOralDiet(NutritionOrderOralDietComponent value) {
        this.oralDiet = value;
        return this;
    }

    public List<NutritionOrderSupplementComponent> getSupplement() {
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        return this.supplement;
    }

    public NutritionOrder setSupplement(List<NutritionOrderSupplementComponent> theSupplement) {
        this.supplement = theSupplement;
        return this;
    }

    public boolean hasSupplement() {
        if (this.supplement == null) {
            return false;
        }
        for (NutritionOrderSupplementComponent item : this.supplement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionOrderSupplementComponent addSupplement() {
        NutritionOrderSupplementComponent t = new NutritionOrderSupplementComponent();
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        this.supplement.add(t);
        return t;
    }

    public NutritionOrder addSupplement(NutritionOrderSupplementComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        this.supplement.add(t);
        return this;
    }

    public NutritionOrderSupplementComponent getSupplementFirstRep() {
        if (this.getSupplement().isEmpty()) {
            this.addSupplement();
        }
        return this.getSupplement().get(0);
    }

    public NutritionOrderEnteralFormulaComponent getEnteralFormula() {
        if (this.enteralFormula == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.enteralFormula");
            }
            if (Configuration.doAutoCreate()) {
                this.enteralFormula = new NutritionOrderEnteralFormulaComponent();
            }
        }
        return this.enteralFormula;
    }

    public boolean hasEnteralFormula() {
        return this.enteralFormula != null && !this.enteralFormula.isEmpty();
    }

    public NutritionOrder setEnteralFormula(NutritionOrderEnteralFormulaComponent value) {
        this.enteralFormula = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public NutritionOrder setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public NutritionOrder addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the order sender or by the order receiver.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(ActivityDefinition|PlanDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("instantiates", "uri", "The URL pointing to a protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiates));
        children.add(new Property(SP_STATUS, "code", "The workflow status of the nutrition order/request.", 0, 1, this.status));
        children.add(new Property("intent", "code", "Indicates the level of authority/intentionality associated with the NutrionOrder and where the request fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.", 0, 1, this.patient));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional information about the healthcare context in which this request is made.", 0, 1, this.encounter));
        children.add(new Property("dateTime", "dateTime", "The date and time that this nutrition order was requested.", 0, 1, this.dateTime));
        children.add(new Property("orderer", "Reference(Practitioner|PractitionerRole)", "The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.", 0, 1, this.orderer));
        children.add(new Property("allergyIntolerance", "Reference(AllergyIntolerance)", "A link to a record of allergies or intolerances  which should be included in the nutrition order.", 0, Integer.MAX_VALUE, this.allergyIntolerance));
        children.add(new Property("foodPreferenceModifier", "CodeableConcept", "This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.foodPreferenceModifier));
        children.add(new Property("excludeFoodModifier", "CodeableConcept", "This modifier is used to convey Order-specific modifier about the type of oral food or oral fluids that should not be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced AllergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.excludeFoodModifier));
        children.add(new Property("oralDiet", "", "Diet given orally in contrast to enteral (tube) feeding.", 0, 1, this.oralDiet));
        children.add(new Property(SP_SUPPLEMENT, "", "Oral nutritional products given in order to add further nutritional value to the patient's diet.", 0, Integer.MAX_VALUE, this.supplement));
        children.add(new Property("enteralFormula", "", "Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.", 0, 1, this.enteralFormula));
        children.add(new Property("note", "Annotation", "Comments made about the nutrition order by the requester, performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the order sender or by the order receiver.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(ActivityDefinition|PlanDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -246883639: {
                return new Property("instantiates", "uri", "The URL pointing to a protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.", 0, Integer.MAX_VALUE, this.instantiates);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The workflow status of the nutrition order/request.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property("intent", "code", "Indicates the level of authority/intentionality associated with the NutrionOrder and where the request fits into the workflow chain.", 0, 1, this.intent);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional information about the healthcare context in which this request is made.", 0, 1, this.encounter);
            }
            case 1792749467: {
                return new Property("dateTime", "dateTime", "The date and time that this nutrition order was requested.", 0, 1, this.dateTime);
            }
            case -1207109509: {
                return new Property("orderer", "Reference(Practitioner|PractitionerRole)", "The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.", 0, 1, this.orderer);
            }
            case -120164120: {
                return new Property("allergyIntolerance", "Reference(AllergyIntolerance)", "A link to a record of allergies or intolerances  which should be included in the nutrition order.", 0, Integer.MAX_VALUE, this.allergyIntolerance);
            }
            case 659473872: {
                return new Property("foodPreferenceModifier", "CodeableConcept", "This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.foodPreferenceModifier);
            }
            case 1760260175: {
                return new Property("excludeFoodModifier", "CodeableConcept", "This modifier is used to convey Order-specific modifier about the type of oral food or oral fluids that should not be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced AllergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.excludeFoodModifier);
            }
            case 1153521250: {
                return new Property("oralDiet", "", "Diet given orally in contrast to enteral (tube) feeding.", 0, 1, this.oralDiet);
            }
            case -711993159: {
                return new Property(SP_SUPPLEMENT, "", "Oral nutritional products given in order to add further nutritional value to the patient's diet.", 0, Integer.MAX_VALUE, this.supplement);
            }
            case -671083805: {
                return new Property("enteralFormula", "", "Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.", 0, 1, this.enteralFormula);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the nutrition order by the requester, performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -246883639: {
                return this.instantiates == null ? new Base[]{} : this.instantiates.toArray(new Base[this.instantiates.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.intent;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case 1792749467: {
                Base[] baseArray;
                if (this.dateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateTime;
                }
                return baseArray;
            }
            case -1207109509: {
                Base[] baseArray;
                if (this.orderer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.orderer;
                }
                return baseArray;
            }
            case -120164120: {
                return this.allergyIntolerance == null ? new Base[]{} : this.allergyIntolerance.toArray(new Base[this.allergyIntolerance.size()]);
            }
            case 659473872: {
                return this.foodPreferenceModifier == null ? new Base[]{} : this.foodPreferenceModifier.toArray(new Base[this.foodPreferenceModifier.size()]);
            }
            case 1760260175: {
                return this.excludeFoodModifier == null ? new Base[]{} : this.excludeFoodModifier.toArray(new Base[this.excludeFoodModifier.size()]);
            }
            case 1153521250: {
                Base[] baseArray;
                if (this.oralDiet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.oralDiet;
                }
                return baseArray;
            }
            case -711993159: {
                return this.supplement == null ? new Base[]{} : this.supplement.toArray(new Base[this.supplement.size()]);
            }
            case -671083805: {
                Base[] baseArray;
                if (this.enteralFormula == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.enteralFormula;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -246883639: {
                this.getInstantiates().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1792749467: {
                this.dateTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1207109509: {
                this.orderer = TypeConvertor.castToReference(value);
                return value;
            }
            case -120164120: {
                this.getAllergyIntolerance().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 659473872: {
                this.getFoodPreferenceModifier().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1760260175: {
                this.getExcludeFoodModifier().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1153521250: {
                this.oralDiet = (NutritionOrderOralDietComponent)((Object)value);
                return value;
            }
            case -711993159: {
                this.getSupplement().add((NutritionOrderSupplementComponent)((Object)value));
                return value;
            }
            case -671083805: {
                this.enteralFormula = (NutritionOrderEnteralFormulaComponent)((Object)value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("instantiates")) {
            this.getInstantiates().add(TypeConvertor.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("intent")) {
            value = new Enumerations.RequestIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("dateTime")) {
            this.dateTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("orderer")) {
            this.orderer = TypeConvertor.castToReference(value);
        } else if (name.equals("allergyIntolerance")) {
            this.getAllergyIntolerance().add(TypeConvertor.castToReference(value));
        } else if (name.equals("foodPreferenceModifier")) {
            this.getFoodPreferenceModifier().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("excludeFoodModifier")) {
            this.getExcludeFoodModifier().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("oralDiet")) {
            this.oralDiet = (NutritionOrderOralDietComponent)((Object)value);
        } else if (name.equals(SP_SUPPLEMENT)) {
            this.getSupplement().add((NutritionOrderSupplementComponent)((Object)value));
        } else if (name.equals("enteralFormula")) {
            this.enteralFormula = (NutritionOrderEnteralFormulaComponent)((Object)value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -246883639: {
                return this.addInstantiatesElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1792749467: {
                return this.getDateTimeElement();
            }
            case -1207109509: {
                return this.getOrderer();
            }
            case -120164120: {
                return this.addAllergyIntolerance();
            }
            case 659473872: {
                return this.addFoodPreferenceModifier();
            }
            case 1760260175: {
                return this.addExcludeFoodModifier();
            }
            case 1153521250: {
                return this.getOralDiet();
            }
            case -711993159: {
                return this.addSupplement();
            }
            case -671083805: {
                return this.getEnteralFormula();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -246883639: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1792749467: {
                return new String[]{"dateTime"};
            }
            case -1207109509: {
                return new String[]{"Reference"};
            }
            case -120164120: {
                return new String[]{"Reference"};
            }
            case 659473872: {
                return new String[]{"CodeableConcept"};
            }
            case 1760260175: {
                return new String[]{"CodeableConcept"};
            }
            case 1153521250: {
                return new String[0];
            }
            case -711993159: {
                return new String[0];
            }
            case -671083805: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.instantiatesUri");
        }
        if (name.equals("instantiates")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.instantiates");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.status");
        }
        if (name.equals("intent")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.intent");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("dateTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.dateTime");
        }
        if (name.equals("orderer")) {
            this.orderer = new Reference();
            return this.orderer;
        }
        if (name.equals("allergyIntolerance")) {
            return this.addAllergyIntolerance();
        }
        if (name.equals("foodPreferenceModifier")) {
            return this.addFoodPreferenceModifier();
        }
        if (name.equals("excludeFoodModifier")) {
            return this.addExcludeFoodModifier();
        }
        if (name.equals("oralDiet")) {
            this.oralDiet = new NutritionOrderOralDietComponent();
            return this.oralDiet;
        }
        if (name.equals(SP_SUPPLEMENT)) {
            return this.addSupplement();
        }
        if (name.equals("enteralFormula")) {
            this.enteralFormula = new NutritionOrderEnteralFormulaComponent();
            return this.enteralFormula;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NutritionOrder";
    }

    @Override
    public NutritionOrder copy() {
        NutritionOrder dst = new NutritionOrder();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NutritionOrder dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.instantiates != null) {
            dst.instantiates = new ArrayList<UriType>();
            for (UriType uriType : this.instantiates) {
                dst.instantiates.add(uriType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        Reference reference = dst.orderer = this.orderer == null ? null : this.orderer.copy();
        if (this.allergyIntolerance != null) {
            dst.allergyIntolerance = new ArrayList<Reference>();
            for (Reference reference2 : this.allergyIntolerance) {
                dst.allergyIntolerance.add(reference2.copy());
            }
        }
        if (this.foodPreferenceModifier != null) {
            dst.foodPreferenceModifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.foodPreferenceModifier) {
                dst.foodPreferenceModifier.add(codeableConcept.copy());
            }
        }
        if (this.excludeFoodModifier != null) {
            dst.excludeFoodModifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.excludeFoodModifier) {
                dst.excludeFoodModifier.add(codeableConcept.copy());
            }
        }
        NutritionOrderOralDietComponent nutritionOrderOralDietComponent = dst.oralDiet = this.oralDiet == null ? null : this.oralDiet.copy();
        if (this.supplement != null) {
            dst.supplement = new ArrayList<NutritionOrderSupplementComponent>();
            for (NutritionOrderSupplementComponent nutritionOrderSupplementComponent : this.supplement) {
                dst.supplement.add(nutritionOrderSupplementComponent.copy());
            }
        }
        NutritionOrderEnteralFormulaComponent nutritionOrderEnteralFormulaComponent = dst.enteralFormula = this.enteralFormula == null ? null : this.enteralFormula.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected NutritionOrder typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionOrder)) {
            return false;
        }
        NutritionOrder o = (NutritionOrder)other_;
        return NutritionOrder.compareDeep(this.identifier, o.identifier, true) && NutritionOrder.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && NutritionOrder.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && NutritionOrder.compareDeep(this.instantiates, o.instantiates, true) && NutritionOrder.compareDeep(this.status, o.status, true) && NutritionOrder.compareDeep(this.intent, o.intent, true) && NutritionOrder.compareDeep(this.patient, o.patient, true) && NutritionOrder.compareDeep(this.encounter, o.encounter, true) && NutritionOrder.compareDeep(this.dateTime, o.dateTime, true) && NutritionOrder.compareDeep(this.orderer, o.orderer, true) && NutritionOrder.compareDeep(this.allergyIntolerance, o.allergyIntolerance, true) && NutritionOrder.compareDeep(this.foodPreferenceModifier, o.foodPreferenceModifier, true) && NutritionOrder.compareDeep(this.excludeFoodModifier, o.excludeFoodModifier, true) && NutritionOrder.compareDeep(this.oralDiet, o.oralDiet, true) && NutritionOrder.compareDeep(this.supplement, o.supplement, true) && NutritionOrder.compareDeep(this.enteralFormula, o.enteralFormula, true) && NutritionOrder.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionOrder)) {
            return false;
        }
        NutritionOrder o = (NutritionOrder)other_;
        return NutritionOrder.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && NutritionOrder.compareValues(this.instantiatesUri, o.instantiatesUri, true) && NutritionOrder.compareValues(this.instantiates, o.instantiates, true) && NutritionOrder.compareValues(this.status, o.status, true) && NutritionOrder.compareValues(this.intent, o.intent, true) && NutritionOrder.compareValues(this.dateTime, o.dateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.instantiates, this.status, this.intent, this.patient, this.encounter, this.dateTime, this.orderer, this.allergyIntolerance, this.foodPreferenceModifier, this.excludeFoodModifier, this.oralDiet, this.supplement, this.enteralFormula, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NutritionOrder;
    }

    @Block
    public static class NutritionOrderEnteralFormulaAdministrationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="schedule", type={Timing.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of enteral feeding", formalDefinition="The time period and frequency at which the enteral formula should be delivered to the patient.")
        protected Timing schedule;
        @Child(name="quantity", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The volume of formula to provide", formalDefinition="The volume of formula to provide to the patient per the specified administration schedule.")
        protected Quantity quantity;
        @Child(name="rate", type={Quantity.class, Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Speed with which the formula is provided per period of time", formalDefinition="The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.")
        protected DataType rate;
        private static final long serialVersionUID = -1312073995L;

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaAdministrationComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaAdministrationComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DataType getRate() {
            return this.rate;
        }

        public Quantity getRateQuantity() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Quantity();
            }
            if (!(this.rate instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Quantity)this.rate;
        }

        public boolean hasRateQuantity() {
            return this != null && this.rate instanceof Quantity;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Ratio();
            }
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this != null && this.rate instanceof Ratio;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setRate(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof Ratio)) {
                throw new Error("Not the right type for NutritionOrder.enteralFormula.administration.rate[x]: " + value.fhirType());
            }
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("schedule", "Timing", "The time period and frequency at which the enteral formula should be delivered to the patient.", 0, 1, this.schedule));
            children.add(new Property("quantity", "Quantity", "The volume of formula to provide to the patient per the specified administration schedule.", 0, 1, this.quantity));
            children.add(new Property("rate[x]", "Quantity|Ratio", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, 1, this.rate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -697920873: {
                    return new Property("schedule", "Timing", "The time period and frequency at which the enteral formula should be delivered to the patient.", 0, 1, this.schedule);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The volume of formula to provide to the patient per the specified administration schedule.", 0, 1, this.quantity);
                }
                case 983460768: {
                    return new Property("rate[x]", "Quantity|Ratio", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, 1, this.rate);
                }
                case 3493088: {
                    return new Property("rate[x]", "Quantity|Ratio", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, 1, this.rate);
                }
                case -1085459061: {
                    return new Property("rate[x]", "Quantity", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, 1, this.rate);
                }
                case 204021515: {
                    return new Property("rate[x]", "Ratio", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, 1, this.rate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.schedule;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    this.schedule = TypeConvertor.castToTiming(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3493088: {
                    this.rate = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("schedule")) {
                this.schedule = TypeConvertor.castToTiming(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    return this.getSchedule();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 3493088: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    return new String[]{"Timing"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 3493088: {
                    return new String[]{"Quantity", "Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("rateQuantity")) {
                this.rate = new Quantity();
                return this.rate;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderEnteralFormulaAdministrationComponent copy() {
            NutritionOrderEnteralFormulaAdministrationComponent dst = new NutritionOrderEnteralFormulaAdministrationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderEnteralFormulaAdministrationComponent dst) {
            super.copyValues(dst);
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderEnteralFormulaAdministrationComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaAdministrationComponent o = (NutritionOrderEnteralFormulaAdministrationComponent)other_;
            return NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.quantity, o.quantity, true) && NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderEnteralFormulaAdministrationComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaAdministrationComponent o = (NutritionOrderEnteralFormulaAdministrationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.schedule, this.quantity, this.rate});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.enteralFormula.administration";
        }
    }

    @Block
    public static class NutritionOrderEnteralFormulaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="baseFormulaType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of enteral or infant formula", formalDefinition="The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/entformula-type")
        protected CodeableConcept baseFormulaType;
        @Child(name="baseFormulaProductName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the enteral or infant formula", formalDefinition="The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".")
        protected StringType baseFormulaProductName;
        @Child(name="additiveType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of modular component to add to the feeding", formalDefinition="Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/entformula-additive")
        protected CodeableConcept additiveType;
        @Child(name="additiveProductName", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the modular additive", formalDefinition="The product or brand name of the type of modular component to be added to the formula.")
        protected StringType additiveProductName;
        @Child(name="caloricDensity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of energy per specified volume that is required", formalDefinition="The amount of energy (calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 calories per fluid ounce or an adult may require an enteral formula that provides 1.5 calorie/mL.")
        protected Quantity caloricDensity;
        @Child(name="routeofAdministration", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the formula should enter the patient's gastrointestinal tract", formalDefinition="The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/enteral-route")
        protected CodeableConcept routeofAdministration;
        @Child(name="administration", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Formula feeding instruction as structured data", formalDefinition="Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.")
        protected List<NutritionOrderEnteralFormulaAdministrationComponent> administration;
        @Child(name="maxVolumeToDeliver", type={Quantity.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Upper limit on formula volume per unit of time", formalDefinition="The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.")
        protected Quantity maxVolumeToDeliver;
        @Child(name="administrationInstruction", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formula feeding instructions expressed as text", formalDefinition="Free text formula administration, feeding instructions or additional instructions or information.")
        protected StringType administrationInstruction;
        private static final long serialVersionUID = -124511395L;

        public CodeableConcept getBaseFormulaType() {
            if (this.baseFormulaType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.baseFormulaType");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseFormulaType = new CodeableConcept();
                }
            }
            return this.baseFormulaType;
        }

        public boolean hasBaseFormulaType() {
            return this.baseFormulaType != null && !this.baseFormulaType.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaType(CodeableConcept value) {
            this.baseFormulaType = value;
            return this;
        }

        public StringType getBaseFormulaProductNameElement() {
            if (this.baseFormulaProductName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.baseFormulaProductName");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseFormulaProductName = new StringType();
                }
            }
            return this.baseFormulaProductName;
        }

        public boolean hasBaseFormulaProductNameElement() {
            return this.baseFormulaProductName != null && !this.baseFormulaProductName.isEmpty();
        }

        public boolean hasBaseFormulaProductName() {
            return this.baseFormulaProductName != null && !this.baseFormulaProductName.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaProductNameElement(StringType value) {
            this.baseFormulaProductName = value;
            return this;
        }

        public String getBaseFormulaProductName() {
            return this.baseFormulaProductName == null ? null : (String)this.baseFormulaProductName.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.baseFormulaProductName = null;
            } else {
                if (this.baseFormulaProductName == null) {
                    this.baseFormulaProductName = new StringType();
                }
                this.baseFormulaProductName.setValue(value);
            }
            return this;
        }

        public CodeableConcept getAdditiveType() {
            if (this.additiveType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.additiveType");
                }
                if (Configuration.doAutoCreate()) {
                    this.additiveType = new CodeableConcept();
                }
            }
            return this.additiveType;
        }

        public boolean hasAdditiveType() {
            return this.additiveType != null && !this.additiveType.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveType(CodeableConcept value) {
            this.additiveType = value;
            return this;
        }

        public StringType getAdditiveProductNameElement() {
            if (this.additiveProductName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.additiveProductName");
                }
                if (Configuration.doAutoCreate()) {
                    this.additiveProductName = new StringType();
                }
            }
            return this.additiveProductName;
        }

        public boolean hasAdditiveProductNameElement() {
            return this.additiveProductName != null && !this.additiveProductName.isEmpty();
        }

        public boolean hasAdditiveProductName() {
            return this.additiveProductName != null && !this.additiveProductName.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveProductNameElement(StringType value) {
            this.additiveProductName = value;
            return this;
        }

        public String getAdditiveProductName() {
            return this.additiveProductName == null ? null : (String)this.additiveProductName.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.additiveProductName = null;
            } else {
                if (this.additiveProductName == null) {
                    this.additiveProductName = new StringType();
                }
                this.additiveProductName.setValue(value);
            }
            return this;
        }

        public Quantity getCaloricDensity() {
            if (this.caloricDensity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.caloricDensity");
                }
                if (Configuration.doAutoCreate()) {
                    this.caloricDensity = new Quantity();
                }
            }
            return this.caloricDensity;
        }

        public boolean hasCaloricDensity() {
            return this.caloricDensity != null && !this.caloricDensity.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setCaloricDensity(Quantity value) {
            this.caloricDensity = value;
            return this;
        }

        public CodeableConcept getRouteofAdministration() {
            if (this.routeofAdministration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.routeofAdministration");
                }
                if (Configuration.doAutoCreate()) {
                    this.routeofAdministration = new CodeableConcept();
                }
            }
            return this.routeofAdministration;
        }

        public boolean hasRouteofAdministration() {
            return this.routeofAdministration != null && !this.routeofAdministration.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setRouteofAdministration(CodeableConcept value) {
            this.routeofAdministration = value;
            return this;
        }

        public List<NutritionOrderEnteralFormulaAdministrationComponent> getAdministration() {
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            return this.administration;
        }

        public NutritionOrderEnteralFormulaComponent setAdministration(List<NutritionOrderEnteralFormulaAdministrationComponent> theAdministration) {
            this.administration = theAdministration;
            return this;
        }

        public boolean hasAdministration() {
            if (this.administration == null) {
                return false;
            }
            for (NutritionOrderEnteralFormulaAdministrationComponent item : this.administration) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderEnteralFormulaAdministrationComponent addAdministration() {
            NutritionOrderEnteralFormulaAdministrationComponent t = new NutritionOrderEnteralFormulaAdministrationComponent();
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            this.administration.add(t);
            return t;
        }

        public NutritionOrderEnteralFormulaComponent addAdministration(NutritionOrderEnteralFormulaAdministrationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            this.administration.add(t);
            return this;
        }

        public NutritionOrderEnteralFormulaAdministrationComponent getAdministrationFirstRep() {
            if (this.getAdministration().isEmpty()) {
                this.addAdministration();
            }
            return this.getAdministration().get(0);
        }

        public Quantity getMaxVolumeToDeliver() {
            if (this.maxVolumeToDeliver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.maxVolumeToDeliver");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxVolumeToDeliver = new Quantity();
                }
            }
            return this.maxVolumeToDeliver;
        }

        public boolean hasMaxVolumeToDeliver() {
            return this.maxVolumeToDeliver != null && !this.maxVolumeToDeliver.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setMaxVolumeToDeliver(Quantity value) {
            this.maxVolumeToDeliver = value;
            return this;
        }

        public StringType getAdministrationInstructionElement() {
            if (this.administrationInstruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.administrationInstruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.administrationInstruction = new StringType();
                }
            }
            return this.administrationInstruction;
        }

        public boolean hasAdministrationInstructionElement() {
            return this.administrationInstruction != null && !this.administrationInstruction.isEmpty();
        }

        public boolean hasAdministrationInstruction() {
            return this.administrationInstruction != null && !this.administrationInstruction.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdministrationInstructionElement(StringType value) {
            this.administrationInstruction = value;
            return this;
        }

        public String getAdministrationInstruction() {
            return this.administrationInstruction == null ? null : (String)this.administrationInstruction.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setAdministrationInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.administrationInstruction = null;
            } else {
                if (this.administrationInstruction == null) {
                    this.administrationInstruction = new StringType();
                }
                this.administrationInstruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("baseFormulaType", "CodeableConcept", "The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.", 0, 1, this.baseFormulaType));
            children.add(new Property("baseFormulaProductName", "string", "The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".", 0, 1, this.baseFormulaProductName));
            children.add(new Property("additiveType", "CodeableConcept", "Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.", 0, 1, this.additiveType));
            children.add(new Property("additiveProductName", "string", "The product or brand name of the type of modular component to be added to the formula.", 0, 1, this.additiveProductName));
            children.add(new Property("caloricDensity", "Quantity", "The amount of energy (calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 calories per fluid ounce or an adult may require an enteral formula that provides 1.5 calorie/mL.", 0, 1, this.caloricDensity));
            children.add(new Property("routeofAdministration", "CodeableConcept", "The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.", 0, 1, this.routeofAdministration));
            children.add(new Property("administration", "", "Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.", 0, Integer.MAX_VALUE, this.administration));
            children.add(new Property("maxVolumeToDeliver", "Quantity", "The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.", 0, 1, this.maxVolumeToDeliver));
            children.add(new Property("administrationInstruction", "string", "Free text formula administration, feeding instructions or additional instructions or information.", 0, 1, this.administrationInstruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -138930641: {
                    return new Property("baseFormulaType", "CodeableConcept", "The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.", 0, 1, this.baseFormulaType);
                }
                case -1267705979: {
                    return new Property("baseFormulaProductName", "string", "The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".", 0, 1, this.baseFormulaProductName);
                }
                case -470746842: {
                    return new Property("additiveType", "CodeableConcept", "Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.", 0, 1, this.additiveType);
                }
                case 488079534: {
                    return new Property("additiveProductName", "string", "The product or brand name of the type of modular component to be added to the formula.", 0, 1, this.additiveProductName);
                }
                case 186983261: {
                    return new Property("caloricDensity", "Quantity", "The amount of energy (calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 calories per fluid ounce or an adult may require an enteral formula that provides 1.5 calorie/mL.", 0, 1, this.caloricDensity);
                }
                case -1710107042: {
                    return new Property("routeofAdministration", "CodeableConcept", "The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.", 0, 1, this.routeofAdministration);
                }
                case 1255702622: {
                    return new Property("administration", "", "Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.", 0, Integer.MAX_VALUE, this.administration);
                }
                case 2017924652: {
                    return new Property("maxVolumeToDeliver", "Quantity", "The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.", 0, 1, this.maxVolumeToDeliver);
                }
                case 427085136: {
                    return new Property("administrationInstruction", "string", "Free text formula administration, feeding instructions or additional instructions or information.", 0, 1, this.administrationInstruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    Base[] baseArray;
                    if (this.baseFormulaType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.baseFormulaType;
                    }
                    return baseArray;
                }
                case -1267705979: {
                    Base[] baseArray;
                    if (this.baseFormulaProductName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.baseFormulaProductName;
                    }
                    return baseArray;
                }
                case -470746842: {
                    Base[] baseArray;
                    if (this.additiveType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.additiveType;
                    }
                    return baseArray;
                }
                case 488079534: {
                    Base[] baseArray;
                    if (this.additiveProductName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.additiveProductName;
                    }
                    return baseArray;
                }
                case 186983261: {
                    Base[] baseArray;
                    if (this.caloricDensity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.caloricDensity;
                    }
                    return baseArray;
                }
                case -1710107042: {
                    Base[] baseArray;
                    if (this.routeofAdministration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.routeofAdministration;
                    }
                    return baseArray;
                }
                case 1255702622: {
                    return this.administration == null ? new Base[]{} : this.administration.toArray(new Base[this.administration.size()]);
                }
                case 2017924652: {
                    Base[] baseArray;
                    if (this.maxVolumeToDeliver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.maxVolumeToDeliver;
                    }
                    return baseArray;
                }
                case 427085136: {
                    Base[] baseArray;
                    if (this.administrationInstruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.administrationInstruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    this.baseFormulaType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1267705979: {
                    this.baseFormulaProductName = TypeConvertor.castToString(value);
                    return value;
                }
                case -470746842: {
                    this.additiveType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 488079534: {
                    this.additiveProductName = TypeConvertor.castToString(value);
                    return value;
                }
                case 186983261: {
                    this.caloricDensity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1710107042: {
                    this.routeofAdministration = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1255702622: {
                    this.getAdministration().add((NutritionOrderEnteralFormulaAdministrationComponent)value);
                    return value;
                }
                case 2017924652: {
                    this.maxVolumeToDeliver = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 427085136: {
                    this.administrationInstruction = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("baseFormulaType")) {
                this.baseFormulaType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("baseFormulaProductName")) {
                this.baseFormulaProductName = TypeConvertor.castToString(value);
            } else if (name.equals("additiveType")) {
                this.additiveType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("additiveProductName")) {
                this.additiveProductName = TypeConvertor.castToString(value);
            } else if (name.equals("caloricDensity")) {
                this.caloricDensity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("routeofAdministration")) {
                this.routeofAdministration = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("administration")) {
                this.getAdministration().add((NutritionOrderEnteralFormulaAdministrationComponent)value);
            } else if (name.equals("maxVolumeToDeliver")) {
                this.maxVolumeToDeliver = TypeConvertor.castToQuantity(value);
            } else if (name.equals("administrationInstruction")) {
                this.administrationInstruction = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    return this.getBaseFormulaType();
                }
                case -1267705979: {
                    return this.getBaseFormulaProductNameElement();
                }
                case -470746842: {
                    return this.getAdditiveType();
                }
                case 488079534: {
                    return this.getAdditiveProductNameElement();
                }
                case 186983261: {
                    return this.getCaloricDensity();
                }
                case -1710107042: {
                    return this.getRouteofAdministration();
                }
                case 1255702622: {
                    return this.addAdministration();
                }
                case 2017924652: {
                    return this.getMaxVolumeToDeliver();
                }
                case 427085136: {
                    return this.getAdministrationInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    return new String[]{"CodeableConcept"};
                }
                case -1267705979: {
                    return new String[]{"string"};
                }
                case -470746842: {
                    return new String[]{"CodeableConcept"};
                }
                case 488079534: {
                    return new String[]{"string"};
                }
                case 186983261: {
                    return new String[]{"Quantity"};
                }
                case -1710107042: {
                    return new String[]{"CodeableConcept"};
                }
                case 1255702622: {
                    return new String[0];
                }
                case 2017924652: {
                    return new String[]{"Quantity"};
                }
                case 427085136: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("baseFormulaType")) {
                this.baseFormulaType = new CodeableConcept();
                return this.baseFormulaType;
            }
            if (name.equals("baseFormulaProductName")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.enteralFormula.baseFormulaProductName");
            }
            if (name.equals("additiveType")) {
                this.additiveType = new CodeableConcept();
                return this.additiveType;
            }
            if (name.equals("additiveProductName")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.enteralFormula.additiveProductName");
            }
            if (name.equals("caloricDensity")) {
                this.caloricDensity = new Quantity();
                return this.caloricDensity;
            }
            if (name.equals("routeofAdministration")) {
                this.routeofAdministration = new CodeableConcept();
                return this.routeofAdministration;
            }
            if (name.equals("administration")) {
                return this.addAdministration();
            }
            if (name.equals("maxVolumeToDeliver")) {
                this.maxVolumeToDeliver = new Quantity();
                return this.maxVolumeToDeliver;
            }
            if (name.equals("administrationInstruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.enteralFormula.administrationInstruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderEnteralFormulaComponent copy() {
            NutritionOrderEnteralFormulaComponent dst = new NutritionOrderEnteralFormulaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderEnteralFormulaComponent dst) {
            super.copyValues(dst);
            dst.baseFormulaType = this.baseFormulaType == null ? null : this.baseFormulaType.copy();
            dst.baseFormulaProductName = this.baseFormulaProductName == null ? null : this.baseFormulaProductName.copy();
            dst.additiveType = this.additiveType == null ? null : this.additiveType.copy();
            dst.additiveProductName = this.additiveProductName == null ? null : this.additiveProductName.copy();
            dst.caloricDensity = this.caloricDensity == null ? null : this.caloricDensity.copy();
            CodeableConcept codeableConcept = dst.routeofAdministration = this.routeofAdministration == null ? null : this.routeofAdministration.copy();
            if (this.administration != null) {
                dst.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
                for (NutritionOrderEnteralFormulaAdministrationComponent i : this.administration) {
                    dst.administration.add(i.copy());
                }
            }
            dst.maxVolumeToDeliver = this.maxVolumeToDeliver == null ? null : this.maxVolumeToDeliver.copy();
            dst.administrationInstruction = this.administrationInstruction == null ? null : this.administrationInstruction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderEnteralFormulaComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaComponent o = (NutritionOrderEnteralFormulaComponent)other_;
            return NutritionOrderEnteralFormulaComponent.compareDeep(this.baseFormulaType, o.baseFormulaType, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.baseFormulaProductName, o.baseFormulaProductName, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.additiveType, o.additiveType, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.additiveProductName, o.additiveProductName, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.caloricDensity, o.caloricDensity, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.routeofAdministration, o.routeofAdministration, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.administration, o.administration, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.maxVolumeToDeliver, o.maxVolumeToDeliver, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.administrationInstruction, o.administrationInstruction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderEnteralFormulaComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaComponent o = (NutritionOrderEnteralFormulaComponent)other_;
            return NutritionOrderEnteralFormulaComponent.compareValues(this.baseFormulaProductName, o.baseFormulaProductName, true) && NutritionOrderEnteralFormulaComponent.compareValues(this.additiveProductName, o.additiveProductName, true) && NutritionOrderEnteralFormulaComponent.compareValues(this.administrationInstruction, o.administrationInstruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.baseFormulaType, this.baseFormulaProductName, this.additiveType, this.additiveProductName, this.caloricDensity, this.routeofAdministration, this.administration, this.maxVolumeToDeliver, this.administrationInstruction});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.enteralFormula";
        }
    }

    @Block
    public static class NutritionOrderSupplementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of supplement product requested", formalDefinition="The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplement-type")
        protected CodeableConcept type;
        @Child(name="productName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the nutritional supplement", formalDefinition="The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".")
        protected StringType productName;
        @Child(name="schedule", type={Timing.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of supplement", formalDefinition="The time period and frequency at which the supplement(s) should be given.  The supplement should be given for the combination of all schedules if more than one schedule is present.")
        protected List<Timing> schedule;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of the nutritional supplement", formalDefinition="The amount of the nutritional supplement to be given.")
        protected Quantity quantity;
        @Child(name="instruction", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Instructions or additional information about the oral supplement", formalDefinition="Free text or additional instructions or information pertaining to the oral supplement.")
        protected StringType instruction;
        private static final long serialVersionUID = -37646618L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NutritionOrderSupplementComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getProductNameElement() {
            if (this.productName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.productName");
                }
                if (Configuration.doAutoCreate()) {
                    this.productName = new StringType();
                }
            }
            return this.productName;
        }

        public boolean hasProductNameElement() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public boolean hasProductName() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public NutritionOrderSupplementComponent setProductNameElement(StringType value) {
            this.productName = value;
            return this;
        }

        public String getProductName() {
            return this.productName == null ? null : (String)this.productName.getValue();
        }

        public NutritionOrderSupplementComponent setProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.productName = null;
            } else {
                if (this.productName == null) {
                    this.productName = new StringType();
                }
                this.productName.setValue(value);
            }
            return this;
        }

        public List<Timing> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            return this.schedule;
        }

        public NutritionOrderSupplementComponent setSchedule(List<Timing> theSchedule) {
            this.schedule = theSchedule;
            return this;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (Timing item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Timing addSchedule() {
            Timing t = new Timing();
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return t;
        }

        public NutritionOrderSupplementComponent addSchedule(Timing t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return this;
        }

        public Timing getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public NutritionOrderSupplementComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public NutritionOrderSupplementComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public NutritionOrderSupplementComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement.", 0, 1, this.type));
            children.add(new Property("productName", "string", "The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".", 0, 1, this.productName));
            children.add(new Property("schedule", "Timing", "The time period and frequency at which the supplement(s) should be given.  The supplement should be given for the combination of all schedules if more than one schedule is present.", 0, Integer.MAX_VALUE, this.schedule));
            children.add(new Property("quantity", "Quantity", "The amount of the nutritional supplement to be given.", 0, 1, this.quantity));
            children.add(new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral supplement.", 0, 1, this.instruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement.", 0, 1, this.type);
                }
                case -1491817446: {
                    return new Property("productName", "string", "The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".", 0, 1, this.productName);
                }
                case -697920873: {
                    return new Property("schedule", "Timing", "The time period and frequency at which the supplement(s) should be given.  The supplement should be given for the combination of all schedules if more than one schedule is present.", 0, Integer.MAX_VALUE, this.schedule);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount of the nutritional supplement to be given.", 0, 1, this.quantity);
                }
                case 301526158: {
                    return new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral supplement.", 0, 1, this.instruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1491817446: {
                    Base[] baseArray;
                    if (this.productName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productName;
                    }
                    return baseArray;
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1491817446: {
                    this.productName = TypeConvertor.castToString(value);
                    return value;
                }
                case -697920873: {
                    this.getSchedule().add(TypeConvertor.castToTiming(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 301526158: {
                    this.instruction = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productName")) {
                this.productName = TypeConvertor.castToString(value);
            } else if (name.equals("schedule")) {
                this.getSchedule().add(TypeConvertor.castToTiming(value));
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("instruction")) {
                this.instruction = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1491817446: {
                    return this.getProductNameElement();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 301526158: {
                    return this.getInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1491817446: {
                    return new String[]{"string"};
                }
                case -697920873: {
                    return new String[]{"Timing"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 301526158: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("productName")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.supplement.productName");
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.supplement.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderSupplementComponent copy() {
            NutritionOrderSupplementComponent dst = new NutritionOrderSupplementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderSupplementComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.productName = this.productName == null ? null : this.productName.copy();
            if (this.schedule != null) {
                dst.schedule = new ArrayList<Timing>();
                for (Timing i : this.schedule) {
                    dst.schedule.add(i.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderSupplementComponent)) {
                return false;
            }
            NutritionOrderSupplementComponent o = (NutritionOrderSupplementComponent)other_;
            return NutritionOrderSupplementComponent.compareDeep(this.type, o.type, true) && NutritionOrderSupplementComponent.compareDeep(this.productName, o.productName, true) && NutritionOrderSupplementComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderSupplementComponent.compareDeep(this.quantity, o.quantity, true) && NutritionOrderSupplementComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderSupplementComponent)) {
                return false;
            }
            NutritionOrderSupplementComponent o = (NutritionOrderSupplementComponent)other_;
            return NutritionOrderSupplementComponent.compareValues(this.productName, o.productName, true) && NutritionOrderSupplementComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.productName, this.schedule, this.quantity, this.instruction});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.supplement";
        }
    }

    @Block
    public static class NutritionOrderOralDietTextureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="modifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code to indicate how to alter the texture of the foods, e.g. pureed", formalDefinition="Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/texture-code")
        protected CodeableConcept modifier;
        @Child(name="foodType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Concepts that are used to identify an entity that is ingested for nutritional purposes", formalDefinition="The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/modified-foodtype")
        protected CodeableConcept foodType;
        private static final long serialVersionUID = -56402817L;

        public CodeableConcept getModifier() {
            if (this.modifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietTextureComponent.modifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.modifier = new CodeableConcept();
                }
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public NutritionOrderOralDietTextureComponent setModifier(CodeableConcept value) {
            this.modifier = value;
            return this;
        }

        public CodeableConcept getFoodType() {
            if (this.foodType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietTextureComponent.foodType");
                }
                if (Configuration.doAutoCreate()) {
                    this.foodType = new CodeableConcept();
                }
            }
            return this.foodType;
        }

        public boolean hasFoodType() {
            return this.foodType != null && !this.foodType.isEmpty();
        }

        public NutritionOrderOralDietTextureComponent setFoodType(CodeableConcept value) {
            this.foodType = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("modifier", "CodeableConcept", "Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.", 0, 1, this.modifier));
            children.add(new Property("foodType", "CodeableConcept", "The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.", 0, 1, this.foodType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.", 0, 1, this.modifier);
                }
                case 379498680: {
                    return new Property("foodType", "CodeableConcept", "The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.", 0, 1, this.foodType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    Base[] baseArray;
                    if (this.modifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.modifier;
                    }
                    return baseArray;
                }
                case 379498680: {
                    Base[] baseArray;
                    if (this.foodType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.foodType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    this.modifier = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 379498680: {
                    this.foodType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("foodType")) {
                this.foodType = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return this.getModifier();
                }
                case 379498680: {
                    return this.getFoodType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 379498680: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = new CodeableConcept();
                return this.modifier;
            }
            if (name.equals("foodType")) {
                this.foodType = new CodeableConcept();
                return this.foodType;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietTextureComponent copy() {
            NutritionOrderOralDietTextureComponent dst = new NutritionOrderOralDietTextureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderOralDietTextureComponent dst) {
            super.copyValues(dst);
            dst.modifier = this.modifier == null ? null : this.modifier.copy();
            dst.foodType = this.foodType == null ? null : this.foodType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietTextureComponent)) {
                return false;
            }
            NutritionOrderOralDietTextureComponent o = (NutritionOrderOralDietTextureComponent)other_;
            return NutritionOrderOralDietTextureComponent.compareDeep(this.modifier, o.modifier, true) && NutritionOrderOralDietTextureComponent.compareDeep(this.foodType, o.foodType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietTextureComponent)) {
                return false;
            }
            NutritionOrderOralDietTextureComponent o = (NutritionOrderOralDietTextureComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.modifier, this.foodType});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet.texture";
        }
    }

    @Block
    public static class NutritionOrderOralDietNutrientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="modifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of nutrient that is being modified", formalDefinition="The nutrient that is being modified such as carbohydrate or sodium.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrient-code")
        protected CodeableConcept modifier;
        @Child(name="amount", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of the specified nutrient", formalDefinition="The quantity of the specified nutrient to include in diet.")
        protected Quantity amount;
        private static final long serialVersionUID = 1042462093L;

        public CodeableConcept getModifier() {
            if (this.modifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietNutrientComponent.modifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.modifier = new CodeableConcept();
                }
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public NutritionOrderOralDietNutrientComponent setModifier(CodeableConcept value) {
            this.modifier = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietNutrientComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionOrderOralDietNutrientComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("modifier", "CodeableConcept", "The nutrient that is being modified such as carbohydrate or sodium.", 0, 1, this.modifier));
            children.add(new Property("amount", "Quantity", "The quantity of the specified nutrient to include in diet.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "The nutrient that is being modified such as carbohydrate or sodium.", 0, 1, this.modifier);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "The quantity of the specified nutrient to include in diet.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    Base[] baseArray;
                    if (this.modifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.modifier;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    this.modifier = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return this.getModifier();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = new CodeableConcept();
                return this.modifier;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietNutrientComponent copy() {
            NutritionOrderOralDietNutrientComponent dst = new NutritionOrderOralDietNutrientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderOralDietNutrientComponent dst) {
            super.copyValues(dst);
            dst.modifier = this.modifier == null ? null : this.modifier.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietNutrientComponent)) {
                return false;
            }
            NutritionOrderOralDietNutrientComponent o = (NutritionOrderOralDietNutrientComponent)other_;
            return NutritionOrderOralDietNutrientComponent.compareDeep(this.modifier, o.modifier, true) && NutritionOrderOralDietNutrientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietNutrientComponent)) {
                return false;
            }
            NutritionOrderOralDietNutrientComponent o = (NutritionOrderOralDietNutrientComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.modifier, this.amount});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet.nutrient";
        }
    }

    @Block
    public static class NutritionOrderOralDietComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Type of oral diet or diet restrictions that describe what can be consumed orally", formalDefinition="The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diet-type")
        protected List<CodeableConcept> type;
        @Child(name="schedule", type={Timing.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of diet", formalDefinition="The time period and frequency at which the diet should be given.  The diet should be given for the combination of all schedules if more than one schedule is present.")
        protected List<Timing> schedule;
        @Child(name="nutrient", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Required  nutrient modifications", formalDefinition="Class that defines the quantity and type of nutrient modifications (for example carbohydrate, fiber or sodium) required for the oral diet.")
        protected List<NutritionOrderOralDietNutrientComponent> nutrient;
        @Child(name="texture", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Required  texture modifications", formalDefinition="Class that describes any texture modifications required for the patient to safely consume various types of solid foods.")
        protected List<NutritionOrderOralDietTextureComponent> texture;
        @Child(name="fluidConsistencyType", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The required consistency of fluids and liquids provided to the patient", formalDefinition="The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consistency-type")
        protected List<CodeableConcept> fluidConsistencyType;
        @Child(name="instruction", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Instructions or additional information about the oral diet", formalDefinition="Free text or additional instructions or information pertaining to the oral diet.")
        protected StringType instruction;
        private static final long serialVersionUID = 973058412L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public NutritionOrderOralDietComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<Timing> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            return this.schedule;
        }

        public NutritionOrderOralDietComponent setSchedule(List<Timing> theSchedule) {
            this.schedule = theSchedule;
            return this;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (Timing item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Timing addSchedule() {
            Timing t = new Timing();
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addSchedule(Timing t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return this;
        }

        public Timing getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public List<NutritionOrderOralDietNutrientComponent> getNutrient() {
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            return this.nutrient;
        }

        public NutritionOrderOralDietComponent setNutrient(List<NutritionOrderOralDietNutrientComponent> theNutrient) {
            this.nutrient = theNutrient;
            return this;
        }

        public boolean hasNutrient() {
            if (this.nutrient == null) {
                return false;
            }
            for (NutritionOrderOralDietNutrientComponent item : this.nutrient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderOralDietNutrientComponent addNutrient() {
            NutritionOrderOralDietNutrientComponent t = new NutritionOrderOralDietNutrientComponent();
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            this.nutrient.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addNutrient(NutritionOrderOralDietNutrientComponent t) {
            if (t == null) {
                return this;
            }
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            this.nutrient.add(t);
            return this;
        }

        public NutritionOrderOralDietNutrientComponent getNutrientFirstRep() {
            if (this.getNutrient().isEmpty()) {
                this.addNutrient();
            }
            return this.getNutrient().get(0);
        }

        public List<NutritionOrderOralDietTextureComponent> getTexture() {
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            return this.texture;
        }

        public NutritionOrderOralDietComponent setTexture(List<NutritionOrderOralDietTextureComponent> theTexture) {
            this.texture = theTexture;
            return this;
        }

        public boolean hasTexture() {
            if (this.texture == null) {
                return false;
            }
            for (NutritionOrderOralDietTextureComponent item : this.texture) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderOralDietTextureComponent addTexture() {
            NutritionOrderOralDietTextureComponent t = new NutritionOrderOralDietTextureComponent();
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            this.texture.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addTexture(NutritionOrderOralDietTextureComponent t) {
            if (t == null) {
                return this;
            }
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            this.texture.add(t);
            return this;
        }

        public NutritionOrderOralDietTextureComponent getTextureFirstRep() {
            if (this.getTexture().isEmpty()) {
                this.addTexture();
            }
            return this.getTexture().get(0);
        }

        public List<CodeableConcept> getFluidConsistencyType() {
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            return this.fluidConsistencyType;
        }

        public NutritionOrderOralDietComponent setFluidConsistencyType(List<CodeableConcept> theFluidConsistencyType) {
            this.fluidConsistencyType = theFluidConsistencyType;
            return this;
        }

        public boolean hasFluidConsistencyType() {
            if (this.fluidConsistencyType == null) {
                return false;
            }
            for (CodeableConcept item : this.fluidConsistencyType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addFluidConsistencyType() {
            CodeableConcept t = new CodeableConcept();
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            this.fluidConsistencyType.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addFluidConsistencyType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            this.fluidConsistencyType.add(t);
            return this;
        }

        public CodeableConcept getFluidConsistencyTypeFirstRep() {
            if (this.getFluidConsistencyType().isEmpty()) {
                this.addFluidConsistencyType();
            }
            return this.getFluidConsistencyType().get(0);
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public NutritionOrderOralDietComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public NutritionOrderOralDietComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("schedule", "Timing", "The time period and frequency at which the diet should be given.  The diet should be given for the combination of all schedules if more than one schedule is present.", 0, Integer.MAX_VALUE, this.schedule));
            children.add(new Property("nutrient", "", "Class that defines the quantity and type of nutrient modifications (for example carbohydrate, fiber or sodium) required for the oral diet.", 0, Integer.MAX_VALUE, this.nutrient));
            children.add(new Property("texture", "", "Class that describes any texture modifications required for the patient to safely consume various types of solid foods.", 0, Integer.MAX_VALUE, this.texture));
            children.add(new Property("fluidConsistencyType", "CodeableConcept", "The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.", 0, Integer.MAX_VALUE, this.fluidConsistencyType));
            children.add(new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral diet.", 0, 1, this.instruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.", 0, Integer.MAX_VALUE, this.type);
                }
                case -697920873: {
                    return new Property("schedule", "Timing", "The time period and frequency at which the diet should be given.  The diet should be given for the combination of all schedules if more than one schedule is present.", 0, Integer.MAX_VALUE, this.schedule);
                }
                case -1671151641: {
                    return new Property("nutrient", "", "Class that defines the quantity and type of nutrient modifications (for example carbohydrate, fiber or sodium) required for the oral diet.", 0, Integer.MAX_VALUE, this.nutrient);
                }
                case -1417816805: {
                    return new Property("texture", "", "Class that describes any texture modifications required for the patient to safely consume various types of solid foods.", 0, Integer.MAX_VALUE, this.texture);
                }
                case -525105592: {
                    return new Property("fluidConsistencyType", "CodeableConcept", "The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.", 0, Integer.MAX_VALUE, this.fluidConsistencyType);
                }
                case 301526158: {
                    return new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral diet.", 0, 1, this.instruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1671151641: {
                    return this.nutrient == null ? new Base[]{} : this.nutrient.toArray(new Base[this.nutrient.size()]);
                }
                case -1417816805: {
                    return this.texture == null ? new Base[]{} : this.texture.toArray(new Base[this.texture.size()]);
                }
                case -525105592: {
                    return this.fluidConsistencyType == null ? new Base[]{} : this.fluidConsistencyType.toArray(new Base[this.fluidConsistencyType.size()]);
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -697920873: {
                    this.getSchedule().add(TypeConvertor.castToTiming(value));
                    return value;
                }
                case -1671151641: {
                    this.getNutrient().add((NutritionOrderOralDietNutrientComponent)value);
                    return value;
                }
                case -1417816805: {
                    this.getTexture().add((NutritionOrderOralDietTextureComponent)value);
                    return value;
                }
                case -525105592: {
                    this.getFluidConsistencyType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 301526158: {
                    this.instruction = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("schedule")) {
                this.getSchedule().add(TypeConvertor.castToTiming(value));
            } else if (name.equals("nutrient")) {
                this.getNutrient().add((NutritionOrderOralDietNutrientComponent)value);
            } else if (name.equals("texture")) {
                this.getTexture().add((NutritionOrderOralDietTextureComponent)value);
            } else if (name.equals("fluidConsistencyType")) {
                this.getFluidConsistencyType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("instruction")) {
                this.instruction = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1671151641: {
                    return this.addNutrient();
                }
                case -1417816805: {
                    return this.addTexture();
                }
                case -525105592: {
                    return this.addFluidConsistencyType();
                }
                case 301526158: {
                    return this.getInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -697920873: {
                    return new String[]{"Timing"};
                }
                case -1671151641: {
                    return new String[0];
                }
                case -1417816805: {
                    return new String[0];
                }
                case -525105592: {
                    return new String[]{"CodeableConcept"};
                }
                case 301526158: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("nutrient")) {
                return this.addNutrient();
            }
            if (name.equals("texture")) {
                return this.addTexture();
            }
            if (name.equals("fluidConsistencyType")) {
                return this.addFluidConsistencyType();
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type NutritionOrder.oralDiet.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietComponent copy() {
            NutritionOrderOralDietComponent dst = new NutritionOrderOralDietComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionOrderOralDietComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            if (this.schedule != null) {
                dst.schedule = new ArrayList<Timing>();
                for (Timing timing : this.schedule) {
                    dst.schedule.add(timing.copy());
                }
            }
            if (this.nutrient != null) {
                dst.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
                for (NutritionOrderOralDietNutrientComponent nutritionOrderOralDietNutrientComponent : this.nutrient) {
                    dst.nutrient.add(nutritionOrderOralDietNutrientComponent.copy());
                }
            }
            if (this.texture != null) {
                dst.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
                for (NutritionOrderOralDietTextureComponent nutritionOrderOralDietTextureComponent : this.texture) {
                    dst.texture.add(nutritionOrderOralDietTextureComponent.copy());
                }
            }
            if (this.fluidConsistencyType != null) {
                dst.fluidConsistencyType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.fluidConsistencyType) {
                    dst.fluidConsistencyType.add(codeableConcept.copy());
                }
            }
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietComponent)) {
                return false;
            }
            NutritionOrderOralDietComponent o = (NutritionOrderOralDietComponent)other_;
            return NutritionOrderOralDietComponent.compareDeep(this.type, o.type, true) && NutritionOrderOralDietComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderOralDietComponent.compareDeep(this.nutrient, o.nutrient, true) && NutritionOrderOralDietComponent.compareDeep(this.texture, o.texture, true) && NutritionOrderOralDietComponent.compareDeep(this.fluidConsistencyType, o.fluidConsistencyType, true) && NutritionOrderOralDietComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionOrderOralDietComponent)) {
                return false;
            }
            NutritionOrderOralDietComponent o = (NutritionOrderOralDietComponent)other_;
            return NutritionOrderOralDietComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.schedule, this.nutrient, this.texture, this.fluidConsistencyType, this.instruction});
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet";
        }
    }
}

