/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class DOMWrappers {

    public static class ResourceWrapperElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<BaseWrappers.ResourceWrapper> list;
        private List<BaseWrappers.PropertyWrapper> list2;

        public ResourceWrapperElement(RenderingContext context, Element wrapped, StructureDefinition definition) {
            super(context);
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<BaseWrappers.ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList children = new ArrayList();
                XMLUtil.getNamedChildren((Element)this.wrapped, (String)"contained", children);
                this.list = new ArrayList<BaseWrappers.ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild((Element)e);
                    this.list.add(new ResourceWrapperElement(this.context, c, this.context.getWorker().fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue((Element)this.wrapped, (String)"id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild((Element)this.wrapped, (String)"text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
            if (div == null) {
                return null;
            }
            try {
                return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = this.context.getProfileUtilities().getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.wrapped, (String)this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.context, this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void describe(XhtmlNode x) {
            throw new Error("Not done yet");
        }

        @Override
        public void injectNarrative(XhtmlNode x, Narrative.NarrativeStatus status) {
            Element st;
            Element txt;
            Element le;
            String l;
            if (!x.hasAttribute("xmlns")) {
                x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
            String string = l = (le = XMLUtil.getNamedChild((Element)this.wrapped, (String)"language")) == null ? null : le.getAttribute("value");
            if (!Utilities.noString((String)l)) {
                x.setAttribute("lang", l);
                x.setAttribute("xml:lang", l);
            }
            if ((txt = XMLUtil.getNamedChild((Element)this.wrapped, (String)"text")) == null) {
                txt = this.wrapped.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
                Element n = XMLUtil.getFirstChild((Element)this.wrapped);
                while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                    n = XMLUtil.getNextSibling((Element)n);
                }
                if (n == null) {
                    this.wrapped.appendChild(txt);
                } else {
                    this.wrapped.insertBefore(txt, n);
                }
            }
            if ((st = XMLUtil.getNamedChild((Element)txt, (String)"status")) == null) {
                st = this.wrapped.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
                Element n = XMLUtil.getFirstChild((Element)txt);
                if (n == null) {
                    txt.appendChild(st);
                } else {
                    txt.insertBefore(st, n);
                }
            }
            st.setAttribute("value", status.toCode());
            Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
            if (div == null) {
                div = this.wrapped.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
                div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                txt.appendChild(div);
            }
            if (div.hasChildNodes()) {
                div.appendChild(this.wrapped.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
            }
            new XhtmlComposer(true, this.context.isPretty()).compose(div, x);
        }

        @Override
        public BaseWrappers.BaseWrapper root() {
            return new BaseWrapperElement(this.context, this.wrapped, this.getName(), this.definition, this.definition.getSnapshot().getElementFirstRep());
        }

        @Override
        public StructureDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public Base getBase() {
            throw new Error("Not Implemented yet");
        }

        @Override
        public boolean hasNarrative() {
            StructureDefinition sd = this.definition;
            while (sd != null) {
                if ("DomainResource".equals(sd.getType())) {
                    return true;
                }
                sd = this.context.getWorker().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
            return false;
        }

        @Override
        public String fhirType() {
            return this.wrapped.getNodeName();
        }
    }

    public static class PropertyWrapperElement
    extends BaseWrappers.RendererWrapperImpl
    implements BaseWrappers.PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrappers.BaseWrapper> list;

        public PropertyWrapperElement(RenderingContext context, StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            super(context);
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrappers.BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(this.context, e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getWorkingCode().equals("Element") || this.definition.getType().get(0).getWorkingCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getWorkingCode();
            }
            String t = e.getNodeName().substring(this.tail(this.definition.getPath()).length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize((String)t))) {
                return Utilities.uncapitalize((String)t);
            }
            return t;
        }

        private boolean isPrimitive(String code) {
            StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(code);
            return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
        }

        @Override
        public String getTypeCode() {
            if (this.definition == null || this.definition.getType().size() != 1) {
                if (this.values.size() != 1) {
                    throw new Error("not handled");
                }
                String tn = this.values.get(0).getLocalName().substring(this.tail(this.definition.getPath()).replace("[x]", "").length());
                if (this.isPrimitive(Utilities.uncapitalize((String)tn))) {
                    return Utilities.uncapitalize((String)tn);
                }
                return tn;
            }
            return this.definition.getType().get(0).getWorkingCode();
        }

        @Override
        public String getDefinition() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrappers.BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }

        @Override
        public BaseWrappers.ResourceWrapper getAsResource() {
            throw new Error("Not implemented yet");
        }

        @Override
        public String fhirType() {
            return this.getTypeCode();
        }

        @Override
        public ElementDefinition getElementDefinition() {
            return this.definition;
        }
    }

    public static class BaseWrapperElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<BaseWrappers.PropertyWrapper> list;

        public BaseWrapperElement(RenderingContext context, Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            super(context);
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            String xml;
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            try {
                xml = new XmlGenerator().generate(this.element);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            return this.context.getParser().parseType(xml, this.type);
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list == null) {
                this.children = this.context.getProfileUtilities().getChildList(this.structure, this.definition);
                if (this.children.isEmpty() && this.type != null) {
                    StructureDefinition sdt = this.context.getWorker().fetchTypeDefinition(this.type);
                    this.children = this.context.getProfileUtilities().getChildList(sdt, sdt.getSnapshot().getElementFirstRep());
                }
                this.list = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.element, (String)this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.context, this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            for (BaseWrappers.PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }

        @Override
        public String fhirType() {
            return this.type;
        }
    }
}

