/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireRenderer
extends TerminologyRenderer {
    public QuestionnaireRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (Questionnaire)q);
    }

    public boolean render(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case LOGIC: {
                return this.renderLogic(x, q);
            }
            case DEFNS: {
                return this.renderDefns(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown Questionnaire Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        boolean hasFlags = this.checkForFlags(q.getItem());
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), !this.forResource);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Text"), this.translate("sd.hint", "Text for the item"), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.translate("sd.head", "Cardinality"), this.translate("sd.hint", "Minimum and Maximum # of times the the itemcan appear in the instance"), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.translate("sd.head", "Type"), this.translate("sd.hint", "The type of the item"), null, 0));
        if (hasFlags) {
            List list5 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, model.getDocoRef(), this.translate("sd.head", "Flags"), this.translate("sd.hint", "Other attributes of the item"), null, 0));
        }
        List list6 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        list6.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator7, null, model.getDocoRef(), this.translate("sd.head", "Description & Constraints"), this.translate("sd.hint", "Additional information about the item"), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q, hasFlags);
        for (Questionnaire.QuestionnaireItemComponent i : q.getItem()) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), q, i, hasFlags) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private boolean checkForFlags(List<Questionnaire.QuestionnaireItemComponent> items) {
        for (Questionnaire.QuestionnaireItemComponent i : items) {
            if (!this.checkForFlags(i)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(Questionnaire.QuestionnaireItemComponent i) {
        if (i.getReadOnly()) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            return true;
        }
        return this.checkForFlags(i.getItem());
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", "QuestionnaireRoot");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getName(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, "Questionnaire", null, null));
        if (hasFlags) {
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        }
        List list6 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator6);
        list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, q.getDescription(), null, null));
        return r;
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Piece p;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i.getType().toCode().toLowerCase() + ".png", i.getType().getDisplay());
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), i.getLinkId(), null, null));
        String txt = (i.hasPrefix() ? i.getPrefix() + ". " : "") + i.getText();
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, txt, null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, (i.getRequired() ? "1" : "0") + ".." + (i.getRepeats() ? "*" : "1"), null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, this.context.getSpecificationLink() + "codesystem-item-type.html#" + i.getType().toCode(), i.getType().toCode(), null, null));
        if (hasFlags) {
            HierarchicalTableGenerator.Cell flags = new HierarchicalTableGenerator.Cell(gen);
            r.getCells().add(flags);
            if (i.getReadOnly()) {
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, Utilities.pathURL((String[])new String[]{this.context.getSpecificationLink(), "questionnaire-definitions.html#Questionnaire.item.readOnly"}), null, "Is Readonly").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-readonly.png"}))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", null, "Can change the subject of the questionnaire").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-subject.png"}))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, Utilities.pathURL((String[])new String[]{this.context.getSpecificationLink(), "extension-questionnaire-hidden.html"}), null, "Is a hidden item").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-hidden.png"}))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", null, "Is optional to display").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-optional.png"}))));
            }
            if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", null, "Is linked to an observation").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-observation.png"}))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
                String code = ToolingExtensions.readStringExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator10);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", null, "Orientation: " + code).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-" + code + ".png"}))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
                CodeableConcept cc = i.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
                String string = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
                HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator11);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-displayCategory", null, "Category: " + string).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("src", Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-" + string + ".png"}))));
            }
        }
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.hasMaxLength()) {
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, "Max Length: ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, Integer.toString(i.getMaxLength()), null));
        }
        if (i.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator14);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator15);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, "Definition: ", null));
            this.genDefinitionLink(gen, i, defn);
        }
        if (i.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator16);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, "br"));
            }
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator17);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, "Enable When: ", null);
            defn.getPieces().add(p);
            if (i.getEnableWhen().size() == 0) {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "span");
                p.getChildren().add(xhtmlNode);
                this.renderEnableWhen(xhtmlNode, i.getEnableWhenFirstRep());
            } else {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "ul");
                p.getChildren().add(xhtmlNode);
                for (Questionnaire.QuestionnaireItemEnableWhenComponent qi : i.getEnableWhen()) {
                    this.renderEnableWhen(xhtmlNode.li(), qi);
                }
            }
        }
        if (i.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator18);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
            }
            List list8 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator19);
            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, "Value Set: ", null));
            if (i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator20);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, i.getAnswerValueSet(), null));
                } else {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i.getAnswerValueSet());
                if (vs == null || !((Base)vs).hasUserData("path")) {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, i.getAnswerValueSet(), null));
                } else {
                    List list12 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator23);
                    list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator24);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, "br"));
            }
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator25);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, "Options: ", null));
            List list14 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator26);
            list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), null));
        }
        if (i.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator27);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, "br"));
                }
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator28);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, "Initial Value: ", null));
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator29);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List list17 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator30);
                list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List list18 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator31 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator31);
                    list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator31, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                List list19 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator32 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator32);
                list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator32, null, "{todo}", null));
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator33 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator33);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator33, "br"));
            }
            List list20 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator34 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator34);
            list20.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator34, null, "Expressions: ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator35 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator35);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator35, "ul");
            defn.getPieces().add(p);
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), "Initial Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), "Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), "Item Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), "Enable When", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), "Calculated Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), "Candidates", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i.getItem()) {
            hasExt = this.renderTreeItem(gen, r.getSubRows(), q, questionnaireItemComponent, hasFlags) || hasExt;
        }
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, Questionnaire.QuestionnaireItemComponent i, HierarchicalTableGenerator.Cell defn) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
            }
        } else {
            List list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, Questionnaire.QuestionnaireItemComponent i) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d)) != null) {
            String url = sd.getUserString("path");
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i.getDefinition());
            }
        } else {
            x.tx(i.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(url).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    private boolean renderLogic(XhtmlNode x, Questionnaire q) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        model.setDocoImg(this.context.getSpecificationLink() + "help16.png");
        model.setDocoRef(this.context.getSpecificationLink() + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "LinkId"), this.translate("sd.hint", "The linkId for the item"), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", "Description & Constraints"), this.translate("sd.hint", "Additional information about the item"), null, 0));
        boolean hasExt = false;
        if (!q.hasItem()) {
            gen.emptyRow(model, 2);
        } else {
            for (Questionnaire.QuestionnaireItemComponent i : q.getItem()) {
                hasExt = this.renderLogicItem(gen, model.getRows(), q, i) || hasExt;
            }
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private boolean renderLogicItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i.getType().toCode().toLowerCase() + ".png", i.getType().getDisplay());
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), i.getLinkId(), null, null));
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.hasMaxLength()) {
            List list2 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "Max Length: ", null));
            List list3 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, Integer.toString(i.getMaxLength()), null));
        }
        if (i.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, "br"));
            }
            List list4 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "Definition: ", null));
            this.genDefinitionLink(gen, i, defn);
        }
        if (i.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "br"));
            }
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, "Enable When: ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, "todo", null));
        }
        if (i.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, "Value Set: ", null));
            if (i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List list8 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, i.getAnswerValueSet(), null));
                } else {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i.getAnswerValueSet());
                if (vs == null || !((Base)vs).hasUserData("path")) {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator13);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, i.getAnswerValueSet(), null));
                } else {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, ((Base)vs).getUserString("path"), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List list12 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator16);
            list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, "Options: ", null));
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator17);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), null));
        }
        if (i.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator18);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
                }
                List list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator19);
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, "Initial Value: ", null));
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator20);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator21);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List list17 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                List list18 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator23);
                list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, "{todo}", null));
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator24);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, "br"));
            }
            List list19 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator25);
            list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, "Expressions: ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator26);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, "ul");
            defn.getPieces().add(p);
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), "Initial Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), "Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), "Item Context", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), "Enable When", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), "Calculated Value", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), "Candidates", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i.getItem()) {
            hasExt = this.renderLogicItem(gen, r.getSubRows(), q, questionnaireItemComponent) || hasExt;
        }
        return hasExt;
    }

    public boolean renderForm(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        boolean hasPrefix = false;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasPrefix = hasPrefix || this.doesItemHavePrefix(c);
        }
        int i = 1;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasExt = this.renderFormItem(d, q, c, hasPrefix ? null : Integer.toString(i), 0) || hasExt;
            ++i;
        }
        return hasExt;
    }

    private boolean doesItemHavePrefix(Questionnaire.QuestionnaireItemComponent i) {
        if (i.hasPrefix()) {
            return true;
        }
        for (Questionnaire.QuestionnaireItemComponent c : i.getItem()) {
            if (!this.doesItemHavePrefix(c)) continue;
            return true;
        }
        return false;
    }

    private boolean renderFormItem(XhtmlNode x, Questionnaire q, Questionnaire.QuestionnaireItemComponent i, String pfx, int indent) throws IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div().style("width: " + Integer.toString(900 - indent * 10) + "px; border-top: 1px #eeeeee solid");
        if (indent > 0) {
            d.style("margin-left: " + Integer.toString(10 * indent) + "px");
        }
        XhtmlNode display = d.div().style("display: inline-block; width: " + Integer.toString(500 - indent * 10) + "px");
        XhtmlNode details = d.div().style("border: 1px #ccccff solid; padding: 2px; display: inline-block; background-color: #fefce7; width: 380px");
        XhtmlNode p = display.para();
        if (i.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
            p = p.b();
        }
        if (i.hasPrefix()) {
            p.tx(i.getPrefix());
            p.tx(": ");
        }
        p.span(null, "linkId: " + i.getLinkId()).tx(i.getText());
        if (i.getRequired()) {
            p.span("color: red", "Mandatory").tx("*");
        }
        XhtmlNode input = null;
        switch (i.getType()) {
            case STRING: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "text", i.getType().getDisplay(), 60);
                break;
            }
            case ATTACHMENT: {
                break;
            }
            case BOOLEAN: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "checkbox", i.getType().getDisplay(), 1);
                break;
            }
            case CHOICE: {
                input = p.select(i.getLinkId());
                this.listOptions(q, i, input);
                break;
            }
            case DATE: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "date", i.getType().getDisplay(), 10);
                break;
            }
            case DATETIME: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "datetime-local", i.getType().getDisplay(), 25);
                break;
            }
            case DECIMAL: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", i.getType().getDisplay(), 15);
                break;
            }
            case DISPLAY: {
                break;
            }
            case GROUP: {
                break;
            }
            case INTEGER: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", i.getType().getDisplay(), 10);
                break;
            }
            case OPENCHOICE: {
                break;
            }
            case QUANTITY: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", "value", 15);
                p.tx(" ");
                input = p.input(i.getLinkId(), "unit", "unit", 10);
                break;
            }
            case QUESTION: {
                break;
            }
            case REFERENCE: {
                break;
            }
            case TEXT: {
                break;
            }
            case TIME: {
                break;
            }
            case URL: {
                break;
            }
        }
        if (input != null && i.getReadOnly()) {
            input.attribute("readonly", "1");
            input.style("background-color: #eeeeee");
        }
        XhtmlNode ul = details.ul();
        boolean hasFlag = false;
        XhtmlNode flags = this.item(ul, "Flags");
        this.item(ul, "linkId", i.getLinkId());
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "Can change the subject of the questionnaire").img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-subject.png"}));
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            hasFlag = true;
            flags.ah(Utilities.pathURL((String[])new String[]{this.context.getSpecificationLink(), "extension-questionnaire-hidden.html"}), "Is a hidden item").img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-hidden.png"}));
            d.style("background-color: #eeeeee");
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "Is optional to display").img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-optional.png"}));
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", "Is linked to an observation").img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-observation.png"}));
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            CodeableConcept cc = i.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
            String code = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
            hasFlag = true;
            flags.ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-displayCategory", "Category: " + code).img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon-qi-" + code + ".png"}));
        }
        if (i.hasMaxLength()) {
            this.item(ul, "Max Length", Integer.toString(i.getMaxLength()));
        }
        if (i.hasDefinition()) {
            this.genDefinitionLink(this.item(ul, "Definition"), i);
        }
        if (i.hasEnableWhen()) {
            this.item(ul, "Enable When", "todo");
        }
        if (i.hasAnswerValueSet()) {
            ValueSet vs;
            XhtmlNode ans = this.item(ul, "Answers");
            if (i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null) {
                    ans.tx(i.getAnswerValueSet());
                } else {
                    ans.ah(vs.getUserString("path")).tx(vs.present());
                }
            } else {
                vs = this.context.getWorker().fetchResource(ValueSet.class, i.getAnswerValueSet());
                if (vs == null || !vs.hasUserData("path")) {
                    ans.tx(i.getAnswerValueSet());
                } else {
                    ans.ah(vs.getUserString("path")).tx(vs.present());
                }
            }
        }
        if (i.hasAnswerOption()) {
            this.item(ul, "Answers", Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), this.context.getDefinitionsTarget() + "#item." + i.getLinkId());
        }
        if (i.hasInitial()) {
            XhtmlNode vi = this.item(ul, "Initial Values");
            boolean first = true;
            for (Questionnaire.QuestionnaireItemInitialComponent v : i.getInitial()) {
                if (first) {
                    first = false;
                } else {
                    vi.tx(", ");
                }
                if (v.getValue().isPrimitive()) {
                    vi.tx(v.getValue().primitiveValue());
                    continue;
                }
                vi.tx("{todo}");
            }
        }
        if (!hasFlag) {
            ul.remove(flags);
        }
        int t = 1;
        for (Questionnaire.QuestionnaireItemComponent c : i.getItem()) {
            hasExt = this.renderFormItem(x, q, c, pfx == null ? null : pfx + "." + Integer.toString(t), indent + 1) || hasExt;
            ++t;
        }
        return hasExt;
    }

    private void item(XhtmlNode ul, String name, String value, String valueLink) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").ah(valueLink).tx(name + ": " + value);
        }
    }

    private void item(XhtmlNode ul, String name, String value) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").tx(name + ": " + value);
        }
    }

    private XhtmlNode item(XhtmlNode ul, String name) {
        XhtmlNode li = ul.li();
        li.style("font-size: 10px").tx(name + ": ");
        return li;
    }

    private void listOptions(Questionnaire q, Questionnaire.QuestionnaireItemComponent i, XhtmlNode select) {
        if (i.hasAnswerValueSet()) {
            ValueSetExpander.ValueSetExpansionOutcome exp;
            ValueSet vs = null;
            if (i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1)).copy();
                if (vs != null && !vs.hasUrl()) {
                    vs.setUrl("urn:uuid:" + UUID.randomUUID().toString().toLowerCase());
                }
            } else {
                vs = this.context.getContext().fetchResource(ValueSet.class, i.getAnswerValueSet());
            }
            if (vs != null && (exp = this.context.getContext().expandVS(vs, true, false)).getValueset() != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                    select.option(cc.getCode(), cc.hasDisplay() ? cc.getDisplay() : cc.getCode(), false);
                }
                return;
            }
        } else if (i.hasAnswerOption()) {
            // empty if block
        }
        select.option("a", "??", false);
    }

    @Override
    public String display(Resource dr) throws UnsupportedEncodingException, IOException {
        return this.display((Questionnaire)dr);
    }

    public String display(Questionnaire q) throws UnsupportedEncodingException, IOException {
        return "Questionnaire " + q.present();
    }

    private boolean renderLinks(XhtmlNode x, Questionnaire q) {
        x.para().tx("Try this questionnaire out:");
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getSelfLink(), "package.tgz"}) + "&q=" + q.getId() + ".json").tx("NLM Forms Library");
        return false;
    }

    private boolean renderDefns(XhtmlNode x, Questionnaire q) throws IOException {
        XhtmlNode tbl = x.table("dict");
        boolean ext = false;
        ext = this.renderRootDefinition(tbl, q, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        for (Questionnaire.QuestionnaireItemComponent qi : q.getItem()) {
            ext = this.renderDefinition(tbl, q, qi, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        }
        return ext;
    }

    private boolean renderRootDefinition(XhtmlNode tbl, Questionnaire q, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        boolean first;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an(q.getId());
        td.img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon_q_root.gif"}));
        td.tx(" Questionnaire ");
        td.b().tx(q.getId());
        this.defn(tbl, "URL", q.getUrl());
        this.defn(tbl, "Version", q.getVersion());
        this.defn(tbl, "Name", q.getName());
        this.defn(tbl, "Title", q.getTitle());
        if (q.hasDerivedFrom()) {
            td = this.defn(tbl, "Derived From");
            first = true;
            for (CanonicalType canonicalType : q.getDerivedFrom()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(canonicalType.asStringValue());
            }
        }
        this.defn(tbl, "Status", q.getStatus().getDisplay());
        this.defn(tbl, "Experimental", q.getExperimental());
        this.defn(tbl, "Publication Date", q.getDateElement().primitiveValue());
        this.defn(tbl, "Approval Date", q.getApprovalDateElement().primitiveValue());
        this.defn(tbl, "Last Review Date", q.getLastReviewDateElement().primitiveValue());
        if (q.hasEffectivePeriod()) {
            this.renderPeriod(this.defn(tbl, "Effective Period"), q.getEffectivePeriod());
        }
        if (q.hasSubjectType()) {
            td = this.defn(tbl, "Subject Type");
            first = true;
            for (CodeType codeType : q.getSubjectType()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(codeType.asStringValue());
            }
        }
        this.defn(tbl, "Description", q.getDescription());
        this.defn(tbl, "Purpose", q.getPurpose());
        this.defn(tbl, "Copyright", q.getCopyright());
        if (q.hasCode()) {
            td = this.defn(tbl, Utilities.pluralize((String)"Code", (int)q.getCode().size()));
            first = true;
            for (Coding coding : q.getCode()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.renderCodingWithDetails(td, coding);
            }
        }
        return false;
    }

    private boolean renderDefinition(XhtmlNode tbl, Questionnaire q, Questionnaire.QuestionnaireItemComponent qi, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        XhtmlNode li;
        XhtmlNode ul;
        XhtmlNode tr;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an("item." + qi.getLinkId());
        for (Questionnaire.QuestionnaireItemComponent p : parents) {
            td.ah("#item." + p.getLinkId()).img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon_q_item.png"}));
            td.tx(" > ");
        }
        td.img(Utilities.path((String[])new String[]{this.context.getLocalPrefix(), "icon_q_item.png"}));
        td.tx(" Item ");
        td.b().tx(qi.getLinkId());
        this.defn(tbl, "Link Id", qi.getLinkId());
        this.defn(tbl, "Prefix", qi.getPrefix());
        this.defn(tbl, "Text", qi.getText());
        this.defn(tbl, "Type", qi.getType().getDisplay());
        this.defn(tbl, "Required", qi.getRequired(), true);
        this.defn(tbl, "Repeats", qi.getRepeats(), true);
        this.defn(tbl, "Read Only", qi.getReadOnly(), false);
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            this.defn(tbl, "Subject", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "This element changes who the subject of the question is", null);
        }
        this.defn(tbl, "Max Length", qi.getMaxLength());
        if (qi.hasAnswerValueSet()) {
            this.defn(tbl, "Value Set", qi.getDefinition(), this.context.getWorker().fetchResource(ValueSet.class, qi.getAnswerValueSet()));
        }
        if (qi.hasAnswerOption()) {
            tr = tbl.tr();
            tr.td().tx("Allowed Answers");
            ul = tr.td().ul();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : qi.getAnswerOption()) {
                li = ul.li();
                this.render(li, questionnaireItemAnswerOptionComponent.getValue());
                if (!questionnaireItemAnswerOptionComponent.getInitialSelected()) continue;
                li.tx(" (initially selected)");
            }
        }
        if (qi.hasInitial()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)"Initial Answer", (int)qi.getInitial().size()));
            if (qi.getInitial().size() == 1) {
                this.render(tr.td(), qi.getInitialFirstRep().getValue());
            } else {
                ul = tr.td().ul();
                for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : qi.getInitial()) {
                    li = ul.li();
                    this.render(li, questionnaireItemInitialComponent.getValue());
                }
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").tx("Display Category");
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValue());
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            this.defn(tbl, "Hidden Item", "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", "This item is a hidden question", null);
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            this.defn(tbl, "Hidden Item", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "This item is optional to display", null);
        }
        if (qi.hasDefinition()) {
            this.genDefinitionLink(this.defn(tbl, "Definition"), qi);
        }
        if (qi.hasCode()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)"Code", (int)qi.getCode().size()));
            ul = tr.td().ul();
            for (Coding coding : qi.getCode()) {
                this.renderCodingWithDetails(ul.li(), coding);
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").tx("Observation Link Period");
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").getValue());
        }
        if (qi.hasEnableWhen()) {
            tr = tbl.tr();
            tr.td().tx("Enable When");
            td = tr.td();
            if (qi.getEnableWhen().size() == 1) {
                this.renderEnableWhen(td, qi.getEnableWhen().get(0));
            } else {
                td.tx(qi.getEnableBehavior().getDisplay() + " are true:");
                ul = td.ul();
                for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : qi.getEnableWhen()) {
                    this.renderEnableWhen(ul.li(), questionnaireItemEnableWhenComponent);
                }
            }
        }
        ArrayList<Questionnaire.QuestionnaireItemComponent> curr = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        curr.addAll(parents);
        curr.add(qi);
        for (Questionnaire.QuestionnaireItemComponent qic : qi.getItem()) {
            ext = this.renderDefinition(tbl, q, qic, curr) || ext;
        }
        return ext;
    }

    private void defn(XhtmlNode tbl, String name, String url, Resource res) throws UnsupportedEncodingException, IOException {
        if (res != null && res.hasUserData("path")) {
            this.defn(tbl, "Definition", RendererFactory.factory(res, this.context).display(res), res.getUserString("path"));
        } else if (Utilities.isAbsoluteUrl((String)url)) {
            this.defn(tbl, "Definition", url, url);
        }
        this.defn(tbl, "Definition", url);
    }

    private void renderEnableWhen(XhtmlNode x, Questionnaire.QuestionnaireItemEnableWhenComponent ew) {
        x.ah("#item." + ew.getQuestion()).tx(ew.getQuestion());
        x.tx(" ");
        x.tx(ew.getOperator().toCode());
        x.tx(" ");
        x.tx(this.display(ew.getAnswer()));
    }

    private XhtmlNode defn(XhtmlNode tbl, String name) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        return tr.td();
    }

    private void defn(XhtmlNode tbl, String name, int value) {
        if (value > 0) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        tr.td().tx(Boolean.toString(value));
    }

    private void defn(XhtmlNode tbl, String name, String value) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().ah(url).tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String nurl, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().ah(nurl).tx(name);
            if (url != null) {
                tr.td().ah(url).tx(value);
            } else {
                tr.td().tx(value);
            }
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value, boolean ifFalse) {
        if (ifFalse || value) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(Boolean.toString(value));
        }
    }
}

