/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ValueSetRenderer
extends TerminologyRenderer {
    private static final String ABSTRACT_CODE_HINT = "This code is not selectable ('Abstract')";
    private static final int MAX_LANGS_IN_LINE = 5;
    private List<TerminologyRenderer.ConceptMapRenderInstructions> renderingMaps = new ArrayList<TerminologyRenderer.ConceptMapRenderInstructions>();

    public ValueSetRenderer(RenderingContext context) {
        super(context);
    }

    public ValueSetRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (ValueSet)dr, false);
    }

    public boolean render(XhtmlNode x, ValueSet vs, boolean header) throws FHIRFormatError, DefinitionException, IOException {
        List<TerminologyRenderer.UsedConceptMap> maps = this.findReleventMaps(vs);
        boolean hasExtensions = vs.hasExpansion() ? this.generateExpansion(x, vs, header, maps) : this.generateComposition(x, vs, header, maps);
        return hasExtensions;
    }

    public void describe(XhtmlNode x, ValueSet vs) {
        x.tx(this.display(vs));
    }

    public String display(ValueSet vs) {
        return vs.present();
    }

    private List<TerminologyRenderer.UsedConceptMap> findReleventMaps(ValueSet vs) throws FHIRException {
        ArrayList<TerminologyRenderer.UsedConceptMap> res = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        for (CanonicalResource md : this.getContext().getWorker().allConformanceResources()) {
            TerminologyRenderer.ConceptMapRenderInstructions re;
            ConceptMap cm;
            if (!(md instanceof ConceptMap) || !this.isSource(vs, (cm = (ConceptMap)md).getSource()) || (re = this.findByTarget(cm.getTarget())) == null) continue;
            ValueSet vst = cm.hasTarget() ? this.getContext().getWorker().fetchResource(ValueSet.class, cm.hasTargetCanonicalType() ? (String)cm.getTargetCanonicalType().getValue() : cm.getTargetUriType().asStringValue()) : null;
            res.add(new TerminologyRenderer.UsedConceptMap(re, vst == null ? cm.getUserString("path") : vst.getUserString("path"), cm));
        }
        return res;
    }

    private boolean isSource(ValueSet vs, DataType source) {
        return vs.hasUrl() && source != null && vs.getUrl().equals(source.primitiveValue());
    }

    private boolean generateExpansion(XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        if (header) {
            XhtmlNode h = x.addTag(this.getHeader());
            h.tx("Value Set Contents");
            if (this.IsNotFixedExpansion(vs)) {
                this.addMarkdown(x, vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            List<Extension> exl = vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
            boolean other = false;
            for (Extension extension : exl) {
                if (extension.getValue() instanceof BooleanType) {
                    x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(vs.getExpansion().getContains().isEmpty() ? this.getContext().getTooCostlyNoteEmpty() : this.getContext().getTooCostlyNoteNotEmpty());
                    continue;
                }
                if (other) continue;
                x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(vs.getExpansion().getContains().isEmpty() ? this.getContext().getTooCostlyNoteEmptyDependent() : this.getContext().getTooCostlyNoteNotEmptyDependent());
                other = true;
            }
        } else {
            Integer count = this.countMembership(vs);
            if (count == null) {
                x.para().tx("This value set does not contain a fixed number of concepts");
            } else {
                x.para().tx("This value set contains " + count.toString() + " concepts");
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/tools/StructureDefinition/expansion-codesystem-fragment")) {
            XhtmlNode div = x.div().style("border: maroon 1px solid; background-color: #FFCCCC; padding: 8px");
            List<Extension> exl = vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/expansion-codesystem-fragment");
            if (exl.size() > 1) {
                div.para().addText("Warning: this expansion is generated from fragments of the following code systems, and may be missing codes, or include codes that are not valid:");
                XhtmlNode ul = div.ul();
                for (Extension ex : exl) {
                    this.addCSRef(ul.li(), ex.getValue().primitiveValue());
                }
            } else {
                XhtmlNode p = div.para();
                p.addText("Warning: this expansion is generated from a fragment of the code system ");
                this.addCSRef(p, exl.get(0).getValue().primitiveValue());
                p.addText(" and may be missing codes, or include codes that are not valid");
            }
        }
        this.generateVersionNotice(x, vs.getExpansion());
        CodeSystem allCS = null;
        boolean doLevel = false;
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : vs.getExpansion().getContains()) {
            if (!valueSetExpansionContainsComponent.hasContains()) continue;
            doLevel = true;
            break;
        }
        boolean doSystem = true;
        boolean bl = this.checkDoDefinition(vs.getExpansion().getContains());
        if (doSystem && this.allFromOneSystem(vs)) {
            doSystem = false;
            XhtmlNode p = x.para();
            p.tx("All codes from system ");
            allCS = this.getContext().getWorker().fetchCodeSystem(vs.getExpansion().getContains().get(0).getSystem());
            String ref = null;
            if (allCS != null) {
                ref = this.getCsRef(allCS);
            }
            if (ref == null) {
                p.code(vs.getExpansion().getContains().get(0).getSystem());
            } else {
                p.ah(this.context.fixReference(ref)).code(vs.getExpansion().getContains().get(0).getSystem());
            }
        }
        XhtmlNode t = x.table("codes");
        XhtmlNode tr = t.tr();
        if (doLevel) {
            tr.td().b().tx("Lvl");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx("Code");
        if (doSystem) {
            tr.td().b().tx("System");
        }
        XhtmlNode tdDisp = tr.td();
        tdDisp.b().tx("Display");
        boolean doLangs = false;
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.scanForLangs(c, langs);
        }
        if (bl) {
            tr.td().b().tx("Definition");
            doLangs = false;
        } else if (langs.size() < 5) {
            doLangs = true;
            if (vs.hasLanguage()) {
                tdDisp.tx(" - " + this.describeLang(vs.getLanguage()));
            }
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
        }
        this.addMapHeaders(tr, maps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, c, 0, doLevel, doSystem, bl, maps, allCS, langs, doLangs);
        }
        if (!doLangs && langs.size() > 0) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            t = x.table("codes");
            tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasValueSet()) {
                return true;
            }
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private TerminologyRenderer.ConceptMapRenderInstructions findByTarget(DataType source) {
        if (source == null) {
            return null;
        }
        String src = source.primitiveValue();
        if (src != null) {
            for (TerminologyRenderer.ConceptMapRenderInstructions t : this.renderingMaps) {
                if (!src.equals(t.getUrl())) continue;
                return t;
            }
        }
        return null;
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += this.conceptCount(vs.getExpansion().getContains());
        } else if (vs.hasCompose()) {
            if (vs.getCompose().hasExclude()) {
                try {
                    ValueSetExpander.ValueSetExpansionOutcome vse = this.getContext().getWorker().expandVS(vs, true, false);
                    count = 0;
                    return count += this.conceptCount(vse.getValueset().getExpansion().getContains());
                }
                catch (Exception e) {
                    return null;
                }
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                if (inc.hasFilter()) {
                    return null;
                }
                if (!inc.hasConcept()) {
                    return null;
                }
                count += inc.getConcept().size();
            }
        }
        return count;
    }

    private int conceptCount(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int count = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (!c.getAbstract()) {
                ++count;
            }
            count += this.conceptCount(c.getContains());
        }
        return count;
    }

    private void addCSRef(XhtmlNode x, String url) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(url);
        if (cs == null) {
            x.code(url);
        } else if (cs.hasUserData("path")) {
            x.ah(cs.getUserString("path")).tx(cs.present());
        } else {
            x.code(url);
            x.tx(" (" + cs.present() + ")");
        }
    }

    private void generateVersionNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion) {
        HashMultimap versions = HashMultimap.create();
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            String[] parts;
            if (!p.getName().equals("version") || (parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|")).length != 2) continue;
            versions.put((Object)parts[0], (Object)parts[1]);
        }
        if (versions.size() > 0) {
            XhtmlNode div = null;
            XhtmlNode ul = null;
            boolean first = true;
            for (String s : versions.keySet()) {
                if (versions.size() == 1 && versions.get((Object)s).size() == 1) {
                    for (String v : versions.get((Object)s)) {
                        XhtmlNode p = x.para().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        p.tx("Expansion based on ");
                        this.expRef(p, s, v);
                    }
                    continue;
                }
                for (String v : versions.get((Object)s)) {
                    if (first) {
                        div = x.div().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        div.para().tx("Expansion based on: ");
                        ul = div.ul();
                        first = false;
                    }
                    this.expRef(ul.li(), s, v);
                }
            }
        }
    }

    private void expRef(XhtmlNode x, String u, String v) {
        if (u.equals("http://snomed.info/sct")) {
            String[] parts = v.split("\\/");
            if (parts.length >= 5) {
                String m = this.describeModule(parts[4]);
                if (parts.length == 7) {
                    x.tx("SNOMED CT " + m + " edition " + this.formatSCTDate(parts[6]));
                } else {
                    x.tx("SNOMED CT " + m + " edition");
                }
            } else {
                x.tx(ValueSetRenderer.describeSystem(u) + " version " + v);
            }
        } else if (u.equals("http://loinc.org")) {
            String vd = this.describeLoincVer(v);
            if (vd != null) {
                x.tx("Loinc v" + v + " (" + vd + ")");
            } else {
                x.tx("Loinc v" + v);
            }
        } else {
            CanonicalResource cr = (CanonicalResource)this.getContext().getWorker().fetchResource(Resource.class, u + "|" + v);
            if (cr != null) {
                if (cr.hasUserData("path")) {
                    x.ah(cr.getUserString("path")).tx(cr.present() + " v" + v + " (" + cr.fhirType() + ")");
                } else {
                    x.tx(ValueSetRenderer.describeSystem(u) + " v" + v + " (" + cr.fhirType() + ")");
                }
            } else {
                x.tx(ValueSetRenderer.describeSystem(u) + " version " + v);
            }
        }
    }

    private String describeLoincVer(String v) {
        if ("2.67".equals(v)) {
            return "Dec 2019";
        }
        if ("2.66".equals(v)) {
            return "Jun 2019";
        }
        if ("2.65".equals(v)) {
            return "Dec 2018";
        }
        if ("2.64".equals(v)) {
            return "Jun 2018";
        }
        if ("2.63".equals(v)) {
            return "Dec 2017";
        }
        if ("2.61".equals(v)) {
            return "Jun 2017";
        }
        if ("2.59".equals(v)) {
            return "Feb 2017";
        }
        if ("2.58".equals(v)) {
            return "Dec 2016";
        }
        if ("2.56".equals(v)) {
            return "Jun 2016";
        }
        if ("2.54".equals(v)) {
            return "Dec 2015";
        }
        if ("2.52".equals(v)) {
            return "Jun 2015";
        }
        if ("2.50".equals(v)) {
            return "Dec 2014";
        }
        if ("2.48".equals(v)) {
            return "Jun 2014";
        }
        if ("2.46".equals(v)) {
            return "Dec 2013";
        }
        if ("2.44".equals(v)) {
            return "Jun 2013";
        }
        if ("2.42".equals(v)) {
            return "Dec 2012";
        }
        if ("2.40".equals(v)) {
            return "Jun 2012";
        }
        if ("2.38".equals(v)) {
            return "Dec 2011";
        }
        if ("2.36".equals(v)) {
            return "Jun 2011";
        }
        if ("2.34".equals(v)) {
            return "Dec 2010";
        }
        if ("2.32".equals(v)) {
            return "Jun 2010";
        }
        if ("2.30".equals(v)) {
            return "Feb 2010";
        }
        if ("2.29".equals(v)) {
            return "Dec 2009";
        }
        if ("2.27".equals(v)) {
            return "Jul 2009";
        }
        if ("2.26".equals(v)) {
            return "Jan 2009";
        }
        if ("2.24".equals(v)) {
            return "Jul 2008";
        }
        if ("2.22".equals(v)) {
            return "Dec 2007";
        }
        if ("2.21".equals(v)) {
            return "Jun 2007";
        }
        if ("2.19".equals(v)) {
            return "Dec 2006";
        }
        if ("2.17".equals(v)) {
            return "Jun 2006";
        }
        if ("2.16".equals(v)) {
            return "Dec 2005";
        }
        if ("2.15".equals(v)) {
            return "Jun 2005";
        }
        if ("2.14".equals(v)) {
            return "Dec 2004";
        }
        if ("2.13".equals(v)) {
            return "Aug 2004";
        }
        if ("2.12".equals(v)) {
            return "Feb 2004";
        }
        if ("2.10".equals(v)) {
            return "Oct 2003";
        }
        if ("2.09".equals(v)) {
            return "May 2003";
        }
        if ("2.08 ".equals(v)) {
            return "Sep 2002";
        }
        if ("2.07".equals(v)) {
            return "Aug 2002";
        }
        if ("2.05".equals(v)) {
            return "Feb 2002";
        }
        if ("2.04".equals(v)) {
            return "Jan 2002";
        }
        if ("2.03".equals(v)) {
            return "Jul 2001";
        }
        if ("2.02".equals(v)) {
            return "May 2001";
        }
        if ("2.01".equals(v)) {
            return "Jan 2001";
        }
        if ("2.00".equals(v)) {
            return "Jan 2001";
        }
        if ("1.0n".equals(v)) {
            return "Feb 2000";
        }
        if ("1.0ma".equals(v)) {
            return "Aug 1999";
        }
        if ("1.0m".equals(v)) {
            return "Jul 1999";
        }
        if ("1.0l".equals(v)) {
            return "Jan 1998";
        }
        if ("1.0ja".equals(v)) {
            return "Oct 1997";
        }
        return null;
    }

    private String formatSCTDate(String ds) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            date = format.parse(ds);
        }
        catch (ParseException e) {
            return ds;
        }
        return new SimpleDateFormat("dd-MMM yyyy").format(date);
    }

    private String describeModule(String module) {
        if ("900000000000207008".equals(module)) {
            return "International";
        }
        if ("731000124108".equals(module)) {
            return "United States";
        }
        if ("32506021000036107".equals(module)) {
            return "Australian";
        }
        if ("449081005".equals(module)) {
            return "Spanish";
        }
        if ("554471000005108".equals(module)) {
            return "Danish";
        }
        if ("11000146104".equals(module)) {
            return "Dutch";
        }
        if ("45991000052106".equals(module)) {
            return "Swedish";
        }
        if ("999000041000000102".equals(module)) {
            return "United Kingdon";
        }
        return module;
    }

    private boolean hasVersionParameter(ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().equals("version")) continue;
            return true;
        }
        return false;
    }

    private void addLanguageRow(ValueSet.ValueSetExpansionContainsComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        this.addLangaugesToRow(c, langs, tr);
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addLanguageRow(cc, t, langs);
        }
    }

    public void addLangaugesToRow(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ToolingExtensions.readStringExtension(ext, "lang"))) continue;
                d = ToolingExtensions.readStringExtension(ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private boolean checkDoDefinition(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            if (cs != null) {
                return true;
            }
            if (!this.checkDoDefinition(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private String getCsRef(String system) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(system);
        return this.getCsRef(cs);
    }

    private <T extends Resource> String getCsRef(T cs) {
        String ref = (String)cs.getUserData("filename");
        if (ref == null) {
            ref = (String)cs.getUserData("path");
        }
        if (ref == null) {
            return "?ngen-14?.html";
        }
        if (!ref.contains(".html")) {
            ref = ref + ".html";
        }
        return ref.replace("\\", "/");
    }

    private void scanForLangs(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs) {
        String lang;
        for (Extension ext : c.getExtension()) {
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : c.getDesignation()) {
            lang = d.getLanguage();
            if (Utilities.noString((String)lang) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.scanForLangs(cc, langs);
        }
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doLevel, boolean doSystem, boolean doDefinition, List<TerminologyRenderer.UsedConceptMap> maps, CodeSystem allCS, List<String> langs, boolean doLangs) {
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        td.an(tgt);
        if (doLevel) {
            td.addText(Integer.toString(i));
            td = tr.td();
        }
        String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
        td.attribute("style", "white-space:nowrap").addText(s);
        this.addCodeToTable(c.getAbstract(), c.getSystem(), c.getCode(), c.getDisplay(), td);
        if (doSystem) {
            td = tr.td();
            td.addText(c.getSystem());
        }
        td = tr.td();
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        if (doDefinition) {
            CodeSystem cs = allCS;
            if (cs == null) {
                cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            }
            td = tr.td();
            if (cs != null) {
                td.addText(CodeSystemUtilities.getCodeDefinition(cs, c.getCode()));
            }
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.getRelationship().toString());
                span.addText(this.getCharForRelationship(mapping.comp));
                this.addRefToCode(td, mapping.group.getTarget(), m.getLink(), mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        if (doLangs) {
            this.addLangaugesToRow(c, langs, tr);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, cc, i + 1, doLevel, doSystem, doDefinition, maps, allCS, langs, doLangs);
        }
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private void addCodeToTable(boolean isAbstract, String system, String code, String display, XhtmlNode td) {
        CodeSystem e = this.getContext().getWorker().fetchCodeSystem(system);
        if (e == null || e.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            if (isAbstract) {
                td.i().setAttribute("title", ABSTRACT_CODE_HINT).addText(code);
            } else if ("http://snomed.info/sct".equals(system)) {
                td.ah(this.sctLink(code)).addText(code);
            } else if ("http://loinc.org".equals(system)) {
                td.ah("http://details.loinc.org/LOINC/" + code + ".html").addText(code);
            } else {
                td.addText(code);
            }
        } else {
            String href = this.context.fixReference(this.getCsRef(e));
            href = href.contains("#") ? href + "-" + Utilities.nmtokenize((String)code) : href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)code);
            if (isAbstract) {
                td.ah(href).setAttribute("title", ABSTRACT_CODE_HINT).i().addText(code);
            } else {
                td.ah(href).addText(code);
            }
        }
    }

    public String sctLink(String code) {
        return "http://browser.ihtsdotools.org/?perspective=full&conceptId1=" + code;
    }

    private void addRefToCode(XhtmlNode td, String target, String vslink, String code) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(target);
        String cslink = this.getCsRef(cs);
        XhtmlNode a = null;
        a = cslink != null ? td.ah(this.getContext().getSpecificationLink() + cslink + "#" + cs.getId() + "-" + code) : td.ah(this.getContext().getSpecificationLink() + vslink + "#" + code);
        a.addText(code);
    }

    private boolean generateComposition(XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRException, IOException {
        boolean doLangs;
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.scanForLangs(inc, langs);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.scanForLangs(inc, langs);
        }
        boolean bl = doLangs = langs.size() < 5;
        if (header) {
            XhtmlNode h = x.h2();
            h.addText(vs.present());
            this.addMarkdown(x, vs.getDescription());
            if (vs.hasCopyrightElement()) {
                this.generateCopyright(x, vs);
            }
        }
        if (vs.getCompose().getInclude().size() == 1 && vs.getCompose().getExclude().size() == 0) {
            hasExtensions = this.genInclude(x.ul(), vs.getCompose().getInclude().get(0), "Include", langs, doLangs, maps) || hasExtensions;
        } else {
            XhtmlNode p = x.para();
            p.tx("This value set includes codes based on the following rules:");
            XhtmlNode ul = x.ul();
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                hasExtensions = this.genInclude(ul, inc, "Include", langs, doLangs, maps) || hasExtensions;
            }
            if (vs.getCompose().hasExclude()) {
                p = x.para();
                p.tx("This value set excludes codes based on the following rules:");
                ul = x.ul();
                for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
                    hasExtensions = this.genInclude(ul, exc, "Exclude", langs, doLangs, maps) || hasExtensions;
                }
            }
        }
        if (!doLangs && langs.size() > 0) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            XhtmlNode t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ConceptSetComponent c : vs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent cc : c.getConcept()) {
                    this.addLanguageRow(cc, t, langs);
                }
            }
        }
        return hasExtensions;
    }

    private void scanForLangs(ValueSet.ConceptSetComponent inc, List<String> langs) {
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String lang;
            for (Extension ext : cc.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
                langs.add(lang);
            }
            for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
                lang = d.getLanguage();
                if (Utilities.noString((String)lang) || langs.contains(lang)) continue;
                langs.add(lang);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean genInclude(XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type, List<String> langs, boolean doLangs, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRException, IOException {
        boolean hasExtensions;
        block37: {
            XhtmlNode li;
            block36: {
                hasExtensions = false;
                li = ul.li();
                CodeSystem e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
                if (!inc.hasSystem()) break block36;
                if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
                    li.addText(type + " all codes defined in ");
                    this.addCsRef(inc, li, e);
                } else {
                    if (inc.getConcept().size() > 0) {
                        boolean bl;
                        li.addText(type + " these codes as defined in ");
                        this.addCsRef(inc, li, e);
                        if (inc.hasVersion()) {
                            li.addText(" version ");
                            li.code(inc.getVersion());
                        }
                        Map<String, CodeSystem.ConceptDefinitionComponent> definitions = this.getConceptsForCodes(e, inc);
                        XhtmlNode t = li.table("none");
                        boolean bl2 = false;
                        boolean hasDefinition = false;
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            bl = bl || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments");
                            CodeSystem.ConceptDefinitionComponent cc = definitions.get(c.getCode());
                            hasDefinition = hasDefinition || cc != null && cc.hasDefinition() || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition");
                        }
                        if (bl || hasDefinition) {
                            hasExtensions = true;
                        }
                        this.addMapHeaders(this.addTableHeaderRowStandard(t, false, true, hasDefinition, bl, false, false, null, langs, doLangs), maps);
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            XhtmlNode tr = t.tr();
                            XhtmlNode td = tr.td();
                            CodeSystem.ConceptDefinitionComponent cc = definitions.get(c.getCode());
                            this.addCodeToTable(false, inc.getSystem(), c.getCode(), c.hasDisplay() ? c.getDisplay() : (cc != null ? cc.getDisplay() : ""), td);
                            td = tr.td();
                            if (!Utilities.noString((String)c.getDisplay())) {
                                td.addText(c.getDisplay());
                            } else if (cc != null && !Utilities.noString((String)cc.getDisplay())) {
                                td.addText(cc.getDisplay());
                            }
                            if (hasDefinition) {
                                td = tr.td();
                                if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition")) {
                                    this.smartAddText(td, ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"));
                                } else if (cc != null && !Utilities.noString((String)cc.getDefinition())) {
                                    this.smartAddText(td, cc.getDefinition());
                                }
                            }
                            if (bl) {
                                td = tr.td();
                                if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments")) {
                                    this.smartAddText(td, "Note: " + ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments"));
                                }
                            }
                            if (!doLangs) continue;
                            this.addLangaugesToRow(c, langs, tr);
                        }
                    }
                    if (inc.getFilter().size() > 0) {
                        li.addText(type + " codes from ");
                        this.addCsRef(inc, li, e);
                        li.tx(" where ");
                        for (int i = 0; i < inc.getFilter().size(); ++i) {
                            ValueSet.ConceptSetFilterComponent f = inc.getFilter().get(i);
                            if (i > 0) {
                                if (i == inc.getFilter().size() - 1) {
                                    li.tx(" and ");
                                } else {
                                    li.tx(", ");
                                }
                            }
                            if (f.getOp() == Enumerations.FilterOperator.EXISTS) {
                                if (f.getValue().equals("true")) {
                                    li.tx(f.getProperty() + " exists");
                                    continue;
                                }
                                li.tx(f.getProperty() + " doesn't exist");
                                continue;
                            }
                            li.tx(f.getProperty() + " " + this.describe(f.getOp()) + " ");
                            if (e != null && this.codeExistsInValueSet(e, f.getValue())) {
                                void var12_21;
                                String string = this.getContext().fixReference(this.getCsRef(e));
                                if (string.contains("#")) {
                                    String string2 = string + "-" + Utilities.nmtokenize((String)f.getValue());
                                } else {
                                    String string3 = string + "#" + e.getId() + "-" + Utilities.nmtokenize((String)f.getValue());
                                }
                                li.ah((String)var12_21).addText(f.getValue());
                            } else if ("concept".equals(f.getProperty()) && inc.hasSystem()) {
                                li.addText(f.getValue());
                                IWorkerContext.ValidationResult validationResult = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions(), inc.getSystem(), f.getValue(), null);
                                if (validationResult.isOk()) {
                                    li.tx(" (" + validationResult.getDisplay() + ")");
                                }
                            } else {
                                li.addText(f.getValue());
                            }
                            String string = ToolingExtensions.getDisplayHint(f);
                            if (string == null) continue;
                            li.tx(" (" + string + ")");
                        }
                    }
                }
                if (!inc.hasValueSet()) break block37;
                li.tx(", where the codes are contained in ");
                boolean first = true;
                for (UriType uriType : inc.getValueSet()) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    this.AddVsRef(uriType.asStringValue(), li);
                }
                break block37;
            }
            li.tx("Import all the codes that are contained in ");
            boolean first = true;
            for (UriType uriType : inc.getValueSet()) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                this.AddVsRef(uriType.asStringValue(), li);
            }
        }
        return hasExtensions;
    }

    public void addLangaugesToRow(ValueSet.ConceptReferenceComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ToolingExtensions.readStringExtension(ext, "lang"))) continue;
                d = ToolingExtensions.readStringExtension(ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private Map<String, CodeSystem.ConceptDefinitionComponent> getConceptsForCodes(CodeSystem e, ValueSet.ConceptSetComponent inc) {
        if (e == null) {
            e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
        }
        ValueSet.ValueSetExpansionComponent vse = null;
        if (!this.context.isNoSlowLookup() && !this.getContext().getWorker().hasCache()) {
            try {
                ValueSetExpander.ValueSetExpansionOutcome vso = this.getContext().getWorker().expandVS(inc, false);
                ValueSet valueset = vso.getValueset();
                if (valueset == null) {
                    throw new TerminologyServiceException("Error Expanding ValueSet: " + vso.getError());
                }
                vse = valueset.getExpansion();
            }
            catch (TerminologyServiceException e1) {
                return null;
            }
        }
        HashMap<String, CodeSystem.ConceptDefinitionComponent> results = new HashMap<String, CodeSystem.ConceptDefinitionComponent>();
        ArrayList<IWorkerContext.CodingValidationRequest> serverList = new ArrayList<IWorkerContext.CodingValidationRequest>();
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String code = cc.getCode();
            CodeSystem.ConceptDefinitionComponent v = null;
            if (e != null) {
                v = this.getConceptForCode(e.getConcept(), code);
            }
            if (v == null && vse != null) {
                v = this.getConceptForCodeFromExpansion(vse.getContains(), code);
            }
            if (v != null) {
                results.put(code, v);
                continue;
            }
            serverList.add(new IWorkerContext.CodingValidationRequest(new Coding(inc.getSystem(), code, null)));
        }
        if (!this.context.isNoSlowLookup() && !serverList.isEmpty()) {
            this.getContext().getWorker().validateCodeBatch(this.getContext().getTerminologyServiceOptions(), serverList, null);
            for (IWorkerContext.CodingValidationRequest vr : serverList) {
                CodeSystem.ConceptDefinitionComponent v = vr.getResult().asConceptDefinition();
                if (v == null) continue;
                results.put(vr.getCoding().getCode(), v);
            }
        }
        return results;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCodeFromExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (code.equals(c.getCode())) {
                CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
                res.setCode(c.getCode());
                res.setDisplay(c.getDisplay());
                return res;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCodeFromExpansion(c.getContains(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private boolean codeExistsInValueSet(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private void addLanguageRow(ValueSet.ConceptReferenceComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            String d = null;
            for (ValueSet.ConceptReferenceDesignationComponent cd : c.getDesignation()) {
                String l = cd.getLanguage();
                if (!lang.equals(l)) continue;
                d = cd.getValue();
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private String describe(Enumerations.FilterOperator op) {
        if (op == null) {
            return " null ";
        }
        switch (op) {
            case EQUAL: {
                return " = ";
            }
            case ISA: {
                return " is-a ";
            }
            case ISNOTA: {
                return " is-not-a ";
            }
            case REGEX: {
                return " matches (by regex) ";
            }
            case NULL: {
                return " ?ngen-13? ";
            }
            case IN: {
                return " in ";
            }
            case NOTIN: {
                return " not in ";
            }
            case DESCENDENTOF: {
                return " descends from ";
            }
            case EXISTS: {
                return " exists ";
            }
            case GENERALIZES: {
                return " generalizes ";
            }
        }
        return null;
    }

    private boolean inConcept(String code, CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.inConcept(code, g)) continue;
            return true;
        }
        return false;
    }
}

