/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.formats.XmlLocationAnnotator;
import org.hl7.fhir.r5.utils.formats.XmlLocationData;
import org.hl7.fhir.utilities.ElementDecoration;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.CDANarrativeFormat;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XmlParser
extends ParserBase {
    private boolean allowXsiLocation;
    private String version;

    public XmlParser(IWorkerContext context) {
        super(context);
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    @Override
    public Element parse(InputStream stream) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                if (stream.markSupported()) {
                    stream.mark(1024);
                    this.version = this.checkHeader(stream);
                    stream.reset();
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer nullTransformer = transformerFactory.newTransformer();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                doc = docBuilder.newDocument();
                DOMResult domResult = new DOMResult(doc);
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                spf.setValidating(false);
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = spf.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                XmlLocationAnnotator locationAnnotator = new XmlLocationAnnotator(xmlReader, doc);
                InputSource inputSource = new InputSource(stream);
                SAXSource saxSource = new SAXSource(locationAnnotator, inputSource);
                nullTransformer.transform(saxSource, domResult);
            } else {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(stream);
            }
        }
        catch (Exception e) {
            this.logError(0, 0, "(syntax)", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
            doc = null;
        }
        if (doc == null) {
            return null;
        }
        return this.parse(doc);
    }

    private void checkForProcessingInstruction(Document document) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING && "http://hl7.org/fhir".equals(document.getDocumentElement().getNamespaceURI())) {
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 7) continue;
                this.logError(this.line(document), this.col(document), "(document)", ValidationMessage.IssueType.INVALID, this.context.formatMessage("No_processing_instructions_allowed_in_resources", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private int line(Node node) {
        XmlLocationData loc = node == null ? null : (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : loc.getStartLine();
    }

    private int col(Node node) {
        XmlLocationData loc = node == null ? null : (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : loc.getStartColumn();
    }

    public Element parse(Document doc) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        this.checkForProcessingInstruction(doc);
        org.w3c.dom.Element element = doc.getDocumentElement();
        return this.parse(element);
    }

    public Element parse(org.w3c.dom.Element element) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        String ns = element.getNamespaceURI();
        String name = element.getLocalName();
        String path = "/" + this.pathPrefix(ns) + name;
        StructureDefinition sd = this.getDefinition(this.line(element), this.col(element), ns == null ? "noNamespace" : ns, name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(element.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        this.checkElement(element, path, result.getProperty());
        result.markLocation(this.line(element), this.col(element));
        result.setType(element.getLocalName());
        this.parseChildren(path, element, result);
        result.numberChildren();
        return result;
    }

    private String pathPrefix(String ns) {
        if (Utilities.noString((String)ns)) {
            return "";
        }
        if (ns.equals("http://hl7.org/fhir")) {
            return "f:";
        }
        if (ns.equals("http://www.w3.org/1999/xhtml")) {
            return "h:";
        }
        if (ns.equals("urn:hl7-org:v3")) {
            return "v3:";
        }
        if (ns.equals("urn:hl7-org:sdtc")) {
            return "sdtc:";
        }
        if (ns.equals("urn:ihe:pharm")) {
            return "pharm:";
        }
        return "?:";
    }

    private boolean empty(org.w3c.dom.Element element) {
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            String n = element.getAttributes().item(i).getNodeName();
            if (n.equals("xmlns") || n.startsWith("xmlns:")) continue;
            return false;
        }
        if (!Utilities.noString((String)element.getTextContent().trim())) {
            return false;
        }
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    private void checkElement(org.w3c.dom.Element element, String path, Property prop) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            if (this.empty(element) && "http://hl7.org/fhir".equals(element.getNamespaceURI())) {
                this.logError(this.line(element), this.col(element), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Element_must_have_some_content", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            String ns = prop.getXmlNamespace();
            String elementNs = element.getNamespaceURI();
            if (elementNs == null) {
                elementNs = "noNamespace";
            }
            if (!elementNs.equals(ns)) {
                this.logError(this.line(element), this.col(element), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Wrong_namespace__expected_", ns), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    public Element parse(org.w3c.dom.Element base, String type) throws Exception {
        StructureDefinition sd = this.getDefinition(0, 0, "http://hl7.org/fhir", type);
        Element result = new Element(base.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd));
        String path = "/" + this.pathPrefix(base.getNamespaceURI()) + base.getLocalName();
        this.checkElement(base, path, result.getProperty());
        result.setType(base.getLocalName());
        this.parseChildren(path, base, result);
        result.numberChildren();
        return result;
    }

    private void parseChildren(String path, org.w3c.dom.Element node, Element element) throws FHIRFormatError, FHIRException, IOException, DefinitionException {
        this.reapComments(node, element);
        List<Property> properties = element.getProperty().getChildProperties(element.getName(), XMLUtil.getXsiType((org.w3c.dom.Element)node));
        String text = XMLUtil.getDirectText((org.w3c.dom.Element)node).trim();
        int line = this.line(node);
        int col = this.col(node);
        if (!Utilities.noString((String)text)) {
            Property property = this.getTextProp(properties);
            if (property != null) {
                if ("ED.data[x]".equals(property.getDefinition().getId()) || property.getDefinition() != null && property.getDefinition().getBase() != null && "ED.data[x]".equals(property.getDefinition().getBase().getPath())) {
                    if ("B64".equals(node.getAttribute("representation"))) {
                        element.getChildren().add(new Element("dataBase64Binary", property, "base64Binary", text).markLocation(line, col));
                    } else {
                        element.getChildren().add(new Element("dataString", property, "string", text).markLocation(line, col));
                    }
                } else {
                    element.getChildren().add(new Element(property.getName(), property, property.getType(), text).markLocation(line, col));
                }
            } else {
                for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (n.getNodeType() != 3 || Utilities.noString((String)n.getTextContent().trim())) continue;
                    while (n.getNextSibling() != null && n.getNodeType() != 1) {
                        n = n.getNextSibling();
                    }
                    while (n.getPreviousSibling() != null && n.getNodeType() != 1) {
                        n = n.getPreviousSibling();
                    }
                    line = this.line(n);
                    col = this.col(n);
                    this.logError(line, col, path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Text_should_not_be_present", text), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attr = node.getAttributes().item(i);
            String value = attr.getNodeValue();
            if (!this.validAttrValue(value)) {
                this.logError(line, col, path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("xml_attr_value_invalid", attr.getNodeName()), ValidationMessage.IssueSeverity.ERROR);
            }
            if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) continue;
            Property property = this.getAttrProp(properties, attr.getLocalName(), attr.getNamespaceURI());
            if (property != null) {
                String av = attr.getNodeValue();
                if (ToolingExtensions.hasExtension(property.getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat")) {
                    av = this.convertForDateFormatFromExternal(ToolingExtensions.readStringExtension(property.getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat"), av);
                }
                if (property.getName().equals("value") && element.isPrimitive()) {
                    element.setValue(av);
                    continue;
                }
                element.getChildren().add(new Element(property.getName(), property, property.getType(), av).markLocation(line, col));
                continue;
            }
            boolean ok = false;
            if ("http://hl7.org/fhir".equals(node.getNamespaceURI())) {
                if (attr.getLocalName().equals("schemaLocation") && "http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI())) {
                    ok = ok || this.allowXsiLocation;
                }
            } else {
                ok = ok || attr.getLocalName().equals("schemaLocation");
            }
            boolean bl = ok = ok || this.hasTypeAttr(element) && attr.getLocalName().equals("type") && "http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI());
            if (ok) continue;
            this.logError(line, col, path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Undefined_attribute__on__for_type__properties__", attr.getNodeName(), node.getNodeName(), element.fhirType(), properties), ValidationMessage.IssueSeverity.ERROR);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                Property property = this.getElementProp(properties, child.getLocalName(), child.getNamespaceURI());
                if (property != null) {
                    if (!property.isChoice() && "xhtml".equals(property.getType())) {
                        XhtmlNode xhtml = property.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.CDATEXT) ? new CDANarrativeFormat().convert((org.w3c.dom.Element)child) : new XhtmlParser().setValidatorMode(true).parseHtmlNode((org.w3c.dom.Element)child);
                        element.getChildren().add(new Element(property.getName(), property, "xhtml", new XhtmlComposer(true, false).compose(xhtml)).setXhtml(xhtml).markLocation(this.line(child), this.col(child)));
                        continue;
                    }
                    String npath = path + "/" + this.pathPrefix(child.getNamespaceURI()) + child.getLocalName();
                    Element n = new Element(child.getLocalName(), property).markLocation(this.line(child), this.col(child));
                    this.checkElement((org.w3c.dom.Element)child, npath, n.getProperty());
                    boolean ok = true;
                    if (property.isChoice()) {
                        if (property.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                            String xsiType = ((org.w3c.dom.Element)child).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                            if (Utilities.noString((String)xsiType)) {
                                if (ToolingExtensions.hasExtension(property.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
                                    xsiType = ToolingExtensions.readStringExtension(property.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
                                    n.setType(xsiType);
                                } else {
                                    this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("No_type_found_on_", child.getLocalName()), ValidationMessage.IssueSeverity.ERROR);
                                    ok = false;
                                }
                            } else {
                                if (xsiType.contains(":")) {
                                    xsiType = xsiType.substring(xsiType.indexOf(":") + 1);
                                }
                                n.setType(xsiType);
                                n.setExplicitType(xsiType);
                            }
                        } else {
                            n.setType(n.getType());
                        }
                    }
                    element.getChildren().add(n);
                    if (!ok) continue;
                    if (property.isResource()) {
                        this.parseResource(npath, (org.w3c.dom.Element)child, n, property);
                        continue;
                    }
                    this.parseChildren(npath, (org.w3c.dom.Element)child, n);
                    continue;
                }
                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Undefined_element_", child.getLocalName()), ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (child.getNodeType() == 4) {
                this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("CDATA_is_not_allowed", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (Utilities.existsInList((int)child.getNodeType(), (int[])new int[]{3, 8})) continue;
            this.logError(this.line(child), this.col(child), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Node_type__is_not_allowed", Integer.toString(child.getNodeType())), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private boolean validAttrValue(String value) {
        if (this.version == null) {
            return true;
        }
        if (this.version.equals("1.0")) {
            boolean ok = true;
            for (char ch : value.toCharArray()) {
                if (ch > '\u001f' || Utilities.existsInList((int)ch, (int[])new int[]{13, 10, 9})) continue;
                ok = false;
            }
            return ok;
        }
        return true;
    }

    private Property getElementProp(List<Property> properties, String nodeName, String namespace) {
        ArrayList<Property> propsSortedByLongestFirst = new ArrayList<Property>(properties);
        Collections.sort(propsSortedByLongestFirst, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o2.getName().length() - o1.getName().length();
            }
        });
        for (Property p : propsSortedByLongestFirst) {
            if (p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT) || !p.getXmlName().equals(nodeName) || !p.getXmlNamespace().equals(namespace)) continue;
            return p;
        }
        for (Property p : propsSortedByLongestFirst) {
            if (p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            if (p.getXmlName().equals(nodeName)) {
                return p;
            }
            if (!p.getName().endsWith("[x]") || nodeName.length() <= p.getName().length() - 3 || !p.getName().substring(0, p.getName().length() - 3).equals(nodeName.substring(0, p.getName().length() - 3))) continue;
            return p;
        }
        return null;
    }

    private Property getAttrProp(List<Property> properties, String nodeName, String namespace) {
        for (Property p : properties) {
            if (!p.getXmlName().equals(nodeName) || !p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || !p.getXmlNamespace().equals(namespace)) continue;
            return p;
        }
        if (namespace == null) {
            for (Property p : properties) {
                if (!p.getXmlName().equals(nodeName) || !p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
                return p;
            }
        }
        return null;
    }

    private Property getTextProp(List<Property> properties) {
        for (Property p : properties) {
            if (!p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            return p;
        }
        return null;
    }

    private String convertForDateFormatFromExternal(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt)) {
            DateTimeType d = DateTimeType.parseV3(av);
            return d.asStringValue();
        }
        throw new FHIRException(this.context.formatMessage("Unknown_Data_format_", fmt));
    }

    private String convertForDateFormatToExternal(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt)) {
            DateTimeType d = new DateTimeType(av);
            return d.getAsV3();
        }
        throw new FHIRException(this.context.formatMessage("Unknown_Date_format_", fmt));
    }

    private void parseResource(String string, org.w3c.dom.Element container, Element parent, Property elementProperty) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        org.w3c.dom.Element res = XMLUtil.getFirstChild((org.w3c.dom.Element)container);
        String name = res.getLocalName();
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(name, this.context.getOverrideVersionNs()));
        if (sd == null) {
            throw new FHIRFormatError(this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", res.getLocalName()));
        }
        parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
        parent.setType(name);
        this.parseChildren(res.getLocalName(), res, parent);
    }

    private void reapComments(org.w3c.dom.Element element, Element context) {
        Node node;
        for (node = element.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 8) continue;
            context.getComments().add(0, node.getTextContent());
        }
        for (node = element.getLastChild(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
        }
        while (node != null) {
            if (node.getNodeType() == 8) {
                context.getComments().add(node.getTextContent());
            }
            node = node.getNextSibling();
        }
    }

    private boolean isAttr(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
            return true;
        }
        return false;
    }

    private boolean isCdaText(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.CDATEXT) continue;
            return true;
        }
        return false;
    }

    private boolean isTypeAttr(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.TYPEATTR) continue;
            return true;
        }
        return false;
    }

    private boolean isText(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLTEXT) continue;
            return true;
        }
        return false;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws IOException, FHIRException {
        XMLWriter xml = new XMLWriter(stream, "UTF-8");
        xml.setSortAttributes(false);
        xml.setPretty(style == IParser.OutputStyle.PRETTY);
        xml.start();
        String ns = e.getProperty().getXmlNamespace();
        if (ns != null && !"noNamespace".equals(ns)) {
            xml.setDefaultNamespace(ns);
        }
        if (this.hasTypeAttr(e)) {
            xml.namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        this.addNamespaces((IXMLWriter)xml, e);
        this.composeElement((IXMLWriter)xml, e, e.getType(), true);
        xml.end();
    }

    private void addNamespaces(IXMLWriter xml, Element e) throws IOException {
        String ns = e.getProperty().getXmlNamespace();
        if (ns != null && xml.getDefaultNamespace() != null && !xml.getDefaultNamespace().equals(ns) && !xml.namespaceDefined(ns)) {
            String prefix = this.pathPrefix(ns);
            if (prefix.endsWith(":")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if ("?".equals(prefix)) {
                xml.namespace(ns);
            } else {
                xml.namespace(ns, prefix);
            }
        }
        for (Element c : e.getChildren()) {
            this.addNamespaces(xml, c);
        }
    }

    private boolean hasTypeAttr(Element e) {
        if (this.isTypeAttr(e.getProperty())) {
            return true;
        }
        for (Element c : e.getChildren()) {
            if (!this.hasTypeAttr(c)) continue;
            return true;
        }
        return false;
    }

    private void setXsiTypeIfIsTypeAttr(IXMLWriter xml, Element element) throws IOException, FHIRException {
        if (this.isTypeAttr(element.getProperty()) && !Utilities.noString((String)element.getType())) {
            String type = element.getType();
            if (Utilities.isAbsoluteUrl((String)type)) {
                type = type.substring(type.lastIndexOf("/") + 1);
            }
            xml.attribute("xsi:type", type);
        }
    }

    public void compose(Element e, IXMLWriter xml) throws Exception {
        xml.start();
        xml.setDefaultNamespace(e.getProperty().getXmlNamespace());
        this.composeElement(xml, e, e.getType(), true);
        xml.end();
    }

    private void composeElement(IXMLWriter xml, Element element, String elementName, boolean root) throws IOException, FHIRException {
        Object decorations;
        if (this.showDecorations && (decorations = (List)element.getUserData("fhir.decorations")) != null) {
            Iterator iterator = decorations.iterator();
            while (iterator.hasNext()) {
                ElementDecoration d = (ElementDecoration)iterator.next();
                xml.decorate(d);
            }
        }
        for (String s : element.getComments()) {
            xml.comment(s, true);
        }
        if (this.isText(element.getProperty())) {
            if (this.linkResolver != null) {
                xml.link(this.linkResolver.resolveProperty(element.getProperty()));
            }
            xml.enter(element.getProperty().getXmlNamespace(), elementName);
            xml.text(element.getValue());
            xml.exit(element.getProperty().getXmlNamespace(), elementName);
        } else if (!element.hasChildren() && !element.hasValue()) {
            if (element.getExplicitType() != null) {
                xml.attribute("xsi:type", element.getExplicitType());
            }
            xml.element(elementName);
        } else if (element.isPrimitive() || element.hasType() && this.isPrimitive(element.getType())) {
            if (element.getType().equals("xhtml")) {
                String rawXhtml = element.getValue();
                if (this.isCdaText(element.getProperty())) {
                    new CDANarrativeFormat().convert(xml, new XhtmlParser().parseFragment(rawXhtml));
                } else {
                    xml.escapedText(rawXhtml);
                    xml.anchor("end-xhtml");
                }
            } else if (this.isText(element.getProperty())) {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                xml.text(element.getValue());
            } else {
                this.setXsiTypeIfIsTypeAttr(xml, element);
                if (element.hasValue()) {
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveType(element.getType()));
                    }
                    xml.attribute("value", element.getValue());
                }
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                if (element.hasChildren()) {
                    xml.enter(element.getProperty().getXmlNamespace(), elementName);
                    for (Element child : element.getChildren()) {
                        this.composeElement(xml, child, child.getName(), false);
                    }
                    xml.exit(element.getProperty().getXmlNamespace(), elementName);
                } else {
                    xml.element(elementName);
                }
            }
        } else {
            this.setXsiTypeIfIsTypeAttr(xml, element);
            for (Element child : element.getChildren()) {
                if (!this.isAttr(child.getProperty())) continue;
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveType(child.getType()));
                }
                String av = child.getValue();
                if (ToolingExtensions.hasExtension(child.getProperty().getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat")) {
                    av = this.convertForDateFormatToExternal(ToolingExtensions.readStringExtension(child.getProperty().getDefinition(), "http://www.healthintersections.com.au/fhir/StructureDefinition/elementdefinition-dateformat"), av);
                }
                xml.attribute(child.getProperty().getXmlNamespace(), child.getProperty().getXmlName(), av);
            }
            if (this.linkResolver != null) {
                xml.link(this.linkResolver.resolveProperty(element.getProperty()));
            }
            xml.enter(element.getProperty().getXmlNamespace(), elementName);
            if (!root && element.getSpecial() != null) {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                xml.enter(element.getProperty().getXmlNamespace(), element.getType());
            }
            for (Element child : element.getChildren()) {
                if (this.isText(child.getProperty())) {
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                    }
                    xml.text(child.getValue());
                    continue;
                }
                if (this.isAttr(child.getProperty())) continue;
                this.composeElement(xml, child, child.getName(), false);
            }
            if (!root && element.getSpecial() != null) {
                xml.exit(element.getProperty().getXmlNamespace(), element.getType());
            }
            xml.exit(element.getProperty().getXmlNamespace(), elementName);
        }
    }

    private String checkHeader(InputStream stream) throws IOException {
        try {
            int i0 = stream.read();
            int i1 = stream.read();
            int i2 = stream.read();
            StringBuilder b = new StringBuilder();
            if (i0 != 239 || i1 != 187 || i2 != 191) {
                if (i0 == 60 && i1 == 63 && i2 == 120) {
                    b.append((char)i0);
                    b.append((char)i1);
                    b.append((char)i2);
                } else {
                    if (i0 == 60) {
                        return "1.0";
                    }
                    throw new Exception(this.context.formatMessage("xml_encoding_invalid", new Object[0]));
                }
            }
            int i = stream.read();
            do {
                b.append((char)i);
            } while ((i = stream.read()) != 62);
            String header = b.toString();
            String e = null;
            i = header.indexOf("encoding=\"");
            if (i > -1) {
                e = header.substring(i + 10, i + 15);
            } else {
                i = header.indexOf("encoding='");
                if (i > -1) {
                    e = header.substring(i + 10, i + 15);
                }
            }
            if (e != null && !"UTF-8".equalsIgnoreCase(e)) {
                this.logError(0, 0, "XML", ValidationMessage.IssueType.INVALID, this.context.formatMessage("xml_encoding_invalid", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            if ((i = header.indexOf("version=\"")) > -1) {
                return header.substring(i + 9, i + 12);
            }
            i = header.indexOf("version='");
            if (i > -1) {
                return header.substring(i + 9, i + 12);
            }
            return "?xml-p1?";
        }
        catch (Exception e) {
            this.logError(0, 0, "XML", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
            return "?xml-p2?";
        }
    }
}

