/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="DeviceUseStatement", profile="http://hl7.org/fhir/StructureDefinition/DeviceUseStatement")
public class DeviceUseStatement
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier for this record", formalDefinition="An external identifier for this statement such as an IRI.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this DeviceUseStatement.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | entered-in-error +", formalDefinition="A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-statement-status")
    protected Enumeration<DeviceUseStatementStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the statement - classifying how the statement is made", formalDefinition="This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient using device", formalDefinition="The patient who used the device.")
    protected Reference subject;
    @Child(name="derivedFrom", type={ServiceRequest.class, Procedure.class, Claim.class, Observation.class, QuestionnaireResponse.class, DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting information", formalDefinition="Allows linking the DeviceUseStatement to the underlying Request, or to other information that supports or is used to derive the DeviceUseStatement.")
    protected List<Reference> derivedFrom;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The encounter or episode of care that establishes the context for this device use statement", formalDefinition="The encounter or episode of care that establishes the context for this device use statement.")
    protected Reference context;
    @Child(name="timing", type={Timing.class, Period.class, DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How often  the device was used", formalDefinition="How often the device was used.")
    protected DataType timing;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the statement was made (and recorded)", formalDefinition="The time at which the statement was recorded by informationSource.")
    protected DateTimeType dateAsserted;
    @Child(name="usageStatus", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement", formalDefinition="The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.")
    protected CodeableConcept usageStatus;
    @Child(name="usageReason", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The reason for asserting the usage status - for example forgot, lost, stolen, broken", formalDefinition="The reason for asserting the usage status - for example forgot, lost, stolen, broken.")
    protected List<CodeableConcept> usageReason;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who made the statement", formalDefinition="Who reported the device was being used by the patient.")
    protected Reference informationSource;
    @Child(name="device", type={CodeableReference.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code or Reference to device used", formalDefinition="Code or Reference to device used.")
    protected CodeableReference device;
    @Child(name="reason", type={CodeableReference.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why device was used", formalDefinition="Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUseStatement.")
    protected List<CodeableReference> reason;
    @Child(name="bodySite", type={CodeableReference.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target body site", formalDefinition="Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableReference bodySite;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Addition details (comments, instructions)", formalDefinition="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1284477298L;
    @SearchParamDefinition(name="device", path="DeviceUseStatement.device.concept", description="Search by device", type="token")
    public static final String SP_DEVICE = "device";
    public static final TokenClientParam DEVICE = new TokenClientParam("device");
    @SearchParamDefinition(name="identifier", path="DeviceUseStatement.identifier", description="Search by identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DeviceUseStatement.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceUseStatement:subject").toLocked();
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUseStatement:patient").toLocked();

    public DeviceUseStatement() {
    }

    public DeviceUseStatement(DeviceUseStatementStatus status, Reference subject, CodeableReference device) {
        this.setStatus(status);
        this.setSubject(subject);
        this.setDevice(device);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceUseStatement setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceUseStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DeviceUseStatement setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DeviceUseStatement addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<DeviceUseStatementStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceUseStatementStatus>(new DeviceUseStatementStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceUseStatement setStatusElement(Enumeration<DeviceUseStatementStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceUseStatementStatus getStatus() {
        return this.status == null ? null : (DeviceUseStatementStatus)((Object)this.status.getValue());
    }

    public DeviceUseStatement setStatus(DeviceUseStatementStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DeviceUseStatementStatus>(new DeviceUseStatementStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DeviceUseStatement setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DeviceUseStatement addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceUseStatement setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public DeviceUseStatement setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public DeviceUseStatement addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public DeviceUseStatement setContext(Reference value) {
        this.context = value;
        return this;
    }

    public DataType getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Timing();
        }
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this != null && this.timing instanceof Timing;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Period();
        }
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this != null && this.timing instanceof Period;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (this.timing == null) {
            this.timing = new DateTimeType();
        }
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this != null && this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public DeviceUseStatement setTiming(DataType value) {
        if (!(value == null || value instanceof Timing || value instanceof Period || value instanceof DateTimeType)) {
            throw new Error("Not the right type for DeviceUseStatement.timing[x]: " + value.fhirType());
        }
        this.timing = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public DeviceUseStatement setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public DeviceUseStatement setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public CodeableConcept getUsageStatus() {
        if (this.usageStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.usageStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.usageStatus = new CodeableConcept();
            }
        }
        return this.usageStatus;
    }

    public boolean hasUsageStatus() {
        return this.usageStatus != null && !this.usageStatus.isEmpty();
    }

    public DeviceUseStatement setUsageStatus(CodeableConcept value) {
        this.usageStatus = value;
        return this;
    }

    public List<CodeableConcept> getUsageReason() {
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        return this.usageReason;
    }

    public DeviceUseStatement setUsageReason(List<CodeableConcept> theUsageReason) {
        this.usageReason = theUsageReason;
        return this;
    }

    public boolean hasUsageReason() {
        if (this.usageReason == null) {
            return false;
        }
        for (CodeableConcept item : this.usageReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUsageReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        this.usageReason.add(t);
        return t;
    }

    public DeviceUseStatement addUsageReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        this.usageReason.add(t);
        return this;
    }

    public CodeableConcept getUsageReasonFirstRep() {
        if (this.getUsageReason().isEmpty()) {
            this.addUsageReason();
        }
        return this.getUsageReason().get(0);
    }

    public Reference getInformationSource() {
        if (this.informationSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.informationSource");
            }
            if (Configuration.doAutoCreate()) {
                this.informationSource = new Reference();
            }
        }
        return this.informationSource;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public DeviceUseStatement setInformationSource(Reference value) {
        this.informationSource = value;
        return this;
    }

    public CodeableReference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new CodeableReference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceUseStatement setDevice(CodeableReference value) {
        this.device = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public DeviceUseStatement setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public DeviceUseStatement addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableReference getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableReference();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public DeviceUseStatement setBodySite(CodeableReference value) {
        this.bodySite = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceUseStatement setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceUseStatement addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this DeviceUseStatement.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("status", "code", "A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient who used the device.", 0, 1, this.subject));
        children.add(new Property("derivedFrom", "Reference(ServiceRequest|Procedure|Claim|Observation|QuestionnaireResponse|DocumentReference)", "Allows linking the DeviceUseStatement to the underlying Request, or to other information that supports or is used to derive the DeviceUseStatement.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this device use statement.", 0, 1, this.context));
        children.add(new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing));
        children.add(new Property("dateAsserted", "dateTime", "The time at which the statement was recorded by informationSource.", 0, 1, this.dateAsserted));
        children.add(new Property("usageStatus", "CodeableConcept", "The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.", 0, 1, this.usageStatus));
        children.add(new Property("usageReason", "CodeableConcept", "The reason for asserting the usage status - for example forgot, lost, stolen, broken.", 0, Integer.MAX_VALUE, this.usageReason));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Who reported the device was being used by the patient.", 0, 1, this.informationSource));
        children.add(new Property(SP_DEVICE, "CodeableReference(Device|DeviceDefinition)", "Code or Reference to device used.", 0, 1, this.device));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUseStatement.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("bodySite", "CodeableReference(BodyStructure)", "Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).", 0, 1, this.bodySite));
        children.add(new Property("note", "Annotation", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this DeviceUseStatement.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property("status", "code", "A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient who used the device.", 0, 1, this.subject);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(ServiceRequest|Procedure|Claim|Observation|QuestionnaireResponse|DocumentReference)", "Allows linking the DeviceUseStatement to the underlying Request, or to other information that supports or is used to derive the DeviceUseStatement.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 951530927: {
                return new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this device use statement.", 0, 1, this.context);
            }
            case 164632566: {
                return new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -873664438: {
                return new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -497554124: {
                return new Property("timing[x]", "Timing", "How often the device was used.", 0, 1, this.timing);
            }
            case -615615829: {
                return new Property("timing[x]", "Period", "How often the device was used.", 0, 1, this.timing);
            }
            case -1837458939: {
                return new Property("timing[x]", "dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -1980855245: {
                return new Property("dateAsserted", "dateTime", "The time at which the statement was recorded by informationSource.", 0, 1, this.dateAsserted);
            }
            case 907197683: {
                return new Property("usageStatus", "CodeableConcept", "The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.", 0, 1, this.usageStatus);
            }
            case 864714565: {
                return new Property("usageReason", "CodeableConcept", "The reason for asserting the usage status - for example forgot, lost, stolen, broken.", 0, Integer.MAX_VALUE, this.usageReason);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Who reported the device was being used by the patient.", 0, 1, this.informationSource);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "CodeableReference(Device|DeviceDefinition)", "Code or Reference to device used.", 0, 1, this.device);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUseStatement.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableReference(BodyStructure)", "Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).", 0, 1, this.bodySite);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.context;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timing;
                }
                return baseArray;
            }
            case -1980855245: {
                Base[] baseArray;
                if (this.dateAsserted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateAsserted;
                }
                return baseArray;
            }
            case 907197683: {
                Base[] baseArray;
                if (this.usageStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.usageStatus;
                }
                return baseArray;
            }
            case 864714565: {
                return this.usageReason == null ? new Base[]{} : this.usageReason.toArray(new Base[this.usageReason.size()]);
            }
            case -2123220889: {
                Base[] baseArray;
                if (this.informationSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.informationSource;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.device;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.bodySite;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DeviceUseStatementStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 951530927: {
                this.context = TypeConvertor.castToReference(value);
                return value;
            }
            case -873664438: {
                this.timing = TypeConvertor.castToType(value);
                return value;
            }
            case -1980855245: {
                this.dateAsserted = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 907197683: {
                this.usageStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 864714565: {
                this.getUsageReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -2123220889: {
                this.informationSource = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("status")) {
            value = new DeviceUseStatementStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("context")) {
            this.context = TypeConvertor.castToReference(value);
        } else if (name.equals("timing[x]")) {
            this.timing = TypeConvertor.castToType(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = TypeConvertor.castToDateTime(value);
        } else if (name.equals("usageStatus")) {
            this.usageStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("usageReason")) {
            this.getUsageReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("informationSource")) {
            this.informationSource = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 951530927: {
                return this.getContext();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case -1980855245: {
                return this.getDateAssertedElement();
            }
            case 907197683: {
                return this.getUsageStatus();
            }
            case 864714565: {
                return this.addUsageReason();
            }
            case -2123220889: {
                return this.getInformationSource();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -873664438: {
                return new String[]{"Timing", "Period", "dateTime"};
            }
            case -1980855245: {
                return new String[]{"dateTime"};
            }
            case 907197683: {
                return new String[]{"CodeableConcept"};
            }
            case 864714565: {
                return new String[]{"CodeableConcept"};
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"CodeableReference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1702620169: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUseStatement.status");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("context")) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUseStatement.dateAsserted");
        }
        if (name.equals("usageStatus")) {
            this.usageStatus = new CodeableConcept();
            return this.usageStatus;
        }
        if (name.equals("usageReason")) {
            return this.addUsageReason();
        }
        if (name.equals("informationSource")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new CodeableReference();
            return this.device;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableReference();
            return this.bodySite;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceUseStatement";
    }

    @Override
    public DeviceUseStatement copy() {
        DeviceUseStatement dst = new DeviceUseStatement();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceUseStatement dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Enumeration<DeviceUseStatementStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference2 : this.derivedFrom) {
                dst.derivedFrom.add(reference2.copy());
            }
        }
        dst.context = this.context == null ? null : this.context.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        CodeableConcept codeableConcept = dst.usageStatus = this.usageStatus == null ? null : this.usageStatus.copy();
        if (this.usageReason != null) {
            dst.usageReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.usageReason) {
                dst.usageReason.add(codeableConcept2.copy());
            }
        }
        dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        CodeableReference codeableReference = dst.device = this.device == null ? null : this.device.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference2 : this.reason) {
                dst.reason.add(codeableReference2.copy());
            }
        }
        CodeableReference codeableReference3 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected DeviceUseStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other_;
        return DeviceUseStatement.compareDeep(this.identifier, o.identifier, true) && DeviceUseStatement.compareDeep(this.basedOn, o.basedOn, true) && DeviceUseStatement.compareDeep(this.status, o.status, true) && DeviceUseStatement.compareDeep(this.category, o.category, true) && DeviceUseStatement.compareDeep(this.subject, o.subject, true) && DeviceUseStatement.compareDeep(this.derivedFrom, o.derivedFrom, true) && DeviceUseStatement.compareDeep(this.context, o.context, true) && DeviceUseStatement.compareDeep(this.timing, o.timing, true) && DeviceUseStatement.compareDeep(this.dateAsserted, o.dateAsserted, true) && DeviceUseStatement.compareDeep(this.usageStatus, o.usageStatus, true) && DeviceUseStatement.compareDeep(this.usageReason, o.usageReason, true) && DeviceUseStatement.compareDeep(this.informationSource, o.informationSource, true) && DeviceUseStatement.compareDeep(this.device, o.device, true) && DeviceUseStatement.compareDeep(this.reason, o.reason, true) && DeviceUseStatement.compareDeep(this.bodySite, o.bodySite, true) && DeviceUseStatement.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other_;
        return DeviceUseStatement.compareValues(this.status, o.status, true) && DeviceUseStatement.compareValues(this.dateAsserted, o.dateAsserted, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.category, this.subject, this.derivedFrom, this.context, this.timing, this.dateAsserted, this.usageStatus, this.usageReason, this.informationSource, this.device, this.reason, this.bodySite, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceUseStatement;
    }

    public static class DeviceUseStatementStatusEnumFactory
    implements EnumFactory<DeviceUseStatementStatus> {
        @Override
        public DeviceUseStatementStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return DeviceUseStatementStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return DeviceUseStatementStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceUseStatementStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return DeviceUseStatementStatus.INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return DeviceUseStatementStatus.STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return DeviceUseStatementStatus.ONHOLD;
            }
            throw new IllegalArgumentException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceUseStatementStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceUseStatementStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ENTEREDINERROR);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.INTENDED);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.STOPPED);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ONHOLD);
            }
            throw new FHIRException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceUseStatementStatus code) {
            if (code == DeviceUseStatementStatus.ACTIVE) {
                return "active";
            }
            if (code == DeviceUseStatementStatus.COMPLETED) {
                return "completed";
            }
            if (code == DeviceUseStatementStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DeviceUseStatementStatus.INTENDED) {
                return "intended";
            }
            if (code == DeviceUseStatementStatus.STOPPED) {
                return "stopped";
            }
            if (code == DeviceUseStatementStatus.ONHOLD) {
                return "on-hold";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceUseStatementStatus code) {
            return code.getSystem();
        }
    }

    public static enum DeviceUseStatementStatus {
        ACTIVE,
        COMPLETED,
        ENTEREDINERROR,
        INTENDED,
        STOPPED,
        ONHOLD,
        NULL;


        public static DeviceUseStatementStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The device is still being used.";
                }
                case COMPLETED: {
                    return "The device is no longer being used.";
                }
                case ENTEREDINERROR: {
                    return "The statement was recorded incorrectly.";
                }
                case INTENDED: {
                    return "The device may be used at some time in the future.";
                }
                case STOPPED: {
                    return "Actions implied by the statement have been permanently halted, before all of them occurred.";
                }
                case ONHOLD: {
                    return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

