/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceDefinition", profile="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition")
public class SubstanceDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier by which this substance is known", formalDefinition="Identifier by which this substance is known.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A business level identifier of the substance", formalDefinition="A business level identifier of the substance.")
    protected StringType version;
    @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Status of substance within the catalogue e.g. approved", formalDefinition="Status of substance within the catalogue e.g. approved.")
    protected CodeableConcept status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High level categorization, e.g. polymer or nucleic acid, or food, chemical, biological", formalDefinition="High level categorization, e.g. polymer or nucleic acid, or food, chemical, biological.")
    protected CodeableConcept category;
    @Child(name="classification", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A lower level classification than category, such as the general types of polymer (linear or branch chain) or type of impurity (process related or contaminant)", formalDefinition="A lower level classification than category, such as the general types of polymer (linear or branch chain) or type of impurity (process related or contaminant).")
    protected List<CodeableConcept> classification;
    @Child(name="domain", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the substance applies to only human or veterinary use", formalDefinition="If the substance applies to only human or veterinary use.")
    protected CodeableConcept domain;
    @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description of the substance", formalDefinition="Textual description of the substance.")
    protected MarkdownType description;
    @Child(name="source", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
    protected List<Reference> source;
    @Child(name="note", type={Annotation.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Textual comment about this record of a substance", formalDefinition="Textual comment about this record of a substance.")
    protected List<Annotation> note;
    @Child(name="manufacturer", type={Organization.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A company that makes this substance", formalDefinition="A company that makes this substance.")
    protected List<Reference> manufacturer;
    @Child(name="supplier", type={Organization.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A company that supplies this substance", formalDefinition="A company that supplies this substance.")
    protected List<Reference> supplier;
    @Child(name="moiety", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Moiety, for structural modifications", formalDefinition="Moiety, for structural modifications.")
    protected List<SubstanceDefinitionMoietyComponent> moiety;
    @Child(name="property", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General specifications for this substance, including how it is related to other substances", formalDefinition="General specifications for this substance, including how it is related to other substances.")
    protected List<SubstanceDefinitionPropertyComponent> property;
    @Child(name="referenceInformation", type={SubstanceReferenceInformation.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General information detailing this substance", formalDefinition="General information detailing this substance.")
    protected Reference referenceInformation;
    @Child(name="structure", type={}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Structural information", formalDefinition="Structural information.")
    protected SubstanceDefinitionStructureComponent structure;
    @Child(name="code", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Codes associated with the substance", formalDefinition="Codes associated with the substance.")
    protected List<SubstanceDefinitionCodeComponent> code;
    @Child(name="name", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Names applicable to this substance", formalDefinition="Names applicable to this substance.")
    protected List<SubstanceDefinitionNameComponent> name;
    @Child(name="molecularWeight", type={SubstanceDefinitionStructureIsotopeMolecularWeightComponent.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
    protected List<SubstanceDefinitionStructureIsotopeMolecularWeightComponent> molecularWeight;
    @Child(name="relationship", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A link between this substance and another, with details of the relationship", formalDefinition="A link between this substance and another, with details of the relationship.")
    protected List<SubstanceDefinitionRelationshipComponent> relationship;
    @Child(name="nucleicAcid", type={SubstanceNucleicAcid.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to nucleic acids", formalDefinition="Data items specific to nucleic acids.")
    protected Reference nucleicAcid;
    @Child(name="polymer", type={SubstancePolymer.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to polymers", formalDefinition="Data items specific to polymers.")
    protected Reference polymer;
    @Child(name="protein", type={SubstanceProtein.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to proteins", formalDefinition="Data items specific to proteins.")
    protected Reference protein;
    @Child(name="sourceMaterial", type={SubstanceSourceMaterial.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Material or taxonomic/anatomical source for the substance", formalDefinition="Material or taxonomic/anatomical source for the substance.")
    protected Reference sourceMaterial;
    private static final long serialVersionUID = 1928000355L;
    @SearchParamDefinition(name="category", path="SubstanceDefinition.category", description="High level categorization, e.g. polymer or nucleic acid, or food, chemical, biological", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="code", path="SubstanceDefinition.code.code", description="The specific code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="domain", path="SubstanceDefinition.domain", description="If the substance applies to only human or veterinary use", type="token")
    public static final String SP_DOMAIN = "domain";
    public static final TokenClientParam DOMAIN = new TokenClientParam("domain");
    @SearchParamDefinition(name="identifier", path="SubstanceDefinition.identifier", description="Identifier by which this substance is known", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="SubstanceDefinition.name.name", description="The actual name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SubstanceDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public SubstanceDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public SubstanceDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubstanceDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public SubstanceDefinition setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public List<CodeableConcept> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        return this.classification;
    }

    public SubstanceDefinition setClassification(List<CodeableConcept> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CodeableConcept item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return t;
    }

    public SubstanceDefinition addClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return this;
    }

    public CodeableConcept getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public CodeableConcept getDomain() {
        if (this.domain == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.domain");
            }
            if (Configuration.doAutoCreate()) {
                this.domain = new CodeableConcept();
            }
        }
        return this.domain;
    }

    public boolean hasDomain() {
        return this.domain != null && !this.domain.isEmpty();
    }

    public SubstanceDefinition setDomain(CodeableConcept value) {
        this.domain = value;
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SubstanceDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SubstanceDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getSource() {
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        return this.source;
    }

    public SubstanceDefinition setSource(List<Reference> theSource) {
        this.source = theSource;
        return this;
    }

    public boolean hasSource() {
        if (this.source == null) {
            return false;
        }
        for (Reference item : this.source) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSource() {
        Reference t = new Reference();
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        this.source.add(t);
        return t;
    }

    public SubstanceDefinition addSource(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        this.source.add(t);
        return this;
    }

    public Reference getSourceFirstRep() {
        if (this.getSource().isEmpty()) {
            this.addSource();
        }
        return this.getSource().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public SubstanceDefinition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public SubstanceDefinition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public SubstanceDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public SubstanceDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<Reference> getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        return this.supplier;
    }

    public SubstanceDefinition setSupplier(List<Reference> theSupplier) {
        this.supplier = theSupplier;
        return this;
    }

    public boolean hasSupplier() {
        if (this.supplier == null) {
            return false;
        }
        for (Reference item : this.supplier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupplier() {
        Reference t = new Reference();
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return t;
    }

    public SubstanceDefinition addSupplier(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return this;
    }

    public Reference getSupplierFirstRep() {
        if (this.getSupplier().isEmpty()) {
            this.addSupplier();
        }
        return this.getSupplier().get(0);
    }

    public List<SubstanceDefinitionMoietyComponent> getMoiety() {
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceDefinitionMoietyComponent>();
        }
        return this.moiety;
    }

    public SubstanceDefinition setMoiety(List<SubstanceDefinitionMoietyComponent> theMoiety) {
        this.moiety = theMoiety;
        return this;
    }

    public boolean hasMoiety() {
        if (this.moiety == null) {
            return false;
        }
        for (SubstanceDefinitionMoietyComponent item : this.moiety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionMoietyComponent addMoiety() {
        SubstanceDefinitionMoietyComponent t = new SubstanceDefinitionMoietyComponent();
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceDefinitionMoietyComponent>();
        }
        this.moiety.add(t);
        return t;
    }

    public SubstanceDefinition addMoiety(SubstanceDefinitionMoietyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceDefinitionMoietyComponent>();
        }
        this.moiety.add(t);
        return this;
    }

    public SubstanceDefinitionMoietyComponent getMoietyFirstRep() {
        if (this.getMoiety().isEmpty()) {
            this.addMoiety();
        }
        return this.getMoiety().get(0);
    }

    public List<SubstanceDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<SubstanceDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public SubstanceDefinition setProperty(List<SubstanceDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (SubstanceDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionPropertyComponent addProperty() {
        SubstanceDefinitionPropertyComponent t = new SubstanceDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<SubstanceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public SubstanceDefinition addProperty(SubstanceDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<SubstanceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public SubstanceDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getReferenceInformation() {
        if (this.referenceInformation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.referenceInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceInformation = new Reference();
            }
        }
        return this.referenceInformation;
    }

    public boolean hasReferenceInformation() {
        return this.referenceInformation != null && !this.referenceInformation.isEmpty();
    }

    public SubstanceDefinition setReferenceInformation(Reference value) {
        this.referenceInformation = value;
        return this;
    }

    public SubstanceDefinitionStructureComponent getStructure() {
        if (this.structure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.structure");
            }
            if (Configuration.doAutoCreate()) {
                this.structure = new SubstanceDefinitionStructureComponent();
            }
        }
        return this.structure;
    }

    public boolean hasStructure() {
        return this.structure != null && !this.structure.isEmpty();
    }

    public SubstanceDefinition setStructure(SubstanceDefinitionStructureComponent value) {
        this.structure = value;
        return this;
    }

    public List<SubstanceDefinitionCodeComponent> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<SubstanceDefinitionCodeComponent>();
        }
        return this.code;
    }

    public SubstanceDefinition setCode(List<SubstanceDefinitionCodeComponent> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (SubstanceDefinitionCodeComponent item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionCodeComponent addCode() {
        SubstanceDefinitionCodeComponent t = new SubstanceDefinitionCodeComponent();
        if (this.code == null) {
            this.code = new ArrayList<SubstanceDefinitionCodeComponent>();
        }
        this.code.add(t);
        return t;
    }

    public SubstanceDefinition addCode(SubstanceDefinitionCodeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<SubstanceDefinitionCodeComponent>();
        }
        this.code.add(t);
        return this;
    }

    public SubstanceDefinitionCodeComponent getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<SubstanceDefinitionNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<SubstanceDefinitionNameComponent>();
        }
        return this.name;
    }

    public SubstanceDefinition setName(List<SubstanceDefinitionNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (SubstanceDefinitionNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionNameComponent addName() {
        SubstanceDefinitionNameComponent t = new SubstanceDefinitionNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<SubstanceDefinitionNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public SubstanceDefinition addName(SubstanceDefinitionNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<SubstanceDefinitionNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public SubstanceDefinitionNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<SubstanceDefinitionStructureIsotopeMolecularWeightComponent> getMolecularWeight() {
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceDefinitionStructureIsotopeMolecularWeightComponent>();
        }
        return this.molecularWeight;
    }

    public SubstanceDefinition setMolecularWeight(List<SubstanceDefinitionStructureIsotopeMolecularWeightComponent> theMolecularWeight) {
        this.molecularWeight = theMolecularWeight;
        return this;
    }

    public boolean hasMolecularWeight() {
        if (this.molecularWeight == null) {
            return false;
        }
        for (SubstanceDefinitionStructureIsotopeMolecularWeightComponent item : this.molecularWeight) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionStructureIsotopeMolecularWeightComponent addMolecularWeight() {
        SubstanceDefinitionStructureIsotopeMolecularWeightComponent t = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceDefinitionStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return t;
    }

    public SubstanceDefinition addMolecularWeight(SubstanceDefinitionStructureIsotopeMolecularWeightComponent t) {
        if (t == null) {
            return this;
        }
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceDefinitionStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return this;
    }

    public SubstanceDefinitionStructureIsotopeMolecularWeightComponent getMolecularWeightFirstRep() {
        if (this.getMolecularWeight().isEmpty()) {
            this.addMolecularWeight();
        }
        return this.getMolecularWeight().get(0);
    }

    public List<SubstanceDefinitionRelationshipComponent> getRelationship() {
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceDefinitionRelationshipComponent>();
        }
        return this.relationship;
    }

    public SubstanceDefinition setRelationship(List<SubstanceDefinitionRelationshipComponent> theRelationship) {
        this.relationship = theRelationship;
        return this;
    }

    public boolean hasRelationship() {
        if (this.relationship == null) {
            return false;
        }
        for (SubstanceDefinitionRelationshipComponent item : this.relationship) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceDefinitionRelationshipComponent addRelationship() {
        SubstanceDefinitionRelationshipComponent t = new SubstanceDefinitionRelationshipComponent();
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceDefinitionRelationshipComponent>();
        }
        this.relationship.add(t);
        return t;
    }

    public SubstanceDefinition addRelationship(SubstanceDefinitionRelationshipComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceDefinitionRelationshipComponent>();
        }
        this.relationship.add(t);
        return this;
    }

    public SubstanceDefinitionRelationshipComponent getRelationshipFirstRep() {
        if (this.getRelationship().isEmpty()) {
            this.addRelationship();
        }
        return this.getRelationship().get(0);
    }

    public Reference getNucleicAcid() {
        if (this.nucleicAcid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.nucleicAcid");
            }
            if (Configuration.doAutoCreate()) {
                this.nucleicAcid = new Reference();
            }
        }
        return this.nucleicAcid;
    }

    public boolean hasNucleicAcid() {
        return this.nucleicAcid != null && !this.nucleicAcid.isEmpty();
    }

    public SubstanceDefinition setNucleicAcid(Reference value) {
        this.nucleicAcid = value;
        return this;
    }

    public Reference getPolymer() {
        if (this.polymer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.polymer");
            }
            if (Configuration.doAutoCreate()) {
                this.polymer = new Reference();
            }
        }
        return this.polymer;
    }

    public boolean hasPolymer() {
        return this.polymer != null && !this.polymer.isEmpty();
    }

    public SubstanceDefinition setPolymer(Reference value) {
        this.polymer = value;
        return this;
    }

    public Reference getProtein() {
        if (this.protein == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.protein");
            }
            if (Configuration.doAutoCreate()) {
                this.protein = new Reference();
            }
        }
        return this.protein;
    }

    public boolean hasProtein() {
        return this.protein != null && !this.protein.isEmpty();
    }

    public SubstanceDefinition setProtein(Reference value) {
        this.protein = value;
        return this;
    }

    public Reference getSourceMaterial() {
        if (this.sourceMaterial == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceDefinition.sourceMaterial");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterial = new Reference();
            }
        }
        return this.sourceMaterial;
    }

    public boolean hasSourceMaterial() {
        return this.sourceMaterial != null && !this.sourceMaterial.isEmpty();
    }

    public SubstanceDefinition setSourceMaterial(Reference value) {
        this.sourceMaterial = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier));
        children.add(new Property("version", "string", "A business level identifier of the substance.", 0, 1, this.version));
        children.add(new Property("status", "CodeableConcept", "Status of substance within the catalogue e.g. approved.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid, or food, chemical, biological.", 0, 1, this.category));
        children.add(new Property("classification", "CodeableConcept", "A lower level classification than category, such as the general types of polymer (linear or branch chain) or type of impurity (process related or contaminant).", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property(SP_DOMAIN, "CodeableConcept", "If the substance applies to only human or veterinary use.", 0, 1, this.domain));
        children.add(new Property("description", "markdown", "Textual description of the substance.", 0, 1, this.description));
        children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        children.add(new Property("note", "Annotation", "Textual comment about this record of a substance.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("manufacturer", "Reference(Organization)", "A company that makes this substance.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("supplier", "Reference(Organization)", "A company that supplies this substance.", 0, Integer.MAX_VALUE, this.supplier));
        children.add(new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety));
        children.add(new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation));
        children.add(new Property("structure", "", "Structural information.", 0, 1, this.structure));
        children.add(new Property(SP_CODE, "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property(SP_NAME, "", "Names applicable to this substance.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("molecularWeight", "@SubstanceDefinition.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight));
        children.add(new Property("relationship", "", "A link between this substance and another, with details of the relationship.", 0, Integer.MAX_VALUE, this.relationship));
        children.add(new Property("nucleicAcid", "Reference(SubstanceNucleicAcid)", "Data items specific to nucleic acids.", 0, 1, this.nucleicAcid));
        children.add(new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer));
        children.add(new Property("protein", "Reference(SubstanceProtein)", "Data items specific to proteins.", 0, 1, this.protein));
        children.add(new Property("sourceMaterial", "Reference(SubstanceSourceMaterial)", "Material or taxonomic/anatomical source for the substance.", 0, 1, this.sourceMaterial));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property("version", "string", "A business level identifier of the substance.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property("status", "CodeableConcept", "Status of substance within the catalogue e.g. approved.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid, or food, chemical, biological.", 0, 1, this.category);
            }
            case 382350310: {
                return new Property("classification", "CodeableConcept", "A lower level classification than category, such as the general types of polymer (linear or branch chain) or type of impurity (process related or contaminant).", 0, Integer.MAX_VALUE, this.classification);
            }
            case -1326197564: {
                return new Property(SP_DOMAIN, "CodeableConcept", "If the substance applies to only human or veterinary use.", 0, 1, this.domain);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Textual description of the substance.", 0, 1, this.description);
            }
            case -896505829: {
                return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Textual comment about this record of a substance.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "A company that makes this substance.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -1663305268: {
                return new Property("supplier", "Reference(Organization)", "A company that supplies this substance.", 0, Integer.MAX_VALUE, this.supplier);
            }
            case -1068650173: {
                return new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety);
            }
            case -993141291: {
                return new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property);
            }
            case -2117930783: {
                return new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation);
            }
            case 144518515: {
                return new Property("structure", "", "Structural information.", 0, 1, this.structure);
            }
            case 3059181: {
                return new Property(SP_CODE, "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.code);
            }
            case 3373707: {
                return new Property(SP_NAME, "", "Names applicable to this substance.", 0, Integer.MAX_VALUE, this.name);
            }
            case 635625672: {
                return new Property("molecularWeight", "@SubstanceDefinition.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight);
            }
            case -261851592: {
                return new Property("relationship", "", "A link between this substance and another, with details of the relationship.", 0, Integer.MAX_VALUE, this.relationship);
            }
            case 1625275180: {
                return new Property("nucleicAcid", "Reference(SubstanceNucleicAcid)", "Data items specific to nucleic acids.", 0, 1, this.nucleicAcid);
            }
            case -397514098: {
                return new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer);
            }
            case -309012605: {
                return new Property("protein", "Reference(SubstanceProtein)", "Data items specific to proteins.", 0, 1, this.protein);
            }
            case -1064442270: {
                return new Property("sourceMaterial", "Reference(SubstanceSourceMaterial)", "Material or taxonomic/anatomical source for the substance.", 0, 1, this.sourceMaterial);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.category;
                }
                return baseArray;
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case -1326197564: {
                Base[] baseArray;
                if (this.domain == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.domain;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case -896505829: {
                return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -1663305268: {
                return this.supplier == null ? new Base[]{} : this.supplier.toArray(new Base[this.supplier.size()]);
            }
            case -1068650173: {
                return this.moiety == null ? new Base[]{} : this.moiety.toArray(new Base[this.moiety.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -2117930783: {
                Base[] baseArray;
                if (this.referenceInformation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.referenceInformation;
                }
                return baseArray;
            }
            case 144518515: {
                Base[] baseArray;
                if (this.structure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.structure;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case 635625672: {
                return this.molecularWeight == null ? new Base[]{} : this.molecularWeight.toArray(new Base[this.molecularWeight.size()]);
            }
            case -261851592: {
                return this.relationship == null ? new Base[]{} : this.relationship.toArray(new Base[this.relationship.size()]);
            }
            case 1625275180: {
                Base[] baseArray;
                if (this.nucleicAcid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.nucleicAcid;
                }
                return baseArray;
            }
            case -397514098: {
                Base[] baseArray;
                if (this.polymer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.polymer;
                }
                return baseArray;
            }
            case -309012605: {
                Base[] baseArray;
                if (this.protein == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.protein;
                }
                return baseArray;
            }
            case -1064442270: {
                Base[] baseArray;
                if (this.sourceMaterial == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.sourceMaterial;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.category = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 382350310: {
                this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1326197564: {
                this.domain = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -896505829: {
                this.getSource().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1663305268: {
                this.getSupplier().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1068650173: {
                this.getMoiety().add((SubstanceDefinitionMoietyComponent)value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((SubstanceDefinitionPropertyComponent)value);
                return value;
            }
            case -2117930783: {
                this.referenceInformation = TypeConvertor.castToReference(value);
                return value;
            }
            case 144518515: {
                this.structure = (SubstanceDefinitionStructureComponent)value;
                return value;
            }
            case 3059181: {
                this.getCode().add((SubstanceDefinitionCodeComponent)value);
                return value;
            }
            case 3373707: {
                this.getName().add((SubstanceDefinitionNameComponent)value);
                return value;
            }
            case 635625672: {
                this.getMolecularWeight().add((SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value);
                return value;
            }
            case -261851592: {
                this.getRelationship().add((SubstanceDefinitionRelationshipComponent)value);
                return value;
            }
            case 1625275180: {
                this.nucleicAcid = TypeConvertor.castToReference(value);
                return value;
            }
            case -397514098: {
                this.polymer = TypeConvertor.castToReference(value);
                return value;
            }
            case -309012605: {
                this.protein = TypeConvertor.castToReference(value);
                return value;
            }
            case -1064442270: {
                this.sourceMaterial = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("status")) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("classification")) {
            this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_DOMAIN)) {
            this.domain = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("source")) {
            this.getSource().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("supplier")) {
            this.getSupplier().add(TypeConvertor.castToReference(value));
        } else if (name.equals("moiety")) {
            this.getMoiety().add((SubstanceDefinitionMoietyComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().add((SubstanceDefinitionPropertyComponent)value);
        } else if (name.equals("referenceInformation")) {
            this.referenceInformation = TypeConvertor.castToReference(value);
        } else if (name.equals("structure")) {
            this.structure = (SubstanceDefinitionStructureComponent)value;
        } else if (name.equals(SP_CODE)) {
            this.getCode().add((SubstanceDefinitionCodeComponent)value);
        } else if (name.equals(SP_NAME)) {
            this.getName().add((SubstanceDefinitionNameComponent)value);
        } else if (name.equals("molecularWeight")) {
            this.getMolecularWeight().add((SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value);
        } else if (name.equals("relationship")) {
            this.getRelationship().add((SubstanceDefinitionRelationshipComponent)value);
        } else if (name.equals("nucleicAcid")) {
            this.nucleicAcid = TypeConvertor.castToReference(value);
        } else if (name.equals("polymer")) {
            this.polymer = TypeConvertor.castToReference(value);
        } else if (name.equals("protein")) {
            this.protein = TypeConvertor.castToReference(value);
        } else if (name.equals("sourceMaterial")) {
            this.sourceMaterial = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 382350310: {
                return this.addClassification();
            }
            case -1326197564: {
                return this.getDomain();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -896505829: {
                return this.addSource();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -1663305268: {
                return this.addSupplier();
            }
            case -1068650173: {
                return this.addMoiety();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -2117930783: {
                return this.getReferenceInformation();
            }
            case 144518515: {
                return this.getStructure();
            }
            case 3059181: {
                return this.addCode();
            }
            case 3373707: {
                return this.addName();
            }
            case 635625672: {
                return this.addMolecularWeight();
            }
            case -261851592: {
                return this.addRelationship();
            }
            case 1625275180: {
                return this.getNucleicAcid();
            }
            case -397514098: {
                return this.getPolymer();
            }
            case -309012605: {
                return this.getProtein();
            }
            case -1064442270: {
                return this.getSourceMaterial();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 382350310: {
                return new String[]{"CodeableConcept"};
            }
            case -1326197564: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -1663305268: {
                return new String[]{"Reference"};
            }
            case -1068650173: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case -2117930783: {
                return new String[]{"Reference"};
            }
            case 144518515: {
                return new String[0];
            }
            case 3059181: {
                return new String[0];
            }
            case 3373707: {
                return new String[0];
            }
            case 635625672: {
                return new String[]{"@SubstanceDefinition.structure.isotope.molecularWeight"};
            }
            case -261851592: {
                return new String[0];
            }
            case 1625275180: {
                return new String[]{"Reference"};
            }
            case -397514098: {
                return new String[]{"Reference"};
            }
            case -309012605: {
                return new String[]{"Reference"};
            }
            case -1064442270: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.version");
        }
        if (name.equals("status")) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals(SP_DOMAIN)) {
            this.domain = new CodeableConcept();
            return this.domain;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.description");
        }
        if (name.equals("source")) {
            return this.addSource();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("supplier")) {
            return this.addSupplier();
        }
        if (name.equals("moiety")) {
            return this.addMoiety();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("referenceInformation")) {
            this.referenceInformation = new Reference();
            return this.referenceInformation;
        }
        if (name.equals("structure")) {
            this.structure = new SubstanceDefinitionStructureComponent();
            return this.structure;
        }
        if (name.equals(SP_CODE)) {
            return this.addCode();
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals("molecularWeight")) {
            return this.addMolecularWeight();
        }
        if (name.equals("relationship")) {
            return this.addRelationship();
        }
        if (name.equals("nucleicAcid")) {
            this.nucleicAcid = new Reference();
            return this.nucleicAcid;
        }
        if (name.equals("polymer")) {
            this.polymer = new Reference();
            return this.polymer;
        }
        if (name.equals("protein")) {
            this.protein = new Reference();
            return this.protein;
        }
        if (name.equals("sourceMaterial")) {
            this.sourceMaterial = new Reference();
            return this.sourceMaterial;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceDefinition";
    }

    @Override
    public SubstanceDefinition copy() {
        SubstanceDefinition dst = new SubstanceDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceDefinition dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.category = this.category == null ? null : this.category.copy();
        if (this.classification != null) {
            dst.classification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.classification) {
                dst.classification.add(codeableConcept2.copy());
            }
        }
        dst.domain = this.domain == null ? null : this.domain.copy();
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.source != null) {
            dst.source = new ArrayList<Reference>();
            for (Reference reference : this.source) {
                dst.source.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.supplier != null) {
            dst.supplier = new ArrayList<Reference>();
            for (Reference reference : this.supplier) {
                dst.supplier.add(reference.copy());
            }
        }
        if (this.moiety != null) {
            dst.moiety = new ArrayList<SubstanceDefinitionMoietyComponent>();
            for (SubstanceDefinitionMoietyComponent substanceDefinitionMoietyComponent : this.moiety) {
                dst.moiety.add(substanceDefinitionMoietyComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<SubstanceDefinitionPropertyComponent>();
            for (SubstanceDefinitionPropertyComponent substanceDefinitionPropertyComponent : this.property) {
                dst.property.add(substanceDefinitionPropertyComponent.copy());
            }
        }
        dst.referenceInformation = this.referenceInformation == null ? null : this.referenceInformation.copy();
        SubstanceDefinitionStructureComponent substanceDefinitionStructureComponent = dst.structure = this.structure == null ? null : this.structure.copy();
        if (this.code != null) {
            dst.code = new ArrayList<SubstanceDefinitionCodeComponent>();
            for (SubstanceDefinitionCodeComponent substanceDefinitionCodeComponent : this.code) {
                dst.code.add(substanceDefinitionCodeComponent.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<SubstanceDefinitionNameComponent>();
            for (SubstanceDefinitionNameComponent substanceDefinitionNameComponent : this.name) {
                dst.name.add(substanceDefinitionNameComponent.copy());
            }
        }
        if (this.molecularWeight != null) {
            dst.molecularWeight = new ArrayList<SubstanceDefinitionStructureIsotopeMolecularWeightComponent>();
            for (SubstanceDefinitionStructureIsotopeMolecularWeightComponent substanceDefinitionStructureIsotopeMolecularWeightComponent : this.molecularWeight) {
                dst.molecularWeight.add(substanceDefinitionStructureIsotopeMolecularWeightComponent.copy());
            }
        }
        if (this.relationship != null) {
            dst.relationship = new ArrayList<SubstanceDefinitionRelationshipComponent>();
            for (SubstanceDefinitionRelationshipComponent substanceDefinitionRelationshipComponent : this.relationship) {
                dst.relationship.add(substanceDefinitionRelationshipComponent.copy());
            }
        }
        dst.nucleicAcid = this.nucleicAcid == null ? null : this.nucleicAcid.copy();
        dst.polymer = this.polymer == null ? null : this.polymer.copy();
        dst.protein = this.protein == null ? null : this.protein.copy();
        dst.sourceMaterial = this.sourceMaterial == null ? null : this.sourceMaterial.copy();
    }

    protected SubstanceDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceDefinition)) {
            return false;
        }
        SubstanceDefinition o = (SubstanceDefinition)other_;
        return SubstanceDefinition.compareDeep(this.identifier, o.identifier, true) && SubstanceDefinition.compareDeep(this.version, o.version, true) && SubstanceDefinition.compareDeep(this.status, o.status, true) && SubstanceDefinition.compareDeep(this.category, o.category, true) && SubstanceDefinition.compareDeep(this.classification, o.classification, true) && SubstanceDefinition.compareDeep(this.domain, o.domain, true) && SubstanceDefinition.compareDeep(this.description, o.description, true) && SubstanceDefinition.compareDeep(this.source, o.source, true) && SubstanceDefinition.compareDeep(this.note, o.note, true) && SubstanceDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && SubstanceDefinition.compareDeep(this.supplier, o.supplier, true) && SubstanceDefinition.compareDeep(this.moiety, o.moiety, true) && SubstanceDefinition.compareDeep(this.property, o.property, true) && SubstanceDefinition.compareDeep(this.referenceInformation, o.referenceInformation, true) && SubstanceDefinition.compareDeep(this.structure, o.structure, true) && SubstanceDefinition.compareDeep(this.code, o.code, true) && SubstanceDefinition.compareDeep(this.name, o.name, true) && SubstanceDefinition.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceDefinition.compareDeep(this.relationship, o.relationship, true) && SubstanceDefinition.compareDeep(this.nucleicAcid, o.nucleicAcid, true) && SubstanceDefinition.compareDeep(this.polymer, o.polymer, true) && SubstanceDefinition.compareDeep(this.protein, o.protein, true) && SubstanceDefinition.compareDeep(this.sourceMaterial, o.sourceMaterial, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceDefinition)) {
            return false;
        }
        SubstanceDefinition o = (SubstanceDefinition)other_;
        return SubstanceDefinition.compareValues(this.version, o.version, true) && SubstanceDefinition.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.version, this.status, this.category, this.classification, this.domain, this.description, this.source, this.note, this.manufacturer, this.supplier, this.moiety, this.property, this.referenceInformation, this.structure, this.code, this.name, this.molecularWeight, this.relationship, this.nucleicAcid, this.polymer, this.protein, this.sourceMaterial});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceDefinition;
    }

    @Block
    public static class SubstanceDefinitionRelationshipComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substanceDefinition", type={SubstanceDefinition.class, CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A pointer to another substance, as a resource or just a representational code", formalDefinition="A pointer to another substance, as a resource or just a representational code.")
        protected DataType substanceDefinition;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For example \"salt to parent\", \"active moiety\", \"starting material\", \"polymorph\"", formalDefinition="For example \"salt to parent\", \"active moiety\", \"starting material\", \"polymorph\".")
        protected CodeableConcept type;
        @Child(name="isDefining", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships", formalDefinition="For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.")
        protected BooleanType isDefining;
        @Child(name="amount", type={Quantity.class, Range.class, Ratio.class, StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other", formalDefinition="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.")
        protected DataType amount;
        @Child(name="amountRatioHighLimit", type={Ratio.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For use when the numeric has an uncertain range", formalDefinition="For use when the numeric has an uncertain range.")
        protected Ratio amountRatioHighLimit;
        @Child(name="amountType", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An operator for the amount, for example \"average\", \"approximately\", \"less than\"", formalDefinition="An operator for the amount, for example \"average\", \"approximately\", \"less than\".")
        protected CodeableConcept amountType;
        @Child(name="source", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        private static final long serialVersionUID = 447426308L;

        public DataType getSubstanceDefinition() {
            return this.substanceDefinition;
        }

        public Reference getSubstanceDefinitionReference() throws FHIRException {
            if (this.substanceDefinition == null) {
                this.substanceDefinition = new Reference();
            }
            if (!(this.substanceDefinition instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.substanceDefinition.getClass().getName() + " was encountered");
            }
            return (Reference)this.substanceDefinition;
        }

        public boolean hasSubstanceDefinitionReference() {
            return this != null && this.substanceDefinition instanceof Reference;
        }

        public CodeableConcept getSubstanceDefinitionCodeableConcept() throws FHIRException {
            if (this.substanceDefinition == null) {
                this.substanceDefinition = new CodeableConcept();
            }
            if (!(this.substanceDefinition instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.substanceDefinition.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.substanceDefinition;
        }

        public boolean hasSubstanceDefinitionCodeableConcept() {
            return this != null && this.substanceDefinition instanceof CodeableConcept;
        }

        public boolean hasSubstanceDefinition() {
            return this.substanceDefinition != null && !this.substanceDefinition.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setSubstanceDefinition(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for SubstanceDefinition.relationship.substanceDefinition[x]: " + value.fhirType());
            }
            this.substanceDefinition = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionRelationshipComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public BooleanType getIsDefiningElement() {
            if (this.isDefining == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionRelationshipComponent.isDefining");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDefining = new BooleanType();
                }
            }
            return this.isDefining;
        }

        public boolean hasIsDefiningElement() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public boolean hasIsDefining() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setIsDefiningElement(BooleanType value) {
            this.isDefining = value;
            return this;
        }

        public boolean getIsDefining() {
            return this.isDefining == null || this.isDefining.isEmpty() ? false : (Boolean)this.isDefining.getValue();
        }

        public SubstanceDefinitionRelationshipComponent setIsDefining(boolean value) {
            if (this.isDefining == null) {
                this.isDefining = new BooleanType();
            }
            this.isDefining.setValue((Object)value);
            return this;
        }

        public DataType getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public Range getAmountRange() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Range();
            }
            if (!(this.amount instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Range)this.amount;
        }

        public boolean hasAmountRange() {
            return this != null && this.amount instanceof Range;
        }

        public Ratio getAmountRatio() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Ratio();
            }
            if (!(this.amount instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Ratio)this.amount;
        }

        public boolean hasAmountRatio() {
            return this != null && this.amount instanceof Ratio;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setAmount(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceDefinition.relationship.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        public Ratio getAmountRatioHighLimit() {
            if (this.amountRatioHighLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionRelationshipComponent.amountRatioHighLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountRatioHighLimit = new Ratio();
                }
            }
            return this.amountRatioHighLimit;
        }

        public boolean hasAmountRatioHighLimit() {
            return this.amountRatioHighLimit != null && !this.amountRatioHighLimit.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setAmountRatioHighLimit(Ratio value) {
            this.amountRatioHighLimit = value;
            return this;
        }

        public CodeableConcept getAmountType() {
            if (this.amountType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionRelationshipComponent.amountType");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountType = new CodeableConcept();
                }
            }
            return this.amountType;
        }

        public boolean hasAmountType() {
            return this.amountType != null && !this.amountType.isEmpty();
        }

        public SubstanceDefinitionRelationshipComponent setAmountType(CodeableConcept value) {
            this.amountType = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceDefinitionRelationshipComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceDefinitionRelationshipComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substanceDefinition[x]", "Reference(SubstanceDefinition)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substanceDefinition));
            children.add(new Property("type", "CodeableConcept", "For example \"salt to parent\", \"active moiety\", \"starting material\", \"polymorph\".", 0, 1, this.type));
            children.add(new Property("isDefining", "boolean", "For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.", 0, 1, this.isDefining));
            children.add(new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount));
            children.add(new Property("amountRatioHighLimit", "Ratio", "For use when the numeric has an uncertain range.", 0, 1, this.amountRatioHighLimit));
            children.add(new Property("amountType", "CodeableConcept", "An operator for the amount, for example \"average\", \"approximately\", \"less than\".", 0, 1, this.amountType));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1767011651: {
                    return new Property("substanceDefinition[x]", "Reference(SubstanceDefinition)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substanceDefinition);
                }
                case 718195427: {
                    return new Property("substanceDefinition[x]", "Reference(SubstanceDefinition)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substanceDefinition);
                }
                case -308206680: {
                    return new Property("substanceDefinition[x]", "Reference(SubstanceDefinition)", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substanceDefinition);
                }
                case -132490690: {
                    return new Property("substanceDefinition[x]", "CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substanceDefinition);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "For example \"salt to parent\", \"active moiety\", \"starting material\", \"polymorph\".", 0, 1, this.type);
                }
                case -141812990: {
                    return new Property("isDefining", "boolean", "For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.", 0, 1, this.isDefining);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1223462971: {
                    return new Property("amount[x]", "Range", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1223457133: {
                    return new Property("amount[x]", "Ratio", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1832648218: {
                    return new Property("amountRatioHighLimit", "Ratio", "For use when the numeric has an uncertain range.", 0, 1, this.amountRatioHighLimit);
                }
                case -1424857166: {
                    return new Property("amountType", "CodeableConcept", "An operator for the amount, for example \"average\", \"approximately\", \"less than\".", 0, 1, this.amountType);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 718195427: {
                    Base[] baseArray;
                    if (this.substanceDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substanceDefinition;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -141812990: {
                    Base[] baseArray;
                    if (this.isDefining == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.isDefining;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1832648218: {
                    Base[] baseArray;
                    if (this.amountRatioHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amountRatioHighLimit;
                    }
                    return baseArray;
                }
                case -1424857166: {
                    Base[] baseArray;
                    if (this.amountType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.amountType;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 718195427: {
                    this.substanceDefinition = TypeConvertor.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -141812990: {
                    this.isDefining = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToType(value);
                    return value;
                }
                case -1832648218: {
                    this.amountRatioHighLimit = TypeConvertor.castToRatio(value);
                    return value;
                }
                case -1424857166: {
                    this.amountType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substanceDefinition[x]")) {
                this.substanceDefinition = TypeConvertor.castToType(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("isDefining")) {
                this.isDefining = TypeConvertor.castToBoolean(value);
            } else if (name.equals("amount[x]")) {
                this.amount = TypeConvertor.castToType(value);
            } else if (name.equals("amountRatioHighLimit")) {
                this.amountRatioHighLimit = TypeConvertor.castToRatio(value);
            } else if (name.equals("amountType")) {
                this.amountType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.getSource().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1767011651: {
                    return this.getSubstanceDefinition();
                }
                case 718195427: {
                    return this.getSubstanceDefinition();
                }
                case 3575610: {
                    return this.getType();
                }
                case -141812990: {
                    return this.getIsDefiningElement();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1832648218: {
                    return this.getAmountRatioHighLimit();
                }
                case -1424857166: {
                    return this.getAmountType();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 718195427: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -141812990: {
                    return new String[]{"boolean"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "Range", "Ratio", "string"};
                }
                case -1832648218: {
                    return new String[]{"Ratio"};
                }
                case -1424857166: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substanceDefinitionReference")) {
                this.substanceDefinition = new Reference();
                return this.substanceDefinition;
            }
            if (name.equals("substanceDefinitionCodeableConcept")) {
                this.substanceDefinition = new CodeableConcept();
                return this.substanceDefinition;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("isDefining")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.relationship.isDefining");
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountRange")) {
                this.amount = new Range();
                return this.amount;
            }
            if (name.equals("amountRatio")) {
                this.amount = new Ratio();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            if (name.equals("amountRatioHighLimit")) {
                this.amountRatioHighLimit = new Ratio();
                return this.amountRatioHighLimit;
            }
            if (name.equals("amountType")) {
                this.amountType = new CodeableConcept();
                return this.amountType;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionRelationshipComponent copy() {
            SubstanceDefinitionRelationshipComponent dst = new SubstanceDefinitionRelationshipComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionRelationshipComponent dst) {
            super.copyValues(dst);
            dst.substanceDefinition = this.substanceDefinition == null ? null : this.substanceDefinition.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.isDefining = this.isDefining == null ? null : this.isDefining.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.amountRatioHighLimit = this.amountRatioHighLimit == null ? null : this.amountRatioHighLimit.copy();
            CodeableConcept codeableConcept = dst.amountType = this.amountType == null ? null : this.amountType.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionRelationshipComponent)) {
                return false;
            }
            SubstanceDefinitionRelationshipComponent o = (SubstanceDefinitionRelationshipComponent)other_;
            return SubstanceDefinitionRelationshipComponent.compareDeep(this.substanceDefinition, o.substanceDefinition, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.type, o.type, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.isDefining, o.isDefining, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.amount, o.amount, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.amountRatioHighLimit, o.amountRatioHighLimit, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.amountType, o.amountType, true) && SubstanceDefinitionRelationshipComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionRelationshipComponent)) {
                return false;
            }
            SubstanceDefinitionRelationshipComponent o = (SubstanceDefinitionRelationshipComponent)other_;
            return SubstanceDefinitionRelationshipComponent.compareValues(this.isDefining, o.isDefining, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substanceDefinition, this.type, this.isDefining, this.amount, this.amountRatioHighLimit, this.amountType, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.relationship";
        }
    }

    @Block
    public static class SubstanceDefinitionNameOfficialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Which authority uses this official name", formalDefinition="Which authority uses this official name.")
        protected CodeableConcept authority;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the official name, for example 'provisional', 'approved'", formalDefinition="The status of the official name, for example 'provisional', 'approved'.")
        protected CodeableConcept status;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of official name change", formalDefinition="Date of official name change.")
        protected DateTimeType date;
        private static final long serialVersionUID = -2040011008L;

        public CodeableConcept getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameOfficialComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new CodeableConcept();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public SubstanceDefinitionNameOfficialComponent setAuthority(CodeableConcept value) {
            this.authority = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameOfficialComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceDefinitionNameOfficialComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameOfficialComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public SubstanceDefinitionNameOfficialComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public SubstanceDefinitionNameOfficialComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority));
            children.add(new Property("status", "CodeableConcept", "The status of the official name, for example 'provisional', 'approved'.", 0, 1, this.status));
            children.add(new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of the official name, for example 'provisional', 'approved'.", 0, 1, this.status);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthority();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 3076014: {
                    return this.getDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = new CodeableConcept();
                return this.authority;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.name.official.date");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionNameOfficialComponent copy() {
            SubstanceDefinitionNameOfficialComponent dst = new SubstanceDefinitionNameOfficialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionNameOfficialComponent dst) {
            super.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.date = this.date == null ? null : this.date.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionNameOfficialComponent)) {
                return false;
            }
            SubstanceDefinitionNameOfficialComponent o = (SubstanceDefinitionNameOfficialComponent)other_;
            return SubstanceDefinitionNameOfficialComponent.compareDeep(this.authority, o.authority, true) && SubstanceDefinitionNameOfficialComponent.compareDeep(this.status, o.status, true) && SubstanceDefinitionNameOfficialComponent.compareDeep(this.date, o.date, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionNameOfficialComponent)) {
                return false;
            }
            SubstanceDefinitionNameOfficialComponent o = (SubstanceDefinitionNameOfficialComponent)other_;
            return SubstanceDefinitionNameOfficialComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.status, this.date});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.name.official";
        }
    }

    @Block
    public static class SubstanceDefinitionNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual name", formalDefinition="The actual name.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name type, for example 'systematic',  'scientific, 'brand'", formalDefinition="Name type, for example 'systematic',  'scientific, 'brand'.")
        protected CodeableConcept type;
        @Child(name="status", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the name, for example 'current', 'proposed'", formalDefinition="The status of the name, for example 'current', 'proposed'.")
        protected CodeableConcept status;
        @Child(name="preferred", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If this is the preferred name for this substance", formalDefinition="If this is the preferred name for this substance.")
        protected BooleanType preferred;
        @Child(name="language", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Human language that the name is written in", formalDefinition="Human language that the name is written in.")
        protected List<CodeableConcept> language;
        @Child(name="domain", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive", formalDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.")
        protected List<CodeableConcept> domain;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The jurisdiction where this name applies", formalDefinition="The jurisdiction where this name applies.")
        protected List<CodeableConcept> jurisdiction;
        @Child(name="synonym", type={SubstanceDefinitionNameComponent.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A synonym of this particular name, by which the substance is also known", formalDefinition="A synonym of this particular name, by which the substance is also known.")
        protected List<SubstanceDefinitionNameComponent> synonym;
        @Child(name="translation", type={SubstanceDefinitionNameComponent.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A translation for this name into another human language", formalDefinition="A translation for this name into another human language.")
        protected List<SubstanceDefinitionNameComponent> translation;
        @Child(name="official", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Details of the official nature of this name", formalDefinition="Details of the official nature of this name.")
        protected List<SubstanceDefinitionNameOfficialComponent> official;
        @Child(name="source", type={DocumentReference.class}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        private static final long serialVersionUID = -1184238780L;

        public SubstanceDefinitionNameComponent() {
        }

        public SubstanceDefinitionNameComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceDefinitionNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceDefinitionNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceDefinitionNameComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceDefinitionNameComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionNameComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public SubstanceDefinitionNameComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public SubstanceDefinitionNameComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            return this.language;
        }

        public SubstanceDefinitionNameComponent setLanguage(List<CodeableConcept> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeableConcept item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLanguage() {
            CodeableConcept t = new CodeableConcept();
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addLanguage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return this;
        }

        public CodeableConcept getLanguageFirstRep() {
            if (this.getLanguage().isEmpty()) {
                this.addLanguage();
            }
            return this.getLanguage().get(0);
        }

        public List<CodeableConcept> getDomain() {
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            return this.domain;
        }

        public SubstanceDefinitionNameComponent setDomain(List<CodeableConcept> theDomain) {
            this.domain = theDomain;
            return this;
        }

        public boolean hasDomain() {
            if (this.domain == null) {
                return false;
            }
            for (CodeableConcept item : this.domain) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDomain() {
            CodeableConcept t = new CodeableConcept();
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addDomain(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return this;
        }

        public CodeableConcept getDomainFirstRep() {
            if (this.getDomain().isEmpty()) {
                this.addDomain();
            }
            return this.getDomain().get(0);
        }

        public List<CodeableConcept> getJurisdiction() {
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            return this.jurisdiction;
        }

        public SubstanceDefinitionNameComponent setJurisdiction(List<CodeableConcept> theJurisdiction) {
            this.jurisdiction = theJurisdiction;
            return this;
        }

        public boolean hasJurisdiction() {
            if (this.jurisdiction == null) {
                return false;
            }
            for (CodeableConcept item : this.jurisdiction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addJurisdiction() {
            CodeableConcept t = new CodeableConcept();
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addJurisdiction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return this;
        }

        public CodeableConcept getJurisdictionFirstRep() {
            if (this.getJurisdiction().isEmpty()) {
                this.addJurisdiction();
            }
            return this.getJurisdiction().get(0);
        }

        public List<SubstanceDefinitionNameComponent> getSynonym() {
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            return this.synonym;
        }

        public SubstanceDefinitionNameComponent setSynonym(List<SubstanceDefinitionNameComponent> theSynonym) {
            this.synonym = theSynonym;
            return this;
        }

        public boolean hasSynonym() {
            if (this.synonym == null) {
                return false;
            }
            for (SubstanceDefinitionNameComponent item : this.synonym) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceDefinitionNameComponent addSynonym() {
            SubstanceDefinitionNameComponent t = new SubstanceDefinitionNameComponent();
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            this.synonym.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addSynonym(SubstanceDefinitionNameComponent t) {
            if (t == null) {
                return this;
            }
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            this.synonym.add(t);
            return this;
        }

        public SubstanceDefinitionNameComponent getSynonymFirstRep() {
            if (this.getSynonym().isEmpty()) {
                this.addSynonym();
            }
            return this.getSynonym().get(0);
        }

        public List<SubstanceDefinitionNameComponent> getTranslation() {
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            return this.translation;
        }

        public SubstanceDefinitionNameComponent setTranslation(List<SubstanceDefinitionNameComponent> theTranslation) {
            this.translation = theTranslation;
            return this;
        }

        public boolean hasTranslation() {
            if (this.translation == null) {
                return false;
            }
            for (SubstanceDefinitionNameComponent item : this.translation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceDefinitionNameComponent addTranslation() {
            SubstanceDefinitionNameComponent t = new SubstanceDefinitionNameComponent();
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            this.translation.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addTranslation(SubstanceDefinitionNameComponent t) {
            if (t == null) {
                return this;
            }
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceDefinitionNameComponent>();
            }
            this.translation.add(t);
            return this;
        }

        public SubstanceDefinitionNameComponent getTranslationFirstRep() {
            if (this.getTranslation().isEmpty()) {
                this.addTranslation();
            }
            return this.getTranslation().get(0);
        }

        public List<SubstanceDefinitionNameOfficialComponent> getOfficial() {
            if (this.official == null) {
                this.official = new ArrayList<SubstanceDefinitionNameOfficialComponent>();
            }
            return this.official;
        }

        public SubstanceDefinitionNameComponent setOfficial(List<SubstanceDefinitionNameOfficialComponent> theOfficial) {
            this.official = theOfficial;
            return this;
        }

        public boolean hasOfficial() {
            if (this.official == null) {
                return false;
            }
            for (SubstanceDefinitionNameOfficialComponent item : this.official) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceDefinitionNameOfficialComponent addOfficial() {
            SubstanceDefinitionNameOfficialComponent t = new SubstanceDefinitionNameOfficialComponent();
            if (this.official == null) {
                this.official = new ArrayList<SubstanceDefinitionNameOfficialComponent>();
            }
            this.official.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addOfficial(SubstanceDefinitionNameOfficialComponent t) {
            if (t == null) {
                return this;
            }
            if (this.official == null) {
                this.official = new ArrayList<SubstanceDefinitionNameOfficialComponent>();
            }
            this.official.add(t);
            return this;
        }

        public SubstanceDefinitionNameOfficialComponent getOfficialFirstRep() {
            if (this.getOfficial().isEmpty()) {
                this.addOfficial();
            }
            return this.getOfficial().get(0);
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceDefinitionNameComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceDefinitionNameComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubstanceDefinition.SP_NAME, "string", "The actual name.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "Name type, for example 'systematic',  'scientific, 'brand'.", 0, 1, this.type));
            children.add(new Property("status", "CodeableConcept", "The status of the name, for example 'current', 'proposed'.", 0, 1, this.status));
            children.add(new Property("preferred", "boolean", "If this is the preferred name for this substance.", 0, 1, this.preferred));
            children.add(new Property("language", "CodeableConcept", "Human language that the name is written in.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property(SubstanceDefinition.SP_DOMAIN, "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain));
            children.add(new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction));
            children.add(new Property("synonym", "@SubstanceDefinition.name", "A synonym of this particular name, by which the substance is also known.", 0, Integer.MAX_VALUE, this.synonym));
            children.add(new Property("translation", "@SubstanceDefinition.name", "A translation for this name into another human language.", 0, Integer.MAX_VALUE, this.translation));
            children.add(new Property("official", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.official));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(SubstanceDefinition.SP_NAME, "string", "The actual name.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Name type, for example 'systematic',  'scientific, 'brand'.", 0, 1, this.type);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of the name, for example 'current', 'proposed'.", 0, 1, this.status);
                }
                case -1294005119: {
                    return new Property("preferred", "boolean", "If this is the preferred name for this substance.", 0, 1, this.preferred);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Human language that the name is written in.", 0, Integer.MAX_VALUE, this.language);
                }
                case -1326197564: {
                    return new Property(SubstanceDefinition.SP_DOMAIN, "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction);
                }
                case -1742128133: {
                    return new Property("synonym", "@SubstanceDefinition.name", "A synonym of this particular name, by which the substance is also known.", 0, Integer.MAX_VALUE, this.synonym);
                }
                case -1840647503: {
                    return new Property("translation", "@SubstanceDefinition.name", "A translation for this name into another human language.", 0, Integer.MAX_VALUE, this.translation);
                }
                case -765289749: {
                    return new Property("official", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.official);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.preferred;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case -1326197564: {
                    return this.domain == null ? new Base[]{} : this.domain.toArray(new Base[this.domain.size()]);
                }
                case -507075711: {
                    return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
                }
                case -1742128133: {
                    return this.synonym == null ? new Base[]{} : this.synonym.toArray(new Base[this.synonym.size()]);
                }
                case -1840647503: {
                    return this.translation == null ? new Base[]{} : this.translation.toArray(new Base[this.translation.size()]);
                }
                case -765289749: {
                    return this.official == null ? new Base[]{} : this.official.toArray(new Base[this.official.size()]);
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1294005119: {
                    this.preferred = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1326197564: {
                    this.getDomain().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -507075711: {
                    this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1742128133: {
                    this.getSynonym().add((SubstanceDefinitionNameComponent)value);
                    return value;
                }
                case -1840647503: {
                    this.getTranslation().add((SubstanceDefinitionNameComponent)value);
                    return value;
                }
                case -765289749: {
                    this.getOfficial().add((SubstanceDefinitionNameOfficialComponent)value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("preferred")) {
                this.preferred = TypeConvertor.castToBoolean(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(SubstanceDefinition.SP_DOMAIN)) {
                this.getDomain().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("jurisdiction")) {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("synonym")) {
                this.getSynonym().add((SubstanceDefinitionNameComponent)value);
            } else if (name.equals("translation")) {
                this.getTranslation().add((SubstanceDefinitionNameComponent)value);
            } else if (name.equals("official")) {
                this.getOfficial().add((SubstanceDefinitionNameOfficialComponent)value);
            } else if (name.equals("source")) {
                this.getSource().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case -1294005119: {
                    return this.getPreferredElement();
                }
                case -1613589672: {
                    return this.addLanguage();
                }
                case -1326197564: {
                    return this.addDomain();
                }
                case -507075711: {
                    return this.addJurisdiction();
                }
                case -1742128133: {
                    return this.addSynonym();
                }
                case -1840647503: {
                    return this.addTranslation();
                }
                case -765289749: {
                    return this.addOfficial();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case -1294005119: {
                    return new String[]{"boolean"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326197564: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -1742128133: {
                    return new String[]{"@SubstanceDefinition.name"};
                }
                case -1840647503: {
                    return new String[]{"@SubstanceDefinition.name"};
                }
                case -765289749: {
                    return new String[0];
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.name.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.name.preferred");
            }
            if (name.equals("language")) {
                return this.addLanguage();
            }
            if (name.equals(SubstanceDefinition.SP_DOMAIN)) {
                return this.addDomain();
            }
            if (name.equals("jurisdiction")) {
                return this.addJurisdiction();
            }
            if (name.equals("synonym")) {
                return this.addSynonym();
            }
            if (name.equals("translation")) {
                return this.addTranslation();
            }
            if (name.equals("official")) {
                return this.addOfficial();
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionNameComponent copy() {
            SubstanceDefinitionNameComponent dst = new SubstanceDefinitionNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.status = this.status == null ? null : this.status.copy();
            BooleanType booleanType = dst.preferred = this.preferred == null ? null : this.preferred.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.language) {
                    dst.language.add(codeableConcept.copy());
                }
            }
            if (this.domain != null) {
                dst.domain = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.domain) {
                    dst.domain.add(codeableConcept.copy());
                }
            }
            if (this.jurisdiction != null) {
                dst.jurisdiction = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.jurisdiction) {
                    dst.jurisdiction.add(codeableConcept.copy());
                }
            }
            if (this.synonym != null) {
                dst.synonym = new ArrayList<SubstanceDefinitionNameComponent>();
                for (SubstanceDefinitionNameComponent substanceDefinitionNameComponent : this.synonym) {
                    dst.synonym.add(substanceDefinitionNameComponent.copy());
                }
            }
            if (this.translation != null) {
                dst.translation = new ArrayList<SubstanceDefinitionNameComponent>();
                for (SubstanceDefinitionNameComponent substanceDefinitionNameComponent : this.translation) {
                    dst.translation.add(substanceDefinitionNameComponent.copy());
                }
            }
            if (this.official != null) {
                dst.official = new ArrayList<SubstanceDefinitionNameOfficialComponent>();
                for (SubstanceDefinitionNameOfficialComponent substanceDefinitionNameOfficialComponent : this.official) {
                    dst.official.add(substanceDefinitionNameOfficialComponent.copy());
                }
            }
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference reference : this.source) {
                    dst.source.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionNameComponent)) {
                return false;
            }
            SubstanceDefinitionNameComponent o = (SubstanceDefinitionNameComponent)other_;
            return SubstanceDefinitionNameComponent.compareDeep(this.name, o.name, true) && SubstanceDefinitionNameComponent.compareDeep(this.type, o.type, true) && SubstanceDefinitionNameComponent.compareDeep(this.status, o.status, true) && SubstanceDefinitionNameComponent.compareDeep(this.preferred, o.preferred, true) && SubstanceDefinitionNameComponent.compareDeep(this.language, o.language, true) && SubstanceDefinitionNameComponent.compareDeep(this.domain, o.domain, true) && SubstanceDefinitionNameComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubstanceDefinitionNameComponent.compareDeep(this.synonym, o.synonym, true) && SubstanceDefinitionNameComponent.compareDeep(this.translation, o.translation, true) && SubstanceDefinitionNameComponent.compareDeep(this.official, o.official, true) && SubstanceDefinitionNameComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionNameComponent)) {
                return false;
            }
            SubstanceDefinitionNameComponent o = (SubstanceDefinitionNameComponent)other_;
            return SubstanceDefinitionNameComponent.compareValues(this.name, o.name, true) && SubstanceDefinitionNameComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.type, this.status, this.preferred, this.language, this.domain, this.jurisdiction, this.synonym, this.translation, this.official, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.name";
        }
    }

    @Block
    public static class SubstanceDefinitionCodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code", formalDefinition="The specific code.")
        protected CodeableConcept code;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status of the code assignment, for example 'provisional', 'approved'", formalDefinition="Status of the code assignment, for example 'provisional', 'approved'.")
        protected CodeableConcept status;
        @Child(name="statusDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date at which the code status is changed as part of the terminology maintenance", formalDefinition="The date at which the code status is changed as part of the terminology maintenance.")
        protected DateTimeType statusDate;
        @Child(name="note", type={Annotation.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Any comment can be provided in this field, if necessary", formalDefinition="Any comment can be provided in this field, if necessary.")
        protected List<Annotation> note;
        @Child(name="source", type={DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        private static final long serialVersionUID = 1140562105L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionCodeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstanceDefinitionCodeComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionCodeComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceDefinitionCodeComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getStatusDateElement() {
            if (this.statusDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionCodeComponent.statusDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusDate = new DateTimeType();
                }
            }
            return this.statusDate;
        }

        public boolean hasStatusDateElement() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public boolean hasStatusDate() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public SubstanceDefinitionCodeComponent setStatusDateElement(DateTimeType value) {
            this.statusDate = value;
            return this;
        }

        public Date getStatusDate() {
            return this.statusDate == null ? null : (Date)this.statusDate.getValue();
        }

        public SubstanceDefinitionCodeComponent setStatusDate(Date value) {
            if (value == null) {
                this.statusDate = null;
            } else {
                if (this.statusDate == null) {
                    this.statusDate = new DateTimeType();
                }
                this.statusDate.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public SubstanceDefinitionCodeComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public SubstanceDefinitionCodeComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceDefinitionCodeComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceDefinitionCodeComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubstanceDefinition.SP_CODE, "CodeableConcept", "The specific code.", 0, 1, this.code));
            children.add(new Property("status", "CodeableConcept", "Status of the code assignment, for example 'provisional', 'approved'.", 0, 1, this.status));
            children.add(new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate));
            children.add(new Property("note", "Annotation", "Any comment can be provided in this field, if necessary.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(SubstanceDefinition.SP_CODE, "CodeableConcept", "The specific code.", 0, 1, this.code);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "Status of the code assignment, for example 'provisional', 'approved'.", 0, 1, this.status);
                }
                case 247524032: {
                    return new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Any comment can be provided in this field, if necessary.", 0, Integer.MAX_VALUE, this.note);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 247524032: {
                    Base[] baseArray;
                    if (this.statusDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.statusDate;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 247524032: {
                    this.statusDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -896505829: {
                    this.getSource().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("statusDate")) {
                this.statusDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("source")) {
                this.getSource().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 247524032: {
                    return this.getStatusDateElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 247524032: {
                    return new String[]{"dateTime"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("statusDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.code.statusDate");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionCodeComponent copy() {
            SubstanceDefinitionCodeComponent dst = new SubstanceDefinitionCodeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionCodeComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.status = this.status == null ? null : this.status.copy();
            DateTimeType dateTimeType = dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference reference : this.source) {
                    dst.source.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionCodeComponent)) {
                return false;
            }
            SubstanceDefinitionCodeComponent o = (SubstanceDefinitionCodeComponent)other_;
            return SubstanceDefinitionCodeComponent.compareDeep(this.code, o.code, true) && SubstanceDefinitionCodeComponent.compareDeep(this.status, o.status, true) && SubstanceDefinitionCodeComponent.compareDeep(this.statusDate, o.statusDate, true) && SubstanceDefinitionCodeComponent.compareDeep(this.note, o.note, true) && SubstanceDefinitionCodeComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionCodeComponent)) {
                return false;
            }
            SubstanceDefinitionCodeComponent o = (SubstanceDefinitionCodeComponent)other_;
            return SubstanceDefinitionCodeComponent.compareValues(this.statusDate, o.statusDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.statusDate, this.note, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.code";
        }
    }

    @Block
    public static class SubstanceDefinitionStructureRepresentationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The kind of structural representation (e.g. full, partial) or the technique used to derive the analytical characterization of the substance (e.g. x-ray, HPLC, NMR, peptide mapping, ligand binding assay, etc.)", formalDefinition="The kind of structural representation (e.g. full, partial) or the technique used to derive the analytical characterization of the substance (e.g. x-ray, HPLC, NMR, peptide mapping, ligand binding assay, etc.).")
        protected CodeableConcept type;
        @Child(name="representation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The structural representation or characterization as a text string in a standard format", formalDefinition="The structural representation or characterization as a text string in a standard format.")
        protected StringType representation;
        @Child(name="format", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The format of the representation e.g. InChI, SMILES, MOLFILE, CDX, SDF, PDB, mmCIF. The logical content type rather than the physical file format of a document", formalDefinition="The format of the representation e.g. InChI, SMILES, MOLFILE, CDX, SDF, PDB, mmCIF. The logical content type rather than the physical file format of a document.")
        protected CodeableConcept format;
        @Child(name="document", type={DocumentReference.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An attached file with the structural representation or characterization e.g. a molecular structure graphic of the substance, a JCAMP or AnIML file", formalDefinition="An attached file with the structural representation or characterization e.g. a molecular structure graphic of the substance, a JCAMP or AnIML file.")
        protected Reference document;
        private static final long serialVersionUID = 138704347L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureRepresentationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceDefinitionStructureRepresentationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRepresentationElement() {
            if (this.representation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureRepresentationComponent.representation");
                }
                if (Configuration.doAutoCreate()) {
                    this.representation = new StringType();
                }
            }
            return this.representation;
        }

        public boolean hasRepresentationElement() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public boolean hasRepresentation() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public SubstanceDefinitionStructureRepresentationComponent setRepresentationElement(StringType value) {
            this.representation = value;
            return this;
        }

        public String getRepresentation() {
            return this.representation == null ? null : (String)this.representation.getValue();
        }

        public SubstanceDefinitionStructureRepresentationComponent setRepresentation(String value) {
            if (Utilities.noString((String)value)) {
                this.representation = null;
            } else {
                if (this.representation == null) {
                    this.representation = new StringType();
                }
                this.representation.setValue(value);
            }
            return this;
        }

        public CodeableConcept getFormat() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureRepresentationComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new CodeableConcept();
                }
            }
            return this.format;
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public SubstanceDefinitionStructureRepresentationComponent setFormat(CodeableConcept value) {
            this.format = value;
            return this;
        }

        public Reference getDocument() {
            if (this.document == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureRepresentationComponent.document");
                }
                if (Configuration.doAutoCreate()) {
                    this.document = new Reference();
                }
            }
            return this.document;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public SubstanceDefinitionStructureRepresentationComponent setDocument(Reference value) {
            this.document = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of structural representation (e.g. full, partial) or the technique used to derive the analytical characterization of the substance (e.g. x-ray, HPLC, NMR, peptide mapping, ligand binding assay, etc.).", 0, 1, this.type));
            children.add(new Property("representation", "string", "The structural representation or characterization as a text string in a standard format.", 0, 1, this.representation));
            children.add(new Property("format", "CodeableConcept", "The format of the representation e.g. InChI, SMILES, MOLFILE, CDX, SDF, PDB, mmCIF. The logical content type rather than the physical file format of a document.", 0, 1, this.format));
            children.add(new Property("document", "Reference(DocumentReference)", "An attached file with the structural representation or characterization e.g. a molecular structure graphic of the substance, a JCAMP or AnIML file.", 0, 1, this.document));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of structural representation (e.g. full, partial) or the technique used to derive the analytical characterization of the substance (e.g. x-ray, HPLC, NMR, peptide mapping, ligand binding assay, etc.).", 0, 1, this.type);
                }
                case -671065907: {
                    return new Property("representation", "string", "The structural representation or characterization as a text string in a standard format.", 0, 1, this.representation);
                }
                case -1268779017: {
                    return new Property("format", "CodeableConcept", "The format of the representation e.g. InChI, SMILES, MOLFILE, CDX, SDF, PDB, mmCIF. The logical content type rather than the physical file format of a document.", 0, 1, this.format);
                }
                case 861720859: {
                    return new Property("document", "Reference(DocumentReference)", "An attached file with the structural representation or characterization e.g. a molecular structure graphic of the substance, a JCAMP or AnIML file.", 0, 1, this.document);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -671065907: {
                    Base[] baseArray;
                    if (this.representation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.representation;
                    }
                    return baseArray;
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.format;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.document;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -671065907: {
                    this.representation = TypeConvertor.castToString(value);
                    return value;
                }
                case -1268779017: {
                    this.format = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 861720859: {
                    this.document = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("representation")) {
                this.representation = TypeConvertor.castToString(value);
            } else if (name.equals("format")) {
                this.format = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("document")) {
                this.document = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -671065907: {
                    return this.getRepresentationElement();
                }
                case -1268779017: {
                    return this.getFormat();
                }
                case 861720859: {
                    return this.getDocument();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -671065907: {
                    return new String[]{"string"};
                }
                case -1268779017: {
                    return new String[]{"CodeableConcept"};
                }
                case 861720859: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("representation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.structure.representation.representation");
            }
            if (name.equals("format")) {
                this.format = new CodeableConcept();
                return this.format;
            }
            if (name.equals("document")) {
                this.document = new Reference();
                return this.document;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionStructureRepresentationComponent copy() {
            SubstanceDefinitionStructureRepresentationComponent dst = new SubstanceDefinitionStructureRepresentationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionStructureRepresentationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.representation = this.representation == null ? null : this.representation.copy();
            dst.format = this.format == null ? null : this.format.copy();
            dst.document = this.document == null ? null : this.document.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureRepresentationComponent)) {
                return false;
            }
            SubstanceDefinitionStructureRepresentationComponent o = (SubstanceDefinitionStructureRepresentationComponent)other_;
            return SubstanceDefinitionStructureRepresentationComponent.compareDeep(this.type, o.type, true) && SubstanceDefinitionStructureRepresentationComponent.compareDeep(this.representation, o.representation, true) && SubstanceDefinitionStructureRepresentationComponent.compareDeep(this.format, o.format, true) && SubstanceDefinitionStructureRepresentationComponent.compareDeep(this.document, o.document, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureRepresentationComponent)) {
                return false;
            }
            SubstanceDefinitionStructureRepresentationComponent o = (SubstanceDefinitionStructureRepresentationComponent)other_;
            return SubstanceDefinitionStructureRepresentationComponent.compareValues(this.representation, o.representation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.representation, this.format, this.document});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.structure.representation";
        }
    }

    @Block
    public static class SubstanceDefinitionStructureIsotopeMolecularWeightComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The method by which the molecular weight was determined", formalDefinition="The method by which the molecular weight was determined.")
        protected CodeableConcept method;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average", formalDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average.")
        protected CodeableConcept type;
        @Child(name="amount", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field", formalDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.")
        protected Quantity amount;
        private static final long serialVersionUID = 805939780L;

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeMolecularWeightComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeMolecularWeightComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeMolecularWeightComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method));
            children.add(new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type));
            children.add(new Property("amount", "Quantity", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return this.getMethod();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent copy() {
            SubstanceDefinitionStructureIsotopeMolecularWeightComponent dst = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionStructureIsotopeMolecularWeightComponent dst) {
            super.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceDefinitionStructureIsotopeMolecularWeightComponent o = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)other_;
            return SubstanceDefinitionStructureIsotopeMolecularWeightComponent.compareDeep(this.method, o.method, true) && SubstanceDefinitionStructureIsotopeMolecularWeightComponent.compareDeep(this.type, o.type, true) && SubstanceDefinitionStructureIsotopeMolecularWeightComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceDefinitionStructureIsotopeMolecularWeightComponent o = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.method, this.type, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.structure.isotope.molecularWeight";
        }
    }

    @Block
    public static class SubstanceDefinitionStructureIsotopeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance identifier for each non-natural or radioisotope", formalDefinition="Substance identifier for each non-natural or radioisotope.")
        protected Identifier identifier;
        @Child(name="name", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance name for each non-natural or radioisotope", formalDefinition="Substance name for each non-natural or radioisotope.")
        protected CodeableConcept name;
        @Child(name="substitution", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of isotopic substitution present in a single substance", formalDefinition="The type of isotopic substitution present in a single substance.")
        protected CodeableConcept substitution;
        @Child(name="halfLife", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Half life - for a non-natural nuclide", formalDefinition="Half life - for a non-natural nuclide.")
        protected Quantity halfLife;
        @Child(name="molecularWeight", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceDefinitionStructureIsotopeMolecularWeightComponent molecularWeight;
        private static final long serialVersionUID = 1897382758L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeableConcept();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeComponent setName(CodeableConcept value) {
            this.name = value;
            return this;
        }

        public CodeableConcept getSubstitution() {
            if (this.substitution == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeComponent.substitution");
                }
                if (Configuration.doAutoCreate()) {
                    this.substitution = new CodeableConcept();
                }
            }
            return this.substitution;
        }

        public boolean hasSubstitution() {
            return this.substitution != null && !this.substitution.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeComponent setSubstitution(CodeableConcept value) {
            this.substitution = value;
            return this;
        }

        public Quantity getHalfLife() {
            if (this.halfLife == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeComponent.halfLife");
                }
                if (Configuration.doAutoCreate()) {
                    this.halfLife = new Quantity();
                }
            }
            return this.halfLife;
        }

        public boolean hasHalfLife() {
            return this.halfLife != null && !this.halfLife.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeComponent setHalfLife(Quantity value) {
            this.halfLife = value;
            return this;
        }

        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureIsotopeComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceDefinitionStructureIsotopeComponent setMolecularWeight(SubstanceDefinitionStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubstanceDefinition.SP_IDENTIFIER, "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.identifier));
            children.add(new Property(SubstanceDefinition.SP_NAME, "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.name));
            children.add(new Property("substitution", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitution));
            children.add(new Property("halfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.halfLife));
            children.add(new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(SubstanceDefinition.SP_IDENTIFIER, "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property(SubstanceDefinition.SP_NAME, "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.name);
                }
                case 826147581: {
                    return new Property("substitution", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitution);
                }
                case -54292017: {
                    return new Property("halfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.halfLife);
                }
                case 635625672: {
                    return new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 826147581: {
                    Base[] baseArray;
                    if (this.substitution == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.substitution;
                    }
                    return baseArray;
                }
                case -54292017: {
                    Base[] baseArray;
                    if (this.halfLife == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.halfLife;
                    }
                    return baseArray;
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 826147581: {
                    this.substitution = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -54292017: {
                    this.halfLife = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals(SubstanceDefinition.SP_NAME)) {
                this.name = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("substitution")) {
                this.substitution = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("halfLife")) {
                this.halfLife = TypeConvertor.castToQuantity(value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getName();
                }
                case 826147581: {
                    return this.getSubstitution();
                }
                case -54292017: {
                    return this.getHalfLife();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"CodeableConcept"};
                }
                case 826147581: {
                    return new String[]{"CodeableConcept"};
                }
                case -54292017: {
                    return new String[]{"Quantity"};
                }
                case 635625672: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(SubstanceDefinition.SP_NAME)) {
                this.name = new CodeableConcept();
                return this.name;
            }
            if (name.equals("substitution")) {
                this.substitution = new CodeableConcept();
                return this.substitution;
            }
            if (name.equals("halfLife")) {
                this.halfLife = new Quantity();
                return this.halfLife;
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionStructureIsotopeComponent copy() {
            SubstanceDefinitionStructureIsotopeComponent dst = new SubstanceDefinitionStructureIsotopeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionStructureIsotopeComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.substitution = this.substitution == null ? null : this.substitution.copy();
            dst.halfLife = this.halfLife == null ? null : this.halfLife.copy();
            dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureIsotopeComponent)) {
                return false;
            }
            SubstanceDefinitionStructureIsotopeComponent o = (SubstanceDefinitionStructureIsotopeComponent)other_;
            return SubstanceDefinitionStructureIsotopeComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceDefinitionStructureIsotopeComponent.compareDeep(this.name, o.name, true) && SubstanceDefinitionStructureIsotopeComponent.compareDeep(this.substitution, o.substitution, true) && SubstanceDefinitionStructureIsotopeComponent.compareDeep(this.halfLife, o.halfLife, true) && SubstanceDefinitionStructureIsotopeComponent.compareDeep(this.molecularWeight, o.molecularWeight, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureIsotopeComponent)) {
                return false;
            }
            SubstanceDefinitionStructureIsotopeComponent o = (SubstanceDefinitionStructureIsotopeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.name, this.substitution, this.halfLife, this.molecularWeight});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.structure.isotope";
        }
    }

    @Block
    public static class SubstanceDefinitionStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula of this substance, typically using the Hill system", formalDefinition="Molecular formula of this substance, typically using the Hill system.")
        protected StringType molecularFormula;
        @Child(name="molecularFormulaByMoiety", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot", formalDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.")
        protected StringType molecularFormulaByMoiety;
        @Child(name="isotope", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio", formalDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.")
        protected List<SubstanceDefinitionStructureIsotopeComponent> isotope;
        @Child(name="molecularWeight", type={SubstanceDefinitionStructureIsotopeMolecularWeightComponent.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceDefinitionStructureIsotopeMolecularWeightComponent molecularWeight;
        @Child(name="technique", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The method used to elucidate the structure or characterization of the drug substance. Examples: X-ray, HPLC, NMR, Peptide mapping, Ligand binding assay", formalDefinition="The method used to elucidate the structure or characterization of the drug substance. Examples: X-ray, HPLC, NMR, Peptide mapping, Ligand binding assay.")
        protected List<CodeableConcept> technique;
        @Child(name="sourceDocument", type={DocumentReference.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature about the source of information", formalDefinition="Supporting literature about the source of information.")
        protected List<Reference> sourceDocument;
        @Child(name="representation", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A depiction of the structure or characterization of the substance", formalDefinition="A depiction of the structure or characterization of the substance.")
        protected List<SubstanceDefinitionStructureRepresentationComponent> representation;
        private static final long serialVersionUID = -1648605311L;

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceDefinitionStructureComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceDefinitionStructureComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceDefinitionStructureComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceDefinitionStructureComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public StringType getMolecularFormulaByMoietyElement() {
            if (this.molecularFormulaByMoiety == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureComponent.molecularFormulaByMoiety");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormulaByMoiety = new StringType();
                }
            }
            return this.molecularFormulaByMoiety;
        }

        public boolean hasMolecularFormulaByMoietyElement() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public boolean hasMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public SubstanceDefinitionStructureComponent setMolecularFormulaByMoietyElement(StringType value) {
            this.molecularFormulaByMoiety = value;
            return this;
        }

        public String getMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety == null ? null : (String)this.molecularFormulaByMoiety.getValue();
        }

        public SubstanceDefinitionStructureComponent setMolecularFormulaByMoiety(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormulaByMoiety = null;
            } else {
                if (this.molecularFormulaByMoiety == null) {
                    this.molecularFormulaByMoiety = new StringType();
                }
                this.molecularFormulaByMoiety.setValue(value);
            }
            return this;
        }

        public List<SubstanceDefinitionStructureIsotopeComponent> getIsotope() {
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceDefinitionStructureIsotopeComponent>();
            }
            return this.isotope;
        }

        public SubstanceDefinitionStructureComponent setIsotope(List<SubstanceDefinitionStructureIsotopeComponent> theIsotope) {
            this.isotope = theIsotope;
            return this;
        }

        public boolean hasIsotope() {
            if (this.isotope == null) {
                return false;
            }
            for (SubstanceDefinitionStructureIsotopeComponent item : this.isotope) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceDefinitionStructureIsotopeComponent addIsotope() {
            SubstanceDefinitionStructureIsotopeComponent t = new SubstanceDefinitionStructureIsotopeComponent();
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceDefinitionStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return t;
        }

        public SubstanceDefinitionStructureComponent addIsotope(SubstanceDefinitionStructureIsotopeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceDefinitionStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return this;
        }

        public SubstanceDefinitionStructureIsotopeComponent getIsotopeFirstRep() {
            if (this.getIsotope().isEmpty()) {
                this.addIsotope();
            }
            return this.getIsotope().get(0);
        }

        public SubstanceDefinitionStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionStructureComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceDefinitionStructureComponent setMolecularWeight(SubstanceDefinitionStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        public List<CodeableConcept> getTechnique() {
            if (this.technique == null) {
                this.technique = new ArrayList<CodeableConcept>();
            }
            return this.technique;
        }

        public SubstanceDefinitionStructureComponent setTechnique(List<CodeableConcept> theTechnique) {
            this.technique = theTechnique;
            return this;
        }

        public boolean hasTechnique() {
            if (this.technique == null) {
                return false;
            }
            for (CodeableConcept item : this.technique) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTechnique() {
            CodeableConcept t = new CodeableConcept();
            if (this.technique == null) {
                this.technique = new ArrayList<CodeableConcept>();
            }
            this.technique.add(t);
            return t;
        }

        public SubstanceDefinitionStructureComponent addTechnique(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.technique == null) {
                this.technique = new ArrayList<CodeableConcept>();
            }
            this.technique.add(t);
            return this;
        }

        public CodeableConcept getTechniqueFirstRep() {
            if (this.getTechnique().isEmpty()) {
                this.addTechnique();
            }
            return this.getTechnique().get(0);
        }

        public List<Reference> getSourceDocument() {
            if (this.sourceDocument == null) {
                this.sourceDocument = new ArrayList<Reference>();
            }
            return this.sourceDocument;
        }

        public SubstanceDefinitionStructureComponent setSourceDocument(List<Reference> theSourceDocument) {
            this.sourceDocument = theSourceDocument;
            return this;
        }

        public boolean hasSourceDocument() {
            if (this.sourceDocument == null) {
                return false;
            }
            for (Reference item : this.sourceDocument) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSourceDocument() {
            Reference t = new Reference();
            if (this.sourceDocument == null) {
                this.sourceDocument = new ArrayList<Reference>();
            }
            this.sourceDocument.add(t);
            return t;
        }

        public SubstanceDefinitionStructureComponent addSourceDocument(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.sourceDocument == null) {
                this.sourceDocument = new ArrayList<Reference>();
            }
            this.sourceDocument.add(t);
            return this;
        }

        public Reference getSourceDocumentFirstRep() {
            if (this.getSourceDocument().isEmpty()) {
                this.addSourceDocument();
            }
            return this.getSourceDocument().get(0);
        }

        public List<SubstanceDefinitionStructureRepresentationComponent> getRepresentation() {
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceDefinitionStructureRepresentationComponent>();
            }
            return this.representation;
        }

        public SubstanceDefinitionStructureComponent setRepresentation(List<SubstanceDefinitionStructureRepresentationComponent> theRepresentation) {
            this.representation = theRepresentation;
            return this;
        }

        public boolean hasRepresentation() {
            if (this.representation == null) {
                return false;
            }
            for (SubstanceDefinitionStructureRepresentationComponent item : this.representation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceDefinitionStructureRepresentationComponent addRepresentation() {
            SubstanceDefinitionStructureRepresentationComponent t = new SubstanceDefinitionStructureRepresentationComponent();
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceDefinitionStructureRepresentationComponent>();
            }
            this.representation.add(t);
            return t;
        }

        public SubstanceDefinitionStructureComponent addRepresentation(SubstanceDefinitionStructureRepresentationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceDefinitionStructureRepresentationComponent>();
            }
            this.representation.add(t);
            return this;
        }

        public SubstanceDefinitionStructureRepresentationComponent getRepresentationFirstRep() {
            if (this.getRepresentation().isEmpty()) {
                this.addRepresentation();
            }
            return this.getRepresentation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula of this substance, typically using the Hill system.", 0, 1, this.molecularFormula));
            children.add(new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety));
            children.add(new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope));
            children.add(new Property("molecularWeight", "@SubstanceDefinition.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
            children.add(new Property("technique", "CodeableConcept", "The method used to elucidate the structure or characterization of the drug substance. Examples: X-ray, HPLC, NMR, Peptide mapping, Ligand binding assay.", 0, Integer.MAX_VALUE, this.technique));
            children.add(new Property("sourceDocument", "Reference(DocumentReference)", "Supporting literature about the source of information.", 0, Integer.MAX_VALUE, this.sourceDocument));
            children.add(new Property("representation", "", "A depiction of the structure or characterization of the substance.", 0, Integer.MAX_VALUE, this.representation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula of this substance, typically using the Hill system.", 0, 1, this.molecularFormula);
                }
                case 1315452848: {
                    return new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety);
                }
                case 2097035189: {
                    return new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope);
                }
                case 635625672: {
                    return new Property("molecularWeight", "@SubstanceDefinition.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
                case 1469675088: {
                    return new Property("technique", "CodeableConcept", "The method used to elucidate the structure or characterization of the drug substance. Examples: X-ray, HPLC, NMR, Peptide mapping, Ligand binding assay.", 0, Integer.MAX_VALUE, this.technique);
                }
                case -501788074: {
                    return new Property("sourceDocument", "Reference(DocumentReference)", "Supporting literature about the source of information.", 0, Integer.MAX_VALUE, this.sourceDocument);
                }
                case -671065907: {
                    return new Property("representation", "", "A depiction of the structure or characterization of the substance.", 0, Integer.MAX_VALUE, this.representation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case 1315452848: {
                    Base[] baseArray;
                    if (this.molecularFormulaByMoiety == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.molecularFormulaByMoiety;
                    }
                    return baseArray;
                }
                case 2097035189: {
                    return this.isotope == null ? new Base[]{} : this.isotope.toArray(new Base[this.isotope.size()]);
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
                case 1469675088: {
                    return this.technique == null ? new Base[]{} : this.technique.toArray(new Base[this.technique.size()]);
                }
                case -501788074: {
                    return this.sourceDocument == null ? new Base[]{} : this.sourceDocument.toArray(new Base[this.sourceDocument.size()]);
                }
                case -671065907: {
                    return this.representation == null ? new Base[]{} : this.representation.toArray(new Base[this.representation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    this.stereochemistry = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = TypeConvertor.castToString(value);
                    return value;
                }
                case 1315452848: {
                    this.molecularFormulaByMoiety = TypeConvertor.castToString(value);
                    return value;
                }
                case 2097035189: {
                    this.getIsotope().add((SubstanceDefinitionStructureIsotopeComponent)value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
                case 1469675088: {
                    this.getTechnique().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -501788074: {
                    this.getSourceDocument().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -671065907: {
                    this.getRepresentation().add((SubstanceDefinitionStructureRepresentationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = TypeConvertor.castToString(value);
            } else if (name.equals("molecularFormulaByMoiety")) {
                this.molecularFormulaByMoiety = TypeConvertor.castToString(value);
            } else if (name.equals("isotope")) {
                this.getIsotope().add((SubstanceDefinitionStructureIsotopeComponent)value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceDefinitionStructureIsotopeMolecularWeightComponent)value;
            } else if (name.equals("technique")) {
                this.getTechnique().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("sourceDocument")) {
                this.getSourceDocument().add(TypeConvertor.castToReference(value));
            } else if (name.equals("representation")) {
                this.getRepresentation().add((SubstanceDefinitionStructureRepresentationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case 1315452848: {
                    return this.getMolecularFormulaByMoietyElement();
                }
                case 2097035189: {
                    return this.addIsotope();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
                case 1469675088: {
                    return this.addTechnique();
                }
                case -501788074: {
                    return this.addSourceDocument();
                }
                case -671065907: {
                    return this.addRepresentation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case 1315452848: {
                    return new String[]{"string"};
                }
                case 2097035189: {
                    return new String[0];
                }
                case 635625672: {
                    return new String[]{"@SubstanceDefinition.structure.isotope.molecularWeight"};
                }
                case 1469675088: {
                    return new String[]{"CodeableConcept"};
                }
                case -501788074: {
                    return new String[]{"Reference"};
                }
                case -671065907: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.structure.molecularFormula");
            }
            if (name.equals("molecularFormulaByMoiety")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.structure.molecularFormulaByMoiety");
            }
            if (name.equals("isotope")) {
                return this.addIsotope();
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceDefinitionStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            if (name.equals("technique")) {
                return this.addTechnique();
            }
            if (name.equals("sourceDocument")) {
                return this.addSourceDocument();
            }
            if (name.equals("representation")) {
                return this.addRepresentation();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionStructureComponent copy() {
            SubstanceDefinitionStructureComponent dst = new SubstanceDefinitionStructureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionStructureComponent dst) {
            super.copyValues(dst);
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            StringType stringType = dst.molecularFormulaByMoiety = this.molecularFormulaByMoiety == null ? null : this.molecularFormulaByMoiety.copy();
            if (this.isotope != null) {
                dst.isotope = new ArrayList<SubstanceDefinitionStructureIsotopeComponent>();
                for (SubstanceDefinitionStructureIsotopeComponent substanceDefinitionStructureIsotopeComponent : this.isotope) {
                    dst.isotope.add(substanceDefinitionStructureIsotopeComponent.copy());
                }
            }
            SubstanceDefinitionStructureIsotopeMolecularWeightComponent substanceDefinitionStructureIsotopeMolecularWeightComponent = dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
            if (this.technique != null) {
                dst.technique = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.technique) {
                    dst.technique.add(codeableConcept.copy());
                }
            }
            if (this.sourceDocument != null) {
                dst.sourceDocument = new ArrayList<Reference>();
                for (Reference reference : this.sourceDocument) {
                    dst.sourceDocument.add(reference.copy());
                }
            }
            if (this.representation != null) {
                dst.representation = new ArrayList<SubstanceDefinitionStructureRepresentationComponent>();
                for (SubstanceDefinitionStructureRepresentationComponent substanceDefinitionStructureRepresentationComponent : this.representation) {
                    dst.representation.add(substanceDefinitionStructureRepresentationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureComponent)) {
                return false;
            }
            SubstanceDefinitionStructureComponent o = (SubstanceDefinitionStructureComponent)other_;
            return SubstanceDefinitionStructureComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceDefinitionStructureComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceDefinitionStructureComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceDefinitionStructureComponent.compareDeep(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true) && SubstanceDefinitionStructureComponent.compareDeep(this.isotope, o.isotope, true) && SubstanceDefinitionStructureComponent.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceDefinitionStructureComponent.compareDeep(this.technique, o.technique, true) && SubstanceDefinitionStructureComponent.compareDeep(this.sourceDocument, o.sourceDocument, true) && SubstanceDefinitionStructureComponent.compareDeep(this.representation, o.representation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionStructureComponent)) {
                return false;
            }
            SubstanceDefinitionStructureComponent o = (SubstanceDefinitionStructureComponent)other_;
            return SubstanceDefinitionStructureComponent.compareValues(this.molecularFormula, o.molecularFormula, true) && SubstanceDefinitionStructureComponent.compareValues(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.stereochemistry, this.opticalActivity, this.molecularFormula, this.molecularFormulaByMoiety, this.isotope, this.molecularWeight, this.technique, this.sourceDocument, this.representation});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.structure";
        }
    }

    @Block
    public static class SubstanceDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A category for this property, e.g. Physical, Chemical, Enzymatic", formalDefinition="A category for this property, e.g. Physical, Chemical, Enzymatic.")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Property type e.g. viscosity, pH, isoelectric point", formalDefinition="Property type e.g. viscosity, pH, isoelectric point.")
        protected CodeableConcept code;
        @Child(name="parameters", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1)", formalDefinition="Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).")
        protected StringType parameters;
        @Child(name="definingSubstance", type={CodeableReference.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol)", formalDefinition="A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).")
        protected CodeableReference definingSubstance;
        @Child(name="amount", type={Quantity.class, StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this property", formalDefinition="Quantitative value for this property.")
        protected DataType amount;
        @Child(name="referenceRange", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Range of typical values", formalDefinition="Range of typical values.")
        protected Range referenceRange;
        @Child(name="source", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        private static final long serialVersionUID = 468287211L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionPropertyComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getParametersElement() {
            if (this.parameters == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionPropertyComponent.parameters");
                }
                if (Configuration.doAutoCreate()) {
                    this.parameters = new StringType();
                }
            }
            return this.parameters;
        }

        public boolean hasParametersElement() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public boolean hasParameters() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setParametersElement(StringType value) {
            this.parameters = value;
            return this;
        }

        public String getParameters() {
            return this.parameters == null ? null : (String)this.parameters.getValue();
        }

        public SubstanceDefinitionPropertyComponent setParameters(String value) {
            if (Utilities.noString((String)value)) {
                this.parameters = null;
            } else {
                if (this.parameters == null) {
                    this.parameters = new StringType();
                }
                this.parameters.setValue(value);
            }
            return this;
        }

        public CodeableReference getDefiningSubstance() {
            if (this.definingSubstance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionPropertyComponent.definingSubstance");
                }
                if (Configuration.doAutoCreate()) {
                    this.definingSubstance = new CodeableReference();
                }
            }
            return this.definingSubstance;
        }

        public boolean hasDefiningSubstance() {
            return this.definingSubstance != null && !this.definingSubstance.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setDefiningSubstance(CodeableReference value) {
            this.definingSubstance = value;
            return this;
        }

        public DataType getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setAmount(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceDefinition.property.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        public Range getReferenceRange() {
            if (this.referenceRange == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionPropertyComponent.referenceRange");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceRange = new Range();
                }
            }
            return this.referenceRange;
        }

        public boolean hasReferenceRange() {
            return this.referenceRange != null && !this.referenceRange.isEmpty();
        }

        public SubstanceDefinitionPropertyComponent setReferenceRange(Range value) {
            this.referenceRange = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceDefinitionPropertyComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceDefinitionPropertyComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubstanceDefinition.SP_CATEGORY, "CodeableConcept", "A category for this property, e.g. Physical, Chemical, Enzymatic.", 0, 1, this.category));
            children.add(new Property(SubstanceDefinition.SP_CODE, "CodeableConcept", "Property type e.g. viscosity, pH, isoelectric point.", 0, 1, this.code));
            children.add(new Property("parameters", "string", "Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).", 0, 1, this.parameters));
            children.add(new Property("definingSubstance", "CodeableReference(SubstanceDefinition|Substance)", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance));
            children.add(new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount));
            children.add(new Property("referenceRange", "Range", "Range of typical values.", 0, 1, this.referenceRange));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property(SubstanceDefinition.SP_CATEGORY, "CodeableConcept", "A category for this property, e.g. Physical, Chemical, Enzymatic.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property(SubstanceDefinition.SP_CODE, "CodeableConcept", "Property type e.g. viscosity, pH, isoelectric point.", 0, 1, this.code);
                }
                case 458736106: {
                    return new Property("parameters", "string", "Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).", 0, 1, this.parameters);
                }
                case 1901076632: {
                    return new Property("definingSubstance", "CodeableReference(SubstanceDefinition|Substance)", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case -1912545102: {
                    return new Property("referenceRange", "Range", "Range of typical values.", 0, 1, this.referenceRange);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 458736106: {
                    Base[] baseArray;
                    if (this.parameters == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.parameters;
                    }
                    return baseArray;
                }
                case 1901076632: {
                    Base[] baseArray;
                    if (this.definingSubstance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.definingSubstance;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1912545102: {
                    Base[] baseArray;
                    if (this.referenceRange == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.referenceRange;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 458736106: {
                    this.parameters = TypeConvertor.castToString(value);
                    return value;
                }
                case 1901076632: {
                    this.definingSubstance = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToType(value);
                    return value;
                }
                case -1912545102: {
                    this.referenceRange = TypeConvertor.castToRange(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_CATEGORY)) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(SubstanceDefinition.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("parameters")) {
                this.parameters = TypeConvertor.castToString(value);
            } else if (name.equals("definingSubstance")) {
                this.definingSubstance = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("amount[x]")) {
                this.amount = TypeConvertor.castToType(value);
            } else if (name.equals("referenceRange")) {
                this.referenceRange = TypeConvertor.castToRange(value);
            } else if (name.equals("source")) {
                this.getSource().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 458736106: {
                    return this.getParametersElement();
                }
                case 1901076632: {
                    return this.getDefiningSubstance();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1912545102: {
                    return this.getReferenceRange();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 458736106: {
                    return new String[]{"string"};
                }
                case 1901076632: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "string"};
                }
                case -1912545102: {
                    return new String[]{"Range"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubstanceDefinition.SP_CATEGORY)) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals(SubstanceDefinition.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("parameters")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.property.parameters");
            }
            if (name.equals("definingSubstance")) {
                this.definingSubstance = new CodeableReference();
                return this.definingSubstance;
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            if (name.equals("referenceRange")) {
                this.referenceRange = new Range();
                return this.referenceRange;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionPropertyComponent copy() {
            SubstanceDefinitionPropertyComponent dst = new SubstanceDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.parameters = this.parameters == null ? null : this.parameters.copy();
            dst.definingSubstance = this.definingSubstance == null ? null : this.definingSubstance.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            Range range = dst.referenceRange = this.referenceRange == null ? null : this.referenceRange.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionPropertyComponent)) {
                return false;
            }
            SubstanceDefinitionPropertyComponent o = (SubstanceDefinitionPropertyComponent)other_;
            return SubstanceDefinitionPropertyComponent.compareDeep(this.category, o.category, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.code, o.code, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.parameters, o.parameters, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.definingSubstance, o.definingSubstance, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.amount, o.amount, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.referenceRange, o.referenceRange, true) && SubstanceDefinitionPropertyComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionPropertyComponent)) {
                return false;
            }
            SubstanceDefinitionPropertyComponent o = (SubstanceDefinitionPropertyComponent)other_;
            return SubstanceDefinitionPropertyComponent.compareValues(this.parameters, o.parameters, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.code, this.parameters, this.definingSubstance, this.amount, this.referenceRange, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.property";
        }
    }

    @Block
    public static class SubstanceDefinitionMoietyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Role that the moiety is playing", formalDefinition="Role that the moiety is playing.")
        protected CodeableConcept role;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier by which this moiety substance is known", formalDefinition="Identifier by which this moiety substance is known.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual name for this moiety substance", formalDefinition="Textual name for this moiety substance.")
        protected StringType name;
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula for this moiety of this substance, typically using the Hill system", formalDefinition="Molecular formula for this moiety of this substance, typically using the Hill system.")
        protected StringType molecularFormula;
        @Child(name="amount", type={Quantity.class, StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this moiety", formalDefinition="Quantitative value for this moiety.")
        protected DataType amount;
        @Child(name="amountType", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The measurement type of the quantitative value", formalDefinition="The measurement type of the quantitative value.")
        protected CodeableConcept amountType;
        private static final long serialVersionUID = -1330905924L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceDefinitionMoietyComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceDefinitionMoietyComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public DataType getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setAmount(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceDefinition.moiety.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        public CodeableConcept getAmountType() {
            if (this.amountType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceDefinitionMoietyComponent.amountType");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountType = new CodeableConcept();
                }
            }
            return this.amountType;
        }

        public boolean hasAmountType() {
            return this.amountType != null && !this.amountType.isEmpty();
        }

        public SubstanceDefinitionMoietyComponent setAmountType(CodeableConcept value) {
            this.amountType = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role));
            children.add(new Property(SubstanceDefinition.SP_IDENTIFIER, "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier));
            children.add(new Property(SubstanceDefinition.SP_NAME, "string", "Textual name for this moiety substance.", 0, 1, this.name));
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula for this moiety of this substance, typically using the Hill system.", 0, 1, this.molecularFormula));
            children.add(new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount));
            children.add(new Property("amountType", "CodeableConcept", "The measurement type of the quantitative value.", 0, 1, this.amountType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property(SubstanceDefinition.SP_IDENTIFIER, "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property(SubstanceDefinition.SP_NAME, "string", "Textual name for this moiety substance.", 0, 1, this.name);
                }
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula for this moiety of this substance, typically using the Hill system.", 0, 1, this.molecularFormula);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case -1424857166: {
                    return new Property("amountType", "CodeableConcept", "The measurement type of the quantitative value.", 0, 1, this.amountType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1424857166: {
                    Base[] baseArray;
                    if (this.amountType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.amountType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 263475116: {
                    this.stereochemistry = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = TypeConvertor.castToString(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToType(value);
                    return value;
                }
                case -1424857166: {
                    this.amountType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(SubstanceDefinition.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals(SubstanceDefinition.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("stereochemistry")) {
                this.stereochemistry = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = TypeConvertor.castToString(value);
            } else if (name.equals("amount[x]")) {
                this.amount = TypeConvertor.castToType(value);
            } else if (name.equals("amountType")) {
                this.amountType = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1424857166: {
                    return this.getAmountType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "string"};
                }
                case -1424857166: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals(SubstanceDefinition.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(SubstanceDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.moiety.name");
            }
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceDefinition.moiety.molecularFormula");
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            if (name.equals("amountType")) {
                this.amountType = new CodeableConcept();
                return this.amountType;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceDefinitionMoietyComponent copy() {
            SubstanceDefinitionMoietyComponent dst = new SubstanceDefinitionMoietyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceDefinitionMoietyComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.amountType = this.amountType == null ? null : this.amountType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionMoietyComponent)) {
                return false;
            }
            SubstanceDefinitionMoietyComponent o = (SubstanceDefinitionMoietyComponent)other_;
            return SubstanceDefinitionMoietyComponent.compareDeep(this.role, o.role, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.name, o.name, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.amount, o.amount, true) && SubstanceDefinitionMoietyComponent.compareDeep(this.amountType, o.amountType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceDefinitionMoietyComponent)) {
                return false;
            }
            SubstanceDefinitionMoietyComponent o = (SubstanceDefinitionMoietyComponent)other_;
            return SubstanceDefinitionMoietyComponent.compareValues(this.name, o.name, true) && SubstanceDefinitionMoietyComponent.compareValues(this.molecularFormula, o.molecularFormula, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount, this.amountType});
        }

        @Override
        public String fhirType() {
            return "SubstanceDefinition.moiety";
        }
    }
}

