/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class MappingSheetParser {
    private List<MappingRow> rows = new ArrayList<MappingRow>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private static final String PFX = "<html><link rel=\"stylesheet\" href=\"file:c:\\work\\org.hl7.fhir\\build\\publish\\fhir.css\"/></head><body>\r\n";
    private static final String SFX = "<body></html>";

    public void parse(InputStream stream, String name) throws FHIRException, IOException {
        CSVReader csv = new CSVReader(stream);
        this.checkHeaders1(csv, name);
        this.checkHeaders2(csv, name);
        while (csv.line()) {
            this.processRow(csv);
        }
    }

    private void checkHeaders1(CSVReader csv, String name) throws FHIRException, IOException {
        csv.readHeaders();
        csv.checkColumn(1, "HL7 v2", "Mapping Sheet " + name);
        csv.checkColumn(6, "Condition (IF True)", "Mapping Sheet " + name);
        csv.checkColumn(7, "HL7 FHIR", "Mapping Sheet " + name);
        csv.checkColumn(14, "Comments", "Mapping Sheet " + name);
        csv.checkColumn(16, "Name", "Mapping Sheet " + name);
        csv.checkColumn(17, "Value", "Mapping Sheet " + name);
    }

    private void checkHeaders2(CSVReader csv, String name) throws FHIRException, IOException {
        csv.readHeaders();
        csv.checkColumn(1, "Display Sequence", "Mapping Sheet " + name);
        csv.checkColumn(2, "Identifier", "Mapping Sheet " + name);
        csv.checkColumn(3, "Name", "Mapping Sheet " + name);
        csv.checkColumn(4, "Data Type", "Mapping Sheet " + name);
        csv.checkColumn(5, "Cardinality", "Mapping Sheet " + name);
        csv.checkColumn(7, "FHIR Attribute", "Mapping Sheet " + name);
        csv.checkColumn(8, "Data Type", "Mapping Sheet " + name);
        csv.checkColumn(9, "Cardinality", "Mapping Sheet " + name);
        csv.checkColumn(10, "Data Type Mapping", "Mapping Sheet " + name);
        csv.checkColumn(11, "Vocabulary Mapping\n(IS, ID, CE, CNE, CWE)", "Mapping Sheet " + name);
        csv.checkColumn(12, "Derived Mapping", "Mapping Sheet " + name);
    }

    private void processRow(CSVReader csv) {
        MappingRow mr = new MappingRow();
        mr.sequence = csv.value(1);
        mr.identifier = csv.value(2);
        mr.name = csv.value(3);
        mr.dataType = csv.value(4);
        mr.cardinality = csv.value(5);
        mr.condition = csv.value(6);
        mr.attribute = csv.value(7);
        mr.type = csv.value(8);
        mr.minMax = csv.value(9);
        mr.dtMapping = csv.value(10);
        mr.vocabMapping = csv.value(11);
        mr.derived = csv.value(12);
        if (!Utilities.noString((String)mr.derived)) {
            String[] s = mr.derived.split("\\=");
            mr.derived = s[0].trim();
            mr.derivedMapping = s[1].trim();
        }
        mr.comments = csv.value(14);
        this.rows.add(mr);
        if (!Utilities.noString((String)csv.value(16))) {
            this.metadata.put(csv.value(16), csv.value(17));
        }
    }

    public List<MappingRow> getRows() {
        return this.rows;
    }

    public ConceptMap getConceptMap() throws FHIRException {
        ConceptMap map = new ConceptMap();
        this.loadMetadata(map);
        if (this.metadata.containsKey("copyright")) {
            map.setCopyright(this.metadata.get("copyright"));
        }
        for (MappingRow row : this.rows) {
            ConceptMap.SourceElementComponent element = map.getGroupFirstRep().addElement();
            element.setCode(row.getIdentifier());
            element.setId(row.getSequence());
            element.setDisplay(row.getName() + " : " + row.getDataType() + " [" + row.getCardinality() + "]");
            element.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-name", new StringType(row.getName()));
            element.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-type", new StringType(row.getDataType()));
            element.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-cardinality", new StringType(row.getCardinality()));
            if ("N/A".equals(row.getAttribute())) {
                element.setNoMap(true);
                continue;
            }
            element.getTargetFirstRep().setRelationship(Enumerations.ConceptMapRelationship.RELATEDTO);
            if (row.getCondition() != null) {
                element.getTargetFirstRep().addDependsOn().setProperty("http://hl7.org/fhirpath").setValue(this.processCondition(row.getCondition()));
            }
            element.getTargetFirstRep().setCode(row.getAttribute());
            element.getTargetFirstRep().setDisplay(row.getType() + " : [" + row.getMinMax() + "]");
            element.getTargetFirstRep().addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-type", new StringType(row.getType()));
            element.getTargetFirstRep().addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-cardinality", new StringType(row.getMinMax()));
            if (row.getDerived() != null) {
                element.getTargetFirstRep().getProductFirstRep().setProperty(row.getDerived()).setValue(row.getDerivedMapping());
            }
            if (row.getComments() != null) {
                element.getTargetFirstRep().setComment(row.getComments());
            }
            if (row.getDtMapping() != null) {
                element.getTargetFirstRep().addExtension("http://hl7.org/fhir/StructureDefinition/ConceptMap-type-mapping", new UrlType("todo#" + row.getDtMapping()));
            }
            if (row.getVocabMapping() == null) continue;
            element.getTargetFirstRep().addExtension("http://hl7.org/fhir/StructureDefinition/ConceptMap-vocab-mapping", new UrlType("todo#" + row.getVocabMapping()));
        }
        return map;
    }

    private String processCondition(String condition) {
        if (condition.startsWith("IF ") && condition.endsWith(" IS VALUED")) {
            return "`" + condition.substring(4, condition.length() - 10) + "`.exists()";
        }
        if (condition.startsWith("IF ") && condition.endsWith(" DOES NOT EXIST")) {
            return "`" + condition.substring(4, condition.length() - 15) + "`.exists()";
        }
        throw new Error("not processed yet: " + condition);
    }

    private void loadMetadata(CanonicalResource mr) throws FHIRException {
        if (this.metadata.containsKey("id")) {
            mr.setId(this.metadata.get("id"));
        }
        if (this.metadata.containsKey("url")) {
            mr.setUrl(this.metadata.get("url"));
        }
        if (this.metadata.containsKey("name")) {
            mr.setName(this.metadata.get("name"));
        }
        if (this.metadata.containsKey("title")) {
            mr.setTitle(this.metadata.get("title"));
        }
        if (this.metadata.containsKey("version")) {
            mr.setVersion(this.metadata.get("version"));
        }
        if (this.metadata.containsKey("status")) {
            mr.setStatus(Enumerations.PublicationStatus.fromCode(this.metadata.get("status")));
        }
        if (this.metadata.containsKey("date")) {
            mr.setDateElement(new DateTimeType(this.metadata.get("date")));
        }
        if (this.metadata.containsKey("publisher")) {
            mr.setPublisher(this.metadata.get("publisher"));
        }
        if (this.metadata.containsKey("description")) {
            mr.setDescription(this.metadata.get("description"));
        }
    }

    public StructureMap getStructureMap() throws FHIRException {
        StructureMap map = new StructureMap();
        this.loadMetadata(map);
        if (this.metadata.containsKey("copyright")) {
            map.setCopyright(this.metadata.get("copyright"));
        }
        StructureMap.StructureMapGroupComponent grp = map.addGroup();
        for (MappingRow row : this.rows) {
            StructureMap.StructureMapGroupRuleComponent rule = grp.addRule();
            rule.setName(row.getSequence());
            StructureMap.StructureMapGroupRuleSourceComponent src = rule.getSourceFirstRep();
            src.setContext("src");
            src.setElement(row.getIdentifier());
            src.setMin(row.getCardinalityMin());
            src.setMax(row.getCardinalityMax());
            src.setType(row.getDataType());
            src.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-name", new StringType(row.getName()));
            if (row.getCondition() != null) {
                src.setCheck(this.processCondition(row.getCondition()));
            }
            StructureMap.StructureMapGroupRuleTargetComponent tgt = rule.getTargetFirstRep();
            tgt.setContext("tgt");
            tgt.setContextType(StructureMap.StructureMapContextType.VARIABLE);
            tgt.setElement(row.getAttribute());
            tgt.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-type", new StringType(row.getType()));
            tgt.addExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-cardinality", new StringType(row.getMinMax()));
            if (row.getDtMapping() != null) {
                src.setVariable("s");
                tgt.setVariable("t");
                tgt.setTransform(StructureMap.StructureMapTransform.CREATE);
                StructureMap.StructureMapGroupRuleDependentComponent dep = rule.addDependent();
                dep.setName(row.getDtMapping());
                dep.addVariable("s");
                dep.addVariable("t");
            } else if (row.getVocabMapping() != null) {
                tgt.setTransform(StructureMap.StructureMapTransform.TRANSLATE);
                tgt.addParameter().setValue(new StringType(row.getVocabMapping()));
                tgt.addParameter().setValue(new IdType("src"));
            } else {
                tgt.setTransform(StructureMap.StructureMapTransform.COPY);
            }
            rule.setDocumentation(row.getComments());
            if (row.getDerived() == null) continue;
            tgt = rule.addTarget();
            tgt.setContext("tgt");
            tgt.setContextType(StructureMap.StructureMapContextType.VARIABLE);
            tgt.setElement(row.getDerived());
            tgt.setTransform(StructureMap.StructureMapTransform.COPY);
            tgt.addParameter().setValue(new StringType(row.getDerivedMapping()));
        }
        return map;
    }

    public boolean isSheet(ConceptMap cm) {
        if (cm.getGroup().size() != 1) {
            return false;
        }
        ConceptMap.ConceptMapGroupComponent grp = cm.getGroupFirstRep();
        for (ConceptMap.SourceElementComponent e : grp.getElement()) {
            if (e.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-type")) continue;
            return false;
        }
        return true;
    }

    public String genSheet(ConceptMap cm) throws FHIRException {
        StringBuilder b = new StringBuilder();
        this.readConceptMap(cm);
        b.append("<table class=\"grid\">\r\n");
        this.addHeaderRow1(b);
        this.addHeaderRow2(b);
        for (MappingRow row : this.rows) {
            this.addRow(b, row);
        }
        b.append("</table>\r\n");
        return b.toString();
    }

    private void addRow(StringBuilder b, MappingRow row) {
        b.append(" <tr>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.sequence)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.identifier)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.name)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.dataType)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.cardinality)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.condition)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.attribute)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.type)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.minMax)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.dtMapping)) + "</td>");
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.vocabMapping)) + "</td>");
        if (row.derived != null) {
            b.append("<td>" + Utilities.escapeXml((String)this.nn(row.derived + "=" + row.derivedMapping)) + "</td>");
        } else {
            b.append("<td></td>");
        }
        b.append("<td>" + Utilities.escapeXml((String)this.nn(row.comments)) + "</td>");
        b.append("</tr>\r\n");
    }

    private String nn(String s) {
        return s == null ? "" : s;
    }

    private void addHeaderRow1(StringBuilder b) {
        b.append(" <tr>");
        b.append("<td colspan=\"5\" style=\"background-color: lightgreen\"><b>v2</b></td>");
        b.append("<td colspan=\"1\"><b>Condition</b></td>");
        b.append("<td colspan=\"6\" style=\"background-color: orange\"><b>FHIR</b></td>");
        b.append("<td colspan=\"1\"><b>Comments</b></td>");
        b.append("</tr>\r\n");
    }

    private void addHeaderRow2(StringBuilder b) {
        b.append(" <tr>");
        b.append("<td style=\"background-color: lightgreen\"><b>Display Sequence</b></td>");
        b.append("<td style=\"background-color: lightgreen\"><b>Identifier</b></td>");
        b.append("<td style=\"background-color: lightgreen\"><b>Name</b></td>");
        b.append("<td style=\"background-color: lightgreen\"><b>Data Type</b></td>");
        b.append("<td style=\"background-color: lightgreen\"><b>Cardinality</b></td>");
        b.append("<td><b></b></td>");
        b.append("<td style=\"background-color: orange\"><b>FHIR Attribute</b></td>");
        b.append("<td style=\"background-color: orange\"><b>Data Type</b></td>");
        b.append("<td style=\"background-color: orange\"><b>Cardinality</b></td>");
        b.append("<td style=\"background-color: orange\"><b>Data Type Mapping</b></td>");
        b.append("<td style=\"background-color: orange\"><b>Vocabulary Mapping</b></td>");
        b.append("<td style=\"background-color: orange\"><b>Derived Mapping</b></td>");
        b.append("<td><b></b></td>");
        b.append("</tr>\r\n");
    }

    private void readConceptMap(ConceptMap cm) throws FHIRException {
        for (ConceptMap.ConceptMapGroupComponent g : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                if (!e.hasId() || e.getTarget().size() != 1 || !e.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-type")) continue;
                ConceptMap.TargetElementComponent t = e.getTargetFirstRep();
                MappingRow row = new MappingRow();
                row.sequence = e.getId();
                row.identifier = e.getCode();
                row.name = e.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-name");
                row.dataType = e.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-type");
                row.cardinality = e.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-cardinality");
                if (e.getNoMap()) {
                    row.attribute = "N/A";
                } else {
                    ConceptMap.OtherElementComponent dep = this.getDependency(t, "http://hl7.org/fhirpath");
                    if (dep != null) {
                        row.condition = dep.getValue();
                    }
                    row.attribute = t.getCode();
                    row.type = t.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-type");
                    row.minMax = t.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-cardinality");
                    row.dtMapping = t.getExtensionString("http://hl7.org/fhir/StructureDefinition/ConceptMap-type-mapping");
                    row.vocabMapping = t.getExtensionString("http://hl7.org/fhir/StructureDefinition/ConceptMap-vocab-mapping");
                    if (t.getProduct().size() > 0) {
                        row.derived = t.getProductFirstRep().getProperty();
                        row.derivedMapping = t.getProductFirstRep().getValue();
                    }
                }
                row.comments = t.getComment();
                this.rows.add(row);
            }
        }
    }

    private ConceptMap.OtherElementComponent getDependency(ConceptMap.TargetElementComponent t, String prop) {
        for (ConceptMap.OtherElementComponent dep : t.getDependsOn()) {
            if (!prop.equals(dep.getProperty())) continue;
            return dep;
        }
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, FHIRException {
        MappingSheetParser parser = new MappingSheetParser();
        parser.parse(new FileInputStream("c:\\temp\\v2-pid.csv"), "v2-pid.csv");
        ConceptMap cm = parser.getConceptMap();
        StructureMap sm = parser.getStructureMap();
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\sm.json"), sm);
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\cm.json"), cm);
        TextFile.stringToFile((String)StructureMapUtilities.render(sm), (String)"c:\\temp\\sm.txt");
        TextFile.stringToFile((String)(PFX + parser.genSheet(cm) + SFX), (String)"c:\\temp\\map.html");
    }

    public class MappingRow {
        private String sequence;
        private String identifier;
        private String name;
        private String dataType;
        private String cardinality;
        private String condition;
        private String attribute;
        private String type;
        private String minMax;
        private String dtMapping;
        private String vocabMapping;
        private String derived;
        private String derivedMapping;
        private String comments;

        public String getSequence() {
            return this.sequence;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public int getCardinalityMin() {
            return Integer.parseInt(this.cardinality.split("\\.")[0]);
        }

        public String getCardinalityMax() {
            return this.cardinality.split("\\.")[2];
        }

        public String getCondition() {
            return this.condition;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getType() {
            return this.type;
        }

        public String getMinMax() {
            return this.minMax;
        }

        public String getDtMapping() {
            return this.dtMapping;
        }

        public String getVocabMapping() {
            return this.vocabMapping;
        }

        public String getDerived() {
            return this.derived;
        }

        public String getDerivedMapping() {
            return this.derivedMapping;
        }

        public String getComments() {
            return this.comments;
        }
    }
}

