/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="QuestionnaireResponse", profile="http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse")
public class QuestionnaireResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for this set of answers", formalDefinition="A business identifier assigned to a particular completed (or partially completed) questionnaire.")
    protected Identifier identifier;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this QuestionnaireResponse", formalDefinition="The order, proposal or plan that is fulfilled in whole or in part by this QuestionnaireResponse.  For example, a ServiceRequest seeking an intake assessment or a decision support recommendation to assess for post-partum depression.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={Observation.class, Procedure.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of this action", formalDefinition="A procedure or observation that this questionnaire was performed as part of the execution of.  For example, the surgery a checklist was executed as part of.")
    protected List<Reference> partOf;
    @Child(name="questionnaire", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Form being answered", formalDefinition="The Questionnaire that defines and organizes the questions for which answers are being provided.")
    protected CanonicalType questionnaire;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | amended | entered-in-error | stopped", formalDefinition="The position of the questionnaire response within its overall lifecycle.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers-status")
    protected Enumeration<QuestionnaireResponseStatus> status;
    @Child(name="subject", type={Reference.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the questions", formalDefinition="The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter created as part of", formalDefinition="The Encounter during which this questionnaire response was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="authored", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date the answers were gathered", formalDefinition="The date and/or time that this set of answers were last changed.")
    protected DateTimeType authored;
    @Child(name="author", type={Device.class, Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person who received and recorded the answers", formalDefinition="Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.")
    protected Reference author;
    @Child(name="source", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who answered the questions", formalDefinition="The person who answered the questions about the subject.")
    protected Reference source;
    @Child(name="item", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Groups and questions", formalDefinition="A group or question item from the original questionnaire for which answers are provided.")
    protected List<QuestionnaireResponseItemComponent> item;
    private static final long serialVersionUID = 764655391L;
    @SearchParamDefinition(name="author", path="QuestionnaireResponse.author", description="The author of the questionnaire response", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("QuestionnaireResponse:author").toLocked();
    @SearchParamDefinition(name="authored", path="QuestionnaireResponse.authored", description="When the questionnaire response was last changed", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="based-on", path="QuestionnaireResponse.basedOn", description="Plan/proposal/order fulfilled by this questionnaire response", type="reference", target={CarePlan.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("QuestionnaireResponse:based-on").toLocked();
    @SearchParamDefinition(name="encounter", path="QuestionnaireResponse.encounter", description="Encounter associated with the questionnaire response", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("QuestionnaireResponse:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="QuestionnaireResponse.identifier", description="The unique identifier for the questionnaire response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="item-subject", path="QuestionnaireResponse.item.where(extension('http://hl7.org/fhir/StructureDefinition/questionnaireresponse-isSubject').exists()).answer.value.ofType(Reference)", description="Allows searching for QuestionnaireResponses by item value where the item has isSubject=true", type="reference")
    public static final String SP_ITEM_SUBJECT = "item-subject";
    public static final ReferenceClientParam ITEM_SUBJECT = new ReferenceClientParam("item-subject");
    public static final Include INCLUDE_ITEM_SUBJECT = new Include("QuestionnaireResponse:item-subject").toLocked();
    @SearchParamDefinition(name="part-of", path="QuestionnaireResponse.partOf", description="Procedure or observation this questionnaire response was performed as a part of", type="reference", target={Observation.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("QuestionnaireResponse:part-of").toLocked();
    @SearchParamDefinition(name="patient", path="QuestionnaireResponse.subject.where(resolve() is Patient)", description="The patient that is the subject of the questionnaire response", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("QuestionnaireResponse:patient").toLocked();
    @SearchParamDefinition(name="questionnaire", path="QuestionnaireResponse.questionnaire", description="The questionnaire the answers are provided for", type="reference", target={Questionnaire.class})
    public static final String SP_QUESTIONNAIRE = "questionnaire";
    public static final ReferenceClientParam QUESTIONNAIRE = new ReferenceClientParam("questionnaire");
    public static final Include INCLUDE_QUESTIONNAIRE = new Include("QuestionnaireResponse:questionnaire").toLocked();
    @SearchParamDefinition(name="source", path="QuestionnaireResponse.source", description="The individual providing the information reflected in the questionnaire respose", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("QuestionnaireResponse:source").toLocked();
    @SearchParamDefinition(name="status", path="QuestionnaireResponse.status", description="The status of the questionnaire response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="QuestionnaireResponse.subject", description="The subject of the questionnaire response", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("QuestionnaireResponse:subject").toLocked();

    public QuestionnaireResponse() {
    }

    public QuestionnaireResponse(QuestionnaireResponseStatus status) {
        this.setStatus(status);
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public QuestionnaireResponse setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public QuestionnaireResponse setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public QuestionnaireResponse addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public QuestionnaireResponse setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public QuestionnaireResponse addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public CanonicalType getQuestionnaireElement() {
        if (this.questionnaire == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.questionnaire");
            }
            if (Configuration.doAutoCreate()) {
                this.questionnaire = new CanonicalType();
            }
        }
        return this.questionnaire;
    }

    public boolean hasQuestionnaireElement() {
        return this.questionnaire != null && !this.questionnaire.isEmpty();
    }

    public boolean hasQuestionnaire() {
        return this.questionnaire != null && !this.questionnaire.isEmpty();
    }

    public QuestionnaireResponse setQuestionnaireElement(CanonicalType value) {
        this.questionnaire = value;
        return this;
    }

    public String getQuestionnaire() {
        return this.questionnaire == null ? null : (String)this.questionnaire.getValue();
    }

    public QuestionnaireResponse setQuestionnaire(String value) {
        if (Utilities.noString((String)value)) {
            this.questionnaire = null;
        } else {
            if (this.questionnaire == null) {
                this.questionnaire = new CanonicalType();
            }
            this.questionnaire.setValue(value);
        }
        return this;
    }

    public Enumeration<QuestionnaireResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public QuestionnaireResponse setStatusElement(Enumeration<QuestionnaireResponseStatus> value) {
        this.status = value;
        return this;
    }

    public QuestionnaireResponseStatus getStatus() {
        return this.status == null ? null : (QuestionnaireResponseStatus)((Object)this.status.getValue());
    }

    public QuestionnaireResponse setStatus(QuestionnaireResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public QuestionnaireResponse setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public QuestionnaireResponse setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getAuthoredElement() {
        if (this.authored == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.authored");
            }
            if (Configuration.doAutoCreate()) {
                this.authored = new DateTimeType();
            }
        }
        return this.authored;
    }

    public boolean hasAuthoredElement() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public boolean hasAuthored() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public QuestionnaireResponse setAuthoredElement(DateTimeType value) {
        this.authored = value;
        return this;
    }

    public Date getAuthored() {
        return this.authored == null ? null : (Date)this.authored.getValue();
    }

    public QuestionnaireResponse setAuthored(Date value) {
        if (value == null) {
            this.authored = null;
        } else {
            if (this.authored == null) {
                this.authored = new DateTimeType();
            }
            this.authored.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public QuestionnaireResponse setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public QuestionnaireResponse setSource(Reference value) {
        this.source = value;
        return this;
    }

    public List<QuestionnaireResponseItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        return this.item;
    }

    public QuestionnaireResponse setItem(List<QuestionnaireResponseItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (QuestionnaireResponseItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public QuestionnaireResponseItemComponent addItem() {
        QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public QuestionnaireResponse addItem(QuestionnaireResponseItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public QuestionnaireResponseItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A business identifier assigned to a particular completed (or partially completed) questionnaire.", 0, 1, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest)", "The order, proposal or plan that is fulfilled in whole or in part by this QuestionnaireResponse.  For example, a ServiceRequest seeking an intake assessment or a decision support recommendation to assess for post-partum depression.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Observation|Procedure)", "A procedure or observation that this questionnaire was performed as part of the execution of.  For example, the surgery a checklist was executed as part of.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_QUESTIONNAIRE, "canonical(Questionnaire)", "The Questionnaire that defines and organizes the questions for which answers are being provided.", 0, 1, this.questionnaire));
        children.add(new Property(SP_STATUS, "code", "The position of the questionnaire response within its overall lifecycle.", 0, 1, this.status));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this questionnaire response was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property(SP_AUTHORED, "dateTime", "The date and/or time that this set of answers were last changed.", 0, 1, this.authored));
        children.add(new Property(SP_AUTHOR, "Reference(Device|Practitioner|PractitionerRole|Patient|RelatedPerson|Organization)", "Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.", 0, 1, this.author));
        children.add(new Property(SP_SOURCE, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson)", "The person who answered the questions about the subject.", 0, 1, this.source));
        children.add(new Property("item", "", "A group or question item from the original questionnaire for which answers are provided.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A business identifier assigned to a particular completed (or partially completed) questionnaire.", 0, 1, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest)", "The order, proposal or plan that is fulfilled in whole or in part by this QuestionnaireResponse.  For example, a ServiceRequest seeking an intake assessment or a decision support recommendation to assess for post-partum depression.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Observation|Procedure)", "A procedure or observation that this questionnaire was performed as part of the execution of.  For example, the surgery a checklist was executed as part of.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -1017049693: {
                return new Property(SP_QUESTIONNAIRE, "canonical(Questionnaire)", "The Questionnaire that defines and organizes the questions for which answers are being provided.", 0, 1, this.questionnaire);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The position of the questionnaire response within its overall lifecycle.", 0, 1, this.status);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this questionnaire response was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case 1433073514: {
                return new Property(SP_AUTHORED, "dateTime", "The date and/or time that this set of answers were last changed.", 0, 1, this.authored);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Device|Practitioner|PractitionerRole|Patient|RelatedPerson|Organization)", "Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.", 0, 1, this.author);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson)", "The person who answered the questions about the subject.", 0, 1, this.source);
            }
            case 3242771: {
                return new Property("item", "", "A group or question item from the original questionnaire for which answers are provided.", 0, Integer.MAX_VALUE, this.item);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -1017049693: {
                Base[] baseArray;
                if (this.questionnaire == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.questionnaire;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case 1433073514: {
                Base[] baseArray;
                if (this.authored == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.authored;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.author;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.source;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1017049693: {
                this.questionnaire = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -892481550: {
                value = new QuestionnaireResponseStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 1433073514: {
                this.authored = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToReference(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((QuestionnaireResponseItemComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_QUESTIONNAIRE)) {
            this.questionnaire = TypeConvertor.castToCanonical(value);
        } else if (name.equals(SP_STATUS)) {
            value = new QuestionnaireResponseStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_AUTHORED)) {
            this.authored = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = TypeConvertor.castToReference(value);
        } else if (name.equals("item")) {
            this.getItem().add((QuestionnaireResponseItemComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -1017049693: {
                return this.getQuestionnaireElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1433073514: {
                return this.getAuthoredElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -896505829: {
                return this.getSource();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -1017049693: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1433073514: {
                return new String[]{"dateTime"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case 3242771: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_QUESTIONNAIRE)) {
            throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.questionnaire");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_AUTHORED)) {
            throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.authored");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "QuestionnaireResponse";
    }

    @Override
    public QuestionnaireResponse copy() {
        QuestionnaireResponse dst = new QuestionnaireResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(QuestionnaireResponse dst) {
        super.copyValues(dst);
        Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.questionnaire = this.questionnaire == null ? null : this.questionnaire.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.authored = this.authored == null ? null : this.authored.copy();
        dst.author = this.author == null ? null : this.author.copy();
        Reference reference = dst.source = this.source == null ? null : this.source.copy();
        if (this.item != null) {
            dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
            for (QuestionnaireResponseItemComponent questionnaireResponseItemComponent : this.item) {
                dst.item.add(questionnaireResponseItemComponent.copy());
            }
        }
    }

    protected QuestionnaireResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other_;
        return QuestionnaireResponse.compareDeep(this.identifier, o.identifier, true) && QuestionnaireResponse.compareDeep(this.basedOn, o.basedOn, true) && QuestionnaireResponse.compareDeep(this.partOf, o.partOf, true) && QuestionnaireResponse.compareDeep(this.questionnaire, o.questionnaire, true) && QuestionnaireResponse.compareDeep(this.status, o.status, true) && QuestionnaireResponse.compareDeep(this.subject, o.subject, true) && QuestionnaireResponse.compareDeep(this.encounter, o.encounter, true) && QuestionnaireResponse.compareDeep(this.authored, o.authored, true) && QuestionnaireResponse.compareDeep(this.author, o.author, true) && QuestionnaireResponse.compareDeep(this.source, o.source, true) && QuestionnaireResponse.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other_;
        return QuestionnaireResponse.compareValues(this.questionnaire, o.questionnaire, true) && QuestionnaireResponse.compareValues(this.status, o.status, true) && QuestionnaireResponse.compareValues(this.authored, o.authored, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.questionnaire, this.status, this.subject, this.encounter, this.authored, this.author, this.source, this.item});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.QuestionnaireResponse;
    }

    @Block
    public static class QuestionnaireResponseItemAnswerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class, Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Single-valued answer to the question", formalDefinition="The answer (or one of the answers) provided by the respondent to the question.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
        protected DataType value;
        @Child(name="item", type={QuestionnaireResponseItemComponent.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Child items of question", formalDefinition="Nested groups and/or questions found within this particular answer.")
        protected List<QuestionnaireResponseItemComponent> item;
        private static final long serialVersionUID = 1790747618L;

        public DataType getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionnaireResponseItemAnswerComponent setValue(DataType value) {
            if (!(value == null || value instanceof BooleanType || value instanceof DecimalType || value instanceof IntegerType || value instanceof DateType || value instanceof DateTimeType || value instanceof TimeType || value instanceof StringType || value instanceof UriType || value instanceof Attachment || value instanceof Coding || value instanceof Quantity || value instanceof Reference)) {
                throw new Error("Not the right type for QuestionnaireResponse.item.answer.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public List<QuestionnaireResponseItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            return this.item;
        }

        public QuestionnaireResponseItemAnswerComponent setItem(List<QuestionnaireResponseItemComponent> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireResponseItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemComponent addItem() {
            QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireResponseItemAnswerComponent addItem(QuestionnaireResponseItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        public QuestionnaireResponseItemComponent getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value));
            children.add(new Property("item", "@QuestionnaireResponse.item", "Nested groups and/or questions found within this particular answer.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|decimal|integer|date|dateTime|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, 1, this.value);
                }
                case 3242771: {
                    return new Property("item", "@QuestionnaireResponse.item", "Nested groups and/or questions found within this particular answer.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireResponseItemComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireResponseItemComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"boolean", "decimal", "integer", "date", "dateTime", "time", "string", "uri", "Attachment", "Coding", "Quantity", "Reference"};
                }
                case 3242771: {
                    return new String[]{"@QuestionnaireResponse.item"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireResponseItemAnswerComponent copy() {
            QuestionnaireResponseItemAnswerComponent dst = new QuestionnaireResponseItemAnswerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireResponseItemAnswerComponent dst) {
            super.copyValues(dst);
            DataType dataType = dst.value = this.value == null ? null : this.value.copy();
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
                for (QuestionnaireResponseItemComponent i : this.item) {
                    dst.item.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireResponseItemAnswerComponent)) {
                return false;
            }
            QuestionnaireResponseItemAnswerComponent o = (QuestionnaireResponseItemAnswerComponent)other_;
            return QuestionnaireResponseItemAnswerComponent.compareDeep(this.value, o.value, true) && QuestionnaireResponseItemAnswerComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireResponseItemAnswerComponent)) {
                return false;
            }
            QuestionnaireResponseItemAnswerComponent o = (QuestionnaireResponseItemAnswerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.value, this.item});
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.item.answer";
        }
    }

    @Block
    public static class QuestionnaireResponseItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to specific item from Questionnaire", formalDefinition="The item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="definition", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ElementDefinition - details for the item", formalDefinition="A reference to an [ElementDefinition](elementdefinition.html) that provides the details for the item.")
        protected UriType definition;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name for group or question text", formalDefinition="Text that is displayed above the contents of the group or as the text of the question being answered.")
        protected StringType text;
        @Child(name="answer", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The response(s) to the question", formalDefinition="The respondent's answer(s) to the question.")
        protected List<QuestionnaireResponseItemAnswerComponent> answer;
        @Child(name="item", type={QuestionnaireResponseItemComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Child items of group item", formalDefinition="Sub-questions, sub-groups or display items nested beneath a group.")
        protected List<QuestionnaireResponseItemComponent> item;
        private static final long serialVersionUID = -1395483402L;

        public QuestionnaireResponseItemComponent() {
        }

        public QuestionnaireResponseItemComponent(String linkId) {
            this.setLinkId(linkId);
        }

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionnaireResponseItemComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionnaireResponseItemComponent setLinkId(String value) {
            if (this.linkId == null) {
                this.linkId = new StringType();
            }
            this.linkId.setValue(value);
            return this;
        }

        public UriType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new UriType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public QuestionnaireResponseItemComponent setDefinitionElement(UriType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public QuestionnaireResponseItemComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new UriType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireResponseItemComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionnaireResponseItemComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionnaireResponseItemComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<QuestionnaireResponseItemAnswerComponent> getAnswer() {
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            return this.answer;
        }

        public QuestionnaireResponseItemComponent setAnswer(List<QuestionnaireResponseItemAnswerComponent> theAnswer) {
            this.answer = theAnswer;
            return this;
        }

        public boolean hasAnswer() {
            if (this.answer == null) {
                return false;
            }
            for (QuestionnaireResponseItemAnswerComponent item : this.answer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemAnswerComponent addAnswer() {
            QuestionnaireResponseItemAnswerComponent t = new QuestionnaireResponseItemAnswerComponent();
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            this.answer.add(t);
            return t;
        }

        public QuestionnaireResponseItemComponent addAnswer(QuestionnaireResponseItemAnswerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
            }
            this.answer.add(t);
            return this;
        }

        public QuestionnaireResponseItemAnswerComponent getAnswerFirstRep() {
            if (this.getAnswer().isEmpty()) {
                this.addAnswer();
            }
            return this.getAnswer().get(0);
        }

        public List<QuestionnaireResponseItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            return this.item;
        }

        public QuestionnaireResponseItemComponent setItem(List<QuestionnaireResponseItemComponent> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireResponseItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireResponseItemComponent addItem() {
            QuestionnaireResponseItemComponent t = new QuestionnaireResponseItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireResponseItemComponent addItem(QuestionnaireResponseItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireResponseItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        public QuestionnaireResponseItemComponent getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "string", "The item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.", 0, 1, this.linkId));
            children.add(new Property("definition", "uri", "A reference to an [ElementDefinition](elementdefinition.html) that provides the details for the item.", 0, 1, this.definition));
            children.add(new Property("text", "string", "Text that is displayed above the contents of the group or as the text of the question being answered.", 0, 1, this.text));
            children.add(new Property("answer", "", "The respondent's answer(s) to the question.", 0, Integer.MAX_VALUE, this.answer));
            children.add(new Property("item", "@QuestionnaireResponse.item", "Sub-questions, sub-groups or display items nested beneath a group.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "string", "The item from the Questionnaire that corresponds to this item in the QuestionnaireResponse resource.", 0, 1, this.linkId);
                }
                case -1014418093: {
                    return new Property("definition", "uri", "A reference to an [ElementDefinition](elementdefinition.html) that provides the details for the item.", 0, 1, this.definition);
                }
                case 3556653: {
                    return new Property("text", "string", "Text that is displayed above the contents of the group or as the text of the question being answered.", 0, 1, this.text);
                }
                case -1412808770: {
                    return new Property("answer", "", "The respondent's answer(s) to the question.", 0, Integer.MAX_VALUE, this.answer);
                }
                case 3242771: {
                    return new Property("item", "@QuestionnaireResponse.item", "Sub-questions, sub-groups or display items nested beneath a group.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case -1412808770: {
                    return this.answer == null ? new Base[]{} : this.answer.toArray(new Base[this.answer.size()]);
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToUri(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
                case -1412808770: {
                    this.getAnswer().add((QuestionnaireResponseItemAnswerComponent)value);
                    return value;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireResponseItemComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = TypeConvertor.castToUri(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else if (name.equals("answer")) {
                this.getAnswer().add((QuestionnaireResponseItemAnswerComponent)value);
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireResponseItemComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1412808770: {
                    return this.addAnswer();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"uri"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1412808770: {
                    return new String[0];
                }
                case 3242771: {
                    return new String[]{"@QuestionnaireResponse.item"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.item.linkId");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.item.definition");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type QuestionnaireResponse.item.text");
            }
            if (name.equals("answer")) {
                return this.addAnswer();
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireResponseItemComponent copy() {
            QuestionnaireResponseItemComponent dst = new QuestionnaireResponseItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(QuestionnaireResponseItemComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.answer != null) {
                dst.answer = new ArrayList<QuestionnaireResponseItemAnswerComponent>();
                for (QuestionnaireResponseItemAnswerComponent questionnaireResponseItemAnswerComponent : this.answer) {
                    dst.answer.add(questionnaireResponseItemAnswerComponent.copy());
                }
            }
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireResponseItemComponent>();
                for (QuestionnaireResponseItemComponent questionnaireResponseItemComponent : this.item) {
                    dst.item.add(questionnaireResponseItemComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireResponseItemComponent)) {
                return false;
            }
            QuestionnaireResponseItemComponent o = (QuestionnaireResponseItemComponent)other_;
            return QuestionnaireResponseItemComponent.compareDeep(this.linkId, o.linkId, true) && QuestionnaireResponseItemComponent.compareDeep(this.definition, o.definition, true) && QuestionnaireResponseItemComponent.compareDeep(this.text, o.text, true) && QuestionnaireResponseItemComponent.compareDeep(this.answer, o.answer, true) && QuestionnaireResponseItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof QuestionnaireResponseItemComponent)) {
                return false;
            }
            QuestionnaireResponseItemComponent o = (QuestionnaireResponseItemComponent)other_;
            return QuestionnaireResponseItemComponent.compareValues(this.linkId, o.linkId, true) && QuestionnaireResponseItemComponent.compareValues(this.definition, o.definition, true) && QuestionnaireResponseItemComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.linkId, this.definition, this.text, this.answer, this.item});
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.item";
        }
    }

    public static class QuestionnaireResponseStatusEnumFactory
    implements EnumFactory<QuestionnaireResponseStatus> {
        @Override
        public QuestionnaireResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return QuestionnaireResponseStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return QuestionnaireResponseStatus.COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return QuestionnaireResponseStatus.AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return QuestionnaireResponseStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return QuestionnaireResponseStatus.STOPPED;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<QuestionnaireResponseStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.COMPLETED);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.AMENDED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.STOPPED);
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireResponseStatus code) {
            if (code == QuestionnaireResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == QuestionnaireResponseStatus.COMPLETED) {
                return "completed";
            }
            if (code == QuestionnaireResponseStatus.AMENDED) {
                return "amended";
            }
            if (code == QuestionnaireResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == QuestionnaireResponseStatus.STOPPED) {
                return "stopped";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireResponseStatus {
        INPROGRESS,
        COMPLETED,
        AMENDED,
        ENTEREDINERROR,
        STOPPED,
        NULL;


        public static QuestionnaireResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case AMENDED: {
                    return "amended";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "This QuestionnaireResponse has been partially filled out with answers but changes or additions are still expected to be made to it.";
                }
                case COMPLETED: {
                    return "This QuestionnaireResponse has been filled out with answers and the current content is regarded as definitive.";
                }
                case AMENDED: {
                    return "This QuestionnaireResponse has been filled out with answers, then marked as complete, yet changes or additions have been made to it afterwards.";
                }
                case ENTEREDINERROR: {
                    return "This QuestionnaireResponse was entered in error and voided.";
                }
                case STOPPED: {
                    return "This QuestionnaireResponse has been partially filled out with answers but has been abandoned. No subsequent changes can be made.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case AMENDED: {
                    return "Amended";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
            }
            return "?";
        }
    }
}

