/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.EncounterRenderer;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class DirectWrappers {

    public static class ResourceWrapperDirect
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.ResourceWrapper {
        private Resource wrapped;

        public ResourceWrapperDirect(RenderingContext context, Resource wrapped) {
            super(context);
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public List<BaseWrappers.ResourceWrapper> getContained() {
            ArrayList<BaseWrappers.ResourceWrapper> list = new ArrayList<BaseWrappers.ResourceWrapper>();
            if (this.wrapped instanceof DomainResource) {
                DomainResource dr = (DomainResource)this.wrapped;
                for (Resource c : dr.getContained()) {
                    list.add(new ResourceWrapperDirect(this.context, c));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public XhtmlNode getNarrative() {
            DomainResource dr;
            if (this.wrapped instanceof DomainResource && (dr = (DomainResource)this.wrapped).hasText() && dr.getText().hasDiv()) {
                return dr.getText().getDiv();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.wrapped.getResourceType().toString();
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            ArrayList<BaseWrappers.PropertyWrapper> list = new ArrayList<BaseWrappers.PropertyWrapper>();
            if (this.wrapped.children() != null) {
                for (Property c : this.wrapped.children()) {
                    list.add(new PropertyWrapperDirect(this.context, c));
                }
            }
            return list;
        }

        @Override
        public void describe(XhtmlNode x) throws UnsupportedEncodingException, IOException {
            if (this.wrapped instanceof CanonicalResource) {
                x.tx(((CanonicalResource)this.wrapped).present());
            } else if (this.wrapped instanceof Patient) {
                new PatientRenderer(this.getContext()).describe(x, (Patient)this.wrapped);
            } else if (this.wrapped instanceof Encounter) {
                new EncounterRenderer(this.getContext()).describe(x, (Encounter)this.wrapped);
            }
        }

        @Override
        public void injectNarrative(XhtmlNode x, Narrative.NarrativeStatus status) {
            ResourceRenderer.inject((DomainResource)this.wrapped, x, status);
        }

        @Override
        public BaseWrappers.BaseWrapper root() {
            return new BaseWrapperDirect(this.context, this.wrapped);
        }

        @Override
        public StructureDefinition getDefinition() {
            return this.context.getWorker().fetchTypeDefinition(this.wrapped.fhirType());
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public boolean hasNarrative() {
            StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(this.wrapped.fhirType());
            while (sd != null) {
                if ("DomainResource".equals(sd.getType())) {
                    return true;
                }
                sd = this.context.getWorker().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
            return false;
        }

        @Override
        public String fhirType() {
            return this.wrapped.fhirType();
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(this.context, p);
        }
    }

    public static class BaseWrapperDirect
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.BaseWrapper {
        private Base wrapped;
        private List<BaseWrappers.PropertyWrapper> list;

        public BaseWrapperDirect(RenderingContext context, Base wrapped) {
            super(context);
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (Property p : this.wrapped.children()) {
                    this.list.add(new PropertyWrapperDirect(this.context, p));
                }
            }
            return this.list;
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(this.context, p);
        }

        @Override
        public String fhirType() {
            return this.wrapped.fhirType();
        }
    }

    public static class PropertyWrapperDirect
    extends BaseWrappers.RendererWrapperImpl
    implements BaseWrappers.PropertyWrapper {
        private Property wrapped;
        private List<BaseWrappers.BaseWrapper> list;
        private ElementDefinition ed;

        public PropertyWrapperDirect(RenderingContext context, Property wrapped) {
            super(context);
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        public PropertyWrapperDirect(RenderingContext context, Property wrapped, ElementDefinition ed) {
            super(context);
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
            this.ed = ed;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        public Property getWrapped() {
            return this.wrapped;
        }

        @Override
        public boolean hasValues() {
            return this.wrapped.hasValues();
        }

        @Override
        public List<BaseWrappers.BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.BaseWrapper>();
                for (Base b : this.wrapped.getValues()) {
                    this.list.add(b == null ? null : new BaseWrapperDirect(this.context, b));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public String getDefinition() {
            return this.wrapped.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public int getMaxCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public StructureDefinition getStructure() {
            return this.wrapped.getStructure();
        }

        @Override
        public BaseWrappers.BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }

        public String toString() {
            return "#." + this.wrapped.toString();
        }

        @Override
        public BaseWrappers.ResourceWrapper getAsResource() {
            throw new Error("Not implemented yet");
        }

        @Override
        public String fhirType() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public ElementDefinition getElementDefinition() {
            return this.ed;
        }
    }
}

