/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Appointment", profile="http://hl7.org/fhir/StructureDefinition/Appointment")
public class Appointment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | pending | booked | arrived | fulfilled | cancelled | noshow | entered-in-error | checked-in | waitlist", formalDefinition="The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/appointmentstatus")
    protected Enumeration<AppointmentStatus> status;
    @Child(name="cancelationReason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The coded reason for the appointment being cancelled", formalDefinition="The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/appointment-cancellation-reason")
    protected CodeableConcept cancelationReason;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A broad categorization of the service that is to be performed during this appointment", formalDefinition="A broad categorization of the service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected List<CodeableConcept> serviceCategory;
    @Child(name="serviceType", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specific service that is to be performed during this appointment", formalDefinition="The specific service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableConcept> serviceType;
    @Child(name="specialty", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment", formalDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="appointmentType", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The style of appointment or patient that has been booked in the slot (not service type)", formalDefinition="The style of appointment or patient that has been booked in the slot (not service type).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0276")
    protected CodeableConcept appointmentType;
    @Child(name="reason", type={CodeableReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason this appointment is scheduled", formalDefinition="The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    protected List<CodeableReference> reason;
    @Child(name="priority", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used to make informed decisions if needing to re-prioritize", formalDefinition="The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActPriority")
    protected CodeableConcept priority;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Shown on a subject line in a meeting request, or appointment list", formalDefinition="The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.")
    protected StringType description;
    @Child(name="supportingInformation", type={Reference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to support the appointment", formalDefinition="Additional information to support the appointment provided when making the appointment.")
    protected List<Reference> supportingInformation;
    @Child(name="start", type={InstantType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to take place", formalDefinition="Date/Time that the appointment is to take place.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to conclude", formalDefinition="Date/Time that the appointment is to conclude.")
    protected InstantType end;
    @Child(name="minutesDuration", type={PositiveIntType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Can be less than start/end (e.g. estimate)", formalDefinition="Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.")
    protected PositiveIntType minutesDuration;
    @Child(name="slot", type={Slot.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The slots that this appointment is filling", formalDefinition="The slots from the participants' schedules that will be filled by the appointment.")
    protected List<Reference> slot;
    @Child(name="created", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The date that this appointment was initially created", formalDefinition="The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.")
    protected DateTimeType created;
    @Child(name="comment", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional comments about the appointment.")
    protected StringType comment;
    @Child(name="patientInstruction", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed information and instructions for the patient", formalDefinition="While Appointment.comment contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).")
    protected StringType patientInstruction;
    @Child(name="basedOn", type={ServiceRequest.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The service request this appointment is allocated to assess", formalDefinition="The service request this appointment is allocated to assess (e.g. incoming referral or procedure request).")
    protected List<Reference> basedOn;
    @Child(name="participant", type={}, order=19, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Participants involved in appointment", formalDefinition="List of participants involved in the appointment.")
    protected List<AppointmentParticipantComponent> participant;
    @Child(name="requestedPeriod", type={Period.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential date/time interval(s) requested to allocate the appointment within", formalDefinition="A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.")
    protected List<Period> requestedPeriod;
    private static final long serialVersionUID = -1194073126L;
    @SearchParamDefinition(name="actor", path="Appointment.participant.actor", description="Any one of the individuals participating in the appointment", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Appointment:actor").toLocked();
    @SearchParamDefinition(name="appointment-type", path="Appointment.appointmentType", description="The style of appointment or patient that has been booked in the slot (not service type)", type="token")
    public static final String SP_APPOINTMENT_TYPE = "appointment-type";
    public static final TokenClientParam APPOINTMENT_TYPE = new TokenClientParam("appointment-type");
    @SearchParamDefinition(name="based-on", path="Appointment.basedOn", description="The service request this appointment is allocated to assess", type="reference", target={ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Appointment:based-on").toLocked();
    @SearchParamDefinition(name="date", path="Appointment.start", description="Appointment date/time.", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Appointment.identifier", description="An Identifier of the Appointment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Appointment.participant.actor.where(resolve() is Location)", description="This location is listed in the participants of the appointment", type="reference", target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Appointment:location").toLocked();
    @SearchParamDefinition(name="part-status", path="Appointment.participant.status", description="The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests.", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="patient", path="Appointment.participant.actor.where(resolve() is Patient)", description="One of the individuals of the appointment is this patient", type="reference", target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Appointment:patient").toLocked();
    @SearchParamDefinition(name="practitioner", path="Appointment.participant.actor.where(resolve() is Practitioner)", description="One of the individuals of the appointment is this practitioner", type="reference", target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Appointment:practitioner").toLocked();
    @SearchParamDefinition(name="reason-code", path="Appointment.reason.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Appointment.reason.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Appointment:reason-reference").toLocked();
    @SearchParamDefinition(name="service-category", path="Appointment.serviceCategory", description="A broad categorization of the service that is to be performed during this appointment", type="token")
    public static final String SP_SERVICE_CATEGORY = "service-category";
    public static final TokenClientParam SERVICE_CATEGORY = new TokenClientParam("service-category");
    @SearchParamDefinition(name="service-type", path="Appointment.serviceType", description="The specific service that is to be performed during this appointment", type="token")
    public static final String SP_SERVICE_TYPE = "service-type";
    public static final TokenClientParam SERVICE_TYPE = new TokenClientParam("service-type");
    @SearchParamDefinition(name="slot", path="Appointment.slot", description="The slots that this appointment is filling", type="reference", target={Slot.class})
    public static final String SP_SLOT = "slot";
    public static final ReferenceClientParam SLOT = new ReferenceClientParam("slot");
    public static final Include INCLUDE_SLOT = new Include("Appointment:slot").toLocked();
    @SearchParamDefinition(name="specialty", path="Appointment.specialty", description="The specialty of a practitioner that would be required to perform the service requested in this appointment", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="status", path="Appointment.status", description="The overall status of the appointment", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="supporting-info", path="Appointment.supportingInformation", description="Additional information to support the appointment", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUPPORTING_INFO = "supporting-info";
    public static final ReferenceClientParam SUPPORTING_INFO = new ReferenceClientParam("supporting-info");
    public static final Include INCLUDE_SUPPORTING_INFO = new Include("Appointment:supporting-info").toLocked();

    public Appointment() {
    }

    public Appointment(AppointmentStatus status, AppointmentParticipantComponent participant) {
        this.setStatus(status);
        this.addParticipant(participant);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Appointment setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Appointment addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AppointmentStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Appointment setStatusElement(Enumeration<AppointmentStatus> value) {
        this.status = value;
        return this;
    }

    public AppointmentStatus getStatus() {
        return this.status == null ? null : (AppointmentStatus)((Object)this.status.getValue());
    }

    public Appointment setStatus(AppointmentStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCancelationReason() {
        if (this.cancelationReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.cancelationReason");
            }
            if (Configuration.doAutoCreate()) {
                this.cancelationReason = new CodeableConcept();
            }
        }
        return this.cancelationReason;
    }

    public boolean hasCancelationReason() {
        return this.cancelationReason != null && !this.cancelationReason.isEmpty();
    }

    public Appointment setCancelationReason(CodeableConcept value) {
        this.cancelationReason = value;
        return this;
    }

    public List<CodeableConcept> getServiceCategory() {
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        return this.serviceCategory;
    }

    public Appointment setServiceCategory(List<CodeableConcept> theServiceCategory) {
        this.serviceCategory = theServiceCategory;
        return this;
    }

    public boolean hasServiceCategory() {
        if (this.serviceCategory == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceCategory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return t;
    }

    public Appointment addServiceCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return this;
    }

    public CodeableConcept getServiceCategoryFirstRep() {
        if (this.getServiceCategory().isEmpty()) {
            this.addServiceCategory();
        }
        return this.getServiceCategory().get(0);
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public Appointment setServiceType(List<CodeableConcept> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceType() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Appointment addServiceType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableConcept getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public Appointment setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public Appointment addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public CodeableConcept getAppointmentType() {
        if (this.appointmentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.appointmentType");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentType = new CodeableConcept();
            }
        }
        return this.appointmentType;
    }

    public boolean hasAppointmentType() {
        return this.appointmentType != null && !this.appointmentType.isEmpty();
    }

    public Appointment setAppointmentType(CodeableConcept value) {
        this.appointmentType = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Appointment setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Appointment addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Appointment setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Appointment setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Appointment setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public Appointment setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public Appointment addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Appointment setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Appointment setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Appointment setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Appointment setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public PositiveIntType getMinutesDurationElement() {
        if (this.minutesDuration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.minutesDuration");
            }
            if (Configuration.doAutoCreate()) {
                this.minutesDuration = new PositiveIntType();
            }
        }
        return this.minutesDuration;
    }

    public boolean hasMinutesDurationElement() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public boolean hasMinutesDuration() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public Appointment setMinutesDurationElement(PositiveIntType value) {
        this.minutesDuration = value;
        return this;
    }

    public int getMinutesDuration() {
        return this.minutesDuration == null || this.minutesDuration.isEmpty() ? 0 : (Integer)this.minutesDuration.getValue();
    }

    public Appointment setMinutesDuration(int value) {
        if (this.minutesDuration == null) {
            this.minutesDuration = new PositiveIntType();
        }
        this.minutesDuration.setValue((Object)value);
        return this;
    }

    public List<Reference> getSlot() {
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        return this.slot;
    }

    public Appointment setSlot(List<Reference> theSlot) {
        this.slot = theSlot;
        return this;
    }

    public boolean hasSlot() {
        if (this.slot == null) {
            return false;
        }
        for (Reference item : this.slot) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSlot() {
        Reference t = new Reference();
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return t;
    }

    public Appointment addSlot(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return this;
    }

    public Reference getSlotFirstRep() {
        if (this.getSlot().isEmpty()) {
            this.addSlot();
        }
        return this.getSlot().get(0);
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Appointment setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Appointment setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Appointment setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Appointment setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public StringType getPatientInstructionElement() {
        if (this.patientInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.patientInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.patientInstruction = new StringType();
            }
        }
        return this.patientInstruction;
    }

    public boolean hasPatientInstructionElement() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public boolean hasPatientInstruction() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public Appointment setPatientInstructionElement(StringType value) {
        this.patientInstruction = value;
        return this;
    }

    public String getPatientInstruction() {
        return this.patientInstruction == null ? null : (String)this.patientInstruction.getValue();
    }

    public Appointment setPatientInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.patientInstruction = null;
        } else {
            if (this.patientInstruction == null) {
                this.patientInstruction = new StringType();
            }
            this.patientInstruction.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Appointment setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Appointment addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<AppointmentParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        return this.participant;
    }

    public Appointment setParticipant(List<AppointmentParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AppointmentParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AppointmentParticipantComponent addParticipant() {
        AppointmentParticipantComponent t = new AppointmentParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Appointment addParticipant(AppointmentParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public AppointmentParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<Period> getRequestedPeriod() {
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        return this.requestedPeriod;
    }

    public Appointment setRequestedPeriod(List<Period> theRequestedPeriod) {
        this.requestedPeriod = theRequestedPeriod;
        return this;
    }

    public boolean hasRequestedPeriod() {
        if (this.requestedPeriod == null) {
            return false;
        }
        for (Period item : this.requestedPeriod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Period addRequestedPeriod() {
        Period t = new Period();
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        this.requestedPeriod.add(t);
        return t;
    }

    public Appointment addRequestedPeriod(Period t) {
        if (t == null) {
            return this;
        }
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        this.requestedPeriod.add(t);
        return this;
    }

    public Period getRequestedPeriodFirstRep() {
        if (this.getRequestedPeriod().isEmpty()) {
            this.addRequestedPeriod();
        }
        return this.getRequestedPeriod().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.", 0, 1, this.status));
        children.add(new Property("cancelationReason", "CodeableConcept", "The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.", 0, 1, this.cancelationReason));
        children.add(new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory));
        children.add(new Property("serviceType", "CodeableConcept", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that has been booked in the slot (not service type).", 0, 1, this.appointmentType));
        children.add(new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("priority", "CodeableConcept", "The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).", 0, 1, this.priority));
        children.add(new Property("description", "string", "The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.", 0, 1, this.description));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information to support the appointment provided when making the appointment.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("start", "instant", "Date/Time that the appointment is to take place.", 0, 1, this.start));
        children.add(new Property("end", "instant", "Date/Time that the appointment is to conclude.", 0, 1, this.end));
        children.add(new Property("minutesDuration", "positiveInt", "Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.", 0, 1, this.minutesDuration));
        children.add(new Property(SP_SLOT, "Reference(Slot)", "The slots from the participants' schedules that will be filled by the appointment.", 0, Integer.MAX_VALUE, this.slot));
        children.add(new Property("created", "dateTime", "The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.", 0, 1, this.created));
        children.add(new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment));
        children.add(new Property("patientInstruction", "string", "While Appointment.comment contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).", 0, 1, this.patientInstruction));
        children.add(new Property("basedOn", "Reference(ServiceRequest)", "The service request this appointment is allocated to assess (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("participant", "", "List of participants involved in the appointment.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("requestedPeriod", "Period", "A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.", 0, Integer.MAX_VALUE, this.requestedPeriod));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.", 0, 1, this.status);
            }
            case 987811551: {
                return new Property("cancelationReason", "CodeableConcept", "The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.", 0, 1, this.cancelationReason);
            }
            case 1281188563: {
                return new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableConcept", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case -1596426375: {
                return new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that has been booked in the slot (not service type).", 0, 1, this.appointmentType);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, Integer.MAX_VALUE, this.reason);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).", 0, 1, this.priority);
            }
            case -1724546052: {
                return new Property("description", "string", "The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.", 0, 1, this.description);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information to support the appointment provided when making the appointment.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 109757538: {
                return new Property("start", "instant", "Date/Time that the appointment is to take place.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "instant", "Date/Time that the appointment is to conclude.", 0, 1, this.end);
            }
            case -413630573: {
                return new Property("minutesDuration", "positiveInt", "Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.", 0, 1, this.minutesDuration);
            }
            case 3533310: {
                return new Property(SP_SLOT, "Reference(Slot)", "The slots from the participants' schedules that will be filled by the appointment.", 0, Integer.MAX_VALUE, this.slot);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.", 0, 1, this.created);
            }
            case 950398559: {
                return new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment);
            }
            case 737543241: {
                return new Property("patientInstruction", "string", "While Appointment.comment contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).", 0, 1, this.patientInstruction);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest)", "The service request this appointment is allocated to assess (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case 767422259: {
                return new Property("participant", "", "List of participants involved in the appointment.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -897241393: {
                return new Property("requestedPeriod", "Period", "A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.", 0, Integer.MAX_VALUE, this.requestedPeriod);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 987811551: {
                Base[] baseArray;
                if (this.cancelationReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.cancelationReason;
                }
                return baseArray;
            }
            case 1281188563: {
                return this.serviceCategory == null ? new Base[]{} : this.serviceCategory.toArray(new Base[this.serviceCategory.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case -1596426375: {
                Base[] baseArray;
                if (this.appointmentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.appointmentType;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.end;
                }
                return baseArray;
            }
            case -413630573: {
                Base[] baseArray;
                if (this.minutesDuration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.minutesDuration;
                }
                return baseArray;
            }
            case 3533310: {
                return this.slot == null ? new Base[]{} : this.slot.toArray(new Base[this.slot.size()]);
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.created;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.comment;
                }
                return baseArray;
            }
            case 737543241: {
                Base[] baseArray;
                if (this.patientInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.patientInstruction;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -897241393: {
                return this.requestedPeriod == null ? new Base[]{} : this.requestedPeriod.toArray(new Base[this.requestedPeriod.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new AppointmentStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 987811551: {
                this.cancelationReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1281188563: {
                this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1596426375: {
                this.appointmentType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToInstant(value);
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case -413630573: {
                this.minutesDuration = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 3533310: {
                this.getSlot().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToString(value);
                return value;
            }
            case 737543241: {
                this.patientInstruction = TypeConvertor.castToString(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 767422259: {
                this.getParticipant().add((AppointmentParticipantComponent)((Object)value));
                return value;
            }
            case -897241393: {
                this.getRequestedPeriod().add(TypeConvertor.castToPeriod(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new AppointmentStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("cancelationReason")) {
            this.cancelationReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("serviceCategory")) {
            this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("appointmentType")) {
            this.appointmentType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("start")) {
            this.start = TypeConvertor.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("minutesDuration")) {
            this.minutesDuration = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals(SP_SLOT)) {
            this.getSlot().add(TypeConvertor.castToReference(value));
        } else if (name.equals("created")) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToString(value);
        } else if (name.equals("patientInstruction")) {
            this.patientInstruction = TypeConvertor.castToString(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("participant")) {
            this.getParticipant().add((AppointmentParticipantComponent)((Object)value));
        } else if (name.equals("requestedPeriod")) {
            this.getRequestedPeriod().add(TypeConvertor.castToPeriod(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 987811551: {
                return this.getCancelationReason();
            }
            case 1281188563: {
                return this.addServiceCategory();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case -1596426375: {
                return this.getAppointmentType();
            }
            case -934964668: {
                return this.addReason();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
            case -413630573: {
                return this.getMinutesDurationElement();
            }
            case 3533310: {
                return this.addSlot();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case 737543241: {
                return this.getPatientInstructionElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -897241393: {
                return this.addRequestedPeriod();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 987811551: {
                return new String[]{"CodeableConcept"};
            }
            case 1281188563: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case -1596426375: {
                return new String[]{"CodeableConcept"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case 109757538: {
                return new String[]{"instant"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case -413630573: {
                return new String[]{"positiveInt"};
            }
            case 3533310: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case 737543241: {
                return new String[]{"string"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -897241393: {
                return new String[]{"Period"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.status");
        }
        if (name.equals("cancelationReason")) {
            this.cancelationReason = new CodeableConcept();
            return this.cancelationReason;
        }
        if (name.equals("serviceCategory")) {
            return this.addServiceCategory();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals("appointmentType")) {
            this.appointmentType = new CodeableConcept();
            return this.appointmentType;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.description");
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.end");
        }
        if (name.equals("minutesDuration")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.minutesDuration");
        }
        if (name.equals(SP_SLOT)) {
            return this.addSlot();
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.created");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.comment");
        }
        if (name.equals("patientInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.patientInstruction");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("requestedPeriod")) {
            return this.addRequestedPeriod();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Appointment";
    }

    @Override
    public Appointment copy() {
        Appointment dst = new Appointment();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Appointment dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.cancelationReason = this.cancelationReason == null ? null : this.cancelationReason.copy();
        if (this.serviceCategory != null) {
            dst.serviceCategory = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.serviceCategory) {
                dst.serviceCategory.add(codeableConcept2.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.serviceType) {
                dst.serviceType.add(codeableConcept3.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.specialty) {
                dst.specialty.add(codeableConcept4.copy());
            }
        }
        CodeableConcept codeableConcept5 = dst.appointmentType = this.appointmentType == null ? null : this.appointmentType.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        PositiveIntType positiveIntType = dst.minutesDuration = this.minutesDuration == null ? null : this.minutesDuration.copy();
        if (this.slot != null) {
            dst.slot = new ArrayList<Reference>();
            for (Reference reference : this.slot) {
                dst.slot.add(reference.copy());
            }
        }
        dst.created = this.created == null ? null : this.created.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        StringType stringType2 = dst.patientInstruction = this.patientInstruction == null ? null : this.patientInstruction.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.participant != null) {
            dst.participant = new ArrayList<AppointmentParticipantComponent>();
            for (AppointmentParticipantComponent appointmentParticipantComponent : this.participant) {
                dst.participant.add(appointmentParticipantComponent.copy());
            }
        }
        if (this.requestedPeriod != null) {
            dst.requestedPeriod = new ArrayList<Period>();
            for (Period period : this.requestedPeriod) {
                dst.requestedPeriod.add(period.copy());
            }
        }
    }

    protected Appointment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other_;
        return Appointment.compareDeep(this.identifier, o.identifier, true) && Appointment.compareDeep(this.status, o.status, true) && Appointment.compareDeep(this.cancelationReason, o.cancelationReason, true) && Appointment.compareDeep(this.serviceCategory, o.serviceCategory, true) && Appointment.compareDeep(this.serviceType, o.serviceType, true) && Appointment.compareDeep(this.specialty, o.specialty, true) && Appointment.compareDeep(this.appointmentType, o.appointmentType, true) && Appointment.compareDeep(this.reason, o.reason, true) && Appointment.compareDeep(this.priority, o.priority, true) && Appointment.compareDeep(this.description, o.description, true) && Appointment.compareDeep(this.supportingInformation, o.supportingInformation, true) && Appointment.compareDeep(this.start, o.start, true) && Appointment.compareDeep(this.end, o.end, true) && Appointment.compareDeep(this.minutesDuration, o.minutesDuration, true) && Appointment.compareDeep(this.slot, o.slot, true) && Appointment.compareDeep(this.created, o.created, true) && Appointment.compareDeep(this.comment, o.comment, true) && Appointment.compareDeep(this.patientInstruction, o.patientInstruction, true) && Appointment.compareDeep(this.basedOn, o.basedOn, true) && Appointment.compareDeep(this.participant, o.participant, true) && Appointment.compareDeep(this.requestedPeriod, o.requestedPeriod, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other_;
        return Appointment.compareValues(this.status, o.status, true) && Appointment.compareValues(this.description, o.description, true) && Appointment.compareValues(this.start, o.start, true) && Appointment.compareValues(this.end, o.end, true) && Appointment.compareValues(this.minutesDuration, o.minutesDuration, true) && Appointment.compareValues(this.created, o.created, true) && Appointment.compareValues(this.comment, o.comment, true) && Appointment.compareValues(this.patientInstruction, o.patientInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.cancelationReason, this.serviceCategory, this.serviceType, this.specialty, this.appointmentType, this.reason, this.priority, this.description, this.supportingInformation, this.start, this.end, this.minutesDuration, this.slot, this.created, this.comment, this.patientInstruction, this.basedOn, this.participant, this.requestedPeriod});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Appointment;
    }

    @Block
    public static class AppointmentParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        protected List<CodeableConcept> type;
        @Child(name="actor", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Person, Location/HealthcareService or Device", formalDefinition="A Person, Location/HealthcareService or Device that is participating in the appointment.")
        protected Reference actor;
        @Child(name="required", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="required | optional | information-only", formalDefinition="Whether this participant is required to be present at the meeting. This covers a use-case where two doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participantrequired")
        protected Enumeration<ParticipantRequired> required;
        @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="accepted | declined | tentative | needs-action", formalDefinition="Participation status of the actor.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participationstatus")
        protected Enumeration<Enumerations.ParticipationStatus> status;
        @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Participation period of the actor", formalDefinition="Participation period of the actor.")
        protected Period period;
        private static final long serialVersionUID = -1993862145L;

        public AppointmentParticipantComponent() {
        }

        public AppointmentParticipantComponent(Enumerations.ParticipationStatus status) {
            this.setStatus(status);
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public AppointmentParticipantComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AppointmentParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AppointmentParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Enumeration<ParticipantRequired> getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new Enumeration<ParticipantRequired>(new ParticipantRequiredEnumFactory());
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public AppointmentParticipantComponent setRequiredElement(Enumeration<ParticipantRequired> value) {
            this.required = value;
            return this;
        }

        public ParticipantRequired getRequired() {
            return this.required == null ? null : (ParticipantRequired)((Object)this.required.getValue());
        }

        public AppointmentParticipantComponent setRequired(ParticipantRequired value) {
            if (value == null) {
                this.required = null;
            } else {
                if (this.required == null) {
                    this.required = new Enumeration<ParticipantRequired>(new ParticipantRequiredEnumFactory());
                }
                this.required.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ParticipationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public AppointmentParticipantComponent setStatusElement(Enumeration<Enumerations.ParticipationStatus> value) {
            this.status = value;
            return this;
        }

        public Enumerations.ParticipationStatus getStatus() {
            return this.status == null ? null : (Enumerations.ParticipationStatus)((Object)this.status.getValue());
        }

        public AppointmentParticipantComponent setStatus(Enumerations.ParticipationStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public AppointmentParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property(Appointment.SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location/HealthcareService or Device that is participating in the appointment.", 0, 1, this.actor));
            children.add(new Property("required", "code", "Whether this participant is required to be present at the meeting. This covers a use-case where two doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.", 0, 1, this.required));
            children.add(new Property(Appointment.SP_STATUS, "code", "Participation status of the actor.", 0, 1, this.status));
            children.add(new Property("period", "Period", "Participation period of the actor.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.type);
                }
                case 92645877: {
                    return new Property(Appointment.SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location/HealthcareService or Device that is participating in the appointment.", 0, 1, this.actor);
                }
                case -393139297: {
                    return new Property("required", "code", "Whether this participant is required to be present at the meeting. This covers a use-case where two doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.", 0, 1, this.required);
                }
                case -892481550: {
                    return new Property(Appointment.SP_STATUS, "code", "Participation status of the actor.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "Participation period of the actor.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.required;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
                case -393139297: {
                    value = new ParticipantRequiredEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.required = value;
                    return value;
                }
                case -892481550: {
                    value = new Enumerations.ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = TypeConvertor.castToReference(value);
            } else if (name.equals("required")) {
                value = new ParticipantRequiredEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.required = value;
            } else if (name.equals(Appointment.SP_STATUS)) {
                value = new Enumerations.ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case 92645877: {
                    return this.getActor();
                }
                case -393139297: {
                    return this.getRequiredElement();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -393139297: {
                    return new String[]{"code"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type Appointment.participant.required");
            }
            if (name.equals(Appointment.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Appointment.participant.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentParticipantComponent copy() {
            AppointmentParticipantComponent dst = new AppointmentParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentParticipantComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.required = this.required == null ? null : this.required.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other_;
            return AppointmentParticipantComponent.compareDeep(this.type, o.type, true) && AppointmentParticipantComponent.compareDeep(this.actor, o.actor, true) && AppointmentParticipantComponent.compareDeep(this.required, o.required, true) && AppointmentParticipantComponent.compareDeep(this.status, o.status, true) && AppointmentParticipantComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other_;
            return AppointmentParticipantComponent.compareValues(this.required, o.required, true) && AppointmentParticipantComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.actor, this.required, this.status, this.period});
        }

        @Override
        public String fhirType() {
            return "Appointment.participant";
        }
    }

    public static class ParticipantRequiredEnumFactory
    implements EnumFactory<ParticipantRequired> {
        @Override
        public ParticipantRequired fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("required".equals(codeString)) {
                return ParticipantRequired.REQUIRED;
            }
            if ("optional".equals(codeString)) {
                return ParticipantRequired.OPTIONAL;
            }
            if ("information-only".equals(codeString)) {
                return ParticipantRequired.INFORMATIONONLY;
            }
            throw new IllegalArgumentException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        public Enumeration<ParticipantRequired> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ParticipantRequired>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("required".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.REQUIRED);
            }
            if ("optional".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.OPTIONAL);
            }
            if ("information-only".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.INFORMATIONONLY);
            }
            throw new FHIRException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipantRequired code) {
            if (code == ParticipantRequired.REQUIRED) {
                return "required";
            }
            if (code == ParticipantRequired.OPTIONAL) {
                return "optional";
            }
            if (code == ParticipantRequired.INFORMATIONONLY) {
                return "information-only";
            }
            return "?";
        }

        @Override
        public String toSystem(ParticipantRequired code) {
            return code.getSystem();
        }
    }

    public static enum ParticipantRequired {
        REQUIRED,
        OPTIONAL,
        INFORMATIONONLY,
        NULL;


        public static ParticipantRequired fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("required".equals(codeString)) {
                return REQUIRED;
            }
            if ("optional".equals(codeString)) {
                return OPTIONAL;
            }
            if ("information-only".equals(codeString)) {
                return INFORMATIONONLY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REQUIRED: {
                    return "required";
                }
                case OPTIONAL: {
                    return "optional";
                }
                case INFORMATIONONLY: {
                    return "information-only";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REQUIRED: {
                    return "http://hl7.org/fhir/participantrequired";
                }
                case OPTIONAL: {
                    return "http://hl7.org/fhir/participantrequired";
                }
                case INFORMATIONONLY: {
                    return "http://hl7.org/fhir/participantrequired";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REQUIRED: {
                    return "The participant is required to attend the appointment.";
                }
                case OPTIONAL: {
                    return "The participant may optionally attend the appointment.";
                }
                case INFORMATIONONLY: {
                    return "The participant is excluded from the appointment, and might not be informed of the appointment taking place. (Appointment is about them, not for them - such as 2 doctors discussing results about a patient's test).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REQUIRED: {
                    return "Required";
                }
                case OPTIONAL: {
                    return "Optional";
                }
                case INFORMATIONONLY: {
                    return "Information Only";
                }
            }
            return "?";
        }
    }

    public static class AppointmentStatusEnumFactory
    implements EnumFactory<AppointmentStatus> {
        @Override
        public AppointmentStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return AppointmentStatus.PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return AppointmentStatus.PENDING;
            }
            if ("booked".equals(codeString)) {
                return AppointmentStatus.BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return AppointmentStatus.ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return AppointmentStatus.FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return AppointmentStatus.CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return AppointmentStatus.NOSHOW;
            }
            if ("entered-in-error".equals(codeString)) {
                return AppointmentStatus.ENTEREDINERROR;
            }
            if ("checked-in".equals(codeString)) {
                return AppointmentStatus.CHECKEDIN;
            }
            if ("waitlist".equals(codeString)) {
                return AppointmentStatus.WAITLIST;
            }
            throw new IllegalArgumentException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public Enumeration<AppointmentStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AppointmentStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PROPOSED);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PENDING);
            }
            if ("booked".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.BOOKED);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.ARRIVED);
            }
            if ("fulfilled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.FULFILLED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.CANCELLED);
            }
            if ("noshow".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.NOSHOW);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.ENTEREDINERROR);
            }
            if ("checked-in".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.CHECKEDIN);
            }
            if ("waitlist".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.WAITLIST);
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AppointmentStatus code) {
            if (code == AppointmentStatus.PROPOSED) {
                return "proposed";
            }
            if (code == AppointmentStatus.PENDING) {
                return "pending";
            }
            if (code == AppointmentStatus.BOOKED) {
                return "booked";
            }
            if (code == AppointmentStatus.ARRIVED) {
                return "arrived";
            }
            if (code == AppointmentStatus.FULFILLED) {
                return "fulfilled";
            }
            if (code == AppointmentStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == AppointmentStatus.NOSHOW) {
                return "noshow";
            }
            if (code == AppointmentStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == AppointmentStatus.CHECKEDIN) {
                return "checked-in";
            }
            if (code == AppointmentStatus.WAITLIST) {
                return "waitlist";
            }
            return "?";
        }

        @Override
        public String toSystem(AppointmentStatus code) {
            return code.getSystem();
        }
    }

    public static enum AppointmentStatus {
        PROPOSED,
        PENDING,
        BOOKED,
        ARRIVED,
        FULFILLED,
        CANCELLED,
        NOSHOW,
        ENTEREDINERROR,
        CHECKEDIN,
        WAITLIST,
        NULL;


        public static AppointmentStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("booked".equals(codeString)) {
                return BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return NOSHOW;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("checked-in".equals(codeString)) {
                return CHECKEDIN;
            }
            if ("waitlist".equals(codeString)) {
                return WAITLIST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PENDING: {
                    return "pending";
                }
                case BOOKED: {
                    return "booked";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case FULFILLED: {
                    return "fulfilled";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NOSHOW: {
                    return "noshow";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case CHECKEDIN: {
                    return "checked-in";
                }
                case WAITLIST: {
                    return "waitlist";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case BOOKED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case FULFILLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case NOSHOW: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case CHECKEDIN: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case WAITLIST: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "None of the participant(s) have finalized their acceptance of the appointment request, and the start/end time might not be set yet.";
                }
                case PENDING: {
                    return "Some or all of the participant(s) have not finalized their acceptance of the appointment request.";
                }
                case BOOKED: {
                    return "All participant(s) have been considered and the appointment is confirmed to go ahead at the date/times specified.";
                }
                case ARRIVED: {
                    return "The patient/patients has/have arrived and is/are waiting to be seen.";
                }
                case FULFILLED: {
                    return "The planning stages of the appointment are now complete, the encounter resource will exist and will track further status changes. Note that an encounter may exist before the appointment status is fulfilled for many reasons.";
                }
                case CANCELLED: {
                    return "The appointment has been cancelled.";
                }
                case NOSHOW: {
                    return "Some or all of the participant(s) have not/did not appear for the appointment (usually the patient).";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case CHECKEDIN: {
                    return "When checked in, all pre-encounter administrative work is complete, and the encounter may begin. (where multiple patients are involved, they are all present).";
                }
                case WAITLIST: {
                    return "The appointment has been placed on a waitlist, to be scheduled/confirmed in the future when a slot/service is available.\nA specific time might or might not be pre-allocated.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PENDING: {
                    return "Pending";
                }
                case BOOKED: {
                    return "Booked";
                }
                case ARRIVED: {
                    return "Arrived";
                }
                case FULFILLED: {
                    return "Fulfilled";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NOSHOW: {
                    return "No Show";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case CHECKEDIN: {
                    return "Checked In";
                }
                case WAITLIST: {
                    return "Waitlisted";
                }
            }
            return "?";
        }
    }
}

