/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Ingredient", profile="http://hl7.org/fhir/StructureDefinition/Ingredient")
public class Ingredient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier or code by which the ingredient can be referenced", formalDefinition="The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected Identifier identifier;
    @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive", formalDefinition="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.")
    protected CodeableConcept role;
    @Child(name="function", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent", formalDefinition="A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent.")
    protected List<CodeableConcept> function;
    @Child(name="group", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink", formalDefinition="A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.")
    protected CodeableConcept group;
    @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A general description of the ingredient, or any supporting text. May be used for an unstructured list of excipients", formalDefinition="A general description of the ingredient, or any supporting text. May be used for an unstructured list of excipients.")
    protected MarkdownType description;
    @Child(name="allergenicIndicator", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the ingredient is a known or suspected allergen", formalDefinition="If the ingredient is a known or suspected allergen.")
    protected BooleanType allergenicIndicator;
    @Child(name="manufacturer", type={Organization.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The organization that manufactures this ingredient", formalDefinition="The organization that manufactures this ingredient.")
    protected List<Reference> manufacturer;
    @Child(name="substance", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The substance that comprises this ingredient", formalDefinition="The substance that comprises this ingredient.")
    protected IngredientSubstanceComponent substance;
    @Child(name="specifiedSubstance", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A specified substance that comprises this ingredient", formalDefinition="A specified substance that comprises this ingredient.")
    protected List<IngredientSpecifiedSubstanceComponent> specifiedSubstance;
    private static final long serialVersionUID = -665064678L;
    @SearchParamDefinition(name="function", path="Ingredient.function", description="A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent", type="token")
    public static final String SP_FUNCTION = "function";
    public static final TokenClientParam FUNCTION = new TokenClientParam("function");
    @SearchParamDefinition(name="identifier", path="Ingredient.identifier", description="An identifier or code by which the ingredient can be referenced", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manufacturer", path="Ingredient.manufacturer", description="The organization that manufactures this ingredient", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Ingredient:manufacturer").toLocked();
    @SearchParamDefinition(name="role", path="Ingredient.role", description="A classification of the ingredient identifying its purpose within the product, e.g. active, inactive", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="specified-substance", path="Ingredient.specifiedSubstance.code.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_SPECIFIED_SUBSTANCE = "specified-substance";
    public static final ReferenceClientParam SPECIFIED_SUBSTANCE = new ReferenceClientParam("specified-substance");
    public static final Include INCLUDE_SPECIFIED_SUBSTANCE = new Include("Ingredient:specified-substance").toLocked();
    @SearchParamDefinition(name="specified-substance-code", path="Ingredient.specifiedSubstance.code.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_SPECIFIED_SUBSTANCE_CODE = "specified-substance-code";
    public static final TokenClientParam SPECIFIED_SUBSTANCE_CODE = new TokenClientParam("specified-substance-code");
    @SearchParamDefinition(name="specified-substance-definition", path="Ingredient.specifiedSubstance.code.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_SPECIFIED_SUBSTANCE_DEFINITION = "specified-substance-definition";
    public static final ReferenceClientParam SPECIFIED_SUBSTANCE_DEFINITION = new ReferenceClientParam("specified-substance-definition");
    public static final Include INCLUDE_SPECIFIED_SUBSTANCE_DEFINITION = new Include("Ingredient:specified-substance-definition").toLocked();
    @SearchParamDefinition(name="substance", path="Ingredient.substance.code.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("Ingredient:substance").toLocked();
    @SearchParamDefinition(name="substance-code", path="Ingredient.substance.code.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_SUBSTANCE_CODE = "substance-code";
    public static final TokenClientParam SUBSTANCE_CODE = new TokenClientParam("substance-code");
    @SearchParamDefinition(name="substance-definition", path="Ingredient.substance.code.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_SUBSTANCE_DEFINITION = "substance-definition";
    public static final ReferenceClientParam SUBSTANCE_DEFINITION = new ReferenceClientParam("substance-definition");
    public static final Include INCLUDE_SUBSTANCE_DEFINITION = new Include("Ingredient:substance-definition").toLocked();

    public Ingredient() {
    }

    public Ingredient(CodeableConcept role) {
        this.setRole(role);
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Ingredient setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getRole() {
        if (this.role == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.role");
            }
            if (Configuration.doAutoCreate()) {
                this.role = new CodeableConcept();
            }
        }
        return this.role;
    }

    public boolean hasRole() {
        return this.role != null && !this.role.isEmpty();
    }

    public Ingredient setRole(CodeableConcept value) {
        this.role = value;
        return this;
    }

    public List<CodeableConcept> getFunction() {
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        return this.function;
    }

    public Ingredient setFunction(List<CodeableConcept> theFunction) {
        this.function = theFunction;
        return this;
    }

    public boolean hasFunction() {
        if (this.function == null) {
            return false;
        }
        for (CodeableConcept item : this.function) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFunction() {
        CodeableConcept t = new CodeableConcept();
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        this.function.add(t);
        return t;
    }

    public Ingredient addFunction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.function == null) {
            this.function = new ArrayList<CodeableConcept>();
        }
        this.function.add(t);
        return this;
    }

    public CodeableConcept getFunctionFirstRep() {
        if (this.getFunction().isEmpty()) {
            this.addFunction();
        }
        return this.getFunction().get(0);
    }

    public CodeableConcept getGroup() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new CodeableConcept();
            }
        }
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Ingredient setGroup(CodeableConcept value) {
        this.group = value;
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Ingredient setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Ingredient setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public BooleanType getAllergenicIndicatorElement() {
        if (this.allergenicIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.allergenicIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.allergenicIndicator = new BooleanType();
            }
        }
        return this.allergenicIndicator;
    }

    public boolean hasAllergenicIndicatorElement() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public boolean hasAllergenicIndicator() {
        return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
    }

    public Ingredient setAllergenicIndicatorElement(BooleanType value) {
        this.allergenicIndicator = value;
        return this;
    }

    public boolean getAllergenicIndicator() {
        return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
    }

    public Ingredient setAllergenicIndicator(boolean value) {
        if (this.allergenicIndicator == null) {
            this.allergenicIndicator = new BooleanType();
        }
        this.allergenicIndicator.setValue((Object)value);
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public Ingredient setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public Ingredient addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public IngredientSubstanceComponent getSubstance() {
        if (this.substance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ingredient.substance");
            }
            if (Configuration.doAutoCreate()) {
                this.substance = new IngredientSubstanceComponent();
            }
        }
        return this.substance;
    }

    public boolean hasSubstance() {
        return this.substance != null && !this.substance.isEmpty();
    }

    public Ingredient setSubstance(IngredientSubstanceComponent value) {
        this.substance = value;
        return this;
    }

    public List<IngredientSpecifiedSubstanceComponent> getSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        return this.specifiedSubstance;
    }

    public Ingredient setSpecifiedSubstance(List<IngredientSpecifiedSubstanceComponent> theSpecifiedSubstance) {
        this.specifiedSubstance = theSpecifiedSubstance;
        return this;
    }

    public boolean hasSpecifiedSubstance() {
        if (this.specifiedSubstance == null) {
            return false;
        }
        for (IngredientSpecifiedSubstanceComponent item : this.specifiedSubstance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IngredientSpecifiedSubstanceComponent addSpecifiedSubstance() {
        IngredientSpecifiedSubstanceComponent t = new IngredientSpecifiedSubstanceComponent();
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return t;
    }

    public Ingredient addSpecifiedSubstance(IngredientSpecifiedSubstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specifiedSubstance == null) {
            this.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
        }
        this.specifiedSubstance.add(t);
        return this;
    }

    public IngredientSpecifiedSubstanceComponent getSpecifiedSubstanceFirstRep() {
        if (this.getSpecifiedSubstance().isEmpty()) {
            this.addSpecifiedSubstance();
        }
        return this.getSpecifiedSubstance().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier));
        children.add(new Property(SP_ROLE, "CodeableConcept", "A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.", 0, 1, this.role));
        children.add(new Property(SP_FUNCTION, "CodeableConcept", "A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent.", 0, Integer.MAX_VALUE, this.function));
        children.add(new Property("group", "CodeableConcept", "A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.", 0, 1, this.group));
        children.add(new Property("description", "markdown", "A general description of the ingredient, or any supporting text. May be used for an unstructured list of excipients.", 0, 1, this.description));
        children.add(new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "The organization that manufactures this ingredient.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property(SP_SUBSTANCE, "", "The substance that comprises this ingredient.", 0, 1, this.substance));
        children.add(new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, 1, this.identifier);
            }
            case 3506294: {
                return new Property(SP_ROLE, "CodeableConcept", "A classification of the ingredient identifying its purpose within the product, e.g. active, inactive.", 0, 1, this.role);
            }
            case 1380938712: {
                return new Property(SP_FUNCTION, "CodeableConcept", "A classification of the ingredient identifying its precise purpose(s) in the drug product. This extends the Ingredient.role to add more detail. Example: Antioxidant, Alkalizing Agent.", 0, Integer.MAX_VALUE, this.function);
            }
            case 98629247: {
                return new Property("group", "CodeableConcept", "A classification of the ingredient according to where in the physical item it tends to be used, such the outer shell of a tablet, inner body or ink.", 0, 1, this.group);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A general description of the ingredient, or any supporting text. May be used for an unstructured list of excipients.", 0, 1, this.description);
            }
            case 75406931: {
                return new Property("allergenicIndicator", "boolean", "If the ingredient is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "The organization that manufactures this ingredient.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case 530040176: {
                return new Property(SP_SUBSTANCE, "", "The substance that comprises this ingredient.", 0, 1, this.substance);
            }
            case -331477600: {
                return new Property("specifiedSubstance", "", "A specified substance that comprises this ingredient.", 0, Integer.MAX_VALUE, this.specifiedSubstance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3506294: {
                Base[] baseArray;
                if (this.role == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.role;
                }
                return baseArray;
            }
            case 1380938712: {
                return this.function == null ? new Base[]{} : this.function.toArray(new Base[this.function.size()]);
            }
            case 98629247: {
                Base[] baseArray;
                if (this.group == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.group;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case 75406931: {
                Base[] baseArray;
                if (this.allergenicIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.allergenicIndicator;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case 530040176: {
                Base[] baseArray;
                if (this.substance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.substance;
                }
                return baseArray;
            }
            case -331477600: {
                return this.specifiedSubstance == null ? new Base[]{} : this.specifiedSubstance.toArray(new Base[this.specifiedSubstance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 3506294: {
                this.role = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1380938712: {
                this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 98629247: {
                this.group = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 75406931: {
                this.allergenicIndicator = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 530040176: {
                this.substance = (IngredientSubstanceComponent)value;
                return value;
            }
            case -331477600: {
                this.getSpecifiedSubstance().add((IngredientSpecifiedSubstanceComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_ROLE)) {
            this.role = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_FUNCTION)) {
            this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("group")) {
            this.group = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("allergenicIndicator")) {
            this.allergenicIndicator = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SUBSTANCE)) {
            this.substance = (IngredientSubstanceComponent)value;
        } else if (name.equals("specifiedSubstance")) {
            this.getSpecifiedSubstance().add((IngredientSpecifiedSubstanceComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3506294: {
                return this.getRole();
            }
            case 1380938712: {
                return this.addFunction();
            }
            case 98629247: {
                return this.getGroup();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 75406931: {
                return this.getAllergenicIndicatorElement();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case 530040176: {
                return this.getSubstance();
            }
            case -331477600: {
                return this.addSpecifiedSubstance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case 1380938712: {
                return new String[]{"CodeableConcept"};
            }
            case 98629247: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 75406931: {
                return new String[]{"boolean"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 530040176: {
                return new String[0];
            }
            case -331477600: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_ROLE)) {
            this.role = new CodeableConcept();
            return this.role;
        }
        if (name.equals(SP_FUNCTION)) {
            return this.addFunction();
        }
        if (name.equals("group")) {
            this.group = new CodeableConcept();
            return this.group;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Ingredient.description");
        }
        if (name.equals("allergenicIndicator")) {
            throw new FHIRException("Cannot call addChild on a primitive type Ingredient.allergenicIndicator");
        }
        if (name.equals(SP_MANUFACTURER)) {
            return this.addManufacturer();
        }
        if (name.equals(SP_SUBSTANCE)) {
            this.substance = new IngredientSubstanceComponent();
            return this.substance;
        }
        if (name.equals("specifiedSubstance")) {
            return this.addSpecifiedSubstance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Ingredient";
    }

    @Override
    public Ingredient copy() {
        Ingredient dst = new Ingredient();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Ingredient dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
        if (this.function != null) {
            dst.function = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.function) {
                dst.function.add(codeableConcept2.copy());
            }
        }
        dst.group = this.group == null ? null : this.group.copy();
        dst.description = this.description == null ? null : this.description.copy();
        BooleanType booleanType = dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        IngredientSubstanceComponent ingredientSubstanceComponent = dst.substance = this.substance == null ? null : this.substance.copy();
        if (this.specifiedSubstance != null) {
            dst.specifiedSubstance = new ArrayList<IngredientSpecifiedSubstanceComponent>();
            for (IngredientSpecifiedSubstanceComponent ingredientSpecifiedSubstanceComponent : this.specifiedSubstance) {
                dst.specifiedSubstance.add(ingredientSpecifiedSubstanceComponent.copy());
            }
        }
    }

    protected Ingredient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareDeep(this.identifier, o.identifier, true) && Ingredient.compareDeep(this.role, o.role, true) && Ingredient.compareDeep(this.function, o.function, true) && Ingredient.compareDeep(this.group, o.group, true) && Ingredient.compareDeep(this.description, o.description, true) && Ingredient.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true) && Ingredient.compareDeep(this.manufacturer, o.manufacturer, true) && Ingredient.compareDeep(this.substance, o.substance, true) && Ingredient.compareDeep(this.specifiedSubstance, o.specifiedSubstance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Ingredient)) {
            return false;
        }
        Ingredient o = (Ingredient)other_;
        return Ingredient.compareValues(this.description, o.description, true) && Ingredient.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.role, this.function, this.group, this.description, this.allergenicIndicator, this.manufacturer, this.substance, this.specifiedSubstance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Ingredient;
    }

    @Block
    public static class IngredientSpecifiedSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance as a 'specified substance', implying extra substance related characteristics", formalDefinition="Substance as a 'specified substance', implying extra substance related characteristics.")
        protected CodeableReference code;
        @Child(name="group", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The group of specified substance, e.g. group 1 to 4, where the group categorises the level of \ndescription of the substance according to standardised sets of properties", formalDefinition="The group of specified substance, e.g. group 1 to 4, where the group categorises the level of \ndescription of the substance according to standardised sets of properties.")
        protected CodeableConcept group;
        @Child(name="confidentiality", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Confidentiality level of the specified substance as the ingredient", formalDefinition="Confidentiality level of the specified substance as the ingredient.")
        protected CodeableConcept confidentiality;
        @Child(name="strength", type={IngredientSubstanceStrengthComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product", formalDefinition="Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.")
        protected List<IngredientSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = 598811158L;

        public IngredientSpecifiedSubstanceComponent() {
        }

        public IngredientSpecifiedSubstanceComponent(CodeableReference code, CodeableConcept group) {
            this.setCode(code);
            this.setGroup(group);
        }

        public CodeableReference getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableReference();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setCode(CodeableReference value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getGroup() {
            if (this.group == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceComponent.group");
                }
                if (Configuration.doAutoCreate()) {
                    this.group = new CodeableConcept();
                }
            }
            return this.group;
        }

        public boolean hasGroup() {
            return this.group != null && !this.group.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setGroup(CodeableConcept value) {
            this.group = value;
            return this;
        }

        public CodeableConcept getConfidentiality() {
            if (this.confidentiality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSpecifiedSubstanceComponent.confidentiality");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentiality = new CodeableConcept();
                }
            }
            return this.confidentiality;
        }

        public boolean hasConfidentiality() {
            return this.confidentiality != null && !this.confidentiality.isEmpty();
        }

        public IngredientSpecifiedSubstanceComponent setConfidentiality(CodeableConcept value) {
            this.confidentiality = value;
            return this;
        }

        public List<IngredientSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public IngredientSpecifiedSubstanceComponent setStrength(List<IngredientSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (IngredientSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSubstanceStrengthComponent addStrength() {
            IngredientSubstanceStrengthComponent t = new IngredientSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public IngredientSpecifiedSubstanceComponent addStrength(IngredientSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public IngredientSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableReference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code));
            children.add(new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4, where the group categorises the level of \ndescription of the substance according to standardised sets of properties.", 0, 1, this.group));
            children.add(new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality));
            children.add(new Property("strength", "@Ingredient.substance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableReference(SubstanceDefinition|Substance)", "Substance as a 'specified substance', implying extra substance related characteristics.", 0, 1, this.code);
                }
                case 98629247: {
                    return new Property("group", "CodeableConcept", "The group of specified substance, e.g. group 1 to 4, where the group categorises the level of \ndescription of the substance according to standardised sets of properties.", 0, 1, this.group);
                }
                case -1923018202: {
                    return new Property("confidentiality", "CodeableConcept", "Confidentiality level of the specified substance as the ingredient.", 0, 1, this.confidentiality);
                }
                case 1791316033: {
                    return new Property("strength", "@Ingredient.substance.strength", "Quantity of the substance or specified substance present in the manufactured item or pharmaceutical product.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 98629247: {
                    Base[] baseArray;
                    if (this.group == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.group;
                    }
                    return baseArray;
                }
                case -1923018202: {
                    Base[] baseArray;
                    if (this.confidentiality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.confidentiality;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 98629247: {
                    this.group = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1923018202: {
                    this.confidentiality = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((IngredientSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("group")) {
                this.group = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("confidentiality")) {
                this.confidentiality = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((IngredientSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 98629247: {
                    return this.getGroup();
                }
                case -1923018202: {
                    return this.getConfidentiality();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableReference"};
                }
                case 98629247: {
                    return new String[]{"CodeableConcept"};
                }
                case -1923018202: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[]{"@Ingredient.substance.strength"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableReference();
                return this.code;
            }
            if (name.equals("group")) {
                this.group = new CodeableConcept();
                return this.group;
            }
            if (name.equals("confidentiality")) {
                this.confidentiality = new CodeableConcept();
                return this.confidentiality;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSpecifiedSubstanceComponent copy() {
            IngredientSpecifiedSubstanceComponent dst = new IngredientSpecifiedSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSpecifiedSubstanceComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.group = this.group == null ? null : this.group.copy();
            CodeableConcept codeableConcept = dst.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
                for (IngredientSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceComponent o = (IngredientSpecifiedSubstanceComponent)other_;
            return IngredientSpecifiedSubstanceComponent.compareDeep(this.code, o.code, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.group, o.group, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.confidentiality, o.confidentiality, true) && IngredientSpecifiedSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSpecifiedSubstanceComponent)) {
                return false;
            }
            IngredientSpecifiedSubstanceComponent o = (IngredientSpecifiedSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.group, this.confidentiality, this.strength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.specifiedSubstance";
        }
    }

    @Block
    public static class IngredientSubstanceStrengthReferenceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relevant reference substance", formalDefinition="Relevant reference substance.")
        protected CodeableReference substance;
        @Child(name="strength", type={Ratio.class, Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit", formalDefinition="Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.")
        protected DataType strength;
        @Child(name="strengthHighLimit", type={Ratio.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit", formalDefinition="Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.")
        protected DataType strengthHighLimit;
        @Child(name="measurementPoint", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        private static final long serialVersionUID = -1478675679L;

        public IngredientSubstanceStrengthReferenceStrengthComponent() {
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent(DataType strength) {
            this.setStrength(strength);
        }

        public CodeableReference getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthReferenceStrengthComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableReference();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setSubstance(CodeableReference value) {
            this.substance = value;
            return this;
        }

        public DataType getStrength() {
            return this.strength;
        }

        public Ratio getStrengthRatio() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Ratio();
            }
            if (!(this.strength instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Ratio)this.strength;
        }

        public boolean hasStrengthRatio() {
            return this != null && this.strength instanceof Ratio;
        }

        public Quantity getStrengthQuantity() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Quantity();
            }
            if (!(this.strength instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Quantity)this.strength;
        }

        public boolean hasStrengthQuantity() {
            return this != null && this.strength instanceof Quantity;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setStrength(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.referenceStrength.strength[x]: " + value.fhirType());
            }
            this.strength = value;
            return this;
        }

        public DataType getStrengthHighLimit() {
            return this.strengthHighLimit;
        }

        public Ratio getStrengthHighLimitRatio() throws FHIRException {
            if (this.strengthHighLimit == null) {
                this.strengthHighLimit = new Ratio();
            }
            if (!(this.strengthHighLimit instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.strengthHighLimit.getClass().getName() + " was encountered");
            }
            return (Ratio)this.strengthHighLimit;
        }

        public boolean hasStrengthHighLimitRatio() {
            return this != null && this.strengthHighLimit instanceof Ratio;
        }

        public Quantity getStrengthHighLimitQuantity() throws FHIRException {
            if (this.strengthHighLimit == null) {
                this.strengthHighLimit = new Quantity();
            }
            if (!(this.strengthHighLimit instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.strengthHighLimit.getClass().getName() + " was encountered");
            }
            return (Quantity)this.strengthHighLimit;
        }

        public boolean hasStrengthHighLimitQuantity() {
            return this != null && this.strengthHighLimit instanceof Quantity;
        }

        public boolean hasStrengthHighLimit() {
            return this.strengthHighLimit != null && !this.strengthHighLimit.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setStrengthHighLimit(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.referenceStrength.strengthHighLimit[x]: " + value.fhirType());
            }
            this.strengthHighLimit = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthReferenceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Ingredient.SP_SUBSTANCE, "CodeableReference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance));
            children.add(new Property("strength[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.", 0, 1, this.strength));
            children.add(new Property("strengthHighLimit[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.", 0, 1, this.strengthHighLimit));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property(Ingredient.SP_SUBSTANCE, "CodeableReference(SubstanceDefinition|Substance)", "Relevant reference substance.", 0, 1, this.substance);
                }
                case 127377567: {
                    return new Property("strength[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.", 0, 1, this.strength);
                }
                case 1791316033: {
                    return new Property("strength[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.", 0, 1, this.strength);
                }
                case 2141786186: {
                    return new Property("strength[x]", "Ratio", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.", 0, 1, this.strength);
                }
                case -1793570836: {
                    return new Property("strength[x]", "Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the lower limit.", 0, 1, this.strength);
                }
                case -151714424: {
                    return new Property("strengthHighLimit[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.", 0, 1, this.strengthHighLimit);
                }
                case 703544312: {
                    return new Property("strengthHighLimit[x]", "Ratio|Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.", 0, 1, this.strengthHighLimit);
                }
                case 222355187: {
                    return new Property("strengthHighLimit[x]", "Ratio", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.", 0, 1, this.strengthHighLimit);
                }
                case -367883101: {
                    return new Property("strengthHighLimit[x]", "Quantity", "Strength expressed in terms of a reference substance. When there is a range of strengths, this represents the upper limit.", 0, 1, this.strengthHighLimit);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.strength;
                    }
                    return baseArray;
                }
                case 703544312: {
                    Base[] baseArray;
                    if (this.strengthHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strengthHighLimit;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToType(value);
                    return value;
                }
                case 703544312: {
                    this.strengthHighLimit = TypeConvertor.castToType(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = TypeConvertor.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Ingredient.SP_SUBSTANCE)) {
                this.substance = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("strength[x]")) {
                this.strength = TypeConvertor.castToType(value);
            } else if (name.equals("strengthHighLimit[x]")) {
                this.strengthHighLimit = TypeConvertor.castToType(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = TypeConvertor.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case 127377567: {
                    return this.getStrength();
                }
                case 1791316033: {
                    return this.getStrength();
                }
                case -151714424: {
                    return this.getStrengthHighLimit();
                }
                case 703544312: {
                    return this.getStrengthHighLimit();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableReference"};
                }
                case 1791316033: {
                    return new String[]{"Ratio", "Quantity"};
                }
                case 703544312: {
                    return new String[]{"Ratio", "Quantity"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Ingredient.SP_SUBSTANCE)) {
                this.substance = new CodeableReference();
                return this.substance;
            }
            if (name.equals("strengthRatio")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthQuantity")) {
                this.strength = new Quantity();
                return this.strength;
            }
            if (name.equals("strengthHighLimitRatio")) {
                this.strengthHighLimit = new Ratio();
                return this.strengthHighLimit;
            }
            if (name.equals("strengthHighLimitQuantity")) {
                this.strengthHighLimit = new Quantity();
                return this.strengthHighLimit;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.substance.strength.referenceStrength.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceStrengthReferenceStrengthComponent copy() {
            IngredientSubstanceStrengthReferenceStrengthComponent dst = new IngredientSubstanceStrengthReferenceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceStrengthReferenceStrengthComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.strengthHighLimit = this.strengthHighLimit == null ? null : this.strengthHighLimit.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.country) {
                    dst.country.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthReferenceStrengthComponent o = (IngredientSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.substance, o.substance, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strength, o.strength, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.strengthHighLimit, o.strengthHighLimit, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSubstanceStrengthReferenceStrengthComponent.compareDeep(this.country, o.country, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthReferenceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthReferenceStrengthComponent o = (IngredientSubstanceStrengthReferenceStrengthComponent)other_;
            return IngredientSubstanceStrengthReferenceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.strength, this.strengthHighLimit, this.measurementPoint, this.country});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance.strength.referenceStrength";
        }
    }

    @Block
    public static class IngredientSubstanceStrengthComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="presentation", type={Ratio.class, CodeableConcept.class, Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.")
        protected DataType presentation;
        @Child(name="presentationHighLimit", type={Ratio.class, Quantity.class}, order=2, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit", formalDefinition="An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.")
        protected DataType presentationHighLimit;
        @Child(name="presentationText", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio", formalDefinition="A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.")
        protected StringType presentationText;
        @Child(name="concentration", type={Ratio.class, CodeableConcept.class, Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The strength per unitary volume (or mass)", formalDefinition="The strength per unitary volume (or mass).")
        protected DataType concentration;
        @Child(name="concentrationHighLimit", type={Ratio.class, Quantity.class}, order=5, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit", formalDefinition="An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.")
        protected DataType concentrationHighLimit;
        @Child(name="concentrationText", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio", formalDefinition="A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.")
        protected StringType concentrationText;
        @Child(name="basis", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt)", formalDefinition="A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).")
        protected CodeableConcept basis;
        @Child(name="measurementPoint", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For when strength is measured at a particular point or distance", formalDefinition="For when strength is measured at a particular point or distance.")
        protected StringType measurementPoint;
        @Child(name="country", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The country or countries for which the strength range applies", formalDefinition="The country or countries for which the strength range applies.")
        protected List<CodeableConcept> country;
        @Child(name="referenceStrength", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Strength expressed in terms of a reference substance", formalDefinition="Strength expressed in terms of a reference substance.")
        protected List<IngredientSubstanceStrengthReferenceStrengthComponent> referenceStrength;
        private static final long serialVersionUID = 1517811263L;

        public DataType getPresentation() {
            return this.presentation;
        }

        public Ratio getPresentationRatio() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new Ratio();
            }
            if (!(this.presentation instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (Ratio)this.presentation;
        }

        public boolean hasPresentationRatio() {
            return this != null && this.presentation instanceof Ratio;
        }

        public CodeableConcept getPresentationCodeableConcept() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new CodeableConcept();
            }
            if (!(this.presentation instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.presentation;
        }

        public boolean hasPresentationCodeableConcept() {
            return this != null && this.presentation instanceof CodeableConcept;
        }

        public Quantity getPresentationQuantity() throws FHIRException {
            if (this.presentation == null) {
                this.presentation = new Quantity();
            }
            if (!(this.presentation instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.presentation.getClass().getName() + " was encountered");
            }
            return (Quantity)this.presentation;
        }

        public boolean hasPresentationQuantity() {
            return this != null && this.presentation instanceof Quantity;
        }

        public boolean hasPresentation() {
            return this.presentation != null && !this.presentation.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setPresentation(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.presentation[x]: " + value.fhirType());
            }
            this.presentation = value;
            return this;
        }

        public DataType getPresentationHighLimit() {
            return this.presentationHighLimit;
        }

        public Ratio getPresentationHighLimitRatio() throws FHIRException {
            if (this.presentationHighLimit == null) {
                this.presentationHighLimit = new Ratio();
            }
            if (!(this.presentationHighLimit instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.presentationHighLimit.getClass().getName() + " was encountered");
            }
            return (Ratio)this.presentationHighLimit;
        }

        public boolean hasPresentationHighLimitRatio() {
            return this != null && this.presentationHighLimit instanceof Ratio;
        }

        public Quantity getPresentationHighLimitQuantity() throws FHIRException {
            if (this.presentationHighLimit == null) {
                this.presentationHighLimit = new Quantity();
            }
            if (!(this.presentationHighLimit instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.presentationHighLimit.getClass().getName() + " was encountered");
            }
            return (Quantity)this.presentationHighLimit;
        }

        public boolean hasPresentationHighLimitQuantity() {
            return this != null && this.presentationHighLimit instanceof Quantity;
        }

        public boolean hasPresentationHighLimit() {
            return this.presentationHighLimit != null && !this.presentationHighLimit.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setPresentationHighLimit(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.presentationHighLimit[x]: " + value.fhirType());
            }
            this.presentationHighLimit = value;
            return this;
        }

        public StringType getPresentationTextElement() {
            if (this.presentationText == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.presentationText");
                }
                if (Configuration.doAutoCreate()) {
                    this.presentationText = new StringType();
                }
            }
            return this.presentationText;
        }

        public boolean hasPresentationTextElement() {
            return this.presentationText != null && !this.presentationText.isEmpty();
        }

        public boolean hasPresentationText() {
            return this.presentationText != null && !this.presentationText.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setPresentationTextElement(StringType value) {
            this.presentationText = value;
            return this;
        }

        public String getPresentationText() {
            return this.presentationText == null ? null : (String)this.presentationText.getValue();
        }

        public IngredientSubstanceStrengthComponent setPresentationText(String value) {
            if (Utilities.noString((String)value)) {
                this.presentationText = null;
            } else {
                if (this.presentationText == null) {
                    this.presentationText = new StringType();
                }
                this.presentationText.setValue(value);
            }
            return this;
        }

        public DataType getConcentration() {
            return this.concentration;
        }

        public Ratio getConcentrationRatio() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new Ratio();
            }
            if (!(this.concentration instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (Ratio)this.concentration;
        }

        public boolean hasConcentrationRatio() {
            return this != null && this.concentration instanceof Ratio;
        }

        public CodeableConcept getConcentrationCodeableConcept() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new CodeableConcept();
            }
            if (!(this.concentration instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.concentration;
        }

        public boolean hasConcentrationCodeableConcept() {
            return this != null && this.concentration instanceof CodeableConcept;
        }

        public Quantity getConcentrationQuantity() throws FHIRException {
            if (this.concentration == null) {
                this.concentration = new Quantity();
            }
            if (!(this.concentration instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.concentration.getClass().getName() + " was encountered");
            }
            return (Quantity)this.concentration;
        }

        public boolean hasConcentrationQuantity() {
            return this != null && this.concentration instanceof Quantity;
        }

        public boolean hasConcentration() {
            return this.concentration != null && !this.concentration.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setConcentration(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.concentration[x]: " + value.fhirType());
            }
            this.concentration = value;
            return this;
        }

        public DataType getConcentrationHighLimit() {
            return this.concentrationHighLimit;
        }

        public Ratio getConcentrationHighLimitRatio() throws FHIRException {
            if (this.concentrationHighLimit == null) {
                this.concentrationHighLimit = new Ratio();
            }
            if (!(this.concentrationHighLimit instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.concentrationHighLimit.getClass().getName() + " was encountered");
            }
            return (Ratio)this.concentrationHighLimit;
        }

        public boolean hasConcentrationHighLimitRatio() {
            return this != null && this.concentrationHighLimit instanceof Ratio;
        }

        public Quantity getConcentrationHighLimitQuantity() throws FHIRException {
            if (this.concentrationHighLimit == null) {
                this.concentrationHighLimit = new Quantity();
            }
            if (!(this.concentrationHighLimit instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.concentrationHighLimit.getClass().getName() + " was encountered");
            }
            return (Quantity)this.concentrationHighLimit;
        }

        public boolean hasConcentrationHighLimitQuantity() {
            return this != null && this.concentrationHighLimit instanceof Quantity;
        }

        public boolean hasConcentrationHighLimit() {
            return this.concentrationHighLimit != null && !this.concentrationHighLimit.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setConcentrationHighLimit(DataType value) {
            if (value != null && !(value instanceof Ratio) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for Ingredient.substance.strength.concentrationHighLimit[x]: " + value.fhirType());
            }
            this.concentrationHighLimit = value;
            return this;
        }

        public StringType getConcentrationTextElement() {
            if (this.concentrationText == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.concentrationText");
                }
                if (Configuration.doAutoCreate()) {
                    this.concentrationText = new StringType();
                }
            }
            return this.concentrationText;
        }

        public boolean hasConcentrationTextElement() {
            return this.concentrationText != null && !this.concentrationText.isEmpty();
        }

        public boolean hasConcentrationText() {
            return this.concentrationText != null && !this.concentrationText.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setConcentrationTextElement(StringType value) {
            this.concentrationText = value;
            return this;
        }

        public String getConcentrationText() {
            return this.concentrationText == null ? null : (String)this.concentrationText.getValue();
        }

        public IngredientSubstanceStrengthComponent setConcentrationText(String value) {
            if (Utilities.noString((String)value)) {
                this.concentrationText = null;
            } else {
                if (this.concentrationText == null) {
                    this.concentrationText = new StringType();
                }
                this.concentrationText.setValue(value);
            }
            return this;
        }

        public CodeableConcept getBasis() {
            if (this.basis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.basis");
                }
                if (Configuration.doAutoCreate()) {
                    this.basis = new CodeableConcept();
                }
            }
            return this.basis;
        }

        public boolean hasBasis() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setBasis(CodeableConcept value) {
            this.basis = value;
            return this;
        }

        public StringType getMeasurementPointElement() {
            if (this.measurementPoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceStrengthComponent.measurementPoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.measurementPoint = new StringType();
                }
            }
            return this.measurementPoint;
        }

        public boolean hasMeasurementPointElement() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public boolean hasMeasurementPoint() {
            return this.measurementPoint != null && !this.measurementPoint.isEmpty();
        }

        public IngredientSubstanceStrengthComponent setMeasurementPointElement(StringType value) {
            this.measurementPoint = value;
            return this;
        }

        public String getMeasurementPoint() {
            return this.measurementPoint == null ? null : (String)this.measurementPoint.getValue();
        }

        public IngredientSubstanceStrengthComponent setMeasurementPoint(String value) {
            if (Utilities.noString((String)value)) {
                this.measurementPoint = null;
            } else {
                if (this.measurementPoint == null) {
                    this.measurementPoint = new StringType();
                }
                this.measurementPoint.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCountry() {
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            return this.country;
        }

        public IngredientSubstanceStrengthComponent setCountry(List<CodeableConcept> theCountry) {
            this.country = theCountry;
            return this;
        }

        public boolean hasCountry() {
            if (this.country == null) {
                return false;
            }
            for (CodeableConcept item : this.country) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCountry() {
            CodeableConcept t = new CodeableConcept();
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return t;
        }

        public IngredientSubstanceStrengthComponent addCountry(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.country == null) {
                this.country = new ArrayList<CodeableConcept>();
            }
            this.country.add(t);
            return this;
        }

        public CodeableConcept getCountryFirstRep() {
            if (this.getCountry().isEmpty()) {
                this.addCountry();
            }
            return this.getCountry().get(0);
        }

        public List<IngredientSubstanceStrengthReferenceStrengthComponent> getReferenceStrength() {
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            return this.referenceStrength;
        }

        public IngredientSubstanceStrengthComponent setReferenceStrength(List<IngredientSubstanceStrengthReferenceStrengthComponent> theReferenceStrength) {
            this.referenceStrength = theReferenceStrength;
            return this;
        }

        public boolean hasReferenceStrength() {
            if (this.referenceStrength == null) {
                return false;
            }
            for (IngredientSubstanceStrengthReferenceStrengthComponent item : this.referenceStrength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent addReferenceStrength() {
            IngredientSubstanceStrengthReferenceStrengthComponent t = new IngredientSubstanceStrengthReferenceStrengthComponent();
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return t;
        }

        public IngredientSubstanceStrengthComponent addReferenceStrength(IngredientSubstanceStrengthReferenceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceStrength == null) {
                this.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
            }
            this.referenceStrength.add(t);
            return this;
        }

        public IngredientSubstanceStrengthReferenceStrengthComponent getReferenceStrengthFirstRep() {
            if (this.getReferenceStrength().isEmpty()) {
                this.addReferenceStrength();
            }
            return this.getReferenceStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("presentation[x]", "Ratio|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation));
            children.add(new Property("presentationHighLimit[x]", "Ratio|Quantity", "An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.", 0, 1, this.presentationHighLimit));
            children.add(new Property("presentationText", "string", "A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.", 0, 1, this.presentationText));
            children.add(new Property("concentration[x]", "Ratio|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration));
            children.add(new Property("concentrationHighLimit[x]", "Ratio|Quantity", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit));
            children.add(new Property("concentrationText", "string", "A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.", 0, 1, this.concentrationText));
            children.add(new Property("basis", "CodeableConcept", "A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).", 0, 1, this.basis));
            children.add(new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint));
            children.add(new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country));
            children.add(new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1714280230: {
                    return new Property("presentation[x]", "Ratio|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case 696975130: {
                    return new Property("presentation[x]", "Ratio|CodeableConcept|Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case -1853112047: {
                    return new Property("presentation[x]", "Ratio", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case 1095127335: {
                    return new Property("presentation[x]", "CodeableConcept", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case -263057979: {
                    return new Property("presentation[x]", "Quantity", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item.", 0, 1, this.presentation);
                }
                case -239716639: {
                    return new Property("presentationHighLimit[x]", "Ratio|Quantity", "An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.", 0, 1, this.presentationHighLimit);
                }
                case 904802623: {
                    return new Property("presentationHighLimit[x]", "Ratio|Quantity", "An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.", 0, 1, this.presentationHighLimit);
                }
                case 1551572492: {
                    return new Property("presentationHighLimit[x]", "Ratio", "An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.", 0, 1, this.presentationHighLimit);
                }
                case -1253618966: {
                    return new Property("presentationHighLimit[x]", "Quantity", "An upper limit for the quantity of substance in the unit of presentation. When there is a range of strengths, this represents the upper limit.", 0, 1, this.presentationHighLimit);
                }
                case 1602853735: {
                    return new Property("presentationText", "string", "A textual represention of either the whole of the presentation strength or a part of it - with the rest being in Strength.presentation as a ratio.", 0, 1, this.presentationText);
                }
                case 1153502451: {
                    return new Property("concentration[x]", "Ratio|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -410557331: {
                    return new Property("concentration[x]", "Ratio|CodeableConcept|Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 405321630: {
                    return new Property("concentration[x]", "Ratio", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -90293388: {
                    return new Property("concentration[x]", "CodeableConcept", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case 71921688: {
                    return new Property("concentration[x]", "Quantity", "The strength per unitary volume (or mass).", 0, 1, this.concentration);
                }
                case -1682032716: {
                    return new Property("concentrationHighLimit[x]", "Ratio|Quantity", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit);
                }
                case -1595729588: {
                    return new Property("concentrationHighLimit[x]", "Ratio|Quantity", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit);
                }
                case -1534708193: {
                    return new Property("concentrationHighLimit[x]", "Ratio", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit);
                }
                case 2018366967: {
                    return new Property("concentrationHighLimit[x]", "Quantity", "An upper limit for the strength per unitary volume (or mass), for when there is a range. The concentration attribute then becomes the lower limit.", 0, 1, this.concentrationHighLimit);
                }
                case 1398611770: {
                    return new Property("concentrationText", "string", "A textual represention of either the whole of the concentration strength or a part of it - with the rest being in Strength.concentration as a ratio.", 0, 1, this.concentrationText);
                }
                case 93508670: {
                    return new Property("basis", "CodeableConcept", "A code that indicates if the strength is, for example, based on the ingredient substance as stated or on the substance base (when the ingredient is a salt).", 0, 1, this.basis);
                }
                case 235437876: {
                    return new Property("measurementPoint", "string", "For when strength is measured at a particular point or distance.", 0, 1, this.measurementPoint);
                }
                case 957831062: {
                    return new Property("country", "CodeableConcept", "The country or countries for which the strength range applies.", 0, Integer.MAX_VALUE, this.country);
                }
                case 1943566508: {
                    return new Property("referenceStrength", "", "Strength expressed in terms of a reference substance.", 0, Integer.MAX_VALUE, this.referenceStrength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    Base[] baseArray;
                    if (this.presentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.presentation;
                    }
                    return baseArray;
                }
                case 904802623: {
                    Base[] baseArray;
                    if (this.presentationHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.presentationHighLimit;
                    }
                    return baseArray;
                }
                case 1602853735: {
                    Base[] baseArray;
                    if (this.presentationText == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.presentationText;
                    }
                    return baseArray;
                }
                case -410557331: {
                    Base[] baseArray;
                    if (this.concentration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.concentration;
                    }
                    return baseArray;
                }
                case -1595729588: {
                    Base[] baseArray;
                    if (this.concentrationHighLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.concentrationHighLimit;
                    }
                    return baseArray;
                }
                case 1398611770: {
                    Base[] baseArray;
                    if (this.concentrationText == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.concentrationText;
                    }
                    return baseArray;
                }
                case 93508670: {
                    Base[] baseArray;
                    if (this.basis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.basis;
                    }
                    return baseArray;
                }
                case 235437876: {
                    Base[] baseArray;
                    if (this.measurementPoint == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.measurementPoint;
                    }
                    return baseArray;
                }
                case 957831062: {
                    return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
                }
                case 1943566508: {
                    return this.referenceStrength == null ? new Base[]{} : this.referenceStrength.toArray(new Base[this.referenceStrength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    this.presentation = TypeConvertor.castToType(value);
                    return value;
                }
                case 904802623: {
                    this.presentationHighLimit = TypeConvertor.castToType(value);
                    return value;
                }
                case 1602853735: {
                    this.presentationText = TypeConvertor.castToString(value);
                    return value;
                }
                case -410557331: {
                    this.concentration = TypeConvertor.castToType(value);
                    return value;
                }
                case -1595729588: {
                    this.concentrationHighLimit = TypeConvertor.castToType(value);
                    return value;
                }
                case 1398611770: {
                    this.concentrationText = TypeConvertor.castToString(value);
                    return value;
                }
                case 93508670: {
                    this.basis = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 235437876: {
                    this.measurementPoint = TypeConvertor.castToString(value);
                    return value;
                }
                case 957831062: {
                    this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1943566508: {
                    this.getReferenceStrength().add((IngredientSubstanceStrengthReferenceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("presentation[x]")) {
                this.presentation = TypeConvertor.castToType(value);
            } else if (name.equals("presentationHighLimit[x]")) {
                this.presentationHighLimit = TypeConvertor.castToType(value);
            } else if (name.equals("presentationText")) {
                this.presentationText = TypeConvertor.castToString(value);
            } else if (name.equals("concentration[x]")) {
                this.concentration = TypeConvertor.castToType(value);
            } else if (name.equals("concentrationHighLimit[x]")) {
                this.concentrationHighLimit = TypeConvertor.castToType(value);
            } else if (name.equals("concentrationText")) {
                this.concentrationText = TypeConvertor.castToString(value);
            } else if (name.equals("basis")) {
                this.basis = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("measurementPoint")) {
                this.measurementPoint = TypeConvertor.castToString(value);
            } else if (name.equals("country")) {
                this.getCountry().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("referenceStrength")) {
                this.getReferenceStrength().add((IngredientSubstanceStrengthReferenceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1714280230: {
                    return this.getPresentation();
                }
                case 696975130: {
                    return this.getPresentation();
                }
                case -239716639: {
                    return this.getPresentationHighLimit();
                }
                case 904802623: {
                    return this.getPresentationHighLimit();
                }
                case 1602853735: {
                    return this.getPresentationTextElement();
                }
                case 1153502451: {
                    return this.getConcentration();
                }
                case -410557331: {
                    return this.getConcentration();
                }
                case -1682032716: {
                    return this.getConcentrationHighLimit();
                }
                case -1595729588: {
                    return this.getConcentrationHighLimit();
                }
                case 1398611770: {
                    return this.getConcentrationTextElement();
                }
                case 93508670: {
                    return this.getBasis();
                }
                case 235437876: {
                    return this.getMeasurementPointElement();
                }
                case 957831062: {
                    return this.addCountry();
                }
                case 1943566508: {
                    return this.addReferenceStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 696975130: {
                    return new String[]{"Ratio", "CodeableConcept", "Quantity"};
                }
                case 904802623: {
                    return new String[]{"Ratio", "Quantity"};
                }
                case 1602853735: {
                    return new String[]{"string"};
                }
                case -410557331: {
                    return new String[]{"Ratio", "CodeableConcept", "Quantity"};
                }
                case -1595729588: {
                    return new String[]{"Ratio", "Quantity"};
                }
                case 1398611770: {
                    return new String[]{"string"};
                }
                case 93508670: {
                    return new String[]{"CodeableConcept"};
                }
                case 235437876: {
                    return new String[]{"string"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case 1943566508: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("presentationRatio")) {
                this.presentation = new Ratio();
                return this.presentation;
            }
            if (name.equals("presentationCodeableConcept")) {
                this.presentation = new CodeableConcept();
                return this.presentation;
            }
            if (name.equals("presentationQuantity")) {
                this.presentation = new Quantity();
                return this.presentation;
            }
            if (name.equals("presentationHighLimitRatio")) {
                this.presentationHighLimit = new Ratio();
                return this.presentationHighLimit;
            }
            if (name.equals("presentationHighLimitQuantity")) {
                this.presentationHighLimit = new Quantity();
                return this.presentationHighLimit;
            }
            if (name.equals("presentationText")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.substance.strength.presentationText");
            }
            if (name.equals("concentrationRatio")) {
                this.concentration = new Ratio();
                return this.concentration;
            }
            if (name.equals("concentrationCodeableConcept")) {
                this.concentration = new CodeableConcept();
                return this.concentration;
            }
            if (name.equals("concentrationQuantity")) {
                this.concentration = new Quantity();
                return this.concentration;
            }
            if (name.equals("concentrationHighLimitRatio")) {
                this.concentrationHighLimit = new Ratio();
                return this.concentrationHighLimit;
            }
            if (name.equals("concentrationHighLimitQuantity")) {
                this.concentrationHighLimit = new Quantity();
                return this.concentrationHighLimit;
            }
            if (name.equals("concentrationText")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.substance.strength.concentrationText");
            }
            if (name.equals("basis")) {
                this.basis = new CodeableConcept();
                return this.basis;
            }
            if (name.equals("measurementPoint")) {
                throw new FHIRException("Cannot call addChild on a primitive type Ingredient.substance.strength.measurementPoint");
            }
            if (name.equals("country")) {
                return this.addCountry();
            }
            if (name.equals("referenceStrength")) {
                return this.addReferenceStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceStrengthComponent copy() {
            IngredientSubstanceStrengthComponent dst = new IngredientSubstanceStrengthComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceStrengthComponent dst) {
            super.copyValues(dst);
            dst.presentation = this.presentation == null ? null : this.presentation.copy();
            dst.presentationHighLimit = this.presentationHighLimit == null ? null : this.presentationHighLimit.copy();
            dst.presentationText = this.presentationText == null ? null : this.presentationText.copy();
            dst.concentration = this.concentration == null ? null : this.concentration.copy();
            dst.concentrationHighLimit = this.concentrationHighLimit == null ? null : this.concentrationHighLimit.copy();
            dst.concentrationText = this.concentrationText == null ? null : this.concentrationText.copy();
            dst.basis = this.basis == null ? null : this.basis.copy();
            StringType stringType = dst.measurementPoint = this.measurementPoint == null ? null : this.measurementPoint.copy();
            if (this.country != null) {
                dst.country = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.country) {
                    dst.country.add(codeableConcept.copy());
                }
            }
            if (this.referenceStrength != null) {
                dst.referenceStrength = new ArrayList<IngredientSubstanceStrengthReferenceStrengthComponent>();
                for (IngredientSubstanceStrengthReferenceStrengthComponent ingredientSubstanceStrengthReferenceStrengthComponent : this.referenceStrength) {
                    dst.referenceStrength.add(ingredientSubstanceStrengthReferenceStrengthComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthComponent o = (IngredientSubstanceStrengthComponent)other_;
            return IngredientSubstanceStrengthComponent.compareDeep(this.presentation, o.presentation, true) && IngredientSubstanceStrengthComponent.compareDeep(this.presentationHighLimit, o.presentationHighLimit, true) && IngredientSubstanceStrengthComponent.compareDeep(this.presentationText, o.presentationText, true) && IngredientSubstanceStrengthComponent.compareDeep(this.concentration, o.concentration, true) && IngredientSubstanceStrengthComponent.compareDeep(this.concentrationHighLimit, o.concentrationHighLimit, true) && IngredientSubstanceStrengthComponent.compareDeep(this.concentrationText, o.concentrationText, true) && IngredientSubstanceStrengthComponent.compareDeep(this.basis, o.basis, true) && IngredientSubstanceStrengthComponent.compareDeep(this.measurementPoint, o.measurementPoint, true) && IngredientSubstanceStrengthComponent.compareDeep(this.country, o.country, true) && IngredientSubstanceStrengthComponent.compareDeep(this.referenceStrength, o.referenceStrength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceStrengthComponent)) {
                return false;
            }
            IngredientSubstanceStrengthComponent o = (IngredientSubstanceStrengthComponent)other_;
            return IngredientSubstanceStrengthComponent.compareValues(this.presentationText, o.presentationText, true) && IngredientSubstanceStrengthComponent.compareValues(this.concentrationText, o.concentrationText, true) && IngredientSubstanceStrengthComponent.compareValues(this.measurementPoint, o.measurementPoint, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.presentation, this.presentationHighLimit, this.presentationText, this.concentration, this.concentrationHighLimit, this.concentrationText, this.basis, this.measurementPoint, this.country, this.referenceStrength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance.strength";
        }
    }

    @Block
    public static class IngredientSubstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code or full resource that represents the ingredient substance", formalDefinition="A code or full resource that represents the ingredient substance.")
        protected CodeableReference code;
        @Child(name="strength", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. When there is a range of strengths, this represents the lower limit", formalDefinition="The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. When there is a range of strengths, this represents the lower limit.")
        protected List<IngredientSubstanceStrengthComponent> strength;
        private static final long serialVersionUID = 538347209L;

        public IngredientSubstanceComponent() {
        }

        public IngredientSubstanceComponent(CodeableReference code) {
            this.setCode(code);
        }

        public CodeableReference getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create IngredientSubstanceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableReference();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public IngredientSubstanceComponent setCode(CodeableReference value) {
            this.code = value;
            return this;
        }

        public List<IngredientSubstanceStrengthComponent> getStrength() {
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            return this.strength;
        }

        public IngredientSubstanceComponent setStrength(List<IngredientSubstanceStrengthComponent> theStrength) {
            this.strength = theStrength;
            return this;
        }

        public boolean hasStrength() {
            if (this.strength == null) {
                return false;
            }
            for (IngredientSubstanceStrengthComponent item : this.strength) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IngredientSubstanceStrengthComponent addStrength() {
            IngredientSubstanceStrengthComponent t = new IngredientSubstanceStrengthComponent();
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return t;
        }

        public IngredientSubstanceComponent addStrength(IngredientSubstanceStrengthComponent t) {
            if (t == null) {
                return this;
            }
            if (this.strength == null) {
                this.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
            }
            this.strength.add(t);
            return this;
        }

        public IngredientSubstanceStrengthComponent getStrengthFirstRep() {
            if (this.getStrength().isEmpty()) {
                this.addStrength();
            }
            return this.getStrength().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableReference(SubstanceDefinition|Substance)", "A code or full resource that represents the ingredient substance.", 0, 1, this.code));
            children.add(new Property("strength", "", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. When there is a range of strengths, this represents the lower limit.", 0, Integer.MAX_VALUE, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableReference(SubstanceDefinition|Substance)", "A code or full resource that represents the ingredient substance.", 0, 1, this.code);
                }
                case 1791316033: {
                    return new Property("strength", "", "The quantity of substance in the unit of presentation, or in the volume (or mass) of the single pharmaceutical product or manufactured item. When there is a range of strengths, this represents the lower limit.", 0, Integer.MAX_VALUE, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    return this.strength == null ? new Base[]{} : this.strength.toArray(new Base[this.strength.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 1791316033: {
                    this.getStrength().add((IngredientSubstanceStrengthComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("strength")) {
                this.getStrength().add((IngredientSubstanceStrengthComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 1791316033: {
                    return this.addStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableReference"};
                }
                case 1791316033: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableReference();
                return this.code;
            }
            if (name.equals("strength")) {
                return this.addStrength();
            }
            return super.addChild(name);
        }

        @Override
        public IngredientSubstanceComponent copy() {
            IngredientSubstanceComponent dst = new IngredientSubstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(IngredientSubstanceComponent dst) {
            super.copyValues(dst);
            CodeableReference codeableReference = dst.code = this.code == null ? null : this.code.copy();
            if (this.strength != null) {
                dst.strength = new ArrayList<IngredientSubstanceStrengthComponent>();
                for (IngredientSubstanceStrengthComponent i : this.strength) {
                    dst.strength.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return IngredientSubstanceComponent.compareDeep(this.code, o.code, true) && IngredientSubstanceComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof IngredientSubstanceComponent)) {
                return false;
            }
            IngredientSubstanceComponent o = (IngredientSubstanceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.strength});
        }

        @Override
        public String fhirType() {
            return "Ingredient.substance";
        }
    }
}

