/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Observation", profile="http://hl7.org/fhir/StructureDefinition/Observation")
public class Observation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for observation", formalDefinition="A unique identifier assigned to this observation.")
    protected List<Identifier> identifier;
    @Child(name="instantiates", type={CanonicalType.class, ObservationDefinition.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR ObservationDefinition", formalDefinition="The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.")
    protected DataType instantiates;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.  For example, a MedicationRequest may require a patient to have laboratory test performed before  it is dispensed.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={MedicationAdministration.class, MedicationDispense.class, MedicationUsage.class, Procedure.class, Immunization.class, ImagingStudy.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular Observation is a component or step.  For example,  an observation as part of a procedure.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | preliminary | final | amended +", formalDefinition="The status of the result value.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    protected Enumeration<Enumerations.ObservationStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Classification of  type of observation", formalDefinition="A code that classifies the general type of observation being made.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"name\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what the observation is about", formalDefinition="The patient, or group of patients, location, device, organization, procedure or practitioner this observation is about and into whose or what record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.")
    protected Reference subject;
    @Child(name="focus", type={Reference.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What the observation is about, when it is not about the subject of record", formalDefinition="The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.")
    protected List<Reference> focus;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Healthcare event during which this observation is made", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class, Timing.class, InstantType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for observation", formalDefinition="The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.")
    protected DataType effective;
    @Child(name="issued", type={InstantType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time this version was made available", formalDefinition="The date and time this version of the observation was made available to providers, typically after the results have been reviewed and verified.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, RelatedPerson.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for the observation", formalDefinition="Who was responsible for asserting the observed value as \"true\".")
    protected List<Reference> performer;
    @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Range.class, Ratio.class, SampledData.class, TimeType.class, DateTimeType.class, Period.class, Attachment.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Actual result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
    protected DataType value;
    @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why the result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/data-absent-reason")
    protected CodeableConcept dataAbsentReason;
    @Child(name="interpretation", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="High, low, normal, etc.", formalDefinition="A categorical assessment of an observation value.  For example, high, low, normal.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
    protected List<CodeableConcept> interpretation;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the observation", formalDefinition="Comments about the observation or the results.")
    protected List<Annotation> note;
    @Child(name="bodySite", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Observed body part", formalDefinition="Indicates the site on the subject's body where the observation was made (i.e. the target site).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="method", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How it was done", formalDefinition="Indicates the mechanism used to perform the observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    protected CodeableConcept method;
    @Child(name="specimen", type={Specimen.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen used for this observation", formalDefinition="The specimen that was used when this observation was made.")
    protected Reference specimen;
    @Child(name="device", type={Device.class, DeviceMetric.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(Measurement) Device", formalDefinition="The device used to generate the observation data.")
    protected Reference device;
    @Child(name="referenceRange", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Provides guide for interpretation", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.  Multiple reference ranges are interpreted as an \"OR\".   In other words, to represent two distinct target populations, two `referenceRange` elements would be used.")
    protected List<ObservationReferenceRangeComponent> referenceRange;
    @Child(name="hasMember", type={Observation.class, QuestionnaireResponse.class, MolecularSequence.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Related resource that belongs to the Observation group", formalDefinition="This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.")
    protected List<Reference> hasMember;
    @Child(name="derivedFrom", type={DocumentReference.class, ImagingStudy.class, QuestionnaireResponse.class, Observation.class, MolecularSequence.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Related measurements the observation is made from", formalDefinition="The target resource that represents a measurement from which this observation value is derived. For example, a calculated anion gap or a fetal measurement based on an ultrasound image.")
    protected List<Reference> derivedFrom;
    @Child(name="component", type={}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Component results", formalDefinition="Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.")
    protected List<ObservationComponentComponent> component;
    private static final long serialVersionUID = 1002725127L;
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Observation:patient").toLocked();
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Observation:encounter").toLocked();
    @SearchParamDefinition(name="based-on", path="Observation.basedOn", description="Reference to the service request.", type="reference", target={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Observation:based-on").toLocked();
    @SearchParamDefinition(name="category", path="Observation.category", description="The classification of the type of observation", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="combo-code", path="Observation.code | Observation.component.code", description="The code of the observation type or component type", type="token")
    public static final String SP_COMBO_CODE = "combo-code";
    public static final TokenClientParam COMBO_CODE = new TokenClientParam("combo-code");
    @SearchParamDefinition(name="combo-data-absent-reason", path="Observation.dataAbsentReason | Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] or Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMBO_DATA_ABSENT_REASON = "combo-data-absent-reason";
    public static final TokenClientParam COMBO_DATA_ABSENT_REASON = new TokenClientParam("combo-data-absent-reason");
    @SearchParamDefinition(name="combo-value-concept", path="(Observation.value as CodeableConcept) | (Observation.component.value as CodeableConcept)", description="The value or component value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMBO_VALUE_CONCEPT = "combo-value-concept";
    public static final TokenClientParam COMBO_VALUE_CONCEPT = new TokenClientParam("combo-value-concept");
    @SearchParamDefinition(name="combo-value-quantity", path="(Observation.value as Quantity) | (Observation.value as SampledData) | (Observation.component.value as Quantity) | (Observation.component.value as SampledData)", description="The value or component value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMBO_VALUE_QUANTITY = "combo-value-quantity";
    public static final QuantityClientParam COMBO_VALUE_QUANTITY = new QuantityClientParam("combo-value-quantity");
    @SearchParamDefinition(name="component-code", path="Observation.component.code", description="The component code of the observation type", type="token")
    public static final String SP_COMPONENT_CODE = "component-code";
    public static final TokenClientParam COMPONENT_CODE = new TokenClientParam("component-code");
    @SearchParamDefinition(name="component-data-absent-reason", path="Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMPONENT_DATA_ABSENT_REASON = "component-data-absent-reason";
    public static final TokenClientParam COMPONENT_DATA_ABSENT_REASON = new TokenClientParam("component-data-absent-reason");
    @SearchParamDefinition(name="component-value-concept", path="(Observation.component.value as CodeableConcept)", description="The value of the component observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMPONENT_VALUE_CONCEPT = "component-value-concept";
    public static final TokenClientParam COMPONENT_VALUE_CONCEPT = new TokenClientParam("component-value-concept");
    @SearchParamDefinition(name="component-value-quantity", path="(Observation.component.value as Quantity) | (Observation.component.value as SampledData)", description="The value of the component observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMPONENT_VALUE_QUANTITY = "component-value-quantity";
    public static final QuantityClientParam COMPONENT_VALUE_QUANTITY = new QuantityClientParam("component-value-quantity");
    @SearchParamDefinition(name="data-absent-reason", path="Observation.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] is missing.", type="token")
    public static final String SP_DATA_ABSENT_REASON = "data-absent-reason";
    public static final TokenClientParam DATA_ABSENT_REASON = new TokenClientParam("data-absent-reason");
    @SearchParamDefinition(name="derived-from", path="Observation.derivedFrom", description="Related measurements the observation is made from", type="reference", target={DocumentReference.class, ImagingStudy.class, MolecularSequence.class, Observation.class, QuestionnaireResponse.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("Observation:derived-from").toLocked();
    @SearchParamDefinition(name="device", path="Observation.device", description="The Device that generated the observation data.", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device")}, target={Device.class, DeviceMetric.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("Observation:device").toLocked();
    @SearchParamDefinition(name="focus", path="Observation.focus", description="The focus of an observation when the focus is not the patient of record.", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("Observation:focus").toLocked();
    @SearchParamDefinition(name="has-member", path="Observation.hasMember", description="Related resource that belongs to the Observation group", type="reference", target={MolecularSequence.class, Observation.class, QuestionnaireResponse.class})
    public static final String SP_HAS_MEMBER = "has-member";
    public static final ReferenceClientParam HAS_MEMBER = new ReferenceClientParam("has-member");
    public static final Include INCLUDE_HAS_MEMBER = new Include("Observation:has-member").toLocked();
    @SearchParamDefinition(name="method", path="Observation.method", description="The method used for the observation", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");
    @SearchParamDefinition(name="part-of", path="Observation.partOf", description="Part of referenced event", type="reference", target={ImagingStudy.class, Immunization.class, MedicationAdministration.class, MedicationDispense.class, MedicationUsage.class, Procedure.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Observation:part-of").toLocked();
    @SearchParamDefinition(name="performer", path="Observation.performer", description="Who performed the observation", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("Observation:performer").toLocked();
    @SearchParamDefinition(name="specimen", path="Observation.specimen", description="Specimen used for this observation", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("Observation:specimen").toLocked();
    @SearchParamDefinition(name="status", path="Observation.status", description="The status of the observation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Observation.subject", description="The subject that the observation is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Observation:subject").toLocked();
    @SearchParamDefinition(name="value-concept", path="(Observation.value as CodeableConcept)", description="The value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_VALUE_CONCEPT = "value-concept";
    public static final TokenClientParam VALUE_CONCEPT = new TokenClientParam("value-concept");
    @SearchParamDefinition(name="value-date", path="(Observation.value as dateTime) | (Observation.value as Period)", description="The value of the observation, if the value is a date or period of time", type="date")
    public static final String SP_VALUE_DATE = "value-date";
    public static final DateClientParam VALUE_DATE = new DateClientParam("value-date");
    @SearchParamDefinition(name="value-quantity", path="(Observation.value as Quantity) | (Observation.value as SampledData)", description="The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_VALUE_QUANTITY = "value-quantity";
    public static final QuantityClientParam VALUE_QUANTITY = new QuantityClientParam("value-quantity");
    @SearchParamDefinition(name="value-string", path="(Observation.value as string) | (Observation.value as CodeableConcept).text", description="The value of the observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_VALUE_STRING = "value-string";
    public static final StringClientParam VALUE_STRING = new StringClientParam("value-string");
    @SearchParamDefinition(name="code-value-concept", path="Observation", description="Code and coded value parameter pair", type="composite", compositeOf={"code", "value-concept"})
    public static final String SP_CODE_VALUE_CONCEPT = "code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CODE_VALUE_CONCEPT = new CompositeClientParam("code-value-concept");
    @SearchParamDefinition(name="code-value-date", path="Observation", description="Code and date/time value parameter pair", type="composite", compositeOf={"code", "value-date"})
    public static final String SP_CODE_VALUE_DATE = "code-value-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> CODE_VALUE_DATE = new CompositeClientParam("code-value-date");
    @SearchParamDefinition(name="code-value-quantity", path="Observation", description="Code and quantity value parameter pair", type="composite", compositeOf={"code", "value-quantity"})
    public static final String SP_CODE_VALUE_QUANTITY = "code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CODE_VALUE_QUANTITY = new CompositeClientParam("code-value-quantity");
    @SearchParamDefinition(name="code-value-string", path="Observation", description="Code and string value parameter pair", type="composite", compositeOf={"code", "value-string"})
    public static final String SP_CODE_VALUE_STRING = "code-value-string";
    public static final CompositeClientParam<TokenClientParam, StringClientParam> CODE_VALUE_STRING = new CompositeClientParam("code-value-string");
    @SearchParamDefinition(name="combo-code-value-concept", path="Observation | Observation.component", description="Code and coded value parameter pair, including in components", type="composite", compositeOf={"combo-code", "combo-value-concept"})
    public static final String SP_COMBO_CODE_VALUE_CONCEPT = "combo-code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> COMBO_CODE_VALUE_CONCEPT = new CompositeClientParam("combo-code-value-concept");
    @SearchParamDefinition(name="combo-code-value-quantity", path="Observation | Observation.component", description="Code and quantity value parameter pair, including in components", type="composite", compositeOf={"combo-code", "combo-value-quantity"})
    public static final String SP_COMBO_CODE_VALUE_QUANTITY = "combo-code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> COMBO_CODE_VALUE_QUANTITY = new CompositeClientParam("combo-code-value-quantity");
    @SearchParamDefinition(name="component-code-value-concept", path="Observation.component", description="Component code and component coded value parameter pair", type="composite", compositeOf={"component-code", "component-value-concept"})
    public static final String SP_COMPONENT_CODE_VALUE_CONCEPT = "component-code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> COMPONENT_CODE_VALUE_CONCEPT = new CompositeClientParam("component-code-value-concept");
    @SearchParamDefinition(name="component-code-value-quantity", path="Observation.component", description="Component code and component quantity value parameter pair", type="composite", compositeOf={"component-code", "component-value-quantity"})
    public static final String SP_COMPONENT_CODE_VALUE_QUANTITY = "component-code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> COMPONENT_CODE_VALUE_QUANTITY = new CompositeClientParam("component-code-value-quantity");

    public Observation() {
    }

    public Observation(Enumerations.ObservationStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Observation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Observation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DataType getInstantiates() {
        return this.instantiates;
    }

    public CanonicalType getInstantiatesCanonicalType() throws FHIRException {
        if (this.instantiates == null) {
            this.instantiates = new CanonicalType();
        }
        if (!(this.instantiates instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.instantiates.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.instantiates;
    }

    public boolean hasInstantiatesCanonicalType() {
        return this != null && this.instantiates instanceof CanonicalType;
    }

    public Reference getInstantiatesReference() throws FHIRException {
        if (this.instantiates == null) {
            this.instantiates = new Reference();
        }
        if (!(this.instantiates instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.instantiates.getClass().getName() + " was encountered");
        }
        return (Reference)this.instantiates;
    }

    public boolean hasInstantiatesReference() {
        return this != null && this.instantiates instanceof Reference;
    }

    public boolean hasInstantiates() {
        return this.instantiates != null && !this.instantiates.isEmpty();
    }

    public Observation setInstantiates(DataType value) {
        if (value != null && !(value instanceof CanonicalType) && !(value instanceof Reference)) {
            throw new Error("Not the right type for Observation.instantiates[x]: " + value.fhirType());
        }
        this.instantiates = value;
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Observation setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Observation addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Observation setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Observation addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<Enumerations.ObservationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Observation setStatusElement(Enumeration<Enumerations.ObservationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ObservationStatus getStatus() {
        return this.status == null ? null : (Enumerations.ObservationStatus)((Object)this.status.getValue());
    }

    public Observation setStatus(Enumerations.ObservationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Observation setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Observation addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Observation setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Observation setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        return this.focus;
    }

    public Observation setFocus(List<Reference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (Reference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFocus() {
        Reference t = new Reference();
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return t;
    }

    public Observation addFocus(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return this;
    }

    public Reference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Observation setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public Timing getEffectiveTiming() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Timing();
        }
        if (!(this.effective instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Timing)this.effective;
    }

    public boolean hasEffectiveTiming() {
        return this != null && this.effective instanceof Timing;
    }

    public InstantType getEffectiveInstantType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new InstantType();
        }
        if (!(this.effective instanceof InstantType)) {
            throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (InstantType)this.effective;
    }

    public boolean hasEffectiveInstantType() {
        return this != null && this.effective instanceof InstantType;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public Observation setEffective(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing || value instanceof InstantType)) {
            throw new Error("Not the right type for Observation.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Observation setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Observation setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Observation setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public Observation addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public DataType getValue() {
        return this.value;
    }

    public Quantity getValueQuantity() throws FHIRException {
        if (this.value == null) {
            this.value = new Quantity();
        }
        if (!(this.value instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Quantity)this.value;
    }

    public boolean hasValueQuantity() {
        return this != null && this.value instanceof Quantity;
    }

    public CodeableConcept getValueCodeableConcept() throws FHIRException {
        if (this.value == null) {
            this.value = new CodeableConcept();
        }
        if (!(this.value instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.value;
    }

    public boolean hasValueCodeableConcept() {
        return this != null && this.value instanceof CodeableConcept;
    }

    public StringType getValueStringType() throws FHIRException {
        if (this.value == null) {
            this.value = new StringType();
        }
        if (!(this.value instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (StringType)this.value;
    }

    public boolean hasValueStringType() {
        return this != null && this.value instanceof StringType;
    }

    public BooleanType getValueBooleanType() throws FHIRException {
        if (this.value == null) {
            this.value = new BooleanType();
        }
        if (!(this.value instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.value;
    }

    public boolean hasValueBooleanType() {
        return this != null && this.value instanceof BooleanType;
    }

    public IntegerType getValueIntegerType() throws FHIRException {
        if (this.value == null) {
            this.value = new IntegerType();
        }
        if (!(this.value instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.value;
    }

    public boolean hasValueIntegerType() {
        return this != null && this.value instanceof IntegerType;
    }

    public Range getValueRange() throws FHIRException {
        if (this.value == null) {
            this.value = new Range();
        }
        if (!(this.value instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Range)this.value;
    }

    public boolean hasValueRange() {
        return this != null && this.value instanceof Range;
    }

    public Ratio getValueRatio() throws FHIRException {
        if (this.value == null) {
            this.value = new Ratio();
        }
        if (!(this.value instanceof Ratio)) {
            throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Ratio)this.value;
    }

    public boolean hasValueRatio() {
        return this != null && this.value instanceof Ratio;
    }

    public SampledData getValueSampledData() throws FHIRException {
        if (this.value == null) {
            this.value = new SampledData();
        }
        if (!(this.value instanceof SampledData)) {
            throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (SampledData)this.value;
    }

    public boolean hasValueSampledData() {
        return this != null && this.value instanceof SampledData;
    }

    public TimeType getValueTimeType() throws FHIRException {
        if (this.value == null) {
            this.value = new TimeType();
        }
        if (!(this.value instanceof TimeType)) {
            throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (TimeType)this.value;
    }

    public boolean hasValueTimeType() {
        return this != null && this.value instanceof TimeType;
    }

    public DateTimeType getValueDateTimeType() throws FHIRException {
        if (this.value == null) {
            this.value = new DateTimeType();
        }
        if (!(this.value instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.value;
    }

    public boolean hasValueDateTimeType() {
        return this != null && this.value instanceof DateTimeType;
    }

    public Period getValuePeriod() throws FHIRException {
        if (this.value == null) {
            this.value = new Period();
        }
        if (!(this.value instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Period)this.value;
    }

    public boolean hasValuePeriod() {
        return this != null && this.value instanceof Period;
    }

    public Attachment getValueAttachment() throws FHIRException {
        if (this.value == null) {
            this.value = new Attachment();
        }
        if (!(this.value instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Attachment)this.value;
    }

    public boolean hasValueAttachment() {
        return this != null && this.value instanceof Attachment;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public Observation setValue(DataType value) {
        if (!(value == null || value instanceof Quantity || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Range || value instanceof Ratio || value instanceof SampledData || value instanceof TimeType || value instanceof DateTimeType || value instanceof Period || value instanceof Attachment)) {
            throw new Error("Not the right type for Observation.value[x]: " + value.fhirType());
        }
        this.value = value;
        return this;
    }

    public CodeableConcept getDataAbsentReason() {
        if (this.dataAbsentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.dataAbsentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.dataAbsentReason = new CodeableConcept();
            }
        }
        return this.dataAbsentReason;
    }

    public boolean hasDataAbsentReason() {
        return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
    }

    public Observation setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
        return this;
    }

    public List<CodeableConcept> getInterpretation() {
        if (this.interpretation == null) {
            this.interpretation = new ArrayList<CodeableConcept>();
        }
        return this.interpretation;
    }

    public Observation setInterpretation(List<CodeableConcept> theInterpretation) {
        this.interpretation = theInterpretation;
        return this;
    }

    public boolean hasInterpretation() {
        if (this.interpretation == null) {
            return false;
        }
        for (CodeableConcept item : this.interpretation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addInterpretation() {
        CodeableConcept t = new CodeableConcept();
        if (this.interpretation == null) {
            this.interpretation = new ArrayList<CodeableConcept>();
        }
        this.interpretation.add(t);
        return t;
    }

    public Observation addInterpretation(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.interpretation == null) {
            this.interpretation = new ArrayList<CodeableConcept>();
        }
        this.interpretation.add(t);
        return this;
    }

    public CodeableConcept getInterpretationFirstRep() {
        if (this.getInterpretation().isEmpty()) {
            this.addInterpretation();
        }
        return this.getInterpretation().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Observation setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Observation addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public Observation setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public Observation setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public Observation setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Observation.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Observation setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public List<ObservationReferenceRangeComponent> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        return this.referenceRange;
    }

    public Observation setReferenceRange(List<ObservationReferenceRangeComponent> theReferenceRange) {
        this.referenceRange = theReferenceRange;
        return this;
    }

    public boolean hasReferenceRange() {
        if (this.referenceRange == null) {
            return false;
        }
        for (ObservationReferenceRangeComponent item : this.referenceRange) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationReferenceRangeComponent addReferenceRange() {
        ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return t;
    }

    public Observation addReferenceRange(ObservationReferenceRangeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        }
        this.referenceRange.add(t);
        return this;
    }

    public ObservationReferenceRangeComponent getReferenceRangeFirstRep() {
        if (this.getReferenceRange().isEmpty()) {
            this.addReferenceRange();
        }
        return this.getReferenceRange().get(0);
    }

    public List<Reference> getHasMember() {
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        return this.hasMember;
    }

    public Observation setHasMember(List<Reference> theHasMember) {
        this.hasMember = theHasMember;
        return this;
    }

    public boolean hasHasMember() {
        if (this.hasMember == null) {
            return false;
        }
        for (Reference item : this.hasMember) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHasMember() {
        Reference t = new Reference();
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        this.hasMember.add(t);
        return t;
    }

    public Observation addHasMember(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.hasMember == null) {
            this.hasMember = new ArrayList<Reference>();
        }
        this.hasMember.add(t);
        return this;
    }

    public Reference getHasMemberFirstRep() {
        if (this.getHasMember().isEmpty()) {
            this.addHasMember();
        }
        return this.getHasMember().get(0);
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public Observation setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public Observation addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<ObservationComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        return this.component;
    }

    public Observation setComponent(List<ObservationComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (ObservationComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationComponentComponent addComponent() {
        ObservationComponentComponent t = new ObservationComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public Observation addComponent(ObservationComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public ObservationComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this observation.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiates[x]", "canonical(ObservationDefinition)|Reference(ObservationDefinition)", "The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.", 0, 1, this.instantiates));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.  For example, a MedicationRequest may require a patient to have laboratory test performed before  it is dispensed.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(MedicationAdministration|MedicationDispense|MedicationUsage|Procedure|Immunization|ImagingStudy)", "A larger event of which this particular Observation is a component or step.  For example,  an observation as part of a procedure.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of the result value.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation being made.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"name\".", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance)", "The patient, or group of patients, location, device, organization, procedure or practitioner this observation is about and into whose or what record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.", 0, 1, this.subject));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period|Timing|instant", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective));
        children.add(new Property("issued", "instant", "The date and time this version of the observation was made available to providers, typically after the results have been reviewed and verified.", 0, 1, this.issued));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|RelatedPerson)", "Who was responsible for asserting the observed value as \"true\".", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value));
        children.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, 1, this.dataAbsentReason));
        children.add(new Property("interpretation", "CodeableConcept", "A categorical assessment of an observation value.  For example, high, low, normal.", 0, Integer.MAX_VALUE, this.interpretation));
        children.add(new Property("note", "Annotation", "Comments about the observation or the results.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, 1, this.bodySite));
        children.add(new Property(SP_METHOD, "CodeableConcept", "Indicates the mechanism used to perform the observation.", 0, 1, this.method));
        children.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "The specimen that was used when this observation was made.", 0, 1, this.specimen));
        children.add(new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to generate the observation data.", 0, 1, this.device));
        children.add(new Property("referenceRange", "", "Guidance on how to interpret the value by comparison to a normal or recommended range.  Multiple reference ranges are interpreted as an \"OR\".   In other words, to represent two distinct target populations, two `referenceRange` elements would be used.", 0, Integer.MAX_VALUE, this.referenceRange));
        children.add(new Property("hasMember", "Reference(Observation|QuestionnaireResponse|MolecularSequence)", "This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.", 0, Integer.MAX_VALUE, this.hasMember));
        children.add(new Property("derivedFrom", "Reference(DocumentReference|ImagingStudy|QuestionnaireResponse|Observation|MolecularSequence)", "The target resource that represents a measurement from which this observation value is derived. For example, a calculated anion gap or a fetal measurement based on an ultrasound image.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("component", "", "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this observation.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1926387433: {
                return new Property("instantiates[x]", "canonical(ObservationDefinition)|Reference(ObservationDefinition)", "The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.", 0, 1, this.instantiates);
            }
            case -246883639: {
                return new Property("instantiates[x]", "canonical(ObservationDefinition)|Reference(ObservationDefinition)", "The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.", 0, 1, this.instantiates);
            }
            case 8911915: {
                return new Property("instantiates[x]", "canonical(ObservationDefinition)", "The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.", 0, 1, this.instantiates);
            }
            case -1744595326: {
                return new Property("instantiates[x]", "Reference(ObservationDefinition)", "The reference to a FHIR ObservationDefinition resource that provides the definition that is adhered to in whole or in part by this Observation instance.", 0, 1, this.instantiates);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.  For example, a MedicationRequest may require a patient to have laboratory test performed before  it is dispensed.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(MedicationAdministration|MedicationDispense|MedicationUsage|Procedure|Immunization|ImagingStudy)", "A larger event of which this particular Observation is a component or step.  For example,  an observation as part of a procedure.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of the result value.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of observation being made.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"name\".", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance)", "The patient, or group of patients, location, device, organization, procedure or practitioner this observation is about and into whose or what record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.", 0, 1, this.subject);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.", 0, Integer.MAX_VALUE, this.focus);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period|Timing|instant", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period|Timing|instant", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -285872943: {
                return new Property("effective[x]", "Timing", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1295730118: {
                return new Property("effective[x]", "instant", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1179159893: {
                return new Property("issued", "instant", "The date and time this version of the observation was made available to providers, typically after the results have been reviewed and verified.", 0, 1, this.issued);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|RelatedPerson)", "Who was responsible for asserting the observed value as \"true\".", 0, Integer.MAX_VALUE, this.performer);
            }
            case -1410166417: {
                return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 111972721: {
                return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -2029823716: {
                return new Property("value[x]", "Quantity", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 924902896: {
                return new Property("value[x]", "CodeableConcept", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -1424603934: {
                return new Property("value[x]", "string", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 733421943: {
                return new Property("value[x]", "boolean", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -1668204915: {
                return new Property("value[x]", "integer", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 2030761548: {
                return new Property("value[x]", "Range", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 2030767386: {
                return new Property("value[x]", "Ratio", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -962229101: {
                return new Property("value[x]", "SampledData", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -765708322: {
                return new Property("value[x]", "time", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 1047929900: {
                return new Property("value[x]", "dateTime", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -1524344174: {
                return new Property("value[x]", "Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case -475566732: {
                return new Property("value[x]", "Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
            }
            case 1034315687: {
                return new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.value[x] is missing.", 0, 1, this.dataAbsentReason);
            }
            case -297950712: {
                return new Property("interpretation", "CodeableConcept", "A categorical assessment of an observation value.  For example, high, low, normal.", 0, Integer.MAX_VALUE, this.interpretation);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments about the observation or the results.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, 1, this.bodySite);
            }
            case -1077554975: {
                return new Property(SP_METHOD, "CodeableConcept", "Indicates the mechanism used to perform the observation.", 0, 1, this.method);
            }
            case -2132868344: {
                return new Property(SP_SPECIMEN, "Reference(Specimen)", "The specimen that was used when this observation was made.", 0, 1, this.specimen);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device|DeviceMetric)", "The device used to generate the observation data.", 0, 1, this.device);
            }
            case -1912545102: {
                return new Property("referenceRange", "", "Guidance on how to interpret the value by comparison to a normal or recommended range.  Multiple reference ranges are interpreted as an \"OR\".   In other words, to represent two distinct target populations, two `referenceRange` elements would be used.", 0, Integer.MAX_VALUE, this.referenceRange);
            }
            case -458019372: {
                return new Property("hasMember", "Reference(Observation|QuestionnaireResponse|MolecularSequence)", "This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.", 0, Integer.MAX_VALUE, this.hasMember);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(DocumentReference|ImagingStudy|QuestionnaireResponse|Observation|MolecularSequence)", "The target resource that represents a measurement from which this observation value is derived. For example, a calculated anion gap or a fetal measurement based on an ultrasound image.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -1399907075: {
                return new Property("component", "", "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.", 0, Integer.MAX_VALUE, this.component);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -246883639: {
                Base[] baseArray;
                if (this.instantiates == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.instantiates;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.effective;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.value;
                }
                return baseArray;
            }
            case 1034315687: {
                Base[] baseArray;
                if (this.dataAbsentReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.dataAbsentReason;
                }
                return baseArray;
            }
            case -297950712: {
                return this.interpretation == null ? new Base[]{} : this.interpretation.toArray(new Base[this.interpretation.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.bodySite;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.method;
                }
                return baseArray;
            }
            case -2132868344: {
                Base[] baseArray;
                if (this.specimen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.specimen;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.device;
                }
                return baseArray;
            }
            case -1912545102: {
                return this.referenceRange == null ? new Base[]{} : this.referenceRange.toArray(new Base[this.referenceRange.size()]);
            }
            case -458019372: {
                return this.hasMember == null ? new Base[]{} : this.hasMember.toArray(new Base[this.hasMember.size()]);
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -246883639: {
                this.instantiates = TypeConvertor.castToType(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.ObservationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 97604824: {
                this.getFocus().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = TypeConvertor.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToType(value);
                return value;
            }
            case 1034315687: {
                this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -297950712: {
                this.getInterpretation().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1077554975: {
                this.method = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -2132868344: {
                this.specimen = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToReference(value);
                return value;
            }
            case -1912545102: {
                this.getReferenceRange().add((ObservationReferenceRangeComponent)((Object)value));
                return value;
            }
            case -458019372: {
                this.getHasMember().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((ObservationComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiates[x]")) {
            this.instantiates = TypeConvertor.castToType(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.ObservationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals("issued")) {
            this.issued = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("value[x]")) {
            this.value = TypeConvertor.castToType(value);
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("interpretation")) {
            this.getInterpretation().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_METHOD)) {
            this.method = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SPECIMEN)) {
            this.specimen = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = TypeConvertor.castToReference(value);
        } else if (name.equals("referenceRange")) {
            this.getReferenceRange().add((ObservationReferenceRangeComponent)((Object)value));
        } else if (name.equals("hasMember")) {
            this.getHasMember().add(TypeConvertor.castToReference(value));
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("component")) {
            this.getComponent().add((ObservationComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1926387433: {
                return this.getInstantiates();
            }
            case -246883639: {
                return this.getInstantiates();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 97604824: {
                return this.addFocus();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -1410166417: {
                return this.getValue();
            }
            case 111972721: {
                return this.getValue();
            }
            case 1034315687: {
                return this.getDataAbsentReason();
            }
            case -297950712: {
                return this.addInterpretation();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -2132868344: {
                return this.getSpecimen();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1912545102: {
                return this.addReferenceRange();
            }
            case -458019372: {
                return this.addHasMember();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -246883639: {
                return new String[]{"canonical", "Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period", "Timing", "instant"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 111972721: {
                return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "integer", "Range", "Ratio", "SampledData", "time", "dateTime", "Period", "Attachment"};
            }
            case 1034315687: {
                return new String[]{"CodeableConcept"};
            }
            case -297950712: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1912545102: {
                return new String[0];
            }
            case -458019372: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            this.instantiates = new CanonicalType();
            return this.instantiates;
        }
        if (name.equals("instantiatesReference")) {
            this.instantiates = new Reference();
            return this.instantiates;
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("effectiveTiming")) {
            this.effective = new Timing();
            return this.effective;
        }
        if (name.equals("effectiveInstant")) {
            this.effective = new InstantType();
            return this.effective;
        }
        if (name.equals("issued")) {
            throw new FHIRException("Cannot call addChild on a primitive type Observation.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueString")) {
            this.value = new StringType();
            return this.value;
        }
        if (name.equals("valueBoolean")) {
            this.value = new BooleanType();
            return this.value;
        }
        if (name.equals("valueInteger")) {
            this.value = new IntegerType();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valueRatio")) {
            this.value = new Ratio();
            return this.value;
        }
        if (name.equals("valueSampledData")) {
            this.value = new SampledData();
            return this.value;
        }
        if (name.equals("valueTime")) {
            this.value = new TimeType();
            return this.value;
        }
        if (name.equals("valueDateTime")) {
            this.value = new DateTimeType();
            return this.value;
        }
        if (name.equals("valuePeriod")) {
            this.value = new Period();
            return this.value;
        }
        if (name.equals("valueAttachment")) {
            this.value = new Attachment();
            return this.value;
        }
        if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = new CodeableConcept();
            return this.dataAbsentReason;
        }
        if (name.equals("interpretation")) {
            return this.addInterpretation();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals(SP_METHOD)) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals(SP_SPECIMEN)) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("referenceRange")) {
            return this.addReferenceRange();
        }
        if (name.equals("hasMember")) {
            return this.addHasMember();
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("component")) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Observation";
    }

    @Override
    public Observation copy() {
        Observation dst = new Observation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Observation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        DataType dataType = dst.instantiates = this.instantiates == null ? null : this.instantiates.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<Enumerations.ObservationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<Reference>();
            for (Reference reference2 : this.focus) {
                dst.focus.add(reference2.copy());
            }
        }
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference3 : this.performer) {
                dst.performer.add(reference3.copy());
            }
        }
        dst.value = this.value == null ? null : this.value.copy();
        CodeableConcept codeableConcept = dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
        if (this.interpretation != null) {
            dst.interpretation = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.interpretation) {
                dst.interpretation.add(codeableConcept2.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        Reference reference4 = dst.device = this.device == null ? null : this.device.copy();
        if (this.referenceRange != null) {
            dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            for (ObservationReferenceRangeComponent observationReferenceRangeComponent : this.referenceRange) {
                dst.referenceRange.add(observationReferenceRangeComponent.copy());
            }
        }
        if (this.hasMember != null) {
            dst.hasMember = new ArrayList<Reference>();
            for (Reference reference5 : this.hasMember) {
                dst.hasMember.add(reference5.copy());
            }
        }
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference6 : this.derivedFrom) {
                dst.derivedFrom.add(reference6.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<ObservationComponentComponent>();
            for (ObservationComponentComponent observationComponentComponent : this.component) {
                dst.component.add(observationComponentComponent.copy());
            }
        }
    }

    protected Observation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other_;
        return Observation.compareDeep(this.identifier, o.identifier, true) && Observation.compareDeep(this.instantiates, o.instantiates, true) && Observation.compareDeep(this.basedOn, o.basedOn, true) && Observation.compareDeep(this.partOf, o.partOf, true) && Observation.compareDeep(this.status, o.status, true) && Observation.compareDeep(this.category, o.category, true) && Observation.compareDeep(this.code, o.code, true) && Observation.compareDeep(this.subject, o.subject, true) && Observation.compareDeep(this.focus, o.focus, true) && Observation.compareDeep(this.encounter, o.encounter, true) && Observation.compareDeep(this.effective, o.effective, true) && Observation.compareDeep(this.issued, o.issued, true) && Observation.compareDeep(this.performer, o.performer, true) && Observation.compareDeep(this.value, o.value, true) && Observation.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && Observation.compareDeep(this.interpretation, o.interpretation, true) && Observation.compareDeep(this.note, o.note, true) && Observation.compareDeep(this.bodySite, o.bodySite, true) && Observation.compareDeep(this.method, o.method, true) && Observation.compareDeep(this.specimen, o.specimen, true) && Observation.compareDeep(this.device, o.device, true) && Observation.compareDeep(this.referenceRange, o.referenceRange, true) && Observation.compareDeep(this.hasMember, o.hasMember, true) && Observation.compareDeep(this.derivedFrom, o.derivedFrom, true) && Observation.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Observation)) {
            return false;
        }
        Observation o = (Observation)other_;
        return Observation.compareValues(this.status, o.status, true) && Observation.compareValues(this.issued, o.issued, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiates, this.basedOn, this.partOf, this.status, this.category, this.code, this.subject, this.focus, this.encounter, this.effective, this.issued, this.performer, this.value, this.dataAbsentReason, this.interpretation, this.note, this.bodySite, this.method, this.specimen, this.device, this.referenceRange, this.hasMember, this.derivedFrom, this.component});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Observation;
    }

    @Block
    public static class ObservationComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of component observation (code / type)", formalDefinition="Describes what was observed. Sometimes this is called the observation \"code\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Range.class, Ratio.class, SampledData.class, TimeType.class, DateTimeType.class, Period.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual component result", formalDefinition="The information determined as a result of making the observation, if the information has a simple value.")
        protected DataType value;
        @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the component result is missing", formalDefinition="Provides a reason why the expected value in the element Observation.component.value[x] is missing.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/data-absent-reason")
        protected CodeableConcept dataAbsentReason;
        @Child(name="interpretation", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="High, low, normal, etc.", formalDefinition="A categorical assessment of an observation value.  For example, high, low, normal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
        protected List<CodeableConcept> interpretation;
        @Child(name="referenceRange", type={ObservationReferenceRangeComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Provides guide for interpretation of component result", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range.")
        protected List<ObservationReferenceRangeComponent> referenceRange;
        private static final long serialVersionUID = -1771757751L;

        public ObservationComponentComponent() {
        }

        public ObservationComponentComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ObservationComponentComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ObservationComponentComponent setValue(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Range || value instanceof Ratio || value instanceof SampledData || value instanceof TimeType || value instanceof DateTimeType || value instanceof Period || value instanceof Attachment)) {
                throw new Error("Not the right type for Observation.component.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeableConcept getDataAbsentReason() {
            if (this.dataAbsentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationComponentComponent.dataAbsentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataAbsentReason = new CodeableConcept();
                }
            }
            return this.dataAbsentReason;
        }

        public boolean hasDataAbsentReason() {
            return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
        }

        public ObservationComponentComponent setDataAbsentReason(CodeableConcept value) {
            this.dataAbsentReason = value;
            return this;
        }

        public List<CodeableConcept> getInterpretation() {
            if (this.interpretation == null) {
                this.interpretation = new ArrayList<CodeableConcept>();
            }
            return this.interpretation;
        }

        public ObservationComponentComponent setInterpretation(List<CodeableConcept> theInterpretation) {
            this.interpretation = theInterpretation;
            return this;
        }

        public boolean hasInterpretation() {
            if (this.interpretation == null) {
                return false;
            }
            for (CodeableConcept item : this.interpretation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addInterpretation() {
            CodeableConcept t = new CodeableConcept();
            if (this.interpretation == null) {
                this.interpretation = new ArrayList<CodeableConcept>();
            }
            this.interpretation.add(t);
            return t;
        }

        public ObservationComponentComponent addInterpretation(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.interpretation == null) {
                this.interpretation = new ArrayList<CodeableConcept>();
            }
            this.interpretation.add(t);
            return this;
        }

        public CodeableConcept getInterpretationFirstRep() {
            if (this.getInterpretation().isEmpty()) {
                this.addInterpretation();
            }
            return this.getInterpretation().get(0);
        }

        public List<ObservationReferenceRangeComponent> getReferenceRange() {
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            return this.referenceRange;
        }

        public ObservationComponentComponent setReferenceRange(List<ObservationReferenceRangeComponent> theReferenceRange) {
            this.referenceRange = theReferenceRange;
            return this;
        }

        public boolean hasReferenceRange() {
            if (this.referenceRange == null) {
                return false;
            }
            for (ObservationReferenceRangeComponent item : this.referenceRange) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ObservationReferenceRangeComponent addReferenceRange() {
            ObservationReferenceRangeComponent t = new ObservationReferenceRangeComponent();
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return t;
        }

        public ObservationComponentComponent addReferenceRange(ObservationReferenceRangeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.referenceRange == null) {
                this.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
            }
            this.referenceRange.add(t);
            return this;
        }

        public ObservationReferenceRangeComponent getReferenceRangeFirstRep() {
            if (this.getReferenceRange().isEmpty()) {
                this.addReferenceRange();
            }
            return this.getReferenceRange().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Observation.SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"code\".", 0, 1, this.code));
            children.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value));
            children.add(new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.component.value[x] is missing.", 0, 1, this.dataAbsentReason));
            children.add(new Property("interpretation", "CodeableConcept", "A categorical assessment of an observation value.  For example, high, low, normal.", 0, Integer.MAX_VALUE, this.interpretation));
            children.add(new Property("referenceRange", "@Observation.referenceRange", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(Observation.SP_CODE, "CodeableConcept", "Describes what was observed. Sometimes this is called the observation \"code\".", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|SampledData|time|dateTime|Period|Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The information determined as a result of making the observation, if the information has a simple value.", 0, 1, this.value);
                }
                case 1034315687: {
                    return new Property("dataAbsentReason", "CodeableConcept", "Provides a reason why the expected value in the element Observation.component.value[x] is missing.", 0, 1, this.dataAbsentReason);
                }
                case -297950712: {
                    return new Property("interpretation", "CodeableConcept", "A categorical assessment of an observation value.  For example, high, low, normal.", 0, Integer.MAX_VALUE, this.interpretation);
                }
                case -1912545102: {
                    return new Property("referenceRange", "@Observation.referenceRange", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1034315687: {
                    Base[] baseArray;
                    if (this.dataAbsentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataAbsentReason;
                    }
                    return baseArray;
                }
                case -297950712: {
                    return this.interpretation == null ? new Base[]{} : this.interpretation.toArray(new Base[this.interpretation.size()]);
                }
                case -1912545102: {
                    return this.referenceRange == null ? new Base[]{} : this.referenceRange.toArray(new Base[this.referenceRange.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 1034315687: {
                    this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -297950712: {
                    this.getInterpretation().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1912545102: {
                    this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("interpretation")) {
                this.getInterpretation().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("referenceRange")) {
                this.getReferenceRange().add((ObservationReferenceRangeComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 1034315687: {
                    return this.getDataAbsentReason();
                }
                case -297950712: {
                    return this.addInterpretation();
                }
                case -1912545102: {
                    return this.addReferenceRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "integer", "Range", "Ratio", "SampledData", "time", "dateTime", "Period", "Attachment"};
                }
                case 1034315687: {
                    return new String[]{"CodeableConcept"};
                }
                case -297950712: {
                    return new String[]{"CodeableConcept"};
                }
                case -1912545102: {
                    return new String[]{"@Observation.referenceRange"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Observation.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("dataAbsentReason")) {
                this.dataAbsentReason = new CodeableConcept();
                return this.dataAbsentReason;
            }
            if (name.equals("interpretation")) {
                return this.addInterpretation();
            }
            if (name.equals("referenceRange")) {
                return this.addReferenceRange();
            }
            return super.addChild(name);
        }

        @Override
        public ObservationComponentComponent copy() {
            ObservationComponentComponent dst = new ObservationComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ObservationComponentComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            CodeableConcept codeableConcept = dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
            if (this.interpretation != null) {
                dst.interpretation = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.interpretation) {
                    dst.interpretation.add(codeableConcept2.copy());
                }
            }
            if (this.referenceRange != null) {
                dst.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
                for (ObservationReferenceRangeComponent observationReferenceRangeComponent : this.referenceRange) {
                    dst.referenceRange.add(observationReferenceRangeComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other_;
            return ObservationComponentComponent.compareDeep(this.code, o.code, true) && ObservationComponentComponent.compareDeep(this.value, o.value, true) && ObservationComponentComponent.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && ObservationComponentComponent.compareDeep(this.interpretation, o.interpretation, true) && ObservationComponentComponent.compareDeep(this.referenceRange, o.referenceRange, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationComponentComponent)) {
                return false;
            }
            ObservationComponentComponent o = (ObservationComponentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.value, this.dataAbsentReason, this.interpretation, this.referenceRange});
        }

        @Override
        public String fhirType() {
            return "Observation.component";
        }
    }

    @Block
    public static class ObservationReferenceRangeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="low", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Low Range, if relevant", formalDefinition="The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).")
        protected Quantity low;
        @Child(name="high", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="High Range, if relevant", formalDefinition="The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).")
        protected Quantity high;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range qualifier", formalDefinition="Codes to indicate the what part of the targeted reference population it applies to. For example, the normal or therapeutic range.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        protected CodeableConcept type;
        @Child(name="appliesTo", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range population", formalDefinition="Codes to indicate the target population this reference range applies to.  For example, a reference range may be based on the normal population or a particular sex or race.  Multiple `appliesTo`  are interpreted as an \"AND\" of the target populations.  For example, to represent a target population of African American females, both a code of female and a code for African American would be used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        protected List<CodeableConcept> appliesTo;
        @Child(name="age", type={Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable age range, if relevant", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.")
        protected Range age;
        @Child(name="text", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text based reference range in an observation", formalDefinition="Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of \"normals\".")
        protected StringType text;
        private static final long serialVersionUID = -305128879L;

        public Quantity getLow() {
            if (this.low == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.low");
                }
                if (Configuration.doAutoCreate()) {
                    this.low = new Quantity();
                }
            }
            return this.low;
        }

        public boolean hasLow() {
            return this.low != null && !this.low.isEmpty();
        }

        public ObservationReferenceRangeComponent setLow(Quantity value) {
            this.low = value;
            return this;
        }

        public Quantity getHigh() {
            if (this.high == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.high");
                }
                if (Configuration.doAutoCreate()) {
                    this.high = new Quantity();
                }
            }
            return this.high;
        }

        public boolean hasHigh() {
            return this.high != null && !this.high.isEmpty();
        }

        public ObservationReferenceRangeComponent setHigh(Quantity value) {
            this.high = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ObservationReferenceRangeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getAppliesTo() {
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            return this.appliesTo;
        }

        public ObservationReferenceRangeComponent setAppliesTo(List<CodeableConcept> theAppliesTo) {
            this.appliesTo = theAppliesTo;
            return this;
        }

        public boolean hasAppliesTo() {
            if (this.appliesTo == null) {
                return false;
            }
            for (CodeableConcept item : this.appliesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAppliesTo() {
            CodeableConcept t = new CodeableConcept();
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return t;
        }

        public ObservationReferenceRangeComponent addAppliesTo(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return this;
        }

        public CodeableConcept getAppliesToFirstRep() {
            if (this.getAppliesTo().isEmpty()) {
                this.addAppliesTo();
            }
            return this.getAppliesTo().get(0);
        }

        public Range getAge() {
            if (this.age == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.age");
                }
                if (Configuration.doAutoCreate()) {
                    this.age = new Range();
                }
            }
            return this.age;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public ObservationReferenceRangeComponent setAge(Range value) {
            this.age = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationReferenceRangeComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public ObservationReferenceRangeComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public ObservationReferenceRangeComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("low", "Quantity", "The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).", 0, 1, this.low));
            children.add(new Property("high", "Quantity", "The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).", 0, 1, this.high));
            children.add(new Property("type", "CodeableConcept", "Codes to indicate the what part of the targeted reference population it applies to. For example, the normal or therapeutic range.", 0, 1, this.type));
            children.add(new Property("appliesTo", "CodeableConcept", "Codes to indicate the target population this reference range applies to.  For example, a reference range may be based on the normal population or a particular sex or race.  Multiple `appliesTo`  are interpreted as an \"AND\" of the target populations.  For example, to represent a target population of African American females, both a code of female and a code for African American would be used.", 0, Integer.MAX_VALUE, this.appliesTo));
            children.add(new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, 1, this.age));
            children.add(new Property("text", "string", "Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of \"normals\".", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 107348: {
                    return new Property("low", "Quantity", "The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).", 0, 1, this.low);
                }
                case 3202466: {
                    return new Property("high", "Quantity", "The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9). If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).", 0, 1, this.high);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Codes to indicate the what part of the targeted reference population it applies to. For example, the normal or therapeutic range.", 0, 1, this.type);
                }
                case -2089924569: {
                    return new Property("appliesTo", "CodeableConcept", "Codes to indicate the target population this reference range applies to.  For example, a reference range may be based on the normal population or a particular sex or race.  Multiple `appliesTo`  are interpreted as an \"AND\" of the target populations.  For example, to represent a target population of African American females, both a code of female and a code for African American would be used.", 0, Integer.MAX_VALUE, this.appliesTo);
                }
                case 96511: {
                    return new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, 1, this.age);
                }
                case 3556653: {
                    return new Property("text", "string", "Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of \"normals\".", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 107348: {
                    Base[] baseArray;
                    if (this.low == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.low;
                    }
                    return baseArray;
                }
                case 3202466: {
                    Base[] baseArray;
                    if (this.high == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.high;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case -2089924569: {
                    return this.appliesTo == null ? new Base[]{} : this.appliesTo.toArray(new Base[this.appliesTo.size()]);
                }
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.age;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 107348: {
                    this.low = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3202466: {
                    this.high = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2089924569: {
                    this.getAppliesTo().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 96511: {
                    this.age = TypeConvertor.castToRange(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("low")) {
                this.low = TypeConvertor.castToQuantity(value);
            } else if (name.equals("high")) {
                this.high = TypeConvertor.castToQuantity(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("appliesTo")) {
                this.getAppliesTo().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("age")) {
                this.age = TypeConvertor.castToRange(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 107348: {
                    return this.getLow();
                }
                case 3202466: {
                    return this.getHigh();
                }
                case 3575610: {
                    return this.getType();
                }
                case -2089924569: {
                    return this.addAppliesTo();
                }
                case 96511: {
                    return this.getAge();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 107348: {
                    return new String[]{"Quantity"};
                }
                case 3202466: {
                    return new String[]{"Quantity"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2089924569: {
                    return new String[]{"CodeableConcept"};
                }
                case 96511: {
                    return new String[]{"Range"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("low")) {
                this.low = new Quantity();
                return this.low;
            }
            if (name.equals("high")) {
                this.high = new Quantity();
                return this.high;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("appliesTo")) {
                return this.addAppliesTo();
            }
            if (name.equals("age")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Observation.referenceRange.text");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationReferenceRangeComponent copy() {
            ObservationReferenceRangeComponent dst = new ObservationReferenceRangeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ObservationReferenceRangeComponent dst) {
            super.copyValues(dst);
            dst.low = this.low == null ? null : this.low.copy();
            dst.high = this.high == null ? null : this.high.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.appliesTo != null) {
                dst.appliesTo = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.appliesTo) {
                    dst.appliesTo.add(i.copy());
                }
            }
            dst.age = this.age == null ? null : this.age.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other_;
            return ObservationReferenceRangeComponent.compareDeep(this.low, o.low, true) && ObservationReferenceRangeComponent.compareDeep(this.high, o.high, true) && ObservationReferenceRangeComponent.compareDeep(this.type, o.type, true) && ObservationReferenceRangeComponent.compareDeep(this.appliesTo, o.appliesTo, true) && ObservationReferenceRangeComponent.compareDeep(this.age, o.age, true) && ObservationReferenceRangeComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationReferenceRangeComponent)) {
                return false;
            }
            ObservationReferenceRangeComponent o = (ObservationReferenceRangeComponent)other_;
            return ObservationReferenceRangeComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.low, this.high, this.type, this.appliesTo, this.age, this.text});
        }

        @Override
        public String fhirType() {
            return "Observation.referenceRange";
        }
    }
}

