/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ProfileDrivenRenderer
extends ResourceRenderer {
    private Set<String> containedIds = new HashSet<String>();
    private boolean hasExtensions;

    public ProfileDrivenRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    public ProfileDrivenRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource r) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, new DirectWrappers.ResourceWrapperDirect(this.context, r));
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        if (this.context.isAddGeneratedNarrativeHeader()) {
            x.para().b().tx("Generated Narrative");
        }
        try {
            StructureDefinition sd = r.getDefinition();
            if (sd == null) {
                throw new FHIRException("Cannot find definition for " + r.fhirType());
            }
            ElementDefinition ed = sd.getSnapshot().getElement().get(0);
            this.containedIds.clear();
            this.hasExtensions = false;
            this.generateByProfile(r, sd, r.root(), sd.getSnapshot().getElement(), ed, this.context.getProfileUtilities().getChildList(sd, ed), x, r.fhirType(), false, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        return this.hasExtensions;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }

    public void generateResourceSummary(XhtmlNode x, BaseWrappers.ResourceWrapper res, boolean textAlready, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && ((XhtmlNode)div.getChildNodes().get(0)).allChildrenAreText()) {
                    x.getChildNodes().addAll(((XhtmlNode)div.getChildNodes().get(0)).getChildNodes());
                }
            }
            x.tx("Generated Summary: ");
        }
        String path = res.fhirType();
        StructureDefinition profile = this.getContext().getWorker().fetchResource(StructureDefinition.class, path);
        if (profile == null) {
            x.tx("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (BaseWrappers.PropertyWrapper p : res.children()) {
                if (this.ignoreProperty(p)) continue;
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.tx("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.tx(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails, false) || last;
                }
            }
        }
    }

    private boolean ignoreProperty(BaseWrappers.PropertyWrapper p) {
        return Utilities.existsInList((String)p.getName(), (String[])new String[]{"contained"});
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getWorkingCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri") && !t.equals("Url") && !t.equals("Canonical");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, BaseWrappers.PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(BaseWrappers.ResourceWrapper res, BaseWrappers.BaseWrapper ew, ElementDefinition defn, XhtmlNode parent, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else {
            if (e instanceof Extension) {
                return;
            }
            if (e instanceof InstantType) {
                x.addText(((InstantType)e).toHumanDisplay());
            } else if (e instanceof DateTimeType) {
                this.renderDateTime(x, e);
            } else if (e instanceof Base64BinaryType) {
                x.addText(new Base64().encodeAsString(((Base64BinaryType)e).getValue()));
            } else if (e instanceof DateType) {
                x.addText(((DateType)e).toHumanDisplay());
            } else if (e instanceof Enumeration) {
                Object ev = ((Enumeration)e).getValue();
                x.addText(ev == null ? "" : ev.toString());
            } else if (e instanceof BooleanType) {
                x.addText(((Boolean)((BooleanType)e).getValue()).toString());
            } else if (e instanceof CodeableConcept) {
                this.renderCodeableConcept(x, (CodeableConcept)e, showCodeDetails);
            } else if (e instanceof Coding) {
                this.renderCoding(x, (Coding)e, showCodeDetails);
            } else if (e instanceof CodeableReference) {
                this.renderCodeableReference(x, (CodeableReference)e, showCodeDetails);
            } else if (e instanceof Annotation) {
                this.renderAnnotation(x, (Annotation)e);
            } else if (e instanceof Identifier) {
                this.renderIdentifier(x, (Identifier)e);
            } else if (e instanceof IntegerType) {
                if (((IntegerType)e).hasValue()) {
                    x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                } else {
                    x.addText("??");
                }
            } else if (e instanceof Integer64Type) {
                if (((Integer64Type)e).hasValue()) {
                    x.addText(Long.toString((Long)((Integer64Type)e).getValue()));
                } else {
                    x.addText("??");
                }
            } else if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
            } else if (e instanceof HumanName) {
                this.renderHumanName(x, (HumanName)e);
            } else if (e instanceof SampledData) {
                this.renderSampledData(x, (SampledData)e);
            } else if (e instanceof Address) {
                this.renderAddress(x, (Address)e);
            } else if (e instanceof ContactPoint) {
                this.renderContactPoint(x, (ContactPoint)e);
            } else if (e instanceof ContactDetail) {
                ContactDetail cd = (ContactDetail)e;
                if (cd.hasName()) {
                    x.tx(cd.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    this.renderContactPoint(x, c);
                }
            } else if (e instanceof UriType) {
                this.renderUri(x, (UriType)e, defn.getPath(), this.rcontext != null && this.rcontext.getResourceResource() != null ? this.rcontext.getResourceResource().getId() : null);
            } else if (e instanceof Timing) {
                this.renderTiming(x, (Timing)e);
            } else if (e instanceof Range) {
                this.renderRange(x, (Range)e);
            } else if (e instanceof Quantity) {
                this.renderQuantity(x, (Quantity)e, showCodeDetails);
            } else if (e instanceof Ratio) {
                this.renderQuantity(x, ((Ratio)e).getNumerator(), showCodeDetails);
                x.tx("/");
                this.renderQuantity(x, ((Ratio)e).getDenominator(), showCodeDetails);
            } else if (e instanceof Period) {
                Period p = (Period)e;
                this.renderPeriod(x, p);
            } else if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.getReference() != null && r.getReference().contains("#")) {
                    if (this.containedIds.contains(r.getReference().substring(1))) {
                        x.ah(r.getReference()).tx("See " + r.getReference());
                    } else {
                        BaseWrappers.ResourceWrapper rw = null;
                        for (BaseWrappers.ResourceWrapper t : res.getContained()) {
                            if (!r.getReference().substring(1).equals(t.getId())) continue;
                            rw = t;
                        }
                        if (rw == null) {
                            this.renderReference(res, x, r);
                        } else {
                            x.an(rw.getId());
                            ResourceRenderer rr = RendererFactory.factory(rw, this.context.copy().setAddGeneratedNarrativeHeader(false));
                            rr.render(parent.blockquote(), rw);
                        }
                    }
                } else {
                    this.renderReference(res, x, r);
                }
            } else {
                if (e instanceof Resource) {
                    return;
                }
                if (e instanceof DataRequirement) {
                    DataRequirement p = (DataRequirement)e;
                    this.renderDataRequirement(x, p);
                } else if (e instanceof PrimitiveType) {
                    x.tx(((PrimitiveType)e).primitiveValue());
                } else if (e instanceof ElementDefinition) {
                    x.tx("todo-bundle");
                } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                    throw new NotImplementedException("type " + e.getClass().getName() + " not handled - should not be here");
                }
            }
        }
    }

    private boolean displayLeaf(BaseWrappers.ResourceWrapper res, BaseWrappers.BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        return this.displayLeaf(res, ew, defn, x, name, showCodeDetails, true);
    }

    private boolean displayLeaf(BaseWrappers.ResourceWrapper res, BaseWrappers.BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails, boolean allowLinks) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        if (e == null) {
            return false;
        }
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof UriType) {
            x.addText(name + ": " + (String)((UriType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            return false;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableReference) {
                if (((CodeableReference)e).hasReference()) {
                    Reference r = ((CodeableReference)e).getReference();
                    this.renderReference(res, x, r, allowLinks);
                } else {
                    this.renderCodeableConcept(x, ((CodeableReference)e).getConcept(), showCodeDetails);
                }
                return true;
            }
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept(x, (CodeableConcept)e, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding(x, (Coding)e, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation(x, (Annotation)e, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier(x, (Identifier)e);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName(x, (HumanName)e);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData(x, (SampledData)e);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress(x, (Address)e);
                return true;
            }
            if (e instanceof ContactPoint) {
                if (allowLinks) {
                    this.renderContactPoint(x, (ContactPoint)e);
                } else {
                    this.displayContactPoint(x, (ContactPoint)e);
                }
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming(x, (Timing)e);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity(x, (Quantity)e, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(x, ((Ratio)e).getNumerator(), showCodeDetails);
                x.tx("/");
                this.renderQuantity(x, ((Ratio)e).getDenominator(), showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "?ngen-2?" : p.getStartElement().toHumanDisplay());
                x.tx(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    Resolver.ResourceWithReference tr = this.resolveReference(res, r.getReference());
                    x.addText(tr == null ? r.getReference() : "?ngen-3");
                } else {
                    x.tx("?ngen-4?");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (e instanceof ContactDetail) {
                ContactDetail cd = (ContactDetail)e;
                if (cd.hasName()) {
                    x.tx(cd.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    if (allowLinks) {
                        this.renderContactPoint(x, c);
                        continue;
                    }
                    this.displayContactPoint(x, c);
                }
                return true;
            }
            if (e instanceof Range) {
                return false;
            }
            if (e instanceof Meta) {
                return false;
            }
            if (e instanceof Dosage) {
                return false;
            }
            if (e instanceof Signature) {
                return false;
            }
            if (e instanceof UsageContext) {
                return false;
            }
            if (e instanceof RelatedArtifact) {
                return false;
            }
            if (e instanceof ElementDefinition) {
                return false;
            }
            if (e instanceof Base64BinaryType) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        if (e.getType().size() == 1 && this.isBase(e.getType().get(0).getWorkingCode())) {
            return false;
        }
        if (e.getType().size() > 1) {
            return true;
        }
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(e.getTypeFirstRep().getCode());
        if (sd != null) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                return true;
            }
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && Utilities.existsInList((String)e.getTypeFirstRep().getCode(), (String[])new String[]{"Extension", "CodeableConcept", "Coding", "Annotation", "Identifier", "HumanName", "SampledData", "Address", "ContactPoint", "ContactDetail", "Timing", "Range", "Quantity", "Ratio", "Period", "Reference"})) {
                return true;
            }
        }
        return false;
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    private boolean generateByProfile(StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (this.context.isAddGeneratedNarrativeHeader()) {
            x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        }
        try {
            this.generateByProfile(this.rcontext.getResourceResource(), profile, this.rcontext.getResourceResource(), profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), this.rcontext.getResourceResource().getResourceType().toString()), x, this.rcontext.getResourceResource().getResourceType().toString(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        ProfileDrivenRenderer.inject(this.rcontext.getResourceResource(), x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        this.generateByProfile(new DirectWrappers.ResourceWrapperDirect(this.context, res), profile, new DirectWrappers.BaseWrapperDirect(this.context, e), allElements, defn, children, x, path, showCodeDetails, 0);
    }

    private void generateByProfile(BaseWrappers.ResourceWrapper res, StructureDefinition profile, BaseWrappers.BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, x, false, showCodeDetails, this.readDisplayHints(defn), path, indent);
        } else {
            for (BaseWrappers.PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                if (!p.hasValues()) continue;
                ElementDefinition child = this.getElementDefinition(children, path + "." + p.getName(), p);
                if (child == null) {
                    child = p.getElementDefinition();
                }
                if (child == null || child.getBase().hasPath() && child.getBase().getPath().startsWith("Resource.")) continue;
                this.generateElementByProfile(res, profile, allElements, x, path, showCodeDetails, indent, p, child);
            }
        }
    }

    public void generateElementByProfile(BaseWrappers.ResourceWrapper res, StructureDefinition profile, List<ElementDefinition> allElements, XhtmlNode x, String path, boolean showCodeDetails, int indent, BaseWrappers.PropertyWrapper p, ElementDefinition child) throws UnsupportedEncodingException, IOException, EOperationOutcome {
        block15: {
            List<ElementDefinition> grandChildren;
            Map<String, String> displayHints;
            block17: {
                block16: {
                    XhtmlNode para;
                    displayHints = this.readDisplayHints(child);
                    if ("DomainResource.contained".equals(child.getBase().getPath()) || this.exemptFromRendering(child)) break block15;
                    if (this.isExtension(p)) {
                        this.hasExtensions = true;
                    }
                    grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                    this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                    if (p.getValues().size() <= 0) break block15;
                    if (!this.isPrimitive(child)) break block16;
                    para = x.isPara() ? (para = x) : x.para();
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) break block15;
                    para.b().addText(name);
                    para.tx(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.ul();
                        for (BaseWrappers.BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, x, list.li(), false, showCodeDetails, displayHints, path, indent);
                        }
                    } else {
                        boolean first = true;
                        for (BaseWrappers.BaseWrapper v : p.getValues()) {
                            if (first) {
                                first = false;
                            } else {
                                para.tx(", ");
                            }
                            this.renderLeaf(res, v, child, x, para, false, showCodeDetails, displayHints, path, indent);
                        }
                    }
                    break block15;
                }
                if (!this.canDoTable(path, p, grandChildren, x)) break block17;
                XhtmlNode xn = new XhtmlNode(NodeType.Element, this.getHeader());
                xn.addText(Utilities.capitalize((String)Utilities.camelCase((String)Utilities.pluralizeMe((String)p.getName()))));
                XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
                tbl.setAttribute("class", "grid");
                XhtmlNode tr = tbl.tr();
                tr.td().tx("-");
                boolean add = this.addColumnHeadings(tr, grandChildren);
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    tr = tbl.tr();
                    tr.td().tx("*");
                    add = this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints, path, indent) || add;
                }
                if (!add) break block15;
                x.add(xn);
                x.add(tbl);
                break block15;
            }
            if (this.isExtension(p)) {
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    BaseWrappers.PropertyWrapper vp = v.getChildByName("value");
                    BaseWrappers.PropertyWrapper ev = v.getChildByName("extension");
                    if (vp.hasValues()) {
                        BaseWrappers.BaseWrapper vv = vp.value();
                        XhtmlNode para = x.para();
                        para.b().addText(p.getStructure().present());
                        para.tx(": ");
                        this.renderLeaf(res, vv, child, x, para, false, showCodeDetails, displayHints, path, indent);
                        continue;
                    }
                    if (!ev.hasValues()) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(this.isExtension(p) ? p.getStructure().present() : p.getName());
                    for (BaseWrappers.BaseWrapper vv : ev.getValues()) {
                        StructureDefinition ex = this.context.getWorker().fetchTypeDefinition("Extension");
                        List<ElementDefinition> children = this.getChildrenForPath(ex.getSnapshot().getElement(), "Extension");
                        this.generateByProfile(res, ex, vv, allElements, child, children, bq, "Extension", showCodeDetails, indent + 1);
                    }
                }
            } else {
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(this.isExtension(p) ? p.getStructure().present() : p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails, indent + 1);
                }
            }
        }
    }

    private String getHeader() {
        int i;
        for (i = 3; i <= this.context.getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    private List<BaseWrappers.PropertyWrapper> getValues(String path, BaseWrappers.PropertyWrapper p, ElementDefinition e) {
        ArrayList<BaseWrappers.PropertyWrapper> res = new ArrayList<BaseWrappers.PropertyWrapper>();
        for (BaseWrappers.BaseWrapper v : p.getValues()) {
            for (BaseWrappers.PropertyWrapper g : v.children()) {
                if (!(path + "." + p.getName() + "." + g.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canDoTable(String path, BaseWrappers.PropertyWrapper p, List<ElementDefinition> grandChildren, XhtmlNode x) {
        if (this.isExtension(p)) {
            return false;
        }
        if (x.getName().equals("p")) {
            return false;
        }
        for (ElementDefinition e : grandChildren) {
            List<BaseWrappers.PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isExtension(BaseWrappers.PropertyWrapper p) {
        return p.getName().contains("extension[");
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getWorkingCode()).equals("Address") || t.equals("Reference"));
    }

    private boolean addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        boolean b = false;
        for (ElementDefinition e : grandChildren) {
            b = true;
            tr.td().b().addText(Utilities.capitalize((String)this.tail(e.getPath())));
        }
        return b;
    }

    private boolean addColumnValues(BaseWrappers.ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrappers.BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        boolean b = false;
        for (ElementDefinition e : grandChildren) {
            BaseWrappers.PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            XhtmlNode td = tr.td();
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                b = true;
                td.tx(" ");
                continue;
            }
            for (BaseWrappers.BaseWrapper vv : p.getValues()) {
                b = true;
                td.sep(", ");
                this.renderLeaf(res, vv, e, td, td, false, showCodeDetails, displayHints, path, indent);
            }
        }
        return b;
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, BaseWrappers.PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrappers.BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                BaseWrappers.PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<BaseWrappers.PropertyWrapper> splitExtensions(StructureDefinition profile, List<BaseWrappers.PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<BaseWrappers.PropertyWrapper> results = new ArrayList<BaseWrappers.PropertyWrapper>();
        HashMap map = new HashMap();
        for (BaseWrappers.PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrappers.BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.getContext().getWorker().fetchResource(StructureDefinition.class, url);
                    if (ed == null) {
                        if (this.xverManager == null) {
                            this.xverManager = new XVerExtensionManager(this.context.getWorker());
                        }
                        if (this.xverManager.matchingUrl(url) && this.xverManager.status(url) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                            ed = this.xverManager.makeDefinition(url);
                            this.getContext().getWorker().generateSnapshot(ed);
                            this.getContext().getWorker().cacheResource(ed);
                        }
                    }
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    BaseWrappers.PropertyWrapper pe = (BaseWrappers.PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir") && !url.startsWith("http://hl7.org/fhir/us")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            pe = new DirectWrappers.PropertyWrapperDirect(this.context, new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex), null);
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new DirectWrappers.PropertyWrapperDirect(this.context, new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex), ed.getSnapshot().getElementFirstRep());
                            ((DirectWrappers.PropertyWrapperDirect)pe).getWrapped().setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString((String)(displayHint = ToolingExtensions.getDisplayHint(defn)))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length == 1) {
                    hints.put("value", parts[0].trim());
                    continue;
                }
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrappers.BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString((String)v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    protected String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    @Override
    public boolean canRender(Resource resource) {
        return this.context.getWorker().getResourceNames().contains(resource.fhirType());
    }
}

