/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.SpecialCodeSystem;
import org.hl7.fhir.r5.terminologies.URICodeSystem;
import org.hl7.fhir.r5.terminologies.ValueSetChecker;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetWorker;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class ValueSetCheckerSimple
extends ValueSetWorker
implements ValueSetChecker {
    private ValueSet valueset;
    private IWorkerContext context;
    private Map<String, ValueSetCheckerSimple> inner = new HashMap<String, ValueSetCheckerSimple>();
    private ValidationOptions options;

    public ValueSetCheckerSimple(ValidationOptions options, ValueSet source, IWorkerContext context) {
        this.valueset = source;
        this.context = context;
        this.options = options;
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) {
                    warnings.add(this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0]));
                }
                CodeSystem cs = this.context.fetchCodeSystem(c.getSystem());
                IWorkerContext.ValidationResult res = null;
                res = cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE ? this.context.validateCode(this.options.noClient(), c, null) : this.validateCode(c, cs);
                if (!res.isOk()) {
                    errors.add(res.getMessage());
                    continue;
                }
                if (res.getMessage() == null) continue;
                warnings.add(res.getMessage());
            }
        }
        if (this.valueset != null && this.options.getValueSetMode() != ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) {
            Boolean result = false;
            for (Coding c : code.getCoding()) {
                Boolean ok = this.codeInValueSet(c.getSystem(), c.getCode());
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
            }
            if (result == null) {
                warnings.add(0, this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_", this.valueset.getUrl()));
            } else if (!result.booleanValue()) {
                errors.add(0, this.context.formatMessage("None_of_the_provided_codes_are_in_the_value_set_", this.valueset.getUrl()));
            }
        }
        if (errors.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)errors).toString());
        }
        if (warnings.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, ((Object)warnings).toString());
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.INFORMATION, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        Boolean ok;
        String system;
        String warningMessage = null;
        IWorkerContext.ValidationResult res = null;
        boolean inExpansion = false;
        boolean inInclude = false;
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystemOrNull();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            if (system == null && !code.hasDisplay()) {
                system = this.systemForCodeInValueSet(code.getCode());
            }
            if (!code.hasSystem()) {
                if (this.options.isGuessSystem() && system == null && Utilities.isAbsoluteUrl((String)code.getCode())) {
                    system = "urn:ietf:rfc:3986";
                }
                code.setSystem(system);
            }
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
            CodeSystem cs = this.context.fetchCodeSystem(system);
            if (cs == null) {
                cs = this.findSpecialCodeSystem(system);
            }
            if (cs == null) {
                warningMessage = "Unable to resolve system " + system;
                if (!inExpansion) {
                    if (!this.valueset.hasExpansion()) throw new FHIRException(warningMessage);
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("CODESYSTEM_CS_UNK_EXPANSION", this.valueset.getUrl(), code.getCode().toString(), code.getSystem()));
                }
            }
            if (cs != null && cs.hasSupplements()) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("CODESYSTEM_CS_NO_SUPPLEMENT", cs.getUrl()));
            }
            if (cs != null && cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                warningMessage = "Resolved system " + system + ", but the definition is not complete";
                if (!inExpansion && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
                    throw new FHIRException(warningMessage);
                }
            }
            if (cs != null) {
                if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
                    throw new FHIRException("Unable to evaluate based on empty code system");
                }
                res = this.validateCode(code, cs);
            } else {
                if (cs != null) throw new FHIRException("No try the server");
                if (!this.valueset.hasExpansion()) throw new FHIRException("No try the server");
                if (!inExpansion) throw new FHIRException("No try the server");
                res = new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code.getCode()).setDisplay(code.getDisplay()));
            }
        } else {
            inExpansion = this.checkExpansion(code);
            inInclude = this.checkInclude(code);
        }
        if (this.valueset == null) return res;
        if (this.options.getValueSetMode() == ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) return res;
        if (res != null) {
            if (!res.isOk()) return res;
        }
        if ((ok = this.codeInValueSet(system, code.getCode())) != null) {
            if (ok != false) return res;
        }
        if (res == null) {
            res = new IWorkerContext.ValidationResult(null, null);
        }
        if (!inExpansion && !inInclude) {
            res.setMessage("Not in value set " + this.valueset.getUrl()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
            return res;
        } else {
            if (warningMessage != null) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("Code_found_in_expansion_however_", warningMessage));
            }
            if (inExpansion) {
                res.setMessage("Code found in expansion, however: " + res.getMessage());
                return res;
            } else {
                if (!inInclude) return res;
                res.setMessage("Code found in include, however: " + res.getMessage());
            }
        }
        return res;
    }

    private boolean checkInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return false;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return false;
            }
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private CodeSystem findSpecialCodeSystem(String system) {
        if ("urn:ietf:rfc:3986".equals(system)) {
            CodeSystem cs = new CodeSystem();
            cs.setUrl(system);
            cs.setUserData("tx.cs.special", new URICodeSystem());
            cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
            return cs;
        }
        return null;
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return null;
        }
        return this.findCodeInExpansion(code, this.valueset.getExpansion().getContains());
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            IWorkerContext.ValidationResult res;
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                CodeSystem.ConceptDefinitionComponent ccd = new CodeSystem.ConceptDefinitionComponent();
                ccd.setCode(containsComponent.getCode());
                ccd.setDisplay(containsComponent.getDisplay());
                IWorkerContext.ValidationResult res2 = new IWorkerContext.ValidationResult(ccd);
                return res2;
            }
            if (!containsComponent.hasContains() || (res = this.findCodeInExpansion(code, containsComponent.getContains())) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains());
    }

    private boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains())) continue;
            return true;
        }
        return false;
    }

    private IWorkerContext.ValidationResult validateCode(Coding code, CodeSystem cs) {
        CodeSystem.ConceptDefinitionComponent cc;
        CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = cc = cs.hasUserData("tx.cs.special") ? ((SpecialCodeSystem)cs.getUserData("tx.cs.special")).findConcept(code) : this.findCodeInConcept(cs.getConcept(), code.getCode());
        if (cc == null) {
            if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("UNKNOWN_CODE__IN_FRAGMENT", this.gen(code), cs.getUrl()));
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.context.formatMessage("Unknown_Code__in_", this.gen(code), cs.getUrl()));
        }
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        ValueSet.ConceptReferenceComponent vs = this.findValueSetRef(code.getSystem(), code.getCode());
        if (vs != null && (vs.hasDisplay() || vs.hasDesignation())) {
            if (vs.hasDisplay()) {
                b.append(vs.getDisplay());
                if (code.getDisplay().equalsIgnoreCase(vs.getDisplay())) {
                    return new IWorkerContext.ValidationResult(cc);
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getDesignation()) {
                b.append(ds.getValue());
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("Display_Name_for__should_be_one_of__instead_of_", code.getSystem(), code.getCode(), b.toString(), code.getDisplay()), cc);
    }

    private ValueSet.ConceptReferenceComponent findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return cc;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return cc;
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ValueSet.ConceptReferenceComponent cc = this.getVs(url.asStringValue()).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private String gen(Coding code) {
        if (code.hasSystem()) {
            return code.getSystem() + "#" + code.getCode();
        }
        return null;
    }

    private String getValueSetSystem() throws FHIRException {
        if (this.valueset == null) {
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_system__no_value_set", new Object[0]));
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_system__value_set_has_no_includes_or_expansion", new Object[0]));
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_system__value_set_expansion_has_multiple_systems", new Object[0]));
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_system__value_set_has_imports", new Object[0]));
            }
            if (inc.hasSystem()) continue;
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", new Object[0]));
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private String getValueSetSystemOrNull() throws FHIRException {
        if (this.valueset == null) {
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                return null;
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                return null;
            }
            if (inc.hasSystem()) continue;
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(CodeSystem.ConceptDefinitionComponent concept, String code) {
        if (code.equals(concept.getCode())) {
            return concept;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(concept.getConcept(), code);
        if (cc != null) {
            return cc;
        }
        if (concept.hasUserData("cs.utils.cross.link")) {
            List children = (List)concept.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                cc = this.findCodeInConcept(c, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc, code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String systemForCodeInValueSet(String code) {
        String sys = null;
        if (this.valueset.hasCompose()) {
            if (this.valueset.getCompose().hasExclude()) {
                return null;
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                if (vsi.hasValueSet()) {
                    return null;
                }
                if (!vsi.hasSystem()) {
                    return null;
                }
                if (vsi.hasFilter()) {
                    return null;
                }
                CodeSystem cs = this.context.fetchCodeSystem(vsi.getSystem());
                if (cs == null) {
                    return null;
                }
                if (vsi.hasConcept()) {
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        boolean match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                        if (!match) continue;
                        if (sys == null) {
                            sys = vsi.getSystem();
                            continue;
                        }
                        if (sys.equals(vsi.getSystem())) continue;
                        return null;
                    }
                    continue;
                }
                CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
                if (cc == null) continue;
                if (sys == null) {
                    sys = vsi.getSystem();
                    continue;
                }
                if (sys.equals(vsi.getSystem())) continue;
                return null;
            }
        } else if (this.valueset.hasExpansion()) {
            ArrayList<String> systems = new ArrayList<String>();
            this.checkSystems(this.valueset.getExpansion().getContains(), code, systems);
            if (systems.size() == 1) {
                sys = (String)systems.get(0);
            }
        }
        return sys;
    }

    private void checkSystems(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code, List<String> systems) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            if (c.getCode().equals(code) && !systems.contains(c.getSystem())) {
                systems.add(c.getSystem());
            }
            if (!c.hasContains()) continue;
            this.checkSystems(c.getContains(), code, systems);
        }
    }

    @Override
    public Boolean codeInValueSet(String system, String code) throws FHIRException {
        Boolean result = false;
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null));
        }
        if (this.valueset.hasCompose()) {
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                Boolean ok = this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
                if (ok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!ok.booleanValue()) continue;
                result = true;
                break;
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                Boolean nok = this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
                if (nok == null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (!nok.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    private Boolean inComponent(ValueSet.ConceptSetComponent vsi, String system, String code, boolean only) throws FHIRException {
        for (UriType uriType : vsi.getValueSet()) {
            if (!this.inImport((String)uriType.getValue(), system, code)) continue;
            return true;
        }
        if (!vsi.hasSystem()) {
            return false;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (!system.equals(vsi.getSystem())) {
            return false;
        }
        CodeSystem cs = this.context.fetchCodeSystem(system);
        if (cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE && cs.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT) {
            ValueSet valueSet = new ValueSet();
            valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
            valueSet.setUrl(Utilities.makeUuidUrn());
            valueSet.getCompose().addInclude(vsi);
            IWorkerContext.ValidationResult res = this.context.validateCode(this.options.noClient(), new Coding(system, code, null), valueSet);
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED || res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED) {
                return null;
            }
            if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE) {
                throw new NoTerminologyServiceException();
            }
            return res.isOk();
        }
        if (vsi.hasFilter()) {
            boolean bl;
            boolean bl2 = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(cs, system, f, code)) continue;
                bl = false;
                break;
            }
            return bl;
        }
        List<CodeSystem.ConceptDefinitionComponent> list = cs.getConcept();
        boolean ok = this.validateCodeInConceptList(code, cs, list);
        if (ok && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        return ok;
    }

    private boolean codeInFilter(CodeSystem cs, String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__filter_with_property__", cs.getUrl(), f.getProperty()));
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code);
            }
        }
        System.out.println("todo: handle concept filters with op = " + (Object)((Object)f.getOp()));
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__concept_filter_with_op__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        if (code.equals(f.getProperty())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue());
        if (cc == null) {
            return false;
        }
        return (cc = this.findCodeInConcept(cc, code)) != null;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list) {
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetCheckerSimple getVs(String url) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, url);
        ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(this.options, vs, this.context);
        this.inner.put(url, vsc);
        return vsc;
    }

    private boolean inImport(String uri, String system, String code) throws FHIRException {
        return this.getVs(uri).codeInValueSet(system, code);
    }
}

