/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.npm.PackageGenerator;

public class NPMPackageGenerator {
    private String destFile;
    private Set<String> created = new HashSet<String>();
    private TarArchiveOutputStream tar;
    private ByteArrayOutputStream OutputStream;
    private BufferedOutputStream bufferedOutputStream;
    private GzipCompressorOutputStream gzipOutputStream;
    private JsonObject packageJ;
    private JsonObject packageManifest;
    private NpmPackageIndexBuilder indexer;
    private String igVersion;

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, Date date, boolean notForPublication) throws FHIRException, IOException {
        this.destFile = destFile;
        this.start();
        ArrayList<String> fhirVersion = new ArrayList<String>();
        for (Enumeration<Enumerations.FHIRVersion> v : ig.getFhirVersion()) {
            fhirVersion.add(v.asStringValue());
        }
        this.buildPackageJson(canonical, kind, url, date, ig, fhirVersion, notForPublication);
    }

    public static NPMPackageGenerator subset(NPMPackageGenerator master, String destFile, String id, String name, Date date, boolean notForPublication) throws FHIRException, IOException {
        JsonObject p = master.packageJ.deepCopy();
        p.remove("name");
        p.addProperty("name", id);
        p.remove("type");
        p.addProperty("type", PackageGenerator.PackageType.SUBSET.getCode());
        p.remove("title");
        p.addProperty("title", name);
        if (notForPublication) {
            p.addProperty("notForPublication", Boolean.valueOf(true));
        }
        return new NPMPackageGenerator(destFile, p, date, notForPublication);
    }

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, Date date, List<String> fhirVersion, boolean notForPublication) throws FHIRException, IOException {
        this.destFile = destFile;
        this.start();
        this.buildPackageJson(canonical, kind, url, date, ig, fhirVersion, notForPublication);
    }

    public NPMPackageGenerator(String destFile, JsonObject npm, Date date, boolean notForPublication) throws FHIRException, IOException {
        String dt = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        this.packageJ = npm;
        this.packageManifest = new JsonObject();
        this.packageManifest.addProperty("version", npm.get("version").getAsString());
        this.packageManifest.addProperty("date", dt);
        if (notForPublication) {
            this.packageManifest.addProperty("notForPublication", Boolean.valueOf(true));
        }
        npm.addProperty("date", dt);
        this.packageManifest.addProperty("name", npm.get("name").getAsString());
        this.destFile = destFile;
        this.start();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)npm);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void buildPackageJson(String canonical, PackageGenerator.PackageType kind, String web, Date date, ImplementationGuide ig, List<String> fhirVersion, boolean notForPublication) throws FHIRException, IOException {
        String dtHuman = new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(date);
        String dt = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (!ig.hasPackageId()) {
            b.append("packageId");
        }
        if (!ig.hasVersion()) {
            b.append("version");
        }
        if (!ig.hasFhirVersion()) {
            b.append("fhirVersion");
        }
        if (!ig.hasLicense()) {
            b.append("license");
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
            if (d.hasVersion()) continue;
            b.append("dependsOn.version(" + d.getUri() + ")");
        }
        JsonObject npm = new JsonObject();
        npm.addProperty("name", ig.getPackageId());
        npm.addProperty("version", ig.getVersion());
        this.igVersion = ig.getVersion();
        npm.addProperty("tools-version", (Number)3);
        npm.addProperty("type", kind.getCode());
        npm.addProperty("date", dt);
        if (ig.hasLicense()) {
            npm.addProperty("license", ig.getLicense().toCode());
        }
        npm.addProperty("canonical", canonical);
        if (notForPublication) {
            npm.addProperty("notForPublication", Boolean.valueOf(true));
        }
        npm.addProperty("url", web);
        if (ig.hasTitle()) {
            npm.addProperty("title", ig.getTitle());
        }
        if (ig.hasDescription()) {
            npm.addProperty("description", ig.getDescription() + " (built " + dtHuman + this.timezone() + ")");
        }
        JsonArray vl = new JsonArray();
        npm.add("fhirVersions", (JsonElement)vl);
        for (String string : fhirVersion) {
            vl.add((JsonElement)new JsonPrimitive(string));
        }
        if (kind != PackageGenerator.PackageType.CORE) {
            JsonObject dep = new JsonObject();
            npm.add("dependencies", (JsonElement)dep);
            for (String v : fhirVersion) {
                String vp = this.packageForVersion(v);
                if (vp == null) continue;
                dep.addProperty(vp, v);
            }
            for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
                dep.addProperty(d.getPackageId(), d.getVersion());
            }
        }
        if (ig.hasPublisher()) {
            npm.addProperty("author", ig.getPublisher());
        }
        JsonArray m = new JsonArray();
        for (ContactDetail t : ig.getContact()) {
            String email = this.email(t.getTelecom());
            String url = this.url(t.getTelecom());
            if (!(t.hasName() & (email != null || url != null))) continue;
            JsonObject md = new JsonObject();
            m.add((JsonElement)md);
            md.addProperty("name", t.getName());
            if (email != null) {
                md.addProperty("email", email);
            }
            if (url == null) continue;
            md.addProperty("url", url);
        }
        if (m.size() > 0) {
            npm.add("maintainers", (JsonElement)m);
        }
        if (ig.getManifest().hasRendering()) {
            npm.addProperty("homepage", ig.getManifest().getRendering());
        }
        JsonObject jsonObject = new JsonObject();
        npm.add("directories", (JsonElement)jsonObject);
        jsonObject.addProperty("lib", "package");
        jsonObject.addProperty("example", "example");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)npm);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.packageJ = npm;
        this.packageManifest = new JsonObject();
        this.packageManifest.addProperty("version", ig.getVersion());
        this.packageManifest.addProperty("fhirVersion", fhirVersion.toString());
        this.packageManifest.addProperty("date", dt);
        this.packageManifest.addProperty("name", ig.getPackageId());
    }

    private String packageForVersion(String v) {
        if (v == null) {
            return null;
        }
        if (v.startsWith("1.0")) {
            return "hl7.fhir.r2.core";
        }
        if (v.startsWith("1.4")) {
            return "hl7.fhir.r2b.core";
        }
        if (v.startsWith("3.0")) {
            return "hl7.fhir.r3.core";
        }
        if (v.startsWith("4.0")) {
            return "hl7.fhir.r4.core";
        }
        if (v.startsWith("4.1")) {
            return "hl7.fhir.r4b.core";
        }
        return null;
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private String url(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.URL) continue;
            return cp.getValue();
        }
        return null;
    }

    private String email(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.EMAIL) continue;
            return cp.getValue();
        }
        return null;
    }

    private void start() throws IOException {
        this.OutputStream = new ByteArrayOutputStream();
        this.bufferedOutputStream = new BufferedOutputStream(this.OutputStream);
        this.gzipOutputStream = new GzipCompressorOutputStream((OutputStream)this.bufferedOutputStream);
        this.tar = new TarArchiveOutputStream((OutputStream)this.gzipOutputStream);
        this.indexer = new NpmPackageIndexBuilder();
        this.indexer.start();
    }

    public void addFile(Category cat, String name, byte[] content) throws IOException {
        String path = cat.getDirectory() + name;
        if (!path.startsWith("package/")) {
            path = "package/" + path;
        }
        if (path.length() > 100) {
            name = name.substring(0, name.indexOf("-")) + "-" + UUID.randomUUID().toString();
            path = cat.getDirectory() + name;
            if (!path.startsWith("package/")) {
                path = "package/" + path;
            }
        }
        if (this.created.contains(path)) {
            System.out.println("Duplicate package file " + path);
        } else {
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
            if (cat == Category.RESOURCE) {
                this.indexer.seeFile(name, content);
            }
        }
    }

    public void finish() throws IOException {
        this.buildIndexJson();
        this.tar.finish();
        this.tar.close();
        this.gzipOutputStream.close();
        this.bufferedOutputStream.close();
        this.OutputStream.close();
        TextFile.bytesToFile((byte[])this.OutputStream.toByteArray(), (String)this.destFile);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)this.packageManifest);
        TextFile.stringToFile((String)json, (String)Utilities.changeFileExt((String)this.destFile, (String)".manifest.json"), (boolean)false);
    }

    private void buildIndexJson() throws IOException {
        byte[] content = TextFile.stringToBytes((String)this.indexer.build(), (boolean)false);
        this.addFile(Category.RESOURCE, ".index.json", content);
    }

    public String filename() {
        return this.destFile;
    }

    public void loadDir(String rootDir, String name) throws IOException {
        this.loadFiles(rootDir, new File(Utilities.path((String[])new String[]{rootDir, name})), new String[0]);
    }

    public void loadFiles(String root, File dir, String ... noload) throws IOException {
        for (File f : dir.listFiles()) {
            if (Utilities.existsInList((String)f.getName(), (String[])noload)) continue;
            if (f.isDirectory()) {
                this.loadFiles(root, f, new String[0]);
                continue;
            }
            String path = f.getAbsolutePath().substring(root.length() + 1);
            byte[] content = TextFile.fileToBytes((File)f);
            if (this.created.contains(path)) {
                System.out.println("Duplicate package file " + path);
                continue;
            }
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
        }
    }

    public String version() {
        return this.igVersion;
    }

    public static enum Category {
        RESOURCE,
        EXAMPLE,
        OPENAPI,
        SCHEMATRON,
        RDF,
        OTHER,
        TOOL,
        TEMPLATE,
        JEKYLL;


        private String getDirectory() {
            switch (this) {
                case RESOURCE: {
                    return "package/";
                }
                case EXAMPLE: {
                    return "example/";
                }
                case OPENAPI: {
                    return "openapi/";
                }
                case SCHEMATRON: {
                    return "xml/";
                }
                case RDF: {
                    return "rdf/";
                }
                case OTHER: {
                    return "other/";
                }
                case TEMPLATE: {
                    return "other/";
                }
                case JEKYLL: {
                    return "jekyll/";
                }
                case TOOL: {
                    return "bin/";
                }
            }
            return "/";
        }
    }
}

