/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class PatientRenderer
extends ResourceRenderer {
    public PatientRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws UnsupportedEncodingException, IOException {
        this.describe(x, dr);
        return false;
    }

    @Override
    public String display(Resource dr) {
        Patient pat = (Patient)dr;
        Identifier id = null;
        for (Identifier t : pat.getIdentifier()) {
            id = this.chooseId(id, t);
        }
        HumanName n = null;
        for (HumanName t : pat.getName()) {
            n = this.chooseName(n, t);
        }
        return this.display(n, pat.getGender().getDisplay(), pat.getBirthDateElement(), id);
    }

    private Identifier chooseId(Identifier oldId, Identifier newId) {
        if (oldId == null) {
            return newId;
        }
        if (newId == null) {
            return oldId;
        }
        return this.isPreferred(newId.getUse(), oldId.getUse()) ? newId : oldId;
    }

    private boolean isPreferred(Identifier.IdentifierUse newUse, Identifier.IdentifierUse oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        switch (newUse) {
            case NULL: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.USUAL);
            }
            case OFFICIAL: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.USUAL);
            }
            case OLD: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.SECONDARY, Identifier.IdentifierUse.USUAL);
            }
            case SECONDARY: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.USUAL);
            }
            case TEMP: {
                return !this.existsInList(oldUse, Identifier.IdentifierUse.OFFICIAL, Identifier.IdentifierUse.SECONDARY, Identifier.IdentifierUse.USUAL);
            }
            case USUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean existsInList(Identifier.IdentifierUse oldUse, Identifier.IdentifierUse ... values) {
        for (Identifier.IdentifierUse value : values) {
            if (value != oldUse) continue;
            return true;
        }
        return false;
    }

    private HumanName chooseName(HumanName oldName, HumanName newName) {
        if (oldName == null) {
            return newName;
        }
        if (newName == null) {
            return oldName;
        }
        return this.isPreferred(newName.getUse(), oldName.getUse()) ? newName : oldName;
    }

    private boolean isPreferred(HumanName.NameUse newUse, HumanName.NameUse oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        switch (oldUse) {
            case ANONYMOUS: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case MAIDEN: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case NICKNAME: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case NULL: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case OFFICIAL: {
                return this.existsInList(newUse, HumanName.NameUse.USUAL);
            }
            case OLD: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case TEMP: {
                return this.existsInList(newUse, HumanName.NameUse.OFFICIAL, HumanName.NameUse.USUAL);
            }
            case USUAL: {
                return false;
            }
        }
        return false;
    }

    private boolean existsInList(HumanName.NameUse oldUse, HumanName.NameUse ... values) {
        for (HumanName.NameUse value : values) {
            if (value != oldUse) continue;
            return true;
        }
        return false;
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper pat) throws UnsupportedEncodingException, IOException {
        Identifier id = null;
        BaseWrappers.PropertyWrapper pw = this.getProperty(pat, "identifier");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            id = this.chooseId(id, (Identifier)baseWrapper.getBase());
        }
        pw = this.getProperty(pat, "name");
        HumanName n = null;
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            n = this.chooseName(n, (HumanName)((Object)t));
        }
        String string = null;
        pw = this.getProperty(pat, "gender");
        if (this.valued(pw)) {
            pw.value().getBase().primitiveValue();
        }
        DateType dt = null;
        pw = this.getProperty(pat, "birthDate");
        if (this.valued(pw)) {
            dt = (DateType)pw.value().getBase();
        }
        return this.display(n, string, dt, id);
    }

    @Override
    public void describe(XhtmlNode x, BaseWrappers.ResourceWrapper pat) throws UnsupportedEncodingException, IOException {
        Identifier id = null;
        BaseWrappers.PropertyWrapper pw = this.getProperty(pat, "identifier");
        for (BaseWrappers.BaseWrapper baseWrapper : pw.getValues()) {
            id = this.chooseId(id, (Identifier)baseWrapper.getBase());
        }
        pw = this.getProperty(pat, "name");
        HumanName n = null;
        for (BaseWrappers.BaseWrapper t : pw.getValues()) {
            n = this.chooseName(n, (HumanName)t.getBase());
        }
        String string = null;
        pw = this.getProperty(pat, "gender");
        if (this.valued(pw)) {
            pw.value().getBase().primitiveValue();
        }
        DateType dt = null;
        pw = this.getProperty(pat, "birthDate");
        if (this.valued(pw)) {
            dt = (DateType)pw.value().getBase();
        }
        this.describe(x, n, string, dt, id);
    }

    private String display(HumanName name, String gender, DateType dob, Identifier id) {
        StringBuilder b = new StringBuilder();
        b.append(this.display(name));
        b.append(" ");
        if (dob == null) {
            b.append("??");
        } else {
            b.append(gender);
        }
        b.append(" ");
        if (dob == null) {
            b.append("DoB Unknown");
        } else {
            b.append(this.display(dob));
        }
        if (id != null) {
            b.append(" ( ");
            b.append(this.display(id));
            b.append(")");
        }
        return b.toString();
    }

    public void describe(XhtmlNode x, HumanName name, String gender, DateType dob, Identifier id) throws UnsupportedEncodingException, IOException {
        if (name == null) {
            x.b().tx("Unnamed Patient");
        } else {
            this.render(x.b(), name);
        }
        x.tx(" ");
        if (gender == null) {
            x.tx("??");
        } else {
            x.tx(gender);
        }
        x.tx(" ");
        if (dob == null) {
            x.tx("DoB Unknown");
        } else {
            this.render(x, dob);
        }
        if (id != null) {
            x.tx(" ( ");
            this.render(x, id);
            x.tx(")");
        }
    }
}

