/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.TerminologyCache;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.OperationOutcomeRenderer;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    private Object lock = new Object();
    protected String version;
    private String cacheId;
    private boolean isTxCaching;
    private Set<String> cached = new HashSet<String>();
    private Map<String, Map<String, Resource>> allResourcesById = new HashMap<String, Map<String, Resource>>();
    private CanonicalResourceManager<CodeSystem> codeSystems = new CanonicalResourceManager(false);
    private Set<String> supportedCodeSystems = new HashSet<String>();
    private Set<String> unsupportedCodeSystems = new HashSet<String>();
    private CanonicalResourceManager<ValueSet> valueSets = new CanonicalResourceManager(false);
    private CanonicalResourceManager<ConceptMap> maps = new CanonicalResourceManager(false);
    protected CanonicalResourceManager<StructureMap> transforms = new CanonicalResourceManager(false);
    private CanonicalResourceManager<StructureDefinition> structures = new CanonicalResourceManager(false);
    private CanonicalResourceManager<Measure> measures = new CanonicalResourceManager(false);
    private CanonicalResourceManager<Library> libraries = new CanonicalResourceManager(false);
    private CanonicalResourceManager<ImplementationGuide> guides = new CanonicalResourceManager(false);
    private CanonicalResourceManager<CapabilityStatement> capstmts = new CanonicalResourceManager(false);
    private CanonicalResourceManager<SearchParameter> searchParameters = new CanonicalResourceManager(false);
    private CanonicalResourceManager<Questionnaire> questionnaires = new CanonicalResourceManager(false);
    private CanonicalResourceManager<OperationDefinition> operations = new CanonicalResourceManager(false);
    private CanonicalResourceManager<PlanDefinition> plans = new CanonicalResourceManager(false);
    private CanonicalResourceManager<NamingSystem> systems = new CanonicalResourceManager(false);
    private UcumService ucumService;
    protected Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    protected Map<String, String> oidCache = new HashMap<String, String>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected String tsServer;
    protected String name;
    private boolean allowLoadingDuplicates;
    protected TerminologyClient txClient;
    private Set<String> codeSystemsUsed = new HashSet<String>();
    protected ToolingClientLogger txLog;
    private TerminologyCapabilities txcaps;
    private boolean canRunWithoutTerminology;
    protected boolean noTerminologyServer;
    private int expandCodesLimit = 1000;
    protected IWorkerContext.ILoggingService logger;
    protected Parameters expParameters;
    private TranslationServices translator = new NullTranslator();
    protected TerminologyCache txCache;
    protected TimeTracker clock;
    private boolean tlogging = true;
    private IWorkerContext.ICanonicalResourceLocator locator;
    private Set<String> notCanonical = new HashSet<String>();
    private String overrideVersionNs;

    public BaseWorkerContext() throws FileNotFoundException, IOException, FHIRException {
        this.txCache = new TerminologyCache(this.lock, null);
        this.setValidationMessageLanguage(this.getLocale());
        this.clock = new TimeTracker();
    }

    public BaseWorkerContext(Locale locale) throws FileNotFoundException, IOException, FHIRException {
        this.txCache = new TerminologyCache(this.lock, null);
        this.setValidationMessageLanguage(locale);
        this.clock = new TimeTracker();
    }

    public BaseWorkerContext(CanonicalResourceManager<CodeSystem> codeSystems, CanonicalResourceManager<ValueSet> valueSets, CanonicalResourceManager<ConceptMap> maps, CanonicalResourceManager<StructureDefinition> profiles, CanonicalResourceManager<ImplementationGuide> guides) throws FileNotFoundException, IOException, FHIRException {
        this();
        this.codeSystems = codeSystems;
        this.valueSets = valueSets;
        this.maps = maps;
        this.structures = profiles;
        this.guides = guides;
        this.clock = new TimeTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(BaseWorkerContext other) {
        Object object = other.lock;
        synchronized (object) {
            this.allResourcesById.putAll(other.allResourcesById);
            this.translator = other.translator;
            this.codeSystems.copy(other.codeSystems);
            this.txcaps = other.txcaps;
            this.valueSets.copy(other.valueSets);
            this.maps.copy(other.maps);
            this.transforms.copy(other.transforms);
            this.structures.copy(other.structures);
            this.searchParameters.copy(other.searchParameters);
            this.plans.copy(other.plans);
            this.questionnaires.copy(other.questionnaires);
            this.operations.copy(other.operations);
            this.systems.copy(other.systems);
            this.guides.copy(other.guides);
            this.capstmts.copy(other.capstmts);
            this.measures.copy(other.measures);
            this.libraries.copy(this.libraries);
            this.allowLoadingDuplicates = other.allowLoadingDuplicates;
            this.tsServer = other.tsServer;
            this.name = other.name;
            this.txClient = other.txClient;
            this.txLog = other.txLog;
            this.txcaps = other.txcaps;
            this.canRunWithoutTerminology = other.canRunWithoutTerminology;
            this.noTerminologyServer = other.noTerminologyServer;
            if (other.txCache != null) {
                this.txCache = other.txCache.copy();
            }
            this.expandCodesLimit = other.expandCodesLimit;
            this.logger = other.logger;
            this.expParameters = other.expParameters;
        }
    }

    @Override
    public void cacheResource(Resource r) throws FHIRException {
        this.cacheResourceFromPackage(r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceFromPackage(CanonicalResourceManager.CanonicalResourceProxy r, IWorkerContext.PackageVersion packageInfo) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            String url = r.getUrl();
            if (!this.allowLoadingDuplicates && this.hasResource(r.getType(), url)) {
                if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                    return;
                }
                throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url}));
            }
            switch (r.getType()) {
                case "StructureDefinition": {
                    if ("1.4.0".equals(this.version)) {
                        StructureDefinition sd = (StructureDefinition)r.getResource();
                        this.fixOldSD(sd);
                    }
                    this.structures.register(r, packageInfo);
                    break;
                }
                case "ValueSet": {
                    this.valueSets.register(r, packageInfo);
                    break;
                }
                case "CodeSystem": {
                    this.codeSystems.register(r, packageInfo);
                    break;
                }
                case "ImplementationGuide": {
                    this.guides.register(r, packageInfo);
                    break;
                }
                case "CapabilityStatement": {
                    this.capstmts.register(r, packageInfo);
                    break;
                }
                case "Measure": {
                    this.measures.register(r, packageInfo);
                    break;
                }
                case "Library": {
                    this.libraries.register(r, packageInfo);
                    break;
                }
                case "SearchParameter": {
                    this.searchParameters.register(r, packageInfo);
                    break;
                }
                case "PlanDefinition": {
                    this.plans.register(r, packageInfo);
                    break;
                }
                case "OperationDefinition": {
                    this.operations.register(r, packageInfo);
                    break;
                }
                case "Questionnaire": {
                    this.questionnaires.register(r, packageInfo);
                    break;
                }
                case "ConceptMap": {
                    this.maps.register(r, packageInfo);
                    break;
                }
                case "StructureMap": {
                    this.transforms.register(r, packageInfo);
                    break;
                }
                case "NamingSystem": {
                    this.systems.register(r, packageInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResourceFromPackage(Resource r, IWorkerContext.PackageVersion packageInfo) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(r.fhirType());
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(r.fhirType(), map);
            }
            map.put(r.getId(), r);
            if (r instanceof CodeSystem || r instanceof NamingSystem) {
                this.oidCache.clear();
            }
            if (r instanceof CanonicalResource) {
                CanonicalResource m = (CanonicalResource)r;
                String url = m.getUrl();
                if (!this.allowLoadingDuplicates && this.hasResource(r.getClass(), url)) {
                    if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                        return;
                    }
                    throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url}));
                }
                if (r instanceof StructureDefinition) {
                    StructureDefinition sd = (StructureDefinition)m;
                    if ("1.4.0".equals(this.version)) {
                        this.fixOldSD(sd);
                    }
                    this.structures.see(sd, packageInfo);
                } else if (r instanceof ValueSet) {
                    this.valueSets.see((ValueSet)m, packageInfo);
                } else if (r instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)r);
                    this.codeSystems.see((CodeSystem)m, packageInfo);
                } else if (r instanceof ImplementationGuide) {
                    this.guides.see((ImplementationGuide)m, packageInfo);
                } else if (r instanceof CapabilityStatement) {
                    this.capstmts.see((CapabilityStatement)m, packageInfo);
                } else if (r instanceof Measure) {
                    this.measures.see((Measure)m, packageInfo);
                } else if (r instanceof Library) {
                    this.libraries.see((Library)m, packageInfo);
                } else if (r instanceof SearchParameter) {
                    this.searchParameters.see((SearchParameter)m, packageInfo);
                } else if (r instanceof PlanDefinition) {
                    this.plans.see((PlanDefinition)m, packageInfo);
                } else if (r instanceof OperationDefinition) {
                    this.operations.see((OperationDefinition)m, packageInfo);
                } else if (r instanceof Questionnaire) {
                    this.questionnaires.see((Questionnaire)m, packageInfo);
                } else if (r instanceof ConceptMap) {
                    this.maps.see((ConceptMap)m, packageInfo);
                } else if (r instanceof StructureMap) {
                    this.transforms.see((StructureMap)m, packageInfo);
                } else if (r instanceof NamingSystem) {
                    this.systems.see((NamingSystem)m, packageInfo);
                }
            }
        }
    }

    public void fixOldSD(StructureDefinition sd) {
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && sd.getType().equals("Extension") && sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            sd.setSnapshot(null);
        }
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (ed.getPath().equals("Extension.url") || ed.getPath().endsWith(".extension.url")) {
                ed.setMin(1);
                if (ed.hasBase()) {
                    ed.getBase().setMin(1);
                }
            }
            if (!"extension".equals(ed.getSliceName())) continue;
            ed.setSliceName(null);
        }
    }

    private boolean laterVersion(String newVersion, String oldVersion) {
        newVersion = newVersion.trim();
        oldVersion = oldVersion.trim();
        if (StringUtils.isNumeric((CharSequence)newVersion) && StringUtils.isNumeric((CharSequence)oldVersion)) {
            return Double.parseDouble(newVersion) > Double.parseDouble(oldVersion);
        }
        if (this.hasDelimiter(newVersion, oldVersion, ".")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\.");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "-")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\-");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "_")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\_");
        }
        if (this.hasDelimiter(newVersion, oldVersion, ":")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\:");
        }
        if (this.hasDelimiter(newVersion, oldVersion, " ")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\ ");
        }
        return newVersion.compareTo(oldVersion) > 0;
    }

    private boolean hasDelimiter(String s1, String s2, String delimiter) {
        return s1.contains(delimiter) && s2.contains(delimiter) && s1.split(delimiter).length == s2.split(delimiter).length;
    }

    private boolean laterDelimitedVersion(String newVersion, String oldVersion, String delimiter) {
        String[] newParts = newVersion.split(delimiter);
        String[] oldParts = oldVersion.split(delimiter);
        for (int i = 0; i < newParts.length; ++i) {
            if (newParts[i].equals(oldParts[i])) continue;
            return this.laterVersion(newParts[i], oldParts[i]);
        }
        throw new Error(this.formatMessage("Delimited_versions_have_exact_match_for_delimiter____vs_", new Object[]{delimiter, newParts, oldParts}));
    }

    protected <T extends CanonicalResource> void seeMetadataResource(T r, Map<String, T> map, List<T> list, boolean addId) throws FHIRException {
        list.add(r);
        if (r.hasUrl()) {
            if (r.hasVersion()) {
                map.put(r.getUrl() + "|" + r.getVersion(), r);
            }
            if (!map.containsKey(r.getUrl())) {
                map.put(r.getUrl(), r);
            } else {
                ArrayList<CanonicalResource> rl = new ArrayList<CanonicalResource>();
                for (CanonicalResource t : list) {
                    if (!t.getUrl().equals(r.getUrl()) || rl.contains(t)) continue;
                    rl.add(t);
                }
                Collections.sort(rl, new MetadataResourceVersionComparator<T>(list));
                map.put(r.getUrl(), rl.get(rl.size() - 1));
                CanonicalResource latest = null;
                for (CanonicalResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)r.getVersion())) continue;
                    latest = t;
                }
                if (latest != null) {
                    map.put(r.getUrl() + "|" + VersionUtilities.getMajMin((String)latest.getVersion()), rl.get(rl.size() - 1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSystem fetchCodeSystem(String system) {
        CodeSystem cs;
        Object object = this.lock;
        synchronized (object) {
            cs = this.codeSystems.get(system);
        }
        if (cs == null && this.locator != null) {
            this.locator.findResource(this, system);
            object = this.lock;
            synchronized (object) {
                cs = this.codeSystems.get(system);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.codeSystems.has(system) && this.codeSystems.get(system).getContent() != CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                return true;
            }
            if (this.supportedCodeSystems.contains(system)) {
                return true;
            }
            if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
                return false;
            }
            if (this.noTerminologyServer) {
                return false;
            }
            if (this.txcaps == null) {
                try {
                    this.log("Terminology server: Check for supported code systems for " + system);
                    this.setTxCaps(this.txClient.getTerminologyCapabilities());
                }
                catch (Exception e) {
                    if (this.canRunWithoutTerminology) {
                        this.noTerminologyServer = true;
                        this.log("==============!! Running without terminology server !! ==============");
                        if (this.txClient != null) {
                            this.log("txServer = " + this.txClient.getAddress());
                            this.log("Error = " + e.getMessage() + "");
                        }
                        this.log("=====================================================================");
                        return false;
                    }
                    e.printStackTrace();
                    throw new TerminologyServiceException((Throwable)e);
                }
                if (this.supportedCodeSystems.contains(system)) {
                    return true;
                }
            }
            return false;
        }
    }

    private void log(String message) {
        if (this.logger != null) {
            this.logger.logMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected void tlog(String msg) {
        if (this.tlogging) {
            if (this.logger != null) {
                this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.TX, msg);
            } else {
                System.out.println("-tx: " + msg);
            }
        }
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heirarchical) throws FHIRException {
        ValueSet vs = null;
        vs = this.fetchResource(ValueSet.class, binding.getValueSet());
        if (vs == null) {
            throw new FHIRException(this.formatMessage("Unable_to_resolve_value_Set_", new Object[]{binding.getValueSet()}));
        }
        return this.expandVS(vs, cacheOk, heirarchical);
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean hierarchical) throws TerminologyServiceException {
        ValueSetExpander.ValueSetExpansionOutcome res;
        TerminologyCache.CacheToken cacheToken;
        block7: {
            ValueSet vs = new ValueSet();
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setCompose(new ValueSet.ValueSetComposeComponent());
            vs.getCompose().getInclude().add(inc);
            cacheToken = this.txCache.generateExpandToken(vs, hierarchical);
            res = this.txCache.getExpansion(cacheToken);
            if (res != null) {
                return res;
            }
            Parameters p = this.expParameters.copy();
            p.setParameter("includeDefinition", false);
            p.setParameter("excludeNested", !hierarchical);
            boolean cached = this.addDependentResources(p, vs);
            if (cached) {
                p.addParameter().setName("cache-id").setValue(new StringType(this.cacheId));
            }
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            if (this.noTerminologyServer) {
                return new ValueSetExpander.ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", Integer.toString(this.expandCodesLimit));
            params.put("_incomplete", "true");
            this.tlog("$expand on " + this.txCache.summary(vs));
            try {
                ValueSet result = this.txClient.expandValueset(vs, p, params);
                res = new ValueSetExpander.ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
            }
            catch (Exception e) {
                res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
                if (this.txLog == null) break block7;
                res.setTxLink(this.txLog.getLastId());
            }
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_Expansion_Parameters_provided", new Object[0]));
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, p);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical, Parameters p) {
        ValueSetExpander.ValueSetExpansionOutcome res;
        if (p == null) {
            throw new Error(this.formatMessage("No_Parameters_provided_to_expandVS", new Object[0]));
        }
        if (vs.hasExpansion()) {
            return new ValueSetExpander.ValueSetExpansionOutcome(vs.copy());
        }
        if (!vs.hasUrl()) {
            throw new Error(this.formatMessage("no_value_set", new Object[0]));
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, heirarchical);
        if (cacheOk && (res = this.txCache.getExpansion(cacheToken)) != null) {
            return res;
        }
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !heirarchical);
        ArrayList<String> allErrors = new ArrayList<String>();
        ValueSetExpanderSimple vse = new ValueSetExpanderSimple(this);
        try {
            res = vse.expand(vs, p);
            allErrors.addAll(vse.getAllErrors());
            if (res.getValueset() != null) {
                if (!res.getValueset().hasUrl()) {
                    throw new Error(this.formatMessage("no_url_in_expand_value_set", new Object[0]));
                }
                this.txCache.cacheExpansion(cacheToken, res, false);
                return res;
            }
        }
        catch (Exception e) {
            allErrors.addAll(vse.getAllErrors());
            e.printStackTrace();
        }
        if (this.addDependentResources(p, vs)) {
            p.addParameter().setName("cache-id").setValue(new StringType(this.cacheId));
        }
        if (this.noTerminologyServer) {
            return new ValueSetExpander.ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE, allErrors);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("_limit", Integer.toString(this.expandCodesLimit));
        params.put("_incomplete", "true");
        this.tlog("$expand on " + this.txCache.summary(vs));
        try {
            ValueSet result = this.txClient.expandValueset(vs, p, params);
            if (!result.hasUrl()) {
                result.setUrl(vs.getUrl());
            }
            if (!result.hasUrl()) {
                throw new Error(this.formatMessage("no_url_in_expand_value_set_2", new Object[0]));
            }
            res = new ValueSetExpander.ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
        }
        catch (Exception e) {
            res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN, allErrors).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    private boolean hasTooCostlyExpansion(ValueSet valueset) {
        return valueset != null && valueset.hasExpansion() && ToolingExtensions.hasExtension(valueset.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String system, String code, String display) {
        assert (options != null);
        Coding c = new Coding(system, code, display);
        return this.validateCode(options, c, null);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String system, String code, String display, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(system, code, display);
        return this.validateCode(options, c, vs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String code, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(null, code, null);
        return this.validateCode(options.guessSystem(), c, vs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateCodeBatch(ValidationOptions options, List<? extends IWorkerContext.CodingValidationRequest> codes, ValueSet vs) {
        if (options == null) {
            options = ValidationOptions.defaults();
        }
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            codingValidationRequest.setCacheToken(this.txCache != null ? this.txCache.generateValidationToken(options, codingValidationRequest.getCoding(), vs) : null);
            if (codingValidationRequest.getCoding().hasSystem()) {
                this.codeSystemsUsed.add(codingValidationRequest.getCoding().getSystem());
            }
            if (this.txCache == null) continue;
            codingValidationRequest.setResult(this.txCache.getValidation(codingValidationRequest.getCacheToken()));
        }
        if (options.isUseClient()) {
            for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
                if (codingValidationRequest.hasResult()) continue;
                try {
                    ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(options, vs, this);
                    IWorkerContext.ValidationResult validationResult = vsc.validateCode(codingValidationRequest.getCoding());
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(codingValidationRequest.getCacheToken(), validationResult, false);
                    }
                    codingValidationRequest.setResult(validationResult);
                }
                catch (Exception vsc) {}
            }
        }
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            if (codingValidationRequest.hasResult()) continue;
            if (!options.isUseServer()) {
                codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS));
                continue;
            }
            if (this.unsupportedCodeSystems.contains(codingValidationRequest.getCoding().getSystem())) {
                codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Terminology_TX_System_NotKnown", new Object[]{codingValidationRequest.getCoding().getSystem()}), ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED));
                continue;
            }
            if (!this.noTerminologyServer) continue;
            codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        Bundle batch = new Bundle();
        batch.setType(Bundle.BundleType.BATCH);
        HashSet<String> hashSet = new HashSet<String>();
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            if (codingValidationRequest.hasResult()) continue;
            Parameters pIn = new Parameters();
            pIn.addParameter().setName("coding").setValue(codingValidationRequest.getCoding());
            if (options.isGuessSystem()) {
                pIn.addParameter().setName("implySystem").setValue(new BooleanType(true));
            }
            if (vs != null) {
                pIn.addParameter().setName("valueSet").setResource(vs);
            }
            pIn.addParameter().setName("profile").setResource(this.expParameters);
            this.setTerminologyOptions(options, pIn);
            Bundle.BundleEntryComponent be = batch.addEntry();
            be.setResource(pIn);
            be.getRequest().setMethod(Bundle.HTTPVerb.POST);
            be.getRequest().setUrl("CodeSystem/$validate-code");
            be.setUserData("source", codingValidationRequest);
            hashSet.add(codingValidationRequest.getCoding().getSystem());
        }
        if (batch.getEntry().size() > 0) {
            void var7_17;
            this.tlog("$batch validate for " + batch.getEntry().size() + " codes on systems " + ((Object)hashSet).toString());
            if (this.txClient == null) {
                throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
            }
            if (this.txLog != null) {
                this.txLog.clearLastId();
            }
            Bundle resp = this.txClient.validateBatch(batch);
            boolean bl = false;
            while (var7_17 < batch.getEntry().size()) {
                IWorkerContext.CodingValidationRequest t = (IWorkerContext.CodingValidationRequest)batch.getEntry().get((int)var7_17).getUserData("source");
                Bundle.BundleEntryComponent r = resp.getEntry().get((int)var7_17);
                if (r.getResource() instanceof Parameters) {
                    t.setResult(this.processValidationResult((Parameters)r.getResource()));
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(t.getCacheToken(), t.getResult(), true);
                    }
                } else {
                    t.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.getResponseText(r.getResource())).setTxLink(this.txLog == null ? null : this.txLog.getLastId()));
                }
                ++var7_17;
            }
        }
    }

    private String getResponseText(Resource resource) {
        if (resource instanceof OperationOutcome) {
            return OperationOutcomeRenderer.toString((OperationOutcome)resource);
        }
        return "Todo";
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs) {
        String csumm;
        if (options == null) {
            options = ValidationOptions.defaults();
        }
        if (code.hasSystem()) {
            this.codeSystemsUsed.add(code.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.txCache != null ? this.txCache.generateValidationToken(options, code, vs) : null;
        IWorkerContext.ValidationResult res = null;
        if (this.txCache != null) {
            res = this.txCache.getValidation(cacheToken);
        }
        if (res != null) {
            return res;
        }
        if (options.isUseClient()) {
            try {
                ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(options, vs, this);
                if (!vsc.isServerSide(code.getSystem())) {
                    res = vsc.validateCode(code);
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(cacheToken, res, false);
                    }
                    return res;
                }
            }
            catch (Exception vsc) {
                // empty catch block
            }
        }
        if (!options.isUseServer()) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS);
        }
        if (this.unsupportedCodeSystems.contains(code.getSystem())) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Terminology_TX_System_NotKnown", new Object[]{code.getSystem()}), ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
        }
        if (this.noTerminologyServer) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[0]), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        String string = csumm = this.txCache != null ? this.txCache.summary(code) : null;
        if (this.txCache != null) {
            this.tlog("$validate " + csumm + " for " + this.txCache.summary(vs));
        } else {
            this.tlog("$validate " + csumm + " before cache exists");
        }
        try {
            Parameters pIn = new Parameters();
            pIn.addParameter().setName("coding").setValue(code);
            if (options.isGuessSystem()) {
                pIn.addParameter().setName("implySystem").setValue(new BooleanType(true));
            }
            this.setTerminologyOptions(options, pIn);
            res = this.validateOnServer(vs, pIn, options);
        }
        catch (Exception e) {
            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage()).setTxLink(this.txLog == null ? null : this.txLog.getLastId()).setErrorClass(ValueSetExpander.TerminologyServiceErrorClass.SERVER_ERROR);
        }
        if (res.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
            this.unsupportedCodeSystems.add(code.getSystem());
        } else if (this.txCache != null) {
            this.txCache.cacheValidation(cacheToken, res, true);
        }
        return res;
    }

    private void setTerminologyOptions(ValidationOptions options, Parameters pIn) {
        if (!Utilities.noString((String)options.getLanguage())) {
            pIn.addParameter("displayLanguage", options.getLanguage());
        }
        if (options.getValueSetMode() != ValidationOptions.ValueSetMode.ALL_CHECKS) {
            pIn.addParameter("valueSetMode", options.getValueSetMode().toString());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, CodeableConcept code, ValueSet vs) {
        IWorkerContext.ValidationResult res;
        TerminologyCache.CacheToken cacheToken;
        block9: {
            cacheToken = this.txCache.generateValidationToken(options, code, vs);
            res = this.txCache.getValidation(cacheToken);
            if (res != null) {
                return res;
            }
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) continue;
                this.codeSystemsUsed.add(c.getSystem());
            }
            if (options.isUseClient()) {
                try {
                    ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(options, vs, this);
                    res = vsc.validateCode(code);
                    this.txCache.cacheValidation(cacheToken, res, false);
                    return res;
                }
                catch (Exception e) {
                    if (!(e instanceof NoTerminologyServiceException)) break block9;
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "No Terminology Service", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
                }
            }
        }
        if (!options.isUseServer()) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Unable to validate code without using server", ValueSetExpander.TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS);
        }
        if (this.noTerminologyServer) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        this.tlog("$validate " + this.txCache.summary(code) + " for " + this.txCache.summary(vs));
        try {
            Parameters pIn = new Parameters();
            pIn.addParameter().setName("codeableConcept").setValue(code);
            this.setTerminologyOptions(options, pIn);
            res = this.validateOnServer(vs, pIn, options);
        }
        catch (Exception e) {
            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage()).setTxLink(this.txLog.getLastId());
        }
        this.txCache.cacheValidation(cacheToken, res, true);
        return res;
    }

    private IWorkerContext.ValidationResult validateOnServer(ValueSet vs, Parameters pin, ValidationOptions options) throws FHIRException {
        boolean cache = false;
        if (vs != null) {
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
        }
        if (vs != null) {
            if (this.isTxCaching && this.cacheId != null && this.cached.contains(vs.getUrl() + "|" + vs.getVersion())) {
                pin.addParameter().setName("url").setValue(new UriType(vs.getUrl() + (vs.hasVersion() ? "|" + vs.getVersion() : "")));
            } else if (options.getVsAsUrl()) {
                pin.addParameter().setName("url").setValue(new StringType(vs.getUrl()));
            } else {
                pin.addParameter().setName("valueSet").setResource(vs);
                this.cached.add(vs.getUrl() + "|" + vs.getVersion());
            }
            cache = true;
            this.addDependentResources(pin, vs);
        }
        if (cache) {
            pin.addParameter().setName("cache-id").setValue(new StringType(this.cacheId));
        }
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error(this.formatMessage("Can_only_specify_profile_in_the_context", new Object[0]));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        pin.addParameter().setName("profile").setResource(this.expParameters);
        if (this.txLog != null) {
            this.txLog.clearLastId();
        }
        if (this.txClient == null) {
            throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
        }
        Parameters pOut = vs == null ? this.txClient.validateCS(pin) : this.txClient.validateVS(pin);
        return this.processValidationResult(pOut);
    }

    private boolean addDependentResources(Parameters pin, ValueSet vs) {
        boolean cache = false;
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            cache = this.addDependentResources(pin, inc) || cache;
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            cache = this.addDependentResources(pin, inc) || cache;
        }
        return cache;
    }

    private boolean addDependentResources(Parameters pin, ValueSet.ConceptSetComponent inc) {
        boolean cache = false;
        for (CanonicalType c : inc.getValueSet()) {
            ValueSet vs = this.fetchResource(ValueSet.class, (String)c.getValue());
            if (vs == null) continue;
            pin.addParameter().setName("tx-resource").setResource(vs);
            if (this.isTxCaching && this.cacheId == null || !this.cached.contains(vs.getVUrl())) {
                this.cached.add(vs.getVUrl());
                cache = true;
            }
            this.addDependentResources(pin, vs);
        }
        CodeSystem cs = this.fetchResource(CodeSystem.class, inc.getSystem());
        if (cs != null) {
            pin.addParameter().setName("tx-resource").setResource(cs);
            if (this.isTxCaching && this.cacheId == null || !this.cached.contains(cs.getVUrl())) {
                this.cached.add(cs.getVUrl());
                cache = true;
            }
        }
        return cache;
    }

    public IWorkerContext.ValidationResult processValidationResult(Parameters pOut) {
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        String system = null;
        String code = null;
        ValueSetExpander.TerminologyServiceErrorClass err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (!p.hasValue()) continue;
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("display")) {
                display = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("system")) {
                system = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("code")) {
                code = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("cause")) continue;
            try {
                ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                if (it == ValidationMessage.IssueType.UNKNOWN) {
                    err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
                    continue;
                }
                if (it == ValidationMessage.IssueType.NOTFOUND) {
                    err = ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED;
                    continue;
                }
                if (it != ValidationMessage.IssueType.NOTSUPPORTED) continue;
                err = ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
            }
            catch (FHIRException fHIRException) {}
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message + " (from " + this.txClient.getAddress() + ")", err).setTxLink(this.txLog.getLastId());
        }
        if (message != null && !message.equals("No Message returned")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, message + " (from " + this.txClient.getAddress() + ")", system, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code)).setTxLink(this.txLog.getLastId());
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code)).setTxLink(this.txLog.getLastId());
        }
        return new IWorkerContext.ValidationResult(system, new CodeSystem.ConceptDefinitionComponent().setCode(code)).setTxLink(this.txLog.getLastId());
    }

    public void initTS(String cachePath) throws Exception {
        if (!new File(cachePath).exists()) {
            Utilities.createDirectory((String)cachePath);
        }
        this.txCache = new TerminologyCache(this.lock, cachePath);
    }

    public void clearTSCache(String url) throws Exception {
        this.txCache.removeCS(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConceptMap> findMapsForSource(String url) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
            for (ConceptMap map : this.maps.getList()) {
                if (!((Reference)map.getSource()).getReference().equals(url)) continue;
                res.add(map);
            }
            return res;
        }
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    @Override
    public void setLogger(IWorkerContext.ILoggingService logger) {
        this.logger = logger;
    }

    @Override
    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    @Override
    public void setExpansionProfile(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    @Override
    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer;
    }

    public void setNoTerminologyServer(boolean noTerminologyServer) {
        this.noTerminologyServer = noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        return this.fetchResourceWithException(class_, uri, null);
    }

    public <T extends Resource> T fetchResourceWithException(String cls, String uri) throws FHIRException {
        return this.fetchResourceWithException(cls, uri, null);
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, CanonicalResource source) throws FHIRException {
        if (uri == null) {
            return null;
        }
        if (class_ == StructureDefinition.class) {
            uri = ProfileUtilities.sdNs(uri, this.getOverrideVersionNs());
        }
        Object object = this.lock;
        synchronized (object) {
            String version = null;
            if (uri.contains("|")) {
                version = uri.substring(uri.lastIndexOf("|") + 1);
                uri = uri.substring(0, uri.lastIndexOf("|"));
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (class_ == Resource.class || class_ == null) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                for (Map<String, Resource> rt : this.allResourcesById.values()) {
                    for (Resource r : rt.values()) {
                        CanonicalResource mr;
                        if (!(r instanceof CanonicalResource) || !uri.equals((mr = (CanonicalResource)r).getUrl())) continue;
                        return (T)mr;
                    }
                }
                return null;
            }
            if (class_ == ImplementationGuide.class) {
                return (T)this.guides.get(uri, version);
            }
            if (class_ == CapabilityStatement.class) {
                return (T)this.capstmts.get(uri, version);
            }
            if (class_ == Measure.class) {
                return (T)this.measures.get(uri, version);
            }
            if (class_ == Library.class) {
                return (T)this.libraries.get(uri, version);
            }
            if (class_ == StructureDefinition.class) {
                return (T)this.structures.get(uri, version);
            }
            if (class_ == StructureMap.class) {
                return (T)this.transforms.get(uri, version);
            }
            if (class_ == ValueSet.class) {
                return (T)this.valueSets.get(uri, version);
            }
            if (class_ == CodeSystem.class) {
                return (T)this.codeSystems.get(uri, version);
            }
            if (class_ == ConceptMap.class) {
                return (T)this.maps.get(uri, version);
            }
            if (class_ == PlanDefinition.class) {
                return (T)this.plans.get(uri, version);
            }
            if (class_ == OperationDefinition.class) {
                OperationDefinition od = this.operations.get(uri, version);
                return (T)od;
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version);
            }
            if (class_ == SearchParameter.class) {
                SearchParameter res = this.searchParameters.get(uri, version);
                return (T)res;
            }
            if (class_ == CodeSystem.class && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version);
            }
            if (class_ == ValueSet.class && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version);
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version);
            }
            if (class_ == null) {
                T res;
                if (uri.matches("((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkerContext.PackageVersion getPackageForUrl(String uri) {
        if (uri == null) {
            return null;
        }
        uri = ProfileUtilities.sdNs(uri, this.getOverrideVersionNs());
        Object object = this.lock;
        synchronized (object) {
            String version = null;
            if (uri.contains("|")) {
                version = uri.substring(uri.lastIndexOf("|") + 1);
                uri = uri.substring(0, uri.lastIndexOf("|"));
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (this.structures.has(uri)) {
                return this.structures.getPackageInfo(uri, version);
            }
            if (this.guides.has(uri)) {
                return this.guides.getPackageInfo(uri, version);
            }
            if (this.capstmts.has(uri)) {
                return this.capstmts.getPackageInfo(uri, version);
            }
            if (this.measures.has(uri)) {
                return this.measures.getPackageInfo(uri, version);
            }
            if (this.libraries.has(uri)) {
                return this.libraries.getPackageInfo(uri, version);
            }
            if (this.valueSets.has(uri)) {
                return this.valueSets.getPackageInfo(uri, version);
            }
            if (this.codeSystems.has(uri)) {
                return this.codeSystems.getPackageInfo(uri, version);
            }
            if (this.operations.has(uri)) {
                return this.operations.getPackageInfo(uri, version);
            }
            if (this.searchParameters.has(uri)) {
                return this.searchParameters.getPackageInfo(uri, version);
            }
            if (this.plans.has(uri)) {
                return this.plans.getPackageInfo(uri, version);
            }
            if (this.maps.has(uri)) {
                return this.maps.getPackageInfo(uri, version);
            }
            if (this.transforms.has(uri)) {
                return this.transforms.getPackageInfo(uri, version);
            }
            if (this.questionnaires.has(uri)) {
                return this.questionnaires.getPackageInfo(uri, version);
            }
            return null;
        }
    }

    public <T extends Resource> T fetchResourceWithException(String cls, String uri, CanonicalResource source) throws FHIRException {
        if (uri == null) {
            return null;
        }
        if ("StructureDefinition".equals(cls)) {
            uri = ProfileUtilities.sdNs(uri, this.getOverrideVersionNs());
        }
        Object object = this.lock;
        synchronized (object) {
            String version = null;
            if (uri.contains("|")) {
                version = uri.substring(uri.lastIndexOf("|") + 1);
                uri = uri.substring(0, uri.lastIndexOf("|"));
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (cls == null || "Resource".equals(cls)) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                for (Map<String, Resource> rt : this.allResourcesById.values()) {
                    for (Resource r : rt.values()) {
                        CanonicalResource mr;
                        if (!(r instanceof CanonicalResource) || !uri.equals((mr = (CanonicalResource)r).getUrl())) continue;
                        return (T)mr;
                    }
                }
            } else {
                if ("ImplementationGuide".equals(cls)) {
                    return (T)this.guides.get(uri, version);
                }
                if ("CapabilityStatement".equals(cls)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if ("Measure".equals(cls)) {
                    return (T)this.measures.get(uri, version);
                }
                if ("Library".equals(cls)) {
                    return (T)this.libraries.get(uri, version);
                }
                if ("StructureDefinition".equals(cls)) {
                    return (T)this.structures.get(uri, version);
                }
                if ("StructureMap".equals(cls)) {
                    return (T)this.transforms.get(uri, version);
                }
                if ("ValueSet".equals(cls)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if ("CodeSystem".equals(cls)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if ("ConceptMap".equals(cls)) {
                    return (T)this.maps.get(uri, version);
                }
                if ("PlanDefinition".equals(cls)) {
                    return (T)this.plans.get(uri, version);
                }
                if ("OperationDefinition".equals(cls)) {
                    OperationDefinition od = this.operations.get(uri, version);
                    return (T)od;
                }
                if ("Questionnaire.class".equals(cls)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                if ("SearchParameter.class".equals(cls)) {
                    SearchParameter res = this.searchParameters.get(uri, version);
                    return (T)res;
                }
            }
            if ("CodeSystem".equals(cls) && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version);
            }
            if ("ValueSet".equals(cls) && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version);
            }
            if ("Questionnaire".equals(cls)) {
                return (T)this.questionnaires.get(uri, version);
            }
            if (cls == null) {
                T res;
                if (uri.matches("((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    @Override
    public Resource fetchResourceById(String type, String uri) {
        Object object = this.lock;
        synchronized (object) {
            String[] parts = uri.split("\\/");
            if (!Utilities.noString((String)type) && parts.length == 1) {
                if (this.allResourcesById.containsKey(type)) {
                    return this.allResourcesById.get(type).get(parts[0]);
                }
                return null;
            }
            if (parts.length >= 2) {
                if (!Utilities.noString((String)type) && !type.equals(parts[parts.length - 2])) {
                    throw new Error(this.formatMessage("Resource_type_mismatch_for___", new Object[]{type, uri}));
                }
                return this.allResourcesById.get(parts[parts.length - 2]).get(parts[parts.length - 1]);
            }
            throw new Error(this.formatMessage("Unable_to_process_request_for_resource_for___", new Object[]{type, uri}));
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, CanonicalResource source) {
        try {
            return this.fetchResourceWithException(class_, uri, source);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri, null);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResource(String cls, String uri) {
        try {
            return this.fetchResourceWithException(cls, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public TranslationServices translator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStatus(JsonObject json) {
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("codeystem-count", (Number)this.codeSystems.size());
            json.addProperty("valueset-count", (Number)this.valueSets.size());
            json.addProperty("conceptmap-count", (Number)this.maps.size());
            json.addProperty("transforms-count", (Number)this.transforms.size());
            json.addProperty("structures-count", (Number)this.structures.size());
            json.addProperty("guides-count", (Number)this.guides.size());
            json.addProperty("statements-count", (Number)this.capstmts.size());
            json.addProperty("measures-count", (Number)this.measures.size());
            json.addProperty("libraries-count", (Number)this.libraries.size());
        }
    }

    public void dropResource(Resource r) throws FHIRException {
        this.dropResource(r.fhirType(), r.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String fhirType, String id) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(fhirType);
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(fhirType, map);
            }
            if (map.containsKey(id)) {
                map.remove(id);
            }
            if (fhirType.equals("StructureDefinition")) {
                this.structures.drop(id);
            } else if (fhirType.equals("ImplementationGuide")) {
                this.guides.drop(id);
            } else if (fhirType.equals("CapabilityStatement")) {
                this.capstmts.drop(id);
            } else if (fhirType.equals("Measure")) {
                this.measures.drop(id);
            } else if (fhirType.equals("Library")) {
                this.libraries.drop(id);
            } else if (fhirType.equals("ValueSet")) {
                this.valueSets.drop(id);
            } else if (fhirType.equals("CodeSystem")) {
                this.codeSystems.drop(id);
            } else if (fhirType.equals("OperationDefinition")) {
                this.operations.drop(id);
            } else if (fhirType.equals("Questionnaire")) {
                this.questionnaires.drop(id);
            } else if (fhirType.equals("ConceptMap")) {
                this.maps.drop(id);
            } else if (fhirType.equals("StructureMap")) {
                this.transforms.drop(id);
            } else if (fhirType.equals("NamingSystem")) {
                this.systems.drop(id);
            }
        }
    }

    private <T extends CanonicalResource> void dropMetadataResource(Map<String, T> map, String id) {
        CanonicalResource res = (CanonicalResource)map.get(id);
        if (res != null) {
            map.remove(id);
            if (map.containsKey(res.getUrl())) {
                map.remove(res.getUrl());
            }
            if (res.getVersion() != null && map.containsKey(res.getUrl() + "|" + res.getVersion())) {
                map.remove(res.getUrl() + "|" + res.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CanonicalResource> allConformanceResources() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CanonicalResource> result = new ArrayList<CanonicalResource>();
            this.structures.listAllM(result);
            this.guides.listAllM(result);
            this.capstmts.listAllM(result);
            this.measures.listAllM(result);
            this.libraries.listAllM(result);
            this.codeSystems.listAllM(result);
            this.valueSets.listAllM(result);
            this.maps.listAllM(result);
            this.transforms.listAllM(result);
            this.plans.listAllM(result);
            this.questionnaires.listAllM(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSupportedSystems() {
        Object object = this.lock;
        synchronized (object) {
            String sl = null;
            for (String s : this.supportedCodeSystems) {
                sl = sl == null ? s : sl + "\r\n" + s;
            }
            return sl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConceptMap> listMaps() {
        ArrayList<ConceptMap> m = new ArrayList<ConceptMap>();
        Object object = this.lock;
        synchronized (object) {
            this.maps.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StructureMap> listTransforms() {
        ArrayList<StructureMap> m = new ArrayList<StructureMap>();
        Object object = this.lock;
        synchronized (object) {
            this.transforms.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructureMap getTransform(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.transforms.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StructureDefinition> listStructures() {
        ArrayList<StructureDefinition> m = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureDefinition getStructure(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.structures.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String oid2Uri(String oid) {
        Object object = this.lock;
        synchronized (object) {
            if (oid != null && oid.startsWith("urn:oid:")) {
                oid = oid.substring(8);
            }
            if (this.oidCache.containsKey(oid)) {
                return this.oidCache.get(oid);
            }
            String uri = OIDUtils.getUriForOid((String)oid);
            if (uri != null) {
                this.oidCache.put(oid, uri);
                return uri;
            }
            CodeSystem cs = this.fetchCodeSystem("http://terminology.hl7.org/CodeSystem/v2-tables");
            if (cs != null) {
                for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
                    for (CodeSystem.ConceptPropertyComponent cp : cc.getProperty()) {
                        if (!Utilities.existsInList((String)cp.getCode(), (String[])new String[]{"v2-table-oid", "v2-cs-oid"}) || !oid.equals(cp.getValue().primitiveValue())) continue;
                        for (CodeSystem.ConceptPropertyComponent cp2 : cc.getProperty()) {
                            if (!"v2-cs-uri".equals(cp2.getCode())) continue;
                            this.oidCache.put(oid, cp2.getValue().primitiveValue());
                            return cp2.getValue().primitiveValue();
                        }
                    }
                }
            }
            for (CodeSystem css : this.codeSystems.getList()) {
                if (("urn:oid:" + oid).equals(css.getUrl())) {
                    this.oidCache.put(oid, css.getUrl());
                    return css.getUrl();
                }
                for (Identifier id : css.getIdentifier()) {
                    if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !("urn:oid:" + oid).equals(id.getValue())) continue;
                    this.oidCache.put(oid, css.getUrl());
                    return css.getUrl();
                }
            }
            for (NamingSystem ns : this.systems.getList()) {
                if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
                this.oidCache.put(oid, null);
                return null;
            }
        }
        this.oidCache.put(oid, null);
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVS(JsonObject json, Map<String, IWorkerContext.ValidationResult> t) {
        Object object = this.lock;
        synchronized (object) {
            this.validationCache.put(json.get("url").getAsString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchParameter getSearchParameter(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.searchParameters.get(code);
        }
    }

    @Override
    public String getOverrideVersionNs() {
        return this.overrideVersionNs;
    }

    @Override
    public void setOverrideVersionNs(String value) {
        this.overrideVersionNs = value;
    }

    @Override
    public IWorkerContext.ILoggingService getLogger() {
        return this.logger;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        if (Utilities.isAbsoluteUrl((String)typeName)) {
            return this.fetchResource(StructureDefinition.class, typeName);
        }
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public boolean isTlogging() {
        return this.tlogging;
    }

    public void setTlogging(boolean tlogging) {
        this.tlogging = tlogging;
    }

    @Override
    public UcumService getUcumService() {
        return this.ucumService;
    }

    @Override
    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StructureDefinition> getStructures() {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(res);
        }
        return res;
    }

    @Override
    public String getLinkForUrl(String corePath, String url) {
        if (url == null) {
            return null;
        }
        if (this.codeSystems.has(url)) {
            return this.codeSystems.get(url).getUserString("path");
        }
        if (this.valueSets.has(url)) {
            return this.valueSets.get(url).getUserString("path");
        }
        if (this.maps.has(url)) {
            return this.maps.get(url).getUserString("path");
        }
        if (this.transforms.has(url)) {
            return this.transforms.get(url).getUserString("path");
        }
        if (this.structures.has(url)) {
            return this.structures.get(url).getUserString("path");
        }
        if (this.guides.has(url)) {
            return this.guides.get(url).getUserString("path");
        }
        if (this.capstmts.has(url)) {
            return this.capstmts.get(url).getUserString("path");
        }
        if (this.measures.has(url)) {
            return this.measures.get(url).getUserString("path");
        }
        if (this.libraries.has(url)) {
            return this.libraries.get(url).getUserString("path");
        }
        if (this.searchParameters.has(url)) {
            return this.searchParameters.get(url).getUserString("path");
        }
        if (this.questionnaires.has(url)) {
            return this.questionnaires.get(url).getUserString("path");
        }
        if (this.operations.has(url)) {
            return this.operations.get(url).getUserString("path");
        }
        if (this.plans.has(url)) {
            return this.plans.get(url).getUserString("path");
        }
        if (url.equals("http://loinc.org")) {
            return corePath + "loinc.html";
        }
        if (url.equals("http://unitsofmeasure.org")) {
            return corePath + "ucum.html";
        }
        if (url.equals("http://snomed.info/sct")) {
            return corePath + "snomed.html";
        }
        return null;
    }

    public List<ImplementationGuide> allImplementationGuides() {
        ArrayList<ImplementationGuide> res = new ArrayList<ImplementationGuide>();
        this.guides.listAll(res);
        return res;
    }

    @Override
    public Map<String, byte[]> getBinaries() {
        return this.binaries;
    }

    public void finishLoading() {
        for (StructureDefinition sd : this.listStructures()) {
            try {
                if (!sd.getSnapshot().isEmpty()) continue;
                this.generateSnapshot(sd);
            }
            catch (Exception exception) {}
        }
    }

    protected String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "noname";
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    @Override
    public int getClientRetryCount() {
        return this.txClient == null ? 0 : this.txClient.getRetryCount();
    }

    @Override
    public IWorkerContext setClientRetryCount(int value) {
        if (this.txClient != null) {
            this.txClient.setRetryCount(value);
        }
        return this;
    }

    public String getTxCache() {
        return this.txCache.getFolder();
    }

    public TerminologyClient getTxClient() {
        return this.txClient;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public TerminologyCapabilities getTxCaps() {
        return this.txcaps;
    }

    public void setTxCaps(TerminologyCapabilities txCaps) {
        this.txcaps = txCaps;
        if (txCaps != null) {
            for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : this.txcaps.getExpansion().getParameter()) {
                if (!"cache-id".equals(t.getName())) continue;
                this.isTxCaching = true;
            }
            for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.txcaps.getCodeSystem()) {
                this.supportedCodeSystems.add(tccs.getUri());
            }
        }
    }

    @Override
    public TimeTracker clock() {
        return this.clock;
    }

    public int countAllCaches() {
        return this.codeSystems.size() + this.valueSets.size() + this.maps.size() + this.transforms.size() + this.structures.size() + this.measures.size() + this.libraries.size() + this.guides.size() + this.capstmts.size() + this.searchParameters.size() + this.questionnaires.size() + this.operations.size() + this.plans.size() + this.systems.size();
    }

    @Override
    public Set<String> getCodeSystemsUsed() {
        return this.codeSystemsUsed;
    }

    @Override
    public String getSpecUrl() {
        String v = this.getVersion();
        switch (VersionUtilities.getMajMin((String)v)) {
            case "1.0": {
                return "http://hl7.org/fhir/DSTU1";
            }
            case "1.4": {
                return "http://hl7.org/fhir/DSTU2";
            }
            case "3.0": {
                return "http://hl7.org/fhir/STU3";
            }
            case "4.0": {
                return "http://hl7.org/fhir/R4";
            }
            case "4.5": {
                return "http://build.fhir.org";
            }
            case "5.0": {
                return "http://build.fhir.org";
            }
        }
        return "http://hl7.org/fhir";
    }

    public IWorkerContext.ICanonicalResourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(IWorkerContext.ICanonicalResourceLocator locator) {
        this.locator = locator;
    }

    public class NullTranslator
    implements TranslationServices {
        public String translate(String context, String value, String targetLang) {
            return value;
        }

        public String translate(String context, String value) {
            return value;
        }

        public String toStr(float value) {
            return null;
        }

        public String toStr(Date value) {
            return null;
        }

        public String translateAndFormat(String contest, String lang, String value, Object ... args) {
            return String.format(value, args);
        }

        public Map<String, String> translations(String value) {
            return null;
        }

        public Set<String> listTranslations(String category) {
            return null;
        }
    }

    public class MetadataResourceVersionComparator<T extends CanonicalResource>
    implements Comparator<T> {
        private List<T> list;

        public MetadataResourceVersionComparator(List<T> list) {
            this.list = list;
        }

        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((CanonicalResource)arg1).getVersion();
            String v2 = ((CanonicalResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(this.list.indexOf(arg1), this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }
}

