/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CodeSystemRenderer
extends TerminologyRenderer {
    public CodeSystemRenderer(RenderingContext context) {
        super(context);
    }

    public CodeSystemRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (CodeSystem)dr);
    }

    public boolean render(XhtmlNode x, CodeSystem cs) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        if (this.context.isHeader()) {
            XhtmlNode h = x.h2();
            h.addText(cs.hasTitle() ? cs.getTitle() : cs.getName());
            this.addMarkdown(x, cs.getDescription());
            if (cs.hasCopyright()) {
                this.generateCopyright(x, cs);
            }
        }
        this.generateProperties(x, cs);
        this.generateFilters(x, cs);
        ArrayList<TerminologyRenderer.UsedConceptMap> maps = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        hasExtensions = this.generateCodeSystemContent(x, cs, hasExtensions, maps);
        return hasExtensions;
    }

    public void describe(XhtmlNode x, CodeSystem cs) {
        x.tx(this.display(cs));
    }

    public String display(CodeSystem cs) {
        return cs.present();
    }

    private void generateFilters(XhtmlNode x, CodeSystem cs) {
        if (cs.hasFilter()) {
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Filters", this.getContext().getLang()));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Description", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "operator", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Value", this.getContext().getLang()));
            for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                tr = tbl.tr();
                tr.td().tx(f.getCode());
                tr.td().tx(f.getDescription());
                XhtmlNode td = tr.td();
                for (Enumeration<Enumerations.FilterOperator> t : f.getOperator()) {
                    td.tx(t.asStringValue() + " ");
                }
                tr.td().tx(f.getValue());
            }
        }
    }

    private void generateProperties(XhtmlNode x, CodeSystem cs) {
        if (cs.hasProperty()) {
            boolean hasRendered = false;
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                hasRendered = hasRendered || !p.getCode().equals(ToolingExtensions.getPresentation(p, p.getCodeElement()));
            }
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Properties", this.getContext().getLang()));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            if (hasRendered) {
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Name", this.getContext().getLang()));
            }
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "URL", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Description", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Type", this.getContext().getLang()));
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                tr = tbl.tr();
                if (hasRendered) {
                    tr.td().tx(ToolingExtensions.getPresentation(p, p.getCodeElement()));
                }
                tr.td().tx(p.getCode());
                tr.td().tx(p.getUri());
                tr.td().tx(p.getDescription());
                tr.td().tx(p.hasType() ? p.getType().toCode() : "");
            }
        }
    }

    private boolean generateCodeSystemContent(XhtmlNode x, CodeSystem cs, boolean hasExtensions, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode p = x.para();
        if (cs.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE) {
            p.tx(this.getContext().getWorker().translator().translateAndFormat("xhtml-gen-cs", this.getContext().getLang(), "This code system %s defines the following codes", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.EXAMPLE) {
            p.tx(this.getContext().getWorker().translator().translateAndFormat("xhtml-gen-cs", this.getContext().getLang(), "This code system %s defines many codes, of which the following are some examples", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
            p.tx(this.getContext().getWorker().translator().translateAndFormat("xhtml-gen-cs", this.getContext().getLang(), "This code system %s defines many codes, of which the following are a subset", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
            p.tx(this.getContext().getWorker().translator().translateAndFormat("xhtml-gen-cs", this.getContext().getLang(), "This code system %s defines many codes, but they are not represented here", new Object[]{cs.getUrl()}));
            return false;
        }
        XhtmlNode t = x.table("codes");
        boolean definitions = false;
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        boolean version = false;
        boolean ignoreStatus = false;
        ArrayList<CodeSystem.PropertyComponent> properties = new ArrayList<CodeSystem.PropertyComponent>();
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!this.showPropertyInTable(cp)) continue;
            boolean exists = false;
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                exists = exists || this.conceptsHaveProperty(c, cp);
            }
            if (!exists) continue;
            properties.add(cp);
            if (!"status".equals(cp.getCode())) continue;
            ignoreStatus = true;
        }
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(cs, c, ignoreStatus);
            display = display || this.conceptsHaveDisplay(c);
            version = version || this.conceptsHaveVersion(c);
            hierarchy = hierarchy || c.hasConcept();
            definitions = definitions || this.conceptsHaveDefinition(c);
        }
        CodeSystemUtilities.CodeSystemNavigator csNav = new CodeSystemUtilities.CodeSystemNavigator(cs);
        hierarchy = hierarchy || csNav.isRestructure();
        ArrayList<String> langs = new ArrayList<String>();
        this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, definitions, commentS, version, deprecated, properties, null, false), maps);
        for (CodeSystem.ConceptDefinitionComponent c : csNav.getConcepts(null)) {
            hasExtensions = this.addDefineRowToTable(t, c, 0, hierarchy, display, definitions, commentS, version, deprecated, maps, cs.getUrl(), cs, properties, csNav, langs) || hasExtensions;
        }
        if (langs.size() > 0) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private boolean conceptsHaveDefinition(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDefinition()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDefinition(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveProperty(CodeSystem.ConceptDefinitionComponent c, CodeSystem.PropertyComponent cp) {
        if (CodeSystemUtilities.hasProperty(c, cp.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveProperty(g, cp)) continue;
            return true;
        }
        return false;
    }

    private boolean showPropertyInTable(CodeSystem.PropertyComponent cp) {
        if (cp.hasCode()) {
            if (cp.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            if (cp.getCodeElement().hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            String uri = cp.getUri();
            String code = null;
            if (Utilities.noString((String)uri)) {
                return false;
            }
            if (uri.contains("#")) {
                code = uri.substring(uri.indexOf("#") + 1);
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (Utilities.existsInList((String)uri, (String[])new String[]{"http://hl7.org/fhir/concept-properties"}) || this.context.getCodeSystemPropList().contains(uri)) {
                return true;
            }
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(uri);
            if (cs == null) {
                return false;
            }
            return CodeSystemUtilities.hasCode(cs, code);
        }
        return false;
    }

    private int countConcepts(List<CodeSystem.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private boolean conceptsHaveComments(CodeSystem.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasCSComment(c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveComments(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDisplay()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveVersion(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasUserData("cs.version.notes")) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveVersion(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c, boolean ignoreStatus) {
        if (CodeSystemUtilities.isDeprecated(cs, c, ignoreStatus)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(cs, g, ignoreStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean addDefineRowToTable(XhtmlNode t, CodeSystem.ConceptDefinitionComponent c, int level, boolean hasHierarchy, boolean hasDisplay, boolean hasDefinitions, boolean comment, boolean version, boolean deprecated, List<TerminologyRenderer.UsedConceptMap> maps, String system, CodeSystem cs, List<CodeSystem.PropertyComponent> properties, CodeSystemUtilities.CodeSystemNavigator csNav, List<String> langs) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode a;
        boolean hasExtensions = false;
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        if (hasHierarchy) {
            td.addText(Integer.toString(level + 1));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(level * 2));
            td.addText(s);
        }
        td.attribute("style", "white-space:nowrap").addText(c.getCode());
        if (c.hasCodeElement()) {
            td.an(cs.getId() + "-" + Utilities.nmtokenize((String)c.getCode()));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
            if (!conceptDefinitionDesignationComponent.hasLanguage() || langs.contains(conceptDefinitionDesignationComponent.getLanguage()) || cs.hasLanguage() && cs.getLanguage().equals(conceptDefinitionDesignationComponent.getLanguage())) continue;
            langs.add(conceptDefinitionDesignationComponent.getLanguage());
        }
        if (hasDisplay) {
            td = tr.td();
            this.renderDisplayName(c, cs, td);
        }
        if (hasDefinitions) {
            td = tr.td();
            if (c != null && c.hasDefinitionElement()) {
                if (this.getContext().getLang() == null) {
                    if (this.hasMarkdownInDefinitions(cs)) {
                        this.addMarkdown(td, c.getDefinition());
                    } else {
                        td.addText(c.getDefinition());
                    }
                } else if (this.getContext().getLang().equals("*")) {
                    boolean sl = false;
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                        sl = true;
                    }
                    td.addText((sl ? cs.getLanguage("en") + ": " : "") + c.getDefinition());
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                        td.br();
                        td.addText(cd.getLanguage() + ": " + cd.getValue());
                    }
                } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                    td.addText(c.getDefinition());
                } else {
                    for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
                        if (!conceptDefinitionDesignationComponent.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !conceptDefinitionDesignationComponent.hasLanguage() || !conceptDefinitionDesignationComponent.getLanguage().equals(this.getContext().getLang())) continue;
                        td.addText(conceptDefinitionDesignationComponent.getValue());
                    }
                }
            }
        }
        if (deprecated) {
            td = tr.td();
            Boolean b = CodeSystemUtilities.isDeprecated(cs, c, false);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Deprecated", this.getContext().getLang()));
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby")) {
                    Coding coding = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby").getValue();
                    td.tx(" (replaced by ");
                    String url = this.getCodingReference(coding, system);
                    if (url != null) {
                        td.ah(url).addText(coding.getCode());
                        td.tx(": " + coding.getDisplay() + ")");
                    } else {
                        td.addText(coding.getCode() + " '" + coding.getDisplay() + "' in " + coding.getSystem() + ")");
                    }
                }
            }
        }
        if (comment) {
            td = tr.td();
            Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments");
            if (ext != null) {
                hasExtensions = true;
                String string = ext.hasValue() ? ext.getValue().primitiveValue() : null;
                Map<String, String> translations = ToolingExtensions.getLanguageTranslations(ext.getValue());
                if (this.getContext().getLang() == null) {
                    if (string != null) {
                        td.addText(string);
                    }
                } else if (this.getContext().getLang().equals("*")) {
                    boolean sl = false;
                    for (String l : translations.keySet()) {
                        if (string != null && string.equalsIgnoreCase(translations.get(l))) continue;
                        sl = true;
                    }
                    if (string != null) {
                        td.addText((sl ? cs.getLanguage("en") + ": " : "") + string);
                    }
                    for (String l : translations.keySet()) {
                        if (string != null && string.equalsIgnoreCase(translations.get(l))) continue;
                        if (!td.getChildNodes().isEmpty()) {
                            td.br();
                        }
                        td.addText(l + ": " + translations.get(l));
                    }
                } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                    if (string != null) {
                        td.addText(string);
                    }
                } else {
                    if (string != null) {
                        translations.put(cs.getLanguage("en"), string);
                    }
                    for (String string2 : translations.keySet()) {
                        if (!string2.equals(this.getContext().getLang())) continue;
                        td.addText(translations.get(string2));
                    }
                }
            }
        }
        if (version) {
            td = tr.td();
            if (c.hasUserData("cs.version.notes")) {
                td.addText(c.getUserString("cs.version.notes"));
            }
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent propertyComponent : properties) {
                td = tr.td();
                boolean first = true;
                List<CodeSystem.ConceptPropertyComponent> pcvl = CodeSystemUtilities.getPropertyValues(c, propertyComponent.getCode());
                for (CodeSystem.ConceptPropertyComponent pcv : pcvl) {
                    if (!pcv.hasValue()) continue;
                    if (first) {
                        first = false;
                    } else {
                        td.addText(", ");
                    }
                    if (pcv.hasValueCoding()) {
                        td.addText(pcv.getValueCoding().getCode());
                        continue;
                    }
                    if (pcv.hasValueStringType() && Utilities.isAbsoluteUrlLinkable((String)pcv.getValue().primitiveValue())) {
                        td.ah(pcv.getValue().primitiveValue()).tx(pcv.getValue().primitiveValue());
                        continue;
                    }
                    td.addText(pcv.getValue().primitiveValue());
                }
            }
        }
        for (TerminologyRenderer.UsedConceptMap usedConceptMap : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), usedConceptMap.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.hasRelationship() ? mapping.comp.getRelationship().toCode() : "");
                span.addText(this.getCharForRelationship(mapping.comp));
                a = td.ah(this.getContext().getSpecificationLink() + usedConceptMap.getLink() + "#" + this.makeAnchor(mapping.group.getTarget(), mapping.comp.getCode()));
                a.addText(mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        List<CodeSystem.ConceptDefinitionComponent> ocl = csNav.getOtherChildren(c);
        for (CodeSystem.ConceptDefinitionComponent cc : csNav.getConcepts(c)) {
            hasExtensions = this.addDefineRowToTable(t, cc, level + 1, hasHierarchy, hasDisplay, hasDefinitions, comment, version, deprecated, maps, system, cs, properties, csNav, langs) || hasExtensions;
        }
        for (CodeSystem.ConceptDefinitionComponent cc : ocl) {
            int n;
            tr = t.tr();
            td = tr.td();
            td.addText(Integer.toString(level + 2));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)((level + 1) * 2));
            td.addText(s);
            td.attribute("style", "white-space:nowrap");
            a = td.ah("#" + cs.getId() + "-" + Utilities.nmtokenize((String)cc.getCode()));
            a.addText(cc.getCode());
            if (hasDisplay) {
                td = tr.td();
                this.renderDisplayName(cc, cs, td);
            }
            int n2 = 1 + (deprecated ? 1 : 0) + (comment ? 1 : 0) + (version ? 1 : 0) + maps.size();
            if (properties != null) {
                n = n2 + properties.size();
            }
            td = tr.td().colspan(Integer.toString(n));
        }
        return hasExtensions;
    }

    private boolean hasMarkdownInDefinitions(CodeSystem cs) {
        return ToolingExtensions.readBoolExtension(cs, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown");
    }

    public void renderDisplayName(CodeSystem.ConceptDefinitionComponent c, CodeSystem cs, XhtmlNode td) {
        block9: {
            if (!c.hasDisplayElement()) break block9;
            if (this.getContext().getLang() == null) {
                td.addText(c.getDisplay());
            } else if (this.getContext().getLang().equals("*")) {
                boolean sl = false;
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                    sl = true;
                }
                td.addText((sl ? cs.getLanguage("en") + ": " : "") + c.getDisplay());
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                    td.br();
                    td.addText(cd.getLanguage() + ": " + cd.getValue());
                }
            } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                td.addText(c.getDisplay());
            } else {
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || !cd.getLanguage().equals(this.getContext().getLang())) continue;
                    td.addText(cd.getValue());
                }
            }
        }
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return "http://s.details.loinc.org/LOINC/" + cc.getCode() + ".html";
        }
        return null;
    }

    private void addLanguageRow(CodeSystem.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            CodeSystem.ConceptDefinitionDesignationComponent d = null;
            for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!designation.hasLanguage() || !lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.td().addText(d == null ? "" : d.getValue());
        }
    }
}

