/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.renderers.spreadsheets.CanonicalSpreadsheetGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFilterOperator;

public class StructureDefinitionSpreadsheetGenerator
extends CanonicalSpreadsheetGenerator {
    private XmlParser xml = new XmlParser();
    private JsonParser json = new JsonParser();
    private boolean asXml;
    private boolean hideMustSupportFalse;
    private List<StructureDefinition.StructureDefinitionMappingComponent> mapKeys = new ArrayList<StructureDefinition.StructureDefinitionMappingComponent>();
    private static String[] titles = new String[]{"Path", "Slice Name", "Alias(s)", "Label", "Min", "Max", "Must Support?", "Is Modifier?", "Is Summary?", "Type(s)", "Short", "Definition", "Comments", "Requirements", "Default Value", "Meaning When Missing", "Fixed Value", "Pattern", "Example", "Minimum Value", "Maximum Value", "Maximum Length", "Binding Strength", "Binding Description", "Binding Value Set", "Code", "Slicing Discriminator", "Slicing Description", "Slicing Ordered", "Slicing Rules", "Base Path", "Base Min", "Base Max", "Condition(s)", "Constraint(s)"};

    public StructureDefinitionSpreadsheetGenerator(IWorkerContext context, boolean valuesAsXml, boolean hideMustSupportFalse) {
        super(context);
        this.asXml = valuesAsXml;
        this.hideMustSupportFalse = hideMustSupportFalse;
    }

    public StructureDefinitionSpreadsheetGenerator renderStructureDefinition(StructureDefinition sd) throws Exception {
        int i;
        if (sd == null) {
            System.out.println("no structure!");
        }
        if (!sd.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        this.addStructureDefinitionMetadata(this.renderCanonicalResource(sd), sd);
        Sheet sheet = this.makeSheet("Elements");
        Row headerRow = sheet.createRow(0);
        for (i = 0; i < titles.length; ++i) {
            this.addCell(headerRow, i, titles[i], (CellStyle)this.styles.get("header"));
        }
        i = titles.length - 1;
        for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
            this.addCell(headerRow, ++i, "Mapping: " + map.getName(), (CellStyle)this.styles.get("header"));
        }
        for (ElementDefinition child : sd.getSnapshot().getElement()) {
            this.processElement(sheet, sd, child);
        }
        this.configureSheet(sheet, sd);
        return this;
    }

    private void addStructureDefinitionMetadata(Sheet sheet, StructureDefinition sd) {
        for (Coding coding : sd.getKeyword()) {
            this.addMetadataRow(sheet, "Keyword", this.dr.display(coding));
        }
        this.addMetadataRow(sheet, "FHIR Version", sd.getFhirVersionElement().asStringValue());
        this.addMetadataRow(sheet, "Kind", sd.getKindElement().asStringValue());
        this.addMetadataRow(sheet, "Type", sd.getType());
        this.addMetadataRow(sheet, "Base Definition", sd.getBaseDefinition());
        this.addMetadataRow(sheet, "Abstract", sd.getAbstractElement().asStringValue());
        this.addMetadataRow(sheet, "Derivation", sd.getDerivationElement().asStringValue());
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : sd.getContext()) {
            this.addMetadataRow(sheet, "Context", structureDefinitionContextComponent.getTypeElement().asStringValue() + ":" + structureDefinitionContextComponent.getExpression());
        }
        for (StringType stringType : sd.getContextInvariant()) {
            this.addMetadataRow(sheet, "Context Inv.", (String)stringType.getValue());
        }
    }

    public void processElement(Sheet sheet, StructureDefinition sd, ElementDefinition ed) throws Exception {
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        int i = 0;
        this.addCell(row, i++, ed.getPath(), (CellStyle)this.styles.get("body"));
        this.addCell(row, i++, ed.getSliceName());
        this.addCell(row, i++, this.itemList(ed.getAlias()));
        this.addCell(row, i++, ed.getLabel());
        this.addCell(row, i++, ed.getMin());
        this.addCell(row, i++, ed.getMax());
        this.addCell(row, i++, ed.getMustSupport() ? "Y" : "");
        this.addCell(row, i++, ed.getIsModifier() ? "Y" : "");
        this.addCell(row, i++, ed.getIsSummary() ? "Y" : "");
        this.addCell(row, i++, this.itemList(ed.getType()));
        this.addCell(row, i++, ed.getShort());
        this.addCell(row, i++, ed.getDefinition());
        this.addCell(row, i++, ed.getComment());
        this.addCell(row, i++, ed.getRequirements());
        this.addCell(row, i++, ed.getDefaultValue() != null ? this.renderType(ed.getDefaultValue()) : "");
        this.addCell(row, i++, ed.getMeaningWhenMissing());
        this.addCell(row, i++, ed.hasFixed() ? this.renderType(ed.getFixed()) : "");
        this.addCell(row, i++, ed.hasPattern() ? this.renderType(ed.getPattern()) : "");
        this.addCell(row, i++, ed.hasExample() ? this.renderType(ed.getExample().get(0).getValue()) : "");
        this.addCell(row, i++, ed.hasMinValue() ? this.renderType(ed.getMinValue()) : "");
        this.addCell(row, i++, ed.hasMaxValue() ? this.renderType(ed.getMaxValue()) : "");
        this.addCell(row, i++, ed.hasMaxLength() ? Integer.toString(ed.getMaxLength()) : "");
        if (ed.hasBinding()) {
            this.addCell(row, i++, ed.getBinding().getStrength() != null ? ed.getBinding().getStrength().toCode() : "");
            this.addCell(row, i++, ed.getBinding().getDescription());
            if (ed.getBinding().getValueSet() == null) {
                this.addCell(row, i++, "");
            } else {
                this.addCell(row, i++, ed.getBinding().getValueSet());
            }
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        this.addCell(row, i++, this.itemList(ed.getCode()));
        if (ed.hasSlicing()) {
            this.addCell(row, i++, this.itemList(ed.getSlicing().getDiscriminator()));
            this.addCell(row, i++, ed.getSlicing().getDescription());
            this.addCell(row, i++, ed.getSlicing().getOrdered());
            this.addCell(row, i++, ed.getSlicing().getRules() != null ? ed.getSlicing().getRules().toCode() : "");
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        if (ed.getBase() != null) {
            this.addCell(row, i++, ed.getBase().getPath());
            this.addCell(row, i++, ed.getBase().getMin());
            this.addCell(row, i++, ed.getBase().getMax());
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        this.addCell(row, i++, this.itemList(ed.getCondition()));
        this.addCell(row, i++, this.itemList(ed.getConstraint()));
        for (StructureDefinition.StructureDefinitionMappingComponent mapKey : sd.getMapping()) {
            String mapString = "";
            for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
                if (!map.getIdentity().equals(mapKey.getIdentity())) continue;
                mapString = map.getMap();
            }
            this.addCell(row, i++, mapString);
        }
    }

    private String itemList(List l) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            Element c;
            Element t;
            Object o = l.get(i);
            String val = "";
            if (o instanceof StringType) {
                val = (String)((StringType)o).getValue();
            } else if (o instanceof UriType) {
                val = (String)((UriType)o).getValue();
            } else if (o instanceof IdType) {
                val = ((IdType)o).getValue();
            } else if (o instanceof java.util.Enumeration) {
                val = o.toString();
            } else if (o instanceof ElementDefinition.TypeRefComponent) {
                t = (ElementDefinition.TypeRefComponent)o;
                val = ((ElementDefinition.TypeRefComponent)t).getWorkingCode();
                if (val == null) {
                    val = "";
                }
                if (val.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    val = val.substring(40);
                }
                if (((ElementDefinition.TypeRefComponent)t).hasTargetProfile()) {
                    val = val + "(" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getTargetProfile()) + ")";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasProfile()) {
                    val = val + " {" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getProfile()) + "}";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasAggregation()) {
                    val = val + " <<" + this.aggList(((ElementDefinition.TypeRefComponent)t).getAggregation()) + ">>";
                }
            } else if (o instanceof Coding) {
                t = (Coding)o;
                val = (((Coding)t).getSystem() == null ? "" : ((Coding)t).getSystem()) + (((Coding)t).getCode() == null ? "" : "#" + ((Coding)t).getCode()) + (((Coding)t).getDisplay() == null ? "" : " (" + ((Coding)t).getDisplay() + ")");
            } else if (o instanceof ElementDefinition.ElementDefinitionConstraintComponent) {
                c = (ElementDefinition.ElementDefinitionConstraintComponent)o;
                val = ((ElementDefinition.ElementDefinitionConstraintComponent)c).getKey() + ":" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getHuman() + " {" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getExpression() + "}";
            } else if (o instanceof ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent) {
                c = (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)o;
                val = ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getType().toCode() + ":" + ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getPath() + "}";
            } else {
                val = o.toString();
                val = val.substring(val.indexOf("[") + 1);
                val = val.substring(0, val.indexOf("]"));
            }
            s = s.append(val);
            if (i != 0) continue;
            s.append("\n");
        }
        return s.toString();
    }

    private String aggList(List<Enumeration<ElementDefinition.AggregationMode>> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Enumeration<ElementDefinition.AggregationMode> c : list) {
            b.append(((ElementDefinition.AggregationMode)((Object)c.getValue())).toCode());
        }
        return b.toString();
    }

    private String canonicalList(List<CanonicalType> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("|");
        for (CanonicalType c : list) {
            String v = (String)c.getValue();
            if (v.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                v = v.substring(40);
            }
            b.append(v);
        }
        return b.toString();
    }

    private String renderType(DataType value) throws Exception {
        if (value == null) {
            return "";
        }
        if (value.isPrimitive()) {
            return value.primitiveValue();
        }
        String s = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (this.asXml) {
            this.xml.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.xml.compose((OutputStream)bs, "", value);
            bs.close();
            s = bs.toString();
            s = s.substring(s.indexOf("\n") + 2);
        } else {
            this.json.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.json.compose(bs, value, "");
            bs.close();
            s = bs.toString();
        }
        return s;
    }

    public void configureSheet(Sheet sheet, StructureDefinition sd) throws IOException {
        int i;
        for (i = 0; i < 34; ++i) {
            sheet.autoSizeColumn(i);
        }
        sheet.setColumnHidden(2, true);
        sheet.setColumnHidden(3, true);
        sheet.setColumnHidden(30, true);
        sheet.setColumnHidden(31, true);
        sheet.setColumnHidden(32, true);
        sheet.setColumnWidth(9, this.columnPixels(20.0));
        sheet.setColumnWidth(11, this.columnPixels(100.0));
        sheet.setColumnWidth(12, this.columnPixels(100.0));
        sheet.setColumnWidth(13, this.columnPixels(100.0));
        sheet.setColumnWidth(15, this.columnPixels(20.0));
        sheet.setColumnWidth(16, this.columnPixels(20.0));
        sheet.setColumnWidth(17, this.columnPixels(20.0));
        sheet.setColumnWidth(18, this.columnPixels(20.0));
        sheet.setColumnWidth(34, this.columnPixels(100.0));
        i = titles.length - 1;
        for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
            sheet.setColumnWidth(++i, this.columnPixels(50.0));
            sheet.autoSizeColumn(i);
        }
        sheet.createFreezePane(2, 1);
        if (this.hideMustSupportFalse) {
            SheetConditionalFormatting sheetCF = sheet.getSheetConditionalFormatting();
            String address = "A2:AI" + Math.max(sheet.getLastRowNum(), 2);
            CellRangeAddress[] regions = new CellRangeAddress[]{CellRangeAddress.valueOf((String)address)};
            ConditionalFormattingRule rule1 = sheetCF.createConditionalFormattingRule("$G2<>\"Y\"");
            PatternFormatting fill1 = rule1.createPatternFormatting();
            fill1.setFillBackgroundColor(IndexedColors.GREY_25_PERCENT.index);
            fill1.setFillPattern((short)1);
            ConditionalFormattingRule rule2 = sheetCF.createConditionalFormattingRule("$Q2<>\"\"");
            FontFormatting font = rule2.createFontFormatting();
            font.setFontColorIndex(IndexedColors.GREY_25_PERCENT.index);
            font.setFontStyle(true, false);
            sheetCF.addConditionalFormatting(regions, rule1, rule2);
            sheet.setAutoFilter(new CellRangeAddress(0, sheet.getLastRowNum(), 0, titles.length + sd.getMapping().size() - 1));
            XSSFSheet xSheet = (XSSFSheet)sheet;
            CTAutoFilter sheetFilter = xSheet.getCTWorksheet().getAutoFilter();
            CTFilterColumn filterColumn1 = sheetFilter.addNewFilterColumn();
            filterColumn1.setColId(6L);
            CTCustomFilters filters = filterColumn1.addNewCustomFilters();
            CTCustomFilter filter1 = filters.addNewCustomFilter();
            filter1.setOperator(STFilterOperator.NOT_EQUAL);
            filter1.setVal(" ");
            CTFilterColumn filterColumn2 = sheetFilter.addNewFilterColumn();
            filterColumn2.setColId(26L);
            CTFilters filters2 = filterColumn2.addNewFilters();
            filters2.setBlank(true);
            for (Row row : sheet) {
                if (row.getRowNum() <= 0 || row.getCell(6).getStringCellValue().equals("Y") && row.getCell(26).getStringCellValue().isEmpty()) continue;
                ((XSSFRow)row).getCTRow().setHidden(true);
            }
        }
        sheet.setActiveCell(new CellAddress(sheet.getRow(1).getCell(0)));
    }
}

