/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ConceptMap2;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PlanDefinition", profile="http://hl7.org/fhir/StructureDefinition/PlanDefinition")
public class PlanDefinition
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this plan definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this plan definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this plan definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the plan definition is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the plan definition", formalDefinition="A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the plan definition", formalDefinition="The identifier that is used to identify this version of the plan definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the plan definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this plan definition (computer friendly)", formalDefinition="A natural language name identifying the plan definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this plan definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the plan definition.")
    protected StringType title;
    @Child(name="subtitle", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the plan definition", formalDefinition="An explanatory or alternate title for the plan definition giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="type", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="order-set | clinical-protocol | eca-rule | workflow-definition", formalDefinition="A high-level category for the plan definition that distinguishes the kinds of systems that would be interested in the plan definition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/plan-definition-type")
    protected CodeableConcept type;
    @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this plan definition. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this plan definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="subject", type={CodeableConcept.class, Group.class, CanonicalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of individual the plan definition is focused on", formalDefinition="A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    protected DataType subject;
    @Child(name="date", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the plan definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the plan definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the plan definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the plan definition", formalDefinition="A free text natural language description of the plan definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate plan definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for plan definition (if applicable)", formalDefinition="A legal or geographic region in which the plan definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this plan definition is defined", formalDefinition="Explanation of why this plan definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the plan", formalDefinition="A detailed description of how the plan definition is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="copyright", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the plan definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the plan definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the plan definition is expected to be used", formalDefinition="The period during which the plan definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment", formalDefinition="Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={CanonicalType.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the plan definition", formalDefinition="A reference to a Library resource containing any formal logic used by the plan definition.")
    protected List<CanonicalType> library;
    @Child(name="goal", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What the plan is trying to accomplish", formalDefinition="A goal describes an expected outcome that activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, meeting the acceptance criteria for a test as specified by a quality specification, etc.")
    protected List<PlanDefinitionGoalComponent> goal;
    @Child(name="actor", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actors within the plan", formalDefinition="Actors represent the individuals or groups involved in the execution of the defined set of activities.")
    protected List<PlanDefinitionActorComponent> actor;
    @Child(name="action", type={}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action defined by the plan", formalDefinition="An action or group of actions to be taken as part of the plan. For example, in clinical care, an action would be to prescribe a particular indicated medication, or perform a particular test as appropriate. In pharmaceutical quality, an action would be the test that needs to be performed on a drug product as defined in the quality specification.")
    protected List<PlanDefinitionActionComponent> action;
    private static final long serialVersionUID = -2104269622L;
    @SearchParamDefinition(name="composed-of", path="PlanDefinition.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("PlanDefinition:composed-of").toLocked();
    @SearchParamDefinition(name="context-quantity", path="(PlanDefinition.useContext.value as Quantity) | (PlanDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the plan definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="PlanDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the plan definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="PlanDefinition.useContext", description="A use context type and value assigned to the plan definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="PlanDefinition.useContext.code", description="A type of use context assigned to the plan definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(PlanDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the plan definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="PlanDefinition.date", description="The plan definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="definition", path="PlanDefinition.action.definition", description="Activity or plan definitions used by plan definition", type="reference", target={ActivityDefinition.class, ObservationDefinition.class, PlanDefinition.class, Questionnaire.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("PlanDefinition:definition").toLocked();
    @SearchParamDefinition(name="depends-on", path="PlanDefinition.relatedArtifact.where(type='depends-on').resource | PlanDefinition.library", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("PlanDefinition:depends-on").toLocked();
    @SearchParamDefinition(name="derived-from", path="PlanDefinition.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("PlanDefinition:derived-from").toLocked();
    @SearchParamDefinition(name="description", path="PlanDefinition.description", description="The description of the plan definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="effective", path="PlanDefinition.effectivePeriod", description="The time during which the plan definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="identifier", path="PlanDefinition.identifier", description="External identifier for the plan definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="PlanDefinition.jurisdiction", description="Intended jurisdiction for the plan definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="PlanDefinition.name", description="Computationally friendly name of the plan definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="predecessor", path="PlanDefinition.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("PlanDefinition:predecessor").toLocked();
    @SearchParamDefinition(name="publisher", path="PlanDefinition.publisher", description="Name of the publisher of the plan definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="PlanDefinition.status", description="The current status of the plan definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="successor", path="PlanDefinition.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("PlanDefinition:successor").toLocked();
    @SearchParamDefinition(name="title", path="PlanDefinition.title", description="The human-friendly name of the plan definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="topic", path="PlanDefinition.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="type", path="PlanDefinition.type", description="The type of artifact the plan (e.g. order-set, eca-rule, protocol)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="PlanDefinition.url", description="The uri that identifies the plan definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="PlanDefinition.version", description="The business version of the plan definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public PlanDefinition() {
    }

    public PlanDefinition(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public PlanDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public PlanDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public PlanDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public PlanDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public PlanDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public PlanDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public PlanDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public PlanDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public PlanDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public PlanDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public PlanDefinition setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public PlanDefinition setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public PlanDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public PlanDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public PlanDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public PlanDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public PlanDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DataType getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public CanonicalType getSubjectCanonicalType() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CanonicalType();
        }
        if (!(this.subject instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.subject;
    }

    public boolean hasSubjectCanonicalType() {
        return this != null && this.subject instanceof CanonicalType;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public PlanDefinition setSubject(DataType value) {
        if (!(value == null || value instanceof CodeableConcept || value instanceof Reference || value instanceof CanonicalType)) {
            throw new Error("Not the right type for PlanDefinition.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public PlanDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public PlanDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public PlanDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public PlanDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public PlanDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public PlanDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public PlanDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public PlanDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public PlanDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public PlanDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public PlanDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public PlanDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public PlanDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public PlanDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public PlanDefinition setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public PlanDefinition setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public PlanDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public PlanDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public PlanDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public PlanDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public PlanDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public PlanDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public PlanDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    @Override
    public PlanDefinition setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    @Override
    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    @Override
    public PlanDefinition addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public PlanDefinition setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public PlanDefinition addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public PlanDefinition setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public PlanDefinition addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public PlanDefinition setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public PlanDefinition addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public PlanDefinition setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public PlanDefinition addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public PlanDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public PlanDefinition addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CanonicalType> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        return this.library;
    }

    public PlanDefinition setLibrary(List<CanonicalType> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addLibraryElement() {
        CanonicalType t = new CanonicalType();
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return t;
    }

    public PlanDefinition addLibrary(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return this;
    }

    public boolean hasLibrary(String value) {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType v : this.library) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<PlanDefinitionGoalComponent> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        return this.goal;
    }

    public PlanDefinition setGoal(List<PlanDefinitionGoalComponent> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (PlanDefinitionGoalComponent item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PlanDefinitionGoalComponent addGoal() {
        PlanDefinitionGoalComponent t = new PlanDefinitionGoalComponent();
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        this.goal.add(t);
        return t;
    }

    public PlanDefinition addGoal(PlanDefinitionGoalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        this.goal.add(t);
        return this;
    }

    public PlanDefinitionGoalComponent getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<PlanDefinitionActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<PlanDefinitionActorComponent>();
        }
        return this.actor;
    }

    public PlanDefinition setActor(List<PlanDefinitionActorComponent> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (PlanDefinitionActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PlanDefinitionActorComponent addActor() {
        PlanDefinitionActorComponent t = new PlanDefinitionActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<PlanDefinitionActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public PlanDefinition addActor(PlanDefinitionActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<PlanDefinitionActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public PlanDefinitionActorComponent getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<PlanDefinitionActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        return this.action;
    }

    public PlanDefinition setAction(List<PlanDefinitionActionComponent> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (PlanDefinitionActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PlanDefinitionActionComponent addAction() {
        PlanDefinitionActionComponent t = new PlanDefinitionActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public PlanDefinition addAction(PlanDefinitionActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public PlanDefinitionActionComponent getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this plan definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this plan definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the plan definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the plan definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the plan definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the plan definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the plan definition.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the plan definition giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_TYPE, "CodeableConcept", "A high-level category for the plan definition that distinguishes the kinds of systems that would be interested in the plan definition.", 0, 1, this.type));
        children.add(new Property(SP_STATUS, "code", "The status of this plan definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this plan definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical(MedicinalProductDefinition|SubstanceDefinition|AdministrableProductDefinition|ManufacturedItemDefinition|PackagedProductDefinition)", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the plan definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the plan definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the plan definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the plan definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate plan definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the plan definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this plan definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description of how the plan definition is used from a clinical perspective.", 0, 1, this.usage));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the plan definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "canonical(Library)", "A reference to a Library resource containing any formal logic used by the plan definition.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("goal", "", "A goal describes an expected outcome that activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, meeting the acceptance criteria for a test as specified by a quality specification, etc.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("actor", "", "Actors represent the individuals or groups involved in the execution of the defined set of activities.", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property("action", "", "An action or group of actions to be taken as part of the plan. For example, in clinical care, an action would be to prescribe a particular indicated medication, or perform a particular test as appropriate. In pharmaceutical quality, an action would be the test that needs to be performed on a drug product as defined in the quality specification.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this plan definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this plan definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the plan definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the plan definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the plan definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the plan definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the plan definition.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the plan definition giving additional information about its content.", 0, 1, this.subtitle);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "A high-level category for the plan definition that distinguishes the kinds of systems that would be interested in the plan definition.", 0, 1, this.type);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this plan definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this plan definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical(MedicinalProductDefinition|SubstanceDefinition|AdministrableProductDefinition|ManufacturedItemDefinition|PackagedProductDefinition)", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical(MedicinalProductDefinition|SubstanceDefinition|AdministrableProductDefinition|ManufacturedItemDefinition|PackagedProductDefinition)", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "Reference(Group)", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
            }
            case -1768521432: {
                return new Property("subject[x]", "canonical(MedicinalProductDefinition|SubstanceDefinition|AdministrableProductDefinition|ManufacturedItemDefinition|PackagedProductDefinition)", "A code, group definition, or canonical reference that describes  or identifies the intended subject of the plan definition. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the plan definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the plan definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the plan definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the plan definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate plan definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the plan definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this plan definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description of how the plan definition is used from a clinical perspective.", 0, 1, this.usage);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the plan definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "canonical(Library)", "A reference to a Library resource containing any formal logic used by the plan definition.", 0, Integer.MAX_VALUE, this.library);
            }
            case 3178259: {
                return new Property("goal", "", "A goal describes an expected outcome that activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, meeting the acceptance criteria for a test as specified by a quality specification, etc.", 0, Integer.MAX_VALUE, this.goal);
            }
            case 92645877: {
                return new Property("actor", "", "Actors represent the individuals or groups involved in the execution of the defined set of activities.", 0, Integer.MAX_VALUE, this.actor);
            }
            case -1422950858: {
                return new Property("action", "", "An action or group of actions to be taken as part of the plan. For example, in clinical care, an action would be to prescribe a particular indicated medication, or perform a particular test as appropriate. In pharmaceutical quality, an action would be the test that needs to be performed on a drug product as defined in the quality specification.", 0, Integer.MAX_VALUE, this.action);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subtitle;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.usage;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = TypeConvertor.castToString(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add((PlanDefinitionGoalComponent)((Object)value));
                return value;
            }
            case 92645877: {
                this.getActor().add((PlanDefinitionActorComponent)((Object)value));
                return value;
            }
            case -1422950858: {
                this.getAction().add((PlanDefinitionActionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subject[x]")) {
            this.subject = TypeConvertor.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = TypeConvertor.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("goal")) {
            this.getGoal().add((PlanDefinitionGoalComponent)((Object)value));
        } else if (name.equals("actor")) {
            this.getActor().add((PlanDefinitionActorComponent)((Object)value));
        } else if (name.equals("action")) {
            this.getAction().add((PlanDefinitionActionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibraryElement();
            }
            case 3178259: {
                return this.addGoal();
            }
            case 92645877: {
                return this.addActor();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference", "canonical"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"canonical"};
            }
            case 3178259: {
                return new String[0];
            }
            case 92645877: {
                return new String[0];
            }
            case -1422950858: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.subtitle");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.experimental");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("subjectCanonical")) {
            this.subject = new CanonicalType();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.usage");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.library");
        }
        if (name.equals("goal")) {
            return this.addGoal();
        }
        if (name.equals("actor")) {
            return this.addActor();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PlanDefinition";
    }

    @Override
    public PlanDefinition copy() {
        PlanDefinition dst = new PlanDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PlanDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.library) {
                dst.library.add(canonicalType.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<PlanDefinitionGoalComponent>();
            for (PlanDefinitionGoalComponent planDefinitionGoalComponent : this.goal) {
                dst.goal.add(planDefinitionGoalComponent.copy());
            }
        }
        if (this.actor != null) {
            dst.actor = new ArrayList<PlanDefinitionActorComponent>();
            for (PlanDefinitionActorComponent planDefinitionActorComponent : this.actor) {
                dst.actor.add(planDefinitionActorComponent.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<PlanDefinitionActionComponent>();
            for (PlanDefinitionActionComponent planDefinitionActionComponent : this.action) {
                dst.action.add(planDefinitionActionComponent.copy());
            }
        }
    }

    protected PlanDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PlanDefinition)) {
            return false;
        }
        PlanDefinition o = (PlanDefinition)other_;
        return PlanDefinition.compareDeep(this.url, o.url, true) && PlanDefinition.compareDeep(this.identifier, o.identifier, true) && PlanDefinition.compareDeep(this.version, o.version, true) && PlanDefinition.compareDeep(this.name, o.name, true) && PlanDefinition.compareDeep(this.title, o.title, true) && PlanDefinition.compareDeep(this.subtitle, o.subtitle, true) && PlanDefinition.compareDeep(this.type, o.type, true) && PlanDefinition.compareDeep(this.status, o.status, true) && PlanDefinition.compareDeep(this.experimental, o.experimental, true) && PlanDefinition.compareDeep(this.subject, o.subject, true) && PlanDefinition.compareDeep(this.date, o.date, true) && PlanDefinition.compareDeep(this.publisher, o.publisher, true) && PlanDefinition.compareDeep(this.contact, o.contact, true) && PlanDefinition.compareDeep(this.description, o.description, true) && PlanDefinition.compareDeep(this.useContext, o.useContext, true) && PlanDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && PlanDefinition.compareDeep(this.purpose, o.purpose, true) && PlanDefinition.compareDeep(this.usage, o.usage, true) && PlanDefinition.compareDeep(this.copyright, o.copyright, true) && PlanDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && PlanDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && PlanDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && PlanDefinition.compareDeep(this.topic, o.topic, true) && PlanDefinition.compareDeep(this.author, o.author, true) && PlanDefinition.compareDeep(this.editor, o.editor, true) && PlanDefinition.compareDeep(this.reviewer, o.reviewer, true) && PlanDefinition.compareDeep(this.endorser, o.endorser, true) && PlanDefinition.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && PlanDefinition.compareDeep(this.library, o.library, true) && PlanDefinition.compareDeep(this.goal, o.goal, true) && PlanDefinition.compareDeep(this.actor, o.actor, true) && PlanDefinition.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PlanDefinition)) {
            return false;
        }
        PlanDefinition o = (PlanDefinition)other_;
        return PlanDefinition.compareValues(this.url, o.url, true) && PlanDefinition.compareValues(this.version, o.version, true) && PlanDefinition.compareValues(this.name, o.name, true) && PlanDefinition.compareValues(this.title, o.title, true) && PlanDefinition.compareValues(this.subtitle, o.subtitle, true) && PlanDefinition.compareValues(this.status, o.status, true) && PlanDefinition.compareValues(this.experimental, o.experimental, true) && PlanDefinition.compareValues(this.date, o.date, true) && PlanDefinition.compareValues(this.publisher, o.publisher, true) && PlanDefinition.compareValues(this.description, o.description, true) && PlanDefinition.compareValues(this.purpose, o.purpose, true) && PlanDefinition.compareValues(this.usage, o.usage, true) && PlanDefinition.compareValues(this.copyright, o.copyright, true) && PlanDefinition.compareValues(this.approvalDate, o.approvalDate, true) && PlanDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && PlanDefinition.compareValues(this.library, o.library, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.type, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.goal, this.actor, this.action});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PlanDefinition;
    }

    @Block
    public static class PlanDefinitionActionDynamicValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).")
        protected StringType path;
        @Child(name="expression", type={Expression.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected Expression expression;
        private static final long serialVersionUID = 1064529082L;

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public PlanDefinitionActionDynamicValueComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path));
            children.add(new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.dynamicValue.path");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionDynamicValueComponent copy() {
            PlanDefinitionActionDynamicValueComponent dst = new PlanDefinitionActionDynamicValueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionDynamicValueComponent dst) {
            super.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionDynamicValueComponent)) {
                return false;
            }
            PlanDefinitionActionDynamicValueComponent o = (PlanDefinitionActionDynamicValueComponent)other_;
            return PlanDefinitionActionDynamicValueComponent.compareDeep(this.path, o.path, true) && PlanDefinitionActionDynamicValueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionDynamicValueComponent)) {
                return false;
            }
            PlanDefinitionActionDynamicValueComponent o = (PlanDefinitionActionDynamicValueComponent)other_;
            return PlanDefinitionActionDynamicValueComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.expression});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.dynamicValue";
        }
    }

    @Block
    public static class PlanDefinitionActionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actorId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What actor", formalDefinition="A reference to the id element of the actor who will participate in this action.")
        protected StringType actorId;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="careteam | device | group | healthcareservice | location | organization | patient | practitioner | practitionerrole | relatedperson", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<Enumerations.ActionParticipantType> type;
        @Child(name="typeReference", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can participate", formalDefinition="The type of participant in the action.")
        protected Reference typeReference;
        @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/action-participant-role")
        protected CodeableConcept role;
        @Child(name="function", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Author, Reviewer, Witness, etc.", formalDefinition="Indicates how the actor will be involved in the action - author, reviewer, witness, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-function")
        protected CodeableConcept function;
        private static final long serialVersionUID = -1307587293L;

        public StringType getActorIdElement() {
            if (this.actorId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.actorId");
                }
                if (Configuration.doAutoCreate()) {
                    this.actorId = new StringType();
                }
            }
            return this.actorId;
        }

        public boolean hasActorIdElement() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public boolean hasActorId() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setActorIdElement(StringType value) {
            this.actorId = value;
            return this;
        }

        public String getActorId() {
            return this.actorId == null ? null : (String)this.actorId.getValue();
        }

        public PlanDefinitionActionParticipantComponent setActorId(String value) {
            if (Utilities.noString((String)value)) {
                this.actorId = null;
            } else {
                if (this.actorId == null) {
                    this.actorId = new StringType();
                }
                this.actorId.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setTypeElement(Enumeration<Enumerations.ActionParticipantType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ActionParticipantType getType() {
            return this.type == null ? null : (Enumerations.ActionParticipantType)((Object)this.type.getValue());
        }

        public PlanDefinitionActionParticipantComponent setType(Enumerations.ActionParticipantType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Reference getTypeReference() {
            if (this.typeReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.typeReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeReference = new Reference();
                }
            }
            return this.typeReference;
        }

        public boolean hasTypeReference() {
            return this.typeReference != null && !this.typeReference.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setTypeReference(Reference value) {
            this.typeReference = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actorId", "string", "A reference to the id element of the actor who will participate in this action.", 0, 1, this.actorId));
            children.add(new Property(PlanDefinition.SP_TYPE, "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
            children.add(new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1161623056: {
                    return new Property("actorId", "string", "A reference to the id element of the actor who will participate in this action.", 0, 1, this.actorId);
                }
                case 3575610: {
                    return new Property(PlanDefinition.SP_TYPE, "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 2074825009: {
                    return new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Indicates how the actor will be involved in the action - author, reviewer, witness, etc.", 0, 1, this.function);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    Base[] baseArray;
                    if (this.actorId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actorId;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 2074825009: {
                    Base[] baseArray;
                    if (this.typeReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.typeReference;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.function;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    this.actorId = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 2074825009: {
                    this.typeReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actorId")) {
                this.actorId = TypeConvertor.castToString(value);
            } else if (name.equals(PlanDefinition.SP_TYPE)) {
                value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("typeReference")) {
                this.typeReference = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return this.getActorIdElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 2074825009: {
                    return this.getTypeReference();
                }
                case 3506294: {
                    return this.getRole();
                }
                case 1380938712: {
                    return this.getFunction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 2074825009: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actorId")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.participant.actorId");
            }
            if (name.equals(PlanDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.participant.type");
            }
            if (name.equals("typeReference")) {
                this.typeReference = new Reference();
                return this.typeReference;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionParticipantComponent copy() {
            PlanDefinitionActionParticipantComponent dst = new PlanDefinitionActionParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionParticipantComponent dst) {
            super.copyValues(dst);
            dst.actorId = this.actorId == null ? null : this.actorId.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.typeReference = this.typeReference == null ? null : this.typeReference.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.function = this.function == null ? null : this.function.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionParticipantComponent)) {
                return false;
            }
            PlanDefinitionActionParticipantComponent o = (PlanDefinitionActionParticipantComponent)other_;
            return PlanDefinitionActionParticipantComponent.compareDeep(this.actorId, o.actorId, true) && PlanDefinitionActionParticipantComponent.compareDeep(this.type, o.type, true) && PlanDefinitionActionParticipantComponent.compareDeep(this.typeReference, o.typeReference, true) && PlanDefinitionActionParticipantComponent.compareDeep(this.role, o.role, true) && PlanDefinitionActionParticipantComponent.compareDeep(this.function, o.function, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionParticipantComponent)) {
                return false;
            }
            PlanDefinitionActionParticipantComponent o = (PlanDefinitionActionParticipantComponent)other_;
            return PlanDefinitionActionParticipantComponent.compareValues(this.actorId, o.actorId, true) && PlanDefinitionActionParticipantComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.actorId, this.type, this.typeReference, this.role, this.function});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.participant";
        }
    }

    @Block
    public static class PlanDefinitionActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="targetId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What action is this related to", formalDefinition="The element id of the target related action.")
        protected IdType targetId;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before-start | before | before-end | concurrent-with-start | concurrent | concurrent-with-end | after-start | after | after-end", formalDefinition="The relationship of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected Enumeration<Enumerations.ActionRelationshipType> relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected DataType offset;
        private static final long serialVersionUID = -462773513L;

        public PlanDefinitionActionRelatedActionComponent() {
        }

        public PlanDefinitionActionRelatedActionComponent(String targetId, Enumerations.ActionRelationshipType relationship) {
            this.setTargetId(targetId);
            this.setRelationship(relationship);
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionRelatedActionComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public PlanDefinitionActionRelatedActionComponent setTargetId(String value) {
            if (this.targetId == null) {
                this.targetId = new IdType();
            }
            this.targetId.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.ActionRelationshipType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setRelationshipElement(Enumeration<Enumerations.ActionRelationshipType> value) {
            this.relationship = value;
            return this;
        }

        public Enumerations.ActionRelationshipType getRelationship() {
            return this.relationship == null ? null : (Enumerations.ActionRelationshipType)((Object)this.relationship.getValue());
        }

        public PlanDefinitionActionRelatedActionComponent setRelationship(Enumerations.ActionRelationshipType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<Enumerations.ActionRelationshipType>(new Enumerations.ActionRelationshipTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public DataType getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Duration();
            }
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this != null && this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (this.offset == null) {
                this.offset = new Range();
            }
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this != null && this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setOffset(DataType value) {
            if (value != null && !(value instanceof Duration) && !(value instanceof Range)) {
                throw new Error("Not the right type for PlanDefinition.action.relatedAction.offset[x]: " + value.fhirType());
            }
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId));
            children.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship));
            children.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -441951604: {
                    return new Property("targetId", "id", "The element id of the target related action.", 0, 1, this.targetId);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship);
                }
                case -1960684787: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case -1019779949: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 134075207: {
                    return new Property("offset[x]", "Duration", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 1263585386: {
                    return new Property("offset[x]", "Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.targetId;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    this.targetId = TypeConvertor.castToId(value);
                    return value;
                }
                case -261851592: {
                    value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -1019779949: {
                    this.offset = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("targetId")) {
                this.targetId = TypeConvertor.castToId(value);
            } else if (name.equals("relationship")) {
                value = new Enumerations.ActionRelationshipTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("offset[x]")) {
                this.offset = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return this.getTargetIdElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -441951604: {
                    return new String[]{"id"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case -1019779949: {
                    return new String[]{"Duration", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.relatedAction.targetId");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.relatedAction.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionRelatedActionComponent copy() {
            PlanDefinitionActionRelatedActionComponent dst = new PlanDefinitionActionRelatedActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionRelatedActionComponent dst) {
            super.copyValues(dst);
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionRelatedActionComponent)) {
                return false;
            }
            PlanDefinitionActionRelatedActionComponent o = (PlanDefinitionActionRelatedActionComponent)other_;
            return PlanDefinitionActionRelatedActionComponent.compareDeep(this.targetId, o.targetId, true) && PlanDefinitionActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && PlanDefinitionActionRelatedActionComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionRelatedActionComponent)) {
                return false;
            }
            PlanDefinitionActionRelatedActionComponent o = (PlanDefinitionActionRelatedActionComponent)other_;
            return PlanDefinitionActionRelatedActionComponent.compareValues(this.targetId, o.targetId, true) && PlanDefinitionActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.targetId, this.relationship, this.offset});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.relatedAction";
        }
    }

    @Block
    public static class PlanDefinitionActionOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.")
        protected StringType title;
        @Child(name="requirement", type={DataRequirement.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Defines the data that results as output from the action.")
        protected DataRequirement requirement;
        @Child(name="relatedData", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Points to an existing input or output element that is results as output from the action.")
        protected StringType relatedData;
        private static final long serialVersionUID = 1822414421L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionOutputComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public PlanDefinitionActionOutputComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public PlanDefinitionActionOutputComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public DataRequirement getRequirement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionOutputComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new DataRequirement();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public PlanDefinitionActionOutputComponent setRequirement(DataRequirement value) {
            this.requirement = value;
            return this;
        }

        public StringType getRelatedDataElement() {
            if (this.relatedData == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionOutputComponent.relatedData");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedData = new StringType();
                }
            }
            return this.relatedData;
        }

        public boolean hasRelatedDataElement() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public boolean hasRelatedData() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public PlanDefinitionActionOutputComponent setRelatedDataElement(StringType value) {
            this.relatedData = value;
            return this;
        }

        public String getRelatedData() {
            return this.relatedData == null ? null : (String)this.relatedData.getValue();
        }

        public PlanDefinitionActionOutputComponent setRelatedData(String value) {
            if (Utilities.noString((String)value)) {
                this.relatedData = null;
            } else {
                if (this.relatedData == null) {
                    this.relatedData = new StringType();
                }
                this.relatedData.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PlanDefinition.SP_TITLE, "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title));
            children.add(new Property("requirement", "DataRequirement", "Defines the data that results as output from the action.", 0, 1, this.requirement));
            children.add(new Property("relatedData", "string", "Points to an existing input or output element that is results as output from the action.", 0, 1, this.relatedData));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property(PlanDefinition.SP_TITLE, "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title);
                }
                case 363387971: {
                    return new Property("requirement", "DataRequirement", "Defines the data that results as output from the action.", 0, 1, this.requirement);
                }
                case 1112535669: {
                    return new Property("relatedData", "string", "Points to an existing input or output element that is results as output from the action.", 0, 1, this.relatedData);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1112535669: {
                    Base[] baseArray;
                    if (this.relatedData == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relatedData;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = TypeConvertor.castToDataRequirement(value);
                    return value;
                }
                case 1112535669: {
                    this.relatedData = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("requirement")) {
                this.requirement = TypeConvertor.castToDataRequirement(value);
            } else if (name.equals("relatedData")) {
                this.relatedData = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 363387971: {
                    return this.getRequirement();
                }
                case 1112535669: {
                    return this.getRelatedDataElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 363387971: {
                    return new String[]{"DataRequirement"};
                }
                case 1112535669: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.output.title");
            }
            if (name.equals("requirement")) {
                this.requirement = new DataRequirement();
                return this.requirement;
            }
            if (name.equals("relatedData")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.output.relatedData");
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionOutputComponent copy() {
            PlanDefinitionActionOutputComponent dst = new PlanDefinitionActionOutputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionOutputComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            dst.relatedData = this.relatedData == null ? null : this.relatedData.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionOutputComponent)) {
                return false;
            }
            PlanDefinitionActionOutputComponent o = (PlanDefinitionActionOutputComponent)other_;
            return PlanDefinitionActionOutputComponent.compareDeep(this.title, o.title, true) && PlanDefinitionActionOutputComponent.compareDeep(this.requirement, o.requirement, true) && PlanDefinitionActionOutputComponent.compareDeep(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionOutputComponent)) {
                return false;
            }
            PlanDefinitionActionOutputComponent o = (PlanDefinitionActionOutputComponent)other_;
            return PlanDefinitionActionOutputComponent.compareValues(this.title, o.title, true) && PlanDefinitionActionOutputComponent.compareValues(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.title, this.requirement, this.relatedData});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.output";
        }
    }

    @Block
    public static class PlanDefinitionActionInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.")
        protected StringType title;
        @Child(name="requirement", type={DataRequirement.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Defines the data that is to be provided as input to the action.")
        protected DataRequirement requirement;
        @Child(name="relatedData", type={IdType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What data is provided", formalDefinition="Points to an existing input or output element that provides data to this input.")
        protected IdType relatedData;
        private static final long serialVersionUID = -1064046709L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionInputComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public PlanDefinitionActionInputComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public PlanDefinitionActionInputComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public DataRequirement getRequirement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionInputComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new DataRequirement();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public PlanDefinitionActionInputComponent setRequirement(DataRequirement value) {
            this.requirement = value;
            return this;
        }

        public IdType getRelatedDataElement() {
            if (this.relatedData == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionInputComponent.relatedData");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedData = new IdType();
                }
            }
            return this.relatedData;
        }

        public boolean hasRelatedDataElement() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public boolean hasRelatedData() {
            return this.relatedData != null && !this.relatedData.isEmpty();
        }

        public PlanDefinitionActionInputComponent setRelatedDataElement(IdType value) {
            this.relatedData = value;
            return this;
        }

        public String getRelatedData() {
            return this.relatedData == null ? null : this.relatedData.getValue();
        }

        public PlanDefinitionActionInputComponent setRelatedData(String value) {
            if (Utilities.noString((String)value)) {
                this.relatedData = null;
            } else {
                if (this.relatedData == null) {
                    this.relatedData = new IdType();
                }
                this.relatedData.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PlanDefinition.SP_TITLE, "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title));
            children.add(new Property("requirement", "DataRequirement", "Defines the data that is to be provided as input to the action.", 0, 1, this.requirement));
            children.add(new Property("relatedData", "id", "Points to an existing input or output element that provides data to this input.", 0, 1, this.relatedData));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property(PlanDefinition.SP_TITLE, "string", "A human-readable label for the data requirement used to label data flows in BPMN or similar diagrams. Also provides a human readable label when rendering the data requirement that conveys its purpose to human readers.", 0, 1, this.title);
                }
                case 363387971: {
                    return new Property("requirement", "DataRequirement", "Defines the data that is to be provided as input to the action.", 0, 1, this.requirement);
                }
                case 1112535669: {
                    return new Property("relatedData", "id", "Points to an existing input or output element that provides data to this input.", 0, 1, this.relatedData);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1112535669: {
                    Base[] baseArray;
                    if (this.relatedData == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.relatedData;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 363387971: {
                    this.requirement = TypeConvertor.castToDataRequirement(value);
                    return value;
                }
                case 1112535669: {
                    this.relatedData = TypeConvertor.castToId(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("requirement")) {
                this.requirement = TypeConvertor.castToDataRequirement(value);
            } else if (name.equals("relatedData")) {
                this.relatedData = TypeConvertor.castToId(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 363387971: {
                    return this.getRequirement();
                }
                case 1112535669: {
                    return this.getRelatedDataElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 363387971: {
                    return new String[]{"DataRequirement"};
                }
                case 1112535669: {
                    return new String[]{"id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.input.title");
            }
            if (name.equals("requirement")) {
                this.requirement = new DataRequirement();
                return this.requirement;
            }
            if (name.equals("relatedData")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.input.relatedData");
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionInputComponent copy() {
            PlanDefinitionActionInputComponent dst = new PlanDefinitionActionInputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionInputComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            dst.relatedData = this.relatedData == null ? null : this.relatedData.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionInputComponent)) {
                return false;
            }
            PlanDefinitionActionInputComponent o = (PlanDefinitionActionInputComponent)other_;
            return PlanDefinitionActionInputComponent.compareDeep(this.title, o.title, true) && PlanDefinitionActionInputComponent.compareDeep(this.requirement, o.requirement, true) && PlanDefinitionActionInputComponent.compareDeep(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionInputComponent)) {
                return false;
            }
            PlanDefinitionActionInputComponent o = (PlanDefinitionActionInputComponent)other_;
            return PlanDefinitionActionInputComponent.compareValues(this.title, o.title, true) && PlanDefinitionActionInputComponent.compareValues(this.relatedData, o.relatedData, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.title, this.requirement, this.relatedData});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.input";
        }
    }

    @Block
    public static class PlanDefinitionActionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="applicability | start | stop", formalDefinition="The kind of condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind")
        protected Enumeration<Enumerations.ActionConditionKind> kind;
        @Child(name="expression", type={Expression.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether the condition is satisfied.")
        protected Expression expression;
        private static final long serialVersionUID = -455150438L;

        public PlanDefinitionActionConditionComponent() {
        }

        public PlanDefinitionActionConditionComponent(Enumerations.ActionConditionKind kind) {
            this.setKind(kind);
        }

        public Enumeration<Enumerations.ActionConditionKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setKindElement(Enumeration<Enumerations.ActionConditionKind> value) {
            this.kind = value;
            return this;
        }

        public Enumerations.ActionConditionKind getKind() {
            return this.kind == null ? null : (Enumerations.ActionConditionKind)((Object)this.kind.getValue());
        }

        public PlanDefinitionActionConditionComponent setKind(Enumerations.ActionConditionKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<Enumerations.ActionConditionKind>(new Enumerations.ActionConditionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", "code", "The kind of condition.", 0, 1, this.kind));
            children.add(new Property("expression", "Expression", "An expression that returns true or false, indicating whether the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", "code", "The kind of condition.", 0, 1, this.kind);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression that returns true or false, indicating whether the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    value = new Enumerations.ActionConditionKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                value = new Enumerations.ActionConditionKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.condition.kind");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionConditionComponent copy() {
            PlanDefinitionActionConditionComponent dst = new PlanDefinitionActionConditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionConditionComponent dst) {
            super.copyValues(dst);
            dst.kind = this.kind == null ? null : this.kind.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionConditionComponent)) {
                return false;
            }
            PlanDefinitionActionConditionComponent o = (PlanDefinitionActionConditionComponent)other_;
            return PlanDefinitionActionConditionComponent.compareDeep(this.kind, o.kind, true) && PlanDefinitionActionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionConditionComponent)) {
                return false;
            }
            PlanDefinitionActionConditionComponent o = (PlanDefinitionActionConditionComponent)other_;
            return PlanDefinitionActionConditionComponent.compareValues(this.kind, o.kind, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.kind, this.expression});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.condition";
        }
    }

    @Block
    public static class PlanDefinitionActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique id for the action in the PlanDefinition", formalDefinition="An identifier that is unique within the PlanDefinition to allow linkage within the realized CarePlan and/or RequestGroup.")
        protected StringType linkId;
        @Child(name="prefix", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible prefix for the action (e.g. 1. or A.)", formalDefinition="A user-visible prefix for the action. For example a section or item numbering such as 1. or A.")
        protected StringType prefix;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The textual description of the action displayed to a user. For example, when the action is a test to be performed, the title would be the title of the test such as Assay by HPLC.")
        protected StringType title;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Brief description of the action", formalDefinition="A brief description of the action used to provide a summary to display to the user.")
        protected StringType description;
        @Child(name="textEquivalent", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.")
        protected StringType textEquivalent;
        @Child(name="priority", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the action should be addressed with respect to other actions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
        protected Enumeration<Enumerations.RequestPriority> priority;
        @Child(name="code", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code representing the meaning of the action or sub-actions", formalDefinition="A code that provides a meaning, grouping, or classification for the action or action group. For example, a section may have a LOINC code for the section of a documentation template. In pharmaceutical quality, an action (Test) such as pH could be classified as a physical property.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-code")
        protected CodeableConcept code;
        @Child(name="reason", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why the action should be performed", formalDefinition="A description of why this action is necessary or appropriate.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-reason-code")
        protected List<CodeableConcept> reason;
        @Child(name="documentation", type={RelatedArtifact.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="goalId", type={IdType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What goals this action supports", formalDefinition="Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition. In pharmaceutical quality, a goal represents acceptance criteria (Goal) for a given action (Test), so the goalId would be the unique id of a defined goal element establishing the acceptance criteria for the action.")
        protected List<IdType> goalId;
        @Child(name="subject", type={CodeableConcept.class, Group.class, CanonicalType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of individual the action is focused on", formalDefinition="A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subject-type")
        protected DataType subject;
        @Child(name="trigger", type={TriggerDefinition.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should be triggered", formalDefinition="A description of when the action should be triggered.")
        protected List<TriggerDefinition> trigger;
        @Child(name="condition", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not the action is applicable", formalDefinition="An expression that describes applicability criteria or start/stop conditions for the action.")
        protected List<PlanDefinitionActionConditionComponent> condition;
        @Child(name="input", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Input data requirements", formalDefinition="Defines input data requirements for the action.")
        protected List<PlanDefinitionActionInputComponent> input;
        @Child(name="output", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Output data definition", formalDefinition="Defines the outputs of the action, if any.")
        protected List<PlanDefinitionActionOutputComponent> output;
        @Child(name="relatedAction", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected List<PlanDefinitionActionRelatedActionComponent> relatedAction;
        @Child(name="timing", type={Age.class, Duration.class, Range.class, Timing.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should take place", formalDefinition="An optional value describing when the action should be performed.")
        protected DataType timing;
        @Child(name="location", type={CodeableReference.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.")
        protected CodeableReference location;
        @Child(name="participant", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who should participate in the action", formalDefinition="Indicates who should participate in performing the action described.")
        protected List<PlanDefinitionActionParticipantComponent> participant;
        @Child(name="type", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-type")
        protected CodeableConcept type;
        @Child(name="groupingBehavior", type={CodeType.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="visual-group | logical-group | sentence-group", formalDefinition="Defines the grouping behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior")
        protected Enumeration<Enumerations.ActionGroupingBehavior> groupingBehavior;
        @Child(name="selectionBehavior", type={CodeType.class}, order=22, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="any | all | all-or-none | exactly-one | at-most-one | one-or-more", formalDefinition="Defines the selection behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior")
        protected Enumeration<Enumerations.ActionSelectionBehavior> selectionBehavior;
        @Child(name="requiredBehavior", type={CodeType.class}, order=23, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="must | could | must-unless-documented", formalDefinition="Defines the required behavior for the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior")
        protected Enumeration<Enumerations.ActionRequiredBehavior> requiredBehavior;
        @Child(name="precheckBehavior", type={CodeType.class}, order=24, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="yes | no", formalDefinition="Defines whether the action should usually be preselected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior")
        protected Enumeration<Enumerations.ActionPrecheckBehavior> precheckBehavior;
        @Child(name="cardinalityBehavior", type={CodeType.class}, order=25, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="single | multiple", formalDefinition="Defines whether the action can be selected multiple times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior")
        protected Enumeration<Enumerations.ActionCardinalityBehavior> cardinalityBehavior;
        @Child(name="definition", type={CanonicalType.class, UriType.class}, order=26, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the activity to be performed", formalDefinition="A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.")
        protected DataType definition;
        @Child(name="transform", type={CanonicalType.class}, order=27, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Transform to apply the template", formalDefinition="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.")
        protected CanonicalType transform;
        @Child(name="dynamicValue", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.")
        protected List<PlanDefinitionActionDynamicValueComponent> dynamicValue;
        @Child(name="action", type={PlanDefinitionActionComponent.class}, order=29, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A sub-action", formalDefinition="Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.")
        protected List<PlanDefinitionActionComponent> action;
        private static final long serialVersionUID = 1445040760L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public PlanDefinitionActionComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public PlanDefinitionActionComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getPrefixElement() {
            if (this.prefix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.prefix");
                }
                if (Configuration.doAutoCreate()) {
                    this.prefix = new StringType();
                }
            }
            return this.prefix;
        }

        public boolean hasPrefixElement() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public boolean hasPrefix() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public PlanDefinitionActionComponent setPrefixElement(StringType value) {
            this.prefix = value;
            return this;
        }

        public String getPrefix() {
            return this.prefix == null ? null : (String)this.prefix.getValue();
        }

        public PlanDefinitionActionComponent setPrefix(String value) {
            if (Utilities.noString((String)value)) {
                this.prefix = null;
            } else {
                if (this.prefix == null) {
                    this.prefix = new StringType();
                }
                this.prefix.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public PlanDefinitionActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public PlanDefinitionActionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionActionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PlanDefinitionActionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new StringType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public PlanDefinitionActionComponent setTextEquivalentElement(StringType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public PlanDefinitionActionComponent setTextEquivalent(String value) {
            if (Utilities.noString((String)value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new StringType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.RequestPriority> getPriorityElement() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
                }
            }
            return this.priority;
        }

        public boolean hasPriorityElement() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public PlanDefinitionActionComponent setPriorityElement(Enumeration<Enumerations.RequestPriority> value) {
            this.priority = value;
            return this;
        }

        public Enumerations.RequestPriority getPriority() {
            return this.priority == null ? null : (Enumerations.RequestPriority)((Object)this.priority.getValue());
        }

        public PlanDefinitionActionComponent setPriority(Enumerations.RequestPriority value) {
            if (value == null) {
                this.priority = null;
            } else {
                if (this.priority == null) {
                    this.priority = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
                }
                this.priority.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PlanDefinitionActionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public PlanDefinitionActionComponent setReason(List<CodeableConcept> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableConcept getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public PlanDefinitionActionComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<IdType> getGoalId() {
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            return this.goalId;
        }

        public PlanDefinitionActionComponent setGoalId(List<IdType> theGoalId) {
            this.goalId = theGoalId;
            return this;
        }

        public boolean hasGoalId() {
            if (this.goalId == null) {
                return false;
            }
            for (IdType item : this.goalId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IdType addGoalIdElement() {
            IdType t = new IdType();
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            this.goalId.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addGoalId(String value) {
            IdType t = new IdType();
            t.setValue(value);
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            this.goalId.add(t);
            return this;
        }

        public boolean hasGoalId(String value) {
            if (this.goalId == null) {
                return false;
            }
            for (IdType v : this.goalId) {
                if (!v.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public DataType getSubject() {
            return this.subject;
        }

        public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
            if (this.subject == null) {
                this.subject = new CodeableConcept();
            }
            if (!(this.subject instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.subject;
        }

        public boolean hasSubjectCodeableConcept() {
            return this != null && this.subject instanceof CodeableConcept;
        }

        public Reference getSubjectReference() throws FHIRException {
            if (this.subject == null) {
                this.subject = new Reference();
            }
            if (!(this.subject instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
            }
            return (Reference)this.subject;
        }

        public boolean hasSubjectReference() {
            return this != null && this.subject instanceof Reference;
        }

        public CanonicalType getSubjectCanonicalType() throws FHIRException {
            if (this.subject == null) {
                this.subject = new CanonicalType();
            }
            if (!(this.subject instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.subject.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.subject;
        }

        public boolean hasSubjectCanonicalType() {
            return this != null && this.subject instanceof CanonicalType;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public PlanDefinitionActionComponent setSubject(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Reference || value instanceof CanonicalType)) {
                throw new Error("Not the right type for PlanDefinition.action.subject[x]: " + value.fhirType());
            }
            this.subject = value;
            return this;
        }

        public List<TriggerDefinition> getTrigger() {
            if (this.trigger == null) {
                this.trigger = new ArrayList<TriggerDefinition>();
            }
            return this.trigger;
        }

        public PlanDefinitionActionComponent setTrigger(List<TriggerDefinition> theTrigger) {
            this.trigger = theTrigger;
            return this;
        }

        public boolean hasTrigger() {
            if (this.trigger == null) {
                return false;
            }
            for (TriggerDefinition item : this.trigger) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TriggerDefinition addTrigger() {
            TriggerDefinition t = new TriggerDefinition();
            if (this.trigger == null) {
                this.trigger = new ArrayList<TriggerDefinition>();
            }
            this.trigger.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addTrigger(TriggerDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.trigger == null) {
                this.trigger = new ArrayList<TriggerDefinition>();
            }
            this.trigger.add(t);
            return this;
        }

        public TriggerDefinition getTriggerFirstRep() {
            if (this.getTrigger().isEmpty()) {
                this.addTrigger();
            }
            return this.getTrigger().get(0);
        }

        public List<PlanDefinitionActionConditionComponent> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            return this.condition;
        }

        public PlanDefinitionActionComponent setCondition(List<PlanDefinitionActionConditionComponent> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (PlanDefinitionActionConditionComponent item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionConditionComponent addCondition() {
            PlanDefinitionActionConditionComponent t = new PlanDefinitionActionConditionComponent();
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            this.condition.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addCondition(PlanDefinitionActionConditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            this.condition.add(t);
            return this;
        }

        public PlanDefinitionActionConditionComponent getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<PlanDefinitionActionInputComponent> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<PlanDefinitionActionInputComponent>();
            }
            return this.input;
        }

        public PlanDefinitionActionComponent setInput(List<PlanDefinitionActionInputComponent> theInput) {
            this.input = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (PlanDefinitionActionInputComponent item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionInputComponent addInput() {
            PlanDefinitionActionInputComponent t = new PlanDefinitionActionInputComponent();
            if (this.input == null) {
                this.input = new ArrayList<PlanDefinitionActionInputComponent>();
            }
            this.input.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addInput(PlanDefinitionActionInputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<PlanDefinitionActionInputComponent>();
            }
            this.input.add(t);
            return this;
        }

        public PlanDefinitionActionInputComponent getInputFirstRep() {
            if (this.getInput().isEmpty()) {
                this.addInput();
            }
            return this.getInput().get(0);
        }

        public List<PlanDefinitionActionOutputComponent> getOutput() {
            if (this.output == null) {
                this.output = new ArrayList<PlanDefinitionActionOutputComponent>();
            }
            return this.output;
        }

        public PlanDefinitionActionComponent setOutput(List<PlanDefinitionActionOutputComponent> theOutput) {
            this.output = theOutput;
            return this;
        }

        public boolean hasOutput() {
            if (this.output == null) {
                return false;
            }
            for (PlanDefinitionActionOutputComponent item : this.output) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionOutputComponent addOutput() {
            PlanDefinitionActionOutputComponent t = new PlanDefinitionActionOutputComponent();
            if (this.output == null) {
                this.output = new ArrayList<PlanDefinitionActionOutputComponent>();
            }
            this.output.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addOutput(PlanDefinitionActionOutputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.output == null) {
                this.output = new ArrayList<PlanDefinitionActionOutputComponent>();
            }
            this.output.add(t);
            return this;
        }

        public PlanDefinitionActionOutputComponent getOutputFirstRep() {
            if (this.getOutput().isEmpty()) {
                this.addOutput();
            }
            return this.getOutput().get(0);
        }

        public List<PlanDefinitionActionRelatedActionComponent> getRelatedAction() {
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            return this.relatedAction;
        }

        public PlanDefinitionActionComponent setRelatedAction(List<PlanDefinitionActionRelatedActionComponent> theRelatedAction) {
            this.relatedAction = theRelatedAction;
            return this;
        }

        public boolean hasRelatedAction() {
            if (this.relatedAction == null) {
                return false;
            }
            for (PlanDefinitionActionRelatedActionComponent item : this.relatedAction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionRelatedActionComponent addRelatedAction() {
            PlanDefinitionActionRelatedActionComponent t = new PlanDefinitionActionRelatedActionComponent();
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addRelatedAction(PlanDefinitionActionRelatedActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return this;
        }

        public PlanDefinitionActionRelatedActionComponent getRelatedActionFirstRep() {
            if (this.getRelatedAction().isEmpty()) {
                this.addRelatedAction();
            }
            return this.getRelatedAction().get(0);
        }

        public DataType getTiming() {
            return this.timing;
        }

        public Age getTimingAge() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Age();
            }
            if (!(this.timing instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Age)this.timing;
        }

        public boolean hasTimingAge() {
            return this != null && this.timing instanceof Age;
        }

        public Duration getTimingDuration() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Duration();
            }
            if (!(this.timing instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Duration)this.timing;
        }

        public boolean hasTimingDuration() {
            return this != null && this.timing instanceof Duration;
        }

        public Range getTimingRange() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Range();
            }
            if (!(this.timing instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Range)this.timing;
        }

        public boolean hasTimingRange() {
            return this != null && this.timing instanceof Range;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Timing();
            }
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this != null && this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public PlanDefinitionActionComponent setTiming(DataType value) {
            if (!(value == null || value instanceof Age || value instanceof Duration || value instanceof Range || value instanceof Timing)) {
                throw new Error("Not the right type for PlanDefinition.action.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public CodeableReference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new CodeableReference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public PlanDefinitionActionComponent setLocation(CodeableReference value) {
            this.location = value;
            return this;
        }

        public List<PlanDefinitionActionParticipantComponent> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            return this.participant;
        }

        public PlanDefinitionActionComponent setParticipant(List<PlanDefinitionActionParticipantComponent> theParticipant) {
            this.participant = theParticipant;
            return this;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (PlanDefinitionActionParticipantComponent item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionParticipantComponent addParticipant() {
            PlanDefinitionActionParticipantComponent t = new PlanDefinitionActionParticipantComponent();
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            this.participant.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addParticipant(PlanDefinitionActionParticipantComponent t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            this.participant.add(t);
            return this;
        }

        public PlanDefinitionActionParticipantComponent getParticipantFirstRep() {
            if (this.getParticipant().isEmpty()) {
                this.addParticipant();
            }
            return this.getParticipant().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanDefinitionActionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<Enumerations.ActionGroupingBehavior> getGroupingBehaviorElement() {
            if (this.groupingBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.groupingBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingBehavior = new Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
                }
            }
            return this.groupingBehavior;
        }

        public boolean hasGroupingBehaviorElement() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public boolean hasGroupingBehavior() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setGroupingBehaviorElement(Enumeration<Enumerations.ActionGroupingBehavior> value) {
            this.groupingBehavior = value;
            return this;
        }

        public Enumerations.ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior == null ? null : (Enumerations.ActionGroupingBehavior)((Object)this.groupingBehavior.getValue());
        }

        public PlanDefinitionActionComponent setGroupingBehavior(Enumerations.ActionGroupingBehavior value) {
            if (value == null) {
                this.groupingBehavior = null;
            } else {
                if (this.groupingBehavior == null) {
                    this.groupingBehavior = new Enumeration<Enumerations.ActionGroupingBehavior>(new Enumerations.ActionGroupingBehaviorEnumFactory());
                }
                this.groupingBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionSelectionBehavior> getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setSelectionBehaviorElement(Enumeration<Enumerations.ActionSelectionBehavior> value) {
            this.selectionBehavior = value;
            return this;
        }

        public Enumerations.ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (Enumerations.ActionSelectionBehavior)((Object)this.selectionBehavior.getValue());
        }

        public PlanDefinitionActionComponent setSelectionBehavior(Enumerations.ActionSelectionBehavior value) {
            if (value == null) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new Enumeration<Enumerations.ActionSelectionBehavior>(new Enumerations.ActionSelectionBehaviorEnumFactory());
                }
                this.selectionBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionRequiredBehavior> getRequiredBehaviorElement() {
            if (this.requiredBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.requiredBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.requiredBehavior = new Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
                }
            }
            return this.requiredBehavior;
        }

        public boolean hasRequiredBehaviorElement() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public boolean hasRequiredBehavior() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setRequiredBehaviorElement(Enumeration<Enumerations.ActionRequiredBehavior> value) {
            this.requiredBehavior = value;
            return this;
        }

        public Enumerations.ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior == null ? null : (Enumerations.ActionRequiredBehavior)((Object)this.requiredBehavior.getValue());
        }

        public PlanDefinitionActionComponent setRequiredBehavior(Enumerations.ActionRequiredBehavior value) {
            if (value == null) {
                this.requiredBehavior = null;
            } else {
                if (this.requiredBehavior == null) {
                    this.requiredBehavior = new Enumeration<Enumerations.ActionRequiredBehavior>(new Enumerations.ActionRequiredBehaviorEnumFactory());
                }
                this.requiredBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionPrecheckBehavior> getPrecheckBehaviorElement() {
            if (this.precheckBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.precheckBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.precheckBehavior = new Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
                }
            }
            return this.precheckBehavior;
        }

        public boolean hasPrecheckBehaviorElement() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public boolean hasPrecheckBehavior() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setPrecheckBehaviorElement(Enumeration<Enumerations.ActionPrecheckBehavior> value) {
            this.precheckBehavior = value;
            return this;
        }

        public Enumerations.ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior == null ? null : (Enumerations.ActionPrecheckBehavior)((Object)this.precheckBehavior.getValue());
        }

        public PlanDefinitionActionComponent setPrecheckBehavior(Enumerations.ActionPrecheckBehavior value) {
            if (value == null) {
                this.precheckBehavior = null;
            } else {
                if (this.precheckBehavior == null) {
                    this.precheckBehavior = new Enumeration<Enumerations.ActionPrecheckBehavior>(new Enumerations.ActionPrecheckBehaviorEnumFactory());
                }
                this.precheckBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<Enumerations.ActionCardinalityBehavior> getCardinalityBehaviorElement() {
            if (this.cardinalityBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.cardinalityBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.cardinalityBehavior = new Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
                }
            }
            return this.cardinalityBehavior;
        }

        public boolean hasCardinalityBehaviorElement() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public boolean hasCardinalityBehavior() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setCardinalityBehaviorElement(Enumeration<Enumerations.ActionCardinalityBehavior> value) {
            this.cardinalityBehavior = value;
            return this;
        }

        public Enumerations.ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior == null ? null : (Enumerations.ActionCardinalityBehavior)((Object)this.cardinalityBehavior.getValue());
        }

        public PlanDefinitionActionComponent setCardinalityBehavior(Enumerations.ActionCardinalityBehavior value) {
            if (value == null) {
                this.cardinalityBehavior = null;
            } else {
                if (this.cardinalityBehavior == null) {
                    this.cardinalityBehavior = new Enumeration<Enumerations.ActionCardinalityBehavior>(new Enumerations.ActionCardinalityBehaviorEnumFactory());
                }
                this.cardinalityBehavior.setValue((Object)value);
            }
            return this;
        }

        public DataType getDefinition() {
            return this.definition;
        }

        public CanonicalType getDefinitionCanonicalType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            if (!(this.definition instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.definition;
        }

        public boolean hasDefinitionCanonicalType() {
            return this != null && this.definition instanceof CanonicalType;
        }

        public UriType getDefinitionUriType() throws FHIRException {
            if (this.definition == null) {
                this.definition = new UriType();
            }
            if (!(this.definition instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.definition.getClass().getName() + " was encountered");
            }
            return (UriType)this.definition;
        }

        public boolean hasDefinitionUriType() {
            return this != null && this.definition instanceof UriType;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public PlanDefinitionActionComponent setDefinition(DataType value) {
            if (value != null && !(value instanceof CanonicalType) && !(value instanceof UriType)) {
                throw new Error("Not the right type for PlanDefinition.action.definition[x]: " + value.fhirType());
            }
            this.definition = value;
            return this;
        }

        public CanonicalType getTransformElement() {
            if (this.transform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transform = new CanonicalType();
                }
            }
            return this.transform;
        }

        public boolean hasTransformElement() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public boolean hasTransform() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public PlanDefinitionActionComponent setTransformElement(CanonicalType value) {
            this.transform = value;
            return this;
        }

        public String getTransform() {
            return this.transform == null ? null : (String)this.transform.getValue();
        }

        public PlanDefinitionActionComponent setTransform(String value) {
            if (Utilities.noString((String)value)) {
                this.transform = null;
            } else {
                if (this.transform == null) {
                    this.transform = new CanonicalType();
                }
                this.transform.setValue(value);
            }
            return this;
        }

        public List<PlanDefinitionActionDynamicValueComponent> getDynamicValue() {
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            return this.dynamicValue;
        }

        public PlanDefinitionActionComponent setDynamicValue(List<PlanDefinitionActionDynamicValueComponent> theDynamicValue) {
            this.dynamicValue = theDynamicValue;
            return this;
        }

        public boolean hasDynamicValue() {
            if (this.dynamicValue == null) {
                return false;
            }
            for (PlanDefinitionActionDynamicValueComponent item : this.dynamicValue) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionDynamicValueComponent addDynamicValue() {
            PlanDefinitionActionDynamicValueComponent t = new PlanDefinitionActionDynamicValueComponent();
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addDynamicValue(PlanDefinitionActionDynamicValueComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return this;
        }

        public PlanDefinitionActionDynamicValueComponent getDynamicValueFirstRep() {
            if (this.getDynamicValue().isEmpty()) {
                this.addDynamicValue();
            }
            return this.getDynamicValue().get(0);
        }

        public List<PlanDefinitionActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            return this.action;
        }

        public PlanDefinitionActionComponent setAction(List<PlanDefinitionActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (PlanDefinitionActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionComponent addAction() {
            PlanDefinitionActionComponent t = new PlanDefinitionActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addAction(PlanDefinitionActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public PlanDefinitionActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "string", "An identifier that is unique within the PlanDefinition to allow linkage within the realized CarePlan and/or RequestGroup.", 0, 1, this.linkId));
            children.add(new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix));
            children.add(new Property(PlanDefinition.SP_TITLE, "string", "The textual description of the action displayed to a user. For example, when the action is a test to be performed, the title would be the title of the test such as Assay by HPLC.", 0, 1, this.title));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief description of the action used to provide a summary to display to the user.", 0, 1, this.description));
            children.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent));
            children.add(new Property("priority", "code", "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority));
            children.add(new Property("code", "CodeableConcept", "A code that provides a meaning, grouping, or classification for the action or action group. For example, a section may have a LOINC code for the section of a documentation template. In pharmaceutical quality, an action (Test) such as pH could be classified as a physical property.", 0, 1, this.code));
            children.add(new Property("reason", "CodeableConcept", "A description of why this action is necessary or appropriate.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("goalId", "id", "Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition. In pharmaceutical quality, a goal represents acceptance criteria (Goal) for a given action (Test), so the goalId would be the unique id of a defined goal element establishing the acceptance criteria for the action.", 0, Integer.MAX_VALUE, this.goalId));
            children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject));
            children.add(new Property("trigger", "TriggerDefinition", "A description of when the action should be triggered.", 0, Integer.MAX_VALUE, this.trigger));
            children.add(new Property("condition", "", "An expression that describes applicability criteria or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("input", "", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input));
            children.add(new Property("output", "", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output));
            children.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            children.add(new Property("timing[x]", "Age|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing));
            children.add(new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
            children.add(new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant));
            children.add(new Property(PlanDefinition.SP_TYPE, "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type));
            children.add(new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior));
            children.add(new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior));
            children.add(new Property("requiredBehavior", "code", "Defines the required behavior for the action.", 0, 1, this.requiredBehavior));
            children.add(new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior));
            children.add(new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior));
            children.add(new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition));
            children.add(new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform));
            children.add(new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue));
            children.add(new Property("action", "@PlanDefinition.action", "Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "string", "An identifier that is unique within the PlanDefinition to allow linkage within the realized CarePlan and/or RequestGroup.", 0, 1, this.linkId);
                }
                case -980110702: {
                    return new Property("prefix", "string", "A user-visible prefix for the action. For example a section or item numbering such as 1. or A.", 0, 1, this.prefix);
                }
                case 110371416: {
                    return new Property(PlanDefinition.SP_TITLE, "string", "The textual description of the action displayed to a user. For example, when the action is a test to be performed, the title would be the title of the test such as Assay by HPLC.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief description of the action used to provide a summary to display to the user.", 0, 1, this.description);
                }
                case -900391049: {
                    return new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent);
                }
                case -1165461084: {
                    return new Property("priority", "code", "Indicates how quickly the action should be addressed with respect to other actions.", 0, 1, this.priority);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that provides a meaning, grouping, or classification for the action or action group. For example, a section may have a LOINC code for the section of a documentation template. In pharmaceutical quality, an action (Test) such as pH could be classified as a physical property.", 0, 1, this.code);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "A description of why this action is necessary or appropriate.", 0, Integer.MAX_VALUE, this.reason);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case -1240658034: {
                    return new Property("goalId", "id", "Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition. In pharmaceutical quality, a goal represents acceptance criteria (Goal) for a given action (Test), so the goalId would be the unique id of a defined goal element establishing the acceptance criteria for the action.", 0, Integer.MAX_VALUE, this.goalId);
                }
                case -573640748: {
                    return new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
                }
                case -1867885268: {
                    return new Property("subject[x]", "CodeableConcept|Reference(Group)|canonical", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
                }
                case -1257122603: {
                    return new Property("subject[x]", "CodeableConcept", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
                }
                case 772938623: {
                    return new Property("subject[x]", "Reference(Group)", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
                }
                case -1768521432: {
                    return new Property("subject[x]", "canonical", "A code, group definition, or canonical reference that describes the intended subject of the action and its children, if any. Canonical references are allowed to support the definition of protocols for drug and substance quality specifications, and is allowed to reference a MedicinalProductDefinition, SubstanceDefinition, AdministrableProductDefinition, ManufacturedItemDefinition, or PackagedProductDefinition resource.", 0, 1, this.subject);
                }
                case -1059891784: {
                    return new Property("trigger", "TriggerDefinition", "A description of when the action should be triggered.", 0, Integer.MAX_VALUE, this.trigger);
                }
                case -861311717: {
                    return new Property("condition", "", "An expression that describes applicability criteria or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition);
                }
                case 100358090: {
                    return new Property("input", "", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input);
                }
                case -1005512447: {
                    return new Property("output", "", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output);
                }
                case -384107967: {
                    return new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction);
                }
                case 164632566: {
                    return new Property("timing[x]", "Age|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "Age|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 164607061: {
                    return new Property("timing[x]", "Age", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1327253506: {
                    return new Property("timing[x]", "Duration", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -710871277: {
                    return new Property("timing[x]", "Range", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -497554124: {
                    return new Property("timing[x]", "Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 1901043637: {
                    return new Property("location", "CodeableReference(Location)", "Identifies the facility where the action will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
                }
                case 767422259: {
                    return new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant);
                }
                case 3575610: {
                    return new Property(PlanDefinition.SP_TYPE, "CodeableConcept", "The type of action to perform (create, update, remove).", 0, 1, this.type);
                }
                case 586678389: {
                    return new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior);
                }
                case 168639486: {
                    return new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior);
                }
                case -1163906287: {
                    return new Property("requiredBehavior", "code", "Defines the required behavior for the action.", 0, 1, this.requiredBehavior);
                }
                case -1174249033: {
                    return new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior);
                }
                case -922577408: {
                    return new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior);
                }
                case -1139422643: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case -1014418093: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire)|uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case 933485793: {
                    return new Property("definition[x]", "canonical(ActivityDefinition|ObservationDefinition|PlanDefinition|Questionnaire)", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case -1139428583: {
                    return new Property("definition[x]", "uri", "A reference to an ActivityDefinition that describes the action to be taken in detail, a PlanDefinition that describes a series of actions to be taken, a Questionnaire that should be filled out, or an ObservationDefinition that specifies what observation should be captured.", 0, 1, this.definition);
                }
                case 1052666732: {
                    return new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform);
                }
                case 572625010: {
                    return new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue);
                }
                case -1422950858: {
                    return new Property("action", "@PlanDefinition.action", "Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -980110702: {
                    Base[] baseArray;
                    if (this.prefix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.prefix;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.priority;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.code;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case -1240658034: {
                    return this.goalId == null ? new Base[]{} : this.goalId.toArray(new Base[this.goalId.size()]);
                }
                case -1867885268: {
                    Base[] baseArray;
                    if (this.subject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.subject;
                    }
                    return baseArray;
                }
                case -1059891784: {
                    return this.trigger == null ? new Base[]{} : this.trigger.toArray(new Base[this.trigger.size()]);
                }
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case -1005512447: {
                    return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
                }
                case -384107967: {
                    return this.relatedAction == null ? new Base[]{} : this.relatedAction.toArray(new Base[this.relatedAction.size()]);
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.timing;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.location;
                    }
                    return baseArray;
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.type;
                    }
                    return baseArray;
                }
                case 586678389: {
                    Base[] baseArray;
                    if (this.groupingBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.groupingBehavior;
                    }
                    return baseArray;
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1163906287: {
                    Base[] baseArray;
                    if (this.requiredBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.requiredBehavior;
                    }
                    return baseArray;
                }
                case -1174249033: {
                    Base[] baseArray;
                    if (this.precheckBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray16 = new Base[1];
                        baseArray = baseArray16;
                        baseArray16[0] = this.precheckBehavior;
                    }
                    return baseArray;
                }
                case -922577408: {
                    Base[] baseArray;
                    if (this.cardinalityBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray17 = new Base[1];
                        baseArray = baseArray17;
                        baseArray17[0] = this.cardinalityBehavior;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray18 = new Base[1];
                        baseArray = baseArray18;
                        baseArray18[0] = this.definition;
                    }
                    return baseArray;
                }
                case 1052666732: {
                    Base[] baseArray;
                    if (this.transform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray19 = new Base[1];
                        baseArray = baseArray19;
                        baseArray19[0] = this.transform;
                    }
                    return baseArray;
                }
                case 572625010: {
                    return this.dynamicValue == null ? new Base[]{} : this.dynamicValue.toArray(new Base[this.dynamicValue.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToString(value);
                    return value;
                }
                case -980110702: {
                    this.prefix = TypeConvertor.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -900391049: {
                    this.textEquivalent = TypeConvertor.castToString(value);
                    return value;
                }
                case -1165461084: {
                    value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.priority = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.getReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case -1240658034: {
                    this.getGoalId().add(TypeConvertor.castToId(value));
                    return value;
                }
                case -1867885268: {
                    this.subject = TypeConvertor.castToType(value);
                    return value;
                }
                case -1059891784: {
                    this.getTrigger().add(TypeConvertor.castToTriggerDefinition(value));
                    return value;
                }
                case -861311717: {
                    this.getCondition().add((PlanDefinitionActionConditionComponent)((Object)value));
                    return value;
                }
                case 100358090: {
                    this.getInput().add((PlanDefinitionActionInputComponent)((Object)value));
                    return value;
                }
                case -1005512447: {
                    this.getOutput().add((PlanDefinitionActionOutputComponent)((Object)value));
                    return value;
                }
                case -384107967: {
                    this.getRelatedAction().add((PlanDefinitionActionRelatedActionComponent)((Object)value));
                    return value;
                }
                case -873664438: {
                    this.timing = TypeConvertor.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 767422259: {
                    this.getParticipant().add((PlanDefinitionActionParticipantComponent)((Object)value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 586678389: {
                    value = new Enumerations.ActionGroupingBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.groupingBehavior = value;
                    return value;
                }
                case 168639486: {
                    value = new Enumerations.ActionSelectionBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.selectionBehavior = value;
                    return value;
                }
                case -1163906287: {
                    value = new Enumerations.ActionRequiredBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.requiredBehavior = value;
                    return value;
                }
                case -1174249033: {
                    value = new Enumerations.ActionPrecheckBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.precheckBehavior = value;
                    return value;
                }
                case -922577408: {
                    value = new Enumerations.ActionCardinalityBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.cardinalityBehavior = value;
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToType(value);
                    return value;
                }
                case 1052666732: {
                    this.transform = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 572625010: {
                    this.getDynamicValue().add((PlanDefinitionActionDynamicValueComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((PlanDefinitionActionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToString(value);
            } else if (name.equals("prefix")) {
                this.prefix = TypeConvertor.castToString(value);
            } else if (name.equals(PlanDefinition.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = TypeConvertor.castToString(value);
            } else if (name.equals("priority")) {
                value = new Enumerations.RequestPriorityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.priority = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("goalId")) {
                this.getGoalId().add(TypeConvertor.castToId(value));
            } else if (name.equals("subject[x]")) {
                this.subject = TypeConvertor.castToType(value);
            } else if (name.equals("trigger")) {
                this.getTrigger().add(TypeConvertor.castToTriggerDefinition(value));
            } else if (name.equals("condition")) {
                this.getCondition().add((PlanDefinitionActionConditionComponent)((Object)value));
            } else if (name.equals("input")) {
                this.getInput().add((PlanDefinitionActionInputComponent)((Object)value));
            } else if (name.equals("output")) {
                this.getOutput().add((PlanDefinitionActionOutputComponent)((Object)value));
            } else if (name.equals("relatedAction")) {
                this.getRelatedAction().add((PlanDefinitionActionRelatedActionComponent)((Object)value));
            } else if (name.equals("timing[x]")) {
                this.timing = TypeConvertor.castToType(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("participant")) {
                this.getParticipant().add((PlanDefinitionActionParticipantComponent)((Object)value));
            } else if (name.equals(PlanDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("groupingBehavior")) {
                value = new Enumerations.ActionGroupingBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.groupingBehavior = value;
            } else if (name.equals("selectionBehavior")) {
                value = new Enumerations.ActionSelectionBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.selectionBehavior = value;
            } else if (name.equals("requiredBehavior")) {
                value = new Enumerations.ActionRequiredBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.requiredBehavior = value;
            } else if (name.equals("precheckBehavior")) {
                value = new Enumerations.ActionPrecheckBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.precheckBehavior = value;
            } else if (name.equals("cardinalityBehavior")) {
                value = new Enumerations.ActionCardinalityBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.cardinalityBehavior = value;
            } else if (name.equals("definition[x]")) {
                this.definition = TypeConvertor.castToType(value);
            } else if (name.equals("transform")) {
                this.transform = TypeConvertor.castToCanonical(value);
            } else if (name.equals("dynamicValue")) {
                this.getDynamicValue().add((PlanDefinitionActionDynamicValueComponent)((Object)value));
            } else if (name.equals("action")) {
                this.getAction().add((PlanDefinitionActionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -980110702: {
                    return this.getPrefixElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -900391049: {
                    return this.getTextEquivalentElement();
                }
                case -1165461084: {
                    return this.getPriorityElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case -1240658034: {
                    return this.addGoalIdElement();
                }
                case -573640748: {
                    return this.getSubject();
                }
                case -1867885268: {
                    return this.getSubject();
                }
                case -1059891784: {
                    return this.addTrigger();
                }
                case -861311717: {
                    return this.addCondition();
                }
                case 100358090: {
                    return this.addInput();
                }
                case -1005512447: {
                    return this.addOutput();
                }
                case -384107967: {
                    return this.addRelatedAction();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    return this.getType();
                }
                case 586678389: {
                    return this.getGroupingBehaviorElement();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1163906287: {
                    return this.getRequiredBehaviorElement();
                }
                case -1174249033: {
                    return this.getPrecheckBehaviorElement();
                }
                case -922577408: {
                    return this.getCardinalityBehaviorElement();
                }
                case -1139422643: {
                    return this.getDefinition();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 1052666732: {
                    return this.getTransformElement();
                }
                case 572625010: {
                    return this.addDynamicValue();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"string"};
                }
                case -980110702: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -900391049: {
                    return new String[]{"string"};
                }
                case -1165461084: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case -1240658034: {
                    return new String[]{"id"};
                }
                case -1867885268: {
                    return new String[]{"CodeableConcept", "Reference", "canonical"};
                }
                case -1059891784: {
                    return new String[]{"TriggerDefinition"};
                }
                case -861311717: {
                    return new String[0];
                }
                case 100358090: {
                    return new String[0];
                }
                case -1005512447: {
                    return new String[0];
                }
                case -384107967: {
                    return new String[0];
                }
                case -873664438: {
                    return new String[]{"Age", "Duration", "Range", "Timing"};
                }
                case 1901043637: {
                    return new String[]{"CodeableReference"};
                }
                case 767422259: {
                    return new String[0];
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 586678389: {
                    return new String[]{"code"};
                }
                case 168639486: {
                    return new String[]{"code"};
                }
                case -1163906287: {
                    return new String[]{"code"};
                }
                case -1174249033: {
                    return new String[]{"code"};
                }
                case -922577408: {
                    return new String[]{"code"};
                }
                case -1014418093: {
                    return new String[]{"canonical", "uri"};
                }
                case 1052666732: {
                    return new String[]{"canonical"};
                }
                case 572625010: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"@PlanDefinition.action"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.linkId");
            }
            if (name.equals("prefix")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.prefix");
            }
            if (name.equals(PlanDefinition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.title");
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.textEquivalent");
            }
            if (name.equals("priority")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.priority");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("goalId")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.goalId");
            }
            if (name.equals("subjectCodeableConcept")) {
                this.subject = new CodeableConcept();
                return this.subject;
            }
            if (name.equals("subjectReference")) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("subjectCanonical")) {
                this.subject = new CanonicalType();
                return this.subject;
            }
            if (name.equals("trigger")) {
                return this.addTrigger();
            }
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("output")) {
                return this.addOutput();
            }
            if (name.equals("relatedAction")) {
                return this.addRelatedAction();
            }
            if (name.equals("timingAge")) {
                this.timing = new Age();
                return this.timing;
            }
            if (name.equals("timingDuration")) {
                this.timing = new Duration();
                return this.timing;
            }
            if (name.equals("timingRange")) {
                this.timing = new Range();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("location")) {
                this.location = new CodeableReference();
                return this.location;
            }
            if (name.equals("participant")) {
                return this.addParticipant();
            }
            if (name.equals(PlanDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("groupingBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.groupingBehavior");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.selectionBehavior");
            }
            if (name.equals("requiredBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.requiredBehavior");
            }
            if (name.equals("precheckBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.precheckBehavior");
            }
            if (name.equals("cardinalityBehavior")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.cardinalityBehavior");
            }
            if (name.equals("definitionCanonical")) {
                this.definition = new CanonicalType();
                return this.definition;
            }
            if (name.equals("definitionUri")) {
                this.definition = new UriType();
                return this.definition;
            }
            if (name.equals("transform")) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.action.transform");
            }
            if (name.equals("dynamicValue")) {
                return this.addDynamicValue();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionComponent copy() {
            PlanDefinitionActionComponent dst = new PlanDefinitionActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActionComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.prefix = this.prefix == null ? null : this.prefix.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            dst.priority = this.priority == null ? null : this.priority.copy();
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.reason) {
                    dst.reason.add(codeableConcept2.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.goalId != null) {
                dst.goalId = new ArrayList<IdType>();
                for (IdType idType : this.goalId) {
                    dst.goalId.add(idType.copy());
                }
            }
            DataType dataType = dst.subject = this.subject == null ? null : this.subject.copy();
            if (this.trigger != null) {
                dst.trigger = new ArrayList<TriggerDefinition>();
                for (TriggerDefinition triggerDefinition : this.trigger) {
                    dst.trigger.add(triggerDefinition.copy());
                }
            }
            if (this.condition != null) {
                dst.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
                for (PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : this.condition) {
                    dst.condition.add(planDefinitionActionConditionComponent.copy());
                }
            }
            if (this.input != null) {
                dst.input = new ArrayList<PlanDefinitionActionInputComponent>();
                for (PlanDefinitionActionInputComponent planDefinitionActionInputComponent : this.input) {
                    dst.input.add(planDefinitionActionInputComponent.copy());
                }
            }
            if (this.output != null) {
                dst.output = new ArrayList<PlanDefinitionActionOutputComponent>();
                for (PlanDefinitionActionOutputComponent planDefinitionActionOutputComponent : this.output) {
                    dst.output.add(planDefinitionActionOutputComponent.copy());
                }
            }
            if (this.relatedAction != null) {
                dst.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
                for (PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : this.relatedAction) {
                    dst.relatedAction.add(planDefinitionActionRelatedActionComponent.copy());
                }
            }
            dst.timing = this.timing == null ? null : this.timing.copy();
            CodeableReference codeableReference = dst.location = this.location == null ? null : this.location.copy();
            if (this.participant != null) {
                dst.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
                for (PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : this.participant) {
                    dst.participant.add(planDefinitionActionParticipantComponent.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupingBehavior = this.groupingBehavior == null ? null : this.groupingBehavior.copy();
            dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            dst.requiredBehavior = this.requiredBehavior == null ? null : this.requiredBehavior.copy();
            dst.precheckBehavior = this.precheckBehavior == null ? null : this.precheckBehavior.copy();
            dst.cardinalityBehavior = this.cardinalityBehavior == null ? null : this.cardinalityBehavior.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            CanonicalType canonicalType = dst.transform = this.transform == null ? null : this.transform.copy();
            if (this.dynamicValue != null) {
                dst.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
                for (PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : this.dynamicValue) {
                    dst.dynamicValue.add(planDefinitionActionDynamicValueComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<PlanDefinitionActionComponent>();
                for (PlanDefinitionActionComponent planDefinitionActionComponent : this.action) {
                    dst.action.add(planDefinitionActionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionComponent)) {
                return false;
            }
            PlanDefinitionActionComponent o = (PlanDefinitionActionComponent)other_;
            return PlanDefinitionActionComponent.compareDeep(this.linkId, o.linkId, true) && PlanDefinitionActionComponent.compareDeep(this.prefix, o.prefix, true) && PlanDefinitionActionComponent.compareDeep(this.title, o.title, true) && PlanDefinitionActionComponent.compareDeep(this.description, o.description, true) && PlanDefinitionActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && PlanDefinitionActionComponent.compareDeep(this.priority, o.priority, true) && PlanDefinitionActionComponent.compareDeep(this.code, o.code, true) && PlanDefinitionActionComponent.compareDeep(this.reason, o.reason, true) && PlanDefinitionActionComponent.compareDeep(this.documentation, o.documentation, true) && PlanDefinitionActionComponent.compareDeep(this.goalId, o.goalId, true) && PlanDefinitionActionComponent.compareDeep(this.subject, o.subject, true) && PlanDefinitionActionComponent.compareDeep(this.trigger, o.trigger, true) && PlanDefinitionActionComponent.compareDeep(this.condition, o.condition, true) && PlanDefinitionActionComponent.compareDeep(this.input, o.input, true) && PlanDefinitionActionComponent.compareDeep(this.output, o.output, true) && PlanDefinitionActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && PlanDefinitionActionComponent.compareDeep(this.timing, o.timing, true) && PlanDefinitionActionComponent.compareDeep(this.location, o.location, true) && PlanDefinitionActionComponent.compareDeep(this.participant, o.participant, true) && PlanDefinitionActionComponent.compareDeep(this.type, o.type, true) && PlanDefinitionActionComponent.compareDeep(this.groupingBehavior, o.groupingBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.requiredBehavior, o.requiredBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.precheckBehavior, o.precheckBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.cardinalityBehavior, o.cardinalityBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.definition, o.definition, true) && PlanDefinitionActionComponent.compareDeep(this.transform, o.transform, true) && PlanDefinitionActionComponent.compareDeep(this.dynamicValue, o.dynamicValue, true) && PlanDefinitionActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionComponent)) {
                return false;
            }
            PlanDefinitionActionComponent o = (PlanDefinitionActionComponent)other_;
            return PlanDefinitionActionComponent.compareValues(this.linkId, o.linkId, true) && PlanDefinitionActionComponent.compareValues(this.prefix, o.prefix, true) && PlanDefinitionActionComponent.compareValues(this.title, o.title, true) && PlanDefinitionActionComponent.compareValues(this.description, o.description, true) && PlanDefinitionActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && PlanDefinitionActionComponent.compareValues(this.priority, o.priority, true) && PlanDefinitionActionComponent.compareValues(this.goalId, o.goalId, true) && PlanDefinitionActionComponent.compareValues(this.groupingBehavior, o.groupingBehavior, true) && PlanDefinitionActionComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true) && PlanDefinitionActionComponent.compareValues(this.requiredBehavior, o.requiredBehavior, true) && PlanDefinitionActionComponent.compareValues(this.precheckBehavior, o.precheckBehavior, true) && PlanDefinitionActionComponent.compareValues(this.cardinalityBehavior, o.cardinalityBehavior, true) && PlanDefinitionActionComponent.compareValues(this.transform, o.transform, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.linkId, this.prefix, this.title, this.description, this.textEquivalent, this.priority, this.code, this.reason, this.documentation, this.goalId, this.subject, this.trigger, this.condition, this.input, this.output, this.relatedAction, this.timing, this.location, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.definition, this.transform, this.dynamicValue, this.action});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action";
        }
    }

    @Block
    public static class PlanDefinitionActorOptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="careteam | device | group | healthcareservice | location | organization | patient | practitioner | practitionerrole | relatedperson", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<Enumerations.ActionParticipantType> type;
        @Child(name="typeReference", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can participate", formalDefinition="The type of participant in the action.")
        protected Reference typeReference;
        @Child(name="role", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/action-participant-role")
        protected CodeableConcept role;
        private static final long serialVersionUID = -1613816809L;

        public Enumeration<Enumerations.ActionParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActorOptionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanDefinitionActorOptionComponent setTypeElement(Enumeration<Enumerations.ActionParticipantType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ActionParticipantType getType() {
            return this.type == null ? null : (Enumerations.ActionParticipantType)((Object)this.type.getValue());
        }

        public PlanDefinitionActorOptionComponent setType(Enumerations.ActionParticipantType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.ActionParticipantType>(new Enumerations.ActionParticipantTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Reference getTypeReference() {
            if (this.typeReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActorOptionComponent.typeReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.typeReference = new Reference();
                }
            }
            return this.typeReference;
        }

        public boolean hasTypeReference() {
            return this.typeReference != null && !this.typeReference.isEmpty();
        }

        public PlanDefinitionActorOptionComponent setTypeReference(Reference value) {
            this.typeReference = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActorOptionComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public PlanDefinitionActorOptionComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PlanDefinition.SP_TYPE, "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(PlanDefinition.SP_TYPE, "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 2074825009: {
                    return new Property("typeReference", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson)", "The type of participant in the action.", 0, 1, this.typeReference);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 2074825009: {
                    Base[] baseArray;
                    if (this.typeReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.typeReference;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 2074825009: {
                    this.typeReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TYPE)) {
                value = new Enumerations.ActionParticipantTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("typeReference")) {
                this.typeReference = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 2074825009: {
                    return this.getTypeReference();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 2074825009: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.actor.option.type");
            }
            if (name.equals("typeReference")) {
                this.typeReference = new Reference();
                return this.typeReference;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActorOptionComponent copy() {
            PlanDefinitionActorOptionComponent dst = new PlanDefinitionActorOptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActorOptionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.typeReference = this.typeReference == null ? null : this.typeReference.copy();
            dst.role = this.role == null ? null : this.role.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActorOptionComponent)) {
                return false;
            }
            PlanDefinitionActorOptionComponent o = (PlanDefinitionActorOptionComponent)other_;
            return PlanDefinitionActorOptionComponent.compareDeep(this.type, o.type, true) && PlanDefinitionActorOptionComponent.compareDeep(this.typeReference, o.typeReference, true) && PlanDefinitionActorOptionComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActorOptionComponent)) {
                return false;
            }
            PlanDefinitionActorOptionComponent o = (PlanDefinitionActorOptionComponent)other_;
            return PlanDefinitionActorOptionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.typeReference, this.role});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.actor.option";
        }
    }

    @Block
    public static class PlanDefinitionActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="A descriptive label for the actor.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Describes the actor", formalDefinition="A description of how the actor fits into the overall actions of the plan definition.")
        protected MarkdownType description;
        @Child(name="option", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who or what can be this actor", formalDefinition="The characteristics of the candidates that could serve as the actor.")
        protected List<PlanDefinitionActorOptionComponent> option;
        private static final long serialVersionUID = -571302300L;

        public PlanDefinitionActorComponent() {
        }

        public PlanDefinitionActorComponent(PlanDefinitionActorOptionComponent option) {
            this.addOption(option);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActorComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public PlanDefinitionActorComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public PlanDefinitionActorComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActorComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionActorComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PlanDefinitionActorComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<PlanDefinitionActorOptionComponent> getOption() {
            if (this.option == null) {
                this.option = new ArrayList<PlanDefinitionActorOptionComponent>();
            }
            return this.option;
        }

        public PlanDefinitionActorComponent setOption(List<PlanDefinitionActorOptionComponent> theOption) {
            this.option = theOption;
            return this;
        }

        public boolean hasOption() {
            if (this.option == null) {
                return false;
            }
            for (PlanDefinitionActorOptionComponent item : this.option) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActorOptionComponent addOption() {
            PlanDefinitionActorOptionComponent t = new PlanDefinitionActorOptionComponent();
            if (this.option == null) {
                this.option = new ArrayList<PlanDefinitionActorOptionComponent>();
            }
            this.option.add(t);
            return t;
        }

        public PlanDefinitionActorComponent addOption(PlanDefinitionActorOptionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.option == null) {
                this.option = new ArrayList<PlanDefinitionActorOptionComponent>();
            }
            this.option.add(t);
            return this;
        }

        public PlanDefinitionActorOptionComponent getOptionFirstRep() {
            if (this.getOption().isEmpty()) {
                this.addOption();
            }
            return this.getOption().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PlanDefinition.SP_TITLE, "string", "A descriptive label for the actor.", 0, 1, this.title));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "markdown", "A description of how the actor fits into the overall actions of the plan definition.", 0, 1, this.description));
            children.add(new Property("option", "", "The characteristics of the candidates that could serve as the actor.", 0, Integer.MAX_VALUE, this.option));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property(PlanDefinition.SP_TITLE, "string", "A descriptive label for the actor.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "markdown", "A description of how the actor fits into the overall actions of the plan definition.", 0, 1, this.description);
                }
                case -1010136971: {
                    return new Property("option", "", "The characteristics of the candidates that could serve as the actor.", 0, Integer.MAX_VALUE, this.option);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1010136971: {
                    return this.option == null ? new Base[]{} : this.option.toArray(new Base[this.option.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1010136971: {
                    this.getOption().add((PlanDefinitionActorOptionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("option")) {
                this.getOption().add((PlanDefinitionActorOptionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1010136971: {
                    return this.addOption();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1010136971: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PlanDefinition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.actor.title");
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type PlanDefinition.actor.description");
            }
            if (name.equals("option")) {
                return this.addOption();
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActorComponent copy() {
            PlanDefinitionActorComponent dst = new PlanDefinitionActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionActorComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.option != null) {
                dst.option = new ArrayList<PlanDefinitionActorOptionComponent>();
                for (PlanDefinitionActorOptionComponent i : this.option) {
                    dst.option.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActorComponent)) {
                return false;
            }
            PlanDefinitionActorComponent o = (PlanDefinitionActorComponent)other_;
            return PlanDefinitionActorComponent.compareDeep(this.title, o.title, true) && PlanDefinitionActorComponent.compareDeep(this.description, o.description, true) && PlanDefinitionActorComponent.compareDeep(this.option, o.option, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActorComponent)) {
                return false;
            }
            PlanDefinitionActorComponent o = (PlanDefinitionActorComponent)other_;
            return PlanDefinitionActorComponent.compareValues(this.title, o.title, true) && PlanDefinitionActorComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.option});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.actor";
        }
    }

    @Block
    public static class PlanDefinitionGoalTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="measure", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The parameter whose value is to be tracked", formalDefinition="The parameter whose value is to be tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept measure;
        @Child(name="detail", type={Quantity.class, Range.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Ratio.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target value to be achieved", formalDefinition="The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.")
        protected DataType detail;
        @Child(name="due", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reach goal within", formalDefinition="Indicates the timeframe after the start of the goal in which the goal should be met.")
        protected Duration due;
        private static final long serialVersionUID = -1464475626L;

        public CodeableConcept getMeasure() {
            if (this.measure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalTargetComponent.measure");
                }
                if (Configuration.doAutoCreate()) {
                    this.measure = new CodeableConcept();
                }
            }
            return this.measure;
        }

        public boolean hasMeasure() {
            return this.measure != null && !this.measure.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setMeasure(CodeableConcept value) {
            this.measure = value;
            return this;
        }

        public DataType getDetail() {
            return this.detail;
        }

        public Quantity getDetailQuantity() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Quantity();
            }
            if (!(this.detail instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Quantity)this.detail;
        }

        public boolean hasDetailQuantity() {
            return this != null && this.detail instanceof Quantity;
        }

        public Range getDetailRange() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Range();
            }
            if (!(this.detail instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Range)this.detail;
        }

        public boolean hasDetailRange() {
            return this != null && this.detail instanceof Range;
        }

        public CodeableConcept getDetailCodeableConcept() throws FHIRException {
            if (this.detail == null) {
                this.detail = new CodeableConcept();
            }
            if (!(this.detail instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.detail;
        }

        public boolean hasDetailCodeableConcept() {
            return this != null && this.detail instanceof CodeableConcept;
        }

        public StringType getDetailStringType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new StringType();
            }
            if (!(this.detail instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (StringType)this.detail;
        }

        public boolean hasDetailStringType() {
            return this != null && this.detail instanceof StringType;
        }

        public BooleanType getDetailBooleanType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new BooleanType();
            }
            if (!(this.detail instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.detail;
        }

        public boolean hasDetailBooleanType() {
            return this != null && this.detail instanceof BooleanType;
        }

        public IntegerType getDetailIntegerType() throws FHIRException {
            if (this.detail == null) {
                this.detail = new IntegerType();
            }
            if (!(this.detail instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.detail;
        }

        public boolean hasDetailIntegerType() {
            return this != null && this.detail instanceof IntegerType;
        }

        public Ratio getDetailRatio() throws FHIRException {
            if (this.detail == null) {
                this.detail = new Ratio();
            }
            if (!(this.detail instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Ratio)this.detail;
        }

        public boolean hasDetailRatio() {
            return this != null && this.detail instanceof Ratio;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setDetail(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Ratio)) {
                throw new Error("Not the right type for PlanDefinition.goal.target.detail[x]: " + value.fhirType());
            }
            this.detail = value;
            return this;
        }

        public Duration getDue() {
            if (this.due == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalTargetComponent.due");
                }
                if (Configuration.doAutoCreate()) {
                    this.due = new Duration();
                }
            }
            return this.due;
        }

        public boolean hasDue() {
            return this.due != null && !this.due.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setDue(Duration value) {
            this.due = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("measure", "CodeableConcept", "The parameter whose value is to be tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure));
            children.add(new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail));
            children.add(new Property("due", "Duration", "Indicates the timeframe after the start of the goal in which the goal should be met.", 0, 1, this.due));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938321246: {
                    return new Property("measure", "CodeableConcept", "The parameter whose value is to be tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure);
                }
                case -1973084529: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -1335224239: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept|string|boolean|integer|Ratio", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -1313079300: {
                    return new Property("detail[x]", "Quantity", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -2062632084: {
                    return new Property("detail[x]", "Range", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -175586544: {
                    return new Property("detail[x]", "CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case 529212354: {
                    return new Property("detail[x]", "string", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case 1172184727: {
                    return new Property("detail[x]", "boolean", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -1229442131: {
                    return new Property("detail[x]", "integer", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -2062626246: {
                    return new Property("detail[x]", "Ratio", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%, or in the case of pharmaceutical quality - NMT 0.6%, Clear solution, etc. Either the high or low or both values of the range can be specified. When a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case 99828: {
                    return new Property("due", "Duration", "Indicates the timeframe after the start of the goal in which the goal should be met.", 0, 1, this.due);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    Base[] baseArray;
                    if (this.measure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.measure;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
                case 99828: {
                    Base[] baseArray;
                    if (this.due == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.due;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    this.measure = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = TypeConvertor.castToType(value);
                    return value;
                }
                case 99828: {
                    this.due = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("detail[x]")) {
                this.detail = TypeConvertor.castToType(value);
            } else if (name.equals("due")) {
                this.due = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return this.getMeasure();
                }
                case -1973084529: {
                    return this.getDetail();
                }
                case -1335224239: {
                    return this.getDetail();
                }
                case 99828: {
                    return this.getDue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Quantity", "Range", "CodeableConcept", "string", "boolean", "integer", "Ratio"};
                }
                case 99828: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = new CodeableConcept();
                return this.measure;
            }
            if (name.equals("detailQuantity")) {
                this.detail = new Quantity();
                return this.detail;
            }
            if (name.equals("detailRange")) {
                this.detail = new Range();
                return this.detail;
            }
            if (name.equals("detailCodeableConcept")) {
                this.detail = new CodeableConcept();
                return this.detail;
            }
            if (name.equals("detailString")) {
                this.detail = new StringType();
                return this.detail;
            }
            if (name.equals("detailBoolean")) {
                this.detail = new BooleanType();
                return this.detail;
            }
            if (name.equals("detailInteger")) {
                this.detail = new IntegerType();
                return this.detail;
            }
            if (name.equals("detailRatio")) {
                this.detail = new Ratio();
                return this.detail;
            }
            if (name.equals("due")) {
                this.due = new Duration();
                return this.due;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionGoalTargetComponent copy() {
            PlanDefinitionGoalTargetComponent dst = new PlanDefinitionGoalTargetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionGoalTargetComponent dst) {
            super.copyValues(dst);
            dst.measure = this.measure == null ? null : this.measure.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.due = this.due == null ? null : this.due.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalTargetComponent)) {
                return false;
            }
            PlanDefinitionGoalTargetComponent o = (PlanDefinitionGoalTargetComponent)other_;
            return PlanDefinitionGoalTargetComponent.compareDeep(this.measure, o.measure, true) && PlanDefinitionGoalTargetComponent.compareDeep(this.detail, o.detail, true) && PlanDefinitionGoalTargetComponent.compareDeep(this.due, o.due, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalTargetComponent)) {
                return false;
            }
            PlanDefinitionGoalTargetComponent o = (PlanDefinitionGoalTargetComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.measure, this.detail, this.due});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.goal.target";
        }
    }

    @Block
    public static class PlanDefinitionGoalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Treatment, dietary, behavioral", formalDefinition="Indicates a category the goal falls within.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-category")
        protected CodeableConcept category;
        @Child(name="description", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or text describing the goal", formalDefinition="Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected CodeableConcept description;
        @Child(name="priority", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="high-priority | medium-priority | low-priority", formalDefinition="Identifies the expected level of importance associated with reaching/sustaining the defined goal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-priority")
        protected CodeableConcept priority;
        @Child(name="start", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When goal pursuit begins", formalDefinition="The event after which the goal should begin being pursued.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-start-event")
        protected CodeableConcept start;
        @Child(name="addresses", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What does the goal address", formalDefinition="Identifies problems, conditions, issues, or concerns the goal is intended to address.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected List<CodeableConcept> addresses;
        @Child(name="documentation", type={RelatedArtifact.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the goal", formalDefinition="Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="target", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Target outcome for the goal", formalDefinition="Indicates what should be done and within what timeframe.")
        protected List<PlanDefinitionGoalTargetComponent> target;
        private static final long serialVersionUID = -795308926L;

        public PlanDefinitionGoalComponent() {
        }

        public PlanDefinitionGoalComponent(CodeableConcept description) {
            this.setDescription(description);
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public PlanDefinitionGoalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getDescription() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new CodeableConcept();
                }
            }
            return this.description;
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionGoalComponent setDescription(CodeableConcept value) {
            this.description = value;
            return this;
        }

        public CodeableConcept getPriority() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new CodeableConcept();
                }
            }
            return this.priority;
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public PlanDefinitionGoalComponent setPriority(CodeableConcept value) {
            this.priority = value;
            return this;
        }

        public CodeableConcept getStart() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new CodeableConcept();
                }
            }
            return this.start;
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public PlanDefinitionGoalComponent setStart(CodeableConcept value) {
            this.start = value;
            return this;
        }

        public List<CodeableConcept> getAddresses() {
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            return this.addresses;
        }

        public PlanDefinitionGoalComponent setAddresses(List<CodeableConcept> theAddresses) {
            this.addresses = theAddresses;
            return this;
        }

        public boolean hasAddresses() {
            if (this.addresses == null) {
                return false;
            }
            for (CodeableConcept item : this.addresses) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAddresses() {
            CodeableConcept t = new CodeableConcept();
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            this.addresses.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addAddresses(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            this.addresses.add(t);
            return this;
        }

        public CodeableConcept getAddressesFirstRep() {
            if (this.getAddresses().isEmpty()) {
                this.addAddresses();
            }
            return this.getAddresses().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public PlanDefinitionGoalComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<PlanDefinitionGoalTargetComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            return this.target;
        }

        public PlanDefinitionGoalComponent setTarget(List<PlanDefinitionGoalTargetComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (PlanDefinitionGoalTargetComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionGoalTargetComponent addTarget() {
            PlanDefinitionGoalTargetComponent t = new PlanDefinitionGoalTargetComponent();
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            this.target.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addTarget(PlanDefinitionGoalTargetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            this.target.add(t);
            return this;
        }

        public PlanDefinitionGoalTargetComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Indicates a category the goal falls within.", 0, 1, this.category));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description));
            children.add(new Property("priority", "CodeableConcept", "Identifies the expected level of importance associated with reaching/sustaining the defined goal.", 0, 1, this.priority));
            children.add(new Property("start", "CodeableConcept", "The event after which the goal should begin being pursued.", 0, 1, this.start));
            children.add(new Property("addresses", "CodeableConcept", "Identifies problems, conditions, issues, or concerns the goal is intended to address.", 0, Integer.MAX_VALUE, this.addresses));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("target", "", "Indicates what should be done and within what timeframe.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Indicates a category the goal falls within.", 0, 1, this.category);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description);
                }
                case -1165461084: {
                    return new Property("priority", "CodeableConcept", "Identifies the expected level of importance associated with reaching/sustaining the defined goal.", 0, 1, this.priority);
                }
                case 109757538: {
                    return new Property("start", "CodeableConcept", "The event after which the goal should begin being pursued.", 0, 1, this.start);
                }
                case 874544034: {
                    return new Property("addresses", "CodeableConcept", "Identifies problems, conditions, issues, or concerns the goal is intended to address.", 0, Integer.MAX_VALUE, this.addresses);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case -880905839: {
                    return new Property("target", "", "Indicates what should be done and within what timeframe.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.priority;
                    }
                    return baseArray;
                }
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.start;
                    }
                    return baseArray;
                }
                case 874544034: {
                    return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1165461084: {
                    this.priority = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 109757538: {
                    this.start = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 874544034: {
                    this.getAddresses().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((PlanDefinitionGoalTargetComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("priority")) {
                this.priority = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("start")) {
                this.start = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("addresses")) {
                this.getAddresses().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("target")) {
                this.getTarget().add((PlanDefinitionGoalTargetComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1724546052: {
                    return this.getDescription();
                }
                case -1165461084: {
                    return this.getPriority();
                }
                case 109757538: {
                    return this.getStart();
                }
                case 874544034: {
                    return this.addAddresses();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"CodeableConcept"};
                }
                case -1165461084: {
                    return new String[]{"CodeableConcept"};
                }
                case 109757538: {
                    return new String[]{"CodeableConcept"};
                }
                case 874544034: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = new CodeableConcept();
                return this.description;
            }
            if (name.equals("priority")) {
                this.priority = new CodeableConcept();
                return this.priority;
            }
            if (name.equals("start")) {
                this.start = new CodeableConcept();
                return this.start;
            }
            if (name.equals("addresses")) {
                return this.addAddresses();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionGoalComponent copy() {
            PlanDefinitionGoalComponent dst = new PlanDefinitionGoalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PlanDefinitionGoalComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.priority = this.priority == null ? null : this.priority.copy();
            CodeableConcept codeableConcept = dst.start = this.start == null ? null : this.start.copy();
            if (this.addresses != null) {
                dst.addresses = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.addresses) {
                    dst.addresses.add(codeableConcept2.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.target != null) {
                dst.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
                for (PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : this.target) {
                    dst.target.add(planDefinitionGoalTargetComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalComponent)) {
                return false;
            }
            PlanDefinitionGoalComponent o = (PlanDefinitionGoalComponent)other_;
            return PlanDefinitionGoalComponent.compareDeep(this.category, o.category, true) && PlanDefinitionGoalComponent.compareDeep(this.description, o.description, true) && PlanDefinitionGoalComponent.compareDeep(this.priority, o.priority, true) && PlanDefinitionGoalComponent.compareDeep(this.start, o.start, true) && PlanDefinitionGoalComponent.compareDeep(this.addresses, o.addresses, true) && PlanDefinitionGoalComponent.compareDeep(this.documentation, o.documentation, true) && PlanDefinitionGoalComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalComponent)) {
                return false;
            }
            PlanDefinitionGoalComponent o = (PlanDefinitionGoalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.description, this.priority, this.start, this.addresses, this.documentation, this.target});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.goal";
        }
    }
}

