/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Slot", profile="http://hl7.org/fhir/StructureDefinition/Slot")
public class Slot
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="External Ids for this item.")
    protected List<Identifier> identifier;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A broad categorization of the service that is to be performed during this appointment", formalDefinition="A broad categorization of the service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected List<CodeableConcept> serviceCategory;
    @Child(name="serviceType", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource", formalDefinition="The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableConcept> serviceType;
    @Child(name="specialty", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment", formalDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="appointmentType", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The style of appointment or patient that may be booked in the slot (not service type)", formalDefinition="The style of appointment or patient that may be booked in the slot (not service type).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0276")
    protected List<CodeableConcept> appointmentType;
    @Child(name="schedule", type={Schedule.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The schedule resource that this slot defines an interval of status information", formalDefinition="The schedule resource that this slot defines an interval of status information.")
    protected Reference schedule;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="busy | free | busy-unavailable | busy-tentative | entered-in-error", formalDefinition="busy | free | busy-unavailable | busy-tentative | entered-in-error.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/slotstatus")
    protected Enumeration<SlotStatus> status;
    @Child(name="start", type={InstantType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time that the slot is to begin", formalDefinition="Date/Time that the slot is to begin.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time that the slot is to conclude", formalDefinition="Date/Time that the slot is to conclude.")
    protected InstantType end;
    @Child(name="overbooked", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="This slot has already been overbooked, appointments are unlikely to be accepted for this time", formalDefinition="This slot has already been overbooked, appointments are unlikely to be accepted for this time.")
    protected BooleanType overbooked;
    @Child(name="comment", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the slot to describe any extended information. Such as custom constraints on the slot", formalDefinition="Comments on the slot to describe any extended information. Such as custom constraints on the slot.")
    protected StringType comment;
    private static final long serialVersionUID = 1338658975L;
    @SearchParamDefinition(name="appointment-type", path="Slot.appointmentType", description="The style of appointment or patient that may be booked in the slot (not service type)", type="token")
    public static final String SP_APPOINTMENT_TYPE = "appointment-type";
    public static final TokenClientParam APPOINTMENT_TYPE = new TokenClientParam("appointment-type");
    @SearchParamDefinition(name="identifier", path="Slot.identifier", description="A Slot Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="schedule", path="Slot.schedule", description="The Schedule Resource that we are seeking a slot within", type="reference", target={Schedule.class})
    public static final String SP_SCHEDULE = "schedule";
    public static final ReferenceClientParam SCHEDULE = new ReferenceClientParam("schedule");
    public static final Include INCLUDE_SCHEDULE = new Include("Slot:schedule").toLocked();
    @SearchParamDefinition(name="service-category", path="Slot.serviceCategory", description="A broad categorization of the service that is to be performed during this appointment", type="token")
    public static final String SP_SERVICE_CATEGORY = "service-category";
    public static final TokenClientParam SERVICE_CATEGORY = new TokenClientParam("service-category");
    @SearchParamDefinition(name="service-type", path="Slot.serviceType", description="The type of appointments that can be booked into the slot", type="token")
    public static final String SP_SERVICE_TYPE = "service-type";
    public static final TokenClientParam SERVICE_TYPE = new TokenClientParam("service-type");
    @SearchParamDefinition(name="specialty", path="Slot.specialty", description="The specialty of a practitioner that would be required to perform the service requested in this appointment", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="start", path="Slot.start", description="Appointment date/time.", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="status", path="Slot.status", description="The free/busy status of the appointment", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Slot() {
    }

    public Slot(Reference schedule, SlotStatus status, Date start, Date end) {
        this.setSchedule(schedule);
        this.setStatus(status);
        this.setStart(start);
        this.setEnd(end);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Slot setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Slot addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CodeableConcept> getServiceCategory() {
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        return this.serviceCategory;
    }

    public Slot setServiceCategory(List<CodeableConcept> theServiceCategory) {
        this.serviceCategory = theServiceCategory;
        return this;
    }

    public boolean hasServiceCategory() {
        if (this.serviceCategory == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceCategory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return t;
    }

    public Slot addServiceCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return this;
    }

    public CodeableConcept getServiceCategoryFirstRep() {
        if (this.getServiceCategory().isEmpty()) {
            this.addServiceCategory();
        }
        return this.getServiceCategory().get(0);
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public Slot setServiceType(List<CodeableConcept> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceType() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Slot addServiceType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableConcept getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public Slot setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public Slot addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<CodeableConcept> getAppointmentType() {
        if (this.appointmentType == null) {
            this.appointmentType = new ArrayList<CodeableConcept>();
        }
        return this.appointmentType;
    }

    public Slot setAppointmentType(List<CodeableConcept> theAppointmentType) {
        this.appointmentType = theAppointmentType;
        return this;
    }

    public boolean hasAppointmentType() {
        if (this.appointmentType == null) {
            return false;
        }
        for (CodeableConcept item : this.appointmentType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAppointmentType() {
        CodeableConcept t = new CodeableConcept();
        if (this.appointmentType == null) {
            this.appointmentType = new ArrayList<CodeableConcept>();
        }
        this.appointmentType.add(t);
        return t;
    }

    public Slot addAppointmentType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.appointmentType == null) {
            this.appointmentType = new ArrayList<CodeableConcept>();
        }
        this.appointmentType.add(t);
        return this;
    }

    public CodeableConcept getAppointmentTypeFirstRep() {
        if (this.getAppointmentType().isEmpty()) {
            this.addAppointmentType();
        }
        return this.getAppointmentType().get(0);
    }

    public Reference getSchedule() {
        if (this.schedule == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.schedule");
            }
            if (Configuration.doAutoCreate()) {
                this.schedule = new Reference();
            }
        }
        return this.schedule;
    }

    public boolean hasSchedule() {
        return this.schedule != null && !this.schedule.isEmpty();
    }

    public Slot setSchedule(Reference value) {
        this.schedule = value;
        return this;
    }

    public Enumeration<SlotStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SlotStatus>(new SlotStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Slot setStatusElement(Enumeration<SlotStatus> value) {
        this.status = value;
        return this;
    }

    public SlotStatus getStatus() {
        return this.status == null ? null : (SlotStatus)((Object)this.status.getValue());
    }

    public Slot setStatus(SlotStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<SlotStatus>(new SlotStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Slot setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Slot setStart(Date value) {
        if (this.start == null) {
            this.start = new InstantType();
        }
        this.start.setValue(value);
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Slot setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Slot setEnd(Date value) {
        if (this.end == null) {
            this.end = new InstantType();
        }
        this.end.setValue(value);
        return this;
    }

    public BooleanType getOverbookedElement() {
        if (this.overbooked == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.overbooked");
            }
            if (Configuration.doAutoCreate()) {
                this.overbooked = new BooleanType();
            }
        }
        return this.overbooked;
    }

    public boolean hasOverbookedElement() {
        return this.overbooked != null && !this.overbooked.isEmpty();
    }

    public boolean hasOverbooked() {
        return this.overbooked != null && !this.overbooked.isEmpty();
    }

    public Slot setOverbookedElement(BooleanType value) {
        this.overbooked = value;
        return this;
    }

    public boolean getOverbooked() {
        return this.overbooked == null || this.overbooked.isEmpty() ? false : (Boolean)this.overbooked.getValue();
    }

    public Slot setOverbooked(boolean value) {
        if (this.overbooked == null) {
            this.overbooked = new BooleanType();
        }
        this.overbooked.setValue((Object)value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Slot setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Slot setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory));
        children.add(new Property("serviceType", "CodeableConcept", "The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that may be booked in the slot (not service type).", 0, Integer.MAX_VALUE, this.appointmentType));
        children.add(new Property(SP_SCHEDULE, "Reference(Schedule)", "The schedule resource that this slot defines an interval of status information.", 0, 1, this.schedule));
        children.add(new Property(SP_STATUS, "code", "busy | free | busy-unavailable | busy-tentative | entered-in-error.", 0, 1, this.status));
        children.add(new Property(SP_START, "instant", "Date/Time that the slot is to begin.", 0, 1, this.start));
        children.add(new Property("end", "instant", "Date/Time that the slot is to conclude.", 0, 1, this.end));
        children.add(new Property("overbooked", "boolean", "This slot has already been overbooked, appointments are unlikely to be accepted for this time.", 0, 1, this.overbooked));
        children.add(new Property("comment", "string", "Comments on the slot to describe any extended information. Such as custom constraints on the slot.", 0, 1, this.comment));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1281188563: {
                return new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableConcept", "The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case -1596426375: {
                return new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that may be booked in the slot (not service type).", 0, Integer.MAX_VALUE, this.appointmentType);
            }
            case -697920873: {
                return new Property(SP_SCHEDULE, "Reference(Schedule)", "The schedule resource that this slot defines an interval of status information.", 0, 1, this.schedule);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "busy | free | busy-unavailable | busy-tentative | entered-in-error.", 0, 1, this.status);
            }
            case 109757538: {
                return new Property(SP_START, "instant", "Date/Time that the slot is to begin.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "instant", "Date/Time that the slot is to conclude.", 0, 1, this.end);
            }
            case 2068545308: {
                return new Property("overbooked", "boolean", "This slot has already been overbooked, appointments are unlikely to be accepted for this time.", 0, 1, this.overbooked);
            }
            case 950398559: {
                return new Property("comment", "string", "Comments on the slot to describe any extended information. Such as custom constraints on the slot.", 0, 1, this.comment);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1281188563: {
                return this.serviceCategory == null ? new Base[]{} : this.serviceCategory.toArray(new Base[this.serviceCategory.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case -1596426375: {
                return this.appointmentType == null ? new Base[]{} : this.appointmentType.toArray(new Base[this.appointmentType.size()]);
            }
            case -697920873: {
                Base[] baseArray;
                if (this.schedule == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.schedule;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.end;
                }
                return baseArray;
            }
            case 2068545308: {
                Base[] baseArray;
                if (this.overbooked == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.overbooked;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 1281188563: {
                this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1596426375: {
                this.getAppointmentType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -697920873: {
                this.schedule = TypeConvertor.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new SlotStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToInstant(value);
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case 2068545308: {
                this.overbooked = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("serviceCategory")) {
            this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("appointmentType")) {
            this.getAppointmentType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SCHEDULE)) {
            this.schedule = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            value = new SlotStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_START)) {
            this.start = TypeConvertor.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("overbooked")) {
            this.overbooked = TypeConvertor.castToBoolean(value);
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1281188563: {
                return this.addServiceCategory();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case -1596426375: {
                return this.addAppointmentType();
            }
            case -697920873: {
                return this.getSchedule();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
            case 2068545308: {
                return this.getOverbookedElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1281188563: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case -1596426375: {
                return new String[]{"CodeableConcept"};
            }
            case -697920873: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 109757538: {
                return new String[]{"instant"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case 2068545308: {
                return new String[]{"boolean"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("serviceCategory")) {
            return this.addServiceCategory();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals("appointmentType")) {
            return this.addAppointmentType();
        }
        if (name.equals(SP_SCHEDULE)) {
            this.schedule = new Reference();
            return this.schedule;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.status");
        }
        if (name.equals(SP_START)) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.end");
        }
        if (name.equals("overbooked")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.overbooked");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Slot";
    }

    @Override
    public Slot copy() {
        Slot dst = new Slot();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Slot dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.serviceCategory != null) {
            dst.serviceCategory = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceCategory) {
                dst.serviceCategory.add(codeableConcept.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceType) {
                dst.serviceType.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.appointmentType != null) {
            dst.appointmentType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.appointmentType) {
                dst.appointmentType.add(codeableConcept.copy());
            }
        }
        dst.schedule = this.schedule == null ? null : this.schedule.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        dst.overbooked = this.overbooked == null ? null : this.overbooked.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
    }

    protected Slot typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Slot)) {
            return false;
        }
        Slot o = (Slot)other_;
        return Slot.compareDeep(this.identifier, o.identifier, true) && Slot.compareDeep(this.serviceCategory, o.serviceCategory, true) && Slot.compareDeep(this.serviceType, o.serviceType, true) && Slot.compareDeep(this.specialty, o.specialty, true) && Slot.compareDeep(this.appointmentType, o.appointmentType, true) && Slot.compareDeep(this.schedule, o.schedule, true) && Slot.compareDeep(this.status, o.status, true) && Slot.compareDeep(this.start, o.start, true) && Slot.compareDeep(this.end, o.end, true) && Slot.compareDeep(this.overbooked, o.overbooked, true) && Slot.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Slot)) {
            return false;
        }
        Slot o = (Slot)other_;
        return Slot.compareValues(this.status, o.status, true) && Slot.compareValues(this.start, o.start, true) && Slot.compareValues(this.end, o.end, true) && Slot.compareValues(this.overbooked, o.overbooked, true) && Slot.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.serviceCategory, this.serviceType, this.specialty, this.appointmentType, this.schedule, this.status, this.start, this.end, this.overbooked, this.comment});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Slot;
    }

    public static class SlotStatusEnumFactory
    implements EnumFactory<SlotStatus> {
        @Override
        public SlotStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return SlotStatus.BUSY;
            }
            if ("free".equals(codeString)) {
                return SlotStatus.FREE;
            }
            if ("busy-unavailable".equals(codeString)) {
                return SlotStatus.BUSYUNAVAILABLE;
            }
            if ("busy-tentative".equals(codeString)) {
                return SlotStatus.BUSYTENTATIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return SlotStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SlotStatus code '" + codeString + "'");
        }

        public Enumeration<SlotStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SlotStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSY);
            }
            if ("free".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.FREE);
            }
            if ("busy-unavailable".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSYUNAVAILABLE);
            }
            if ("busy-tentative".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSYTENTATIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown SlotStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SlotStatus code) {
            if (code == SlotStatus.BUSY) {
                return "busy";
            }
            if (code == SlotStatus.FREE) {
                return "free";
            }
            if (code == SlotStatus.BUSYUNAVAILABLE) {
                return "busy-unavailable";
            }
            if (code == SlotStatus.BUSYTENTATIVE) {
                return "busy-tentative";
            }
            if (code == SlotStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(SlotStatus code) {
            return code.getSystem();
        }
    }

    public static enum SlotStatus {
        BUSY,
        FREE,
        BUSYUNAVAILABLE,
        BUSYTENTATIVE,
        ENTEREDINERROR,
        NULL;


        public static SlotStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return BUSY;
            }
            if ("free".equals(codeString)) {
                return FREE;
            }
            if ("busy-unavailable".equals(codeString)) {
                return BUSYUNAVAILABLE;
            }
            if ("busy-tentative".equals(codeString)) {
                return BUSYTENTATIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SlotStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BUSY: {
                    return "busy";
                }
                case FREE: {
                    return "free";
                }
                case BUSYUNAVAILABLE: {
                    return "busy-unavailable";
                }
                case BUSYTENTATIVE: {
                    return "busy-tentative";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BUSY: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case FREE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case BUSYUNAVAILABLE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case BUSYTENTATIVE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/slotstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BUSY: {
                    return "Indicates that the time interval is busy because one  or more events have been scheduled for that interval.";
                }
                case FREE: {
                    return "Indicates that the time interval is free for scheduling.";
                }
                case BUSYUNAVAILABLE: {
                    return "Indicates that the time interval is busy and that the interval cannot be scheduled.";
                }
                case BUSYTENTATIVE: {
                    return "Indicates that the time interval is busy because one or more events have been tentatively scheduled for that interval.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BUSY: {
                    return "Busy";
                }
                case FREE: {
                    return "Free";
                }
                case BUSYUNAVAILABLE: {
                    return "Busy (Unavailable)";
                }
                case BUSYTENTATIVE: {
                    return "Busy (Tentative)";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
            }
            return "?";
        }
    }
}

