/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ConceptMap2;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="DocumentReference", profile="http://hl7.org/fhir/StructureDefinition/DocumentReference")
public class DocumentReference
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the document", formalDefinition="Other identifiers associated with the document, including version independent identifiers.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ServiceRequest.class, CarePlan.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedure that caused this media to be created", formalDefinition="A procedure that is fulfilled in whole or in part by the creation of this media.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="current | superseded | entered-in-error", formalDefinition="The status of this document reference.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-reference-status")
    protected Enumeration<Enumerations.DocumentReferenceStatus> status;
    @Child(name="docStatus", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="preliminary | final | amended | entered-in-error | deprecated", formalDefinition="The status of the underlying document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    protected Enumeration<Enumerations.CompositionStatus> docStatus;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of document (LOINC if possible)", formalDefinition="Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-doc-typecodes")
    protected CodeableConcept type;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of document", formalDefinition="A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-classcodes")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class, Device.class, PractitionerRole.class, Specimen.class, Organization.class, Location.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is the subject of the document", formalDefinition="Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Context of the document  content", formalDefinition="Describes the clinical encounter or type of care that the document content is associated with.")
    protected List<Reference> encounter;
    @Child(name="event", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Main clinical acts documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
    protected List<CodeableConcept> event;
    @Child(name="facilityType", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Kind of facility where patient was seen", formalDefinition="The kind of facility where the patient was seen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-facilitycodes")
    protected CodeableConcept facilityType;
    @Child(name="practiceSetting", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional details about where the content was created (e.g. clinical specialty)", formalDefinition="This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected CodeableConcept practiceSetting;
    @Child(name="period", type={Period.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time of service that is being documented", formalDefinition="The time period over which the service that is described by the document was provided.")
    protected Period period;
    @Child(name="date", type={InstantType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this document reference was created", formalDefinition="When the document reference was created.")
    protected InstantType date;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Organization.class, Device.class, Patient.class, RelatedPerson.class, CareTeam.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the document", formalDefinition="Identifies who is responsible for adding the information to the document.")
    protected List<Reference> author;
    @Child(name="attester", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attests to accuracy of composition", formalDefinition="A participant who has attested to the accuracy of the composition/document.")
    protected List<DocumentReferenceAttesterComponent> attester;
    @Child(name="custodian", type={Organization.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization which maintains the document", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.")
    protected Reference custodian;
    @Child(name="relatesTo", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Relationships to other documents", formalDefinition="Relationships that this document has with other document references that already exist.")
    protected List<DocumentReferenceRelatesToComponent> relatesTo;
    @Child(name="description", type={MarkdownType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable description", formalDefinition="Human-readable description of the source document.")
    protected MarkdownType description;
    @Child(name="securityLabel", type={CodeableConcept.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document security-tags", formalDefinition="A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    protected List<CodeableConcept> securityLabel;
    @Child(name="content", type={}, order=19, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document referenced", formalDefinition="The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.")
    protected List<DocumentReferenceContentComponent> content;
    @Child(name="sourcePatientInfo", type={Patient.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient demographics from source", formalDefinition="The Patient Information as known when the document was published. May be a reference to a version specific, or contained.")
    protected Reference sourcePatientInfo;
    @Child(name="related", type={Reference.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Related identifiers or resources", formalDefinition="Related identifiers or resources associated with the DocumentReference.")
    protected List<Reference> related;
    private static final long serialVersionUID = -1169558405L;
    @SearchParamDefinition(name="attester", path="DocumentReference.attester.party", description="Who attested the composition", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    public static final Include INCLUDE_ATTESTER = new Include("DocumentReference:attester").toLocked();
    @SearchParamDefinition(name="author", path="DocumentReference.author", description="Who and/or what authored the document", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentReference:author").toLocked();
    @SearchParamDefinition(name="based-on", path="DocumentReference.basedOn", description="Procedure that caused this media to be created", type="reference", target={CarePlan.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DocumentReference:based-on").toLocked();
    @SearchParamDefinition(name="category", path="DocumentReference.category", description="Categorization of document", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="contenttype", path="DocumentReference.content.attachment.contentType", description="Mime type of the content, with charset etc.", type="token")
    public static final String SP_CONTENTTYPE = "contenttype";
    public static final TokenClientParam CONTENTTYPE = new TokenClientParam("contenttype");
    @SearchParamDefinition(name="creation", path="DocumentReference.content.attachment.creation", description="Date attachment was first created", type="date")
    public static final String SP_CREATION = "creation";
    public static final DateClientParam CREATION = new DateClientParam("creation");
    @SearchParamDefinition(name="custodian", path="DocumentReference.custodian", description="Organization which maintains the document", type="reference", target={Organization.class})
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    public static final Include INCLUDE_CUSTODIAN = new Include("DocumentReference:custodian").toLocked();
    @SearchParamDefinition(name="date", path="DocumentReference.date", description="When this document reference was created", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="DocumentReference.description", description="Human-readable description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="doc-status", path="DocumentReference.docStatus", description="preliminary | final | amended | entered-in-error", type="token")
    public static final String SP_DOC_STATUS = "doc-status";
    public static final TokenClientParam DOC_STATUS = new TokenClientParam("doc-status");
    @SearchParamDefinition(name="event", path="DocumentReference.event", description="Main clinical acts documented", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="facility", path="DocumentReference.facilityType", description="Kind of facility where patient was seen", type="token")
    public static final String SP_FACILITY = "facility";
    public static final TokenClientParam FACILITY = new TokenClientParam("facility");
    @SearchParamDefinition(name="format", path="DocumentReference.content.format", description="Format/content rules for the document", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="language", path="DocumentReference.content.attachment.language", description="Human language of the content (BCP-47)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="location", path="DocumentReference.content.attachment.url", description="Uri where the data can be found", type="uri")
    public static final String SP_LOCATION = "location";
    public static final UriClientParam LOCATION = new UriClientParam("location");
    @SearchParamDefinition(name="period", path="DocumentReference.period", description="Time of service that is being documented", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="related", path="DocumentReference.related", description="Related identifiers or resources", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_RELATED = "related";
    public static final ReferenceClientParam RELATED = new ReferenceClientParam("related");
    public static final Include INCLUDE_RELATED = new Include("DocumentReference:related").toLocked();
    @SearchParamDefinition(name="relatesto", path="DocumentReference.relatesTo.target", description="Target of the relationship", type="reference", target={DocumentReference.class})
    public static final String SP_RELATESTO = "relatesto";
    public static final ReferenceClientParam RELATESTO = new ReferenceClientParam("relatesto");
    public static final Include INCLUDE_RELATESTO = new Include("DocumentReference:relatesto").toLocked();
    @SearchParamDefinition(name="relation", path="DocumentReference.relatesTo.code", description="replaces | transforms | signs | appends", type="token")
    public static final String SP_RELATION = "relation";
    public static final TokenClientParam RELATION = new TokenClientParam("relation");
    @SearchParamDefinition(name="relationship", path="DocumentReference.relatesTo", description="Combination of relation and relatesTo", type="composite", compositeOf={"relatesto", "relation"})
    public static final String SP_RELATIONSHIP = "relationship";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATIONSHIP = new CompositeClientParam("relationship");
    @SearchParamDefinition(name="security-label", path="DocumentReference.securityLabel", description="Document security-tags", type="token")
    public static final String SP_SECURITY_LABEL = "security-label";
    public static final TokenClientParam SECURITY_LABEL = new TokenClientParam("security-label");
    @SearchParamDefinition(name="setting", path="DocumentReference.practiceSetting", description="Additional details about where the content was created (e.g. clinical specialty)", type="token")
    public static final String SP_SETTING = "setting";
    public static final TokenClientParam SETTING = new TokenClientParam("setting");
    @SearchParamDefinition(name="status", path="DocumentReference.status", description="current | superseded | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DocumentReference.subject", description="Who/what is the subject of the document", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, Specimen.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentReference:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DocumentReference:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DocumentReference:patient").toLocked();
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type | Composition.type | DocumentManifest.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [DocumentManifest](documentmanifest.html): Kind of document set\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public DocumentReference() {
    }

    public DocumentReference(Enumerations.DocumentReferenceStatus status, DocumentReferenceContentComponent content) {
        this.setStatus(status);
        this.addContent(content);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DocumentReference setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DocumentReference addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DocumentReference setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DocumentReference addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<Enumerations.DocumentReferenceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DocumentReference setStatusElement(Enumeration<Enumerations.DocumentReferenceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.DocumentReferenceStatus getStatus() {
        return this.status == null ? null : (Enumerations.DocumentReferenceStatus)((Object)this.status.getValue());
    }

    public DocumentReference setStatus(Enumerations.DocumentReferenceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<Enumerations.CompositionStatus> getDocStatusElement() {
        if (this.docStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.docStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.docStatus = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
            }
        }
        return this.docStatus;
    }

    public boolean hasDocStatusElement() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public boolean hasDocStatus() {
        return this.docStatus != null && !this.docStatus.isEmpty();
    }

    public DocumentReference setDocStatusElement(Enumeration<Enumerations.CompositionStatus> value) {
        this.docStatus = value;
        return this;
    }

    public Enumerations.CompositionStatus getDocStatus() {
        return this.docStatus == null ? null : (Enumerations.CompositionStatus)((Object)this.docStatus.getValue());
    }

    public DocumentReference setDocStatus(Enumerations.CompositionStatus value) {
        if (value == null) {
            this.docStatus = null;
        } else {
            if (this.docStatus == null) {
                this.docStatus = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
            }
            this.docStatus.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DocumentReference setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DocumentReference setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DocumentReference addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DocumentReference setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<Reference> getEncounter() {
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        return this.encounter;
    }

    public DocumentReference setEncounter(List<Reference> theEncounter) {
        this.encounter = theEncounter;
        return this;
    }

    public boolean hasEncounter() {
        if (this.encounter == null) {
            return false;
        }
        for (Reference item : this.encounter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEncounter() {
        Reference t = new Reference();
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        this.encounter.add(t);
        return t;
    }

    public DocumentReference addEncounter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        this.encounter.add(t);
        return this;
    }

    public Reference getEncounterFirstRep() {
        if (this.getEncounter().isEmpty()) {
            this.addEncounter();
        }
        return this.getEncounter().get(0);
    }

    public List<CodeableConcept> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CodeableConcept>();
        }
        return this.event;
    }

    public DocumentReference setEvent(List<CodeableConcept> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (CodeableConcept item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addEvent() {
        CodeableConcept t = new CodeableConcept();
        if (this.event == null) {
            this.event = new ArrayList<CodeableConcept>();
        }
        this.event.add(t);
        return t;
    }

    public DocumentReference addEvent(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<CodeableConcept>();
        }
        this.event.add(t);
        return this;
    }

    public CodeableConcept getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public CodeableConcept getFacilityType() {
        if (this.facilityType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.facilityType");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityType = new CodeableConcept();
            }
        }
        return this.facilityType;
    }

    public boolean hasFacilityType() {
        return this.facilityType != null && !this.facilityType.isEmpty();
    }

    public DocumentReference setFacilityType(CodeableConcept value) {
        this.facilityType = value;
        return this;
    }

    public CodeableConcept getPracticeSetting() {
        if (this.practiceSetting == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.practiceSetting");
            }
            if (Configuration.doAutoCreate()) {
                this.practiceSetting = new CodeableConcept();
            }
        }
        return this.practiceSetting;
    }

    public boolean hasPracticeSetting() {
        return this.practiceSetting != null && !this.practiceSetting.isEmpty();
    }

    public DocumentReference setPracticeSetting(CodeableConcept value) {
        this.practiceSetting = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public DocumentReference setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public InstantType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new InstantType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public DocumentReference setDateElement(InstantType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public DocumentReference setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new InstantType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public DocumentReference setAuthor(List<Reference> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public DocumentReference addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public Reference getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<DocumentReferenceAttesterComponent> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        return this.attester;
    }

    public DocumentReference setAttester(List<DocumentReferenceAttesterComponent> theAttester) {
        this.attester = theAttester;
        return this;
    }

    public boolean hasAttester() {
        if (this.attester == null) {
            return false;
        }
        for (DocumentReferenceAttesterComponent item : this.attester) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceAttesterComponent addAttester() {
        DocumentReferenceAttesterComponent t = new DocumentReferenceAttesterComponent();
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        this.attester.add(t);
        return t;
    }

    public DocumentReference addAttester(DocumentReferenceAttesterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attester == null) {
            this.attester = new ArrayList<DocumentReferenceAttesterComponent>();
        }
        this.attester.add(t);
        return this;
    }

    public DocumentReferenceAttesterComponent getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public DocumentReference setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public List<DocumentReferenceRelatesToComponent> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        return this.relatesTo;
    }

    public DocumentReference setRelatesTo(List<DocumentReferenceRelatesToComponent> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (DocumentReferenceRelatesToComponent item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceRelatesToComponent addRelatesTo() {
        DocumentReferenceRelatesToComponent t = new DocumentReferenceRelatesToComponent();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public DocumentReference addRelatesTo(DocumentReferenceRelatesToComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public DocumentReferenceRelatesToComponent getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public DocumentReference setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public DocumentReference setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        return this.securityLabel;
    }

    public DocumentReference setSecurityLabel(List<CodeableConcept> theSecurityLabel) {
        this.securityLabel = theSecurityLabel;
        return this;
    }

    public boolean hasSecurityLabel() {
        if (this.securityLabel == null) {
            return false;
        }
        for (CodeableConcept item : this.securityLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSecurityLabel() {
        CodeableConcept t = new CodeableConcept();
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return t;
    }

    public DocumentReference addSecurityLabel(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        this.securityLabel.add(t);
        return this;
    }

    public CodeableConcept getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<DocumentReferenceContentComponent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        return this.content;
    }

    public DocumentReference setContent(List<DocumentReferenceContentComponent> theContent) {
        this.content = theContent;
        return this;
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        for (DocumentReferenceContentComponent item : this.content) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DocumentReferenceContentComponent addContent() {
        DocumentReferenceContentComponent t = new DocumentReferenceContentComponent();
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return t;
    }

    public DocumentReference addContent(DocumentReferenceContentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContentComponent>();
        }
        this.content.add(t);
        return this;
    }

    public DocumentReferenceContentComponent getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            this.addContent();
        }
        return this.getContent().get(0);
    }

    public Reference getSourcePatientInfo() {
        if (this.sourcePatientInfo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DocumentReference.sourcePatientInfo");
            }
            if (Configuration.doAutoCreate()) {
                this.sourcePatientInfo = new Reference();
            }
        }
        return this.sourcePatientInfo;
    }

    public boolean hasSourcePatientInfo() {
        return this.sourcePatientInfo != null && !this.sourcePatientInfo.isEmpty();
    }

    public DocumentReference setSourcePatientInfo(Reference value) {
        this.sourcePatientInfo = value;
        return this;
    }

    public List<Reference> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<Reference>();
        }
        return this.related;
    }

    public DocumentReference setRelated(List<Reference> theRelated) {
        this.related = theRelated;
        return this;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (Reference item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelated() {
        Reference t = new Reference();
        if (this.related == null) {
            this.related = new ArrayList<Reference>();
        }
        this.related.add(t);
        return t;
    }

    public DocumentReference addRelated(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<Reference>();
        }
        this.related.add(t);
        return this;
    }

    public Reference getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            this.addRelated();
        }
        return this.getRelated().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Other identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ServiceRequest|CarePlan)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status));
        children.add(new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device|PractitionerRole|Specimen|Organization|Location)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, Integer.MAX_VALUE, this.encounter));
        children.add(new Property(SP_EVENT, "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType));
        children.add(new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting));
        children.add(new Property(SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period));
        children.add(new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson|CareTeam)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester));
        children.add(new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian));
        children.add(new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property(SP_DESCRIPTION, "markdown", "Human-readable description of the source document.", 0, 1, this.description));
        children.add(new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.", 0, Integer.MAX_VALUE, this.securityLabel));
        children.add(new Property("content", "", "The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.", 0, Integer.MAX_VALUE, this.content));
        children.add(new Property("sourcePatientInfo", "Reference(Patient)", "The Patient Information as known when the document was published. May be a reference to a version specific, or contained.", 0, 1, this.sourcePatientInfo));
        children.add(new Property(SP_RELATED, "Reference(Any)", "Related identifiers or resources associated with the DocumentReference.", 0, Integer.MAX_VALUE, this.related));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Other identifiers associated with the document, including version independent identifiers.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest|CarePlan)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this document reference.", 0, 1, this.status);
            }
            case -23496886: {
                return new Property("docStatus", "code", "The status of the underlying document.", 0, 1, this.docStatus);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device|PractitionerRole|Specimen|Organization|Location)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care that the document content is associated with.", 0, Integer.MAX_VALUE, this.encounter);
            }
            case 96891546: {
                return new Property(SP_EVENT, "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the type Code, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.event);
            }
            case 370698365: {
                return new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, 1, this.facilityType);
            }
            case 331373717: {
                return new Property("practiceSetting", "CodeableConcept", "This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty.", 0, 1, this.practiceSetting);
            }
            case -991726143: {
                return new Property(SP_PERIOD, "Period", "The time period over which the service that is described by the document was provided.", 0, 1, this.period);
            }
            case 3076014: {
                return new Property(SP_DATE, "instant", "When the document reference was created.", 0, 1, this.date);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Organization|Device|Patient|RelatedPerson|CareTeam)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author);
            }
            case 542920370: {
                return new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester);
            }
            case 1611297262: {
                return new Property(SP_CUSTODIAN, "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, 1, this.custodian);
            }
            case -7765931: {
                return new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "Human-readable description of the source document.", 0, 1, this.description);
            }
            case -722296940: {
                return new Property("securityLabel", "CodeableConcept", "A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to.", 0, Integer.MAX_VALUE, this.securityLabel);
            }
            case 951530617: {
                return new Property("content", "", "The document and format referenced.  If there are multiple content element repetitions, these must all represent the same document in different format, or attachment metadata.", 0, Integer.MAX_VALUE, this.content);
            }
            case 2031381048: {
                return new Property("sourcePatientInfo", "Reference(Patient)", "The Patient Information as known when the document was published. May be a reference to a version specific, or contained.", 0, 1, this.sourcePatientInfo);
            }
            case 1090493483: {
                return new Property(SP_RELATED, "Reference(Any)", "Related identifiers or resources associated with the DocumentReference.", 0, Integer.MAX_VALUE, this.related);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -23496886: {
                Base[] baseArray;
                if (this.docStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.docStatus;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                return this.encounter == null ? new Base[]{} : this.encounter.toArray(new Base[this.encounter.size()]);
            }
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case 370698365: {
                Base[] baseArray;
                if (this.facilityType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.facilityType;
                }
                return baseArray;
            }
            case 331373717: {
                Base[] baseArray;
                if (this.practiceSetting == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.practiceSetting;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case 542920370: {
                return this.attester == null ? new Base[]{} : this.attester.toArray(new Base[this.attester.size()]);
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.custodian;
                }
                return baseArray;
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -722296940: {
                return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
            }
            case 951530617: {
                return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
            }
            case 2031381048: {
                Base[] baseArray;
                if (this.sourcePatientInfo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.sourcePatientInfo;
                }
                return baseArray;
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -23496886: {
                value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.docStatus = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.getEncounter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 96891546: {
                this.getEvent().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 370698365: {
                this.facilityType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 331373717: {
                this.practiceSetting = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToInstant(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 542920370: {
                this.getAttester().add((DocumentReferenceAttesterComponent)((Object)value));
                return value;
            }
            case 1611297262: {
                this.custodian = TypeConvertor.castToReference(value);
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -722296940: {
                this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 951530617: {
                this.getContent().add((DocumentReferenceContentComponent)((Object)value));
                return value;
            }
            case 2031381048: {
                this.sourcePatientInfo = TypeConvertor.castToReference(value);
                return value;
            }
            case 1090493483: {
                this.getRelated().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.DocumentReferenceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("docStatus")) {
            value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.docStatus = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.getEncounter().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_EVENT)) {
            this.getEvent().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("facilityType")) {
            this.facilityType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("practiceSetting")) {
            this.practiceSetting = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PERIOD)) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().add((DocumentReferenceAttesterComponent)((Object)value));
        } else if (name.equals(SP_CUSTODIAN)) {
            this.custodian = TypeConvertor.castToReference(value);
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add((DocumentReferenceRelatesToComponent)((Object)value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("content")) {
            this.getContent().add((DocumentReferenceContentComponent)((Object)value));
        } else if (name.equals("sourcePatientInfo")) {
            this.sourcePatientInfo = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RELATED)) {
            this.getRelated().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -23496886: {
                return this.getDocStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.addEncounter();
            }
            case 96891546: {
                return this.addEvent();
            }
            case 370698365: {
                return this.getFacilityType();
            }
            case 331373717: {
                return this.getPracticeSetting();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case 542920370: {
                return this.addAttester();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -722296940: {
                return this.addSecurityLabel();
            }
            case 951530617: {
                return this.addContent();
            }
            case 2031381048: {
                return this.getSourcePatientInfo();
            }
            case 1090493483: {
                return this.addRelated();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -23496886: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 96891546: {
                return new String[]{"CodeableConcept"};
            }
            case 370698365: {
                return new String[]{"CodeableConcept"};
            }
            case 331373717: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 3076014: {
                return new String[]{"instant"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 542920370: {
                return new String[0];
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -7765931: {
                return new String[0];
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -722296940: {
                return new String[]{"CodeableConcept"};
            }
            case 951530617: {
                return new String[0];
            }
            case 2031381048: {
                return new String[]{"Reference"};
            }
            case 1090493483: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.status");
        }
        if (name.equals("docStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.docStatus");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            return this.addEncounter();
        }
        if (name.equals(SP_EVENT)) {
            return this.addEvent();
        }
        if (name.equals("facilityType")) {
            this.facilityType = new CodeableConcept();
            return this.facilityType;
        }
        if (name.equals("practiceSetting")) {
            this.practiceSetting = new CodeableConcept();
            return this.practiceSetting;
        }
        if (name.equals(SP_PERIOD)) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.date");
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals(SP_ATTESTER)) {
            return this.addAttester();
        }
        if (name.equals(SP_CUSTODIAN)) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.description");
        }
        if (name.equals("securityLabel")) {
            return this.addSecurityLabel();
        }
        if (name.equals("content")) {
            return this.addContent();
        }
        if (name.equals("sourcePatientInfo")) {
            this.sourcePatientInfo = new Reference();
            return this.sourcePatientInfo;
        }
        if (name.equals(SP_RELATED)) {
            return this.addRelated();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DocumentReference";
    }

    @Override
    public DocumentReference copy() {
        DocumentReference dst = new DocumentReference();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DocumentReference dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.docStatus = this.docStatus == null ? null : this.docStatus.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.encounter != null) {
            dst.encounter = new ArrayList<Reference>();
            for (Reference reference2 : this.encounter) {
                dst.encounter.add(reference2.copy());
            }
        }
        if (this.event != null) {
            dst.event = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.event) {
                dst.event.add(codeableConcept3.copy());
            }
        }
        dst.facilityType = this.facilityType == null ? null : this.facilityType.copy();
        dst.practiceSetting = this.practiceSetting == null ? null : this.practiceSetting.copy();
        dst.period = this.period == null ? null : this.period.copy();
        InstantType instantType = dst.date = this.date == null ? null : this.date.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference3 : this.author) {
                dst.author.add(reference3.copy());
            }
        }
        if (this.attester != null) {
            dst.attester = new ArrayList<DocumentReferenceAttesterComponent>();
            for (DocumentReferenceAttesterComponent documentReferenceAttesterComponent : this.attester) {
                dst.attester.add(documentReferenceAttesterComponent.copy());
            }
        }
        Reference reference4 = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
            for (DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : this.relatesTo) {
                dst.relatesTo.add(documentReferenceRelatesToComponent.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.securityLabel != null) {
            dst.securityLabel = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.securityLabel) {
                dst.securityLabel.add(codeableConcept4.copy());
            }
        }
        if (this.content != null) {
            dst.content = new ArrayList<DocumentReferenceContentComponent>();
            for (DocumentReferenceContentComponent documentReferenceContentComponent : this.content) {
                dst.content.add(documentReferenceContentComponent.copy());
            }
        }
        Reference reference5 = dst.sourcePatientInfo = this.sourcePatientInfo == null ? null : this.sourcePatientInfo.copy();
        if (this.related != null) {
            dst.related = new ArrayList<Reference>();
            for (Reference reference6 : this.related) {
                dst.related.add(reference6.copy());
            }
        }
    }

    protected DocumentReference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareDeep(this.identifier, o.identifier, true) && DocumentReference.compareDeep(this.basedOn, o.basedOn, true) && DocumentReference.compareDeep(this.status, o.status, true) && DocumentReference.compareDeep(this.docStatus, o.docStatus, true) && DocumentReference.compareDeep(this.type, o.type, true) && DocumentReference.compareDeep(this.category, o.category, true) && DocumentReference.compareDeep(this.subject, o.subject, true) && DocumentReference.compareDeep(this.encounter, o.encounter, true) && DocumentReference.compareDeep(this.event, o.event, true) && DocumentReference.compareDeep(this.facilityType, o.facilityType, true) && DocumentReference.compareDeep(this.practiceSetting, o.practiceSetting, true) && DocumentReference.compareDeep(this.period, o.period, true) && DocumentReference.compareDeep(this.date, o.date, true) && DocumentReference.compareDeep(this.author, o.author, true) && DocumentReference.compareDeep(this.attester, o.attester, true) && DocumentReference.compareDeep(this.custodian, o.custodian, true) && DocumentReference.compareDeep(this.relatesTo, o.relatesTo, true) && DocumentReference.compareDeep(this.description, o.description, true) && DocumentReference.compareDeep(this.securityLabel, o.securityLabel, true) && DocumentReference.compareDeep(this.content, o.content, true) && DocumentReference.compareDeep(this.sourcePatientInfo, o.sourcePatientInfo, true) && DocumentReference.compareDeep(this.related, o.related, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DocumentReference)) {
            return false;
        }
        DocumentReference o = (DocumentReference)other_;
        return DocumentReference.compareValues(this.status, o.status, true) && DocumentReference.compareValues(this.docStatus, o.docStatus, true) && DocumentReference.compareValues(this.date, o.date, true) && DocumentReference.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.docStatus, this.type, this.category, this.subject, this.encounter, this.event, this.facilityType, this.practiceSetting, this.period, this.date, this.author, this.attester, this.custodian, this.relatesTo, this.description, this.securityLabel, this.content, this.sourcePatientInfo, this.related});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentReference;
    }

    @Block
    public static class DocumentReferenceContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="attachment", type={Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to access the document", formalDefinition="The document or URL of the document along with critical metadata to prove content has integrity.")
        protected Attachment attachment;
        @Child(name="format", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Format/content rules for the document", formalDefinition="An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/formatcodes")
        protected Coding format;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the attachment binary", formalDefinition="Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.")
        protected Identifier identifier;
        private static final long serialVersionUID = 1399001009L;

        public DocumentReferenceContentComponent() {
        }

        public DocumentReferenceContentComponent(Attachment attachment) {
            this.setAttachment(attachment);
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public DocumentReferenceContentComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        public Coding getFormat() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new Coding();
                }
            }
            return this.format;
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public DocumentReferenceContentComponent setFormat(Coding value) {
            this.format = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceContentComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public DocumentReferenceContentComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment));
            children.add(new Property(DocumentReference.SP_FORMAT, "Coding", "An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, 1, this.format));
            children.add(new Property(DocumentReference.SP_IDENTIFIER, "Identifier", "Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.", 0, 1, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1963501277: {
                    return new Property("attachment", "Attachment", "The document or URL of the document along with critical metadata to prove content has integrity.", 0, 1, this.attachment);
                }
                case -1268779017: {
                    return new Property(DocumentReference.SP_FORMAT, "Coding", "An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType.", 0, 1, this.format);
                }
                case -1618432855: {
                    return new Property(DocumentReference.SP_IDENTIFIER, "Identifier", "Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.", 0, 1, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.attachment;
                    }
                    return baseArray;
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.format;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.identifier;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    this.attachment = TypeConvertor.castToAttachment(value);
                    return value;
                }
                case -1268779017: {
                    this.format = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = TypeConvertor.castToAttachment(value);
            } else if (name.equals(DocumentReference.SP_FORMAT)) {
                this.format = TypeConvertor.castToCoding(value);
            } else if (name.equals(DocumentReference.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return this.getAttachment();
                }
                case -1268779017: {
                    return this.getFormat();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
                case -1268779017: {
                    return new String[]{"Coding"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            if (name.equals(DocumentReference.SP_FORMAT)) {
                this.format = new Coding();
                return this.format;
            }
            if (name.equals(DocumentReference.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceContentComponent copy() {
            DocumentReferenceContentComponent dst = new DocumentReferenceContentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceContentComponent dst) {
            super.copyValues(dst);
            dst.attachment = this.attachment == null ? null : this.attachment.copy();
            dst.format = this.format == null ? null : this.format.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return DocumentReferenceContentComponent.compareDeep(this.attachment, o.attachment, true) && DocumentReferenceContentComponent.compareDeep(this.format, o.format, true) && DocumentReferenceContentComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceContentComponent)) {
                return false;
            }
            DocumentReferenceContentComponent o = (DocumentReferenceContentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.attachment, this.format, this.identifier});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.content";
        }
    }

    @Block
    public static class DocumentReferenceRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The relationship type with another document", formalDefinition="The type of relationship that this document has with anther document.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type")
        protected CodeableConcept code;
        @Child(name="target", type={DocumentReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Target of the relationship", formalDefinition="The target document of this relationship.")
        protected Reference target;
        private static final long serialVersionUID = -372012026L;

        public DocumentReferenceRelatesToComponent() {
        }

        public DocumentReferenceRelatesToComponent(CodeableConcept code, Reference target) {
            this.setCode(code);
            this.setTarget(target);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceRelatesToComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public DocumentReferenceRelatesToComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The type of relationship that this document has with anther document.", 0, 1, this.code));
            children.add(new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of relationship that this document has with anther document.", 0, 1, this.code);
                }
                case -880905839: {
                    return new Property("target", "Reference(DocumentReference)", "The target document of this relationship.", 0, 1, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("target")) {
                this.target = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -880905839: {
                    return this.getTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceRelatesToComponent copy() {
            DocumentReferenceRelatesToComponent dst = new DocumentReferenceRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceRelatesToComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.target = this.target == null ? null : this.target.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return DocumentReferenceRelatesToComponent.compareDeep(this.code, o.code, true) && DocumentReferenceRelatesToComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceRelatesToComponent)) {
                return false;
            }
            DocumentReferenceRelatesToComponent o = (DocumentReferenceRelatesToComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.target});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.relatesTo";
        }
    }

    @Block
    public static class DocumentReferenceAttesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-attestation-mode")
        protected Enumeration<DocumentAttestationMode> mode;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the composition was attested", formalDefinition="When the composition was attested by the party.")
        protected DateTimeType time;
        @Child(name="party", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who attested the composition", formalDefinition="Who attested the composition in the specified way.")
        protected Reference party;
        private static final long serialVersionUID = -437585715L;

        public DocumentReferenceAttesterComponent() {
        }

        public DocumentReferenceAttesterComponent(DocumentAttestationMode mode) {
            this.setMode(mode);
        }

        public Enumeration<DocumentAttestationMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<DocumentAttestationMode>(new DocumentAttestationModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public DocumentReferenceAttesterComponent setModeElement(Enumeration<DocumentAttestationMode> value) {
            this.mode = value;
            return this;
        }

        public DocumentAttestationMode getMode() {
            return this.mode == null ? null : (DocumentAttestationMode)((Object)this.mode.getValue());
        }

        public DocumentReferenceAttesterComponent setMode(DocumentAttestationMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<DocumentAttestationMode>(new DocumentAttestationModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public DocumentReferenceAttesterComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public DocumentReferenceAttesterComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DocumentReferenceAttesterComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public DocumentReferenceAttesterComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "The type of attestation the authenticator offers.", 0, 1, this.mode));
            children.add(new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time));
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "The type of attestation the authenticator offers.", 0, 1, this.mode);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time);
                }
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new DocumentAttestationModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new DocumentAttestationModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToDateTime(value);
            } else if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.attester.mode");
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type DocumentReference.attester.time");
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public DocumentReferenceAttesterComponent copy() {
            DocumentReferenceAttesterComponent dst = new DocumentReferenceAttesterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DocumentReferenceAttesterComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.time = this.time == null ? null : this.time.copy();
            dst.party = this.party == null ? null : this.party.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAttesterComponent)) {
                return false;
            }
            DocumentReferenceAttesterComponent o = (DocumentReferenceAttesterComponent)other_;
            return DocumentReferenceAttesterComponent.compareDeep(this.mode, o.mode, true) && DocumentReferenceAttesterComponent.compareDeep(this.time, o.time, true) && DocumentReferenceAttesterComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DocumentReferenceAttesterComponent)) {
                return false;
            }
            DocumentReferenceAttesterComponent o = (DocumentReferenceAttesterComponent)other_;
            return DocumentReferenceAttesterComponent.compareValues(this.mode, o.mode, true) && DocumentReferenceAttesterComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.time, this.party});
        }

        @Override
        public String fhirType() {
            return "DocumentReference.attester";
        }
    }

    public static class DocumentAttestationModeEnumFactory
    implements EnumFactory<DocumentAttestationMode> {
        @Override
        public DocumentAttestationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return DocumentAttestationMode.PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return DocumentAttestationMode.PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return DocumentAttestationMode.LEGAL;
            }
            if ("official".equals(codeString)) {
                return DocumentAttestationMode.OFFICIAL;
            }
            throw new IllegalArgumentException("Unknown DocumentAttestationMode code '" + codeString + "'");
        }

        public Enumeration<DocumentAttestationMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentAttestationMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return new Enumeration<DocumentAttestationMode>(this, DocumentAttestationMode.PERSONAL);
            }
            if ("professional".equals(codeString)) {
                return new Enumeration<DocumentAttestationMode>(this, DocumentAttestationMode.PROFESSIONAL);
            }
            if ("legal".equals(codeString)) {
                return new Enumeration<DocumentAttestationMode>(this, DocumentAttestationMode.LEGAL);
            }
            if ("official".equals(codeString)) {
                return new Enumeration<DocumentAttestationMode>(this, DocumentAttestationMode.OFFICIAL);
            }
            throw new FHIRException("Unknown DocumentAttestationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentAttestationMode code) {
            if (code == DocumentAttestationMode.PERSONAL) {
                return "personal";
            }
            if (code == DocumentAttestationMode.PROFESSIONAL) {
                return "professional";
            }
            if (code == DocumentAttestationMode.LEGAL) {
                return "legal";
            }
            if (code == DocumentAttestationMode.OFFICIAL) {
                return "official";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentAttestationMode code) {
            return code.getSystem();
        }
    }

    public static enum DocumentAttestationMode {
        PERSONAL,
        PROFESSIONAL,
        LEGAL,
        OFFICIAL,
        NULL;


        public static DocumentAttestationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("personal".equals(codeString)) {
                return PERSONAL;
            }
            if ("professional".equals(codeString)) {
                return PROFESSIONAL;
            }
            if ("legal".equals(codeString)) {
                return LEGAL;
            }
            if ("official".equals(codeString)) {
                return OFFICIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentAttestationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSONAL: {
                    return "personal";
                }
                case PROFESSIONAL: {
                    return "professional";
                }
                case LEGAL: {
                    return "legal";
                }
                case OFFICIAL: {
                    return "official";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSONAL: {
                    return "http://hl7.org/fhir/document-attestation-mode";
                }
                case PROFESSIONAL: {
                    return "http://hl7.org/fhir/document-attestation-mode";
                }
                case LEGAL: {
                    return "http://hl7.org/fhir/document-attestation-mode";
                }
                case OFFICIAL: {
                    return "http://hl7.org/fhir/document-attestation-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSONAL: {
                    return "The person authenticated the content in their personal capacity.";
                }
                case PROFESSIONAL: {
                    return "The person authenticated the content in their professional capacity.";
                }
                case LEGAL: {
                    return "The person authenticated the content and accepted legal responsibility for its content.";
                }
                case OFFICIAL: {
                    return "The organization authenticated the content as consistent with their policies and procedures.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSONAL: {
                    return "Personal";
                }
                case PROFESSIONAL: {
                    return "Professional";
                }
                case LEGAL: {
                    return "Legal";
                }
                case OFFICIAL: {
                    return "Official";
                }
            }
            return "?";
        }
    }
}

