/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ConceptMap2;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="EpisodeOfCare", profile="http://hl7.org/fhir/StructureDefinition/EpisodeOfCare")
public class EpisodeOfCare
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier(s) relevant for this EpisodeOfCare", formalDefinition="The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled | entered-in-error", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
    protected Enumeration<EpisodeOfCareStatus> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Past list of status codes (the current status may be included to cover the start date of the status)", formalDefinition="The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).")
    protected List<EpisodeOfCareStatusHistoryComponent> statusHistory;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type/class  - e.g. specialist referral, disease management", formalDefinition="A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/episodeofcare-type")
    protected List<CodeableConcept> type;
    @Child(name="diagnosis", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of diagnosis relevant to this episode of care", formalDefinition="The list of diagnosis relevant to this episode of care.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient who is the focus of this episode of care", formalDefinition="The patient who is the focus of this episode of care.")
    protected Reference patient;
    @Child(name="managingOrganization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that assumes care", formalDefinition="The organization that has assumed the specific responsibilities for the specified duration.")
    protected Reference managingOrganization;
    @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval during responsibility is assumed", formalDefinition="The interval during which the managing organization assumes the defined responsibility.")
    protected Period period;
    @Child(name="referralRequest", type={ServiceRequest.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Originating Referral Request(s)", formalDefinition="Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.")
    protected List<Reference> referralRequest;
    @Child(name="careManager", type={Practitioner.class, PractitionerRole.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Care manager/care coordinator for the patient", formalDefinition="The practitioner that is the care manager/care coordinator for this patient.")
    protected Reference careManager;
    @Child(name="team", type={CareTeam.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other practitioners facilitating this episode of care", formalDefinition="The list of practitioners that may be facilitating this episode of care for specific purposes.")
    protected List<Reference> team;
    @Child(name="account", type={Account.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this EpisodeOfCare", formalDefinition="The set of accounts that may be used for billing for this EpisodeOfCare.")
    protected List<Reference> account;
    private static final long serialVersionUID = 202200834L;
    @SearchParamDefinition(name="care-manager", path="EpisodeOfCare.careManager.where(resolve() is Practitioner)", description="Care manager/care coordinator for the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_CARE_MANAGER = "care-manager";
    public static final ReferenceClientParam CARE_MANAGER = new ReferenceClientParam("care-manager");
    public static final Include INCLUDE_CARE_MANAGER = new Include("EpisodeOfCare:care-manager").toLocked();
    @SearchParamDefinition(name="condition", path="EpisodeOfCare.diagnosis.condition", description="Conditions/problems/diagnoses this episode of care is for", type="reference", target={Condition.class})
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("EpisodeOfCare:condition").toLocked();
    @SearchParamDefinition(name="incoming-referral", path="EpisodeOfCare.referralRequest", description="Incoming Referral Request", type="reference", target={ServiceRequest.class})
    public static final String SP_INCOMING_REFERRAL = "incoming-referral";
    public static final ReferenceClientParam INCOMING_REFERRAL = new ReferenceClientParam("incoming-referral");
    public static final Include INCLUDE_INCOMING_REFERRAL = new Include("EpisodeOfCare:incoming-referral").toLocked();
    @SearchParamDefinition(name="organization", path="EpisodeOfCare.managingOrganization", description="The organization that has assumed the specific responsibilities of this EpisodeOfCare", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("EpisodeOfCare:organization").toLocked();
    @SearchParamDefinition(name="status", path="EpisodeOfCare.status", description="The current status of the Episode of Care as provided (does not check the status history collection)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EpisodeOfCare:patient").toLocked();
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type | Composition.type | DocumentManifest.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [DocumentManifest](documentmanifest.html): Kind of document set\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public EpisodeOfCare() {
    }

    public EpisodeOfCare(EpisodeOfCareStatus status, Reference patient) {
        this.setStatus(status);
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EpisodeOfCare setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EpisodeOfCare addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EpisodeOfCareStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EpisodeOfCare setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
        this.status = value;
        return this;
    }

    public EpisodeOfCareStatus getStatus() {
        return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
    }

    public EpisodeOfCare setStatus(EpisodeOfCareStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<EpisodeOfCareStatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public EpisodeOfCare setStatusHistory(List<EpisodeOfCareStatusHistoryComponent> theStatusHistory) {
        this.statusHistory = theStatusHistory;
        return this;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (EpisodeOfCareStatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EpisodeOfCareStatusHistoryComponent addStatusHistory() {
        EpisodeOfCareStatusHistoryComponent t = new EpisodeOfCareStatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public EpisodeOfCare addStatusHistory(EpisodeOfCareStatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public EpisodeOfCareStatusHistoryComponent getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public EpisodeOfCare setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public EpisodeOfCare addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public EpisodeOfCare setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public EpisodeOfCare addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public EpisodeOfCare setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public EpisodeOfCare setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public EpisodeOfCare setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getReferralRequest() {
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        return this.referralRequest;
    }

    public EpisodeOfCare setReferralRequest(List<Reference> theReferralRequest) {
        this.referralRequest = theReferralRequest;
        return this;
    }

    public boolean hasReferralRequest() {
        if (this.referralRequest == null) {
            return false;
        }
        for (Reference item : this.referralRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReferralRequest() {
        Reference t = new Reference();
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return t;
    }

    public EpisodeOfCare addReferralRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.referralRequest == null) {
            this.referralRequest = new ArrayList<Reference>();
        }
        this.referralRequest.add(t);
        return this;
    }

    public Reference getReferralRequestFirstRep() {
        if (this.getReferralRequest().isEmpty()) {
            this.addReferralRequest();
        }
        return this.getReferralRequest().get(0);
    }

    public Reference getCareManager() {
        if (this.careManager == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EpisodeOfCare.careManager");
            }
            if (Configuration.doAutoCreate()) {
                this.careManager = new Reference();
            }
        }
        return this.careManager;
    }

    public boolean hasCareManager() {
        return this.careManager != null && !this.careManager.isEmpty();
    }

    public EpisodeOfCare setCareManager(Reference value) {
        this.careManager = value;
        return this;
    }

    public List<Reference> getTeam() {
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        return this.team;
    }

    public EpisodeOfCare setTeam(List<Reference> theTeam) {
        this.team = theTeam;
        return this;
    }

    public boolean hasTeam() {
        if (this.team == null) {
            return false;
        }
        for (Reference item : this.team) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTeam() {
        Reference t = new Reference();
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return t;
    }

    public EpisodeOfCare addTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return this;
    }

    public Reference getTeamFirstRep() {
        if (this.getTeam().isEmpty()) {
            this.addTeam();
        }
        return this.getTeam().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public EpisodeOfCare setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public EpisodeOfCare addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status));
        children.add(new Property("statusHistory", "", "The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).", 0, Integer.MAX_VALUE, this.statusHistory));
        children.add(new Property(SP_TYPE, "CodeableConcept", "A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("diagnosis", "", "The list of diagnosis relevant to this episode of care.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the focus of this episode of care.", 0, 1, this.patient));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization that has assumed the specific responsibilities for the specified duration.", 0, 1, this.managingOrganization));
        children.add(new Property("period", "Period", "The interval during which the managing organization assumes the defined responsibility.", 0, 1, this.period));
        children.add(new Property("referralRequest", "Reference(ServiceRequest)", "Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.", 0, Integer.MAX_VALUE, this.referralRequest));
        children.add(new Property("careManager", "Reference(Practitioner|PractitionerRole)", "The practitioner that is the care manager/care coordinator for this patient.", 0, 1, this.careManager));
        children.add(new Property("team", "Reference(CareTeam)", "The list of practitioners that may be facilitating this episode of care for specific purposes.", 0, Integer.MAX_VALUE, this.team));
        children.add(new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this EpisodeOfCare.", 0, Integer.MAX_VALUE, this.account));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The EpisodeOfCare may be known by different identifiers for different contexts of use, such as when an external agency is tracking the Episode for funding purposes.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status);
            }
            case -986695614: {
                return new Property("statusHistory", "", "The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource).", 0, Integer.MAX_VALUE, this.statusHistory);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "A classification of the type of episode of care; e.g. specialist referral, disease management, type of funded care.", 0, Integer.MAX_VALUE, this.type);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "The list of diagnosis relevant to this episode of care.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who is the focus of this episode of care.", 0, 1, this.patient);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization that has assumed the specific responsibilities for the specified duration.", 0, 1, this.managingOrganization);
            }
            case -991726143: {
                return new Property("period", "Period", "The interval during which the managing organization assumes the defined responsibility.", 0, 1, this.period);
            }
            case -310299598: {
                return new Property("referralRequest", "Reference(ServiceRequest)", "Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals.", 0, Integer.MAX_VALUE, this.referralRequest);
            }
            case -1147746468: {
                return new Property("careManager", "Reference(Practitioner|PractitionerRole)", "The practitioner that is the care manager/care coordinator for this patient.", 0, 1, this.careManager);
            }
            case 3555933: {
                return new Property("team", "Reference(CareTeam)", "The list of practitioners that may be facilitating this episode of care for specific purposes.", 0, Integer.MAX_VALUE, this.team);
            }
            case -1177318867: {
                return new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this EpisodeOfCare.", 0, Integer.MAX_VALUE, this.account);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -310299598: {
                return this.referralRequest == null ? new Base[]{} : this.referralRequest.toArray(new Base[this.referralRequest.size()]);
            }
            case -1147746468: {
                Base[] baseArray;
                if (this.careManager == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.careManager;
                }
                return baseArray;
            }
            case 3555933: {
                return this.team == null ? new Base[]{} : this.team.toArray(new Base[this.team.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -986695614: {
                this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)((Object)value));
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case -2058947787: {
                this.managingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -310299598: {
                this.getReferralRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1147746468: {
                this.careManager = TypeConvertor.castToReference(value);
                return value;
            }
            case 3555933: {
                this.getTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((EpisodeOfCareStatusHistoryComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("referralRequest")) {
            this.getReferralRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("careManager")) {
            this.careManager = TypeConvertor.castToReference(value);
        } else if (name.equals("team")) {
            this.getTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("account")) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 3575610: {
                return this.addType();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -310299598: {
                return this.addReferralRequest();
            }
            case -1147746468: {
                return this.getCareManager();
            }
            case 3555933: {
                return this.addTeam();
            }
            case -1177318867: {
                return this.addAccount();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -986695614: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 1196993265: {
                return new String[0];
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -310299598: {
                return new String[]{"Reference"};
            }
            case -1147746468: {
                return new String[]{"Reference"};
            }
            case 3555933: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EpisodeOfCare.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("referralRequest")) {
            return this.addReferralRequest();
        }
        if (name.equals("careManager")) {
            this.careManager = new Reference();
            return this.careManager;
        }
        if (name.equals("team")) {
            return this.addTeam();
        }
        if (name.equals("account")) {
            return this.addAccount();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EpisodeOfCare";
    }

    @Override
    public EpisodeOfCare copy() {
        EpisodeOfCare dst = new EpisodeOfCare();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EpisodeOfCare dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EpisodeOfCareStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<EpisodeOfCareStatusHistoryComponent>();
            for (EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(episodeOfCareStatusHistoryComponent.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.referralRequest != null) {
            dst.referralRequest = new ArrayList<Reference>();
            for (Reference reference : this.referralRequest) {
                dst.referralRequest.add(reference.copy());
            }
        }
        Reference reference = dst.careManager = this.careManager == null ? null : this.careManager.copy();
        if (this.team != null) {
            dst.team = new ArrayList<Reference>();
            for (Reference reference2 : this.team) {
                dst.team.add(reference2.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference3 : this.account) {
                dst.account.add(reference3.copy());
            }
        }
    }

    protected EpisodeOfCare typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other_;
        return EpisodeOfCare.compareDeep(this.identifier, o.identifier, true) && EpisodeOfCare.compareDeep(this.status, o.status, true) && EpisodeOfCare.compareDeep(this.statusHistory, o.statusHistory, true) && EpisodeOfCare.compareDeep(this.type, o.type, true) && EpisodeOfCare.compareDeep(this.diagnosis, o.diagnosis, true) && EpisodeOfCare.compareDeep(this.patient, o.patient, true) && EpisodeOfCare.compareDeep(this.managingOrganization, o.managingOrganization, true) && EpisodeOfCare.compareDeep(this.period, o.period, true) && EpisodeOfCare.compareDeep(this.referralRequest, o.referralRequest, true) && EpisodeOfCare.compareDeep(this.careManager, o.careManager, true) && EpisodeOfCare.compareDeep(this.team, o.team, true) && EpisodeOfCare.compareDeep(this.account, o.account, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EpisodeOfCare)) {
            return false;
        }
        EpisodeOfCare o = (EpisodeOfCare)other_;
        return EpisodeOfCare.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.statusHistory, this.type, this.diagnosis, this.patient, this.managingOrganization, this.period, this.referralRequest, this.careManager, this.team, this.account});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EpisodeOfCare;
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={Condition.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Conditions/problems/diagnoses this episode of care is for", formalDefinition="A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for.")
        protected Reference condition;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026)", formalDefinition="Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnosis-role")
        protected CodeableConcept role;
        @Child(name="rank", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Ranking of the diagnosis (for each role type)", formalDefinition="Ranking of the diagnosis (for each role type).")
        protected PositiveIntType rank;
        private static final long serialVersionUID = -294944963L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(Reference condition) {
            this.setCondition(condition);
        }

        public Reference getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new Reference();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public DiagnosisComponent setCondition(Reference value) {
            this.condition = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public DiagnosisComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public PositiveIntType getRankElement() {
            if (this.rank == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.rank");
                }
                if (Configuration.doAutoCreate()) {
                    this.rank = new PositiveIntType();
                }
            }
            return this.rank;
        }

        public boolean hasRankElement() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public boolean hasRank() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public DiagnosisComponent setRankElement(PositiveIntType value) {
            this.rank = value;
            return this;
        }

        public int getRank() {
            return this.rank == null || this.rank.isEmpty() ? 0 : (Integer)this.rank.getValue();
        }

        public DiagnosisComponent setRank(int value) {
            if (this.rank == null) {
                this.rank = new PositiveIntType();
            }
            this.rank.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EpisodeOfCare.SP_CONDITION, "Reference(Condition)", "A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for.", 0, 1, this.condition));
            children.add(new Property("role", "CodeableConcept", "Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).", 0, 1, this.role));
            children.add(new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property(EpisodeOfCare.SP_CONDITION, "Reference(Condition)", "A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for.", 0, 1, this.condition);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role that this diagnosis has within the episode of care (e.g. admission, billing, discharge \u2026).", 0, 1, this.role);
                }
                case 3492908: {
                    return new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.condition;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case 3492908: {
                    Base[] baseArray;
                    if (this.rank == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rank;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.condition = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3492908: {
                    this.rank = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_CONDITION)) {
                this.condition = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("rank")) {
                this.rank = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.getCondition();
                }
                case 3506294: {
                    return this.getRole();
                }
                case 3492908: {
                    return this.getRankElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 3492908: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_CONDITION)) {
                this.condition = new Reference();
                return this.condition;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("rank")) {
                throw new FHIRException("Cannot call addChild on a primitive type EpisodeOfCare.diagnosis.rank");
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.rank = this.rank == null ? null : this.rank.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.condition, o.condition, true) && DiagnosisComponent.compareDeep(this.role, o.role, true) && DiagnosisComponent.compareDeep(this.rank, o.rank, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.rank, o.rank, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.condition, this.role, this.rank});
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.diagnosis";
        }
    }

    @Block
    public static class EpisodeOfCareStatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | waitlist | active | onhold | finished | cancelled | entered-in-error", formalDefinition="planned | waitlist | active | onhold | finished | cancelled.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
        protected Enumeration<EpisodeOfCareStatus> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Duration the EpisodeOfCare was in the specified status", formalDefinition="The period during this EpisodeOfCare that the specific status applied.")
        protected Period period;
        private static final long serialVersionUID = -1192432864L;

        public EpisodeOfCareStatusHistoryComponent() {
        }

        public EpisodeOfCareStatusHistoryComponent(EpisodeOfCareStatus status, Period period) {
            this.setStatus(status);
            this.setPeriod(period);
        }

        public Enumeration<EpisodeOfCareStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setStatusElement(Enumeration<EpisodeOfCareStatus> value) {
            this.status = value;
            return this;
        }

        public EpisodeOfCareStatus getStatus() {
            return this.status == null ? null : (EpisodeOfCareStatus)((Object)this.status.getValue());
        }

        public EpisodeOfCareStatusHistoryComponent setStatus(EpisodeOfCareStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<EpisodeOfCareStatus>(new EpisodeOfCareStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EpisodeOfCareStatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EpisodeOfCareStatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EpisodeOfCare.SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status));
            children.add(new Property("period", "Period", "The period during this EpisodeOfCare that the specific status applied.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(EpisodeOfCare.SP_STATUS, "code", "planned | waitlist | active | onhold | finished | cancelled.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period during this EpisodeOfCare that the specific status applied.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                value = new EpisodeOfCareStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EpisodeOfCare.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type EpisodeOfCare.statusHistory.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EpisodeOfCareStatusHistoryComponent copy() {
            EpisodeOfCareStatusHistoryComponent dst = new EpisodeOfCareStatusHistoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EpisodeOfCareStatusHistoryComponent dst) {
            super.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other_;
            return EpisodeOfCareStatusHistoryComponent.compareDeep(this.status, o.status, true) && EpisodeOfCareStatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EpisodeOfCareStatusHistoryComponent)) {
                return false;
            }
            EpisodeOfCareStatusHistoryComponent o = (EpisodeOfCareStatusHistoryComponent)other_;
            return EpisodeOfCareStatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.status, this.period});
        }

        @Override
        public String fhirType() {
            return "EpisodeOfCare.statusHistory";
        }
    }

    public static class EpisodeOfCareStatusEnumFactory
    implements EnumFactory<EpisodeOfCareStatus> {
        @Override
        public EpisodeOfCareStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EpisodeOfCareStatus.PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return EpisodeOfCareStatus.WAITLIST;
            }
            if ("active".equals(codeString)) {
                return EpisodeOfCareStatus.ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return EpisodeOfCareStatus.ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return EpisodeOfCareStatus.FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return EpisodeOfCareStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return EpisodeOfCareStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public Enumeration<EpisodeOfCareStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EpisodeOfCareStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.PLANNED);
            }
            if ("waitlist".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.WAITLIST);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ACTIVE);
            }
            if ("onhold".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ONHOLD);
            }
            if ("finished".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.FINISHED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EpisodeOfCareStatus>(this, EpisodeOfCareStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EpisodeOfCareStatus code) {
            if (code == EpisodeOfCareStatus.PLANNED) {
                return "planned";
            }
            if (code == EpisodeOfCareStatus.WAITLIST) {
                return "waitlist";
            }
            if (code == EpisodeOfCareStatus.ACTIVE) {
                return "active";
            }
            if (code == EpisodeOfCareStatus.ONHOLD) {
                return "onhold";
            }
            if (code == EpisodeOfCareStatus.FINISHED) {
                return "finished";
            }
            if (code == EpisodeOfCareStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EpisodeOfCareStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EpisodeOfCareStatus code) {
            return code.getSystem();
        }
    }

    public static enum EpisodeOfCareStatus {
        PLANNED,
        WAITLIST,
        ACTIVE,
        ONHOLD,
        FINISHED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static EpisodeOfCareStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("waitlist".equals(codeString)) {
                return WAITLIST;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("onhold".equals(codeString)) {
                return ONHOLD;
            }
            if ("finished".equals(codeString)) {
                return FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case WAITLIST: {
                    return "waitlist";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "onhold";
                }
                case FINISHED: {
                    return "finished";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case WAITLIST: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case FINISHED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/episode-of-care-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "This episode of care is planned to start at the date specified in the period.start. During this status, an organization may perform assessments to determine if the patient is eligible to receive services, or be organizing to make resources available to provide care services.";
                }
                case WAITLIST: {
                    return "This episode has been placed on a waitlist, pending the episode being made active (or cancelled).";
                }
                case ACTIVE: {
                    return "This episode of care is current.";
                }
                case ONHOLD: {
                    return "This episode of care is on hold; the organization has limited responsibility for the patient (such as while on respite).";
                }
                case FINISHED: {
                    return "This episode of care is finished and the organization is not expecting to be providing further care to the patient. Can also be known as \"closed\", \"completed\" or other similar terms.";
                }
                case CANCELLED: {
                    return "The episode of care was cancelled, or withdrawn from service, often selected during the planned stage as the patient may have gone elsewhere, or the circumstances have changed and the organization is unable to provide the care. It indicates that services terminated outside the planned/expected workflow.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case WAITLIST: {
                    return "Waitlist";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FINISHED: {
                    return "Finished";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

