/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ElementWrappers {

    public static class PropertyWrapperMetaElement
    extends BaseWrappers.RendererWrapperImpl
    implements BaseWrappers.PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrappers.BaseWrapper> list;

        public PropertyWrapperMetaElement(RenderingContext context, StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            super(context);
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrappers.BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrappers.BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperMetaElement(this.context, e, e.fhirType(), this.structure, this.definition));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.definition.typeSummary();
        }

        @Override
        public String getDefinition() {
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            return "*".equals(this.definition.getMax()) ? Integer.MAX_VALUE : Integer.valueOf(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrappers.BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }

        @Override
        public BaseWrappers.ResourceWrapper getAsResource() {
            return new ResourceWrapperMetaElement(this.context, this.values.get(0));
        }

        @Override
        public String fhirType() {
            return this.getTypeCode();
        }

        @Override
        public ElementDefinition getElementDefinition() {
            return this.definition;
        }
    }

    public static class ResourceWrapperMetaElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.ResourceWrapper {
        private Element wrapped;
        private List<BaseWrappers.ResourceWrapper> list;
        private List<BaseWrappers.PropertyWrapper> list2;
        private StructureDefinition definition;

        public ResourceWrapperMetaElement(RenderingContext context, Element wrapped) {
            super(context);
            this.wrapped = wrapped;
            this.definition = wrapped.getProperty().getStructure();
        }

        @Override
        public List<BaseWrappers.ResourceWrapper> getContained() {
            if (this.list == null) {
                List<Element> children = this.wrapped.getChildrenByName("contained");
                this.list = new ArrayList<BaseWrappers.ResourceWrapper>();
                for (Element e : children) {
                    this.list.add(new ResourceWrapperMetaElement(this.context, e));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return this.wrapped.getNamedChildValue("id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = this.wrapped.getNamedChild("text");
            if (txt == null) {
                return null;
            }
            Element div = txt.getNamedChild("div");
            if (div == null) {
                return null;
            }
            return div.getXhtml();
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public String getNameFromResource() {
            Property name = this.wrapped.getChildByName("name");
            if (name != null && name.hasValues()) {
                Base b = name.getValues().get(0);
                if (b.isPrimitive()) {
                    return b.primitiveValue();
                }
                if (b.fhirType().equals("HumanName")) {
                    String s;
                    Property family = b.getChildByName("family");
                    Property given = this.wrapped.getChildByName("given");
                    String string = s = given != null && given.hasValues() ? given.getValues().get(0).primitiveValue() : "";
                    if (family != null && family.hasValues()) {
                        s = s + " " + family.getValues().get(0).primitiveValue().toUpperCase();
                    }
                    return s;
                }
                return null;
            }
            return null;
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = this.context.getProfileUtilities().getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    if (child.getPath().endsWith("[x]")) {
                        this.wrapped.getNamedChildrenWithWildcard(this.tail(child.getPath()), elements);
                    } else {
                        this.wrapped.getNamedChildren(this.tail(child.getPath()), elements);
                    }
                    this.list2.add(new PropertyWrapperMetaElement(this.context, this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void describe(XhtmlNode x) {
            if (this.wrapped.hasChild("title") && this.wrapped.getChildValue("title") != null) {
                x.tx(this.wrapped.getChildValue("title"));
            } else if (this.wrapped.hasChild("name") && this.wrapped.getChildValue("name") != null) {
                x.tx(this.wrapped.getChildValue("name"));
            } else {
                x.tx("?ngen-1?");
            }
        }

        @Override
        public void injectNarrative(XhtmlNode x, Narrative.NarrativeStatus status) throws IOException {
            Element st;
            Element txt;
            String l;
            if (!x.hasAttribute("xmlns")) {
                x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
            if (!Utilities.noString((String)(l = this.wrapped.getChildValue("language")))) {
                x.setAttribute("lang", l);
                x.setAttribute("xml:lang", l);
            }
            if ((txt = this.wrapped.getNamedChild("text")) == null) {
                int i;
                txt = new Element("text", this.wrapped.getProperty().getChild(null, "text"));
                for (i = 0; i < this.wrapped.getChildren().size() && (this.wrapped.getChildren().get(i).getName().equals("id") || this.wrapped.getChildren().get(i).getName().equals("meta") || this.wrapped.getChildren().get(i).getName().equals("implicitRules") || this.wrapped.getChildren().get(i).getName().equals("language")); ++i) {
                }
                if (i >= this.wrapped.getChildren().size()) {
                    this.wrapped.getChildren().add(txt);
                } else {
                    this.wrapped.getChildren().add(i, txt);
                }
            }
            if ((st = txt.getNamedChild("status")) == null) {
                st = new Element("status", txt.getProperty().getChild(null, "status"));
                txt.getChildren().add(0, st);
            }
            st.setValue(status.toCode());
            Element div = txt.getNamedChild("div");
            if (div == null) {
                div = new Element("div", txt.getProperty().getChild(null, "div"));
                txt.getChildren().add(div);
                div.setValue(new XhtmlComposer(true, this.context.isPretty()).compose(x));
            }
            div.setValue(x.toString());
            div.setXhtml(x);
        }

        @Override
        public BaseWrappers.BaseWrapper root() {
            return new BaseWrapperMetaElement(this.context, this.wrapped, this.getName(), this.definition, this.definition.getSnapshot().getElementFirstRep());
        }

        @Override
        public StructureDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public boolean hasNarrative() {
            StructureDefinition sd = this.definition;
            while (sd != null) {
                if ("DomainResource".equals(sd.getType())) {
                    return true;
                }
                sd = this.context.getWorker().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
            return false;
        }

        @Override
        public String fhirType() {
            return this.wrapped.fhirType();
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            for (BaseWrappers.PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    public static class BaseWrapperMetaElement
    extends BaseWrappers.WrapperBaseImpl
    implements BaseWrappers.BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<BaseWrappers.PropertyWrapper> list;

        public BaseWrapperMetaElement(RenderingContext context, Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            super(context);
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            if (this.element.hasElementProperty()) {
                return this.element;
            }
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            try {
                new XmlParser(this.context.getWorker()).compose(this.element, (OutputStream)xml, IParser.OutputStyle.PRETTY, null);
            }
            catch (Exception e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            if (this.context.getParser() == null) {
                System.out.println("No version specific parser provided");
            }
            if (this.context.getParser() == null) {
                throw new Error("No type parser provided to renderer context");
            }
            try {
                return this.context.getParser().parseType(xml.toString(StandardCharsets.UTF_8), this.type);
            }
            catch (Exception e) {
                return new StringType("Illegal syntax: " + e.getMessage());
            }
        }

        @Override
        public List<BaseWrappers.PropertyWrapper> children() {
            if (this.list == null) {
                this.children = this.context.getProfileUtilities().getChildList(this.structure, this.definition, false, true);
                if (this.children.isEmpty() && !Utilities.noString((String)this.type)) {
                    StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(this.type);
                    this.children = this.context.getProfileUtilities().getChildList(sd, sd.getSnapshot().getElementFirstRep());
                }
                this.list = new ArrayList<BaseWrappers.PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    String name = this.tail(child.getPath());
                    if (name.endsWith("[x]")) {
                        this.element.getNamedChildrenWithWildcard(name, elements);
                    } else {
                        this.element.getNamedChildren(name, elements);
                    }
                    this.list.add(new PropertyWrapperMetaElement(this.context, this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public BaseWrappers.PropertyWrapper getChildByName(String name) {
            for (BaseWrappers.PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }

        @Override
        public String fhirType() {
            return this.element.fhirType();
        }
    }
}

