/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConceptMap2", profile="http://hl7.org/fhir/StructureDefinition/ConceptMap2")
public class ConceptMap2
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this concept map, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the concept map", formalDefinition="A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the concept map", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (computer friendly)", formalDefinition="A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the concept map.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this concept map. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the concept map.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the concept map", formalDefinition="A free text natural language description of the concept map from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for concept map (if applicable)", formalDefinition="A legal or geographic region in which the concept map is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this concept map is defined", formalDefinition="Explanation of why this concept map is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.")
    protected MarkdownType copyright;
    @Child(name="source", type={UriType.class, CanonicalType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source value set that contains the concepts that are being mapped", formalDefinition="Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.")
    protected DataType source;
    @Child(name="target", type={UriType.class, CanonicalType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The target value set which provides context for the mappings", formalDefinition="The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.")
    protected DataType target;
    @Child(name="group", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Same source and target systems", formalDefinition="A group of mappings that all have the same source and target system.")
    protected List<ConceptMap2GroupComponent> group;
    private static final long serialVersionUID = -601128902L;
    @SearchParamDefinition(name="context-quantity", path="(ConceptMap2.useContext.value as Quantity) | (ConceptMap2.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the concept map", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ConceptMap2.useContext", description="A use context type and quantity- or range-based value assigned to the concept map", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ConceptMap2.useContext", description="A use context type and value assigned to the concept map", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ConceptMap2.useContext.code", description="A type of use context assigned to the concept map", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ConceptMap2.useContext.value as CodeableConcept)", description="A use context assigned to the concept map", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ConceptMap2.date", description="The concept map publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="dependson", path="ConceptMap2.group.element.target.dependsOn.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_DEPENDSON = "dependson";
    public static final UriClientParam DEPENDSON = new UriClientParam("dependson");
    @SearchParamDefinition(name="description", path="ConceptMap2.description", description="The description of the concept map", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ConceptMap2.identifier", description="External identifier for the concept map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ConceptMap2.jurisdiction", description="Intended jurisdiction for the concept map", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ConceptMap2.name", description="Computationally friendly name of the concept map", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="other", path="ConceptMap2.group.unmapped.url", description="canonical reference to an additional ConceptMap2 to use for mapping if the source concept is unmapped", type="reference", target={ConceptMap2.class})
    public static final String SP_OTHER = "other";
    public static final ReferenceClientParam OTHER = new ReferenceClientParam("other");
    public static final Include INCLUDE_OTHER = new Include("ConceptMap2:other").toLocked();
    @SearchParamDefinition(name="product", path="ConceptMap2.group.element.target.product.property", description="Reference to property mapping depends on", type="uri")
    public static final String SP_PRODUCT = "product";
    public static final UriClientParam PRODUCT = new UriClientParam("product");
    @SearchParamDefinition(name="publisher", path="ConceptMap2.publisher", description="Name of the publisher of the concept map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="source-code", path="ConceptMap2.group.element.code", description="Identifies element being mapped", type="token")
    public static final String SP_SOURCE_CODE = "source-code";
    public static final TokenClientParam SOURCE_CODE = new TokenClientParam("source-code");
    @SearchParamDefinition(name="source-system", path="ConceptMap2.group.source", description="Source system where concepts to be mapped are defined", type="uri")
    public static final String SP_SOURCE_SYSTEM = "source-system";
    public static final UriClientParam SOURCE_SYSTEM = new UriClientParam("source-system");
    @SearchParamDefinition(name="source-uri", path="(ConceptMap2.source as uri)", description="The source value set that contains the concepts that are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE_URI = "source-uri";
    public static final ReferenceClientParam SOURCE_URI = new ReferenceClientParam("source-uri");
    public static final Include INCLUDE_SOURCE_URI = new Include("ConceptMap2:source-uri").toLocked();
    @SearchParamDefinition(name="source", path="(ConceptMap2.source as canonical)", description="The source value set that contains the concepts that are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("ConceptMap2:source").toLocked();
    @SearchParamDefinition(name="status", path="ConceptMap2.status", description="The current status of the concept map", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="target-code", path="ConceptMap2.group.element.target.code", description="Code that identifies the target element", type="token")
    public static final String SP_TARGET_CODE = "target-code";
    public static final TokenClientParam TARGET_CODE = new TokenClientParam("target-code");
    @SearchParamDefinition(name="target-system", path="ConceptMap2.group.target", description="Target system that the concepts are to be mapped to", type="uri")
    public static final String SP_TARGET_SYSTEM = "target-system";
    public static final UriClientParam TARGET_SYSTEM = new UriClientParam("target-system");
    @SearchParamDefinition(name="target-uri", path="(ConceptMap2.target as uri)", description="The target value set which provides context for the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET_URI = "target-uri";
    public static final ReferenceClientParam TARGET_URI = new ReferenceClientParam("target-uri");
    public static final Include INCLUDE_TARGET_URI = new Include("ConceptMap2:target-uri").toLocked();
    @SearchParamDefinition(name="target", path="(ConceptMap2.target as canonical)", description="The target value set which provides context for the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("ConceptMap2:target").toLocked();
    @SearchParamDefinition(name="title", path="ConceptMap2.title", description="The human-friendly name of the concept map", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ConceptMap2.url", description="The uri that identifies the concept map", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ConceptMap2.version", description="The business version of the concept map", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ConceptMap2() {
    }

    public ConceptMap2(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConceptMap2 setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConceptMap2 setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ConceptMap2 setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ConceptMap2 addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConceptMap2 setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConceptMap2 setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConceptMap2 setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConceptMap2 setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConceptMap2 setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConceptMap2 setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConceptMap2 setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConceptMap2 setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConceptMap2 setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConceptMap2 setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConceptMap2 setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConceptMap2 setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConceptMap2 setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConceptMap2 setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ConceptMap2 setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConceptMap2 addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConceptMap2 setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConceptMap2 setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ConceptMap2 setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConceptMap2 addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ConceptMap2 setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConceptMap2 addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ConceptMap2 setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ConceptMap2 setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap2.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ConceptMap2 setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ConceptMap2 setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DataType getSource() {
        return this.source;
    }

    public UriType getSourceUriType() throws FHIRException {
        if (this.source == null) {
            this.source = new UriType();
        }
        if (!(this.source instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (UriType)this.source;
    }

    public boolean hasSourceUriType() {
        return this != null && this.source instanceof UriType;
    }

    public CanonicalType getSourceCanonicalType() throws FHIRException {
        if (this.source == null) {
            this.source = new CanonicalType();
        }
        if (!(this.source instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.source;
    }

    public boolean hasSourceCanonicalType() {
        return this != null && this.source instanceof CanonicalType;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ConceptMap2 setSource(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new Error("Not the right type for ConceptMap2.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public DataType getTarget() {
        return this.target;
    }

    public UriType getTargetUriType() throws FHIRException {
        if (this.target == null) {
            this.target = new UriType();
        }
        if (!(this.target instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (UriType)this.target;
    }

    public boolean hasTargetUriType() {
        return this != null && this.target instanceof UriType;
    }

    public CanonicalType getTargetCanonicalType() throws FHIRException {
        if (this.target == null) {
            this.target = new CanonicalType();
        }
        if (!(this.target instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.target;
    }

    public boolean hasTargetCanonicalType() {
        return this != null && this.target instanceof CanonicalType;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ConceptMap2 setTarget(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new Error("Not the right type for ConceptMap2.target[x]: " + value.fhirType());
        }
        this.target = value;
        return this;
    }

    public List<ConceptMap2GroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<ConceptMap2GroupComponent>();
        }
        return this.group;
    }

    public ConceptMap2 setGroup(List<ConceptMap2GroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (ConceptMap2GroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptMap2GroupComponent addGroup() {
        ConceptMap2GroupComponent t = new ConceptMap2GroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<ConceptMap2GroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public ConceptMap2 addGroup(ConceptMap2GroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<ConceptMap2GroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public ConceptMap2GroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the concept map.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright));
        children.add(new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source));
        children.add(new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target));
        children.add(new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the concept map.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright);
            }
            case -1698413947: {
                return new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -1698419887: {
                return new Property("source[x]", "uri", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case 1509247769: {
                return new Property("source[x]", "canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.", 0, 1, this.source);
            }
            case -815579825: {
                return new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -880905839: {
                return new Property("target[x]", "uri|canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -815585765: {
                return new Property("target[x]", "uri", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case -1281653149: {
                return new Property("target[x]", "canonical(ValueSet)", "The target value set provides context for the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, 1, this.target);
            }
            case 98629247: {
                return new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.source;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.target;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -896505829: {
                this.source = TypeConvertor.castToType(value);
                return value;
            }
            case -880905839: {
                this.target = TypeConvertor.castToType(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((ConceptMap2GroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("source[x]")) {
            this.source = TypeConvertor.castToType(value);
        } else if (name.equals("target[x]")) {
            this.target = TypeConvertor.castToType(value);
        } else if (name.equals("group")) {
            this.getGroup().add((ConceptMap2GroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -815579825: {
                return this.getTarget();
            }
            case -880905839: {
                return this.getTarget();
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -896505829: {
                return new String[]{"uri", "canonical"};
            }
            case -880905839: {
                return new String[]{"uri", "canonical"};
            }
            case 98629247: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.copyright");
        }
        if (name.equals("sourceUri")) {
            this.source = new UriType();
            return this.source;
        }
        if (name.equals("sourceCanonical")) {
            this.source = new CanonicalType();
            return this.source;
        }
        if (name.equals("targetUri")) {
            this.target = new UriType();
            return this.target;
        }
        if (name.equals("targetCanonical")) {
            this.target = new CanonicalType();
            return this.target;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConceptMap2";
    }

    @Override
    public ConceptMap2 copy() {
        ConceptMap2 dst = new ConceptMap2();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ConceptMap2 dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.source = this.source == null ? null : this.source.copy();
        DataType dataType = dst.target = this.target == null ? null : this.target.copy();
        if (this.group != null) {
            dst.group = new ArrayList<ConceptMap2GroupComponent>();
            for (ConceptMap2GroupComponent conceptMap2GroupComponent : this.group) {
                dst.group.add(conceptMap2GroupComponent.copy());
            }
        }
    }

    protected ConceptMap2 typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap2)) {
            return false;
        }
        ConceptMap2 o = (ConceptMap2)other_;
        return ConceptMap2.compareDeep(this.url, o.url, true) && ConceptMap2.compareDeep(this.identifier, o.identifier, true) && ConceptMap2.compareDeep(this.version, o.version, true) && ConceptMap2.compareDeep(this.name, o.name, true) && ConceptMap2.compareDeep(this.title, o.title, true) && ConceptMap2.compareDeep(this.status, o.status, true) && ConceptMap2.compareDeep(this.experimental, o.experimental, true) && ConceptMap2.compareDeep(this.date, o.date, true) && ConceptMap2.compareDeep(this.publisher, o.publisher, true) && ConceptMap2.compareDeep(this.contact, o.contact, true) && ConceptMap2.compareDeep(this.description, o.description, true) && ConceptMap2.compareDeep(this.useContext, o.useContext, true) && ConceptMap2.compareDeep(this.jurisdiction, o.jurisdiction, true) && ConceptMap2.compareDeep(this.purpose, o.purpose, true) && ConceptMap2.compareDeep(this.copyright, o.copyright, true) && ConceptMap2.compareDeep(this.source, o.source, true) && ConceptMap2.compareDeep(this.target, o.target, true) && ConceptMap2.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap2)) {
            return false;
        }
        ConceptMap2 o = (ConceptMap2)other_;
        return ConceptMap2.compareValues(this.url, o.url, true) && ConceptMap2.compareValues(this.version, o.version, true) && ConceptMap2.compareValues(this.name, o.name, true) && ConceptMap2.compareValues(this.title, o.title, true) && ConceptMap2.compareValues(this.status, o.status, true) && ConceptMap2.compareValues(this.experimental, o.experimental, true) && ConceptMap2.compareValues(this.date, o.date, true) && ConceptMap2.compareValues(this.publisher, o.publisher, true) && ConceptMap2.compareValues(this.description, o.description, true) && ConceptMap2.compareValues(this.purpose, o.purpose, true) && ConceptMap2.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.source, this.target, this.group});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap2;
    }

    @Block
    public static class ConceptMap2GroupUnmappedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="provided | fixed | other-map", formalDefinition="Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-unmapped-mode")
        protected Enumeration<Enumerations.ConceptMapGroupUnmappedMode> mode;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code when mode = fixed", formalDefinition="The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code set when mode = fixed", formalDefinition="The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to a each of the fixed codes.")
        protected CanonicalType valueSet;
        @Child(name="url", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="canonical reference to an additional ConceptMap2 to use for mapping if the source concept is unmapped", formalDefinition="The canonical reference to an additional ConceptMap2 resource instance to use for mapping if this ConceptMap2 resource contains no matching mapping for the source concept.")
        protected CanonicalType url;
        private static final long serialVersionUID = -1886028069L;

        public ConceptMap2GroupUnmappedComponent() {
        }

        public ConceptMap2GroupUnmappedComponent(Enumerations.ConceptMapGroupUnmappedMode mode) {
            this.setMode(mode);
        }

        public Enumeration<Enumerations.ConceptMapGroupUnmappedMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupUnmappedComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<Enumerations.ConceptMapGroupUnmappedMode>(new Enumerations.ConceptMapGroupUnmappedModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConceptMap2GroupUnmappedComponent setModeElement(Enumeration<Enumerations.ConceptMapGroupUnmappedMode> value) {
            this.mode = value;
            return this;
        }

        public Enumerations.ConceptMapGroupUnmappedMode getMode() {
            return this.mode == null ? null : (Enumerations.ConceptMapGroupUnmappedMode)((Object)this.mode.getValue());
        }

        public ConceptMap2GroupUnmappedComponent setMode(Enumerations.ConceptMapGroupUnmappedMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<Enumerations.ConceptMapGroupUnmappedMode>(new Enumerations.ConceptMapGroupUnmappedModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupUnmappedComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptMap2GroupUnmappedComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptMap2GroupUnmappedComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupUnmappedComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptMap2GroupUnmappedComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptMap2GroupUnmappedComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupUnmappedComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public ConceptMap2GroupUnmappedComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public ConceptMap2GroupUnmappedComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public CanonicalType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupUnmappedComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new CanonicalType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ConceptMap2GroupUnmappedComponent setUrlElement(CanonicalType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ConceptMap2GroupUnmappedComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new CanonicalType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode));
            children.add(new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to a each of the fixed codes.", 0, 1, this.valueSet));
            children.add(new Property(ConceptMap2.SP_URL, "canonical(ConceptMap2)", "The canonical reference to an additional ConceptMap2 resource instance to use for mapping if this ConceptMap2 resource contains no matching mapping for the source concept.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode);
                }
                case 3059181: {
                    return new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to a each of the fixed codes.", 0, 1, this.valueSet);
                }
                case 116079: {
                    return new Property(ConceptMap2.SP_URL, "canonical(ConceptMap2)", "The canonical reference to an additional ConceptMap2 resource instance to use for mapping if this ConceptMap2 resource contains no matching mapping for the source concept.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new Enumerations.ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new Enumerations.ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals(ConceptMap2.SP_URL)) {
                this.url = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case 116079: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.unmapped.mode");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.unmapped.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.unmapped.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.unmapped.valueSet");
            }
            if (name.equals(ConceptMap2.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.unmapped.url");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMap2GroupUnmappedComponent copy() {
            ConceptMap2GroupUnmappedComponent dst = new ConceptMap2GroupUnmappedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMap2GroupUnmappedComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMap2GroupUnmappedComponent)) {
                return false;
            }
            ConceptMap2GroupUnmappedComponent o = (ConceptMap2GroupUnmappedComponent)other_;
            return ConceptMap2GroupUnmappedComponent.compareDeep(this.mode, o.mode, true) && ConceptMap2GroupUnmappedComponent.compareDeep(this.code, o.code, true) && ConceptMap2GroupUnmappedComponent.compareDeep(this.display, o.display, true) && ConceptMap2GroupUnmappedComponent.compareDeep(this.valueSet, o.valueSet, true) && ConceptMap2GroupUnmappedComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMap2GroupUnmappedComponent)) {
                return false;
            }
            ConceptMap2GroupUnmappedComponent o = (ConceptMap2GroupUnmappedComponent)other_;
            return ConceptMap2GroupUnmappedComponent.compareValues(this.mode, o.mode, true) && ConceptMap2GroupUnmappedComponent.compareValues(this.code, o.code, true) && ConceptMap2GroupUnmappedComponent.compareValues(this.display, o.display, true) && ConceptMap2GroupUnmappedComponent.compareValues(this.valueSet, o.valueSet, true) && ConceptMap2GroupUnmappedComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.code, this.display, this.valueSet, this.url});
        }

        @Override
        public String fhirType() {
            return "ConceptMap2.group.unmapped";
        }
    }

    @Block
    public static class OtherElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to property mapping depends on", formalDefinition="A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.")
        protected UriType property;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class, DecimalType.class, UriType.class, IdType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the referenced property", formalDefinition="Property value that the map depends on.")
        protected DataType value;
        private static final long serialVersionUID = 956155898L;

        public OtherElementComponent() {
        }

        public OtherElementComponent(String property, DataType value) {
            this.setProperty(property);
            this.setValue(value);
        }

        public UriType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new UriType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public OtherElementComponent setPropertyElement(UriType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public OtherElementComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new UriType();
            }
            this.property.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public OtherElementComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeType || value instanceof Coding || value instanceof StringType || value instanceof IntegerType || value instanceof BooleanType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof UriType || value instanceof IdType)) {
                throw new Error("Not the right type for ConceptMap2.group.element.target.dependsOn.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.", 0, 1, this.property));
            children.add(new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal|uri|id", "Property value that the map depends on.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -993141291: {
                    return new Property("property", "uri", "A reference to an element that holds a coded value that corresponds to a code system property. The idea is that the information model carries an element somewhere that is labeled to correspond with a code system property.", 0, 1, this.property);
                }
                case -1410166417: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal|uri|id", "Property value that the map depends on.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal|uri|id", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "Property value that the map depends on.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Property value that the map depends on.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "Property value that the map depends on.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "Property value that the map depends on.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "Property value that the map depends on.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    Base[] baseArray;
                    if (this.property == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.property;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    this.property = TypeConvertor.castToUri(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = TypeConvertor.castToUri(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return this.getPropertyElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return new String[]{"uri"};
                }
                case 111972721: {
                    return new String[]{"code", "Coding", "string", "integer", "boolean", "dateTime", "decimal", "uri", "id"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.dependsOn.property");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public OtherElementComponent copy() {
            OtherElementComponent dst = new OtherElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OtherElementComponent dst) {
            super.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareDeep(this.property, o.property, true) && OtherElementComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareValues(this.property, o.property, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.property, this.value});
        }

        @Override
        public String fhirType() {
            return "ConceptMap2.group.element.target.dependsOn";
        }
    }

    @Block
    public static class TargetElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies the target element", formalDefinition="Identity (code or path) or the element/item that the map refers to.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the set of target elements", formalDefinition="The set of codes being that the map refers to.")
        protected CanonicalType valueSet;
        @Child(name="relationship", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="related-to | equivalent | source-is-narrower-than-target | source-is-broader-than-target | not-related-to", formalDefinition="The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-relationship")
        protected Enumeration<Enumerations.ConceptMapRelationship> relationship;
        @Child(name="comment", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data.")
        protected StringType comment;
        @Child(name="dependsOn", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other elements required for this mapping (from context)", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.")
        protected List<OtherElementComponent> dependsOn;
        @Child(name="product", type={OtherElementComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other concepts that this mapping also produces", formalDefinition="A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the relationship (e.g., equivalent) cannot be relied on.")
        protected List<OtherElementComponent> product;
        private static final long serialVersionUID = 1705844456L;

        public TargetElementComponent() {
        }

        public TargetElementComponent(Enumerations.ConceptMapRelationship relationship) {
            this.setRelationship(relationship);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TargetElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TargetElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public TargetElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public TargetElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public TargetElementComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public TargetElementComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ConceptMapRelationship> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public TargetElementComponent setRelationshipElement(Enumeration<Enumerations.ConceptMapRelationship> value) {
            this.relationship = value;
            return this;
        }

        public Enumerations.ConceptMapRelationship getRelationship() {
            return this.relationship == null ? null : (Enumerations.ConceptMapRelationship)((Object)this.relationship.getValue());
        }

        public TargetElementComponent setRelationship(Enumerations.ConceptMapRelationship value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public TargetElementComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public TargetElementComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<OtherElementComponent> getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            return this.dependsOn;
        }

        public TargetElementComponent setDependsOn(List<OtherElementComponent> theDependsOn) {
            this.dependsOn = theDependsOn;
            return this;
        }

        public boolean hasDependsOn() {
            if (this.dependsOn == null) {
                return false;
            }
            for (OtherElementComponent item : this.dependsOn) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addDependsOn() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return t;
        }

        public TargetElementComponent addDependsOn(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return this;
        }

        public OtherElementComponent getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<OtherElementComponent> getProduct() {
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            return this.product;
        }

        public TargetElementComponent setProduct(List<OtherElementComponent> theProduct) {
            this.product = theProduct;
            return this;
        }

        public boolean hasProduct() {
            if (this.product == null) {
                return false;
            }
            for (OtherElementComponent item : this.product) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addProduct() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return t;
        }

        public TargetElementComponent addProduct(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return this;
        }

        public OtherElementComponent getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                this.addProduct();
            }
            return this.getProduct().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of codes being that the map refers to.", 0, 1, this.valueSet));
            children.add(new Property("relationship", "code", "The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).", 0, 1, this.relationship));
            children.add(new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment));
            children.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            children.add(new Property(ConceptMap2.SP_PRODUCT, "@ConceptMap2.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the relationship (e.g., equivalent) cannot be relied on.", 0, Integer.MAX_VALUE, this.product));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of codes being that the map refers to.", 0, 1, this.valueSet);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).", 0, 1, this.relationship);
                }
                case 950398559: {
                    return new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment);
                }
                case -1109214266: {
                    return new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn);
                }
                case -309474065: {
                    return new Property(ConceptMap2.SP_PRODUCT, "@ConceptMap2.group.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the relationship (e.g., equivalent) cannot be relied on.", 0, Integer.MAX_VALUE, this.product);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.relationship;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.comment;
                    }
                    return baseArray;
                }
                case -1109214266: {
                    return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
                }
                case -309474065: {
                    return this.product == null ? new Base[]{} : this.product.toArray(new Base[this.product.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -261851592: {
                    value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
                case -1109214266: {
                    this.getDependsOn().add((OtherElementComponent)((Object)value));
                    return value;
                }
                case -309474065: {
                    this.getProduct().add((OtherElementComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("relationship")) {
                value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().add((OtherElementComponent)((Object)value));
            } else if (name.equals(ConceptMap2.SP_PRODUCT)) {
                this.getProduct().add((OtherElementComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -1109214266: {
                    return this.addDependsOn();
                }
                case -309474065: {
                    return this.addProduct();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -1109214266: {
                    return new String[0];
                }
                case -309474065: {
                    return new String[]{"@ConceptMap2.group.element.target.dependsOn"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.valueSet");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.relationship");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.target.comment");
            }
            if (name.equals("dependsOn")) {
                return this.addDependsOn();
            }
            if (name.equals(ConceptMap2.SP_PRODUCT)) {
                return this.addProduct();
            }
            return super.addChild(name);
        }

        @Override
        public TargetElementComponent copy() {
            TargetElementComponent dst = new TargetElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TargetElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.dependsOn != null) {
                dst.dependsOn = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.dependsOn) {
                    dst.dependsOn.add(i.copy());
                }
            }
            if (this.product != null) {
                dst.product = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.product) {
                    dst.product.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareDeep(this.code, o.code, true) && TargetElementComponent.compareDeep(this.display, o.display, true) && TargetElementComponent.compareDeep(this.valueSet, o.valueSet, true) && TargetElementComponent.compareDeep(this.relationship, o.relationship, true) && TargetElementComponent.compareDeep(this.comment, o.comment, true) && TargetElementComponent.compareDeep(this.dependsOn, o.dependsOn, true) && TargetElementComponent.compareDeep(this.product, o.product, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareValues(this.code, o.code, true) && TargetElementComponent.compareValues(this.display, o.display, true) && TargetElementComponent.compareValues(this.valueSet, o.valueSet, true) && TargetElementComponent.compareValues(this.relationship, o.relationship, true) && TargetElementComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.valueSet, this.relationship, this.comment, this.dependsOn, this.product});
        }

        @Override
        public String fhirType() {
            return "ConceptMap2.group.element.target";
        }
    }

    @Block
    public static class SourceElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies element being mapped", formalDefinition="Identity (code or path) or the element/item being mapped.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies elements being mapped", formalDefinition="The set of codes being mapped.")
        protected CanonicalType valueSet;
        @Child(name="noMap", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="No mapping to a target concept for this source concept", formalDefinition="If noMap = true this indicates that no mapping to a target concept exists for this source concept.")
        protected BooleanType noMap;
        @Child(name="target", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept in target system for element", formalDefinition="A concept from the target value set that this concept maps to.")
        protected List<TargetElementComponent> target;
        private static final long serialVersionUID = 1485743554L;

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SourceElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public SourceElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public SourceElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public SourceElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public SourceElementComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public SourceElementComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public BooleanType getNoMapElement() {
            if (this.noMap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.noMap");
                }
                if (Configuration.doAutoCreate()) {
                    this.noMap = new BooleanType();
                }
            }
            return this.noMap;
        }

        public boolean hasNoMapElement() {
            return this.noMap != null && !this.noMap.isEmpty();
        }

        public boolean hasNoMap() {
            return this.noMap != null && !this.noMap.isEmpty();
        }

        public SourceElementComponent setNoMapElement(BooleanType value) {
            this.noMap = value;
            return this;
        }

        public boolean getNoMap() {
            return this.noMap == null || this.noMap.isEmpty() ? false : (Boolean)this.noMap.getValue();
        }

        public SourceElementComponent setNoMap(boolean value) {
            if (this.noMap == null) {
                this.noMap = new BooleanType();
            }
            this.noMap.setValue((Object)value);
            return this;
        }

        public List<TargetElementComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            return this.target;
        }

        public SourceElementComponent setTarget(List<TargetElementComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (TargetElementComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget() {
            TargetElementComponent t = new TargetElementComponent();
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return t;
        }

        public SourceElementComponent addTarget(TargetElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return this;
        }

        public TargetElementComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of codes being mapped.", 0, 1, this.valueSet));
            children.add(new Property("noMap", "boolean", "If noMap = true this indicates that no mapping to a target concept exists for this source concept.", 0, 1, this.noMap));
            children.add(new Property(ConceptMap2.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of codes being mapped.", 0, 1, this.valueSet);
                }
                case 104971227: {
                    return new Property("noMap", "boolean", "If noMap = true this indicates that no mapping to a target concept exists for this source concept.", 0, 1, this.noMap);
                }
                case -880905839: {
                    return new Property(ConceptMap2.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case 104971227: {
                    Base[] baseArray;
                    if (this.noMap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.noMap;
                    }
                    return baseArray;
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 104971227: {
                    this.noMap = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((TargetElementComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("noMap")) {
                this.noMap = TypeConvertor.castToBoolean(value);
            } else if (name.equals(ConceptMap2.SP_TARGET)) {
                this.getTarget().add((TargetElementComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case 104971227: {
                    return this.getNoMapElement();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case 104971227: {
                    return new String[]{"boolean"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.valueSet");
            }
            if (name.equals("noMap")) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.element.noMap");
            }
            if (name.equals(ConceptMap2.SP_TARGET)) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public SourceElementComponent copy() {
            SourceElementComponent dst = new SourceElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SourceElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            BooleanType booleanType = dst.noMap = this.noMap == null ? null : this.noMap.copy();
            if (this.target != null) {
                dst.target = new ArrayList<TargetElementComponent>();
                for (TargetElementComponent i : this.target) {
                    dst.target.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareDeep(this.code, o.code, true) && SourceElementComponent.compareDeep(this.display, o.display, true) && SourceElementComponent.compareDeep(this.valueSet, o.valueSet, true) && SourceElementComponent.compareDeep(this.noMap, o.noMap, true) && SourceElementComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareValues(this.code, o.code, true) && SourceElementComponent.compareValues(this.display, o.display, true) && SourceElementComponent.compareValues(this.valueSet, o.valueSet, true) && SourceElementComponent.compareValues(this.noMap, o.noMap, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.valueSet, this.noMap, this.target});
        }

        @Override
        public String fhirType() {
            return "ConceptMap2.group.element";
        }
    }

    @Block
    public static class ConceptMap2GroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source system where concepts to be mapped are defined", formalDefinition="An absolute URI that identifies the source system where the concepts to be mapped are defined.")
        protected CanonicalType source;
        @Child(name="target", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Target system that the concepts are to be mapped to", formalDefinition="An absolute URI that identifies the target system that the concepts will be mapped to.")
        protected CanonicalType target;
        @Child(name="element", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Mappings for a concept from the source set", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target.")
        protected List<SourceElementComponent> element;
        @Child(name="unmapped", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What to do when there is no mapping target for the source concept", formalDefinition="What to do when there is no mapping to a target concept from the source concept.  This provides the \"default\" to be applied when there is no target concept mapping specified.  The 'unmapped' element is ignored if a code is specified to have relationship = not-related-to.")
        protected ConceptMap2GroupUnmappedComponent unmapped;
        private static final long serialVersionUID = -421651506L;

        public ConceptMap2GroupComponent() {
        }

        public ConceptMap2GroupComponent(SourceElementComponent element) {
            this.addElement(element);
        }

        public CanonicalType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CanonicalType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ConceptMap2GroupComponent setSourceElement(CanonicalType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ConceptMap2GroupComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new CanonicalType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public CanonicalType getTargetElement() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new CanonicalType();
                }
            }
            return this.target;
        }

        public boolean hasTargetElement() {
            return this.target != null && !this.target.isEmpty();
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ConceptMap2GroupComponent setTargetElement(CanonicalType value) {
            this.target = value;
            return this;
        }

        public String getTarget() {
            return this.target == null ? null : (String)this.target.getValue();
        }

        public ConceptMap2GroupComponent setTarget(String value) {
            if (Utilities.noString((String)value)) {
                this.target = null;
            } else {
                if (this.target == null) {
                    this.target = new CanonicalType();
                }
                this.target.setValue(value);
            }
            return this;
        }

        public List<SourceElementComponent> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            return this.element;
        }

        public ConceptMap2GroupComponent setElement(List<SourceElementComponent> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (SourceElementComponent item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SourceElementComponent addElement() {
            SourceElementComponent t = new SourceElementComponent();
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return t;
        }

        public ConceptMap2GroupComponent addElement(SourceElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return this;
        }

        public SourceElementComponent getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        public ConceptMap2GroupUnmappedComponent getUnmapped() {
            if (this.unmapped == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMap2GroupComponent.unmapped");
                }
                if (Configuration.doAutoCreate()) {
                    this.unmapped = new ConceptMap2GroupUnmappedComponent();
                }
            }
            return this.unmapped;
        }

        public boolean hasUnmapped() {
            return this.unmapped != null && !this.unmapped.isEmpty();
        }

        public ConceptMap2GroupComponent setUnmapped(ConceptMap2GroupUnmappedComponent value) {
            this.unmapped = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ConceptMap2.SP_SOURCE, "canonical(CodeSystem)", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source));
            children.add(new Property(ConceptMap2.SP_TARGET, "canonical(CodeSystem)", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target));
            children.add(new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element));
            children.add(new Property("unmapped", "", "What to do when there is no mapping to a target concept from the source concept.  This provides the \"default\" to be applied when there is no target concept mapping specified.  The 'unmapped' element is ignored if a code is specified to have relationship = not-related-to.", 0, 1, this.unmapped));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property(ConceptMap2.SP_SOURCE, "canonical(CodeSystem)", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source);
                }
                case -880905839: {
                    return new Property(ConceptMap2.SP_TARGET, "canonical(CodeSystem)", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target);
                }
                case -1662836996: {
                    return new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element);
                }
                case -194857460: {
                    return new Property("unmapped", "", "What to do when there is no mapping to a target concept from the source concept.  This provides the \"default\" to be applied when there is no target concept mapping specified.  The 'unmapped' element is ignored if a code is specified to have relationship = not-related-to.", 0, 1, this.unmapped);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
                case -194857460: {
                    Base[] baseArray;
                    if (this.unmapped == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unmapped;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1662836996: {
                    this.getElement().add((SourceElementComponent)value);
                    return value;
                }
                case -194857460: {
                    this.unmapped = (ConceptMap2GroupUnmappedComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ConceptMap2.SP_SOURCE)) {
                this.source = TypeConvertor.castToCanonical(value);
            } else if (name.equals(ConceptMap2.SP_TARGET)) {
                this.target = TypeConvertor.castToCanonical(value);
            } else if (name.equals("element")) {
                this.getElement().add((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMap2GroupUnmappedComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case -880905839: {
                    return this.getTargetElement();
                }
                case -1662836996: {
                    return this.addElement();
                }
                case -194857460: {
                    return this.getUnmapped();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"canonical"};
                }
                case -880905839: {
                    return new String[]{"canonical"};
                }
                case -1662836996: {
                    return new String[0];
                }
                case -194857460: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ConceptMap2.SP_SOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.source");
            }
            if (name.equals(ConceptMap2.SP_TARGET)) {
                throw new FHIRException("Cannot call addChild on a primitive type ConceptMap2.group.target");
            }
            if (name.equals("element")) {
                return this.addElement();
            }
            if (name.equals("unmapped")) {
                this.unmapped = new ConceptMap2GroupUnmappedComponent();
                return this.unmapped;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMap2GroupComponent copy() {
            ConceptMap2GroupComponent dst = new ConceptMap2GroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMap2GroupComponent dst) {
            super.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            CanonicalType canonicalType = dst.target = this.target == null ? null : this.target.copy();
            if (this.element != null) {
                dst.element = new ArrayList<SourceElementComponent>();
                for (SourceElementComponent i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            dst.unmapped = this.unmapped == null ? null : this.unmapped.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMap2GroupComponent)) {
                return false;
            }
            ConceptMap2GroupComponent o = (ConceptMap2GroupComponent)other_;
            return ConceptMap2GroupComponent.compareDeep(this.source, o.source, true) && ConceptMap2GroupComponent.compareDeep(this.target, o.target, true) && ConceptMap2GroupComponent.compareDeep(this.element, o.element, true) && ConceptMap2GroupComponent.compareDeep(this.unmapped, o.unmapped, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMap2GroupComponent)) {
                return false;
            }
            ConceptMap2GroupComponent o = (ConceptMap2GroupComponent)other_;
            return ConceptMap2GroupComponent.compareValues(this.source, o.source, true) && ConceptMap2GroupComponent.compareValues(this.target, o.target, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.source, this.target, this.element, this.unmapped});
        }

        @Override
        public String fhirType() {
            return "ConceptMap2.group";
        }
    }
}

