/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingSelection", profile="http://hl7.org/fhir/StructureDefinition/ImagingSelection")
public class ImagingSelection
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for Imaging Selection", formalDefinition="A unique identifier assigned to this imaging selection.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class, Appointment.class, AppointmentResponse.class, Task.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Associated request", formalDefinition="A list of the diagnostic requests that resulted in this imaging selection being performed.")
    protected List<Reference> basedOn;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, Specimen.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject of the selected instances and / or frames", formalDefinition="The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.")
    protected Reference subject;
    @Child(name="issued", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date / Time when the selection of instances was made", formalDefinition="The date and time this imaging selection was created.")
    protected InstantType issued;
    @Child(name="performer", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Author (human or machine)", formalDefinition="Author \u2013 human or machine.")
    protected List<ImagingSelectionPerformerComponent> performer;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging Selection description text or code", formalDefinition="Describes the imaging selection.")
    @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7010.html")
    protected CodeableConcept code;
    @Child(name="studyUid", type={OidType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DICOM Study Instance UID", formalDefinition="The Study Instance UID for the DICOM Study from which the images were selected.")
    protected OidType studyUid;
    @Child(name="derivedFrom", type={ImagingStudy.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The imaging study from which the imaging selection is derived", formalDefinition="The imaging study from which the imaging selection is made.")
    protected List<Reference> derivedFrom;
    @Child(name="endpoint", type={Endpoint.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The network service providing retrieval for the images referenced in the imaging selection", formalDefinition="The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.")
    protected List<Reference> endpoint;
    @Child(name="seriesUid", type={OidType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DICOM Series Instance UID", formalDefinition="The Series Instance UID for the DICOM Series from which the images were selected.")
    protected OidType seriesUid;
    @Child(name="frameOfReferenceUid", type={OidType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Frame of Reference UID for the selected images", formalDefinition="The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.")
    protected OidType frameOfReferenceUid;
    @Child(name="bodySite", type={Coding.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body part examined", formalDefinition="The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected Coding bodySite;
    @Child(name="instance", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The selected instances", formalDefinition="Each imaging selection includes one or more selected DICOM SOP instances.")
    protected List<ImagingSelectionInstanceComponent> instance;
    @Child(name="imageRegion", type={}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A specific region in a DICOM image / frame", formalDefinition="Each imaging selection might includes one or more image regions. Image regions are specified by a region type and a set of 2D or 3D coordinates.")
    protected ImagingSelectionImageRegionComponent imageRegion;
    private static final long serialVersionUID = 4408161L;
    @SearchParamDefinition(name="based-on", path="ImagingSelection.basedOn", description="The request associated with an imaging selection", type="reference", target={Appointment.class, AppointmentResponse.class, CarePlan.class, ServiceRequest.class, Task.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("ImagingSelection:based-on").toLocked();
    @SearchParamDefinition(name="body-site", path="ImagingSelection.bodySite", description="The body site associated with the imaging selection", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="code", path="ImagingSelection.code", description="The imaging selection description text or code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="derived-from", path="ImagingSelection.derivedFrom", description="The imaging study from which the imaging selection was derived", type="reference", target={ImagingStudy.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ImagingSelection:derived-from").toLocked();
    @SearchParamDefinition(name="identifier", path="ImagingSelection.identifier", description="Identifiers for the imaging selection", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="issued", path="ImagingSelection.issued", description="The date / time the imaging selection was created", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="patient", path="ImagingSelection.subject.where(resolve() is Patient)", description="Who the study is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Specimen.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingSelection:patient").toLocked();
    @SearchParamDefinition(name="study-uid", path="ImagingSelection.studyUid", description="The DICOM Study Instance UID from which the images were selected", type="uri")
    public static final String SP_STUDY_UID = "study-uid";
    public static final UriClientParam STUDY_UID = new UriClientParam("study-uid");
    @SearchParamDefinition(name="subject", path="ImagingSelection.subject", description="The subject of the Imaging Selection, such as the associated Patient", type="reference", target={Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Specimen.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ImagingSelection:subject").toLocked();

    public ImagingSelection() {
    }

    public ImagingSelection(CodeableConcept code) {
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImagingSelection setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImagingSelection addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ImagingSelection setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ImagingSelection addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ImagingSelection setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public ImagingSelection setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public ImagingSelection setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<ImagingSelectionPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        return this.performer;
    }

    public ImagingSelection setPerformer(List<ImagingSelectionPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ImagingSelectionPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingSelectionPerformerComponent addPerformer() {
        ImagingSelectionPerformerComponent t = new ImagingSelectionPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public ImagingSelection addPerformer(ImagingSelectionPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ImagingSelectionPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ImagingSelection setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public OidType getStudyUidElement() {
        if (this.studyUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.studyUid");
            }
            if (Configuration.doAutoCreate()) {
                this.studyUid = new OidType();
            }
        }
        return this.studyUid;
    }

    public boolean hasStudyUidElement() {
        return this.studyUid != null && !this.studyUid.isEmpty();
    }

    public boolean hasStudyUid() {
        return this.studyUid != null && !this.studyUid.isEmpty();
    }

    public ImagingSelection setStudyUidElement(OidType value) {
        this.studyUid = value;
        return this;
    }

    public String getStudyUid() {
        return this.studyUid == null ? null : (String)this.studyUid.getValue();
    }

    public ImagingSelection setStudyUid(String value) {
        if (Utilities.noString((String)value)) {
            this.studyUid = null;
        } else {
            if (this.studyUid == null) {
                this.studyUid = new OidType();
            }
            this.studyUid.setValue(value);
        }
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public ImagingSelection setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public ImagingSelection addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public ImagingSelection setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public ImagingSelection addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    public OidType getSeriesUidElement() {
        if (this.seriesUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.seriesUid");
            }
            if (Configuration.doAutoCreate()) {
                this.seriesUid = new OidType();
            }
        }
        return this.seriesUid;
    }

    public boolean hasSeriesUidElement() {
        return this.seriesUid != null && !this.seriesUid.isEmpty();
    }

    public boolean hasSeriesUid() {
        return this.seriesUid != null && !this.seriesUid.isEmpty();
    }

    public ImagingSelection setSeriesUidElement(OidType value) {
        this.seriesUid = value;
        return this;
    }

    public String getSeriesUid() {
        return this.seriesUid == null ? null : (String)this.seriesUid.getValue();
    }

    public ImagingSelection setSeriesUid(String value) {
        if (Utilities.noString((String)value)) {
            this.seriesUid = null;
        } else {
            if (this.seriesUid == null) {
                this.seriesUid = new OidType();
            }
            this.seriesUid.setValue(value);
        }
        return this;
    }

    public OidType getFrameOfReferenceUidElement() {
        if (this.frameOfReferenceUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.frameOfReferenceUid");
            }
            if (Configuration.doAutoCreate()) {
                this.frameOfReferenceUid = new OidType();
            }
        }
        return this.frameOfReferenceUid;
    }

    public boolean hasFrameOfReferenceUidElement() {
        return this.frameOfReferenceUid != null && !this.frameOfReferenceUid.isEmpty();
    }

    public boolean hasFrameOfReferenceUid() {
        return this.frameOfReferenceUid != null && !this.frameOfReferenceUid.isEmpty();
    }

    public ImagingSelection setFrameOfReferenceUidElement(OidType value) {
        this.frameOfReferenceUid = value;
        return this;
    }

    public String getFrameOfReferenceUid() {
        return this.frameOfReferenceUid == null ? null : (String)this.frameOfReferenceUid.getValue();
    }

    public ImagingSelection setFrameOfReferenceUid(String value) {
        if (Utilities.noString((String)value)) {
            this.frameOfReferenceUid = null;
        } else {
            if (this.frameOfReferenceUid == null) {
                this.frameOfReferenceUid = new OidType();
            }
            this.frameOfReferenceUid.setValue(value);
        }
        return this;
    }

    public Coding getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new Coding();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public ImagingSelection setBodySite(Coding value) {
        this.bodySite = value;
        return this;
    }

    public List<ImagingSelectionInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        return this.instance;
    }

    public ImagingSelection setInstance(List<ImagingSelectionInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (ImagingSelectionInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingSelectionInstanceComponent addInstance() {
        ImagingSelectionInstanceComponent t = new ImagingSelectionInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public ImagingSelection addInstance(ImagingSelectionInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public ImagingSelectionInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public ImagingSelectionImageRegionComponent getImageRegion() {
        if (this.imageRegion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.imageRegion");
            }
            if (Configuration.doAutoCreate()) {
                this.imageRegion = new ImagingSelectionImageRegionComponent();
            }
        }
        return this.imageRegion;
    }

    public boolean hasImageRegion() {
        return this.imageRegion != null && !this.imageRegion.isEmpty();
    }

    public ImagingSelection setImageRegion(ImagingSelectionImageRegionComponent value) {
        this.imageRegion = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this imaging selection.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging selection being performed.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|Specimen)", "The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.", 0, 1, this.subject));
        children.add(new Property(SP_ISSUED, "instant", "The date and time this imaging selection was created.", 0, 1, this.issued));
        children.add(new Property("performer", "", "Author \u2013 human or machine.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property(SP_CODE, "CodeableConcept", "Describes the imaging selection.", 0, 1, this.code));
        children.add(new Property("studyUid", "oid", "The Study Instance UID for the DICOM Study from which the images were selected.", 0, 1, this.studyUid));
        children.add(new Property("derivedFrom", "Reference(ImagingStudy)", "The imaging study from which the imaging selection is made.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("endpoint", "Reference(Endpoint)", "The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("seriesUid", "oid", "The Series Instance UID for the DICOM Series from which the images were selected.", 0, 1, this.seriesUid));
        children.add(new Property("frameOfReferenceUid", "oid", "The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.", 0, 1, this.frameOfReferenceUid));
        children.add(new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.", 0, 1, this.bodySite));
        children.add(new Property("instance", "", "Each imaging selection includes one or more selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("imageRegion", "", "Each imaging selection might includes one or more image regions. Image regions are specified by a region type and a set of 2D or 3D coordinates.", 0, 1, this.imageRegion));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this imaging selection.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging selection being performed.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|Specimen)", "The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.", 0, 1, this.subject);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "instant", "The date and time this imaging selection was created.", 0, 1, this.issued);
            }
            case 481140686: {
                return new Property("performer", "", "Author \u2013 human or machine.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Describes the imaging selection.", 0, 1, this.code);
            }
            case 1876590023: {
                return new Property("studyUid", "oid", "The Study Instance UID for the DICOM Study from which the images were selected.", 0, 1, this.studyUid);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(ImagingStudy)", "The imaging study from which the imaging selection is made.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 1741102485: {
                return new Property("endpoint", "Reference(Endpoint)", "The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case -569596327: {
                return new Property("seriesUid", "oid", "The Series Instance UID for the DICOM Series from which the images were selected.", 0, 1, this.seriesUid);
            }
            case 828378953: {
                return new Property("frameOfReferenceUid", "oid", "The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.", 0, 1, this.frameOfReferenceUid);
            }
            case 1702620169: {
                return new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.", 0, 1, this.bodySite);
            }
            case 555127957: {
                return new Property("instance", "", "Each imaging selection includes one or more selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance);
            }
            case 2132544559: {
                return new Property("imageRegion", "", "Each imaging selection might includes one or more image regions. Image regions are specified by a region type and a set of 2D or 3D coordinates.", 0, 1, this.imageRegion);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case 1876590023: {
                Base[] baseArray;
                if (this.studyUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.studyUid;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case -569596327: {
                Base[] baseArray;
                if (this.seriesUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.seriesUid;
                }
                return baseArray;
            }
            case 828378953: {
                Base[] baseArray;
                if (this.frameOfReferenceUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.frameOfReferenceUid;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.bodySite;
                }
                return baseArray;
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case 2132544559: {
                Base[] baseArray;
                if (this.imageRegion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.imageRegion;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -1179159893: {
                this.issued = TypeConvertor.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ImagingSelectionPerformerComponent)value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1876590023: {
                this.studyUid = TypeConvertor.castToOid(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -569596327: {
                this.seriesUid = TypeConvertor.castToOid(value);
                return value;
            }
            case 828378953: {
                this.frameOfReferenceUid = TypeConvertor.castToOid(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCoding(value);
                return value;
            }
            case 555127957: {
                this.getInstance().add((ImagingSelectionInstanceComponent)value);
                return value;
            }
            case 2132544559: {
                this.imageRegion = (ImagingSelectionImageRegionComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = TypeConvertor.castToInstant(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add((ImagingSelectionPerformerComponent)value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("studyUid")) {
            this.studyUid = TypeConvertor.castToOid(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("endpoint")) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else if (name.equals("seriesUid")) {
            this.seriesUid = TypeConvertor.castToOid(value);
        } else if (name.equals("frameOfReferenceUid")) {
            this.frameOfReferenceUid = TypeConvertor.castToOid(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCoding(value);
        } else if (name.equals("instance")) {
            this.getInstance().add((ImagingSelectionInstanceComponent)value);
        } else if (name.equals("imageRegion")) {
            this.imageRegion = (ImagingSelectionImageRegionComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1876590023: {
                return this.getStudyUidElement();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case -569596327: {
                return this.getSeriesUidElement();
            }
            case 828378953: {
                return this.getFrameOfReferenceUidElement();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 555127957: {
                return this.addInstance();
            }
            case 2132544559: {
                return this.getImageRegion();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[0];
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1876590023: {
                return new String[]{"oid"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case -569596327: {
                return new String[]{"oid"};
            }
            case 828378953: {
                return new String[]{"oid"};
            }
            case 1702620169: {
                return new String[]{"Coding"};
            }
            case 555127957: {
                return new String[0];
            }
            case 2132544559: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.issued");
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("studyUid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.studyUid");
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("endpoint")) {
            return this.addEndpoint();
        }
        if (name.equals("seriesUid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.seriesUid");
        }
        if (name.equals("frameOfReferenceUid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.frameOfReferenceUid");
        }
        if (name.equals("bodySite")) {
            this.bodySite = new Coding();
            return this.bodySite;
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("imageRegion")) {
            this.imageRegion = new ImagingSelectionImageRegionComponent();
            return this.imageRegion;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingSelection";
    }

    @Override
    public ImagingSelection copy() {
        ImagingSelection dst = new ImagingSelection();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImagingSelection dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ImagingSelectionPerformerComponent>();
            for (ImagingSelectionPerformerComponent imagingSelectionPerformerComponent : this.performer) {
                dst.performer.add(imagingSelectionPerformerComponent.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        OidType oidType = dst.studyUid = this.studyUid == null ? null : this.studyUid.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference : this.derivedFrom) {
                dst.derivedFrom.add(reference.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference : this.endpoint) {
                dst.endpoint.add(reference.copy());
            }
        }
        dst.seriesUid = this.seriesUid == null ? null : this.seriesUid.copy();
        dst.frameOfReferenceUid = this.frameOfReferenceUid == null ? null : this.frameOfReferenceUid.copy();
        Coding coding = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        if (this.instance != null) {
            dst.instance = new ArrayList<ImagingSelectionInstanceComponent>();
            for (ImagingSelectionInstanceComponent imagingSelectionInstanceComponent : this.instance) {
                dst.instance.add(imagingSelectionInstanceComponent.copy());
            }
        }
        dst.imageRegion = this.imageRegion == null ? null : this.imageRegion.copy();
    }

    protected ImagingSelection typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingSelection)) {
            return false;
        }
        ImagingSelection o = (ImagingSelection)other_;
        return ImagingSelection.compareDeep(this.identifier, o.identifier, true) && ImagingSelection.compareDeep(this.basedOn, o.basedOn, true) && ImagingSelection.compareDeep(this.subject, o.subject, true) && ImagingSelection.compareDeep(this.issued, o.issued, true) && ImagingSelection.compareDeep(this.performer, o.performer, true) && ImagingSelection.compareDeep(this.code, o.code, true) && ImagingSelection.compareDeep(this.studyUid, o.studyUid, true) && ImagingSelection.compareDeep(this.derivedFrom, o.derivedFrom, true) && ImagingSelection.compareDeep(this.endpoint, o.endpoint, true) && ImagingSelection.compareDeep(this.seriesUid, o.seriesUid, true) && ImagingSelection.compareDeep(this.frameOfReferenceUid, o.frameOfReferenceUid, true) && ImagingSelection.compareDeep(this.bodySite, o.bodySite, true) && ImagingSelection.compareDeep(this.instance, o.instance, true) && ImagingSelection.compareDeep(this.imageRegion, o.imageRegion, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingSelection)) {
            return false;
        }
        ImagingSelection o = (ImagingSelection)other_;
        return ImagingSelection.compareValues(this.issued, o.issued, true) && ImagingSelection.compareValues(this.studyUid, o.studyUid, true) && ImagingSelection.compareValues(this.seriesUid, o.seriesUid, true) && ImagingSelection.compareValues(this.frameOfReferenceUid, o.frameOfReferenceUid, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.subject, this.issued, this.performer, this.code, this.studyUid, this.derivedFrom, this.endpoint, this.seriesUid, this.frameOfReferenceUid, this.bodySite, this.instance, this.imageRegion});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingSelection;
    }

    @Block
    public static class ImagingSelectionImageRegionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regionType", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="POINT | MULTIPOINT | POLYLINE | POLYGON | ELLIPSE | ELLIPSOID", formalDefinition="Specifies the type of image region.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingselection-graphictype")
        protected Enumeration<ImagingSelectionGraphicType> regionType;
        @Child(name="coordinateType", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="2d | 3d", formalDefinition="Specifies the type of coordinate system that define the image region.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingselection-coordinatetype")
        protected Enumeration<ImagingSelectionCoordinateType> coordinateType;
        @Child(name="coordinates", type={DecimalType.class}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the type of coordinates that define the image region 2d | 3d", formalDefinition="The coordinates describing the image region.       If coordinateType is 2D this specifies sequence of (x,y) coordinates in the coordinate system of the image specified by the instance.uid element that contains this image region.       If coordinateType is 3D this specifies sequence of (x,y,z) coordinates in the coordinate system specified by the frameOfReferenceUid element.")
        protected List<DecimalType> coordinates;
        private static final long serialVersionUID = -1266111852L;

        public ImagingSelectionImageRegionComponent() {
        }

        public ImagingSelectionImageRegionComponent(ImagingSelectionGraphicType regionType, ImagingSelectionCoordinateType coordinateType, BigDecimal coordinates) {
            this.setRegionType(regionType);
            this.setCoordinateType(coordinateType);
            this.addCoordinates(coordinates);
        }

        public Enumeration<ImagingSelectionGraphicType> getRegionTypeElement() {
            if (this.regionType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionImageRegionComponent.regionType");
                }
                if (Configuration.doAutoCreate()) {
                    this.regionType = new Enumeration<ImagingSelectionGraphicType>(new ImagingSelectionGraphicTypeEnumFactory());
                }
            }
            return this.regionType;
        }

        public boolean hasRegionTypeElement() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public boolean hasRegionType() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public ImagingSelectionImageRegionComponent setRegionTypeElement(Enumeration<ImagingSelectionGraphicType> value) {
            this.regionType = value;
            return this;
        }

        public ImagingSelectionGraphicType getRegionType() {
            return this.regionType == null ? null : (ImagingSelectionGraphicType)((Object)this.regionType.getValue());
        }

        public ImagingSelectionImageRegionComponent setRegionType(ImagingSelectionGraphicType value) {
            if (this.regionType == null) {
                this.regionType = new Enumeration<ImagingSelectionGraphicType>(new ImagingSelectionGraphicTypeEnumFactory());
            }
            this.regionType.setValue((Object)value);
            return this;
        }

        public Enumeration<ImagingSelectionCoordinateType> getCoordinateTypeElement() {
            if (this.coordinateType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionImageRegionComponent.coordinateType");
                }
                if (Configuration.doAutoCreate()) {
                    this.coordinateType = new Enumeration<ImagingSelectionCoordinateType>(new ImagingSelectionCoordinateTypeEnumFactory());
                }
            }
            return this.coordinateType;
        }

        public boolean hasCoordinateTypeElement() {
            return this.coordinateType != null && !this.coordinateType.isEmpty();
        }

        public boolean hasCoordinateType() {
            return this.coordinateType != null && !this.coordinateType.isEmpty();
        }

        public ImagingSelectionImageRegionComponent setCoordinateTypeElement(Enumeration<ImagingSelectionCoordinateType> value) {
            this.coordinateType = value;
            return this;
        }

        public ImagingSelectionCoordinateType getCoordinateType() {
            return this.coordinateType == null ? null : (ImagingSelectionCoordinateType)((Object)this.coordinateType.getValue());
        }

        public ImagingSelectionImageRegionComponent setCoordinateType(ImagingSelectionCoordinateType value) {
            if (this.coordinateType == null) {
                this.coordinateType = new Enumeration<ImagingSelectionCoordinateType>(new ImagingSelectionCoordinateTypeEnumFactory());
            }
            this.coordinateType.setValue((Object)value);
            return this;
        }

        public List<DecimalType> getCoordinates() {
            if (this.coordinates == null) {
                this.coordinates = new ArrayList<DecimalType>();
            }
            return this.coordinates;
        }

        public ImagingSelectionImageRegionComponent setCoordinates(List<DecimalType> theCoordinates) {
            this.coordinates = theCoordinates;
            return this;
        }

        public boolean hasCoordinates() {
            if (this.coordinates == null) {
                return false;
            }
            for (DecimalType item : this.coordinates) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addCoordinatesElement() {
            DecimalType t = new DecimalType();
            if (this.coordinates == null) {
                this.coordinates = new ArrayList<DecimalType>();
            }
            this.coordinates.add(t);
            return t;
        }

        public ImagingSelectionImageRegionComponent addCoordinates(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.coordinates == null) {
                this.coordinates = new ArrayList<DecimalType>();
            }
            this.coordinates.add(t);
            return this;
        }

        public boolean hasCoordinates(BigDecimal value) {
            if (this.coordinates == null) {
                return false;
            }
            for (DecimalType v : this.coordinates) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType));
            children.add(new Property("coordinateType", ImagingSelection.SP_CODE, "Specifies the type of coordinate system that define the image region.", 0, 1, this.coordinateType));
            children.add(new Property("coordinates", "decimal", "The coordinates describing the image region.       If coordinateType is 2D this specifies sequence of (x,y) coordinates in the coordinate system of the image specified by the instance.uid element that contains this image region.       If coordinateType is 3D this specifies sequence of (x,y,z) coordinates in the coordinate system specified by the frameOfReferenceUid element.", 0, Integer.MAX_VALUE, this.coordinates));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1990487986: {
                    return new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType);
                }
                case 500956370: {
                    return new Property("coordinateType", ImagingSelection.SP_CODE, "Specifies the type of coordinate system that define the image region.", 0, 1, this.coordinateType);
                }
                case 1871919611: {
                    return new Property("coordinates", "decimal", "The coordinates describing the image region.       If coordinateType is 2D this specifies sequence of (x,y) coordinates in the coordinate system of the image specified by the instance.uid element that contains this image region.       If coordinateType is 3D this specifies sequence of (x,y,z) coordinates in the coordinate system specified by the frameOfReferenceUid element.", 0, Integer.MAX_VALUE, this.coordinates);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    Base[] baseArray;
                    if (this.regionType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regionType;
                    }
                    return baseArray;
                }
                case 500956370: {
                    Base[] baseArray;
                    if (this.coordinateType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.coordinateType;
                    }
                    return baseArray;
                }
                case 1871919611: {
                    return this.coordinates == null ? new Base[]{} : this.coordinates.toArray(new Base[this.coordinates.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    value = new ImagingSelectionGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.regionType = value;
                    return value;
                }
                case 500956370: {
                    value = new ImagingSelectionCoordinateTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.coordinateType = value;
                    return value;
                }
                case 1871919611: {
                    this.getCoordinates().add(TypeConvertor.castToDecimal(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regionType")) {
                value = new ImagingSelectionGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.regionType = value;
            } else if (name.equals("coordinateType")) {
                value = new ImagingSelectionCoordinateTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.coordinateType = value;
            } else if (name.equals("coordinates")) {
                this.getCoordinates().add(TypeConvertor.castToDecimal(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return this.getRegionTypeElement();
                }
                case 500956370: {
                    return this.getCoordinateTypeElement();
                }
                case 1871919611: {
                    return this.addCoordinatesElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return new String[]{ImagingSelection.SP_CODE};
                }
                case 500956370: {
                    return new String[]{ImagingSelection.SP_CODE};
                }
                case 1871919611: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regionType")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.imageRegion.regionType");
            }
            if (name.equals("coordinateType")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.imageRegion.coordinateType");
            }
            if (name.equals("coordinates")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.imageRegion.coordinates");
            }
            return super.addChild(name);
        }

        @Override
        public ImagingSelectionImageRegionComponent copy() {
            ImagingSelectionImageRegionComponent dst = new ImagingSelectionImageRegionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingSelectionImageRegionComponent dst) {
            super.copyValues(dst);
            dst.regionType = this.regionType == null ? null : this.regionType.copy();
            Enumeration<ImagingSelectionCoordinateType> enumeration = dst.coordinateType = this.coordinateType == null ? null : this.coordinateType.copy();
            if (this.coordinates != null) {
                dst.coordinates = new ArrayList<DecimalType>();
                for (DecimalType i : this.coordinates) {
                    dst.coordinates.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionImageRegionComponent)) {
                return false;
            }
            ImagingSelectionImageRegionComponent o = (ImagingSelectionImageRegionComponent)other_;
            return ImagingSelectionImageRegionComponent.compareDeep(this.regionType, o.regionType, true) && ImagingSelectionImageRegionComponent.compareDeep(this.coordinateType, o.coordinateType, true) && ImagingSelectionImageRegionComponent.compareDeep(this.coordinates, o.coordinates, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionImageRegionComponent)) {
                return false;
            }
            ImagingSelectionImageRegionComponent o = (ImagingSelectionImageRegionComponent)other_;
            return ImagingSelectionImageRegionComponent.compareValues(this.regionType, o.regionType, true) && ImagingSelectionImageRegionComponent.compareValues(this.coordinateType, o.coordinateType, true) && ImagingSelectionImageRegionComponent.compareValues(this.coordinates, o.coordinates, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regionType, this.coordinateType, this.coordinates});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.imageRegion";
        }
    }

    @Block
    public static class ImagingSelectionInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="DICOM SOP Instance UID", formalDefinition="The SOP Instance UID for the selected DICOM instance.")
        protected OidType uid;
        @Child(name="sopClass", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="DICOM SOP Class UID", formalDefinition="The SOP Class UID for the selected DICOM instance.")
        @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1")
        protected Coding sopClass;
        @Child(name="frameList", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="List of selected frames encoded as a comma separated list of one or more non duplicate frame numbers", formalDefinition="The set of frames within a multi-frame SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate frame numbers.       If this is absent, all frames within the referenced SOP Instance are included in the selection.")
        protected StringType frameList;
        @Child(name="observationUid", type={OidType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Selected observations in a DICOM SR", formalDefinition="The unique identifier for the observation Content Item (and its subsidiary Content Items, if any) that are included in the imaging selection.")
        protected List<OidType> observationUid;
        @Child(name="segmentList", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="List of selected segments encoded as a comma separated list of one or more non duplicate segnent numbers", formalDefinition="The set of segments within a segmentation SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate segment numbers.       If this is absent, all segments within the referenced segmentation SOP Instance are included in the selection.")
        protected StringType segmentList;
        @Child(name="roiList", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="List of selected regions of interest (ROI) encoded as a comma separated list of one or more non duplicate ROI numbers", formalDefinition="The set of regions of interest (ROI) within a radiotherapy structure set instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate ROI numbers.       If this is absent, all ROIs within the referenced radiotherapy structure set SOP Instance are included in the selection.")
        protected StringType roiList;
        private static final long serialVersionUID = -1574362633L;

        public ImagingSelectionInstanceComponent() {
        }

        public ImagingSelectionInstanceComponent(String uid) {
            this.setUid(uid);
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingSelectionInstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public ImagingSelectionInstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public Coding getSopClass() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new Coding();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public ImagingSelectionInstanceComponent setSopClass(Coding value) {
            this.sopClass = value;
            return this;
        }

        public StringType getFrameListElement() {
            if (this.frameList == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.frameList");
                }
                if (Configuration.doAutoCreate()) {
                    this.frameList = new StringType();
                }
            }
            return this.frameList;
        }

        public boolean hasFrameListElement() {
            return this.frameList != null && !this.frameList.isEmpty();
        }

        public boolean hasFrameList() {
            return this.frameList != null && !this.frameList.isEmpty();
        }

        public ImagingSelectionInstanceComponent setFrameListElement(StringType value) {
            this.frameList = value;
            return this;
        }

        public String getFrameList() {
            return this.frameList == null ? null : (String)this.frameList.getValue();
        }

        public ImagingSelectionInstanceComponent setFrameList(String value) {
            if (Utilities.noString((String)value)) {
                this.frameList = null;
            } else {
                if (this.frameList == null) {
                    this.frameList = new StringType();
                }
                this.frameList.setValue(value);
            }
            return this;
        }

        public List<OidType> getObservationUid() {
            if (this.observationUid == null) {
                this.observationUid = new ArrayList<OidType>();
            }
            return this.observationUid;
        }

        public ImagingSelectionInstanceComponent setObservationUid(List<OidType> theObservationUid) {
            this.observationUid = theObservationUid;
            return this;
        }

        public boolean hasObservationUid() {
            if (this.observationUid == null) {
                return false;
            }
            for (OidType item : this.observationUid) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OidType addObservationUidElement() {
            OidType t = new OidType();
            if (this.observationUid == null) {
                this.observationUid = new ArrayList<OidType>();
            }
            this.observationUid.add(t);
            return t;
        }

        public ImagingSelectionInstanceComponent addObservationUid(String value) {
            OidType t = new OidType();
            t.setValue(value);
            if (this.observationUid == null) {
                this.observationUid = new ArrayList<OidType>();
            }
            this.observationUid.add(t);
            return this;
        }

        public boolean hasObservationUid(String value) {
            if (this.observationUid == null) {
                return false;
            }
            for (OidType v : this.observationUid) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getSegmentListElement() {
            if (this.segmentList == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.segmentList");
                }
                if (Configuration.doAutoCreate()) {
                    this.segmentList = new StringType();
                }
            }
            return this.segmentList;
        }

        public boolean hasSegmentListElement() {
            return this.segmentList != null && !this.segmentList.isEmpty();
        }

        public boolean hasSegmentList() {
            return this.segmentList != null && !this.segmentList.isEmpty();
        }

        public ImagingSelectionInstanceComponent setSegmentListElement(StringType value) {
            this.segmentList = value;
            return this;
        }

        public String getSegmentList() {
            return this.segmentList == null ? null : (String)this.segmentList.getValue();
        }

        public ImagingSelectionInstanceComponent setSegmentList(String value) {
            if (Utilities.noString((String)value)) {
                this.segmentList = null;
            } else {
                if (this.segmentList == null) {
                    this.segmentList = new StringType();
                }
                this.segmentList.setValue(value);
            }
            return this;
        }

        public StringType getRoiListElement() {
            if (this.roiList == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.roiList");
                }
                if (Configuration.doAutoCreate()) {
                    this.roiList = new StringType();
                }
            }
            return this.roiList;
        }

        public boolean hasRoiListElement() {
            return this.roiList != null && !this.roiList.isEmpty();
        }

        public boolean hasRoiList() {
            return this.roiList != null && !this.roiList.isEmpty();
        }

        public ImagingSelectionInstanceComponent setRoiListElement(StringType value) {
            this.roiList = value;
            return this;
        }

        public String getRoiList() {
            return this.roiList == null ? null : (String)this.roiList.getValue();
        }

        public ImagingSelectionInstanceComponent setRoiList(String value) {
            if (Utilities.noString((String)value)) {
                this.roiList = null;
            } else {
                if (this.roiList == null) {
                    this.roiList = new StringType();
                }
                this.roiList.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "oid", "The SOP Instance UID for the selected DICOM instance.", 0, 1, this.uid));
            children.add(new Property("sopClass", "Coding", "The SOP Class UID for the selected DICOM instance.", 0, 1, this.sopClass));
            children.add(new Property("frameList", "string", "The set of frames within a multi-frame SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate frame numbers.       If this is absent, all frames within the referenced SOP Instance are included in the selection.", 0, 1, this.frameList));
            children.add(new Property("observationUid", "oid", "The unique identifier for the observation Content Item (and its subsidiary Content Items, if any) that are included in the imaging selection.", 0, Integer.MAX_VALUE, this.observationUid));
            children.add(new Property("segmentList", "string", "The set of segments within a segmentation SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate segment numbers.       If this is absent, all segments within the referenced segmentation SOP Instance are included in the selection.", 0, 1, this.segmentList));
            children.add(new Property("roiList", "string", "The set of regions of interest (ROI) within a radiotherapy structure set instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate ROI numbers.       If this is absent, all ROIs within the referenced radiotherapy structure set SOP Instance are included in the selection.", 0, 1, this.roiList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "oid", "The SOP Instance UID for the selected DICOM instance.", 0, 1, this.uid);
                }
                case 1560041540: {
                    return new Property("sopClass", "Coding", "The SOP Class UID for the selected DICOM instance.", 0, 1, this.sopClass);
                }
                case 544886699: {
                    return new Property("frameList", "string", "The set of frames within a multi-frame SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate frame numbers.       If this is absent, all frames within the referenced SOP Instance are included in the selection.", 0, 1, this.frameList);
                }
                case -1631882108: {
                    return new Property("observationUid", "oid", "The unique identifier for the observation Content Item (and its subsidiary Content Items, if any) that are included in the imaging selection.", 0, Integer.MAX_VALUE, this.observationUid);
                }
                case -953159055: {
                    return new Property("segmentList", "string", "The set of segments within a segmentation SOP Instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate segment numbers.       If this is absent, all segments within the referenced segmentation SOP Instance are included in the selection.", 0, 1, this.segmentList);
                }
                case 1373378698: {
                    return new Property("roiList", "string", "The set of regions of interest (ROI) within a radiotherapy structure set instance that are included in the imaging selection.       Encoded as a comma separated list of one or more non duplicate ROI numbers.       If this is absent, all ROIs within the referenced radiotherapy structure set SOP Instance are included in the selection.", 0, 1, this.roiList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 544886699: {
                    Base[] baseArray;
                    if (this.frameList == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.frameList;
                    }
                    return baseArray;
                }
                case -1631882108: {
                    return this.observationUid == null ? new Base[]{} : this.observationUid.toArray(new Base[this.observationUid.size()]);
                }
                case -953159055: {
                    Base[] baseArray;
                    if (this.segmentList == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.segmentList;
                    }
                    return baseArray;
                }
                case 1373378698: {
                    Base[] baseArray;
                    if (this.roiList == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.roiList;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = TypeConvertor.castToOid(value);
                    return value;
                }
                case 1560041540: {
                    this.sopClass = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 544886699: {
                    this.frameList = TypeConvertor.castToString(value);
                    return value;
                }
                case -1631882108: {
                    this.getObservationUid().add(TypeConvertor.castToOid(value));
                    return value;
                }
                case -953159055: {
                    this.segmentList = TypeConvertor.castToString(value);
                    return value;
                }
                case 1373378698: {
                    this.roiList = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = TypeConvertor.castToOid(value);
            } else if (name.equals("sopClass")) {
                this.sopClass = TypeConvertor.castToCoding(value);
            } else if (name.equals("frameList")) {
                this.frameList = TypeConvertor.castToString(value);
            } else if (name.equals("observationUid")) {
                this.getObservationUid().add(TypeConvertor.castToOid(value));
            } else if (name.equals("segmentList")) {
                this.segmentList = TypeConvertor.castToString(value);
            } else if (name.equals("roiList")) {
                this.roiList = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case 1560041540: {
                    return this.getSopClass();
                }
                case 544886699: {
                    return this.getFrameListElement();
                }
                case -1631882108: {
                    return this.addObservationUidElement();
                }
                case -953159055: {
                    return this.getSegmentListElement();
                }
                case 1373378698: {
                    return this.getRoiListElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"oid"};
                }
                case 1560041540: {
                    return new String[]{"Coding"};
                }
                case 544886699: {
                    return new String[]{"string"};
                }
                case -1631882108: {
                    return new String[]{"oid"};
                }
                case -953159055: {
                    return new String[]{"string"};
                }
                case 1373378698: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.instance.uid");
            }
            if (name.equals("sopClass")) {
                this.sopClass = new Coding();
                return this.sopClass;
            }
            if (name.equals("frameList")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.instance.frameList");
            }
            if (name.equals("observationUid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.instance.observationUid");
            }
            if (name.equals("segmentList")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.instance.segmentList");
            }
            if (name.equals("roiList")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingSelection.instance.roiList");
            }
            return super.addChild(name);
        }

        @Override
        public ImagingSelectionInstanceComponent copy() {
            ImagingSelectionInstanceComponent dst = new ImagingSelectionInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingSelectionInstanceComponent dst) {
            super.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            StringType stringType = dst.frameList = this.frameList == null ? null : this.frameList.copy();
            if (this.observationUid != null) {
                dst.observationUid = new ArrayList<OidType>();
                for (OidType i : this.observationUid) {
                    dst.observationUid.add(i.copy());
                }
            }
            dst.segmentList = this.segmentList == null ? null : this.segmentList.copy();
            dst.roiList = this.roiList == null ? null : this.roiList.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionInstanceComponent)) {
                return false;
            }
            ImagingSelectionInstanceComponent o = (ImagingSelectionInstanceComponent)other_;
            return ImagingSelectionInstanceComponent.compareDeep(this.uid, o.uid, true) && ImagingSelectionInstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && ImagingSelectionInstanceComponent.compareDeep(this.frameList, o.frameList, true) && ImagingSelectionInstanceComponent.compareDeep(this.observationUid, o.observationUid, true) && ImagingSelectionInstanceComponent.compareDeep(this.segmentList, o.segmentList, true) && ImagingSelectionInstanceComponent.compareDeep(this.roiList, o.roiList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionInstanceComponent)) {
                return false;
            }
            ImagingSelectionInstanceComponent o = (ImagingSelectionInstanceComponent)other_;
            return ImagingSelectionInstanceComponent.compareValues(this.uid, o.uid, true) && ImagingSelectionInstanceComponent.compareValues(this.frameList, o.frameList, true) && ImagingSelectionInstanceComponent.compareValues(this.observationUid, o.observationUid, true) && ImagingSelectionInstanceComponent.compareValues(this.segmentList, o.segmentList, true) && ImagingSelectionInstanceComponent.compareValues(this.roiList, o.roiList, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.sopClass, this.frameList, this.observationUid, this.segmentList, this.roiList});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.instance";
        }
    }

    @Block
    public static class ImagingSelectionPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of performer", formalDefinition="Distinguishes the type of involvement of the performer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/series-performer-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Device.class, Organization.class, CareTeam.class, Patient.class, RelatedPerson.class, HealthcareService.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Author (human or machine)", formalDefinition="Author \u2013 human or machine.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ImagingSelectionPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ImagingSelectionPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Device|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "Author \u2013 human or machine.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Device|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "Author \u2013 human or machine.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ImagingSelectionPerformerComponent copy() {
            ImagingSelectionPerformerComponent dst = new ImagingSelectionPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingSelectionPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionPerformerComponent)) {
                return false;
            }
            ImagingSelectionPerformerComponent o = (ImagingSelectionPerformerComponent)other_;
            return ImagingSelectionPerformerComponent.compareDeep(this.function, o.function, true) && ImagingSelectionPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionPerformerComponent)) {
                return false;
            }
            ImagingSelectionPerformerComponent o = (ImagingSelectionPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.performer";
        }
    }

    public static class ImagingSelectionGraphicTypeEnumFactory
    implements EnumFactory<ImagingSelectionGraphicType> {
        @Override
        public ImagingSelectionGraphicType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("POINT".equals(codeString)) {
                return ImagingSelectionGraphicType.POINT;
            }
            if ("MULTIPOINT".equals(codeString)) {
                return ImagingSelectionGraphicType.MULTIPOINT;
            }
            if ("POLYLINE".equals(codeString)) {
                return ImagingSelectionGraphicType.POLYLINE;
            }
            if ("POLYGON".equals(codeString)) {
                return ImagingSelectionGraphicType.POLYGON;
            }
            if ("ELLIPSE".equals(codeString)) {
                return ImagingSelectionGraphicType.ELLIPSE;
            }
            if ("ELLIPSOID".equals(codeString)) {
                return ImagingSelectionGraphicType.ELLIPSOID;
            }
            throw new IllegalArgumentException("Unknown ImagingSelectionGraphicType code '" + codeString + "'");
        }

        public Enumeration<ImagingSelectionGraphicType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingSelectionGraphicType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("POINT".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.POINT);
            }
            if ("MULTIPOINT".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.MULTIPOINT);
            }
            if ("POLYLINE".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.POLYLINE);
            }
            if ("POLYGON".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.POLYGON);
            }
            if ("ELLIPSE".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.ELLIPSE);
            }
            if ("ELLIPSOID".equals(codeString)) {
                return new Enumeration<ImagingSelectionGraphicType>(this, ImagingSelectionGraphicType.ELLIPSOID);
            }
            throw new FHIRException("Unknown ImagingSelectionGraphicType code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingSelectionGraphicType code) {
            if (code == ImagingSelectionGraphicType.POINT) {
                return "POINT";
            }
            if (code == ImagingSelectionGraphicType.MULTIPOINT) {
                return "MULTIPOINT";
            }
            if (code == ImagingSelectionGraphicType.POLYLINE) {
                return "POLYLINE";
            }
            if (code == ImagingSelectionGraphicType.POLYGON) {
                return "POLYGON";
            }
            if (code == ImagingSelectionGraphicType.ELLIPSE) {
                return "ELLIPSE";
            }
            if (code == ImagingSelectionGraphicType.ELLIPSOID) {
                return "ELLIPSOID";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingSelectionGraphicType code) {
            return code.getSystem();
        }
    }

    public static enum ImagingSelectionGraphicType {
        POINT,
        MULTIPOINT,
        POLYLINE,
        POLYGON,
        ELLIPSE,
        ELLIPSOID,
        NULL;


        public static ImagingSelectionGraphicType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("POINT".equals(codeString)) {
                return POINT;
            }
            if ("MULTIPOINT".equals(codeString)) {
                return MULTIPOINT;
            }
            if ("POLYLINE".equals(codeString)) {
                return POLYLINE;
            }
            if ("POLYGON".equals(codeString)) {
                return POLYGON;
            }
            if ("ELLIPSE".equals(codeString)) {
                return ELLIPSE;
            }
            if ("ELLIPSOID".equals(codeString)) {
                return ELLIPSOID;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingSelectionGraphicType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case POINT: {
                    return "POINT";
                }
                case MULTIPOINT: {
                    return "MULTIPOINT";
                }
                case POLYLINE: {
                    return "POLYLINE";
                }
                case POLYGON: {
                    return "POLYGON";
                }
                case ELLIPSE: {
                    return "ELLIPSE";
                }
                case ELLIPSOID: {
                    return "ELLIPSOID";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case POINT: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
                case MULTIPOINT: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
                case POLYLINE: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
                case POLYGON: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
                case ELLIPSE: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
                case ELLIPSOID: {
                    return "http://hl7.org/fhir/imagingselection-graphictype";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case POINT: {
                    return "A single location denoted by a single (x,y,z) triplet.";
                }
                case MULTIPOINT: {
                    return "multiple locations each denoted by an (x,y,z) triplet; the points need not be coplanar.";
                }
                case POLYLINE: {
                    return "a series of connected line segments with ordered vertices denoted by (x,y,z) triplets; the points need not be coplanar.";
                }
                case POLYGON: {
                    return "a series of connected line segments with ordered vertices denoted by (x,y,z) triplets, where the first and last vertices shall be the same forming a polygon; the points shall be coplanar.";
                }
                case ELLIPSE: {
                    return "an ellipse defined by four (x,y,z) triplets, the first two triplets specifying the endpoints of the major axis and the second two triplets specifying the endpoints of the minor axis.";
                }
                case ELLIPSOID: {
                    return "a three-dimensional geometric surface whose plane sections are either ellipses or circles and contains three intersecting orthogonal axes, \"a\", \"b\", and \"c\"; the ellipsoid is defined by six (x,y,z) triplets, the first and second triplets specifying the endpoints of axis \"a\", the third and fourth triplets specifying the endpoints of axis \"b\", and the fifth and sixth triplets specifying the endpoints of axis \"c\".";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case POINT: {
                    return "POINT";
                }
                case MULTIPOINT: {
                    return "MULTIPOINT";
                }
                case POLYLINE: {
                    return "POLYLINE";
                }
                case POLYGON: {
                    return "POLYGON";
                }
                case ELLIPSE: {
                    return "ELLIPSE";
                }
                case ELLIPSOID: {
                    return "ELLIPSOID";
                }
            }
            return "?";
        }
    }

    public static class ImagingSelectionCoordinateTypeEnumFactory
    implements EnumFactory<ImagingSelectionCoordinateType> {
        @Override
        public ImagingSelectionCoordinateType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("2d".equals(codeString)) {
                return ImagingSelectionCoordinateType._2D;
            }
            if ("3d".equals(codeString)) {
                return ImagingSelectionCoordinateType._3D;
            }
            throw new IllegalArgumentException("Unknown ImagingSelectionCoordinateType code '" + codeString + "'");
        }

        public Enumeration<ImagingSelectionCoordinateType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingSelectionCoordinateType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("2d".equals(codeString)) {
                return new Enumeration<ImagingSelectionCoordinateType>(this, ImagingSelectionCoordinateType._2D);
            }
            if ("3d".equals(codeString)) {
                return new Enumeration<ImagingSelectionCoordinateType>(this, ImagingSelectionCoordinateType._3D);
            }
            throw new FHIRException("Unknown ImagingSelectionCoordinateType code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingSelectionCoordinateType code) {
            if (code == ImagingSelectionCoordinateType._2D) {
                return "2d";
            }
            if (code == ImagingSelectionCoordinateType._3D) {
                return "3d";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingSelectionCoordinateType code) {
            return code.getSystem();
        }
    }

    public static enum ImagingSelectionCoordinateType {
        _2D,
        _3D,
        NULL;


        public static ImagingSelectionCoordinateType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("2d".equals(codeString)) {
                return _2D;
            }
            if ("3d".equals(codeString)) {
                return _3D;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingSelectionCoordinateType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case _2D: {
                    return "2d";
                }
                case _3D: {
                    return "3d";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _2D: {
                    return "http://hl7.org/fhir/imagingselection-coordinatetype";
                }
                case _3D: {
                    return "http://hl7.org/fhir/imagingselection-coordinatetype";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _2D: {
                    return "The selected image region is defined in a 2D coordinate system.";
                }
                case _3D: {
                    return "The selected image region is defined in a 3D coordinate system.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _2D: {
                    return "2D";
                }
                case _3D: {
                    return "3D";
                }
            }
            return "?";
        }
    }
}

