/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

@ResourceDef(name="Parameters", profile="http://hl7.org/fhir/StructureDefinition/Parameters")
public class Parameters
extends Resource
implements IBaseParameters {
    @Child(name="parameter", type={}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Operation Parameter", formalDefinition="A parameter passed to or received from the operation.")
    protected List<ParametersParameterComponent> parameter;
    private static final long serialVersionUID = -1495940293L;

    public List<ParametersParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        return this.parameter;
    }

    public Parameters setParameter(List<ParametersParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ParametersParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParametersParameterComponent addParameter() {
        ParametersParameterComponent t = new ParametersParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public Parameters addParameter(ParametersParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public ParametersParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("parameter", "", "A parameter passed to or received from the operation.", 0, Integer.MAX_VALUE, this.parameter));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1954460585: {
                return new Property("parameter", "", "A parameter passed to or received from the operation.", 0, Integer.MAX_VALUE, this.parameter);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                this.getParameter().add((ParametersParameterComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("parameter")) {
            return super.setProperty(name, value);
        }
        this.getParameter().add((ParametersParameterComponent)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return this.addParameter();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1954460585: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Parameters";
    }

    @Override
    public Parameters copy() {
        Parameters dst = new Parameters();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Parameters dst) {
        super.copyValues(dst);
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ParametersParameterComponent>();
            for (ParametersParameterComponent i : this.parameter) {
                dst.parameter.add(i.copy());
            }
        }
    }

    protected Parameters typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other_;
        return Parameters.compareDeep(this.parameter, o.parameter, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.parameter);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Parameters;
    }

    public Parameters addParameter(String name, boolean b) {
        this.addParameter().setName(name).setValue(new BooleanType(b));
        return this;
    }

    public Parameters addParameter(String name, String s) {
        if (s != null) {
            this.addParameter().setName(name).setValue(new StringType(s));
        }
        return this;
    }

    public Parameters addParameter(String name, DataType v) {
        if (v != null) {
            this.addParameter().setName(name).setValue(v);
        }
        return this;
    }

    public Parameters setParameter(String name, boolean b) {
        for (ParametersParameterComponent p : this.getParameter()) {
            if (!p.getName().equals(name)) continue;
            p.setValue(new BooleanType(b));
            return this;
        }
        this.addParameter().setName(name).setValue(new BooleanType(b));
        return this;
    }

    public Parameters setParameter(String name, String s) {
        if (s != null) {
            for (ParametersParameterComponent p : this.getParameter()) {
                if (!p.getName().equals(name)) continue;
                p.setValue(new StringType(s));
                return this;
            }
            this.addParameter().setName(name).setValue(new StringType(s));
        }
        return this;
    }

    public Parameters setParameter(String name, DataType v) {
        if (v != null) {
            for (ParametersParameterComponent p : this.getParameter()) {
                if (!p.getName().equals(name)) continue;
                p.setValue(v);
                return this;
            }
            this.addParameter().setName(name).setValue(v);
        }
        return this;
    }

    public boolean hasParameter(String name) {
        for (ParametersParameterComponent p : this.getParameter()) {
            if (!p.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public DataType getParameter(String name) {
        for (ParametersParameterComponent p : this.getParameter()) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }

    public List<DataType> getParameters(String name) {
        ArrayList<DataType> res = new ArrayList<DataType>();
        for (ParametersParameterComponent p : this.getParameter()) {
            if (!p.getName().equals(name)) continue;
            res.add(p.getValue());
        }
        return res;
    }

    public boolean getParameterBool(String name) {
        for (ParametersParameterComponent p : this.getParameter()) {
            if (!p.getName().equals(name)) continue;
            if (p.getValue() instanceof BooleanType) {
                return ((BooleanType)p.getValue()).booleanValue();
            }
            boolean ok = Boolean.getBoolean(p.getValue().primitiveValue());
            return ok;
        }
        return false;
    }

    @Block
    public static class ParametersParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name from the definition", formalDefinition="The name of the parameter (reference to the operation definition).")
        protected StringType name;
        @Child(name="value", type={Base64BinaryType.class, BooleanType.class, CanonicalType.class, CodeType.class, DateType.class, DateTimeType.class, DecimalType.class, IdType.class, InstantType.class, IntegerType.class, Integer64Type.class, MarkdownType.class, OidType.class, PositiveIntType.class, StringType.class, TimeType.class, UnsignedIntType.class, UriType.class, UrlType.class, UuidType.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If parameter is a data type", formalDefinition="Conveys the content if the parameter is a data type.")
        protected DataType value;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If parameter is a whole resource", formalDefinition="Conveys the content if the parameter is a whole resource.")
        protected Resource resource;
        @Child(name="part", type={ParametersParameterComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Named part of a multi-part parameter", formalDefinition="A named part of a multi-part parameter.")
        protected List<ParametersParameterComponent> part;
        private static final long serialVersionUID = -1755858390L;

        public ParametersParameterComponent() {
        }

        public ParametersParameterComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParametersParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ParametersParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ParametersParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public CanonicalType getValueCanonicalType() throws FHIRException {
            if (this.value == null) {
                this.value = new CanonicalType();
            }
            if (!(this.value instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.value;
        }

        public boolean hasValueCanonicalType() {
            return this != null && this.value instanceof CanonicalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (this.value == null) {
                this.value = new InstantType();
            }
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this != null && this.value instanceof InstantType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Integer64Type getValueInteger64Type() throws FHIRException {
            if (this.value == null) {
                this.value = new Integer64Type();
            }
            if (!(this.value instanceof Integer64Type)) {
                throw new FHIRException("Type mismatch: the type Integer64Type was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Integer64Type)this.value;
        }

        public boolean hasValueInteger64Type() {
            return this != null && this.value instanceof Integer64Type;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public OidType getValueOidType() throws FHIRException {
            if (this.value == null) {
                this.value = new OidType();
            }
            if (!(this.value instanceof OidType)) {
                throw new FHIRException("Type mismatch: the type OidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (OidType)this.value;
        }

        public boolean hasValueOidType() {
            return this != null && this.value instanceof OidType;
        }

        public PositiveIntType getValuePositiveIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new PositiveIntType();
            }
            if (!(this.value instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.value;
        }

        public boolean hasValuePositiveIntType() {
            return this != null && this.value instanceof PositiveIntType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public UnsignedIntType getValueUnsignedIntType() throws FHIRException {
            if (this.value == null) {
                this.value = new UnsignedIntType();
            }
            if (!(this.value instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.value;
        }

        public boolean hasValueUnsignedIntType() {
            return this != null && this.value instanceof UnsignedIntType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public UuidType getValueUuidType() throws FHIRException {
            if (this.value == null) {
                this.value = new UuidType();
            }
            if (!(this.value instanceof UuidType)) {
                throw new FHIRException("Type mismatch: the type UuidType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UuidType)this.value;
        }

        public boolean hasValueUuidType() {
            return this != null && this.value instanceof UuidType;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Age getValueAge() throws FHIRException {
            if (this.value == null) {
                this.value = new Age();
            }
            if (!(this.value instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Age)this.value;
        }

        public boolean hasValueAge() {
            return this != null && this.value instanceof Age;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public CodeableReference getValueCodeableReference() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableReference();
            }
            if (!(this.value instanceof CodeableReference)) {
                throw new FHIRException("Type mismatch: the type CodeableReference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableReference)this.value;
        }

        public boolean hasValueCodeableReference() {
            return this != null && this.value instanceof CodeableReference;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public ContactPoint getValueContactPoint() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactPoint();
            }
            if (!(this.value instanceof ContactPoint)) {
                throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactPoint)this.value;
        }

        public boolean hasValueContactPoint() {
            return this != null && this.value instanceof ContactPoint;
        }

        public Count getValueCount() throws FHIRException {
            if (this.value == null) {
                this.value = new Count();
            }
            if (!(this.value instanceof Count)) {
                throw new FHIRException("Type mismatch: the type Count was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Count)this.value;
        }

        public boolean hasValueCount() {
            return this != null && this.value instanceof Count;
        }

        public Distance getValueDistance() throws FHIRException {
            if (this.value == null) {
                this.value = new Distance();
            }
            if (!(this.value instanceof Distance)) {
                throw new FHIRException("Type mismatch: the type Distance was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Distance)this.value;
        }

        public boolean hasValueDistance() {
            return this != null && this.value instanceof Distance;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public HumanName getValueHumanName() throws FHIRException {
            if (this.value == null) {
                this.value = new HumanName();
            }
            if (!(this.value instanceof HumanName)) {
                throw new FHIRException("Type mismatch: the type HumanName was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (HumanName)this.value;
        }

        public boolean hasValueHumanName() {
            return this != null && this.value instanceof HumanName;
        }

        public Identifier getValueIdentifier() throws FHIRException {
            if (this.value == null) {
                this.value = new Identifier();
            }
            if (!(this.value instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Identifier)this.value;
        }

        public boolean hasValueIdentifier() {
            return this != null && this.value instanceof Identifier;
        }

        public Money getValueMoney() throws FHIRException {
            if (this.value == null) {
                this.value = new Money();
            }
            if (!(this.value instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Money)this.value;
        }

        public boolean hasValueMoney() {
            return this != null && this.value instanceof Money;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public RatioRange getValueRatioRange() throws FHIRException {
            if (this.value == null) {
                this.value = new RatioRange();
            }
            if (!(this.value instanceof RatioRange)) {
                throw new FHIRException("Type mismatch: the type RatioRange was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RatioRange)this.value;
        }

        public boolean hasValueRatioRange() {
            return this != null && this.value instanceof RatioRange;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public SampledData getValueSampledData() throws FHIRException {
            if (this.value == null) {
                this.value = new SampledData();
            }
            if (!(this.value instanceof SampledData)) {
                throw new FHIRException("Type mismatch: the type SampledData was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SampledData)this.value;
        }

        public boolean hasValueSampledData() {
            return this != null && this.value instanceof SampledData;
        }

        public Signature getValueSignature() throws FHIRException {
            if (this.value == null) {
                this.value = new Signature();
            }
            if (!(this.value instanceof Signature)) {
                throw new FHIRException("Type mismatch: the type Signature was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Signature)this.value;
        }

        public boolean hasValueSignature() {
            return this != null && this.value instanceof Signature;
        }

        public Timing getValueTiming() throws FHIRException {
            if (this.value == null) {
                this.value = new Timing();
            }
            if (!(this.value instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Timing)this.value;
        }

        public boolean hasValueTiming() {
            return this != null && this.value instanceof Timing;
        }

        public ContactDetail getValueContactDetail() throws FHIRException {
            if (this.value == null) {
                this.value = new ContactDetail();
            }
            if (!(this.value instanceof ContactDetail)) {
                throw new FHIRException("Type mismatch: the type ContactDetail was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ContactDetail)this.value;
        }

        public boolean hasValueContactDetail() {
            return this != null && this.value instanceof ContactDetail;
        }

        public Contributor getValueContributor() throws FHIRException {
            if (this.value == null) {
                this.value = new Contributor();
            }
            if (!(this.value instanceof Contributor)) {
                throw new FHIRException("Type mismatch: the type Contributor was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Contributor)this.value;
        }

        public boolean hasValueContributor() {
            return this != null && this.value instanceof Contributor;
        }

        public DataRequirement getValueDataRequirement() throws FHIRException {
            if (this.value == null) {
                this.value = new DataRequirement();
            }
            if (!(this.value instanceof DataRequirement)) {
                throw new FHIRException("Type mismatch: the type DataRequirement was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DataRequirement)this.value;
        }

        public boolean hasValueDataRequirement() {
            return this != null && this.value instanceof DataRequirement;
        }

        public Expression getValueExpression() throws FHIRException {
            if (this.value == null) {
                this.value = new Expression();
            }
            if (!(this.value instanceof Expression)) {
                throw new FHIRException("Type mismatch: the type Expression was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Expression)this.value;
        }

        public boolean hasValueExpression() {
            return this != null && this.value instanceof Expression;
        }

        public ParameterDefinition getValueParameterDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new ParameterDefinition();
            }
            if (!(this.value instanceof ParameterDefinition)) {
                throw new FHIRException("Type mismatch: the type ParameterDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (ParameterDefinition)this.value;
        }

        public boolean hasValueParameterDefinition() {
            return this != null && this.value instanceof ParameterDefinition;
        }

        public RelatedArtifact getValueRelatedArtifact() throws FHIRException {
            if (this.value == null) {
                this.value = new RelatedArtifact();
            }
            if (!(this.value instanceof RelatedArtifact)) {
                throw new FHIRException("Type mismatch: the type RelatedArtifact was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (RelatedArtifact)this.value;
        }

        public boolean hasValueRelatedArtifact() {
            return this != null && this.value instanceof RelatedArtifact;
        }

        public TriggerDefinition getValueTriggerDefinition() throws FHIRException {
            if (this.value == null) {
                this.value = new TriggerDefinition();
            }
            if (!(this.value instanceof TriggerDefinition)) {
                throw new FHIRException("Type mismatch: the type TriggerDefinition was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TriggerDefinition)this.value;
        }

        public boolean hasValueTriggerDefinition() {
            return this != null && this.value instanceof TriggerDefinition;
        }

        public UsageContext getValueUsageContext() throws FHIRException {
            if (this.value == null) {
                this.value = new UsageContext();
            }
            if (!(this.value instanceof UsageContext)) {
                throw new FHIRException("Type mismatch: the type UsageContext was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UsageContext)this.value;
        }

        public boolean hasValueUsageContext() {
            return this != null && this.value instanceof UsageContext;
        }

        public Dosage getValueDosage() throws FHIRException {
            if (this.value == null) {
                this.value = new Dosage();
            }
            if (!(this.value instanceof Dosage)) {
                throw new FHIRException("Type mismatch: the type Dosage was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Dosage)this.value;
        }

        public boolean hasValueDosage() {
            return this != null && this.value instanceof Dosage;
        }

        public Meta getValueMeta() throws FHIRException {
            if (this.value == null) {
                this.value = new Meta();
            }
            if (!(this.value instanceof Meta)) {
                throw new FHIRException("Type mismatch: the type Meta was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Meta)this.value;
        }

        public boolean hasValueMeta() {
            return this != null && this.value instanceof Meta;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParametersParameterComponent setValue(DataType value) {
            if (!(value == null || value instanceof Base64BinaryType || value instanceof BooleanType || value instanceof CanonicalType || value instanceof CodeType || value instanceof DateType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof IdType || value instanceof InstantType || value instanceof IntegerType || value instanceof Integer64Type || value instanceof MarkdownType || value instanceof OidType || value instanceof PositiveIntType || value instanceof StringType || value instanceof TimeType || value instanceof UnsignedIntType || value instanceof UriType || value instanceof UrlType || value instanceof UuidType || value instanceof Address || value instanceof Age || value instanceof Annotation || value instanceof Attachment || value instanceof CodeableConcept || value instanceof CodeableReference || value instanceof Coding || value instanceof ContactPoint || value instanceof Count || value instanceof Distance || value instanceof Duration || value instanceof HumanName || value instanceof Identifier || value instanceof Money || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof RatioRange || value instanceof Reference || value instanceof SampledData || value instanceof Signature || value instanceof Timing || value instanceof ContactDetail || value instanceof Contributor || value instanceof DataRequirement || value instanceof Expression || value instanceof ParameterDefinition || value instanceof RelatedArtifact || value instanceof TriggerDefinition || value instanceof UsageContext || value instanceof Dosage || value instanceof Meta)) {
                throw new Error("Not the right type for Parameters.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public ParametersParameterComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public List<ParametersParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            return this.part;
        }

        public ParametersParameterComponent setPart(List<ParametersParameterComponent> thePart) {
            this.part = thePart;
            return this;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (ParametersParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ParametersParameterComponent addPart() {
            ParametersParameterComponent t = new ParametersParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public ParametersParameterComponent addPart(ParametersParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        public ParametersParameterComponent getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                this.addPart();
            }
            return this.getPart().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name of the parameter (reference to the operation definition).", 0, 1, this.name));
            children.add(new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|Contributor|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Dosage|Meta", "Conveys the content if the parameter is a data type.", 0, 1, this.value));
            children.add(new Property("resource", "Resource", "Conveys the content if the parameter is a whole resource.", 0, 1, this.resource));
            children.add(new Property("part", "@Parameters.parameter", "A named part of a multi-part parameter.", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name of the parameter (reference to the operation definition).", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|Contributor|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Dosage|Meta", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "base64Binary|boolean|canonical|code|date|dateTime|decimal|id|instant|integer|integer64|markdown|oid|positiveInt|string|time|unsignedInt|uri|url|uuid|Address|Age|Annotation|Attachment|CodeableConcept|CodeableReference|Coding|ContactPoint|Count|Distance|Duration|HumanName|Identifier|Money|Period|Quantity|Range|Ratio|RatioRange|Reference|SampledData|Signature|Timing|ContactDetail|Contributor|DataRequirement|Expression|ParameterDefinition|RelatedArtifact|TriggerDefinition|UsageContext|Dosage|Meta", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "canonical", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "instant", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1122120181: {
                    return new Property("value[x]", "integer64", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "oid", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "positiveInt", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "unsignedInt", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "uuid", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1410191922: {
                    return new Property("value[x]", "Age", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -257955629: {
                    return new Property("value[x]", "CodeableReference", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "ContactPoint", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 2017332766: {
                    return new Property("value[x]", "Count", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -456359802: {
                    return new Property("value[x]", "Distance", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "HumanName", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "Identifier", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 2026560975: {
                    return new Property("value[x]", "Money", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -706454461: {
                    return new Property("value[x]", "RatioRange", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "SampledData", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "Signature", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "Timing", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1125200224: {
                    return new Property("value[x]", "ContactDetail", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1281021610: {
                    return new Property("value[x]", "Contributor", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1710554248: {
                    return new Property("value[x]", "DataRequirement", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -307517719: {
                    return new Property("value[x]", "Expression", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1387478187: {
                    return new Property("value[x]", "ParameterDefinition", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 1748214124: {
                    return new Property("value[x]", "RelatedArtifact", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 976830394: {
                    return new Property("value[x]", "TriggerDefinition", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case 588000479: {
                    return new Property("value[x]", "UsageContext", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "Dosage", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -765920490: {
                    return new Property("value[x]", "Meta", "Conveys the content if the parameter is a data type.", 0, 1, this.value);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "Conveys the content if the parameter is a whole resource.", 0, 1, this.resource);
                }
                case 3433459: {
                    return new Property("part", "@Parameters.parameter", "A named part of a multi-part parameter.", 0, Integer.MAX_VALUE, this.part);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
                case 3433459: {
                    return this.part == null ? new Base[]{} : this.part.toArray(new Base[this.part.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToResource(value);
                    return value;
                }
                case 3433459: {
                    this.getPart().add((ParametersParameterComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToResource(value);
            } else if (name.equals("part")) {
                this.getPart().add((ParametersParameterComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case 3433459: {
                    return this.addPart();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Age", "Annotation", "Attachment", "CodeableConcept", "CodeableReference", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "RatioRange", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "Contributor", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext", "Dosage", "Meta"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case 3433459: {
                    return new String[]{"@Parameters.parameter"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Parameters.parameter.name");
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueCanonical")) {
                this.value = new CanonicalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueInteger64")) {
                this.value = new Integer64Type();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueUuid")) {
                this.value = new UuidType();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueAge")) {
                this.value = new Age();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCodeableReference")) {
                this.value = new CodeableReference();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueCount")) {
                this.value = new Count();
                return this.value;
            }
            if (name.equals("valueDistance")) {
                this.value = new Distance();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueMoney")) {
                this.value = new Money();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueRatioRange")) {
                this.value = new RatioRange();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueContactDetail")) {
                this.value = new ContactDetail();
                return this.value;
            }
            if (name.equals("valueContributor")) {
                this.value = new Contributor();
                return this.value;
            }
            if (name.equals("valueDataRequirement")) {
                this.value = new DataRequirement();
                return this.value;
            }
            if (name.equals("valueExpression")) {
                this.value = new Expression();
                return this.value;
            }
            if (name.equals("valueParameterDefinition")) {
                this.value = new ParameterDefinition();
                return this.value;
            }
            if (name.equals("valueRelatedArtifact")) {
                this.value = new RelatedArtifact();
                return this.value;
            }
            if (name.equals("valueTriggerDefinition")) {
                this.value = new TriggerDefinition();
                return this.value;
            }
            if (name.equals("valueUsageContext")) {
                this.value = new UsageContext();
                return this.value;
            }
            if (name.equals("valueDosage")) {
                this.value = new Dosage();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Parameters.parameter.resource");
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public ParametersParameterComponent copy() {
            ParametersParameterComponent dst = new ParametersParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ParametersParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            Resource resource = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.part != null) {
                dst.part = new ArrayList<ParametersParameterComponent>();
                for (ParametersParameterComponent i : this.part) {
                    dst.part.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other_;
            return ParametersParameterComponent.compareDeep(this.name, o.name, true) && ParametersParameterComponent.compareDeep(this.value, o.value, true) && ParametersParameterComponent.compareDeep(this.resource, o.resource, true) && ParametersParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other_;
            return ParametersParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.value, this.resource, this.part});
        }

        @Override
        public String fhirType() {
            return "Parameters.parameter";
        }

        public String toString() {
            String s = this.getName() + " = ";
            if (this.hasValue()) {
                s = this.getValue().isPrimitive() ? s + this.getValue().primitiveValue() : s + "[" + this.getValue().fhirType() + "]";
            } else if (this.hasResource()) {
                s = s + "[" + this.getResource().fhirType() + "]";
            } else {
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                for (ParametersParameterComponent p : this.getPart()) {
                    b.append(p.getName());
                }
                s = s + "{" + b.toString() + "}";
            }
            return s;
        }
    }
}

