/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="Permission", profile="http://hl7.org/fhir/StructureDefinition/Permission")
public class Permission
extends DomainResource {
    @Child(name="status", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | entered-in-error | draft | rejected", formalDefinition="Status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/permission-status")
    protected Enumeration<PermissionStatus> status;
    @Child(name="intent", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="grant|refuse", formalDefinition="grant|refuse.")
    protected CodeableConcept intent;
    @Child(name="asserter", type={Person.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person or entity that asserts the permission", formalDefinition="The person or entity that asserts the permission.")
    protected Reference asserter;
    @Child(name="assertionDate", type={DateTimeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The date that permission was asserted", formalDefinition="The date that permission was asserted.")
    protected List<DateTimeType> assertionDate;
    @Child(name="validity", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period in which the permission is active", formalDefinition="The period in which the permission is active.")
    protected Period validity;
    @Child(name="purpose", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The purpose for which the permission is given", formalDefinition="The purpose for which the permission is given.")
    protected List<CodeableConcept> purpose;
    @Child(name="dataScope", type={Expression.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="This can be 1) the definition of data elements, or 2) a category or label) e.g. \u201csensitive\u201d. It could also be a c) graph-like definition of a set of data elements", formalDefinition="This can be 1) the definition of data elements, or 2) a category or label) e.g. \u201csensitive\u201d. It could also be a c) graph-like definition of a set of data elements.")
    protected List<Expression> dataScope;
    @Child(name="processingActivity", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A description or definition of which activities are allowed to be done on the data", formalDefinition="A description or definition of which activities are allowed to be done on the data.")
    protected List<PermissionProcessingActivityComponent> processingActivity;
    @Child(name="justification", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The asserted justification for using the data", formalDefinition="The asserted justification for using the data.")
    protected PermissionJustificationComponent justification;
    @Child(name="usageLimitations", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What limits apply to the use of the data", formalDefinition="What limits apply to the use of the data.")
    protected List<CodeableConcept> usageLimitations;
    private static final long serialVersionUID = -1764304363L;
    @SearchParamDefinition(name="status", path="Permission.status", description="active | entered-in-error | draft | rejected", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Permission() {
    }

    public Permission(PermissionStatus status) {
        this.setStatus(status);
    }

    public Enumeration<PermissionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<PermissionStatus>(new PermissionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Permission setStatusElement(Enumeration<PermissionStatus> value) {
        this.status = value;
        return this;
    }

    public PermissionStatus getStatus() {
        return this.status == null ? null : (PermissionStatus)((Object)this.status.getValue());
    }

    public Permission setStatus(PermissionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<PermissionStatus>(new PermissionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getIntent() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new CodeableConcept();
            }
        }
        return this.intent;
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public Permission setIntent(CodeableConcept value) {
        this.intent = value;
        return this;
    }

    public Reference getAsserter() {
        if (this.asserter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.asserter");
            }
            if (Configuration.doAutoCreate()) {
                this.asserter = new Reference();
            }
        }
        return this.asserter;
    }

    public boolean hasAsserter() {
        return this.asserter != null && !this.asserter.isEmpty();
    }

    public Permission setAsserter(Reference value) {
        this.asserter = value;
        return this;
    }

    public List<DateTimeType> getAssertionDate() {
        if (this.assertionDate == null) {
            this.assertionDate = new ArrayList<DateTimeType>();
        }
        return this.assertionDate;
    }

    public Permission setAssertionDate(List<DateTimeType> theAssertionDate) {
        this.assertionDate = theAssertionDate;
        return this;
    }

    public boolean hasAssertionDate() {
        if (this.assertionDate == null) {
            return false;
        }
        for (DateTimeType item : this.assertionDate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DateTimeType addAssertionDateElement() {
        DateTimeType t = new DateTimeType();
        if (this.assertionDate == null) {
            this.assertionDate = new ArrayList<DateTimeType>();
        }
        this.assertionDate.add(t);
        return t;
    }

    public Permission addAssertionDate(Date value) {
        DateTimeType t = new DateTimeType();
        t.setValue(value);
        if (this.assertionDate == null) {
            this.assertionDate = new ArrayList<DateTimeType>();
        }
        this.assertionDate.add(t);
        return this;
    }

    public boolean hasAssertionDate(Date value) {
        if (this.assertionDate == null) {
            return false;
        }
        for (DateTimeType v : this.assertionDate) {
            if (!((Date)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getValidity() {
        if (this.validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.validity");
            }
            if (Configuration.doAutoCreate()) {
                this.validity = new Period();
            }
        }
        return this.validity;
    }

    public boolean hasValidity() {
        return this.validity != null && !this.validity.isEmpty();
    }

    public Permission setValidity(Period value) {
        this.validity = value;
        return this;
    }

    public List<CodeableConcept> getPurpose() {
        if (this.purpose == null) {
            this.purpose = new ArrayList<CodeableConcept>();
        }
        return this.purpose;
    }

    public Permission setPurpose(List<CodeableConcept> thePurpose) {
        this.purpose = thePurpose;
        return this;
    }

    public boolean hasPurpose() {
        if (this.purpose == null) {
            return false;
        }
        for (CodeableConcept item : this.purpose) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPurpose() {
        CodeableConcept t = new CodeableConcept();
        if (this.purpose == null) {
            this.purpose = new ArrayList<CodeableConcept>();
        }
        this.purpose.add(t);
        return t;
    }

    public Permission addPurpose(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.purpose == null) {
            this.purpose = new ArrayList<CodeableConcept>();
        }
        this.purpose.add(t);
        return this;
    }

    public CodeableConcept getPurposeFirstRep() {
        if (this.getPurpose().isEmpty()) {
            this.addPurpose();
        }
        return this.getPurpose().get(0);
    }

    public List<Expression> getDataScope() {
        if (this.dataScope == null) {
            this.dataScope = new ArrayList<Expression>();
        }
        return this.dataScope;
    }

    public Permission setDataScope(List<Expression> theDataScope) {
        this.dataScope = theDataScope;
        return this;
    }

    public boolean hasDataScope() {
        if (this.dataScope == null) {
            return false;
        }
        for (Expression item : this.dataScope) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Expression addDataScope() {
        Expression t = new Expression();
        if (this.dataScope == null) {
            this.dataScope = new ArrayList<Expression>();
        }
        this.dataScope.add(t);
        return t;
    }

    public Permission addDataScope(Expression t) {
        if (t == null) {
            return this;
        }
        if (this.dataScope == null) {
            this.dataScope = new ArrayList<Expression>();
        }
        this.dataScope.add(t);
        return this;
    }

    public Expression getDataScopeFirstRep() {
        if (this.getDataScope().isEmpty()) {
            this.addDataScope();
        }
        return this.getDataScope().get(0);
    }

    public List<PermissionProcessingActivityComponent> getProcessingActivity() {
        if (this.processingActivity == null) {
            this.processingActivity = new ArrayList<PermissionProcessingActivityComponent>();
        }
        return this.processingActivity;
    }

    public Permission setProcessingActivity(List<PermissionProcessingActivityComponent> theProcessingActivity) {
        this.processingActivity = theProcessingActivity;
        return this;
    }

    public boolean hasProcessingActivity() {
        if (this.processingActivity == null) {
            return false;
        }
        for (PermissionProcessingActivityComponent item : this.processingActivity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PermissionProcessingActivityComponent addProcessingActivity() {
        PermissionProcessingActivityComponent t = new PermissionProcessingActivityComponent();
        if (this.processingActivity == null) {
            this.processingActivity = new ArrayList<PermissionProcessingActivityComponent>();
        }
        this.processingActivity.add(t);
        return t;
    }

    public Permission addProcessingActivity(PermissionProcessingActivityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processingActivity == null) {
            this.processingActivity = new ArrayList<PermissionProcessingActivityComponent>();
        }
        this.processingActivity.add(t);
        return this;
    }

    public PermissionProcessingActivityComponent getProcessingActivityFirstRep() {
        if (this.getProcessingActivity().isEmpty()) {
            this.addProcessingActivity();
        }
        return this.getProcessingActivity().get(0);
    }

    public PermissionJustificationComponent getJustification() {
        if (this.justification == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Permission.justification");
            }
            if (Configuration.doAutoCreate()) {
                this.justification = new PermissionJustificationComponent();
            }
        }
        return this.justification;
    }

    public boolean hasJustification() {
        return this.justification != null && !this.justification.isEmpty();
    }

    public Permission setJustification(PermissionJustificationComponent value) {
        this.justification = value;
        return this;
    }

    public List<CodeableConcept> getUsageLimitations() {
        if (this.usageLimitations == null) {
            this.usageLimitations = new ArrayList<CodeableConcept>();
        }
        return this.usageLimitations;
    }

    public Permission setUsageLimitations(List<CodeableConcept> theUsageLimitations) {
        this.usageLimitations = theUsageLimitations;
        return this;
    }

    public boolean hasUsageLimitations() {
        if (this.usageLimitations == null) {
            return false;
        }
        for (CodeableConcept item : this.usageLimitations) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUsageLimitations() {
        CodeableConcept t = new CodeableConcept();
        if (this.usageLimitations == null) {
            this.usageLimitations = new ArrayList<CodeableConcept>();
        }
        this.usageLimitations.add(t);
        return t;
    }

    public Permission addUsageLimitations(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.usageLimitations == null) {
            this.usageLimitations = new ArrayList<CodeableConcept>();
        }
        this.usageLimitations.add(t);
        return this;
    }

    public CodeableConcept getUsageLimitationsFirstRep() {
        if (this.getUsageLimitations().isEmpty()) {
            this.addUsageLimitations();
        }
        return this.getUsageLimitations().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_STATUS, "code", "Status.", 0, 1, this.status));
        children.add(new Property("intent", "CodeableConcept", "grant|refuse.", 0, 1, this.intent));
        children.add(new Property("asserter", "Reference(Person)", "The person or entity that asserts the permission.", 0, 1, this.asserter));
        children.add(new Property("assertionDate", "dateTime", "The date that permission was asserted.", 0, Integer.MAX_VALUE, this.assertionDate));
        children.add(new Property("validity", "Period", "The period in which the permission is active.", 0, 1, this.validity));
        children.add(new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose));
        children.add(new Property("dataScope", "Expression", "This can be 1) the definition of data elements, or 2) a category or label) e.g. \u201csensitive\u201d. It could also be a c) graph-like definition of a set of data elements.", 0, Integer.MAX_VALUE, this.dataScope));
        children.add(new Property("processingActivity", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.processingActivity));
        children.add(new Property("justification", "", "The asserted justification for using the data.", 0, 1, this.justification));
        children.add(new Property("usageLimitations", "CodeableConcept", "What limits apply to the use of the data.", 0, Integer.MAX_VALUE, this.usageLimitations));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property("intent", "CodeableConcept", "grant|refuse.", 0, 1, this.intent);
            }
            case -373242253: {
                return new Property("asserter", "Reference(Person)", "The person or entity that asserts the permission.", 0, 1, this.asserter);
            }
            case -1498338864: {
                return new Property("assertionDate", "dateTime", "The date that permission was asserted.", 0, Integer.MAX_VALUE, this.assertionDate);
            }
            case -1421265102: {
                return new Property("validity", "Period", "The period in which the permission is active.", 0, 1, this.validity);
            }
            case -220463842: {
                return new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose);
            }
            case -374957878: {
                return new Property("dataScope", "Expression", "This can be 1) the definition of data elements, or 2) a category or label) e.g. \u201csensitive\u201d. It could also be a c) graph-like definition of a set of data elements.", 0, Integer.MAX_VALUE, this.dataScope);
            }
            case -2117745854: {
                return new Property("processingActivity", "", "A description or definition of which activities are allowed to be done on the data.", 0, Integer.MAX_VALUE, this.processingActivity);
            }
            case 1864993522: {
                return new Property("justification", "", "The asserted justification for using the data.", 0, 1, this.justification);
            }
            case -788364488: {
                return new Property("usageLimitations", "CodeableConcept", "What limits apply to the use of the data.", 0, Integer.MAX_VALUE, this.usageLimitations);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.intent;
                }
                return baseArray;
            }
            case -373242253: {
                Base[] baseArray;
                if (this.asserter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.asserter;
                }
                return baseArray;
            }
            case -1498338864: {
                return this.assertionDate == null ? new Base[]{} : this.assertionDate.toArray(new Base[this.assertionDate.size()]);
            }
            case -1421265102: {
                Base[] baseArray;
                if (this.validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.validity;
                }
                return baseArray;
            }
            case -220463842: {
                return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
            }
            case -374957878: {
                return this.dataScope == null ? new Base[]{} : this.dataScope.toArray(new Base[this.dataScope.size()]);
            }
            case -2117745854: {
                return this.processingActivity == null ? new Base[]{} : this.processingActivity.toArray(new Base[this.processingActivity.size()]);
            }
            case 1864993522: {
                Base[] baseArray;
                if (this.justification == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.justification;
                }
                return baseArray;
            }
            case -788364488: {
                return this.usageLimitations == null ? new Base[]{} : this.usageLimitations.toArray(new Base[this.usageLimitations.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -892481550: {
                value = new PermissionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                this.intent = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -373242253: {
                this.asserter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1498338864: {
                this.getAssertionDate().add(TypeConvertor.castToDateTime(value));
                return value;
            }
            case -1421265102: {
                this.validity = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -220463842: {
                this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -374957878: {
                this.getDataScope().add(TypeConvertor.castToExpression(value));
                return value;
            }
            case -2117745854: {
                this.getProcessingActivity().add((PermissionProcessingActivityComponent)((Object)value));
                return value;
            }
            case 1864993522: {
                this.justification = (PermissionJustificationComponent)((Object)value);
                return value;
            }
            case -788364488: {
                this.getUsageLimitations().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            value = new PermissionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("intent")) {
            this.intent = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("asserter")) {
            this.asserter = TypeConvertor.castToReference(value);
        } else if (name.equals("assertionDate")) {
            this.getAssertionDate().add(TypeConvertor.castToDateTime(value));
        } else if (name.equals("validity")) {
            this.validity = TypeConvertor.castToPeriod(value);
        } else if (name.equals("purpose")) {
            this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("dataScope")) {
            this.getDataScope().add(TypeConvertor.castToExpression(value));
        } else if (name.equals("processingActivity")) {
            this.getProcessingActivity().add((PermissionProcessingActivityComponent)((Object)value));
        } else if (name.equals("justification")) {
            this.justification = (PermissionJustificationComponent)((Object)value);
        } else if (name.equals("usageLimitations")) {
            this.getUsageLimitations().add(TypeConvertor.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntent();
            }
            case -373242253: {
                return this.getAsserter();
            }
            case -1498338864: {
                return this.addAssertionDateElement();
            }
            case -1421265102: {
                return this.getValidity();
            }
            case -220463842: {
                return this.addPurpose();
            }
            case -374957878: {
                return this.addDataScope();
            }
            case -2117745854: {
                return this.addProcessingActivity();
            }
            case 1864993522: {
                return this.getJustification();
            }
            case -788364488: {
                return this.addUsageLimitations();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"CodeableConcept"};
            }
            case -373242253: {
                return new String[]{"Reference"};
            }
            case -1498338864: {
                return new String[]{"dateTime"};
            }
            case -1421265102: {
                return new String[]{"Period"};
            }
            case -220463842: {
                return new String[]{"CodeableConcept"};
            }
            case -374957878: {
                return new String[]{"Expression"};
            }
            case -2117745854: {
                return new String[0];
            }
            case 1864993522: {
                return new String[0];
            }
            case -788364488: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Permission.status");
        }
        if (name.equals("intent")) {
            this.intent = new CodeableConcept();
            return this.intent;
        }
        if (name.equals("asserter")) {
            this.asserter = new Reference();
            return this.asserter;
        }
        if (name.equals("assertionDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Permission.assertionDate");
        }
        if (name.equals("validity")) {
            this.validity = new Period();
            return this.validity;
        }
        if (name.equals("purpose")) {
            return this.addPurpose();
        }
        if (name.equals("dataScope")) {
            return this.addDataScope();
        }
        if (name.equals("processingActivity")) {
            return this.addProcessingActivity();
        }
        if (name.equals("justification")) {
            this.justification = new PermissionJustificationComponent();
            return this.justification;
        }
        if (name.equals("usageLimitations")) {
            return this.addUsageLimitations();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Permission";
    }

    @Override
    public Permission copy() {
        Permission dst = new Permission();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Permission dst) {
        super.copyValues(dst);
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        Reference reference = dst.asserter = this.asserter == null ? null : this.asserter.copy();
        if (this.assertionDate != null) {
            dst.assertionDate = new ArrayList<DateTimeType>();
            for (DateTimeType dateTimeType : this.assertionDate) {
                dst.assertionDate.add(dateTimeType.copy());
            }
        }
        Period period = dst.validity = this.validity == null ? null : this.validity.copy();
        if (this.purpose != null) {
            dst.purpose = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.purpose) {
                dst.purpose.add(codeableConcept.copy());
            }
        }
        if (this.dataScope != null) {
            dst.dataScope = new ArrayList<Expression>();
            for (Expression expression : this.dataScope) {
                dst.dataScope.add(expression.copy());
            }
        }
        if (this.processingActivity != null) {
            dst.processingActivity = new ArrayList<PermissionProcessingActivityComponent>();
            for (PermissionProcessingActivityComponent permissionProcessingActivityComponent : this.processingActivity) {
                dst.processingActivity.add(permissionProcessingActivityComponent.copy());
            }
        }
        PermissionJustificationComponent permissionJustificationComponent = dst.justification = this.justification == null ? null : this.justification.copy();
        if (this.usageLimitations != null) {
            dst.usageLimitations = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.usageLimitations) {
                dst.usageLimitations.add(codeableConcept.copy());
            }
        }
    }

    protected Permission typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Permission)) {
            return false;
        }
        Permission o = (Permission)other_;
        return Permission.compareDeep(this.status, o.status, true) && Permission.compareDeep(this.intent, o.intent, true) && Permission.compareDeep(this.asserter, o.asserter, true) && Permission.compareDeep(this.assertionDate, o.assertionDate, true) && Permission.compareDeep(this.validity, o.validity, true) && Permission.compareDeep(this.purpose, o.purpose, true) && Permission.compareDeep(this.dataScope, o.dataScope, true) && Permission.compareDeep(this.processingActivity, o.processingActivity, true) && Permission.compareDeep(this.justification, o.justification, true) && Permission.compareDeep(this.usageLimitations, o.usageLimitations, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Permission)) {
            return false;
        }
        Permission o = (Permission)other_;
        return Permission.compareValues(this.status, o.status, true) && Permission.compareValues(this.assertionDate, o.assertionDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.intent, this.asserter, this.assertionDate, this.validity, this.purpose, this.dataScope, this.processingActivity, this.justification, this.usageLimitations});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Permission;
    }

    @Block
    public static class PermissionJustificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="evidence", type={Consent.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Evidence \u2013 reference to consent, or a contract, or a policy, or a regulation, or an attachment that contains a screenshot", formalDefinition="Evidence \u2013 reference to consent, or a contract, or a policy, or a regulation, or an attachment that contains a screenshot.")
        protected List<Reference> evidence;
        @Child(name="grounds", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR", formalDefinition="This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.")
        protected List<CodeableConcept> grounds;
        private static final long serialVersionUID = -146214493L;

        public List<Reference> getEvidence() {
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            return this.evidence;
        }

        public PermissionJustificationComponent setEvidence(List<Reference> theEvidence) {
            this.evidence = theEvidence;
            return this;
        }

        public boolean hasEvidence() {
            if (this.evidence == null) {
                return false;
            }
            for (Reference item : this.evidence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEvidence() {
            Reference t = new Reference();
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            this.evidence.add(t);
            return t;
        }

        public PermissionJustificationComponent addEvidence(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.evidence == null) {
                this.evidence = new ArrayList<Reference>();
            }
            this.evidence.add(t);
            return this;
        }

        public Reference getEvidenceFirstRep() {
            if (this.getEvidence().isEmpty()) {
                this.addEvidence();
            }
            return this.getEvidence().get(0);
        }

        public List<CodeableConcept> getGrounds() {
            if (this.grounds == null) {
                this.grounds = new ArrayList<CodeableConcept>();
            }
            return this.grounds;
        }

        public PermissionJustificationComponent setGrounds(List<CodeableConcept> theGrounds) {
            this.grounds = theGrounds;
            return this;
        }

        public boolean hasGrounds() {
            if (this.grounds == null) {
                return false;
            }
            for (CodeableConcept item : this.grounds) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addGrounds() {
            CodeableConcept t = new CodeableConcept();
            if (this.grounds == null) {
                this.grounds = new ArrayList<CodeableConcept>();
            }
            this.grounds.add(t);
            return t;
        }

        public PermissionJustificationComponent addGrounds(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.grounds == null) {
                this.grounds = new ArrayList<CodeableConcept>();
            }
            this.grounds.add(t);
            return this;
        }

        public CodeableConcept getGroundsFirstRep() {
            if (this.getGrounds().isEmpty()) {
                this.addGrounds();
            }
            return this.getGrounds().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("evidence", "Reference(Consent)", "Evidence \u2013 reference to consent, or a contract, or a policy, or a regulation, or an attachment that contains a screenshot.", 0, Integer.MAX_VALUE, this.evidence));
            children.add(new Property("grounds", "CodeableConcept", "This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.", 0, Integer.MAX_VALUE, this.grounds));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 382967383: {
                    return new Property("evidence", "Reference(Consent)", "Evidence \u2013 reference to consent, or a contract, or a policy, or a regulation, or an attachment that contains a screenshot.", 0, Integer.MAX_VALUE, this.evidence);
                }
                case 293427148: {
                    return new Property("grounds", "CodeableConcept", "This would be a codeableconcept, or a coding, which can be constrained to , for example, the 6 grounds for processing in GDPR.", 0, Integer.MAX_VALUE, this.grounds);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 382967383: {
                    return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
                }
                case 293427148: {
                    return this.grounds == null ? new Base[]{} : this.grounds.toArray(new Base[this.grounds.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 382967383: {
                    this.getEvidence().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 293427148: {
                    this.getGrounds().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("evidence")) {
                this.getEvidence().add(TypeConvertor.castToReference(value));
            } else if (name.equals("grounds")) {
                this.getGrounds().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 382967383: {
                    return this.addEvidence();
                }
                case 293427148: {
                    return this.addGrounds();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 382967383: {
                    return new String[]{"Reference"};
                }
                case 293427148: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("evidence")) {
                return this.addEvidence();
            }
            if (name.equals("grounds")) {
                return this.addGrounds();
            }
            return super.addChild(name);
        }

        @Override
        public PermissionJustificationComponent copy() {
            PermissionJustificationComponent dst = new PermissionJustificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PermissionJustificationComponent dst) {
            super.copyValues(dst);
            if (this.evidence != null) {
                dst.evidence = new ArrayList<Reference>();
                for (Reference reference : this.evidence) {
                    dst.evidence.add(reference.copy());
                }
            }
            if (this.grounds != null) {
                dst.grounds = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.grounds) {
                    dst.grounds.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionJustificationComponent)) {
                return false;
            }
            PermissionJustificationComponent o = (PermissionJustificationComponent)other_;
            return PermissionJustificationComponent.compareDeep(this.evidence, o.evidence, true) && PermissionJustificationComponent.compareDeep(this.grounds, o.grounds, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionJustificationComponent)) {
                return false;
            }
            PermissionJustificationComponent o = (PermissionJustificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.evidence, this.grounds});
        }

        @Override
        public String fhirType() {
            return "Permission.justification";
        }
    }

    @Block
    public static class PermissionProcessingActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="partyReference", type={Organization.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="If the processing is a transfer, we must capture where it the data allowed or expected to be shared - with a party or person", formalDefinition="If the processing is a transfer, we must capture where it the data allowed or expected to be shared - with a party or person.")
        protected List<Reference> partyReference;
        @Child(name="partyCodeableConcept", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="If the processing is a transfer, or involves another party, we must capture where it the data allowed or expected to be shared - with a party or person. This can be a party instance or party type\n\u00a7 Purpose \u2013 a specific purpose of the data", formalDefinition="If the processing is a transfer, or involves another party, we must capture where it the data allowed or expected to be shared - with a party or person. This can be a party instance or party type\n\u00a7 Purpose \u2013 a specific purpose of the data.")
        protected List<CodeableConcept> partyCodeableConcept;
        @Child(name="purpose", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The purpose for which the permission is given", formalDefinition="The purpose for which the permission is given.")
        protected List<CodeableConcept> purpose;
        private static final long serialVersionUID = -1556351771L;

        public List<Reference> getPartyReference() {
            if (this.partyReference == null) {
                this.partyReference = new ArrayList<Reference>();
            }
            return this.partyReference;
        }

        public PermissionProcessingActivityComponent setPartyReference(List<Reference> thePartyReference) {
            this.partyReference = thePartyReference;
            return this;
        }

        public boolean hasPartyReference() {
            if (this.partyReference == null) {
                return false;
            }
            for (Reference item : this.partyReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPartyReference() {
            Reference t = new Reference();
            if (this.partyReference == null) {
                this.partyReference = new ArrayList<Reference>();
            }
            this.partyReference.add(t);
            return t;
        }

        public PermissionProcessingActivityComponent addPartyReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.partyReference == null) {
                this.partyReference = new ArrayList<Reference>();
            }
            this.partyReference.add(t);
            return this;
        }

        public Reference getPartyReferenceFirstRep() {
            if (this.getPartyReference().isEmpty()) {
                this.addPartyReference();
            }
            return this.getPartyReference().get(0);
        }

        public List<CodeableConcept> getPartyCodeableConcept() {
            if (this.partyCodeableConcept == null) {
                this.partyCodeableConcept = new ArrayList<CodeableConcept>();
            }
            return this.partyCodeableConcept;
        }

        public PermissionProcessingActivityComponent setPartyCodeableConcept(List<CodeableConcept> thePartyCodeableConcept) {
            this.partyCodeableConcept = thePartyCodeableConcept;
            return this;
        }

        public boolean hasPartyCodeableConcept() {
            if (this.partyCodeableConcept == null) {
                return false;
            }
            for (CodeableConcept item : this.partyCodeableConcept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPartyCodeableConcept() {
            CodeableConcept t = new CodeableConcept();
            if (this.partyCodeableConcept == null) {
                this.partyCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.partyCodeableConcept.add(t);
            return t;
        }

        public PermissionProcessingActivityComponent addPartyCodeableConcept(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.partyCodeableConcept == null) {
                this.partyCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.partyCodeableConcept.add(t);
            return this;
        }

        public CodeableConcept getPartyCodeableConceptFirstRep() {
            if (this.getPartyCodeableConcept().isEmpty()) {
                this.addPartyCodeableConcept();
            }
            return this.getPartyCodeableConcept().get(0);
        }

        public List<CodeableConcept> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            return this.purpose;
        }

        public PermissionProcessingActivityComponent setPurpose(List<CodeableConcept> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (CodeableConcept item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPurpose() {
            CodeableConcept t = new CodeableConcept();
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            this.purpose.add(t);
            return t;
        }

        public PermissionProcessingActivityComponent addPurpose(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<CodeableConcept>();
            }
            this.purpose.add(t);
            return this;
        }

        public CodeableConcept getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("partyReference", "Reference(Organization)", "If the processing is a transfer, we must capture where it the data allowed or expected to be shared - with a party or person.", 0, Integer.MAX_VALUE, this.partyReference));
            children.add(new Property("partyCodeableConcept", "CodeableConcept", "If the processing is a transfer, or involves another party, we must capture where it the data allowed or expected to be shared - with a party or person. This can be a party instance or party type\n\u00a7 Purpose \u2013 a specific purpose of the data.", 0, Integer.MAX_VALUE, this.partyCodeableConcept));
            children.add(new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -865196283: {
                    return new Property("partyReference", "Reference(Organization)", "If the processing is a transfer, we must capture where it the data allowed or expected to be shared - with a party or person.", 0, Integer.MAX_VALUE, this.partyReference);
                }
                case -1283677221: {
                    return new Property("partyCodeableConcept", "CodeableConcept", "If the processing is a transfer, or involves another party, we must capture where it the data allowed or expected to be shared - with a party or person. This can be a party instance or party type\n\u00a7 Purpose \u2013 a specific purpose of the data.", 0, Integer.MAX_VALUE, this.partyCodeableConcept);
                }
                case -220463842: {
                    return new Property("purpose", "CodeableConcept", "The purpose for which the permission is given.", 0, Integer.MAX_VALUE, this.purpose);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -865196283: {
                    return this.partyReference == null ? new Base[]{} : this.partyReference.toArray(new Base[this.partyReference.size()]);
                }
                case -1283677221: {
                    return this.partyCodeableConcept == null ? new Base[]{} : this.partyCodeableConcept.toArray(new Base[this.partyCodeableConcept.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -865196283: {
                    this.getPartyReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1283677221: {
                    this.getPartyCodeableConcept().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("partyReference")) {
                this.getPartyReference().add(TypeConvertor.castToReference(value));
            } else if (name.equals("partyCodeableConcept")) {
                this.getPartyCodeableConcept().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("purpose")) {
                this.getPurpose().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -865196283: {
                    return this.addPartyReference();
                }
                case -1283677221: {
                    return this.addPartyCodeableConcept();
                }
                case -220463842: {
                    return this.addPurpose();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -865196283: {
                    return new String[]{"Reference"};
                }
                case -1283677221: {
                    return new String[]{"CodeableConcept"};
                }
                case -220463842: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("partyReference")) {
                return this.addPartyReference();
            }
            if (name.equals("partyCodeableConcept")) {
                return this.addPartyCodeableConcept();
            }
            if (name.equals("purpose")) {
                return this.addPurpose();
            }
            return super.addChild(name);
        }

        @Override
        public PermissionProcessingActivityComponent copy() {
            PermissionProcessingActivityComponent dst = new PermissionProcessingActivityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PermissionProcessingActivityComponent dst) {
            super.copyValues(dst);
            if (this.partyReference != null) {
                dst.partyReference = new ArrayList<Reference>();
                for (Reference reference : this.partyReference) {
                    dst.partyReference.add(reference.copy());
                }
            }
            if (this.partyCodeableConcept != null) {
                dst.partyCodeableConcept = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.partyCodeableConcept) {
                    dst.partyCodeableConcept.add(codeableConcept.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.purpose) {
                    dst.purpose.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionProcessingActivityComponent)) {
                return false;
            }
            PermissionProcessingActivityComponent o = (PermissionProcessingActivityComponent)other_;
            return PermissionProcessingActivityComponent.compareDeep(this.partyReference, o.partyReference, true) && PermissionProcessingActivityComponent.compareDeep(this.partyCodeableConcept, o.partyCodeableConcept, true) && PermissionProcessingActivityComponent.compareDeep(this.purpose, o.purpose, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PermissionProcessingActivityComponent)) {
                return false;
            }
            PermissionProcessingActivityComponent o = (PermissionProcessingActivityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.partyReference, this.partyCodeableConcept, this.purpose});
        }

        @Override
        public String fhirType() {
            return "Permission.processingActivity";
        }
    }

    public static class PermissionStatusEnumFactory
    implements EnumFactory<PermissionStatus> {
        @Override
        public PermissionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return PermissionStatus.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return PermissionStatus.ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return PermissionStatus.DRAFT;
            }
            if ("rejected".equals(codeString)) {
                return PermissionStatus.REJECTED;
            }
            throw new IllegalArgumentException("Unknown PermissionStatus code '" + codeString + "'");
        }

        public Enumeration<PermissionStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PermissionStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.ACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.ENTEREDINERROR);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.DRAFT);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<PermissionStatus>(this, PermissionStatus.REJECTED);
            }
            throw new FHIRException("Unknown PermissionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(PermissionStatus code) {
            if (code == PermissionStatus.ACTIVE) {
                return "active";
            }
            if (code == PermissionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == PermissionStatus.DRAFT) {
                return "draft";
            }
            if (code == PermissionStatus.REJECTED) {
                return "rejected";
            }
            return "?";
        }

        @Override
        public String toSystem(PermissionStatus code) {
            return code.getSystem();
        }
    }

    public static enum PermissionStatus {
        ACTIVE,
        ENTEREDINERROR,
        DRAFT,
        REJECTED,
        NULL;


        public static PermissionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PermissionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case DRAFT: {
                    return "draft";
                }
                case REJECTED: {
                    return "rejected";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/permission-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/permission-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "Permission is given.";
                }
                case ENTEREDINERROR: {
                    return "Permission was entered in error and is not active.";
                }
                case DRAFT: {
                    return "Permission is being defined.";
                }
                case REJECTED: {
                    return "Permission not granted.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case DRAFT: {
                    return "Draft";
                }
                case REJECTED: {
                    return "Rejected";
                }
            }
            return "?";
        }
    }
}

