/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ConceptMap2;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/StructureDefinition/DiagnosticReport")
public class DiagnosticReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for report", formalDefinition="Identifiers assigned to this report by the performer or other systems.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was requested", formalDefinition="Details concerning a service requested.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | partial | preliminary | final +", formalDefinition="The status of the diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-report-status")
    protected Enumeration<DiagnosticReportStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Service category", formalDefinition="A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-service-sections")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name/Code for this diagnostic report", formalDefinition="A code or name that describes this diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the report - usually, but not always, the patient", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Health care event when test ordered", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for report", formalDefinition="The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.")
    protected DataType effective;
    @Child(name="issued", type={InstantType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DateTime this version was made", formalDefinition="The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible Diagnostic Service", formalDefinition="The diagnostic service that is responsible for issuing the report.")
    protected List<Reference> performer;
    @Child(name="resultsInterpreter", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Primary result interpreter", formalDefinition="The practitioner or organization that is responsible for the report's conclusions and interpretations.")
    protected List<Reference> resultsInterpreter;
    @Child(name="specimen", type={Specimen.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimens this report is based on", formalDefinition="Details about the specimens on which this diagnostic report is based.")
    protected List<Reference> specimen;
    @Child(name="result", type={Observation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations", formalDefinition="[Observations](observation.html)  that are part of this diagnostic report.")
    protected List<Reference> result;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the diagnostic report", formalDefinition="Comments about the diagnostic report.")
    protected List<Annotation> note;
    @Child(name="imagingStudy", type={ImagingStudy.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to full details of imaging associated with the diagnostic report", formalDefinition="One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.")
    protected List<Reference> imagingStudy;
    @Child(name="media", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Key images or data associated with this report", formalDefinition="A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).")
    protected List<DiagnosticReportMediaComponent> media;
    @Child(name="composition", type={Composition.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to a Composition resource for the DiagnosticReport structure", formalDefinition="Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.")
    protected Reference composition;
    @Child(name="conclusion", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical conclusion (interpretation) of test results", formalDefinition="Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.")
    protected StringType conclusion;
    @Child(name="conclusionCode", type={CodeableConcept.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Codes for the clinical conclusion of test results", formalDefinition="One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> conclusionCode;
    @Child(name="presentedForm", type={Attachment.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entire report as issued", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    protected List<Attachment> presentedForm;
    private static final long serialVersionUID = -491814069L;
    @SearchParamDefinition(name="based-on", path="DiagnosticReport.basedOn", description="Reference to the service request.", type="reference", target={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DiagnosticReport:based-on").toLocked();
    @SearchParamDefinition(name="category", path="DiagnosticReport.category", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="conclusion", path="DiagnosticReport.conclusionCode", description="A coded conclusion (interpretation/impression) on the report", type="token")
    public static final String SP_CONCLUSION = "conclusion";
    public static final TokenClientParam CONCLUSION = new TokenClientParam("conclusion");
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="media", path="DiagnosticReport.media.link", description="A reference to the image source.", type="reference", target={DocumentReference.class})
    public static final String SP_MEDIA = "media";
    public static final ReferenceClientParam MEDIA = new ReferenceClientParam("media");
    public static final Include INCLUDE_MEDIA = new Include("DiagnosticReport:media").toLocked();
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer", description="Who is responsible for the report", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={CareTeam.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("DiagnosticReport:performer").toLocked();
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference", target={Observation.class})
    public static final String SP_RESULT = "result";
    public static final ReferenceClientParam RESULT = new ReferenceClientParam("result");
    public static final Include INCLUDE_RESULT = new Include("DiagnosticReport:result").toLocked();
    @SearchParamDefinition(name="results-interpreter", path="DiagnosticReport.resultsInterpreter", description="Who was the source of the report", type="reference", target={CareTeam.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_RESULTS_INTERPRETER = "results-interpreter";
    public static final ReferenceClientParam RESULTS_INTERPRETER = new ReferenceClientParam("results-interpreter");
    public static final Include INCLUDE_RESULTS_INTERPRETER = new Include("DiagnosticReport:results-interpreter").toLocked();
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticReport:specimen").toLocked();
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticReport:subject").toLocked();
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code | ServiceRequest.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [ServiceRequest](servicerequest.html): What is being requested/ordered\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | DocumentReference.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [DocumentReference](documentreference.html): Context of the document  content\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticReport:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, ConceptMap2.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DiagnosticReport:patient").toLocked();

    public DiagnosticReport() {
    }

    public DiagnosticReport(DiagnosticReportStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DiagnosticReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DiagnosticReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DiagnosticReport setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DiagnosticReport addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<DiagnosticReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DiagnosticReport setStatusElement(Enumeration<DiagnosticReportStatus> value) {
        this.status = value;
        return this;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status == null ? null : (DiagnosticReportStatus)((Object)this.status.getValue());
    }

    public DiagnosticReport setStatus(DiagnosticReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DiagnosticReport setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DiagnosticReport addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DiagnosticReport setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DiagnosticReport setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DiagnosticReport setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public DiagnosticReport setEffective(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for DiagnosticReport.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public DiagnosticReport setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public DiagnosticReport setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public DiagnosticReport setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public DiagnosticReport addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Reference> getResultsInterpreter() {
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        return this.resultsInterpreter;
    }

    public DiagnosticReport setResultsInterpreter(List<Reference> theResultsInterpreter) {
        this.resultsInterpreter = theResultsInterpreter;
        return this;
    }

    public boolean hasResultsInterpreter() {
        if (this.resultsInterpreter == null) {
            return false;
        }
        for (Reference item : this.resultsInterpreter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResultsInterpreter() {
        Reference t = new Reference();
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        this.resultsInterpreter.add(t);
        return t;
    }

    public DiagnosticReport addResultsInterpreter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        this.resultsInterpreter.add(t);
        return this;
    }

    public Reference getResultsInterpreterFirstRep() {
        if (this.getResultsInterpreter().isEmpty()) {
            this.addResultsInterpreter();
        }
        return this.getResultsInterpreter().get(0);
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public DiagnosticReport setSpecimen(List<Reference> theSpecimen) {
        this.specimen = theSpecimen;
        return this;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public DiagnosticReport addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public Reference getSpecimenFirstRep() {
        if (this.getSpecimen().isEmpty()) {
            this.addSpecimen();
        }
        return this.getSpecimen().get(0);
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public DiagnosticReport setResult(List<Reference> theResult) {
        this.result = theResult;
        return this;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public DiagnosticReport addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public Reference getResultFirstRep() {
        if (this.getResult().isEmpty()) {
            this.addResult();
        }
        return this.getResult().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DiagnosticReport setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DiagnosticReport addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getImagingStudy() {
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        return this.imagingStudy;
    }

    public DiagnosticReport setImagingStudy(List<Reference> theImagingStudy) {
        this.imagingStudy = theImagingStudy;
        return this;
    }

    public boolean hasImagingStudy() {
        if (this.imagingStudy == null) {
            return false;
        }
        for (Reference item : this.imagingStudy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImagingStudy() {
        Reference t = new Reference();
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return t;
    }

    public DiagnosticReport addImagingStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return this;
    }

    public Reference getImagingStudyFirstRep() {
        if (this.getImagingStudy().isEmpty()) {
            this.addImagingStudy();
        }
        return this.getImagingStudy().get(0);
    }

    public List<DiagnosticReportMediaComponent> getMedia() {
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        return this.media;
    }

    public DiagnosticReport setMedia(List<DiagnosticReportMediaComponent> theMedia) {
        this.media = theMedia;
        return this;
    }

    public boolean hasMedia() {
        if (this.media == null) {
            return false;
        }
        for (DiagnosticReportMediaComponent item : this.media) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportMediaComponent addMedia() {
        DiagnosticReportMediaComponent t = new DiagnosticReportMediaComponent();
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        this.media.add(t);
        return t;
    }

    public DiagnosticReport addMedia(DiagnosticReportMediaComponent t) {
        if (t == null) {
            return this;
        }
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        this.media.add(t);
        return this;
    }

    public DiagnosticReportMediaComponent getMediaFirstRep() {
        if (this.getMedia().isEmpty()) {
            this.addMedia();
        }
        return this.getMedia().get(0);
    }

    public Reference getComposition() {
        if (this.composition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.composition");
            }
            if (Configuration.doAutoCreate()) {
                this.composition = new Reference();
            }
        }
        return this.composition;
    }

    public boolean hasComposition() {
        return this.composition != null && !this.composition.isEmpty();
    }

    public DiagnosticReport setComposition(Reference value) {
        this.composition = value;
        return this;
    }

    public StringType getConclusionElement() {
        if (this.conclusion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.conclusion");
            }
            if (Configuration.doAutoCreate()) {
                this.conclusion = new StringType();
            }
        }
        return this.conclusion;
    }

    public boolean hasConclusionElement() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public boolean hasConclusion() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public DiagnosticReport setConclusionElement(StringType value) {
        this.conclusion = value;
        return this;
    }

    public String getConclusion() {
        return this.conclusion == null ? null : (String)this.conclusion.getValue();
    }

    public DiagnosticReport setConclusion(String value) {
        if (Utilities.noString((String)value)) {
            this.conclusion = null;
        } else {
            if (this.conclusion == null) {
                this.conclusion = new StringType();
            }
            this.conclusion.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getConclusionCode() {
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        return this.conclusionCode;
    }

    public DiagnosticReport setConclusionCode(List<CodeableConcept> theConclusionCode) {
        this.conclusionCode = theConclusionCode;
        return this;
    }

    public boolean hasConclusionCode() {
        if (this.conclusionCode == null) {
            return false;
        }
        for (CodeableConcept item : this.conclusionCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addConclusionCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        this.conclusionCode.add(t);
        return t;
    }

    public DiagnosticReport addConclusionCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        this.conclusionCode.add(t);
        return this;
    }

    public CodeableConcept getConclusionCodeFirstRep() {
        if (this.getConclusionCode().isEmpty()) {
            this.addConclusionCode();
        }
        return this.getConclusionCode().get(0);
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public DiagnosticReport setPresentedForm(List<Attachment> thePresentedForm) {
        this.presentedForm = thePresentedForm;
        return this;
    }

    public boolean hasPresentedForm() {
        if (this.presentedForm == null) {
            return false;
        }
        for (Attachment item : this.presentedForm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPresentedForm() {
        Attachment t = new Attachment();
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return t;
    }

    public DiagnosticReport addPresentedForm(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return this;
    }

    public Attachment getPresentedFormFirstRep() {
        if (this.getPresentedForm().isEmpty()) {
            this.addPresentedForm();
        }
        return this.getPresentedForm().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this report by the performer or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "Details concerning a service requested.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct)", "The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective));
        children.add(new Property(SP_ISSUED, "instant", "The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.", 0, 1, this.issued));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("resultsInterpreter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The practitioner or organization that is responsible for the report's conclusions and interpretations.", 0, Integer.MAX_VALUE, this.resultsInterpreter));
        children.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen));
        children.add(new Property(SP_RESULT, "Reference(Observation)", "[Observations](observation.html)  that are part of this diagnostic report.", 0, Integer.MAX_VALUE, this.result));
        children.add(new Property("note", "Annotation", "Comments about the diagnostic report.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("imagingStudy", "Reference(ImagingStudy)", "One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.", 0, Integer.MAX_VALUE, this.imagingStudy));
        children.add(new Property(SP_MEDIA, "", "A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.media));
        children.add(new Property("composition", "Reference(Composition)", "Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.", 0, 1, this.composition));
        children.add(new Property(SP_CONCLUSION, "string", "Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.", 0, 1, this.conclusion));
        children.add(new Property("conclusionCode", "CodeableConcept", "One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusionCode));
        children.add(new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this report by the performer or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "Details concerning a service requested.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct)", "The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "instant", "The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.", 0, 1, this.issued);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 2134944932: {
                return new Property("resultsInterpreter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The practitioner or organization that is responsible for the report's conclusions and interpretations.", 0, Integer.MAX_VALUE, this.resultsInterpreter);
            }
            case -2132868344: {
                return new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen);
            }
            case -934426595: {
                return new Property(SP_RESULT, "Reference(Observation)", "[Observations](observation.html)  that are part of this diagnostic report.", 0, Integer.MAX_VALUE, this.result);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments about the diagnostic report.", 0, Integer.MAX_VALUE, this.note);
            }
            case -814900911: {
                return new Property("imagingStudy", "Reference(ImagingStudy)", "One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.", 0, Integer.MAX_VALUE, this.imagingStudy);
            }
            case 103772132: {
                return new Property(SP_MEDIA, "", "A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.media);
            }
            case -838923862: {
                return new Property("composition", "Reference(Composition)", "Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.", 0, 1, this.composition);
            }
            case -1731259873: {
                return new Property(SP_CONCLUSION, "string", "Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.", 0, 1, this.conclusion);
            }
            case -1731523412: {
                return new Property("conclusionCode", "CodeableConcept", "One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusionCode);
            }
            case 230090366: {
                return new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.effective;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 2134944932: {
                return this.resultsInterpreter == null ? new Base[]{} : this.resultsInterpreter.toArray(new Base[this.resultsInterpreter.size()]);
            }
            case -2132868344: {
                return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
            }
            case -934426595: {
                return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -814900911: {
                return this.imagingStudy == null ? new Base[]{} : this.imagingStudy.toArray(new Base[this.imagingStudy.size()]);
            }
            case 103772132: {
                return this.media == null ? new Base[]{} : this.media.toArray(new Base[this.media.size()]);
            }
            case -838923862: {
                Base[] baseArray;
                if (this.composition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.composition;
                }
                return baseArray;
            }
            case -1731259873: {
                Base[] baseArray;
                if (this.conclusion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.conclusion;
                }
                return baseArray;
            }
            case -1731523412: {
                return this.conclusionCode == null ? new Base[]{} : this.conclusionCode.toArray(new Base[this.conclusionCode.size()]);
            }
            case 230090366: {
                return this.presentedForm == null ? new Base[]{} : this.presentedForm.toArray(new Base[this.presentedForm.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DiagnosticReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = TypeConvertor.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 2134944932: {
                this.getResultsInterpreter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -2132868344: {
                this.getSpecimen().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -934426595: {
                this.getResult().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -814900911: {
                this.getImagingStudy().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 103772132: {
                this.getMedia().add((DiagnosticReportMediaComponent)((Object)value));
                return value;
            }
            case -838923862: {
                this.composition = TypeConvertor.castToReference(value);
                return value;
            }
            case -1731259873: {
                this.conclusion = TypeConvertor.castToString(value);
                return value;
            }
            case -1731523412: {
                this.getConclusionCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 230090366: {
                this.getPresentedForm().add(TypeConvertor.castToAttachment(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DiagnosticReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("resultsInterpreter")) {
            this.getResultsInterpreter().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_RESULT)) {
            this.getResult().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("imagingStudy")) {
            this.getImagingStudy().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_MEDIA)) {
            this.getMedia().add((DiagnosticReportMediaComponent)((Object)value));
        } else if (name.equals("composition")) {
            this.composition = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONCLUSION)) {
            this.conclusion = TypeConvertor.castToString(value);
        } else if (name.equals("conclusionCode")) {
            this.getConclusionCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("presentedForm")) {
            this.getPresentedForm().add(TypeConvertor.castToAttachment(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 2134944932: {
                return this.addResultsInterpreter();
            }
            case -2132868344: {
                return this.addSpecimen();
            }
            case -934426595: {
                return this.addResult();
            }
            case 3387378: {
                return this.addNote();
            }
            case -814900911: {
                return this.addImagingStudy();
            }
            case 103772132: {
                return this.addMedia();
            }
            case -838923862: {
                return this.getComposition();
            }
            case -1731259873: {
                return this.getConclusionElement();
            }
            case -1731523412: {
                return this.addConclusionCode();
            }
            case 230090366: {
                return this.addPresentedForm();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 2134944932: {
                return new String[]{"Reference"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -814900911: {
                return new String[]{"Reference"};
            }
            case 103772132: {
                return new String[0];
            }
            case -838923862: {
                return new String[]{"Reference"};
            }
            case -1731259873: {
                return new String[]{"string"};
            }
            case -1731523412: {
                return new String[]{"CodeableConcept"};
            }
            case 230090366: {
                return new String[]{"Attachment"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("resultsInterpreter")) {
            return this.addResultsInterpreter();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals(SP_RESULT)) {
            return this.addResult();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("imagingStudy")) {
            return this.addImagingStudy();
        }
        if (name.equals(SP_MEDIA)) {
            return this.addMedia();
        }
        if (name.equals("composition")) {
            this.composition = new Reference();
            return this.composition;
        }
        if (name.equals(SP_CONCLUSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.conclusion");
        }
        if (name.equals("conclusionCode")) {
            return this.addConclusionCode();
        }
        if (name.equals("presentedForm")) {
            return this.addPresentedForm();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DiagnosticReport";
    }

    @Override
    public DiagnosticReport copy() {
        DiagnosticReport dst = new DiagnosticReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DiagnosticReport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Enumeration<DiagnosticReportStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        if (this.resultsInterpreter != null) {
            dst.resultsInterpreter = new ArrayList<Reference>();
            for (Reference reference : this.resultsInterpreter) {
                dst.resultsInterpreter.add(reference.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference : this.specimen) {
                dst.specimen.add(reference.copy());
            }
        }
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference : this.result) {
                dst.result.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.imagingStudy != null) {
            dst.imagingStudy = new ArrayList<Reference>();
            for (Reference reference : this.imagingStudy) {
                dst.imagingStudy.add(reference.copy());
            }
        }
        if (this.media != null) {
            dst.media = new ArrayList<DiagnosticReportMediaComponent>();
            for (DiagnosticReportMediaComponent diagnosticReportMediaComponent : this.media) {
                dst.media.add(diagnosticReportMediaComponent.copy());
            }
        }
        dst.composition = this.composition == null ? null : this.composition.copy();
        StringType stringType = dst.conclusion = this.conclusion == null ? null : this.conclusion.copy();
        if (this.conclusionCode != null) {
            dst.conclusionCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.conclusionCode) {
                dst.conclusionCode.add(codeableConcept.copy());
            }
        }
        if (this.presentedForm != null) {
            dst.presentedForm = new ArrayList<Attachment>();
            for (Attachment attachment : this.presentedForm) {
                dst.presentedForm.add(attachment.copy());
            }
        }
    }

    protected DiagnosticReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other_;
        return DiagnosticReport.compareDeep(this.identifier, o.identifier, true) && DiagnosticReport.compareDeep(this.basedOn, o.basedOn, true) && DiagnosticReport.compareDeep(this.status, o.status, true) && DiagnosticReport.compareDeep(this.category, o.category, true) && DiagnosticReport.compareDeep(this.code, o.code, true) && DiagnosticReport.compareDeep(this.subject, o.subject, true) && DiagnosticReport.compareDeep(this.encounter, o.encounter, true) && DiagnosticReport.compareDeep(this.effective, o.effective, true) && DiagnosticReport.compareDeep(this.issued, o.issued, true) && DiagnosticReport.compareDeep(this.performer, o.performer, true) && DiagnosticReport.compareDeep(this.resultsInterpreter, o.resultsInterpreter, true) && DiagnosticReport.compareDeep(this.specimen, o.specimen, true) && DiagnosticReport.compareDeep(this.result, o.result, true) && DiagnosticReport.compareDeep(this.note, o.note, true) && DiagnosticReport.compareDeep(this.imagingStudy, o.imagingStudy, true) && DiagnosticReport.compareDeep(this.media, o.media, true) && DiagnosticReport.compareDeep(this.composition, o.composition, true) && DiagnosticReport.compareDeep(this.conclusion, o.conclusion, true) && DiagnosticReport.compareDeep(this.conclusionCode, o.conclusionCode, true) && DiagnosticReport.compareDeep(this.presentedForm, o.presentedForm, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other_;
        return DiagnosticReport.compareValues(this.status, o.status, true) && DiagnosticReport.compareValues(this.issued, o.issued, true) && DiagnosticReport.compareValues(this.conclusion, o.conclusion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.category, this.code, this.subject, this.encounter, this.effective, this.issued, this.performer, this.resultsInterpreter, this.specimen, this.result, this.note, this.imagingStudy, this.media, this.composition, this.conclusion, this.conclusionCode, this.presentedForm});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticReport;
    }

    @Block
    public static class DiagnosticReportMediaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="comment", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comment about the image or data (e.g. explanation)", formalDefinition="A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.")
        protected StringType comment;
        @Child(name="link", type={DocumentReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to the image or data source", formalDefinition="Reference to the image or data source.")
        protected Reference link;
        private static final long serialVersionUID = 1827561947L;

        public DiagnosticReportMediaComponent() {
        }

        public DiagnosticReportMediaComponent(Reference link) {
            this.setLink(link);
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportMediaComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DiagnosticReportMediaComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DiagnosticReportMediaComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public Reference getLink() {
            if (this.link == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportMediaComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.link = new Reference();
                }
            }
            return this.link;
        }

        public boolean hasLink() {
            return this.link != null && !this.link.isEmpty();
        }

        public DiagnosticReportMediaComponent setLink(Reference value) {
            this.link = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("comment", "string", "A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.", 0, 1, this.comment));
            children.add(new Property("link", "Reference(DocumentReference)", "Reference to the image or data source.", 0, 1, this.link));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 950398559: {
                    return new Property("comment", "string", "A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.", 0, 1, this.comment);
                }
                case 3321850: {
                    return new Property("link", "Reference(DocumentReference)", "Reference to the image or data source.", 0, 1, this.link);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.comment;
                    }
                    return baseArray;
                }
                case 3321850: {
                    Base[] baseArray;
                    if (this.link == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.link;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
                case 3321850: {
                    this.link = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else if (name.equals("link")) {
                this.link = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return this.getCommentElement();
                }
                case 3321850: {
                    return this.getLink();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return new String[]{"string"};
                }
                case 3321850: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.media.comment");
            }
            if (name.equals("link")) {
                this.link = new Reference();
                return this.link;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportMediaComponent copy() {
            DiagnosticReportMediaComponent dst = new DiagnosticReportMediaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosticReportMediaComponent dst) {
            super.copyValues(dst);
            dst.comment = this.comment == null ? null : this.comment.copy();
            dst.link = this.link == null ? null : this.link.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportMediaComponent)) {
                return false;
            }
            DiagnosticReportMediaComponent o = (DiagnosticReportMediaComponent)other_;
            return DiagnosticReportMediaComponent.compareDeep(this.comment, o.comment, true) && DiagnosticReportMediaComponent.compareDeep(this.link, o.link, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportMediaComponent)) {
                return false;
            }
            DiagnosticReportMediaComponent o = (DiagnosticReportMediaComponent)other_;
            return DiagnosticReportMediaComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.comment, this.link});
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.media";
        }
    }

    public static class DiagnosticReportStatusEnumFactory
    implements EnumFactory<DiagnosticReportStatus> {
        @Override
        public DiagnosticReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return DiagnosticReportStatus.REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return DiagnosticReportStatus.PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return DiagnosticReportStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return DiagnosticReportStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return DiagnosticReportStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return DiagnosticReportStatus.CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return DiagnosticReportStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return DiagnosticReportStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DiagnosticReportStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return DiagnosticReportStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public Enumeration<DiagnosticReportStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DiagnosticReportStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.REGISTERED);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PARTIAL);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.AMENDED);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CORRECTED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticReportStatus code) {
            if (code == DiagnosticReportStatus.REGISTERED) {
                return "registered";
            }
            if (code == DiagnosticReportStatus.PARTIAL) {
                return "partial";
            }
            if (code == DiagnosticReportStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == DiagnosticReportStatus.FINAL) {
                return "final";
            }
            if (code == DiagnosticReportStatus.AMENDED) {
                return "amended";
            }
            if (code == DiagnosticReportStatus.CORRECTED) {
                return "corrected";
            }
            if (code == DiagnosticReportStatus.APPENDED) {
                return "appended";
            }
            if (code == DiagnosticReportStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DiagnosticReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DiagnosticReportStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(DiagnosticReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum DiagnosticReportStatus {
        REGISTERED,
        PARTIAL,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CORRECTED,
        APPENDED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static DiagnosticReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PARTIAL: {
                    return "partial";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the report is registered, but there is nothing yet available.";
                }
                case PARTIAL: {
                    return "This is a partial (e.g. initial, interim or preliminary) report: data in the report may be incomplete or unverified.";
                }
                case PRELIMINARY: {
                    return "Verified early results are available, but not all  results are final.";
                }
                case FINAL: {
                    return "The report is complete and verified by an authorized person.";
                }
                case AMENDED: {
                    return "Subsequent to being final, the report has been modified.  This includes any change in the results, diagnosis, narrative text, or other content of a report that has been issued.";
                }
                case CORRECTED: {
                    return "Subsequent to being final, the report has been modified  to correct an error in the report or referenced results.";
                }
                case APPENDED: {
                    return "Subsequent to being final, the report has been modified by adding new content. The existing content is unchanged.";
                }
                case CANCELLED: {
                    return "The report is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PARTIAL: {
                    return "Partial";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

