/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationKnowledge", profile="http://hl7.org/fhir/StructureDefinition/MedicationKnowledge")
public class MedicationKnowledge
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this medication", formalDefinition="Business identifier for this medication.")
    protected List<Identifier> identifier;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies this medication", formalDefinition="A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | entered-in-error | inactive", formalDefinition="A code to indicate if the medication referred to by this MedicationKnowledge is in active use within the drug database or inventory system. The status refers to the validity about the information of the medication and not to its medicinal properties.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-status")
    protected Enumeration<MedicationKnowledgeStatusCodes> status;
    @Child(name="author", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creator or owner of the knowledge or information about the medication", formalDefinition="The creator or owner of the knowledge or information about the medication.")
    protected Reference author;
    @Child(name="intendedJurisdiction", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Codes that identify the different jurisdictions for which the information of this resource was created", formalDefinition="Lists the jurisdictions that this medication knowledge was written for.")
    protected List<CodeableConcept> intendedJurisdiction;
    @Child(name="name", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the medication being described", formalDefinition="All of the names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.")
    protected List<StringType> name;
    @Child(name="relatedMedicationKnowledge", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated or related medication information", formalDefinition="Associated or related medications. For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor.")
    protected List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> relatedMedicationKnowledge;
    @Child(name="associatedMedication", type={Medication.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of medication resources that are associated with this medication", formalDefinition="Links to associated medications that could be prescribed, dispensed or administered.")
    protected List<Reference> associatedMedication;
    @Child(name="productType", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Category of the medication or product", formalDefinition="Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).")
    protected List<CodeableConcept> productType;
    @Child(name="monograph", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
    protected List<MedicationKnowledgeMonographComponent> monograph;
    @Child(name="preparationInstruction", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The instructions for preparing the medication", formalDefinition="The instructions for preparing the medication.")
    protected MarkdownType preparationInstruction;
    @Child(name="cost", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The pricing of the medication", formalDefinition="The price of the medication.")
    protected List<MedicationKnowledgeCostComponent> cost;
    @Child(name="monitoringProgram", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Program under which a medication is reviewed", formalDefinition="The program under which the medication is reviewed.")
    protected List<MedicationKnowledgeMonitoringProgramComponent> monitoringProgram;
    @Child(name="indicationGuideline", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Guidelines or protocols for administration of the medication for an indication", formalDefinition="Guidelines or protocols that are applicable for the administration of the medication based on indication.")
    protected List<MedicationKnowledgeIndicationGuidelineComponent> indicationGuideline;
    @Child(name="medicineClassification", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Categorization of the medication within a formulary or classification system", formalDefinition="Categorization of the medication within a formulary or classification system.")
    protected List<MedicationKnowledgeMedicineClassificationComponent> medicineClassification;
    @Child(name="packaging", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected List<MedicationKnowledgePackagingComponent> packaging;
    @Child(name="clinicalUseIssue", type={ClinicalUseDefinition.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential clinical issue with or between medication(s)", formalDefinition="Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).")
    protected List<Reference> clinicalUseIssue;
    @Child(name="regulatory", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Regulatory information about a medication", formalDefinition="Regulatory information about a medication.")
    protected List<MedicationKnowledgeRegulatoryComponent> regulatory;
    @Child(name="definitional", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Minimal definition information about the medication", formalDefinition="Along with the link to a Medicinal Product Definition resource, this information provides common definitional elements that are needed to understand the specific medication that is being described.")
    protected MedicationKnowledgeDefinitionalComponent definitional;
    private static final long serialVersionUID = 259479639L;
    @SearchParamDefinition(name="classification-type", path="MedicationKnowledge.medicineClassification.type", description="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", type="token")
    public static final String SP_CLASSIFICATION_TYPE = "classification-type";
    public static final TokenClientParam CLASSIFICATION_TYPE = new TokenClientParam("classification-type");
    @SearchParamDefinition(name="classification", path="MedicationKnowledge.medicineClassification.classification", description="Specific category assigned to the medication", type="token")
    public static final String SP_CLASSIFICATION = "classification";
    public static final TokenClientParam CLASSIFICATION = new TokenClientParam("classification");
    @SearchParamDefinition(name="code", path="MedicationKnowledge.code", description="Code that identifies this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="doseform", path="MedicationKnowledge.definitional.doseForm", description="powder | tablets | capsule +", type="token")
    public static final String SP_DOSEFORM = "doseform";
    public static final TokenClientParam DOSEFORM = new TokenClientParam("doseform");
    @SearchParamDefinition(name="identifier", path="MedicationKnowledge.identifier", description="Business identifier for this medication", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient-code", path="MedicationKnowledge.definitional.ingredient.item.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="ingredient", path="MedicationKnowledge.definitional.ingredient.item.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("MedicationKnowledge:ingredient").toLocked();
    @SearchParamDefinition(name="monitoring-program-name", path="MedicationKnowledge.monitoringProgram.name", description="Name of the reviewing program", type="token")
    public static final String SP_MONITORING_PROGRAM_NAME = "monitoring-program-name";
    public static final TokenClientParam MONITORING_PROGRAM_NAME = new TokenClientParam("monitoring-program-name");
    @SearchParamDefinition(name="monitoring-program-type", path="MedicationKnowledge.monitoringProgram.type", description="Type of program under which the medication is monitored", type="token")
    public static final String SP_MONITORING_PROGRAM_TYPE = "monitoring-program-type";
    public static final TokenClientParam MONITORING_PROGRAM_TYPE = new TokenClientParam("monitoring-program-type");
    @SearchParamDefinition(name="monograph-type", path="MedicationKnowledge.monograph.type", description="The category of medication document", type="token")
    public static final String SP_MONOGRAPH_TYPE = "monograph-type";
    public static final TokenClientParam MONOGRAPH_TYPE = new TokenClientParam("monograph-type");
    @SearchParamDefinition(name="monograph", path="MedicationKnowledge.monograph.source", description="Associated documentation about the medication", type="reference", target={DocumentReference.class})
    public static final String SP_MONOGRAPH = "monograph";
    public static final ReferenceClientParam MONOGRAPH = new ReferenceClientParam("monograph");
    public static final Include INCLUDE_MONOGRAPH = new Include("MedicationKnowledge:monograph").toLocked();
    @SearchParamDefinition(name="packaging-cost-concept", path="", description="The cost of the packaged medication, if the cost is a CodeableConcept", type="token")
    public static final String SP_PACKAGING_COST_CONCEPT = "packaging-cost-concept";
    public static final TokenClientParam PACKAGING_COST_CONCEPT = new TokenClientParam("packaging-cost-concept");
    @SearchParamDefinition(name="packaging-cost", path="", description="The cost of the packaged medication, if the cost is Money", type="quantity")
    public static final String SP_PACKAGING_COST = "packaging-cost";
    public static final QuantityClientParam PACKAGING_COST = new QuantityClientParam("packaging-cost");
    @SearchParamDefinition(name="product-type", path="MedicationKnowledge.productType", description="Category of the medication or product", type="token")
    public static final String SP_PRODUCT_TYPE = "product-type";
    public static final TokenClientParam PRODUCT_TYPE = new TokenClientParam("product-type");
    @SearchParamDefinition(name="source-cost", path="MedicationKnowledge.cost.source", description="The source or owner for the price information", type="token")
    public static final String SP_SOURCE_COST = "source-cost";
    public static final TokenClientParam SOURCE_COST = new TokenClientParam("source-cost");
    @SearchParamDefinition(name="status", path="MedicationKnowledge.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationKnowledge setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationKnowledge addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public MedicationKnowledge setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationKnowledgeStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationKnowledge setStatusElement(Enumeration<MedicationKnowledgeStatusCodes> value) {
        this.status = value;
        return this;
    }

    public MedicationKnowledgeStatusCodes getStatus() {
        return this.status == null ? null : (MedicationKnowledgeStatusCodes)((Object)this.status.getValue());
    }

    public MedicationKnowledge setStatus(MedicationKnowledgeStatusCodes value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationKnowledgeStatusCodes>(new MedicationKnowledgeStatusCodesEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public MedicationKnowledge setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public List<CodeableConcept> getIntendedJurisdiction() {
        if (this.intendedJurisdiction == null) {
            this.intendedJurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.intendedJurisdiction;
    }

    public MedicationKnowledge setIntendedJurisdiction(List<CodeableConcept> theIntendedJurisdiction) {
        this.intendedJurisdiction = theIntendedJurisdiction;
        return this;
    }

    public boolean hasIntendedJurisdiction() {
        if (this.intendedJurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.intendedJurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIntendedJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.intendedJurisdiction == null) {
            this.intendedJurisdiction = new ArrayList<CodeableConcept>();
        }
        this.intendedJurisdiction.add(t);
        return t;
    }

    public MedicationKnowledge addIntendedJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.intendedJurisdiction == null) {
            this.intendedJurisdiction = new ArrayList<CodeableConcept>();
        }
        this.intendedJurisdiction.add(t);
        return this;
    }

    public CodeableConcept getIntendedJurisdictionFirstRep() {
        if (this.getIntendedJurisdiction().isEmpty()) {
            this.addIntendedJurisdiction();
        }
        return this.getIntendedJurisdiction().get(0);
    }

    public List<StringType> getName() {
        if (this.name == null) {
            this.name = new ArrayList<StringType>();
        }
        return this.name;
    }

    public MedicationKnowledge setName(List<StringType> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (StringType item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addNameElement() {
        StringType t = new StringType();
        if (this.name == null) {
            this.name = new ArrayList<StringType>();
        }
        this.name.add(t);
        return t;
    }

    public MedicationKnowledge addName(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.name == null) {
            this.name = new ArrayList<StringType>();
        }
        this.name.add(t);
        return this;
    }

    public boolean hasName(String value) {
        if (this.name == null) {
            return false;
        }
        for (StringType v : this.name) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> getRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        return this.relatedMedicationKnowledge;
    }

    public MedicationKnowledge setRelatedMedicationKnowledge(List<MedicationKnowledgeRelatedMedicationKnowledgeComponent> theRelatedMedicationKnowledge) {
        this.relatedMedicationKnowledge = theRelatedMedicationKnowledge;
        return this;
    }

    public boolean hasRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            return false;
        }
        for (MedicationKnowledgeRelatedMedicationKnowledgeComponent item : this.relatedMedicationKnowledge) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent addRelatedMedicationKnowledge() {
        MedicationKnowledgeRelatedMedicationKnowledgeComponent t = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return t;
    }

    public MedicationKnowledge addRelatedMedicationKnowledge(MedicationKnowledgeRelatedMedicationKnowledgeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
        }
        this.relatedMedicationKnowledge.add(t);
        return this;
    }

    public MedicationKnowledgeRelatedMedicationKnowledgeComponent getRelatedMedicationKnowledgeFirstRep() {
        if (this.getRelatedMedicationKnowledge().isEmpty()) {
            this.addRelatedMedicationKnowledge();
        }
        return this.getRelatedMedicationKnowledge().get(0);
    }

    public List<Reference> getAssociatedMedication() {
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        return this.associatedMedication;
    }

    public MedicationKnowledge setAssociatedMedication(List<Reference> theAssociatedMedication) {
        this.associatedMedication = theAssociatedMedication;
        return this;
    }

    public boolean hasAssociatedMedication() {
        if (this.associatedMedication == null) {
            return false;
        }
        for (Reference item : this.associatedMedication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAssociatedMedication() {
        Reference t = new Reference();
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return t;
    }

    public MedicationKnowledge addAssociatedMedication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.associatedMedication == null) {
            this.associatedMedication = new ArrayList<Reference>();
        }
        this.associatedMedication.add(t);
        return this;
    }

    public Reference getAssociatedMedicationFirstRep() {
        if (this.getAssociatedMedication().isEmpty()) {
            this.addAssociatedMedication();
        }
        return this.getAssociatedMedication().get(0);
    }

    public List<CodeableConcept> getProductType() {
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        return this.productType;
    }

    public MedicationKnowledge setProductType(List<CodeableConcept> theProductType) {
        this.productType = theProductType;
        return this;
    }

    public boolean hasProductType() {
        if (this.productType == null) {
            return false;
        }
        for (CodeableConcept item : this.productType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductType() {
        CodeableConcept t = new CodeableConcept();
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return t;
    }

    public MedicationKnowledge addProductType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return this;
    }

    public CodeableConcept getProductTypeFirstRep() {
        if (this.getProductType().isEmpty()) {
            this.addProductType();
        }
        return this.getProductType().get(0);
    }

    public List<MedicationKnowledgeMonographComponent> getMonograph() {
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        return this.monograph;
    }

    public MedicationKnowledge setMonograph(List<MedicationKnowledgeMonographComponent> theMonograph) {
        this.monograph = theMonograph;
        return this;
    }

    public boolean hasMonograph() {
        if (this.monograph == null) {
            return false;
        }
        for (MedicationKnowledgeMonographComponent item : this.monograph) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonographComponent addMonograph() {
        MedicationKnowledgeMonographComponent t = new MedicationKnowledgeMonographComponent();
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return t;
    }

    public MedicationKnowledge addMonograph(MedicationKnowledgeMonographComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return this;
    }

    public MedicationKnowledgeMonographComponent getMonographFirstRep() {
        if (this.getMonograph().isEmpty()) {
            this.addMonograph();
        }
        return this.getMonograph().get(0);
    }

    public MarkdownType getPreparationInstructionElement() {
        if (this.preparationInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.preparationInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.preparationInstruction = new MarkdownType();
            }
        }
        return this.preparationInstruction;
    }

    public boolean hasPreparationInstructionElement() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public boolean hasPreparationInstruction() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public MedicationKnowledge setPreparationInstructionElement(MarkdownType value) {
        this.preparationInstruction = value;
        return this;
    }

    public String getPreparationInstruction() {
        return this.preparationInstruction == null ? null : (String)this.preparationInstruction.getValue();
    }

    public MedicationKnowledge setPreparationInstruction(String value) {
        if (value == null) {
            this.preparationInstruction = null;
        } else {
            if (this.preparationInstruction == null) {
                this.preparationInstruction = new MarkdownType();
            }
            this.preparationInstruction.setValue(value);
        }
        return this;
    }

    public List<MedicationKnowledgeCostComponent> getCost() {
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        return this.cost;
    }

    public MedicationKnowledge setCost(List<MedicationKnowledgeCostComponent> theCost) {
        this.cost = theCost;
        return this;
    }

    public boolean hasCost() {
        if (this.cost == null) {
            return false;
        }
        for (MedicationKnowledgeCostComponent item : this.cost) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeCostComponent addCost() {
        MedicationKnowledgeCostComponent t = new MedicationKnowledgeCostComponent();
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return t;
    }

    public MedicationKnowledge addCost(MedicationKnowledgeCostComponent t) {
        if (t == null) {
            return this;
        }
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return this;
    }

    public MedicationKnowledgeCostComponent getCostFirstRep() {
        if (this.getCost().isEmpty()) {
            this.addCost();
        }
        return this.getCost().get(0);
    }

    public List<MedicationKnowledgeMonitoringProgramComponent> getMonitoringProgram() {
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        return this.monitoringProgram;
    }

    public MedicationKnowledge setMonitoringProgram(List<MedicationKnowledgeMonitoringProgramComponent> theMonitoringProgram) {
        this.monitoringProgram = theMonitoringProgram;
        return this;
    }

    public boolean hasMonitoringProgram() {
        if (this.monitoringProgram == null) {
            return false;
        }
        for (MedicationKnowledgeMonitoringProgramComponent item : this.monitoringProgram) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonitoringProgramComponent addMonitoringProgram() {
        MedicationKnowledgeMonitoringProgramComponent t = new MedicationKnowledgeMonitoringProgramComponent();
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return t;
    }

    public MedicationKnowledge addMonitoringProgram(MedicationKnowledgeMonitoringProgramComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return this;
    }

    public MedicationKnowledgeMonitoringProgramComponent getMonitoringProgramFirstRep() {
        if (this.getMonitoringProgram().isEmpty()) {
            this.addMonitoringProgram();
        }
        return this.getMonitoringProgram().get(0);
    }

    public List<MedicationKnowledgeIndicationGuidelineComponent> getIndicationGuideline() {
        if (this.indicationGuideline == null) {
            this.indicationGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineComponent>();
        }
        return this.indicationGuideline;
    }

    public MedicationKnowledge setIndicationGuideline(List<MedicationKnowledgeIndicationGuidelineComponent> theIndicationGuideline) {
        this.indicationGuideline = theIndicationGuideline;
        return this;
    }

    public boolean hasIndicationGuideline() {
        if (this.indicationGuideline == null) {
            return false;
        }
        for (MedicationKnowledgeIndicationGuidelineComponent item : this.indicationGuideline) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeIndicationGuidelineComponent addIndicationGuideline() {
        MedicationKnowledgeIndicationGuidelineComponent t = new MedicationKnowledgeIndicationGuidelineComponent();
        if (this.indicationGuideline == null) {
            this.indicationGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineComponent>();
        }
        this.indicationGuideline.add(t);
        return t;
    }

    public MedicationKnowledge addIndicationGuideline(MedicationKnowledgeIndicationGuidelineComponent t) {
        if (t == null) {
            return this;
        }
        if (this.indicationGuideline == null) {
            this.indicationGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineComponent>();
        }
        this.indicationGuideline.add(t);
        return this;
    }

    public MedicationKnowledgeIndicationGuidelineComponent getIndicationGuidelineFirstRep() {
        if (this.getIndicationGuideline().isEmpty()) {
            this.addIndicationGuideline();
        }
        return this.getIndicationGuideline().get(0);
    }

    public List<MedicationKnowledgeMedicineClassificationComponent> getMedicineClassification() {
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        return this.medicineClassification;
    }

    public MedicationKnowledge setMedicineClassification(List<MedicationKnowledgeMedicineClassificationComponent> theMedicineClassification) {
        this.medicineClassification = theMedicineClassification;
        return this;
    }

    public boolean hasMedicineClassification() {
        if (this.medicineClassification == null) {
            return false;
        }
        for (MedicationKnowledgeMedicineClassificationComponent item : this.medicineClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMedicineClassificationComponent addMedicineClassification() {
        MedicationKnowledgeMedicineClassificationComponent t = new MedicationKnowledgeMedicineClassificationComponent();
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return t;
    }

    public MedicationKnowledge addMedicineClassification(MedicationKnowledgeMedicineClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return this;
    }

    public MedicationKnowledgeMedicineClassificationComponent getMedicineClassificationFirstRep() {
        if (this.getMedicineClassification().isEmpty()) {
            this.addMedicineClassification();
        }
        return this.getMedicineClassification().get(0);
    }

    public List<MedicationKnowledgePackagingComponent> getPackaging() {
        if (this.packaging == null) {
            this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
        }
        return this.packaging;
    }

    public MedicationKnowledge setPackaging(List<MedicationKnowledgePackagingComponent> thePackaging) {
        this.packaging = thePackaging;
        return this;
    }

    public boolean hasPackaging() {
        if (this.packaging == null) {
            return false;
        }
        for (MedicationKnowledgePackagingComponent item : this.packaging) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgePackagingComponent addPackaging() {
        MedicationKnowledgePackagingComponent t = new MedicationKnowledgePackagingComponent();
        if (this.packaging == null) {
            this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
        }
        this.packaging.add(t);
        return t;
    }

    public MedicationKnowledge addPackaging(MedicationKnowledgePackagingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.packaging == null) {
            this.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
        }
        this.packaging.add(t);
        return this;
    }

    public MedicationKnowledgePackagingComponent getPackagingFirstRep() {
        if (this.getPackaging().isEmpty()) {
            this.addPackaging();
        }
        return this.getPackaging().get(0);
    }

    public List<Reference> getClinicalUseIssue() {
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        return this.clinicalUseIssue;
    }

    public MedicationKnowledge setClinicalUseIssue(List<Reference> theClinicalUseIssue) {
        this.clinicalUseIssue = theClinicalUseIssue;
        return this;
    }

    public boolean hasClinicalUseIssue() {
        if (this.clinicalUseIssue == null) {
            return false;
        }
        for (Reference item : this.clinicalUseIssue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addClinicalUseIssue() {
        Reference t = new Reference();
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        this.clinicalUseIssue.add(t);
        return t;
    }

    public MedicationKnowledge addClinicalUseIssue(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.clinicalUseIssue == null) {
            this.clinicalUseIssue = new ArrayList<Reference>();
        }
        this.clinicalUseIssue.add(t);
        return this;
    }

    public Reference getClinicalUseIssueFirstRep() {
        if (this.getClinicalUseIssue().isEmpty()) {
            this.addClinicalUseIssue();
        }
        return this.getClinicalUseIssue().get(0);
    }

    public List<MedicationKnowledgeRegulatoryComponent> getRegulatory() {
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        return this.regulatory;
    }

    public MedicationKnowledge setRegulatory(List<MedicationKnowledgeRegulatoryComponent> theRegulatory) {
        this.regulatory = theRegulatory;
        return this;
    }

    public boolean hasRegulatory() {
        if (this.regulatory == null) {
            return false;
        }
        for (MedicationKnowledgeRegulatoryComponent item : this.regulatory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeRegulatoryComponent addRegulatory() {
        MedicationKnowledgeRegulatoryComponent t = new MedicationKnowledgeRegulatoryComponent();
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return t;
    }

    public MedicationKnowledge addRegulatory(MedicationKnowledgeRegulatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.regulatory == null) {
            this.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
        }
        this.regulatory.add(t);
        return this;
    }

    public MedicationKnowledgeRegulatoryComponent getRegulatoryFirstRep() {
        if (this.getRegulatory().isEmpty()) {
            this.addRegulatory();
        }
        return this.getRegulatory().get(0);
    }

    public MedicationKnowledgeDefinitionalComponent getDefinitional() {
        if (this.definitional == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.definitional");
            }
            if (Configuration.doAutoCreate()) {
                this.definitional = new MedicationKnowledgeDefinitionalComponent();
            }
        }
        return this.definitional;
    }

    public boolean hasDefinitional() {
        return this.definitional != null && !this.definitional.isEmpty();
    }

    public MedicationKnowledge setDefinitional(MedicationKnowledgeDefinitionalComponent value) {
        this.definitional = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication referred to by this MedicationKnowledge is in active use within the drug database or inventory system. The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status));
        children.add(new Property("author", "Reference(Organization)", "The creator or owner of the knowledge or information about the medication.", 0, 1, this.author));
        children.add(new Property("intendedJurisdiction", "CodeableConcept", "Lists the jurisdictions that this medication knowledge was written for.", 0, Integer.MAX_VALUE, this.intendedJurisdiction));
        children.add(new Property("name", "string", "All of the names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("relatedMedicationKnowledge", "", "Associated or related medications. For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge));
        children.add(new Property("associatedMedication", "Reference(Medication)", "Links to associated medications that could be prescribed, dispensed or administered.", 0, Integer.MAX_VALUE, this.associatedMedication));
        children.add(new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType));
        children.add(new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph));
        children.add(new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction));
        children.add(new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost));
        children.add(new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram));
        children.add(new Property("indicationGuideline", "", "Guidelines or protocols that are applicable for the administration of the medication based on indication.", 0, Integer.MAX_VALUE, this.indicationGuideline));
        children.add(new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification));
        children.add(new Property("packaging", "", "Information that only applies to packages (not products).", 0, Integer.MAX_VALUE, this.packaging));
        children.add(new Property("clinicalUseIssue", "Reference(ClinicalUseDefinition)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.clinicalUseIssue));
        children.add(new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory));
        children.add(new Property("definitional", "", "Along with the link to a Medicinal Product Definition resource, this information provides common definitional elements that are needed to understand the specific medication that is being described.", 0, 1, this.definitional));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this medication.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication referred to by this MedicationKnowledge is in active use within the drug database or inventory system. The status refers to the validity about the information of the medication and not to its medicinal properties.", 0, 1, this.status);
            }
            case -1406328437: {
                return new Property("author", "Reference(Organization)", "The creator or owner of the knowledge or information about the medication.", 0, 1, this.author);
            }
            case 2136596300: {
                return new Property("intendedJurisdiction", "CodeableConcept", "Lists the jurisdictions that this medication knowledge was written for.", 0, Integer.MAX_VALUE, this.intendedJurisdiction);
            }
            case 3373707: {
                return new Property("name", "string", "All of the names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.name);
            }
            case 723067972: {
                return new Property("relatedMedicationKnowledge", "", "Associated or related medications. For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge);
            }
            case 1312779381: {
                return new Property("associatedMedication", "Reference(Medication)", "Links to associated medications that could be prescribed, dispensed or administered.", 0, Integer.MAX_VALUE, this.associatedMedication);
            }
            case -1491615543: {
                return new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).", 0, Integer.MAX_VALUE, this.productType);
            }
            case -1442980789: {
                return new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph);
            }
            case 1025456503: {
                return new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction);
            }
            case 3059661: {
                return new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost);
            }
            case 569848092: {
                return new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram);
            }
            case -347044108: {
                return new Property("indicationGuideline", "", "Guidelines or protocols that are applicable for the administration of the medication based on indication.", 0, Integer.MAX_VALUE, this.indicationGuideline);
            }
            case 1791551680: {
                return new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification);
            }
            case 1802065795: {
                return new Property("packaging", "", "Information that only applies to packages (not products).", 0, Integer.MAX_VALUE, this.packaging);
            }
            case 251885509: {
                return new Property("clinicalUseIssue", "Reference(ClinicalUseDefinition)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).", 0, Integer.MAX_VALUE, this.clinicalUseIssue);
            }
            case -27327848: {
                return new Property("regulatory", "", "Regulatory information about a medication.", 0, Integer.MAX_VALUE, this.regulatory);
            }
            case 101791934: {
                return new Property("definitional", "", "Along with the link to a Medicinal Product Definition resource, this information provides common definitional elements that are needed to understand the specific medication that is being described.", 0, 1, this.definitional);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.author;
                }
                return baseArray;
            }
            case 2136596300: {
                return this.intendedJurisdiction == null ? new Base[]{} : this.intendedJurisdiction.toArray(new Base[this.intendedJurisdiction.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case 723067972: {
                return this.relatedMedicationKnowledge == null ? new Base[]{} : this.relatedMedicationKnowledge.toArray(new Base[this.relatedMedicationKnowledge.size()]);
            }
            case 1312779381: {
                return this.associatedMedication == null ? new Base[]{} : this.associatedMedication.toArray(new Base[this.associatedMedication.size()]);
            }
            case -1491615543: {
                return this.productType == null ? new Base[]{} : this.productType.toArray(new Base[this.productType.size()]);
            }
            case -1442980789: {
                return this.monograph == null ? new Base[]{} : this.monograph.toArray(new Base[this.monograph.size()]);
            }
            case 1025456503: {
                Base[] baseArray;
                if (this.preparationInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.preparationInstruction;
                }
                return baseArray;
            }
            case 3059661: {
                return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
            }
            case 569848092: {
                return this.monitoringProgram == null ? new Base[]{} : this.monitoringProgram.toArray(new Base[this.monitoringProgram.size()]);
            }
            case -347044108: {
                return this.indicationGuideline == null ? new Base[]{} : this.indicationGuideline.toArray(new Base[this.indicationGuideline.size()]);
            }
            case 1791551680: {
                return this.medicineClassification == null ? new Base[]{} : this.medicineClassification.toArray(new Base[this.medicineClassification.size()]);
            }
            case 1802065795: {
                return this.packaging == null ? new Base[]{} : this.packaging.toArray(new Base[this.packaging.size()]);
            }
            case 251885509: {
                return this.clinicalUseIssue == null ? new Base[]{} : this.clinicalUseIssue.toArray(new Base[this.clinicalUseIssue.size()]);
            }
            case -27327848: {
                return this.regulatory == null ? new Base[]{} : this.regulatory.toArray(new Base[this.regulatory.size()]);
            }
            case 101791934: {
                Base[] baseArray;
                if (this.definitional == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.definitional;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case 2136596300: {
                this.getIntendedJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.getName().add(TypeConvertor.castToString(value));
                return value;
            }
            case 723067972: {
                this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
                return value;
            }
            case 1312779381: {
                this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1491615543: {
                this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1442980789: {
                this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
                return value;
            }
            case 1025456503: {
                this.preparationInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3059661: {
                this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
                return value;
            }
            case 569848092: {
                this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
                return value;
            }
            case -347044108: {
                this.getIndicationGuideline().add((MedicationKnowledgeIndicationGuidelineComponent)((Object)value));
                return value;
            }
            case 1791551680: {
                this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
                return value;
            }
            case 1802065795: {
                this.getPackaging().add((MedicationKnowledgePackagingComponent)((Object)value));
                return value;
            }
            case 251885509: {
                this.getClinicalUseIssue().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -27327848: {
                this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
                return value;
            }
            case 101791934: {
                this.definitional = (MedicationKnowledgeDefinitionalComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationKnowledgeStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("author")) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals("intendedJurisdiction")) {
            this.getIntendedJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("name")) {
            this.getName().add(TypeConvertor.castToString(value));
        } else if (name.equals("relatedMedicationKnowledge")) {
            this.getRelatedMedicationKnowledge().add((MedicationKnowledgeRelatedMedicationKnowledgeComponent)((Object)value));
        } else if (name.equals("associatedMedication")) {
            this.getAssociatedMedication().add(TypeConvertor.castToReference(value));
        } else if (name.equals("productType")) {
            this.getProductType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_MONOGRAPH)) {
            this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
        } else if (name.equals("preparationInstruction")) {
            this.preparationInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("cost")) {
            this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
        } else if (name.equals("monitoringProgram")) {
            this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
        } else if (name.equals("indicationGuideline")) {
            this.getIndicationGuideline().add((MedicationKnowledgeIndicationGuidelineComponent)((Object)value));
        } else if (name.equals("medicineClassification")) {
            this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
        } else if (name.equals("packaging")) {
            this.getPackaging().add((MedicationKnowledgePackagingComponent)((Object)value));
        } else if (name.equals("clinicalUseIssue")) {
            this.getClinicalUseIssue().add(TypeConvertor.castToReference(value));
        } else if (name.equals("regulatory")) {
            this.getRegulatory().add((MedicationKnowledgeRegulatoryComponent)((Object)value));
        } else if (name.equals("definitional")) {
            this.definitional = (MedicationKnowledgeDefinitionalComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 2136596300: {
                return this.addIntendedJurisdiction();
            }
            case 3373707: {
                return this.addNameElement();
            }
            case 723067972: {
                return this.addRelatedMedicationKnowledge();
            }
            case 1312779381: {
                return this.addAssociatedMedication();
            }
            case -1491615543: {
                return this.addProductType();
            }
            case -1442980789: {
                return this.addMonograph();
            }
            case 1025456503: {
                return this.getPreparationInstructionElement();
            }
            case 3059661: {
                return this.addCost();
            }
            case 569848092: {
                return this.addMonitoringProgram();
            }
            case -347044108: {
                return this.addIndicationGuideline();
            }
            case 1791551680: {
                return this.addMedicineClassification();
            }
            case 1802065795: {
                return this.addPackaging();
            }
            case 251885509: {
                return this.addClinicalUseIssue();
            }
            case -27327848: {
                return this.addRegulatory();
            }
            case 101791934: {
                return this.getDefinitional();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 2136596300: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 723067972: {
                return new String[0];
            }
            case 1312779381: {
                return new String[]{"Reference"};
            }
            case -1491615543: {
                return new String[]{"CodeableConcept"};
            }
            case -1442980789: {
                return new String[0];
            }
            case 1025456503: {
                return new String[]{"markdown"};
            }
            case 3059661: {
                return new String[0];
            }
            case 569848092: {
                return new String[0];
            }
            case -347044108: {
                return new String[0];
            }
            case 1791551680: {
                return new String[0];
            }
            case 1802065795: {
                return new String[0];
            }
            case 251885509: {
                return new String[]{"Reference"};
            }
            case -27327848: {
                return new String[0];
            }
            case 101791934: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.status");
        }
        if (name.equals("author")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("intendedJurisdiction")) {
            return this.addIntendedJurisdiction();
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.name");
        }
        if (name.equals("relatedMedicationKnowledge")) {
            return this.addRelatedMedicationKnowledge();
        }
        if (name.equals("associatedMedication")) {
            return this.addAssociatedMedication();
        }
        if (name.equals("productType")) {
            return this.addProductType();
        }
        if (name.equals(SP_MONOGRAPH)) {
            return this.addMonograph();
        }
        if (name.equals("preparationInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.preparationInstruction");
        }
        if (name.equals("cost")) {
            return this.addCost();
        }
        if (name.equals("monitoringProgram")) {
            return this.addMonitoringProgram();
        }
        if (name.equals("indicationGuideline")) {
            return this.addIndicationGuideline();
        }
        if (name.equals("medicineClassification")) {
            return this.addMedicineClassification();
        }
        if (name.equals("packaging")) {
            return this.addPackaging();
        }
        if (name.equals("clinicalUseIssue")) {
            return this.addClinicalUseIssue();
        }
        if (name.equals("regulatory")) {
            return this.addRegulatory();
        }
        if (name.equals("definitional")) {
            this.definitional = new MedicationKnowledgeDefinitionalComponent();
            return this.definitional;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationKnowledge";
    }

    @Override
    public MedicationKnowledge copy() {
        MedicationKnowledge dst = new MedicationKnowledge();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicationKnowledge dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.intendedJurisdiction != null) {
            dst.intendedJurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.intendedJurisdiction) {
                dst.intendedJurisdiction.add(codeableConcept.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<StringType>();
            for (StringType stringType : this.name) {
                dst.name.add(stringType.copy());
            }
        }
        if (this.relatedMedicationKnowledge != null) {
            dst.relatedMedicationKnowledge = new ArrayList<MedicationKnowledgeRelatedMedicationKnowledgeComponent>();
            for (MedicationKnowledgeRelatedMedicationKnowledgeComponent medicationKnowledgeRelatedMedicationKnowledgeComponent : this.relatedMedicationKnowledge) {
                dst.relatedMedicationKnowledge.add(medicationKnowledgeRelatedMedicationKnowledgeComponent.copy());
            }
        }
        if (this.associatedMedication != null) {
            dst.associatedMedication = new ArrayList<Reference>();
            for (Reference reference2 : this.associatedMedication) {
                dst.associatedMedication.add(reference2.copy());
            }
        }
        if (this.productType != null) {
            dst.productType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.productType) {
                dst.productType.add(codeableConcept.copy());
            }
        }
        if (this.monograph != null) {
            dst.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
            for (MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : this.monograph) {
                dst.monograph.add(medicationKnowledgeMonographComponent.copy());
            }
        }
        MarkdownType markdownType = dst.preparationInstruction = this.preparationInstruction == null ? null : this.preparationInstruction.copy();
        if (this.cost != null) {
            dst.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            for (MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : this.cost) {
                dst.cost.add(medicationKnowledgeCostComponent.copy());
            }
        }
        if (this.monitoringProgram != null) {
            dst.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
            for (MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : this.monitoringProgram) {
                dst.monitoringProgram.add(medicationKnowledgeMonitoringProgramComponent.copy());
            }
        }
        if (this.indicationGuideline != null) {
            dst.indicationGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineComponent>();
            for (MedicationKnowledgeIndicationGuidelineComponent medicationKnowledgeIndicationGuidelineComponent : this.indicationGuideline) {
                dst.indicationGuideline.add(medicationKnowledgeIndicationGuidelineComponent.copy());
            }
        }
        if (this.medicineClassification != null) {
            dst.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
            for (MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : this.medicineClassification) {
                dst.medicineClassification.add(medicationKnowledgeMedicineClassificationComponent.copy());
            }
        }
        if (this.packaging != null) {
            dst.packaging = new ArrayList<MedicationKnowledgePackagingComponent>();
            for (MedicationKnowledgePackagingComponent medicationKnowledgePackagingComponent : this.packaging) {
                dst.packaging.add(medicationKnowledgePackagingComponent.copy());
            }
        }
        if (this.clinicalUseIssue != null) {
            dst.clinicalUseIssue = new ArrayList<Reference>();
            for (Reference reference3 : this.clinicalUseIssue) {
                dst.clinicalUseIssue.add(reference3.copy());
            }
        }
        if (this.regulatory != null) {
            dst.regulatory = new ArrayList<MedicationKnowledgeRegulatoryComponent>();
            for (MedicationKnowledgeRegulatoryComponent medicationKnowledgeRegulatoryComponent : this.regulatory) {
                dst.regulatory.add(medicationKnowledgeRegulatoryComponent.copy());
            }
        }
        dst.definitional = this.definitional == null ? null : this.definitional.copy();
    }

    protected MedicationKnowledge typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareDeep(this.identifier, o.identifier, true) && MedicationKnowledge.compareDeep(this.code, o.code, true) && MedicationKnowledge.compareDeep(this.status, o.status, true) && MedicationKnowledge.compareDeep(this.author, o.author, true) && MedicationKnowledge.compareDeep(this.intendedJurisdiction, o.intendedJurisdiction, true) && MedicationKnowledge.compareDeep(this.name, o.name, true) && MedicationKnowledge.compareDeep(this.relatedMedicationKnowledge, o.relatedMedicationKnowledge, true) && MedicationKnowledge.compareDeep(this.associatedMedication, o.associatedMedication, true) && MedicationKnowledge.compareDeep(this.productType, o.productType, true) && MedicationKnowledge.compareDeep(this.monograph, o.monograph, true) && MedicationKnowledge.compareDeep(this.preparationInstruction, o.preparationInstruction, true) && MedicationKnowledge.compareDeep(this.cost, o.cost, true) && MedicationKnowledge.compareDeep(this.monitoringProgram, o.monitoringProgram, true) && MedicationKnowledge.compareDeep(this.indicationGuideline, o.indicationGuideline, true) && MedicationKnowledge.compareDeep(this.medicineClassification, o.medicineClassification, true) && MedicationKnowledge.compareDeep(this.packaging, o.packaging, true) && MedicationKnowledge.compareDeep(this.clinicalUseIssue, o.clinicalUseIssue, true) && MedicationKnowledge.compareDeep(this.regulatory, o.regulatory, true) && MedicationKnowledge.compareDeep(this.definitional, o.definitional, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareValues(this.status, o.status, true) && MedicationKnowledge.compareValues(this.name, o.name, true) && MedicationKnowledge.compareValues(this.preparationInstruction, o.preparationInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.status, this.author, this.intendedJurisdiction, this.name, this.relatedMedicationKnowledge, this.associatedMedication, this.productType, this.monograph, this.preparationInstruction, this.cost, this.monitoringProgram, this.indicationGuideline, this.medicineClassification, this.packaging, this.clinicalUseIssue, this.regulatory, this.definitional});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationKnowledge;
    }

    @Block
    public static class MedicationKnowledgeDefinitionalDrugCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of characteristic of medication", formalDefinition="A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-characteristic")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, StringType.class, Quantity.class, Base64BinaryType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the characteristic", formalDefinition="Description of the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDefinitionalDrugCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeDefinitionalDrugCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeDefinitionalDrugCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof Quantity || value instanceof Base64BinaryType || value instanceof Attachment)) {
                throw new Error("Not the right type for MedicationKnowledge.definitional.drugCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Description of the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Description of the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "string", "Quantity", "base64Binary", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDefinitionalDrugCharacteristicComponent copy() {
            MedicationKnowledgeDefinitionalDrugCharacteristicComponent dst = new MedicationKnowledgeDefinitionalDrugCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeDefinitionalDrugCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalDrugCharacteristicComponent o = (MedicationKnowledgeDefinitionalDrugCharacteristicComponent)other_;
            return MedicationKnowledgeDefinitionalDrugCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeDefinitionalDrugCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalDrugCharacteristicComponent o = (MedicationKnowledgeDefinitionalDrugCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.definitional.drugCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgeDefinitionalIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substances contained in the medication", formalDefinition="A reference to the resource that provides information about the ingredient.")
        protected CodeableReference item;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A code that defines the type of ingredient, active, base, etc.", formalDefinition="Indication of whether this ingredient affects the therapeutic action of the drug.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-RoleClassIngredientEntity")
        protected CodeableConcept type;
        @Child(name="strength", type={Ratio.class, CodeableConcept.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-ingredientstrength")
        protected DataType strength;
        private static final long serialVersionUID = 1772676131L;

        public MedicationKnowledgeDefinitionalIngredientComponent() {
        }

        public MedicationKnowledgeDefinitionalIngredientComponent(CodeableReference item) {
            this.setItem(item);
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDefinitionalIngredientComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationKnowledgeDefinitionalIngredientComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDefinitionalIngredientComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeDefinitionalIngredientComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getStrength() {
            return this.strength;
        }

        public Ratio getStrengthRatio() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Ratio();
            }
            if (!(this.strength instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Ratio)this.strength;
        }

        public boolean hasStrengthRatio() {
            return this != null && this.strength instanceof Ratio;
        }

        public CodeableConcept getStrengthCodeableConcept() throws FHIRException {
            if (this.strength == null) {
                this.strength = new CodeableConcept();
            }
            if (!(this.strength instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.strength;
        }

        public boolean hasStrengthCodeableConcept() {
            return this != null && this.strength instanceof CodeableConcept;
        }

        public Quantity getStrengthQuantity() throws FHIRException {
            if (this.strength == null) {
                this.strength = new Quantity();
            }
            if (!(this.strength instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.strength.getClass().getName() + " was encountered");
            }
            return (Quantity)this.strength;
        }

        public boolean hasStrengthQuantity() {
            return this != null && this.strength instanceof Quantity;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicationKnowledgeDefinitionalIngredientComponent setStrength(DataType value) {
            if (!(value == null || value instanceof Ratio || value instanceof CodeableConcept || value instanceof Quantity)) {
                throw new Error("Not the right type for MedicationKnowledge.definitional.ingredient.strength[x]: " + value.fhirType());
            }
            this.strength = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(Substance)", "A reference to the resource that provides information about the ingredient.", 0, 1, this.item));
            children.add(new Property("type", "CodeableConcept", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.type));
            children.add(new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(Substance)", "A reference to the resource that provides information about the ingredient.", 0, 1, this.item);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Indication of whether this ingredient affects the therapeutic action of the drug.", 0, 1, this.type);
                }
                case 127377567: {
                    return new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case 1791316033: {
                    return new Property("strength[x]", "Ratio|CodeableConcept|Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case 2141786186: {
                    return new Property("strength[x]", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case -1455903456: {
                    return new Property("strength[x]", "CodeableConcept", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
                case -1793570836: {
                    return new Property("strength[x]", "Quantity", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet but can also be expressed a quantity when the denominator is assumed to be 1 tablet.", 0, 1, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strength;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("strength[x]")) {
                this.strength = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case 3575610: {
                    return this.getType();
                }
                case 127377567: {
                    return this.getStrength();
                }
                case 1791316033: {
                    return this.getStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1791316033: {
                    return new String[]{"Ratio", "CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("strengthRatio")) {
                this.strength = new Ratio();
                return this.strength;
            }
            if (name.equals("strengthCodeableConcept")) {
                this.strength = new CodeableConcept();
                return this.strength;
            }
            if (name.equals("strengthQuantity")) {
                this.strength = new Quantity();
                return this.strength;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDefinitionalIngredientComponent copy() {
            MedicationKnowledgeDefinitionalIngredientComponent dst = new MedicationKnowledgeDefinitionalIngredientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeDefinitionalIngredientComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalIngredientComponent o = (MedicationKnowledgeDefinitionalIngredientComponent)other_;
            return MedicationKnowledgeDefinitionalIngredientComponent.compareDeep(this.item, o.item, true) && MedicationKnowledgeDefinitionalIngredientComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeDefinitionalIngredientComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalIngredientComponent o = (MedicationKnowledgeDefinitionalIngredientComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.type, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.definitional.ingredient";
        }
    }

    @Block
    public static class MedicationKnowledgeDefinitionalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="definition", type={MedicinalProductDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definitional resources that provide more information about this medication", formalDefinition="Associated definitions for this medication.")
        protected List<Reference> definition;
        @Child(name="doseForm", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
        protected CodeableConcept doseForm;
        @Child(name="intendedRoute", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The intended or approved route of administration", formalDefinition="The intended or approved route of administration.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected List<CodeableConcept> intendedRoute;
        @Child(name="ingredient", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
        protected List<MedicationKnowledgeDefinitionalIngredientComponent> ingredient;
        @Child(name="drugCharacteristic", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies descriptive properties of the medicine", formalDefinition="Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.")
        protected List<MedicationKnowledgeDefinitionalDrugCharacteristicComponent> drugCharacteristic;
        private static final long serialVersionUID = 2050532775L;

        public List<Reference> getDefinition() {
            if (this.definition == null) {
                this.definition = new ArrayList<Reference>();
            }
            return this.definition;
        }

        public MedicationKnowledgeDefinitionalComponent setDefinition(List<Reference> theDefinition) {
            this.definition = theDefinition;
            return this;
        }

        public boolean hasDefinition() {
            if (this.definition == null) {
                return false;
            }
            for (Reference item : this.definition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDefinition() {
            Reference t = new Reference();
            if (this.definition == null) {
                this.definition = new ArrayList<Reference>();
            }
            this.definition.add(t);
            return t;
        }

        public MedicationKnowledgeDefinitionalComponent addDefinition(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.definition == null) {
                this.definition = new ArrayList<Reference>();
            }
            this.definition.add(t);
            return this;
        }

        public Reference getDefinitionFirstRep() {
            if (this.getDefinition().isEmpty()) {
                this.addDefinition();
            }
            return this.getDefinition().get(0);
        }

        public CodeableConcept getDoseForm() {
            if (this.doseForm == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDefinitionalComponent.doseForm");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseForm = new CodeableConcept();
                }
            }
            return this.doseForm;
        }

        public boolean hasDoseForm() {
            return this.doseForm != null && !this.doseForm.isEmpty();
        }

        public MedicationKnowledgeDefinitionalComponent setDoseForm(CodeableConcept value) {
            this.doseForm = value;
            return this;
        }

        public List<CodeableConcept> getIntendedRoute() {
            if (this.intendedRoute == null) {
                this.intendedRoute = new ArrayList<CodeableConcept>();
            }
            return this.intendedRoute;
        }

        public MedicationKnowledgeDefinitionalComponent setIntendedRoute(List<CodeableConcept> theIntendedRoute) {
            this.intendedRoute = theIntendedRoute;
            return this;
        }

        public boolean hasIntendedRoute() {
            if (this.intendedRoute == null) {
                return false;
            }
            for (CodeableConcept item : this.intendedRoute) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addIntendedRoute() {
            CodeableConcept t = new CodeableConcept();
            if (this.intendedRoute == null) {
                this.intendedRoute = new ArrayList<CodeableConcept>();
            }
            this.intendedRoute.add(t);
            return t;
        }

        public MedicationKnowledgeDefinitionalComponent addIntendedRoute(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.intendedRoute == null) {
                this.intendedRoute = new ArrayList<CodeableConcept>();
            }
            this.intendedRoute.add(t);
            return this;
        }

        public CodeableConcept getIntendedRouteFirstRep() {
            if (this.getIntendedRoute().isEmpty()) {
                this.addIntendedRoute();
            }
            return this.getIntendedRoute().get(0);
        }

        public List<MedicationKnowledgeDefinitionalIngredientComponent> getIngredient() {
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationKnowledgeDefinitionalIngredientComponent>();
            }
            return this.ingredient;
        }

        public MedicationKnowledgeDefinitionalComponent setIngredient(List<MedicationKnowledgeDefinitionalIngredientComponent> theIngredient) {
            this.ingredient = theIngredient;
            return this;
        }

        public boolean hasIngredient() {
            if (this.ingredient == null) {
                return false;
            }
            for (MedicationKnowledgeDefinitionalIngredientComponent item : this.ingredient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeDefinitionalIngredientComponent addIngredient() {
            MedicationKnowledgeDefinitionalIngredientComponent t = new MedicationKnowledgeDefinitionalIngredientComponent();
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationKnowledgeDefinitionalIngredientComponent>();
            }
            this.ingredient.add(t);
            return t;
        }

        public MedicationKnowledgeDefinitionalComponent addIngredient(MedicationKnowledgeDefinitionalIngredientComponent t) {
            if (t == null) {
                return this;
            }
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<MedicationKnowledgeDefinitionalIngredientComponent>();
            }
            this.ingredient.add(t);
            return this;
        }

        public MedicationKnowledgeDefinitionalIngredientComponent getIngredientFirstRep() {
            if (this.getIngredient().isEmpty()) {
                this.addIngredient();
            }
            return this.getIngredient().get(0);
        }

        public List<MedicationKnowledgeDefinitionalDrugCharacteristicComponent> getDrugCharacteristic() {
            if (this.drugCharacteristic == null) {
                this.drugCharacteristic = new ArrayList<MedicationKnowledgeDefinitionalDrugCharacteristicComponent>();
            }
            return this.drugCharacteristic;
        }

        public MedicationKnowledgeDefinitionalComponent setDrugCharacteristic(List<MedicationKnowledgeDefinitionalDrugCharacteristicComponent> theDrugCharacteristic) {
            this.drugCharacteristic = theDrugCharacteristic;
            return this;
        }

        public boolean hasDrugCharacteristic() {
            if (this.drugCharacteristic == null) {
                return false;
            }
            for (MedicationKnowledgeDefinitionalDrugCharacteristicComponent item : this.drugCharacteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeDefinitionalDrugCharacteristicComponent addDrugCharacteristic() {
            MedicationKnowledgeDefinitionalDrugCharacteristicComponent t = new MedicationKnowledgeDefinitionalDrugCharacteristicComponent();
            if (this.drugCharacteristic == null) {
                this.drugCharacteristic = new ArrayList<MedicationKnowledgeDefinitionalDrugCharacteristicComponent>();
            }
            this.drugCharacteristic.add(t);
            return t;
        }

        public MedicationKnowledgeDefinitionalComponent addDrugCharacteristic(MedicationKnowledgeDefinitionalDrugCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.drugCharacteristic == null) {
                this.drugCharacteristic = new ArrayList<MedicationKnowledgeDefinitionalDrugCharacteristicComponent>();
            }
            this.drugCharacteristic.add(t);
            return this;
        }

        public MedicationKnowledgeDefinitionalDrugCharacteristicComponent getDrugCharacteristicFirstRep() {
            if (this.getDrugCharacteristic().isEmpty()) {
                this.addDrugCharacteristic();
            }
            return this.getDrugCharacteristic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("definition", "Reference(MedicinalProductDefinition)", "Associated definitions for this medication.", 0, Integer.MAX_VALUE, this.definition));
            children.add(new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm));
            children.add(new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute));
            children.add(new Property(MedicationKnowledge.SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
            children.add(new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1014418093: {
                    return new Property("definition", "Reference(MedicinalProductDefinition)", "Associated definitions for this medication.", 0, Integer.MAX_VALUE, this.definition);
                }
                case 1303858817: {
                    return new Property("doseForm", "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.doseForm);
                }
                case -767798050: {
                    return new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute);
                }
                case -206409263: {
                    return new Property(MedicationKnowledge.SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
                }
                case -844126885: {
                    return new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
                }
                case 1303858817: {
                    Base[] baseArray;
                    if (this.doseForm == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.doseForm;
                    }
                    return baseArray;
                }
                case -767798050: {
                    return this.intendedRoute == null ? new Base[]{} : this.intendedRoute.toArray(new Base[this.intendedRoute.size()]);
                }
                case -206409263: {
                    return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
                }
                case -844126885: {
                    return this.drugCharacteristic == null ? new Base[]{} : this.drugCharacteristic.toArray(new Base[this.drugCharacteristic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    this.getDefinition().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 1303858817: {
                    this.doseForm = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -767798050: {
                    this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -206409263: {
                    this.getIngredient().add((MedicationKnowledgeDefinitionalIngredientComponent)value);
                    return value;
                }
                case -844126885: {
                    this.getDrugCharacteristic().add((MedicationKnowledgeDefinitionalDrugCharacteristicComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("definition")) {
                this.getDefinition().add(TypeConvertor.castToReference(value));
            } else if (name.equals("doseForm")) {
                this.doseForm = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("intendedRoute")) {
                this.getIntendedRoute().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(MedicationKnowledge.SP_INGREDIENT)) {
                this.getIngredient().add((MedicationKnowledgeDefinitionalIngredientComponent)value);
            } else if (name.equals("drugCharacteristic")) {
                this.getDrugCharacteristic().add((MedicationKnowledgeDefinitionalDrugCharacteristicComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return this.addDefinition();
                }
                case 1303858817: {
                    return this.getDoseForm();
                }
                case -767798050: {
                    return this.addIntendedRoute();
                }
                case -206409263: {
                    return this.addIngredient();
                }
                case -844126885: {
                    return this.addDrugCharacteristic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return new String[]{"Reference"};
                }
                case 1303858817: {
                    return new String[]{"CodeableConcept"};
                }
                case -767798050: {
                    return new String[]{"CodeableConcept"};
                }
                case -206409263: {
                    return new String[0];
                }
                case -844126885: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("definition")) {
                return this.addDefinition();
            }
            if (name.equals("doseForm")) {
                this.doseForm = new CodeableConcept();
                return this.doseForm;
            }
            if (name.equals("intendedRoute")) {
                return this.addIntendedRoute();
            }
            if (name.equals(MedicationKnowledge.SP_INGREDIENT)) {
                return this.addIngredient();
            }
            if (name.equals("drugCharacteristic")) {
                return this.addDrugCharacteristic();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDefinitionalComponent copy() {
            MedicationKnowledgeDefinitionalComponent dst = new MedicationKnowledgeDefinitionalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeDefinitionalComponent dst) {
            super.copyValues(dst);
            if (this.definition != null) {
                dst.definition = new ArrayList<Reference>();
                for (Reference reference : this.definition) {
                    dst.definition.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept = dst.doseForm = this.doseForm == null ? null : this.doseForm.copy();
            if (this.intendedRoute != null) {
                dst.intendedRoute = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.intendedRoute) {
                    dst.intendedRoute.add(codeableConcept2.copy());
                }
            }
            if (this.ingredient != null) {
                dst.ingredient = new ArrayList<MedicationKnowledgeDefinitionalIngredientComponent>();
                for (MedicationKnowledgeDefinitionalIngredientComponent medicationKnowledgeDefinitionalIngredientComponent : this.ingredient) {
                    dst.ingredient.add(medicationKnowledgeDefinitionalIngredientComponent.copy());
                }
            }
            if (this.drugCharacteristic != null) {
                dst.drugCharacteristic = new ArrayList<MedicationKnowledgeDefinitionalDrugCharacteristicComponent>();
                for (MedicationKnowledgeDefinitionalDrugCharacteristicComponent medicationKnowledgeDefinitionalDrugCharacteristicComponent : this.drugCharacteristic) {
                    dst.drugCharacteristic.add(medicationKnowledgeDefinitionalDrugCharacteristicComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalComponent o = (MedicationKnowledgeDefinitionalComponent)other_;
            return MedicationKnowledgeDefinitionalComponent.compareDeep(this.definition, o.definition, true) && MedicationKnowledgeDefinitionalComponent.compareDeep(this.doseForm, o.doseForm, true) && MedicationKnowledgeDefinitionalComponent.compareDeep(this.intendedRoute, o.intendedRoute, true) && MedicationKnowledgeDefinitionalComponent.compareDeep(this.ingredient, o.ingredient, true) && MedicationKnowledgeDefinitionalComponent.compareDeep(this.drugCharacteristic, o.drugCharacteristic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDefinitionalComponent)) {
                return false;
            }
            MedicationKnowledgeDefinitionalComponent o = (MedicationKnowledgeDefinitionalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.definition, this.doseForm, this.intendedRoute, this.ingredient, this.drugCharacteristic});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.definitional";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryMaxDispenseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed", formalDefinition="The maximum number of units of the medication that can be dispensed.")
        protected Quantity quantity;
        @Child(name="period", type={Duration.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The period that applies to the maximum number of units", formalDefinition="The period that applies to the maximum number of units.")
        protected Duration period;
        private static final long serialVersionUID = -441724185L;

        public MedicationKnowledgeRegulatoryMaxDispenseComponent() {
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent(Quantity quantity) {
            this.setQuantity(quantity);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryMaxDispenseComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Duration();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent setPeriod(Duration value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity));
            children.add(new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The maximum number of units of the medication that can be dispensed.", 0, 1, this.quantity);
                }
                case -991726143: {
                    return new Property("period", "Duration", "The period that applies to the maximum number of units.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -991726143: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("period")) {
                this.period = new Duration();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryMaxDispenseComponent copy() {
            MedicationKnowledgeRegulatoryMaxDispenseComponent dst = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryMaxDispenseComponent dst) {
            super.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.quantity, o.quantity, true) && MedicationKnowledgeRegulatoryMaxDispenseComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryMaxDispenseComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryMaxDispenseComponent o = (MedicationKnowledgeRegulatoryMaxDispenseComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.period});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.maxDispense";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatorySubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the type of substitution allowed", formalDefinition="Specifies the type of substitution allowed.")
        protected CodeableConcept type;
        @Child(name="allowed", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if regulation allows for changes in the medication when dispensing", formalDefinition="Specifies if regulation allows for changes in the medication when dispensing.")
        protected BooleanType allowed;
        private static final long serialVersionUID = 396354861L;

        public MedicationKnowledgeRegulatorySubstitutionComponent() {
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent(CodeableConcept type, boolean allowed) {
            this.setType(type);
            this.setAllowed(allowed);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public BooleanType getAllowedElement() {
            if (this.allowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatorySubstitutionComponent.allowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.allowed = new BooleanType();
                }
            }
            return this.allowed;
        }

        public boolean hasAllowedElement() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowedElement(BooleanType value) {
            this.allowed = value;
            return this;
        }

        public boolean getAllowed() {
            return this.allowed == null || this.allowed.isEmpty() ? false : (Boolean)this.allowed.getValue();
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent setAllowed(boolean value) {
            if (this.allowed == null) {
                this.allowed = new BooleanType();
            }
            this.allowed.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type));
            children.add(new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Specifies the type of substitution allowed.", 0, 1, this.type);
                }
                case -911343192: {
                    return new Property("allowed", "boolean", "Specifies if regulation allows for changes in the medication when dispensing.", 0, 1, this.allowed);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("allowed")) {
                this.allowed = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -911343192: {
                    return this.getAllowedElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.regulatory.substitution.allowed");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatorySubstitutionComponent copy() {
            MedicationKnowledgeRegulatorySubstitutionComponent dst = new MedicationKnowledgeRegulatorySubstitutionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatorySubstitutionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRegulatorySubstitutionComponent.compareDeep(this.allowed, o.allowed, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatorySubstitutionComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatorySubstitutionComponent o = (MedicationKnowledgeRegulatorySubstitutionComponent)other_;
            return MedicationKnowledgeRegulatorySubstitutionComponent.compareValues(this.allowed, o.allowed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.allowed});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory.substitution";
        }
    }

    @Block
    public static class MedicationKnowledgeRegulatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regulatoryAuthority", type={Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the authority of the regulation", formalDefinition="The authority that is specifying the regulations.")
        protected Reference regulatoryAuthority;
        @Child(name="substitution", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective", formalDefinition="Specifies if changes are allowed when dispensing a medication from a regulatory perspective.")
        protected List<MedicationKnowledgeRegulatorySubstitutionComponent> substitution;
        @Child(name="schedule", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the schedule of a medication in jurisdiction", formalDefinition="Specifies the schedule of a medication in jurisdiction.")
        protected List<CodeableConcept> schedule;
        @Child(name="maxDispense", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The maximum number of units of the medication that can be dispensed in a period", formalDefinition="The maximum number of units of the medication that can be dispensed in a period.")
        protected MedicationKnowledgeRegulatoryMaxDispenseComponent maxDispense;
        private static final long serialVersionUID = -2005823416L;

        public MedicationKnowledgeRegulatoryComponent() {
        }

        public MedicationKnowledgeRegulatoryComponent(Reference regulatoryAuthority) {
            this.setRegulatoryAuthority(regulatoryAuthority);
        }

        public Reference getRegulatoryAuthority() {
            if (this.regulatoryAuthority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.regulatoryAuthority");
                }
                if (Configuration.doAutoCreate()) {
                    this.regulatoryAuthority = new Reference();
                }
            }
            return this.regulatoryAuthority;
        }

        public boolean hasRegulatoryAuthority() {
            return this.regulatoryAuthority != null && !this.regulatoryAuthority.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setRegulatoryAuthority(Reference value) {
            this.regulatoryAuthority = value;
            return this;
        }

        public List<MedicationKnowledgeRegulatorySubstitutionComponent> getSubstitution() {
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            return this.substitution;
        }

        public MedicationKnowledgeRegulatoryComponent setSubstitution(List<MedicationKnowledgeRegulatorySubstitutionComponent> theSubstitution) {
            this.substitution = theSubstitution;
            return this;
        }

        public boolean hasSubstitution() {
            if (this.substitution == null) {
                return false;
            }
            for (MedicationKnowledgeRegulatorySubstitutionComponent item : this.substitution) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent addSubstitution() {
            MedicationKnowledgeRegulatorySubstitutionComponent t = new MedicationKnowledgeRegulatorySubstitutionComponent();
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSubstitution(MedicationKnowledgeRegulatorySubstitutionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.substitution == null) {
                this.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
            }
            this.substitution.add(t);
            return this;
        }

        public MedicationKnowledgeRegulatorySubstitutionComponent getSubstitutionFirstRep() {
            if (this.getSubstitution().isEmpty()) {
                this.addSubstitution();
            }
            return this.getSubstitution().get(0);
        }

        public List<CodeableConcept> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            return this.schedule;
        }

        public MedicationKnowledgeRegulatoryComponent setSchedule(List<CodeableConcept> theSchedule) {
            this.schedule = theSchedule;
            return this;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (CodeableConcept item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSchedule() {
            CodeableConcept t = new CodeableConcept();
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            this.schedule.add(t);
            return t;
        }

        public MedicationKnowledgeRegulatoryComponent addSchedule(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<CodeableConcept>();
            }
            this.schedule.add(t);
            return this;
        }

        public CodeableConcept getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public MedicationKnowledgeRegulatoryMaxDispenseComponent getMaxDispense() {
            if (this.maxDispense == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRegulatoryComponent.maxDispense");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                }
            }
            return this.maxDispense;
        }

        public boolean hasMaxDispense() {
            return this.maxDispense != null && !this.maxDispense.isEmpty();
        }

        public MedicationKnowledgeRegulatoryComponent setMaxDispense(MedicationKnowledgeRegulatoryMaxDispenseComponent value) {
            this.maxDispense = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority));
            children.add(new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution));
            children.add(new Property("schedule", "CodeableConcept", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule));
            children.add(new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 711233419: {
                    return new Property("regulatoryAuthority", "Reference(Organization)", "The authority that is specifying the regulations.", 0, 1, this.regulatoryAuthority);
                }
                case 826147581: {
                    return new Property("substitution", "", "Specifies if changes are allowed when dispensing a medication from a regulatory perspective.", 0, Integer.MAX_VALUE, this.substitution);
                }
                case -697920873: {
                    return new Property("schedule", "CodeableConcept", "Specifies the schedule of a medication in jurisdiction.", 0, Integer.MAX_VALUE, this.schedule);
                }
                case -1977784607: {
                    return new Property("maxDispense", "", "The maximum number of units of the medication that can be dispensed in a period.", 0, 1, this.maxDispense);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    Base[] baseArray;
                    if (this.regulatoryAuthority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regulatoryAuthority;
                    }
                    return baseArray;
                }
                case 826147581: {
                    return this.substitution == null ? new Base[]{} : this.substitution.toArray(new Base[this.substitution.size()]);
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1977784607: {
                    Base[] baseArray;
                    if (this.maxDispense == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.maxDispense;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    this.regulatoryAuthority = TypeConvertor.castToReference(value);
                    return value;
                }
                case 826147581: {
                    this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
                    return value;
                }
                case -697920873: {
                    this.getSchedule().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1977784607: {
                    this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = TypeConvertor.castToReference(value);
            } else if (name.equals("substitution")) {
                this.getSubstitution().add((MedicationKnowledgeRegulatorySubstitutionComponent)value);
            } else if (name.equals("schedule")) {
                this.getSchedule().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("maxDispense")) {
                this.maxDispense = (MedicationKnowledgeRegulatoryMaxDispenseComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return this.getRegulatoryAuthority();
                }
                case 826147581: {
                    return this.addSubstitution();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1977784607: {
                    return this.getMaxDispense();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 711233419: {
                    return new String[]{"Reference"};
                }
                case 826147581: {
                    return new String[0];
                }
                case -697920873: {
                    return new String[]{"CodeableConcept"};
                }
                case -1977784607: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regulatoryAuthority")) {
                this.regulatoryAuthority = new Reference();
                return this.regulatoryAuthority;
            }
            if (name.equals("substitution")) {
                return this.addSubstitution();
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("maxDispense")) {
                this.maxDispense = new MedicationKnowledgeRegulatoryMaxDispenseComponent();
                return this.maxDispense;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRegulatoryComponent copy() {
            MedicationKnowledgeRegulatoryComponent dst = new MedicationKnowledgeRegulatoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRegulatoryComponent dst) {
            super.copyValues(dst);
            Reference reference = dst.regulatoryAuthority = this.regulatoryAuthority == null ? null : this.regulatoryAuthority.copy();
            if (this.substitution != null) {
                dst.substitution = new ArrayList<MedicationKnowledgeRegulatorySubstitutionComponent>();
                for (MedicationKnowledgeRegulatorySubstitutionComponent medicationKnowledgeRegulatorySubstitutionComponent : this.substitution) {
                    dst.substitution.add(medicationKnowledgeRegulatorySubstitutionComponent.copy());
                }
            }
            if (this.schedule != null) {
                dst.schedule = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.schedule) {
                    dst.schedule.add(codeableConcept.copy());
                }
            }
            dst.maxDispense = this.maxDispense == null ? null : this.maxDispense.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return MedicationKnowledgeRegulatoryComponent.compareDeep(this.regulatoryAuthority, o.regulatoryAuthority, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.substitution, o.substitution, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.schedule, o.schedule, true) && MedicationKnowledgeRegulatoryComponent.compareDeep(this.maxDispense, o.maxDispense, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRegulatoryComponent)) {
                return false;
            }
            MedicationKnowledgeRegulatoryComponent o = (MedicationKnowledgeRegulatoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regulatoryAuthority, this.substitution, this.schedule, this.maxDispense});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.regulatory";
        }
    }

    @Block
    public static class MedicationKnowledgePackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="cost", type={MedicationKnowledgeCostComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Cost of the packaged medication", formalDefinition="The cost of the packaged medication.")
        protected List<MedicationKnowledgeCostComponent> cost;
        @Child(name="packagedProduct", type={PackagedProductDefinition.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The packaged medication that is being priced", formalDefinition="A reference to a PackagedProductDefinition that provides the details of the product that is in the packaging and is being priced.")
        protected Reference packagedProduct;
        private static final long serialVersionUID = -337249398L;

        public List<MedicationKnowledgeCostComponent> getCost() {
            if (this.cost == null) {
                this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            }
            return this.cost;
        }

        public MedicationKnowledgePackagingComponent setCost(List<MedicationKnowledgeCostComponent> theCost) {
            this.cost = theCost;
            return this;
        }

        public boolean hasCost() {
            if (this.cost == null) {
                return false;
            }
            for (MedicationKnowledgeCostComponent item : this.cost) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeCostComponent addCost() {
            MedicationKnowledgeCostComponent t = new MedicationKnowledgeCostComponent();
            if (this.cost == null) {
                this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            }
            this.cost.add(t);
            return t;
        }

        public MedicationKnowledgePackagingComponent addCost(MedicationKnowledgeCostComponent t) {
            if (t == null) {
                return this;
            }
            if (this.cost == null) {
                this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            }
            this.cost.add(t);
            return this;
        }

        public MedicationKnowledgeCostComponent getCostFirstRep() {
            if (this.getCost().isEmpty()) {
                this.addCost();
            }
            return this.getCost().get(0);
        }

        public Reference getPackagedProduct() {
            if (this.packagedProduct == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.packagedProduct");
                }
                if (Configuration.doAutoCreate()) {
                    this.packagedProduct = new Reference();
                }
            }
            return this.packagedProduct;
        }

        public boolean hasPackagedProduct() {
            return this.packagedProduct != null && !this.packagedProduct.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setPackagedProduct(Reference value) {
            this.packagedProduct = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("cost", "@MedicationKnowledge.cost", "The cost of the packaged medication.", 0, Integer.MAX_VALUE, this.cost));
            children.add(new Property("packagedProduct", "Reference(PackagedProductDefinition)", "A reference to a PackagedProductDefinition that provides the details of the product that is in the packaging and is being priced.", 0, 1, this.packagedProduct));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059661: {
                    return new Property("cost", "@MedicationKnowledge.cost", "The cost of the packaged medication.", 0, Integer.MAX_VALUE, this.cost);
                }
                case 1893956145: {
                    return new Property("packagedProduct", "Reference(PackagedProductDefinition)", "A reference to a PackagedProductDefinition that provides the details of the product that is in the packaging and is being priced.", 0, 1, this.packagedProduct);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059661: {
                    return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
                }
                case 1893956145: {
                    Base[] baseArray;
                    if (this.packagedProduct == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.packagedProduct;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059661: {
                    this.getCost().add((MedicationKnowledgeCostComponent)value);
                    return value;
                }
                case 1893956145: {
                    this.packagedProduct = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("cost")) {
                this.getCost().add((MedicationKnowledgeCostComponent)value);
            } else if (name.equals("packagedProduct")) {
                this.packagedProduct = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059661: {
                    return this.addCost();
                }
                case 1893956145: {
                    return this.getPackagedProduct();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059661: {
                    return new String[]{"@MedicationKnowledge.cost"};
                }
                case 1893956145: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("cost")) {
                return this.addCost();
            }
            if (name.equals("packagedProduct")) {
                this.packagedProduct = new Reference();
                return this.packagedProduct;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgePackagingComponent copy() {
            MedicationKnowledgePackagingComponent dst = new MedicationKnowledgePackagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgePackagingComponent dst) {
            super.copyValues(dst);
            if (this.cost != null) {
                dst.cost = new ArrayList<MedicationKnowledgeCostComponent>();
                for (MedicationKnowledgeCostComponent i : this.cost) {
                    dst.cost.add(i.copy());
                }
            }
            dst.packagedProduct = this.packagedProduct == null ? null : this.packagedProduct.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return MedicationKnowledgePackagingComponent.compareDeep(this.cost, o.cost, true) && MedicationKnowledgePackagingComponent.compareDeep(this.packagedProduct, o.packagedProduct, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.cost, this.packagedProduct});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.packaging";
        }
    }

    @Block
    public static class MedicationKnowledgeMedicineClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", formalDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).")
        protected CodeableConcept type;
        @Child(name="source", type={StringType.class, UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source of the classification", formalDefinition="Either a textual source of the classification or a reference to an online source.")
        protected DataType source;
        @Child(name="classification", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific category assigned to the medication", formalDefinition="Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).")
        protected List<CodeableConcept> classification;
        private static final long serialVersionUID = 1598220123L;

        public MedicationKnowledgeMedicineClassificationComponent() {
        }

        public MedicationKnowledgeMedicineClassificationComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMedicineClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMedicineClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getSource() {
            return this.source;
        }

        public StringType getSourceStringType() throws FHIRException {
            if (this.source == null) {
                this.source = new StringType();
            }
            if (!(this.source instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (StringType)this.source;
        }

        public boolean hasSourceStringType() {
            return this != null && this.source instanceof StringType;
        }

        public UriType getSourceUriType() throws FHIRException {
            if (this.source == null) {
                this.source = new UriType();
            }
            if (!(this.source instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (UriType)this.source;
        }

        public boolean hasSourceUriType() {
            return this != null && this.source instanceof UriType;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeMedicineClassificationComponent setSource(DataType value) {
            if (value != null && !(value instanceof StringType) && !(value instanceof UriType)) {
                throw new Error("Not the right type for MedicationKnowledge.medicineClassification.source[x]: " + value.fhirType());
            }
            this.source = value;
            return this;
        }

        public List<CodeableConcept> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            return this.classification;
        }

        public MedicationKnowledgeMedicineClassificationComponent setClassification(List<CodeableConcept> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CodeableConcept item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassification() {
            CodeableConcept t = new CodeableConcept();
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return t;
        }

        public MedicationKnowledgeMedicineClassificationComponent addClassification(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return this;
        }

        public CodeableConcept getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type));
            children.add(new Property("source[x]", "string|uri", "Either a textual source of the classification or a reference to an online source.", 0, 1, this.source));
            children.add(new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type);
                }
                case -1698413947: {
                    return new Property("source[x]", "string|uri", "Either a textual source of the classification or a reference to an online source.", 0, 1, this.source);
                }
                case -896505829: {
                    return new Property("source[x]", "string|uri", "Either a textual source of the classification or a reference to an online source.", 0, 1, this.source);
                }
                case 1327821836: {
                    return new Property("source[x]", "string", "Either a textual source of the classification or a reference to an online source.", 0, 1, this.source);
                }
                case -1698419887: {
                    return new Property("source[x]", "uri", "Either a textual source of the classification or a reference to an online source.", 0, 1, this.source);
                }
                case 382350310: {
                    return new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc.).", 0, Integer.MAX_VALUE, this.classification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToType(value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source[x]")) {
                this.source = TypeConvertor.castToType(value);
            } else if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1698413947: {
                    return this.getSource();
                }
                case -896505829: {
                    return this.getSource();
                }
                case 382350310: {
                    return this.addClassification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"string", "uri"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("sourceString")) {
                this.source = new StringType();
                return this.source;
            }
            if (name.equals("sourceUri")) {
                this.source = new UriType();
                return this.source;
            }
            if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                return this.addClassification();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMedicineClassificationComponent copy() {
            MedicationKnowledgeMedicineClassificationComponent dst = new MedicationKnowledgeMedicineClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMedicineClassificationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            DataType dataType = dst.source = this.source == null ? null : this.source.copy();
            if (this.classification != null) {
                dst.classification = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classification) {
                    dst.classification.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.source, o.source, true) && MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.classification, o.classification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.source, this.classification});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.medicineClassification";
        }
    }

    @Block
    public static class MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Categorization of specific characteristic that is relevant to the administration guideline", formalDefinition="The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific characteristic", formalDefinition="The specific characteristic (e.g. height, weight, gender, etc.).")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent() {
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof Range)) {
                throw new Error("Not the right type for MedicationKnowledge.indicationGuideline.dosingGuideline.patientCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|Range", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The categorization of the specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The specific characteristic (e.g. height, weight, gender, etc.).", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent copy() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent dst = new MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)other_;
            return MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.indicationGuideline.dosingGuideline.patientCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of dosage for a medication", formalDefinition="The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).")
        protected CodeableConcept type;
        @Child(name="dosage", type={Dosage.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<Dosage> dosage;
        private static final long serialVersionUID = 1578257961L;

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent() {
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent(CodeableConcept type, Dosage dosage) {
            this.setType(type);
            this.addDosage(dosage);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Dosage> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent setDosage(List<Dosage> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (Dosage item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Dosage addDosage() {
            Dosage t = new Dosage();
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent addDosage(Dosage t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return this;
        }

        public Dosage getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type));
            children.add(new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type or category of dosage for a given medication (for example, prophylaxis, maintenance, therapeutic, etc.).", 0, 1, this.type);
                }
                case -1326018889: {
                    return new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1326018889: {
                    this.getDosage().add(TypeConvertor.castToDosage(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dosage")) {
                this.getDosage().add(TypeConvertor.castToDosage(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1326018889: {
                    return this.addDosage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326018889: {
                    return new String[]{"Dosage"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent copy() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent dst = new MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.dosage != null) {
                dst.dosage = new ArrayList<Dosage>();
                for (Dosage i : this.dosage) {
                    dst.dosage.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)other_;
            return MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent.compareDeep(this.dosage, o.dosage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.dosage});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.indicationGuideline.dosingGuideline.dosage";
        }
    }

    @Block
    public static class MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="treatmentIntent", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Intention of the treatment", formalDefinition="The overall intention of the treatment, for example, prophylactic, supporative, curative, etc.")
        protected CodeableConcept treatmentIntent;
        @Child(name="dosage", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent> dosage;
        @Child(name="administrationTreatment", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of treatment the guideline applies to", formalDefinition="The type of the treatment that the guideline applies to, for example, long term therapy, first line treatment, etc.")
        protected CodeableConcept administrationTreatment;
        @Child(name="patientCharacteristic", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristics of the patient that are relevant to the administration guidelines", formalDefinition="Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).")
        protected List<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent> patientCharacteristic;
        private static final long serialVersionUID = 882198366L;

        public CodeableConcept getTreatmentIntent() {
            if (this.treatmentIntent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.treatmentIntent");
                }
                if (Configuration.doAutoCreate()) {
                    this.treatmentIntent = new CodeableConcept();
                }
            }
            return this.treatmentIntent;
        }

        public boolean hasTreatmentIntent() {
            return this.treatmentIntent != null && !this.treatmentIntent.isEmpty();
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent setTreatmentIntent(CodeableConcept value) {
            this.treatmentIntent = value;
            return this;
        }

        public List<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent setDosage(List<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent addDosage() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent t = new MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent();
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent addDosage(MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent>();
            }
            this.dosage.add(t);
            return this;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        public CodeableConcept getAdministrationTreatment() {
            if (this.administrationTreatment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.administrationTreatment");
                }
                if (Configuration.doAutoCreate()) {
                    this.administrationTreatment = new CodeableConcept();
                }
            }
            return this.administrationTreatment;
        }

        public boolean hasAdministrationTreatment() {
            return this.administrationTreatment != null && !this.administrationTreatment.isEmpty();
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent setAdministrationTreatment(CodeableConcept value) {
            this.administrationTreatment = value;
            return this;
        }

        public List<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent> getPatientCharacteristic() {
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent>();
            }
            return this.patientCharacteristic;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent setPatientCharacteristic(List<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent> thePatientCharacteristic) {
            this.patientCharacteristic = thePatientCharacteristic;
            return this;
        }

        public boolean hasPatientCharacteristic() {
            if (this.patientCharacteristic == null) {
                return false;
            }
            for (MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent item : this.patientCharacteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent addPatientCharacteristic() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent t = new MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent();
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent>();
            }
            this.patientCharacteristic.add(t);
            return t;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent addPatientCharacteristic(MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.patientCharacteristic == null) {
                this.patientCharacteristic = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent>();
            }
            this.patientCharacteristic.add(t);
            return this;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent getPatientCharacteristicFirstRep() {
            if (this.getPatientCharacteristic().isEmpty()) {
                this.addPatientCharacteristic();
            }
            return this.getPatientCharacteristic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("treatmentIntent", "CodeableConcept", "The overall intention of the treatment, for example, prophylactic, supporative, curative, etc.", 0, 1, this.treatmentIntent));
            children.add(new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
            children.add(new Property("administrationTreatment", "CodeableConcept", "The type of the treatment that the guideline applies to, for example, long term therapy, first line treatment, etc.", 0, 1, this.administrationTreatment));
            children.add(new Property("patientCharacteristic", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1744920884: {
                    return new Property("treatmentIntent", "CodeableConcept", "The overall intention of the treatment, for example, prophylactic, supporative, curative, etc.", 0, 1, this.treatmentIntent);
                }
                case -1326018889: {
                    return new Property("dosage", "", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
                case 1197121978: {
                    return new Property("administrationTreatment", "CodeableConcept", "The type of the treatment that the guideline applies to, for example, long term therapy, first line treatment, etc.", 0, 1, this.administrationTreatment);
                }
                case 1770130432: {
                    return new Property("patientCharacteristic", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight, gender, etc.).", 0, Integer.MAX_VALUE, this.patientCharacteristic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1744920884: {
                    Base[] baseArray;
                    if (this.treatmentIntent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.treatmentIntent;
                    }
                    return baseArray;
                }
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
                case 1197121978: {
                    Base[] baseArray;
                    if (this.administrationTreatment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.administrationTreatment;
                    }
                    return baseArray;
                }
                case 1770130432: {
                    return this.patientCharacteristic == null ? new Base[]{} : this.patientCharacteristic.toArray(new Base[this.patientCharacteristic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1744920884: {
                    this.treatmentIntent = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1326018889: {
                    this.getDosage().add((MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)value);
                    return value;
                }
                case 1197121978: {
                    this.administrationTreatment = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1770130432: {
                    this.getPatientCharacteristic().add((MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("treatmentIntent")) {
                this.treatmentIntent = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dosage")) {
                this.getDosage().add((MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent)value);
            } else if (name.equals("administrationTreatment")) {
                this.administrationTreatment = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("patientCharacteristic")) {
                this.getPatientCharacteristic().add((MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1744920884: {
                    return this.getTreatmentIntent();
                }
                case -1326018889: {
                    return this.addDosage();
                }
                case 1197121978: {
                    return this.getAdministrationTreatment();
                }
                case 1770130432: {
                    return this.addPatientCharacteristic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1744920884: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326018889: {
                    return new String[0];
                }
                case 1197121978: {
                    return new String[]{"CodeableConcept"};
                }
                case 1770130432: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("treatmentIntent")) {
                this.treatmentIntent = new CodeableConcept();
                return this.treatmentIntent;
            }
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            if (name.equals("administrationTreatment")) {
                this.administrationTreatment = new CodeableConcept();
                return this.administrationTreatment;
            }
            if (name.equals("patientCharacteristic")) {
                return this.addPatientCharacteristic();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent copy() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent dst = new MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.treatmentIntent = this.treatmentIntent == null ? null : this.treatmentIntent.copy();
            if (this.dosage != null) {
                dst.dosage = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent>();
                for (MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent medicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent : this.dosage) {
                    dst.dosage.add(medicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent.copy());
                }
            }
            CodeableConcept codeableConcept2 = dst.administrationTreatment = this.administrationTreatment == null ? null : this.administrationTreatment.copy();
            if (this.patientCharacteristic != null) {
                dst.patientCharacteristic = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent>();
                for (MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent medicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent : this.patientCharacteristic) {
                    dst.patientCharacteristic.add(medicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)other_;
            return MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.compareDeep(this.treatmentIntent, o.treatmentIntent, true) && MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.compareDeep(this.dosage, o.dosage, true) && MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.compareDeep(this.administrationTreatment, o.administrationTreatment, true) && MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent.compareDeep(this.patientCharacteristic, o.patientCharacteristic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent o = (MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.treatmentIntent, this.dosage, this.administrationTreatment, this.patientCharacteristic});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.indicationGuideline.dosingGuideline";
        }
    }

    @Block
    public static class MedicationKnowledgeIndicationGuidelineComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="indication", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Indication for use that applies to the specific administration guideline", formalDefinition="Indication or reason for use of the medication that applies to the specific administration guideline.")
        protected List<CodeableReference> indication;
        @Child(name="dosingGuideline", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Guidelines for dosage of the medication", formalDefinition="The guidelines for the dosage of the medication for the indication.")
        protected List<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent> dosingGuideline;
        private static final long serialVersionUID = 256409722L;

        public List<CodeableReference> getIndication() {
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            return this.indication;
        }

        public MedicationKnowledgeIndicationGuidelineComponent setIndication(List<CodeableReference> theIndication) {
            this.indication = theIndication;
            return this;
        }

        public boolean hasIndication() {
            if (this.indication == null) {
                return false;
            }
            for (CodeableReference item : this.indication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addIndication() {
            CodeableReference t = new CodeableReference();
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            this.indication.add(t);
            return t;
        }

        public MedicationKnowledgeIndicationGuidelineComponent addIndication(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            this.indication.add(t);
            return this;
        }

        public CodeableReference getIndicationFirstRep() {
            if (this.getIndication().isEmpty()) {
                this.addIndication();
            }
            return this.getIndication().get(0);
        }

        public List<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent> getDosingGuideline() {
            if (this.dosingGuideline == null) {
                this.dosingGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent>();
            }
            return this.dosingGuideline;
        }

        public MedicationKnowledgeIndicationGuidelineComponent setDosingGuideline(List<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent> theDosingGuideline) {
            this.dosingGuideline = theDosingGuideline;
            return this;
        }

        public boolean hasDosingGuideline() {
            if (this.dosingGuideline == null) {
                return false;
            }
            for (MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent item : this.dosingGuideline) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent addDosingGuideline() {
            MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent t = new MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent();
            if (this.dosingGuideline == null) {
                this.dosingGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent>();
            }
            this.dosingGuideline.add(t);
            return t;
        }

        public MedicationKnowledgeIndicationGuidelineComponent addDosingGuideline(MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dosingGuideline == null) {
                this.dosingGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent>();
            }
            this.dosingGuideline.add(t);
            return this;
        }

        public MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent getDosingGuidelineFirstRep() {
            if (this.getDosingGuideline().isEmpty()) {
                this.addDosingGuideline();
            }
            return this.getDosingGuideline().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("indication", "CodeableReference(ClinicalUseDefinition)", "Indication or reason for use of the medication that applies to the specific administration guideline.", 0, Integer.MAX_VALUE, this.indication));
            children.add(new Property("dosingGuideline", "", "The guidelines for the dosage of the medication for the indication.", 0, Integer.MAX_VALUE, this.dosingGuideline));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -597168804: {
                    return new Property("indication", "CodeableReference(ClinicalUseDefinition)", "Indication or reason for use of the medication that applies to the specific administration guideline.", 0, Integer.MAX_VALUE, this.indication);
                }
                case -1792856970: {
                    return new Property("dosingGuideline", "", "The guidelines for the dosage of the medication for the indication.", 0, Integer.MAX_VALUE, this.dosingGuideline);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -597168804: {
                    return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
                }
                case -1792856970: {
                    return this.dosingGuideline == null ? new Base[]{} : this.dosingGuideline.toArray(new Base[this.dosingGuideline.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -597168804: {
                    this.getIndication().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1792856970: {
                    this.getDosingGuideline().add((MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("indication")) {
                this.getIndication().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("dosingGuideline")) {
                this.getDosingGuideline().add((MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -597168804: {
                    return this.addIndication();
                }
                case -1792856970: {
                    return this.addDosingGuideline();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -597168804: {
                    return new String[]{"CodeableReference"};
                }
                case -1792856970: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("indication")) {
                return this.addIndication();
            }
            if (name.equals("dosingGuideline")) {
                return this.addDosingGuideline();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIndicationGuidelineComponent copy() {
            MedicationKnowledgeIndicationGuidelineComponent dst = new MedicationKnowledgeIndicationGuidelineComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeIndicationGuidelineComponent dst) {
            super.copyValues(dst);
            if (this.indication != null) {
                dst.indication = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.indication) {
                    dst.indication.add(codeableReference.copy());
                }
            }
            if (this.dosingGuideline != null) {
                dst.dosingGuideline = new ArrayList<MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent>();
                for (MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent medicationKnowledgeIndicationGuidelineDosingGuidelineComponent : this.dosingGuideline) {
                    dst.dosingGuideline.add(medicationKnowledgeIndicationGuidelineDosingGuidelineComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineComponent o = (MedicationKnowledgeIndicationGuidelineComponent)other_;
            return MedicationKnowledgeIndicationGuidelineComponent.compareDeep(this.indication, o.indication, true) && MedicationKnowledgeIndicationGuidelineComponent.compareDeep(this.dosingGuideline, o.dosingGuideline, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIndicationGuidelineComponent)) {
                return false;
            }
            MedicationKnowledgeIndicationGuidelineComponent o = (MedicationKnowledgeIndicationGuidelineComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.indication, this.dosingGuideline});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.indicationGuideline";
        }
    }

    @Block
    public static class MedicationKnowledgeMonitoringProgramComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of program under which the medication is monitored", formalDefinition="Type of program under which the medication is monitored.")
        protected CodeableConcept type;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the reviewing program", formalDefinition="Name of the reviewing program.")
        protected StringType name;
        private static final long serialVersionUID = -280346281L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MedicationKnowledgeMonitoringProgramComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type));
            children.add(new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.monitoringProgram.name");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonitoringProgramComponent copy() {
            MedicationKnowledgeMonitoringProgramComponent dst = new MedicationKnowledgeMonitoringProgramComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonitoringProgramComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monitoringProgram";
        }
    }

    @Block
    public static class MedicationKnowledgeCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="effectiveDate", type={Period.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The date range for which the cost is effective", formalDefinition="The date range for which the cost information of the medication is effective.")
        protected List<Period> effectiveDate;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of the cost information", formalDefinition="The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.")
        protected CodeableConcept type;
        @Child(name="source", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source or owner for the price information", formalDefinition="The source or owner that assigns the price to the medication.")
        protected StringType source;
        @Child(name="cost", type={Money.class, CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The price or category of the cost of the medication", formalDefinition="The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-cost-category")
        protected DataType cost;
        private static final long serialVersionUID = 747402134L;

        public MedicationKnowledgeCostComponent() {
        }

        public MedicationKnowledgeCostComponent(CodeableConcept type, DataType cost) {
            this.setType(type);
            this.setCost(cost);
        }

        public List<Period> getEffectiveDate() {
            if (this.effectiveDate == null) {
                this.effectiveDate = new ArrayList<Period>();
            }
            return this.effectiveDate;
        }

        public MedicationKnowledgeCostComponent setEffectiveDate(List<Period> theEffectiveDate) {
            this.effectiveDate = theEffectiveDate;
            return this;
        }

        public boolean hasEffectiveDate() {
            if (this.effectiveDate == null) {
                return false;
            }
            for (Period item : this.effectiveDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Period addEffectiveDate() {
            Period t = new Period();
            if (this.effectiveDate == null) {
                this.effectiveDate = new ArrayList<Period>();
            }
            this.effectiveDate.add(t);
            return t;
        }

        public MedicationKnowledgeCostComponent addEffectiveDate(Period t) {
            if (t == null) {
                return this;
            }
            if (this.effectiveDate == null) {
                this.effectiveDate = new ArrayList<Period>();
            }
            this.effectiveDate.add(t);
            return this;
        }

        public Period getEffectiveDateFirstRep() {
            if (this.getEffectiveDate().isEmpty()) {
                this.addEffectiveDate();
            }
            return this.getEffectiveDate().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeCostComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeCostComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public MedicationKnowledgeCostComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new StringType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public DataType getCost() {
            return this.cost;
        }

        public Money getCostMoney() throws FHIRException {
            if (this.cost == null) {
                this.cost = new Money();
            }
            if (!(this.cost instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.cost.getClass().getName() + " was encountered");
            }
            return (Money)this.cost;
        }

        public boolean hasCostMoney() {
            return this != null && this.cost instanceof Money;
        }

        public CodeableConcept getCostCodeableConcept() throws FHIRException {
            if (this.cost == null) {
                this.cost = new CodeableConcept();
            }
            if (!(this.cost instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.cost.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.cost;
        }

        public boolean hasCostCodeableConcept() {
            return this != null && this.cost instanceof CodeableConcept;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public MedicationKnowledgeCostComponent setCost(DataType value) {
            if (value != null && !(value instanceof Money) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for MedicationKnowledge.cost.cost[x]: " + value.fhirType());
            }
            this.cost = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("effectiveDate", "Period", "The date range for which the cost information of the medication is effective.", 0, Integer.MAX_VALUE, this.effectiveDate));
            children.add(new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type));
            children.add(new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source));
            children.add(new Property("cost[x]", "Money|CodeableConcept", "The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.", 0, 1, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -930389515: {
                    return new Property("effectiveDate", "Period", "The date range for which the cost information of the medication is effective.", 0, Integer.MAX_VALUE, this.effectiveDate);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source);
                }
                case 956138899: {
                    return new Property("cost[x]", "Money|CodeableConcept", "The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.", 0, 1, this.cost);
                }
                case 3059661: {
                    return new Property("cost[x]", "Money|CodeableConcept", "The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.", 0, 1, this.cost);
                }
                case -286697229: {
                    return new Property("cost[x]", "Money", "The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.", 0, 1, this.cost);
                }
                case -238369772: {
                    return new Property("cost[x]", "CodeableConcept", "The price or representation of the cost (for example, Band A, Band B or $, $$) of the medication.", 0, 1, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -930389515: {
                    return this.effectiveDate == null ? new Base[]{} : this.effectiveDate.toArray(new Base[this.effectiveDate.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -930389515: {
                    this.getEffectiveDate().add(TypeConvertor.castToPeriod(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToString(value);
                    return value;
                }
                case 3059661: {
                    this.cost = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("effectiveDate")) {
                this.getEffectiveDate().add(TypeConvertor.castToPeriod(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToString(value);
            } else if (name.equals("cost[x]")) {
                this.cost = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -930389515: {
                    return this.addEffectiveDate();
                }
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 956138899: {
                    return this.getCost();
                }
                case 3059661: {
                    return this.getCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -930389515: {
                    return new String[]{"Period"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 3059661: {
                    return new String[]{"Money", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("effectiveDate")) {
                return this.addEffectiveDate();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.cost.source");
            }
            if (name.equals("costMoney")) {
                this.cost = new Money();
                return this.cost;
            }
            if (name.equals("costCodeableConcept")) {
                this.cost = new CodeableConcept();
                return this.cost;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeCostComponent copy() {
            MedicationKnowledgeCostComponent dst = new MedicationKnowledgeCostComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeCostComponent dst) {
            super.copyValues(dst);
            if (this.effectiveDate != null) {
                dst.effectiveDate = new ArrayList<Period>();
                for (Period i : this.effectiveDate) {
                    dst.effectiveDate.add(i.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareDeep(this.effectiveDate, o.effectiveDate, true) && MedicationKnowledgeCostComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeCostComponent.compareDeep(this.source, o.source, true) && MedicationKnowledgeCostComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareValues(this.source, o.source, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.effectiveDate, this.type, this.source, this.cost});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.cost";
        }
    }

    @Block
    public static class MedicationKnowledgeMonographComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of medication document", formalDefinition="The category of documentation about the medication. (e.g. professional monograph, patient education monograph).")
        protected CodeableConcept type;
        @Child(name="source", type={DocumentReference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
        protected Reference source;
        private static final long serialVersionUID = -197893751L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Reference();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setSource(Reference value) {
            this.source = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type));
            children.add(new Property("source", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient education monograph).", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -896505829: {
                    return this.getSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("source")) {
                this.source = new Reference();
                return this.source;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonographComponent copy() {
            MedicationKnowledgeMonographComponent dst = new MedicationKnowledgeMonographComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeMonographComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return MedicationKnowledgeMonographComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonographComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monograph";
        }
    }

    @Block
    public static class MedicationKnowledgeRelatedMedicationKnowledgeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of medicationKnowledge", formalDefinition="The category of the associated medication knowledge reference.")
        protected CodeableConcept type;
        @Child(name="reference", type={MedicationKnowledge.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the associated medication knowledge", formalDefinition="Associated documentation about the associated medication knowledge.")
        protected List<Reference> reference;
        private static final long serialVersionUID = 1687147899L;

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent() {
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent(CodeableConcept type, Reference reference) {
            this.setType(type);
            this.addReference(reference);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeRelatedMedicationKnowledgeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Reference> getReference() {
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            return this.reference;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent setReference(List<Reference> theReference) {
            this.reference = theReference;
            return this;
        }

        public boolean hasReference() {
            if (this.reference == null) {
                return false;
            }
            for (Reference item : this.reference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReference() {
            Reference t = new Reference();
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return t;
        }

        public MedicationKnowledgeRelatedMedicationKnowledgeComponent addReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reference == null) {
                this.reference = new ArrayList<Reference>();
            }
            this.reference.add(t);
            return this;
        }

        public Reference getReferenceFirstRep() {
            if (this.getReference().isEmpty()) {
                this.addReference();
            }
            return this.getReference().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type));
            children.add(new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of the associated medication knowledge reference.", 0, 1, this.type);
                }
                case -925155509: {
                    return new Property("reference", "Reference(MedicationKnowledge)", "Associated documentation about the associated medication knowledge.", 0, Integer.MAX_VALUE, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -925155509: {
                    return this.reference == null ? new Base[]{} : this.reference.toArray(new Base[this.reference.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.getReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.getReference().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -925155509: {
                    return this.addReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reference")) {
                return this.addReference();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeRelatedMedicationKnowledgeComponent copy() {
            MedicationKnowledgeRelatedMedicationKnowledgeComponent dst = new MedicationKnowledgeRelatedMedicationKnowledgeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicationKnowledgeRelatedMedicationKnowledgeComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.reference != null) {
                dst.reference = new ArrayList<Reference>();
                for (Reference i : this.reference) {
                    dst.reference.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeRelatedMedicationKnowledgeComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeRelatedMedicationKnowledgeComponent)) {
                return false;
            }
            MedicationKnowledgeRelatedMedicationKnowledgeComponent o = (MedicationKnowledgeRelatedMedicationKnowledgeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.reference});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.relatedMedicationKnowledge";
        }
    }

    public static class MedicationKnowledgeStatusCodesEnumFactory
    implements EnumFactory<MedicationKnowledgeStatusCodes> {
        @Override
        public MedicationKnowledgeStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.ENTEREDINERROR;
            }
            if ("inactive".equals(codeString)) {
                return MedicationKnowledgeStatusCodes.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public Enumeration<MedicationKnowledgeStatusCodes> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.ENTEREDINERROR);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatusCodes>(this, MedicationKnowledgeStatusCodes.INACTIVE);
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationKnowledgeStatusCodes code) {
            if (code == MedicationKnowledgeStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == MedicationKnowledgeStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationKnowledgeStatusCodes.INACTIVE) {
                return "inactive";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationKnowledgeStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum MedicationKnowledgeStatusCodes {
        ACTIVE,
        ENTEREDINERROR,
        INACTIVE,
        NULL;


        public static MedicationKnowledgeStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INACTIVE: {
                    return "inactive";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/medicationknowledge-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/CodeSystem/medicationknowledge-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/CodeSystem/medicationknowledge-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication referred to by this MedicationKnowledge is in active use within the drug database or inventory system.";
                }
                case ENTEREDINERROR: {
                    return "The medication referred to by this MedicationKnowledge was entered in error within the drug database or inventory system.";
                }
                case INACTIVE: {
                    return "The medication referred to by this MedicationKnowledge is not in active use within the drug database or inventory system.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INACTIVE: {
                    return "Inactive";
                }
            }
            return "?";
        }
    }
}

