/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;

public class Resolver {

    public static class ResourceWithReference {
        private String reference;
        private BaseWrappers.ResourceWrapper resource;

        public ResourceWithReference(String reference, BaseWrappers.ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public BaseWrappers.ResourceWrapper getResource() {
            return this.resource;
        }
    }

    public static class ResourceContext {
        private ResourceContextType type;
        private Resource containerResource;
        private Element containerElement;
        DomainResource resourceResource;
        Element resourceElement;

        public ResourceContext(ResourceContextType type, Resource bundle, DomainResource dr) {
            this.type = type;
            this.containerResource = bundle;
            this.resourceResource = dr;
        }

        public ResourceContext(ResourceContextType type, Element bundle, Element dr) {
            this.type = type;
            this.containerElement = bundle;
            this.resourceElement = dr;
        }

        public DomainResource getResourceResource() {
            return this.resourceResource;
        }

        public Element getResourceElement() {
            return this.resourceElement;
        }

        public Bundle.BundleEntryComponent resolve(String value) {
            if (value.startsWith("#")) {
                if (this.resourceResource != null) {
                    for (Resource r : this.resourceResource.getContained()) {
                        if (!r.getId().equals(value.substring(1))) continue;
                        Bundle.BundleEntryComponent be = new Bundle.BundleEntryComponent();
                        be.setResource(r);
                        return be;
                    }
                }
                return null;
            }
            if (this.type == ResourceContextType.BUNDLE && this.containerResource != null) {
                for (Bundle.BundleEntryComponent be : ((Bundle)this.containerResource).getEntry()) {
                    if (be.getFullUrl().equals(value)) {
                        return be;
                    }
                    if (!value.equals(be.getResource().fhirType() + "/" + be.getResource().getId())) continue;
                    return be;
                }
            }
            if (this.type == ResourceContextType.PARAMETERS && this.containerResource != null) {
                for (Parameters.ParametersParameterComponent p : ((Parameters)this.containerResource).getParameter()) {
                    if (p.getResource() == null || !value.equals(p.getResource().fhirType() + "/" + p.getResource().getId())) continue;
                    Bundle.BundleEntryComponent be = new Bundle.BundleEntryComponent();
                    be.setResource(p.getResource());
                    return be;
                }
            }
            return null;
        }

        public Element resolveElement(String value, String version) {
            Element res;
            if (value.startsWith("#")) {
                if (this.resourceElement != null) {
                    for (Element r : this.resourceElement.getChildrenByName("contained")) {
                        if (!r.getChildValue("id").equals(value.substring(1))) continue;
                        return r;
                    }
                }
                return null;
            }
            if (this.type == ResourceContextType.BUNDLE && this.containerElement != null) {
                for (Element be : this.containerElement.getChildren("entry")) {
                    res = be.getNamedChild("resource");
                    if (res == null) continue;
                    if (value.equals(be.getChildValue("fullUrl")) && this.checkVersion(version, res)) {
                        return be;
                    }
                    if (!value.equals(res.fhirType() + "/" + res.getChildValue("id")) || !this.checkVersion(version, res)) continue;
                    return be;
                }
            }
            if (this.type == ResourceContextType.PARAMETERS && this.containerElement != null) {
                for (Element p : this.containerElement.getChildren("parameter")) {
                    res = p.getNamedChild("resource");
                    if (res == null || !value.equals(res.fhirType() + "/" + res.getChildValue("id")) || !this.checkVersion(version, res)) continue;
                    return p;
                }
            }
            return null;
        }

        private boolean checkVersion(String version, Element res) {
            if (version == null) {
                return true;
            }
            if (!res.hasChild("meta")) {
                return false;
            }
            Element meta = res.getNamedChild("meta");
            return version.equals(meta.getChildValue("version"));
        }
    }

    public static interface IReferenceResolver {
        public ResourceWithReference resolve(RenderingContext var1, String var2);
    }

    public static enum ResourceContextType {
        PARAMETERS,
        BUNDLE;

    }
}

