/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.List;
import java.util.Locale;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.utils.JurisdictionLocales;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ResourceUtilities {
    public static final String FHIR_LANGUAGE = "urn:ietf:bcp:47";
    private static JurisdictionLocales jl = new JurisdictionLocales();

    public static boolean isAnError(OperationOutcome error) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : error.getIssue()) {
            if (t.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                return true;
            }
            if (t.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            return true;
        }
        return false;
    }

    public static String getErrorDescription(OperationOutcome error) {
        if (error.hasText() && error.getText().hasDiv()) {
            return new XhtmlComposer(true).composePlainText(error.getText().getDiv());
        }
        StringBuilder b = new StringBuilder();
        for (OperationOutcome.OperationOutcomeIssueComponent t : error.getIssue()) {
            if (t.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                b.append("Error:" + t.getDetails() + "\r\n");
                continue;
            }
            if (t.getSeverity() == OperationOutcome.IssueSeverity.FATAL) {
                b.append("Fatal:" + t.getDetails() + "\r\n");
                continue;
            }
            if (t.getSeverity() == OperationOutcome.IssueSeverity.WARNING) {
                b.append("Warning:" + t.getDetails() + "\r\n");
                continue;
            }
            if (t.getSeverity() != OperationOutcome.IssueSeverity.INFORMATION) continue;
            b.append("Information:" + t.getDetails() + "\r\n");
        }
        return b.toString();
    }

    public static Resource getById(Bundle feed, ResourceType type, String reference) {
        for (Bundle.BundleEntryComponent item : feed.getEntry()) {
            if (!item.getResource().getId().equals(reference) || item.getResource().getResourceType() != type) continue;
            return item.getResource();
        }
        return null;
    }

    public static Bundle.BundleEntryComponent getEntryById(Bundle feed, ResourceType type, String reference) {
        for (Bundle.BundleEntryComponent item : feed.getEntry()) {
            if (!item.getResource().getId().equals(reference) || item.getResource().getResourceType() != type) continue;
            return item;
        }
        return null;
    }

    public static String getLink(Bundle feed, String rel) {
        for (Bundle.BundleLinkComponent link : feed.getLink()) {
            if (!link.getRelation().equals(rel)) continue;
            return link.getUrl();
        }
        return null;
    }

    public static Meta meta(Resource resource) {
        if (!resource.hasMeta()) {
            resource.setMeta(new Meta());
        }
        return resource.getMeta();
    }

    public static Locale getLocale(CanonicalResource cr) {
        return ResourceUtilities.getLocale(cr.getLanguage(), cr.getJurisdiction());
    }

    public static Locale getLocale(String lang, List<CodeableConcept> jurisdictions) {
        if (lang != null && lang.contains("-")) {
            return new Locale(lang);
        }
        for (CodeableConcept cc : jurisdictions) {
            Locale locale = ResourceUtilities.getLocale(lang, cc);
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    private static Locale getLocale(String lang, CodeableConcept cc) {
        if (cc.hasCoding("http://unstats.un.org/unsd/methods/m49/m49.htm", "001")) {
            return new Locale("en-US");
        }
        String c = cc.getCode("urn:iso:std:iso:3166");
        if (c == null) {
            return null;
        }
        String l = jl.get(c);
        if (l == null) {
            return null;
        }
        if (lang != null) {
            return new Locale(lang + "-" + l.substring(l.indexOf("-") + 1));
        }
        return new Locale(l);
    }
}

